// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 20;
// AUTOGENERATED END

const file = 'step_through_is_and_as_test.dart';

void code() {
  final i = 42.42; // LINE_A
  final hex = 0x42;
  if (i is int) {
    print('i is int');
    final int x = i as int;
    if (x.isEven) {
      print("it's even even!");
    } else {
      print("but it's not even even!");
    }
  }
  if (i is! int) {
    print('i is not int');
  }
  // ignore: unnecessary_type_check_true
  if (hex is int) {
    print('hex is int');
    final int x = hex as dynamic;
    if (x.isEven) {
      print("it's even even!");
    } else {
      print("but it's not even even!");
    }
  }
  // ignore: unnecessary_type_check_false
  if (hex is! int) {
    print('hex is not int');
  }
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:11', // on '='
  '$file:${LINE_A + 1}:13', // on '='
  '$file:${LINE_A + 2}:9', // on 'is'
  '$file:${LINE_A + 11}:9', // on 'is!'
  '$file:${LINE_A + 12}:5', // on call to 'print'
  '$file:${LINE_A + 15}:11', // in 'is'
  '$file:${LINE_A + 16}:5', // on call to 'print'
  '$file:${LINE_A + 17}:17', // on '='
  '$file:${LINE_A + 18}:11', // on 'isEven'
  '$file:${LINE_A + 19}:7', // on call to 'print'
  '$file:${LINE_A + 25}:11', // on 'is!'
  '$file:${LINE_A + 28}:1', // on ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepThroughProgramRecordingStops(stops),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_is_and_as_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
