/* Generated by wayland-scanner 1.20.0 */

#ifndef BUILD_TIME_WAYLAND_TESTS_SERVER_PROTOCOL_H
#define BUILD_TIME_WAYLAND_TESTS_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_build_time_wayland_tests The build_time_wayland_tests protocol
 * @section page_ifaces_build_time_wayland_tests Interfaces
 * - @subpage page_iface_fd_passer - Sends an event with an fd
 * @section page_copyright_build_time_wayland_tests Copyright
 * <pre>
 *
 * Copyright © 2017 Samsung Electronics Co., Ltd
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * </pre>
 */
struct fd_passer;

#ifndef FD_PASSER_INTERFACE
#define FD_PASSER_INTERFACE
/**
 * @page page_iface_fd_passer fd_passer
 * @section page_iface_fd_passer_desc Description
 *
 * A trivial interface for fd passing tests.
 * @section page_iface_fd_passer_api API
 * See @ref iface_fd_passer.
 */
/**
 * @defgroup iface_fd_passer The fd_passer interface
 *
 * A trivial interface for fd passing tests.
 */
extern const struct wl_interface fd_passer_interface;
#endif

/**
 * @ingroup iface_fd_passer
 * @struct fd_passer_interface
 */
struct fd_passer_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * register another fd passer with this one
	 *
	 * Tells this fd passer object about another one to send events
	 * to for more complicated fd leak tests.
	 * @since 2
	 */
	void (*conjoin)(struct wl_client *client,
			struct wl_resource *resource,
			struct wl_resource *passer);
};

#define FD_PASSER_PRE_FD 0
#define FD_PASSER_FD 1

/**
 * @ingroup iface_fd_passer
 */
#define FD_PASSER_PRE_FD_SINCE_VERSION 1
/**
 * @ingroup iface_fd_passer
 */
#define FD_PASSER_FD_SINCE_VERSION 1

/**
 * @ingroup iface_fd_passer
 */
#define FD_PASSER_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_fd_passer
 */
#define FD_PASSER_CONJOIN_SINCE_VERSION 2

/**
 * @ingroup iface_fd_passer
 * Sends an pre_fd event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
fd_passer_send_pre_fd(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, FD_PASSER_PRE_FD);
}

/**
 * @ingroup iface_fd_passer
 * Sends an fd event to the client owning the resource.
 * @param resource_ The client's resource
 * @param fd file descriptor
 */
static inline void
fd_passer_send_fd(struct wl_resource *resource_, int32_t fd)
{
	wl_resource_post_event(resource_, FD_PASSER_FD, fd);
}

#ifdef  __cplusplus
}
#endif

#endif
