/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _PERF_PERF_H
#include <stdbool.h>

#define _PERF_PERF_H

#include <stdbool.h>

#ifndef MAX_NR_CPUS
#define MAX_NR_CPUS			2048
#endif

extern const char *input_name;
extern bool perf_host, perf_guest;
extern const char perf_version_string[];

void pthread__unblock_sigwinch(void);

enum perf_affinity {
	PERF_AFFINITY_SYS = 0,
	PERF_AFFINITY_NODE,
	PERF_AFFINITY_CPU,
	PERF_AFFINITY_MAX
};

extern int version_verbose;
#endif
