
/* autogenerated from gstaudiopack.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union { orc_int16 i; orc_int8 x2[2]; } orc_union16;
typedef union { orc_int32 i; float f; orc_int16 x2[2]; orc_int8 x4[4]; } orc_union32;
typedef union { orc_int64 i; double f; orc_int32 x2[2]; float x2f[2]; orc_int16 x4[4]; } orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#elif defined(_MSC_VER)
#define ORC_RESTRICT __restrict
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void audio_orc_unpack_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u8_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s8_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u16_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s16_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u16_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u16_swap_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s16_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s16_swap_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u24_32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s24_32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u24_32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s24_32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_f32 (gdouble * ORC_RESTRICT d1, const gfloat * ORC_RESTRICT s1, int n);
void audio_orc_unpack_f32_swap (gdouble * ORC_RESTRICT d1, const gfloat * ORC_RESTRICT s1, int n);
void audio_orc_unpack_f64 (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_unpack_f64_swap (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_pack_u8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u16_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s16_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u24_32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s24_32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_f32 (gfloat * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_pack_f32_swap (gfloat * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_pack_f64 (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_pack_f64_swap (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_splat_u16 (guint16 * ORC_RESTRICT d1, int p1, int n);
void audio_orc_splat_u32 (guint32 * ORC_RESTRICT d1, int p1, int n);
void audio_orc_splat_u64 (guint64 * ORC_RESTRICT d1, int p1, int n);
void audio_orc_int_bias (gint32 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int p1, int p2, int n);
void audio_orc_int_dither (gint32 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, const gint32 * ORC_RESTRICT s2, int p1, int n);
void audio_orc_update_rand (guint32 * ORC_RESTRICT d1, int n);
void audio_orc_s32_to_double (gdouble * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_double_to_s32 (gint32 * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX (orc_uint8) 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX (orc_uint16)65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xffU)<<8) | (((x)&0xff00U)>>8))
#define ORC_SWAP_L(x) ((((x)&0xffU)<<24) | (((x)&0xff00U)<<8) | (((x)&0xff0000U)>>8) | (((x)&0xff000000U)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#elif defined(_MSC_VER)
#define ORC_RESTRICT __restrict
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* audio_orc_unpack_u8 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 2: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: splatbl */
    var36.i = ((((orc_uint32)var33)&0xff) << 24) | ((((orc_uint32)var33)&0xff)<<16) | ((((orc_uint32)var33)&0xff) << 8) | (((orc_uint32)var33)&0xff);
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 2: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: splatbl */
    var36.i = ((((orc_uint32)var33)&0xff) << 24) | ((((orc_uint32)var33)&0xff)<<16) | ((((orc_uint32)var33)&0xff) << 8) | (((orc_uint32)var33)&0xff);
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 56, 11, 4, 4, 12, 1, 1, 14, 4, 0, 0, 
      0, 128, 20, 4, 152, 32, 4, 132, 0, 32, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u8);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u8");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u8);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u8_trunc */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u8_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 3: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: splatbl */
    var36.i = ((((orc_uint32)var33)&0xff) << 24) | ((((orc_uint32)var33)&0xff)<<16) | ((((orc_uint32)var33)&0xff) << 8) | (((orc_uint32)var33)&0xff);
    /* 2: shll */
    var37.i = ((orc_uint32)var36.i) << 24;
    /* 4: xorl */
    var35.i = var37.i ^ var34.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u8_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 3: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: splatbl */
    var36.i = ((((orc_uint32)var33)&0xff) << 24) | ((((orc_uint32)var33)&0xff)<<16) | ((((orc_uint32)var33)&0xff) << 8) | (((orc_uint32)var33)&0xff);
    /* 2: shll */
    var37.i = ((orc_uint32)var36.i) << 24;
    /* 4: xorl */
    var35.i = var37.i ^ var34.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u8_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 56, 95, 116, 114, 117, 110, 99, 11, 4, 4, 12, 
      1, 1, 14, 4, 0, 0, 0, 128, 14, 4, 24, 0, 0, 0, 20, 4, 
      152, 32, 4, 124, 32, 32, 17, 132, 0, 32, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u8_trunc);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u8_trunc");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u8_trunc);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_constant (p, 4, 0x00000018, "c2");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s8 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 2: loadpl */
    var35.i = 0x00808080; /* 8421504 or 4.16078e-317f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: splatbl */
    var37.i = ((((orc_uint32)var34)&0xff) << 24) | ((((orc_uint32)var34)&0xff)<<16) | ((((orc_uint32)var34)&0xff) << 8) | (((orc_uint32)var34)&0xff);
    /* 3: xorl */
    var36.i = var37.i ^ var35.i;
    /* 4: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_unpack_s8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 2: loadpl */
    var35.i = 0x00808080; /* 8421504 or 4.16078e-317f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: splatbl */
    var37.i = ((((orc_uint32)var34)&0xff) << 24) | ((((orc_uint32)var34)&0xff)<<16) | ((((orc_uint32)var34)&0xff) << 8) | (((orc_uint32)var34)&0xff);
    /* 3: xorl */
    var36.i = var37.i ^ var35.i;
    /* 4: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_unpack_s8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 56, 11, 4, 4, 12, 1, 1, 14, 4, 128, 128, 
      128, 0, 20, 2, 20, 4, 152, 33, 4, 132, 0, 33, 16, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s8);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s8");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s8);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_constant (p, 4, 0x00808080, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s8_trunc */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s8_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: splatbl */
    var35.i = ((((orc_uint32)var33)&0xff) << 24) | ((((orc_uint32)var33)&0xff)<<16) | ((((orc_uint32)var33)&0xff) << 8) | (((orc_uint32)var33)&0xff);
    /* 2: shll */
    var34.i = ((orc_uint32)var35.i) << 24;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_s8_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: splatbl */
    var35.i = ((((orc_uint32)var33)&0xff) << 24) | ((((orc_uint32)var33)&0xff)<<16) | ((((orc_uint32)var33)&0xff) << 8) | (((orc_uint32)var33)&0xff);
    /* 2: shll */
    var34.i = ((orc_uint32)var35.i) << 24;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_s8_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 56, 95, 116, 114, 117, 110, 99, 11, 4, 4, 12, 
      1, 1, 14, 4, 24, 0, 0, 0, 20, 4, 152, 32, 4, 124, 0, 32, 
      16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s8_trunc);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s8_trunc");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s8_trunc);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_constant (p, 4, 0x00000018, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u16 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var33.i;
       _dest.x2[1] = var34.i;
       var37.i = _dest.i;
    }
    /* 4: xorl */
    var36.i = var37.i ^ var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_unpack_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var33.i;
       _dest.x2[1] = var34.i;
       var37.i = _dest.i;
    }
    /* 4: xorl */
    var36.i = var37.i ^ var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_unpack_u16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 20, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 49, 54, 11, 4, 4, 12, 2, 2, 14, 4, 0, 
      0, 0, 128, 20, 4, 195, 32, 4, 4, 132, 0, 32, 16, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u16");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u16_trunc */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u16_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 4: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var33.i;
       _dest.x2[1] = var34.i;
       var37.i = _dest.i;
    }
    /* 3: shll */
    var38.i = ((orc_uint32)var37.i) << 16;
    /* 5: xorl */
    var36.i = var38.i ^ var35.i;
    /* 6: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_unpack_u16_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 4: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var33.i;
       _dest.x2[1] = var34.i;
       var37.i = _dest.i;
    }
    /* 3: shll */
    var38.i = ((orc_uint32)var37.i) << 16;
    /* 5: xorl */
    var36.i = var38.i ^ var35.i;
    /* 6: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_unpack_u16_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 49, 54, 95, 116, 114, 117, 110, 99, 11, 4, 4, 
      12, 2, 2, 14, 4, 16, 0, 0, 0, 14, 4, 0, 0, 0, 128, 20, 
      4, 195, 32, 4, 4, 124, 32, 32, 16, 132, 0, 32, 17, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16_trunc);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u16_trunc");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16_trunc);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_constant (p, 4, 0x00000010, "c1");
    orc_program_add_constant (p, 4, 0x80000000, "c2");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s16 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpl */
    var35.i = 0x00008000; /* 32768 or 1.61895e-319f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var33.i;
       _dest.x2[1] = var34.i;
       var37.i = _dest.i;
    }
    /* 4: xorl */
    var36.i = var37.i ^ var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_unpack_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpl */
    var35.i = 0x00008000; /* 32768 or 1.61895e-319f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var33.i;
       _dest.x2[1] = var34.i;
       var37.i = _dest.i;
    }
    /* 4: xorl */
    var36.i = var37.i ^ var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_unpack_s16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 20, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 49, 54, 11, 4, 4, 12, 2, 2, 14, 4, 0, 
      128, 0, 0, 20, 4, 195, 32, 4, 4, 132, 0, 32, 16, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s16");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_constant (p, 4, 0x00008000, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s16_trunc */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s16_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convuwl */
    var35.i = (orc_uint16)var33.i;
    /* 2: shll */
    var34.i = ((orc_uint32)var35.i) << 16;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_s16_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convuwl */
    var35.i = (orc_uint16)var33.i;
    /* 2: shll */
    var34.i = ((orc_uint32)var35.i) << 16;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_s16_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 49, 54, 95, 116, 114, 117, 110, 99, 11, 4, 4, 
      12, 2, 2, 14, 4, 16, 0, 0, 0, 20, 4, 154, 32, 4, 124, 0, 
      32, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16_trunc);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s16_trunc");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16_trunc);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_constant (p, 4, 0x00000010, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u16_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u16_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var37.i = ORC_SWAP_W(var34.i);
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var37.i;
       _dest.x2[1] = var37.i;
       var38.i = _dest.i;
    }
    /* 4: xorl */
    var36.i = var38.i ^ var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_unpack_u16_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var37.i = ORC_SWAP_W(var34.i);
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var37.i;
       _dest.x2[1] = var37.i;
       var38.i = _dest.i;
    }
    /* 4: xorl */
    var36.i = var38.i ^ var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_unpack_u16_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 49, 54, 95, 115, 119, 97, 112, 11, 4, 4, 12, 
      2, 2, 14, 4, 0, 0, 0, 128, 20, 2, 20, 4, 183, 32, 4, 195, 
      33, 32, 32, 132, 0, 33, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u16_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u16_swap_trunc */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u16_swap_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 4: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var37.i = ORC_SWAP_W(var34.i);
    /* 2: convuwl */
    var38.i = (orc_uint16)var37.i;
    /* 3: shll */
    var39.i = ((orc_uint32)var38.i) << 16;
    /* 5: xorl */
    var36.i = var39.i ^ var35.i;
    /* 6: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_unpack_u16_swap_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 4: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var37.i = ORC_SWAP_W(var34.i);
    /* 2: convuwl */
    var38.i = (orc_uint16)var37.i;
    /* 3: shll */
    var39.i = ((orc_uint32)var38.i) << 16;
    /* 5: xorl */
    var36.i = var39.i ^ var35.i;
    /* 6: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_unpack_u16_swap_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 49, 54, 95, 115, 119, 97, 112, 95, 116, 114, 117, 
      110, 99, 11, 4, 4, 12, 2, 2, 14, 4, 16, 0, 0, 0, 14, 4, 
      0, 0, 0, 128, 20, 2, 20, 4, 183, 32, 4, 154, 33, 32, 124, 33, 
      33, 16, 132, 0, 33, 17, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16_swap_trunc);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u16_swap_trunc");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16_swap_trunc);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_constant (p, 4, 0x00000010, "c1");
    orc_program_add_constant (p, 4, 0x80000000, "c2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "shll", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s16_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s16_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union16 var35;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: swapw */
    var35.i = ORC_SWAP_W(var33.i);
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var35.i;
       _dest.x2[1] = var35.i;
       var34.i = _dest.i;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_s16_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union16 var35;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: swapw */
    var35.i = ORC_SWAP_W(var33.i);
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var35.i;
       _dest.x2[1] = var35.i;
       var34.i = _dest.i;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_s16_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 49, 54, 95, 115, 119, 97, 112, 11, 4, 4, 12, 
      2, 2, 20, 2, 183, 32, 4, 195, 0, 32, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s16_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s16_swap_trunc */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s16_swap_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union32 var35;
  orc_union16 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var36.i = ORC_SWAP_W(var34.i);
    /* 2: convuwl */
    var37.i = (orc_uint16)var36.i;
    /* 3: shll */
    var35.i = ((orc_uint32)var37.i) << 16;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_s16_swap_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union32 var35;
  orc_union16 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var36.i = ORC_SWAP_W(var34.i);
    /* 2: convuwl */
    var37.i = (orc_uint16)var36.i;
    /* 3: shll */
    var35.i = ((orc_uint32)var37.i) << 16;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_s16_swap_trunc (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 49, 54, 95, 115, 119, 97, 112, 95, 116, 114, 117, 
      110, 99, 11, 4, 4, 12, 2, 2, 14, 4, 16, 0, 0, 0, 20, 2, 
      20, 4, 183, 32, 4, 154, 33, 32, 124, 0, 33, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16_swap_trunc);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s16_swap_trunc");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16_swap_trunc);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_constant (p, 4, 0x00000010, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u24_32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u24_32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 2: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shll */
    var36.i = ((orc_uint32)var33.i) << 8;
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u24_32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 2: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shll */
    var36.i = ((orc_uint32)var33.i) << 8;
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u24_32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 50, 52, 95, 51, 50, 11, 4, 4, 12, 4, 4, 
      14, 4, 8, 0, 0, 0, 14, 4, 0, 0, 0, 128, 20, 4, 124, 32, 
      4, 16, 132, 0, 32, 17, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u24_32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u24_32");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u24_32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x00000008, "c1");
    orc_program_add_constant (p, 4, 0x80000000, "c2");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s24_32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s24_32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shll */
    var33.i = ((orc_uint32)var32.i) << 8;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_s24_32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shll */
    var33.i = ((orc_uint32)var32.i) << 8;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_s24_32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 50, 52, 95, 51, 50, 11, 4, 4, 12, 4, 4, 
      14, 4, 8, 0, 0, 0, 124, 0, 4, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s24_32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s24_32");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s24_32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x00000008, "c1");

    orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u24_32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u24_32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 3: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L(var33.i);
    /* 2: shll */
    var37.i = ((orc_uint32)var36.i) << 8;
    /* 4: xorl */
    var35.i = var37.i ^ var34.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u24_32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 3: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L(var33.i);
    /* 2: shll */
    var37.i = ((orc_uint32)var36.i) << 8;
    /* 4: xorl */
    var35.i = var37.i ^ var34.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u24_32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 28, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 50, 52, 95, 51, 50, 95, 115, 119, 97, 112, 11, 
      4, 4, 12, 4, 4, 14, 4, 8, 0, 0, 0, 14, 4, 0, 0, 0, 
      128, 20, 4, 184, 32, 4, 124, 32, 32, 16, 132, 0, 32, 17, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u24_32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u24_32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u24_32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x00000008, "c1");
    orc_program_add_constant (p, 4, 0x80000000, "c2");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "swapl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s24_32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s24_32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var35.i = ORC_SWAP_L(var33.i);
    /* 2: shll */
    var34.i = ((orc_uint32)var35.i) << 8;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_s24_32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var35.i = ORC_SWAP_L(var33.i);
    /* 2: shll */
    var34.i = ((orc_uint32)var35.i) << 8;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_s24_32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 28, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 50, 52, 95, 51, 50, 95, 115, 119, 97, 112, 11, 
      4, 4, 12, 4, 4, 14, 4, 8, 0, 0, 0, 20, 4, 184, 32, 4, 
      124, 0, 32, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s24_32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s24_32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s24_32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x00000008, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "swapl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var33;
#else
  orc_union32 var33;
#endif
  orc_union32 var34;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var33.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var33;
#else
  orc_union32 var33;
#endif
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var33.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_u32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 20, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 51, 50, 11, 4, 4, 12, 4, 4, 14, 4, 0, 
      0, 0, 128, 132, 0, 4, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u32");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");

    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 2: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L(var33.i);
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 2: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L(var33.i);
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 117, 51, 50, 95, 115, 119, 97, 112, 11, 4, 4, 12, 
      4, 4, 14, 4, 0, 0, 0, 128, 20, 4, 184, 32, 4, 132, 0, 32, 
      16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_u32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_u32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "swapl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_s32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 20, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 51, 50, 11, 4, 4, 12, 4, 4, 112, 0, 4, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s32");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append_2 (p, "copyl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_s32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_s32_swap (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 115, 51, 50, 95, 115, 119, 97, 112, 11, 4, 4, 12, 
      4, 4, 184, 0, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_s32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_s32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_f32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_f32 (gdouble * ORC_RESTRICT d1, const gfloat * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convfd */
    {
       orc_union32 _src1;
       _src1.i = ORC_DENORMAL(var32.i);
       var33.f = _src1.f;
    }
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_f32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convfd */
    {
       orc_union32 _src1;
       _src1.i = ORC_DENORMAL(var32.i);
       var33.f = _src1.f;
    }
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_f32 (gdouble * ORC_RESTRICT d1, const gfloat * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 20, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 102, 51, 50, 11, 8, 8, 12, 4, 4, 224, 0, 4, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_f32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_f32");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_f32);
    orc_program_add_destination (p, 8, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append_2 (p, "convfd", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_f32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_f32_swap (gdouble * ORC_RESTRICT d1, const gfloat * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union64 var34;
  orc_union32 var35;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var35.i = ORC_SWAP_L(var33.i);
    /* 2: convfd */
    {
       orc_union32 _src1;
       _src1.i = ORC_DENORMAL(var35.i);
       var34.f = _src1.f;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_f32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union64 var34;
  orc_union32 var35;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var35.i = ORC_SWAP_L(var33.i);
    /* 2: convfd */
    {
       orc_union32 _src1;
       _src1.i = ORC_DENORMAL(var35.i);
       var34.f = _src1.f;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_f32_swap (gdouble * ORC_RESTRICT d1, const gfloat * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 102, 51, 50, 95, 115, 119, 97, 112, 11, 8, 8, 12, 
      4, 4, 20, 4, 184, 32, 4, 224, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_f32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_f32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_f32_swap);
    orc_program_add_destination (p, 8, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "swapl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "convfd", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_f64 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_f64 (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_f64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_f64 (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 20, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 102, 54, 52, 11, 8, 8, 12, 8, 8, 137, 0, 4, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_f64);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_f64");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_f64);
    orc_program_add_destination (p, 8, "d1");
    orc_program_add_source (p, 8, "s1");

    orc_program_append_2 (p, "copyq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_f64_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_f64_swap (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q(var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_f64_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q(var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_f64_swap (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
      97, 99, 107, 95, 102, 54, 52, 95, 115, 119, 97, 112, 11, 8, 8, 12, 
      8, 8, 186, 0, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_f64_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_unpack_f64_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_unpack_f64_swap);
    orc_program_add_destination (p, 8, "d1");
    orc_program_add_source (p, 8, "s1");

    orc_program_append_2 (p, "swapq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u8 */
#ifdef DISABLE_ORC
void
audio_orc_pack_u8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_int8 var36;
  orc_union32 var37;
  orc_union16 var38;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var37.i = var34.i ^ var35.i;
    /* 3: convhlw */
    var38.i = ((orc_uint32)var37.i)>>16;
    /* 4: convhwb */
    var36 = ((orc_uint16)var38.i)>>8;
    /* 5: storeb */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_pack_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_int8 var36;
  orc_union32 var37;
  orc_union16 var38;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var37.i = var34.i ^ var35.i;
    /* 3: convhlw */
    var38.i = ((orc_uint32)var37.i)>>16;
    /* 4: convhwb */
    var36 = ((orc_uint16)var38.i)>>8;
    /* 5: storeb */
    ptr0[i] = var36;
  }

}

void
audio_orc_pack_u8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 117, 56, 11, 1, 1, 12, 4, 4, 14, 4, 0, 0, 0, 128, 
      20, 4, 20, 2, 132, 32, 4, 16, 164, 33, 32, 158, 0, 33, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u8);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_u8");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_temporary (p, 4, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "convhlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "convhwb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s8 */
#ifdef DISABLE_ORC
void
audio_orc_pack_s8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: convhlw */
    var35.i = ((orc_uint32)var33.i)>>16;
    /* 2: convhwb */
    var34 = ((orc_uint16)var35.i)>>8;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_s8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: convhlw */
    var35.i = ((orc_uint32)var33.i)>>16;
    /* 2: convhwb */
    var34 = ((orc_uint16)var35.i)>>8;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_s8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 115, 56, 11, 1, 1, 12, 4, 4, 20, 2, 164, 32, 4, 158, 
      0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s8);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_s8");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append_2 (p, "convhlw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "convhwb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u16 */
#ifdef DISABLE_ORC
void
audio_orc_pack_u16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union16 var35;
  orc_union32 var36;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: convhlw */
    var35.i = ((orc_uint32)var36.i)>>16;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union16 var35;
  orc_union32 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: convhlw */
    var35.i = ((orc_uint32)var36.i)>>16;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_u16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 117, 49, 54, 11, 2, 2, 12, 4, 4, 14, 4, 0, 0, 0, 
      128, 20, 4, 132, 32, 4, 16, 164, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u16);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_u16");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "convhlw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s16 */
#ifdef DISABLE_ORC
void
audio_orc_pack_s16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convhlw */
    var33.i = ((orc_uint32)var32.i)>>16;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convhlw */
    var33.i = ((orc_uint32)var32.i)>>16;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_s16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 115, 49, 54, 11, 2, 2, 12, 4, 4, 164, 0, 4, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s16);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_s16");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append_2 (p, "convhlw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u16_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_u16_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union16 var36;
  orc_union32 var37;
  orc_union16 var38;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var37.i = var34.i ^ var35.i;
    /* 3: convhlw */
    var38.i = ((orc_uint32)var37.i)>>16;
    /* 4: swapw */
    var36.i = ORC_SWAP_W(var38.i);
    /* 5: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_pack_u16_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union16 var36;
  orc_union32 var37;
  orc_union16 var38;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var35.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var37.i = var34.i ^ var35.i;
    /* 3: convhlw */
    var38.i = ((orc_uint32)var37.i)>>16;
    /* 4: swapw */
    var36.i = ORC_SWAP_W(var38.i);
    /* 5: storew */
    ptr0[i] = var36;
  }

}

void
audio_orc_pack_u16_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 117, 49, 54, 95, 115, 119, 97, 112, 11, 2, 2, 12, 4, 4, 
      14, 4, 0, 0, 0, 128, 20, 4, 20, 2, 132, 32, 4, 16, 164, 33, 
      32, 183, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u16_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_u16_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u16_swap);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_temporary (p, 4, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "convhlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "swapw", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s16_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_s16_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_union16 var35;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: convhlw */
    var35.i = ((orc_uint32)var33.i)>>16;
    /* 2: swapw */
    var34.i = ORC_SWAP_W(var35.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_s16_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_union16 var35;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: convhlw */
    var35.i = ((orc_uint32)var33.i)>>16;
    /* 2: swapw */
    var34.i = ORC_SWAP_W(var35.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_s16_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 115, 49, 54, 95, 115, 119, 97, 112, 11, 2, 2, 12, 4, 4, 
      20, 2, 164, 32, 4, 183, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s16_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_s16_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s16_swap);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append_2 (p, "convhlw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "swapw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u24_32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_u24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var35.i = ((orc_uint32)var36.i) >> 8;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_u24_32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var35.i = ((orc_uint32)var36.i) >> 8;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_u24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 117, 50, 52, 95, 51, 50, 11, 4, 4, 12, 4, 4, 14, 4, 
      0, 0, 0, 128, 14, 4, 8, 0, 0, 0, 20, 4, 132, 32, 4, 16, 
      126, 0, 32, 17, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u24_32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_u24_32");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u24_32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_constant (p, 4, 0x00000008, "c2");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "shrul", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s24_32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_s24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shrsl */
    var33.i = var32.i >> 8;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_s24_32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shrsl */
    var33.i = var32.i >> 8;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_s24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 115, 50, 52, 95, 51, 50, 11, 4, 4, 12, 4, 4, 14, 4, 
      8, 0, 0, 0, 125, 0, 4, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s24_32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_s24_32");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s24_32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x00000008, "c1");

    orc_program_append_2 (p, "shrsl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u24_32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_u24_32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var37.i = ((orc_uint32)var36.i) >> 8;
    /* 4: swapl */
    var35.i = ORC_SWAP_L(var37.i);
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_u24_32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var37.i = ((orc_uint32)var36.i) >> 8;
    /* 4: swapl */
    var35.i = ORC_SWAP_L(var37.i);
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_u24_32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 117, 50, 52, 95, 51, 50, 95, 115, 119, 97, 112, 11, 4, 4, 
      12, 4, 4, 14, 4, 0, 0, 0, 128, 14, 4, 8, 0, 0, 0, 20, 
      4, 132, 32, 4, 16, 126, 32, 32, 17, 184, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u24_32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_u24_32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u24_32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_constant (p, 4, 0x00000008, "c2");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "shrul", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
    orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s24_32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_s24_32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shrsl */
    var35.i = var33.i >> 8;
    /* 2: swapl */
    var34.i = ORC_SWAP_L(var35.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_s24_32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shrsl */
    var35.i = var33.i >> 8;
    /* 2: swapl */
    var34.i = ORC_SWAP_L(var35.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_s24_32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 115, 50, 52, 95, 51, 50, 95, 115, 119, 97, 112, 11, 4, 4, 
      12, 4, 4, 14, 4, 8, 0, 0, 0, 20, 4, 125, 32, 4, 16, 184, 
      0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s24_32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_s24_32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s24_32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x00000008, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_u32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var33;
#else
  orc_union32 var33;
#endif
  orc_union32 var34;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var33.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var33;
#else
  orc_union32 var33;
#endif
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var33.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_u32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 117, 51, 50, 11, 4, 4, 12, 4, 4, 14, 4, 0, 0, 0, 
      128, 132, 0, 4, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_u32");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");

    orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_s32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_s32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 115, 51, 50, 11, 4, 4, 12, 4, 4, 112, 0, 4, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_s32");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append_2 (p, "copyl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_u32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: swapl */
    var35.i = ORC_SWAP_L(var36.i);
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_u32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var34.i = 0x80000000; /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: swapl */
    var35.i = ORC_SWAP_L(var36.i);
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_u32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 117, 51, 50, 95, 115, 119, 97, 112, 11, 4, 4, 12, 4, 4, 
      14, 4, 0, 0, 0, 128, 20, 4, 132, 32, 4, 16, 184, 0, 32, 2, 
      0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_u32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_u32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant (p, 4, 0x80000000, "c1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_s32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_s32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_s32_swap (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 115, 51, 50, 95, 115, 119, 97, 112, 11, 4, 4, 12, 4, 4, 
      184, 0, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_s32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_s32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_f32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_f32 (gfloat * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convdf */
    {
       orc_union64 _src1;
       orc_union32 _dest;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _dest.f = _src1.f;
       var33.i = ORC_DENORMAL(_dest.i);
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_f32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convdf */
    {
       orc_union64 _src1;
       orc_union32 _dest;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _dest.f = _src1.f;
       var33.i = ORC_DENORMAL(_dest.i);
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_f32 (gfloat * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 102, 51, 50, 11, 4, 4, 12, 8, 8, 225, 0, 4, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_f32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_f32");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_f32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 8, "s1");

    orc_program_append_2 (p, "convdf", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_f32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_f32_swap (gfloat * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 1: convdf */
    {
       orc_union64 _src1;
       orc_union32 _dest;
       _src1.i = ORC_DENORMAL_DOUBLE(var33.i);
       _dest.f = _src1.f;
       var35.i = ORC_DENORMAL(_dest.i);
    }
    /* 2: swapl */
    var34.i = ORC_SWAP_L(var35.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_f32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 1: convdf */
    {
       orc_union64 _src1;
       orc_union32 _dest;
       _src1.i = ORC_DENORMAL_DOUBLE(var33.i);
       _dest.f = _src1.f;
       var35.i = ORC_DENORMAL(_dest.i);
    }
    /* 2: swapl */
    var34.i = ORC_SWAP_L(var35.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_f32_swap (gfloat * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 102, 51, 50, 95, 115, 119, 97, 112, 11, 4, 4, 12, 8, 8, 
      20, 4, 225, 32, 4, 184, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_f32_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_f32_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_f32_swap);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 8, "s1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "convdf", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_f64 */
#ifdef DISABLE_ORC
void
audio_orc_pack_f64 (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_f64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_f64 (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 102, 54, 52, 11, 8, 8, 12, 8, 8, 137, 0, 4, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_f64);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_f64");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_f64);
    orc_program_add_destination (p, 8, "d1");
    orc_program_add_source (p, 8, "s1");

    orc_program_append_2 (p, "copyq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_f64_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_f64_swap (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q(var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_f64_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q(var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_f64_swap (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
      107, 95, 102, 54, 52, 95, 115, 119, 97, 112, 11, 8, 8, 12, 8, 8, 
      186, 0, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_pack_f64_swap);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_pack_f64_swap");
    orc_program_set_backup_function (p, _backup_audio_orc_pack_f64_swap);
    orc_program_add_destination (p, 8, "d1");
    orc_program_add_source (p, 8, "s1");

    orc_program_append_2 (p, "swapq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_splat_u16 */
#ifdef DISABLE_ORC
void
audio_orc_splat_u16 (guint16 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)d1;

    /* 0: loadpw */
    var32.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: copyw */
    var33.i = var32.i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_splat_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->arrays[0];

    /* 0: loadpw */
    var32.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: copyw */
    var33.i = var32.i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
audio_orc_splat_u16 (guint16 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 115, 112, 108, 
      97, 116, 95, 117, 49, 54, 11, 2, 2, 16, 2, 79, 0, 24, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_splat_u16);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_splat_u16");
    orc_program_set_backup_function (p, _backup_audio_orc_splat_u16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_splat_u32 */
#ifdef DISABLE_ORC
void
audio_orc_splat_u32 (guint32 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;

    /* 0: loadpl */
    var32.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_splat_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];

    /* 0: loadpl */
    var32.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_splat_u32 (guint32 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 115, 112, 108, 
      97, 116, 95, 117, 51, 50, 11, 4, 4, 16, 4, 112, 0, 24, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_splat_u32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_splat_u32");
    orc_program_set_backup_function (p, _backup_audio_orc_splat_u32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_parameter (p, 4, "p1");

    orc_program_append_2 (p, "copyl", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_splat_u64 */
#ifdef DISABLE_ORC
void
audio_orc_splat_u64 (guint64 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)d1;

    /* 0: loadpq */
    var32.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_splat_u64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->arrays[0];

    /* 0: loadpq */
    var32.i = (ex->params[24] & 0xffffffff) | ((orc_uint64)(ex->params[24 + (ORC_N_PARAMS)]) << 32);

  for (i = 0; i < n; i++) {
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_splat_u64 (guint64 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 115, 112, 108, 
      97, 116, 95, 117, 54, 52, 11, 8, 8, 16, 8, 137, 0, 24, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_splat_u64);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_splat_u64");
    orc_program_set_backup_function (p, _backup_audio_orc_splat_u64);
    orc_program_add_destination (p, 8, "d1");
    orc_program_add_parameter (p, 8, "p1");

    orc_program_append_2 (p, "copyq", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_int_bias */
#ifdef DISABLE_ORC
void
audio_orc_int_bias (gint32 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var34.i = p1;
    /* 3: loadpl */
    var35.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: addssl */
    var37.i = ORC_CLAMP_SL((orc_int64)var33.i + (orc_int64)var34.i);
    /* 4: andl */
    var36.i = var37.i & var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_int_bias (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var34.i = ex->params[24];
    /* 3: loadpl */
    var35.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: addssl */
    var37.i = ORC_CLAMP_SL((orc_int64)var33.i + (orc_int64)var34.i);
    /* 4: andl */
    var36.i = var37.i & var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_int_bias (gint32 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 105, 110, 116, 
      95, 98, 105, 97, 115, 11, 4, 4, 12, 4, 4, 16, 4, 16, 4, 20, 
      4, 104, 32, 4, 24, 106, 0, 32, 25, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_int_bias);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_int_bias");
    orc_program_set_backup_function (p, _backup_audio_orc_int_bias);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_parameter (p, 4, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "addssl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_P1, ORC_VAR_D1);
    orc_program_append_2 (p, "andl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_int_dither */
#ifdef DISABLE_ORC
void
audio_orc_int_dither (gint32 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, const gint32 * ORC_RESTRICT s2, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;

    /* 3: loadpl */
    var35.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: loadl */
    var34 = ptr5[i];
    /* 2: addssl */
    var37.i = ORC_CLAMP_SL((orc_int64)var33.i + (orc_int64)var34.i);
    /* 4: andl */
    var36.i = var37.i & var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_int_dither (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

    /* 3: loadpl */
    var35.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: loadl */
    var34 = ptr5[i];
    /* 2: addssl */
    var37.i = ORC_CLAMP_SL((orc_int64)var33.i + (orc_int64)var34.i);
    /* 4: andl */
    var36.i = var37.i & var35.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_int_dither (gint32 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, const gint32 * ORC_RESTRICT s2, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 20, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 105, 110, 116, 
      95, 100, 105, 116, 104, 101, 114, 11, 4, 4, 12, 4, 4, 12, 4, 4, 
      16, 4, 20, 4, 104, 32, 4, 5, 106, 0, 32, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_int_dither);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_int_dither");
    orc_program_set_backup_function (p, _backup_audio_orc_int_dither);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");
    orc_program_add_parameter (p, 4, "p1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "addssl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append_2 (p, "andl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_update_rand */
#ifdef DISABLE_ORC
void
audio_orc_update_rand (guint32 * ORC_RESTRICT d1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;

    /* 1: loadpl */
    var34.i = 0x41c64e6d; /* 1103515245 or 5.45209e-315f */
    /* 3: loadpl */
    var35.i = 0x00003039; /* 12345 or 6.09924e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: mulll */
    var37.i = (((orc_uint32)var33.i) * ((orc_uint32)var34.i)) & 0xffffffff;
    /* 4: addl */
    var36.i = ((orc_uint32)var37.i) + ((orc_uint32)var35.i);
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_update_rand (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];

    /* 1: loadpl */
    var34.i = 0x41c64e6d; /* 1103515245 or 5.45209e-315f */
    /* 3: loadpl */
    var35.i = 0x00003039; /* 12345 or 6.09924e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: mulll */
    var37.i = (((orc_uint32)var33.i) * ((orc_uint32)var34.i)) & 0xffffffff;
    /* 4: addl */
    var36.i = ((orc_uint32)var37.i) + ((orc_uint32)var35.i);
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_update_rand (guint32 * ORC_RESTRICT d1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 117, 112, 100, 
      97, 116, 101, 95, 114, 97, 110, 100, 11, 4, 4, 14, 4, 109, 78, 198, 
      65, 14, 4, 57, 48, 0, 0, 20, 4, 120, 32, 0, 16, 103, 0, 32, 
      17, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_update_rand);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_update_rand");
    orc_program_set_backup_function (p, _backup_audio_orc_update_rand);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_constant (p, 4, 0x41c64e6d, "c1");
    orc_program_add_constant (p, 4, 0x00003039, "c2");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append_2 (p, "mulll", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_s32_to_double */
#ifdef DISABLE_ORC
void
audio_orc_s32_to_double (gdouble * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var34;
#else
  orc_union64 var34;
#endif
  orc_union64 var35;
  orc_union64 var36;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 2: loadpq */
    var34.i = ORC_UINT64_C(0x41e0000000000000); /* 2.14748e+09f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: convld */
    var36.f = (double)var33.i;
    /* 3: divd */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var36.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var34.i);
       _dest1.f = _src1.f / _src2.f;
       var35.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 4: storeq */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_s32_to_double (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var34;
#else
  orc_union64 var34;
#endif
  orc_union64 var35;
  orc_union64 var36;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 2: loadpq */
    var34.i = ORC_UINT64_C(0x41e0000000000000); /* 2.14748e+09f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: convld */
    var36.f = (double)var33.i;
    /* 3: divd */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var36.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var34.i);
       _dest1.f = _src1.f / _src2.f;
       var35.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 4: storeq */
    ptr0[i] = var35;
  }

}

void
audio_orc_s32_to_double (gdouble * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 115, 51, 50, 
      95, 116, 111, 95, 100, 111, 117, 98, 108, 101, 11, 8, 8, 12, 4, 4, 
      15, 8, 0, 0, 0, 0, 0, 0, 224, 65, 20, 8, 223, 32, 4, 215, 
      0, 32, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_s32_to_double);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_s32_to_double");
    orc_program_set_backup_function (p, _backup_audio_orc_s32_to_double);
    orc_program_add_destination (p, 8, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_constant_int64 (p, 8, 0x41e0000000000000ULL, "c1");
    orc_program_add_temporary (p, 8, "t1");

    orc_program_append_2 (p, "convld", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append_2 (p, "divd", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_double_to_s32 */
#ifdef DISABLE_ORC
void
audio_orc_double_to_s32 (gint32 * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var34;
#else
  orc_union64 var34;
#endif
  orc_union32 var35;
  orc_union64 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union64 *)s1;

    /* 1: loadpq */
    var34.i = ORC_UINT64_C(0x41e0000000000000); /* 2.14748e+09f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 2: muld */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var33.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var34.i);
       _dest1.f = _src1.f * _src2.f;
       var36.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 3: convdl */
    {
       int tmp;
       tmp = (int)var36.f;
       if (tmp == 0x80000000 && !(var36.i & ORC_UINT64_C(0x8000000000000000))) tmp = 0x7fffffff;
       var35.i = tmp;
    }
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_double_to_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var34;
#else
  orc_union64 var34;
#endif
  orc_union32 var35;
  orc_union64 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];

    /* 1: loadpq */
    var34.i = ORC_UINT64_C(0x41e0000000000000); /* 2.14748e+09f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 2: muld */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var33.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var34.i);
       _dest1.f = _src1.f * _src2.f;
       var36.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 3: convdl */
    {
       int tmp;
       tmp = (int)var36.f;
       if (tmp == 0x80000000 && !(var36.i & ORC_UINT64_C(0x8000000000000000))) tmp = 0x7fffffff;
       var35.i = tmp;
    }
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_double_to_s32 (gint32 * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static OrcOnce once = ORC_ONCE_INIT;
  OrcCode *c;
  OrcExecutorFunc func = NULL;

  if (!orc_once_enter (&once, (void **) &c)) {
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 97, 117, 100, 105, 111, 95, 111, 114, 99, 95, 100, 111, 117, 
      98, 108, 101, 95, 116, 111, 95, 115, 51, 50, 11, 4, 4, 12, 8, 8, 
      15, 8, 0, 0, 0, 0, 0, 0, 224, 65, 20, 8, 214, 32, 4, 16, 
      222, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_audio_orc_double_to_s32);
#else
    p = orc_program_new ();
    orc_program_set_name (p, "audio_orc_double_to_s32");
    orc_program_set_backup_function (p, _backup_audio_orc_double_to_s32);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 8, "s1");
    orc_program_add_constant_int64 (p, 8, 0x41e0000000000000ULL, "c1");
    orc_program_add_temporary (p, 8, "t1");

    orc_program_append_2 (p, "muld", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
    orc_program_append_2 (p, "convdl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);
    c = orc_program_take_code (p);
    orc_program_free (p);
    orc_once_leave (&once, c);
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


