
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 1912
 * transforms:
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('f2b', ('fneg', 'a')) => ('f2b', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul', 'a@16', 0.0) => 0.0
 *    ('fmul', 'a@32', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('fround_even', 'a') => ('bcsel', ('feq', ('ffract', 'a'), 0.5), ('fadd', ('ffloor', ('fadd', 'a', 0.5)), 1.0), ('ffloor', ('fadd', 'a', 0.5)))
 *    ('ffloor', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b')
 *    ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('f2f16', ('f2f32', 'a@16')) => a
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('f2f16', ('f2f64', 'a@16')) => a
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('f2f32', ('f2f64', 'a@32')) => a
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a')
 *    ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('ieq', 'a.z', 'b.z'))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ine', 'a.z', 'b.z'))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('feq', 'a.z', 'b.z'))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('fneu', 'a.z', 'b.z'))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', 0) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', True) => True
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0)
 *    ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0)
 *    ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0)
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('i2b', ('iabs', 'a')) => ('i2b', 'a')
 *    ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0)
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('i2b', ('ubfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('i2b', ('ibfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ufind_msb', 'value') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('find_lsb', 'value') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('pack_32_2x16_split', 'a@16', 'b@16') => ('ior', ('ishl', ('u2u32', 'b'), 16), ('u2u32', 'a'))
 *    ('unpack_32_2x16_split_x', 'a@32') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a@32') => ('u2u16', ('ushr', 'a', 16))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('fcsel', ('slt', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('fcsel', ('slt', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'c', 'b')
 *    ('fcsel', ('sge', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('fcsel', ('sge', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('ilt', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('ilt', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('ige', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('ige', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('flt', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('flt', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('fge', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('fge', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'c', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2b1', ('b2f', 'a@1')) => a
 *    ('i2b1', ('b2i', 'a@1')) => a
 *    ('f2b8', ('b2f', 'a@8')) => a
 *    ('i2b8', ('b2i', 'a@8')) => a
 *    ('f2b16', ('b2f', 'a@16')) => a
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('f2b32', ('b2f', 'a@32')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80 /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 6, 7 },
      -1,
   } },

   /* replace1_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7 /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 9 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000 /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 11, 12 },
      -1,
   } },

   /* replace2_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xf /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 14 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000 /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 17 },
      -1,
   } },

   /* replace3_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1f /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 19 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000 /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 22 },
      -1,
   } },

   /* replace4_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3f /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 24 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search5_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 26 },
      -1,
   } },

   /* replace5_0_0 -> 0 in the cache */
   /* replace5_0_1_0_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 28 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 30 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 33 },
      -1,
   } },

   /* replace6_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 35, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 37 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search7_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 39 },
      -1,
   } },

   /* replace7_0_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ufind_msb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 42 },
      -1,
   } },
   /* replace7_1_0 -> 21 in the cache */
   /* replace7_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 43, 45 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search8_0_0 -> 16 in the cache */
   /* search8_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 47 },
      -1,
   } },

   /* replace8_0 -> 16 in the cache */
   /* replace8_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search9_0_0 -> 16 in the cache */
   /* search9_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 50 },
      -1,
   } },

   /* replace9_0 -> 16 in the cache */
   /* replace9_1 -> 36 in the cache */
   /* replace9 -> 49 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search10_0 -> 16 in the cache */
   /* search10_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace10_0_0 -> 16 in the cache */
   /* replace10_0_1 -> 36 in the cache */
   /* replace10_0 -> 49 in the cache */
   /* replace10_1_0 -> 16 in the cache */
   /* replace10_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 53 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search11_0 -> 16 in the cache */
   /* search11_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace11_0_0 -> 16 in the cache */
   /* replace11_0_1 -> 36 in the cache */
   /* replace11_0 -> 49 in the cache */
   /* replace11_1_0 -> 16 in the cache */
   /* replace11_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 56 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search12_0 -> 32 in the cache */
   /* search12_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace12 -> 32 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search13_0 -> 32 in the cache */
   /* search13_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace13 -> 32 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search14_0 -> 32 in the cache */
   /* search14_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0 /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search15_0 -> 32 in the cache */
   /* search15_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace15 -> 61 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search16_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace16 -> 61 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search17_0 -> 32 in the cache */
   /* search17_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace17 -> 61 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search18_0 -> 32 in the cache */
   /* search18_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace18 -> 61 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search19_0 -> 0 in the cache */
   /* search19_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace19_0 -> 0 in the cache */
   /* replace19_1_0 -> 3 in the cache */
   /* replace19_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search20_0 -> 0 in the cache */
   /* search20_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace20_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_1_0 -> 3 in the cache */
   /* replace20_1_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 4 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 72 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search21_0 -> 0 in the cache */
   /* search21_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace21_0_0_0 -> 0 in the cache */
   /* replace21_0_0 -> 70 in the cache */
   /* replace21_0_1_0_0 -> 0 in the cache */
   /* replace21_0_1_0 -> 71 in the cache */
   /* replace21_0_1_1_0_0 -> 3 in the cache */
   /* replace21_0_1_1_0 -> 28 in the cache */
   /* replace21_0_1_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 75 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 76 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search22_0 -> 0 in the cache */
   /* search22_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace22_0 -> 0 in the cache */
   /* replace22_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 3, 79 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 80 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 3 in the cache */
   /* replace23_1_1 -> 79 in the cache */
   /* replace23_1 -> 80 in the cache */
   /* replace23 -> 81 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace24_0_0_0 -> 0 in the cache */
   /* replace24_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* replace24_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 84, 3 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   /* replace24_2_0 -> 0 in the cache */
   /* replace24_2_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 3,
      { 85, 86, 87 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace25_0 -> 0 in the cache */
   /* replace25_1_0_0_0 -> 0 in the cache */
   /* replace25_1_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 86 },
      -1,
   } },
   /* replace25_1_0_1_0 -> 0 in the cache */
   /* replace25_1_0_1_1_0 -> 3 in the cache */
   /* replace25_1_0_1_1_1 -> 79 in the cache */
   /* replace25_1_0_1_1 -> 80 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 80 },
      -1,
   } },
   /* replace25_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 90, 91, 0 },
      -1,
   } },
   /* replace25_1_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 92, 93 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 2,
      { 0, 94 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 3 in the cache */
   /* replace26_1 -> 28 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 28 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search27_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace27 -> 32 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search28_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace28 -> 32 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search29_0_0 -> 32 in the cache */
   /* search29_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace29_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search30_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 104 },
      -1,
   } },

   /* replace30_0 -> 32 in the cache */
   /* replace30 -> 104 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search31_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 106 },
      -1,
   } },

   /* replace31_0 -> 32 in the cache */
   /* replace31 -> 106 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search32_0_0 -> 32 in the cache */
   /* search32_0 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace32_0 -> 32 in the cache */
   /* replace32 -> 106 in the cache */

   /* ('f2b', ('fneg', 'a')) => ('f2b', 'a') */
   /* search33_0_0 -> 32 in the cache */
   /* search33_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2b,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace33_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2b,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2b', ('ineg', 'a')) => ('i2b', 'a') */
   /* search34_0_0 -> 32 in the cache */
   /* search34_0 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace34_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~fadd', 'a', 0.0) => a */
   /* search35_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* replace35 -> 32 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a */
   /* search36_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 115 },
      1,
   } },

   /* replace36 -> 11 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a */
   /* search37_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 117 },
      1,
   } },

   /* replace37 -> 16 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search38_0 -> 32 in the cache */
   /* search38_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace38 -> 32 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search39_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 120 },
      -1,
   } },

   /* replace39 -> 16 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search40_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 122 },
      -1,
   } },

   /* replace40 -> 122 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* search41_1_0 -> 124 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 126, 128 },
      -1,
   } },

   /* replace41_0 -> 124 in the cache */
   /* replace41_1_0 -> 125 in the cache */
   /* replace41_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 124, 130 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search42_0_0 -> 16 in the cache */
   /* search42_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* search42_1_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 16, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 132, 134 },
      -1,
   } },

   /* replace42_0 -> 16 in the cache */
   /* replace42_1_0 -> 36 in the cache */
   /* replace42_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 16, 136 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search43_0 -> 0 in the cache */
   /* search43_1 -> 3 in the cache */
   /* search43_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 0, 138, 139 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 140 },
      -1,
   } },

   /* replace43_0 -> 0 in the cache */
   /* replace43_1_0 -> 3 in the cache */
   /* replace43_1_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 3, 138 },
      -1,
   } },
   /* replace43_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 142, 139 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search44_0 -> 0 in the cache */
   /* search44_1 -> 3 in the cache */
   /* search44_2_0 -> 0 in the cache */
   /* search44_2_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 0, 138 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 144 },
      -1,
   } },

   /* replace44_0 -> 0 in the cache */
   /* replace44_1_0 -> 3 in the cache */
   /* replace44_1_1 -> 138 in the cache */
   /* replace44_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 0, 142 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 147, 148 },
      0,
   } },
   /* search45_1_0 -> 147 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      2, 1,
      { 147, 150, 151 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 149, 152 },
      -1,
   } },

   /* replace45_0 -> 147 in the cache */
   /* replace45_1_0 -> 148 in the cache */
   /* replace45_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 148, 150 },
      -1,
   } },
   /* replace45_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 147, 154, 151 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search46_0 -> 147 in the cache */
   /* search46_1_0 -> 148 in the cache */
   /* search46_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 148, 150 },
      0,
   } },
   /* search46_2_0 -> 148 in the cache */
   /* search46_2_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 148, 151 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 147, 156, 157 },
      -1,
   } },

   /* replace46_0 -> 148 in the cache */
   /* replace46_1_0 -> 147 in the cache */
   /* replace46_1_1 -> 150 in the cache */
   /* replace46_1_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 147, 150, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 148, 159 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search47_0 -> 16 in the cache */
   /* search47_1 -> 36 in the cache */
   /* search47_2_0 -> 16 in the cache */
   /* search47_2_1 -> 133 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 133, 161 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 162 },
      -1,
   } },

   /* replace47_0 -> 16 in the cache */
   /* replace47_1_0 -> 36 in the cache */
   /* replace47_1_1 -> 133 in the cache */
   /* replace47_1 -> 136 in the cache */
   /* replace47_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 136, 161 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search48_0 -> 16 in the cache */
   /* search48_1 -> 36 in the cache */
   /* search48_2_0 -> 16 in the cache */
   /* search48_2_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 133 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 165 },
      -1,
   } },

   /* replace48_0 -> 16 in the cache */
   /* replace48_1_0 -> 36 in the cache */
   /* replace48_1_1 -> 133 in the cache */
   /* replace48_1 -> 136 in the cache */
   /* replace48 -> 137 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search49_0_0 -> 16 in the cache */
   /* search49_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      0,
   } },
   /* search49_1_0 -> 16 in the cache */
   /* search49_1_1 -> 133 in the cache */
   /* search49_1_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      2, 1,
      { 16, 133, 161 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 167, 168 },
      -1,
   } },

   /* replace49_0 -> 16 in the cache */
   /* replace49_1_0 -> 36 in the cache */
   /* replace49_1_1 -> 133 in the cache */
   /* replace49_1 -> 136 in the cache */
   /* replace49_2 -> 161 in the cache */
   /* replace49 -> 164 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search50_0 -> 16 in the cache */
   /* search50_1_0 -> 36 in the cache */
   /* search50_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 36, 133 },
      0,
   } },
   /* search50_2_0 -> 36 in the cache */
   /* search50_2_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 36, 161 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 3,
      { 16, 170, 171 },
      -1,
   } },

   /* replace50_0 -> 36 in the cache */
   /* replace50_1_0 -> 16 in the cache */
   /* replace50_1_1 -> 133 in the cache */
   /* replace50_1_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 133, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 36, 173 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search51_0_0 -> 124 in the cache */
   /* search51_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* search51_1_0 -> 124 in the cache */
   /* search51_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 175, 176 },
      -1,
   } },

   /* replace51_0 -> 124 in the cache */
   /* replace51_1_0 -> 125 in the cache */
   /* replace51_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 124, 178 },
      -1,
   } },

   /* ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search52_0_0 -> 124 in the cache */
   /* search52_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* search52_1_0 -> 124 in the cache */
   /* search52_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 180, 181 },
      -1,
   } },

   /* replace52_0 -> 124 in the cache */
   /* replace52_1_0 -> 125 in the cache */
   /* replace52_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 124, 183 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search53_0_0 -> 124 in the cache */
   /* search53_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* search53_1_0 -> 124 in the cache */
   /* search53_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 185, 186 },
      -1,
   } },

   /* replace53_0 -> 124 in the cache */
   /* replace53_1_0 -> 125 in the cache */
   /* replace53_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 124, 188 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search54_0_0 -> 32 in the cache */
   /* search54_0 -> 98 in the cache */
   /* search54_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace54 -> 113 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search55_0_0 -> 32 in the cache */
   /* search55_0 -> 100 in the cache */
   /* search55_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 100, 32 },
      -1,
   } },

   /* replace55 -> 61 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search56_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search56_1_0 -> 0 in the cache */
   /* search56_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 192, 193 },
      -1,
   } },

   /* replace56 -> 3 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search57_0 -> 0 in the cache */
   /* search57_1_0_0 -> 0 in the cache */
   /* search57_1_0 -> 192 in the cache */
   /* search57_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 192, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 0, 195 },
      -1,
   } },

   /* replace57 -> 3 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search58_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search58_1_0 -> 0 in the cache */
   /* search58_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 197, 198 },
      -1,
   } },

   /* replace58 -> 3 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search59_0 -> 0 in the cache */
   /* search59_1_0_0 -> 0 in the cache */
   /* search59_1_0 -> 197 in the cache */
   /* search59_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 197, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 0, 200 },
      -1,
   } },

   /* replace59 -> 3 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search60_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search60_1_0_0 -> 32 in the cache */
   /* search60_1_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 202, 203 },
      -1,
   } },

   /* replace60_0_0 -> 32 in the cache */
   /* replace60_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 103 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search61_0 -> 32 in the cache */
   /* search61_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* replace61 -> 113 in the cache */

   /* ('fmul', 'a@16', 0.0) => 0.0 */
   /* search62_0 -> 11 in the cache */
   /* search62_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 115 },
      -1,
   } },

   /* replace62 -> 115 in the cache */

   /* ('fmul', 'a@32', 0.0) => 0.0 */
   /* search63_0 -> 16 in the cache */
   /* search63_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 117 },
      -1,
   } },

   /* replace63 -> 117 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search64_0 -> 16 in the cache */
   /* search64_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 117 },
      -1,
   } },

   /* replace64 -> 117 in the cache */

   /* ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search65_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 210 },
      -1,
   } },

   /* replace65_0 -> 16 in the cache */
   /* replace65_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 213, 214 },
      -1,
   } },

   /* replace66_0 -> 16 in the cache */
   /* replace66_1 -> 36 in the cache */
   /* replace66 -> 212 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search67_0 -> 16 in the cache */
   /* search67_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* replace67_0 -> 16 in the cache */
   /* replace67_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search68_0 -> 16 in the cache */
   /* search68_1 -> 210 in the cache */
   /* search68_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 210, 133 },
      -1,
   } },

   /* replace68_0 -> 16 in the cache */
   /* replace68_1 -> 36 in the cache */
   /* replace68_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search69_0 -> 213 in the cache */
   /* search69_1 -> 214 in the cache */
   /* search69_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 213, 214, 133 },
      -1,
   } },

   /* replace69_0 -> 16 in the cache */
   /* replace69_1 -> 36 in the cache */
   /* replace69_2 -> 133 in the cache */
   /* replace69 -> 219 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search70_0 -> 16 in the cache */
   /* search70_1 -> 16 in the cache */
   /* search70_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* replace70_0 -> 16 in the cache */
   /* replace70_1 -> 16 in the cache */
   /* replace70_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search71_0 -> 32 in the cache */
   /* search71_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace71 -> 61 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search72_0 -> 16 in the cache */
   /* search72_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 120 },
      -1,
   } },

   /* replace72 -> 120 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search73_0 -> 16 in the cache */
   /* search73_1 -> 122 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 122 },
      -1,
   } },

   /* replace73 -> 16 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search74_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 226 },
      -1,
   } },

   /* replace74 -> 32 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search75_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 228 },
      -1,
   } },

   /* replace75 -> 16 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search76_0 -> 32 in the cache */
   /* search76_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 226 },
      1,
   } },

   /* replace76 -> 32 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search77_0 -> 32 in the cache */
   /* search77_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 35 },
      -1,
   } },

   /* replace77 -> 32 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search78_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 232 },
      -1,
   } },

   /* replace78_0 -> 32 in the cache */
   /* replace78 -> 98 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search79_0 -> 32 in the cache */
   /* search79_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace79_0 -> 32 in the cache */
   /* replace79 -> 100 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search80_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search80_1_0 -> 32 in the cache */
   /* search80_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 235, 236 },
      -1,
   } },

   /* replace80_0_0 -> 32 in the cache */
   /* replace80_0 -> 103 in the cache */
   /* replace80_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 103, 32 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search81_0_0_0 -> 32 in the cache */
   /* search81_0_0 -> 235 in the cache */
   /* search81_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 235, 32 },
      -1,
   } },
   /* search81_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 239, 32 },
      -1,
   } },

   /* replace81_0_0 -> 32 in the cache */
   /* replace81_0 -> 103 in the cache */
   /* replace81_1 -> 32 in the cache */
   /* replace81 -> 238 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search82_1 -> 0 in the cache */
   /* search82_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 241, 0, 3 },
      -1,
   } },

   /* replace82 -> 3 in the cache */

   /* ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search83_0 -> 115 in the cache */
   /* search83_1 -> 11 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 115, 11, 243 },
      1,
   } },

   /* replace83 -> 243 in the cache */

   /* ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search84_0 -> 117 in the cache */
   /* search84_1 -> 16 in the cache */
   /* search84_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 117, 16, 36 },
      1,
   } },

   /* replace84 -> 36 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search85_0 -> 117 in the cache */
   /* search85_1 -> 16 in the cache */
   /* search85_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 117, 16, 36 },
      -1,
   } },

   /* replace85_0 -> 117 in the cache */
   /* replace85_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 117, 36 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search86_0 -> 0 in the cache */
   /* search86_1 -> 3 in the cache */
   /* search86_2 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 3, 241 },
      -1,
   } },

   /* replace86_0 -> 0 in the cache */
   /* replace86_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search87_0 -> 11 in the cache */
   /* search87_1 -> 243 in the cache */
   /* search87_2 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 243, 115 },
      -1,
   } },

   /* replace87_0 -> 11 in the cache */
   /* replace87_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 243 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search88_0 -> 16 in the cache */
   /* search88_1 -> 36 in the cache */
   /* search88_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 117 },
      -1,
   } },

   /* replace88_0 -> 16 in the cache */
   /* replace88_1 -> 36 in the cache */
   /* replace88 -> 212 in the cache */

   /* ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search89_0 -> 16 in the cache */
   /* search89_1 -> 36 in the cache */
   /* search89_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 117 },
      -1,
   } },

   /* replace89_0 -> 16 in the cache */
   /* replace89_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search90_1 -> 0 in the cache */
   /* search90_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 255, 0, 3 },
      -1,
   } },

   /* replace90_0 -> 0 in the cache */
   /* replace90_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search91_0 -> 228 in the cache */
   /* search91_1 -> 16 in the cache */
   /* search91_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 228, 16, 36 },
      -1,
   } },

   /* replace91_0 -> 16 in the cache */
   /* replace91_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search92_1 -> 0 in the cache */
   /* search92_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 260, 0, 3 },
      -1,
   } },

   /* replace92_0_0 -> 0 in the cache */
   /* replace92_0 -> 197 in the cache */
   /* replace92_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 197, 3 },
      -1,
   } },

   /* ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search93_1 -> 16 in the cache */
   /* search93_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 263, 16, 36 },
      -1,
   } },

   /* replace93_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 16 },
      -1,
   } },
   /* replace93_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 265, 36 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search94_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 267, 268, 127 },
      -1,
   } },

   /* replace94_0_0 -> 124 in the cache */
   /* replace94_0_1 -> 125 in the cache */
   /* replace94_0 -> 126 in the cache */
   /* replace94_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 126, 127 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search95_1 -> 33 in the cache */
   /* search95_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 271, 33, 133 },
      -1,
   } },

   /* replace95_0_0 -> 16 in the cache */
   /* replace95_0_1 -> 36 in the cache */
   /* replace95_0 -> 132 in the cache */
   /* replace95_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 132, 133 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search96_0 -> 0 in the cache */
   /* search96_1 -> 3 in the cache */
   /* search96_2 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 241 },
      -1,
   } },

   /* replace96 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search97_0 -> 0 in the cache */
   /* search97_1 -> 3 in the cache */
   /* search97_2 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 255 },
      -1,
   } },

   /* replace97 -> 3 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search98_0 -> 0 in the cache */
   /* search98_1 -> 0 in the cache */
   /* search98_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 3 },
      -1,
   } },

   /* replace98 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search99_0 -> 241 in the cache */
   /* search99_1 -> 0 in the cache */
   /* search99_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 241, 0, 3 },
      -1,
   } },

   /* replace99_0 -> 0 in the cache */
   /* replace99_1 -> 3 in the cache */
   /* replace99 -> 249 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search100_0 -> 124 in the cache */
   /* search100_1_0 -> 124 in the cache */
   /* search100_1_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 124, 125 },
      0,
   } },
   /* search100_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 124, 278, 127 },
      -1,
   } },

   /* replace100_0_0 -> 125 in the cache */
   /* replace100_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 125, 127 },
      -1,
   } },
   /* replace100_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 280, 124 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search101_0 -> 16 in the cache */
   /* search101_1 -> 120 in the cache */
   /* search101_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace101 -> 36 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search102_0 -> 16 in the cache */
   /* search102_1 -> 120 in the cache */
   /* search102_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace102 -> 36 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search103_0 -> 16 in the cache */
   /* search103_1 -> 120 in the cache */
   /* search103_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace103 -> 36 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search104_0 -> 16 in the cache */
   /* search104_1 -> 120 in the cache */
   /* search104_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace104 -> 36 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search105_0 -> 16 in the cache */
   /* search105_1 -> 120 in the cache */
   /* search105_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace105 -> 36 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search106_0 -> 16 in the cache */
   /* search106_1 -> 120 in the cache */
   /* search106_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace106 -> 36 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search107_0 -> 16 in the cache */
   /* search107_1 -> 120 in the cache */
   /* search107_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace107 -> 36 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search108_0 -> 16 in the cache */
   /* search108_1 -> 120 in the cache */
   /* search108_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace108 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search109_0 -> 16 in the cache */
   /* search109_1 -> 120 in the cache */
   /* search109_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 120, 36 },
      -1,
   } },

   /* replace109 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search110_0 -> 120 in the cache */
   /* search110_1 -> 16 in the cache */
   /* search110_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 120, 16, 36 },
      -1,
   } },

   /* replace110 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search111_0 -> 16 in the cache */
   /* search111_1 -> 120 in the cache */
   /* search111_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 120, 36 },
      -1,
   } },

   /* replace111 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search112_0 -> 120 in the cache */
   /* search112_1 -> 16 in the cache */
   /* search112_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 120, 16, 36 },
      -1,
   } },

   /* replace112 -> 36 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search113_0_0 -> 16 in the cache */
   /* search113_0_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 294 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 295, 296 },
      -1,
   } },

   /* replace113_0 -> 16 in the cache */
   /* replace113_1 -> 36 in the cache */
   /* replace113_2_0 -> 133 in the cache */
   /* replace113_2_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 133, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 16, 36, 298 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search114_0_0 -> 16 in the cache */
   /* search114_0_1 -> 36 in the cache */
   /* search114_0_2 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 294 },
      0,
   } },
   /* search114_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 300, 296 },
      -1,
   } },

   /* replace114_0 -> 16 in the cache */
   /* replace114_1 -> 36 in the cache */
   /* replace114_2_0 -> 133 in the cache */
   /* replace114_2_1 -> 161 in the cache */
   /* replace114_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 16, 36, 298 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search115_0_0 -> 16 in the cache */
   /* search115_0_1 -> 36 in the cache */
   /* search115_0_2 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 294 },
      0,
   } },
   /* search115_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 303, 296 },
      -1,
   } },

   /* replace115_0 -> 16 in the cache */
   /* replace115_1 -> 36 in the cache */
   /* replace115_2_0 -> 133 in the cache */
   /* replace115_2_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 133, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 16, 36, 305 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search116_0_0 -> 16 in the cache */
   /* search116_0_1 -> 36 in the cache */
   /* search116_0_2 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 294 },
      0,
   } },
   /* search116_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 307, 296 },
      -1,
   } },

   /* replace116_0 -> 16 in the cache */
   /* replace116_1 -> 36 in the cache */
   /* replace116_2_0 -> 133 in the cache */
   /* replace116_2_1 -> 161 in the cache */
   /* replace116_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 16, 36, 298 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search117_0_0 -> 16 in the cache */
   /* search117_0_1 -> 36 in the cache */
   /* search117_0_2 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 294 },
      0,
   } },
   /* search117_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 310, 296 },
      -1,
   } },

   /* replace117_0 -> 16 in the cache */
   /* replace117_1 -> 36 in the cache */
   /* replace117_2_0 -> 133 in the cache */
   /* replace117_2_1 -> 161 in the cache */
   /* replace117_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 16, 36, 298 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search118_0_1 -> 36 in the cache */
   /* search118_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 313, 36, 120 },
      -1,
   } },
   /* search118_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 314, 133 },
      -1,
   } },

   /* replace118_0 -> 16 in the cache */
   /* replace118_1 -> 36 in the cache */
   /* replace118_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search119_0_0 -> 313 in the cache */
   /* search119_0_1 -> 36 in the cache */
   /* search119_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 313, 36, 120 },
      -1,
   } },
   /* search119_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 317, 133 },
      -1,
   } },

   /* replace119_0 -> 16 in the cache */
   /* replace119_1 -> 36 in the cache */
   /* replace119_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search120_0_0 -> 313 in the cache */
   /* search120_0_1 -> 36 in the cache */
   /* search120_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 313, 36, 120 },
      -1,
   } },
   /* search120_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 320, 133 },
      -1,
   } },

   /* replace120_0 -> 16 in the cache */
   /* replace120_1 -> 36 in the cache */
   /* replace120_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 133 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search121_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search121_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 323, 120 },
      -1,
   } },
   /* search121_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 324, 133 },
      -1,
   } },

   /* replace121_0 -> 16 in the cache */
   /* replace121_1 -> 36 in the cache */
   /* replace121_2 -> 133 in the cache */
   /* replace121 -> 322 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search122_0_0 -> 313 in the cache */
   /* search122_0_1 -> 36 in the cache */
   /* search122_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 313, 36, 120 },
      -1,
   } },
   /* search122_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 326, 133 },
      -1,
   } },

   /* replace122_0 -> 16 in the cache */
   /* replace122_1 -> 36 in the cache */
   /* replace122_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search123_0_0 -> 313 in the cache */
   /* search123_0_1 -> 36 in the cache */
   /* search123_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 313, 36, 120 },
      -1,
   } },
   /* search123_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 329, 133 },
      -1,
   } },

   /* replace123_0 -> 16 in the cache */
   /* replace123_1 -> 36 in the cache */
   /* replace123_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search124_0 -> 271 in the cache */
   /* search124_1 -> 33 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace124_0_0 -> 16 in the cache */
   /* replace124_0_1 -> 36 in the cache */
   /* replace124_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 120 },
      -1,
   } },
   /* replace124_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 334, 133 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search125_0 -> 271 in the cache */
   /* search125_1 -> 33 in the cache */
   /* search125_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace125_0_0 -> 16 in the cache */
   /* replace125_0_1 -> 36 in the cache */
   /* replace125_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 120 },
      -1,
   } },
   /* replace125_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 337, 133 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search126_0 -> 271 in the cache */
   /* search126_1 -> 33 in the cache */
   /* search126_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 271, 33, 332 },
      -1,
   } },

   /* replace126_0_0 -> 16 in the cache */
   /* replace126_0_1 -> 36 in the cache */
   /* replace126_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 120 },
      -1,
   } },
   /* replace126_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 340, 133 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search127_0 -> 271 in the cache */
   /* search127_1 -> 33 in the cache */
   /* search127_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace127_0_0 -> 16 in the cache */
   /* replace127_0_1 -> 36 in the cache */
   /* replace127_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 120 },
      -1,
   } },
   /* replace127_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 343, 133 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search128_0 -> 271 in the cache */
   /* search128_1 -> 33 in the cache */
   /* search128_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace128_0_0 -> 16 in the cache */
   /* replace128_0_1 -> 36 in the cache */
   /* replace128_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 120 },
      -1,
   } },
   /* replace128_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 346, 133 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search129_0 -> 271 in the cache */
   /* search129_1 -> 33 in the cache */
   /* search129_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace129_0_0 -> 16 in the cache */
   /* replace129_0_1 -> 36 in the cache */
   /* replace129_0_2 -> 120 in the cache */
   /* replace129_0 -> 334 in the cache */
   /* replace129_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 334, 133 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search130_0 -> 271 in the cache */
   /* search130_1 -> 33 in the cache */
   /* search130_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace130_0_0 -> 16 in the cache */
   /* replace130_0_1 -> 36 in the cache */
   /* replace130_0_2 -> 120 in the cache */
   /* replace130_0 -> 337 in the cache */
   /* replace130_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 337, 133 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search131_0 -> 271 in the cache */
   /* search131_1 -> 33 in the cache */
   /* search131_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 271, 33, 332 },
      -1,
   } },

   /* replace131_0_0 -> 16 in the cache */
   /* replace131_0_1 -> 36 in the cache */
   /* replace131_0_2 -> 120 in the cache */
   /* replace131_0 -> 340 in the cache */
   /* replace131_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 340, 133 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search132_0 -> 271 in the cache */
   /* search132_1 -> 33 in the cache */
   /* search132_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace132_0_0 -> 16 in the cache */
   /* replace132_0_1 -> 36 in the cache */
   /* replace132_0_2 -> 120 in the cache */
   /* replace132_0 -> 343 in the cache */
   /* replace132_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 343, 133 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search133_0 -> 271 in the cache */
   /* search133_1 -> 33 in the cache */
   /* search133_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace133_0_0 -> 16 in the cache */
   /* replace133_0_1 -> 36 in the cache */
   /* replace133_0_2 -> 120 in the cache */
   /* replace133_0 -> 346 in the cache */
   /* replace133_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 346, 133 },
      -1,
   } },

   /* ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search134_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 358, 117 },
      -1,
   } },
   /* search134_0_1 -> 117 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 359, 117, 360 },
      -1,
   } },
   /* search134_1_0_0 -> 360 in the cache */
   /* search134_1_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      2, 1,
      { 360, 117 },
      -1,
   } },
   /* search134_1_1 -> 117 in the cache */
   /* search134_1_2 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 362, 117, 358 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 361, 363 },
      -1,
   } },

   /* replace134_0 -> 360 in the cache */
   /* replace134_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 360, 358 },
      -1,
   } },

   /* ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search135_0 -> 16 in the cache */
   /* search135_1_0_0 -> 16 in the cache */
   /* search135_1_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 16, 117 },
      -1,
   } },
   /* search135_1_1 -> 117 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 366, 117, 367 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 16, 368 },
      -1,
   } },

   /* replace135_0 -> 16 in the cache */
   /* replace135_1 -> 36 in the cache */
   /* replace135 -> 254 in the cache */

   /* ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search136_0_0_0 -> 358 in the cache */
   /* search136_0_0_1 -> 117 in the cache */
   /* search136_0_0 -> 359 in the cache */
   /* search136_0_1 -> 117 in the cache */
   /* search136_0_2 -> 360 in the cache */
   /* search136_0 -> 361 in the cache */
   /* search136_1_0_0 -> 360 in the cache */
   /* search136_1_0_1 -> 117 in the cache */
   /* search136_1_0 -> 362 in the cache */
   /* search136_1_1 -> 117 in the cache */
   /* search136_1_2 -> 358 in the cache */
   /* search136_1 -> 363 in the cache */
   /* search136_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 361, 363, 133 },
      -1,
   } },

   /* replace136_0 -> 360 in the cache */
   /* replace136_1 -> 358 in the cache */
   /* replace136_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 360, 358, 133 },
      -1,
   } },

   /* ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search137_0 -> 16 in the cache */
   /* search137_1_0_0 -> 16 in the cache */
   /* search137_1_0_1 -> 117 in the cache */
   /* search137_1_0 -> 366 in the cache */
   /* search137_1_1 -> 117 in the cache */
   /* search137_1_2 -> 367 in the cache */
   /* search137_1 -> 368 in the cache */
   /* search137_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 16, 368, 133 },
      -1,
   } },

   /* replace137_0 -> 16 in the cache */
   /* replace137_1 -> 36 in the cache */
   /* replace137_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search138_0 -> 16 in the cache */
   /* search138_1 -> 36 in the cache */
   /* search138_2 -> 133 in the cache */
   /* search138 -> 316 in the cache */

   /* replace138_0_0_0_0_0 -> 16 in the cache */
   /* replace138_0_0_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   /* replace138_0_0_0_1_0 -> 36 in the cache */
   /* replace138_0_0_0_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 374, 375 },
      -1,
   } },
   /* replace138_0_0_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* replace138_0_0_1_1_0 -> 36 in the cache */
   /* replace138_0_0_1_1_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 377 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 378, 379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 376, 380 },
      -1,
   } },
   /* replace138_0_1_0_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 382 },
      -1,
   } },
   /* replace138_0_1_0_1_0 -> 36 in the cache */
   /* replace138_0_1_0_1_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 382 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 383, 384 },
      -1,
   } },
   /* replace138_0_1_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 386 },
      -1,
   } },
   /* replace138_0_1_1_1_0 -> 36 in the cache */
   /* replace138_0_1_1_1_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 387, 388 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 385, 389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 381, 390 },
      -1,
   } },
   /* replace138_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 391, 133 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search139_0 -> 16 in the cache */
   /* search139_1 -> 36 in the cache */
   /* search139_2 -> 133 in the cache */
   /* search139 -> 319 in the cache */

   /* replace139_0_0_0_0_0 -> 16 in the cache */
   /* replace139_0_0_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   /* replace139_0_0_0_1_0 -> 36 in the cache */
   /* replace139_0_0_0_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 393, 394 },
      -1,
   } },
   /* replace139_0_0_1_0_0 -> 16 in the cache */
   /* replace139_0_0_1_0_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* replace139_0_0_1_1_0 -> 36 in the cache */
   /* replace139_0_0_1_1_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 377 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 396, 397 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 395, 398 },
      -1,
   } },
   /* replace139_0_1_0_0_0 -> 16 in the cache */
   /* replace139_0_1_0_0_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 382 },
      -1,
   } },
   /* replace139_0_1_0_1_0 -> 36 in the cache */
   /* replace139_0_1_0_1_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 382 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 400, 401 },
      -1,
   } },
   /* replace139_0_1_1_0_0 -> 16 in the cache */
   /* replace139_0_1_1_0_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 386 },
      -1,
   } },
   /* replace139_0_1_1_1_0 -> 36 in the cache */
   /* replace139_0_1_1_1_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 403, 404 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 402, 405 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 399, 406 },
      -1,
   } },
   /* replace139_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 407, 133 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search140_0 -> 16 in the cache */
   /* search140_1 -> 36 in the cache */
   /* search140_2 -> 133 in the cache */
   /* search140 -> 322 in the cache */

   /* replace140_0_0_0_0_0 -> 16 in the cache */
   /* replace140_0_0_0_0_1 -> 120 in the cache */
   /* replace140_0_0_0_0 -> 374 in the cache */
   /* replace140_0_0_0_1_0 -> 36 in the cache */
   /* replace140_0_0_0_1_1 -> 120 in the cache */
   /* replace140_0_0_0_1 -> 394 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 374, 394 },
      -1,
   } },
   /* replace140_0_0_1_0_0 -> 16 in the cache */
   /* replace140_0_0_1_0_1 -> 377 in the cache */
   /* replace140_0_0_1_0 -> 378 in the cache */
   /* replace140_0_0_1_1_0 -> 36 in the cache */
   /* replace140_0_0_1_1_1 -> 377 in the cache */
   /* replace140_0_0_1_1 -> 397 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 378, 397 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 409, 410 },
      -1,
   } },
   /* replace140_0_1_0_0_0 -> 16 in the cache */
   /* replace140_0_1_0_0_1 -> 382 in the cache */
   /* replace140_0_1_0_0 -> 383 in the cache */
   /* replace140_0_1_0_1_0 -> 36 in the cache */
   /* replace140_0_1_0_1_1 -> 382 in the cache */
   /* replace140_0_1_0_1 -> 401 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 383, 401 },
      -1,
   } },
   /* replace140_0_1_1_0_0 -> 16 in the cache */
   /* replace140_0_1_1_0_1 -> 386 in the cache */
   /* replace140_0_1_1_0 -> 387 in the cache */
   /* replace140_0_1_1_1_0 -> 36 in the cache */
   /* replace140_0_1_1_1_1 -> 386 in the cache */
   /* replace140_0_1_1_1 -> 404 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 387, 404 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 412, 413 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 411, 414 },
      -1,
   } },
   /* replace140_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 415, 133 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search141_0 -> 16 in the cache */
   /* search141_1 -> 36 in the cache */
   /* search141_2 -> 133 in the cache */
   /* search141 -> 328 in the cache */

   /* replace141_0_0_0_0 -> 16 in the cache */
   /* replace141_0_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   /* replace141_0_0_1_0 -> 36 in the cache */
   /* replace141_0_0_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 417, 418 },
      -1,
   } },
   /* replace141_0_1_0_0 -> 16 in the cache */
   /* replace141_0_1_0_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* replace141_0_1_1_0 -> 36 in the cache */
   /* replace141_0_1_1_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 377 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 420, 421 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 419, 422 },
      -1,
   } },
   /* replace141_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 423, 133 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search142_0 -> 16 in the cache */
   /* search142_1 -> 36 in the cache */
   /* search142_2 -> 133 in the cache */
   /* search142 -> 331 in the cache */

   /* replace142_0_0_0_0 -> 16 in the cache */
   /* replace142_0_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   /* replace142_0_0_1_0 -> 36 in the cache */
   /* replace142_0_0_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 425, 426 },
      -1,
   } },
   /* replace142_0_1_0_0 -> 16 in the cache */
   /* replace142_0_1_0_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* replace142_0_1_1_0 -> 36 in the cache */
   /* replace142_0_1_1_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 377 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 428, 429 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 427, 430 },
      -1,
   } },
   /* replace142_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 431, 133 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search143_0 -> 16 in the cache */
   /* search143_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 433 },
      -1,
   } },

   /* replace143_0 -> 16 in the cache */
   /* replace143_1 -> 36 in the cache */
   /* replace143_2 -> 133 in the cache */
   /* replace143 -> 319 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search144_0 -> 16 in the cache */
   /* search144_1 -> 36 in the cache */
   /* search144_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace144_0_0_0_0_0 -> 16 in the cache */
   /* replace144_0_0_0_0_1 -> 120 in the cache */
   /* replace144_0_0_0_0 -> 393 in the cache */
   /* replace144_0_0_0_1_0 -> 36 in the cache */
   /* replace144_0_0_0_1_1 -> 120 in the cache */
   /* replace144_0_0_0_1 -> 394 in the cache */
   /* replace144_0_0_0 -> 395 in the cache */
   /* replace144_0_0_1_0_0 -> 16 in the cache */
   /* replace144_0_0_1_0_1 -> 377 in the cache */
   /* replace144_0_0_1_0 -> 396 in the cache */
   /* replace144_0_0_1_1_0 -> 36 in the cache */
   /* replace144_0_0_1_1_1 -> 377 in the cache */
   /* replace144_0_0_1_1 -> 397 in the cache */
   /* replace144_0_0_1 -> 398 in the cache */
   /* replace144_0_0 -> 399 in the cache */
   /* replace144_0_1_0_0_0 -> 16 in the cache */
   /* replace144_0_1_0_0_1 -> 382 in the cache */
   /* replace144_0_1_0_0 -> 400 in the cache */
   /* replace144_0_1_0_1_0 -> 36 in the cache */
   /* replace144_0_1_0_1_1 -> 382 in the cache */
   /* replace144_0_1_0_1 -> 401 in the cache */
   /* replace144_0_1_0 -> 402 in the cache */
   /* replace144_0_1_1_0_0 -> 16 in the cache */
   /* replace144_0_1_1_0_1 -> 386 in the cache */
   /* replace144_0_1_1_0 -> 403 in the cache */
   /* replace144_0_1_1_1_0 -> 36 in the cache */
   /* replace144_0_1_1_1_1 -> 386 in the cache */
   /* replace144_0_1_1_1 -> 404 in the cache */
   /* replace144_0_1_1 -> 405 in the cache */
   /* replace144_0_1 -> 406 in the cache */
   /* replace144_0 -> 407 in the cache */
   /* replace144_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 8,
      { 407, 133 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search145_0 -> 16 in the cache */
   /* search145_1 -> 36 in the cache */
   /* search145_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace145_0_0_0_0_0 -> 16 in the cache */
   /* replace145_0_0_0_0_1 -> 120 in the cache */
   /* replace145_0_0_0_0 -> 374 in the cache */
   /* replace145_0_0_0_1_0 -> 36 in the cache */
   /* replace145_0_0_0_1_1 -> 120 in the cache */
   /* replace145_0_0_0_1 -> 375 in the cache */
   /* replace145_0_0_0 -> 376 in the cache */
   /* replace145_0_0_1_0_0 -> 16 in the cache */
   /* replace145_0_0_1_0_1 -> 377 in the cache */
   /* replace145_0_0_1_0 -> 378 in the cache */
   /* replace145_0_0_1_1_0 -> 36 in the cache */
   /* replace145_0_0_1_1_1 -> 377 in the cache */
   /* replace145_0_0_1_1 -> 379 in the cache */
   /* replace145_0_0_1 -> 380 in the cache */
   /* replace145_0_0 -> 381 in the cache */
   /* replace145_0_1_0_0_0 -> 16 in the cache */
   /* replace145_0_1_0_0_1 -> 382 in the cache */
   /* replace145_0_1_0_0 -> 383 in the cache */
   /* replace145_0_1_0_1_0 -> 36 in the cache */
   /* replace145_0_1_0_1_1 -> 382 in the cache */
   /* replace145_0_1_0_1 -> 384 in the cache */
   /* replace145_0_1_0 -> 385 in the cache */
   /* replace145_0_1_1_0_0 -> 16 in the cache */
   /* replace145_0_1_1_0_1 -> 386 in the cache */
   /* replace145_0_1_1_0 -> 387 in the cache */
   /* replace145_0_1_1_1_0 -> 36 in the cache */
   /* replace145_0_1_1_1_1 -> 386 in the cache */
   /* replace145_0_1_1_1 -> 388 in the cache */
   /* replace145_0_1_1 -> 389 in the cache */
   /* replace145_0_1 -> 390 in the cache */
   /* replace145_0 -> 391 in the cache */
   /* replace145_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 8,
      { 391, 133 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search146_0 -> 16 in the cache */
   /* search146_1 -> 36 in the cache */
   /* search146_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 36, 133 },
      -1,
   } },

   /* replace146_0_0_0_0_0 -> 16 in the cache */
   /* replace146_0_0_0_0_1 -> 120 in the cache */
   /* replace146_0_0_0_0 -> 374 in the cache */
   /* replace146_0_0_0_1_0 -> 36 in the cache */
   /* replace146_0_0_0_1_1 -> 120 in the cache */
   /* replace146_0_0_0_1 -> 394 in the cache */
   /* replace146_0_0_0 -> 409 in the cache */
   /* replace146_0_0_1_0_0 -> 16 in the cache */
   /* replace146_0_0_1_0_1 -> 377 in the cache */
   /* replace146_0_0_1_0 -> 378 in the cache */
   /* replace146_0_0_1_1_0 -> 36 in the cache */
   /* replace146_0_0_1_1_1 -> 377 in the cache */
   /* replace146_0_0_1_1 -> 397 in the cache */
   /* replace146_0_0_1 -> 410 in the cache */
   /* replace146_0_0 -> 411 in the cache */
   /* replace146_0_1_0_0_0 -> 16 in the cache */
   /* replace146_0_1_0_0_1 -> 382 in the cache */
   /* replace146_0_1_0_0 -> 383 in the cache */
   /* replace146_0_1_0_1_0 -> 36 in the cache */
   /* replace146_0_1_0_1_1 -> 382 in the cache */
   /* replace146_0_1_0_1 -> 401 in the cache */
   /* replace146_0_1_0 -> 412 in the cache */
   /* replace146_0_1_1_0_0 -> 16 in the cache */
   /* replace146_0_1_1_0_1 -> 386 in the cache */
   /* replace146_0_1_1_0 -> 387 in the cache */
   /* replace146_0_1_1_1_0 -> 36 in the cache */
   /* replace146_0_1_1_1_1 -> 386 in the cache */
   /* replace146_0_1_1_1 -> 404 in the cache */
   /* replace146_0_1_1 -> 413 in the cache */
   /* replace146_0_1 -> 414 in the cache */
   /* replace146_0 -> 415 in the cache */
   /* replace146_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 8,
      { 415, 133 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search147_0 -> 16 in the cache */
   /* search147_1 -> 36 in the cache */
   /* search147_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace147_0_0_0_0 -> 16 in the cache */
   /* replace147_0_0_0_1 -> 120 in the cache */
   /* replace147_0_0_0 -> 425 in the cache */
   /* replace147_0_0_1_0 -> 36 in the cache */
   /* replace147_0_0_1_1 -> 120 in the cache */
   /* replace147_0_0_1 -> 426 in the cache */
   /* replace147_0_0 -> 427 in the cache */
   /* replace147_0_1_0_0 -> 16 in the cache */
   /* replace147_0_1_0_1 -> 377 in the cache */
   /* replace147_0_1_0 -> 428 in the cache */
   /* replace147_0_1_1_0 -> 36 in the cache */
   /* replace147_0_1_1_1 -> 377 in the cache */
   /* replace147_0_1_1 -> 429 in the cache */
   /* replace147_0_1 -> 430 in the cache */
   /* replace147_0 -> 431 in the cache */
   /* replace147_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 4,
      { 431, 133 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search148_0 -> 16 in the cache */
   /* search148_1 -> 36 in the cache */
   /* search148_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace148_0_0_0_0 -> 16 in the cache */
   /* replace148_0_0_0_1 -> 120 in the cache */
   /* replace148_0_0_0 -> 417 in the cache */
   /* replace148_0_0_1_0 -> 36 in the cache */
   /* replace148_0_0_1_1 -> 120 in the cache */
   /* replace148_0_0_1 -> 418 in the cache */
   /* replace148_0_0 -> 419 in the cache */
   /* replace148_0_1_0_0 -> 16 in the cache */
   /* replace148_0_1_0_1 -> 377 in the cache */
   /* replace148_0_1_0 -> 420 in the cache */
   /* replace148_0_1_1_0 -> 36 in the cache */
   /* replace148_0_1_1_1 -> 377 in the cache */
   /* replace148_0_1_1 -> 421 in the cache */
   /* replace148_0_1 -> 422 in the cache */
   /* replace148_0 -> 423 in the cache */
   /* replace148_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 4,
      { 423, 133 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search149_0 -> 11 in the cache */
   /* search149_1 -> 243 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 243, 446 },
      -1,
   } },

   /* replace149_0 -> 445 in the cache */
   /* replace149_1 -> 243 in the cache */
   /* replace149_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 445, 243, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search150_0 -> 11 in the cache */
   /* search150_1_0 -> 11 in the cache */
   /* search150_1_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 243 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 449, 450 },
      -1,
   } },

   /* replace150_0_0 -> 243 in the cache */
   /* replace150_0_1 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 243, 450 },
      -1,
   } },
   /* replace150_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 452, 11 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search151_0_0 -> 11 in the cache */
   /* search151_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 243 },
      0,
   } },
   /* search151_1_0 -> 11 in the cache */
   /* search151_1_1 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 11, 450 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 454, 455, 456 },
      -1,
   } },

   /* replace151_0_0 -> 243 in the cache */
   /* replace151_0_1 -> 450 in the cache */
   /* replace151_0_2 -> 456 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 243, 450, 456 },
      -1,
   } },
   /* replace151_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 458, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search152_0 -> 11 in the cache */
   /* search152_1_0 -> 11 in the cache */
   /* search152_1_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 243 },
      0,
   } },
   /* search152_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 460, 450 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace152_0_1 -> 243 in the cache */
   /* replace152_0_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 462, 243, 450 },
      -1,
   } },
   /* replace152_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 463, 11 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search153_0_0 -> 11 in the cache */
   /* search153_0_1_0 -> 462 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 465 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 462, 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 467 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search153_1_1 -> 465 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 469, 465 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 468, 470 },
      -1,
   } },

   /* replace153_0 -> 11 in the cache */
   /* replace153_1 -> 469 in the cache */
   /* replace153_2 -> 465 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 469, 465 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search154_0_0 -> 11 in the cache */
   /* search154_0_1_0_0 -> 462 in the cache */
   /* search154_0_1_0_1_0 -> 465 in the cache */
   /* search154_0_1_0_1 -> 466 in the cache */
   /* search154_0_1_0 -> 467 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 467 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 473 },
      -1,
   } },
   /* search154_1_0 -> 469 in the cache */
   /* search154_1_1_0 -> 465 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 465 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 469, 475 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 474, 476 },
      -1,
   } },

   /* replace154_0 -> 11 in the cache */
   /* replace154_1 -> 469 in the cache */
   /* replace154_2_0 -> 465 in the cache */
   /* replace154_2 -> 475 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 469, 475 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search155_0 -> 11 in the cache */
   /* search155_1_0 -> 465 in the cache */
   /* search155_1_1_0 -> 469 in the cache */
   /* search155_1_1_1_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 469, 479 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 465, 480 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 481 },
      -1,
   } },

   /* replace155_0 -> 11 in the cache */
   /* replace155_1 -> 469 in the cache */
   /* replace155_2 -> 465 in the cache */
   /* replace155 -> 472 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search156_0_0 -> 11 in the cache */
   /* search156_0_1_0 -> 462 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 462, 485 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 486 },
      -1,
   } },
   /* search156_1_0 -> 469 in the cache */
   /* search156_1_1_0 -> 483 in the cache */
   /* search156_1_1 -> 484 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 469, 484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 487, 488 },
      -1,
   } },

   /* replace156_0 -> 483 in the cache */
   /* replace156_1 -> 469 in the cache */
   /* replace156_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 469, 11 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search157_0 -> 11 in the cache */
   /* search157_1_0_0 -> 483 in the cache */
   /* search157_1_0 -> 484 in the cache */
   /* search157_1_1_0 -> 469 in the cache */
   /* search157_1_1_1_0 -> 11 in the cache */
   /* search157_1_1_1 -> 479 in the cache */
   /* search157_1_1 -> 480 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 484, 480 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 491 },
      -1,
   } },

   /* replace157_0 -> 483 in the cache */
   /* replace157_1 -> 469 in the cache */
   /* replace157_2 -> 11 in the cache */
   /* replace157 -> 490 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search158_0 -> 11 in the cache */
   /* search158_1_0 -> 462 in the cache */
   /* search158_1_1_0_0 -> 483 in the cache */
   /* search158_1_1_0 -> 484 in the cache */
   /* search158_1_1 -> 485 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 462, 485 },
      -1,
   } },
   /* search158_2_0 -> 469 in the cache */
   /* search158_2_1_0 -> 483 in the cache */
   /* search158_2_1 -> 484 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 469, 484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 11, 493, 494 },
      -1,
   } },

   /* replace158_0 -> 483 in the cache */
   /* replace158_1 -> 469 in the cache */
   /* replace158_2 -> 11 in the cache */
   /* replace158 -> 490 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search159_1_0 -> 483 in the cache */
   /* search159_1 -> 484 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 497 },
      -1,
   } },
   /* search159_2_1_0 -> 483 in the cache */
   /* search159_2_1 -> 484 in the cache */
   /* search159_2_2 -> 497 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 498, 484, 497 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 496, 484, 499 },
      -1,
   } },

   /* replace159_0 -> 483 in the cache */
   /* replace159_1 -> 496 in the cache */
   /* replace159_2 -> 497 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 496, 497 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 502 },
      -1,
   } },
   /* search160_1_0 -> 243 in the cache */
   /* search160_1_1_0 -> 497 in the cache */
   /* search160_1_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 243, 498 },
      -1,
   } },
   /* search160_2 -> 497 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 503, 504, 497 },
      -1,
   } },

   /* replace160_0 -> 502 in the cache */
   /* replace160_1 -> 243 in the cache */
   /* replace160_2 -> 497 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 502, 243, 497 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search161_0_0 -> 502 in the cache */
   /* search161_0 -> 503 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 507 },
      -1,
   } },
   /* search161_1_1 -> 469 in the cache */
   /* search161_1_2 -> 456 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 508, 469, 456 },
      -1,
   } },
   /* search161_2_0 -> 507 in the cache */
   /* search161_2_1 -> 469 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 507, 469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 503, 509, 510 },
      -1,
   } },

   /* replace161_0 -> 502 in the cache */
   /* replace161_1 -> 456 in the cache */
   /* replace161_2_0 -> 507 in the cache */
   /* replace161_2_1 -> 469 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 507, 469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 502, 456, 512 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search162_0 -> 462 in the cache */
   /* search162_1_0_0_0 -> 462 in the cache */
   /* search162_1_0_0_1_0 -> 11 in the cache */
   /* search162_1_0_0_1 -> 479 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 462, 479 },
      -1,
   } },
   /* search162_1_0_1_0 -> 462 in the cache */
   /* search162_1_0_1_1_0 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 462, 515 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 514, 516 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 517 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 462, 518 },
      -1,
   } },

   /* replace162_0 -> 243 in the cache */
   /* replace162_1 -> 462 in the cache */
   /* replace162_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 243, 462, 11 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search163_0 -> 16 in the cache */
   /* search163_1 -> 36 in the cache */
   /* search163_2_0 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 36, 521 },
      -1,
   } },

   /* replace163_0 -> 445 in the cache */
   /* replace163_1 -> 36 in the cache */
   /* replace163_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 445, 36, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search164_0 -> 16 in the cache */
   /* search164_1_0 -> 16 in the cache */
   /* search164_1_1 -> 36 in the cache */
   /* search164_1 -> 259 in the cache */
   /* search164_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 259, 133 },
      -1,
   } },

   /* replace164_0_0 -> 36 in the cache */
   /* replace164_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 36, 133 },
      -1,
   } },
   /* replace164_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 525, 16 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search165_0_0 -> 16 in the cache */
   /* search165_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search165_1_0 -> 16 in the cache */
   /* search165_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 16, 133 },
      0,
   } },
   /* search165_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 527, 528, 161 },
      -1,
   } },

   /* replace165_0_0 -> 36 in the cache */
   /* replace165_0_1 -> 133 in the cache */
   /* replace165_0_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 133, 161 },
      -1,
   } },
   /* replace165_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 530, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search166_0 -> 16 in the cache */
   /* search166_1_0 -> 16 in the cache */
   /* search166_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search166_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 532, 133 },
      -1,
   } },

   /* replace166_0_0 -> 228 in the cache */
   /* replace166_0_1 -> 36 in the cache */
   /* replace166_0_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 228, 36, 133 },
      -1,
   } },
   /* replace166_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 534, 16 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search167_0_0 -> 16 in the cache */
   /* search167_0_1_0 -> 228 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 228, 537 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 538 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search167_1_1 -> 536 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 540, 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 539, 541 },
      -1,
   } },

   /* replace167_0 -> 16 in the cache */
   /* replace167_1 -> 540 in the cache */
   /* replace167_2 -> 536 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 540, 536 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search168_0_0 -> 16 in the cache */
   /* search168_0_1_0_0 -> 228 in the cache */
   /* search168_0_1_0_1_0 -> 536 in the cache */
   /* search168_0_1_0_1 -> 537 in the cache */
   /* search168_0_1_0 -> 538 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 538 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 544 },
      -1,
   } },
   /* search168_1_0 -> 540 in the cache */
   /* search168_1_1_0 -> 536 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 540, 546 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 545, 547 },
      -1,
   } },

   /* replace168_0 -> 16 in the cache */
   /* replace168_1 -> 540 in the cache */
   /* replace168_2_0 -> 536 in the cache */
   /* replace168_2 -> 546 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 540, 546 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search169_0 -> 16 in the cache */
   /* search169_1_0 -> 536 in the cache */
   /* search169_1_1_0 -> 540 in the cache */
   /* search169_1_1_1_0 -> 16 in the cache */
   /* search169_1_1_1 -> 265 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 540, 265 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 536, 550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 551 },
      -1,
   } },

   /* replace169_0 -> 16 in the cache */
   /* replace169_1 -> 540 in the cache */
   /* replace169_2 -> 536 in the cache */
   /* replace169 -> 543 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search170_0_0 -> 16 in the cache */
   /* search170_0_1_0 -> 228 in the cache */
   /* search170_0_1_1_0_0 -> 483 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 553 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 228, 554 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 555 },
      -1,
   } },
   /* search170_1_0 -> 540 in the cache */
   /* search170_1_1_0 -> 483 in the cache */
   /* search170_1_1 -> 553 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 540, 553 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 556, 557 },
      -1,
   } },

   /* replace170_0 -> 483 in the cache */
   /* replace170_1 -> 540 in the cache */
   /* replace170_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 540, 16 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search171_0 -> 16 in the cache */
   /* search171_1_0_0 -> 483 in the cache */
   /* search171_1_0 -> 553 in the cache */
   /* search171_1_1_0 -> 540 in the cache */
   /* search171_1_1_1_0 -> 16 in the cache */
   /* search171_1_1_1 -> 265 in the cache */
   /* search171_1_1 -> 550 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 553, 550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 560 },
      -1,
   } },

   /* replace171_0 -> 483 in the cache */
   /* replace171_1 -> 540 in the cache */
   /* replace171_2 -> 16 in the cache */
   /* replace171 -> 559 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search172_0 -> 16 in the cache */
   /* search172_1_0 -> 228 in the cache */
   /* search172_1_1_0_0 -> 483 in the cache */
   /* search172_1_1_0 -> 553 in the cache */
   /* search172_1_1 -> 554 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 228, 554 },
      -1,
   } },
   /* search172_2_0 -> 540 in the cache */
   /* search172_2_1_0 -> 483 in the cache */
   /* search172_2_1 -> 553 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 540, 553 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 16, 562, 563 },
      -1,
   } },

   /* replace172_0 -> 483 in the cache */
   /* replace172_1 -> 540 in the cache */
   /* replace172_2 -> 16 in the cache */
   /* replace172 -> 559 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search173_0 -> 358 in the cache */
   /* search173_1_0 -> 483 in the cache */
   /* search173_1 -> 553 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 565 },
      -1,
   } },
   /* search173_2_1_0 -> 483 in the cache */
   /* search173_2_1 -> 553 in the cache */
   /* search173_2_2 -> 565 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 566, 553, 565 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 358, 553, 567 },
      -1,
   } },

   /* replace173_0 -> 483 in the cache */
   /* replace173_1 -> 358 in the cache */
   /* replace173_2 -> 565 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 358, 565 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search174_0_0 -> 502 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 502 },
      -1,
   } },
   /* search174_1_0 -> 36 in the cache */
   /* search174_1_1_0 -> 565 in the cache */
   /* search174_1_1 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 566 },
      -1,
   } },
   /* search174_2 -> 565 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 570, 571, 565 },
      -1,
   } },

   /* replace174_0 -> 502 in the cache */
   /* replace174_1 -> 36 in the cache */
   /* replace174_2 -> 565 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 502, 36, 565 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search175_0_0 -> 502 in the cache */
   /* search175_0 -> 570 in the cache */
   /* search175_1_0_0 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 360 },
      -1,
   } },
   /* search175_1_1 -> 540 in the cache */
   /* search175_1_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 574, 540, 161 },
      -1,
   } },
   /* search175_2_0 -> 360 in the cache */
   /* search175_2_1 -> 540 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 360, 540 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 570, 575, 576 },
      -1,
   } },

   /* replace175_0 -> 502 in the cache */
   /* replace175_1 -> 161 in the cache */
   /* replace175_2_0 -> 360 in the cache */
   /* replace175_2_1 -> 540 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 360, 540 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 502, 161, 578 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search176_0 -> 228 in the cache */
   /* search176_1_0_0_0 -> 228 in the cache */
   /* search176_1_0_0_1_0 -> 16 in the cache */
   /* search176_1_0_0_1 -> 265 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 228, 265 },
      -1,
   } },
   /* search176_1_0_1_0 -> 228 in the cache */
   /* search176_1_0_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 228, 581 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 580, 582 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 583 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 228, 584 },
      -1,
   } },

   /* replace176_0 -> 36 in the cache */
   /* replace176_1 -> 228 in the cache */
   /* replace176_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 228, 16 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search177_0 -> 21 in the cache */
   /* search177_1 -> 41 in the cache */
   /* search177_2_0 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 41, 587 },
      -1,
   } },

   /* replace177_0 -> 445 in the cache */
   /* replace177_1 -> 41 in the cache */
   /* replace177_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 445, 41, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search178_0 -> 21 in the cache */
   /* search178_1_0 -> 21 in the cache */
   /* search178_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 590, 591 },
      -1,
   } },

   /* replace178_0_0 -> 41 in the cache */
   /* replace178_0_1 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 41, 591 },
      -1,
   } },
   /* replace178_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 593, 21 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search179_0_0 -> 21 in the cache */
   /* search179_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search179_1_0 -> 21 in the cache */
   /* search179_1_1 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 21, 591 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 595, 596, 597 },
      -1,
   } },

   /* replace179_0_0 -> 41 in the cache */
   /* replace179_0_1 -> 591 in the cache */
   /* replace179_0_2 -> 597 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 591, 597 },
      -1,
   } },
   /* replace179_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 599, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search180_0 -> 21 in the cache */
   /* search180_1_0 -> 21 in the cache */
   /* search180_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search180_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 601, 591 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace180_0_1 -> 41 in the cache */
   /* replace180_0_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 603, 41, 591 },
      -1,
   } },
   /* replace180_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 604, 21 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search181_0_0 -> 21 in the cache */
   /* search181_0_1_0 -> 603 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 603, 607 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 608 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search181_1_1 -> 606 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 610, 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 609, 611 },
      -1,
   } },

   /* replace181_0 -> 21 in the cache */
   /* replace181_1 -> 610 in the cache */
   /* replace181_2 -> 606 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 610, 606 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search182_0_0 -> 21 in the cache */
   /* search182_0_1_0_0 -> 603 in the cache */
   /* search182_0_1_0_1_0 -> 606 in the cache */
   /* search182_0_1_0_1 -> 607 in the cache */
   /* search182_0_1_0 -> 608 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 608 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 614 },
      -1,
   } },
   /* search182_1_0 -> 610 in the cache */
   /* search182_1_1_0 -> 606 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 610, 616 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 615, 617 },
      -1,
   } },

   /* replace182_0 -> 21 in the cache */
   /* replace182_1 -> 610 in the cache */
   /* replace182_2_0 -> 606 in the cache */
   /* replace182_2 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 610, 616 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search183_0 -> 21 in the cache */
   /* search183_1_0 -> 606 in the cache */
   /* search183_1_1_0 -> 610 in the cache */
   /* search183_1_1_1_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 610, 620 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 606, 621 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 622 },
      -1,
   } },

   /* replace183_0 -> 21 in the cache */
   /* replace183_1 -> 610 in the cache */
   /* replace183_2 -> 606 in the cache */
   /* replace183 -> 613 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search184_0_0 -> 21 in the cache */
   /* search184_0_1_0 -> 603 in the cache */
   /* search184_0_1_1_0_0 -> 483 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 603, 625 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 626 },
      -1,
   } },
   /* search184_1_0 -> 610 in the cache */
   /* search184_1_1_0 -> 483 in the cache */
   /* search184_1_1 -> 624 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 610, 624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 627, 628 },
      -1,
   } },

   /* replace184_0 -> 483 in the cache */
   /* replace184_1 -> 610 in the cache */
   /* replace184_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 610, 21 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search185_0 -> 21 in the cache */
   /* search185_1_0_0 -> 483 in the cache */
   /* search185_1_0 -> 624 in the cache */
   /* search185_1_1_0 -> 610 in the cache */
   /* search185_1_1_1_0 -> 21 in the cache */
   /* search185_1_1_1 -> 620 in the cache */
   /* search185_1_1 -> 621 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 624, 621 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 631 },
      -1,
   } },

   /* replace185_0 -> 483 in the cache */
   /* replace185_1 -> 610 in the cache */
   /* replace185_2 -> 21 in the cache */
   /* replace185 -> 630 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search186_0 -> 21 in the cache */
   /* search186_1_0 -> 603 in the cache */
   /* search186_1_1_0_0 -> 483 in the cache */
   /* search186_1_1_0 -> 624 in the cache */
   /* search186_1_1 -> 625 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 603, 625 },
      -1,
   } },
   /* search186_2_0 -> 610 in the cache */
   /* search186_2_1_0 -> 483 in the cache */
   /* search186_2_1 -> 624 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 610, 624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 21, 633, 634 },
      -1,
   } },

   /* replace186_0 -> 483 in the cache */
   /* replace186_1 -> 610 in the cache */
   /* replace186_2 -> 21 in the cache */
   /* replace186 -> 630 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search187_1_0 -> 483 in the cache */
   /* search187_1 -> 624 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 637 },
      -1,
   } },
   /* search187_2_1_0 -> 483 in the cache */
   /* search187_2_1 -> 624 in the cache */
   /* search187_2_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 638, 624, 637 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 636, 624, 639 },
      -1,
   } },

   /* replace187_0 -> 483 in the cache */
   /* replace187_1 -> 636 in the cache */
   /* replace187_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 636, 637 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search188_0_0 -> 502 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 502 },
      -1,
   } },
   /* search188_1_0 -> 41 in the cache */
   /* search188_1_1_0 -> 637 in the cache */
   /* search188_1_1 -> 638 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 41, 638 },
      -1,
   } },
   /* search188_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 642, 643, 637 },
      -1,
   } },

   /* replace188_0 -> 502 in the cache */
   /* replace188_1 -> 41 in the cache */
   /* replace188_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 502, 41, 637 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search189_0_0 -> 502 in the cache */
   /* search189_0 -> 642 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 646 },
      -1,
   } },
   /* search189_1_1 -> 610 in the cache */
   /* search189_1_2 -> 597 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 647, 610, 597 },
      -1,
   } },
   /* search189_2_0 -> 646 in the cache */
   /* search189_2_1 -> 610 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 646, 610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 642, 648, 649 },
      -1,
   } },

   /* replace189_0 -> 502 in the cache */
   /* replace189_1 -> 597 in the cache */
   /* replace189_2_0 -> 646 in the cache */
   /* replace189_2_1 -> 610 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 646, 610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 502, 597, 651 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search190_0 -> 603 in the cache */
   /* search190_1_0_0_0 -> 603 in the cache */
   /* search190_1_0_0_1_0 -> 21 in the cache */
   /* search190_1_0_0_1 -> 620 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 603, 620 },
      -1,
   } },
   /* search190_1_0_1_0 -> 603 in the cache */
   /* search190_1_0_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 603, 654 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 653, 655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 656 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 603, 657 },
      -1,
   } },

   /* replace190_0 -> 41 in the cache */
   /* replace190_1 -> 603 in the cache */
   /* replace190_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 603, 21 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search191_0_0 -> 147 in the cache */
   /* search191_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 147, 148 },
      0,
   } },
   /* search191_1_0 -> 147 in the cache */
   /* search191_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 147, 150 },
      0,
   } },
   /* search191_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 660, 661, 151 },
      -1,
   } },

   /* replace191_0_0 -> 148 in the cache */
   /* replace191_0_1 -> 150 in the cache */
   /* replace191_0_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 148, 150, 151 },
      -1,
   } },
   /* replace191_1 -> 147 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 663, 147 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search192_0 -> 0 in the cache */
   /* search192_1 -> 241 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 241, 665 },
      -1,
   } },

   /* replace192_0_0_0 -> 0 in the cache */
   /* replace192_0_0 -> 197 in the cache */
   /* replace192_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 197, 665 },
      -1,
   } },
   /* replace192_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 667, 0 },
      -1,
   } },

   /* ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search193_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace193_0_0 -> 32 in the cache */
   /* replace193_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 113 },
      -1,
   } },
   /* replace193_1_0_0_0 -> 32 in the cache */
   /* replace193_1_0_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 103 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 671 },
      -1,
   } },
   /* replace193_2_0_0 -> 32 in the cache */
   /* replace193_2_0 -> 103 in the cache */
   /* replace193_2 -> 671 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 670, 672, 671 },
      -1,
   } },

   /* ('fround_even', 'a') => ('bcsel', ('feq', ('ffract', 'a'), 0.5), ('fadd', ('ffloor', ('fadd', 'a', 0.5)), 1.0), ('ffloor', ('fadd', 'a', 0.5))) */
   /* search194_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fround_even,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace194_0_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 32 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 675, 676 },
      -1,
   } },
   /* replace194_1_0_0_0 -> 32 in the cache */
   /* replace194_1_0_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 32, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 1,
      { 678 },
      -1,
   } },
   /* replace194_1_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 679, 226 },
      -1,
   } },
   /* replace194_2_0_0 -> 32 in the cache */
   /* replace194_2_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 32, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 1,
      { 681 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 677, 680, 682 },
      -1,
   } },

   /* ('ffloor', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search195_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace195_0 -> 32 in the cache */
   /* replace195_1_0 -> 32 in the cache */
   /* replace195_1 -> 675 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 32, 675 },
      -1,
   } },

   /* ('fadd', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search196_0 -> 32 in the cache */
   /* search196_1_0_0 -> 32 in the cache */
   /* search196_1_0 -> 675 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 32, 686 },
      -1,
   } },

   /* replace196_0 -> 32 in the cache */
   /* replace196 -> 684 in the cache */

   /* ('ffract', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search197_0 -> 32 in the cache */
   /* search197 -> 675 in the cache */

   /* replace197_0 -> 32 in the cache */
   /* replace197_1_0 -> 32 in the cache */
   /* replace197_1 -> 684 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 32, 684 },
      -1,
   } },

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search198_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fceil,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace198_0_0_0 -> 32 in the cache */
   /* replace198_0_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 690 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search199_0 -> 11 in the cache */
   /* search199_1 -> 243 in the cache */
   /* search199_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 243, 450 },
      -1,
   } },

   /* replace199_0_0 -> 11 in the cache */
   /* replace199_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 11, 243 },
      -1,
   } },
   /* replace199_1 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 693, 450 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search200_0 -> 16 in the cache */
   /* search200_1 -> 36 in the cache */
   /* search200_2 -> 133 in the cache */
   /* search200 -> 219 in the cache */

   /* replace200_0_0 -> 16 in the cache */
   /* replace200_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace200_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 695, 133 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search201_0 -> 21 in the cache */
   /* search201_1 -> 41 in the cache */
   /* search201_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 591 },
      -1,
   } },

   /* replace201_0_0 -> 21 in the cache */
   /* replace201_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace201_1 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 698, 591 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search202_0 -> 16 in the cache */
   /* search202_1 -> 36 in the cache */
   /* search202_2 -> 133 in the cache */
   /* search202 -> 373 in the cache */

   /* replace202_0_0 -> 16 in the cache */
   /* replace202_0_1 -> 36 in the cache */
   /* replace202_0 -> 132 in the cache */
   /* replace202_1 -> 133 in the cache */
   /* replace202 -> 273 in the cache */

   /* ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search203_0 -> 11 in the cache */
   /* search203_1 -> 243 in the cache */
   /* search203_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 243, 450 },
      -1,
   } },

   /* replace203_0_0 -> 11 in the cache */
   /* replace203_0_1 -> 243 in the cache */
   /* replace203_0 -> 693 in the cache */
   /* replace203_1 -> 450 in the cache */
   /* replace203 -> 694 in the cache */

   /* ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search204_0 -> 16 in the cache */
   /* search204_1 -> 36 in the cache */
   /* search204_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace204_0_0 -> 16 in the cache */
   /* replace204_0_1 -> 36 in the cache */
   /* replace204_0 -> 695 in the cache */
   /* replace204_1 -> 133 in the cache */
   /* replace204 -> 696 in the cache */

   /* ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search205_0 -> 21 in the cache */
   /* search205_1 -> 41 in the cache */
   /* search205_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 591 },
      -1,
   } },

   /* replace205_0_0 -> 21 in the cache */
   /* replace205_0_1 -> 41 in the cache */
   /* replace205_0 -> 698 in the cache */
   /* replace205_1 -> 591 in the cache */
   /* replace205 -> 699 in the cache */

   /* ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search206_0 -> 16 in the cache */
   /* search206_1 -> 36 in the cache */
   /* search206_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace206_0_0 -> 16 in the cache */
   /* replace206_0_1 -> 36 in the cache */
   /* replace206_0 -> 132 in the cache */
   /* replace206_1 -> 133 in the cache */
   /* replace206 -> 273 in the cache */

   /* ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 704 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 705 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 707, 708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_iand,
      2, 2,
      { 706, 709 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 3,
      { 710, 711 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 4,
      { 712, 713 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace207_1_0_0_0 -> 707 in the cache */
   /* replace207_1_0_0_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 707, 708 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 716, 717 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 718, 719 },
      -1,
   } },
   /* replace207_2_0 -> 717 in the cache */
   /* replace207_2_1 -> 719 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 717, 719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 715, 720, 721 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search208_0 -> 0 in the cache */
   /* search208_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace208_0_3 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 724, 725, 726, 255 },
      -1,
   } },
   /* replace208_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 727, 3 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search209_0_0 -> 147 in the cache */
   /* search209_0_1 -> 148 in the cache */
   /* search209_0_2 -> 150 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 147, 148, 150, 729 },
      -1,
   } },
   /* search209_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 730, 151 },
      -1,
   } },

   /* replace209_0_0 -> 147 in the cache */
   /* replace209_0_1 -> 148 in the cache */
   /* replace209_0_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 147, 148, 150 },
      -1,
   } },
   /* replace209_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 732, 151 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search210_0_0 -> 0 in the cache */
   /* search210_0_1 -> 241 in the cache */
   /* search210_0_2 -> 241 in the cache */
   /* search210_0_3 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 0, 241, 241, 241 },
      -1,
   } },
   /* search210_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 734, 3 },
      -1,
   } },

   /* replace210_0 -> 0 in the cache */
   /* replace210_1 -> 3 in the cache */
   /* replace210 -> 249 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search211_0_0 -> 124 in the cache */
   /* search211_0_1 -> 125 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search211_0_3 -> 736 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 124, 125, 736, 736 },
      -1,
   } },
   /* search211_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 737, 127 },
      -1,
   } },

   /* replace211_0_0 -> 124 in the cache */
   /* replace211_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace211_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 739, 127 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search212_0_0 -> 147 in the cache */
   /* search212_0_1 -> 148 in the cache */
   /* search212_0_2 -> 150 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 147, 148, 150, 741 },
      -1,
   } },
   /* search212_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 742, 151 },
      -1,
   } },

   /* replace212_0_0 -> 147 in the cache */
   /* replace212_0_1 -> 148 in the cache */
   /* replace212_0_2 -> 150 in the cache */
   /* replace212_0 -> 732 in the cache */
   /* replace212_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 732, 151 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search213_0_0 -> 0 in the cache */
   /* search213_0_1 -> 241 in the cache */
   /* search213_0_2 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 0, 241, 241 },
      -1,
   } },
   /* search213_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 745, 3 },
      -1,
   } },

   /* replace213_0 -> 0 in the cache */
   /* replace213_1 -> 3 in the cache */
   /* replace213 -> 249 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search214_0_0 -> 124 in the cache */
   /* search214_0_1 -> 125 in the cache */
   /* search214_0_2 -> 736 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 124, 125, 736 },
      -1,
   } },
   /* search214_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 747, 127 },
      -1,
   } },

   /* replace214_0_0 -> 124 in the cache */
   /* replace214_0_1 -> 125 in the cache */
   /* replace214_0 -> 739 in the cache */
   /* replace214_1 -> 127 in the cache */
   /* replace214 -> 740 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search215_0_0 -> 0 in the cache */
   /* search215_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 0, 241 },
      -1,
   } },
   /* search215_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 749, 3 },
      -1,
   } },

   /* replace215_0 -> 0 in the cache */
   /* replace215_1 -> 3 in the cache */
   /* replace215 -> 249 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search216_0 -> 32 in the cache */
   /* search216_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 32, 226 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      -1, 0,
      { 752, 753 },
      -1,
   } },

   /* ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b')) */
   /* search217_0 -> 0 in the cache */
   /* search217_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace217_0_0 -> 0 in the cache */
   /* replace217_0_1 -> 3 in the cache */
   /* replace217_0 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 1,
      { 249 },
      -1,
   } },

   /* ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b')) */
   /* search218_0 -> 0 in the cache */
   /* search218_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace218_0_0 -> 0 in the cache */
   /* replace218_0_1 -> 3 in the cache */
   /* replace218_0 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum3,
      -1, 1,
      { 249 },
      -1,
   } },

   /* ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b')) */
   /* search219_0 -> 0 in the cache */
   /* search219_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace219_0_0 -> 0 in the cache */
   /* replace219_0_1 -> 3 in the cache */
   /* replace219_0 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum4,
      -1, 1,
      { 249 },
      -1,
   } },

   /* ('fsum2', 'a') => ('fadd', 'a.x', 'a.y') */
   /* search220_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace220_0 -> 752 in the cache */
   /* replace220_1 -> 753 in the cache */
   /* replace220 -> 754 in the cache */

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 762 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 763 },
      0,
   } },
   /* search221_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 764, 226 },
      -1,
   } },

   /* replace221_0_0 -> 226 in the cache */
   /* replace221_0_1_0 -> 32 in the cache */
   /* replace221_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 226, 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 766 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search222_0_0_0 -> 124 in the cache */
   /* search222_0_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 124, 268 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 768, 769 },
      -1,
   } },
   /* search222_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 770, 296 },
      -1,
   } },

   /* replace222_0_0 -> 124 in the cache */
   /* replace222_0_1_0 -> 125 in the cache */
   /* replace222_0_1_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 125, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 124, 772 },
      -1,
   } },
   /* replace222_1_0 -> 127 in the cache */
   /* replace222_1_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 127, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 773, 774 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search223_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 776 },
      -1,
   } },
   /* search223_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 777, 294 },
      -1,
   } },

   /* replace223_0 -> 0 in the cache */
   /* replace223_1_0 -> 3 in the cache */
   /* replace223_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 3, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 779 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search224_0_0 -> 6 in the cache */
   /* search224_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search224_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 781, 294 },
      -1,
   } },

   /* replace224_0_0_0_0 -> 36 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 783 },
      -1,
   } },
   /* replace224_0_0_1_0 -> 133 in the cache */
   /* replace224_0_0_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 133, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 784, 785 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8 /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 786, 787 },
      -1,
   } },
   /* replace224_1_0 -> 6 in the cache */
   /* replace224_1_1_0 -> 36 in the cache */
   /* replace224_1_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      3, 1,
      { 36, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 789 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 788, 790, 791 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search225_0_0 -> 6 in the cache */
   /* search225_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search225_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 793, 294 },
      -1,
   } },

   /* replace225_0_0_0_0 -> 36 in the cache */
   /* replace225_0_0_0_1 -> 783 in the cache */
   /* replace225_0_0_0 -> 784 in the cache */
   /* replace225_0_0_1_0 -> 133 in the cache */
   /* replace225_0_0_1_1 -> 783 in the cache */
   /* replace225_0_0_1 -> 785 in the cache */
   /* replace225_0_0 -> 786 in the cache */
   /* replace225_0_1 -> 787 in the cache */
   /* replace225_0 -> 788 in the cache */
   /* replace225_1_0 -> 6 in the cache */
   /* replace225_1_1_0 -> 36 in the cache */
   /* replace225_1_1_1 -> 133 in the cache */
   /* replace225_1_1 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 789 },
      -1,
   } },
   /* replace225_2 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 788, 795, 791 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 7)) */
   /* search226_0_0 -> 6 in the cache */
   /* search226_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search226_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 797, 294 },
      -1,
   } },

   /* replace226_0 -> 6 in the cache */
   /* replace226_1_0_0_0 -> 36 in the cache */
   /* replace226_1_0_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 783 },
      -1,
   } },
   /* replace226_1_0_1_0 -> 133 in the cache */
   /* replace226_1_0_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 133, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 799, 800 },
      -1,
   } },
   /* replace226_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 801, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 6, 802 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search227_0_0 -> 11 in the cache */
   /* search227_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search227_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 804, 294 },
      -1,
   } },

   /* replace227_0_0_0_0 -> 36 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 806 },
      -1,
   } },
   /* replace227_0_0_1_0 -> 133 in the cache */
   /* replace227_0_0_1_1 -> 806 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 133, 806 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 807, 808 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10 /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 809, 810 },
      -1,
   } },
   /* replace227_1_0 -> 11 in the cache */
   /* replace227_1_1_0 -> 36 in the cache */
   /* replace227_1_1_1 -> 133 in the cache */
   /* replace227_1_1 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 789 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 811, 812, 813 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search228_0_0 -> 11 in the cache */
   /* search228_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search228_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 815, 294 },
      -1,
   } },

   /* replace228_0_0_0_0 -> 36 in the cache */
   /* replace228_0_0_0_1 -> 806 in the cache */
   /* replace228_0_0_0 -> 807 in the cache */
   /* replace228_0_0_1_0 -> 133 in the cache */
   /* replace228_0_0_1_1 -> 806 in the cache */
   /* replace228_0_0_1 -> 808 in the cache */
   /* replace228_0_0 -> 809 in the cache */
   /* replace228_0_1 -> 810 in the cache */
   /* replace228_0 -> 811 in the cache */
   /* replace228_1_0 -> 11 in the cache */
   /* replace228_1_1_0 -> 36 in the cache */
   /* replace228_1_1_1 -> 133 in the cache */
   /* replace228_1_1 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 789 },
      -1,
   } },
   /* replace228_2 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 811, 817, 813 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 15)) */
   /* search229_0_0 -> 11 in the cache */
   /* search229_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search229_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 819, 294 },
      -1,
   } },

   /* replace229_0 -> 11 in the cache */
   /* replace229_1_0_0_0 -> 36 in the cache */
   /* replace229_1_0_0_1 -> 806 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 806 },
      -1,
   } },
   /* replace229_1_0_1_0 -> 133 in the cache */
   /* replace229_1_0_1_1 -> 806 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 133, 806 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 821, 822 },
      -1,
   } },
   /* replace229_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 823, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 11, 824 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search230_0_0 -> 16 in the cache */
   /* search230_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search230_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 826, 294 },
      -1,
   } },

   /* replace230_0_0_0_0 -> 36 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffff /* 4294967295 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 828 },
      -1,
   } },
   /* replace230_0_0_1_0 -> 133 in the cache */
   /* replace230_0_0_1_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 133, 828 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 829, 830 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20 /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 831, 832 },
      -1,
   } },
   /* replace230_1_0 -> 16 in the cache */
   /* replace230_1_1_0 -> 36 in the cache */
   /* replace230_1_1_1 -> 133 in the cache */
   /* replace230_1_1 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 789 },
      -1,
   } },
   /* replace230_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 833, 834, 120 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search231_0_0 -> 16 in the cache */
   /* search231_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search231_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 836, 294 },
      -1,
   } },

   /* replace231_0_0_0_0 -> 36 in the cache */
   /* replace231_0_0_0_1 -> 828 in the cache */
   /* replace231_0_0_0 -> 829 in the cache */
   /* replace231_0_0_1_0 -> 133 in the cache */
   /* replace231_0_0_1_1 -> 828 in the cache */
   /* replace231_0_0_1 -> 830 in the cache */
   /* replace231_0_0 -> 831 in the cache */
   /* replace231_0_1 -> 832 in the cache */
   /* replace231_0 -> 833 in the cache */
   /* replace231_1_0 -> 16 in the cache */
   /* replace231_1_1_0 -> 36 in the cache */
   /* replace231_1_1_1 -> 133 in the cache */
   /* replace231_1_1 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 789 },
      -1,
   } },
   /* replace231_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 833, 838, 120 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 31)) */
   /* search232_0_0 -> 16 in the cache */
   /* search232_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search232_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 840, 294 },
      -1,
   } },

   /* replace232_0 -> 16 in the cache */
   /* replace232_1_0_0_0 -> 36 in the cache */
   /* replace232_1_0_0_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 828 },
      -1,
   } },
   /* replace232_1_0_1_0 -> 133 in the cache */
   /* replace232_1_0_1_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 133, 828 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 842, 843 },
      -1,
   } },
   /* replace232_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 844, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 16, 845 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search233_0_0 -> 21 in the cache */
   /* search233_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search233_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 847, 294 },
      -1,
   } },

   /* replace233_0_0_0_0 -> 36 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 849 },
      -1,
   } },
   /* replace233_0_0_1_0 -> 133 in the cache */
   /* replace233_0_0_1_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 133, 849 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 850, 851 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40 /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 852, 853 },
      -1,
   } },
   /* replace233_1_0 -> 21 in the cache */
   /* replace233_1_1_0 -> 36 in the cache */
   /* replace233_1_1_1 -> 133 in the cache */
   /* replace233_1_1 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 789 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 854, 855, 856 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search234_0_0 -> 21 in the cache */
   /* search234_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search234_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 858, 294 },
      -1,
   } },

   /* replace234_0_0_0_0 -> 36 in the cache */
   /* replace234_0_0_0_1 -> 849 in the cache */
   /* replace234_0_0_0 -> 850 in the cache */
   /* replace234_0_0_1_0 -> 133 in the cache */
   /* replace234_0_0_1_1 -> 849 in the cache */
   /* replace234_0_0_1 -> 851 in the cache */
   /* replace234_0_0 -> 852 in the cache */
   /* replace234_0_1 -> 853 in the cache */
   /* replace234_0 -> 854 in the cache */
   /* replace234_1_0 -> 21 in the cache */
   /* replace234_1_1_0 -> 36 in the cache */
   /* replace234_1_1_1 -> 133 in the cache */
   /* replace234_1_1 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 789 },
      -1,
   } },
   /* replace234_2 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 854, 860, 856 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 63)) */
   /* search235_0_0 -> 21 in the cache */
   /* search235_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search235_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 862, 294 },
      -1,
   } },

   /* replace235_0 -> 21 in the cache */
   /* replace235_1_0_0_0 -> 36 in the cache */
   /* replace235_1_0_0_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 849 },
      -1,
   } },
   /* replace235_1_0_1_0 -> 133 in the cache */
   /* replace235_1_0_1_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 133, 849 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 864, 865 },
      -1,
   } },
   /* replace235_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 866, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 21, 867 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search236_0_0 -> 6 in the cache */
   /* search236_0_1 -> 33 in the cache */
   /* search236_0 -> 793 in the cache */
   /* search236_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 793, 36 },
      -1,
   } },

   /* replace236_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   /* replace236_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 870, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 871 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search237_0_0 -> 6 in the cache */
   /* search237_0_1 -> 33 in the cache */
   /* search237_0 -> 797 in the cache */
   /* search237_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 797, 36 },
      -1,
   } },

   /* replace237_0 -> 6 in the cache */
   /* replace237_1_0 -> 870 in the cache */
   /* replace237_1_1 -> 36 in the cache */
   /* replace237_1 -> 871 in the cache */
   /* replace237 -> 872 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search238_0_0 -> 6 in the cache */
   /* search238_0_1 -> 33 in the cache */
   /* search238_0 -> 781 in the cache */
   /* search238_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 781, 36 },
      -1,
   } },

   /* replace238_0 -> 6 in the cache */
   /* replace238_1_0 -> 870 in the cache */
   /* replace238_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 870, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 875 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search239_0_0 -> 11 in the cache */
   /* search239_0_1 -> 33 in the cache */
   /* search239_0 -> 815 in the cache */
   /* search239_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 815, 36 },
      -1,
   } },

   /* replace239_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   /* replace239_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 878, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 879 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search240_0_0 -> 11 in the cache */
   /* search240_0_1 -> 33 in the cache */
   /* search240_0 -> 819 in the cache */
   /* search240_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 819, 36 },
      -1,
   } },

   /* replace240_0 -> 11 in the cache */
   /* replace240_1_0 -> 878 in the cache */
   /* replace240_1_1 -> 36 in the cache */
   /* replace240_1 -> 879 in the cache */
   /* replace240 -> 880 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search241_0_0 -> 11 in the cache */
   /* search241_0_1 -> 33 in the cache */
   /* search241_0 -> 804 in the cache */
   /* search241_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 804, 36 },
      -1,
   } },

   /* replace241_0 -> 11 in the cache */
   /* replace241_1_0 -> 878 in the cache */
   /* replace241_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 878, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 883 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search242_0_0 -> 16 in the cache */
   /* search242_0_1 -> 33 in the cache */
   /* search242_0 -> 836 in the cache */
   /* search242_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 836, 36 },
      -1,
   } },

   /* replace242_0 -> 16 in the cache */
   /* replace242_1_0 -> 828 in the cache */
   /* replace242_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 828, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 886 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search243_0_0 -> 16 in the cache */
   /* search243_0_1 -> 33 in the cache */
   /* search243_0 -> 840 in the cache */
   /* search243_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 840, 36 },
      -1,
   } },

   /* replace243_0 -> 16 in the cache */
   /* replace243_1_0 -> 828 in the cache */
   /* replace243_1_1 -> 36 in the cache */
   /* replace243_1 -> 886 in the cache */
   /* replace243 -> 887 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search244_0_0 -> 16 in the cache */
   /* search244_0_1 -> 33 in the cache */
   /* search244_0 -> 826 in the cache */
   /* search244_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 826, 36 },
      -1,
   } },

   /* replace244_0 -> 16 in the cache */
   /* replace244_1_0 -> 828 in the cache */
   /* replace244_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 828, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 890 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search245_0_0 -> 21 in the cache */
   /* search245_0_1 -> 33 in the cache */
   /* search245_0 -> 858 in the cache */
   /* search245_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 858, 36 },
      -1,
   } },

   /* replace245_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
   } },
   /* replace245_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 893, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 894 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search246_0_0 -> 21 in the cache */
   /* search246_0_1 -> 33 in the cache */
   /* search246_0 -> 862 in the cache */
   /* search246_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 862, 36 },
      -1,
   } },

   /* replace246_0 -> 21 in the cache */
   /* replace246_1_0 -> 893 in the cache */
   /* replace246_1_1 -> 36 in the cache */
   /* replace246_1 -> 894 in the cache */
   /* replace246 -> 895 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search247_0_0 -> 21 in the cache */
   /* search247_0_1 -> 33 in the cache */
   /* search247_0 -> 847 in the cache */
   /* search247_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 847, 36 },
      -1,
   } },

   /* replace247_0 -> 21 in the cache */
   /* replace247_1_0 -> 893 in the cache */
   /* replace247_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 893, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 898 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b') */
   /* search248_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 900 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 901, 902 },
      -1,
   } },

   /* replace248_0 -> 16 in the cache */
   /* replace248_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b') */
   /* search249_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 0, 905 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 906, 907 },
      -1,
   } },

   /* replace249_0 -> 0 in the cache */
   /* replace249_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search250_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 910 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffe /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 911, 912 },
      -1,
   } },

   /* replace250_0_0 -> 16 in the cache */
   /* replace250_0_1 -> 912 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 912 },
      -1,
   } },
   /* replace250_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 914, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search251_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 916 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffc /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 917, 918 },
      -1,
   } },

   /* replace251_0_0 -> 16 in the cache */
   /* replace251_0_1 -> 918 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 918 },
      -1,
   } },
   /* replace251_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 920, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search252_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 922 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8 /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 923, 924 },
      -1,
   } },

   /* replace252_0_0 -> 16 in the cache */
   /* replace252_0_1 -> 924 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 924 },
      -1,
   } },
   /* replace252_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 926, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search253_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 928 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0 /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 929, 930 },
      -1,
   } },

   /* replace253_0_0 -> 16 in the cache */
   /* replace253_0_1 -> 930 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 930 },
      -1,
   } },
   /* replace253_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 932, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search254_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 934 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0 /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 935, 936 },
      -1,
   } },

   /* replace254_0_0 -> 16 in the cache */
   /* replace254_0_1 -> 936 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 936 },
      -1,
   } },
   /* replace254_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 938, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search255_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 940 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0 /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 941, 942 },
      -1,
   } },

   /* replace255_0_0 -> 16 in the cache */
   /* replace255_0_1 -> 942 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 942 },
      -1,
   } },
   /* replace255_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 944, 36 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search256_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffff /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 946 },
      -1,
   } },
   /* search256_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 947, 377 },
      -1,
   } },

   /* replace256_0 -> 16 in the cache */
   /* replace256_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 377 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search257_0_0 -> 16 in the cache */
   /* search257_0_1 -> 377 in the cache */
   /* search257_0 -> 949 in the cache */
   /* search257_1 -> 912 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 949, 912 },
      -1,
   } },

   /* replace257_0 -> 16 in the cache */
   /* replace257_1 -> 377 in the cache */
   /* replace257 -> 949 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search258_0_0 -> 16 in the cache */
   /* search258_0_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* search258_1 -> 946 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 951, 946 },
      -1,
   } },

   /* replace258_0 -> 16 in the cache */
   /* replace258_1 -> 377 in the cache */
   /* replace258 -> 951 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search259_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffff /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 953 },
      -1,
   } },
   /* search259_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 954, 382 },
      -1,
   } },

   /* replace259_0 -> 16 in the cache */
   /* replace259_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 382 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search260_0_0 -> 16 in the cache */
   /* search260_0_1 -> 382 in the cache */
   /* search260_0 -> 956 in the cache */
   /* search260_1 -> 918 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 956, 918 },
      -1,
   } },

   /* replace260_0 -> 16 in the cache */
   /* replace260_1 -> 382 in the cache */
   /* replace260 -> 956 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search261_0_0 -> 16 in the cache */
   /* search261_0_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 382 },
      -1,
   } },
   /* search261_1 -> 953 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 958, 953 },
      -1,
   } },

   /* replace261_0 -> 16 in the cache */
   /* replace261_1 -> 382 in the cache */
   /* replace261 -> 958 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search262_0_0 -> 16 in the cache */
   /* search262_0_1 -> 806 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 806 },
      -1,
   } },
   /* search262_1 -> 810 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 960, 810 },
      -1,
   } },

   /* replace262_0 -> 16 in the cache */
   /* replace262_1 -> 810 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 810 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search263_0_0 -> 16 in the cache */
   /* search263_0_1 -> 810 in the cache */
   /* search263_0 -> 962 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000 /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 962, 963 },
      -1,
   } },

   /* replace263_0 -> 16 in the cache */
   /* replace263_1 -> 810 in the cache */
   /* replace263 -> 962 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search264_0_0 -> 16 in the cache */
   /* search264_0_1 -> 810 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 810 },
      -1,
   } },
   /* search264_1 -> 806 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 965, 806 },
      -1,
   } },

   /* replace264_0 -> 16 in the cache */
   /* replace264_1 -> 810 in the cache */
   /* replace264 -> 965 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search265_0_0 -> 16 in the cache */
   /* search265_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 783 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18 /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 967, 968 },
      -1,
   } },

   /* replace265_0 -> 16 in the cache */
   /* replace265_1 -> 968 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 968 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search266_0_0 -> 16 in the cache */
   /* search266_0_1 -> 968 in the cache */
   /* search266_0 -> 970 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000 /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 970, 971 },
      -1,
   } },

   /* replace266_0 -> 16 in the cache */
   /* replace266_1 -> 968 in the cache */
   /* replace266 -> 970 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search267_0_0 -> 16 in the cache */
   /* search267_0_1 -> 968 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 968 },
      -1,
   } },
   /* search267_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 973, 783 },
      -1,
   } },

   /* replace267_0 -> 16 in the cache */
   /* replace267_1 -> 968 in the cache */
   /* replace267 -> 973 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search268_0_0 -> 0 in the cache */
   /* search268_0_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 0, 776 },
      -1,
   } },
   /* search268_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 975, 294 },
      -1,
   } },

   /* replace268_0_0 -> 0 in the cache */
   /* replace268_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 133 },
      -1,
   } },
   /* replace268_1_0 -> 3 in the cache */
   /* replace268_1_1 -> 133 in the cache */
   /* replace268_1 -> 779 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 977, 779 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search269_0_0 -> 124 in the cache */
   /* search269_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 124, 268 },
      0,
   } },
   /* search269_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 979, 769 },
      -1,
   } },

   /* replace269_0_0 -> 124 in the cache */
   /* replace269_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 124, 127 },
      -1,
   } },
   /* replace269_1_0 -> 125 in the cache */
   /* replace269_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 981, 982 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search270_0_0_0 -> 147 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 147, 984 },
      0,
   } },
   /* search270_0_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 2,
      { 985, 150 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      0, 3,
      { 986, 987 },
      -1,
   } },

   /* replace270_0_0_0 -> 147 in the cache */
   /* replace270_0_0_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 147, 150 },
      -1,
   } },
   /* replace270_0_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      1, 2,
      { 989, 151 },
      -1,
   } },
   /* replace270_1_0 -> 148 in the cache */
   /* replace270_1_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 148, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 990, 991 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search271_0_0_0 -> 124 in the cache */
   /* search271_0_0_1 -> 268 in the cache */
   /* search271_0_0 -> 979 in the cache */
   /* search271_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 979, 127 },
      0,
   } },
   /* search271_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 993, 296 },
      -1,
   } },

   /* replace271_0_0_0 -> 124 in the cache */
   /* replace271_0_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 124, 127 },
      -1,
   } },
   /* replace271_0_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 995, 161 },
      -1,
   } },
   /* replace271_1_0 -> 125 in the cache */
   /* replace271_1_1 -> 161 in the cache */
   /* replace271_1 -> 772 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 996, 772 },
      -1,
   } },

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 998, 999 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1000 },
      -1,
   } },

   /* replace272_0 -> 0 in the cache */
   /* replace272_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search273_0_0 -> 998 in the cache */
   /* search273_0_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 998, 999 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1003 },
      -1,
   } },

   /* replace273_0 -> 0 in the cache */
   /* replace273_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search274_0_0 -> 0 in the cache */
   /* search274_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1006 },
      -1,
   } },

   /* replace274_0 -> 0 in the cache */
   /* replace274_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search275_0_0 -> 0 in the cache */
   /* search275_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1009 },
      -1,
   } },

   /* replace275_0 -> 0 in the cache */
   /* replace275_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search276_0_0 -> 0 in the cache */
   /* search276_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1012 },
      -1,
   } },

   /* replace276_0 -> 0 in the cache */
   /* replace276_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search277_0_0 -> 0 in the cache */
   /* search277_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1015 },
      -1,
   } },

   /* replace277_0 -> 0 in the cache */
   /* replace277_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search278_0_0 -> 0 in the cache */
   /* search278_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1018 },
      -1,
   } },

   /* replace278_0 -> 0 in the cache */
   /* replace278_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search279_0_0 -> 0 in the cache */
   /* search279_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1021 },
      -1,
   } },

   /* replace279_0 -> 0 in the cache */
   /* replace279_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search280_0_0 -> 0 in the cache */
   /* search280_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1024 },
      -1,
   } },

   /* replace280_0 -> 0 in the cache */
   /* replace280_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search281_0_0 -> 0 in the cache */
   /* search281_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1027 },
      -1,
   } },

   /* replace281_0 -> 0 in the cache */
   /* replace281_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search282_0_0 -> 0 in the cache */
   /* search282_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search282_1_0 -> 0 in the cache */
   /* search282_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1030, 1031 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search283_0_0 -> 0 in the cache */
   /* search283_0_1 -> 3 in the cache */
   /* search283_0 -> 1005 in the cache */
   /* search283_1_0 -> 3 in the cache */
   /* search283_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1005, 1034 },
      -1,
   } },

   /* replace283 -> 1033 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search284_0_0 -> 0 in the cache */
   /* search284_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search284_1_0 -> 0 in the cache */
   /* search284_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1036, 1037 },
      -1,
   } },

   /* replace284 -> 1033 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search285_0_0 -> 0 in the cache */
   /* search285_0_1 -> 3 in the cache */
   /* search285_0 -> 1020 in the cache */
   /* search285_1_0 -> 3 in the cache */
   /* search285_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1020, 1039 },
      -1,
   } },

   /* replace285 -> 1033 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search286_0_0 -> 0 in the cache */
   /* search286_0_1 -> 3 in the cache */
   /* search286_0 -> 1023 in the cache */
   /* search286_1_0 -> 3 in the cache */
   /* search286_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1023, 1041 },
      -1,
   } },

   /* replace286 -> 1033 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search287_0_0 -> 0 in the cache */
   /* search287_0 -> 197 in the cache */
   /* search287_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 197, 1043 },
      -1,
   } },

   /* replace287_0 -> 3 in the cache */
   /* replace287_1 -> 0 in the cache */
   /* replace287 -> 1034 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search288_0_0 -> 0 in the cache */
   /* search288_0 -> 197 in the cache */
   /* search288_1_0 -> 3 in the cache */
   /* search288_1 -> 1043 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 197, 1043 },
      -1,
   } },

   /* replace288_0 -> 3 in the cache */
   /* replace288_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search289_0_0 -> 0 in the cache */
   /* search289_0 -> 197 in the cache */
   /* search289_1_0 -> 3 in the cache */
   /* search289_1 -> 1043 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 197, 1043 },
      -1,
   } },

   /* replace289_0 -> 3 in the cache */
   /* replace289_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search290_0_0 -> 0 in the cache */
   /* search290_0 -> 197 in the cache */
   /* search290_1_0 -> 3 in the cache */
   /* search290_1 -> 1043 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 197, 1043 },
      -1,
   } },

   /* replace290_0 -> 3 in the cache */
   /* replace290_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a') */
   /* search291_0_0 -> 32 in the cache */
   /* search291_0 -> 98 in the cache */
   /* search291_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 98, 232 },
      -1,
   } },

   /* replace291_0 -> 226 in the cache */
   /* replace291_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 226, 32 },
      -1,
   } },

   /* ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0) */
   /* search292_0 -> 232 in the cache */
   /* search292_1_0 -> 32 in the cache */
   /* search292_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 232, 98 },
      -1,
   } },

   /* replace292_0 -> 32 in the cache */
   /* replace292_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 226 },
      -1,
   } },

   /* ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a') */
   /* search293_0_0 -> 32 in the cache */
   /* search293_0 -> 98 in the cache */
   /* search293_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 98, 232 },
      -1,
   } },

   /* replace293_0 -> 226 in the cache */
   /* replace293_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 226, 32 },
      -1,
   } },

   /* ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0) */
   /* search294_0 -> 232 in the cache */
   /* search294_1_0 -> 32 in the cache */
   /* search294_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 232, 98 },
      -1,
   } },

   /* replace294_0 -> 32 in the cache */
   /* replace294_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 226 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a') */
   /* search295_0_0 -> 32 in the cache */
   /* search295_0 -> 98 in the cache */
   /* search295_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 98, 232 },
      -1,
   } },

   /* replace295_0 -> 226 in the cache */
   /* replace295_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 226, 32 },
      -1,
   } },

   /* ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0) */
   /* search296_0 -> 232 in the cache */
   /* search296_1_0 -> 32 in the cache */
   /* search296_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 232, 98 },
      -1,
   } },

   /* replace296_0 -> 32 in the cache */
   /* replace296_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 226 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1064 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1063, 1065 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace297_1 -> 1064 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1067, 1064 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search298_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1069, 1070 },
      -1,
   } },

   /* replace298_0 -> 0 in the cache */
   /* replace298_1 -> 3 in the cache */
   /* replace298 -> 1002 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search299_0_0 -> 0 in the cache */
   /* search299_0 -> 1069 in the cache */
   /* search299_1 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1069, 1070 },
      -1,
   } },

   /* replace299_0 -> 0 in the cache */
   /* replace299_1 -> 3 in the cache */
   /* replace299 -> 1011 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search300_0_0 -> 0 in the cache */
   /* search300_0 -> 1069 in the cache */
   /* search300_1 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1069, 1070 },
      -1,
   } },

   /* replace300_0 -> 0 in the cache */
   /* replace300_1 -> 3 in the cache */
   /* replace300 -> 1008 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search301_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      0,
   } },
   /* search301_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1074, 226 },
      -1,
   } },

   /* replace301_0 -> 32 in the cache */
   /* replace301_1 -> 226 in the cache */
   /* replace301 -> 1058 in the cache */

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search302_0 -> 113 in the cache */
   /* search302_1_0 -> 32 in the cache */
   /* search302_1 -> 1074 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 1074 },
      -1,
   } },

   /* replace302_0 -> 113 in the cache */
   /* replace302_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 32 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search303_1_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1078, 1079 },
      -1,
   } },

   /* replace303_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 715 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search304_0_0_0 -> 715 in the cache */
   /* search304_0_0 -> 1079 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1079 },
      -1,
   } },
   /* search304_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1082, 1078 },
      -1,
   } },

   /* replace304_0 -> 715 in the cache */
   /* replace304 -> 1081 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search305_0_0_0 -> 715 in the cache */
   /* search305_0_0 -> 1079 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1079, 1085 },
      -1,
   } },
   /* search305_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1086, 1078 },
      -1,
   } },

   /* replace305_0 -> 715 in the cache */
   /* replace305_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 715, 1084 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search306_0_0 -> 715 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search306_0_2_0 -> 1084 in the cache */
   /* search306_0_2 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1089, 1085 },
      -1,
   } },
   /* search306_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1090, 1078 },
      -1,
   } },

   /* replace306_0 -> 715 in the cache */
   /* replace306_1 -> 1084 in the cache */
   /* replace306 -> 1088 in the cache */

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search307_0_0 -> 715 in the cache */
   /* search307_0 -> 1079 in the cache */
   /* search307_1_0_0 -> 1084 in the cache */
   /* search307_1_0 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1085 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1079, 1092 },
      -1,
   } },

   /* replace307_0 -> 715 in the cache */
   /* replace307_1 -> 1084 in the cache */
   /* replace307 -> 1088 in the cache */

   /* ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b') */
   /* search308_0_0_0 -> 715 in the cache */
   /* search308_0_0 -> 1079 in the cache */
   /* search308_0_1_0 -> 1084 in the cache */
   /* search308_0_1 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 1079, 1085 },
      -1,
   } },
   /* search308_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1094, 1078 },
      -1,
   } },

   /* replace308_0 -> 715 in the cache */
   /* replace308_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 715, 1084 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b') */
   /* search309_0_0 -> 715 in the cache */
   /* search309_0_1_0 -> 1084 in the cache */
   /* search309_0_1 -> 1085 in the cache */
   /* search309_0_2 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1085, 1078 },
      -1,
   } },
   /* search309_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1097, 1078 },
      -1,
   } },

   /* replace309_0 -> 715 in the cache */
   /* replace309_1 -> 1084 in the cache */
   /* replace309 -> 1096 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search310_0_0_0 -> 715 in the cache */
   /* search310_0_0 -> 1079 in the cache */
   /* search310_0_1_0_0 -> 1084 in the cache */
   /* search310_0_1_0 -> 1085 in the cache */
   /* search310_0_1 -> 1092 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1079, 1092 },
      -1,
   } },
   /* search310_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1099, 1078 },
      -1,
   } },

   /* replace310_0 -> 715 in the cache */
   /* replace310_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 715, 1084 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search311_0_0 -> 715 in the cache */
   /* search311_0 -> 1079 in the cache */
   /* search311_1_0 -> 1084 in the cache */
   /* search311_1 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1079, 1085 },
      -1,
   } },

   /* replace311_0 -> 715 in the cache */
   /* replace311_1 -> 1084 in the cache */
   /* replace311 -> 1101 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search312_0_0_0 -> 715 in the cache */
   /* search312_0_0 -> 1079 in the cache */
   /* search312_0 -> 1082 in the cache */
   /* search312_1_0_0 -> 1084 in the cache */
   /* search312_1_0 -> 1085 in the cache */
   /* search312_1 -> 1092 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1082, 1092 },
      -1,
   } },

   /* replace312_0 -> 715 in the cache */
   /* replace312_1 -> 1084 in the cache */
   /* replace312 -> 1101 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search313_0_0_0 -> 715 in the cache */
   /* search313_0_0 -> 1079 in the cache */
   /* search313_0_1_0 -> 1084 in the cache */
   /* search313_0_1 -> 1085 in the cache */
   /* search313_0 -> 1086 in the cache */
   /* search313_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1086, 1078 },
      -1,
   } },

   /* replace313_0_0 -> 715 in the cache */
   /* replace313_0_1 -> 1084 in the cache */
   /* replace313_0 -> 1088 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1088 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search314_0_0 -> 715 in the cache */
   /* search314_0_1 -> 1089 in the cache */
   /* search314_0_2_0 -> 1084 in the cache */
   /* search314_0_2 -> 1085 in the cache */
   /* search314_0 -> 1090 in the cache */
   /* search314_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1090, 1078 },
      -1,
   } },

   /* replace314_0_0 -> 715 in the cache */
   /* replace314_0_1 -> 1084 in the cache */
   /* replace314_0 -> 1088 in the cache */
   /* replace314 -> 1105 in the cache */

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search315_0_0 -> 715 in the cache */
   /* search315_0 -> 1079 in the cache */
   /* search315_1_0_0 -> 1084 in the cache */
   /* search315_1_0 -> 1085 in the cache */
   /* search315_1 -> 1092 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1079, 1092 },
      -1,
   } },

   /* replace315_0_0 -> 715 in the cache */
   /* replace315_0_1 -> 1084 in the cache */
   /* replace315_0 -> 1088 in the cache */
   /* replace315 -> 1105 in the cache */

   /* ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search316_0_0_0 -> 715 in the cache */
   /* search316_0_0 -> 1079 in the cache */
   /* search316_0_1_0 -> 1084 in the cache */
   /* search316_0_1 -> 1085 in the cache */
   /* search316_0 -> 1094 in the cache */
   /* search316_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1094, 1078 },
      -1,
   } },

   /* replace316_0_0 -> 715 in the cache */
   /* replace316_0_1 -> 1084 in the cache */
   /* replace316_0 -> 1096 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1096 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search317_0_0 -> 715 in the cache */
   /* search317_0_1_0 -> 1084 in the cache */
   /* search317_0_1 -> 1085 in the cache */
   /* search317_0_2 -> 1078 in the cache */
   /* search317_0 -> 1097 in the cache */
   /* search317_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1097, 1078 },
      -1,
   } },

   /* replace317_0_0 -> 715 in the cache */
   /* replace317_0_1 -> 1084 in the cache */
   /* replace317_0 -> 1096 in the cache */
   /* replace317 -> 1109 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search318_0_0_0 -> 715 in the cache */
   /* search318_0_0 -> 1079 in the cache */
   /* search318_0_1_0_0 -> 1084 in the cache */
   /* search318_0_1_0 -> 1085 in the cache */
   /* search318_0_1 -> 1092 in the cache */
   /* search318_0 -> 1099 in the cache */
   /* search318_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1099, 1078 },
      -1,
   } },

   /* replace318_0 -> 715 in the cache */
   /* replace318_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 715, 1084 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search319_0_0 -> 715 in the cache */
   /* search319_0 -> 1079 in the cache */
   /* search319_1_0 -> 1084 in the cache */
   /* search319_1 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1079, 1085 },
      -1,
   } },

   /* replace319_0 -> 715 in the cache */
   /* replace319_1 -> 1084 in the cache */
   /* replace319 -> 1112 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search320_0_0_0 -> 715 in the cache */
   /* search320_0_0 -> 1079 in the cache */
   /* search320_0 -> 1082 in the cache */
   /* search320_1_0_0 -> 1084 in the cache */
   /* search320_1_0 -> 1085 in the cache */
   /* search320_1 -> 1092 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1082, 1092 },
      -1,
   } },

   /* replace320_0 -> 715 in the cache */
   /* replace320_1 -> 1084 in the cache */
   /* replace320 -> 1112 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search321_0_0_0_0 -> 715 in the cache */
   /* search321_0_0_0 -> 1079 in the cache */
   /* search321_0_0_1_0 -> 1084 in the cache */
   /* search321_0_0_1 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1079, 1085 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1115 },
      -1,
   } },
   /* search321_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1116, 1078 },
      -1,
   } },

   /* replace321_0 -> 715 in the cache */
   /* replace321_1 -> 1084 in the cache */
   /* replace321 -> 1088 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search322_0 -> 1078 in the cache */
   /* search322_1_0_0 -> 715 in the cache */
   /* search322_1_0 -> 1079 in the cache */
   /* search322_1_1_0 -> 1084 in the cache */
   /* search322_1_1 -> 1085 in the cache */
   /* search322_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1078, 1115 },
      -1,
   } },

   /* replace322_0 -> 715 in the cache */
   /* replace322_1 -> 1084 in the cache */
   /* replace322 -> 1088 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search323_0_0_0_0 -> 715 in the cache */
   /* search323_0_0_0 -> 1079 in the cache */
   /* search323_0_0_1_0 -> 1084 in the cache */
   /* search323_0_0_1 -> 1085 in the cache */
   /* search323_0_0 -> 1115 in the cache */
   /* search323_0 -> 1116 in the cache */
   /* search323_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1116, 1078 },
      -1,
   } },

   /* replace323_0_0 -> 715 in the cache */
   /* replace323_0_1 -> 1084 in the cache */
   /* replace323_0 -> 1088 in the cache */
   /* replace323 -> 1105 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search324_0 -> 1078 in the cache */
   /* search324_1_0_0 -> 715 in the cache */
   /* search324_1_0 -> 1079 in the cache */
   /* search324_1_1_0 -> 1084 in the cache */
   /* search324_1_1 -> 1085 in the cache */
   /* search324_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1078, 1115 },
      -1,
   } },

   /* replace324_0_0 -> 715 in the cache */
   /* replace324_0_1 -> 1084 in the cache */
   /* replace324_0 -> 1088 in the cache */
   /* replace324 -> 1105 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search325_0 -> 32 in the cache */
   /* search325_1_0 -> 32 in the cache */
   /* search325_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 98 },
      -1,
   } },

   /* replace325_0 -> 32 in the cache */
   /* replace325_1 -> 113 in the cache */
   /* replace325 -> 670 in the cache */

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search326_0 -> 32 in the cache */
   /* search326_1_0 -> 32 in the cache */
   /* search326_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 98 },
      -1,
   } },

   /* replace326_0 -> 32 in the cache */
   /* replace326_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 113 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1125 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1126, 1128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1129 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1124, 1130 },
      -1,
   } },
   /* search327_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 2,
      { 1131, 113 },
      -1,
   } },

   /* replace327_0_0 -> 1124 in the cache */
   /* replace327_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1124, 113 },
      -1,
   } },
   /* replace327_1_0 -> 1125 in the cache */
   /* replace327_1_1 -> 1127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1125, 1127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1133, 1134 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search328_0_0 -> 0 in the cache */
   /* search328_0_1 -> 3 in the cache */
   /* search328_0 -> 257 in the cache */
   /* search328_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 257, 0 },
      -1,
   } },

   /* replace328_0 -> 3 in the cache */
   /* replace328_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 241 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search329_0_0 -> 0 in the cache */
   /* search329_0_1 -> 3 in the cache */
   /* search329_0 -> 257 in the cache */
   /* search329_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 257, 0 },
      -1,
   } },

   /* replace329_0 -> 3 in the cache */
   /* replace329_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 241 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search330_0_0 -> 0 in the cache */
   /* search330_0_1 -> 3 in the cache */
   /* search330_0 -> 198 in the cache */
   /* search330_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 198, 0 },
      -1,
   } },

   /* replace330_0 -> 3 in the cache */
   /* replace330_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 241 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search331_0_0 -> 0 in the cache */
   /* search331_0_1 -> 3 in the cache */
   /* search331_0 -> 198 in the cache */
   /* search331_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 198, 0 },
      -1,
   } },

   /* replace331_0 -> 3 in the cache */
   /* replace331_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 241 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search332_0_0 -> 124 in the cache */
   /* search332_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 124, 268 },
      0,
   } },
   /* search332_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1144, 769 },
      -1,
   } },

   /* replace332_0 -> 124 in the cache */
   /* replace332_1_0 -> 127 in the cache */
   /* replace332_1_1_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 125 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 127, 1146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 124, 1147 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search333_0_0_0 -> 124 in the cache */
   /* search333_0_0_1 -> 268 in the cache */
   /* search333_0_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1144 },
      0,
   } },
   /* search333_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1149, 769 },
      -1,
   } },

   /* replace333_0_0_0 -> 127 in the cache */
   /* replace333_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 127, 125 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1151 },
      -1,
   } },
   /* replace333_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1152, 124 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search334_0_0 -> 124 in the cache */
   /* search334_0_1 -> 268 in the cache */
   /* search334_0 -> 1144 in the cache */
   /* search334_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1144, 769 },
      -1,
   } },

   /* replace334_0 -> 124 in the cache */
   /* replace334_1_0 -> 127 in the cache */
   /* replace334_1_1_0 -> 125 in the cache */
   /* replace334_1_1 -> 1146 in the cache */
   /* replace334_1 -> 1147 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 124, 1147 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search335_0_0_0 -> 124 in the cache */
   /* search335_0_0_1 -> 268 in the cache */
   /* search335_0_0 -> 1144 in the cache */
   /* search335_0 -> 1149 in the cache */
   /* search335_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1149, 769 },
      -1,
   } },

   /* replace335_0_0_0 -> 127 in the cache */
   /* replace335_0_0_1 -> 125 in the cache */
   /* replace335_0_0 -> 1151 in the cache */
   /* replace335_0 -> 1152 in the cache */
   /* replace335_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1152, 124 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search336_0_0 -> 124 in the cache */
   /* search336_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 124, 268 },
      0,
   } },
   /* search336_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1158, 769 },
      -1,
   } },

   /* replace336_0 -> 124 in the cache */
   /* replace336_1_0 -> 127 in the cache */
   /* replace336_1_1_0 -> 125 in the cache */
   /* replace336_1_1 -> 1146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 127, 1146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 124, 1160 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search337_0_0_0 -> 124 in the cache */
   /* search337_0_0_1 -> 268 in the cache */
   /* search337_0_0 -> 1158 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1158 },
      0,
   } },
   /* search337_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1162, 769 },
      -1,
   } },

   /* replace337_0_0_0 -> 127 in the cache */
   /* replace337_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 127, 125 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1164 },
      -1,
   } },
   /* replace337_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1165, 124 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search338_0_0 -> 124 in the cache */
   /* search338_0_1 -> 268 in the cache */
   /* search338_0 -> 1158 in the cache */
   /* search338_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1158, 769 },
      -1,
   } },

   /* replace338_0 -> 124 in the cache */
   /* replace338_1_0 -> 127 in the cache */
   /* replace338_1_1_0 -> 125 in the cache */
   /* replace338_1_1 -> 1146 in the cache */
   /* replace338_1 -> 1160 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 124, 1160 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search339_0_0_0 -> 124 in the cache */
   /* search339_0_0_1 -> 268 in the cache */
   /* search339_0_0 -> 1158 in the cache */
   /* search339_0 -> 1162 in the cache */
   /* search339_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1162, 769 },
      -1,
   } },

   /* replace339_0_0_0 -> 127 in the cache */
   /* replace339_0_0_1 -> 125 in the cache */
   /* replace339_0_0 -> 1164 in the cache */
   /* replace339_0 -> 1165 in the cache */
   /* replace339_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1165, 124 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search340_0_0 -> 0 in the cache */
   /* search340_0_1 -> 3 in the cache */
   /* search340_0 -> 193 in the cache */
   /* search340_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 193, 0 },
      -1,
   } },

   /* replace340_0 -> 3 in the cache */
   /* replace340_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search341_0_0 -> 0 in the cache */
   /* search341_0_1 -> 3 in the cache */
   /* search341_0 -> 193 in the cache */
   /* search341_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 193, 0 },
      -1,
   } },

   /* replace341_0 -> 3 in the cache */
   /* replace341_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a') */
   /* search342_0_0 -> 715 in the cache */
   /* search342_0 -> 1079 in the cache */
   /* search342_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1079, 1078 },
      -1,
   } },

   /* replace342_0 -> 715 in the cache */
   /* replace342 -> 1081 in the cache */

   /* ('fneu', ('b2f', 'a@1'), 0.0) => a */
   /* search343_0_0 -> 715 in the cache */
   /* search343_0 -> 1079 in the cache */
   /* search343_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1079, 1078 },
      -1,
   } },

   /* replace343 -> 715 in the cache */

   /* ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a') */
   /* search344_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 715 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1177, 1178 },
      -1,
   } },

   /* replace344_0 -> 715 in the cache */
   /* replace344 -> 1081 in the cache */

   /* ('ine', ('b2i', 'a@1'), 0) => a */
   /* search345_0_0 -> 715 in the cache */
   /* search345_0 -> 1177 in the cache */
   /* search345_1 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1177, 1178 },
      -1,
   } },

   /* replace345 -> 715 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search346_0_0 -> 32 in the cache */
   /* search346_0 -> 104 in the cache */
   /* search346_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 104, 1078 },
      -1,
   } },

   /* replace346_0 -> 32 in the cache */
   /* replace346_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search347_0_0 -> 32 in the cache */
   /* search347_0 -> 104 in the cache */
   /* search347_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 104, 1078 },
      -1,
   } },

   /* replace347_0 -> 32 in the cache */
   /* replace347_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search348_0_0 -> 32 in the cache */
   /* search348_0 -> 104 in the cache */
   /* search348_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 104, 1078 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },

   /* ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a') */
   /* search349_0 -> 1078 in the cache */
   /* search349_1_0 -> 32 in the cache */
   /* search349_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1078, 104 },
      -1,
   } },

   /* replace349_0 -> 61 in the cache */
   /* replace349_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search350_0_0 -> 32 in the cache */
   /* search350_0 -> 104 in the cache */
   /* search350_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 104, 1078 },
      -1,
   } },

   /* replace350 -> 1033 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a') */
   /* search351_0 -> 1078 in the cache */
   /* search351_1_0 -> 32 in the cache */
   /* search351_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1078, 104 },
      -1,
   } },

   /* replace351_0 -> 61 in the cache */
   /* replace351_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search352_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search352_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1192, 1078 },
      -1,
   } },

   /* replace352_0 -> 32 in the cache */
   /* replace352_1 -> 61 in the cache */
   /* replace352 -> 1182 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search353_0_0 -> 32 in the cache */
   /* search353_0 -> 1192 in the cache */
   /* search353_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1192, 1078 },
      -1,
   } },

   /* replace353_0 -> 32 in the cache */
   /* replace353_1 -> 61 in the cache */
   /* replace353 -> 1184 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search354_0_0 -> 32 in the cache */
   /* search354_0 -> 1192 in the cache */
   /* search354_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1192, 1078 },
      -1,
   } },

   /* replace354_0 -> 32 in the cache */
   /* replace354_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search355_0 -> 1078 in the cache */
   /* search355_1_0 -> 32 in the cache */
   /* search355_1 -> 1192 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1078, 1192 },
      -1,
   } },

   /* replace355_0 -> 61 in the cache */
   /* replace355_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search356_0_0 -> 32 in the cache */
   /* search356_0 -> 1192 in the cache */
   /* search356_1 -> 1078 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1192, 1078 },
      -1,
   } },

   /* replace356_0 -> 32 in the cache */
   /* replace356_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search357_0 -> 1078 in the cache */
   /* search357_1_0 -> 32 in the cache */
   /* search357_1 -> 1192 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1078, 1192 },
      -1,
   } },

   /* replace357_0 -> 61 in the cache */
   /* replace357_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search358_0 -> 113 in the cache */
   /* search358_1_0 -> 32 in the cache */
   /* search358_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 103 },
      -1,
   } },

   /* replace358_0 -> 32 in the cache */
   /* replace358_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search359_0_0_0 -> 32 in the cache */
   /* search359_0_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 103 },
      -1,
   } },
   /* search359_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1205, 113 },
      -1,
   } },

   /* replace359_0 -> 32 in the cache */
   /* replace359_1 -> 113 in the cache */
   /* replace359 -> 1204 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search360_0 -> 113 in the cache */
   /* search360_1_0 -> 32 in the cache */
   /* search360_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 113, 103 },
      -1,
   } },

   /* replace360_0 -> 32 in the cache */
   /* replace360_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search361_0_0_0 -> 32 in the cache */
   /* search361_0_0 -> 103 in the cache */
   /* search361_0 -> 1205 in the cache */
   /* search361_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1205, 113 },
      -1,
   } },

   /* replace361_0 -> 32 in the cache */
   /* replace361_1 -> 113 in the cache */
   /* replace361 -> 1208 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search362_0_0 -> 32 in the cache */
   /* search362_0_1 -> 113 in the cache */
   /* search362_0 -> 1123 in the cache */
   /* search362_1_0 -> 226 in the cache */
   /* search362_1_1 -> 32 in the cache */
   /* search362_1 -> 1056 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1123, 1056 },
      -1,
   } },

   /* replace362_0 -> 32 in the cache */
   /* replace362_1_0 -> 32 in the cache */
   /* replace362_1 -> 202 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 202 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search363_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 715 },
      0,
   } },
   /* search363_1_0 -> 1084 in the cache */
   /* search363_1 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1212, 1085 },
      -1,
   } },

   /* replace363_0_0 -> 715 in the cache */
   /* replace363_0_1 -> 1084 in the cache */
   /* replace363_0 -> 1088 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1088 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search364_0_0_0 -> 715 in the cache */
   /* search364_0_0 -> 1212 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1212 },
      0,
   } },
   /* search364_1_0_0 -> 1084 in the cache */
   /* search364_1_0 -> 1085 in the cache */
   /* search364_1 -> 1092 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1215, 1092 },
      -1,
   } },

   /* replace364_0_0_0 -> 715 in the cache */
   /* replace364_0_0_1 -> 1084 in the cache */
   /* replace364_0_0 -> 1096 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1096 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1217 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search365_0_0 -> 715 in the cache */
   /* search365_0 -> 1212 in the cache */
   /* search365_1_0 -> 1084 in the cache */
   /* search365_1 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1212, 1085 },
      -1,
   } },

   /* replace365_0_0 -> 715 in the cache */
   /* replace365_0_1 -> 1084 in the cache */
   /* replace365_0 -> 1096 in the cache */
   /* replace365 -> 1217 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search366_0_0_0 -> 715 in the cache */
   /* search366_0_0 -> 1212 in the cache */
   /* search366_0 -> 1215 in the cache */
   /* search366_1_0_0 -> 1084 in the cache */
   /* search366_1_0 -> 1085 in the cache */
   /* search366_1 -> 1092 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1215, 1092 },
      -1,
   } },

   /* replace366_0_0_0 -> 715 in the cache */
   /* replace366_0_0_1 -> 1084 in the cache */
   /* replace366_0_0 -> 1088 in the cache */
   /* replace366_0 -> 1214 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1214 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search367_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search367_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1222, 776 },
      -1,
   } },

   /* replace367_0 -> 715 in the cache */
   /* replace367_1_0 -> 3 in the cache */
   /* replace367_1_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 3, 255 },
      -1,
   } },
   /* replace367_2_0 -> 3 in the cache */
   /* replace367_2_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 3, 241 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 715, 1224, 1225 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search368_0_0 -> 0 in the cache */
   /* search368_0_1_0 -> 3 in the cache */
   /* search368_0_1 -> 1043 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1043 },
      0,
   } },
   /* search368_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1227, 241 },
      -1,
   } },

   /* replace368_0 -> 0 in the cache */
   /* replace368_1 -> 3 in the cache */
   /* replace368 -> 1005 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search369_0_0_0 -> 32 in the cache */
   /* search369_0_0 -> 103 in the cache */
   /* search369_0 -> 1205 in the cache */
   /* search369_1 -> 113 in the cache */
   /* search369 -> 1209 in the cache */

   /* replace369_0 -> 32 in the cache */
   /* replace369_1 -> 113 in the cache */
   /* replace369 -> 1208 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search370_0_0 -> 1067 in the cache */
   /* search370_0_1 -> 1064 in the cache */
   /* search370_0 -> 1068 in the cache */
   /* search370_1 -> 1067 in the cache */
   /* search370_2 -> 1064 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1068, 1067, 1064 },
      -1,
   } },

   /* replace370_0 -> 1064 in the cache */
   /* replace370_1 -> 1067 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1064, 1067 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search371_0_0 -> 0 in the cache */
   /* search371_0_1 -> 3 in the cache */
   /* search371_0 -> 1005 in the cache */
   /* search371_1 -> 3 in the cache */
   /* search371_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1005, 3, 0 },
      -1,
   } },

   /* replace371_0 -> 0 in the cache */
   /* replace371_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search372_0_0 -> 0 in the cache */
   /* search372_0_1 -> 3 in the cache */
   /* search372_0 -> 1002 in the cache */
   /* search372_1 -> 3 in the cache */
   /* search372_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1002, 3, 0 },
      -1,
   } },

   /* replace372_0 -> 0 in the cache */
   /* replace372_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search373_0_0 -> 1067 in the cache */
   /* search373_0_1 -> 1064 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1067, 1064 },
      -1,
   } },
   /* search373_1 -> 1067 in the cache */
   /* search373_2 -> 1064 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1235, 1067, 1064 },
      -1,
   } },

   /* replace373_0 -> 1064 in the cache */
   /* replace373_1 -> 1067 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1064, 1067 },
      -1,
   } },

   /* ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c') */
   /* search374_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search374_1 -> 125 in the cache */
   /* search374_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1238, 125, 127 },
      -1,
   } },

   /* replace374_0_0 -> 32 in the cache */
   /* replace374_0_1 -> 61 in the cache */
   /* replace374_0 -> 1182 in the cache */
   /* replace374_1 -> 125 in the cache */
   /* replace374_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 1182, 125, 127 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search375_0_0 -> 715 in the cache */
   /* search375_0 -> 1081 in the cache */
   /* search375_1 -> 125 in the cache */
   /* search375_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1081, 125, 127 },
      -1,
   } },

   /* replace375_0 -> 715 in the cache */
   /* replace375_1 -> 127 in the cache */
   /* replace375_2 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 127, 125 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search376_0 -> 715 in the cache */
   /* search376_1_0 -> 715 in the cache */
   /* search376_1_1 -> 148 in the cache */
   /* search376_1_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 148, 150 },
      -1,
   } },
   /* search376_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1243, 151 },
      -1,
   } },

   /* replace376_0 -> 715 in the cache */
   /* replace376_1 -> 148 in the cache */
   /* replace376_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 148, 151 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search377_0 -> 715 in the cache */
   /* search377_1 -> 148 in the cache */
   /* search377_2_0 -> 715 in the cache */
   /* search377_2_1 -> 150 in the cache */
   /* search377_2_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 150, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 148, 1246 },
      -1,
   } },

   /* replace377_0 -> 715 in the cache */
   /* replace377_1 -> 148 in the cache */
   /* replace377_2 -> 151 in the cache */
   /* replace377 -> 1245 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search378_0 -> 715 in the cache */
   /* search378_1_0 -> 1084 in the cache */
   /* search378_1_1 -> 708 in the cache */
   /* search378_1_2 -> 717 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 708, 717 },
      -1,
   } },
   /* search378_2_0 -> 1084 in the cache */
   /* search378_2_1 -> 708 in the cache */
   /* search378_2_2 -> 719 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 708, 719 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1248, 1249 },
      -1,
   } },

   /* replace378_0 -> 1084 in the cache */
   /* replace378_1 -> 708 in the cache */
   /* replace378_2_0 -> 715 in the cache */
   /* replace378_2_1 -> 717 in the cache */
   /* replace378_2_2 -> 719 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 717, 719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 708, 1251 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search379_0 -> 715 in the cache */
   /* search379_1_0 -> 1084 in the cache */
   /* search379_1_1 -> 708 in the cache */
   /* search379_1_2 -> 717 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 708, 717 },
      0,
   } },
   /* search379_2_0 -> 1084 in the cache */
   /* search379_2_1 -> 708 in the cache */
   /* search379_2_2 -> 719 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 708, 719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1253, 1254 },
      -1,
   } },

   /* replace379_0 -> 1084 in the cache */
   /* replace379_1 -> 708 in the cache */
   /* replace379_2_0 -> 715 in the cache */
   /* replace379_2_1 -> 717 in the cache */
   /* replace379_2_2 -> 719 in the cache */
   /* replace379_2 -> 1251 in the cache */
   /* replace379 -> 1252 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search380_0 -> 715 in the cache */
   /* search380_1_0 -> 1084 in the cache */
   /* search380_1_1 -> 150 in the cache */
   /* search380_1_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 150, 151 },
      -1,
   } },
   /* search380_2_0 -> 1084 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search380_2_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 1257, 151 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1256, 1258 },
      -1,
   } },

   /* replace380_0 -> 1084 in the cache */
   /* replace380_1_0 -> 715 in the cache */
   /* replace380_1_1 -> 150 in the cache */
   /* replace380_1_2 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 150, 1257 },
      -1,
   } },
   /* replace380_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 1260, 151 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search381_0 -> 715 in the cache */
   /* search381_1_0 -> 1084 in the cache */
   /* search381_1_1 -> 150 in the cache */
   /* search381_1_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 150, 151 },
      0,
   } },
   /* search381_2_0 -> 1084 in the cache */
   /* search381_2_1 -> 1257 in the cache */
   /* search381_2_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1084, 1257, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1262, 1263 },
      -1,
   } },

   /* replace381_0 -> 1084 in the cache */
   /* replace381_1_0 -> 715 in the cache */
   /* replace381_1_1 -> 150 in the cache */
   /* replace381_1_2 -> 1257 in the cache */
   /* replace381_1 -> 1260 in the cache */
   /* replace381_2 -> 151 in the cache */
   /* replace381 -> 1261 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search382_0 -> 715 in the cache */
   /* search382_1 -> 1186 in the cache */
   /* search382_2 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1186, 1084 },
      -1,
   } },

   /* replace382_0 -> 715 in the cache */
   /* replace382_1 -> 1084 in the cache */
   /* replace382 -> 1088 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search383_0 -> 715 in the cache */
   /* search383_1 -> 715 in the cache */
   /* search383_2 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 715, 1084 },
      -1,
   } },

   /* replace383_0 -> 715 in the cache */
   /* replace383_1 -> 1084 in the cache */
   /* replace383 -> 1088 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search384_0 -> 715 in the cache */
   /* search384_1 -> 1084 in the cache */
   /* search384_2 -> 1033 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1084, 1033 },
      -1,
   } },

   /* replace384_0 -> 715 in the cache */
   /* replace384_1 -> 1084 in the cache */
   /* replace384 -> 1096 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search385_0 -> 715 in the cache */
   /* search385_1 -> 1084 in the cache */
   /* search385_2 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1084, 715 },
      -1,
   } },

   /* replace385_0 -> 715 in the cache */
   /* replace385_1 -> 1084 in the cache */
   /* replace385 -> 1096 in the cache */

   /* ('~fmin', 'a', 'a') => a */
   /* search386_0 -> 32 in the cache */
   /* search386_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace386 -> 32 in the cache */

   /* ('~fmax', 'a', 'a') => a */
   /* search387_0 -> 32 in the cache */
   /* search387_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace387 -> 32 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search388_0 -> 32 in the cache */
   /* search388_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace388 -> 32 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search389_0 -> 32 in the cache */
   /* search389_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace389 -> 32 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search390_0 -> 32 in the cache */
   /* search390_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace390 -> 32 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search391_0 -> 32 in the cache */
   /* search391_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace391 -> 61 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search392_0 -> 32 in the cache */
   /* search392_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace392 -> 32 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search393_0 -> 32 in the cache */
   /* search393_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace393 -> 32 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search394_0 -> 32 in the cache */
   /* search394_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace394 -> 32 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search395_0 -> 32 in the cache */
   /* search395_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace395 -> 63 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search396_0_0 -> 0 in the cache */
   /* search396_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search396_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1279, 3 },
      -1,
   } },

   /* replace396_0 -> 0 in the cache */
   /* replace396_1 -> 3 in the cache */
   /* replace396 -> 1232 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search397_0_0 -> 0 in the cache */
   /* search397_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search397_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1281, 3 },
      -1,
   } },

   /* replace397_0 -> 0 in the cache */
   /* replace397_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search398_0_0 -> 0 in the cache */
   /* search398_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search398_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1284, 3 },
      -1,
   } },

   /* replace398_0 -> 0 in the cache */
   /* replace398_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search399_0_0 -> 0 in the cache */
   /* search399_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search399_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1287, 3 },
      -1,
   } },

   /* replace399_0 -> 0 in the cache */
   /* replace399_1 -> 3 in the cache */
   /* replace399 -> 1234 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search400_0_0 -> 0 in the cache */
   /* search400_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search400_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1289, 3 },
      -1,
   } },

   /* replace400_0 -> 0 in the cache */
   /* replace400_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search401_0_0 -> 0 in the cache */
   /* search401_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search401_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1292, 3 },
      -1,
   } },

   /* replace401_0 -> 0 in the cache */
   /* replace401_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search402_0_0_0 -> 124 in the cache */
   /* search402_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search402_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 2,
      { 1295, 127 },
      -1,
   } },
   /* search402_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 3,
      { 1296, 124 },
      -1,
   } },

   /* replace402_0_0 -> 124 in the cache */
   /* replace402_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace402_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1298, 127 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search403_0_0_0 -> 124 in the cache */
   /* search403_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search403_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 2,
      { 1300, 127 },
      -1,
   } },
   /* search403_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 3,
      { 1301, 124 },
      -1,
   } },

   /* replace403_0_0 -> 124 in the cache */
   /* replace403_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace403_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1303, 127 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search404_0_0_0 -> 124 in the cache */
   /* search404_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search404_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 2,
      { 1305, 127 },
      -1,
   } },
   /* search404_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 3,
      { 1306, 124 },
      -1,
   } },

   /* replace404_0_0 -> 124 in the cache */
   /* replace404_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace404_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1308, 127 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search405_0_0_0 -> 124 in the cache */
   /* search405_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search405_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 2,
      { 1310, 127 },
      -1,
   } },
   /* search405_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 3,
      { 1311, 124 },
      -1,
   } },

   /* replace405_0_0 -> 124 in the cache */
   /* replace405_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace405_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1313, 127 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search406_0_0_0 -> 124 in the cache */
   /* search406_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search406_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 2,
      { 1315, 127 },
      -1,
   } },
   /* search406_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 1316, 124 },
      -1,
   } },

   /* replace406_0_0 -> 124 in the cache */
   /* replace406_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace406_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1318, 127 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search407_0_0_0 -> 124 in the cache */
   /* search407_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search407_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 2,
      { 1320, 127 },
      -1,
   } },
   /* search407_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 3,
      { 1321, 124 },
      -1,
   } },

   /* replace407_0_0 -> 124 in the cache */
   /* replace407_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace407_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1323, 127 },
      -1,
   } },

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search408_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search408_1_0 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1325, 1326 },
      -1,
   } },

   /* replace408_0 -> 715 in the cache */
   /* replace408_1 -> 1084 in the cache */
   /* replace408 -> 1112 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search409_0_0 -> 715 in the cache */
   /* search409_0 -> 1325 in the cache */
   /* search409_1_0 -> 1084 in the cache */
   /* search409_1 -> 1326 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1325, 1326 },
      -1,
   } },

   /* replace409_0 -> 715 in the cache */
   /* replace409_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 715, 1084 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search410_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search410_1_0 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1330, 1331 },
      -1,
   } },

   /* replace410_0 -> 715 in the cache */
   /* replace410_1 -> 1084 in the cache */
   /* replace410 -> 1112 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search411_0_0 -> 715 in the cache */
   /* search411_0 -> 1330 in the cache */
   /* search411_1_0 -> 1084 in the cache */
   /* search411_1 -> 1331 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1330, 1331 },
      -1,
   } },

   /* replace411_0 -> 715 in the cache */
   /* replace411_1 -> 1084 in the cache */
   /* replace411 -> 1329 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search412_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search412_1_0 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1334, 1335 },
      -1,
   } },

   /* replace412_0 -> 715 in the cache */
   /* replace412_1 -> 1084 in the cache */
   /* replace412 -> 1112 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search413_0_0 -> 715 in the cache */
   /* search413_0 -> 1334 in the cache */
   /* search413_1_0 -> 1084 in the cache */
   /* search413_1 -> 1335 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1334, 1335 },
      -1,
   } },

   /* replace413_0 -> 715 in the cache */
   /* replace413_1 -> 1084 in the cache */
   /* replace413 -> 1329 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search414_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search414_1_0 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1338, 1339 },
      -1,
   } },

   /* replace414_0 -> 715 in the cache */
   /* replace414_1 -> 1084 in the cache */
   /* replace414 -> 1112 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search415_0_0 -> 715 in the cache */
   /* search415_0 -> 1338 in the cache */
   /* search415_1_0 -> 1084 in the cache */
   /* search415_1 -> 1339 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1338, 1339 },
      -1,
   } },

   /* replace415_0 -> 715 in the cache */
   /* replace415_1 -> 1084 in the cache */
   /* replace415 -> 1329 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search416_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search416_1_0 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1342, 1343 },
      -1,
   } },

   /* replace416_0 -> 715 in the cache */
   /* replace416_1 -> 1084 in the cache */
   /* replace416 -> 1112 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search417_0_0 -> 715 in the cache */
   /* search417_0 -> 1342 in the cache */
   /* search417_1_0 -> 1084 in the cache */
   /* search417_1 -> 1343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1342, 1343 },
      -1,
   } },

   /* replace417_0 -> 715 in the cache */
   /* replace417_1 -> 1084 in the cache */
   /* replace417 -> 1329 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search418_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search418_1_0 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1346, 1347 },
      -1,
   } },

   /* replace418_0 -> 715 in the cache */
   /* replace418_1 -> 1084 in the cache */
   /* replace418 -> 1112 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search419_0_0 -> 715 in the cache */
   /* search419_0 -> 1346 in the cache */
   /* search419_1_0 -> 1084 in the cache */
   /* search419_1 -> 1347 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1346, 1347 },
      -1,
   } },

   /* replace419_0 -> 715 in the cache */
   /* replace419_1 -> 1084 in the cache */
   /* replace419 -> 1329 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search420_0_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search420_1_0 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1350, 1351 },
      -1,
   } },

   /* replace420_0 -> 715 in the cache */
   /* replace420_1 -> 1084 in the cache */
   /* replace420 -> 1112 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search421_0_0 -> 715 in the cache */
   /* search421_0 -> 1350 in the cache */
   /* search421_1_0 -> 1084 in the cache */
   /* search421_1 -> 1351 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1350, 1351 },
      -1,
   } },

   /* replace421_0 -> 715 in the cache */
   /* replace421_1 -> 1084 in the cache */
   /* replace421 -> 1329 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search422_0 -> 6 in the cache */
   /* search422_1_0_0 -> 6 in the cache */
   /* search422_1_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 1355 },
      -1,
   } },

   /* replace422_0 -> 6 in the cache */
   /* replace422_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 6, 791 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0) */
   /* search423_0_0 -> 6 in the cache */
   /* search423_0_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 6, 7 },
      -1,
   } },
   /* search423_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1358, 791 },
      -1,
   } },

   /* replace423_0 -> 6 in the cache */
   /* replace423_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 6, 791 },
      -1,
   } },

   /* ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0) */
   /* search424_0_0 -> 6 in the cache */
   /* search424_0_1 -> 7 in the cache */
   /* search424_0 -> 1358 in the cache */
   /* search424_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1358, 7 },
      -1,
   } },

   /* replace424_0 -> 6 in the cache */
   /* replace424_1 -> 791 in the cache */
   /* replace424 -> 1360 in the cache */

   /* ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0) */
   /* search425_0_0 -> 6 in the cache */
   /* search425_0_1 -> 7 in the cache */
   /* search425_0 -> 1358 in the cache */
   /* search425_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1358, 791 },
      -1,
   } },

   /* replace425_0 -> 6 in the cache */
   /* replace425_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 6, 791 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0) */
   /* search426_0_0 -> 6 in the cache */
   /* search426_0_1 -> 7 in the cache */
   /* search426_0 -> 1358 in the cache */
   /* search426_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1358, 7 },
      -1,
   } },

   /* replace426_0 -> 6 in the cache */
   /* replace426_1 -> 791 in the cache */
   /* replace426 -> 1363 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search427_0_0 -> 6 in the cache */
   /* search427_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   /* search427_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1365, 791 },
      -1,
   } },

   /* replace427_0 -> 6 in the cache */
   /* replace427_1 -> 791 in the cache */
   /* replace427 -> 1363 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search428_0_0 -> 6 in the cache */
   /* search428_0_1 -> 9 in the cache */
   /* search428_0 -> 1365 in the cache */
   /* search428_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1365, 791 },
      -1,
   } },

   /* replace428_0 -> 6 in the cache */
   /* replace428_1 -> 791 in the cache */
   /* replace428 -> 1360 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0) */
   /* search429_0_0 -> 6 in the cache */
   /* search429_0_1 -> 9 in the cache */
   /* search429_0 -> 1365 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1365, 1368 },
      -1,
   } },

   /* replace429_0 -> 6 in the cache */
   /* replace429_1 -> 791 in the cache */
   /* replace429 -> 1363 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0) */
   /* search430_0_0 -> 6 in the cache */
   /* search430_0_1 -> 9 in the cache */
   /* search430_0 -> 1365 in the cache */
   /* search430_1 -> 1368 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1365, 1368 },
      -1,
   } },

   /* replace430_0 -> 6 in the cache */
   /* replace430_1 -> 791 in the cache */
   /* replace430 -> 1360 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search431_0_0 -> 6 in the cache */
   /* search431_0_1 -> 9 in the cache */
   /* search431_0 -> 1354 in the cache */
   /* search431_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1354, 791 },
      -1,
   } },

   /* replace431_0 -> 6 in the cache */
   /* replace431_1 -> 791 in the cache */
   /* replace431 -> 1363 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search432_0_0 -> 6 in the cache */
   /* search432_0_1 -> 9 in the cache */
   /* search432_0 -> 1354 in the cache */
   /* search432_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1354, 791 },
      -1,
   } },

   /* replace432_0 -> 6 in the cache */
   /* replace432_1 -> 791 in the cache */
   /* replace432 -> 1360 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0) */
   /* search433_0_0 -> 6 in the cache */
   /* search433_0_1 -> 9 in the cache */
   /* search433_0 -> 1354 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1354, 1373 },
      -1,
   } },

   /* replace433_0 -> 6 in the cache */
   /* replace433_1 -> 791 in the cache */
   /* replace433 -> 1363 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0) */
   /* search434_0_0 -> 6 in the cache */
   /* search434_0_1 -> 9 in the cache */
   /* search434_0 -> 1354 in the cache */
   /* search434_1 -> 1373 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1354, 1373 },
      -1,
   } },

   /* replace434_0 -> 6 in the cache */
   /* replace434_1 -> 791 in the cache */
   /* replace434 -> 1360 in the cache */

   /* ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0) */
   /* search435_0 -> 11 in the cache */
   /* search435_1_0_0 -> 11 in the cache */
   /* search435_1_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1376 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 1377 },
      -1,
   } },

   /* replace435_0 -> 11 in the cache */
   /* replace435_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 11, 813 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0) */
   /* search436_0_0 -> 11 in the cache */
   /* search436_0_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 11, 12 },
      -1,
   } },
   /* search436_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1380, 813 },
      -1,
   } },

   /* replace436_0 -> 11 in the cache */
   /* replace436_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 11, 813 },
      -1,
   } },

   /* ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0) */
   /* search437_0_0 -> 11 in the cache */
   /* search437_0_1 -> 12 in the cache */
   /* search437_0 -> 1380 in the cache */
   /* search437_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1380, 12 },
      -1,
   } },

   /* replace437_0 -> 11 in the cache */
   /* replace437_1 -> 813 in the cache */
   /* replace437 -> 1382 in the cache */

   /* ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0) */
   /* search438_0_0 -> 11 in the cache */
   /* search438_0_1 -> 12 in the cache */
   /* search438_0 -> 1380 in the cache */
   /* search438_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1380, 813 },
      -1,
   } },

   /* replace438_0 -> 11 in the cache */
   /* replace438_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 11, 813 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0) */
   /* search439_0_0 -> 11 in the cache */
   /* search439_0_1 -> 12 in the cache */
   /* search439_0 -> 1380 in the cache */
   /* search439_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1380, 12 },
      -1,
   } },

   /* replace439_0 -> 11 in the cache */
   /* replace439_1 -> 813 in the cache */
   /* replace439 -> 1385 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search440_0_0 -> 11 in the cache */
   /* search440_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   /* search440_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1387, 813 },
      -1,
   } },

   /* replace440_0 -> 11 in the cache */
   /* replace440_1 -> 813 in the cache */
   /* replace440 -> 1385 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search441_0_0 -> 11 in the cache */
   /* search441_0_1 -> 14 in the cache */
   /* search441_0 -> 1387 in the cache */
   /* search441_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1387, 813 },
      -1,
   } },

   /* replace441_0 -> 11 in the cache */
   /* replace441_1 -> 813 in the cache */
   /* replace441 -> 1382 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0) */
   /* search442_0_0 -> 11 in the cache */
   /* search442_0_1 -> 14 in the cache */
   /* search442_0 -> 1387 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1387, 1390 },
      -1,
   } },

   /* replace442_0 -> 11 in the cache */
   /* replace442_1 -> 813 in the cache */
   /* replace442 -> 1385 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0) */
   /* search443_0_0 -> 11 in the cache */
   /* search443_0_1 -> 14 in the cache */
   /* search443_0 -> 1387 in the cache */
   /* search443_1 -> 1390 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1387, 1390 },
      -1,
   } },

   /* replace443_0 -> 11 in the cache */
   /* replace443_1 -> 813 in the cache */
   /* replace443 -> 1382 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search444_0_0 -> 11 in the cache */
   /* search444_0_1 -> 14 in the cache */
   /* search444_0 -> 1376 in the cache */
   /* search444_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1376, 813 },
      -1,
   } },

   /* replace444_0 -> 11 in the cache */
   /* replace444_1 -> 813 in the cache */
   /* replace444 -> 1385 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search445_0_0 -> 11 in the cache */
   /* search445_0_1 -> 14 in the cache */
   /* search445_0 -> 1376 in the cache */
   /* search445_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1376, 813 },
      -1,
   } },

   /* replace445_0 -> 11 in the cache */
   /* replace445_1 -> 813 in the cache */
   /* replace445 -> 1382 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0) */
   /* search446_0_0 -> 11 in the cache */
   /* search446_0_1 -> 14 in the cache */
   /* search446_0 -> 1376 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1376, 1395 },
      -1,
   } },

   /* replace446_0 -> 11 in the cache */
   /* replace446_1 -> 813 in the cache */
   /* replace446 -> 1385 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0) */
   /* search447_0_0 -> 11 in the cache */
   /* search447_0_1 -> 14 in the cache */
   /* search447_0 -> 1376 in the cache */
   /* search447_1 -> 1395 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1376, 1395 },
      -1,
   } },

   /* replace447_0 -> 11 in the cache */
   /* replace447_1 -> 813 in the cache */
   /* replace447 -> 1382 in the cache */

   /* ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0) */
   /* search448_0 -> 16 in the cache */
   /* search448_1_0_0 -> 16 in the cache */
   /* search448_1_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1398 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1399 },
      -1,
   } },

   /* replace448_0 -> 16 in the cache */
   /* replace448_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 16, 120 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0) */
   /* search449_0_0 -> 16 in the cache */
   /* search449_0_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 17 },
      -1,
   } },
   /* search449_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1402, 120 },
      -1,
   } },

   /* replace449_0 -> 16 in the cache */
   /* replace449_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 16, 120 },
      -1,
   } },

   /* ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0) */
   /* search450_0_0 -> 16 in the cache */
   /* search450_0_1 -> 17 in the cache */
   /* search450_0 -> 1402 in the cache */
   /* search450_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1402, 17 },
      -1,
   } },

   /* replace450_0 -> 16 in the cache */
   /* replace450_1 -> 120 in the cache */
   /* replace450 -> 1404 in the cache */

   /* ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0) */
   /* search451_0_0 -> 16 in the cache */
   /* search451_0_1 -> 17 in the cache */
   /* search451_0 -> 1402 in the cache */
   /* search451_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1402, 120 },
      -1,
   } },

   /* replace451_0 -> 16 in the cache */
   /* replace451_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 16, 120 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0) */
   /* search452_0_0 -> 16 in the cache */
   /* search452_0_1 -> 17 in the cache */
   /* search452_0 -> 1402 in the cache */
   /* search452_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1402, 17 },
      -1,
   } },

   /* replace452_0 -> 16 in the cache */
   /* replace452_1 -> 120 in the cache */
   /* replace452 -> 1407 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search453_0_0 -> 16 in the cache */
   /* search453_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   /* search453_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1409, 120 },
      -1,
   } },

   /* replace453_0 -> 16 in the cache */
   /* replace453_1 -> 120 in the cache */
   /* replace453 -> 1407 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search454_0_0 -> 16 in the cache */
   /* search454_0_1 -> 19 in the cache */
   /* search454_0 -> 1409 in the cache */
   /* search454_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1409, 120 },
      -1,
   } },

   /* replace454_0 -> 16 in the cache */
   /* replace454_1 -> 120 in the cache */
   /* replace454 -> 1404 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0) */
   /* search455_0_0 -> 16 in the cache */
   /* search455_0_1 -> 19 in the cache */
   /* search455_0 -> 1409 in the cache */
   /* search455_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1409, 377 },
      -1,
   } },

   /* replace455_0 -> 16 in the cache */
   /* replace455_1 -> 120 in the cache */
   /* replace455 -> 1407 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0) */
   /* search456_0_0 -> 16 in the cache */
   /* search456_0_1 -> 19 in the cache */
   /* search456_0 -> 1409 in the cache */
   /* search456_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1409, 377 },
      -1,
   } },

   /* replace456_0 -> 16 in the cache */
   /* replace456_1 -> 120 in the cache */
   /* replace456 -> 1404 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search457_0_0 -> 16 in the cache */
   /* search457_0_1 -> 19 in the cache */
   /* search457_0 -> 1398 in the cache */
   /* search457_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1398, 120 },
      -1,
   } },

   /* replace457_0 -> 16 in the cache */
   /* replace457_1 -> 120 in the cache */
   /* replace457 -> 1407 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search458_0_0 -> 16 in the cache */
   /* search458_0_1 -> 19 in the cache */
   /* search458_0 -> 1398 in the cache */
   /* search458_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1398, 120 },
      -1,
   } },

   /* replace458_0 -> 16 in the cache */
   /* replace458_1 -> 120 in the cache */
   /* replace458 -> 1404 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0) */
   /* search459_0_0 -> 16 in the cache */
   /* search459_0_1 -> 19 in the cache */
   /* search459_0 -> 1398 in the cache */
   /* search459_1 -> 122 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1398, 122 },
      -1,
   } },

   /* replace459_0 -> 16 in the cache */
   /* replace459_1 -> 120 in the cache */
   /* replace459 -> 1407 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0) */
   /* search460_0_0 -> 16 in the cache */
   /* search460_0_1 -> 19 in the cache */
   /* search460_0 -> 1398 in the cache */
   /* search460_1 -> 122 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1398, 122 },
      -1,
   } },

   /* replace460_0 -> 16 in the cache */
   /* replace460_1 -> 120 in the cache */
   /* replace460 -> 1404 in the cache */

   /* ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0) */
   /* search461_0 -> 21 in the cache */
   /* search461_1_0_0 -> 21 in the cache */
   /* search461_1_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1418 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 1419 },
      -1,
   } },

   /* replace461_0 -> 21 in the cache */
   /* replace461_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 21, 856 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0) */
   /* search462_0_0 -> 21 in the cache */
   /* search462_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 21, 22 },
      -1,
   } },
   /* search462_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1422, 856 },
      -1,
   } },

   /* replace462_0 -> 21 in the cache */
   /* replace462_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 21, 856 },
      -1,
   } },

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0) */
   /* search463_0_0 -> 21 in the cache */
   /* search463_0_1 -> 22 in the cache */
   /* search463_0 -> 1422 in the cache */
   /* search463_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1422, 22 },
      -1,
   } },

   /* replace463_0 -> 21 in the cache */
   /* replace463_1 -> 856 in the cache */
   /* replace463 -> 1424 in the cache */

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0) */
   /* search464_0_0 -> 21 in the cache */
   /* search464_0_1 -> 22 in the cache */
   /* search464_0 -> 1422 in the cache */
   /* search464_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1422, 856 },
      -1,
   } },

   /* replace464_0 -> 21 in the cache */
   /* replace464_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 21, 856 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0) */
   /* search465_0_0 -> 21 in the cache */
   /* search465_0_1 -> 22 in the cache */
   /* search465_0 -> 1422 in the cache */
   /* search465_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1422, 22 },
      -1,
   } },

   /* replace465_0 -> 21 in the cache */
   /* replace465_1 -> 856 in the cache */
   /* replace465 -> 1427 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search466_0_0 -> 21 in the cache */
   /* search466_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   /* search466_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1429, 856 },
      -1,
   } },

   /* replace466_0 -> 21 in the cache */
   /* replace466_1 -> 856 in the cache */
   /* replace466 -> 1427 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search467_0_0 -> 21 in the cache */
   /* search467_0_1 -> 24 in the cache */
   /* search467_0 -> 1429 in the cache */
   /* search467_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1429, 856 },
      -1,
   } },

   /* replace467_0 -> 21 in the cache */
   /* replace467_1 -> 856 in the cache */
   /* replace467 -> 1424 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0) */
   /* search468_0_0 -> 21 in the cache */
   /* search468_0_1 -> 24 in the cache */
   /* search468_0 -> 1429 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1429, 1432 },
      -1,
   } },

   /* replace468_0 -> 21 in the cache */
   /* replace468_1 -> 856 in the cache */
   /* replace468 -> 1427 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0) */
   /* search469_0_0 -> 21 in the cache */
   /* search469_0_1 -> 24 in the cache */
   /* search469_0 -> 1429 in the cache */
   /* search469_1 -> 1432 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1429, 1432 },
      -1,
   } },

   /* replace469_0 -> 21 in the cache */
   /* replace469_1 -> 856 in the cache */
   /* replace469 -> 1424 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search470_0_0 -> 21 in the cache */
   /* search470_0_1 -> 24 in the cache */
   /* search470_0 -> 1418 in the cache */
   /* search470_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1418, 856 },
      -1,
   } },

   /* replace470_0 -> 21 in the cache */
   /* replace470_1 -> 856 in the cache */
   /* replace470 -> 1427 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search471_0_0 -> 21 in the cache */
   /* search471_0_1 -> 24 in the cache */
   /* search471_0 -> 1418 in the cache */
   /* search471_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1418, 856 },
      -1,
   } },

   /* replace471_0 -> 21 in the cache */
   /* replace471_1 -> 856 in the cache */
   /* replace471 -> 1424 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0) */
   /* search472_0_0 -> 21 in the cache */
   /* search472_0_1 -> 24 in the cache */
   /* search472_0 -> 1418 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1418, 1437 },
      -1,
   } },

   /* replace472_0 -> 21 in the cache */
   /* replace472_1 -> 856 in the cache */
   /* replace472 -> 1427 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0) */
   /* search473_0_0 -> 21 in the cache */
   /* search473_0_1 -> 24 in the cache */
   /* search473_0 -> 1418 in the cache */
   /* search473_1 -> 1437 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1418, 1437 },
      -1,
   } },

   /* replace473_0 -> 21 in the cache */
   /* replace473_1 -> 856 in the cache */
   /* replace473 -> 1424 in the cache */

   /* ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a')) */
   /* search474_0 -> 32 in the cache */
   /* search474_1_0 -> 32 in the cache */
   /* search474_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 98 },
      -1,
   } },

   /* replace474_0_0 -> 32 in the cache */
   /* replace474_0 -> 103 in the cache */
   /* replace474 -> 1205 in the cache */

   /* ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a')) */
   /* search475_0 -> 32 in the cache */
   /* search475_1_0 -> 32 in the cache */
   /* search475_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 100 },
      -1,
   } },

   /* replace475_0_0 -> 32 in the cache */
   /* replace475_0 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 106 },
      -1,
   } },

   /* ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a')) */
   /* search476_0 -> 32 in the cache */
   /* search476_1_0_0 -> 32 in the cache */
   /* search476_1_0 -> 103 in the cache */
   /* search476_1 -> 1205 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 1205 },
      -1,
   } },

   /* replace476_0_0 -> 32 in the cache */
   /* replace476_0 -> 103 in the cache */
   /* replace476 -> 1205 in the cache */

   /* ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a')) */
   /* search477_0 -> 32 in the cache */
   /* search477_1_0_0 -> 32 in the cache */
   /* search477_1_0 -> 106 in the cache */
   /* search477_1 -> 1442 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 1442 },
      -1,
   } },

   /* replace477_0_0 -> 32 in the cache */
   /* replace477_0 -> 106 in the cache */
   /* replace477 -> 1442 in the cache */

   /* ('~fmin', 'a', ('fabs', 'a')) => a */
   /* search478_0 -> 32 in the cache */
   /* search478_1_0 -> 32 in the cache */
   /* search478_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 103 },
      -1,
   } },

   /* replace478 -> 32 in the cache */

   /* ('imin', 'a', ('iabs', 'a')) => a */
   /* search479_0 -> 32 in the cache */
   /* search479_1_0 -> 32 in the cache */
   /* search479_1 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 106 },
      -1,
   } },

   /* replace479 -> 32 in the cache */

   /* ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a */
   /* search480_0 -> 32 in the cache */
   /* search480_1_0_0 -> 32 in the cache */
   /* search480_1_0 -> 103 in the cache */
   /* search480_1 -> 1205 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 1205 },
      -1,
   } },

   /* replace480 -> 32 in the cache */

   /* ('imax', 'a', ('ineg', ('iabs', 'a'))) => a */
   /* search481_0 -> 32 in the cache */
   /* search481_1_0_0 -> 32 in the cache */
   /* search481_1_0 -> 106 in the cache */
   /* search481_1 -> 1442 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 1442 },
      -1,
   } },

   /* replace481 -> 32 in the cache */

   /* ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a') */
   /* search482_0 -> 32 in the cache */
   /* search482_1_0 -> 32 in the cache */
   /* search482_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 103 },
      -1,
   } },

   /* replace482_0 -> 32 in the cache */
   /* replace482 -> 103 in the cache */

   /* ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a') */
   /* search483_0 -> 32 in the cache */
   /* search483_1_0 -> 32 in the cache */
   /* search483_1 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 106 },
      -1,
   } },

   /* replace483_0 -> 32 in the cache */
   /* replace483 -> 106 in the cache */

   /* ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a') */
   /* search484_0 -> 32 in the cache */
   /* search484_1_0 -> 32 in the cache */
   /* search484_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 98 },
      -1,
   } },

   /* replace484_0 -> 32 in the cache */
   /* replace484 -> 103 in the cache */

   /* ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a') */
   /* search485_0 -> 32 in the cache */
   /* search485_1_0 -> 32 in the cache */
   /* search485_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 100 },
      -1,
   } },

   /* replace485_0 -> 32 in the cache */
   /* replace485 -> 106 in the cache */

   /* ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a') */
   /* search486_0_0 -> 32 in the cache */
   /* search486_0 -> 103 in the cache */
   /* search486_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 103, 113 },
      -1,
   } },

   /* replace486_0 -> 32 in the cache */
   /* replace486 -> 103 in the cache */

   /* ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a') */
   /* search487_0_0 -> 32 in the cache */
   /* search487_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 113 },
      -1,
   } },
   /* search487_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1454, 226 },
      -1,
   } },

   /* replace487_0 -> 32 in the cache */
   /* replace487 -> 202 in the cache */

   /* ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a') */
   /* search488_0_0 -> 32 in the cache */
   /* search488_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 226 },
      -1,
   } },
   /* search488_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1456, 113 },
      -1,
   } },

   /* replace488_0 -> 32 in the cache */
   /* replace488 -> 202 in the cache */

   /* ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search489_0_0 -> 32 in the cache */
   /* search489_0_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 232 },
      -1,
   } },
   /* search489_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1458, 113 },
      -1,
   } },

   /* replace489_0_0_0 -> 32 in the cache */
   /* replace489_0_0 -> 98 in the cache */
   /* replace489_0 -> 203 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 203 },
      -1,
   } },

   /* ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search490_0_0 -> 32 in the cache */
   /* search490_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 113 },
      -1,
   } },
   /* search490_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1461, 232 },
      -1,
   } },

   /* replace490_0_0_0 -> 32 in the cache */
   /* replace490_0_0 -> 98 in the cache */
   /* replace490_0 -> 203 in the cache */
   /* replace490 -> 1460 in the cache */

   /* ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a')) */
   /* search491_0_0 -> 32 in the cache */
   /* search491_0 -> 235 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 235 },
      -1,
   } },

   /* replace491_0_0 -> 113 in the cache */
   /* replace491_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1464 },
      -1,
   } },

   /* ('fsat', ('b2f', 'a')) => ('b2f', 'a') */
   /* search492_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1466 },
      -1,
   } },

   /* replace492_0 -> 32 in the cache */
   /* replace492 -> 1466 in the cache */

   /* ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0) */
   /* search493_0 -> 32 in the cache */
   /* search493 -> 202 in the cache */

   /* replace493_0_0 -> 32 in the cache */
   /* replace493_0_1 -> 113 in the cache */
   /* replace493_0 -> 1454 in the cache */
   /* replace493_1 -> 226 in the cache */
   /* replace493 -> 1455 in the cache */

   /* ('fsat', ('fsat', 'a')) => ('fsat', 'a') */
   /* search494_0_0 -> 32 in the cache */
   /* search494_0 -> 202 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 202 },
      -1,
   } },

   /* replace494_0 -> 32 in the cache */
   /* replace494 -> 202 in the cache */

   /* ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b'))) */
   /* search495_0_0_0 -> 0 in the cache */
   /* search495_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1469 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1470 },
      -1,
   } },

   /* replace495_0_0_0 -> 0 in the cache */
   /* replace495_0_0 -> 197 in the cache */
   /* replace495_0_1_0 -> 3 in the cache */
   /* replace495_0_1 -> 1043 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 197, 1043 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1472 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b')) */
   /* search496_0_0_0 -> 0 in the cache */
   /* search496_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1474 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1475 },
      -1,
   } },

   /* replace496_0_0_0 -> 0 in the cache */
   /* replace496_0_0 -> 197 in the cache */
   /* replace496_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 197, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1477 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b')) */
   /* search497_0_0_0 -> 16 in the cache */
   /* search497_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1479 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1480 },
      -1,
   } },

   /* replace497_0_0_0 -> 16 in the cache */
   /* replace497_0_0 -> 265 in the cache */
   /* replace497_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 265, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1482 },
      -1,
   } },

   /* ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b'))) */
   /* search498_0_0_0 -> 0 in the cache */
   /* search498_0_0_1 -> 3 in the cache */
   /* search498_0_0 -> 1474 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 1474 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1484 },
      -1,
   } },

   /* replace498_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace498_0_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1486, 1487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1488 },
      -1,
   } },

   /* ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c') */
   /* search499_0_0_0_0 -> 124 in the cache */
   /* search499_0_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      3, 1,
      { 124, 125 },
      -1,
   } },
   /* search499_0_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 2,
      { 1490, 127 },
      -1,
   } },
   /* search499_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 3,
      { 1491, 125 },
      -1,
   } },
   /* search499_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 4,
      { 1492, 127 },
      -1,
   } },

   /* replace499_0_0 -> 124 in the cache */
   /* replace499_0_1 -> 125 in the cache */
   /* replace499_0 -> 1298 in the cache */
   /* replace499_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1298, 127 },
      -1,
   } },

   /* ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c') */
   /* search500_0_0_0_0 -> 124 in the cache */
   /* search500_0_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      3, 1,
      { 124, 125 },
      -1,
   } },
   /* search500_0_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 2,
      { 1495, 127 },
      -1,
   } },
   /* search500_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 3,
      { 1496, 125 },
      -1,
   } },
   /* search500_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1497, 127 },
      -1,
   } },

   /* replace500_0_0 -> 124 in the cache */
   /* replace500_0_1 -> 125 in the cache */
   /* replace500_0 -> 1308 in the cache */
   /* replace500_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1308, 127 },
      -1,
   } },

   /* ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c') */
   /* search501_0_0_0_0 -> 124 in the cache */
   /* search501_0_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      3, 1,
      { 124, 125 },
      -1,
   } },
   /* search501_0_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 2,
      { 1500, 127 },
      -1,
   } },
   /* search501_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 3,
      { 1501, 125 },
      -1,
   } },
   /* search501_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 4,
      { 1502, 127 },
      -1,
   } },

   /* replace501_0_0 -> 124 in the cache */
   /* replace501_0_1 -> 125 in the cache */
   /* replace501_0 -> 1303 in the cache */
   /* replace501_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1303, 127 },
      -1,
   } },

   /* ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b')) */
   /* search502_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1505, 1506 },
      -1,
   } },

   /* replace502_0_0 -> 0 in the cache */
   /* replace502_0_1 -> 3 in the cache */
   /* replace502_0 -> 1232 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1232 },
      -1,
   } },

   /* ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b')) */
   /* search503_0_0 -> 0 in the cache */
   /* search503_0 -> 1505 in the cache */
   /* search503_1 -> 1506 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1505, 1506 },
      -1,
   } },

   /* replace503_0_0 -> 0 in the cache */
   /* replace503_0_1 -> 3 in the cache */
   /* replace503_0 -> 1234 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1234 },
      -1,
   } },

   /* ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a')) */
   /* search504_0_0_0 -> 1067 in the cache */
   /* search504_0_0_1 -> 1064 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1067, 1064 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1511 },
      -1,
   } },
   /* search504_1 -> 1067 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1512, 1067 },
      -1,
   } },

   /* replace504_0_0 -> 1067 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1067 },
      -1,
   } },
   /* replace504_1_0 -> 1064 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1064 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1514, 1515 },
      -1,
   } },

   /* ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a')) */
   /* search505_0_0_0 -> 1067 in the cache */
   /* search505_0_0_1 -> 1064 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 1067, 1064 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1517 },
      -1,
   } },
   /* search505_1 -> 1067 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1518, 1067 },
      -1,
   } },

   /* replace505_0_0_0 -> 1067 in the cache */
   /* replace505_0_0 -> 1514 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1514 },
      -1,
   } },
   /* replace505_1_0 -> 1064 in the cache */
   /* replace505_1 -> 1515 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1520, 1515 },
      -1,
   } },

   /* ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1522 },
      -1,
   } },
   /* search506_0_1 -> 1506 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1523, 1506 },
      0,
   } },
   /* search506_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1524, 241 },
      -1,
   } },

   /* replace506_0_0_0 -> 0 in the cache */
   /* replace506_0_0 -> 197 in the cache */
   /* replace506_0_1 -> 3 in the cache */
   /* replace506_0 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 262 },
      -1,
   } },

   /* ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255) */
   /* search507_0_0_0 -> 32 in the cache */
   /* search507_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 32, 61 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1527, 1528 },
      -1,
   } },
   /* search507_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 2,
      { 1529, 61 },
      -1,
   } },

   /* replace507_0_0 -> 32 in the cache */
   /* replace507_0_1 -> 61 in the cache */
   /* replace507_0 -> 1527 in the cache */
   /* replace507_1 -> 1528 in the cache */
   /* replace507 -> 1529 in the cache */

   /* ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search508_0_0 -> 124 in the cache */
   /* search508_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search508_1_0 -> 124 in the cache */
   /* search508_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1531, 1532 },
      -1,
   } },

   /* replace508_0 -> 124 in the cache */
   /* replace508_1_0 -> 125 in the cache */
   /* replace508_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 124, 1534 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   /* search509_0_0 -> 0 in the cache */
   /* search509_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 665 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search509_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1537, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1536, 1538 },
      -1,
   } },

   /* replace509_0_0 -> 0 in the cache */
   /* replace509_0_1 -> 1537 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1537 },
      -1,
   } },
   /* replace509_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1540, 665 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search510_0_0 -> 124 in the cache */
   /* search510_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search510_1_0 -> 124 in the cache */
   /* search510_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1542, 1543 },
      -1,
   } },

   /* replace510_0 -> 124 in the cache */
   /* replace510_1_0 -> 125 in the cache */
   /* replace510_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 124, 1545 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search511_0_0 -> 0 in the cache */
   /* search511_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search511_1_0 -> 1537 in the cache */
   /* search511_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1537, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1547, 1548 },
      -1,
   } },

   /* replace511_0_0 -> 0 in the cache */
   /* replace511_0_1 -> 1537 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1537 },
      -1,
   } },
   /* replace511_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1550, 665 },
      -1,
   } },

   /* ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search512_0_0 -> 124 in the cache */
   /* search512_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 268 },
      -1,
   } },
   /* search512_1_0 -> 124 in the cache */
   /* search512_1_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 769 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1552, 1553 },
      -1,
   } },

   /* replace512_0 -> 124 in the cache */
   /* replace512_1_0 -> 125 in the cache */
   /* replace512_1_1 -> 127 in the cache */
   /* replace512_1 -> 1534 in the cache */
   /* replace512 -> 1535 in the cache */

   /* ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search513_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1555, 665 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search513_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1557, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1556, 1558 },
      -1,
   } },

   /* replace513_0_0 -> 0 in the cache */
   /* replace513_0_1 -> 1537 in the cache */
   /* replace513_0 -> 1540 in the cache */
   /* replace513_1 -> 665 in the cache */
   /* replace513 -> 1541 in the cache */

   /* ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search514_0_0 -> 124 in the cache */
   /* search514_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 268 },
      -1,
   } },
   /* search514_1_0 -> 124 in the cache */
   /* search514_1_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 769 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1560, 1561 },
      -1,
   } },

   /* replace514_0 -> 124 in the cache */
   /* replace514_1_0 -> 125 in the cache */
   /* replace514_1_1 -> 127 in the cache */
   /* replace514_1 -> 1545 in the cache */
   /* replace514 -> 1546 in the cache */

   /* ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search515_0_0 -> 1555 in the cache */
   /* search515_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1555, 665 },
      -1,
   } },
   /* search515_1_0 -> 1557 in the cache */
   /* search515_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1557, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1563, 1564 },
      -1,
   } },

   /* replace515_0_0 -> 0 in the cache */
   /* replace515_0_1 -> 1537 in the cache */
   /* replace515_0 -> 1550 in the cache */
   /* replace515_1 -> 665 in the cache */
   /* replace515 -> 1551 in the cache */

   /* ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search516_0_0 -> 124 in the cache */
   /* search516_0_1 -> 125 in the cache */
   /* search516_0 -> 1531 in the cache */
   /* search516_1_0 -> 124 in the cache */
   /* search516_1_1 -> 127 in the cache */
   /* search516_1 -> 1532 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1531, 1532 },
      -1,
   } },

   /* replace516_0 -> 124 in the cache */
   /* replace516_1_0 -> 125 in the cache */
   /* replace516_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 124, 1567 },
      -1,
   } },

   /* ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   /* search517_0_0 -> 0 in the cache */
   /* search517_0_1 -> 665 in the cache */
   /* search517_0 -> 1536 in the cache */
   /* search517_1_0 -> 1537 in the cache */
   /* search517_1_1 -> 665 in the cache */
   /* search517_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1536, 1538 },
      -1,
   } },

   /* replace517_0_0 -> 0 in the cache */
   /* replace517_0_1 -> 1537 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1537 },
      -1,
   } },
   /* replace517_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1570, 665 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search518_0_0 -> 124 in the cache */
   /* search518_0_1 -> 125 in the cache */
   /* search518_0 -> 1542 in the cache */
   /* search518_1_0 -> 124 in the cache */
   /* search518_1_1 -> 127 in the cache */
   /* search518_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1542, 1543 },
      -1,
   } },

   /* replace518_0 -> 124 in the cache */
   /* replace518_1_0 -> 125 in the cache */
   /* replace518_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 124, 1573 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search519_0_0 -> 0 in the cache */
   /* search519_0_1 -> 665 in the cache */
   /* search519_0 -> 1547 in the cache */
   /* search519_1_0 -> 1537 in the cache */
   /* search519_1_1 -> 665 in the cache */
   /* search519_1 -> 1548 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1547, 1548 },
      -1,
   } },

   /* replace519_0_0 -> 0 in the cache */
   /* replace519_0_1 -> 1537 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1537 },
      -1,
   } },
   /* replace519_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1576, 665 },
      -1,
   } },

   /* ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search520_0_0 -> 124 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 1578 },
      -1,
   } },
   /* search520_1_0 -> 124 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 1580 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1579, 1581 },
      -1,
   } },

   /* replace520_0 -> 124 in the cache */
   /* replace520_1_0 -> 125 in the cache */
   /* replace520_1_1 -> 127 in the cache */
   /* replace520_1 -> 1567 in the cache */
   /* replace520 -> 1568 in the cache */

   /* ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search521_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1583, 665 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search521_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1585, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1584, 1586 },
      -1,
   } },

   /* replace521_0_0 -> 0 in the cache */
   /* replace521_0_1 -> 1537 in the cache */
   /* replace521_0 -> 1570 in the cache */
   /* replace521_1 -> 665 in the cache */
   /* replace521 -> 1571 in the cache */

   /* ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search522_0_0 -> 124 in the cache */
   /* search522_0_1 -> 1578 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 1578 },
      -1,
   } },
   /* search522_1_0 -> 124 in the cache */
   /* search522_1_1 -> 1580 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 1580 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1588, 1589 },
      -1,
   } },

   /* replace522_0 -> 124 in the cache */
   /* replace522_1_0 -> 125 in the cache */
   /* replace522_1_1 -> 127 in the cache */
   /* replace522_1 -> 1573 in the cache */
   /* replace522 -> 1574 in the cache */

   /* ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search523_0_0 -> 1583 in the cache */
   /* search523_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1583, 665 },
      -1,
   } },
   /* search523_1_0 -> 1585 in the cache */
   /* search523_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1585, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1591, 1592 },
      -1,
   } },

   /* replace523_0_0 -> 0 in the cache */
   /* replace523_0_1 -> 1537 in the cache */
   /* replace523_0 -> 1576 in the cache */
   /* replace523_1 -> 665 in the cache */
   /* replace523 -> 1577 in the cache */

   /* ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c')) */
   /* search524_0_0 -> 124 in the cache */
   /* search524_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search524_1_0 -> 124 in the cache */
   /* search524_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1594, 1595 },
      -1,
   } },

   /* replace524_0 -> 124 in the cache */
   /* replace524_1_0 -> 125 in the cache */
   /* replace524_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 124, 1597 },
      -1,
   } },

   /* ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c') */
   /* search525_0_0 -> 0 in the cache */
   /* search525_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search525_1_0 -> 1537 in the cache */
   /* search525_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1537, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1599, 1600 },
      -1,
   } },

   /* replace525_0_0 -> 0 in the cache */
   /* replace525_0_1 -> 1537 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1537 },
      -1,
   } },
   /* replace525_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1602, 665 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c')) */
   /* search526_0_0 -> 124 in the cache */
   /* search526_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search526_1_0 -> 124 in the cache */
   /* search526_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1604, 1605 },
      -1,
   } },

   /* replace526_0 -> 124 in the cache */
   /* replace526_1_0 -> 125 in the cache */
   /* replace526_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 124, 1607 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c') */
   /* search527_0_0 -> 0 in the cache */
   /* search527_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search527_1_0 -> 1537 in the cache */
   /* search527_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1537, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1609, 1610 },
      -1,
   } },

   /* replace527_0_0 -> 0 in the cache */
   /* replace527_0_1 -> 1537 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1537 },
      -1,
   } },
   /* replace527_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1612, 665 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c')) */
   /* search528_0_0 -> 124 in the cache */
   /* search528_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search528_1_0 -> 124 in the cache */
   /* search528_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1614, 1615 },
      -1,
   } },

   /* replace528_0 -> 124 in the cache */
   /* replace528_1_0 -> 125 in the cache */
   /* replace528_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 124, 1617 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c') */
   /* search529_0_0 -> 0 in the cache */
   /* search529_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search529_1_0 -> 1537 in the cache */
   /* search529_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1537, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1619, 1620 },
      -1,
   } },

   /* replace529_0_0 -> 0 in the cache */
   /* replace529_0_1 -> 1537 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1537 },
      -1,
   } },
   /* replace529_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1622, 665 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c')) */
   /* search530_0_0 -> 124 in the cache */
   /* search530_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search530_1_0 -> 124 in the cache */
   /* search530_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1624, 1625 },
      -1,
   } },

   /* replace530_0 -> 124 in the cache */
   /* replace530_1_0 -> 125 in the cache */
   /* replace530_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 124, 1627 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c') */
   /* search531_0_0 -> 0 in the cache */
   /* search531_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search531_1_0 -> 1537 in the cache */
   /* search531_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1537, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1629, 1630 },
      -1,
   } },

   /* replace531_0_0 -> 0 in the cache */
   /* replace531_0_1 -> 1537 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1537 },
      -1,
   } },
   /* replace531_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1632, 665 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c')) */
   /* search532_0_0 -> 124 in the cache */
   /* search532_0_1 -> 125 in the cache */
   /* search532_0 -> 1594 in the cache */
   /* search532_1_0 -> 124 in the cache */
   /* search532_1_1 -> 127 in the cache */
   /* search532_1 -> 1595 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1594, 1595 },
      -1,
   } },

   /* replace532_0 -> 124 in the cache */
   /* replace532_1_0 -> 125 in the cache */
   /* replace532_1_1 -> 127 in the cache */
   /* replace532_1 -> 1607 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 124, 1607 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c') */
   /* search533_0_0 -> 0 in the cache */
   /* search533_0_1 -> 665 in the cache */
   /* search533_0 -> 1599 in the cache */
   /* search533_1_0 -> 1537 in the cache */
   /* search533_1_1 -> 665 in the cache */
   /* search533_1 -> 1600 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1599, 1600 },
      -1,
   } },

   /* replace533_0_0 -> 0 in the cache */
   /* replace533_0_1 -> 1537 in the cache */
   /* replace533_0 -> 1612 in the cache */
   /* replace533_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1612, 665 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c')) */
   /* search534_0_0 -> 124 in the cache */
   /* search534_0_1 -> 125 in the cache */
   /* search534_0 -> 1604 in the cache */
   /* search534_1_0 -> 124 in the cache */
   /* search534_1_1 -> 127 in the cache */
   /* search534_1 -> 1605 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1604, 1605 },
      -1,
   } },

   /* replace534_0 -> 124 in the cache */
   /* replace534_1_0 -> 125 in the cache */
   /* replace534_1_1 -> 127 in the cache */
   /* replace534_1 -> 1597 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 124, 1597 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c') */
   /* search535_0_0 -> 0 in the cache */
   /* search535_0_1 -> 665 in the cache */
   /* search535_0 -> 1609 in the cache */
   /* search535_1_0 -> 1537 in the cache */
   /* search535_1_1 -> 665 in the cache */
   /* search535_1 -> 1610 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1609, 1610 },
      -1,
   } },

   /* replace535_0_0 -> 0 in the cache */
   /* replace535_0_1 -> 1537 in the cache */
   /* replace535_0 -> 1602 in the cache */
   /* replace535_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1602, 665 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c')) */
   /* search536_0_0 -> 124 in the cache */
   /* search536_0_1 -> 125 in the cache */
   /* search536_0 -> 1614 in the cache */
   /* search536_1_0 -> 124 in the cache */
   /* search536_1_1 -> 127 in the cache */
   /* search536_1 -> 1615 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1614, 1615 },
      -1,
   } },

   /* replace536_0 -> 124 in the cache */
   /* replace536_1_0 -> 125 in the cache */
   /* replace536_1_1 -> 127 in the cache */
   /* replace536_1 -> 1627 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 124, 1627 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c') */
   /* search537_0_0 -> 0 in the cache */
   /* search537_0_1 -> 665 in the cache */
   /* search537_0 -> 1619 in the cache */
   /* search537_1_0 -> 1537 in the cache */
   /* search537_1_1 -> 665 in the cache */
   /* search537_1 -> 1620 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1619, 1620 },
      -1,
   } },

   /* replace537_0_0 -> 0 in the cache */
   /* replace537_0_1 -> 1537 in the cache */
   /* replace537_0 -> 1632 in the cache */
   /* replace537_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1632, 665 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c')) */
   /* search538_0_0 -> 124 in the cache */
   /* search538_0_1 -> 125 in the cache */
   /* search538_0 -> 1624 in the cache */
   /* search538_1_0 -> 124 in the cache */
   /* search538_1_1 -> 127 in the cache */
   /* search538_1 -> 1625 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1624, 1625 },
      -1,
   } },

   /* replace538_0 -> 124 in the cache */
   /* replace538_1_0 -> 125 in the cache */
   /* replace538_1_1 -> 127 in the cache */
   /* replace538_1 -> 1617 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 124, 1617 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c') */
   /* search539_0_0 -> 0 in the cache */
   /* search539_0_1 -> 665 in the cache */
   /* search539_0 -> 1629 in the cache */
   /* search539_1_0 -> 1537 in the cache */
   /* search539_1_1 -> 665 in the cache */
   /* search539_1 -> 1630 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1629, 1630 },
      -1,
   } },

   /* replace539_0_0 -> 0 in the cache */
   /* replace539_0_1 -> 1537 in the cache */
   /* replace539_0 -> 1622 in the cache */
   /* replace539_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1622, 665 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search540_0_0_0 -> 0 in the cache */
   /* search540_0_0_1 -> 665 in the cache */
   /* search540_0_0 -> 1536 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1536, 1650 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search540_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1652, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1651, 1653 },
      -1,
   } },

   /* replace540_0_0_0 -> 0 in the cache */
   /* replace540_0_0_1 -> 1652 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1652 },
      -1,
   } },
   /* replace540_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1655, 665 },
      -1,
   } },
   /* replace540_1 -> 1650 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1656, 1650 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search541_0_0_0 -> 0 in the cache */
   /* search541_0_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 665 },
      -1,
   } },
   /* search541_0_1 -> 1650 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1658, 1650 },
      0,
   } },
   /* search541_1_0 -> 1652 in the cache */
   /* search541_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1652, 665 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1659, 1660 },
      -1,
   } },

   /* replace541_0_0_0 -> 0 in the cache */
   /* replace541_0_0_1 -> 1652 in the cache */
   /* replace541_0_0 -> 1655 in the cache */
   /* replace541_0_1 -> 665 in the cache */
   /* replace541_0 -> 1656 in the cache */
   /* replace541_1 -> 1650 in the cache */
   /* replace541 -> 1657 in the cache */

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search542_0_0_0 -> 147 in the cache */
   /* search542_0_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 147, 148 },
      0,
   } },
   /* search542_0_1 -> 1650 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1662, 1650 },
      0,
   } },
   /* search542_1_0 -> 147 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 147, 1664 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1663, 1665 },
      -1,
   } },

   /* replace542_0_0 -> 147 in the cache */
   /* replace542_0_1_0 -> 148 in the cache */
   /* replace542_0_1_1 -> 1664 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      true,
      false,
      nir_op_fmax,
      1, 1,
      { 148, 1664 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 147, 1667 },
      -1,
   } },
   /* replace542_1 -> 1650 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1668, 1650 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search543_0_0_0 -> 147 in the cache */
   /* search543_0_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 147, 148 },
      -1,
   } },
   /* search543_0_1 -> 1650 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1670, 1650 },
      0,
   } },
   /* search543_1_0 -> 147 in the cache */
   /* search543_1_1 -> 1664 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 147, 1664 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1671, 1672 },
      -1,
   } },

   /* replace543_0_0 -> 147 in the cache */
   /* replace543_0_1_0 -> 148 in the cache */
   /* replace543_0_1_1 -> 1664 in the cache */
   /* replace543_0_1 -> 1667 in the cache */
   /* replace543_0 -> 1668 in the cache */
   /* replace543_1 -> 1650 in the cache */
   /* replace543 -> 1669 in the cache */

   /* ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b') */
   /* search544_0_0 -> 998 in the cache */
   /* search544_0_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 998, 999 },
      -1,
   } },
   /* search544_1_0 -> 3 in the cache */
   /* search544_1_1 -> 0 in the cache */
   /* search544_1 -> 1034 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1674, 1034 },
      -1,
   } },

   /* replace544_0 -> 0 in the cache */
   /* replace544_1 -> 3 in the cache */
   /* replace544 -> 1008 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search545_0_0 -> 115 in the cache */
   /* search545_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 115, 11 },
      0,
   } },
   /* search545_1_0 -> 243 in the cache */
   /* search545_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 243, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1676, 1677 },
      -1,
   } },

   /* replace545_0 -> 115 in the cache */
   /* replace545_1_0 -> 11 in the cache */
   /* replace545_1_1_0 -> 243 in the cache */
   /* replace545_1_1 -> 515 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 11, 515 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 115, 1679 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search546_0_0 -> 115 in the cache */
   /* search546_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 115, 11 },
      -1,
   } },
   /* search546_1_0 -> 243 in the cache */
   /* search546_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 243, 115 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1681, 1682 },
      -1,
   } },

   /* replace546_0 -> 115 in the cache */
   /* replace546_1_0 -> 11 in the cache */
   /* replace546_1_1_0 -> 243 in the cache */
   /* replace546_1_1 -> 515 in the cache */
   /* replace546_1 -> 1679 in the cache */
   /* replace546 -> 1680 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search547_0_0 -> 115 in the cache */
   /* search547_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 115, 11 },
      0,
   } },
   /* search547_1_0 -> 243 in the cache */
   /* search547_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 243, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1684, 1685 },
      -1,
   } },

   /* replace547_0 -> 115 in the cache */
   /* replace547_1_0 -> 11 in the cache */
   /* replace547_1_1_0 -> 243 in the cache */
   /* replace547_1_1 -> 515 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 11, 515 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 115, 1687 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search548_0_0 -> 115 in the cache */
   /* search548_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 115, 11 },
      -1,
   } },
   /* search548_1_0 -> 243 in the cache */
   /* search548_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 243, 115 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1689, 1690 },
      -1,
   } },

   /* replace548_0 -> 115 in the cache */
   /* replace548_1_0 -> 11 in the cache */
   /* replace548_1_1_0 -> 243 in the cache */
   /* replace548_1_1 -> 515 in the cache */
   /* replace548_1 -> 1687 in the cache */
   /* replace548 -> 1688 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search549_0_0 -> 115 in the cache */
   /* search549_0_1 -> 11 in the cache */
   /* search549_0 -> 1676 in the cache */
   /* search549_1_0 -> 243 in the cache */
   /* search549_1_1 -> 115 in the cache */
   /* search549_1 -> 1677 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1676, 1677 },
      -1,
   } },

   /* replace549_0 -> 115 in the cache */
   /* replace549_1_0 -> 11 in the cache */
   /* replace549_1_1_0 -> 243 in the cache */
   /* replace549_1_1 -> 515 in the cache */
   /* replace549_1 -> 1687 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 115, 1687 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search550_0_0 -> 115 in the cache */
   /* search550_0_1 -> 11 in the cache */
   /* search550_0 -> 1681 in the cache */
   /* search550_1_0 -> 243 in the cache */
   /* search550_1_1 -> 115 in the cache */
   /* search550_1 -> 1682 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1681, 1682 },
      -1,
   } },

   /* replace550_0 -> 115 in the cache */
   /* replace550_1_0 -> 11 in the cache */
   /* replace550_1_1_0 -> 243 in the cache */
   /* replace550_1_1 -> 515 in the cache */
   /* replace550_1 -> 1687 in the cache */
   /* replace550 -> 1693 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search551_0_0 -> 115 in the cache */
   /* search551_0_1 -> 11 in the cache */
   /* search551_0 -> 1684 in the cache */
   /* search551_1_0 -> 243 in the cache */
   /* search551_1_1 -> 115 in the cache */
   /* search551_1 -> 1685 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1684, 1685 },
      -1,
   } },

   /* replace551_0 -> 115 in the cache */
   /* replace551_1_0 -> 11 in the cache */
   /* replace551_1_1_0 -> 243 in the cache */
   /* replace551_1_1 -> 515 in the cache */
   /* replace551_1 -> 1679 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 115, 1679 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search552_0_0 -> 115 in the cache */
   /* search552_0_1 -> 11 in the cache */
   /* search552_0 -> 1689 in the cache */
   /* search552_1_0 -> 243 in the cache */
   /* search552_1_1 -> 115 in the cache */
   /* search552_1 -> 1690 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1689, 1690 },
      -1,
   } },

   /* replace552_0 -> 115 in the cache */
   /* replace552_1_0 -> 11 in the cache */
   /* replace552_1_1_0 -> 243 in the cache */
   /* replace552_1_1 -> 515 in the cache */
   /* replace552_1 -> 1679 in the cache */
   /* replace552 -> 1696 in the cache */

   /* ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search553_0_0 -> 11 in the cache */
   /* search553_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 11, 115 },
      -1,
   } },
   /* search553_1 -> 462 in the cache */
   /* search553_2_0_0_0_0 -> 115 in the cache */
   /* search553_2_0_0_0_1 -> 11 in the cache */
   /* search553_2_0_0_0 -> 1681 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1681 },
      -1,
   } },
   /* search553_2_0_1_0_0_0 -> 11 in the cache */
   /* search553_2_0_1_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1700 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1701 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1699, 1702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1698, 462, 1704 },
      -1,
   } },

   /* replace553_0_0_0_0 -> 11 in the cache */
   /* replace553_0_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1706 },
      -1,
   } },
   /* replace553_0_1_0_0_0 -> 11 in the cache */
   /* replace553_0_1_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1709 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1707, 1710 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1711 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search554_0 -> 715 in the cache */
   /* search554_1_0 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 243 },
      0,
   } },
   /* search554_2_0 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 450 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1713, 1714 },
      -1,
   } },

   /* replace554_0_0 -> 715 in the cache */
   /* replace554_0_1 -> 243 in the cache */
   /* replace554_0_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 243, 450 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1716 },
      -1,
   } },

   /* ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a') */
   /* search555_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1718 },
      -1,
   } },

   /* replace555_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('~f2i16', ('i2f', 'a@16')) => a */
   /* search556_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1721 },
      -1,
   } },

   /* replace556 -> 11 in the cache */

   /* ('~f2i16', ('u2f', 'a@16')) => a */
   /* search557_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1723 },
      -1,
   } },

   /* replace557 -> 11 in the cache */

   /* ('~f2u16', ('i2f', 'a@16')) => a */
   /* search558_0_0 -> 11 in the cache */
   /* search558_0 -> 1721 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1721 },
      -1,
   } },

   /* replace558 -> 11 in the cache */

   /* ('~f2u16', ('u2f', 'a@16')) => a */
   /* search559_0_0 -> 11 in the cache */
   /* search559_0 -> 1723 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1723 },
      -1,
   } },

   /* replace559 -> 11 in the cache */

   /* ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a') */
   /* search560_0_0_0 -> 115 in the cache */
   /* search560_0_0_1 -> 11 in the cache */
   /* search560_0_0 -> 1681 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1681 },
      -1,
   } },
   /* search560_1_0_0_0 -> 11 in the cache */
   /* search560_1_0_0_1 -> 115 in the cache */
   /* search560_1_0_0 -> 1700 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1700 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1728 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1727, 1729 },
      -1,
   } },

   /* replace560_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a')) */
   /* search561_0_0_0 -> 813 in the cache */
   /* search561_0_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 813, 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1732 },
      -1,
   } },
   /* search561_1_0_0_0 -> 11 in the cache */
   /* search561_1_0_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1734 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1735 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1733, 1736 },
      -1,
   } },

   /* replace561_0_0 -> 11 in the cache */
   /* replace561_0 -> 1731 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1731 },
      -1,
   } },

   /* ('f2f16', ('f2f32', 'a@16')) => a */
   /* search562_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1739 },
      -1,
   } },

   /* replace562 -> 11 in the cache */

   /* ('i2i16', ('i2i32', 'a@16')) => a */
   /* search563_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1741 },
      -1,
   } },

   /* replace563 -> 11 in the cache */

   /* ('u2u16', ('u2u32', 'a@16')) => a */
   /* search564_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1743 },
      -1,
   } },

   /* replace564 -> 11 in the cache */

   /* ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a') */
   /* search565_0_0 -> 715 in the cache */
   /* search565_0 -> 1346 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1346 },
      -1,
   } },

   /* replace565_0 -> 715 in the cache */
   /* replace565 -> 1342 in the cache */

   /* ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search566_0_0 -> 715 in the cache */
   /* search566_0 -> 1334 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1334 },
      -1,
   } },

   /* replace566_0 -> 715 in the cache */
   /* replace566 -> 1330 in the cache */

   /* ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search567_0_0 -> 715 in the cache */
   /* search567_0 -> 1334 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1334 },
      -1,
   } },

   /* replace567_0 -> 715 in the cache */
   /* replace567 -> 1330 in the cache */

   /* ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a') */
   /* search568_0_0 -> 11 in the cache */
   /* search568_0 -> 1739 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1739 },
      -1,
   } },

   /* replace568_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a') */
   /* search569_0_0 -> 11 in the cache */
   /* search569_0 -> 1739 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1739 },
      -1,
   } },

   /* replace569_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a') */
   /* search570_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1752 },
      -1,
   } },

   /* replace570_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a') */
   /* search571_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1755 },
      -1,
   } },

   /* replace571_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a') */
   /* search572_0_0 -> 11 in the cache */
   /* search572_0 -> 1743 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 1743 },
      -1,
   } },

   /* replace572_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a') */
   /* search573_0_0 -> 11 in the cache */
   /* search573_0 -> 1741 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1741 },
      -1,
   } },

   /* replace573_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('f2f64', 'a@16')) => a */
   /* search574_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1762 },
      -1,
   } },

   /* replace574 -> 11 in the cache */

   /* ('i2i16', ('i2i64', 'a@16')) => a */
   /* search575_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1764 },
      -1,
   } },

   /* replace575 -> 11 in the cache */

   /* ('u2u16', ('u2u64', 'a@16')) => a */
   /* search576_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1766 },
      -1,
   } },

   /* replace576 -> 11 in the cache */

   /* ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a') */
   /* search577_0_0 -> 715 in the cache */
   /* search577_0 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1350 },
      -1,
   } },

   /* replace577_0 -> 715 in the cache */
   /* replace577 -> 1342 in the cache */

   /* ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a') */
   /* search578_0_0 -> 715 in the cache */
   /* search578_0 -> 1338 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1338 },
      -1,
   } },

   /* replace578_0 -> 715 in the cache */
   /* replace578 -> 1330 in the cache */

   /* ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a') */
   /* search579_0_0 -> 715 in the cache */
   /* search579_0 -> 1338 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1338 },
      -1,
   } },

   /* replace579_0 -> 715 in the cache */
   /* replace579 -> 1330 in the cache */

   /* ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a') */
   /* search580_0_0 -> 11 in the cache */
   /* search580_0 -> 1762 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1762 },
      -1,
   } },

   /* replace580_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a') */
   /* search581_0_0 -> 11 in the cache */
   /* search581_0 -> 1762 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1762 },
      -1,
   } },

   /* replace581_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a') */
   /* search582_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1775 },
      -1,
   } },

   /* replace582_0 -> 32 in the cache */
   /* replace582 -> 1754 in the cache */

   /* ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a') */
   /* search583_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1777 },
      -1,
   } },

   /* replace583_0 -> 32 in the cache */
   /* replace583 -> 1757 in the cache */

   /* ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a') */
   /* search584_0_0 -> 11 in the cache */
   /* search584_0 -> 1766 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 1766 },
      -1,
   } },

   /* replace584_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a') */
   /* search585_0_0 -> 11 in the cache */
   /* search585_0 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1764 },
      -1,
   } },

   /* replace585_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search586_0_0 -> 117 in the cache */
   /* search586_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 16 },
      0,
   } },
   /* search586_1_0 -> 36 in the cache */
   /* search586_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1783, 1784 },
      -1,
   } },

   /* replace586_0 -> 117 in the cache */
   /* replace586_1_0 -> 16 in the cache */
   /* replace586_1_1_0 -> 36 in the cache */
   /* replace586_1_1 -> 581 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 16, 581 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 117, 1786 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search587_0_0 -> 117 in the cache */
   /* search587_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 16 },
      -1,
   } },
   /* search587_1_0 -> 36 in the cache */
   /* search587_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 117 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1788, 1789 },
      -1,
   } },

   /* replace587_0 -> 117 in the cache */
   /* replace587_1_0 -> 16 in the cache */
   /* replace587_1_1_0 -> 36 in the cache */
   /* replace587_1_1 -> 581 in the cache */
   /* replace587_1 -> 1786 in the cache */
   /* replace587 -> 1787 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search588_0_0 -> 117 in the cache */
   /* search588_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 16 },
      0,
   } },
   /* search588_1_0 -> 36 in the cache */
   /* search588_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1791, 1792 },
      -1,
   } },

   /* replace588_0 -> 117 in the cache */
   /* replace588_1_0 -> 16 in the cache */
   /* replace588_1_1_0 -> 36 in the cache */
   /* replace588_1_1 -> 581 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 16, 581 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 117, 1794 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search589_0_0 -> 117 in the cache */
   /* search589_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 16 },
      -1,
   } },
   /* search589_1_0 -> 36 in the cache */
   /* search589_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 117 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1796, 1797 },
      -1,
   } },

   /* replace589_0 -> 117 in the cache */
   /* replace589_1_0 -> 16 in the cache */
   /* replace589_1_1_0 -> 36 in the cache */
   /* replace589_1_1 -> 581 in the cache */
   /* replace589_1 -> 1794 in the cache */
   /* replace589 -> 1795 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search590_0_0 -> 117 in the cache */
   /* search590_0_1 -> 16 in the cache */
   /* search590_0 -> 1783 in the cache */
   /* search590_1_0 -> 36 in the cache */
   /* search590_1_1 -> 117 in the cache */
   /* search590_1 -> 1784 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1783, 1784 },
      -1,
   } },

   /* replace590_0 -> 117 in the cache */
   /* replace590_1_0 -> 16 in the cache */
   /* replace590_1_1_0 -> 36 in the cache */
   /* replace590_1_1 -> 581 in the cache */
   /* replace590_1 -> 1794 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 117, 1794 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search591_0_0 -> 117 in the cache */
   /* search591_0_1 -> 16 in the cache */
   /* search591_0 -> 1788 in the cache */
   /* search591_1_0 -> 36 in the cache */
   /* search591_1_1 -> 117 in the cache */
   /* search591_1 -> 1789 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1788, 1789 },
      -1,
   } },

   /* replace591_0 -> 117 in the cache */
   /* replace591_1_0 -> 16 in the cache */
   /* replace591_1_1_0 -> 36 in the cache */
   /* replace591_1_1 -> 581 in the cache */
   /* replace591_1 -> 1794 in the cache */
   /* replace591 -> 1800 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search592_0_0 -> 117 in the cache */
   /* search592_0_1 -> 16 in the cache */
   /* search592_0 -> 1791 in the cache */
   /* search592_1_0 -> 36 in the cache */
   /* search592_1_1 -> 117 in the cache */
   /* search592_1 -> 1792 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1791, 1792 },
      -1,
   } },

   /* replace592_0 -> 117 in the cache */
   /* replace592_1_0 -> 16 in the cache */
   /* replace592_1_1_0 -> 36 in the cache */
   /* replace592_1_1 -> 581 in the cache */
   /* replace592_1 -> 1786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 117, 1786 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search593_0_0 -> 117 in the cache */
   /* search593_0_1 -> 16 in the cache */
   /* search593_0 -> 1796 in the cache */
   /* search593_1_0 -> 36 in the cache */
   /* search593_1_1 -> 117 in the cache */
   /* search593_1 -> 1797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1796, 1797 },
      -1,
   } },

   /* replace593_0 -> 117 in the cache */
   /* replace593_1_0 -> 16 in the cache */
   /* replace593_1_1_0 -> 36 in the cache */
   /* replace593_1_1 -> 581 in the cache */
   /* replace593_1 -> 1786 in the cache */
   /* replace593 -> 1803 in the cache */

   /* ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search594_0_0 -> 16 in the cache */
   /* search594_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 16, 117 },
      -1,
   } },
   /* search594_1 -> 228 in the cache */
   /* search594_2_0_0_0_0 -> 117 in the cache */
   /* search594_2_0_0_0_1 -> 16 in the cache */
   /* search594_2_0_0_0 -> 1788 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1788 },
      -1,
   } },
   /* search594_2_0_1_0_0_0 -> 16 in the cache */
   /* search594_2_0_1_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1807 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1808 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1806, 1809 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1810 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1805, 228, 1811 },
      -1,
   } },

   /* replace594_0_0_0_0 -> 16 in the cache */
   /* replace594_0_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1813 },
      -1,
   } },
   /* replace594_0_1_0_0_0 -> 16 in the cache */
   /* replace594_0_1_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1815 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1816 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1814, 1817 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1818 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search595_0 -> 715 in the cache */
   /* search595_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 36 },
      0,
   } },
   /* search595_2_0 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1820, 1821 },
      -1,
   } },

   /* replace595_0_0 -> 715 in the cache */
   /* replace595_0_1 -> 36 in the cache */
   /* replace595_0_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 36, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1823 },
      -1,
   } },

   /* ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a') */
   /* search596_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1825 },
      -1,
   } },

   /* replace596_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('~f2i32', ('i2f', 'a@32')) => a */
   /* search597_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1828 },
      -1,
   } },

   /* replace597 -> 16 in the cache */

   /* ('~f2i32', ('u2f', 'a@32')) => a */
   /* search598_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1830 },
      -1,
   } },

   /* replace598 -> 16 in the cache */

   /* ('~f2u32', ('i2f', 'a@32')) => a */
   /* search599_0_0 -> 16 in the cache */
   /* search599_0 -> 1828 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1828 },
      -1,
   } },

   /* replace599 -> 16 in the cache */

   /* ('~f2u32', ('u2f', 'a@32')) => a */
   /* search600_0_0 -> 16 in the cache */
   /* search600_0 -> 1830 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1830 },
      -1,
   } },

   /* replace600 -> 16 in the cache */

   /* ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a') */
   /* search601_0_0_0 -> 117 in the cache */
   /* search601_0_0_1 -> 16 in the cache */
   /* search601_0_0 -> 1788 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1788 },
      -1,
   } },
   /* search601_1_0_0_0 -> 16 in the cache */
   /* search601_1_0_0_1 -> 117 in the cache */
   /* search601_1_0_0 -> 1807 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1807 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1835 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1834, 1836 },
      -1,
   } },

   /* replace601_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a')) */
   /* search602_0_0_0 -> 120 in the cache */
   /* search602_0_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 120, 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1839 },
      -1,
   } },
   /* search602_1_0_0_0 -> 16 in the cache */
   /* search602_1_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1841 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1842 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1840, 1843 },
      -1,
   } },

   /* replace602_0_0 -> 16 in the cache */
   /* replace602_0 -> 1838 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1838 },
      -1,
   } },

   /* ('f2f32', ('f2f64', 'a@32')) => a */
   /* search603_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1846 },
      -1,
   } },

   /* replace603 -> 16 in the cache */

   /* ('i2i32', ('i2i64', 'a@32')) => a */
   /* search604_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1848 },
      -1,
   } },

   /* replace604 -> 16 in the cache */

   /* ('u2u32', ('u2u64', 'a@32')) => a */
   /* search605_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1850 },
      -1,
   } },

   /* replace605 -> 16 in the cache */

   /* ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a') */
   /* search606_0_0 -> 715 in the cache */
   /* search606_0 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1350 },
      -1,
   } },

   /* replace606_0 -> 715 in the cache */
   /* replace606 -> 1346 in the cache */

   /* ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a') */
   /* search607_0_0 -> 715 in the cache */
   /* search607_0 -> 1338 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1338 },
      -1,
   } },

   /* replace607_0 -> 715 in the cache */
   /* replace607 -> 1334 in the cache */

   /* ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a') */
   /* search608_0_0 -> 715 in the cache */
   /* search608_0 -> 1338 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1338 },
      -1,
   } },

   /* replace608_0 -> 715 in the cache */
   /* replace608 -> 1334 in the cache */

   /* ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a') */
   /* search609_0_0 -> 16 in the cache */
   /* search609_0 -> 1846 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1846 },
      -1,
   } },

   /* replace609_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a') */
   /* search610_0_0 -> 16 in the cache */
   /* search610_0 -> 1846 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1846 },
      -1,
   } },

   /* replace610_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a') */
   /* search611_0_0 -> 32 in the cache */
   /* search611_0 -> 1775 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1775 },
      -1,
   } },

   /* replace611_0 -> 32 in the cache */
   /* replace611 -> 1752 in the cache */

   /* ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a') */
   /* search612_0_0 -> 32 in the cache */
   /* search612_0 -> 1777 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1777 },
      -1,
   } },

   /* replace612_0 -> 32 in the cache */
   /* replace612 -> 1755 in the cache */

   /* ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a') */
   /* search613_0_0 -> 16 in the cache */
   /* search613_0 -> 1850 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 1850 },
      -1,
   } },

   /* replace613_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a') */
   /* search614_0_0 -> 16 in the cache */
   /* search614_0 -> 1848 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1848 },
      -1,
   } },

   /* replace614_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search615_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1865, 21 },
      0,
   } },
   /* search615_1_0 -> 41 in the cache */
   /* search615_1_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 1865 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1866, 1867 },
      -1,
   } },

   /* replace615_0 -> 1865 in the cache */
   /* replace615_1_0 -> 21 in the cache */
   /* replace615_1_1_0 -> 41 in the cache */
   /* replace615_1_1 -> 654 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 21, 654 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1865, 1869 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search616_0_0 -> 1865 in the cache */
   /* search616_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1865, 21 },
      -1,
   } },
   /* search616_1_0 -> 41 in the cache */
   /* search616_1_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 1865 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1871, 1872 },
      -1,
   } },

   /* replace616_0 -> 1865 in the cache */
   /* replace616_1_0 -> 21 in the cache */
   /* replace616_1_1_0 -> 41 in the cache */
   /* replace616_1_1 -> 654 in the cache */
   /* replace616_1 -> 1869 in the cache */
   /* replace616 -> 1870 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search617_0_0 -> 1865 in the cache */
   /* search617_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1865, 21 },
      0,
   } },
   /* search617_1_0 -> 41 in the cache */
   /* search617_1_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 1865 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1874, 1875 },
      -1,
   } },

   /* replace617_0 -> 1865 in the cache */
   /* replace617_1_0 -> 21 in the cache */
   /* replace617_1_1_0 -> 41 in the cache */
   /* replace617_1_1 -> 654 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 21, 654 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1865, 1877 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search618_0_0 -> 1865 in the cache */
   /* search618_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1865, 21 },
      -1,
   } },
   /* search618_1_0 -> 41 in the cache */
   /* search618_1_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 1865 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1879, 1880 },
      -1,
   } },

   /* replace618_0 -> 1865 in the cache */
   /* replace618_1_0 -> 21 in the cache */
   /* replace618_1_1_0 -> 41 in the cache */
   /* replace618_1_1 -> 654 in the cache */
   /* replace618_1 -> 1877 in the cache */
   /* replace618 -> 1878 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search619_0_0 -> 1865 in the cache */
   /* search619_0_1 -> 21 in the cache */
   /* search619_0 -> 1866 in the cache */
   /* search619_1_0 -> 41 in the cache */
   /* search619_1_1 -> 1865 in the cache */
   /* search619_1 -> 1867 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1866, 1867 },
      -1,
   } },

   /* replace619_0 -> 1865 in the cache */
   /* replace619_1_0 -> 21 in the cache */
   /* replace619_1_1_0 -> 41 in the cache */
   /* replace619_1_1 -> 654 in the cache */
   /* replace619_1 -> 1877 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1865, 1877 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search620_0_0 -> 1865 in the cache */
   /* search620_0_1 -> 21 in the cache */
   /* search620_0 -> 1871 in the cache */
   /* search620_1_0 -> 41 in the cache */
   /* search620_1_1 -> 1865 in the cache */
   /* search620_1 -> 1872 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1871, 1872 },
      -1,
   } },

   /* replace620_0 -> 1865 in the cache */
   /* replace620_1_0 -> 21 in the cache */
   /* replace620_1_1_0 -> 41 in the cache */
   /* replace620_1_1 -> 654 in the cache */
   /* replace620_1 -> 1877 in the cache */
   /* replace620 -> 1883 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search621_0_0 -> 1865 in the cache */
   /* search621_0_1 -> 21 in the cache */
   /* search621_0 -> 1874 in the cache */
   /* search621_1_0 -> 41 in the cache */
   /* search621_1_1 -> 1865 in the cache */
   /* search621_1 -> 1875 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1874, 1875 },
      -1,
   } },

   /* replace621_0 -> 1865 in the cache */
   /* replace621_1_0 -> 21 in the cache */
   /* replace621_1_1_0 -> 41 in the cache */
   /* replace621_1_1 -> 654 in the cache */
   /* replace621_1 -> 1869 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1865, 1869 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search622_0_0 -> 1865 in the cache */
   /* search622_0_1 -> 21 in the cache */
   /* search622_0 -> 1879 in the cache */
   /* search622_1_0 -> 41 in the cache */
   /* search622_1_1 -> 1865 in the cache */
   /* search622_1 -> 1880 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1879, 1880 },
      -1,
   } },

   /* replace622_0 -> 1865 in the cache */
   /* replace622_1_0 -> 21 in the cache */
   /* replace622_1_1_0 -> 41 in the cache */
   /* replace622_1_1 -> 654 in the cache */
   /* replace622_1 -> 1869 in the cache */
   /* replace622 -> 1886 in the cache */

   /* ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search623_0_0 -> 21 in the cache */
   /* search623_0_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 21, 1865 },
      -1,
   } },
   /* search623_1 -> 603 in the cache */
   /* search623_2_0_0_0_0 -> 1865 in the cache */
   /* search623_2_0_0_0_1 -> 21 in the cache */
   /* search623_2_0_0_0 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1871 },
      -1,
   } },
   /* search623_2_0_1_0_0_0 -> 21 in the cache */
   /* search623_2_0_1_0_0_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 1865 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1890 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1891 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1889, 1892 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1893 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1888, 603, 1894 },
      -1,
   } },

   /* replace623_0_0_0_0 -> 21 in the cache */
   /* replace623_0_0_0_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 21, 1865 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1896 },
      -1,
   } },
   /* replace623_0_1_0_0_0 -> 21 in the cache */
   /* replace623_0_1_0_0_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 1865 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1898 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1899 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1897, 1900 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1901 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search624_0 -> 715 in the cache */
   /* search624_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 41 },
      0,
   } },
   /* search624_2_0 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1903, 1904 },
      -1,
   } },

   /* replace624_0_0 -> 715 in the cache */
   /* replace624_0_1 -> 41 in the cache */
   /* replace624_0_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 41, 591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1906 },
      -1,
   } },

   /* ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a') */
   /* search625_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1908 },
      -1,
   } },

   /* replace625_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 21 },
      -1,
   } },

   /* ('~f2i64', ('i2f', 'a@64')) => a */
   /* search626_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1911 },
      -1,
   } },

   /* replace626 -> 21 in the cache */

   /* ('~f2i64', ('u2f', 'a@64')) => a */
   /* search627_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1913 },
      -1,
   } },

   /* replace627 -> 21 in the cache */

   /* ('~f2u64', ('i2f', 'a@64')) => a */
   /* search628_0_0 -> 21 in the cache */
   /* search628_0 -> 1911 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1911 },
      -1,
   } },

   /* replace628 -> 21 in the cache */

   /* ('~f2u64', ('u2f', 'a@64')) => a */
   /* search629_0_0 -> 21 in the cache */
   /* search629_0 -> 1913 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1913 },
      -1,
   } },

   /* replace629 -> 21 in the cache */

   /* ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a') */
   /* search630_0_0_0 -> 1865 in the cache */
   /* search630_0_0_1 -> 21 in the cache */
   /* search630_0_0 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1871 },
      -1,
   } },
   /* search630_1_0_0_0 -> 21 in the cache */
   /* search630_1_0_0_1 -> 1865 in the cache */
   /* search630_1_0_0 -> 1890 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1890 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1918 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1917, 1919 },
      -1,
   } },

   /* replace630_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 21 },
      -1,
   } },

   /* ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a')) */
   /* search631_0_0_0 -> 856 in the cache */
   /* search631_0_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 856, 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1922 },
      -1,
   } },
   /* search631_1_0_0_0 -> 21 in the cache */
   /* search631_1_0_0_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1924 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1925 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1923, 1926 },
      -1,
   } },

   /* replace631_0_0 -> 21 in the cache */
   /* replace631_0 -> 1921 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1921 },
      -1,
   } },

   /* ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a') */
   /* search632_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1929 },
      -1,
   } },

   /* replace632_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a') */
   /* search633_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1932 },
      -1,
   } },

   /* replace633_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a') */
   /* search634_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace634_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a') */
   /* search635_0_0 -> 16 in the cache */
   /* search635_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace635_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a') */
   /* search636_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1940 },
      -1,
   } },

   /* replace636_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a') */
   /* search637_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1943 },
      -1,
   } },

   /* replace637_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a') */
   /* search638_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 1946 },
      -1,
   } },

   /* replace638_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a') */
   /* search639_0_0 -> 16 in the cache */
   /* search639_0 -> 1946 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1946 },
      -1,
   } },

   /* replace639_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255)) */
   /* search640_0_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1951 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1952, 1953 },
      -1,
   } },

   /* replace640_0 -> 11 in the cache */
   /* replace640_1_0 -> 243 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 243, 1955 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 11, 1956 },
      -1,
   } },

   /* ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255)) */
   /* search641_0_0_0 -> 11 in the cache */
   /* search641_0_0_1 -> 1953 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 1953 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1958 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 1,
      { 1959 },
      -1,
   } },

   /* replace641_0 -> 11 in the cache */
   /* replace641_1_0 -> 243 in the cache */
   /* replace641_1_1 -> 1955 in the cache */
   /* replace641_1 -> 1956 in the cache */
   /* replace641 -> 1957 in the cache */

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search642_0_0_0_0 -> 11 in the cache */
   /* search642_0_0_0 -> 1951 in the cache */
   /* search642_0_0 -> 1952 in the cache */
   /* search642_0_1_0_0 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1961 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1952, 1962 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1963 },
      -1,
   } },

   /* replace642_0_0 -> 11 in the cache */
   /* replace642_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1965 },
      -1,
   } },

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search643_0_0_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1967 },
      -1,
   } },
   /* search643_0_1_0_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1969 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1968, 1970 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1971 },
      -1,
   } },

   /* replace643_0_0 -> 16 in the cache */
   /* replace643_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1973 },
      -1,
   } },

   /* ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b') */
   /* search644_0_0 -> 0 in the cache */
   /* search644_0_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 0, 776 },
      -1,
   } },
   /* search644_1_0 -> 138 in the cache */
   /* search644_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 138, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1975, 1976 },
      -1,
   } },

   /* replace644_0_0 -> 0 in the cache */
   /* replace644_0_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 138 },
      -1,
   } },
   /* replace644_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 1978, 3 },
      -1,
   } },

   /* ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b') */
   /* search645_0_0 -> 0 in the cache */
   /* search645_0_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 0, 776 },
      -1,
   } },
   /* search645_1_0 -> 138 in the cache */
   /* search645_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 138, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1980, 1981 },
      -1,
   } },

   /* replace645_0_0 -> 0 in the cache */
   /* replace645_0_1 -> 138 in the cache */
   /* replace645_0 -> 1978 in the cache */
   /* replace645_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 1978, 3 },
      -1,
   } },

   /* ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b') */
   /* search646_0_0 -> 0 in the cache */
   /* search646_0_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 0, 776 },
      -1,
   } },
   /* search646_1_0 -> 138 in the cache */
   /* search646_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 138, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1984, 1985 },
      -1,
   } },

   /* replace646_0_0 -> 0 in the cache */
   /* replace646_0_1 -> 138 in the cache */
   /* replace646_0 -> 1978 in the cache */
   /* replace646_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 1978, 3 },
      -1,
   } },

   /* ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b') */
   /* search647_0_0 -> 0 in the cache */
   /* search647_0_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 0, 776 },
      -1,
   } },
   /* search647_1_0 -> 138 in the cache */
   /* search647_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 138, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1988, 1989 },
      -1,
   } },

   /* replace647_0_0 -> 0 in the cache */
   /* replace647_0_1 -> 138 in the cache */
   /* replace647_0 -> 1978 in the cache */
   /* replace647_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 1978, 3 },
      -1,
   } },

   /* ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b') */
   /* search648_0_0 -> 124 in the cache */
   /* search648_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 124, 33 },
      0,
   } },
   /* search648_1_0 -> 127 in the cache */
   /* search648_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 127, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1992, 1993 },
      -1,
   } },

   /* replace648_0_0 -> 124 in the cache */
   /* replace648_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 124, 127 },
      -1,
   } },
   /* replace648_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 1995, 36 },
      -1,
   } },

   /* ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b') */
   /* search649_0_0 -> 124 in the cache */
   /* search649_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 124, 33 },
      0,
   } },
   /* search649_1_0 -> 127 in the cache */
   /* search649_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 127, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1997, 1998 },
      -1,
   } },

   /* replace649_0_0 -> 124 in the cache */
   /* replace649_0_1 -> 127 in the cache */
   /* replace649_0 -> 1995 in the cache */
   /* replace649_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 1995, 36 },
      -1,
   } },

   /* ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b') */
   /* search650_0_0 -> 124 in the cache */
   /* search650_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 124, 33 },
      0,
   } },
   /* search650_1_0 -> 127 in the cache */
   /* search650_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 127, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2001, 2002 },
      -1,
   } },

   /* replace650_0_0 -> 124 in the cache */
   /* replace650_0_1 -> 127 in the cache */
   /* replace650_0 -> 1995 in the cache */
   /* replace650_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1995, 36 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search651_0_0_0_0 -> 11 in the cache */
   /* search651_0_0_0 -> 1951 in the cache */
   /* search651_0_0 -> 1952 in the cache */
   /* search651_0_1_0_0 -> 243 in the cache */
   /* search651_0_1_0 -> 1961 in the cache */
   /* search651_0_1 -> 1962 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1952, 1962 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2005 },
      -1,
   } },

   /* replace651_0_0 -> 11 in the cache */
   /* replace651_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 11, 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2007 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search652_0_0_0_0 -> 16 in the cache */
   /* search652_0_0_0 -> 1967 in the cache */
   /* search652_0_0 -> 1968 in the cache */
   /* search652_0_1_0_0 -> 36 in the cache */
   /* search652_0_1_0 -> 1969 in the cache */
   /* search652_0_1 -> 1970 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1968, 1970 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2009 },
      -1,
   } },

   /* replace652_0_0 -> 16 in the cache */
   /* replace652_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2011 },
      -1,
   } },

   /* ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b') */
   /* search653_0_0 -> 0 in the cache */
   /* search653_0_1 -> 776 in the cache */
   /* search653_0 -> 1975 in the cache */
   /* search653_1_0 -> 138 in the cache */
   /* search653_1_1 -> 3 in the cache */
   /* search653_1 -> 1976 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1975, 1976 },
      -1,
   } },

   /* replace653_0_0 -> 0 in the cache */
   /* replace653_0_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 138 },
      -1,
   } },
   /* replace653_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2014, 3 },
      -1,
   } },

   /* ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b') */
   /* search654_0_0 -> 0 in the cache */
   /* search654_0_1 -> 776 in the cache */
   /* search654_0 -> 1980 in the cache */
   /* search654_1_0 -> 138 in the cache */
   /* search654_1_1 -> 3 in the cache */
   /* search654_1 -> 1981 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1980, 1981 },
      -1,
   } },

   /* replace654_0_0 -> 0 in the cache */
   /* replace654_0_1 -> 138 in the cache */
   /* replace654_0 -> 2014 in the cache */
   /* replace654_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2014, 3 },
      -1,
   } },

   /* ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b') */
   /* search655_0_0 -> 0 in the cache */
   /* search655_0_1 -> 776 in the cache */
   /* search655_0 -> 1984 in the cache */
   /* search655_1_0 -> 138 in the cache */
   /* search655_1_1 -> 3 in the cache */
   /* search655_1 -> 1985 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1984, 1985 },
      -1,
   } },

   /* replace655_0_0 -> 0 in the cache */
   /* replace655_0_1 -> 138 in the cache */
   /* replace655_0 -> 2014 in the cache */
   /* replace655_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2014, 3 },
      -1,
   } },

   /* ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b') */
   /* search656_0_0 -> 0 in the cache */
   /* search656_0_1 -> 776 in the cache */
   /* search656_0 -> 1988 in the cache */
   /* search656_1_0 -> 138 in the cache */
   /* search656_1_1 -> 3 in the cache */
   /* search656_1 -> 1989 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1988, 1989 },
      -1,
   } },

   /* replace656_0_0 -> 0 in the cache */
   /* replace656_0_1 -> 138 in the cache */
   /* replace656_0 -> 2014 in the cache */
   /* replace656_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2014, 3 },
      -1,
   } },

   /* ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b') */
   /* search657_0_0 -> 124 in the cache */
   /* search657_0_1 -> 33 in the cache */
   /* search657_0 -> 1992 in the cache */
   /* search657_1_0 -> 127 in the cache */
   /* search657_1_1 -> 36 in the cache */
   /* search657_1 -> 1993 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1992, 1993 },
      -1,
   } },

   /* replace657_0_0 -> 124 in the cache */
   /* replace657_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 124, 127 },
      -1,
   } },
   /* replace657_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2023, 36 },
      -1,
   } },

   /* ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b') */
   /* search658_0_0 -> 124 in the cache */
   /* search658_0_1 -> 33 in the cache */
   /* search658_0 -> 1997 in the cache */
   /* search658_1_0 -> 127 in the cache */
   /* search658_1_1 -> 36 in the cache */
   /* search658_1 -> 1998 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1997, 1998 },
      -1,
   } },

   /* replace658_0_0 -> 124 in the cache */
   /* replace658_0_1 -> 127 in the cache */
   /* replace658_0 -> 2023 in the cache */
   /* replace658_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2023, 36 },
      -1,
   } },

   /* ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b') */
   /* search659_0_0 -> 124 in the cache */
   /* search659_0_1 -> 33 in the cache */
   /* search659_0 -> 2001 in the cache */
   /* search659_1_0 -> 127 in the cache */
   /* search659_1_1 -> 36 in the cache */
   /* search659_1 -> 2002 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2001, 2002 },
      -1,
   } },

   /* replace659_0_0 -> 124 in the cache */
   /* replace659_0_1 -> 127 in the cache */
   /* replace659_0 -> 2023 in the cache */
   /* replace659_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2023, 36 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search660_0_0_0_0 -> 11 in the cache */
   /* search660_0_0_0 -> 1951 in the cache */
   /* search660_0_0 -> 1952 in the cache */
   /* search660_0_1_0_0 -> 243 in the cache */
   /* search660_0_1_0 -> 1961 in the cache */
   /* search660_0_1 -> 1962 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1952, 1962 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2029 },
      -1,
   } },

   /* replace660_0_0 -> 11 in the cache */
   /* replace660_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 11, 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2031 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search661_0_0_0_0 -> 16 in the cache */
   /* search661_0_0_0 -> 1967 in the cache */
   /* search661_0_0 -> 1968 in the cache */
   /* search661_0_1_0_0 -> 36 in the cache */
   /* search661_0_1_0 -> 1969 in the cache */
   /* search661_0_1 -> 1970 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1968, 1970 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2033 },
      -1,
   } },

   /* replace661_0_0 -> 16 in the cache */
   /* replace661_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2035 },
      -1,
   } },

   /* ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b') */
   /* search662_0_0 -> 0 in the cache */
   /* search662_0_1 -> 776 in the cache */
   /* search662_0 -> 1975 in the cache */
   /* search662_1_0 -> 138 in the cache */
   /* search662_1_1 -> 3 in the cache */
   /* search662_1 -> 1976 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1975, 1976 },
      -1,
   } },

   /* replace662_0_0 -> 0 in the cache */
   /* replace662_0_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 0, 138 },
      -1,
   } },
   /* replace662_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2038, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b') */
   /* search663_0_0 -> 0 in the cache */
   /* search663_0_1 -> 776 in the cache */
   /* search663_0 -> 1980 in the cache */
   /* search663_1_0 -> 138 in the cache */
   /* search663_1_1 -> 3 in the cache */
   /* search663_1 -> 1981 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1980, 1981 },
      -1,
   } },

   /* replace663_0_0 -> 0 in the cache */
   /* replace663_0_1 -> 138 in the cache */
   /* replace663_0 -> 2038 in the cache */
   /* replace663_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2038, 3 },
      -1,
   } },

   /* ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b') */
   /* search664_0_0 -> 0 in the cache */
   /* search664_0_1 -> 776 in the cache */
   /* search664_0 -> 1984 in the cache */
   /* search664_1_0 -> 138 in the cache */
   /* search664_1_1 -> 3 in the cache */
   /* search664_1 -> 1985 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1984, 1985 },
      -1,
   } },

   /* replace664_0_0 -> 0 in the cache */
   /* replace664_0_1 -> 138 in the cache */
   /* replace664_0 -> 2038 in the cache */
   /* replace664_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2038, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b') */
   /* search665_0_0 -> 0 in the cache */
   /* search665_0_1 -> 776 in the cache */
   /* search665_0 -> 1988 in the cache */
   /* search665_1_0 -> 138 in the cache */
   /* search665_1_1 -> 3 in the cache */
   /* search665_1 -> 1989 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1988, 1989 },
      -1,
   } },

   /* replace665_0_0 -> 0 in the cache */
   /* replace665_0_1 -> 138 in the cache */
   /* replace665_0 -> 2038 in the cache */
   /* replace665_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2038, 3 },
      -1,
   } },

   /* ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b') */
   /* search666_0_0 -> 124 in the cache */
   /* search666_0_1 -> 33 in the cache */
   /* search666_0 -> 1992 in the cache */
   /* search666_1_0 -> 127 in the cache */
   /* search666_1_1 -> 36 in the cache */
   /* search666_1 -> 1993 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1992, 1993 },
      -1,
   } },

   /* replace666_0_0 -> 124 in the cache */
   /* replace666_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 124, 127 },
      -1,
   } },
   /* replace666_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2047, 36 },
      -1,
   } },

   /* ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b') */
   /* search667_0_0 -> 124 in the cache */
   /* search667_0_1 -> 33 in the cache */
   /* search667_0 -> 1997 in the cache */
   /* search667_1_0 -> 127 in the cache */
   /* search667_1_1 -> 36 in the cache */
   /* search667_1 -> 1998 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1997, 1998 },
      -1,
   } },

   /* replace667_0_0 -> 124 in the cache */
   /* replace667_0_1 -> 127 in the cache */
   /* replace667_0 -> 2047 in the cache */
   /* replace667_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2047, 36 },
      -1,
   } },

   /* ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b') */
   /* search668_0_0 -> 124 in the cache */
   /* search668_0_1 -> 33 in the cache */
   /* search668_0 -> 2001 in the cache */
   /* search668_1_0 -> 127 in the cache */
   /* search668_1_1 -> 36 in the cache */
   /* search668_1 -> 2002 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2001, 2002 },
      -1,
   } },

   /* replace668_0_0 -> 124 in the cache */
   /* replace668_0_1 -> 127 in the cache */
   /* replace668_0 -> 2047 in the cache */
   /* replace668_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2047, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search669_0_0 -> 6 in the cache */
   /* search669_0_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 6, 791 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 8 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search669_1_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 2054, 791 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2053, 2055 },
      -1,
   } },

   /* replace669_0_0 -> 6 in the cache */
   /* replace669_0_1 -> 2054 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 6, 2054 },
      -1,
   } },
   /* replace669_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2057, 791 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search670_0_0 -> 6 in the cache */
   /* search670_0_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 6, 791 },
      -1,
   } },
   /* search670_1_0 -> 2054 in the cache */
   /* search670_1_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 2054, 791 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2059, 2060 },
      -1,
   } },

   /* replace670_0_0 -> 6 in the cache */
   /* replace670_0_1 -> 2054 in the cache */
   /* replace670_0 -> 2057 in the cache */
   /* replace670_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2057, 791 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search671_0_0 -> 6 in the cache */
   /* search671_0_1 -> 791 in the cache */
   /* search671_0 -> 2053 in the cache */
   /* search671_1_0 -> 2054 in the cache */
   /* search671_1_1 -> 791 in the cache */
   /* search671_1 -> 2055 in the cache */
   /* search671 -> 2056 in the cache */

   /* replace671_0_0 -> 6 in the cache */
   /* replace671_0_1 -> 2054 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 6, 2054 },
      -1,
   } },
   /* replace671_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2063, 791 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search672_0_0 -> 6 in the cache */
   /* search672_0_1 -> 791 in the cache */
   /* search672_0 -> 2053 in the cache */
   /* search672_1_0 -> 2054 in the cache */
   /* search672_1_1 -> 791 in the cache */
   /* search672_1 -> 2055 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2053, 2055 },
      -1,
   } },

   /* replace672_0_0 -> 6 in the cache */
   /* replace672_0_1 -> 2054 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 6, 2054 },
      -1,
   } },
   /* replace672_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2066, 791 },
      -1,
   } },

   /* ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search673_0_0 -> 6 in the cache */
   /* search673_0_1 -> 791 in the cache */
   /* search673_0 -> 2059 in the cache */
   /* search673_1_0 -> 2054 in the cache */
   /* search673_1_1 -> 791 in the cache */
   /* search673_1 -> 2060 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2059, 2060 },
      -1,
   } },

   /* replace673_0_0 -> 6 in the cache */
   /* replace673_0_1 -> 2054 in the cache */
   /* replace673_0 -> 2066 in the cache */
   /* replace673_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2066, 791 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search674_0_0 -> 6 in the cache */
   /* search674_0_1 -> 791 in the cache */
   /* search674_0 -> 2059 in the cache */
   /* search674_1_0 -> 2054 in the cache */
   /* search674_1_1 -> 791 in the cache */
   /* search674_1 -> 2060 in the cache */
   /* search674 -> 2061 in the cache */

   /* replace674_0_0 -> 6 in the cache */
   /* replace674_0_1 -> 2054 in the cache */
   /* replace674_0 -> 2063 in the cache */
   /* replace674_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2063, 791 },
      -1,
   } },

   /* ('ineg', ('b2i8', 'a@8')) => a */
   /* search675_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2071 },
      -1,
   } },

   /* replace675 -> 6 in the cache */

   /* ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b') */
   /* search676_0 -> 6 in the cache */
   /* search676_1_0 -> 9 in the cache */
   /* search676_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 9, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 2073 },
      -1,
   } },

   /* replace676_0 -> 6 in the cache */
   /* replace676_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b') */
   /* search677_0 -> 6 in the cache */
   /* search677_1_0 -> 9 in the cache */
   /* search677_1_1 -> 36 in the cache */
   /* search677_1 -> 2073 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 6, 2073 },
      -1,
   } },

   /* replace677_0 -> 6 in the cache */
   /* replace677_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b') */
   /* search678_0 -> 6 in the cache */
   /* search678_1_0 -> 9 in the cache */
   /* search678_1_1 -> 36 in the cache */
   /* search678_1 -> 2073 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 2073 },
      -1,
   } },

   /* replace678_0 -> 6 in the cache */
   /* replace678_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search679_0_0 -> 11 in the cache */
   /* search679_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 11, 813 },
      -1,
   } },
   /* search679_1_0 -> 243 in the cache */
   /* search679_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 243, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2080, 2081 },
      -1,
   } },

   /* replace679_0_0 -> 11 in the cache */
   /* replace679_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 11, 243 },
      -1,
   } },
   /* replace679_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2083, 813 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search680_0_0 -> 11 in the cache */
   /* search680_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 11, 813 },
      -1,
   } },
   /* search680_1_0 -> 243 in the cache */
   /* search680_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 243, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2085, 2086 },
      -1,
   } },

   /* replace680_0_0 -> 11 in the cache */
   /* replace680_0_1 -> 243 in the cache */
   /* replace680_0 -> 2083 in the cache */
   /* replace680_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2083, 813 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search681_0_0 -> 11 in the cache */
   /* search681_0_1 -> 813 in the cache */
   /* search681_0 -> 2080 in the cache */
   /* search681_1_0 -> 243 in the cache */
   /* search681_1_1 -> 813 in the cache */
   /* search681_1 -> 2081 in the cache */
   /* search681 -> 2082 in the cache */

   /* replace681_0_0 -> 11 in the cache */
   /* replace681_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 11, 243 },
      -1,
   } },
   /* replace681_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2089, 813 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search682_0_0 -> 11 in the cache */
   /* search682_0_1 -> 813 in the cache */
   /* search682_0 -> 2080 in the cache */
   /* search682_1_0 -> 243 in the cache */
   /* search682_1_1 -> 813 in the cache */
   /* search682_1 -> 2081 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2080, 2081 },
      -1,
   } },

   /* replace682_0_0 -> 11 in the cache */
   /* replace682_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 11, 243 },
      -1,
   } },
   /* replace682_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2092, 813 },
      -1,
   } },

   /* ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search683_0_0 -> 11 in the cache */
   /* search683_0_1 -> 813 in the cache */
   /* search683_0 -> 2085 in the cache */
   /* search683_1_0 -> 243 in the cache */
   /* search683_1_1 -> 813 in the cache */
   /* search683_1 -> 2086 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2085, 2086 },
      -1,
   } },

   /* replace683_0_0 -> 11 in the cache */
   /* replace683_0_1 -> 243 in the cache */
   /* replace683_0 -> 2092 in the cache */
   /* replace683_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2092, 813 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search684_0_0 -> 11 in the cache */
   /* search684_0_1 -> 813 in the cache */
   /* search684_0 -> 2085 in the cache */
   /* search684_1_0 -> 243 in the cache */
   /* search684_1_1 -> 813 in the cache */
   /* search684_1 -> 2086 in the cache */
   /* search684 -> 2087 in the cache */

   /* replace684_0_0 -> 11 in the cache */
   /* replace684_0_1 -> 243 in the cache */
   /* replace684_0 -> 2089 in the cache */
   /* replace684_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2089, 813 },
      -1,
   } },

   /* ('ineg', ('b2i16', 'a@16')) => a */
   /* search685_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2097 },
      -1,
   } },

   /* replace685 -> 11 in the cache */

   /* ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b') */
   /* search686_0 -> 11 in the cache */
   /* search686_1_0 -> 14 in the cache */
   /* search686_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 14, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2099 },
      -1,
   } },

   /* replace686_0 -> 11 in the cache */
   /* replace686_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b') */
   /* search687_0 -> 11 in the cache */
   /* search687_1_0 -> 14 in the cache */
   /* search687_1_1 -> 36 in the cache */
   /* search687_1 -> 2099 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 11, 2099 },
      -1,
   } },

   /* replace687_0 -> 11 in the cache */
   /* replace687_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b') */
   /* search688_0 -> 11 in the cache */
   /* search688_1_0 -> 14 in the cache */
   /* search688_1_1 -> 36 in the cache */
   /* search688_1 -> 2099 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2099 },
      -1,
   } },

   /* replace688_0 -> 11 in the cache */
   /* replace688_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search689_0_0 -> 16 in the cache */
   /* search689_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 16, 120 },
      -1,
   } },
   /* search689_1_0 -> 36 in the cache */
   /* search689_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2106, 2107 },
      -1,
   } },

   /* replace689_0_0 -> 16 in the cache */
   /* replace689_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace689_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2109, 120 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search690_0_0 -> 16 in the cache */
   /* search690_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 16, 120 },
      -1,
   } },
   /* search690_1_0 -> 36 in the cache */
   /* search690_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2111, 2112 },
      -1,
   } },

   /* replace690_0_0 -> 16 in the cache */
   /* replace690_0_1 -> 36 in the cache */
   /* replace690_0 -> 2109 in the cache */
   /* replace690_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2109, 120 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search691_0_0 -> 16 in the cache */
   /* search691_0_1 -> 120 in the cache */
   /* search691_0 -> 2106 in the cache */
   /* search691_1_0 -> 36 in the cache */
   /* search691_1_1 -> 120 in the cache */
   /* search691_1 -> 2107 in the cache */
   /* search691 -> 2108 in the cache */

   /* replace691_0_0 -> 16 in the cache */
   /* replace691_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace691_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2115, 120 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search692_0_0 -> 16 in the cache */
   /* search692_0_1 -> 120 in the cache */
   /* search692_0 -> 2106 in the cache */
   /* search692_1_0 -> 36 in the cache */
   /* search692_1_1 -> 120 in the cache */
   /* search692_1 -> 2107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2106, 2107 },
      -1,
   } },

   /* replace692_0_0 -> 16 in the cache */
   /* replace692_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace692_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2118, 120 },
      -1,
   } },

   /* ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search693_0_0 -> 16 in the cache */
   /* search693_0_1 -> 120 in the cache */
   /* search693_0 -> 2111 in the cache */
   /* search693_1_0 -> 36 in the cache */
   /* search693_1_1 -> 120 in the cache */
   /* search693_1 -> 2112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2111, 2112 },
      -1,
   } },

   /* replace693_0_0 -> 16 in the cache */
   /* replace693_0_1 -> 36 in the cache */
   /* replace693_0 -> 2118 in the cache */
   /* replace693_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2118, 120 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search694_0_0 -> 16 in the cache */
   /* search694_0_1 -> 120 in the cache */
   /* search694_0 -> 2111 in the cache */
   /* search694_1_0 -> 36 in the cache */
   /* search694_1_1 -> 120 in the cache */
   /* search694_1 -> 2112 in the cache */
   /* search694 -> 2113 in the cache */

   /* replace694_0_0 -> 16 in the cache */
   /* replace694_0_1 -> 36 in the cache */
   /* replace694_0 -> 2115 in the cache */
   /* replace694_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2115, 120 },
      -1,
   } },

   /* ('ineg', ('b2i32', 'a@32')) => a */
   /* search695_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2123 },
      -1,
   } },

   /* replace695 -> 16 in the cache */

   /* ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b') */
   /* search696_0 -> 16 in the cache */
   /* search696_1_0 -> 19 in the cache */
   /* search696_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2125 },
      -1,
   } },

   /* replace696_0 -> 16 in the cache */
   /* replace696_1 -> 36 in the cache */
   /* replace696 -> 904 in the cache */

   /* ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b') */
   /* search697_0 -> 16 in the cache */
   /* search697_1_0 -> 19 in the cache */
   /* search697_1_1 -> 36 in the cache */
   /* search697_1 -> 2125 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 16, 2125 },
      -1,
   } },

   /* replace697_0 -> 16 in the cache */
   /* replace697_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b') */
   /* search698_0 -> 16 in the cache */
   /* search698_1_0 -> 19 in the cache */
   /* search698_1_1 -> 36 in the cache */
   /* search698_1 -> 2125 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2125 },
      -1,
   } },

   /* replace698_0 -> 16 in the cache */
   /* replace698_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search699_0_0 -> 21 in the cache */
   /* search699_0_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 21, 856 },
      -1,
   } },
   /* search699_1_0 -> 41 in the cache */
   /* search699_1_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 41, 856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2131, 2132 },
      -1,
   } },

   /* replace699_0_0 -> 21 in the cache */
   /* replace699_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace699_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2134, 856 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search700_0_0 -> 21 in the cache */
   /* search700_0_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 21, 856 },
      -1,
   } },
   /* search700_1_0 -> 41 in the cache */
   /* search700_1_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 41, 856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2136, 2137 },
      -1,
   } },

   /* replace700_0_0 -> 21 in the cache */
   /* replace700_0_1 -> 41 in the cache */
   /* replace700_0 -> 2134 in the cache */
   /* replace700_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2134, 856 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search701_0_0 -> 21 in the cache */
   /* search701_0_1 -> 856 in the cache */
   /* search701_0 -> 2131 in the cache */
   /* search701_1_0 -> 41 in the cache */
   /* search701_1_1 -> 856 in the cache */
   /* search701_1 -> 2132 in the cache */
   /* search701 -> 2133 in the cache */

   /* replace701_0_0 -> 21 in the cache */
   /* replace701_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace701_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2140, 856 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search702_0_0 -> 21 in the cache */
   /* search702_0_1 -> 856 in the cache */
   /* search702_0 -> 2131 in the cache */
   /* search702_1_0 -> 41 in the cache */
   /* search702_1_1 -> 856 in the cache */
   /* search702_1 -> 2132 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2131, 2132 },
      -1,
   } },

   /* replace702_0_0 -> 21 in the cache */
   /* replace702_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace702_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2143, 856 },
      -1,
   } },

   /* ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search703_0_0 -> 21 in the cache */
   /* search703_0_1 -> 856 in the cache */
   /* search703_0 -> 2136 in the cache */
   /* search703_1_0 -> 41 in the cache */
   /* search703_1_1 -> 856 in the cache */
   /* search703_1 -> 2137 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2136, 2137 },
      -1,
   } },

   /* replace703_0_0 -> 21 in the cache */
   /* replace703_0_1 -> 41 in the cache */
   /* replace703_0 -> 2143 in the cache */
   /* replace703_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2143, 856 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search704_0_0 -> 21 in the cache */
   /* search704_0_1 -> 856 in the cache */
   /* search704_0 -> 2136 in the cache */
   /* search704_1_0 -> 41 in the cache */
   /* search704_1_1 -> 856 in the cache */
   /* search704_1 -> 2137 in the cache */
   /* search704 -> 2138 in the cache */

   /* replace704_0_0 -> 21 in the cache */
   /* replace704_0_1 -> 41 in the cache */
   /* replace704_0 -> 2140 in the cache */
   /* replace704_1 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2140, 856 },
      -1,
   } },

   /* ('ineg', ('b2i64', 'a@64')) => a */
   /* search705_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2148 },
      -1,
   } },

   /* replace705 -> 21 in the cache */

   /* ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b') */
   /* search706_0 -> 21 in the cache */
   /* search706_1_0 -> 24 in the cache */
   /* search706_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 2150 },
      -1,
   } },

   /* replace706_0 -> 21 in the cache */
   /* replace706_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b') */
   /* search707_0 -> 21 in the cache */
   /* search707_1_0 -> 24 in the cache */
   /* search707_1_1 -> 36 in the cache */
   /* search707_1 -> 2150 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 21, 2150 },
      -1,
   } },

   /* replace707_0 -> 21 in the cache */
   /* replace707_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b') */
   /* search708_0 -> 21 in the cache */
   /* search708_1_0 -> 24 in the cache */
   /* search708_1_1 -> 36 in the cache */
   /* search708_1 -> 2150 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 2150 },
      -1,
   } },

   /* replace708_0 -> 21 in the cache */
   /* replace708_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a') */
   /* search709_0_0 -> 32 in the cache */
   /* search709_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 61 },
      -1,
   } },
   /* search709_1_0 -> 32 in the cache */
   /* search709_1_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 32, 35 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2157, 2158 },
      -1,
   } },

   /* replace709_0 -> 35 in the cache */
   /* replace709_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 35, 32 },
      -1,
   } },

   /* ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a') */
   /* search710_0_0 -> 35 in the cache */
   /* search710_0_1 -> 32 in the cache */
   /* search710_0 -> 2160 in the cache */
   /* search710_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2160, 2162 },
      -1,
   } },

   /* replace710_0 -> 2161 in the cache */
   /* replace710_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2161, 32 },
      -1,
   } },

   /* ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a') */
   /* search711_0_0 -> 2161 in the cache */
   /* search711_0_1 -> 32 in the cache */
   /* search711_0 -> 2164 in the cache */
   /* search711_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2164, 2166 },
      -1,
   } },

   /* replace711_0 -> 2165 in the cache */
   /* replace711_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2165, 32 },
      -1,
   } },

   /* ('ior', 'a', ('ieq', 'a', False)) => True */
   /* search712_0 -> 715 in the cache */
   /* search712_1_0 -> 715 in the cache */
   /* search712_1_1 -> 1033 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 715, 1033 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 715, 2169 },
      -1,
   } },

   /* replace712 -> 1186 in the cache */

   /* ('ior', 'a', ('inot', 'a')) => -1 */
   /* search713_0 -> 32 in the cache */
   /* search713_1_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 2171 },
      -1,
   } },

   /* replace713 -> 63 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b') */
   /* search714_0_0_0 -> 715 in the cache */
   /* search714_0_0 -> 1177 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1177 },
      -1,
   } },
   /* search714_1_0_0 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 1084 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2174 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2173, 2175 },
      -1,
   } },

   /* replace714_0 -> 715 in the cache */
   /* replace714_1 -> 1084 in the cache */
   /* replace714 -> 1329 in the cache */

   /* ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b')) */
   /* search715_0_0 -> 715 in the cache */
   /* search715_0_1 -> 1084 in the cache */
   /* search715_0 -> 1329 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1329 },
      -1,
   } },

   /* replace715_0_0 -> 715 in the cache */
   /* replace715_0_1 -> 1084 in the cache */
   /* replace715_0 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1101 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0)) */
   /* search716_0_0_0_0_0 -> 32 in the cache */
   /* search716_0_0_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 32, 61 },
      -1,
   } },
   /* search716_0_0_0_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      2, 2,
      { 2179, 1084 },
      -1,
   } },
   /* search716_0_0_1 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2180, 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2181 },
      -1,
   } },
   /* search716_1_0 -> 32 in the cache */
   /* search716_1_1 -> 61 in the cache */
   /* search716_1 -> 1200 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2182, 1200 },
      -1,
   } },

   /* replace716_0_0_0 -> 1084 in the cache */
   /* replace716_0_0_1 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 1084, 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2184 },
      -1,
   } },
   /* replace716_1_0 -> 32 in the cache */
   /* replace716_1_1 -> 61 in the cache */
   /* replace716_1 -> 1200 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2185, 1200 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0)) */
   /* search717_0_0_0_0_0 -> 0 in the cache */
   /* search717_0_0_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      3, 1,
      { 0, 3 },
      -1,
   } },
   /* search717_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 2,
      { 2187, 86 },
      -1,
   } },
   /* search717_0_0_1 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2188, 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2189 },
      -1,
   } },
   /* search717_1_0 -> 0 in the cache */
   /* search717_1_1 -> 86 in the cache */
   /* search717_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2190, 90 },
      -1,
   } },

   /* replace717_0_0_0_0 -> 3 in the cache */
   /* replace717_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 3, 86 },
      -1,
   } },
   /* replace717_0_0_1 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 2,
      { 2192, 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 2,
      { 2193 },
      -1,
   } },
   /* replace717_1_0 -> 0 in the cache */
   /* replace717_1_1 -> 86 in the cache */
   /* replace717_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2194, 90 },
      -1,
   } },

   /* ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b') */
   /* search718_0 -> 32 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search718_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 2196, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2197 },
      -1,
   } },

   /* replace718_0 -> 32 in the cache */
   /* replace718_1 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 2196 },
      -1,
   } },

   /* ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a') */
   /* search719_0_0 -> 0 in the cache */
   /* search719_0_1 -> 3 in the cache */
   /* search719_0 -> 1234 in the cache */
   /* search719_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1234, 0 },
      -1,
   } },

   /* replace719_0 -> 3 in the cache */
   /* replace719_1 -> 0 in the cache */
   /* replace719 -> 1034 in the cache */

   /* ('~fge', 'a', ('fmin', 'b', 'a')) => True */
   /* search720_0 -> 32 in the cache */
   /* search720_1_0 -> 2196 in the cache */
   /* search720_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 2196, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2201 },
      -1,
   } },

   /* replace720 -> 1186 in the cache */

   /* ('~fge', ('fmax', 'a', 'b'), 'a') => True */
   /* search721_0_0 -> 0 in the cache */
   /* search721_0_1 -> 3 in the cache */
   /* search721_0 -> 1232 in the cache */
   /* search721_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1232, 0 },
      -1,
   } },

   /* replace721 -> 1186 in the cache */

   /* ('flt', 'a', ('fmin', 'b', 'a')) => False */
   /* search722_0 -> 32 in the cache */
   /* search722_1_0 -> 2196 in the cache */
   /* search722_1_1 -> 32 in the cache */
   /* search722_1 -> 2201 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2201 },
      -1,
   } },

   /* replace722 -> 1033 in the cache */

   /* ('flt', ('fmax', 'a', 'b'), 'a') => False */
   /* search723_0_0 -> 0 in the cache */
   /* search723_0_1 -> 3 in the cache */
   /* search723_0 -> 1232 in the cache */
   /* search723_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1232, 0 },
      -1,
   } },

   /* replace723 -> 1033 in the cache */

   /* ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b') */
   /* search724_0 -> 32 in the cache */
   /* search724_1_0 -> 2196 in the cache */
   /* search724_1_1 -> 32 in the cache */
   /* search724_1 -> 2197 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2197 },
      -1,
   } },

   /* replace724_0 -> 32 in the cache */
   /* replace724_1 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 2196 },
      -1,
   } },

   /* ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a') */
   /* search725_0_0 -> 0 in the cache */
   /* search725_0_1 -> 3 in the cache */
   /* search725_0 -> 1234 in the cache */
   /* search725_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1234, 0 },
      -1,
   } },

   /* replace725_0 -> 3 in the cache */
   /* replace725_1 -> 0 in the cache */
   /* replace725 -> 1046 in the cache */

   /* ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b') */
   /* search726_0 -> 32 in the cache */
   /* search726_1_0 -> 2196 in the cache */
   /* search726_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 2196, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2209 },
      -1,
   } },

   /* replace726_0 -> 32 in the cache */
   /* replace726_1 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 2196 },
      -1,
   } },

   /* ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a') */
   /* search727_0_0 -> 0 in the cache */
   /* search727_0_1 -> 3 in the cache */
   /* search727_0 -> 1294 in the cache */
   /* search727_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1294, 0 },
      -1,
   } },

   /* replace727_0 -> 3 in the cache */
   /* replace727_1 -> 0 in the cache */
   /* replace727 -> 1039 in the cache */

   /* ('ige', 'a', ('imin', 'b', 'a')) => True */
   /* search728_0 -> 32 in the cache */
   /* search728_1_0 -> 2196 in the cache */
   /* search728_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 2196, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2213 },
      -1,
   } },

   /* replace728 -> 1186 in the cache */

   /* ('ige', ('imax', 'a', 'b'), 'a') => True */
   /* search729_0_0 -> 0 in the cache */
   /* search729_0_1 -> 3 in the cache */
   /* search729_0 -> 1286 in the cache */
   /* search729_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1286, 0 },
      -1,
   } },

   /* replace729 -> 1186 in the cache */

   /* ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b') */
   /* search730_0 -> 32 in the cache */
   /* search730_1_0 -> 2196 in the cache */
   /* search730_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 2196, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2216 },
      -1,
   } },

   /* replace730_0 -> 32 in the cache */
   /* replace730_1 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 2196 },
      -1,
   } },

   /* ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a') */
   /* search731_0_0 -> 0 in the cache */
   /* search731_0_1 -> 3 in the cache */
   /* search731_0 -> 1291 in the cache */
   /* search731_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1291, 0 },
      -1,
   } },

   /* replace731_0 -> 3 in the cache */
   /* replace731_1 -> 0 in the cache */
   /* replace731 -> 1041 in the cache */

   /* ('uge', 'a', ('umin', 'b', 'a')) => True */
   /* search732_0 -> 32 in the cache */
   /* search732_1_0 -> 2196 in the cache */
   /* search732_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 2196, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2220 },
      -1,
   } },

   /* replace732 -> 1186 in the cache */

   /* ('uge', ('umax', 'a', 'b'), 'a') => True */
   /* search733_0_0 -> 0 in the cache */
   /* search733_0_1 -> 3 in the cache */
   /* search733_0 -> 1283 in the cache */
   /* search733_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1283, 0 },
      -1,
   } },

   /* replace733 -> 1186 in the cache */

   /* ('ilt', 'a', ('imin', 'b', 'a')) => False */
   /* search734_0 -> 32 in the cache */
   /* search734_1_0 -> 2196 in the cache */
   /* search734_1_1 -> 32 in the cache */
   /* search734_1 -> 2213 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2213 },
      -1,
   } },

   /* replace734 -> 1033 in the cache */

   /* ('ilt', ('imax', 'a', 'b'), 'a') => False */
   /* search735_0_0 -> 0 in the cache */
   /* search735_0_1 -> 3 in the cache */
   /* search735_0 -> 1286 in the cache */
   /* search735_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1286, 0 },
      -1,
   } },

   /* replace735 -> 1033 in the cache */

   /* ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b') */
   /* search736_0 -> 32 in the cache */
   /* search736_1_0 -> 2196 in the cache */
   /* search736_1_1 -> 32 in the cache */
   /* search736_1 -> 2209 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2209 },
      -1,
   } },

   /* replace736_0 -> 32 in the cache */
   /* replace736_1 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 2196 },
      -1,
   } },

   /* ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a') */
   /* search737_0_0 -> 0 in the cache */
   /* search737_0_1 -> 3 in the cache */
   /* search737_0 -> 1294 in the cache */
   /* search737_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1294, 0 },
      -1,
   } },

   /* replace737_0 -> 3 in the cache */
   /* replace737_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('umin', 'b', 'a')) => False */
   /* search738_0 -> 32 in the cache */
   /* search738_1_0 -> 2196 in the cache */
   /* search738_1_1 -> 32 in the cache */
   /* search738_1 -> 2220 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2220 },
      -1,
   } },

   /* replace738 -> 1033 in the cache */

   /* ('ult', ('umax', 'a', 'b'), 'a') => False */
   /* search739_0_0 -> 0 in the cache */
   /* search739_0_1 -> 3 in the cache */
   /* search739_0 -> 1283 in the cache */
   /* search739_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1283, 0 },
      -1,
   } },

   /* replace739 -> 1033 in the cache */

   /* ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b') */
   /* search740_0 -> 32 in the cache */
   /* search740_1_0 -> 2196 in the cache */
   /* search740_1_1 -> 32 in the cache */
   /* search740_1 -> 2216 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2216 },
      -1,
   } },

   /* replace740_0 -> 32 in the cache */
   /* replace740_1 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 2196 },
      -1,
   } },

   /* ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a') */
   /* search741_0_0 -> 0 in the cache */
   /* search741_0_1 -> 3 in the cache */
   /* search741_0 -> 1291 in the cache */
   /* search741_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1291, 0 },
      -1,
   } },

   /* replace741_0 -> 3 in the cache */
   /* replace741_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('iand', 'b', 'a')) => False */
   /* search742_0 -> 32 in the cache */
   /* search742_1_0 -> 2196 in the cache */
   /* search742_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2196, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2235 },
      -1,
   } },

   /* replace742 -> 1033 in the cache */

   /* ('ult', ('ior', 'a', 'b'), 'a') => False */
   /* search743_0_0 -> 0 in the cache */
   /* search743_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 3 },
      -1,
   } },
   /* search743_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2237, 0 },
      -1,
   } },

   /* replace743 -> 1033 in the cache */

   /* ('uge', 'a', ('iand', 'b', 'a')) => True */
   /* search744_0 -> 32 in the cache */
   /* search744_1_0 -> 2196 in the cache */
   /* search744_1_1 -> 32 in the cache */
   /* search744_1 -> 2235 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2235 },
      -1,
   } },

   /* replace744 -> 1186 in the cache */

   /* ('uge', ('ior', 'a', 'b'), 'a') => True */
   /* search745_0_0 -> 0 in the cache */
   /* search745_0_1 -> 3 in the cache */
   /* search745_0 -> 2237 in the cache */
   /* search745_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2237, 0 },
      -1,
   } },

   /* replace745 -> 1186 in the cache */

   /* ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search746_0 -> 267 in the cache */
   /* search746_1_0 -> 268 in the cache */
   /* search746_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 268, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 267, 2241 },
      -1,
   } },

   /* replace746_0_0 -> 124 in the cache */
   /* replace746_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace746_1_0 -> 124 in the cache */
   /* replace746_1_1 -> 127 in the cache */
   /* replace746_1 -> 1595 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2243, 1595 },
      -1,
   } },

   /* ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search747_0_0 -> 267 in the cache */
   /* search747_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 267, 125 },
      -1,
   } },
   /* search747_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2245, 769 },
      -1,
   } },

   /* replace747_0_0 -> 124 in the cache */
   /* replace747_0_1 -> 127 in the cache */
   /* replace747_0 -> 1595 in the cache */
   /* replace747_1_0 -> 125 in the cache */
   /* replace747_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1595, 2247 },
      -1,
   } },

   /* ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search748_0 -> 267 in the cache */
   /* search748_1_0 -> 268 in the cache */
   /* search748_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 268, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 267, 2249 },
      -1,
   } },

   /* replace748_0_0 -> 124 in the cache */
   /* replace748_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace748_1_0 -> 124 in the cache */
   /* replace748_1_1 -> 127 in the cache */
   /* replace748_1 -> 1605 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2251, 1605 },
      -1,
   } },

   /* ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search749_0_0 -> 267 in the cache */
   /* search749_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 267, 125 },
      -1,
   } },
   /* search749_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2253, 769 },
      -1,
   } },

   /* replace749_0_0 -> 124 in the cache */
   /* replace749_0_1 -> 127 in the cache */
   /* replace749_0 -> 1605 in the cache */
   /* replace749_1_0 -> 125 in the cache */
   /* replace749_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1605, 2255 },
      -1,
   } },

   /* ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search750_0 -> 267 in the cache */
   /* search750_1_0 -> 268 in the cache */
   /* search750_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 268, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 267, 2257 },
      -1,
   } },

   /* replace750_0_0 -> 124 in the cache */
   /* replace750_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace750_1_0 -> 124 in the cache */
   /* replace750_1_1 -> 127 in the cache */
   /* replace750_1 -> 1615 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2259, 1615 },
      -1,
   } },

   /* ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search751_0_0 -> 267 in the cache */
   /* search751_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 267, 125 },
      -1,
   } },
   /* search751_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2261, 769 },
      -1,
   } },

   /* replace751_0_0 -> 124 in the cache */
   /* replace751_0_1 -> 127 in the cache */
   /* replace751_0 -> 1615 in the cache */
   /* replace751_1_0 -> 125 in the cache */
   /* replace751_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1615, 2263 },
      -1,
   } },

   /* ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search752_0 -> 267 in the cache */
   /* search752_1_0 -> 268 in the cache */
   /* search752_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 268, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 267, 2265 },
      -1,
   } },

   /* replace752_0_0 -> 124 in the cache */
   /* replace752_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace752_1_0 -> 124 in the cache */
   /* replace752_1_1 -> 127 in the cache */
   /* replace752_1 -> 1625 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2267, 1625 },
      -1,
   } },

   /* ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search753_0_0 -> 267 in the cache */
   /* search753_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 267, 125 },
      -1,
   } },
   /* search753_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2269, 769 },
      -1,
   } },

   /* replace753_0_0 -> 124 in the cache */
   /* replace753_0_1 -> 127 in the cache */
   /* replace753_0 -> 1625 in the cache */
   /* replace753_1_0 -> 125 in the cache */
   /* replace753_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1625, 2271 },
      -1,
   } },

   /* ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search754_0 -> 267 in the cache */
   /* search754_1_0 -> 268 in the cache */
   /* search754_1_1 -> 127 in the cache */
   /* search754_1 -> 2249 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 267, 2249 },
      -1,
   } },

   /* replace754_0_0 -> 124 in the cache */
   /* replace754_0_1 -> 125 in the cache */
   /* replace754_0 -> 2243 in the cache */
   /* replace754_1_0 -> 124 in the cache */
   /* replace754_1_1 -> 127 in the cache */
   /* replace754_1 -> 1595 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2243, 1595 },
      -1,
   } },

   /* ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search755_0_0 -> 267 in the cache */
   /* search755_0_1 -> 125 in the cache */
   /* search755_0 -> 2253 in the cache */
   /* search755_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2253, 769 },
      -1,
   } },

   /* replace755_0_0 -> 124 in the cache */
   /* replace755_0_1 -> 127 in the cache */
   /* replace755_0 -> 1595 in the cache */
   /* replace755_1_0 -> 125 in the cache */
   /* replace755_1_1 -> 127 in the cache */
   /* replace755_1 -> 2247 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1595, 2247 },
      -1,
   } },

   /* ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search756_0 -> 267 in the cache */
   /* search756_1_0 -> 268 in the cache */
   /* search756_1_1 -> 127 in the cache */
   /* search756_1 -> 2241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 267, 2241 },
      -1,
   } },

   /* replace756_0_0 -> 124 in the cache */
   /* replace756_0_1 -> 125 in the cache */
   /* replace756_0 -> 2251 in the cache */
   /* replace756_1_0 -> 124 in the cache */
   /* replace756_1_1 -> 127 in the cache */
   /* replace756_1 -> 1605 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2251, 1605 },
      -1,
   } },

   /* ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search757_0_0 -> 267 in the cache */
   /* search757_0_1 -> 125 in the cache */
   /* search757_0 -> 2245 in the cache */
   /* search757_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2245, 769 },
      -1,
   } },

   /* replace757_0_0 -> 124 in the cache */
   /* replace757_0_1 -> 127 in the cache */
   /* replace757_0 -> 1605 in the cache */
   /* replace757_1_0 -> 125 in the cache */
   /* replace757_1_1 -> 127 in the cache */
   /* replace757_1 -> 2255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1605, 2255 },
      -1,
   } },

   /* ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search758_0 -> 267 in the cache */
   /* search758_1_0 -> 268 in the cache */
   /* search758_1_1 -> 127 in the cache */
   /* search758_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 267, 2265 },
      -1,
   } },

   /* replace758_0_0 -> 124 in the cache */
   /* replace758_0_1 -> 125 in the cache */
   /* replace758_0 -> 2259 in the cache */
   /* replace758_1_0 -> 124 in the cache */
   /* replace758_1_1 -> 127 in the cache */
   /* replace758_1 -> 1615 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2259, 1615 },
      -1,
   } },

   /* ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search759_0_0 -> 267 in the cache */
   /* search759_0_1 -> 125 in the cache */
   /* search759_0 -> 2269 in the cache */
   /* search759_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2269, 769 },
      -1,
   } },

   /* replace759_0_0 -> 124 in the cache */
   /* replace759_0_1 -> 127 in the cache */
   /* replace759_0 -> 1615 in the cache */
   /* replace759_1_0 -> 125 in the cache */
   /* replace759_1_1 -> 127 in the cache */
   /* replace759_1 -> 2263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1615, 2263 },
      -1,
   } },

   /* ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search760_0 -> 267 in the cache */
   /* search760_1_0 -> 268 in the cache */
   /* search760_1_1 -> 127 in the cache */
   /* search760_1 -> 2257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 267, 2257 },
      -1,
   } },

   /* replace760_0_0 -> 124 in the cache */
   /* replace760_0_1 -> 125 in the cache */
   /* replace760_0 -> 2267 in the cache */
   /* replace760_1_0 -> 124 in the cache */
   /* replace760_1_1 -> 127 in the cache */
   /* replace760_1 -> 1625 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2267, 1625 },
      -1,
   } },

   /* ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search761_0_0 -> 267 in the cache */
   /* search761_0_1 -> 125 in the cache */
   /* search761_0 -> 2261 in the cache */
   /* search761_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2261, 769 },
      -1,
   } },

   /* replace761_0_0 -> 124 in the cache */
   /* replace761_0_1 -> 127 in the cache */
   /* replace761_0 -> 1625 in the cache */
   /* replace761_1_0 -> 125 in the cache */
   /* replace761_1_1 -> 127 in the cache */
   /* replace761_1 -> 2271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1625, 2271 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b')) */
   /* search762_0_0 -> 32 in the cache */
   /* search762_0_1 -> 61 in the cache */
   /* search762_0 -> 1200 in the cache */
   /* search762_1_0_0 -> 32 in the cache */
   /* search762_1_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2289 },
      -1,
   } },
   /* search762_2_0 -> 32 in the cache */
   /* search762_2_1 -> 36 in the cache */
   /* search762_2 -> 2289 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1200, 2290, 2289 },
      -1,
   } },

   /* replace762_0_0 -> 32 in the cache */
   /* replace762_0_1 -> 36 in the cache */
   /* replace762_0 -> 2289 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2289 },
      -1,
   } },

   /* ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b') */
   /* search763_0_0_0 -> 32 in the cache */
   /* search763_0_0 -> 106 in the cache */
   /* search763_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 106, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2293 },
      -1,
   } },

   /* replace763_0_0 -> 32 in the cache */
   /* replace763_0 -> 106 in the cache */
   /* replace763_1 -> 36 in the cache */
   /* replace763 -> 2293 in the cache */

   /* ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b') */
   /* search764_0_0 -> 0 in the cache */
   /* search764_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_slt,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2295 },
      -1,
   } },

   /* replace764_0 -> 0 in the cache */
   /* replace764_1 -> 3 in the cache */
   /* replace764 -> 2295 in the cache */

   /* ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b') */
   /* search765_0_0 -> 0 in the cache */
   /* search765_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sge,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2297 },
      -1,
   } },

   /* replace765_0 -> 0 in the cache */
   /* replace765_1 -> 3 in the cache */
   /* replace765 -> 2297 in the cache */

   /* ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b') */
   /* search766_0_0 -> 0 in the cache */
   /* search766_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2299 },
      -1,
   } },

   /* replace766_0 -> 0 in the cache */
   /* replace766_1 -> 3 in the cache */
   /* replace766 -> 2299 in the cache */

   /* ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b') */
   /* search767_0_0 -> 0 in the cache */
   /* search767_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2301 },
      -1,
   } },

   /* replace767_0 -> 0 in the cache */
   /* replace767_1 -> 3 in the cache */
   /* replace767 -> 2301 in the cache */

   /* ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b')) */
   /* search768_0 -> 0 in the cache */
   /* search768_1 -> 3 in the cache */
   /* search768 -> 2295 in the cache */

   /* replace768_0_0 -> 0 in the cache */
   /* replace768_0_1 -> 3 in the cache */
   /* replace768_0 -> 1005 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1005 },
      -1,
   } },

   /* ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b')) */
   /* search769_0 -> 0 in the cache */
   /* search769_1 -> 3 in the cache */
   /* search769 -> 2297 in the cache */

   /* replace769_0_0 -> 0 in the cache */
   /* replace769_0_1 -> 3 in the cache */
   /* replace769_0 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1002 },
      -1,
   } },

   /* ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b')) */
   /* search770_0 -> 0 in the cache */
   /* search770_1 -> 3 in the cache */
   /* search770 -> 2299 in the cache */

   /* replace770_0_0 -> 0 in the cache */
   /* replace770_0_1 -> 3 in the cache */
   /* replace770_0 -> 1011 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1011 },
      -1,
   } },

   /* ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b')) */
   /* search771_0 -> 0 in the cache */
   /* search771_1 -> 3 in the cache */
   /* search771 -> 2301 in the cache */

   /* replace771_0_0 -> 0 in the cache */
   /* replace771_0_1 -> 3 in the cache */
   /* replace771_0 -> 1008 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1008 },
      -1,
   } },

   /* ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search772_0_0 -> 0 in the cache */
   /* search772_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search772_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2307, 255 },
      -1,
   } },

   /* replace772_0 -> 0 in the cache */
   /* replace772_1 -> 3 in the cache */
   /* replace772 -> 2299 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search773_0_0 -> 0 in the cache */
   /* search773_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search773_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2309, 255 },
      -1,
   } },

   /* replace773_0 -> 0 in the cache */
   /* replace773_1 -> 3 in the cache */
   /* replace773 -> 2301 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search774_0_0 -> 0 in the cache */
   /* search774_0_1 -> 3 in the cache */
   /* search774_0 -> 2295 in the cache */
   /* search774_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2295, 255 },
      -1,
   } },

   /* replace774_0 -> 0 in the cache */
   /* replace774_1 -> 3 in the cache */
   /* replace774 -> 2295 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search775_0_0 -> 0 in the cache */
   /* search775_0_1 -> 3 in the cache */
   /* search775_0 -> 2297 in the cache */
   /* search775_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2297, 255 },
      -1,
   } },

   /* replace775_0 -> 0 in the cache */
   /* replace775_1 -> 3 in the cache */
   /* replace775 -> 2297 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search776_0_0 -> 0 in the cache */
   /* search776_0_1 -> 3 in the cache */
   /* search776_0 -> 2307 in the cache */
   /* search776_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2307, 241 },
      -1,
   } },

   /* replace776_0 -> 0 in the cache */
   /* replace776_1 -> 3 in the cache */
   /* replace776 -> 2299 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search777_0_0 -> 0 in the cache */
   /* search777_0_1 -> 3 in the cache */
   /* search777_0 -> 2309 in the cache */
   /* search777_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2309, 241 },
      -1,
   } },

   /* replace777_0 -> 0 in the cache */
   /* replace777_1 -> 3 in the cache */
   /* replace777 -> 2301 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search778_0_0 -> 0 in the cache */
   /* search778_0_1 -> 3 in the cache */
   /* search778_0 -> 2295 in the cache */
   /* search778_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2295, 241 },
      -1,
   } },

   /* replace778_0 -> 0 in the cache */
   /* replace778_1 -> 3 in the cache */
   /* replace778 -> 2295 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search779_0_0 -> 0 in the cache */
   /* search779_0_1 -> 3 in the cache */
   /* search779_0 -> 2297 in the cache */
   /* search779_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2297, 241 },
      -1,
   } },

   /* replace779_0 -> 0 in the cache */
   /* replace779_1 -> 3 in the cache */
   /* replace779 -> 2297 in the cache */

   /* ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search780_0_0 -> 0 in the cache */
   /* search780_0_1 -> 3 in the cache */
   /* search780_0 -> 2307 in the cache */
   /* search780_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2307, 241 },
      -1,
   } },

   /* replace780_0 -> 0 in the cache */
   /* replace780_1 -> 3 in the cache */
   /* replace780 -> 2301 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search781_0_0 -> 0 in the cache */
   /* search781_0_1 -> 3 in the cache */
   /* search781_0 -> 2309 in the cache */
   /* search781_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2309, 241 },
      -1,
   } },

   /* replace781_0 -> 0 in the cache */
   /* replace781_1 -> 3 in the cache */
   /* replace781 -> 2299 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search782_0_0 -> 0 in the cache */
   /* search782_0_1 -> 3 in the cache */
   /* search782_0 -> 2295 in the cache */
   /* search782_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2295, 241 },
      -1,
   } },

   /* replace782_0 -> 0 in the cache */
   /* replace782_1 -> 3 in the cache */
   /* replace782 -> 2297 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search783_0_0 -> 0 in the cache */
   /* search783_0_1 -> 3 in the cache */
   /* search783_0 -> 2297 in the cache */
   /* search783_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2297, 241 },
      -1,
   } },

   /* replace783_0 -> 0 in the cache */
   /* replace783_1 -> 3 in the cache */
   /* replace783 -> 2295 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search784_0_0 -> 0 in the cache */
   /* search784_0_1 -> 3 in the cache */
   /* search784_0 -> 2307 in the cache */
   /* search784_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2307, 255 },
      -1,
   } },

   /* replace784_0 -> 0 in the cache */
   /* replace784_1 -> 3 in the cache */
   /* replace784 -> 2301 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search785_0_0 -> 0 in the cache */
   /* search785_0_1 -> 3 in the cache */
   /* search785_0 -> 2309 in the cache */
   /* search785_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2309, 255 },
      -1,
   } },

   /* replace785_0 -> 0 in the cache */
   /* replace785_1 -> 3 in the cache */
   /* replace785 -> 2299 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search786_0_0 -> 0 in the cache */
   /* search786_0_1 -> 3 in the cache */
   /* search786_0 -> 2295 in the cache */
   /* search786_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2295, 255 },
      -1,
   } },

   /* replace786_0 -> 0 in the cache */
   /* replace786_1 -> 3 in the cache */
   /* replace786 -> 2297 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search787_0_0 -> 0 in the cache */
   /* search787_0_1 -> 3 in the cache */
   /* search787_0 -> 2297 in the cache */
   /* search787_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2297, 255 },
      -1,
   } },

   /* replace787_0 -> 0 in the cache */
   /* replace787_1 -> 3 in the cache */
   /* replace787 -> 2295 in the cache */

   /* ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y')) */
   /* search788_0 -> 16 in the cache */
   /* search788_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2326, 2327 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 2329, 2330 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      -1, 2,
      { 2328, 2331 },
      -1,
   } },

   /* ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0) */
   /* search789_0 -> 16 in the cache */
   /* search789_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace789_0_0 -> 16 in the cache */
   /* replace789_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace789_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2334, 117 },
      -1,
   } },

   /* ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0) */
   /* search790_0 -> 16 in the cache */
   /* search790_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace790_0_0 -> 16 in the cache */
   /* replace790_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace790_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2337, 117 },
      -1,
   } },

   /* ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y')) */
   /* search791_0 -> 16 in the cache */
   /* search791_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace791_0_0 -> 2326 in the cache */
   /* replace791_0_1 -> 2327 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2326, 2327 },
      -1,
   } },
   /* replace791_1_0 -> 2329 in the cache */
   /* replace791_1_1 -> 2330 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 2329, 2330 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      -1, 2,
      { 2340, 2341 },
      -1,
   } },

   /* ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search792_0 -> 16 in the cache */
   /* search792_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace792_0_0_0 -> 16 in the cache */
   /* replace792_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 16, 36 },
      -1,
   } },
   /* replace792_0_1_0 -> 16 in the cache */
   /* replace792_0_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot3,
      -1, 2,
      { 2344, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2346 },
      -1,
   } },

   /* ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search793_0 -> 16 in the cache */
   /* search793_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace793_0_0_0 -> 16 in the cache */
   /* replace793_0_0_1 -> 36 in the cache */
   /* replace793_0_0 -> 2344 in the cache */
   /* replace793_0_1_0 -> 16 in the cache */
   /* replace793_0_1_1 -> 36 in the cache */
   /* replace793_0_1 -> 2345 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot4,
      -1, 2,
      { 2344, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2349 },
      -1,
   } },

   /* ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')) */
   /* search794_0 -> 0 in the cache */
   /* search794_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace794_0_0 -> 724 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 724, 2352 },
      -1,
   } },
   /* replace794_1_0 -> 725 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 725, 2354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2353, 2355 },
      -1,
   } },

   /* ('ball_iequal3', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('ieq', 'a.z', 'b.z')) */
   /* search795_0 -> 0 in the cache */
   /* search795_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace795_0_0_0 -> 724 in the cache */
   /* replace795_0_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 724, 2352 },
      -1,
   } },
   /* replace795_0_1_0 -> 725 in the cache */
   /* replace795_0_1_1 -> 2354 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 725, 2354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2358, 2359 },
      -1,
   } },
   /* replace795_1_0 -> 726 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 726, 2361 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2360, 2362 },
      -1,
   } },

   /* ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w'))) */
   /* search796_0 -> 0 in the cache */
   /* search796_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace796_0_0_0 -> 724 in the cache */
   /* replace796_0_0_1 -> 2352 in the cache */
   /* replace796_0_0 -> 2353 in the cache */
   /* replace796_0_1_0 -> 725 in the cache */
   /* replace796_0_1_1 -> 2354 in the cache */
   /* replace796_0_1 -> 2355 in the cache */
   /* replace796_0 -> 2356 in the cache */
   /* replace796_1_0_0 -> 726 in the cache */
   /* replace796_1_0_1 -> 2361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 726, 2361 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {3},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {3},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 2366, 2367 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2365, 2368 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2356, 2369 },
      -1,
   } },

   /* ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')) */
   /* search797_0 -> 0 in the cache */
   /* search797_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace797_0_0 -> 724 in the cache */
   /* replace797_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 724, 2352 },
      -1,
   } },
   /* replace797_1_0 -> 725 in the cache */
   /* replace797_1_1 -> 2354 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 725, 2354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2372, 2373 },
      -1,
   } },

   /* ('bany_inequal3', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ine', 'a.z', 'b.z')) */
   /* search798_0 -> 0 in the cache */
   /* search798_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace798_0_0_0 -> 724 in the cache */
   /* replace798_0_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 724, 2352 },
      -1,
   } },
   /* replace798_0_1_0 -> 725 in the cache */
   /* replace798_0_1_1 -> 2354 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 725, 2354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2376, 2377 },
      -1,
   } },
   /* replace798_1_0 -> 726 in the cache */
   /* replace798_1_1 -> 2361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      3, 1,
      { 726, 2361 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 4,
      { 2378, 2379 },
      -1,
   } },

   /* ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w'))) */
   /* search799_0 -> 0 in the cache */
   /* search799_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace799_0_0_0 -> 724 in the cache */
   /* replace799_0_0_1 -> 2352 in the cache */
   /* replace799_0_0 -> 2372 in the cache */
   /* replace799_0_1_0 -> 725 in the cache */
   /* replace799_0_1_1 -> 2354 in the cache */
   /* replace799_0_1 -> 2373 in the cache */
   /* replace799_0 -> 2374 in the cache */
   /* replace799_1_0_0 -> 726 in the cache */
   /* replace799_1_0_1 -> 2361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 726, 2361 },
      -1,
   } },
   /* replace799_1_1_0 -> 2366 in the cache */
   /* replace799_1_1_1 -> 2367 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      3, 1,
      { 2366, 2367 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2382, 2383 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2374, 2384 },
      -1,
   } },

   /* ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')) */
   /* search800_0 -> 0 in the cache */
   /* search800_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace800_0_0 -> 724 in the cache */
   /* replace800_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 724, 2352 },
      -1,
   } },
   /* replace800_1_0 -> 725 in the cache */
   /* replace800_1_1 -> 2354 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 725, 2354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2387, 2388 },
      -1,
   } },

   /* ('ball_fequal3', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('feq', 'a.z', 'b.z')) */
   /* search801_0 -> 0 in the cache */
   /* search801_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace801_0_0_0 -> 724 in the cache */
   /* replace801_0_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 724, 2352 },
      -1,
   } },
   /* replace801_0_1_0 -> 725 in the cache */
   /* replace801_0_1_1 -> 2354 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 725, 2354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2391, 2392 },
      -1,
   } },
   /* replace801_1_0 -> 726 in the cache */
   /* replace801_1_1 -> 2361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      3, 1,
      { 726, 2361 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2393, 2394 },
      -1,
   } },

   /* ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w'))) */
   /* search802_0 -> 0 in the cache */
   /* search802_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace802_0_0_0 -> 724 in the cache */
   /* replace802_0_0_1 -> 2352 in the cache */
   /* replace802_0_0 -> 2387 in the cache */
   /* replace802_0_1_0 -> 725 in the cache */
   /* replace802_0_1_1 -> 2354 in the cache */
   /* replace802_0_1 -> 2388 in the cache */
   /* replace802_0 -> 2389 in the cache */
   /* replace802_1_0_0 -> 726 in the cache */
   /* replace802_1_0_1 -> 2361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 726, 2361 },
      -1,
   } },
   /* replace802_1_1_0 -> 2366 in the cache */
   /* replace802_1_1_1 -> 2367 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      3, 1,
      { 2366, 2367 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2397, 2398 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2389, 2399 },
      -1,
   } },

   /* ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')) */
   /* search803_0 -> 0 in the cache */
   /* search803_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace803_0_0 -> 724 in the cache */
   /* replace803_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 724, 2352 },
      -1,
   } },
   /* replace803_1_0 -> 725 in the cache */
   /* replace803_1_1 -> 2354 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 725, 2354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2402, 2403 },
      -1,
   } },

   /* ('bany_fnequal3', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('fneu', 'a.z', 'b.z')) */
   /* search804_0 -> 0 in the cache */
   /* search804_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace804_0_0_0 -> 724 in the cache */
   /* replace804_0_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 724, 2352 },
      -1,
   } },
   /* replace804_0_1_0 -> 725 in the cache */
   /* replace804_0_1_1 -> 2354 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 725, 2354 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2406, 2407 },
      -1,
   } },
   /* replace804_1_0 -> 726 in the cache */
   /* replace804_1_1 -> 2361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      3, 1,
      { 726, 2361 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 4,
      { 2408, 2409 },
      -1,
   } },

   /* ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w'))) */
   /* search805_0 -> 0 in the cache */
   /* search805_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace805_0_0_0 -> 724 in the cache */
   /* replace805_0_0_1 -> 2352 in the cache */
   /* replace805_0_0 -> 2402 in the cache */
   /* replace805_0_1_0 -> 725 in the cache */
   /* replace805_0_1_1 -> 2354 in the cache */
   /* replace805_0_1 -> 2403 in the cache */
   /* replace805_0 -> 2404 in the cache */
   /* replace805_1_0_0 -> 726 in the cache */
   /* replace805_1_0_1 -> 2361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 726, 2361 },
      -1,
   } },
   /* replace805_1_1_0 -> 2366 in the cache */
   /* replace805_1_1_1 -> 2367 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      3, 1,
      { 2366, 2367 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2412, 2413 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2404, 2414 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0) */
   /* search806_0_0 -> 32 in the cache */
   /* search806_0 -> 98 in the cache */
   /* search806_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace806_0 -> 32 in the cache */
   /* replace806_1 -> 113 in the cache */
   /* replace806 -> 1204 in the cache */

   /* ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0) */
   /* search807_0_0 -> 32 in the cache */
   /* search807_0 -> 98 in the cache */
   /* search807_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace807_0 -> 32 in the cache */
   /* replace807_1 -> 113 in the cache */
   /* replace807 -> 1208 in the cache */

   /* ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b')) */
   /* search808_0_0 -> 715 in the cache */
   /* search808_0 -> 1177 in the cache */
   /* search808_1_0 -> 1084 in the cache */
   /* search808_1 -> 2174 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 1177, 2174 },
      -1,
   } },

   /* replace808_0_0 -> 715 in the cache */
   /* replace808_0_1 -> 1084 in the cache */
   /* replace808_0 -> 1096 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1096 },
      -1,
   } },

   /* ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b')) */
   /* search809_0_0 -> 715 in the cache */
   /* search809_0 -> 1177 in the cache */
   /* search809_1_0 -> 1084 in the cache */
   /* search809_1 -> 2174 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1177, 2174 },
      -1,
   } },

   /* replace809_0_0 -> 715 in the cache */
   /* replace809_0_1 -> 1084 in the cache */
   /* replace809_0 -> 1096 in the cache */
   /* replace809 -> 2419 in the cache */

   /* ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b')) */
   /* search810_0_0 -> 715 in the cache */
   /* search810_0 -> 1177 in the cache */
   /* search810_1_0 -> 1084 in the cache */
   /* search810_1 -> 2174 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1177, 2174 },
      -1,
   } },

   /* replace810_0_0 -> 715 in the cache */
   /* replace810_0_1 -> 1084 in the cache */
   /* replace810_0 -> 1088 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1088 },
      -1,
   } },

   /* ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search811_0_0 -> 715 in the cache */
   /* search811_0 -> 1079 in the cache */
   /* search811_1_0 -> 1084 in the cache */
   /* search811_1 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1079, 1085 },
      -1,
   } },

   /* replace811_0_0 -> 715 in the cache */
   /* replace811_0_1 -> 1084 in the cache */
   /* replace811_0 -> 1096 in the cache */
   /* replace811 -> 1217 in the cache */

   /* ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b')) */
   /* search812_0_0_0 -> 715 in the cache */
   /* search812_0_0 -> 1079 in the cache */
   /* search812_0_1_0 -> 1084 in the cache */
   /* search812_0_1 -> 1085 in the cache */
   /* search812_0 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1115 },
      -1,
   } },

   /* replace812_0_0 -> 715 in the cache */
   /* replace812_0_1 -> 1084 in the cache */
   /* replace812_0 -> 1088 in the cache */
   /* replace812 -> 1214 in the cache */

   /* ('iand', 'a@bool16', 1.0) => ('b2f', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search813_1 -> 462 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2425, 462 },
      -1,
   } },

   /* replace813_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iand', 'a@bool32', 1.0) => ('b2f', 'a') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search814_1 -> 228 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2428, 228 },
      -1,
   } },

   /* replace814_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('flt', ('fneg', ('b2f', 'a@1')), 0) => a */
   /* search815_0_0_0 -> 715 in the cache */
   /* search815_0_0 -> 1079 in the cache */
   /* search815_0 -> 1082 in the cache */
   /* search815_1 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1082, 1178 },
      -1,
   } },

   /* replace815 -> 715 in the cache */

   /* ('ilt', 'a', 'a') => False */
   /* search816_0 -> 32 in the cache */
   /* search816_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace816 -> 1033 in the cache */

   /* ('ige', 'a', 'a') => True */
   /* search817_0 -> 32 in the cache */
   /* search817_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace817 -> 1186 in the cache */

   /* ('ieq', 'a', 'a') => True */
   /* search818_0 -> 32 in the cache */
   /* search818_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace818 -> 1186 in the cache */

   /* ('ine', 'a', 'a') => False */
   /* search819_0 -> 32 in the cache */
   /* search819_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace819 -> 1033 in the cache */

   /* ('ult', 'a', 'a') => False */
   /* search820_0 -> 32 in the cache */
   /* search820_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace820 -> 1033 in the cache */

   /* ('uge', 'a', 'a') => True */
   /* search821_0 -> 32 in the cache */
   /* search821_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace821 -> 1186 in the cache */

   /* ('flt', 'a', 'a') => False */
   /* search822_0 -> 32 in the cache */
   /* search822_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace822 -> 1033 in the cache */

   /* ('fge', 'a(is_a_number)', 'a') => True */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search823_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 2439, 32 },
      -1,
   } },

   /* replace823 -> 1186 in the cache */

   /* ('feq', 'a(is_a_number)', 'a') => True */
   /* search824_0 -> 2439 in the cache */
   /* search824_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 2439, 32 },
      -1,
   } },

   /* replace824 -> 1186 in the cache */

   /* ('fneu', 'a(is_a_number)', 'a') => False */
   /* search825_0 -> 2439 in the cache */
   /* search825_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 2439, 32 },
      -1,
   } },

   /* replace825 -> 1033 in the cache */

   /* ('iand', 'a', 'a') => a */
   /* search826_0 -> 32 in the cache */
   /* search826_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace826 -> 32 in the cache */

   /* ('iand', 'a', -1) => a */
   /* search827_0 -> 32 in the cache */
   /* search827_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace827 -> 32 in the cache */

   /* ('iand', 'a', 0) => 0 */
   /* search828_0 -> 32 in the cache */
   /* search828_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace828 -> 61 in the cache */

   /* ('ior', 'a', 'a') => a */
   /* search829_0 -> 32 in the cache */
   /* search829_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace829 -> 32 in the cache */

   /* ('ior', 'a', 0) => a */
   /* search830_0 -> 32 in the cache */
   /* search830_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace830 -> 32 in the cache */

   /* ('ior', 'a', True) => True */
   /* search831_0 -> 715 in the cache */
   /* search831_1 -> 1186 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 715, 1186 },
      -1,
   } },

   /* replace831 -> 1186 in the cache */

   /* ('ixor', 'a', 'a') => 0 */
   /* search832_0 -> 32 in the cache */
   /* search832_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace832 -> 61 in the cache */

   /* ('ixor', 'a', 0) => a */
   /* search833_0 -> 32 in the cache */
   /* search833_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace833 -> 32 in the cache */

   /* ('inot', ('inot', 'a')) => a */
   /* search834_0_0 -> 32 in the cache */
   /* search834_0 -> 2171 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 2171 },
      -1,
   } },

   /* replace834 -> 32 in the cache */

   /* ('ior', ('iand', 'a', 'b'), 'b') => b */
   /* search835_0_0 -> 0 in the cache */
   /* search835_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search835_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2452, 3 },
      -1,
   } },

   /* replace835 -> 3 in the cache */

   /* ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b') */
   /* search836_0_0 -> 0 in the cache */
   /* search836_0_1 -> 3 in the cache */
   /* search836_0 -> 84 in the cache */
   /* search836_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 84, 3 },
      -1,
   } },

   /* replace836_0 -> 0 in the cache */
   /* replace836_1 -> 3 in the cache */
   /* replace836 -> 2237 in the cache */

   /* ('iand', ('ior', 'a', 'b'), 'b') => b */
   /* search837_0_0 -> 0 in the cache */
   /* search837_0_1 -> 3 in the cache */
   /* search837_0 -> 84 in the cache */
   /* search837_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 84, 3 },
      -1,
   } },

   /* replace837 -> 3 in the cache */

   /* ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b') */
   /* search838_0_0 -> 0 in the cache */
   /* search838_0_1 -> 3 in the cache */
   /* search838_0 -> 2452 in the cache */
   /* search838_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2452, 3 },
      -1,
   } },

   /* replace838_0 -> 0 in the cache */
   /* replace838_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b')) */
   /* search839_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search839_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2458, 2459 },
      -1,
   } },

   /* replace839_0_0 -> 0 in the cache */
   /* replace839_0_1 -> 3 in the cache */
   /* replace839_0 -> 2237 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2237 },
      -1,
   } },

   /* ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b')) */
   /* search840_0_0 -> 0 in the cache */
   /* search840_0 -> 2458 in the cache */
   /* search840_1_0 -> 3 in the cache */
   /* search840_1 -> 2459 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2458, 2459 },
      -1,
   } },

   /* replace840_0_0 -> 0 in the cache */
   /* replace840_0_1 -> 3 in the cache */
   /* replace840_0 -> 2457 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2457 },
      -1,
   } },

   /* ('ishl', 0, 'a') => 0 */
   /* search841_0 -> 1178 in the cache */
   /* search841_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1178, 16 },
      -1,
   } },

   /* replace841 -> 1178 in the cache */

   /* ('ishl', 'a', 0) => a */
   /* search842_0 -> 32 in the cache */
   /* search842_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 120 },
      -1,
   } },

   /* replace842 -> 32 in the cache */

   /* ('ishr', 0, 'a') => 0 */
   /* search843_0 -> 1178 in the cache */
   /* search843_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1178, 16 },
      -1,
   } },

   /* replace843 -> 1178 in the cache */

   /* ('ishr', 'a', 0) => a */
   /* search844_0 -> 32 in the cache */
   /* search844_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 120 },
      -1,
   } },

   /* replace844 -> 32 in the cache */

   /* ('ushr', 0, 'a') => 0 */
   /* search845_0 -> 1178 in the cache */
   /* search845_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1178, 16 },
      -1,
   } },

   /* replace845 -> 1178 in the cache */

   /* ('ushr', 'a', 0) => a */
   /* search846_0 -> 32 in the cache */
   /* search846_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 32, 120 },
      -1,
   } },

   /* replace846 -> 32 in the cache */

   /* ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b') */
   /* search847_0_0 -> 11 in the cache */
   /* search847_0_1 -> 36 in the cache */
   /* search847_0 -> 2101 in the cache */
   /* search847_1_0 -> 11 in the cache */
   /* search847_1_1_0 -> 810 in the cache */
   /* search847_1_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 810, 2470 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2101, 2472 },
      -1,
   } },

   /* replace847_0 -> 11 in the cache */
   /* replace847_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b') */
   /* search848_0_0 -> 11 in the cache */
   /* search848_0_1 -> 36 in the cache */
   /* search848_0 -> 2101 in the cache */
   /* search848_1_0 -> 11 in the cache */
   /* search848_1_1_0 -> 810 in the cache */
   /* search848_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 810, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 2475 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2101, 2476 },
      -1,
   } },

   /* replace848_0 -> 11 in the cache */
   /* replace848_1 -> 36 in the cache */
   /* replace848 -> 2474 in the cache */

   /* ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b') */
   /* search849_0_0 -> 16 in the cache */
   /* search849_0_1 -> 36 in the cache */
   /* search849_0 -> 904 in the cache */
   /* search849_1_0 -> 16 in the cache */
   /* search849_1_1_0 -> 832 in the cache */
   /* search849_1_1_1_0 -> 36 in the cache */
   /* search849_1_1_1 -> 2470 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 832, 2470 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2478 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 904, 2479 },
      -1,
   } },

   /* replace849_0 -> 16 in the cache */
   /* replace849_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b') */
   /* search850_0_0 -> 16 in the cache */
   /* search850_0_1 -> 36 in the cache */
   /* search850_0 -> 904 in the cache */
   /* search850_1_0 -> 16 in the cache */
   /* search850_1_1_0 -> 832 in the cache */
   /* search850_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 832, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 2482 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 904, 2483 },
      -1,
   } },

   /* replace850_0 -> 16 in the cache */
   /* replace850_1 -> 36 in the cache */
   /* replace850 -> 2481 in the cache */

   /* ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b') */
   /* search851_0_0 -> 11 in the cache */
   /* search851_0_1 -> 36 in the cache */
   /* search851_0 -> 2105 in the cache */
   /* search851_1_0 -> 11 in the cache */
   /* search851_1_1_0 -> 810 in the cache */
   /* search851_1_1_1_0 -> 36 in the cache */
   /* search851_1_1_1 -> 2470 in the cache */
   /* search851_1_1 -> 2471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2105, 2485 },
      -1,
   } },

   /* replace851_0 -> 11 in the cache */
   /* replace851_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b') */
   /* search852_0_0 -> 11 in the cache */
   /* search852_0_1 -> 36 in the cache */
   /* search852_0 -> 2105 in the cache */
   /* search852_1_0 -> 11 in the cache */
   /* search852_1_1_0 -> 810 in the cache */
   /* search852_1_1_1 -> 36 in the cache */
   /* search852_1_1 -> 2475 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 2475 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2105, 2488 },
      -1,
   } },

   /* replace852_0 -> 11 in the cache */
   /* replace852_1 -> 36 in the cache */
   /* replace852 -> 2487 in the cache */

   /* ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b') */
   /* search853_0_0 -> 16 in the cache */
   /* search853_0_1 -> 36 in the cache */
   /* search853_0 -> 2130 in the cache */
   /* search853_1_0 -> 16 in the cache */
   /* search853_1_1_0 -> 832 in the cache */
   /* search853_1_1_1_0 -> 36 in the cache */
   /* search853_1_1_1 -> 2470 in the cache */
   /* search853_1_1 -> 2478 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2478 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2130, 2490 },
      -1,
   } },

   /* replace853_0 -> 16 in the cache */
   /* replace853_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b') */
   /* search854_0_0 -> 16 in the cache */
   /* search854_0_1 -> 36 in the cache */
   /* search854_0 -> 2130 in the cache */
   /* search854_1_0 -> 16 in the cache */
   /* search854_1_1_0 -> 832 in the cache */
   /* search854_1_1_1 -> 36 in the cache */
   /* search854_1_1 -> 2482 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 2482 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2130, 2493 },
      -1,
   } },

   /* replace854_0 -> 16 in the cache */
   /* replace854_1 -> 36 in the cache */
   /* replace854 -> 2492 in the cache */

   /* ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b'))) */
   /* search855_0 -> 11 in the cache */
   /* search855_1 -> 36 in the cache */
   /* search855 -> 2474 in the cache */

   /* replace855_0_0 -> 11 in the cache */
   /* replace855_0_1 -> 36 in the cache */
   /* replace855_0 -> 2101 in the cache */
   /* replace855_1_0 -> 11 in the cache */
   /* replace855_1_1_0 -> 810 in the cache */
   /* replace855_1_1_1 -> 36 in the cache */
   /* replace855_1_1 -> 2475 in the cache */
   /* replace855_1 -> 2476 in the cache */
   /* replace855 -> 2477 in the cache */

   /* ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b'))) */
   /* search856_0 -> 16 in the cache */
   /* search856_1 -> 36 in the cache */
   /* search856 -> 2481 in the cache */

   /* replace856_0_0 -> 16 in the cache */
   /* replace856_0_1 -> 36 in the cache */
   /* replace856_0 -> 904 in the cache */
   /* replace856_1_0 -> 16 in the cache */
   /* replace856_1_1_0 -> 832 in the cache */
   /* replace856_1_1_1 -> 36 in the cache */
   /* replace856_1_1 -> 2482 in the cache */
   /* replace856_1 -> 2483 in the cache */
   /* replace856 -> 2484 in the cache */

   /* ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b'))) */
   /* search857_0 -> 11 in the cache */
   /* search857_1 -> 36 in the cache */
   /* search857 -> 2487 in the cache */

   /* replace857_0_0 -> 11 in the cache */
   /* replace857_0_1 -> 36 in the cache */
   /* replace857_0 -> 2105 in the cache */
   /* replace857_1_0 -> 11 in the cache */
   /* replace857_1_1_0 -> 810 in the cache */
   /* replace857_1_1_1 -> 36 in the cache */
   /* replace857_1_1 -> 2475 in the cache */
   /* replace857_1 -> 2488 in the cache */
   /* replace857 -> 2489 in the cache */

   /* ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b'))) */
   /* search858_0 -> 16 in the cache */
   /* search858_1 -> 36 in the cache */
   /* search858 -> 2492 in the cache */

   /* replace858_0_0 -> 16 in the cache */
   /* replace858_0_1 -> 36 in the cache */
   /* replace858_0 -> 2130 in the cache */
   /* replace858_1_0 -> 16 in the cache */
   /* replace858_1_1_0 -> 832 in the cache */
   /* replace858_1_1_1 -> 36 in the cache */
   /* replace858_1_1 -> 2482 in the cache */
   /* replace858_1 -> 2493 in the cache */
   /* replace858 -> 2494 in the cache */

   /* ('~fexp2', ('flog2', 'a')) => a */
   /* search859_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 2495 },
      -1,
   } },

   /* replace859 -> 32 in the cache */

   /* ('~flog2', ('fexp2', 'a')) => a */
   /* search860_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2497 },
      -1,
   } },

   /* replace860 -> 32 in the cache */

   /* ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b')) */
   /* search861_0 -> 0 in the cache */
   /* search861_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* replace861_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace861_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2500, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2501 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b') */
   /* search862_0_0_0 -> 0 in the cache */
   /* search862_0_0 -> 2500 in the cache */
   /* search862_0_1 -> 3 in the cache */
   /* search862_0 -> 2501 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2501 },
      -1,
   } },

   /* replace862_0 -> 0 in the cache */
   /* replace862_1 -> 3 in the cache */
   /* replace862 -> 2499 in the cache */

   /* ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd')) */
   /* search863_0_0_0_0 -> 147 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 147 },
      -1,
   } },
   /* search863_0_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 2504, 148 },
      -1,
   } },
   /* search863_0_1_0_0 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 150 },
      -1,
   } },
   /* search863_0_1_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 2506, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 2505, 2507 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 3,
      { 2508 },
      -1,
   } },

   /* replace863_0_0 -> 147 in the cache */
   /* replace863_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 147, 148 },
      -1,
   } },
   /* replace863_1_0 -> 150 in the cache */
   /* replace863_1_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 150, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2510, 2511 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a') */
   /* search864_0_0_0 -> 32 in the cache */
   /* search864_0_0 -> 2495 in the cache */
   /* search864_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2495, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2513 },
      -1,
   } },

   /* replace864_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a') */
   /* search865_0_0_0 -> 32 in the cache */
   /* search865_0_0 -> 2495 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x4000000000000000 /* 2.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2495, 2516 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2517 },
      -1,
   } },

   /* replace865_0 -> 32 in the cache */
   /* replace865_1 -> 32 in the cache */
   /* replace865 -> 236 in the cache */

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')) */
   /* search866_0_0_0 -> 32 in the cache */
   /* search866_0_0 -> 2495 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x4010000000000000 /* 4.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2495, 2519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2520 },
      -1,
   } },

   /* replace866_0_0 -> 32 in the cache */
   /* replace866_0_1 -> 32 in the cache */
   /* replace866_0 -> 236 in the cache */
   /* replace866_1_0 -> 32 in the cache */
   /* replace866_1_1 -> 32 in the cache */
   /* replace866_1 -> 236 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 236, 236 },
      -1,
   } },

   /* ('~fpow', 'a', 1.0) => a */
   /* search867_0 -> 32 in the cache */
   /* search867_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 226 },
      -1,
   } },

   /* replace867 -> 32 in the cache */

   /* ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a') */
   /* search868_0 -> 32 in the cache */
   /* search868_1 -> 2516 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2516 },
      -1,
   } },

   /* replace868_0 -> 32 in the cache */
   /* replace868_1 -> 32 in the cache */
   /* replace868 -> 236 in the cache */

   /* ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')) */
   /* search869_0 -> 32 in the cache */
   /* search869_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2519 },
      -1,
   } },

   /* replace869_0_0 -> 32 in the cache */
   /* replace869_0_1 -> 32 in the cache */
   /* replace869_0 -> 236 in the cache */
   /* replace869_1_0 -> 32 in the cache */
   /* replace869_1_1 -> 32 in the cache */
   /* replace869_1 -> 236 in the cache */
   /* replace869 -> 2522 in the cache */

   /* ('~fpow', 2.0, 'a') => ('fexp2', 'a') */
   /* search870_0 -> 2516 in the cache */
   /* search870_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2516, 32 },
      -1,
   } },

   /* replace870_0 -> 32 in the cache */
   /* replace870 -> 2497 in the cache */

   /* ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a */
   /* search871_0_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x400199999999999a /* 2.2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2527 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fdd1743e963dc48 /* 0.454545 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2528, 2529 },
      -1,
   } },

   /* replace871 -> 32 in the cache */

   /* ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a') */
   /* search872_0_0_0 -> 32 in the cache */
   /* search872_0_0_1 -> 2527 in the cache */
   /* search872_0_0 -> 2528 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2528 },
      -1,
   } },
   /* search872_1 -> 2529 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2531, 2529 },
      -1,
   } },

   /* replace872_0 -> 32 in the cache */
   /* replace872 -> 103 in the cache */

   /* ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a')) */
   /* search873_0_0 -> 32 in the cache */
   /* search873_0 -> 2497 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 2497 },
      -1,
   } },

   /* replace873_0_0 -> 676 in the cache */
   /* replace873_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 676, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2534 },
      -1,
   } },

   /* ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a')) */
   /* search874_0_0 -> 32 in the cache */
   /* search874_0 -> 2497 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2497 },
      -1,
   } },

   /* replace874_0_0 -> 32 in the cache */
   /* replace874_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 98 },
      -1,
   } },

   /* ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a')) */
   /* search875_0_0 -> 32 in the cache */
   /* search875_0 -> 2497 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frsq,
      -1, 0,
      { 2497 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbfe0000000000000 /* -0.5 */ },
   } },
   /* replace875_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2539, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2540 },
      -1,
   } },

   /* ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a')) */
   /* search876_0_0 -> 32 in the cache */
   /* search876_0 -> 2515 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2515 },
      -1,
   } },

   /* replace876_0 -> 676 in the cache */
   /* replace876_1_0 -> 32 in the cache */
   /* replace876_1 -> 2495 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 676, 2495 },
      -1,
   } },

   /* ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a')) */
   /* search877_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2544 },
      -1,
   } },

   /* replace877_0_0 -> 32 in the cache */
   /* replace877_0 -> 2495 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2495 },
      -1,
   } },

   /* ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a')) */
   /* search878_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frsq,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2547 },
      -1,
   } },

   /* replace878_0 -> 2539 in the cache */
   /* replace878_1_0 -> 32 in the cache */
   /* replace878_1 -> 2495 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2539, 2495 },
      -1,
   } },

   /* ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a')) */
   /* search879_0_0 -> 0 in the cache */
   /* search879_0_1 -> 3 in the cache */
   /* search879_0 -> 2499 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2499 },
      -1,
   } },

   /* replace879_0 -> 3 in the cache */
   /* replace879_1_0 -> 0 in the cache */
   /* replace879_1 -> 2500 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 3, 2500 },
      -1,
   } },

   /* ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b')) */
   /* search880_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 0 },
      0,
   } },
   /* search880_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2552, 2553 },
      -1,
   } },

   /* replace880_0_0 -> 0 in the cache */
   /* replace880_0_1 -> 3 in the cache */
   /* replace880_0 -> 257 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 257 },
      -1,
   } },

   /* ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0)) */
   /* search881_0_0 -> 32 in the cache */
   /* search881_0_1 -> 113 in the cache */
   /* search881_0 -> 670 in the cache */
   /* search881_1 -> 113 in the cache */
   /* search881_2_0 -> 32 in the cache */
   /* search881_2 -> 2515 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 670, 113, 2515 },
      -1,
   } },

   /* replace881_0_0 -> 32 in the cache */
   /* replace881_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 113 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 1,
      { 2557 },
      -1,
   } },

   /* ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a') */
   /* search882_0_0 -> 32 in the cache */
   /* search882_0 -> 2515 in the cache */
   /* search882_1_0 -> 32 in the cache */
   /* search882_1 -> 2515 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 2515, 2515 },
      -1,
   } },

   /* replace882_0 -> 32 in the cache */
   /* replace882 -> 103 in the cache */

   /* ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a') */
   /* search883_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 16 },
      -1,
   } },
   /* search883_1_0 -> 16 in the cache */
   /* search883_1 -> 2560 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 2560, 2560 },
      -1,
   } },

   /* replace883_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('~fdiv', 1.0, 'a') => ('frcp', 'a') */
   /* search884_0 -> 226 in the cache */
   /* search884_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fdiv,
      -1, 0,
      { 226, 32 },
      -1,
   } },

   /* replace884_0 -> 32 in the cache */
   /* replace884 -> 2544 in the cache */

   /* ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b')) */
   /* search885_0 -> 0 in the cache */
   /* search885_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdiv,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* replace885_0 -> 0 in the cache */
   /* replace885_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 2565 },
      -1,
   } },

   /* ('~frcp', ('frcp', 'a')) => a */
   /* search886_0_0 -> 32 in the cache */
   /* search886_0 -> 2544 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2544 },
      -1,
   } },

   /* replace886 -> 32 in the cache */

   /* ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a') */
   /* search887_0_0 -> 32 in the cache */
   /* search887_0 -> 2515 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2515 },
      -1,
   } },

   /* replace887_0 -> 32 in the cache */
   /* replace887 -> 2547 in the cache */

   /* ('fsqrt', 'a') => ('frcp', ('frsq', 'a')) */
   /* search888_0 -> 32 in the cache */
   /* search888 -> 2515 in the cache */

   /* replace888_0_0 -> 32 in the cache */
   /* replace888_0 -> 2547 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2547 },
      -1,
   } },

   /* ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a') */
   /* search889_0_0 -> 32 in the cache */
   /* search889_0 -> 2547 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2547 },
      -1,
   } },

   /* replace889_0 -> 32 in the cache */
   /* replace889 -> 2515 in the cache */

   /* ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)) */
   /* search890_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsin,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace890_0_0_0_0_0_0 -> 2516 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fc45f306dc9c883 /* 0.15915494309189535 */ },
   } },
   /* replace890_0_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      5, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_0_0_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      4, 2,
      { 2573, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2574 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 3,
      { 2516, 2575 },
      -1,
   } },
   /* replace890_0_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2576, 226 },
      -1,
   } },
   /* replace890_0_0_0_1_0_0_0 -> 2516 in the cache */
   /* replace890_0_0_0_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_0_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      9, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_0_0_1_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      8, 2,
      { 2578, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2579 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      7, 3,
      { 2516, 2580 },
      -1,
   } },
   /* replace890_0_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2581, 226 },
      -1,
   } },
   /* replace890_0_0_0_1_1_0_0_0 -> 2516 in the cache */
   /* replace890_0_0_0_1_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_0_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      12, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_0_0_1_1_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      11, 2,
      { 2583, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2584 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      10, 3,
      { 2516, 2585 },
      -1,
   } },
   /* replace890_0_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2586, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2587 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      6, 7,
      { 2582, 2588 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2577, 2589 },
      -1,
   } },
   /* replace890_0_0_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 11,
      { 2590, 2519 },
      -1,
   } },
   /* replace890_0_1_0_0_0_0_0 -> 2516 in the cache */
   /* replace890_0_1_0_0_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_0_1_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      16, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_1_0_0_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      15, 2,
      { 2592, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2593 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      14, 3,
      { 2516, 2594 },
      -1,
   } },
   /* replace890_0_1_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2595, 226 },
      -1,
   } },
   /* replace890_0_1_0_0_1_0_0_0 -> 2516 in the cache */
   /* replace890_0_1_0_0_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_0_1_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      20, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_1_0_0_1_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      19, 2,
      { 2597, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2598 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      18, 3,
      { 2516, 2599 },
      -1,
   } },
   /* replace890_0_1_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2600, 226 },
      -1,
   } },
   /* replace890_0_1_0_0_1_1_0_0_0 -> 2516 in the cache */
   /* replace890_0_1_0_0_1_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_0_1_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      23, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_1_0_0_1_1_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      22, 2,
      { 2602, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2603 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      21, 3,
      { 2516, 2604 },
      -1,
   } },
   /* replace890_0_1_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2605, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      17, 7,
      { 2601, 2607 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2596, 2608 },
      -1,
   } },
   /* replace890_0_1_0_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      13, 11,
      { 2609, 2519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 11,
      { 2610 },
      -1,
   } },
   /* replace890_0_2_0_0_0_0_0 -> 2516 in the cache */
   /* replace890_0_2_0_0_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_0_2_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      27, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_2_0_0_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      26, 2,
      { 2612, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2613 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      25, 3,
      { 2516, 2614 },
      -1,
   } },
   /* replace890_0_2_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2615, 226 },
      -1,
   } },
   /* replace890_0_2_0_0_1_0_0_0 -> 2516 in the cache */
   /* replace890_0_2_0_0_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_0_2_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      31, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_2_0_0_1_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      30, 2,
      { 2617, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2618 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      29, 3,
      { 2516, 2619 },
      -1,
   } },
   /* replace890_0_2_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2620, 226 },
      -1,
   } },
   /* replace890_0_2_0_0_1_1_0_0_0 -> 2516 in the cache */
   /* replace890_0_2_0_0_1_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_0_2_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      34, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_0_2_0_0_1_1_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      33, 2,
      { 2622, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2623 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      32, 3,
      { 2516, 2624 },
      -1,
   } },
   /* replace890_0_2_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2625, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2626 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      28, 7,
      { 2621, 2627 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2616, 2628 },
      -1,
   } },
   /* replace890_0_2_0_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      24, 11,
      { 2629, 2519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 11,
      { 2630 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 34,
      { 2591, 2611, 2631 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fcccccccccccccd /* 0.225 */ },
   } },
   /* replace890_2_0_0_0_0 -> 2516 in the cache */
   /* replace890_2_0_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_2_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      38, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_2_0_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      37, 2,
      { 2634, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2635 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      36, 3,
      { 2516, 2636 },
      -1,
   } },
   /* replace890_2_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2637, 226 },
      -1,
   } },
   /* replace890_2_0_1_0_0_0 -> 2516 in the cache */
   /* replace890_2_0_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_2_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      42, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_2_0_1_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      41, 2,
      { 2639, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2640 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      40, 3,
      { 2516, 2641 },
      -1,
   } },
   /* replace890_2_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2642, 226 },
      -1,
   } },
   /* replace890_2_0_1_1_0_0_0 -> 2516 in the cache */
   /* replace890_2_0_1_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace890_2_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      45, 1,
      { 2572, 32 },
      -1,
   } },
   /* replace890_2_0_1_1_0_0_1_0_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      44, 2,
      { 2644, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2645 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      43, 3,
      { 2516, 2646 },
      -1,
   } },
   /* replace890_2_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2647, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2648 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      39, 7,
      { 2643, 2649 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2638, 2650 },
      -1,
   } },
   /* replace890_2_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      35, 11,
      { 2651, 2519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 46,
      { 2632, 2633, 2652 },
      -1,
   } },

   /* ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)) */
   /* search891_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fcos,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace891_0_0_0_0_0_0 -> 2516 in the cache */
   /* replace891_0_0_0_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_0_0_0_0_1_0_0 -> 2573 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe8000000000000 /* 0.75 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      4, 2,
      { 2573, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2656 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 3,
      { 2516, 2657 },
      -1,
   } },
   /* replace891_0_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2658, 226 },
      -1,
   } },
   /* replace891_0_0_0_1_0_0_0 -> 2516 in the cache */
   /* replace891_0_0_0_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_0_0_1_0_0_1_0_0 -> 2578 in the cache */
   /* replace891_0_0_0_1_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      8, 2,
      { 2578, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2660 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      7, 3,
      { 2516, 2661 },
      -1,
   } },
   /* replace891_0_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2662, 226 },
      -1,
   } },
   /* replace891_0_0_0_1_1_0_0_0 -> 2516 in the cache */
   /* replace891_0_0_0_1_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_0_0_1_1_0_0_1_0_0 -> 2583 in the cache */
   /* replace891_0_0_0_1_1_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      11, 2,
      { 2583, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2664 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      10, 3,
      { 2516, 2665 },
      -1,
   } },
   /* replace891_0_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2666, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2667 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      6, 7,
      { 2663, 2668 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2659, 2669 },
      -1,
   } },
   /* replace891_0_0_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 11,
      { 2670, 2519 },
      -1,
   } },
   /* replace891_0_1_0_0_0_0_0 -> 2516 in the cache */
   /* replace891_0_1_0_0_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_1_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_1_0_0_0_0_1_0_0 -> 2592 in the cache */
   /* replace891_0_1_0_0_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      15, 2,
      { 2592, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2672 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      14, 3,
      { 2516, 2673 },
      -1,
   } },
   /* replace891_0_1_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2674, 226 },
      -1,
   } },
   /* replace891_0_1_0_0_1_0_0_0 -> 2516 in the cache */
   /* replace891_0_1_0_0_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_1_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_1_0_0_1_0_0_1_0_0 -> 2597 in the cache */
   /* replace891_0_1_0_0_1_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      19, 2,
      { 2597, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      18, 3,
      { 2516, 2677 },
      -1,
   } },
   /* replace891_0_1_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2678, 226 },
      -1,
   } },
   /* replace891_0_1_0_0_1_1_0_0_0 -> 2516 in the cache */
   /* replace891_0_1_0_0_1_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_1_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_1_0_0_1_1_0_0_1_0_0 -> 2602 in the cache */
   /* replace891_0_1_0_0_1_1_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      22, 2,
      { 2602, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2680 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      21, 3,
      { 2516, 2681 },
      -1,
   } },
   /* replace891_0_1_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2682, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2683 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      17, 7,
      { 2679, 2684 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2675, 2685 },
      -1,
   } },
   /* replace891_0_1_0_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      13, 11,
      { 2686, 2519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 11,
      { 2687 },
      -1,
   } },
   /* replace891_0_2_0_0_0_0_0 -> 2516 in the cache */
   /* replace891_0_2_0_0_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_2_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_2_0_0_0_0_1_0_0 -> 2612 in the cache */
   /* replace891_0_2_0_0_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      26, 2,
      { 2612, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2689 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      25, 3,
      { 2516, 2690 },
      -1,
   } },
   /* replace891_0_2_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2691, 226 },
      -1,
   } },
   /* replace891_0_2_0_0_1_0_0_0 -> 2516 in the cache */
   /* replace891_0_2_0_0_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_2_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_2_0_0_1_0_0_1_0_0 -> 2617 in the cache */
   /* replace891_0_2_0_0_1_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      30, 2,
      { 2617, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2693 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      29, 3,
      { 2516, 2694 },
      -1,
   } },
   /* replace891_0_2_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2695, 226 },
      -1,
   } },
   /* replace891_0_2_0_0_1_1_0_0_0 -> 2516 in the cache */
   /* replace891_0_2_0_0_1_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_0_2_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_0_2_0_0_1_1_0_0_1_0_0 -> 2622 in the cache */
   /* replace891_0_2_0_0_1_1_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      33, 2,
      { 2622, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2697 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      32, 3,
      { 2516, 2698 },
      -1,
   } },
   /* replace891_0_2_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2699, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2700 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      28, 7,
      { 2696, 2701 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2692, 2702 },
      -1,
   } },
   /* replace891_0_2_0_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      24, 11,
      { 2703, 2519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 11,
      { 2704 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 34,
      { 2671, 2688, 2705 },
      -1,
   } },
   /* replace891_1 -> 2633 in the cache */
   /* replace891_2_0_0_0_0 -> 2516 in the cache */
   /* replace891_2_0_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_2_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_2_0_0_0_1_0_0 -> 2634 in the cache */
   /* replace891_2_0_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      37, 2,
      { 2634, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2707 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      36, 3,
      { 2516, 2708 },
      -1,
   } },
   /* replace891_2_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2709, 226 },
      -1,
   } },
   /* replace891_2_0_1_0_0_0 -> 2516 in the cache */
   /* replace891_2_0_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_2_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_2_0_1_0_0_1_0_0 -> 2639 in the cache */
   /* replace891_2_0_1_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      41, 2,
      { 2639, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2711 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      40, 3,
      { 2516, 2712 },
      -1,
   } },
   /* replace891_2_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2713, 226 },
      -1,
   } },
   /* replace891_2_0_1_1_0_0_0 -> 2516 in the cache */
   /* replace891_2_0_1_1_0_0_1_0_0_0 -> 2572 in the cache */
   /* replace891_2_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace891_2_0_1_1_0_0_1_0_0 -> 2644 in the cache */
   /* replace891_2_0_1_1_0_0_1_0_1 -> 2655 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      44, 2,
      { 2644, 2655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      43, 3,
      { 2516, 2716 },
      -1,
   } },
   /* replace891_2_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2717, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2718 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      39, 7,
      { 2714, 2719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2710, 2720 },
      -1,
   } },
   /* replace891_2_1 -> 2519 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      35, 11,
      { 2721, 2519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 46,
      { 2706, 2633, 2722 },
      -1,
   } },

   /* ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0) */
   /* search892_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2b16,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace892_0 -> 32 in the cache */
   /* replace892_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ine16,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0) */
   /* search893_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2b32,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace893_0 -> 32 in the cache */
   /* replace893_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ine32,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0) */
   /* search894_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_i2b1,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace894_0 -> 32 in the cache */
   /* replace894_1 -> 61 in the cache */
   /* replace894 -> 1182 in the cache */

   /* ('ieq', 'a', True) => a */
   /* search895_0 -> 715 in the cache */
   /* search895_1 -> 1186 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 715, 1186 },
      -1,
   } },

   /* replace895 -> 715 in the cache */

   /* ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a') */
   /* search896_0 -> 715 in the cache */
   /* search896_1 -> 1186 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 715, 1186 },
      3,
   } },

   /* replace896_0 -> 715 in the cache */
   /* replace896 -> 1081 in the cache */

   /* ('ine', 'a', False) => a */
   /* search897_0 -> 715 in the cache */
   /* search897_1 -> 1033 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 715, 1033 },
      -1,
   } },

   /* replace897 -> 715 in the cache */

   /* ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a') */
   /* search898_0 -> 715 in the cache */
   /* search898_1 -> 1033 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 715, 1033 },
      3,
   } },

   /* replace898_0 -> 715 in the cache */
   /* replace898 -> 1081 in the cache */

   /* ('bcsel', 'a', True, False) => a */
   /* search899_0 -> 715 in the cache */
   /* search899_1 -> 1186 in the cache */
   /* search899_2 -> 1033 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1186, 1033 },
      -1,
   } },

   /* replace899 -> 715 in the cache */

   /* ('bcsel', 'a', False, True) => ('inot', 'a') */
   /* search900_0 -> 715 in the cache */
   /* search900_1 -> 1033 in the cache */
   /* search900_2 -> 1186 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1033, 1186 },
      -1,
   } },

   /* replace900_0 -> 715 in the cache */
   /* replace900 -> 1081 in the cache */

   /* ('bcsel', True, 'b', 'c') => b */
   /* search901_0 -> 1186 in the cache */
   /* search901_1 -> 1067 in the cache */
   /* search901_2 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1186, 1067, 665 },
      -1,
   } },

   /* replace901 -> 1067 in the cache */

   /* ('bcsel', False, 'b', 'c') => c */
   /* search902_0 -> 1033 in the cache */
   /* search902_1 -> 1067 in the cache */
   /* search902_2 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1033, 1067, 665 },
      -1,
   } },

   /* replace902 -> 665 in the cache */

   /* ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search903_0 -> 715 in the cache */
   /* search903_1 -> 462 in the cache */
   /* search903_2 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 462, 115 },
      -1,
   } },

   /* replace903_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 715 },
      -1,
   } },

   /* ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search904_0 -> 715 in the cache */
   /* search904_1 -> 115 in the cache */
   /* search904_2 -> 462 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 115, 462 },
      -1,
   } },

   /* replace904_0_0 -> 715 in the cache */
   /* replace904_0 -> 1081 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1081 },
      -1,
   } },

   /* ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search905_0 -> 715 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 2741, 2742 },
      -1,
   } },

   /* replace905_0_0 -> 715 in the cache */
   /* replace905_0 -> 2738 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2738 },
      -1,
   } },

   /* ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search906_0 -> 715 in the cache */
   /* search906_1 -> 2742 in the cache */
   /* search906_2 -> 2741 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 2742, 2741 },
      -1,
   } },

   /* replace906_0_0_0 -> 715 in the cache */
   /* replace906_0_0 -> 1081 in the cache */
   /* replace906_0 -> 2740 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2740 },
      -1,
   } },

   /* ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search907_0 -> 715 in the cache */
   /* search907_1 -> 228 in the cache */
   /* search907_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 228, 117 },
      -1,
   } },

   /* replace907_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 715 },
      -1,
   } },

   /* ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search908_0 -> 715 in the cache */
   /* search908_1 -> 117 in the cache */
   /* search908_2 -> 228 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 117, 228 },
      -1,
   } },

   /* replace908_0_0 -> 715 in the cache */
   /* replace908_0 -> 1081 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1081 },
      -1,
   } },

   /* ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search909_0 -> 715 in the cache */
   /* search909_1 -> 263 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 263, 2751 },
      -1,
   } },

   /* replace909_0_0 -> 715 in the cache */
   /* replace909_0 -> 2748 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2748 },
      -1,
   } },

   /* ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search910_0 -> 715 in the cache */
   /* search910_1 -> 2751 in the cache */
   /* search910_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 2751, 263 },
      -1,
   } },

   /* replace910_0_0_0 -> 715 in the cache */
   /* replace910_0_0 -> 1081 in the cache */
   /* replace910_0 -> 2750 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2750 },
      -1,
   } },

   /* ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search911_0 -> 715 in the cache */
   /* search911_1 -> 603 in the cache */
   /* search911_2 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 603, 1865 },
      -1,
   } },

   /* replace911_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 715 },
      -1,
   } },

   /* ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search912_0 -> 715 in the cache */
   /* search912_1 -> 1865 in the cache */
   /* search912_2 -> 603 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1865, 603 },
      -1,
   } },

   /* replace912_0_0 -> 715 in the cache */
   /* replace912_0 -> 1081 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1081 },
      -1,
   } },

   /* ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search913_0 -> 715 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 2760, 2761 },
      -1,
   } },

   /* replace913_0_0 -> 715 in the cache */
   /* replace913_0 -> 2757 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2757 },
      -1,
   } },

   /* ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search914_0 -> 715 in the cache */
   /* search914_1 -> 2761 in the cache */
   /* search914_2 -> 2760 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 2761, 2760 },
      -1,
   } },

   /* replace914_0_0_0 -> 715 in the cache */
   /* replace914_0_0 -> 1081 in the cache */
   /* replace914_0 -> 2759 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2759 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', 'b') => b */
   /* search915_0 -> 715 in the cache */
   /* search915_1 -> 3 in the cache */
   /* search915_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 3, 3 },
      -1,
   } },

   /* replace915 -> 3 in the cache */

   /* ('~fcsel', 'a', 'b', 'b') => b */
   /* search916_0 -> 16 in the cache */
   /* search916_1 -> 36 in the cache */
   /* search916_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fcsel,
      -1, 0,
      { 16, 36, 36 },
      -1,
   } },

   /* replace916 -> 36 in the cache */

   /* ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1')) */
   /* search917_0 -> 715 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   /* search917_2 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 2768, 1178 },
      -1,
   } },

   /* replace917_0_0 -> 715 in the cache */
   /* replace917_0 -> 1177 in the cache */
   /* replace917 -> 2173 in the cache */

   /* ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a'))) */
   /* search918_0 -> 715 in the cache */
   /* search918_1 -> 1178 in the cache */
   /* search918_2 -> 2768 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1178, 2768 },
      -1,
   } },

   /* replace918_0_0_0 -> 715 in the cache */
   /* replace918_0_0 -> 1081 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 1081 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2771 },
      -1,
   } },

   /* ('bcsel', 'a', 1, 0) => ('b2i', 'a@1') */
   /* search919_0 -> 715 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   /* search919_2 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 2773, 1178 },
      -1,
   } },

   /* replace919_0 -> 715 in the cache */
   /* replace919 -> 1177 in the cache */

   /* ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a')) */
   /* search920_0 -> 715 in the cache */
   /* search920_1 -> 1178 in the cache */
   /* search920_2 -> 2773 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 715, 1178, 2773 },
      -1,
   } },

   /* replace920_0_0 -> 715 in the cache */
   /* replace920_0 -> 1081 in the cache */
   /* replace920 -> 2771 in the cache */

   /* ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b'))) */
   /* search921_0_0_0 -> 715 in the cache */
   /* search921_0_0 -> 1177 in the cache */
   /* search921_0 -> 2173 in the cache */
   /* search921_1_0_0 -> 1084 in the cache */
   /* search921_1_0 -> 2174 in the cache */
   /* search921_1 -> 2175 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2173, 2175 },
      -1,
   } },

   /* replace921_0_0_0 -> 715 in the cache */
   /* replace921_0_0_1 -> 1084 in the cache */
   /* replace921_0_0 -> 1096 in the cache */
   /* replace921_0 -> 2419 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 2419 },
      -1,
   } },

   /* ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b'))) */
   /* search922_0_0_0 -> 715 in the cache */
   /* search922_0_0 -> 1177 in the cache */
   /* search922_0 -> 2173 in the cache */
   /* search922_1_0_0 -> 1084 in the cache */
   /* search922_1_0 -> 2174 in the cache */
   /* search922_1 -> 2175 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2173, 2175 },
      -1,
   } },

   /* replace922_0_0_0 -> 715 in the cache */
   /* replace922_0_0_1 -> 1084 in the cache */
   /* replace922_0_0 -> 1088 in the cache */
   /* replace922_0 -> 2422 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 2422 },
      -1,
   } },

   /* ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a') */
   /* search923_0_0_0 -> 715 in the cache */
   /* search923_0_0 -> 1177 in the cache */
   /* search923_0 -> 2173 in the cache */
   /* search923_1 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 2173, 1178 },
      -1,
   } },

   /* replace923_0 -> 715 in the cache */
   /* replace923 -> 1081 in the cache */

   /* ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a */
   /* search924_0_0_0 -> 715 in the cache */
   /* search924_0_0 -> 1177 in the cache */
   /* search924_0 -> 2173 in the cache */
   /* search924_1 -> 2768 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 2173, 2768 },
      -1,
   } },

   /* replace924 -> 715 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), 0) => a */
   /* search925_0_0_0 -> 715 in the cache */
   /* search925_0_0 -> 1177 in the cache */
   /* search925_0 -> 2173 in the cache */
   /* search925_1 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2173, 1178 },
      -1,
   } },

   /* replace925 -> 715 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a') */
   /* search926_0_0_0 -> 715 in the cache */
   /* search926_0_0 -> 1177 in the cache */
   /* search926_0 -> 2173 in the cache */
   /* search926_1 -> 2768 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2173, 2768 },
      -1,
   } },

   /* replace926_0 -> 715 in the cache */
   /* replace926 -> 1081 in the cache */

   /* ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a') */
   /* search927_0_0_0 -> 715 in the cache */
   /* search927_0_0 -> 1177 in the cache */
   /* search927_0 -> 2173 in the cache */
   /* search927_1 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 2173, 1178 },
      -1,
   } },

   /* replace927_0 -> 715 in the cache */
   /* replace927 -> 1081 in the cache */

   /* ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a */
   /* search928_0_0_0 -> 715 in the cache */
   /* search928_0_0 -> 1177 in the cache */
   /* search928_0 -> 2173 in the cache */
   /* search928_1 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 2173, 1178 },
      -1,
   } },

   /* replace928 -> 715 in the cache */

   /* ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a */
   /* search929_0 -> 1178 in the cache */
   /* search929_1_0_0 -> 715 in the cache */
   /* search929_1_0 -> 1177 in the cache */
   /* search929_1 -> 2173 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1178, 2173 },
      -1,
   } },

   /* replace929 -> 715 in the cache */

   /* ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a') */
   /* search930_0_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2787 },
      -1,
   } },
   /* search930_1 -> 1089 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2788, 1089 },
      -1,
   } },

   /* replace930_0 -> 32 in the cache */
   /* replace930 -> 1466 in the cache */

   /* ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a') */
   /* search931_0_0_0 -> 32 in the cache */
   /* search931_0_0 -> 2787 in the cache */
   /* search931_0 -> 2788 in the cache */
   /* search931_1 -> 2773 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2788, 2773 },
      -1,
   } },

   /* replace931_0 -> 32 in the cache */
   /* replace931 -> 2787 in the cache */

   /* ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b'))) */
   /* search932_0_0_0 -> 715 in the cache */
   /* search932_0_0 -> 1177 in the cache */
   /* search932_0 -> 2173 in the cache */
   /* search932_1_0_0 -> 1084 in the cache */
   /* search932_1_0 -> 2174 in the cache */
   /* search932_1 -> 2175 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 2173, 2175 },
      -1,
   } },

   /* replace932_0_0_0 -> 715 in the cache */
   /* replace932_0_0_1 -> 1084 in the cache */
   /* replace932_0_0 -> 1096 in the cache */
   /* replace932_0 -> 2419 in the cache */
   /* replace932 -> 2777 in the cache */

   /* ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b'))) */
   /* search933_0_0_0 -> 715 in the cache */
   /* search933_0_0 -> 1177 in the cache */
   /* search933_0 -> 2173 in the cache */
   /* search933_1_0_0 -> 1084 in the cache */
   /* search933_1_0 -> 2174 in the cache */
   /* search933_1 -> 2175 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 2173, 2175 },
      -1,
   } },

   /* replace933_0_0_0 -> 715 in the cache */
   /* replace933_0_0_1 -> 1084 in the cache */
   /* replace933_0_0 -> 1088 in the cache */
   /* replace933_0 -> 2422 in the cache */
   /* replace933 -> 2779 in the cache */

   /* ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b'))) */
   /* search934_0_0_0 -> 715 in the cache */
   /* search934_0_0 -> 1177 in the cache */
   /* search934_0 -> 2173 in the cache */
   /* search934_1_0_0 -> 1084 in the cache */
   /* search934_1_0 -> 2174 in the cache */
   /* search934_1 -> 2175 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 2173, 2175 },
      -1,
   } },

   /* replace934_0_0_0 -> 715 in the cache */
   /* replace934_0_0_1 -> 1084 in the cache */
   /* replace934_0_0 -> 1088 in the cache */
   /* replace934_0 -> 2422 in the cache */
   /* replace934 -> 2779 in the cache */

   /* ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b'))) */
   /* search935_0_0_0 -> 715 in the cache */
   /* search935_0_0 -> 1177 in the cache */
   /* search935_0 -> 2173 in the cache */
   /* search935_1_0_0 -> 1084 in the cache */
   /* search935_1_0 -> 2174 in the cache */
   /* search935_1 -> 2175 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 2173, 2175 },
      -1,
   } },

   /* replace935_0_0_0 -> 715 in the cache */
   /* replace935_0_0_1 -> 1084 in the cache */
   /* replace935_0_0 -> 1096 in the cache */
   /* replace935_0 -> 2419 in the cache */
   /* replace935 -> 2777 in the cache */

   /* ('i2b16', ('b2i', 'a@16')) => a */
   /* search936_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2b16,
      -1, 0,
      { 2795 },
      -1,
   } },

   /* replace936 -> 11 in the cache */

   /* ('i2b32', ('b2i', 'a@32')) => a */
   /* search937_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2b32,
      -1, 0,
      { 2797 },
      -1,
   } },

   /* replace937 -> 16 in the cache */

   /* ('f2i', ('ftrunc', 'a')) => ('f2i', 'a') */
   /* search938_0_0 -> 32 in the cache */
   /* search938_0 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 669 },
      -1,
   } },

   /* replace938_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('f2u', ('ftrunc', 'a')) => ('f2u', 'a') */
   /* search939_0_0 -> 32 in the cache */
   /* search939_0 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2u,
      -1, 0,
      { 669 },
      -1,
   } },

   /* replace939_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2u,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2b', ('ineg', 'a')) => ('i2b', 'a') */
   /* search940_0_0 -> 32 in the cache */
   /* search940_0 -> 100 in the cache */
   /* search940 -> 111 in the cache */

   /* replace940_0 -> 32 in the cache */
   /* replace940 -> 112 in the cache */

   /* ('i2b', ('iabs', 'a')) => ('i2b', 'a') */
   /* search941_0_0 -> 32 in the cache */
   /* search941_0 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 106 },
      -1,
   } },

   /* replace941_0 -> 32 in the cache */
   /* replace941 -> 112 in the cache */

   /* ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0) */
   /* search942_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_f2b1,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 2804 },
      -1,
   } },

   /* replace942_0 -> 32 in the cache */
   /* replace942_1 -> 113 in the cache */
   /* replace942 -> 1208 in the cache */

   /* ('f2fmp', ('f2f32', 'a@16')) => a */
   /* search943_0_0 -> 11 in the cache */
   /* search943_0 -> 1739 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1739 },
      -1,
   } },

   /* replace943 -> 11 in the cache */

   /* ('i2imp', ('i2i32', 'a@16')) => a */
   /* search944_0_0 -> 11 in the cache */
   /* search944_0 -> 1741 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1741 },
      -1,
   } },

   /* replace944 -> 11 in the cache */

   /* ('i2imp', ('u2u32', 'a@16')) => a */
   /* search945_0_0 -> 11 in the cache */
   /* search945_0 -> 1743 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1743 },
      -1,
   } },

   /* replace945 -> 11 in the cache */

   /* ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a') */
   /* search946_0_0 -> 11 in the cache */
   /* search946_0 -> 1739 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 1739 },
      -1,
   } },

   /* replace946_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a') */
   /* search947_0_0 -> 11 in the cache */
   /* search947_0 -> 1739 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 1739 },
      -1,
   } },

   /* replace947_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a') */
   /* search948_0_0 -> 11 in the cache */
   /* search948_0 -> 1741 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 1741 },
      -1,
   } },

   /* replace948_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a') */
   /* search949_0_0 -> 11 in the cache */
   /* search949_0 -> 1743 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 1743 },
      -1,
   } },

   /* replace949_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a') */
   /* search950_0_0 -> 715 in the cache */
   /* search950_0 -> 1346 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1346 },
      -1,
   } },

   /* replace950_0 -> 715 in the cache */
   /* replace950 -> 1342 in the cache */

   /* ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search951_0_0 -> 715 in the cache */
   /* search951_0 -> 1334 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1334 },
      -1,
   } },

   /* replace951_0 -> 715 in the cache */
   /* replace951 -> 1330 in the cache */

   /* ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search952_0_0 -> 715 in the cache */
   /* search952_0 -> 1334 in the cache */
   /* search952 -> 2818 in the cache */

   /* replace952_0 -> 715 in the cache */
   /* replace952 -> 1330 in the cache */

   /* ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a') */
   /* search953_0_0 -> 715 in the cache */
   /* search953_0 -> 1346 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 1346 },
      -1,
   } },

   /* replace953_0 -> 715 in the cache */
   /* replace953 -> 1330 in the cache */

   /* ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a') */
   /* search954_0_0 -> 715 in the cache */
   /* search954_0 -> 1346 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 1346 },
      -1,
   } },

   /* replace954_0 -> 715 in the cache */
   /* replace954 -> 1330 in the cache */

   /* ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a') */
   /* search955_0_0 -> 715 in the cache */
   /* search955_0 -> 1334 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 1334 },
      -1,
   } },

   /* replace955_0 -> 715 in the cache */
   /* replace955 -> 1342 in the cache */

   /* ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a') */
   /* search956_0_0 -> 715 in the cache */
   /* search956_0 -> 1334 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 1334 },
      -1,
   } },

   /* replace956_0 -> 715 in the cache */
   /* replace956 -> 1342 in the cache */

   /* ('f2f32', ('f2fmp', 'a@32')) => a */
   /* search957_0_0 -> 16 in the cache */
   /* search957_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1935 },
      -1,
   } },

 