/* This file is generated by venus-protocol git-e05ae158. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_COMMAND_BUFFER_H
#define VN_PROTOCOL_RENDERER_COMMAND_BUFFER_H

#include "vn_protocol_renderer_structs.h"

/* struct VkCommandBufferAllocateInfo chain */

static inline void *
vn_decode_VkCommandBufferAllocateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCommandBufferAllocateInfo_self_temp(struct vn_cs_decoder *dec, VkCommandBufferAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkCommandPool_lookup(dec, &val->commandPool);
    vn_decode_VkCommandBufferLevel(dec, &val->level);
    vn_decode_uint32_t(dec, &val->commandBufferCount);
}

static inline void
vn_decode_VkCommandBufferAllocateInfo_temp(struct vn_cs_decoder *dec, VkCommandBufferAllocateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkCommandBufferAllocateInfo_pnext_temp(dec);
    vn_decode_VkCommandBufferAllocateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkCommandBufferAllocateInfo_handle_self(VkCommandBufferAllocateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkCommandPool_handle(&val->commandPool);
    /* skip val->level */
    /* skip val->commandBufferCount */
}

static inline void
vn_replace_VkCommandBufferAllocateInfo_handle(VkCommandBufferAllocateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO:
            vn_replace_VkCommandBufferAllocateInfo_handle_self((VkCommandBufferAllocateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCommandBufferInheritanceInfo chain */

static inline void
vn_encode_VkCommandBufferInheritanceInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferInheritanceInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkRenderPass(enc, &val->renderPass);
    vn_encode_uint32_t(enc, &val->subpass);
    vn_encode_VkFramebuffer(enc, &val->framebuffer);
    vn_encode_VkBool32(enc, &val->occlusionQueryEnable);
    vn_encode_VkFlags(enc, &val->queryFlags);
    vn_encode_VkFlags(enc, &val->pipelineStatistics);
}

static inline void
vn_encode_VkCommandBufferInheritanceInfo(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO });
    vn_encode_VkCommandBufferInheritanceInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferInheritanceInfo_self(enc, val);
}

static inline void *
vn_decode_VkCommandBufferInheritanceInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCommandBufferInheritanceInfo_self_temp(struct vn_cs_decoder *dec, VkCommandBufferInheritanceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkRenderPass_lookup(dec, &val->renderPass);
    vn_decode_uint32_t(dec, &val->subpass);
    vn_decode_VkFramebuffer_lookup(dec, &val->framebuffer);
    vn_decode_VkBool32(dec, &val->occlusionQueryEnable);
    vn_decode_VkFlags(dec, &val->queryFlags);
    vn_decode_VkFlags(dec, &val->pipelineStatistics);
}

static inline void
vn_decode_VkCommandBufferInheritanceInfo_temp(struct vn_cs_decoder *dec, VkCommandBufferInheritanceInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkCommandBufferInheritanceInfo_pnext_temp(dec);
    vn_decode_VkCommandBufferInheritanceInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkCommandBufferInheritanceInfo_handle_self(VkCommandBufferInheritanceInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkRenderPass_handle(&val->renderPass);
    /* skip val->subpass */
    vn_replace_VkFramebuffer_handle(&val->framebuffer);
    /* skip val->occlusionQueryEnable */
    /* skip val->queryFlags */
    /* skip val->pipelineStatistics */
}

static inline void
vn_replace_VkCommandBufferInheritanceInfo_handle(VkCommandBufferInheritanceInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO:
            vn_replace_VkCommandBufferInheritanceInfo_handle_self((VkCommandBufferInheritanceInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceGroupCommandBufferBeginInfo chain */

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(struct vn_cs_encoder *enc, const VkDeviceGroupCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->deviceMask);
}

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo(struct vn_cs_encoder *enc, const VkDeviceGroupCommandBufferBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO });
    vn_encode_VkDeviceGroupCommandBufferBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(enc, val);
}

static inline void *
vn_decode_VkDeviceGroupCommandBufferBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupCommandBufferBeginInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->deviceMask);
}

static inline void
vn_decode_VkDeviceGroupCommandBufferBeginInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupCommandBufferBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupCommandBufferBeginInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupCommandBufferBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupCommandBufferBeginInfo_handle_self(VkDeviceGroupCommandBufferBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->deviceMask */
}

static inline void
vn_replace_VkDeviceGroupCommandBufferBeginInfo_handle(VkDeviceGroupCommandBufferBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            vn_replace_VkDeviceGroupCommandBufferBeginInfo_handle_self((VkDeviceGroupCommandBufferBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCommandBufferBeginInfo chain */

static inline void
vn_encode_VkCommandBufferBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkCommandBufferBeginInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(enc, (const VkDeviceGroupCommandBufferBeginInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferBeginInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    if (vn_encode_simple_pointer(enc, val->pInheritanceInfo))
        vn_encode_VkCommandBufferInheritanceInfo(enc, val->pInheritanceInfo);
}

static inline void
vn_encode_VkCommandBufferBeginInfo(struct vn_cs_encoder *enc, const VkCommandBufferBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO });
    vn_encode_VkCommandBufferBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferBeginInfo_self(enc, val);
}

static inline void *
vn_decode_VkCommandBufferBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupCommandBufferBeginInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkCommandBufferBeginInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupCommandBufferBeginInfo_self_temp(dec, (VkDeviceGroupCommandBufferBeginInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkCommandBufferBeginInfo_self_temp(struct vn_cs_decoder *dec, VkCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    if (vn_decode_simple_pointer(dec)) {
        val->pInheritanceInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pInheritanceInfo));
        if (!val->pInheritanceInfo) return;
        vn_decode_VkCommandBufferInheritanceInfo_temp(dec, (VkCommandBufferInheritanceInfo *)val->pInheritanceInfo);
    } else {
        val->pInheritanceInfo = NULL;
    }
}

static inline void
vn_decode_VkCommandBufferBeginInfo_temp(struct vn_cs_decoder *dec, VkCommandBufferBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkCommandBufferBeginInfo_pnext_temp(dec);
    vn_decode_VkCommandBufferBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkCommandBufferBeginInfo_handle_self(VkCommandBufferBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    if (val->pInheritanceInfo)
        vn_replace_VkCommandBufferInheritanceInfo_handle((VkCommandBufferInheritanceInfo *)val->pInheritanceInfo);
}

static inline void
vn_replace_VkCommandBufferBeginInfo_handle(VkCommandBufferBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO:
            vn_replace_VkCommandBufferBeginInfo_handle_self((VkCommandBufferBeginInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            vn_replace_VkDeviceGroupCommandBufferBeginInfo_handle_self((VkDeviceGroupCommandBufferBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBufferCopy */

static inline void
vn_decode_VkBufferCopy_temp(struct vn_cs_decoder *dec, VkBufferCopy *val)
{
    vn_decode_VkDeviceSize(dec, &val->srcOffset);
    vn_decode_VkDeviceSize(dec, &val->dstOffset);
    vn_decode_VkDeviceSize(dec, &val->size);
}

static inline void
vn_replace_VkBufferCopy_handle(VkBufferCopy *val)
{
    /* skip val->srcOffset */
    /* skip val->dstOffset */
    /* skip val->size */
}

/* struct VkImageSubresourceLayers */

static inline void
vn_decode_VkImageSubresourceLayers_temp(struct vn_cs_decoder *dec, VkImageSubresourceLayers *val)
{
    vn_decode_VkFlags(dec, &val->aspectMask);
    vn_decode_uint32_t(dec, &val->mipLevel);
    vn_decode_uint32_t(dec, &val->baseArrayLayer);
    vn_decode_uint32_t(dec, &val->layerCount);
}

static inline void
vn_replace_VkImageSubresourceLayers_handle(VkImageSubresourceLayers *val)
{
    /* skip val->aspectMask */
    /* skip val->mipLevel */
    /* skip val->baseArrayLayer */
    /* skip val->layerCount */
}

/* struct VkImageCopy */

static inline void
vn_decode_VkImageCopy_temp(struct vn_cs_decoder *dec, VkImageCopy *val)
{
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->srcOffset);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->dstOffset);
    vn_decode_VkExtent3D_temp(dec, &val->extent);
}

static inline void
vn_replace_VkImageCopy_handle(VkImageCopy *val)
{
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    vn_replace_VkOffset3D_handle(&val->srcOffset);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    vn_replace_VkOffset3D_handle(&val->dstOffset);
    vn_replace_VkExtent3D_handle(&val->extent);
}

/* struct VkImageBlit */

static inline void
vn_decode_VkImageBlit_temp(struct vn_cs_decoder *dec, VkImageBlit *val)
{
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    {
        vn_decode_array_size(dec, 2);
        for (uint32_t i = 0; i < 2; i++)
            vn_decode_VkOffset3D_temp(dec, &val->srcOffsets[i]);
    }
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    {
        vn_decode_array_size(dec, 2);
        for (uint32_t i = 0; i < 2; i++)
            vn_decode_VkOffset3D_temp(dec, &val->dstOffsets[i]);
    }
}

static inline void
vn_replace_VkImageBlit_handle(VkImageBlit *val)
{
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    for (uint32_t i = 0; i < 2; i++)
        vn_replace_VkOffset3D_handle(&val->srcOffsets[i]);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    for (uint32_t i = 0; i < 2; i++)
        vn_replace_VkOffset3D_handle(&val->dstOffsets[i]);
}

/* struct VkBufferImageCopy */

static inline void
vn_decode_VkBufferImageCopy_temp(struct vn_cs_decoder *dec, VkBufferImageCopy *val)
{
    vn_decode_VkDeviceSize(dec, &val->bufferOffset);
    vn_decode_uint32_t(dec, &val->bufferRowLength);
    vn_decode_uint32_t(dec, &val->bufferImageHeight);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->imageSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->imageOffset);
    vn_decode_VkExtent3D_temp(dec, &val->imageExtent);
}

static inline void
vn_replace_VkBufferImageCopy_handle(VkBufferImageCopy *val)
{
    /* skip val->bufferOffset */
    /* skip val->bufferRowLength */
    /* skip val->bufferImageHeight */
    vn_replace_VkImageSubresourceLayers_handle(&val->imageSubresource);
    vn_replace_VkOffset3D_handle(&val->imageOffset);
    vn_replace_VkExtent3D_handle(&val->imageExtent);
}

/* union VkClearColorValue */

static inline void
vn_decode_VkClearColorValue_temp(struct vn_cs_decoder *dec, VkClearColorValue *val)
{
    uint32_t tag;
    vn_decode_uint32_t(dec, &tag);
    switch (tag) {
    case 0:
        {
        const size_t array_size = vn_decode_array_size(dec, 4);
        vn_decode_float_array(dec, val->float32, array_size);
    }
        break;
    case 1:
        {
        const size_t array_size = vn_decode_array_size(dec, 4);
        vn_decode_int32_t_array(dec, val->int32, array_size);
    }
        break;
    case 2:
        {
        const size_t array_size = vn_decode_array_size(dec, 4);
        vn_decode_uint32_t_array(dec, val->uint32, array_size);
    }
        break;
    default:
        vn_cs_decoder_set_fatal(dec);
        break;
    }
}

/* struct VkClearDepthStencilValue */

static inline void
vn_decode_VkClearDepthStencilValue_temp(struct vn_cs_decoder *dec, VkClearDepthStencilValue *val)
{
    vn_decode_float(dec, &val->depth);
    vn_decode_uint32_t(dec, &val->stencil);
}

static inline void
vn_replace_VkClearDepthStencilValue_handle(VkClearDepthStencilValue *val)
{
    /* skip val->depth */
    /* skip val->stencil */
}

/* union VkClearValue */

static inline void
vn_decode_VkClearValue_temp(struct vn_cs_decoder *dec, VkClearValue *val)
{
    uint32_t tag;
    vn_decode_uint32_t(dec, &tag);
    switch (tag) {
    case 0:
        vn_decode_VkClearColorValue_temp(dec, &val->color);
        break;
    case 1:
        vn_decode_VkClearDepthStencilValue_temp(dec, &val->depthStencil);
        break;
    default:
        vn_cs_decoder_set_fatal(dec);
        break;
    }
}

/* struct VkClearAttachment */

static inline void
vn_decode_VkClearAttachment_temp(struct vn_cs_decoder *dec, VkClearAttachment *val)
{
    vn_decode_VkFlags(dec, &val->aspectMask);
    vn_decode_uint32_t(dec, &val->colorAttachment);
    vn_decode_VkClearValue_temp(dec, &val->clearValue);
}

static inline void
vn_replace_VkClearAttachment_handle(VkClearAttachment *val)
{
    /* skip val->aspectMask */
    /* skip val->colorAttachment */
    /* skip val->clearValue */
}

/* struct VkClearRect */

static inline void
vn_decode_VkClearRect_temp(struct vn_cs_decoder *dec, VkClearRect *val)
{
    vn_decode_VkRect2D_temp(dec, &val->rect);
    vn_decode_uint32_t(dec, &val->baseArrayLayer);
    vn_decode_uint32_t(dec, &val->layerCount);
}

static inline void
vn_replace_VkClearRect_handle(VkClearRect *val)
{
    vn_replace_VkRect2D_handle(&val->rect);
    /* skip val->baseArrayLayer */
    /* skip val->layerCount */
}

/* struct VkImageResolve */

static inline void
vn_decode_VkImageResolve_temp(struct vn_cs_decoder *dec, VkImageResolve *val)
{
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->srcOffset);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->dstOffset);
    vn_decode_VkExtent3D_temp(dec, &val->extent);
}

static inline void
vn_replace_VkImageResolve_handle(VkImageResolve *val)
{
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    vn_replace_VkOffset3D_handle(&val->srcOffset);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    vn_replace_VkOffset3D_handle(&val->dstOffset);
    vn_replace_VkExtent3D_handle(&val->extent);
}

/* struct VkMemoryBarrier chain */

static inline void *
vn_decode_VkMemoryBarrier_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkMemoryBarrier_self_temp(struct vn_cs_decoder *dec, VkMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->srcAccessMask);
    vn_decode_VkFlags(dec, &val->dstAccessMask);
}

static inline void
vn_decode_VkMemoryBarrier_temp(struct vn_cs_decoder *dec, VkMemoryBarrier *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_MEMORY_BARRIER);

    val->sType = stype;
    val->pNext = vn_decode_VkMemoryBarrier_pnext_temp(dec);
    vn_decode_VkMemoryBarrier_self_temp(dec, val);
}

static inline void
vn_replace_VkMemoryBarrier_handle_self(VkMemoryBarrier *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcAccessMask */
    /* skip val->dstAccessMask */
}

static inline void
vn_replace_VkMemoryBarrier_handle(VkMemoryBarrier *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER:
            vn_replace_VkMemoryBarrier_handle_self((VkMemoryBarrier *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBufferMemoryBarrier chain */

static inline void *
vn_decode_VkBufferMemoryBarrier_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkBufferMemoryBarrier_self_temp(struct vn_cs_decoder *dec, VkBufferMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->srcAccessMask);
    vn_decode_VkFlags(dec, &val->dstAccessMask);
    vn_decode_uint32_t(dec, &val->srcQueueFamilyIndex);
    vn_decode_uint32_t(dec, &val->dstQueueFamilyIndex);
    vn_decode_VkBuffer_lookup(dec, &val->buffer);
    vn_decode_VkDeviceSize(dec, &val->offset);
    vn_decode_VkDeviceSize(dec, &val->size);
}

static inline void
vn_decode_VkBufferMemoryBarrier_temp(struct vn_cs_decoder *dec, VkBufferMemoryBarrier *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER);

    val->sType = stype;
    val->pNext = vn_decode_VkBufferMemoryBarrier_pnext_temp(dec);
    vn_decode_VkBufferMemoryBarrier_self_temp(dec, val);
}

static inline void
vn_replace_VkBufferMemoryBarrier_handle_self(VkBufferMemoryBarrier *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcAccessMask */
    /* skip val->dstAccessMask */
    /* skip val->srcQueueFamilyIndex */
    /* skip val->dstQueueFamilyIndex */
    vn_replace_VkBuffer_handle(&val->buffer);
    /* skip val->offset */
    /* skip val->size */
}

static inline void
vn_replace_VkBufferMemoryBarrier_handle(VkBufferMemoryBarrier *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER:
            vn_replace_VkBufferMemoryBarrier_handle_self((VkBufferMemoryBarrier *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageMemoryBarrier chain */

static inline void *
vn_decode_VkImageMemoryBarrier_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageMemoryBarrier_self_temp(struct vn_cs_decoder *dec, VkImageMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->srcAccessMask);
    vn_decode_VkFlags(dec, &val->dstAccessMask);
    vn_decode_VkImageLayout(dec, &val->oldLayout);
    vn_decode_VkImageLayout(dec, &val->newLayout);
    vn_decode_uint32_t(dec, &val->srcQueueFamilyIndex);
    vn_decode_uint32_t(dec, &val->dstQueueFamilyIndex);
    vn_decode_VkImage_lookup(dec, &val->image);
    vn_decode_VkImageSubresourceRange_temp(dec, &val->subresourceRange);
}

static inline void
vn_decode_VkImageMemoryBarrier_temp(struct vn_cs_decoder *dec, VkImageMemoryBarrier *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER);

    val->sType = stype;
    val->pNext = vn_decode_VkImageMemoryBarrier_pnext_temp(dec);
    vn_decode_VkImageMemoryBarrier_self_temp(dec, val);
}

static inline void
vn_replace_VkImageMemoryBarrier_handle_self(VkImageMemoryBarrier *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcAccessMask */
    /* skip val->dstAccessMask */
    /* skip val->oldLayout */
    /* skip val->newLayout */
    /* skip val->srcQueueFamilyIndex */
    /* skip val->dstQueueFamilyIndex */
    vn_replace_VkImage_handle(&val->image);
    vn_replace_VkImageSubresourceRange_handle(&val->subresourceRange);
}

static inline void
vn_replace_VkImageMemoryBarrier_handle(VkImageMemoryBarrier *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER:
            vn_replace_VkImageMemoryBarrier_handle_self((VkImageMemoryBarrier *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceGroupRenderPassBeginInfo chain */

static inline void *
vn_decode_VkDeviceGroupRenderPassBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupRenderPassBeginInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupRenderPassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->deviceMask);
    vn_decode_uint32_t(dec, &val->deviceRenderAreaCount);
    if (vn_peek_array_size(dec)) {
        val->pDeviceRenderAreas = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDeviceRenderAreas) * val->deviceRenderAreaCount);
        if (!val->pDeviceRenderAreas) return;
        vn_decode_array_size(dec, val->deviceRenderAreaCount);
        for (uint32_t i = 0; i < val->deviceRenderAreaCount; i++)
            vn_decode_VkRect2D_temp(dec, &((VkRect2D *)val->pDeviceRenderAreas)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pDeviceRenderAreas = NULL;
    }
}

static inline void
vn_decode_VkDeviceGroupRenderPassBeginInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupRenderPassBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupRenderPassBeginInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupRenderPassBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupRenderPassBeginInfo_handle_self(VkDeviceGroupRenderPassBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->deviceMask */
    /* skip val->deviceRenderAreaCount */
    if (val->pDeviceRenderAreas) {
       for (uint32_t i = 0; i < val->deviceRenderAreaCount; i++)
            vn_replace_VkRect2D_handle(&((VkRect2D *)val->pDeviceRenderAreas)[i]);
    }
}

static inline void
vn_replace_VkDeviceGroupRenderPassBeginInfo_handle(VkDeviceGroupRenderPassBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            vn_replace_VkDeviceGroupRenderPassBeginInfo_handle_self((VkDeviceGroupRenderPassBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkRenderPassAttachmentBeginInfo chain */

static inline void *
vn_decode_VkRenderPassAttachmentBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkRenderPassAttachmentBeginInfo_self_temp(struct vn_cs_decoder *dec, VkRenderPassAttachmentBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->attachmentCount);
    if (vn_peek_array_size(dec)) {
        val->pAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pAttachments) * val->attachmentCount);
        if (!val->pAttachments) return;
        vn_decode_array_size(dec, val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_decode_VkImageView_lookup(dec, &((VkImageView *)val->pAttachments)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pAttachments = NULL;
    }
}

static inline void
vn_decode_VkRenderPassAttachmentBeginInfo_temp(struct vn_cs_decoder *dec, VkRenderPassAttachmentBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderPassAttachmentBeginInfo_pnext_temp(dec);
    vn_decode_VkRenderPassAttachmentBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderPassAttachmentBeginInfo_handle_self(VkRenderPassAttachmentBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->attachmentCount */
    if (val->pAttachments) {
       for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_replace_VkImageView_handle(&((VkImageView *)val->pAttachments)[i]);
    }
}

static inline void
vn_replace_VkRenderPassAttachmentBeginInfo_handle(VkRenderPassAttachmentBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            vn_replace_VkRenderPassAttachmentBeginInfo_handle_self((VkRenderPassAttachmentBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkRenderPassBeginInfo chain */

static inline void *
vn_decode_VkRenderPassBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupRenderPassBeginInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkRenderPassBeginInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupRenderPassBeginInfo_self_temp(dec, (VkDeviceGroupRenderPassBeginInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkRenderPassAttachmentBeginInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkRenderPassBeginInfo_pnext_temp(dec);
            vn_decode_VkRenderPassAttachmentBeginInfo_self_temp(dec, (VkRenderPassAttachmentBeginInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkRenderPassBeginInfo_self_temp(struct vn_cs_decoder *dec, VkRenderPassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkRenderPass_lookup(dec, &val->renderPass);
    vn_decode_VkFramebuffer_lookup(dec, &val->framebuffer);
    vn_decode_VkRect2D_temp(dec, &val->renderArea);
    vn_decode_uint32_t(dec, &val->clearValueCount);
    if (vn_peek_array_size(dec)) {
        val->pClearValues = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pClearValues) * val->clearValueCount);
        if (!val->pClearValues) return;
        vn_decode_array_size(dec, val->clearValueCount);
        for (uint32_t i = 0; i < val->clearValueCount; i++)
            vn_decode_VkClearValue_temp(dec, &((VkClearValue *)val->pClearValues)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pClearValues = NULL;
    }
}

static inline void
vn_decode_VkRenderPassBeginInfo_temp(struct vn_cs_decoder *dec, VkRenderPassBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderPassBeginInfo_pnext_temp(dec);
    vn_decode_VkRenderPassBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderPassBeginInfo_handle_self(VkRenderPassBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkRenderPass_handle(&val->renderPass);
    vn_replace_VkFramebuffer_handle(&val->framebuffer);
    vn_replace_VkRect2D_handle(&val->renderArea);
    /* skip val->clearValueCount */
    /* skip val->pClearValues */
}

static inline void
vn_replace_VkRenderPassBeginInfo_handle(VkRenderPassBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO:
            vn_replace_VkRenderPassBeginInfo_handle_self((VkRenderPassBeginInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            vn_replace_VkDeviceGroupRenderPassBeginInfo_handle_self((VkDeviceGroupRenderPassBeginInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            vn_replace_VkRenderPassAttachmentBeginInfo_handle_self((VkRenderPassAttachmentBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubpassBeginInfo chain */

static inline void *
vn_decode_VkSubpassBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSubpassBeginInfo_self_temp(struct vn_cs_decoder *dec, VkSubpassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSubpassContents(dec, &val->contents);
}

static inline void
vn_decode_VkSubpassBeginInfo_temp(struct vn_cs_decoder *dec, VkSubpassBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkSubpassBeginInfo_pnext_temp(dec);
    vn_decode_VkSubpassBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkSubpassBeginInfo_handle_self(VkSubpassBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->contents */
}

static inline void
vn_replace_VkSubpassBeginInfo_handle(VkSubpassBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO:
            vn_replace_VkSubpassBeginInfo_handle_self((VkSubpassBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubpassEndInfo chain */

static inline void *
vn_decode_VkSubpassEndInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSubpassEndInfo_self_temp(struct vn_cs_decoder *dec, VkSubpassEndInfo *val)
{
    /* skip val->{sType,pNext} */
}

static inline void
vn_decode_VkSubpassEndInfo_temp(struct vn_cs_decoder *dec, VkSubpassEndInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SUBPASS_END_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkSubpassEndInfo_pnext_temp(dec);
    vn_decode_VkSubpassEndInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkSubpassEndInfo_handle_self(VkSubpassEndInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
}

static inline void
vn_replace_VkSubpassEndInfo_handle(VkSubpassEndInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_END_INFO:
            vn_replace_VkSubpassEndInfo_handle_self((VkSubpassEndInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkAllocateCommandBuffers_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkAllocateCommandBuffers *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pAllocateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pAllocateInfo));
        if (!args->pAllocateInfo) return;
        vn_decode_VkCommandBufferAllocateInfo_temp(dec, (VkCommandBufferAllocateInfo *)args->pAllocateInfo);
    } else {
        args->pAllocateInfo = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pCommandBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCommandBuffers) * args->pAllocateInfo->commandBufferCount);
        if (!args->pCommandBuffers) return;
        vn_decode_array_size(dec, args->pAllocateInfo->commandBufferCount);
        for (uint32_t i = 0; i < args->pAllocateInfo->commandBufferCount; i++)
            vn_decode_VkCommandBuffer_temp(dec, &args->pCommandBuffers[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCommandBuffers = NULL;
    }
}

static inline void vn_replace_vkAllocateCommandBuffers_args_handle(struct vn_command_vkAllocateCommandBuffers *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pAllocateInfo)
        vn_replace_VkCommandBufferAllocateInfo_handle((VkCommandBufferAllocateInfo *)args->pAllocateInfo);
    /* skip args->pCommandBuffers */
}

static inline void vn_encode_vkAllocateCommandBuffers_reply(struct vn_cs_encoder *enc, const struct vn_command_vkAllocateCommandBuffers *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pAllocateInfo */
    if (args->pCommandBuffers) {
        vn_encode_array_size(enc, args->pAllocateInfo->commandBufferCount);
        for (uint32_t i = 0; i < args->pAllocateInfo->commandBufferCount; i++)
            vn_encode_VkCommandBuffer(enc, &args->pCommandBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkFreeCommandBuffers_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkFreeCommandBuffers *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkCommandPool_lookup(dec, &args->commandPool);
    vn_decode_uint32_t(dec, &args->commandBufferCount);
    if (vn_peek_array_size(dec)) {
        args->pCommandBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCommandBuffers) * args->commandBufferCount);
        if (!args->pCommandBuffers) return;
        vn_decode_array_size(dec, args->commandBufferCount);
        for (uint32_t i = 0; i < args->commandBufferCount; i++)
            vn_decode_VkCommandBuffer_lookup(dec, &((VkCommandBuffer *)args->pCommandBuffers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCommandBuffers = NULL;
    }
}

static inline void vn_replace_vkFreeCommandBuffers_args_handle(struct vn_command_vkFreeCommandBuffers *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkCommandPool_handle(&args->commandPool);
    /* skip args->commandBufferCount */
    if (args->pCommandBuffers) {
       for (uint32_t i = 0; i < args->commandBufferCount; i++)
            vn_replace_VkCommandBuffer_handle(&((VkCommandBuffer *)args->pCommandBuffers)[i]);
    }
}

static inline void vn_encode_vkFreeCommandBuffers_reply(struct vn_cs_encoder *enc, const struct vn_command_vkFreeCommandBuffers *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT});

    /* skip args->device */
    /* skip args->commandPool */
    /* skip args->commandBufferCount */
    /* skip args->pCommandBuffers */
}

static inline void vn_decode_vkBeginCommandBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkBeginCommandBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pBeginInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBeginInfo));
        if (!args->pBeginInfo) return;
        vn_decode_VkCommandBufferBeginInfo_temp(dec, (VkCommandBufferBeginInfo *)args->pBeginInfo);
    } else {
        args->pBeginInfo = NULL;
    }
}

static inline void vn_replace_vkBeginCommandBuffer_args_handle(struct vn_command_vkBeginCommandBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pBeginInfo)
        vn_replace_VkCommandBufferBeginInfo_handle((VkCommandBufferBeginInfo *)args->pBeginInfo);
}

static inline void vn_encode_vkBeginCommandBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkBeginCommandBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->commandBuffer */
    /* skip args->pBeginInfo */
}

static inline void vn_decode_vkEndCommandBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEndCommandBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
}

static inline void vn_replace_vkEndCommandBuffer_args_handle(struct vn_command_vkEndCommandBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
}

static inline void vn_encode_vkEndCommandBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEndCommandBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEndCommandBuffer_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->commandBuffer */
}

static inline void vn_decode_vkResetCommandBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkResetCommandBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->flags);
}

static inline void vn_replace_vkResetCommandBuffer_args_handle(struct vn_command_vkResetCommandBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->flags */
}

static inline void vn_encode_vkResetCommandBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkResetCommandBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkResetCommandBuffer_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->commandBuffer */
    /* skip args->flags */
}

static inline void vn_decode_vkCmdBindPipeline_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindPipeline *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPipelineBindPoint(dec, &args->pipelineBindPoint);
    vn_decode_VkPipeline_lookup(dec, &args->pipeline);
}

static inline void vn_replace_vkCmdBindPipeline_args_handle(struct vn_command_vkCmdBindPipeline *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->pipelineBindPoint */
    vn_replace_VkPipeline_handle(&args->pipeline);
}

static inline void vn_encode_vkCmdBindPipeline_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindPipeline *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindPipeline_EXT});

    /* skip args->commandBuffer */
    /* skip args->pipelineBindPoint */
    /* skip args->pipeline */
}

static inline void vn_decode_vkCmdSetViewport_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetViewport *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstViewport);
    vn_decode_uint32_t(dec, &args->viewportCount);
    if (vn_peek_array_size(dec)) {
        args->pViewports = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pViewports) * args->viewportCount);
        if (!args->pViewports) return;
        vn_decode_array_size(dec, args->viewportCount);
        for (uint32_t i = 0; i < args->viewportCount; i++)
            vn_decode_VkViewport_temp(dec, &((VkViewport *)args->pViewports)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pViewports = NULL;
    }
}

static inline void vn_replace_vkCmdSetViewport_args_handle(struct vn_command_vkCmdSetViewport *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstViewport */
    /* skip args->viewportCount */
    if (args->pViewports) {
       for (uint32_t i = 0; i < args->viewportCount; i++)
            vn_replace_VkViewport_handle(&((VkViewport *)args->pViewports)[i]);
    }
}

static inline void vn_encode_vkCmdSetViewport_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetViewport *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetViewport_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstViewport */
    /* skip args->viewportCount */
    /* skip args->pViewports */
}

static inline void vn_decode_vkCmdSetScissor_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetScissor *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstScissor);
    vn_decode_uint32_t(dec, &args->scissorCount);
    if (vn_peek_array_size(dec)) {
        args->pScissors = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pScissors) * args->scissorCount);
        if (!args->pScissors) return;
        vn_decode_array_size(dec, args->scissorCount);
        for (uint32_t i = 0; i < args->scissorCount; i++)
            vn_decode_VkRect2D_temp(dec, &((VkRect2D *)args->pScissors)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pScissors = NULL;
    }
}

static inline void vn_replace_vkCmdSetScissor_args_handle(struct vn_command_vkCmdSetScissor *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstScissor */
    /* skip args->scissorCount */
    if (args->pScissors) {
       for (uint32_t i = 0; i < args->scissorCount; i++)
            vn_replace_VkRect2D_handle(&((VkRect2D *)args->pScissors)[i]);
    }
}

static inline void vn_encode_vkCmdSetScissor_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetScissor *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetScissor_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstScissor */
    /* skip args->scissorCount */
    /* skip args->pScissors */
}

static inline void vn_decode_vkCmdSetLineWidth_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetLineWidth *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_float(dec, &args->lineWidth);
}

static inline void vn_replace_vkCmdSetLineWidth_args_handle(struct vn_command_vkCmdSetLineWidth *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->lineWidth */
}

static inline void vn_encode_vkCmdSetLineWidth_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetLineWidth *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT});

    /* skip args->commandBuffer */
    /* skip args->lineWidth */
}

static inline void vn_decode_vkCmdSetDepthBias_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthBias *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_float(dec, &args->depthBiasConstantFactor);
    vn_decode_float(dec, &args->depthBiasClamp);
    vn_decode_float(dec, &args->depthBiasSlopeFactor);
}

static inline void vn_replace_vkCmdSetDepthBias_args_handle(struct vn_command_vkCmdSetDepthBias *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->depthBiasConstantFactor */
    /* skip args->depthBiasClamp */
    /* skip args->depthBiasSlopeFactor */
}

static inline void vn_encode_vkCmdSetDepthBias_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthBias *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT});

    /* skip args->commandBuffer */
    /* skip args->depthBiasConstantFactor */
    /* skip args->depthBiasClamp */
    /* skip args->depthBiasSlopeFactor */
}

static inline void vn_decode_vkCmdSetBlendConstants_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetBlendConstants *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    {
        const size_t array_size = vn_decode_array_size(dec, 4);
        vn_decode_float_array(dec, (float *)args->blendConstants, array_size);
    }
}

static inline void vn_replace_vkCmdSetBlendConstants_args_handle(struct vn_command_vkCmdSetBlendConstants *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->blendConstants */
}

static inline void vn_encode_vkCmdSetBlendConstants_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetBlendConstants *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT});

    /* skip args->commandBuffer */
    /* skip args->blendConstants */
}

static inline void vn_decode_vkCmdSetDepthBounds_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthBounds *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_float(dec, &args->minDepthBounds);
    vn_decode_float(dec, &args->maxDepthBounds);
}

static inline void vn_replace_vkCmdSetDepthBounds_args_handle(struct vn_command_vkCmdSetDepthBounds *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->minDepthBounds */
    /* skip args->maxDepthBounds */
}

static inline void vn_encode_vkCmdSetDepthBounds_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthBounds *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT});

    /* skip args->commandBuffer */
    /* skip args->minDepthBounds */
    /* skip args->maxDepthBounds */
}

static inline void vn_decode_vkCmdSetStencilCompareMask_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetStencilCompareMask *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->faceMask);
    vn_decode_uint32_t(dec, &args->compareMask);
}

static inline void vn_replace_vkCmdSetStencilCompareMask_args_handle(struct vn_command_vkCmdSetStencilCompareMask *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->faceMask */
    /* skip args->compareMask */
}

static inline void vn_encode_vkCmdSetStencilCompareMask_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetStencilCompareMask *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT});

    /* skip args->commandBuffer */
    /* skip args->faceMask */
    /* skip args->compareMask */
}

static inline void vn_decode_vkCmdSetStencilWriteMask_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetStencilWriteMask *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->faceMask);
    vn_decode_uint32_t(dec, &args->writeMask);
}

static inline void vn_replace_vkCmdSetStencilWriteMask_args_handle(struct vn_command_vkCmdSetStencilWriteMask *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->faceMask */
    /* skip args->writeMask */
}

static inline void vn_encode_vkCmdSetStencilWriteMask_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetStencilWriteMask *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT});

    /* skip args->commandBuffer */
    /* skip args->faceMask */
    /* skip args->writeMask */
}

static inline void vn_decode_vkCmdSetStencilReference_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetStencilReference *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->faceMask);
    vn_decode_uint32_t(dec, &args->reference);
}

static inline void vn_replace_vkCmdSetStencilReference_args_handle(struct vn_command_vkCmdSetStencilReference *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->faceMask */
    /* skip args->reference */
}

static inline void vn_encode_vkCmdSetStencilReference_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetStencilReference *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT});

    /* skip args->commandBuffer */
    /* skip args->faceMask */
    /* skip args->reference */
}

static inline void vn_decode_vkCmdBindDescriptorSets_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindDescriptorSets *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPipelineBindPoint(dec, &args->pipelineBindPoint);
    vn_decode_VkPipelineLayout_lookup(dec, &args->layout);
    vn_decode_uint32_t(dec, &args->firstSet);
    vn_decode_uint32_t(dec, &args->descriptorSetCount);
    if (vn_peek_array_size(dec)) {
        args->pDescriptorSets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDescriptorSets) * args->descriptorSetCount);
        if (!args->pDescriptorSets) return;
        vn_decode_array_size(dec, args->descriptorSetCount);
        for (uint32_t i = 0; i < args->descriptorSetCount; i++)
            vn_decode_VkDescriptorSet_lookup(dec, &((VkDescriptorSet *)args->pDescriptorSets)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pDescriptorSets = NULL;
    }
    vn_decode_uint32_t(dec, &args->dynamicOffsetCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->dynamicOffsetCount);
        args->pDynamicOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDynamicOffsets) * array_size);
        if (!args->pDynamicOffsets) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)args->pDynamicOffsets, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pDynamicOffsets = NULL;
    }
}

static inline void vn_replace_vkCmdBindDescriptorSets_args_handle(struct vn_command_vkCmdBindDescriptorSets *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->pipelineBindPoint */
    vn_replace_VkPipelineLayout_handle(&args->layout);
    /* skip args->firstSet */
    /* skip args->descriptorSetCount */
    if (args->pDescriptorSets) {
       for (uint32_t i = 0; i < args->descriptorSetCount; i++)
            vn_replace_VkDescriptorSet_handle(&((VkDescriptorSet *)args->pDescriptorSets)[i]);
    }
    /* skip args->dynamicOffsetCount */
    /* skip args->pDynamicOffsets */
}

static inline void vn_encode_vkCmdBindDescriptorSets_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindDescriptorSets *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT});

    /* skip args->commandBuffer */
    /* skip args->pipelineBindPoint */
    /* skip args->layout */
    /* skip args->firstSet */
    /* skip args->descriptorSetCount */
    /* skip args->pDescriptorSets */
    /* skip args->dynamicOffsetCount */
    /* skip args->pDynamicOffsets */
}

static inline void vn_decode_vkCmdBindIndexBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindIndexBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_VkIndexType(dec, &args->indexType);
}

static inline void vn_replace_vkCmdBindIndexBuffer_args_handle(struct vn_command_vkCmdBindIndexBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    /* skip args->indexType */
}

static inline void vn_encode_vkCmdBindIndexBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindIndexBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->indexType */
}

static inline void vn_decode_vkCmdBindVertexBuffers_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindVertexBuffers *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstBinding);
    vn_decode_uint32_t(dec, &args->bindingCount);
    if (vn_peek_array_size(dec)) {
        args->pBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBuffers) * args->bindingCount);
        if (!args->pBuffers) return;
        vn_decode_array_size(dec, args->bindingCount);
        for (uint32_t i = 0; i < args->bindingCount; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pBuffers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pOffsets) * array_size);
        if (!args->pOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pOffsets, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pOffsets = NULL;
    }
}

static inline void vn_replace_vkCmdBindVertexBuffers_args_handle(struct vn_command_vkCmdBindVertexBuffers *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    if (args->pBuffers) {
       for (uint32_t i = 0; i < args->bindingCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pBuffers)[i]);
    }
    /* skip args->pOffsets */
}

static inline void vn_encode_vkCmdBindVertexBuffers_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindVertexBuffers *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    /* skip args->pBuffers */
    /* skip args->pOffsets */
}

static inline void vn_decode_vkCmdDraw_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDraw *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->vertexCount);
    vn_decode_uint32_t(dec, &args->instanceCount);
    vn_decode_uint32_t(dec, &args->firstVertex);
    vn_decode_uint32_t(dec, &args->firstInstance);
}

static inline void vn_replace_vkCmdDraw_args_handle(struct vn_command_vkCmdDraw *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->vertexCount */
    /* skip args->instanceCount */
    /* skip args->firstVertex */
    /* skip args->firstInstance */
}

static inline void vn_encode_vkCmdDraw_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDraw *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDraw_EXT});

    /* skip args->commandBuffer */
    /* skip args->vertexCount */
    /* skip args->instanceCount */
    /* skip args->firstVertex */
    /* skip args->firstInstance */
}

static inline void vn_decode_vkCmdDrawIndexed_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndexed *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->indexCount);
    vn_decode_uint32_t(dec, &args->instanceCount);
    vn_decode_uint32_t(dec, &args->firstIndex);
    vn_decode_int32_t(dec, &args->vertexOffset);
    vn_decode_uint32_t(dec, &args->firstInstance);
}

static inline void vn_replace_vkCmdDrawIndexed_args_handle(struct vn_command_vkCmdDrawIndexed *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->indexCount */
    /* skip args->instanceCount */
    /* skip args->firstIndex */
    /* skip args->vertexOffset */
    /* skip args->firstInstance */
}

static inline void vn_encode_vkCmdDrawIndexed_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndexed *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT});

    /* skip args->commandBuffer */
    /* skip args->indexCount */
    /* skip args->instanceCount */
    /* skip args->firstIndex */
    /* skip args->vertexOffset */
    /* skip args->firstInstance */
}

static inline void vn_decode_vkCmdDrawIndirect_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndirect *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_uint32_t(dec, &args->drawCount);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawIndirect_args_handle(struct vn_command_vkCmdDrawIndirect *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    /* skip args->drawCount */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawIndirect_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndirect *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->drawCount */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdDrawIndexedIndirect_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndexedIndirect *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_uint32_t(dec, &args->drawCount);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawIndexedIndirect_args_handle(struct vn_command_vkCmdDrawIndexedIndirect *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    /* skip args->drawCount */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawIndexedIndirect_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndexedIndirect *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->drawCount */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdDispatch_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDispatch *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->groupCountX);
    vn_decode_uint32_t(dec, &args->groupCountY);
    vn_decode_uint32_t(dec, &args->groupCountZ);
}

static inline void vn_replace_vkCmdDispatch_args_handle(struct vn_command_vkCmdDispatch *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->groupCountX */
    /* skip args->groupCountY */
    /* skip args->groupCountZ */
}

static inline void vn_encode_vkCmdDispatch_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDispatch *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDispatch_EXT});

    /* skip args->commandBuffer */
    /* skip args->groupCountX */
    /* skip args->groupCountY */
    /* skip args->groupCountZ */
}

static inline void vn_decode_vkCmdDispatchIndirect_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDispatchIndirect *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
}

static inline void vn_replace_vkCmdDispatchIndirect_args_handle(struct vn_command_vkCmdDispatchIndirect *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
}

static inline void vn_encode_vkCmdDispatchIndirect_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDispatchIndirect *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
}

static inline void vn_decode_vkCmdCopyBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->srcBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * args->regionCount);
        if (!args->pRegions) return;
        vn_decode_array_size(dec, args->regionCount);
        for (uint32_t i = 0; i < args->regionCount; i++)
            vn_decode_VkBufferCopy_temp(dec, &((VkBufferCopy *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdCopyBuffer_args_handle(struct vn_command_vkCmdCopyBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->srcBuffer);
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkBufferCopy_handle(&((VkBufferCopy *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdCopyBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcBuffer */
    /* skip args->dstBuffer */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdCopyImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->srcImage);
    vn_decode_VkImageLayout(dec, &args->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &args->dstImage);
    vn_decode_VkImageLayout(dec, &args->dstImageLayout);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * args->regionCount);
        if (!args->pRegions) return;
        vn_decode_array_size(dec, args->regionCount);
        for (uint32_t i = 0; i < args->regionCount; i++)
            vn_decode_VkImageCopy_temp(dec, &((VkImageCopy *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdCopyImage_args_handle(struct vn_command_vkCmdCopyImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->srcImage);
    /* skip args->srcImageLayout */
    vn_replace_VkImage_handle(&args->dstImage);
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkImageCopy_handle(&((VkImageCopy *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdCopyImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcImage */
    /* skip args->srcImageLayout */
    /* skip args->dstImage */
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdBlitImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBlitImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->srcImage);
    vn_decode_VkImageLayout(dec, &args->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &args->dstImage);
    vn_decode_VkImageLayout(dec, &args->dstImageLayout);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * args->regionCount);
        if (!args->pRegions) return;
        vn_decode_array_size(dec, args->regionCount);
        for (uint32_t i = 0; i < args->regionCount; i++)
            vn_decode_VkImageBlit_temp(dec, &((VkImageBlit *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRegions = NULL;
    }
    vn_decode_VkFilter(dec, &args->filter);
}

static inline void vn_replace_vkCmdBlitImage_args_handle(struct vn_command_vkCmdBlitImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->srcImage);
    /* skip args->srcImageLayout */
    vn_replace_VkImage_handle(&args->dstImage);
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkImageBlit_handle(&((VkImageBlit *)args->pRegions)[i]);
    }
    /* skip args->filter */
}

static inline void vn_encode_vkCmdBlitImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBlitImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBlitImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcImage */
    /* skip args->srcImageLayout */
    /* skip args->dstImage */
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    /* skip args->pRegions */
    /* skip args->filter */
}

static inline void vn_decode_vkCmdCopyBufferToImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyBufferToImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->srcBuffer);
    vn_decode_VkImage_lookup(dec, &args->dstImage);
    vn_decode_VkImageLayout(dec, &args->dstImageLayout);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * args->regionCount);
        if (!args->pRegions) return;
        vn_decode_array_size(dec, args->regionCount);
        for (uint32_t i = 0; i < args->regionCount; i++)
            vn_decode_VkBufferImageCopy_temp(dec, &((VkBufferImageCopy *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdCopyBufferToImage_args_handle(struct vn_command_vkCmdCopyBufferToImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->srcBuffer);
    vn_replace_VkImage_handle(&args->dstImage);
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkBufferImageCopy_handle(&((VkBufferImageCopy *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdCopyBufferToImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyBufferToImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcBuffer */
    /* skip args->dstImage */
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdCopyImageToBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyImageToBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->srcImage);
    vn_decode_VkImageLayout(dec, &args->srcImageLayout);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * args->regionCount);
        if (!args->pRegions) return;
        vn_decode_array_size(dec, args->regionCount);
        for (uint32_t i = 0; i < args->regionCount; i++)
            vn_decode_VkBufferImageCopy_temp(dec, &((VkBufferImageCopy *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdCopyImageToBuffer_args_handle(struct vn_command_vkCmdCopyImageToBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->srcImage);
    /* skip args->srcImageLayout */
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkBufferImageCopy_handle(&((VkBufferImageCopy *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdCopyImageToBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyImageToBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcImage */
    /* skip args->srcImageLayout */
    /* skip args->dstBuffer */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdUpdateBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdUpdateBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_VkDeviceSize(dec, &args->dstOffset);
    vn_decode_VkDeviceSize(dec, &args->dataSize);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->dataSize);
        args->pData = vn_cs_decoder_alloc_temp(dec, array_size);
        if (!args->pData) return;
        vn_decode_blob_array(dec, (void *)args->pData, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pData = NULL;
    }
}

static inline void vn_replace_vkCmdUpdateBuffer_args_handle(struct vn_command_vkCmdUpdateBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->dstOffset */
    /* skip args->dataSize */
    /* skip args->pData */
}

static inline void vn_encode_vkCmdUpdateBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdUpdateBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->dstBuffer */
    /* skip args->dstOffset */
    /* skip args->dataSize */
    /* skip args->pData */
}

static inline void vn_decode_vkCmdFillBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdFillBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_VkDeviceSize(dec, &args->dstOffset);
    vn_decode_VkDeviceSize(dec, &args->size);
    vn_decode_uint32_t(dec, &args->data);
}

static inline void vn_replace_vkCmdFillBuffer_args_handle(struct vn_command_vkCmdFillBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->dstOffset */
    /* skip args->size */
    /* skip args->data */
}

static inline void vn_encode_vkCmdFillBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdFillBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdFillBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->dstBuffer */
    /* skip args->dstOffset */
    /* skip args->size */
    /* skip args->data */
}

static inline void vn_decode_vkCmdClearColorImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdClearColorImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->image);
    vn_decode_VkImageLayout(dec, &args->imageLayout);
    if (vn_decode_simple_pointer(dec)) {
        args->pColor = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pColor));
        if (!args->pColor) return;
        vn_decode_VkClearColorValue_temp(dec, (VkClearColorValue *)args->pColor);
    } else {
        args->pColor = NULL;
    }
    vn_decode_uint32_t(dec, &args->rangeCount);
    if (vn_peek_array_size(dec)) {
        args->pRanges = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRanges) * args->rangeCount);
        if (!args->pRanges) return;
        vn_decode_array_size(dec, args->rangeCount);
        for (uint32_t i = 0; i < args->rangeCount; i++)
            vn_decode_VkImageSubresourceRange_temp(dec, &((VkImageSubresourceRange *)args->pRanges)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRanges = NULL;
    }
}

static inline void vn_replace_vkCmdClearColorImage_args_handle(struct vn_command_vkCmdClearColorImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->image);
    /* skip args->imageLayout */
    /* skip args->pColor */
    /* skip args->rangeCount */
    if (args->pRanges) {
       for (uint32_t i = 0; i < args->rangeCount; i++)
            vn_replace_VkImageSubresourceRange_handle(&((VkImageSubresourceRange *)args->pRanges)[i]);
    }
}

static inline void vn_encode_vkCmdClearColorImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdClearColorImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdClearColorImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->image */
    /* skip args->imageLayout */
    /* skip args->pColor */
    /* skip args->rangeCount */
    /* skip args->pRanges */
}

static inline void vn_decode_vkCmdClearDepthStencilImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdClearDepthStencilImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->image);
    vn_decode_VkImageLayout(dec, &args->imageLayout);
    if (vn_decode_simple_pointer(dec)) {
        args->pDepthStencil = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDepthStencil));
        if (!args->pDepthStencil) return;
        vn_decode_VkClearDepthStencilValue_temp(dec, (VkClearDepthStencilValue *)args->pDepthStencil);
    } else {
        args->pDepthStencil = NULL;
    }
    vn_decode_uint32_t(dec, &args->rangeCount);
    if (vn_peek_array_size(dec)) {
        args->pRanges = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRanges) * args->rangeCount);
        if (!args->pRanges) return;
        vn_decode_array_size(dec, args->rangeCount);
        for (uint32_t i = 0; i < args->rangeCount; i++)
            vn_decode_VkImageSubresourceRange_temp(dec, &((VkImageSubresourceRange *)args->pRanges)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRanges = NULL;
    }
}

static inline void vn_replace_vkCmdClearDepthStencilImage_args_handle(struct vn_command_vkCmdClearDepthStencilImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->image);
    /* skip args->imageLayout */
    if (args->pDepthStencil)
        vn_replace_VkClearDepthStencilValue_handle((VkClearDepthStencilValue *)args->pDepthStencil);
    /* skip args->rangeCount */
    if (args->pRanges) {
       for (uint32_t i = 0; i < args->rangeCount; i++)
            vn_replace_VkImageSubresourceRange_handle(&((VkImageSubresourceRange *)args->pRanges)[i]);
    }
}

static inline void vn_encode_vkCmdClearDepthStencilImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdClearDepthStencilImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->image */
    /* skip args->imageLayout */
    /* skip args->pDepthStencil */
    /* skip args->rangeCount */
    /* skip args->pRanges */
}

static inline void vn_decode_vkCmdClearAttachments_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdClearAttachments *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->attachmentCount);
    if (vn_peek_array_size(dec)) {
        args->pAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pAttachments) * args->attachmentCount);
        if (!args->pAttachments) return;
        vn_decode_array_size(dec, args->attachmentCount);
        for (uint32_t i = 0; i < args->attachmentCount; i++)
            vn_decode_VkClearAttachment_temp(dec, &((VkClearAttachment *)args->pAttachments)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pAttachments = NULL;
    }
    vn_decode_uint32_t(dec, &args->rectCount);
    if (vn_peek_array_size(dec)) {
        args->pRects = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRects) * args->rectCount);
        if (!args->pRects) return;
        vn_decode_array_size(dec, args->rectCount);
        for (uint32_t i = 0; i < args->rectCount; i++)
            vn_decode_VkClearRect_temp(dec, &((VkClearRect *)args->pRects)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRects = NULL;
    }
}

static inline void vn_replace_vkCmdClearAttachments_args_handle(struct vn_command_vkCmdClearAttachments *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->attachmentCount */
    if (args->pAttachments) {
       for (uint32_t i = 0; i < args->attachmentCount; i++)
            vn_replace_VkClearAttachment_handle(&((VkClearAttachment *)args->pAttachments)[i]);
    }
    /* skip args->rectCount */
    if (args->pRects) {
       for (uint32_t i = 0; i < args->rectCount; i++)
            vn_replace_VkClearRect_handle(&((VkClearRect *)args->pRects)[i]);
    }
}

static inline void vn_encode_vkCmdClearAttachments_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdClearAttachments *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdClearAttachments_EXT});

    /* skip args->commandBuffer */
    /* skip args->attachmentCount */
    /* skip args->pAttachments */
    /* skip args->rectCount */
    /* skip args->pRects */
}

static inline void vn_decode_vkCmdResolveImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdResolveImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->srcImage);
    vn_decode_VkImageLayout(dec, &args->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &args->dstImage);
    vn_decode_VkImageLayout(dec, &args->dstImageLayout);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * args->regionCount);
        if (!args->pRegions) return;
        vn_decode_array_size(dec, args->regionCount);
        for (uint32_t i = 0; i < args->regionCount; i++)
            vn_decode_VkImageResolve_temp(dec, &((VkImageResolve *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdResolveImage_args_handle(struct vn_command_vkCmdResolveImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->srcImage);
    /* skip args->srcImageLayout */
    vn_replace_VkImage_handle(&args->dstImage);
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkImageResolve_handle(&((VkImageResolve *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdResolveImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdResolveImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdResolveImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcImage */
    /* skip args->srcImageLayout */
    /* skip args->dstImage */
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdSetEvent_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetEvent *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkEvent_lookup(dec, &args->event);
    vn_decode_VkFlags(dec, &args->stageMask);
}

static inline void vn_replace_vkCmdSetEvent_args_handle(struct vn_command_vkCmdSetEvent *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkEvent_handle(&args->event);
    /* skip args->stageMask */
}

static inline void vn_encode_vkCmdSetEvent_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetEvent *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetEvent_EXT});

    /* skip args->commandBuffer */
    /* skip args->event */
    /* skip args->stageMask */
}

static inline void vn_decode_vkCmdResetEvent_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdResetEvent *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkEvent_lookup(dec, &args->event);
    vn_decode_VkFlags(dec, &args->stageMask);
}

static inline void vn_replace_vkCmdResetEvent_args_handle(struct vn_command_vkCmdResetEvent *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkEvent_handle(&args->event);
    /* skip args->stageMask */
}

static inline void vn_encode_vkCmdResetEvent_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdResetEvent *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdResetEvent_EXT});

    /* skip args->commandBuffer */
    /* skip args->event */
    /* skip args->stageMask */
}

static inline void vn_decode_vkCmdWaitEvents_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdWaitEvents *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->eventCount);
    if (vn_peek_array_size(dec)) {
        args->pEvents = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pEvents) * args->eventCount);
        if (!args->pEvents) return;
        vn_decode_array_size(dec, args->eventCount);
        for (uint32_t i = 0; i < args->eventCount; i++)
            vn_decode_VkEvent_lookup(dec, &((VkEvent *)args->pEvents)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pEvents = NULL;
    }
    vn_decode_VkFlags(dec, &args->srcStageMask);
    vn_decode_VkFlags(dec, &args->dstStageMask);
    vn_decode_uint32_t(dec, &args->memoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        args->pMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryBarriers) * args->memoryBarrierCount);
        if (!args->pMemoryBarriers) return;
        vn_decode_array_size(dec, args->memoryBarrierCount);
        for (uint32_t i = 0; i < args->memoryBarrierCount; i++)
            vn_decode_VkMemoryBarrier_temp(dec, &((VkMemoryBarrier *)args->pMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &args->bufferMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        args->pBufferMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBufferMemoryBarriers) * args->bufferMemoryBarrierCount);
        if (!args->pBufferMemoryBarriers) return;
        vn_decode_array_size(dec, args->bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < args->bufferMemoryBarrierCount; i++)
            vn_decode_VkBufferMemoryBarrier_temp(dec, &((VkBufferMemoryBarrier *)args->pBufferMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pBufferMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &args->imageMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        args->pImageMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageMemoryBarriers) * args->imageMemoryBarrierCount);
        if (!args->pImageMemoryBarriers) return;
        vn_decode_array_size(dec, args->imageMemoryBarrierCount);
        for (uint32_t i = 0; i < args->imageMemoryBarrierCount; i++)
            vn_decode_VkImageMemoryBarrier_temp(dec, &((VkImageMemoryBarrier *)args->pImageMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pImageMemoryBarriers = NULL;
    }
}

static inline void vn_replace_vkCmdWaitEvents_args_handle(struct vn_command_vkCmdWaitEvents *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->eventCount */
    if (args->pEvents) {
       for (uint32_t i = 0; i < args->eventCount; i++)
            vn_replace_VkEvent_handle(&((VkEvent *)args->pEvents)[i]);
    }
    /* skip args->srcStageMask */
    /* skip args->dstStageMask */
    /* skip args->memoryBarrierCount */
    if (args->pMemoryBarriers) {
       for (uint32_t i = 0; i < args->memoryBarrierCount; i++)
            vn_replace_VkMemoryBarrier_handle(&((VkMemoryBarrier *)args->pMemoryBarriers)[i]);
    }
    /* skip args->bufferMemoryBarrierCount */
    if (args->pBufferMemoryBarriers) {
       for (uint32_t i = 0; i < args->bufferMemoryBarrierCount; i++)
            vn_replace_VkBufferMemoryBarrier_handle(&((VkBufferMemoryBarrier *)args->pBufferMemoryBarriers)[i]);
    }
    /* skip args->imageMemoryBarrierCount */
    if (args->pImageMemoryBarriers) {
       for (uint32_t i = 0; i < args->imageMemoryBarrierCount; i++)
            vn_replace_VkImageMemoryBarrier_handle(&((VkImageMemoryBarrier *)args->pImageMemoryBarriers)[i]);
    }
}

static inline void vn_encode_vkCmdWaitEvents_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdWaitEvents *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdWaitEvents_EXT});

    /* skip args->commandBuffer */
    /* skip args->eventCount */
    /* skip args->pEvents */
    /* skip args->srcStageMask */
    /* skip args->dstStageMask */
    /* skip args->memoryBarrierCount */
    /* skip args->pMemoryBarriers */
    /* skip args->bufferMemoryBarrierCount */
    /* skip args->pBufferMemoryBarriers */
    /* skip args->imageMemoryBarrierCount */
    /* skip args->pImageMemoryBarriers */
}

static inline void vn_decode_vkCmdPipelineBarrier_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdPipelineBarrier *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->srcStageMask);
    vn_decode_VkFlags(dec, &args->dstStageMask);
    vn_decode_VkFlags(dec, &args->dependencyFlags);
    vn_decode_uint32_t(dec, &args->memoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        args->pMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryBarriers) * args->memoryBarrierCount);
        if (!args->pMemoryBarriers) return;
        vn_decode_array_size(dec, args->memoryBarrierCount);
        for (uint32_t i = 0; i < args->memoryBarrierCount; i++)
            vn_decode_VkMemoryBarrier_temp(dec, &((VkMemoryBarrier *)args->pMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &args->bufferMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        args->pBufferMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBufferMemoryBarriers) * args->bufferMemoryBarrierCount);
        if (!args->pBufferMemoryBarriers) return;
        vn_decode_array_size(dec, args->bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < args->bufferMemoryBarrierCount; i++)
            vn_decode_VkBufferMemoryBarrier_temp(dec, &((VkBufferMemoryBarrier *)args->pBufferMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pBufferMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &args->imageMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        args->pImageMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageMemoryBarriers) * args->imageMemoryBarrierCount);
        if (!args->pImageMemoryBarriers) return;
        vn_decode_array_size(dec, args->imageMemoryBarrierCount);
        for (uint32_t i = 0; i < args->imageMemoryBarrierCount; i++)
            vn_decode_VkImageMemoryBarrier_temp(dec, &((VkImageMemoryBarrier *)args->pImageMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pImageMemoryBarriers = NULL;
    }
}

static inline void vn_replace_vkCmdPipelineBarrier_args_handle(struct vn_command_vkCmdPipelineBarrier *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->srcStageMask */
    /* skip args->dstStageMask */
    /* skip args->dependencyFlags */
    /* skip args->memoryBarrierCount */
    if (args->pMemoryBarriers) {
       for (uint32_t i = 0; i < args->memoryBarrierCount; i++)
            vn_replace_VkMemoryBarrier_handle(&((VkMemoryBarrier *)args->pMemoryBarriers)[i]);
    }
    /* skip args->bufferMemoryBarrierCount */
    if (args->pBufferMemoryBarriers) {
       for (uint32_t i = 0; i < args->bufferMemoryBarrierCount; i++)
            vn_replace_VkBufferMemoryBarrier_handle(&((VkBufferMemoryBarrier *)args->pBufferMemoryBarriers)[i]);
    }
    /* skip args->imageMemoryBarrierCount */
    if (args->pImageMemoryBarriers) {
       for (uint32_t i = 0; i < args->imageMemoryBarrierCount; i++)
            vn_replace_VkImageMemoryBarrier_handle(&((VkImageMemoryBarrier *)args->pImageMemoryBarriers)[i]);
    }
}

static inline void vn_encode_vkCmdPipelineBarrier_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdPipelineBarrier *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcStageMask */
    /* skip args->dstStageMask */
    /* skip args->dependencyFlags */
    /* skip args->memoryBarrierCount */
    /* skip args->pMemoryBarriers */
    /* skip args->bufferMemoryBarrierCount */
    /* skip args->pBufferMemoryBarriers */
    /* skip args->imageMemoryBarrierCount */
    /* skip args->pImageMemoryBarriers */
}

static inline void vn_decode_vkCmdBeginQuery_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginQuery *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
    vn_decode_VkFlags(dec, &args->flags);
}

static inline void vn_replace_vkCmdBeginQuery_args_handle(struct vn_command_vkCmdBeginQuery *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
    /* skip args->flags */
}

static inline void vn_encode_vkCmdBeginQuery_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginQuery *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginQuery_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->query */
    /* skip args->flags */
}

static inline void vn_decode_vkCmdEndQuery_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndQuery *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
}

static inline void vn_replace_vkCmdEndQuery_args_handle(struct vn_command_vkCmdEndQuery *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
}

static inline void vn_encode_vkCmdEndQuery_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndQuery *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndQuery_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->query */
}

static inline void vn_decode_vkCmdResetQueryPool_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdResetQueryPool *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->firstQuery);
    vn_decode_uint32_t(dec, &args->queryCount);
}

static inline void vn_replace_vkCmdResetQueryPool_args_handle(struct vn_command_vkCmdResetQueryPool *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->firstQuery */
    /* skip args->queryCount */
}

static inline void vn_encode_vkCmdResetQueryPool_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdResetQueryPool *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->firstQuery */
    /* skip args->queryCount */
}

static inline void vn_decode_vkCmdWriteTimestamp_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdWriteTimestamp *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPipelineStageFlagBits(dec, &args->pipelineStage);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
}

static inline void vn_replace_vkCmdWriteTimestamp_args_handle(struct vn_command_vkCmdWriteTimestamp *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->pipelineStage */
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
}

static inline void vn_encode_vkCmdWriteTimestamp_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdWriteTimestamp *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT});

    /* skip args->commandBuffer */
    /* skip args->pipelineStage */
    /* skip args->queryPool */
    /* skip args->query */
}

static inline void vn_decode_vkCmdCopyQueryPoolResults_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyQueryPoolResults *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->firstQuery);
    vn_decode_uint32_t(dec, &args->queryCount);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_VkDeviceSize(dec, &args->dstOffset);
    vn_decode_VkDeviceSize(dec, &args->stride);
    vn_decode_VkFlags(dec, &args->flags);
}

static inline void vn_replace_vkCmdCopyQueryPoolResults_args_handle(struct vn_command_vkCmdCopyQueryPoolResults *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->firstQuery */
    /* skip args->queryCount */
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->dstOffset */
    /* skip args->stride */
    /* skip args->flags */
}

static inline void vn_encode_vkCmdCopyQueryPoolResults_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyQueryPoolResults *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->firstQuery */
    /* skip args->queryCount */
    /* skip args->dstBuffer */
    /* skip args->dstOffset */
    /* skip args->stride */
    /* skip args->flags */
}

static inline void vn_decode_vkCmdPushConstants_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdPushConstants *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPipelineLayout_lookup(dec, &args->layout);
    vn_decode_VkFlags(dec, &args->stageFlags);
    vn_decode_uint32_t(dec, &args->offset);
    vn_decode_uint32_t(dec, &args->size);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->size);
        args->pValues = vn_cs_decoder_alloc_temp(dec, array_size);
        if (!args->pValues) return;
        vn_decode_blob_array(dec, (void *)args->pValues, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pValues = NULL;
    }
}

static inline void vn_replace_vkCmdPushConstants_args_handle(struct vn_command_vkCmdPushConstants *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkPipelineLayout_handle(&args->layout);
    /* skip args->stageFlags */
    /* skip args->offset */
    /* skip args->size */
    /* skip args->pValues */
}

static inline void vn_encode_vkCmdPushConstants_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdPushConstants *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdPushConstants_EXT});

    /* skip args->commandBuffer */
    /* skip args->layout */
    /* skip args->stageFlags */
    /* skip args->offset */
    /* skip args->size */
    /* skip args->pValues */
}

static inline void vn_decode_vkCmdBeginRenderPass_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginRenderPass *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pRenderPassBegin = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRenderPassBegin));
        if (!args->pRenderPassBegin) return;
        vn_decode_VkRenderPassBeginInfo_temp(dec, (VkRenderPassBeginInfo *)args->pRenderPassBegin);
    } else {
        args->pRenderPassBegin = NULL;
    }
    vn_decode_VkSubpassContents(dec, &args->contents);
}

static inline void vn_replace_vkCmdBeginRenderPass_args_handle(struct vn_command_vkCmdBeginRenderPass *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pRenderPassBegin)
        vn_replace_VkRenderPassBeginInfo_handle((VkRenderPassBeginInfo *)args->pRenderPassBegin);
    /* skip args->contents */
}

static inline void vn_encode_vkCmdBeginRenderPass_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginRenderPass *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT});

    /* skip args->commandBuffer */
    /* skip args->pRenderPassBegin */
    /* skip args->contents */
}

static inline void vn_decode_vkCmdNextSubpass_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdNextSubpass *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkSubpassContents(dec, &args->contents);
}

static inline void vn_replace_vkCmdNextSubpass_args_handle(struct vn_command_vkCmdNextSubpass *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->contents */
}

static inline void vn_encode_vkCmdNextSubpass_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdNextSubpass *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdNextSubpass_EXT});

    /* skip args->commandBuffer */
    /* skip args->contents */
}

static inline void vn_decode_vkCmdEndRenderPass_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndRenderPass *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
}

static inline void vn_replace_vkCmdEndRenderPass_args_handle(struct vn_command_vkCmdEndRenderPass *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
}

static inline void vn_encode_vkCmdEndRenderPass_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndRenderPass *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT});

    /* skip args->commandBuffer */
}

static inline void vn_decode_vkCmdExecuteCommands_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdExecuteCommands *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->commandBufferCount);
    if (vn_peek_array_size(dec)) {
        args->pCommandBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCommandBuffers) * args->commandBufferCount);
        if (!args->pCommandBuffers) return;
        vn_decode_array_size(dec, args->commandBufferCount);
        for (uint32_t i = 0; i < args->commandBufferCount; i++)
            vn_decode_VkCommandBuffer_lookup(dec, &((VkCommandBuffer *)args->pCommandBuffers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCommandBuffers = NULL;
    }
}

static inline void vn_replace_vkCmdExecuteCommands_args_handle(struct vn_command_vkCmdExecuteCommands *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->commandBufferCount */
    if (args->pCommandBuffers) {
       for (uint32_t i = 0; i < args->commandBufferCount; i++)
            vn_replace_VkCommandBuffer_handle(&((VkCommandBuffer *)args->pCommandBuffers)[i]);
    }
}

static inline void vn_encode_vkCmdExecuteCommands_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdExecuteCommands *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT});

    /* skip args->commandBuffer */
    /* skip args->commandBufferCount */
    /* skip args->pCommandBuffers */
}

static inline void vn_decode_vkCmdSetDeviceMask_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDeviceMask *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->deviceMask);
}

static inline void vn_replace_vkCmdSetDeviceMask_args_handle(struct vn_command_vkCmdSetDeviceMask *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->deviceMask */
}

static inline void vn_encode_vkCmdSetDeviceMask_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDeviceMask *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT});

    /* skip args->commandBuffer */
    /* skip args->deviceMask */
}

static inline void vn_decode_vkCmdDispatchBase_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDispatchBase *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->baseGroupX);
    vn_decode_uint32_t(dec, &args->baseGroupY);
    vn_decode_uint32_t(dec, &args->baseGroupZ);
    vn_decode_uint32_t(dec, &args->groupCountX);
    vn_decode_uint32_t(dec, &args->groupCountY);
    vn_decode_uint32_t(dec, &args->groupCountZ);
}

static inline void vn_replace_vkCmdDispatchBase_args_handle(struct vn_command_vkCmdDispatchBase *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->baseGroupX */
    /* skip args->baseGroupY */
    /* skip args->baseGroupZ */
    /* skip args->groupCountX */
    /* skip args->groupCountY */
    /* skip args->groupCountZ */
}

static inline void vn_encode_vkCmdDispatchBase_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDispatchBase *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDispatchBase_EXT});

    /* skip args->commandBuffer */
    /* skip args->baseGroupX */
    /* skip args->baseGroupY */
    /* skip args->baseGroupZ */
    /* skip args->groupCountX */
    /* skip args->groupCountY */
    /* skip args->groupCountZ */
}

static inline void vn_decode_vkCmdBeginRenderPass2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginRenderPass2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pRenderPassBegin = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRenderPassBegin));
        if (!args->pRenderPassBegin) return;
        vn_decode_VkRenderPassBeginInfo_temp(dec, (VkRenderPassBeginInfo *)args->pRenderPassBegin);
    } else {
        args->pRenderPassBegin = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pSubpassBeginInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubpassBeginInfo));
        if (!args->pSubpassBeginInfo) return;
        vn_decode_VkSubpassBeginInfo_temp(dec, (VkSubpassBeginInfo *)args->pSubpassBeginInfo);
    } else {
        args->pSubpassBeginInfo = NULL;
    }
}

static inline void vn_replace_vkCmdBeginRenderPass2_args_handle(struct vn_command_vkCmdBeginRenderPass2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pRenderPassBegin)
        vn_replace_VkRenderPassBeginInfo_handle((VkRenderPassBeginInfo *)args->pRenderPassBegin);
    if (args->pSubpassBeginInfo)
        vn_replace_VkSubpassBeginInfo_handle((VkSubpassBeginInfo *)args->pSubpassBeginInfo);
}

static inline void vn_encode_vkCmdBeginRenderPass2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginRenderPass2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pRenderPassBegin */
    /* skip args->pSubpassBeginInfo */
}

static inline void vn_decode_vkCmdNextSubpass2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdNextSubpass2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pSubpassBeginInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubpassBeginInfo));
        if (!args->pSubpassBeginInfo) return;
        vn_decode_VkSubpassBeginInfo_temp(dec, (VkSubpassBeginInfo *)args->pSubpassBeginInfo);
    } else {
        args->pSubpassBeginInfo = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pSubpassEndInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubpassEndInfo));
        if (!args->pSubpassEndInfo) return;
        vn_decode_VkSubpassEndInfo_temp(dec, (VkSubpassEndInfo *)args->pSubpassEndInfo);
    } else {
        args->pSubpassEndInfo = NULL;
    }
}

static inline void vn_replace_vkCmdNextSubpass2_args_handle(struct vn_command_vkCmdNextSubpass2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pSubpassBeginInfo)
        vn_replace_VkSubpassBeginInfo_handle((VkSubpassBeginInfo *)args->pSubpassBeginInfo);
    if (args->pSubpassEndInfo)
        vn_replace_VkSubpassEndInfo_handle((VkSubpassEndInfo *)args->pSubpassEndInfo);
}

static inline void vn_encode_vkCmdNextSubpass2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdNextSubpass2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pSubpassBeginInfo */
    /* skip args->pSubpassEndInfo */
}

static inline void vn_decode_vkCmdEndRenderPass2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndRenderPass2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pSubpassEndInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubpassEndInfo));
        if (!args->pSubpassEndInfo) return;
        vn_decode_VkSubpassEndInfo_temp(dec, (VkSubpassEndInfo *)args->pSubpassEndInfo);
    } else {
        args->pSubpassEndInfo = NULL;
    }
}

static inline void vn_replace_vkCmdEndRenderPass2_args_handle(struct vn_command_vkCmdEndRenderPass2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pSubpassEndInfo)
        vn_replace_VkSubpassEndInfo_handle((VkSubpassEndInfo *)args->pSubpassEndInfo);
}

static inline void vn_encode_vkCmdEndRenderPass2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndRenderPass2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pSubpassEndInfo */
}

static inline void vn_decode_vkCmdDrawIndirectCount_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndirectCount *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_VkBuffer_lookup(dec, &args->countBuffer);
    vn_decode_VkDeviceSize(dec, &args->countBufferOffset);
    vn_decode_uint32_t(dec, &args->maxDrawCount);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawIndirectCount_args_handle(struct vn_command_vkCmdDrawIndirectCount *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    vn_replace_VkBuffer_handle(&args->countBuffer);
    /* skip args->countBufferOffset */
    /* skip args->maxDrawCount */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawIndirectCount_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndirectCount *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->countBuffer */
    /* skip args->countBufferOffset */
    /* skip args->maxDrawCount */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdDrawIndexedIndirectCount_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndexedIndirectCount *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_VkBuffer_lookup(dec, &args->countBuffer);
    vn_decode_VkDeviceSize(dec, &args->countBufferOffset);
    vn_decode_uint32_t(dec, &args->maxDrawCount);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawIndexedIndirectCount_args_handle(struct vn_command_vkCmdDrawIndexedIndirectCount *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    vn_replace_VkBuffer_handle(&args->countBuffer);
    /* skip args->countBufferOffset */
    /* skip args->maxDrawCount */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawIndexedIndirectCount_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndexedIndirectCount *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->countBuffer */
    /* skip args->countBufferOffset */
    /* skip args->maxDrawCount */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdBindTransformFeedbackBuffersEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindTransformFeedbackBuffersEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstBinding);
    vn_decode_uint32_t(dec, &args->bindingCount);
    if (vn_peek_array_size(dec)) {
        args->pBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBuffers) * args->bindingCount);
        if (!args->pBuffers) return;
        vn_decode_array_size(dec, args->bindingCount);
        for (uint32_t i = 0; i < args->bindingCount; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pBuffers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pOffsets) * array_size);
        if (!args->pOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pOffsets, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pOffsets = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pSizes = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSizes) * array_size);
        if (!args->pSizes) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pSizes, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pSizes = NULL;
    }
}

static inline void vn_replace_vkCmdBindTransformFeedbackBuffersEXT_args_handle(struct vn_command_vkCmdBindTransformFeedbackBuffersEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    if (args->pBuffers) {
       for (uint32_t i = 0; i < args->bindingCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pBuffers)[i]);
    }
    /* skip args->pOffsets */
    /* skip args->pSizes */
}

static inline void vn_encode_vkCmdBindTransformFeedbackBuffersEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindTransformFeedbackBuffersEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    /* skip args->pBuffers */
    /* skip args->pOffsets */
    /* skip args->pSizes */
}

static inline void vn_decode_vkCmdBeginTransformFeedbackEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginTransformFeedbackEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstCounterBuffer);
    vn_decode_uint32_t(dec, &args->counterBufferCount);
    if (vn_peek_array_size(dec)) {
        args->pCounterBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCounterBuffers) * args->counterBufferCount);
        if (!args->pCounterBuffers) return;
        vn_decode_array_size(dec, args->counterBufferCount);
        for (uint32_t i = 0; i < args->counterBufferCount; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pCounterBuffers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCounterBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->counterBufferCount);
        args->pCounterBufferOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCounterBufferOffsets) * array_size);
        if (!args->pCounterBufferOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pCounterBufferOffsets, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCounterBufferOffsets = NULL;
    }
}

static inline void vn_replace_vkCmdBeginTransformFeedbackEXT_args_handle(struct vn_command_vkCmdBeginTransformFeedbackEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstCounterBuffer */
    /* skip args->counterBufferCount */
    if (args->pCounterBuffers) {
       for (uint32_t i = 0; i < args->counterBufferCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pCounterBuffers)[i]);
    }
    /* skip args->pCounterBufferOffsets */
}

static inline void vn_encode_vkCmdBeginTransformFeedbackEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginTransformFeedbackEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstCounterBuffer */
    /* skip args->counterBufferCount */
    /* skip args->pCounterBuffers */
    /* skip args->pCounterBufferOffsets */
}

static inline void vn_decode_vkCmdEndTransformFeedbackEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndTransformFeedbackEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstCounterBuffer);
    vn_decode_uint32_t(dec, &args->counterBufferCount);
    if (vn_peek_array_size(dec)) {
        args->pCounterBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCounterBuffers) * args->counterBufferCount);
        if (!args->pCounterBuffers) return;
        vn_decode_array_size(dec, args->counterBufferCount);
        for (uint32_t i = 0; i < args->counterBufferCount; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pCounterBuffers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCounterBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->counterBufferCount);
        args->pCounterBufferOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCounterBufferOffsets) * array_size);
        if (!args->pCounterBufferOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pCounterBufferOffsets, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCounterBufferOffsets = NULL;
    }
}

static inline void vn_replace_vkCmdEndTransformFeedbackEXT_args_handle(struct vn_command_vkCmdEndTransformFeedbackEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstCounterBuffer */
    /* skip args->counterBufferCount */
    if (args->pCounterBuffers) {
       for (uint32_t i = 0; i < args->counterBufferCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pCounterBuffers)[i]);
    }
    /* skip args->pCounterBufferOffsets */
}

static inline void vn_encode_vkCmdEndTransformFeedbackEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndTransformFeedbackEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstCounterBuffer */
    /* skip args->counterBufferCount */
    /* skip args->pCounterBuffers */
    /* skip args->pCounterBufferOffsets */
}

static inline void vn_decode_vkCmdBeginQueryIndexedEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginQueryIndexedEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
    vn_decode_VkFlags(dec, &args->flags);
    vn_decode_uint32_t(dec, &args->index);
}

static inline void vn_replace_vkCmdBeginQueryIndexedEXT_args_handle(struct vn_command_vkCmdBeginQueryIndexedEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
    /* skip args->flags */
    /* skip args->index */
}

static inline void vn_encode_vkCmdBeginQueryIndexedEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginQueryIndexedEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->query */
    /* skip args->flags */
    /* skip args->index */
}

static inline void vn_decode_vkCmdEndQueryIndexedEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndQueryIndexedEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
    vn_decode_uint32_t(dec, &args->index);
}

static inline void vn_replace_vkCmdEndQueryIndexedEXT_args_handle(struct vn_command_vkCmdEndQueryIndexedEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
    /* skip args->index */
}

static inline void vn_encode_vkCmdEndQueryIndexedEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndQueryIndexedEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->query */
    /* skip args->index */
}

static inline void vn_decode_vkCmdDrawIndirectByteCountEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndirectByteCountEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->instanceCount);
    vn_decode_uint32_t(dec, &args->firstInstance);
    vn_decode_VkBuffer_lookup(dec, &args->counterBuffer);
    vn_decode_VkDeviceSize(dec, &args->counterBufferOffset);
    vn_decode_uint32_t(dec, &args->counterOffset);
    vn_decode_uint32_t(dec, &args->vertexStride);
}

static inline void vn_replace_vkCmdDrawIndirectByteCountEXT_args_handle(struct vn_command_vkCmdDrawIndirectByteCountEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->instanceCount */
    /* skip args->firstInstance */
    vn_replace_VkBuffer_handle(&args->counterBuffer);
    /* skip args->counterBufferOffset */
    /* skip args->counterOffset */
    /* skip args->vertexStride */
}

static inline void vn_encode_vkCmdDrawIndirectByteCountEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndirectByteCountEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->instanceCount */
    /* skip args->firstInstance */
    /* skip args->counterBuffer */
    /* skip args->counterBufferOffset */
    /* skip args->counterOffset */
    /* skip args->vertexStride */
}

static inline void vn_dispatch_vkAllocateCommandBuffers(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkAllocateCommandBuffers args;

    if (!ctx->dispatch_vkAllocateCommandBuffers) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkAllocateCommandBuffers_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkAllocateCommandBuffers(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkAllocateCommandBuffers returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkAllocateCommandBuffers_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkFreeCommandBuffers(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkFreeCommandBuffers args;

    if (!ctx->dispatch_vkFreeCommandBuffers) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkFreeCommandBuffers_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkFreeCommandBuffers(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkFreeCommandBuffers_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkBeginCommandBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkBeginCommandBuffer args;

    if (!ctx->dispatch_vkBeginCommandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkBeginCommandBuffer_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkBeginCommandBuffer(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkBeginCommandBuffer returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkBeginCommandBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkEndCommandBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEndCommandBuffer args;

    if (!ctx->dispatch_vkEndCommandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEndCommandBuffer_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEndCommandBuffer(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkEndCommandBuffer returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkEndCommandBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkResetCommandBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkResetCommandBuffer args;

    if (!ctx->dispatch_vkResetCommandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkResetCommandBuffer_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkResetCommandBuffer(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkResetCommandBuffer returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkResetCommandBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindPipeline(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindPipeline args;

    if (!ctx->dispatch_vkCmdBindPipeline) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindPipeline_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindPipeline(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindPipeline_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetViewport(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetViewport args;

    if (!ctx->dispatch_vkCmdSetViewport) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetViewport_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetViewport(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetViewport_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetScissor(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetScissor args;

    if (!ctx->dispatch_vkCmdSetScissor) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetScissor_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetScissor(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetScissor_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetLineWidth(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetLineWidth args;

    if (!ctx->dispatch_vkCmdSetLineWidth) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetLineWidth_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetLineWidth(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetLineWidth_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthBias(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthBias args;

    if (!ctx->dispatch_vkCmdSetDepthBias) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthBias_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthBias(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthBias_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetBlendConstants(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetBlendConstants args;

    if (!ctx->dispatch_vkCmdSetBlendConstants) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetBlendConstants_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetBlendConstants(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetBlendConstants_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthBounds(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthBounds args;

    if (!ctx->dispatch_vkCmdSetDepthBounds) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthBounds_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthBounds(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthBounds_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetStencilCompareMask(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetStencilCompareMask args;

    if (!ctx->dispatch_vkCmdSetStencilCompareMask) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetStencilCompareMask_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetStencilCompareMask(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetStencilCompareMask_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetStencilWriteMask(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetStencilWriteMask args;

    if (!ctx->dispatch_vkCmdSetStencilWriteMask) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetStencilWriteMask_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetStencilWriteMask(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetStencilWriteMask_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetStencilReference(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetStencilReference args;

    if (!ctx->dispatch_vkCmdSetStencilReference) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetStencilReference_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetStencilReference(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetStencilReference_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindDescriptorSets(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindDescriptorSets args;

    if (!ctx->dispatch_vkCmdBindDescriptorSets) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindDescriptorSets_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindDescriptorSets(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindDescriptorSets_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindIndexBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindIndexBuffer args;

    if (!ctx->dispatch_vkCmdBindIndexBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindIndexBuffer_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindIndexBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindIndexBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindVertexBuffers(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindVertexBuffers args;

    if (!ctx->dispatch_vkCmdBindVertexBuffers) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindVertexBuffers_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindVertexBuffers(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindVertexBuffers_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDraw(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDraw args;

    if (!ctx->dispatch_vkCmdDraw) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDraw_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDraw(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDraw_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndexed(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndexed args;

    if (!ctx->dispatch_vkCmdDrawIndexed) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndexed_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndexed(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndexed_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndirect(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndirect args;

    if (!ctx->dispatch_vkCmdDrawIndirect) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndirect_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndirect(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndirect_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndexedIndirect(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndexedIndirect args;

    if (!ctx->dispatch_vkCmdDrawIndexedIndirect) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndexedIndirect_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndexedIndirect(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndexedIndirect_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDispatch(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDispatch args;

    if (!ctx->dispatch_vkCmdDispatch) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDispatch_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDispatch(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDispatch_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDispatchIndirect(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDispatchIndirect args;

    if (!ctx->dispatch_vkCmdDispatchIndirect) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDispatchIndirect_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDispatchIndirect(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDispatchIndirect_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyBuffer args;

    if (!ctx->dispatch_vkCmdCopyBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyBuffer_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyImage args;

    if (!ctx->dispatch_vkCmdCopyImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyImage_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBlitImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBlitImage args;

    if (!ctx->dispatch_vkCmdBlitImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBlitImage_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBlitImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBlitImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyBufferToImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyBufferToImage args;

    if (!ctx->dispatch_vkCmdCopyBufferToImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyBufferToImage_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyBufferToImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyBufferToImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyImageToBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyImageToBuffer args;

    if (!ctx->dispatch_vkCmdCopyImageToBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyImageToBuffer_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyImageToBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyImageToBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdUpdateBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdUpdateBuffer args;

    if (!ctx->dispatch_vkCmdUpdateBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdUpdateBuffer_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdUpdateBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdUpdateBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdFillBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdFillBuffer args;

    if (!ctx->dispatch_vkCmdFillBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdFillBuffer_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdFillBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdFillBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdClearColorImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdClearColorImage args;

    if (!ctx->dispatch_vkCmdClearColorImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdClearColorImage_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdClearColorImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdClearColorImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdClearDepthStencilImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdClearDepthStencilImage args;

    if (!ctx->dispatch_vkCmdClearDepthStencilImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdClearDepthStencilImage_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdClearDepthStencilImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdClearDepthStencilImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdClearAttachments(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdClearAttachments args;

    if (!ctx->dispatch_vkCmdClearAttachments) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdClearAttachments_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdClearAttachments(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdClearAttachments_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdResolveImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdResolveImage args;

    if (!ctx->dispatch_vkCmdResolveImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdResolveImage_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdResolveImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdResolveImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetEvent(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetEvent args;

    if (!ctx->dispatch_vkCmdSetEvent) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetEvent_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetEvent(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetEvent_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdResetEvent(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdResetEvent args;

    if (!ctx->dispatch_vkCmdResetEvent) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdResetEvent_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdResetEvent(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdResetEvent_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdWaitEvents(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdWaitEvents args;

    if (!ctx->dispatch_vkCmdWaitEvents) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdWaitEvents_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdWaitEvents(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdWaitEvents_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdPipelineBarrier(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdPipelineBarrier args;

    if (!ctx->dispatch_vkCmdPipelineBarrier) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdPipelineBarrier_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdPipelineBarrier(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdPipelineBarrier_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginQuery(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginQuery args;

    if (!ctx->dispatch_vkCmdBeginQuery) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginQuery_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginQuery(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginQuery_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndQuery(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndQuery args;

    if (!ctx->dispatch_vkCmdEndQuery) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndQuery_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndQuery(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndQuery_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdResetQueryPool(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdResetQueryPool args;

    if (!ctx->dispatch_vkCmdResetQueryPool) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdResetQueryPool_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdResetQueryPool(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdResetQueryPool_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdWriteTimestamp(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdWriteTimestamp args;

    if (!ctx->dispatch_vkCmdWriteTimestamp) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdWriteTimestamp_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdWriteTimestamp(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdWriteTimestamp_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyQueryPoolResults(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyQueryPoolResults args;

    if (!ctx->dispatch_vkCmdCopyQueryPoolResults) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyQueryPoolResults_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyQueryPoolResults(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyQueryPoolResults_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdPushConstants(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdPushConstants args;

    if (!ctx->dispatch_vkCmdPushConstants) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdPushConstants_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdPushConstants(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdPushConstants_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginRenderPass(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginRenderPass args;

    if (!ctx->dispatch_vkCmdBeginRenderPass) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginRenderPass_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginRenderPass(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginRenderPass_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdNextSubpass(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdNextSubpass args;

    if (!ctx->dispatch_vkCmdNextSubpass) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdNextSubpass_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdNextSubpass(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdNextSubpass_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndRenderPass(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndRenderPass args;

    if (!ctx->dispatch_vkCmdEndRenderPass) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndRenderPass_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndRenderPass(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndRenderPass_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdExecuteCommands(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdExecuteCommands args;

    if (!ctx->dispatch_vkCmdExecuteCommands) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdExecuteCommands_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdExecuteCommands(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdExecuteCommands_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDeviceMask(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDeviceMask args;

    if (!ctx->dispatch_vkCmdSetDeviceMask) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDeviceMask_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDeviceMask(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDeviceMask_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDispatchBase(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDispatchBase args;

    if (!ctx->dispatch_vkCmdDispatchBase) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDispatchBase_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDispatchBase(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDispatchBase_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginRenderPass2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginRenderPass2 args;

    if (!ctx->dispatch_vkCmdBeginRenderPass2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginRenderPass2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginRenderPass2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginRenderPass2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdNextSubpass2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdNextSubpass2 args;

    if (!ctx->dispatch_vkCmdNextSubpass2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdNextSubpass2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdNextSubpass2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdNextSubpass2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndRenderPass2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndRenderPass2 args;

    if (!ctx->dispatch_vkCmdEndRenderPass2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndRenderPass2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndRenderPass2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndRenderPass2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndirectCount(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndirectCount args;

    if (!ctx->dispatch_vkCmdDrawIndirectCount) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndirectCount_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndirectCount(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndirectCount_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndexedIndirectCount(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndexedIndirectCount args;

    if (!ctx->dispatch_vkCmdDrawIndexedIndirectCount) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndexedIndirectCount_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndexedIndirectCount(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndexedIndirectCount_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindTransformFeedbackBuffersEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindTransformFeedbackBuffersEXT args;

    if (!ctx->dispatch_vkCmdBindTransformFeedbackBuffersEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindTransformFeedbackBuffersEXT_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindTransformFeedbackBuffersEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindTransformFeedbackBuffersEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginTransformFeedbackEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginTransformFeedbackEXT args;

    if (!ctx->dispatch_vkCmdBeginTransformFeedbackEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginTransformFeedbackEXT_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginTransformFeedbackEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginTransformFeedbackEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndTransformFeedbackEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndTransformFeedbackEXT args;

    if (!ctx->dispatch_vkCmdEndTransformFeedbackEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndTransformFeedbackEXT_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndTransformFeedbackEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndTransformFeedbackEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginQueryIndexedEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginQueryIndexedEXT args;

    if (!ctx->dispatch_vkCmdBeginQueryIndexedEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginQueryIndexedEXT_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginQueryIndexedEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginQueryIndexedEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndQueryIndexedEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndQueryIndexedEXT args;

    if (!ctx->dispatch_vkCmdEndQueryIndexedEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndQueryIndexedEXT_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndQueryIndexedEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndQueryIndexedEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndirectByteCountEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndirectByteCountEXT args;

    if (!ctx->dispatch_vkCmdDrawIndirectByteCountEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndirectByteCountEXT_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndirectByteCountEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndirectByteCountEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#endif /* VN_PROTOCOL_RENDERER_COMMAND_BUFFER_H */
