/* This file is auto-generated by optc-gen.awk.  */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "options.h"
#include "tm.h"
#include "opts.h"
#include "intl.h"
#include "insn-attr-common.h"

#include "cpplib.h"
#include "cpplib.h"
#include "diagnostic-color.h"
#include "diagnostic-url.h"
#include "diagnostic.h"
#include "pretty-print.h"

static const struct cl_enum_arg cl_enum_arm_abi_type_data[] = 
{
  { "aapcs", ARM_ABI_AAPCS, 0 },
  { "aapcs-linux", ARM_ABI_AAPCS_LINUX, 0 },
  { "apcs-gnu", ARM_ABI_APCS, 0 },
  { "atpcs", ARM_ABI_ATPCS, 0 },
  { "iwmmxt", ARM_ABI_IWMMXT, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_arm_abi_type_set (void *var, int value)
{
  *((enum arm_abi_type *) var) = (enum arm_abi_type) value;
}

static int
cl_enum_arm_abi_type_get (const void *var)
{
  return (int) *((const enum arm_abi_type *) var);
}

static const struct cl_enum_arg cl_enum_arm_arch_data[] = 
{
  { "armv4", 0, 0 },
  { "armv4t", 1, 0 },
  { "armv5t", 2, 0 },
  { "armv5te", 3, 0 },
  { "armv5tej", 4, 0 },
  { "armv6", 5, 0 },
  { "armv6-m", 12, 0 },
  { "armv6j", 6, 0 },
  { "armv6k", 7, 0 },
  { "armv6kz", 9, 0 },
  { "armv6s-m", 13, 0 },
  { "armv6t2", 11, 0 },
  { "armv6z", 8, 0 },
  { "armv6zk", 10, 0 },
  { "armv7", 14, 0 },
  { "armv7-a", 15, 0 },
  { "armv7-m", 18, 0 },
  { "armv7-r", 17, 0 },
  { "armv7e-m", 19, 0 },
  { "armv7ve", 16, 0 },
  { "armv8-a", 20, 0 },
  { "armv8-m.base", 27, 0 },
  { "armv8-m.main", 28, 0 },
  { "armv8-r", 29, 0 },
  { "armv8.1-a", 21, 0 },
  { "armv8.1-m.main", 30, 0 },
  { "armv8.2-a", 22, 0 },
  { "armv8.3-a", 23, 0 },
  { "armv8.4-a", 24, 0 },
  { "armv8.5-a", 25, 0 },
  { "armv8.6-a", 26, 0 },
  { "armv9-a", 31, 0 },
  { "iwmmxt", 32, 0 },
  { "iwmmxt2", 33, 0 },
  { "native", -1, 0| CL_ENUM_DRIVER_ONLY },
  { NULL, 0, 0 }
};

static void
cl_enum_arm_arch_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_arm_arch_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_arm_fp16_format_type_data[] = 
{
  { "alternative", ARM_FP16_FORMAT_ALTERNATIVE, 0 },
  { "ieee", ARM_FP16_FORMAT_IEEE, 0 },
  { "none", ARM_FP16_FORMAT_NONE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_arm_fp16_format_type_set (void *var, int value)
{
  *((enum arm_fp16_format_type *) var) = (enum arm_fp16_format_type) value;
}

static int
cl_enum_arm_fp16_format_type_get (const void *var)
{
  return (int) *((const enum arm_fp16_format_type *) var);
}

static const struct cl_enum_arg cl_enum_arm_fpu_data[] = 
{
  { "auto", TARGET_FPU_auto, 0 },
  { "crypto-neon-fp-armv8", TARGET_FPU_crypto_neon_fp_armv8, 0 },
  { "fp-armv8", TARGET_FPU_fp_armv8, 0 },
  { "fpv4-sp-d16", TARGET_FPU_fpv4_sp_d16, 0 },
  { "fpv5-d16", TARGET_FPU_fpv5_d16, 0 },
  { "fpv5-sp-d16", TARGET_FPU_fpv5_sp_d16, 0 },
  { "neon", TARGET_FPU_neon, 0 },
  { "neon-fp-armv8", TARGET_FPU_neon_fp_armv8, 0 },
  { "neon-fp16", TARGET_FPU_neon_fp16, 0 },
  { "neon-vfpv3", TARGET_FPU_neon_vfpv3, 0 },
  { "neon-vfpv4", TARGET_FPU_neon_vfpv4, 0 },
  { "vfp", TARGET_FPU_vfp, 0 },
  { "vfp3", TARGET_FPU_vfp3, 0 },
  { "vfpv2", TARGET_FPU_vfpv2, 0 },
  { "vfpv3", TARGET_FPU_vfpv3, 0 },
  { "vfpv3-d16", TARGET_FPU_vfpv3_d16, 0 },
  { "vfpv3-d16-fp16", TARGET_FPU_vfpv3_d16_fp16, 0 },
  { "vfpv3-fp16", TARGET_FPU_vfpv3_fp16, 0 },
  { "vfpv3xd", TARGET_FPU_vfpv3xd, 0 },
  { "vfpv3xd-fp16", TARGET_FPU_vfpv3xd_fp16, 0 },
  { "vfpv4", TARGET_FPU_vfpv4, 0 },
  { "vfpv4-d16", TARGET_FPU_vfpv4_d16, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_arm_fpu_set (void *var, int value)
{
  *((enum fpu_type *) var) = (enum fpu_type) value;
}

static int
cl_enum_arm_fpu_get (const void *var)
{
  return (int) *((const enum fpu_type *) var);
}

static const struct cl_enum_arg cl_enum_arm_tp_type_data[] = 
{
  { "auto", TP_AUTO, 0 },
  { "cp15", TP_CP15, 0 },
  { "soft", TP_SOFT, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_arm_tp_type_set (void *var, int value)
{
  *((enum arm_tp_type *) var) = (enum arm_tp_type) value;
}

static int
cl_enum_arm_tp_type_get (const void *var)
{
  return (int) *((const enum arm_tp_type *) var);
}

static const struct cl_enum_arg cl_enum_bounds_check_data[] = 
{
  { "off", 0, 0 },
  { "on", 2, 0 },
  { "safeonly", 1, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_bounds_check_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_bounds_check_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_cf_protection_level_data[] = 
{
  { "branch", CF_BRANCH, 0 },
  { "check", CF_CHECK, 0 },
  { "full", CF_FULL, 0 },
  { "none", CF_NONE, 0 },
  { "return", CF_RETURN, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_cf_protection_level_set (void *var, int value)
{
  *((enum cf_protection_level *) var) = (enum cf_protection_level) value;
}

static int
cl_enum_cf_protection_level_get (const void *var)
{
  return (int) *((const enum cf_protection_level *) var);
}

static const struct cl_enum_arg cl_enum_compressed_debug_sections_data[] = 
{
  { "none", 0, 0 },
  { "zlib", 1, 0 },
  { "zlib-gnu", 2, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_compressed_debug_sections_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_compressed_debug_sections_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_cpp_bidirectional_level_data[] = 
{
  { "any", bidirectional_any, 0 },
  { "none", bidirectional_none, 0 },
  { "unpaired", bidirectional_unpaired, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_cpp_bidirectional_level_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_cpp_bidirectional_level_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_cpp_normalize_level_data[] = 
{
  { "id", normalized_identifier_C, 0 },
  { "nfc", normalized_C, 0 },
  { "nfkc", normalized_KC, 0 },
  { "none", normalized_none, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_cpp_normalize_level_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_cpp_normalize_level_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_diagnostic_color_rule_data[] = 
{
  { "always", DIAGNOSTICS_COLOR_YES, 0 },
  { "auto", DIAGNOSTICS_COLOR_AUTO, 0 },
  { "never", DIAGNOSTICS_COLOR_NO, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostic_color_rule_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostic_color_rule_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_diagnostic_path_format_data[] = 
{
  { "inline-events", DPF_INLINE_EVENTS, 0 },
  { "none", DPF_NONE, 0 },
  { "separate-events", DPF_SEPARATE_EVENTS, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostic_path_format_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostic_path_format_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_diagnostic_prefixing_rule_data[] = 
{
  { "every-line", DIAGNOSTICS_SHOW_PREFIX_EVERY_LINE, 0 },
  { "once", DIAGNOSTICS_SHOW_PREFIX_ONCE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostic_prefixing_rule_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostic_prefixing_rule_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_diagnostic_url_rule_data[] = 
{
  { "always", DIAGNOSTICS_URL_YES, 0 },
  { "auto", DIAGNOSTICS_URL_AUTO, 0 },
  { "never", DIAGNOSTICS_URL_NO, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostic_url_rule_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostic_url_rule_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_diagnostics_column_unit_data[] = 
{
  { "byte", DIAGNOSTICS_COLUMN_UNIT_BYTE, 0 },
  { "display", DIAGNOSTICS_COLUMN_UNIT_DISPLAY, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostics_column_unit_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostics_column_unit_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_diagnostics_escape_format_data[] = 
{
  { "bytes", DIAGNOSTICS_ESCAPE_FORMAT_BYTES, 0 },
  { "unicode", DIAGNOSTICS_ESCAPE_FORMAT_UNICODE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostics_escape_format_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostics_escape_format_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_diagnostics_output_format_data[] = 
{
  { "json", DIAGNOSTICS_OUTPUT_FORMAT_JSON, 0 },
  { "text", DIAGNOSTICS_OUTPUT_FORMAT_TEXT, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostics_output_format_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostics_output_format_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_dwarf_gnat_encodings_data[] = 
{
  { "all", DWARF_GNAT_ENCODINGS_ALL, 0 },
  { "gdb", DWARF_GNAT_ENCODINGS_GDB, 0 },
  { "minimal", DWARF_GNAT_ENCODINGS_MINIMAL, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_dwarf_gnat_encodings_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_dwarf_gnat_encodings_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_evrp_mode_data[] = 
{
  { "debug", EVRP_MODE_DEBUG, 0 },
  { "legacy", EVRP_MODE_EVRP_ONLY, 0 },
  { "legacy-first", EVRP_MODE_EVRP_FIRST, 0 },
  { "ranger", EVRP_MODE_RVRP_ONLY, 0 },
  { "ranger-debug", EVRP_MODE_RVRP_DEBUG, 0 },
  { "ranger-first", EVRP_MODE_RVRP_FIRST, 0 },
  { "ranger-trace", EVRP_MODE_RVRP_TRACE, 0 },
  { "trace", EVRP_MODE_TRACE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_evrp_mode_set (void *var, int value)
{
  *((enum evrp_mode *) var) = (enum evrp_mode) value;
}

static int
cl_enum_evrp_mode_get (const void *var)
{
  return (int) *((const enum evrp_mode *) var);
}

static const struct cl_enum_arg cl_enum_excess_precision_data[] = 
{
  { "fast", EXCESS_PRECISION_FAST, 0 },
  { "standard", EXCESS_PRECISION_STANDARD, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_excess_precision_set (void *var, int value)
{
  *((enum excess_precision *) var) = (enum excess_precision) value;
}

static int
cl_enum_excess_precision_get (const void *var)
{
  return (int) *((const enum excess_precision *) var);
}

static const struct cl_enum_arg cl_enum_float_abi_type_data[] = 
{
  { "hard", ARM_FLOAT_ABI_HARD, 0 },
  { "soft", ARM_FLOAT_ABI_SOFT, 0 },
  { "softfp", ARM_FLOAT_ABI_SOFTFP, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_float_abi_type_set (void *var, int value)
{
  *((enum float_abi_type *) var) = (enum float_abi_type) value;
}

static int
cl_enum_float_abi_type_get (const void *var)
{
  return (int) *((const enum float_abi_type *) var);
}

static const struct cl_enum_arg cl_enum_fp_contract_mode_data[] = 
{
  { "fast", FP_CONTRACT_FAST, 0 },
  { "off", FP_CONTRACT_OFF, 0 },
  { "on", FP_CONTRACT_OFF, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_fp_contract_mode_set (void *var, int value)
{
  *((enum fp_contract_mode *) var) = (enum fp_contract_mode) value;
}

static int
cl_enum_fp_contract_mode_get (const void *var)
{
  return (int) *((const enum fp_contract_mode *) var);
}

static const struct cl_enum_arg cl_enum_gfc_convert_data[] = 
{
  { "big-endian", GFC_FLAG_CONVERT_BIG, 0 },
  { "little-endian", GFC_FLAG_CONVERT_LITTLE, 0 },
  { "native", GFC_FLAG_CONVERT_NATIVE, 0 },
  { "swap", GFC_FLAG_CONVERT_SWAP, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_gfc_convert_set (void *var, int value)
{
  *((enum gfc_convert *) var) = (enum gfc_convert) value;
}

static int
cl_enum_gfc_convert_get (const void *var)
{
  return (int) *((const enum gfc_convert *) var);
}

static const struct cl_enum_arg cl_enum_gfc_fcoarray_data[] = 
{
  { "lib", GFC_FCOARRAY_LIB, 0 },
  { "none", GFC_FCOARRAY_NONE, 0 },
  { "single", GFC_FCOARRAY_SINGLE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_gfc_fcoarray_set (void *var, int value)
{
  *((enum gfc_fcoarray *) var) = (enum gfc_fcoarray) value;
}

static int
cl_enum_gfc_fcoarray_get (const void *var)
{
  return (int) *((const enum gfc_fcoarray *) var);
}

static const struct cl_enum_arg cl_enum_gfc_init_local_real_data[] = 
{
  { "-inf", GFC_INIT_REAL_NEG_INF, 0 },
  { "inf", GFC_INIT_REAL_INF, 0 },
  { "nan", GFC_INIT_REAL_NAN, 0 },
  { "snan", GFC_INIT_REAL_SNAN, 0 },
  { "zero", GFC_INIT_REAL_ZERO, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_gfc_init_local_real_set (void *var, int value)
{
  *((enum gfc_init_local_real *) var) = (enum gfc_init_local_real) value;
}

static int
cl_enum_gfc_init_local_real_get (const void *var)
{
  return (int) *((const enum gfc_init_local_real *) var);
}

static const struct cl_enum_arg cl_enum_ira_algorithm_data[] = 
{
  { "CB", IRA_ALGORITHM_CB, 0 },
  { "priority", IRA_ALGORITHM_PRIORITY, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_ira_algorithm_set (void *var, int value)
{
  *((enum ira_algorithm *) var) = (enum ira_algorithm) value;
}

static int
cl_enum_ira_algorithm_get (const void *var)
{
  return (int) *((const enum ira_algorithm *) var);
}

static const struct cl_enum_arg cl_enum_ira_region_data[] = 
{
  { "all", IRA_REGION_ALL, 0 },
  { "mixed", IRA_REGION_MIXED, 0 },
  { "one", IRA_REGION_ONE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_ira_region_set (void *var, int value)
{
  *((enum ira_region *) var) = (enum ira_region) value;
}

static int
cl_enum_ira_region_get (const void *var)
{
  return (int) *((const enum ira_region *) var);
}

static const struct cl_enum_arg cl_enum_ivar_visibility_data[] = 
{
  { "package", IVAR_VISIBILITY_PACKAGE, 0 },
  { "private", IVAR_VISIBILITY_PRIVATE, 0 },
  { "protected", IVAR_VISIBILITY_PROTECTED, 0 },
  { "public", IVAR_VISIBILITY_PUBLIC, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_ivar_visibility_set (void *var, int value)
{
  *((enum ivar_visibility *) var) = (enum ivar_visibility) value;
}

static int
cl_enum_ivar_visibility_get (const void *var)
{
  return (int) *((const enum ivar_visibility *) var);
}

static const struct cl_enum_arg cl_enum_live_patching_level_data[] = 
{
  { "inline-clone", LIVE_PATCHING_INLINE_CLONE, 0 },
  { "inline-only-static", LIVE_PATCHING_INLINE_ONLY_STATIC, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_live_patching_level_set (void *var, int value)
{
  *((enum live_patching_level *) var) = (enum live_patching_level) value;
}

static int
cl_enum_live_patching_level_get (const void *var)
{
  return (int) *((const enum live_patching_level *) var);
}

static const struct cl_enum_arg cl_enum_lto_linker_output_data[] = 
{
  { "dyn", LTO_LINKER_OUTPUT_DYN, 0 },
  { "exec", LTO_LINKER_OUTPUT_EXEC, 0 },
  { "nolto-rel", LTO_LINKER_OUTPUT_NOLTOREL, 0 },
  { "pie", LTO_LINKER_OUTPUT_PIE, 0 },
  { "rel", LTO_LINKER_OUTPUT_REL, 0 },
  { "unknown", LTO_LINKER_OUTPUT_UNKNOWN, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_lto_linker_output_set (void *var, int value)
{
  *((enum lto_linker_output *) var) = (enum lto_linker_output) value;
}

static int
cl_enum_lto_linker_output_get (const void *var)
{
  return (int) *((const enum lto_linker_output *) var);
}

static const struct cl_enum_arg cl_enum_lto_partition_model_data[] = 
{
  { "1to1", LTO_PARTITION_1TO1, 0 },
  { "balanced", LTO_PARTITION_BALANCED, 0 },
  { "max", LTO_PARTITION_MAX, 0 },
  { "none", LTO_PARTITION_NONE, 0 },
  { "one", LTO_PARTITION_ONE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_lto_partition_model_set (void *var, int value)
{
  *((enum lto_partition_model *) var) = (enum lto_partition_model) value;
}

static int
cl_enum_lto_partition_model_get (const void *var)
{
  return (int) *((const enum lto_partition_model *) var);
}

static const struct cl_enum_arg cl_enum_offload_abi_data[] = 
{
  { "ilp32", OFFLOAD_ABI_ILP32, 0 },
  { "lp64", OFFLOAD_ABI_LP64, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_offload_abi_set (void *var, int value)
{
  *((enum offload_abi *) var) = (enum offload_abi) value;
}

static int
cl_enum_offload_abi_get (const void *var)
{
  return (int) *((const enum offload_abi *) var);
}

static const struct cl_enum_arg cl_enum_openacc_kernels_data[] = 
{
  { "decompose", OPENACC_KERNELS_DECOMPOSE, 0 },
  { "parloops", OPENACC_KERNELS_PARLOOPS, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_openacc_kernels_set (void *var, int value)
{
  *((enum openacc_kernels *) var) = (enum openacc_kernels) value;
}

static int
cl_enum_openacc_kernels_get (const void *var)
{
  return (int) *((const enum openacc_kernels *) var);
}

static const struct cl_enum_arg cl_enum_parloops_schedule_type_data[] = 
{
  { "auto", PARLOOPS_SCHEDULE_AUTO, 0 },
  { "dynamic", PARLOOPS_SCHEDULE_DYNAMIC, 0 },
  { "guided", PARLOOPS_SCHEDULE_GUIDED, 0 },
  { "runtime", PARLOOPS_SCHEDULE_RUNTIME, 0 },
  { "static", PARLOOPS_SCHEDULE_STATIC, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_parloops_schedule_type_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_parloops_schedule_type_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_permitted_flt_eval_methods_data[] = 
{
  { "c11", PERMITTED_FLT_EVAL_METHODS_C11, 0 },
  { "ts-18661-3", PERMITTED_FLT_EVAL_METHODS_TS_18661, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_permitted_flt_eval_methods_set (void *var, int value)
{
  *((enum permitted_flt_eval_methods *) var) = (enum permitted_flt_eval_methods) value;
}

static int
cl_enum_permitted_flt_eval_methods_get (const void *var)
{
  return (int) *((const enum permitted_flt_eval_methods *) var);
}

static const struct cl_enum_arg cl_enum_processor_type_data[] = 
{
  { "arm1026ej-s",  TARGET_CPU_arm1026ejs, 0 },
  { "arm10e",  TARGET_CPU_arm10e, 0 },
  { "arm10tdmi",  TARGET_CPU_arm10tdmi, 0 },
  { "arm1136j-s",  TARGET_CPU_arm1136js, 0 },
  { "arm1136jf-s",  TARGET_CPU_arm1136jfs, 0 },
  { "arm1156t2-s",  TARGET_CPU_arm1156t2s, 0 },
  { "arm1156t2f-s",  TARGET_CPU_arm1156t2fs, 0 },
  { "arm1176jz-s",  TARGET_CPU_arm1176jzs, 0 },
  { "arm1176jzf-s",  TARGET_CPU_arm1176jzfs, 0 },
  { "arm710t",  TARGET_CPU_arm710t, 0 },
  { "arm7tdmi",  TARGET_CPU_arm7tdmi, 0 },
  { "arm8",  TARGET_CPU_arm8, 0 },
  { "arm810",  TARGET_CPU_arm810, 0 },
  { "arm9",  TARGET_CPU_arm9, 0 },
  { "arm920t",  TARGET_CPU_arm920t, 0 },
  { "arm926ej-s",  TARGET_CPU_arm926ejs, 0 },
  { "arm9e",  TARGET_CPU_arm9e, 0 },
  { "arm9tdmi",  TARGET_CPU_arm9tdmi, 0 },
  { "cortex-a12",  TARGET_CPU_cortexa12, 0 },
  { "cortex-a15",  TARGET_CPU_cortexa15, 0 },
  { "cortex-a15.cortex-a7",  TARGET_CPU_cortexa15cortexa7, 0 },
  { "cortex-a17",  TARGET_CPU_cortexa17, 0 },
  { "cortex-a17.cortex-a7",  TARGET_CPU_cortexa17cortexa7, 0 },
  { "cortex-a32",  TARGET_CPU_cortexa32, 0 },
  { "cortex-a35",  TARGET_CPU_cortexa35, 0 },
  { "cortex-a5",  TARGET_CPU_cortexa5, 0 },
  { "cortex-a53",  TARGET_CPU_cortexa53, 0 },
  { "cortex-a55",  TARGET_CPU_cortexa55, 0 },
  { "cortex-a57",  TARGET_CPU_cortexa57, 0 },
  { "cortex-a57.cortex-a53",  TARGET_CPU_cortexa57cortexa53, 0 },
  { "cortex-a7",  TARGET_CPU_cortexa7, 0 },
  { "cortex-a72",  TARGET_CPU_cortexa72, 0 },
  { "cortex-a72.cortex-a53",  TARGET_CPU_cortexa72cortexa53, 0 },
  { "cortex-a73",  TARGET_CPU_cortexa73, 0 },
  { "cortex-a73.cortex-a35",  TARGET_CPU_cortexa73cortexa35, 0 },
  { "cortex-a73.cortex-a53",  TARGET_CPU_cortexa73cortexa53, 0 },
  { "cortex-a75",  TARGET_CPU_cortexa75, 0 },
  { "cortex-a75.cortex-a55",  TARGET_CPU_cortexa75cortexa55, 0 },
  { "cortex-a76",  TARGET_CPU_cortexa76, 0 },
  { "cortex-a76.cortex-a55",  TARGET_CPU_cortexa76cortexa55, 0 },
  { "cortex-a76ae",  TARGET_CPU_cortexa76ae, 0 },
  { "cortex-a77",  TARGET_CPU_cortexa77, 0 },
  { "cortex-a78",  TARGET_CPU_cortexa78, 0 },
  { "cortex-a78ae",  TARGET_CPU_cortexa78ae, 0 },
  { "cortex-a78c",  TARGET_CPU_cortexa78c, 0 },
  { "cortex-a8",  TARGET_CPU_cortexa8, 0 },
  { "cortex-a9",  TARGET_CPU_cortexa9, 0 },
  { "cortex-m0",  TARGET_CPU_cortexm0, 0 },
  { "cortex-m0.small-multiply",  TARGET_CPU_cortexm0smallmultiply, 0 },
  { "cortex-m0plus",  TARGET_CPU_cortexm0plus, 0 },
  { "cortex-m0plus.small-multiply",  TARGET_CPU_cortexm0plussmallmultiply, 0 },
  { "cortex-m1",  TARGET_CPU_cortexm1, 0 },
  { "cortex-m1.small-multiply",  TARGET_CPU_cortexm1smallmultiply, 0 },
  { "cortex-m23",  TARGET_CPU_cortexm23, 0 },
  { "cortex-m3",  TARGET_CPU_cortexm3, 0 },
  { "cortex-m33",  TARGET_CPU_cortexm33, 0 },
  { "cortex-m35p",  TARGET_CPU_cortexm35p, 0 },
  { "cortex-m4",  TARGET_CPU_cortexm4, 0 },
  { "cortex-m55",  TARGET_CPU_cortexm55, 0 },
  { "cortex-m7",  TARGET_CPU_cortexm7, 0 },
  { "cortex-r4",  TARGET_CPU_cortexr4, 0 },
  { "cortex-r4f",  TARGET_CPU_cortexr4f, 0 },
  { "cortex-r5",  TARGET_CPU_cortexr5, 0 },
  { "cortex-r52",  TARGET_CPU_cortexr52, 0 },
  { "cortex-r7",  TARGET_CPU_cortexr7, 0 },
  { "cortex-r8",  TARGET_CPU_cortexr8, 0 },
  { "cortex-x1",  TARGET_CPU_cortexx1, 0 },
  { "exynos-m1",  TARGET_CPU_exynosm1, 0 },
  { "fa526",  TARGET_CPU_fa526, 0 },
  { "fa606te",  TARGET_CPU_fa606te, 0 },
  { "fa626",  TARGET_CPU_fa626, 0 },
  { "fa626te",  TARGET_CPU_fa626te, 0 },
  { "fa726te",  TARGET_CPU_fa726te, 0 },
  { "fmp626",  TARGET_CPU_fmp626, 0 },
  { "generic-armv7-a",  TARGET_CPU_genericv7a, 0 },
  { "iwmmxt",  TARGET_CPU_iwmmxt, 0 },
  { "iwmmxt2",  TARGET_CPU_iwmmxt2, 0 },
  { "marvell-pj4",  TARGET_CPU_marvell_pj4, 0 },
  { "mpcore",  TARGET_CPU_mpcore, 0 },
  { "mpcorenovfp",  TARGET_CPU_mpcorenovfp, 0 },
  { "native", -1, 0| CL_ENUM_DRIVER_ONLY },
  { "neoverse-n1",  TARGET_CPU_neoversen1, 0 },
  { "neoverse-n2",  TARGET_CPU_neoversen2, 0 },
  { "neoverse-v1",  TARGET_CPU_neoversev1, 0 },
  { "strongarm",  TARGET_CPU_strongarm, 0 },
  { "xgene1",  TARGET_CPU_xgene1, 0 },
  { "xscale",  TARGET_CPU_xscale, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_processor_type_set (void *var, int value)
{
  *((enum processor_type *) var) = (enum processor_type) value;
}

static int
cl_enum_processor_type_get (const void *var)
{
  return (int) *((const enum processor_type *) var);
}

static const struct cl_enum_arg cl_enum_profile_reproducibility_data[] = 
{
  { "multithreaded", PROFILE_REPRODUCIBILITY_MULTITHREADED, 0 },
  { "parallel-runs", PROFILE_REPRODUCIBILITY_PARALLEL_RUNS, 0 },
  { "serial", PROFILE_REPRODUCIBILITY_SERIAL, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_profile_reproducibility_set (void *var, int value)
{
  *((enum profile_reproducibility *) var) = (enum profile_reproducibility) value;
}

static int
cl_enum_profile_reproducibility_get (const void *var)
{
  return (int) *((const enum profile_reproducibility *) var);
}

static const struct cl_enum_arg cl_enum_profile_update_data[] = 
{
  { "atomic", PROFILE_UPDATE_ATOMIC, 0 },
  { "prefer-atomic", PROFILE_UPDATE_PREFER_ATOMIC, 0 },
  { "single", PROFILE_UPDATE_SINGLE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_profile_update_set (void *var, int value)
{
  *((enum profile_update *) var) = (enum profile_update) value;
}

static int
cl_enum_profile_update_get (const void *var)
{
  return (int) *((const enum profile_update *) var);
}

static const struct cl_enum_arg cl_enum_reorder_blocks_algorithm_data[] = 
{
  { "simple", REORDER_BLOCKS_ALGORITHM_SIMPLE, 0 },
  { "stc", REORDER_BLOCKS_ALGORITHM_STC, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_reorder_blocks_algorithm_set (void *var, int value)
{
  *((enum reorder_blocks_algorithm *) var) = (enum reorder_blocks_algorithm) value;
}

static int
cl_enum_reorder_blocks_algorithm_get (const void *var)
{
  return (int) *((const enum reorder_blocks_algorithm *) var);
}

static const struct cl_enum_arg cl_enum_sso_struct_data[] = 
{
  { "big-endian", SSO_BIG_ENDIAN, 0 },
  { "little-endian", SSO_LITTLE_ENDIAN, 0 },
  { "native", SSO_NATIVE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_sso_struct_set (void *var, int value)
{
  *((enum scalar_storage_order_kind *) var) = (enum scalar_storage_order_kind) value;
}

static int
cl_enum_sso_struct_get (const void *var)
{
  return (int) *((const enum scalar_storage_order_kind *) var);
}

static const struct cl_enum_arg cl_enum_stack_reuse_level_data[] = 
{
  { "all", SR_ALL, 0 },
  { "named_vars", SR_NAMED_VARS, 0 },
  { "none", SR_NONE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_stack_reuse_level_set (void *var, int value)
{
  *((enum stack_reuse_level *) var) = (enum stack_reuse_level) value;
}

static int
cl_enum_stack_reuse_level_get (const void *var)
{
  return (int) *((const enum stack_reuse_level *) var);
}

static const struct cl_enum_arg cl_enum_stdlib_kind_data[] = 
{
  { "libc++", 2, 0 },
  { "libstdc++", 1, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_stdlib_kind_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_stdlib_kind_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_strong_eval_order_data[] = 
{
  { "all", 2, 0 },
  { "none", 0, 0 },
  { "some", 1, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_strong_eval_order_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_strong_eval_order_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_symbol_visibility_data[] = 
{
  { "default", VISIBILITY_DEFAULT, 0 },
  { "hidden", VISIBILITY_HIDDEN, 0 },
  { "internal", VISIBILITY_INTERNAL, 0 },
  { "protected", VISIBILITY_PROTECTED, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_symbol_visibility_set (void *var, int value)
{
  *((enum symbol_visibility *) var) = (enum symbol_visibility) value;
}

static int
cl_enum_symbol_visibility_get (const void *var)
{
  return (int) *((const enum symbol_visibility *) var);
}

static const struct cl_enum_arg cl_enum_tls_model_data[] = 
{
  { "global-dynamic", TLS_MODEL_GLOBAL_DYNAMIC, 0 },
  { "initial-exec", TLS_MODEL_INITIAL_EXEC, 0 },
  { "local-dynamic", TLS_MODEL_LOCAL_DYNAMIC, 0 },
  { "local-exec", TLS_MODEL_LOCAL_EXEC, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_tls_model_set (void *var, int value)
{
  *((enum tls_model *) var) = (enum tls_model) value;
}

static int
cl_enum_tls_model_get (const void *var)
{
  return (int) *((const enum tls_model *) var);
}

static const struct cl_enum_arg cl_enum_tls_type_data[] = 
{
  { "gnu", TLS_GNU, 0 },
  { "gnu2", TLS_GNU2, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_tls_type_set (void *var, int value)
{
  *((enum arm_tls_type *) var) = (enum arm_tls_type) value;
}

static int
cl_enum_tls_type_get (const void *var)
{
  return (int) *((const enum arm_tls_type *) var);
}

static const struct cl_enum_arg cl_enum_vect_cost_model_data[] = 
{
  { "cheap", VECT_COST_MODEL_CHEAP, 0 },
  { "dynamic", VECT_COST_MODEL_DYNAMIC, 0 },
  { "unlimited", VECT_COST_MODEL_UNLIMITED, 0 },
  { "very-cheap", VECT_COST_MODEL_VERY_CHEAP, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_vect_cost_model_set (void *var, int value)
{
  *((enum vect_cost_model *) var) = (enum vect_cost_model) value;
}

static int
cl_enum_vect_cost_model_get (const void *var)
{
  return (int) *((const enum vect_cost_model *) var);
}

static const struct cl_enum_arg cl_enum_vtv_priority_data[] = 
{
  { "none", VTV_NO_PRIORITY, 0 },
  { "preinit", VTV_PREINIT_PRIORITY, 0 },
  { "std", VTV_STANDARD_PRIORITY, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_vtv_priority_set (void *var, int value)
{
  *((enum vtv_priority *) var) = (enum vtv_priority) value;
}

static int
cl_enum_vtv_priority_get (const void *var)
{
  return (int) *((const enum vtv_priority *) var);
}

static const struct cl_enum_arg cl_enum_warn_aligned_new_level_data[] = 
{
  { "all", 2, 0 },
  { "global", 1, 0 },
  { "none", 0, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_warn_aligned_new_level_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_warn_aligned_new_level_get (const void *var)
{
  return (int) *((const int *) var);
}

const struct cl_enum cl_enums[] =
{
  {
    "Known ARM ABIs (for use with the -mabi= option):",
    NULL,
    cl_enum_arm_abi_type_data,
    sizeof (enum arm_abi_type),
    cl_enum_arm_abi_type_set,
    cl_enum_arm_abi_type_get
  },
  {
    "Known ARM architectures (for use with the -march= option):",
    NULL,
    cl_enum_arm_arch_data,
    sizeof (int),
    cl_enum_arm_arch_set,
    cl_enum_arm_arch_get
  },
  {
    "Known __fp16 formats (for use with the -mfp16-format= option):",
    NULL,
    cl_enum_arm_fp16_format_type_data,
    sizeof (enum arm_fp16_format_type),
    cl_enum_arm_fp16_format_type_set,
    cl_enum_arm_fp16_format_type_get
  },
  {
    "Known ARM FPUs (for use with the -mfpu= option):",
    NULL,
    cl_enum_arm_fpu_data,
    sizeof (enum fpu_type),
    cl_enum_arm_fpu_set,
    cl_enum_arm_fpu_get
  },
  {
    "Valid arguments to -mtp=:",
    NULL,
    cl_enum_arm_tp_type_data,
    sizeof (enum arm_tp_type),
    cl_enum_arm_tp_type_set,
    cl_enum_arm_tp_type_get
  },
  {
    NULL,
    "unknown array bounds setting %qs",
    cl_enum_bounds_check_data,
    sizeof (int),
    cl_enum_bounds_check_set,
    cl_enum_bounds_check_get
  },
  {
    NULL,
    "unknown Control-Flow Protection Level %qs",
    cl_enum_cf_protection_level_data,
    sizeof (enum cf_protection_level),
    cl_enum_cf_protection_level_set,
    cl_enum_cf_protection_level_get
  },
  {
    NULL,
    NULL,
    cl_enum_compressed_debug_sections_data,
    sizeof (int),
    cl_enum_compressed_debug_sections_set,
    cl_enum_compressed_debug_sections_get
  },
  {
    NULL,
    "argument %qs to %<-Wbidi-chars%> not recognized",
    cl_enum_cpp_bidirectional_level_data,
    sizeof (int),
    cl_enum_cpp_bidirectional_level_set,
    cl_enum_cpp_bidirectional_level_get
  },
  {
    NULL,
    "argument %qs to %<-Wnormalized%> not recognized",
    cl_enum_cpp_normalize_level_data,
    sizeof (int),
    cl_enum_cpp_normalize_level_set,
    cl_enum_cpp_normalize_level_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostic_color_rule_data,
    sizeof (int),
    cl_enum_diagnostic_color_rule_set,
    cl_enum_diagnostic_color_rule_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostic_path_format_data,
    sizeof (int),
    cl_enum_diagnostic_path_format_set,
    cl_enum_diagnostic_path_format_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostic_prefixing_rule_data,
    sizeof (int),
    cl_enum_diagnostic_prefixing_rule_set,
    cl_enum_diagnostic_prefixing_rule_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostic_url_rule_data,
    sizeof (int),
    cl_enum_diagnostic_url_rule_set,
    cl_enum_diagnostic_url_rule_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostics_column_unit_data,
    sizeof (int),
    cl_enum_diagnostics_column_unit_set,
    cl_enum_diagnostics_column_unit_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostics_escape_format_data,
    sizeof (int),
    cl_enum_diagnostics_escape_format_set,
    cl_enum_diagnostics_escape_format_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostics_output_format_data,
    sizeof (int),
    cl_enum_diagnostics_output_format_set,
    cl_enum_diagnostics_output_format_get
  },
  {
    NULL,
    NULL,
    cl_enum_dwarf_gnat_encodings_data,
    sizeof (int),
    cl_enum_dwarf_gnat_encodings_set,
    cl_enum_dwarf_gnat_encodings_get
  },
  {
    NULL,
    "unknown evrp mode %qs",
    cl_enum_evrp_mode_data,
    sizeof (enum evrp_mode),
    cl_enum_evrp_mode_set,
    cl_enum_evrp_mode_get
  },
  {
    NULL,
    "unknown excess precision style %qs",
    cl_enum_excess_precision_data,
    sizeof (enum excess_precision),
    cl_enum_excess_precision_set,
    cl_enum_excess_precision_get
  },
  {
    "Known floating-point ABIs (for use with the -mfloat-abi= option):",
    NULL,
    cl_enum_float_abi_type_data,
    sizeof (enum float_abi_type),
    cl_enum_float_abi_type_set,
    cl_enum_float_abi_type_get
  },
  {
    NULL,
    "unknown floating point contraction style %qs",
    cl_enum_fp_contract_mode_data,
    sizeof (enum fp_contract_mode),
    cl_enum_fp_contract_mode_set,
    cl_enum_fp_contract_mode_get
  },
  {
    NULL,
    "Unrecognized option to endianness value: %qs",
    cl_enum_gfc_convert_data,
    sizeof (enum gfc_convert),
    cl_enum_gfc_convert_set,
    cl_enum_gfc_convert_get
  },
  {
    NULL,
    "Unrecognized option: %qs",
    cl_enum_gfc_fcoarray_data,
    sizeof (enum gfc_fcoarray),
    cl_enum_gfc_fcoarray_set,
    cl_enum_gfc_fcoarray_get
  },
  {
    NULL,
    "Unrecognized option to floating-point init value: %qs",
    cl_enum_gfc_init_local_real_data,
    sizeof (enum gfc_init_local_real),
    cl_enum_gfc_init_local_real_set,
    cl_enum_gfc_init_local_real_get
  },
  {
    NULL,
    "unknown IRA algorithm %qs",
    cl_enum_ira_algorithm_data,
    sizeof (enum ira_algorithm),
    cl_enum_ira_algorithm_set,
    cl_enum_ira_algorithm_get
  },
  {
    NULL,
    "unknown IRA region %qs",
    cl_enum_ira_region_data,
    sizeof (enum ira_region),
    cl_enum_ira_region_set,
    cl_enum_ira_region_get
  },
  {
    NULL,
    "unrecognized ivar visibility value %qs",
    cl_enum_ivar_visibility_data,
    sizeof (enum ivar_visibility),
    cl_enum_ivar_visibility_set,
    cl_enum_ivar_visibility_get
  },
  {
    NULL,
    "unknown Live-Patching Level %qs",
    cl_enum_live_patching_level_data,
    sizeof (enum live_patching_level),
    cl_enum_live_patching_level_set,
    cl_enum_live_patching_level_get
  },
  {
    NULL,
    "unknown linker output %qs",
    cl_enum_lto_linker_output_data,
    sizeof (enum lto_linker_output),
    cl_enum_lto_linker_output_set,
    cl_enum_lto_linker_output_get
  },
  {
    NULL,
    "unknown LTO partitioning model %qs",
    cl_enum_lto_partition_model_data,
    sizeof (enum lto_partition_model),
    cl_enum_lto_partition_model_set,
    cl_enum_lto_partition_model_get
  },
  {
    NULL,
    "unknown offload ABI %qs",
    cl_enum_offload_abi_data,
    sizeof (enum offload_abi),
    cl_enum_offload_abi_set,
    cl_enum_offload_abi_get
  },
  {
    NULL,
    NULL,
    cl_enum_openacc_kernels_data,
    sizeof (enum openacc_kernels),
    cl_enum_openacc_kernels_set,
    cl_enum_openacc_kernels_get
  },
  {
    NULL,
    NULL,
    cl_enum_parloops_schedule_type_data,
    sizeof (int),
    cl_enum_parloops_schedule_type_set,
    cl_enum_parloops_schedule_type_get
  },
  {
    NULL,
    "unknown specification for the set of FLT_EVAL_METHOD values to permit %qs",
    cl_enum_permitted_flt_eval_methods_data,
    sizeof (enum permitted_flt_eval_methods),
    cl_enum_permitted_flt_eval_methods_set,
    cl_enum_permitted_flt_eval_methods_get
  },
  {
    "Known ARM CPUs (for use with the -mcpu= and -mtune= options):",
    NULL,
    cl_enum_processor_type_data,
    sizeof (enum processor_type),
    cl_enum_processor_type_set,
    cl_enum_processor_type_get
  },
  {
    NULL,
    "unknown profile reproducibility method %qs",
    cl_enum_profile_reproducibility_data,
    sizeof (enum profile_reproducibility),
    cl_enum_profile_reproducibility_set,
    cl_enum_profile_reproducibility_get
  },
  {
    NULL,
    "unknown profile update method %qs",
    cl_enum_profile_update_data,
    sizeof (enum profile_update),
    cl_enum_profile_update_set,
    cl_enum_profile_update_get
  },
  {
    NULL,
    "unknown basic block reordering algorithm %qs",
    cl_enum_reorder_blocks_algorithm_data,
    sizeof (enum reorder_blocks_algorithm),
    cl_enum_reorder_blocks_algorithm_set,
    cl_enum_reorder_blocks_algorithm_get
  },
  {
    NULL,
    "unrecognized scalar storage order value %qs",
    cl_enum_sso_struct_data,
    sizeof (enum scalar_storage_order_kind),
    cl_enum_sso_struct_set,
    cl_enum_sso_struct_get
  },
  {
    NULL,
    "unknown Stack Reuse Level %qs",
    cl_enum_stack_reuse_level_data,
    sizeof (enum stack_reuse_level),
    cl_enum_stack_reuse_level_set,
    cl_enum_stack_reuse_level_get
  },
  {
    NULL,
    NULL,
    cl_enum_stdlib_kind_data,
    sizeof (int),
    cl_enum_stdlib_kind_set,
    cl_enum_stdlib_kind_get
  },
  {
    NULL,
    NULL,
    cl_enum_strong_eval_order_data,
    sizeof (int),
    cl_enum_strong_eval_order_set,
    cl_enum_strong_eval_order_get
  },
  {
    NULL,
    "unrecognized visibility value %qs",
    cl_enum_symbol_visibility_data,
    sizeof (enum symbol_visibility),
    cl_enum_symbol_visibility_set,
    cl_enum_symbol_visibility_get
  },
  {
    NULL,
    "unknown TLS model %qs",
    cl_enum_tls_model_data,
    sizeof (enum tls_model),
    cl_enum_tls_model_set,
    cl_enum_tls_model_get
  },
  {
    "TLS dialect to use:",
    NULL,
    cl_enum_tls_type_data,
    sizeof (enum arm_tls_type),
    cl_enum_tls_type_set,
    cl_enum_tls_type_get
  },
  {
    NULL,
    "unknown vectorizer cost model %qs",
    cl_enum_vect_cost_model_data,
    sizeof (enum vect_cost_model),
    cl_enum_vect_cost_model_set,
    cl_enum_vect_cost_model_get
  },
  {
    NULL,
    "unknown vtable verify initialization priority %qs",
    cl_enum_vtv_priority_data,
    sizeof (enum vtv_priority),
    cl_enum_vtv_priority_set,
    cl_enum_vtv_priority_get
  },
  {
    NULL,
    "argument %qs to %<-Waligned-new%> not recognized",
    cl_enum_warn_aligned_new_level_data,
    sizeof (int),
    cl_enum_warn_aligned_new_level_set,
    cl_enum_warn_aligned_new_level_get
  },
};
const unsigned int cl_enums_count = 49;

const struct gcc_options global_options_init =
{
  false, /* dump_base_name_prefixed */
  0, /* exit_after_options */
  0, /* flag_dump_all_passed */
  0, /* flag_opts_finished */
  false, /* flag_stack_usage_info */
  false, /* flag_warn_unused_result */
  false, /* in_lto_p */
  0, /* use_gnu_debug_info_extensions */
  0, /* help_enum_printed */
  0, /* help_printed */
  0, /* aux_base_name */
  0, /* main_input_basename */
  0, /* main_input_filename */
  DINFO_LEVEL_NONE, /* debug_info_level */
  NO_DEBUG, /* write_symbols */
  { DINFO_STRUCT_FILE_ANY, DINFO_STRUCT_FILE_ANY, DINFO_STRUCT_FILE_ANY }, /* debug_struct_generic */
  { DINFO_STRUCT_FILE_ANY, DINFO_STRUCT_FILE_ANY, DINFO_STRUCT_FILE_ANY }, /* debug_struct_ordinary */
  DWARF_GNAT_ENCODINGS_DEFAULT, /* gnat_encodings */
  INCREMENTAL_LINK_NONE, /* flag_incremental_link */
  NO_STACK_CHECK, /* flag_stack_check */
  1, /* flag_complex_method */
  0, /* flag_debug_asm */
  0, /* flag_dump_rtl_in_asm */
  0, /* flag_gen_aux_info */
  0, /* flag_generate_lto */
  0, /* flag_generate_offload */
  0, /* flag_print_asm_name */
  0, /* flag_shlib */
  0, /* main_input_baselength */
  0, /* optimize */
  0, /* optimize_debug */
  0, /* optimize_fast */
  0, /* optimize_size */
  0, /* rtl_dump_and_exit */
  0, /* target_flags */
  0, /* flag_sanitize */
  0, /* flag_sanitize_coverage */
  (SANITIZE_UNDEFINED | SANITIZE_UNDEFINED_NONDEFAULT | SANITIZE_KERNEL_ADDRESS | SANITIZE_KERNEL_HWADDRESS) & ~(SANITIZE_UNREACHABLE | SANITIZE_RETURN), /* flag_sanitize_recover */
  0, /* flag_zero_call_used_regs */
  0, /* help_columns */
  TARGET_DEFAULT_PACK_STRUCT, /* initial_max_fld_align */
  0, /* flag_instrument_functions_exclude_files */
  0, /* flag_instrument_functions_exclude_functions */
  0, /* help_flag */
  0, /* no_sysroot_suffix */
  4, /* param_align_loop_iterations */
  100, /* param_align_threshold */
  5, /* param_analyzer_bb_explosion_factor */
  20, /* param_analyzer_max_constraints */
  200, /* param_analyzer_max_enodes_for_full_dump */
  8, /* param_analyzer_max_enodes_per_program_point */
  10, /* param_analyzer_max_infeasible_edges */
  2, /* param_analyzer_max_recursion_depth */
  13, /* param_analyzer_max_svalue_depth */
  10, /* param_analyzer_min_snodes_for_call_summary */
  1, /* param_asan_globals */
  1, /* param_asan_protect_allocas */
  1, /* param_asan_instrument_reads */
  1, /* param_asan_instrument_writes */
  7000, /* param_asan_instrumentation_with_call_threshold */
  1, /* param_asan_memintrin */
  1, /* param_asan_stack */
  1, /* param_asan_use_after_return */
  10, /* param_avg_loop_niter */
  0, /* param_avoid_fma_max_bits */
  90, /* param_builtin_expect_probability */
  3, /* param_builtin_string_cmp_inline_length */
  0, /* param_case_values_threshold */
  20, /* param_comdat_sharing_probability */
  1000, /* param_cxx_max_namespaces_for_diagnostic_help */
  256, /* param_dse_max_alias_queries_per_store */
  256, /* param_dse_max_object_size */
  6, /* param_early_inlining_insns */
  EVRP_MODE_EVRP_FIRST, /* param_evrp_mode */
  800, /* param_evrp_sparse_threshold */
  100, /* param_fsm_maximum_phi_arguments */
  3, /* param_fsm_scale_path_blocks */
  2, /* param_fsm_scale_path_stmts */
  10, /* param_gcse_after_reload_critical_fraction */
  3, /* param_gcse_after_reload_partial_fraction */
  10, /* param_gcse_cost_distance_ratio */
  3, /* param_gcse_unrestricted_cost */
  30, /* param_ggc_min_expand */
  4096, /* param_ggc_min_heapsize */
  0, /* param_gimple_fe_computed_hot_bb_threshold */
  0, /* param_graphite_allow_codegen_errors */
  100, /* param_graphite_max_arrays_per_scop */
  10, /* param_graphite_max_nb_scop_params */
  10, /* param_hash_table_verification_limit */
  10000, /* param_hot_bb_count_fraction */
  990, /* param_hot_bb_count_ws_permille */
  1000, /* param_hot_bb_frequency_fraction */
  1, /* param_hwasan_instrument_allocas */
  1, /* param_hwasan_instrument_mem_intrinsics */
  1, /* param_hwasan_instrument_reads */
  1, /* param_hwasan_instrument_stack */
  1, /* param_hwasan_instrument_writes */
  1, /* param_hwasan_random_frame_tag */
  200, /* param_inline_heuristics_hint_percent */
  30, /* param_inline_min_speedup */
  40, /* param_inline_unit_growth */
  251, /* param_integer_share_limit */
  500, /* param_ipa_cp_eval_threshold */
  16000, /* param_ipa_cp_large_unit_insns */
  64, /* param_ipa_cp_loop_hint_bonus */
  8, /* param_ipa_cp_max_recursive_depth */
  2, /* param_ipa_cp_min_recursive_probability */
  40, /* param_ipa_cp_recursion_penalty */
  15, /* param_ipa_cp_single_call_penalty */
  10, /* param_ipa_cp_unit_growth */
  8, /* param_ipa_cp_value_list_size */
  8, /* param_ipa_jump_function_lookups */
  25000, /* param_ipa_max_aa_steps */
  16, /* param_ipa_max_agg_items */
  16, /* param_ipa_max_loop_predicates */
  10, /* param_ipa_max_param_expr_ops */
  5, /* param_ipa_max_switch_predicate_bounds */
  8, /* param_ipa_sra_max_replacements */
  2, /* param_ipa_sra_ptr_growth_factor */
  2, /* param_ira_loop_reserved_regs */
  1000, /* param_ira_max_conflict_table_size */
  100, /* param_ira_max_loops_num */
  10, /* param_iv_always_prune_cand_set_bound */
  40, /* param_iv_consider_all_candidates_bound */
  250, /* param_iv_max_considered_uses */
  300, /* param_jump_table_max_growth_ratio_for_size */
  800, /* param_jump_table_max_growth_ratio_for_speed */
  32, /* param_l1_cache_line_size */
  64, /* param_l1_cache_size */
  512, /* param_l2_cache_size */
  100, /* param_large_function_growth */
  2700, /* param_large_function_insns */
  1000, /* param_stack_frame_growth */
  256, /* param_large_stack_frame */
  10000, /* param_large_unit_insns */
  32768, /* param_lazy_modules */
  20, /* param_lim_expensive */
  -1, /* param_logical_op_non_short_circuit */
  51, /* param_loop_block_tile_size */
  64, /* param_loop_interchange_max_num_stmts */
  2, /* param_loop_interchange_stride_ratio */
  10000, /* param_loop_invariant_max_bbs_in_loop */
  1000, /* param_loop_max_datarefs_for_datadeps */
  200, /* param_loop_versioning_max_inner_insns */
  100, /* param_loop_versioning_max_outer_insns */
  40, /* param_lra_inheritance_ebb_probability_cutoff */
  500, /* param_lra_max_considered_reload_pseudos */
  1000000, /* param_max_partition_size */
  32, /* param_max_lto_streaming_parallelism */
  10000, /* param_min_partition_size */
  128, /* param_lto_partitions */
  80, /* param_max_average_unrolled_insns */
  4, /* param_max_combine_insns */
  8, /* param_max_unroll_iterations */
  16, /* param_max_completely_peel_times */
  200, /* param_max_completely_peeled_insns */
  100, /* param_max_crossjump_edges */
  1000, /* param_max_cse_insns */
  10, /* param_max_cse_path_length */
  500, /* param_max_cselib_memory_locations */
  100000, /* param_max_debug_marker_count */
  100, /* param_max_delay_slot_insn_search */
  333, /* param_max_delay_slot_live_search */
  5000, /* param_max_dse_active_local_stores */
  1, /* param_early_inliner_max_iterations */
  0, /* param_max_fields_for_field_sensitive */
  200, /* param_max_find_base_term_values */
  10, /* param_max_fsm_thread_length */
  100, /* param_max_fsm_thread_path_insns */
  50, /* param_max_fsm_thread_paths */
  20, /* param_max_gcse_insertion_ratio */
  131072, /* param_max_gcse_memory */
  8, /* param_max_goto_duplication_insns */
  8, /* param_max_grow_copy_bb_insns */
  30, /* param_max_hoist_depth */
  15, /* param_max_inline_insns_auto */
  450, /* param_max_inline_insns_recursive_auto */
  450, /* param_max_inline_insns_recursive */
  70, /* param_max_inline_insns_single */
  0, /* param_max_inline_insns_size */
  0, /* param_max_inline_insns_small */
  8, /* param_max_inline_recursive_depth_auto */
  8, /* param_max_inline_recursive_depth */
  350000, /* param_max_isl_operations */
  10, /* param_max_iterations_computation_cost */
  1000, /* param_max_iterations_to_track */
  15, /* param_max_jump_thread_duplication_stmts */
  10000, /* param_max_last_value_rtl */
  20, /* param_max_loop_header_insns */
  40, /* param_max_modulo_backtrack_attempts */
  100, /* param_max_partial_antic_length */
  32, /* param_max_peel_branches */
  16, /* param_max_peel_times */
  100, /* param_max_peeled_insns */
  32, /* param_max_pending_list_length */
  15, /* param_max_pipeline_region_blocks */
  200, /* param_max_pipeline_region_insns */
  5, /* param_max_pow_sqrt_depth */
  100, /* param_max_predicted_iterations */
  100, /* param_max_reload_search_insns */
  10, /* param_max_rtl_if_conversion_insns */
  20, /* param_max_rtl_if_conversion_predictable_cost */
  40, /* param_max_rtl_if_conversion_unpredictable_cost */
  0, /* param_max_sched_extend_regions_iters */
  3, /* param_max_sched_insn_conflict_delay */
  100, /* param_max_sched_ready_insns */
  10, /* param_max_sched_region_blocks */
  100, /* param_max_sched_region_insns */
  50, /* param_max_slsr_candidate_scan */
  50, /* param_max_speculative_devirt_maydefs */
  3, /* param_max_ssa_name_query_depth */
  64, /* param_max_store_chains_to_track */
  64, /* param_max_stores_to_merge */
  2, /* param_max_stores_to_sink */
  1024, /* param_max_stores_to_track */
  10, /* param_max_tail_merge_comparisons */
  2, /* param_max_tail_merge_iterations */
  10000, /* param_max_tracked_strlens */
  4, /* param_max_tree_if_conversion_phi_args */
  8, /* param_max_unroll_times */
  200, /* param_max_unrolled_insns */
  50, /* param_max_unswitch_insns */
  3, /* param_max_unswitch_level */
  1, /* param_max_variable_expansions */
  12, /* param_max_vartrack_expr_depth */
  50, /* param_max_vartrack_reverse_op_size */
  50000000, /* param_max_vartrack_size */
  10, /* param_max_vrp_switch_assertions */
  5, /* param_min_crossjump_insns */
  10, /* param_min_inline_recursive_probability */
  9, /* param_min_insn_to_prefetch_ratio */
  30, /* param_min_loop_cond_split_prob */
  0, /* param_min_nondebug_insn_uid */
  4096, /* param_min_pagesize */
  32, /* param_min_size_for_stack_sharing */
  40, /* param_min_spec_prob */
  0, /* param_min_vect_loop_bound */
  16, /* param_modref_max_accesses */
  32, /* param_modref_max_bases */
  256, /* param_modref_max_depth */
  256, /* param_modref_max_escape_points */
  16, /* param_modref_max_refs */
  64, /* param_modref_max_tests */
  OPENACC_KERNELS_PARLOOPS, /* param_openacc_kernels */
  0, /* param_parloops_chunk_size */
  100, /* param_parloops_min_per_thread */
  0, /* param_parloops_schedule */
  70, /* param_partial_inlining_entry_probability */
  2, /* param_predictable_branch_outcome */
  1, /* param_prefetch_dynamic_strides */
  200, /* param_prefetch_latency */
  3, /* param_prefetch_min_insn_to_mem_ratio */
  -1, /* param_prefetch_minimum_stride */
  0, /* param_profile_func_internal_id */
  6, /* param_ranger_logical_depth */
  7, /* param_rpo_vn_max_loop_depth */
  1000, /* param_sccvn_max_alias_queries_per_access */
  10, /* param_scev_max_expr_complexity */
  100, /* param_scev_max_expr_size */
  -1, /* param_sched_autopref_queue_depth */
  1, /* param_sched_mem_true_dep_cost */
  1, /* param_sched_pressure_algorithm */
  40, /* param_sched_spec_prob_cutoff */
  10, /* param_sched_state_edge_prob_cutoff */
  2, /* param_selsched_insns_to_rename */
  50, /* param_selsched_max_lookahead */
  2, /* param_selsched_max_sched_times */
  3, /* param_simultaneous_prefetches */
  75, /* param_sink_frequency_threshold */
  0, /* param_sms_dfa_history */
  0, /* param_sms_loop_average_count_threshold */
  2, /* param_sms_max_ii_factor */
  2, /* param_sms_min_sc */
  32, /* param_sra_max_propagations */
  0, /* param_sra_max_scalarization_size_size */
  0, /* param_sra_max_scalarization_size_speed */
  512, /* param_ssa_name_def_chain_limit */
  8, /* param_ssp_buffer_size */
  12, /* param_stack_clash_protection_guard_size */
  12, /* param_stack_clash_protection_probe_interval */
  1, /* param_store_merging_allow_unaligned */
  65536, /* param_store_merging_max_size */
  8, /* param_switch_conversion_branch_ratio */
  9, /* param_tm_max_aggregate_size */
  95, /* param_tracer_dynamic_coverage_feedback */
  75, /* param_tracer_dynamic_coverage */
  100, /* param_tracer_max_code_growth */
  80, /* param_tracer_min_branch_probability_feedback */
  50, /* param_tracer_min_branch_probability */
  10, /* param_tracer_min_branch_ratio */
  0, /* param_tree_reassoc_width */
  0, /* param_tsan_distinguish_volatile */
  1, /* param_tsan_instrument_func_entry_exit */
  1000, /* param_uninit_control_dep_attempts */
  2, /* param_uninlined_function_insns */
  0, /* param_uninlined_function_time */
  2, /* param_uninlined_function_thunk_insns */
  2, /* param_uninlined_function_thunk_time */
  20, /* param_unlikely_bb_count_fraction */
  4, /* param_unroll_jam_max_unroll */
  1, /* param_unroll_jam_min_percent */
  256, /* param_use_after_scope_direct_emission_threshold */
  1, /* param_use_canonical_types */
  1, /* param_vect_epilogues_nomask */
  -1, /* param_vect_max_peeling_for_alignment */
  10, /* param_vect_max_version_for_alias_checks */
  6, /* param_vect_max_version_for_alignment_checks */
  2, /* param_vect_partial_vector_usage */
  0, /* flag_preprocess_only */
  1, /* warn_nsobject_attribute */
  0, /* warn_abi */
  0, /* warn_abi_tag */
  0, /* warn_absolute_value */
  0, /* warn_address */
  1, /* warn_address_of_packed_member */
  0, /* warn_aggregate_return */
  1, /* warn_aggressive_loop_optimizations */
  0, /* warn_aliasing */
  1, /* warn_align_commons */
  0, /* warn_aligned_new */
  HOST_WIDE_INT_MAX, /* warn_alloc_size_limit */
  0, /* warn_alloc_zero */
  0, /* warn_alloca */
  HOST_WIDE_INT_MAX, /* warn_alloca_limit */
  0, /* warn_ampersand */
  1, /* warn_analyzer_double_fclose */
  1, /* warn_analyzer_double_free */
  1, /* warn_analyzer_exposure_through_output_file */
  1, /* warn_analyzer_file_leak */
  1, /* warn_analyzer_free_of_non_heap */
  1, /* warn_analyzer_malloc_leak */
  1, /* warn_analyzer_mismatching_deallocation */
  1, /* warn_analyzer_null_argument */
  1, /* warn_analyzer_null_dereference */
  1, /* warn_analyzer_possible_null_argument */
  1, /* warn_analyzer_possible_null_dereference */
  1, /* warn_analyzer_shift_count_negative */
  1, /* warn_analyzer_shift_count_overflow */
  1, /* warn_analyzer_stale_setjmp_buffer */
  1, /* warn_analyzer_tainted_array_index */
  0, /* warn_analyzer_too_complex */
  1, /* warn_analyzer_unsafe_call_within_signal_handler */
  1, /* warn_analyzer_use_after_free */
  1, /* warn_analyzer_use_of_pointer_in_stale_stack_frame */
  1, /* warn_analyzer_write_to_const */
  1, /* warn_analyzer_write_to_string_literal */
  0, /* warn_arith_conv */
  0, /* warn_array_bounds */
  0, /* warn_array_parameter */
  0, /* warn_array_temporaries */
  0, /* warn_assign_intercept */
  1, /* warn_attribute_alias */
  1, /* warn_attribute_warning */
  1, /* warn_attributes */
  0, /* warn_bad_function_cast */
  bidirectional_unpaired, /* warn_bidirectional */
  0, /* warn_bool_compare */
  0, /* warn_bool_op */
  1, /* warn_builtin_declaration_mismatch */
  1, /* cpp_warn_builtin_macro_redefined */
  0, /* warn_cxx_compat */
  0, /* warn_cxx11_compat */
  0, /* warn_cxx14_compat */
  0, /* warn_cxx17_compat */
  0, /* warn_cxx20_compat */
  0, /* warn_c_binding_type */
  -1, /* warn_c11_c2x_compat */
  -1, /* warn_c90_c99_compat */
  -1, /* warn_c99_c11_compat */
  1, /* warn_cannot_profile */
  0, /* warn_cast_align */
  0, /* warn_cast_function_type */
  0, /* warn_cast_qual */
  0, /* warn_cast_result */
  0, /* warn_catch_value */
  0, /* warn_char_subscripts */
  0, /* warn_character_truncation */
  1, /* warn_class_conversion */
  0, /* warn_class_memaccess */
  0, /* warn_clobbered */
  0, /* warn_comma_subscript */
  0, /* cpp_warn_comment */
  0, /* warn_compare_reals */
  0, /* warn_conditionally_supported */
  0, /* warn_conversion */
  0, /* warn_conversion_extra */
  1, /* warn_conversion_null */
  1, /* warn_coverage_mismatch */
  1, /* warn_cpp */
  0, /* warn_ctad_maybe_unsupported */
  0, /* warn_ctor_dtor_privacy */
  0, /* warn_dangling_else */
  0, /* cpp_warn_date_time */
  -1, /* warn_declaration_after_statement */
  1, /* warn_delete_incomplete */
  0, /* warn_delnonvdtor */
  1, /* warn_deprecated */
  0, /* warn_deprecated_copy */
  1, /* warn_deprecated_decl */
  0, /* warn_deprecated_enum_enum_conv */
  0, /* warn_deprecated_enum_float_conv */
  1, /* warn_designated_init */
  0, /* warn_disabled_optimization */
  1, /* warn_discarded_array_qualifiers */
  1, /* warn_discarded_qualifiers */
  1, /* warn_div_by_zero */
  0, /* warn_do_subscript */
  0, /* warn_double_promotion */
  0, /* warn_duplicate_decl_specifier */
  0, /* warn_duplicated_branches */
  0, /* warn_duplicated_cond */
  0, /* warn_ecpp */
  0, /* warn_empty_body */
  1, /* cpp_warn_endif_labels */
  -1, /* warn_enum_compare */
  0, /* warn_enum_conversion */
  0, /* warnings_are_errors */
  1, /* warn_exceptions */
  0, /* cpp_warn_expansion_to_defined */
  0, /* extra_warnings */
  0, /* warn_extra_semi */
  0, /* flag_fatal_errors */
  0, /* warn_float_conversion */
  0, /* warn_float_equal */
  0, /* warn_format_contains_nul */
  0, /* warn_format_diag */
  0, /* warn_format_extra_args */
  0, /* warn_format_nonliteral */
  0, /* warn_format_overflow */
  0, /* warn_format_security */
  0, /* warn_format_signedness */
  0, /* warn_format_trunc */
  0, /* warn_format_y2k */
  0, /* warn_format_zero_length */
  0, /* warn_format */
  0, /* warn_frame_address */
  HOST_WIDE_INT_MAX, /* warn_frame_larger_than_size */
  1, /* warn_free_nonheap_object */
  0, /* flag_warn_frontend_loop_interchange */
  0, /* warn_function_elimination */
  1, /* warn_if_not_aligned */
  1, /* warn_ignored_attributes */
  0, /* warn_ignored_qualifiers */
  0, /* warn_implicit */
  0, /* warn_implicit_fallthrough */
  -1, /* warn_implicit_function_declaration */
  -1, /* warn_implicit_int */
  0, /* warn_implicit_interface */
  0, /* warn_implicit_procedure */
  1, /* warn_inaccessible_base */
  1, /* warn_incompatible_pointer_types */
  1, /* warn_inh_var_ctor */
  1, /* warn_init_list */
  0, /* warn_init_self */
  0, /* warn_inline */
  1, /* warn_int_conversion */
  0, /* warn_int_in_bool_context */
  1, /* warn_int_to_pointer_cast */
  0, /* warn_integer_division */
  0, /* warn_intrinsic_shadow */
  0, /* warn_intrinsics_std */
  0, /* warn_imported_macros */
  1, /* warn_invalid_memory_model */
  1, /* warn_invalid_offsetof */
  0, /* cpp_warn_invalid_pch */
  0, /* warn_jump_misses_init */
  HOST_WIDE_INT_MAX, /* warn_larger_than_size */
  -1, /* warn_line_truncation */
  1, /* cpp_warn_literal_suffix */
  0, /* warn_logical_not_paren */
  0, /* warn_logical_op */
  -1, /* warn_long_long */
  1, /* warn_lto_type_mismatch */
  -1, /* warn_main */
  0, /* warn_maybe_uninitialized */
  0, /* warn_memset_elt_size */
  0, /* warn_memset_transposed_args */
  0, /* warn_misleading_indentation */
  0, /* warn_mismatched_alloc */
  0, /* warn_mismatched_new_delete */
  0, /* warn_mismatched_tags */
  0, /* warn_missing_attributes */
  0, /* warn_missing_braces */
  0, /* warn_missing_declarations */
  0, /* warn_missing_field_initializers */
  0, /* cpp_warn_missing_include_dirs */
  0, /* warn_missing_parameter_type */
  1, /* warn_missing_profile */
  0, /* warn_missing_prototypes */
  0, /* cpp_warn_multichar */
  0, /* warn_multiple_inheritance */
  0, /* warn_multistatement_macros */
  0, /* warn_namespaces */
  -1, /* warn_narrowing */
  0, /* warn_nested_externs */
  0, /* warn_noexcept */
  0, /* warn_noexcept_type */
  1, /* warn_nontemplate_friend */
  0, /* warn_nonvdtor */
  0, /* warn_nonnull */
  0, /* warn_nonnull_compare */
  normalized_C, /* cpp_warn_normalize */
  0, /* warn_null_dereference */
  1, /* warn_objc_root_class */
  1, /* warn_odr_violations */
  0, /* warn_old_style_cast */
  0, /* warn_old_style_declaration */
  -1, /* warn_old_style_definition */
  0, /* warn_openmp_simd */
  1, /* warn_overflow */
  0, /* warn_overlength_strings */
  0, /* warn_overloaded_virtual */
  0, /* warn_override_init */
  1, /* warn_override_init_side_effects */
  1, /* warn_overwrite_recursive */
  0, /* warn_packed */
  -1, /* warn_packed_bitfield_compat */
  0, /* warn_packed_not_aligned */
  0, /* warn_padded */
  0, /* warn_parentheses */
  0, /* pedantic */
  0, /* warn_pessimizing_move */
  -1, /* warn_placement_new */
  1, /* warn_pmf2ptr */
  0, /* warn_pointer_arith */
  1, /* warn_pointer_compare */
  0, /* warn_pointer_sign */
  1, /* warn_pointer_to_int_cast */
  1, /* flag_poison_system_directories */
  1, /* warn_pragmas */
  1, /* warn_prio_ctor_dtor */
  1, /* warn_property_assign_default */
  1, /* warn_protocol */
  1, /* warn_psabi */
  0, /* warn_range_loop_construct */
  0, /* warn_real_q_constant */
  0, /* warn_realloc_lhs */
  0, /* warn_realloc_lhs_all */
  0, /* warn_redundant_decls */
  0, /* warn_redundant_move */
  0, /* warn_redundant_tags */
  0, /* warn_register */
  0, /* warn_reorder */
  0, /* warn_restrict */
  1, /* warn_return_local_addr */
  -1, /* warn_return_type */
  1, /* warn_scalar_storage_order */
  0, /* warn_selector */
  0, /* warn_sequence_point */
  0, /* warn_shadow */
  1, /* warn_shadow_ivar */
  0, /* warn_shadow_compatible_local */
  0, /* warn_shadow_local */
  1, /* warn_shift_count_negative */
  1, /* warn_shift_count_overflow */
  -1, /* warn_shift_negative_value */
  -1, /* warn_shift_overflow */
  0, /* warn_sign_compare */
  0, /* warn_sign_conversion */
  0, /* warn_sign_promo */
  0, /* warn_sized_deallocation */
  1, /* warn_sizeof_array_argument */
  0, /* warn_sizeof_array_div */
  0, /* warn_sizeof_pointer_div */
  0, /* warn_sizeof_pointer_memaccess */
  0, /* warn_stack_protect */
  HOST_WIDE_INT_MAX, /* warn_stack_usage */
  0, /* warn_strict_aliasing */
  0, /* warn_strict_null_sentinel */
  0, /* warn_strict_overflow */
  0, /* warn_strict_prototypes */
  0, /* warn_strict_selector_match */
  0, /* warn_string_compare */
  2, /* warn_stringop_overflow */
  1, /* warn_stringop_overread */
  0, /* warn_stringop_truncation */
  1, /* warn_subobject_linkage */
  0, /* warn_suggest_attribute_cold */
  0, /* warn_suggest_attribute_const */
  0, /* warn_suggest_attribute_format */
  0, /* warn_suggest_attribute_malloc */
  0, /* warn_suggest_attribute_noreturn */
  0, /* warn_suggest_attribute_pure */
  0, /* warn_suggest_final_methods */
  0, /* warn_suggest_final_types */
  0, /* warn_override */
  0, /* warn_surprising */
  0, /* warn_switch */
  1, /* warn_switch_bool */
  0, /* warn_switch_default */
  0, /* warn_switch_enum */
  1, /* warn_switch_outside_range */
  1, /* warn_switch_unreachable */
  1, /* warn_sync_nand */
  0, /* warn_synth */
  0, /* warn_system_headers */
  0, /* warn_tabs */
  0, /* warn_target_lifetime */
  0, /* warn_tautological_compare */
  0, /* warn_templates */
  1, /* warn_terminate */
  0, /* warn_traditional */
  0, /* warn_traditional_conversion */
  0, /* warn_trampolines */
  2, /* cpp_warn_trigraphs */
  1, /* warn_tsan */
  0, /* warn_type_limits */
  0, /* warn_undeclared_selector */
  0, /* cpp_warn_undef */
  0, /* warn_undefined_do_loop */
  1, /* warn_underflow */
  0, /* warn_uninitialized */
  0, /* warn_unknown_pragmas */
  0, /* warn_unsuffixed_float_constants */
  0, /* warn_unused */
  0, /* warn_unused_but_set_parameter */
  0, /* warn_unused_but_set_variable */
  0, /* warn_unused_const_variable */
  0, /* warn_unused_dummy_argument */
  0, /* warn_unused_function */
  0, /* warn_unused_label */
  0, /* warn_unused_local_typedefs */
  0, /* cpp_warn_unused_macros */
  0, /* warn_unused_parameter */
  1, /* warn_unused_result */
  0, /* warn_unused_value */
  0, /* warn_unused_variable */
  0, /* warn_use_without_only */
  0, /* warn_useless_cast */
  1, /* warn_varargs */
  0, /* cpp_warn_variadic_macros */
  0, /* warn_vector_operation_performance */
  1, /* warn_vexing_parse */
  0, /* warn_virtual_inheritance */
  1, /* warn_virtual_move_assign */
  -1, /* warn_vla */
  HOST_WIDE_INT_MAX, /* warn_vla_limit */
  0, /* warn_vla_parameter */
  0, /* warn_volatile */
  0, /* warn_volatile_register_var */
  0, /* warn_write_strings */
  0, /* warn_zero_as_null_pointer_constant */
  0, /* warn_zero_length_bounds */
  0, /* warn_zerotrip */
  0, /* aux_info_file_name */
  0, /* flag_dump_callgraph */
  0, /* flag_lto_dump_defined */
  0, /* flag_lto_dump_demangle */
  0, /* flag_dump_body */
  0, /* flag_dump_level */
  0, /* dump_base_name */
  0, /* dump_base_ext */
  0, /* dump_dir_name */
  -1, /* flag_pic */
  -1, /* flag_pie */
  -1, /* flag_abi_compat_version */
  0, /* flag_abi_version */
  1, /* flag_access_control */
  0, /* ada_specs_parent */
  0, /* flag_aggressive_function_elimination */
  1, /* flag_aggressive_loop_optimizations */
  1, /* flag_align_commons */
  0, /* flag_align_functions */
  0, /* str_align_functions */
  0, /* flag_align_jumps */
  0, /* str_align_jumps */
  0, /* flag_align_labels */
  0, /* str_align_labels */
  0, /* flag_align_loops */
  0, /* str_align_loops */
  -1, /* aligned_new_threshold */
  0, /* flag_all_intrinsics */
  1, /* flag_allocation_dce */
  0, /* flag_allow_argument_mismatch */
  0, /* flag_allow_invalid_boz */
  0, /* flag_allow_leading_underscore */
  0, /* flag_allow_parameterless_variadic_functions */
  0, /* flag_store_data_races */
  0, /* flag_analyzer */
  0, /* flag_analyzer_call_summaries */
  0, /* flag_analyzer_checker */
  1, /* flag_analyzer_feasibility */
  0, /* flag_analyzer_fine_grained */
  0, /* flag_analyzer_show_duplicate_count */
  1, /* flag_analyzer_state_merge */
  1, /* flag_analyzer_state_purge */
  0, /* flag_analyzer_transitivity */
  0, /* flag_analyzer_verbose_edges */
  0, /* flag_analyzer_verbose_state_changes */
  2, /* analyzer_verbosity */
  0, /* common_deferred_options */
  0, /* flag_no_asm */
  0, /* flag_assert */
  0, /* flag_associative_math */
  1, /* flag_assume_phsa */
  0, /* flag_asynchronous_unwind_tables */
  1, /* flag_auto_inc_dec */
  0, /* flag_auto_profile */
  0, /* auto_profile_file */
  1, /* flag_automatic */
  0, /* flag_backslash */
  1, /* flag_backtrace */
  1, /* flag_bit_tests */
  30, /* flag_blas_matmul_limit */
  0, /* flag_bounds_check */
  0, /* flag_branch_on_count_reg */
  0, /* flag_branch_probabilities */
  0, /* flag_building_libgcc */
  0, /* flag_building_libphobos_tests */
  0, /* flag_no_builtin */
  0, /* flag_c_prototypes */
  0, /* flag_c_prototypes_external */
  0, /* flag_caller_saves */
  NO_CALLGRAPH_INFO, /* flag_callgraph_info */
  CF_NONE, /* flag_cf_protection */
  -1, /* flag_char8_t */
  0, /* flag_check_new */
  CHECKING_P ? ENABLE_EXTRA_CHECKING ? 2 : 1 : 0, /* flag_checking */
  GFC_FCOARRAY_NONE, /* flag_coarray */
  0, /* flag_code_hoisting */
  0, /* flag_combine_stack_adjustments */
  1, /* flag_no_common */
  0, /* flag_compare_debug */
  0, /* flag_compare_debug_opt */
  0, /* flag_compare_elim_after_reload */
  0, /* flag_concepts */
  1, /* concepts_diagnostics_max_depth */
  0, /* flag_concepts_ts */
  0, /* flag_conserve_stack */
  8, /* constexpr_cache_depth */
  512, /* max_constexpr_depth */
  262144, /* constexpr_loop_limit */
  33554432, /* constexpr_ops_limit */
  GFC_FLAG_CONVERT_NATIVE, /* flag_convert */
  0, /* flag_coroutines */
  0, /* flag_cprop_registers */
  0, /* flag_cray_pointer */
  0, /* flag_crossjumping */
  0, /* flag_cse_follow_jumps */
  0, /* flag_cx_fortran_rules */
  0, /* flag_cx_limited_range */
  0, /* flag_data_sections */
  0, /* flag_dbg_cnt_list */
  1, /* flag_dce */
  0, /* flag_debug_aux_vars */
  0, /* flag_debug_types_section */
  0, /* flag_dec */
  0, /* flag_dec_blank_format_item */
  0, /* flag_dec_char_conversions */
  0, /* flag_dec_format_defaults */
  0, /* flag_dec_include */
  0, /* flag_dec_intrinsic_ints */
  0, /* flag_dec_math */
  0, /* flag_dec_static */
  0, /* flag_dec_structure */
  -1, /* flag_declone_ctor_dtor */
  0, /* flag_default_double */
  0, /* flag_default_integer */
  0, /* flag_default_real_10 */
  0, /* flag_default_real_16 */
  0, /* flag_default_real_8 */
  0, /* flag_defer_pop */
  0, /* flag_delayed_branch */
  0, /* flag_delete_dead_exceptions */
  -1, /* flag_delete_null_pointer_checks */
  0, /* flag_devirtualize */
  0, /* flag_ltrans_devirtualize */
  0, /* flag_devirtualize_speculatively */
  DIAGNOSTICS_COLOR_NO, /* flag_diagnostics_show_color */
  0, /* flag_diagnostics_generate_patch */
  6, /* diagnostics_minimum_margin_width */
  0, /* flag_diagnostics_parseable_fixits */
  DPF_INLINE_EVENTS, /* flag_diagnostics_path_format */
  1, /* flag_diagnostics_show_caret */
  1, /* flag_diagnostics_show_cwe */
  1, /* flag_diagnostics_show_labels */
  1, /* flag_diagnostics_show_line_numbers */
  1, /* flag_diagnostics_show_option */
  0, /* flag_diagnostics_show_path_depths */
  0, /* flag_diagnostics_show_template_tree */
  DIAGNOSTICS_URL_AUTO, /* flag_diagnostics_show_urls */
  0, /* flag_dollar_ok */
  0, /* flag_dse */
  0, /* flag_dump_ada_spec */
  0, /* flag_dump_ada_spec_slim */
  0, /* flag_dump_analyzer */
  0, /* flag_dump_analyzer_callgraph */
  0, /* flag_dump_analyzer_exploded_graph */
  0, /* flag_dump_analyzer_exploded_nodes */
  0, /* flag_dump_analyzer_exploded_nodes_2 */
  0, /* flag_dump_analyzer_exploded_nodes_3 */
  0, /* flag_dump_analyzer_feasibility */
  0, /* flag_dump_analyzer_json */
  0, /* flag_dump_analyzer_state_purge */
  0, /* flag_dump_analyzer_stderr */
  0, /* flag_dump_analyzer_supergraph */
  0, /* flag_dump_final_insns */
  0, /* flag_dump_fortran_global */
  0, /* flag_dump_fortran_optimized */
  0, /* flag_dump_fortran_original */
  0, /* flag_dump_go_spec */
  0, /* flag_dump_locations */
  0, /* flag_dump_noaddr */
  0, /* flag_dump_passes */
  0, /* flag_dump_scos */
  0, /* flag_dump_unnumbered */
  0, /* flag_dump_unnumbered_links */
  HAVE_GAS_CFI_DIRECTIVE, /* flag_dwarf2_cfi_asm */
  1, /* flag_early_inlining */
  1, /* flag_elide_constructors */
  1, /* flag_elide_type */
  1, /* flag_debug_only_used_symbols */
  1, /* flag_eliminate_unused_debug_types */
  0, /* flag_emit_class_debug_always */
  1, /* flag_enforce_eh_specs */
  0, /* flag_exceptions */
  EXCESS_PRECISION_DEFAULT, /* flag_excess_precision */
  0, /* flag_expensive_optimizations */
  1, /* flag_ext_numeric_literals */
  -1, /* flag_extern_tls_init */
  0, /* flag_external_blas */
  0, /* flag_f2c */
  0, /* flag_fat_lto_objects */
  0, /* flag_finite_loops */
  0, /* flag_finite_math_only */
  72, /* flag_fixed_line_length */
  0, /* flag_float_store */
  0, /* flag_forward_propagate */
  FP_CONTRACT_FAST, /* flag_fp_contract_mode */
  1, /* flag_fp_int_builtin_inexact */
  132, /* flag_free_line_length */
  -1, /* flag_frontend_loop_interchange */
  -1, /* flag_frontend_optimize */
  0, /* flag_no_function_cse */
  0, /* flag_function_sections */
  0, /* flag_gcse */
  0, /* flag_gcse_after_reload */
  0, /* flag_gcse_las */
  1, /* flag_gcse_lm */
  0, /* flag_gcse_sm */
  0, /* flag_gimple */
  0, /* flag_no_gnu_keywords */
  NEXT_OBJC_RUNTIME, /* flag_next_runtime */
  0, /* flag_tm */
  1, /* flag_gnu_unique */
  -1, /* flag_gnu89_inline */
  1, /* go_check_divide_overflow */
  1, /* go_check_divide_zero */
  0, /* go_compiling_runtime */
  0, /* go_debug_escape_level */
  0, /* go_debug_escape_hash */
  0, /* go_debug_optimization */
  0, /* flag_graphite */
  0, /* flag_graphite_identity */
  0, /* flag_guess_branch_prob */
  0, /* flag_hoist_adjacent_loads */
  0, /* flag_no_ident */
  0, /* flag_if_conversion */
  0, /* flag_if_conversion2 */
  1, /* flag_implement_inlines */
  1, /* flag_implicit_inline_templates */
  0, /* flag_implicit_none */
  1, /* flag_implicit_templates */
  0, /* flag_indirect_inlining */
  0, /* flag_inhibit_size_directive */
  0, /* flag_init_derived */
  GFC_INIT_REAL_OFF, /* flag_init_real */
  0, /* flag_no_inline */
  -1, /* flag_inline_arg_packing */
  1, /* flag_inline_atomics */
  0, /* flag_inline_functions */
  0, /* flag_inline_functions_called_once */
  -1, /* flag_inline_matmul_limit */
  0, /* flag_inline_small_functions */
  0, /* flag_instrument_function_entry_exit */
  0, /* flag_integer4_kind */
  0, /* flag_invariants */
  0, /* flag_ipa_bit_cp */
  0, /* flag_ipa_cp */
  0, /* flag_ipa_cp_clone */
  0, /* flag_ipa_icf */
  0, /* flag_ipa_icf_functions */
  0, /* flag_ipa_icf_variables */
  0, /* flag_ipa_modref */
  0, /* flag_ipa_profile */
  0, /* flag_ipa_pta */
  0, /* flag_ipa_pure_const */
  0, /* flag_ipa_ra */
  0, /* flag_ipa_reference */
  0, /* flag_ipa_reference_addressable */
  0, /* flag_ipa_sra */
  1, /* flag_ipa_stack_alignment */
  0, /* flag_ipa_vrp */
  IRA_ALGORITHM_CB, /* flag_ira_algorithm */
  1, /* flag_ira_hoist_pressure */
  0, /* flag_ira_loop_pressure */
  IRA_REGION_AUTODETECT, /* flag_ira_region */
  1, /* flag_ira_share_save_slots */
  1, /* flag_ira_share_spill_slots */
  5, /* flag_ira_verbose */
  0, /* flag_isolate_erroneous_paths_attribute */
  0, /* flag_isolate_erroneous_paths_dereference */
  IVAR_VISIBILITY_PROTECTED, /* default_ivar_visibility */
  1, /* flag_ivopts */
  1, /* flag_jump_tables */
  0, /* flag_keep_gc_roots_live */
  1, /* flag_keep_inline_dllexport */
  0, /* flag_keep_inline_functions */
  1, /* flag_keep_static_consts */
  0, /* flag_keep_static_functions */
  0, /* note_include_translate_yes */
  0, /* note_include_translate_no */
  0, /* note_module_cmi_yes */
  0, /* flag_large_source_files */
  0, /* flag_lax_vector_conversions */
  -1, /* flag_leading_underscore */
  2, /* flag_lifetime_dse */
  0, /* flag_limit_function_alignment */
  LTO_LINKER_OUTPUT_UNKNOWN, /* flag_lto_linker_output */
  LIVE_PATCHING_NONE, /* flag_live_patching */
  0, /* flag_live_range_shrinkage */
  1, /* flag_local_ivars */
  0, /* flag_loop_interchange */
  0, /* flag_loop_nest_optimize */
  0, /* flag_loop_parallelize_all */
  0, /* flag_unroll_jam */
  0, /* flag_lra_remat */
  -1, /* flag_lto_compression_level */
  LTO_PARTITION_BALANCED, /* flag_lto_partition */
  0, /* flag_lto_report */
  0, /* flag_lto_report_wpa */
  0, /* flag_lto */
  0, /* flag_ltrans */
  0, /* ltrans_output_list */
  1, /* flag_errno_math */
  65535, /* flag_max_array_constructor */
  0, /* flag_max_errors */
  -2, /* flag_max_stack_var_size */
  0, /* flag_max_subrecord_length */
  0, /* mem_report */
  0, /* mem_report_wpa */
  1, /* flag_merge_constants */
  1, /* flag_merge_debug_strings */
  0, /* flag_header_unit */
  0, /* flag_module_implicit_inline */
  1, /* flag_module_lazy */
  0, /* flag_module_only */
  0, /* flag_module_private */
  0, /* flag_module_version_ignore */
  0, /* flag_moduleinfo */
  0, /* flag_modules */
  0, /* flag_modulo_sched */
  0, /* flag_modulo_sched_allow_regmoves */
  0, /* flag_move_loop_invariants */
  0, /* flag_ms_extensions */
  1, /* flag_new_inheriting_ctors */
  0, /* flag_new_ttp */
  1, /* flag_nil_receivers */
  0, /* flag_non_call_exceptions */
  0, /* flag_no_nonansi_builtin */
  0, /* flag_nothrow_opt */
  0, /* flag_objc_abi */
  0, /* flag_objc_call_cxx_cdtors */
  0, /* flag_objc_direct_dispatch */
  0, /* flag_objc_exceptions */
  0, /* flag_objc_gc */
  0, /* flag_objc_nilcheck */
  -1, /* flag_objc_sjlj_exceptions */
  0, /* flag_objc1_only */
  OFFLOAD_ABI_UNSET, /* flag_offload_abi */
  0, /* flag_omit_frame_pointer */
  0, /* flag_openacc */
  0, /* flag_openacc_dims */
  0, /* flag_openmp */
  0, /* flag_openmp_simd */
  0, /* flag_opt_info */
  0, /* flag_optimize_sibling_calls */
  0, /* flag_optimize_strlen */
  0, /* flag_pack_derived */
  0, /* flag_pack_struct */
  1, /* flag_pad_source */
  0, /* flag_partial_inlining */
  0, /* flag_patchable_function_entry */
  DEFAULT_PCC_STRUCT_RETURN, /* flag_pcc_struct_return */
  0, /* flag_peel_loops */
  0, /* flag_no_peephole */
  0, /* flag_peephole2 */
  0, /* flag_permissive */
  PERMITTED_FLT_EVAL_METHODS_DEFAULT, /* flag_permitted_flt_eval_methods */
  0, /* flag_plan9_extensions */
  1, /* flag_plt */
  0, /* post_ipa_mem_report */
  0, /* flag_postconditions */
  0, /* flag_pre_include */
  0, /* pre_ipa_mem_report */
  0, /* flag_preconditions */
  0, /* flag_predictive_commoning */
  -1, /* flag_prefetch_loop_arrays */
  1, /* flag_pretty_templates */
  1, /* flag_printf_return_value */
  0, /* profile_flag */
  0, /* profile_abs_path_flag */
  0, /* profile_arc_flag */
  0, /* flag_profile_correction */
  0, /* profile_data_prefix */
  0, /* flag_profile_exclude_files */
  0, /* flag_profile_filter_files */
  0, /* profile_info_section */
  0, /* profile_note_location */
  0, /* flag_profile_partial_training */
  0, /* profile_prefix_path */
  0, /* flag_profile_reorder_functions */
  0, /* profile_report */
  PROFILE_REPRODUCIBILITY_SERIAL, /* flag_profile_reproducible */
  PROFILE_UPDATE_SINGLE, /* flag_profile_update */
  0, /* flag_profile_use */
  0, /* flag_profile_values */
  -1, /* flag_protect_parens */
  1, /* flag_range_check */
  0, /* flag_real4_kind */
  0, /* flag_real8_kind */
  -1, /* flag_realloc_lhs */
  0, /* flag_reciprocal_math */
  0, /* flag_record_gcc_switches */
  0, /* flag_record_marker */
  0, /* flag_recursive */
  0, /* flag_ree */
  2, /* flag_rename_registers */
  0, /* flag_reorder_blocks */
  REORDER_BLOCKS_ALGORITHM_SIMPLE, /* flag_reorder_blocks_algorithm */
  0, /* flag_reorder_blocks_and_partition */
  0, /* flag_reorder_functions */
  0, /* flag_repack_arrays */
  0, /* flag_replace_objc_classes */
  0, /* flag_report_bug */
  1, /* go_require_return_statement */
  0, /* flag_rerun_cse_after_loop */
  0, /* flag_resched_modulo_sched */
  0, /* flag_rounding_math */
  1, /* flag_rtti */
  0, /* flag_sanitize_address_use_after_scope */
  0, /* flag_sanitize_undefined_trap_on_error */
  0, /* flag_save_optimization_record */
  1, /* flag_sched_critical_path_heuristic */
  1, /* flag_sched_dep_count_heuristic */
  1, /* flag_sched_group_heuristic */
  1, /* flag_schedule_interblock */
  1, /* flag_sched_last_insn_heuristic */
  0, /* flag_sched_pressure */
  1, /* flag_sched_rank_heuristic */
  1, /* flag_schedule_speculative */
  1, /* flag_sched_spec_insn_heuristic */
  0, /* flag_schedule_speculative_load */
  0, /* flag_schedule_speculative_load_dangerous */
  0, /* flag_sched_stalled_insns */
  1, /* flag_sched_stalled_insns_dep */
  1, /* sched_verbose_param */
  0, /* flag_sched2_use_superblocks */
  2, /* flag_schedule_fusion */
  0, /* flag_schedule_insns */
  0, /* flag_schedule_insns_after_reload */
  -1, /* flag_second_underscore */
  0, /* flag_section_anchors */
  0, /* flag_sel_sched_pipelining */
  0, /* flag_sel_sched_pipelining_outer_loops */
  0, /* flag_sel_sched_reschedule_pipelined */
  0, /* flag_selective_scheduling */
  0, /* flag_selective_scheduling2 */
  0, /* flag_self_test */
  1, /* flag_semantic_interposition */
  0, /* flag_short_enums */
  0, /* flag_short_wchar */
  1, /* flag_show_column */
  0, /* flag_shrink_wrap */
  1, /* flag_shrink_wrap_separate */
  1, /* flag_sign_zero */
  0, /* flag_signaling_nans */
  1, /* flag_signed_bitfields */
  0, /* flag_signed_char */
  1, /* flag_signed_zeros */
  VECT_COST_MODEL_UNLIMITED, /* flag_simd_cost_model */
  0, /* flag_single_precision_constant */
  -1, /* flag_sized_deallocation */
  1, /* flag_split_ivs_in_unroller */
  0, /* flag_split_loops */
  0, /* flag_split_paths */
  -1, /* flag_split_stack */
  0, /* flag_split_wide_types */
  0, /* flag_split_wide_types_early */
  1, /* flag_ssa_backprop */
  0, /* flag_ssa_phiopt */
  SSO_NATIVE, /* default_sso */
  -1, /* flag_stack_arrays */
  0, /* flag_stack_clash_protection */
  -1, /* flag_stack_protect */
  SR_ALL, /* flag_stack_reuse */
  0, /* flag_stack_usage */
  0, /* flag_detailed_statistics */
  1, /* flag_stdarg_opt */
  0, /* flag_store_merging */
  0, /* flag_strict_aliasing */
  0, /* flag_strict_enums */
  -1, /* flag_strict_volatile_bitfields */
  -1, /* flag_strong_eval_order */
  0, /* flag_switch_errors */
  1, /* flag_sync_libcalls */
  0, /* flag_syntax_only */
  1, /* flag_tail_call_workaround */
  10, /* template_backtrace_limit */
  0, /* flag_test_coverage */
  0, /* flag_test_forall_temp */
  0, /* flag_thread_jumps */
  1, /* flag_threadsafe_statics */
  0, /* time_report */
  0, /* time_report_details */
  TLS_MODEL_GLOBAL_DYNAMIC, /* flag_tls_default */
  2, /* flag_toplevel_reorder */
  0, /* flag_tracer */
  0, /* flag_trampolines */
  1, /* flag_trapping_math */
  0, /* flag_trapv */
  0, /* flag_tree_bit_ccp */
  0, /* flag_tree_builtin_call_dce */
  0, /* flag_tree_ccp */
  0, /* flag_tree_ch */
  0, /* flag_tree_coalesce_vars */
  0, /* flag_tree_copy_prop */
  2, /* flag_tree_cselim */
  0, /* flag_tree_dce */
  0, /* flag_tree_dom */
  0, /* flag_tree_dse */
  1, /* flag_tree_forwprop */
  0, /* flag_tree_fre */
  0, /* flag_tree_loop_distribute_patterns */
  0, /* flag_tree_loop_distribution */
  -1, /* flag_tree_loop_if_convert */
  1, /* flag_tree_loop_im */
  1, /* flag_tree_loop_ivcanon */
  1, /* flag_tree_loop_optimize */
  0, /* flag_tree_loop_vectorize */
  0, /* flag_tree_live_range_split */
  1, /* flag_tree_parallelize_loops */
  0, /* flag_tree_partial_pre */
  1, /* flag_tree_phiprop */
  0, /* flag_tree_pre */
  0, /* flag_tree_pta */
  1, /* flag_tree_reassoc */
  1, /* flag_tree_scev_cprop */
  0, /* flag_tree_sink */
  0, /* flag_tree_slp_vectorize */
  0, /* flag_tree_slsr */
  0, /* flag_tree_sra */
  0, /* flag_tree_switch_conversion */
  0, /* flag_tree_tail_merge */
  0, /* flag_tree_ter */
  0, /* flag_tree_vrp */
  0, /* flag_unconstrained_commons */
  1, /* flag_underscoring */
  1, /* flag_unit_at_a_time */
  0, /* flag_unroll_all_loops */
  0, /* flag_cunroll_grow_size */
  0, /* flag_unroll_loops */
  0, /* flag_unsafe_math_optimizations */
  0, /* flag_unswitch_loops */
  0, /* flag_unwind_tables */
  DEFAULT_USE_CXA_ATEXIT, /* flag_use_cxa_atexit */
  2, /* flag_use_cxa_get_exception_ptr */
  0, /* flag_use_linker_plugin */
  2, /* flag_var_tracking */
  2, /* flag_var_tracking_assignments */
  0, /* flag_var_tracking_assignments_toggle */
  0, /* flag_var_tracking_uninit */
  0, /* flag_variable_expansion_in_unroller */
  VECT_COST_MODEL_DEFAULT, /* flag_vect_cost_model */
  0, /* flag_verbose_asm */
  0, /* flag_version_loops_for_strides */
  0, /* flag_visibility_ms_compat */
  VISIBILITY_DEFAULT, /* default_visibility */
  0, /* flag_value_profile_transformations */
  VTV_NO_PRIORITY, /* flag_vtable_verify */
  0, /* flag_vtv_counts */
  0, /* flag_vtv_debug */
  1, /* flag_weak */
  1, /* flag_weak_templates */
  2, /* flag_web */
  0, /* flag_whole_program */
  -1, /* flag_working_directory */
  0, /* flag_wpa */
  0, /* flag_wrapv */
  0, /* flag_wrapv_pointer */
  1, /* flag_zero_initialized_in_bss */
  0, /* flag_zero_link */
  2, /* dwarf2out_as_loc_support */
  2, /* dwarf2out_as_locview_support */
  1, /* debug_column_info */
  0, /* flag_describe_dies */
  5, /* dwarf_version */
  4, /* dwarf_offset_size */
  0, /* flag_gen_declaration */
  -1, /* debug_generate_pub_sections */
  0, /* flag_lto_gimple_stats */
  2, /* debug_inline_points */
  2, /* debug_internal_reset_location_views */
  1, /* dwarf_record_gcc_switches */
  0, /* dwarf_split_debug_info */
  2, /* debug_nonbind_markers_p */
  0, /* dwarf_strict */
  0, /* flag_gtoggle */
  2, /* debug_variable_location_views */
  0, /* flag_lto_dump_tool_help */
  0, /* imultiarch */
  0, /* plugindir_string */
  0, /* flag_lto_dump_list */
  ARM_DEFAULT_ABI, /* arm_abi */
  ANDROID_DEFAULT ? OPTION_MASK_ANDROID : 0, /* flag_android */
  0, /* arm_arch_string */
  0, /* inline_asm_unified */
  DEFAULT_LIBC, /* linux_libc */
  -1, /* arm_branch_cost */
  0, /* use_cmse */
  0, /* arm_cpu_string */
  2, /* fix_vlldm */
  2, /* fix_cm3_ldrd */
  0, /* TARGET_FLIP_THUMB */
  TARGET_DEFAULT_FLOAT_ABI, /* arm_float_abi */
  ARM_FP16_FORMAT_NONE, /* arm_fp16_format */
  TARGET_FPU_auto, /* arm_fpu_index */
  TARGET_DEFAULT_PIC_DATA_IS_TEXT_RELATIVE, /* arm_pic_data_is_text_relative */
  0, /* arm_pic_register_string */
  0, /* print_tune_info */
  0, /* target_pure_code */
  2, /* arm_restrict_it */
  0, /* target_slow_flash_data */
  DEFAULT_STRUCTURE_SIZE_BOUNDARY, /* arm_structure_size_boundary */
  TLS_GNU, /* target_tls_dialect */
  TP_AUTO, /* target_thread_pointer */
  0, /* arm_tune_string */
  2, /* unaligned_access */
  0, /* arm_verbose_cost */
  TARGET_DEFAULT_WORD_RELOCATIONS, /* target_word_relocations */
  0, /* flag_lto_name_sort */
  0, /* asm_file_name */
  0, /* flag_lto_dump_objects */
  0, /* pass_exit_codes */
  0, /* flag_pedantic_errors */
  0, /* use_pipes */
  0, /* print_file_name */
  0, /* print_multi_directory */
  0, /* print_multi_lib */
  0, /* print_multi_os_directory */
  0, /* print_multiarch */
  0, /* print_prog_name */
  0, /* print_search_dirs */
  0, /* print_sysroot */
  0, /* print_sysroot_headers_suffix */
  0, /* flag_lto_print_value */
  0, /* quiet_flag */
  0, /* flag_lto_reverse_sort */
  0, /* flag_lto_size_sort */
  1, /* flag_stdlib_kind */
  0, /* flag_lto_dump_symbol */
  0, /* report_times */
  0, /* flag_lto_tree_stats */
  0, /* flag_lto_dump_type_stats */
  0, /* flag_undef */
  0, /* verbose_flag */
  0, /* version_flag */
  0, /* inhibit_warnings */
  0, /* wrapper_string */
  0, /* VAR_mlibarch_ (private state) */
#undef x_VAR_mlibarch_
  0, /* VAR_mneon_for_64bits (private state) */
#undef x_VAR_mneon_for_64bits
  false, /* frontend_set_flag_associative_math */
  false, /* frontend_set_flag_cx_limited_range */
  false, /* frontend_set_flag_excess_precision */
  false, /* frontend_set_flag_finite_math_only */
  false, /* frontend_set_flag_errno_math */
  false, /* frontend_set_flag_reciprocal_math */
  false, /* frontend_set_flag_rounding_math */
  false, /* frontend_set_flag_signaling_nans */
  false, /* frontend_set_flag_signed_zeros */
  false, /* frontend_set_flag_trapping_math */
  false, /* frontend_set_flag_unsafe_math_optimizations */
};

struct gcc_options global_options;
struct gcc_options global_options_set;

const char * const lang_names[] =
{
  "Ada",
  "AdaSCIL",
  "AdaWhy",
  "BRIG",
  "C",
  "C++",
  "D",
  "Fortran",
  "Go",
  "LTO",
  "LTODump",
  "ObjC",
  "ObjC++",
  0
};

const unsigned int cl_options_count = N_OPTS;

#if (1U << 13) > CL_MIN_OPTION_CLASS
  #error the number of languages exceeds the implementation limit
#endif
const unsigned int cl_lang_count = 13;

const struct cl_option cl_options[] =
{
 /* [0] = */ {
    "-###",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 3, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1] = */ {
    "--all-warnings",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wall, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [2] = */ {
    "--ansi",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_ansi, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [3] = */ {
    "--assemble",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_S, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [4] = */ {
    "--assert",
    NULL,
    "assertion missing after %qs",
    NULL,
    NULL, NULL, OPT_A, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [5] = */ {
    "--assert=",
    NULL,
    "assertion missing after %qs",
    NULL,
    NULL, NULL, OPT_A, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [6] = */ {
    "--comments",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_C, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [7] = */ {
    "--comments-in-macros",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_CC, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [8] = */ {
    "--compile",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_c, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [9] = */ {
    "--completion=",
    "Provide bash completion for options starting with provided string.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [10] = */ {
    "--coverage",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_coverage, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [11] = */ {
    "--debug",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_g, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [12] = */ {
    "--define-macro",
    NULL,
    "macro name missing after %qs",
    NULL,
    NULL, NULL, OPT_D, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [13] = */ {
    "--define-macro=",
    NULL,
    "macro name missing after %qs",
    NULL,
    NULL, NULL, OPT_D, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [14] = */ {
    "--dependencies",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_M, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [15] = */ {
    "--dump",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_d, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_BRIG | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [16] = */ {
    "--dump=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_d, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_BRIG | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [17] = */ {
    "--dumpbase",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_dumpbase, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [18] = */ {
    "--dumpbase-ext",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_dumpbase_ext, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [19] = */ {
    "--dumpdir",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_dumpdir, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [20] = */ {
    "--entry",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_e, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [21] = */ {
    "--entry=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_e, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [22] = */ {
    "--extra-warnings",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wextra, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [23] = */ {
    "--for-assembler",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Xassembler, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [24] = */ {
    "--for-assembler=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Xassembler, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [25] = */ {
    "--for-linker",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Xlinker, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [26] = */ {
    "--for-linker=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Xlinker, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [27] = */ {
    "--force-link",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_u, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [28] = */ {
    "--force-link=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_u, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [29] = */ {
    "--help",
    "Display this information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_help_flag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [30] = */ {
    "--help=",
    "--help=<class>	Display descriptions of a specific class of options.  <class> is one or more of optimizers, target, warnings, undocumented, params.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [31] = */ {
    "--imacros",
    NULL,
    "missing filename after %qs",
    NULL,
    NULL, NULL, OPT_imacros, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [32] = */ {
    "--imacros=",
    NULL,
    "missing filename after %qs",
    NULL,
    NULL, NULL, OPT_imacros, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [33] = */ {
    "--include",
    NULL,
    "missing filename after %qs",
    NULL,
    NULL, NULL, OPT_include, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [34] = */ {
    "--include-barrier",
    NULL,
    NULL,
    NULL,
    "-", NULL, OPT_I, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [35] = */ {
    "--include-directory",
    NULL,
    "missing path after %qs",
    NULL,
    NULL, NULL, OPT_I, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [36] = */ {
    "--include-directory-after",
    NULL,
    "missing path after %qs",
    NULL,
    NULL, NULL, OPT_idirafter, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [37] = */ {
    "--include-directory-after=",
    NULL,
    "missing path after %qs",
    NULL,
    NULL, NULL, OPT_idirafter, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [38] = */ {
    "--include-directory=",
    NULL,
    "missing path after %qs",
    NULL,
    NULL, NULL, OPT_I, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [39] = */ {
    "--include-prefix",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_iprefix, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [40] = */ {
    "--include-prefix=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_iprefix, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [41] = */ {
    "--include-with-prefix",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_iwithprefix, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [42] = */ {
    "--include-with-prefix-after",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_iwithprefix, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [43] = */ {
    "--include-with-prefix-after=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_iwithprefix, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [44] = */ {
    "--include-with-prefix-before",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_iwithprefixbefore, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [45] = */ {
    "--include-with-prefix-before=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_iwithprefixbefore, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [46] = */ {
    "--include-with-prefix=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_iwithprefix, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [47] = */ {
    "--include=",
    NULL,
    "missing filename after %qs",
    NULL,
    NULL, NULL, OPT_include, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [48] = */ {
    "--language",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_x, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [49] = */ {
    "--language=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_x, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [50] = */ {
    "--library-directory",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_L, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [51] = */ {
    "--library-directory=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_L, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [52] = */ {
    "--no-canonical-prefixes",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_no_canonical_prefixes, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [53] = */ {
    "--no-integrated-cpp",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_no_integrated_cpp, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [54] = */ {
    "--no-line-commands",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_P, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [55] = */ {
    "--no-standard-includes",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_nostdinc, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [56] = */ {
    "--no-standard-libraries",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_nostdlib, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [57] = */ {
    "--no-sysroot-suffix",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_no_sysroot_suffix), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [58] = */ {
    "--no-warnings",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_w, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [59] = */ {
    "--optimize",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_O, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [60] = */ {
    "--output",
    NULL,
    "missing filename after %qs",
    NULL,
    NULL, NULL, OPT_o, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [61] = */ {
    "--output-pch=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [62] = */ {
    "--output=",
    NULL,
    "missing filename after %qs",
    NULL,
    NULL, NULL, OPT_o, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_BRIG | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [63] = */ {
    "--param=align-loop-iterations=",
    "Loops iterating at least selected number of iterations will get loop alignment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_align_loop_iterations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [64] = */ {
    "--param=align-threshold=",
    "Select fraction of the maximal frequency of executions of basic block in function given basic block get alignment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_align_threshold), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [65] = */ {
    "--param=analyzer-bb-explosion-factor=",
    "The maximum number of 'after supernode' exploded nodes within the analyzer per supernode, before terminating analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 36, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_analyzer_bb_explosion_factor), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [66] = */ {
    "--param=analyzer-max-constraints=",
    "The maximum number of constraints per state.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_analyzer_max_constraints), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [67] = */ {
    "--param=analyzer-max-enodes-for-full-dump=",
    "The maximum depth of exploded nodes that should appear in a dot dump before switching to a less verbose format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 41, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_analyzer_max_enodes_for_full_dump), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [68] = */ {
    "--param=analyzer-max-enodes-per-program-point=",
    "The maximum number of exploded nodes per program point within the analyzer, before terminating analysis of that point.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 45, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_analyzer_max_enodes_per_program_point), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [69] = */ {
    "--param=analyzer-max-infeasible-edges=",
    "The maximum number of infeasible edges to reject before declaring a diagnostic as infeasible.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_analyzer_max_infeasible_edges), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [70] = */ {
    "--param=analyzer-max-recursion-depth=",
    "The maximum number of times a callsite can appear in a call stack within the analyzer, before terminating analysis of a call that would recurse deeper.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 36, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_analyzer_max_recursion_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [71] = */ {
    "--param=analyzer-max-svalue-depth=",
    "The maximum depth of a symbolic value, before approximating the value as unknown.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_analyzer_max_svalue_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [72] = */ {
    "--param=analyzer-min-snodes-for-call-summary=",
    "The minimum number of supernodes within a function for the analyzer to consider summarizing its effects at call sites.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 44, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_analyzer_min_snodes_for_call_summary), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [73] = */ {
    "--param=asan-globals=",
    "Enable asan globals protection.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_asan_globals), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [74] = */ {
    "--param=asan-instrument-allocas=",
    "Enable asan allocas/VLAs protection.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_asan_protect_allocas), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [75] = */ {
    "--param=asan-instrument-reads=",
    "Enable asan load operations protection.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_asan_instrument_reads), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [76] = */ {
    "--param=asan-instrument-writes=",
    "Enable asan store operations protection.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_asan_instrument_writes), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [77] = */ {
    "--param=asan-instrumentation-with-call-threshold=",
    "Use callbacks instead of inline code if number of accesses in function becomes greater or equal to this number.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 48, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_asan_instrumentation_with_call_threshold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [78] = */ {
    "--param=asan-memintrin=",
    "Enable asan builtin functions protection.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_asan_memintrin), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [79] = */ {
    "--param=asan-stack=",
    "Enable asan stack protection.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_asan_stack), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [80] = */ {
    "--param=asan-use-after-return=",
    "Enable asan detection of use-after-return bugs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_asan_use_after_return), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [81] = */ {
    "--param=avg-loop-niter=",
    "Average number of iterations of a loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_avg_loop_niter), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [82] = */ {
    "--param=avoid-fma-max-bits=",
    "Maximum number of bits for which we avoid creating FMAs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_avoid_fma_max_bits), 0, CLVC_BOOLEAN, 0, 0, 512 },
 /* [83] = */ {
    "--param=builtin-expect-probability=",
    "Set the estimated probability in percentage for builtin expect. The default value is 90% probability.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_builtin_expect_probability), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [84] = */ {
    "--param=builtin-string-cmp-inline-length=",
    "The maximum length of a constant string for a builtin string cmp call eligible for inlining. The default value is 3.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_builtin_string_cmp_inline_length), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [85] = */ {
    "--param=case-values-threshold=",
    "The smallest number of different values for which it is best to use a jump-table instead of a tree of conditional branches, if 0, use the default for the machine.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_case_values_threshold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [86] = */ {
    "--param=comdat-sharing-probability=",
    "Probability that COMDAT function will be shared with different compilation unit.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_comdat_sharing_probability), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [87] = */ {
    "--param=cxx-max-namespaces-for-diagnostic-help=",
    "Maximum number of namespaces to search for alternatives when name lookup fails.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 46, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_cxx_max_namespaces_for_diagnostic_help), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [88] = */ {
    "--param=dse-max-alias-queries-per-store=",
    "Maximum number of queries into the alias oracle per store.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_dse_max_alias_queries_per_store), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [89] = */ {
    "--param=dse-max-object-size=",
    "Maximum size (in bytes) of objects tracked bytewise by dead store elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_dse_max_object_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [90] = */ {
    "--param=early-inlining-insns=",
    "Maximal estimated growth of function body caused by early inlining of single call.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_early_inlining_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [91] = */ {
    "--param=evrp-mode=",
    "--param=evrp-mode=[legacy|ranger|legacy-first|ranger-first|ranger-trace|ranger-debug|trace|debug] Specifies the mode Early VRP should operate in.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_param_evrp_mode), 18, CLVC_ENUM, 0, -1, -1 },
 /* [92] = */ {
    "--param=evrp-sparse-threshold=",
    "Maximum number of basic blocks before EVRP uses a sparse cache.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_evrp_sparse_threshold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [93] = */ {
    "--param=fsm-maximum-phi-arguments=",
    "Maximum number of arguments a PHI may have before the FSM threader will not try to thread through its block.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_fsm_maximum_phi_arguments), 0, CLVC_BOOLEAN, 0, 1, 999999 },
 /* [94] = */ {
    "--param=fsm-scale-path-blocks=",
    "Scale factor to apply to the number of blocks in a threading path when comparing to the number of (scaled) statements.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_fsm_scale_path_blocks), 0, CLVC_BOOLEAN, 0, 1, 10 },
 /* [95] = */ {
    "--param=fsm-scale-path-stmts=",
    "Scale factor to apply to the number of statements in a threading path when comparing to the number of (scaled) blocks.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_fsm_scale_path_stmts), 0, CLVC_BOOLEAN, 0, 1, 10 },
 /* [96] = */ {
    "--param=gcse-after-reload-critical-fraction=",
    "The threshold ratio of critical edges execution count that permit performing redundancy elimination after reload.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 43, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_gcse_after_reload_critical_fraction), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [97] = */ {
    "--param=gcse-after-reload-partial-fraction=",
    "The threshold ratio for performing partial redundancy elimination after reload.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 42, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_gcse_after_reload_partial_fraction), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [98] = */ {
    "--param=gcse-cost-distance-ratio=",
    "Scaling factor in calculation of maximum distance an expression can be moved by GCSE optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_gcse_cost_distance_ratio), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [99] = */ {
    "--param=gcse-unrestricted-cost=",
    "Cost at which GCSE optimizations will not constraint the distance an expression can travel.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_gcse_unrestricted_cost), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [100] = */ {
    "--param=ggc-min-expand=",
    "Minimum heap expansion to trigger garbage collection, as a percentage of the total size of the heap.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ggc_min_expand), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [101] = */ {
    "--param=ggc-min-heapsize=",
    "Minimum heap size before we start collecting garbage, in kilobytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ggc_min_heapsize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [102] = */ {
    "--param=gimple-fe-computed-hot-bb-threshold=",
    "The number of executions of a basic block which is considered hot. The parameter is used only in GIMPLE FE.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 43, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_gimple_fe_computed_hot_bb_threshold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [103] = */ {
    "--param=graphite-allow-codegen-errors=",
    "Whether codegen errors should be ICEs when -fchecking.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_graphite_allow_codegen_errors), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [104] = */ {
    "--param=graphite-max-arrays-per-scop=",
    "Maximum number of arrays per SCoP.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 36, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_graphite_max_arrays_per_scop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [105] = */ {
    "--param=graphite-max-nb-scop-params=",
    "Maximum number of parameters in a SCoP.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 35, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_graphite_max_nb_scop_params), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [106] = */ {
    "--param=hash-table-verification-limit=",
    "The number of elements for which hash table verification is done for each searched element.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hash_table_verification_limit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [107] = */ {
    "--param=hot-bb-count-fraction=",
    "The denominator n of fraction 1/n of the maximal execution count of a basic block in the entire program that a basic block needs to at least have in order to be considered hot (used in non-LTO mode).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hot_bb_count_fraction), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [108] = */ {
    "--param=hot-bb-count-ws-permille=",
    "The number of most executed permilles of the profiled execution of the entire program to which the execution count of a basic block must be part of in order to be considered hot (used in LTO mode).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hot_bb_count_ws_permille), 0, CLVC_BOOLEAN, 0, 0, 1000 },
 /* [109] = */ {
    "--param=hot-bb-frequency-fraction=",
    "The denominator n of fraction 1/n of the execution frequency of the entry block of a function that a basic block of this function needs to at least have in order to be considered hot.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hot_bb_frequency_fraction), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [110] = */ {
    "--param=hwasan-instrument-allocas=",
    "Enable hwasan instrumentation of allocas/VLAs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hwasan_instrument_allocas), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [111] = */ {
    "--param=hwasan-instrument-mem-intrinsics=",
    "Enable hwasan instrumentation of builtin functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hwasan_instrument_mem_intrinsics), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [112] = */ {
    "--param=hwasan-instrument-reads=",
    "Enable hwasan instrumentation of load operations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hwasan_instrument_reads), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [113] = */ {
    "--param=hwasan-instrument-stack=",
    "Enable hwasan instrumentation of statically sized stack-allocated variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hwasan_instrument_stack), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [114] = */ {
    "--param=hwasan-instrument-writes=",
    "Enable hwasan instrumentation of store operations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hwasan_instrument_writes), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [115] = */ {
    "--param=hwasan-random-frame-tag=",
    "Use random base tag for each frame, as opposed to base always zero.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_hwasan_random_frame_tag), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [116] = */ {
    "--param=inline-heuristics-hint-percent=",
    "The scale (in percents) applied to inline-insns-single and auto limits when heuristics hints that inlining is very profitable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_inline_heuristics_hint_percent), 0, CLVC_BOOLEAN, 0, 100, 1000000 },
 /* [117] = */ {
    "--param=inline-min-speedup=",
    "The minimal estimated speedup allowing inliner to ignore inline-insns-single and inline-insns-auto.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_inline_min_speedup), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [118] = */ {
    "--param=inline-unit-growth=",
    "How much can given compilation unit grow because of the inlining (in percent).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_inline_unit_growth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [119] = */ {
    "--param=integer-share-limit=",
    "The upper bound for sharing integer constants.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_integer_share_limit), 0, CLVC_BOOLEAN, 0, 2, 65536 },
 /* [120] = */ {
    "--param=ipa-cp-eval-threshold=",
    "Threshold ipa-cp opportunity evaluation that is still considered beneficial to clone.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_eval_threshold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [121] = */ {
    "--param=ipa-cp-large-unit-insns=",
    "The size of translation unit that IPA-CP pass considers large.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_large_unit_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [122] = */ {
    "--param=ipa-cp-loop-hint-bonus=",
    "Compile-time bonus IPA-CP assigns to candidates which make loop bounds or strides known.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_loop_hint_bonus), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [123] = */ {
    "--param=ipa-cp-max-recursive-depth=",
    "Maximum depth of recursive cloning for self-recursive function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_max_recursive_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [124] = */ {
    "--param=ipa-cp-min-recursive-probability=",
    "Recursive cloning only when the probability of call being executed exceeds the parameter.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_min_recursive_probability), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [125] = */ {
    "--param=ipa-cp-recursion-penalty=",
    "Percentage penalty the recursive functions will receive when they are evaluated for cloning.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_recursion_penalty), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [126] = */ {
    "--param=ipa-cp-single-call-penalty=",
    "Percentage penalty functions containing a single call to another function will receive when they are evaluated for cloning.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_single_call_penalty), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [127] = */ {
    "--param=ipa-cp-unit-growth=",
    "How much can given compilation unit grow because of the interprocedural constant propagation (in percent).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_unit_growth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [128] = */ {
    "--param=ipa-cp-value-list-size=",
    "Maximum size of a list of values associated with each parameter for interprocedural constant propagation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_cp_value_list_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [129] = */ {
    "--param=ipa-jump-function-lookups=",
    "Maximum number of statements visited during jump function offset discovery.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_jump_function_lookups), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [130] = */ {
    "--param=ipa-max-aa-steps=",
    "Maximum number of statements that will be visited by IPA formal parameter analysis based on alias analysis in any given function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_max_aa_steps), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [131] = */ {
    "--param=ipa-max-agg-items=",
    "Maximum number of aggregate content items for a parameter in jump functions and lattices.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_max_agg_items), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [132] = */ {
    "--param=ipa-max-loop-predicates=",
    "Maximum number of different predicates used to track properties of loops in IPA analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_max_loop_predicates), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [133] = */ {
    "--param=ipa-max-param-expr-ops=",
    "Maximum number of operations in a parameter expression that can be handled by IPA analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_max_param_expr_ops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [134] = */ {
    "--param=ipa-max-switch-predicate-bounds=",
    "Maximal number of boundary endpoints of case ranges of switch statement used during IPA function summary generation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_max_switch_predicate_bounds), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [135] = */ {
    "--param=ipa-sra-max-replacements=",
    "Maximum pieces that IPA-SRA tracks per formal parameter, as a consequence, also the maximum number of replacements of a formal parameter.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_sra_max_replacements), 0, CLVC_BOOLEAN, 0, 0, 16 },
 /* [136] = */ {
    "--param=ipa-sra-ptr-growth-factor=",
    "Maximum allowed growth of number and total size of new parameters that ipa-sra replaces a pointer to an aggregate with.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ipa_sra_ptr_growth_factor), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [137] = */ {
    "--param=ira-loop-reserved-regs=",
    "The number of registers in each class kept unused by loop invariant motion.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ira_loop_reserved_regs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [138] = */ {
    "--param=ira-max-conflict-table-size=",
    "Max size of conflict table in MB.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 35, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ira_max_conflict_table_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [139] = */ {
    "--param=ira-max-loops-num=",
    "Max loops number for regional RA.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ira_max_loops_num), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [140] = */ {
    "--param=iv-always-prune-cand-set-bound=",
    "If number of candidates in the set is smaller, we always try to remove unused ivs during its optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_iv_always_prune_cand_set_bound), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [141] = */ {
    "--param=iv-consider-all-candidates-bound=",
    "Bound on number of candidates below that all candidates are considered in iv optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_iv_consider_all_candidates_bound), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [142] = */ {
    "--param=iv-max-considered-uses=",
    "Bound on number of iv uses in loop optimized in iv optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_iv_max_considered_uses), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [143] = */ {
    "--param=jump-table-max-growth-ratio-for-size=",
    "The maximum code size growth ratio when expanding into a jump table (in percent).  The parameter is used when optimizing for size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 44, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_jump_table_max_growth_ratio_for_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [144] = */ {
    "--param=jump-table-max-growth-ratio-for-speed=",
    "The maximum code size growth ratio when expanding into a jump table (in percent).  The parameter is used when optimizing for speed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 45, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_jump_table_max_growth_ratio_for_speed), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [145] = */ {
    "--param=l1-cache-line-size=",
    "The size of L1 cache line.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_l1_cache_line_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [146] = */ {
    "--param=l1-cache-size=",
    "The size of L1 cache.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_l1_cache_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [147] = */ {
    "--param=l2-cache-size=",
    "The size of L2 cache.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_l2_cache_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [148] = */ {
    "--param=large-function-growth=",
    "Maximal growth due to inlining of large function (in percent).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_large_function_growth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [149] = */ {
    "--param=large-function-insns=",
    "The size of function body to be considered large.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_large_function_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [150] = */ {
    "--param=large-stack-frame-growth=",
    "Maximal stack frame growth due to inlining (in percent).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_stack_frame_growth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [151] = */ {
    "--param=large-stack-frame=",
    "The size of stack frame to be considered large.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_large_stack_frame), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [152] = */ {
    "--param=large-unit-insns=",
    "The size of translation unit to be considered large.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_large_unit_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [153] = */ {
    "--param=lazy-modules=",
    "Maximum number of concurrently open C++ module files when lazy loading.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_CXX | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_lazy_modules), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [154] = */ {
    "--param=lim-expensive=",
    "The minimum cost of an expensive expression in the loop invariant motion.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_lim_expensive), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [155] = */ {
    "--param=logical-op-non-short-circuit=",
    "True if a non-short-circuit operation is optimal.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 36, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_logical_op_non_short_circuit), 0, CLVC_BOOLEAN, 0, -1, 1 },
 /* [156] = */ {
    "--param=loop-block-tile-size=",
    "Size of tiles for loop blocking.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_loop_block_tile_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [157] = */ {
    "--param=loop-interchange-max-num-stmts=",
    "The maximum number of stmts in loop nest for loop interchange.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_loop_interchange_max_num_stmts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [158] = */ {
    "--param=loop-interchange-stride-ratio=",
    "The minimum stride ratio for loop interchange to be profitable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_loop_interchange_stride_ratio), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [159] = */ {
    "--param=loop-invariant-max-bbs-in-loop=",
    "Max basic blocks number in loop for loop invariant motion.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_loop_invariant_max_bbs_in_loop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [160] = */ {
    "--param=loop-max-datarefs-for-datadeps=",
    "Maximum number of datarefs in loop for building loop data dependencies.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_loop_max_datarefs_for_datadeps), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [161] = */ {
    "--param=loop-versioning-max-inner-insns=",
    "The maximum number of instructions in an inner loop that is being considered for versioning.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_loop_versioning_max_inner_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [162] = */ {
    "--param=loop-versioning-max-outer-insns=",
    "The maximum number of instructions in an outer loop that is being considered for versioning, on top of the instructions in inner loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_loop_versioning_max_outer_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [163] = */ {
    "--param=lra-inheritance-ebb-probability-cutoff=",
    "Minimal fall-through edge probability in percentage used to add BB to inheritance EBB in LRA.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 46, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_lra_inheritance_ebb_probability_cutoff), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [164] = */ {
    "--param=lra-max-considered-reload-pseudos=",
    "The max number of reload pseudos which are considered during spilling a non-reload pseudo.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 41, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_lra_max_considered_reload_pseudos), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [165] = */ {
    "--param=lto-max-partition=",
    "Maximal size of a partition for LTO (in estimated instructions).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_partition_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [166] = */ {
    "--param=lto-max-streaming-parallelism=",
    "maximal number of LTO partitions streamed in parallel.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_lto_streaming_parallelism), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [167] = */ {
    "--param=lto-min-partition=",
    "Minimal size of a partition for LTO (in estimated instructions).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_partition_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [168] = */ {
    "--param=lto-partitions=",
    "Number of partitions the program should be split to.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_lto_partitions), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [169] = */ {
    "--param=max-average-unrolled-insns=",
    "The maximum number of instructions to consider to unroll in a loop on average.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_average_unrolled_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [170] = */ {
    "--param=max-combine-insns=",
    "The maximum number of insns combine tries to combine.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_combine_insns), 0, CLVC_BOOLEAN, 0, 2, 4 },
 /* [171] = */ {
    "--param=max-completely-peel-loop-nest-depth=",
    "The maximum depth of a loop nest we completely peel.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 43, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_unroll_iterations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [172] = */ {
    "--param=max-completely-peel-times=",
    "The maximum number of peelings of a single loop that is peeled completely.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_completely_peel_times), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [173] = */ {
    "--param=max-completely-peeled-insns=",
    "The maximum number of insns of a completely peeled loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 35, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_completely_peeled_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [174] = */ {
    "--param=max-crossjump-edges=",
    "The maximum number of incoming edges to consider for crossjumping.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_crossjump_edges), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [175] = */ {
    "--param=max-cse-insns=",
    "The maximum instructions CSE process before flushing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_cse_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [176] = */ {
    "--param=max-cse-path-length=",
    "The maximum length of path considered in cse.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_cse_path_length), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [177] = */ {
    "--param=max-cselib-memory-locations=",
    "The maximum memory locations recorded by cselib.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 35, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_cselib_memory_locations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [178] = */ {
    "--param=max-debug-marker-count=",
    "Max. count of debug markers to expand or inline.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_debug_marker_count), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [179] = */ {
    "--param=max-delay-slot-insn-search=",
    "The maximum number of instructions to consider to fill a delay slot.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_delay_slot_insn_search), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [180] = */ {
    "--param=max-delay-slot-live-search=",
    "The maximum number of instructions to consider to find accurate live register information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_delay_slot_live_search), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [181] = */ {
    "--param=max-dse-active-local-stores=",
    "Maximum number of active local stores in RTL dead store elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 35, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_dse_active_local_stores), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [182] = */ {
    "--param=max-early-inliner-iterations=",
    "The maximum number of nested indirect inlining performed by early inliner.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 36, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_early_inliner_max_iterations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [183] = */ {
    "--param=max-fields-for-field-sensitive=",
    "Maximum number of fields in a structure before pointer analysis treats the structure as a single variable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_fields_for_field_sensitive), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [184] = */ {
    "--param=max-find-base-term-values=",
    "Maximum number of VALUEs handled during a single find_base_term call.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_find_base_term_values), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [185] = */ {
    "--param=max-fsm-thread-length=",
    "Maximum number of basic blocks on a finite state automaton jump thread path.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_fsm_thread_length), 0, CLVC_BOOLEAN, 0, 1, 999999 },
 /* [186] = */ {
    "--param=max-fsm-thread-path-insns=",
    "Maximum number of instructions to copy when duplicating blocks on a finite state automaton jump thread path.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_fsm_thread_path_insns), 0, CLVC_BOOLEAN, 0, 1, 999999 },
 /* [187] = */ {
    "--param=max-fsm-thread-paths=",
    "Maximum number of new jump thread paths to create for a finite state automaton.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_fsm_thread_paths), 0, CLVC_BOOLEAN, 0, 1, 999999 },
 /* [188] = */ {
    "--param=max-gcse-insertion-ratio=",
    "The maximum ratio of insertions to deletions of expressions in GCSE.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_gcse_insertion_ratio), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [189] = */ {
    "--param=max-gcse-memory=",
    "The maximum amount of memory to be allocated by GCSE, in kilobytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_gcse_memory), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [190] = */ {
    "--param=max-goto-duplication-insns=",
    "The maximum number of insns to duplicate when unfactoring computed gotos.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_goto_duplication_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [191] = */ {
    "--param=max-grow-copy-bb-insns=",
    "The maximum expansion factor when copying basic blocks.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_grow_copy_bb_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [192] = */ {
    "--param=max-hoist-depth=",
    "Maximum depth of search in the dominator tree for expressions to hoist.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_hoist_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [193] = */ {
    "--param=max-inline-insns-auto=",
    "The maximum number of instructions when automatically inlining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_inline_insns_auto), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [194] = */ {
    "--param=max-inline-insns-recursive-auto=",
    "The maximum number of instructions non-inline function can grow to via recursive inlining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_inline_insns_recursive_auto), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [195] = */ {
    "--param=max-inline-insns-recursive=",
    "The maximum number of instructions inline function can grow to via recursive inlining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_inline_insns_recursive), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [196] = */ {
    "--param=max-inline-insns-single=",
    "The maximum number of instructions in a single function eligible for inlining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_inline_insns_single), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [197] = */ {
    "--param=max-inline-insns-size=",
    "The maximum number of instructions when inlining for size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_inline_insns_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [198] = */ {
    "--param=max-inline-insns-small=",
    "The maximum number of instructions when automatically inlining small functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_inline_insns_small), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [199] = */ {
    "--param=max-inline-recursive-depth-auto=",
    "The maximum depth of recursive inlining for non-inline functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_inline_recursive_depth_auto), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [200] = */ {
    "--param=max-inline-recursive-depth=",
    "The maximum depth of recursive inlining for inline functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_inline_recursive_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [201] = */ {
    "--param=max-isl-operations=",
    "Maximum number of isl operations, 0 means unlimited.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_isl_operations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [202] = */ {
    "--param=max-iterations-computation-cost=",
    "Bound on the cost of an expression to compute the number of iterations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_iterations_computation_cost), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [203] = */ {
    "--param=max-iterations-to-track=",
    "Bound on the number of iterations the brute force # of iterations analysis algorithm evaluates.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_iterations_to_track), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [204] = */ {
    "--param=max-jump-thread-duplication-stmts=",
    "Maximum number of statements allowed in a block that needs to be duplicated when threading jumps.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 41, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_jump_thread_duplication_stmts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [205] = */ {
    "--param=max-last-value-rtl=",
    "The maximum number of RTL nodes that can be recorded as combiner's last value.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_last_value_rtl), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [206] = */ {
    "--param=max-loop-header-insns=",
    "The maximum number of insns in loop header duplicated by the copy loop headers pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_loop_header_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [207] = */ {
    "--param=max-modulo-backtrack-attempts=",
    "The maximum number of backtrack attempts the scheduler should make when modulo scheduling a loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_modulo_backtrack_attempts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [208] = */ {
    "--param=max-partial-antic-length=",
    "Maximum length of partial antic set when performing tree pre optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_partial_antic_length), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [209] = */ {
    "--param=max-peel-branches=",
    "The maximum number of branches on the path through the peeled sequence.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_peel_branches), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [210] = */ {
    "--param=max-peel-times=",
    "The maximum number of peelings of a single loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_peel_times), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [211] = */ {
    "--param=max-peeled-insns=",
    "The maximum number of insns of a peeled loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_peeled_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [212] = */ {
    "--param=max-pending-list-length=",
    "The maximum length of scheduling's pending operations list.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_pending_list_length), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [213] = */ {
    "--param=max-pipeline-region-blocks=",
    "The maximum number of blocks in a region to be considered for interblock scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_pipeline_region_blocks), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [214] = */ {
    "--param=max-pipeline-region-insns=",
    "The maximum number of insns in a region to be considered for interblock scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_pipeline_region_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [215] = */ {
    "--param=max-pow-sqrt-depth=",
    "Maximum depth of sqrt chains to use when synthesizing exponentiation by a real constant.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_pow_sqrt_depth), 0, CLVC_BOOLEAN, 0, 1, 32 },
 /* [216] = */ {
    "--param=max-predicted-iterations=",
    "The maximum number of loop iterations we predict statically.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_predicted_iterations), 0, CLVC_BOOLEAN, 0, 0, 65536 },
 /* [217] = */ {
    "--param=max-reload-search-insns=",
    "The maximum number of instructions to search backward when looking for equivalent reload.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_reload_search_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [218] = */ {
    "--param=max-rtl-if-conversion-insns=",
    "Maximum number of insns in a basic block to consider for RTL if-conversion.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 35, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_rtl_if_conversion_insns), 0, CLVC_BOOLEAN, 0, 0, 99 },
 /* [219] = */ {
    "--param=max-rtl-if-conversion-predictable-cost=",
    "Maximum permissible cost for the sequence that would be generated by the RTL if-conversion pass for a branch that is considered predictable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 46, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_rtl_if_conversion_predictable_cost), 0, CLVC_BOOLEAN, 0, 0, 200 },
 /* [220] = */ {
    "--param=max-rtl-if-conversion-unpredictable-cost=",
    "Maximum permissible cost for the sequence that would be generated by the RTL if-conversion pass for a branch that is considered unpredictable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 48, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_rtl_if_conversion_unpredictable_cost), 0, CLVC_BOOLEAN, 0, 0, 200 },
 /* [221] = */ {
    "--param=max-sched-extend-regions-iters=",
    "The maximum number of iterations through CFG to extend regions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_sched_extend_regions_iters), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [222] = */ {
    "--param=max-sched-insn-conflict-delay=",
    "The maximum conflict delay for an insn to be considered for speculative motion.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_sched_insn_conflict_delay), 0, CLVC_BOOLEAN, 0, 1, 10 },
 /* [223] = */ {
    "--param=max-sched-ready-insns=",
    "The maximum number of instructions ready to be issued to be considered by the scheduler during the first scheduling pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_sched_ready_insns), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [224] = */ {
    "--param=max-sched-region-blocks=",
    "The maximum number of blocks in a region to be considered for interblock scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_sched_region_blocks), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [225] = */ {
    "--param=max-sched-region-insns=",
    "The maximum number of insns in a region to be considered for interblock scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_sched_region_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [226] = */ {
    "--param=max-slsr-cand-scan=",
    "Maximum length of candidate scans for straight-line strength reduction.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_slsr_candidate_scan), 0, CLVC_BOOLEAN, 0, 1, 999999 },
 /* [227] = */ {
    "--param=max-speculative-devirt-maydefs=",
    "Maximum number of may-defs visited when devirtualizing speculatively.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_speculative_devirt_maydefs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [228] = */ {
    "--param=max-ssa-name-query-depth=",
    "Maximum recursion depth allowed when querying a property of an SSA name.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_ssa_name_query_depth), 0, CLVC_BOOLEAN, 0, 1, 10 },
 /* [229] = */ {
    "--param=max-store-chains-to-track=",
    "Maximum number of store chains to track at the same time in the store merging pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_store_chains_to_track), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [230] = */ {
    "--param=max-stores-to-merge=",
    "Maximum number of constant stores to merge in the store merging pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_stores_to_merge), 0, CLVC_BOOLEAN, 0, 2, 65536 },
 /* [231] = */ {
    "--param=max-stores-to-sink=",
    "Maximum number of conditional store pairs that can be sunk.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_stores_to_sink), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [232] = */ {
    "--param=max-stores-to-track=",
    "Maximum number of store chains to track at the same time in the store merging pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_stores_to_track), 0, CLVC_BOOLEAN, 0, 2, 1048576 },
 /* [233] = */ {
    "--param=max-tail-merge-comparisons=",
    "Maximum amount of similar bbs to compare a bb with.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_tail_merge_comparisons), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [234] = */ {
    "--param=max-tail-merge-iterations=",
    "Maximum amount of iterations of the pass over a function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_tail_merge_iterations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [235] = */ {
    "--param=max-tracked-strlens=",
    "Maximum number of strings for which strlen optimization pass will track string lengths.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_tracked_strlens), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [236] = */ {
    "--param=max-tree-if-conversion-phi-args=",
    "Maximum number of arguments in a PHI supported by TREE if-conversion unless the loop is marked with simd pragma.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_tree_if_conversion_phi_args), 0, CLVC_BOOLEAN, 0, 2, 65536 },
 /* [237] = */ {
    "--param=max-unroll-times=",
    "The maximum number of unrollings of a single loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_unroll_times), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [238] = */ {
    "--param=max-unrolled-insns=",
    "The maximum number of instructions to consider to unroll in a loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_unrolled_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [239] = */ {
    "--param=max-unswitch-insns=",
    "The maximum number of insns of an unswitched loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_unswitch_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [240] = */ {
    "--param=max-unswitch-level=",
    "The maximum number of unswitchings in a single loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_unswitch_level), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [241] = */ {
    "--param=max-variable-expansions-in-unroller=",
    "If -fvariable-expansion-in-unroller is used, the maximum number of times that an individual variable will be expanded during loop unrolling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 43, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_variable_expansions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [242] = */ {
    "--param=max-vartrack-expr-depth=",
    "Max. recursion depth for expanding var tracking expressions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_vartrack_expr_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [243] = */ {
    "--param=max-vartrack-reverse-op-size=",
    "Max. size of loc list for which reverse ops should be added.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 36, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_vartrack_reverse_op_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [244] = */ {
    "--param=max-vartrack-size=",
    "Max. size of var tracking hash tables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_vartrack_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [245] = */ {
    "--param=max-vrp-switch-assertions=",
    "Maximum number of assertions to add along the default edge of a switch statement during VRP.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_max_vrp_switch_assertions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [246] = */ {
    "--param=min-crossjump-insns=",
    "The minimum number of matching instructions to consider for crossjumping.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_crossjump_insns), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [247] = */ {
    "--param=min-inline-recursive-probability=",
    "Inline recursively only when the probability of call being executed exceeds the parameter.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_inline_recursive_probability), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [248] = */ {
    "--param=min-insn-to-prefetch-ratio=",
    "Min. ratio of insns to prefetches to enable prefetching for a loop with an unknown trip count.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_insn_to_prefetch_ratio), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [249] = */ {
    "--param=min-loop-cond-split-prob=",
    "The minimum threshold for probability of semi-invariant condition statement to trigger loop split.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_loop_cond_split_prob), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [250] = */ {
    "--param=min-nondebug-insn-uid=",
    "The minimum UID to be used for a nondebug insn.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_nondebug_insn_uid), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [251] = */ {
    "--param=min-pagesize=",
    "Minimum page size for warning purposes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_pagesize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [252] = */ {
    "--param=min-size-for-stack-sharing=",
    "The minimum size of variables taking part in stack slot sharing when not optimizing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_size_for_stack_sharing), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [253] = */ {
    "--param=min-spec-prob=",
    "The minimum probability of reaching a source block for interblock speculative scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_spec_prob), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [254] = */ {
    "--param=min-vect-loop-bound=",
    "If -ftree-vectorize is used, the minimal loop bound of a loop to be considered for vectorization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_min_vect_loop_bound), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [255] = */ {
    "--param=modref-max-accesses=",
    "Maximum number of accesses stored in each modref reference.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_modref_max_accesses), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [256] = */ {
    "--param=modref-max-bases=",
    "Maximum number of bases stored in each modref tree.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_modref_max_bases), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [257] = */ {
    "--param=modref-max-depth=",
    "Maximum depth of DFS walk used by modref escape analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_modref_max_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [258] = */ {
    "--param=modref-max-escape-points=",
    "Maximum number of escape points tracked by modref per SSA-name.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_modref_max_escape_points), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [259] = */ {
    "--param=modref-max-refs=",
    "Maximum number of references stored in each modref base.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_modref_max_refs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [260] = */ {
    "--param=modref-max-tests=",
    "Maximum number of tests performed by modref query.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_modref_max_tests), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [261] = */ {
    "--param=openacc-kernels=",
    "--param=openacc-kernels=[decompose|parloops]	Specify mode of OpenACC 'kernels' constructs handling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_param_openacc_kernels), 32, CLVC_ENUM, 0, -1, -1 },
 /* [262] = */ {
    "--param=parloops-chunk-size=",
    "Chunk size of omp schedule for loops parallelized by parloops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_parloops_chunk_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [263] = */ {
    "--param=parloops-min-per-thread=",
    "Minimum number of iterations per thread of an innermost parallelized loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_parloops_min_per_thread), 0, CLVC_BOOLEAN, 0, 2, 65536 },
 /* [264] = */ {
    "--param=parloops-schedule=",
    "--param=parloops-schedule=[static|dynamic|guided|auto|runtime]	Schedule type of omp schedule for loops parallelized by parloops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_param_parloops_schedule), 33, CLVC_ENUM, 0, -1, -1 },
 /* [265] = */ {
    "--param=partial-inlining-entry-probability=",
    "Maximum probability of the entry BB of split region (in percent relative to entry BB of the function) to make partial inlining happen.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 42, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_partial_inlining_entry_probability), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [266] = */ {
    "--param=predictable-branch-outcome=",
    "Maximal estimated outcome of branch considered predictable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_predictable_branch_outcome), 0, CLVC_BOOLEAN, 0, 0, 50 },
 /* [267] = */ {
    "--param=prefetch-dynamic-strides=",
    "Whether software prefetch hints should be issued for non-constant strides.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_prefetch_dynamic_strides), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [268] = */ {
    "--param=prefetch-latency=",
    "The number of insns executed before prefetch is completed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_prefetch_latency), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [269] = */ {
    "--param=prefetch-min-insn-to-mem-ratio=",
    "Min. ratio of insns to mem ops to enable prefetching in a loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_prefetch_min_insn_to_mem_ratio), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [270] = */ {
    "--param=prefetch-minimum-stride=",
    "The minimum constant stride beyond which we should use prefetch hints for.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_prefetch_minimum_stride), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [271] = */ {
    "--param=profile-func-internal-id=",
    "Use internal function id in profile lookup.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_profile_func_internal_id), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [272] = */ {
    "--param=ranger-logical-depth=",
    "Maximum depth of logical expression evaluation ranger will look through when evaluating outgoing edge ranges.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ranger_logical_depth), 0, CLVC_BOOLEAN, 0, 1, 999 },
 /* [273] = */ {
    "--param=rpo-vn-max-loop-depth=",
    "Maximum depth of a loop nest to fully value-number optimistically.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_rpo_vn_max_loop_depth), 0, CLVC_BOOLEAN, 0, 2, 65536 },
 /* [274] = */ {
    "--param=sccvn-max-alias-queries-per-access=",
    "Maximum number of disambiguations to perform per memory access.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 42, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sccvn_max_alias_queries_per_access), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [275] = */ {
    "--param=scev-max-expr-complexity=",
    "Bound on the complexity of the expressions in the scalar evolutions analyzer.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_scev_max_expr_complexity), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [276] = */ {
    "--param=scev-max-expr-size=",
    "Bound on size of expressions used in the scalar evolutions analyzer.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_scev_max_expr_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [277] = */ {
    "--param=sched-autopref-queue-depth=",
    "Hardware autoprefetcher scheduler model control flag.  Number of lookahead cycles the model looks into, at '0' only enable instruction sorting heuristic.  Disabled by default.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sched_autopref_queue_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [278] = */ {
    "--param=sched-mem-true-dep-cost=",
    "Minimal distance between possibly conflicting store and load.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sched_mem_true_dep_cost), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [279] = */ {
    "--param=sched-pressure-algorithm=",
    "Which -fsched-pressure algorithm to apply.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sched_pressure_algorithm), 0, CLVC_BOOLEAN, 0, 1, 2 },
 /* [280] = */ {
    "--param=sched-spec-prob-cutoff=",
    "The minimal probability of speculation success (in percents), so that speculative insn will be scheduled.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sched_spec_prob_cutoff), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [281] = */ {
    "--param=sched-state-edge-prob-cutoff=",
    "The minimum probability an edge must have for the scheduler to save its state across it.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 36, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sched_state_edge_prob_cutoff), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [282] = */ {
    "--param=selsched-insns-to-rename=",
    "Maximum number of instructions in the ready list that are considered eligible for renaming.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_selsched_insns_to_rename), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [283] = */ {
    "--param=selsched-max-lookahead=",
    "The maximum size of the lookahead window of selective scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_selsched_max_lookahead), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [284] = */ {
    "--param=selsched-max-sched-times=",
    "Maximum number of times that an insn could be scheduled.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_selsched_max_sched_times), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [285] = */ {
    "--param=simultaneous-prefetches=",
    "The number of prefetches that can run at the same time.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_simultaneous_prefetches), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [286] = */ {
    "--param=sink-frequency-threshold=",
    "Target block's relative execution frequency (as a percentage) required to sink a statement.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sink_frequency_threshold), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [287] = */ {
    "--param=sms-dfa-history=",
    "The number of cycles the swing modulo scheduler considers when checking conflicts using DFA.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sms_dfa_history), 0, CLVC_BOOLEAN, 0, 0, 16 },
 /* [288] = */ {
    "--param=sms-loop-average-count-threshold=",
    "A threshold on the average loop count considered by the swing modulo scheduler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sms_loop_average_count_threshold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [289] = */ {
    "--param=sms-max-ii-factor=",
    "A factor for tuning the upper bound that swing modulo scheduler uses for scheduling a loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sms_max_ii_factor), 0, CLVC_BOOLEAN, 0, 1, 16 },
 /* [290] = */ {
    "--param=sms-min-sc=",
    "The minimum value of stage count that swing modulo scheduler will generate.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sms_min_sc), 0, CLVC_BOOLEAN, 0, 1, 2 },
 /* [291] = */ {
    "--param=sra-max-propagations=",
    "Maximum number of artificial accesses to enable forward propagation that Scalar Replacement of Aggregates will keep for one local variable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sra_max_propagations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [292] = */ {
    "--param=sra-max-scalarization-size-Osize=",
    "Maximum size, in storage units, of an aggregate which should be considered for scalarization when compiling for size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sra_max_scalarization_size_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [293] = */ {
    "--param=sra-max-scalarization-size-Ospeed=",
    "Maximum size, in storage units, of an aggregate which should be considered for scalarization when compiling for speed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 41, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_sra_max_scalarization_size_speed), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [294] = */ {
    "--param=ssa-name-def-chain-limit=",
    "The maximum number of SSA_NAME assignments to follow in determining a value.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ssa_name_def_chain_limit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [295] = */ {
    "--param=ssp-buffer-size=",
    "The lower bound for a buffer to be considered for stack smashing protection.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_ssp_buffer_size), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [296] = */ {
    "--param=stack-clash-protection-guard-size=",
    "Size of the stack guard expressed as a power of two in bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 41, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_stack_clash_protection_guard_size), 0, CLVC_BOOLEAN, 0, 12, 30 },
 /* [297] = */ {
    "--param=stack-clash-protection-probe-interval=",
    "Interval in which to probe the stack expressed as a power of two in bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 45, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_stack_clash_protection_probe_interval), 0, CLVC_BOOLEAN, 0, 10, 16 },
 /* [298] = */ {
    "--param=store-merging-allow-unaligned=",
    "Allow the store merging pass to introduce unaligned stores if it is legal to do so.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_store_merging_allow_unaligned), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [299] = */ {
    "--param=store-merging-max-size=",
    "Maximum size of a single store merging region in bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_store_merging_max_size), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [300] = */ {
    "--param=switch-conversion-max-branch-ratio=",
    "The maximum ratio between array size and switch branches for a switch conversion to take place.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 42, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_switch_conversion_branch_ratio), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [301] = */ {
    "--param=tm-max-aggregate-size=",
    "Size in bytes after which thread-local aggregates should be instrumented with the logging functions instead of save/restore pairs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tm_max_aggregate_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [302] = */ {
    "--param=tracer-dynamic-coverage-feedback=",
    "The percentage of function, weighted by execution frequency, that must be covered by trace formation. Used when profile feedback is available.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tracer_dynamic_coverage_feedback), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [303] = */ {
    "--param=tracer-dynamic-coverage=",
    "The percentage of function, weighted by execution frequency, that must be covered by trace formation. Used when profile feedback is not available.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tracer_dynamic_coverage), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [304] = */ {
    "--param=tracer-max-code-growth=",
    "Maximal code growth caused by tail duplication (in percent).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tracer_max_code_growth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [305] = */ {
    "--param=tracer-min-branch-probability-feedback=",
    "Stop forward growth if the probability of best edge is less than this threshold (in percent). Used when profile feedback is available.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 46, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tracer_min_branch_probability_feedback), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [306] = */ {
    "--param=tracer-min-branch-probability=",
    "Stop forward growth if the probability of best edge is less than this threshold (in percent). Used when profile feedback is not available.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 37, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tracer_min_branch_probability), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [307] = */ {
    "--param=tracer-min-branch-ratio=",
    "Stop reverse growth if the reverse probability of best edge is less than this threshold (in percent).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tracer_min_branch_ratio), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [308] = */ {
    "--param=tree-reassoc-width=",
    "Set the maximum number of instructions executed in parallel in reassociated tree.  If 0, use the target dependent heuristic.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tree_reassoc_width), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [309] = */ {
    "--param=tsan-distinguish-volatile=",
    "Emit special instrumentation for accesses to volatiles.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tsan_distinguish_volatile), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [310] = */ {
    "--param=tsan-instrument-func-entry-exit=",
    "Emit instrumentation calls to __tsan_func_entry() and __tsan_func_exit().",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_tsan_instrument_func_entry_exit), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [311] = */ {
    "--param=uninit-control-dep-attempts=",
    "Maximum number of nested calls to search for control dependencies during uninitialized variable analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 35, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_uninit_control_dep_attempts), 0, CLVC_BOOLEAN, 0, 1, 65536 },
 /* [312] = */ {
    "--param=uninlined-function-insns=",
    "Instruction accounted for function prologue, epilogue and other overhead.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_uninlined_function_insns), 0, CLVC_BOOLEAN, 0, 0, 1000000 },
 /* [313] = */ {
    "--param=uninlined-function-time=",
    "Time accounted for function prologue, epilogue and other overhead.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_uninlined_function_time), 0, CLVC_BOOLEAN, 0, 0, 1000000 },
 /* [314] = */ {
    "--param=uninlined-thunk-insns=",
    "Instruction accounted for function thunk overhead.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_uninlined_function_thunk_insns), 0, CLVC_BOOLEAN, 0, 0, 1000000 },
 /* [315] = */ {
    "--param=uninlined-thunk-time=",
    "Time accounted for function thunk overhead.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_uninlined_function_thunk_time), 0, CLVC_BOOLEAN, 0, 0, 1000000 },
 /* [316] = */ {
    "--param=unlikely-bb-count-fraction=",
    "The denominator n of fraction 1/n of the number of profiled runs of the entire program below which the execution count of a basic block must be in order for the basic block to be considered unlikely.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_unlikely_bb_count_fraction), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [317] = */ {
    "--param=unroll-jam-max-unroll=",
    "Maximum unroll factor for the unroll-and-jam transformation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_unroll_jam_max_unroll), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [318] = */ {
    "--param=unroll-jam-min-percent=",
    "Minimum percentage of memrefs that must go away for unroll-and-jam to be considered profitable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_unroll_jam_min_percent), 0, CLVC_BOOLEAN, 0, 0, 100 },
 /* [319] = */ {
    "--param=use-after-scope-direct-emission-threshold=",
    "Use direct poisoning/unpoisoning instructions for variables smaller or equal to this number.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 49, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_use_after_scope_direct_emission_threshold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [320] = */ {
    "--param=use-canonical-types=",
    "Whether to use canonical types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_use_canonical_types), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [321] = */ {
    "--param=vect-epilogues-nomask=",
    "Enable loop epilogue vectorization using smaller vector size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_vect_epilogues_nomask), 0, CLVC_BOOLEAN, 0, 0, 1 },
 /* [322] = */ {
    "--param=vect-max-peeling-for-alignment=",
    "Maximum number of loop peels to enhance alignment of data references in a loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_vect_max_peeling_for_alignment), 0, CLVC_BOOLEAN, 0, -1, 64 },
 /* [323] = */ {
    "--param=vect-max-version-for-alias-checks=",
    "Bound on number of runtime checks inserted by the vectorizer's loop versioning for alias check.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 41, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_vect_max_version_for_alias_checks), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [324] = */ {
    "--param=vect-max-version-for-alignment-checks=",
    "Bound on number of runtime checks inserted by the vectorizer's loop versioning for alignment check.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 45, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_vect_max_version_for_alignment_checks), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [325] = */ {
    "--param=vect-partial-vector-usage=",
    "Controls how loop vectorizer uses partial vectors.  0 means never, 1 means only for loops whose need to iterate can be removed, 2 means for all loops.  The default value is 2.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION | CL_PARAMS,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_param_vect_partial_vector_usage), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [326] = */ {
    "--pass-exit-codes",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_pass_exit_codes, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [327] = */ {
    "--pedantic",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wpedantic, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [328] = */ {
    "--pedantic-errors",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_pedantic_errors, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [329] = */ {
    "--pie",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_pie, N_OPTS, 4, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [330] = */ {
    "--pipe",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_pipe, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [331] = */ {
    "--prefix",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_B, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [332] = */ {
    "--prefix=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_B, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [333] = */ {
    "--preprocess",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_E, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_DRIVER | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [334] = */ {
    "--print-file-name",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_file_name_, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [335] = */ {
    "--print-file-name=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_file_name_, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [336] = */ {
    "--print-libgcc-file-name",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_libgcc_file_name, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [337] = */ {
    "--print-missing-file-dependencies",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_MG, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [338] = */ {
    "--print-multi-directory",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_multi_directory, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [339] = */ {
    "--print-multi-lib",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_multi_lib, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [340] = */ {
    "--print-multi-os-directory",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_multi_os_directory, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [341] = */ {
    "--print-multiarch",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_multiarch, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [342] = */ {
    "--print-prog-name",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_prog_name_, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [343] = */ {
    "--print-prog-name=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_prog_name_, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [344] = */ {
    "--print-search-dirs",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_search_dirs, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [345] = */ {
    "--print-sysroot",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_sysroot, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [346] = */ {
    "--print-sysroot-headers-suffix",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_print_sysroot_headers_suffix, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [347] = */ {
    "--profile",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_p, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [348] = */ {
    "--save-temps",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_save_temps, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [349] = */ {
    "--shared",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_shared, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [350] = */ {
    "--specs",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_specs_, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [351] = */ {
    "--specs=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_specs_, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [352] = */ {
    "--static",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_static, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [353] = */ {
    "--static-pie",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_static_pie, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [354] = */ {
    "--symbolic",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_symbolic, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [355] = */ {
    "--sysroot",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT__sysroot_, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [356] = */ {
    "--sysroot=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [357] = */ {
    "--target-help",
    "Alias for --help=target.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [358] = */ {
    "--time",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_time, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [359] = */ {
    "--trace-includes",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_H, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [360] = */ {
    "--traditional",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_traditional, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [361] = */ {
    "--traditional-cpp",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_traditional_cpp, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [362] = */ {
    "--trigraphs",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_trigraphs, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [363] = */ {
    "--undefine-macro",
    NULL,
    "macro name missing after %qs",
    NULL,
    NULL, NULL, OPT_U, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [364] = */ {
    "--undefine-macro=",
    NULL,
    "macro name missing after %qs",
    NULL,
    NULL, NULL, OPT_U, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [365] = */ {
    "--user-dependencies",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_MM, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [366] = */ {
    "--verbose",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_v, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [367] = */ {
    "--version",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [368] = */ {
    "--write-dependencies",
    NULL,
    "missing filename after %qs",
    NULL,
    NULL, NULL, OPT_MD, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 1 /* NoDriverArg */, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [369] = */ {
    "--write-user-dependencies",
    NULL,
    "missing filename after %qs",
    NULL,
    NULL, NULL, OPT_MMD, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 1 /* NoDriverArg */, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [370] = */ {
    "-A",
    "-A<question>=<answer>	Assert the <answer> to <question>.  Putting '-' before <question> disables the <answer> to <question>.",
    "assertion missing after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [371] = */ {
    "-B",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [372] = */ {
    "-C",
    "Do not discard comments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [373] = */ {
    "-CC",
    "Do not discard comments in macro expansions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [374] = */ {
    "-D",
    "-D<macro>[=<val>]	Define a <macro> with <val> as its value.  If just <macro> is given, <val> is taken to be 1.",
    "macro name missing after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [375] = */ {
    "-E",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_DRIVER | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_preprocess_only), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [376] = */ {
    "-F",
    "-F <dir>	Add <dir> to the end of the main framework include path.",
    "missing path after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [377] = */ {
    "-H",
    "Print the name of header files as they are used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [378] = */ {
    "-Hd",
    "-Hd <dir>	Write D interface files to directory <dir>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_D | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [379] = */ {
    "-Hf",
    "-Hf <file>	Write D interface to <file>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_D | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [380] = */ {
    "-I",
    "-I <dir>	Add <dir> to the end of the main include path.",
    "missing path after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_D | CL_Fortran | CL_Go | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [381] = */ {
    "-J",
    "-J<directory>	Put MODULE files in 'directory'.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_D | CL_Fortran | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [382] = */ {
    "-L",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_BRIG | CL_Go | CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [383] = */ {
    "-M",
    "Generate make dependencies.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [384] = */ {
    "-MD",
    "Generate make dependencies and compile.",
    "missing filename after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 1 /* NoDriverArg */, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [385] = */ {
    "-MF",
    "-MF <file>	Write dependency output to the given file.",
    "missing filename after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [386] = */ {
    "-MG",
    "Treat missing header files as generated files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [387] = */ {
    "-MM",
    "Like -M but ignore system header files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [388] = */ {
    "-MMD",
    "Like -MD but ignore system header files.",
    "missing filename after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 3, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 1 /* NoDriverArg */, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [389] = */ {
    "-MP",
    "Generate phony targets for all headers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [390] = */ {
    "-MQ",
    "-MQ <target>	Add a target that may require quoting.",
    "missing makefile target after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [391] = */ {
    "-MT",
    "-MT <target>	Add a target that does not require quoting.",
    "missing makefile target after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [392] = */ {
    "-Mmodules",
    "Generate C++ Module dependency information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_CXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [393] = */ {
    "-Mno-modules",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [394] = */ {
    "-N",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [395] = */ {
    "-O",
    "-O<number>	Set optimization level to <number>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [396] = */ {
    "-Ofast",
    "Optimize for speed disregarding exact standards compliance.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_O, 5, /* .neg_idx = */ -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [397] = */ {
    "-Og",
    "Optimize for debugging experience rather than speed or size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_O, 2, /* .neg_idx = */ -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [398] = */ {
    "-Os",
    "Optimize for space rather than speed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_O, 2, /* .neg_idx = */ -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [399] = */ {
    "-P",
    "Do not generate #line directives.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [400] = */ {
    "-Q",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [401] = */ {
    "-Qn",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ 402,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [402] = */ {
    "-Qy",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ 401,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [403] = */ {
    "-R",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [404] = */ {
    "-S",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [405] = */ {
    "-T",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [406] = */ {
    "-Tbss",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_T, 4, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [407] = */ {
    "-Tbss=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_T, 5, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [408] = */ {
    "-Tdata",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_T, 5, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [409] = */ {
    "-Tdata=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_T, 6, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [410] = */ {
    "-Ttext",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_T, 5, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [411] = */ {
    "-Ttext=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_T, 6, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [412] = */ {
    "-U",
    "-U<macro>	Undefine <macro>.",
    "macro name missing after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [413] = */ {
    "-W",
    "This switch is deprecated; use -Wextra instead.",
    NULL,
    NULL,
    NULL, NULL, OPT_Wextra, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [414] = */ {
    "-WNSObject-attribute",
    "Warn if the NSObject attribute is applied to a non-typedef.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 414,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nsobject_attribute), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [415] = */ {
    "-Wa,",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 3, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [416] = */ {
    "-Wabi",
    "Warn about things that will change when compiling with an ABI-compliant compiler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 416,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_abi), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [417] = */ {
    "-Wabi-tag",
    "Warn if a subobject has an abi_tag attribute that the complete object type does not have.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 417,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_abi_tag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [418] = */ {
    "-Wabi=",
    "Warn about things that change between the current -fabi-version and the specified version.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [419] = */ {
    "-Wabsolute-value",
    "Warn on suspicious calls of standard functions computing absolute values.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 419,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_absolute_value), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [420] = */ {
    "-Waddress",
    "Warn about suspicious uses of memory addresses.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 420,
    CL_C | CL_CXX | CL_D | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_address), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [421] = */ {
    "-Waddress-of-packed-member",
    "Warn when the address of packed member of struct or union is taken.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 421,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_address_of_packed_member), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [422] = */ {
    "-Waggregate-return",
    "Warn about returning structures, unions or arrays.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 422,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_aggregate_return), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [423] = */ {
    "-Waggressive-loop-optimizations",
    "Warn if a loop with constant number of iterations triggers undefined behavior.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 423,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_aggressive_loop_optimizations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [424] = */ {
    "-Waliasing",
    "Warn about possible aliasing of dummy arguments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 424,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_aliasing), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [425] = */ {
    "-Walign-commons",
    "Warn about alignment of COMMON blocks.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 425,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_align_commons), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [426] = */ {
    "-Waligned-new",
    "Warn about 'new' of type with extended alignment without -faligned-new.",
    NULL,
    NULL,
    "global", "none", OPT_Waligned_new_, N_OPTS, 12, /* .neg_idx = */ 426,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [427] = */ {
    "-Waligned-new=",
    "-Waligned-new=[none|global|all]	Warn even if 'new' uses a class member allocation function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_aligned_new), 48, CLVC_ENUM, 0, -1, -1 },
 /* [428] = */ {
    "-Wall",
    "Enable most warning messages.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 428,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_D | CL_Fortran | CL_Go | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [429] = */ {
    "-Walloc-size-larger-than=",
    "-Walloc-size-larger-than=<bytes>	Warn for calls to allocation functions that attempt to allocate objects larger than the specified number of bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 429,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* ByteSize */,
    offsetof (struct gcc_options, x_warn_alloc_size_limit), 0, CLVC_SIZE, 0, -1, -1 },
 /* [430] = */ {
    "-Walloc-zero",
    "Warn for calls to allocation functions that specify zero bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 430,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_alloc_zero), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [431] = */ {
    "-Walloca",
    "Warn on any use of alloca.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 431,
    CL_C | CL_CXX | CL_D | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_alloca), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [432] = */ {
    "-Walloca-larger-than=",
    "-Walloca-larger-than=<number>	Warn on unbounded uses of alloca, and on bounded uses of alloca whose bound can be larger than <number> bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 432,
    CL_C | CL_CXX | CL_D | CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* ByteSize */,
    offsetof (struct gcc_options, x_warn_alloca_limit), 0, CLVC_SIZE, 0, -1, -1 },
 /* [433] = */ {
    "-Wampersand",
    "Warn about missing ampersand in continued character constants.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 433,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ampersand), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [434] = */ {
    "-Wanalyzer-double-fclose",
    "Warn about code paths in which a stdio FILE can be closed more than once.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 434,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_double_fclose), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [435] = */ {
    "-Wanalyzer-double-free",
    "Warn about code paths in which a pointer can be freed more than once.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 435,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_double_free), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [436] = */ {
    "-Wanalyzer-exposure-through-output-file",
    "Warn about code paths in which sensitive data is written to a file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 38, /* .neg_idx = */ 436,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_exposure_through_output_file), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [437] = */ {
    "-Wanalyzer-file-leak",
    "Warn about code paths in which a stdio FILE is not closed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 437,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_file_leak), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [438] = */ {
    "-Wanalyzer-free-of-non-heap",
    "Warn about code paths in which a non-heap pointer is freed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 438,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_free_of_non_heap), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [439] = */ {
    "-Wanalyzer-malloc-leak",
    "Warn about code paths in which a heap-allocated pointer leaks.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 439,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_malloc_leak), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [440] = */ {
    "-Wanalyzer-mismatching-deallocation",
    "Warn about code paths in which the wrong deallocation function is called.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ 440,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_mismatching_deallocation), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [441] = */ {
    "-Wanalyzer-null-argument",
    "Warn about code paths in which NULL is passed to a must-not-be-NULL function argument.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 441,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_null_argument), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [442] = */ {
    "-Wanalyzer-null-dereference",
    "Warn about code paths in which a NULL pointer is dereferenced.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 442,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_null_dereference), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [443] = */ {
    "-Wanalyzer-possible-null-argument",
    "Warn about code paths in which a possibly-NULL value is passed to a must-not-be-NULL function argument.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ 443,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_possible_null_argument), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [444] = */ {
    "-Wanalyzer-possible-null-dereference",
    "Warn about code paths in which a possibly-NULL pointer is dereferenced.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 35, /* .neg_idx = */ 444,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_possible_null_dereference), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [445] = */ {
    "-Wanalyzer-shift-count-negative",
    "Warn about code paths in which a shift with negative count is attempted.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 445,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_shift_count_negative), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [446] = */ {
    "-Wanalyzer-shift-count-overflow",
    "Warn about code paths in which a shift with count >= width of type is attempted.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 446,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_shift_count_overflow), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [447] = */ {
    "-Wanalyzer-stale-setjmp-buffer",
    "Warn about code paths in which a longjmp rewinds to a jmp_buf saved in a stack frame that has returned.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 447,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_stale_setjmp_buffer), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [448] = */ {
    "-Wanalyzer-tainted-array-index",
    "Warn about code paths in which an unsanitized value is used as an array index.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 448,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_tainted_array_index), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [449] = */ {
    "-Wanalyzer-too-complex",
    "Warn if the code is too complicated for the analyzer to fully explore.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 449,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_too_complex), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [450] = */ {
    "-Wanalyzer-unsafe-call-within-signal-handler",
    "Warn about code paths in which an async-signal-unsafe function is called from a signal handler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 43, /* .neg_idx = */ 450,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_unsafe_call_within_signal_handler), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [451] = */ {
    "-Wanalyzer-use-after-free",
    "Warn about code paths in which a freed value is used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 451,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_use_after_free), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [452] = */ {
    "-Wanalyzer-use-of-pointer-in-stale-stack-frame",
    "Warn about code paths in which a pointer to a stale stack frame is used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 45, /* .neg_idx = */ 452,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_use_of_pointer_in_stale_stack_frame), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [453] = */ {
    "-Wanalyzer-write-to-const",
    "Warn about code paths which attempt to write to a const object.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 453,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_write_to_const), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [454] = */ {
    "-Wanalyzer-write-to-string-literal",
    "Warn about code paths which attempt to write to a string literal.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ 454,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_analyzer_write_to_string_literal), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [455] = */ {
    "-Wargument-mismatch",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 18, /* .neg_idx = */ 455,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [456] = */ {
    "-Warith-conversion",
    "Warn if conversion of the result of arithmetic might change the value even though converting the operands cannot.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 456,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_arith_conv), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [457] = */ {
    "-Warray-bounds",
    "Warn if an array is accessed out of bounds.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 457,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_array_bounds), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [458] = */ {
    "-Warray-bounds=",
    "Warn if an array is accessed out of bounds.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_array_bounds), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [459] = */ {
    "-Warray-parameter",
    "Warn about mismatched declarations of array parameters and unsafe accesses to them.",
    NULL,
    NULL,
    "2", "0", OPT_Warray_parameter_, N_OPTS, 16, /* .neg_idx = */ 459,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [460] = */ {
    "-Warray-parameter=",
    "Warn about mismatched declarations of array parameters and unsafe accesses to them.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_array_parameter), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [461] = */ {
    "-Warray-temporaries",
    "Warn about creation of array temporaries.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 461,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_array_temporaries), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [462] = */ {
    "-Wassign-intercept",
    "Warn whenever an Objective-C assignment is being intercepted by the garbage collector.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 462,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_assign_intercept), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [463] = */ {
    "-Wattribute-alias",
    "Warn about type safety and similar errors and mismatches in declarations with alias attributes.",
    NULL,
    NULL,
    "1", "0", OPT_Wattribute_alias_, N_OPTS, 16, /* .neg_idx = */ 463,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [464] = */ {
    "-Wattribute-alias=",
    "Warn about type safety and similar errors and mismatches in declarations with alias attributes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_attribute_alias), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [465] = */ {
    "-Wattribute-warning",
    "Warn about uses of __attribute__((warning)) declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 465,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_attribute_warning), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [466] = */ {
    "-Wattributes",
    "Warn about inappropriate attribute usage.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 466,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_attributes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [467] = */ {
    "-Wbad-function-cast",
    "Warn about casting functions to incompatible types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 467,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_bad_function_cast), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [468] = */ {
    "-Wbidi-chars",
    NULL,
    NULL,
    NULL,
    "any", "none", OPT_Wbidi_chars_, N_OPTS, 11, /* .neg_idx = */ 468,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [469] = */ {
    "-Wbidi-chars=",
    "-Wbidi-chars=[none|unpaired|any] Warn about UTF-8 bidirectional control characters.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_bidirectional), 8, CLVC_ENUM, 0, -1, -1 },
 /* [470] = */ {
    "-Wbool-compare",
    "Warn about boolean expression compared with an integer value different from true/false.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 470,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_bool_compare), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [471] = */ {
    "-Wbool-operation",
    "Warn about certain operations on boolean expressions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 471,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_bool_op), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [472] = */ {
    "-Wbuiltin-declaration-mismatch",
    "Warn when a built-in function is declared with the wrong signature.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 472,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_builtin_declaration_mismatch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [473] = */ {
    "-Wbuiltin-macro-redefined",
    "Warn when a built-in preprocessor macro is undefined or redefined.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 473,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_builtin_macro_redefined), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [474] = */ {
    "-Wc++-compat",
    "Warn about C constructs that are not in the common subset of C and C++.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 474,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cxx_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [475] = */ {
    "-Wc++0x-compat",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wc__11_compat, N_OPTS, 13, /* .neg_idx = */ 475,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [476] = */ {
    "-Wc++11-compat",
    "Warn about C++ constructs whose meaning differs between ISO C++ 1998 and ISO C++ 2011.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 476,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cxx11_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [477] = */ {
    "-Wc++14-compat",
    "Warn about C++ constructs whose meaning differs between ISO C++ 2011 and ISO C++ 2014.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 477,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cxx14_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [478] = */ {
    "-Wc++17-compat",
    "Warn about C++ constructs whose meaning differs between ISO C++ 2014 and ISO C++ 2017.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 478,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cxx17_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [479] = */ {
    "-Wc++1z-compat",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wc__17_compat, N_OPTS, 13, /* .neg_idx = */ 479,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [480] = */ {
    "-Wc++20-compat",
    "Warn about C++ constructs whose meaning differs between ISO C++ 2017 and ISO C++ 2020.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 480,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cxx20_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [481] = */ {
    "-Wc++2a-compat",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wc__20_compat, N_OPTS, 13, /* .neg_idx = */ 481,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [482] = */ {
    "-Wc-binding-type",
    "Warn if the type of a variable might be not interoperable with C.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 482,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_c_binding_type), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [483] = */ {
    "-Wc11-c2x-compat",
    "Warn about features not present in ISO C11, but present in ISO C2X.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 483,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_c11_c2x_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [484] = */ {
    "-Wc90-c99-compat",
    "Warn about features not present in ISO C90, but present in ISO C99.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 484,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_c90_c99_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [485] = */ {
    "-Wc99-c11-compat",
    "Warn about features not present in ISO C99, but present in ISO C11.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 485,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_c99_c11_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [486] = */ {
    "-Wcannot-profile",
    "Warn when profiling instrumentation was requested, but could not be applied to a certain function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 486,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cannot_profile), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [487] = */ {
    "-Wcast-align",
    "Warn about pointer casts which increase alignment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 487,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cast_align), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [488] = */ {
    "-Wcast-align=strict",
    "Warn about pointer casts which increase alignment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 488,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cast_align), 0, CLVC_EQUAL, 2, -1, -1 },
 /* [489] = */ {
    "-Wcast-function-type",
    "Warn about casts between incompatible function types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 489,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cast_function_type), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [490] = */ {
    "-Wcast-qual",
    "Warn about casts which discard qualifiers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 490,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cast_qual), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [491] = */ {
    "-Wcast-result",
    "Warn about casts that will produce a null result.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 491,
    CL_D | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cast_result), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [492] = */ {
    "-Wcatch-value",
    "Warn about catch handlers of non-reference type.",
    NULL,
    NULL,
    "1", "0", OPT_Wcatch_value_, N_OPTS, 12, /* .neg_idx = */ 492,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [493] = */ {
    "-Wcatch-value=",
    "Warn about catch handlers of non-reference type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_catch_value), 0, CLVC_BOOLEAN, 0, 0, 3 },
 /* [494] = */ {
    "-Wchar-subscripts",
    "Warn about subscripts whose type is \"char\".",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 494,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_char_subscripts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [495] = */ {
    "-Wcharacter-truncation",
    "Warn about truncated character expressions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 495,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_character_truncation), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [496] = */ {
    "-Wchkp",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 5, /* .neg_idx = */ 496,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [497] = */ {
    "-Wclass-conversion",
    "Warn when a conversion function will never be called due to the type it converts to.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 497,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_class_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [498] = */ {
    "-Wclass-memaccess",
    "Warn for unsafe raw memory writes to objects of class types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 498,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_class_memaccess), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [499] = */ {
    "-Wclobbered",
    "Warn about variables that might be changed by \"longjmp\" or \"vfork\".",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 499,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_clobbered), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [500] = */ {
    "-Wcomma-subscript",
    "Warn about uses of a comma operator within a subscripting expression.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 500,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_comma_subscript), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [501] = */ {
    "-Wcomment",
    "Warn about possibly nested block comments, and C++ comments spanning more than one physical line.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 501,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_comment), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [502] = */ {
    "-Wcomments",
    "Synonym for -Wcomment.",
    NULL,
    NULL,
    NULL, NULL, OPT_Wcomment, N_OPTS, 9, /* .neg_idx = */ 502,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [503] = */ {
    "-Wcompare-reals",
    "Warn about equality comparisons involving REAL or COMPLEX expressions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 503,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_compare_reals), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [504] = */ {
    "-Wconditionally-supported",
    "Warn for conditionally-supported constructs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 504,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_conditionally_supported), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [505] = */ {
    "-Wconversion",
    "Warn for implicit type conversions that may change a value.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 505,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [506] = */ {
    "-Wconversion-extra",
    "Warn about most implicit conversions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 506,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_conversion_extra), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [507] = */ {
    "-Wconversion-null",
    "Warn for converting NULL from/to a non-pointer type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 507,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_conversion_null), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [508] = */ {
    "-Wcoverage-mismatch",
    "Warn in case profiles in -fprofile-use do not match.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 508,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_coverage_mismatch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [509] = */ {
    "-Wcpp",
    "Warn when a #warning directive is encountered.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 509,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cpp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [510] = */ {
    "-Wctad-maybe-unsupported",
    "Warn when performing class template argument deduction on a type with no deduction guides.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 510,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ctad_maybe_unsupported), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [511] = */ {
    "-Wctor-dtor-privacy",
    "Warn when all constructors and destructors are private.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 511,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ctor_dtor_privacy), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [512] = */ {
    "-Wdangling-else",
    "Warn about dangling else.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 512,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_dangling_else), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [513] = */ {
    "-Wdate-time",
    "Warn about __TIME__, __DATE__ and __TIMESTAMP__ usage.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 513,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_date_time), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [514] = */ {
    "-Wdeclaration-after-statement",
    "Warn when a declaration is found after a statement.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ 514,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_declaration_after_statement), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [515] = */ {
    "-Wdelete-incomplete",
    "Warn when deleting a pointer to incomplete type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 515,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_delete_incomplete), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [516] = */ {
    "-Wdelete-non-virtual-dtor",
    "Warn about deleting polymorphic objects with non-virtual destructors.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 516,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_delnonvdtor), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [517] = */ {
    "-Wdeprecated",
    "Warn if a deprecated compiler feature, class, method, or field is used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 517,
    CL_C | CL_CXX | CL_D | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_deprecated), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [518] = */ {
    "-Wdeprecated-copy",
    "Mark implicitly-declared copy operations as deprecated if the class has a user-provided copy operation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 518,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_deprecated_copy), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [519] = */ {
    "-Wdeprecated-copy-dtor",
    "Mark implicitly-declared copy operations as deprecated if the class has a user-provided copy operation or destructor.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 519,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_deprecated_copy), 0, CLVC_EQUAL, 2, -1, -1 },
 /* [520] = */ {
    "-Wdeprecated-declarations",
    "Warn about uses of __attribute__((deprecated)) declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 520,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_deprecated_decl), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [521] = */ {
    "-Wdeprecated-enum-enum-conversion",
    "Warn about deprecated arithmetic conversions on operands of enumeration types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ 521,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_deprecated_enum_enum_conv), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [522] = */ {
    "-Wdeprecated-enum-float-conversion",
    "Warn about deprecated arithmetic conversions on operands where one is of enumeration type and the other is of a floating-point type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ 522,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_deprecated_enum_float_conv), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [523] = */ {
    "-Wdesignated-init",
    "Warn about positional initialization of structs requiring designated initializers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 523,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_designated_init), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [524] = */ {
    "-Wdisabled-optimization",
    "Warn when an optimization pass is disabled.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 524,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_disabled_optimization), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [525] = */ {
    "-Wdiscarded-array-qualifiers",
    "Warn if qualifiers on arrays which are pointer targets are discarded.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 525,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_discarded_array_qualifiers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [526] = */ {
    "-Wdiscarded-qualifiers",
    "Warn if type qualifiers on pointers are discarded.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 526,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_discarded_qualifiers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [527] = */ {
    "-Wdiv-by-zero",
    "Warn about compile-time integer division by zero.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 527,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_div_by_zero), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [528] = */ {
    "-Wdo-subscript",
    "Warn about possibly incorrect subscripts in do loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 528,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_do_subscript), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [529] = */ {
    "-Wdouble-promotion",
    "Warn about implicit conversions from \"float\" to \"double\".",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 529,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_double_promotion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [530] = */ {
    "-Wduplicate-decl-specifier",
    "Warn when a declaration has duplicate const, volatile, restrict or _Atomic specifier.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 530,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_duplicate_decl_specifier), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [531] = */ {
    "-Wduplicated-branches",
    "Warn about duplicated branches in if-else statements.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 531,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_duplicated_branches), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [532] = */ {
    "-Wduplicated-cond",
    "Warn about duplicated conditions in an if-else-if chain.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 532,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_duplicated_cond), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [533] = */ {
    "-Weffc++",
    "Warn about violations of Effective C++ style rules.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 533,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ecpp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [534] = */ {
    "-Wempty-body",
    "Warn about an empty body in an if or else statement.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 534,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_empty_body), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [535] = */ {
    "-Wendif-labels",
    "Warn about stray tokens after #else and #endif.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 535,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_endif_labels), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [536] = */ {
    "-Wenum-compare",
    "Warn about comparison of different enum types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 536,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_enum_compare), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [537] = */ {
    "-Wenum-conversion",
    "Warn about implicit conversion of enum types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 537,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_enum_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [538] = */ {
    "-Werror",
    "Treat all warnings as errors.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 538,
    CL_C | CL_CXX | CL_D | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warnings_are_errors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [539] = */ {
    "-Werror-implicit-function-declaration",
    "This switch is deprecated; use -Werror=implicit-function-declaration instead.",
    NULL,
    NULL,
    "implicit-function-declaration", NULL, OPT_Werror_, N_OPTS, 36, /* .neg_idx = */ -1,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [540] = */ {
    "-Werror=",
    "Treat specified warning as error.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 540,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [541] = */ {
    "-Wexceptions",
    "Warn when an exception handler is shadowed by another handler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 541,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_exceptions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [542] = */ {
    "-Wexpansion-to-defined",
    "Warn if \"defined\" is used outside #if.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 542,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_expansion_to_defined), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [543] = */ {
    "-Wextra",
    "Print extra (possibly unwanted) warnings.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 543,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_extra_warnings), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [544] = */ {
    "-Wextra-semi",
    "Warn about semicolon after in-class function definition.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 544,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_extra_semi), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [545] = */ {
    "-Wfatal-errors",
    "Exit on the first error occurred.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 545,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fatal_errors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [546] = */ {
    "-Wfloat-conversion",
    "Warn for implicit type conversions that cause loss of floating point precision.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 546,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_float_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [547] = */ {
    "-Wfloat-equal",
    "Warn if testing floating point numbers for equality.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 547,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_float_equal), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [548] = */ {
    "-Wformat",
    "Warn about printf/scanf/strftime/strfmon format string anomalies.",
    NULL,
    NULL,
    "1", "0", OPT_Wformat_, N_OPTS, 7, /* .neg_idx = */ 548,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [549] = */ {
    "-Wformat-contains-nul",
    "Warn about format strings that contain NUL bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 549,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_contains_nul), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [550] = */ {
    "-Wformat-diag",
    "Warn about GCC format strings with strings unsuitable for diagnostics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 550,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_diag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [551] = */ {
    "-Wformat-extra-args",
    "Warn if passing too many arguments to a function for its format string.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 551,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_extra_args), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [552] = */ {
    "-Wformat-nonliteral",
    "Warn about format strings that are not literals.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 552,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_nonliteral), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [553] = */ {
    "-Wformat-overflow",
    "Warn about function calls with format strings that write past the end of the destination region.  Same as -Wformat-overflow=1.",
    NULL,
    NULL,
    "1", "0", OPT_Wformat_overflow_, N_OPTS, 16, /* .neg_idx = */ 553,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [554] = */ {
    "-Wformat-overflow=",
    "Warn about function calls with format strings that write past the end of the destination region.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_overflow), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [555] = */ {
    "-Wformat-security",
    "Warn about possible security problems with format functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 555,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_security), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [556] = */ {
    "-Wformat-signedness",
    "Warn about sign differences with format functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 556,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_signedness), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [557] = */ {
    "-Wformat-truncation",
    "Warn about calls to snprintf and similar functions that truncate output. Same as -Wformat-truncation=1.",
    NULL,
    NULL,
    "1", "0", OPT_Wformat_truncation_, N_OPTS, 18, /* .neg_idx = */ 557,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [558] = */ {
    "-Wformat-truncation=",
    "Warn about calls to snprintf and similar functions that truncate output.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_trunc), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [559] = */ {
    "-Wformat-y2k",
    "Warn about strftime formats yielding 2-digit years.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 559,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_y2k), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [560] = */ {
    "-Wformat-zero-length",
    "Warn about zero-length formats.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 560,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_zero_length), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [561] = */ {
    "-Wformat=",
    "Warn about printf/scanf/strftime/strfmon format string anomalies.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [562] = */ {
    "-Wframe-address",
    "Warn when __builtin_frame_address or __builtin_return_address is used unsafely.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 562,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_frame_address), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [563] = */ {
    "-Wframe-larger-than=",
    "-Wframe-larger-than=<byte-size>	Warn if a function's stack frame requires in excess of <byte-size>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* ByteSize */,
    offsetof (struct gcc_options, x_warn_frame_larger_than_size), 0, CLVC_SIZE, 0, -1, -1 },
 /* [564] = */ {
    "-Wfree-nonheap-object",
    "Warn when attempting to free a non-heap object.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 564,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_free_nonheap_object), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [565] = */ {
    "-Wfrontend-loop-interchange",
    "Warn if loops have been interchanged.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 565,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_warn_frontend_loop_interchange), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [566] = */ {
    "-Wfunction-elimination",
    "Warn about function call elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 566,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_function_elimination), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [567] = */ {
    "-Whsa",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 4, /* .neg_idx = */ 567,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [568] = */ {
    "-Wif-not-aligned",
    "Warn when the field in a struct is not aligned.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 568,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_if_not_aligned), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [569] = */ {
    "-Wignored-attributes",
    "Warn whenever attributes are ignored.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 569,
    CL_C | CL_CXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ignored_attributes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [570] = */ {
    "-Wignored-qualifiers",
    "Warn whenever type qualifiers are ignored.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 570,
    CL_C | CL_CXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ignored_qualifiers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [571] = */ {
    "-Wimplicit",
    "Warn about implicit declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 571,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [572] = */ {
    "-Wimplicit-fallthrough",
    NULL,
    NULL,
    NULL,
    "3", "0", OPT_Wimplicit_fallthrough_, N_OPTS, 21, /* .neg_idx = */ 572,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [573] = */ {
    "-Wimplicit-fallthrough=",
    "Warn when a switch case falls through.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit_fallthrough), 0, CLVC_BOOLEAN, 0, 0, 5 },
 /* [574] = */ {
    "-Wimplicit-function-declaration",
    "Warn about implicit function declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 574,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit_function_declaration), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [575] = */ {
    "-Wimplicit-int",
    "Warn when a declaration does not specify a type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 575,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit_int), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [576] = */ {
    "-Wimplicit-interface",
    "Warn about calls with implicit interface.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 576,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit_interface), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [577] = */ {
    "-Wimplicit-procedure",
    "Warn about called procedures not explicitly declared.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 577,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit_procedure), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [578] = */ {
    "-Wimport",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 7, /* .neg_idx = */ 578,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [579] = */ {
    "-Winaccessible-base",
    "Warn when a base is inaccessible in derived due to ambiguity.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 579,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_inaccessible_base), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [580] = */ {
    "-Wincompatible-pointer-types",
    "Warn when there is a conversion between pointers that have incompatible types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 580,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_incompatible_pointer_types), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [581] = */ {
    "-Winherited-variadic-ctor",
    "Warn about C++11 inheriting constructors when the base has a variadic constructor.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 581,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_inh_var_ctor), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [582] = */ {
    "-Winit-list-lifetime",
    "Warn about uses of std::initializer_list that can result in dangling pointers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 582,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_init_list), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [583] = */ {
    "-Winit-self",
    "Warn about variables which are initialized to themselves.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 583,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_init_self), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [584] = */ {
    "-Winline",
    "Warn when an inlined function cannot be inlined.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 584,
    CL_COMMON | CL_WARNING | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_inline), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [585] = */ {
    "-Wint-conversion",
    "Warn about incompatible integer to pointer and pointer to integer conversions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 585,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_int_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [586] = */ {
    "-Wint-in-bool-context",
    "Warn for suspicious integer expressions in boolean context.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 586,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_int_in_bool_context), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [587] = */ {
    "-Wint-to-pointer-cast",
    "Warn when there is a cast to a pointer from an integer of a different size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 587,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_int_to_pointer_cast), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [588] = */ {
    "-Winteger-division",
    "Warn about constant integer divisions with truncated results.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 588,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_integer_division), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [589] = */ {
    "-Wintrinsic-shadow",
    "Warn if a user-procedure has the same name as an intrinsic.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 589,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_intrinsic_shadow), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [590] = */ {
    "-Wintrinsics-std",
    "Warn on intrinsics not part of the selected standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 590,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_intrinsics_std), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [591] = */ {
    "-Winvalid-imported-macros",
    "Warn about macros that have conflicting header units definitions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 591,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_imported_macros), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [592] = */ {
    "-Winvalid-memory-model",
    "Warn when an atomic memory model parameter is known to be outside the valid range.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 592,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_invalid_memory_model), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [593] = */ {
    "-Winvalid-offsetof",
    "Warn about invalid uses of the \"offsetof\" macro.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 593,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_invalid_offsetof), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [594] = */ {
    "-Winvalid-pch",
    "Warn about PCH files that are found but not used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 594,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_invalid_pch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [595] = */ {
    "-Wjump-misses-init",
    "Warn when a jump misses a variable initialization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 595,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_jump_misses_init), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [596] = */ {
    "-Wl,",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 3, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [597] = */ {
    "-Wlarger-than-",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wlarger_than_, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_UNDOCUMENTED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [598] = */ {
    "-Wlarger-than=",
    "-Wlarger-than=<byte-size>	Warn if an object's size exceeds <byte-size>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* ByteSize */,
    offsetof (struct gcc_options, x_warn_larger_than_size), 0, CLVC_SIZE, 0, -1, -1 },
 /* [599] = */ {
    "-Wline-truncation",
    "Warn about truncated source lines.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 599,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_line_truncation), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [600] = */ {
    "-Wliteral-suffix",
    "Warn when a string or character literal is followed by a ud-suffix which does not begin with an underscore.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 600,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_literal_suffix), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [601] = */ {
    "-Wlogical-not-parentheses",
    "Warn when logical not is used on the left hand side operand of a comparison.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 601,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_logical_not_paren), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [602] = */ {
    "-Wlogical-op",
    "Warn when a logical operator is suspiciously always evaluating to true or false.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 602,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_logical_op), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [603] = */ {
    "-Wlong-long",
    "Do not warn about using \"long long\" when -pedantic.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 603,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_long_long), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [604] = */ {
    "-Wlto-type-mismatch",
    "During link time optimization warn about mismatched types of global declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 604,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_lto_type_mismatch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [605] = */ {
    "-Wmain",
    "Warn about suspicious declarations of \"main\".",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 605,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_main), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [606] = */ {
    "-Wmaybe-uninitialized",
    "Warn about maybe uninitialized automatic variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 606,
    CL_C | CL_CXX | CL_Fortran | CL_LTO | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_maybe_uninitialized), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [607] = */ {
    "-Wmemset-elt-size",
    "Warn about suspicious calls to memset where the third argument contains the number of elements not multiplied by the element size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 607,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_memset_elt_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [608] = */ {
    "-Wmemset-transposed-args",
    "Warn about suspicious calls to memset where the third argument is constant literal zero and the second is not.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 608,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_memset_transposed_args), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [609] = */ {
    "-Wmisleading-indentation",
    "Warn when the indentation of the code does not reflect the block structure.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 609,
    CL_C | CL_CXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_misleading_indentation), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [610] = */ {
    "-Wmismatched-dealloc",
    "Warn for deallocation calls with arguments returned from mismatched allocation functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 610,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_mismatched_alloc), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [611] = */ {
    "-Wmismatched-new-delete",
    "Warn for mismatches between calls to operator new or delete and the corresponding call to the allocation or deallocation function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 611,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_mismatched_new_delete), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [612] = */ {
    "-Wmismatched-tags",
    "Warn when a class is redeclared or referenced using a mismatched class-key.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 612,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_mismatched_tags), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [613] = */ {
    "-Wmissing-attributes",
    "Warn about declarations of entities that may be missing attributes that related entities have been declared with.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 613,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_attributes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [614] = */ {
    "-Wmissing-braces",
    "Warn about possibly missing braces around initializers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 614,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_braces), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [615] = */ {
    "-Wmissing-declarations",
    "Warn about global functions without previous declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 615,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_declarations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [616] = */ {
    "-Wmissing-field-initializers",
    "Warn about missing fields in struct initializers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 616,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_field_initializers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [617] = */ {
    "-Wmissing-format-attribute",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wsuggest_attribute_format, N_OPTS, 25, /* .neg_idx = */ 617,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [618] = */ {
    "-Wmissing-include-dirs",
    "Warn about user-specified include directories that do not exist.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 618,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_missing_include_dirs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [619] = */ {
    "-Wmissing-noreturn",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wsuggest_attribute_noreturn, N_OPTS, 17, /* .neg_idx = */ 619,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [620] = */ {
    "-Wmissing-parameter-type",
    "Warn about function parameters declared without a type specifier in K&R-style functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 620,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_parameter_type), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [621] = */ {
    "-Wmissing-profile",
    "Warn in case profiles in -fprofile-use do not exist.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 621,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_profile), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [622] = */ {
    "-Wmissing-prototypes",
    "Warn about global functions without prototypes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 622,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_prototypes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [623] = */ {
    "-Wmudflap",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 8, /* .neg_idx = */ 623,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [624] = */ {
    "-Wmultichar",
    "Warn about use of multi-character character constants.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 624,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_multichar), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [625] = */ {
    "-Wmultiple-inheritance",
    "Warn on direct multiple inheritance.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 625,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_multiple_inheritance), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [626] = */ {
    "-Wmultistatement-macros",
    "Warn about unsafe macros expanding to multiple statements used as a body of a clause such as if, else, while, switch, or for.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 626,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_multistatement_macros), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [627] = */ {
    "-Wnamespaces",
    "Warn on namespace definition.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 627,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_namespaces), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [628] = */ {
    "-Wnarrowing",
    "Warn about narrowing conversions within { } that are ill-formed in C++11.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 628,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_narrowing), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [629] = */ {
    "-Wnested-externs",
    "Warn about \"extern\" declarations not at file scope.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 629,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nested_externs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [630] = */ {
    "-Wno-alloc-size-larger-than",
    "Disable Walloc-size-larger-than= warning.  Equivalent to Walloc-size-larger-than=<SIZE_MAX> or larger.",
    NULL,
    NULL,
    "18446744073709551615EiB", "none", OPT_Walloc_size_larger_than_, N_OPTS, 26, /* .neg_idx = */ 630,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [631] = */ {
    "-Wno-alloca-larger-than",
    "Disable Walloca-larger-than= warning.  Equivalent to Walloca-larger-than=<SIZE_MAX> or larger.",
    NULL,
    NULL,
    "18446744073709551615EiB", "none", OPT_Walloca_larger_than_, N_OPTS, 22, /* .neg_idx = */ 631,
    CL_C | CL_CXX | CL_D | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [632] = */ {
    "-Wno-frame-larger-than",
    "Disable -Wframe-larger-than= warning.  Equivalent to -Wframe-larger-than=<SIZE_MAX> or larger.",
    NULL,
    NULL,
    "18446744073709551615EiB", "none", OPT_Wframe_larger_than_, N_OPTS, 21, /* .neg_idx = */ 632,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [633] = */ {
    "-Wno-larger-than",
    "Disable -Wlarger-than= warning.  Equivalent to -Wlarger-than=<SIZE_MAX> or larger.",
    NULL,
    NULL,
    "18446744073709551615EiB", "none", OPT_Wlarger_than_, N_OPTS, 15, /* .neg_idx = */ 633,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [634] = */ {
    "-Wno-stack-usage",
    "Disable Wstack-usage= warning.  Equivalent to Wstack-usage=<SIZE_MAX> or larger.",
    NULL,
    NULL,
    "18446744073709551615EiB", "none", OPT_Wstack_usage_, N_OPTS, 15, /* .neg_idx = */ 634,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [635] = */ {
    "-Wno-vla-larger-than",
    "Disable Wvla-larger-than= warning.  Equivalent to Wvla-larger-than=<SIZE_MAX> or larger.",
    NULL,
    NULL,
    "18446744073709551615EiB", "none", OPT_Wvla_larger_than_, N_OPTS, 19, /* .neg_idx = */ 635,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [636] = */ {
    "-Wnoexcept",
    "Warn when a noexcept expression evaluates to false even though the expression can't actually throw.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 636,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_noexcept), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [637] = */ {
    "-Wnoexcept-type",
    "Warn if C++17 noexcept function type will change the mangled name of a symbol.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 637,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_noexcept_type), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [638] = */ {
    "-Wnon-template-friend",
    "Warn when non-templatized friend functions are declared within a template.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 638,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nontemplate_friend), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [639] = */ {
    "-Wnon-virtual-dtor",
    "Warn about non-virtual destructors.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 639,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nonvdtor), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [640] = */ {
    "-Wnonnull",
    "Warn about NULL being passed to argument slots marked as requiring non-NULL.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 640,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nonnull), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [641] = */ {
    "-Wnonnull-compare",
    "Warn if comparing pointer parameter with nonnull attribute with NULL.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 641,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nonnull_compare), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [642] = */ {
    "-Wnormalized",
    NULL,
    NULL,
    NULL,
    "nfc", "none", OPT_Wnormalized_, N_OPTS, 11, /* .neg_idx = */ 642,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [643] = */ {
    "-Wnormalized=",
    "-Wnormalized=[none|id|nfc|nfkc]	Warn about non-normalized Unicode strings.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_normalize), 9, CLVC_ENUM, 0, -1, -1 },
 /* [644] = */ {
    "-Wnull-dereference",
    "Warn if dereferencing a NULL pointer may lead to erroneous or undefined behavior.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 644,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_null_dereference), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [645] = */ {
    "-Wobjc-root-class",
    "Warn if a class interface has no superclass.  Root classes may use an attribute to suppress this warning.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 645,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_objc_root_class), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [646] = */ {
    "-Wodr",
    "Warn about some C++ One Definition Rule violations during link time optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 646,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_odr_violations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [647] = */ {
    "-Wold-style-cast",
    "Warn if a C-style cast is used in a program.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 647,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_old_style_cast), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [648] = */ {
    "-Wold-style-declaration",
    "Warn for obsolescent usage in a declaration.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 648,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_old_style_declaration), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [649] = */ {
    "-Wold-style-definition",
    "Warn if an old-style parameter definition is used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 649,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_old_style_definition), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [650] = */ {
    "-Wopenmp-simd",
    "Warn if a simd directive is overridden by the vectorizer cost model.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 650,
    CL_C | CL_CXX | CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_openmp_simd), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [651] = */ {
    "-Woverflow",
    "Warn about overflow in arithmetic expressions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 651,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_overflow), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [652] = */ {
    "-Woverlength-strings",
    "Warn if a string is longer than the maximum portable length specified by the standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 652,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_overlength_strings), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [653] = */ {
    "-Woverloaded-virtual",
    "Warn about overloaded virtual function names.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 653,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_overloaded_virtual), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [654] = */ {
    "-Woverride-init",
    "Warn about overriding initializers without side effects.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 654,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_override_init), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [655] = */ {
    "-Woverride-init-side-effects",
    "Warn about overriding initializers with side effects.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 655,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_override_init_side_effects), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [656] = */ {
    "-Woverwrite-recursive",
    "Warn that -fno-automatic may break recursion.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 656,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_overwrite_recursive), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [657] = */ {
    "-Wp,",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 3, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [658] = */ {
    "-Wpacked",
    "Warn when the packed attribute has no effect on struct layout.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 658,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_packed), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [659] = */ {
    "-Wpacked-bitfield-compat",
    "Warn about packed bit-fields whose offset changed in GCC 4.4.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 659,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_packed_bitfield_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [660] = */ {
    "-Wpacked-not-aligned",
    "Warn when fields in a struct with the packed attribute are misaligned.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 660,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_packed_not_aligned), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [661] = */ {
    "-Wpadded",
    "Warn when padding is required to align structure members.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 661,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_padded), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [662] = */ {
    "-Wparentheses",
    "Warn about possibly missing parentheses.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 662,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_parentheses), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [663] = */ {
    "-Wpedantic",
    "Issue warnings needed for strict compliance to the standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 663,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_pedantic), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [664] = */ {
    "-Wpessimizing-move",
    "Warn about calling std::move on a local object in a return statement preventing copy elision.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 664,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pessimizing_move), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [665] = */ {
    "-Wplacement-new",
    "Warn for placement new expressions with undefined behavior.",
    NULL,
    NULL,
    "1", "0", OPT_Wplacement_new_, N_OPTS, 14, /* .neg_idx = */ 665,
    CL_CXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [666] = */ {
    "-Wplacement-new=",
    "Warn for placement new expressions with undefined behavior.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_CXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_placement_new), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [667] = */ {
    "-Wpmf-conversions",
    "Warn when converting the type of pointers to member functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 667,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pmf2ptr), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [668] = */ {
    "-Wpointer-arith",
    "Warn about function pointer arithmetic.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 668,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pointer_arith), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [669] = */ {
    "-Wpointer-compare",
    "Warn when a pointer is compared with a zero character constant.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 669,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pointer_compare), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [670] = */ {
    "-Wpointer-sign",
    "Warn when a pointer differs in signedness in an assignment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 670,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pointer_sign), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [671] = */ {
    "-Wpointer-to-int-cast",
    "Warn when a pointer is cast to an integer of a different size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 671,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pointer_to_int_cast), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [672] = */ {
    "-Wpoison-system-directories",
    "Warn for -I and -L options using system directories if cross compiling",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 672,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_poison_system_directories), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [673] = */ {
    "-Wpragmas",
    "Warn about misuses of pragmas.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 673,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pragmas), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [674] = */ {
    "-Wprio-ctor-dtor",
    "Warn if constructor or destructors with priorities from 0 to 100 are used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 674,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_prio_ctor_dtor), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [675] = */ {
    "-Wproperty-assign-default",
    "Warn if a property for an Objective-C object has no assign semantics specified.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 675,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_property_assign_default), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [676] = */ {
    "-Wprotocol",
    "Warn if inherited methods are unimplemented.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 676,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_protocol), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [677] = */ {
    "-Wpsabi",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 677,
    CL_C | CL_CXX | CL_D | CL_LTO | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_psabi), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [678] = */ {
    "-Wrange-loop-construct",
    "Warn when a range-based for-loop is creating unnecessary copies.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 678,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_range_loop_construct), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [679] = */ {
    "-Wreal-q-constant",
    "Warn about real-literal-constants with 'q' exponent-letter.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 679,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_real_q_constant), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [680] = */ {
    "-Wrealloc-lhs",
    "Warn when a left-hand-side array variable is reallocated.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 680,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_realloc_lhs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [681] = */ {
    "-Wrealloc-lhs-all",
    "Warn when a left-hand-side variable is reallocated.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 681,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_realloc_lhs_all), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [682] = */ {
    "-Wredundant-decls",
    "Warn about multiple declarations of the same object.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 682,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_redundant_decls), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [683] = */ {
    "-Wredundant-move",
    "Warn about redundant calls to std::move.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 683,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_redundant_move), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [684] = */ {
    "-Wredundant-tags",
    "Warn when a class or enumerated type is referenced using a redundant class-key.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 684,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_redundant_tags), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [685] = */ {
    "-Wregister",
    "Warn about uses of register storage specifier.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 685,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_register), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [686] = */ {
    "-Wreorder",
    "Warn when the compiler reorders code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 686,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_reorder), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [687] = */ {
    "-Wrestrict",
    "Warn when an argument passed to a restrict-qualified parameter aliases with another argument.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 687,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_restrict), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [688] = */ {
    "-Wreturn-local-addr",
    "Warn about returning a pointer/reference to a local or temporary variable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 688,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_return_local_addr), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [689] = */ {
    "-Wreturn-type",
    "Warn whenever a function's return type defaults to \"int\" (C), or about inconsistent return types (C++).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 689,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_return_type), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [690] = */ {
    "-Wscalar-storage-order",
    "Warn on suspicious constructs involving reverse scalar storage order.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 690,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_scalar_storage_order), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [691] = */ {
    "-Wselector",
    "Warn if a selector has multiple methods.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 691,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_selector), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [692] = */ {
    "-Wsequence-point",
    "Warn about possible violations of sequence point rules.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 692,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sequence_point), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [693] = */ {
    "-Wshadow",
    "Warn when one variable shadows another.  Same as -Wshadow=global.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 693,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shadow), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [694] = */ {
    "-Wshadow-compatible-local",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wshadow_compatible_local, N_OPTS, 24, /* .neg_idx = */ 694,
    CL_COMMON | CL_UNDOCUMENTED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [695] = */ {
    "-Wshadow-ivar",
    "Warn if a local declaration hides an instance variable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 695,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shadow_ivar), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [696] = */ {
    "-Wshadow-local",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wshadow_local, N_OPTS, 13, /* .neg_idx = */ 696,
    CL_COMMON | CL_UNDOCUMENTED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [697] = */ {
    "-Wshadow=compatible-local",
    "Warn when one local variable shadows another local variable or parameter of compatible type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 697,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shadow_compatible_local), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [698] = */ {
    "-Wshadow=global",
    "Warn when one variable shadows another (globally).",
    NULL,
    NULL,
    NULL, NULL, OPT_Wshadow, N_OPTS, 14, /* .neg_idx = */ 698,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [699] = */ {
    "-Wshadow=local",
    "Warn when one local variable shadows another local variable or parameter.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 699,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shadow_local), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [700] = */ {
    "-Wshift-count-negative",
    "Warn if shift count is negative.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 700,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shift_count_negative), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [701] = */ {
    "-Wshift-count-overflow",
    "Warn if shift count >= width of type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 701,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shift_count_overflow), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [702] = */ {
    "-Wshift-negative-value",
    "Warn if left shifting a negative value.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 702,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shift_negative_value), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [703] = */ {
    "-Wshift-overflow",
    "Warn if left shift of a signed value overflows.",
    NULL,
    NULL,
    "1", "0", OPT_Wshift_overflow_, N_OPTS, 15, /* .neg_idx = */ 703,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [704] = */ {
    "-Wshift-overflow=",
    "Warn if left shift of a signed value overflows.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shift_overflow), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [705] = */ {
    "-Wsign-compare",
    "Warn about signed-unsigned comparisons.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 705,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sign_compare), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [706] = */ {
    "-Wsign-conversion",
    "Warn for implicit type conversions between signed and unsigned integers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 706,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sign_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [707] = */ {
    "-Wsign-promo",
    "Warn when overload promotes from unsigned to signed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 707,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sign_promo), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [708] = */ {
    "-Wsized-deallocation",
    "Warn about missing sized deallocation functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 708,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sized_deallocation), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [709] = */ {
    "-Wsizeof-array-argument",
    "Warn when sizeof is applied on a parameter declared as an array.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 709,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sizeof_array_argument), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [710] = */ {
    "-Wsizeof-array-div",
    "Warn about divisions of two sizeof operators when the first one is applied to an array and the divisor does not equal the size of the array element.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 710,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sizeof_array_div), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [711] = */ {
    "-Wsizeof-pointer-div",
    "Warn about suspicious divisions of two sizeof expressions that don't work correctly with pointers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 711,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sizeof_pointer_div), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [712] = */ {
    "-Wsizeof-pointer-memaccess",
    "Warn about suspicious length parameters to certain string functions if the argument uses sizeof.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 712,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sizeof_pointer_memaccess), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [713] = */ {
    "-Wspeculative",
    "Warn from speculative compiles such as __traits(compiles).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 713,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [714] = */ {
    "-Wstack-protector",
    "Warn when not issuing stack smashing protection for some reason.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 714,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_stack_protect), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [715] = */ {
    "-Wstack-usage=",
    "-Wstack-usage=<byte-size>	Warn if stack usage might exceed <byte-size>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* ByteSize */,
    offsetof (struct gcc_options, x_warn_stack_usage), 0, CLVC_SIZE, 0, -1, -1 },
 /* [716] = */ {
    "-Wstrict-aliasing",
    "Warn about code which might break strict aliasing rules.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 716,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [717] = */ {
    "-Wstrict-aliasing=",
    "Warn about code which might break strict aliasing rules.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_aliasing), 0, CLVC_BOOLEAN, 0, 0, 3 },
 /* [718] = */ {
    "-Wstrict-null-sentinel",
    "Warn about uncasted NULL used as sentinel.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 718,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_null_sentinel), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [719] = */ {
    "-Wstrict-overflow",
    "Warn about optimizations that assume that signed overflow is undefined.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 719,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [720] = */ {
    "-Wstrict-overflow=",
    "Warn about optimizations that assume that signed overflow is undefined.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_overflow), 0, CLVC_BOOLEAN, 0, 0, 5 },
 /* [721] = */ {
    "-Wstrict-prototypes",
    "Warn about unprototyped function declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 721,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_prototypes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [722] = */ {
    "-Wstrict-selector-match",
    "Warn if type signatures of candidate methods do not match exactly.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 722,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_selector_match), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [723] = */ {
    "-Wstring-compare",
    "Warn about calls to strcmp and strncmp used in equality expressions that are necessarily true or false due to the length of one and size of the other argument.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 723,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_string_compare), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [724] = */ {
    "-Wstringop-overflow",
    "Warn about buffer overflow in string manipulation functions like memcpy and strcpy.",
    NULL,
    NULL,
    "2", "0", OPT_Wstringop_overflow_, N_OPTS, 18, /* .neg_idx = */ 724,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [725] = */ {
    "-Wstringop-overflow=",
    "Under the control of Object Size type, warn about buffer overflow in string manipulation functions like memcpy and strcpy.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_stringop_overflow), 0, CLVC_BOOLEAN, 0, 0, 4 },
 /* [726] = */ {
    "-Wstringop-overread",
    "Warn about reading past the end of a source array in string manipulation functions like memchr and memcpy.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 726,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_stringop_overread), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [727] = */ {
    "-Wstringop-truncation",
    "Warn about truncation in string manipulation functions like strncat and strncpy.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 727,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_stringop_truncation), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [728] = */ {
    "-Wsubobject-linkage",
    "Warn if a class type has a base or a field whose type uses the anonymous namespace or depends on a type with no linkage.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 728,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_subobject_linkage), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [729] = */ {
    "-Wsuggest-attribute=cold",
    "Warn about functions which might be candidates for __attribute__((cold)).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 729,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_cold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [730] = */ {
    "-Wsuggest-attribute=const",
    "Warn about functions which might be candidates for __attribute__((const)).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 730,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_const), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [731] = */ {
    "-Wsuggest-attribute=format",
    "Warn about functions which might be candidates for format attributes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 731,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_format), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [732] = */ {
    "-Wsuggest-attribute=malloc",
    "Warn about functions which might be candidates for __attribute__((malloc)).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 732,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_malloc), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [733] = */ {
    "-Wsuggest-attribute=noreturn",
    "Warn about functions which might be candidates for __attribute__((noreturn)).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 733,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_noreturn), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [734] = */ {
    "-Wsuggest-attribute=pure",
    "Warn about functions which might be candidates for __attribute__((pure)).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 734,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_pure), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [735] = */ {
    "-Wsuggest-final-methods",
    "Warn about C++ virtual methods where adding final keyword would improve code quality.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 735,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_final_methods), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [736] = */ {
    "-Wsuggest-final-types",
    "Warn about C++ polymorphic types where adding final keyword would improve code quality.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 736,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_final_types), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [737] = */ {
    "-Wsuggest-override",
    "Suggest that the override keyword be used when the declaration of a virtual function overrides another.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 737,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_override), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [738] = */ {
    "-Wsurprising",
    "Warn about \"suspicious\" constructs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 738,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_surprising), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [739] = */ {
    "-Wswitch",
    "Warn about enumerated switches, with no default, missing a case.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 739,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [740] = */ {
    "-Wswitch-bool",
    "Warn about switches with boolean controlling expression.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 740,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch_bool), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [741] = */ {
    "-Wswitch-default",
    "Warn about enumerated switches missing a \"default:\" statement.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 741,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch_default), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [742] = */ {
    "-Wswitch-enum",
    "Warn about all enumerated switches missing a specific case.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 742,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch_enum), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [743] = */ {
    "-Wswitch-outside-range",
    "Warn about switch values that are outside of the switch's type range.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 743,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch_outside_range), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [744] = */ {
    "-Wswitch-unreachable",
    "Warn about statements between switch's controlling expression and the first case.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 744,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch_unreachable), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [745] = */ {
    "-Wsync-nand",
    "Warn when __sync_fetch_and_nand and __sync_nand_and_fetch built-in functions are used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 745,
    CL_C | CL_CXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sync_nand), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [746] = */ {
    "-Wsynth",
    "Deprecated.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 746,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_synth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [747] = */ {
    "-Wsystem-headers",
    "Do not suppress warnings from system headers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 747,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_system_headers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [748] = */ {
    "-Wtabs",
    "Permit nonconforming uses of the tab character.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 748,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_tabs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [749] = */ {
    "-Wtarget-lifetime",
    "Warn if the pointer in a pointer assignment might outlive its target.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 749,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_target_lifetime), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [750] = */ {
    "-Wtautological-compare",
    "Warn if a comparison always evaluates to true or false.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 750,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_tautological_compare), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [751] = */ {
    "-Wtemplates",
    "Warn on primary template declaration.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 751,
    CL_CXX | CL_D | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_templates), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [752] = */ {
    "-Wterminate",
    "Warn if a throw expression will always result in a call to terminate().",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 752,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_terminate), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [753] = */ {
    "-Wtraditional",
    "Warn about features not present in traditional C.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 753,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_traditional), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [754] = */ {
    "-Wtraditional-conversion",
    "Warn of prototypes causing type conversions different from what would happen in the absence of prototype.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 754,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_traditional_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [755] = */ {
    "-Wtrampolines",
    "Warn whenever a trampoline is generated.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 755,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_trampolines), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [756] = */ {
    "-Wtrigraphs",
    "Warn if trigraphs are encountered that might affect the meaning of the program.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 756,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_trigraphs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [757] = */ {
    "-Wtsan",
    "Warn about unsupported features in ThreadSanitizer.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 757,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_tsan), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [758] = */ {
    "-Wtype-limits",
    "Warn if a comparison is always true or always false due to the limited range of the data type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 758,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_type_limits), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [759] = */ {
    "-Wundeclared-selector",
    "Warn about @selector()s without previously declared methods.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 759,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_undeclared_selector), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [760] = */ {
    "-Wundef",
    "Warn if an undefined macro is used in an #if directive.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 760,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_undef), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [761] = */ {
    "-Wundefined-do-loop",
    "Warn about an invalid DO loop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 761,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_undefined_do_loop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [762] = */ {
    "-Wunderflow",
    "Warn about underflow of numerical constant expressions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 762,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_underflow), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [763] = */ {
    "-Wuninitialized",
    "Warn about uninitialized automatic variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 763,
    CL_C | CL_CXX | CL_Fortran | CL_LTO | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_uninitialized), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [764] = */ {
    "-Wunknown-pragmas",
    "Warn about unrecognized pragmas.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 764,
    CL_C | CL_CXX | CL_D | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unknown_pragmas), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [765] = */ {
    "-Wunreachable-code",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, /* .neg_idx = */ 765,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [766] = */ {
    "-Wunsafe-loop-optimizations",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 26, /* .neg_idx = */ 766,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [767] = */ {
    "-Wunsuffixed-float-constants",
    "Warn about unsuffixed float constants.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 767,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unsuffixed_float_constants), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [768] = */ {
    "-Wunused",
    "Enable all -Wunused- warnings.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 768,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [769] = */ {
    "-Wunused-but-set-parameter",
    "Warn when a function parameter is only set, otherwise unused.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 769,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_but_set_parameter), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [770] = */ {
    "-Wunused-but-set-variable",
    "Warn when a variable is only set, otherwise unused.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 770,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_but_set_variable), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [771] = */ {
    "-Wunused-const-variable",
    "Warn when a const variable is unused.",
    NULL,
    NULL,
    "2", "0", OPT_Wunused_const_variable_, N_OPTS, 22, /* .neg_idx = */ 771,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [772] = */ {
    "-Wunused-const-variable=",
    "Warn when a const variable is unused.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_const_variable), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [773] = */ {
    "-Wunused-dummy-argument",
    "Warn about unused dummy arguments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 773,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_dummy_argument), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [774] = */ {
    "-Wunused-function",
    "Warn when a function is unused.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 774,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_function), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [775] = */ {
    "-Wunused-label",
    "Warn when a label is unused.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 775,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_label), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [776] = */ {
    "-Wunused-local-typedefs",
    "Warn when typedefs locally defined in a function are not used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 776,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_local_typedefs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [777] = */ {
    "-Wunused-macros",
    "Warn about macros defined in the main file that are not used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 777,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_unused_macros), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [778] = */ {
    "-Wunused-parameter",
    "Warn when a function parameter is unused.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 778,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_parameter), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [779] = */ {
    "-Wunused-result",
    "Warn if a caller of a function, marked with attribute warn_unused_result, does not use its return value.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 779,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_result), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [780] = */ {
    "-Wunused-value",
    "Warn when an expression value is unused.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 780,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_value), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [781] = */ {
    "-Wunused-variable",
    "Warn when a variable is unused.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 781,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_variable), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [782] = */ {
    "-Wuse-without-only",
    "Warn about USE statements that have no ONLY qualifier.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 782,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_use_without_only), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [783] = */ {
    "-Wuseless-cast",
    "Warn about useless casts.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 783,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_useless_cast), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [784] = */ {
    "-Wvarargs",
    "Warn about questionable usage of the macros used to retrieve variable arguments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 784,
    CL_C | CL_CXX | CL_D | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_varargs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [785] = */ {
    "-Wvariadic-macros",
    "Warn about using variadic macros.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 785,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_variadic_macros), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [786] = */ {
    "-Wvector-operation-performance",
    "Warn when a vector operation is compiled outside the SIMD.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 786,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_vector_operation_performance), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [787] = */ {
    "-Wvexing-parse",
    "Warn about the most vexing parse syntactic ambiguity.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 787,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_vexing_parse), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [788] = */ {
    "-Wvirtual-inheritance",
    "Warn on direct virtual inheritance.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 788,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_virtual_inheritance), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [789] = */ {
    "-Wvirtual-move-assign",
    "Warn if a virtual base has a non-trivial move assignment operator.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 789,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_virtual_move_assign), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [790] = */ {
    "-Wvla",
    "Warn if a variable length array is used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 790,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_vla), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [791] = */ {
    "-Wvla-larger-than=",
    "-Wvla-larger-than=<number>	Warn on unbounded uses of variable-length arrays, and on bounded uses of variable-length arrays whose bound can be larger than <number> bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 791,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* ByteSize */,
    offsetof (struct gcc_options, x_warn_vla_limit), 0, CLVC_SIZE, 0, -1, -1 },
 /* [792] = */ {
    "-Wvla-parameter",
    "Warn about mismatched declarations of VLA parameters.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 792,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_vla_parameter), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [793] = */ {
    "-Wvolatile",
    "Warn about deprecated uses of volatile qualifier.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 793,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_volatile), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [794] = */ {
    "-Wvolatile-register-var",
    "Warn when a register variable is declared volatile.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 794,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_volatile_register_var), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [795] = */ {
    "-Wwrite-strings",
    "In C++, nonzero means warn about deprecated conversion from string literals to 'char *'.  In C, similar warning, except that the conversion is of course not deprecated by the ISO C standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 795,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_write_strings), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [796] = */ {
    "-Wzero-as-null-pointer-constant",
    "Warn when a literal '0' is used as null pointer.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 796,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_zero_as_null_pointer_constant), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [797] = */ {
    "-Wzero-length-bounds",
    "Warn about accesses to interior zero-length array members.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 797,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_zero_length_bounds), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [798] = */ {
    "-Wzerotrip",
    "Warn about zero-trip DO loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 798,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_zerotrip), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [799] = */ {
    "-X",
    "Generate JSON file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [800] = */ {
    "-Xassembler",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [801] = */ {
    "-Xf",
    "-Xf <file>	Write JSON output to the given <file>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_D | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [802] = */ {
    "-Xlinker",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [803] = */ {
    "-Xpreprocessor",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [804] = */ {
    "-Z",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [805] = */ {
    "-ansi",
    "A synonym for -std=c89 (for C) or -std=c++98 (for C++).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [806] = */ {
    "-aux-info",
    "-aux-info <file>	Emit declaration information into <file>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_aux_info_file_name), 0, CLVC_STRING, 0, -1, -1 },
 /* [807] = */ {
    "-aux-info=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_aux_info, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [808] = */ {
    "-c",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [809] = */ {
    "-callgraph",
    "Dump the symtab callgraph.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_callgraph), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [810] = */ {
    "-coverage",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [811] = */ {
    "-cpp",
    "Enable preprocessing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 3, /* .neg_idx = */ 1744,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [812] = */ {
    "-cpp=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1744,
    CL_Fortran | CL_JOINED | CL_UNDOCUMENTED | CL_NO_DWARF_RECORD,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [813] = */ {
    "-d",
    "-d<letters>	Enable dumps from specific passes of the compiler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [814] = */ {
    "-debuglib=",
    "Debug library to use instead of phobos.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 9, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [815] = */ {
    "-defaultlib=",
    "Default library to use instead of phobos.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 11, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [816] = */ {
    "-defined-only",
    "Dump only the defined symbols.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 12, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_dump_defined), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [817] = */ {
    "-demangle",
    "Dump the demangled output.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 8, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_dump_demangle), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [818] = */ {
    "-dstartfiles",
    "Do link the standard D startup files in the compilation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 11, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [819] = */ {
    "-dump-body=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 10, /* .neg_idx = */ -1,
    CL_LTODump | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_body), 0, CLVC_STRING, 0, -1, -1 },
 /* [820] = */ {
    "-dump-level=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 11, /* .neg_idx = */ -1,
    CL_LTODump | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_level), 0, CLVC_STRING, 0, -1, -1 },
 /* [821] = */ {
    "-dumpbase",
    "-dumpbase <file>	Set the file basename to be used for dumps.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 8, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dump_base_name), 0, CLVC_STRING, 0, -1, -1 },
 /* [822] = */ {
    "-dumpbase-ext",
    "-dumpbase-ext .<ext>    Drop a trailing .<ext> from the dump basename to name auxiliary output files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 12, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dump_base_ext), 0, CLVC_STRING, 0, -1, -1 },
 /* [823] = */ {
    "-dumpdir",
    "-dumpdir <dir>	Set the directory name to be used for dumps.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 7, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dump_dir_name), 0, CLVC_STRING, 0, -1, -1 },
 /* [824] = */ {
    "-dumpfullversion",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 15, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [825] = */ {
    "-dumpmachine",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 11, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [826] = */ {
    "-dumpspecs",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 9, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [827] = */ {
    "-dumpversion",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_d, 11, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [828] = */ {
    "-e",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [829] = */ {
    "-export-dynamic",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_e, 14, /* .neg_idx = */ -1,
    CL_DRIVER | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [830] = */ {
    "-fPIC",
    "Generate position-independent code if possible (large mode).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 831,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pic), 0, CLVC_EQUAL, 2, -1, -1 },
 /* [831] = */ {
    "-fPIE",
    "Generate position-independent code for executables if possible (large mode).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1333,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pie), 0, CLVC_EQUAL, 2, -1, -1 },
 /* [832] = */ {
    "-fRTS=",
    "Select the runtime.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [833] = */ {
    "-fabi-compat-version=",
    "The version of the C++ ABI used for -Wabi warnings and link compatibility aliases.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_abi_compat_version), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [834] = */ {
    "-fabi-version=",
    "The version of the C++ ABI in use.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_abi_version), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [835] = */ {
    "-faccess-control",
    "Enforce class member access control semantics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 835,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_access_control), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [836] = */ {
    "-fada-spec-parent=",
    "-fada-spec-parent=unit	Dump Ada specs as child units of given parent.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ada_specs_parent), 0, CLVC_STRING, 0, -1, -1 },
 /* [837] = */ {
    "-faggressive-function-elimination",
    "Eliminate multiple function invocations also for impure functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ 837,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_aggressive_function_elimination), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [838] = */ {
    "-faggressive-loop-optimizations",
    "Aggressively optimize loops using language constraints.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 838,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_aggressive_loop_optimizations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [839] = */ {
    "-falign-commons",
    "Enable alignment of COMMON blocks.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 839,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_align_commons), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [840] = */ {
    "-falign-functions",
    "Align the start of functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 840,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_align_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [841] = */ {
    "-falign-functions=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_str_align_functions), 0, CLVC_STRING, 0, -1, -1 },
 /* [842] = */ {
    "-falign-jumps",
    "Align labels which are only reached by jumping.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 842,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_align_jumps), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [843] = */ {
    "-falign-jumps=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_str_align_jumps), 0, CLVC_STRING, 0, -1, -1 },
 /* [844] = */ {
    "-falign-labels",
    "Align all labels.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 844,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_align_labels), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [845] = */ {
    "-falign-labels=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_str_align_labels), 0, CLVC_STRING, 0, -1, -1 },
 /* [846] = */ {
    "-falign-loops",
    "Align the start of loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 846,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_align_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [847] = */ {
    "-falign-loops=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_str_align_loops), 0, CLVC_STRING, 0, -1, -1 },
 /* [848] = */ {
    "-faligned-new",
    "Support C++17 allocation of over-aligned types.",
    NULL,
    NULL,
    "1", "0", OPT_faligned_new_, N_OPTS, 12, /* .neg_idx = */ 848,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [849] = */ {
    "-faligned-new=",
    "-faligned-new=<N>	Use C++17 over-aligned type allocation for alignments greater than N.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_aligned_new_threshold), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [850] = */ {
    "-fall-instantiations",
    "Generate code for all template instantiations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 850,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [851] = */ {
    "-fall-intrinsics",
    "All intrinsics procedures are available regardless of selected standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_all_intrinsics), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [852] = */ {
    "-fall-virtual",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 12, /* .neg_idx = */ 852,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [853] = */ {
    "-fallocation-dce",
    "Tell DCE to remove unused C++ allocations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 853,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_allocation_dce), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [854] = */ {
    "-fallow-argument-mismatch",
    "Accept argument mismatches in procedure calls.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 854,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_allow_argument_mismatch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [855] = */ {
    "-fallow-invalid-boz",
    "Allow a BOZ literal constant to appear in an invalid context and with X instead of Z.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_allow_invalid_boz), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [856] = */ {
    "-fallow-leading-underscore",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 856,
    CL_Fortran | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_allow_leading_underscore), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [857] = */ {
    "-fallow-parameterless-variadic-functions",
    "Allow variadic functions without named parameter.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 39, /* .neg_idx = */ 857,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_allow_parameterless_variadic_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [858] = */ {
    "-fallow-store-data-races",
    "Allow the compiler to introduce new data races on stores.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 858,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_store_data_races), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [859] = */ {
    "-falt-external-templates",
    "No longer supported.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 23, /* .neg_idx = */ 859,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [860] = */ {
    "-fanalyzer",
    "Enable static analysis pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 860,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [861] = */ {
    "-fanalyzer-call-summaries",
    "Approximate the effect of function calls to simplify analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 861,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_call_summaries), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [862] = */ {
    "-fanalyzer-checker=",
    "Restrict the analyzer to run just the named checker.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_checker), 0, CLVC_STRING, 0, -1, -1 },
 /* [863] = */ {
    "-fanalyzer-feasibility",
    "Verify that paths are feasible when emitting diagnostics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 863,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_feasibility), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [864] = */ {
    "-fanalyzer-fine-grained",
    "Avoid combining multiple statements into one exploded edge.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 864,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_fine_grained), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [865] = */ {
    "-fanalyzer-show-duplicate-count",
    "Issue a note when diagnostics are deduplicated.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 865,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_show_duplicate_count), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [866] = */ {
    "-fanalyzer-state-merge",
    "Merge similar-enough states during analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 866,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_state_merge), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [867] = */ {
    "-fanalyzer-state-purge",
    "Purge unneeded state during analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 867,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_state_purge), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [868] = */ {
    "-fanalyzer-transitivity",
    "Enable transitivity of constraints during analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 868,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_transitivity), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [869] = */ {
    "-fanalyzer-verbose-edges",
    "Emit more verbose descriptions of control flow in diagnostics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 869,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_verbose_edges), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [870] = */ {
    "-fanalyzer-verbose-state-changes",
    "Emit more verbose descriptions of state changes in diagnostics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ 870,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_analyzer_verbose_state_changes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [871] = */ {
    "-fanalyzer-verbosity=",
    "Control which events are displayed in diagnostic paths.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 871,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_analyzer_verbosity), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [872] = */ {
    "-fargument-alias",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, /* .neg_idx = */ 872,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [873] = */ {
    "-fargument-noalias",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, /* .neg_idx = */ 873,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [874] = */ {
    "-fargument-noalias-anything",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 26, /* .neg_idx = */ 874,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [875] = */ {
    "-fargument-noalias-global",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 24, /* .neg_idx = */ 875,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [876] = */ {
    "-fasan-shadow-offset=",
    "-fasan-shadow-offset=<number>	Use custom shadow memory offset.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [877] = */ {
    "-fasm",
    "Recognize the \"asm\" keyword.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 877,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_asm), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [878] = */ {
    "-fassert",
    "Generate code for assert contracts.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 878,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_assert), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [879] = */ {
    "-fassociative-math",
    "Allow optimization for floating-point arithmetic which may change the result of the operation due to rounding.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 879,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_associative_math), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [880] = */ {
    "-fassume-phsa",
    "Assume we are finalizing for phsa and its libhsail-rt.  Enables additional phsa-specific optimizations (default).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 880,
    CL_BRIG | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_assume_phsa), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [881] = */ {
    "-fasynchronous-unwind-tables",
    "Generate unwind tables that are exact at each instruction boundary.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 881,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_asynchronous_unwind_tables), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [882] = */ {
    "-fauto-inc-dec",
    "Generate auto-inc/dec instructions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 882,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_auto_inc_dec), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [883] = */ {
    "-fauto-profile",
    "Use sample profile information for call graph node weights. The default profile file is fbdata.afdo in 'pwd'.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 883,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_auto_profile), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [884] = */ {
    "-fauto-profile=",
    "Use sample profile information for call graph node weights. The profile file is specified in the argument.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_auto_profile_file), 0, CLVC_STRING, 0, -1, -1 },
 /* [885] = */ {
    "-fautomatic",
    "Do not treat local variables and COMMON blocks as if they were named in SAVE statements.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 885,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_automatic), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [886] = */ {
    "-fbackslash",
    "Specify that backslash in string introduces an escape character.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 886,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_backslash), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [887] = */ {
    "-fbacktrace",
    "Produce a backtrace when a runtime error is encountered.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 887,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_backtrace), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [888] = */ {
    "-fbit-tests",
    "Use bit tests for sufficiently large switch statements.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 888,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_bit_tests), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [889] = */ {
    "-fblas-matmul-limit=",
    "-fblas-matmul-limit=<n>	Size of the smallest matrix for which matmul will use BLAS.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_blas_matmul_limit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [890] = */ {
    "-fbounds-check",
    "Generate code to check bounds before indexing arrays.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 890,
    CL_D | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_bounds_check), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [891] = */ {
    "-fbounds-check=",
    "-fbounds-check=[on|safeonly|off]	Turn array bounds checks on, in @safe code only, or off.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_D | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_bounds_check), 5, CLVC_ENUM, 0, -1, -1 },
 /* [892] = */ {
    "-fbranch-count-reg",
    "Replace add, compare, branch with branch on count register.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 892,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_branch_on_count_reg), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [893] = */ {
    "-fbranch-probabilities",
    "Use profiling information for branch probabilities.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 893,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_branch_probabilities), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [894] = */ {
    "-fbranch-target-load-optimize",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 28, /* .neg_idx = */ 894,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [895] = */ {
    "-fbranch-target-load-optimize2",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 29, /* .neg_idx = */ 895,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [896] = */ {
    "-fbtr-bb-exclusive",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, /* .neg_idx = */ 896,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [897] = */ {
    "-fbuilding-libgcc",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 897,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_building_libgcc), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [898] = */ {
    "-fbuilding-libphobos-tests",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 898,
    CL_D | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_building_libphobos_tests), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [899] = */ {
    "-fbuiltin",
    "Recognize built-in functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 899,
    CL_C | CL_CXX | CL_D | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_builtin), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [900] = */ {
    "-fbuiltin-",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 900,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [901] = */ {
    "-fbuiltin-printf",
    "Ignored.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fbuiltin_, 15, /* .neg_idx = */ 901,
    CL_Ada | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [902] = */ {
    "-fc-prototypes",
    "Generate C prototypes from BIND(C) declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 902,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_c_prototypes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [903] = */ {
    "-fc-prototypes-external",
    "Generate C prototypes from non-BIND(C) external procedure definitions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 903,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_c_prototypes_external), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [904] = */ {
    "-fcall-saved-",
    "-fcall-saved-<register>	Mark <register> as being preserved across functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [905] = */ {
    "-fcall-used-",
    "-fcall-used-<register>	Mark <register> as being corrupted by function calls.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [906] = */ {
    "-fcaller-saves",
    "Save registers around function calls.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 906,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_caller_saves), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [907] = */ {
    "-fcallgraph-info",
    "Output callgraph information on a per-file basis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_callgraph_info), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [908] = */ {
    "-fcallgraph-info=",
    "Output callgraph information on a per-file basis with decorations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [909] = */ {
    "-fcanonical-system-headers",
    "Where shorter, use canonicalized paths to systems headers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 909,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [910] = */ {
    "-fcf-protection",
    NULL,
    NULL,
    NULL,
    "full", NULL, OPT_fcf_protection_, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [911] = */ {
    "-fcf-protection=",
    "-fcf-protection=[full|branch|return|none|check]	Instrument functions with checks to verify jump/call/return control-flow transfer instructions have valid targets.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_cf_protection), 6, CLVC_ENUM, 0, -1, -1 },
 /* [912] = */ {
    "-fchar8_t",
    "Enable the char8_t fundamental type and use it as the type for UTF-8 string and character literals.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 912,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_char8_t), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [913] = */ {
    "-fcheck-array-temporaries",
    "Produce a warning at runtime if a array temporary has been created for a procedure argument.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 913,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [914] = */ {
    "-fcheck-data-deps",
    "This switch is deprecated; do not use.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 16, /* .neg_idx = */ 914,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [915] = */ {
    "-fcheck-new",
    "Check the return value of new in C++.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 915,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_check_new), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [916] = */ {
    "-fcheck-pointer-bounds",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 21, /* .neg_idx = */ 916,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [917] = */ {
    "-fcheck=",
    "-fcheck=[...]	Specify which runtime checks are to be performed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [918] = */ {
    "-fchecking",
    "Perform internal consistency checkings.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 918,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_checking), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [919] = */ {
    "-fchecking=",
    "Perform internal consistency checkings.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_checking), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [920] = */ {
    "-fchkp-check-incomplete-type",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 27, /* .neg_idx = */ 920,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [921] = */ {
    "-fchkp-check-read",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 16, /* .neg_idx = */ 921,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [922] = */ {
    "-fchkp-check-write",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 17, /* .neg_idx = */ 922,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [923] = */ {
    "-fchkp-first-field-has-own-bounds",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 32, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [924] = */ {
    "-fchkp-flexible-struct-trailing-arrays",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 37, /* .neg_idx = */ 924,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [925] = */ {
    "-fchkp-instrument-calls",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 22, /* .neg_idx = */ 925,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [926] = */ {
    "-fchkp-instrument-marked-only",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 28, /* .neg_idx = */ 926,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [927] = */ {
    "-fchkp-narrow-bounds",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 19, /* .neg_idx = */ 927,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [928] = */ {
    "-fchkp-narrow-to-innermost-array",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 31, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [929] = */ {
    "-fchkp-optimize",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 14, /* .neg_idx = */ 929,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [930] = */ {
    "-fchkp-store-bounds",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 18, /* .neg_idx = */ 930,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [931] = */ {
    "-fchkp-treat-zero-dynamic-size-as-infinite",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 41, /* .neg_idx = */ 931,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [932] = */ {
    "-fchkp-use-fast-string-functions",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 31, /* .neg_idx = */ 932,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [933] = */ {
    "-fchkp-use-nochk-string-functions",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 32, /* .neg_idx = */ 933,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [934] = */ {
    "-fchkp-use-static-bounds",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 23, /* .neg_idx = */ 934,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [935] = */ {
    "-fchkp-use-static-const-bounds",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 29, /* .neg_idx = */ 935,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [936] = */ {
    "-fchkp-use-wrappers",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 18, /* .neg_idx = */ 936,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [937] = */ {
    "-fchkp-zero-input-bounds-for-main",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 32, /* .neg_idx = */ 937,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [938] = */ {
    "-fcilkplus",
    "Removed in GCC 8.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 9, /* .neg_idx = */ 938,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [939] = */ {
    "-fcoarray=",
    "-fcoarray=<none|single|lib>	Specify which coarray parallelization should be used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_coarray), 23, CLVC_ENUM, 0, -1, -1 },
 /* [940] = */ {
    "-fcode-hoisting",
    "Enable code hoisting.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 940,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_code_hoisting), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [941] = */ {
    "-fcombine-stack-adjustments",
    "Looks for opportunities to reduce stack adjustments and stack references.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 941,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_combine_stack_adjustments), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [942] = */ {
    "-fcommon",
    "Put uninitialized globals in the common section.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 942,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_common), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [943] = */ {
    "-fcompare-debug",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 943,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [944] = */ {
    "-fcompare-debug-second",
    "Run only the second compilation of -fcompare-debug.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_compare_debug), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [945] = */ {
    "-fcompare-debug=",
    "-fcompare-debug[=<opts>]	Compile with and without e.g. -gtoggle, and compare the final-insns dump.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_compare_debug_opt), 0, CLVC_STRING, 0, -1, -1 },
 /* [946] = */ {
    "-fcompare-elim",
    "Perform comparison elimination after register allocation has finished.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 946,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_compare_elim_after_reload), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [947] = */ {
    "-fconcepts",
    "Enable support for C++ concepts.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 947,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_concepts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [948] = */ {
    "-fconcepts-diagnostics-depth=",
    "Specify maximum error replay depth during recursive diagnosis of a constraint satisfaction failure.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_concepts_diagnostics_max_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [949] = */ {
    "-fconcepts-ts",
    "Enable certain features present in the Concepts TS.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 949,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_concepts_ts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [950] = */ {
    "-fcond-mismatch",
    "Allow the arguments of the '?' operator to have different types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 950,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [951] = */ {
    "-fconserve-space",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, /* .neg_idx = */ 951,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [952] = */ {
    "-fconserve-stack",
    "Do not perform optimizations increasing noticeably stack usage.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 952,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_conserve_stack), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [953] = */ {
    "-fconstant-string-class=",
    "-fconst-string-class=<name>	Use class <name> for constant strings.",
    "no class name specified with %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 953,
    CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [954] = */ {
    "-fconstexpr-cache-depth=",
    "-fconstexpr-cache-depth=<number>	Specify maximum constexpr recursion cache depth.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_constexpr_cache_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [955] = */ {
    "-fconstexpr-depth=",
    "-fconstexpr-depth=<number>	Specify maximum constexpr recursion depth.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_max_constexpr_depth), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [956] = */ {
    "-fconstexpr-loop-limit=",
    "-fconstexpr-loop-limit=<number>	Specify maximum constexpr loop iteration count.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_constexpr_loop_limit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [957] = */ {
    "-fconstexpr-ops-limit=",
    "-fconstexpr-ops-limit=<number>	Specify maximum number of constexpr operations during a single constexpr evaluation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 0,
    offsetof (struct gcc_options, x_constexpr_ops_limit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [958] = */ {
    "-fconvert=",
    "-fconvert=<big-endian|little-endian|native|swap>	The endianness used for unformatted files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_convert), 22, CLVC_ENUM, 0, -1, -1 },
 /* [959] = */ {
    "-fcoroutines",
    "Enable C++ coroutines (experimental).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 959,
    CL_CXX | CL_LTO,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_coroutines), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [960] = */ {
    "-fcprop-registers",
    "Perform a register copy-propagation optimization pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 960,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_cprop_registers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [961] = */ {
    "-fcray-pointer",
    "Use the Cray Pointer extension.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 961,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_cray_pointer), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [962] = */ {
    "-fcrossjumping",
    "Perform cross-jumping optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 962,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_crossjumping), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [963] = */ {
    "-fcse-follow-jumps",
    "When running CSE, follow jumps to their targets.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 963,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_cse_follow_jumps), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [964] = */ {
    "-fcse-skip-blocks",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 16, /* .neg_idx = */ 964,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [965] = */ {
    "-fcx-fortran-rules",
    "Complex multiplication and division follow Fortran rules.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 965,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_cx_fortran_rules), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [966] = */ {
    "-fcx-limited-range",
    "Omit range reduction step when performing complex division.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 966,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_cx_limited_range), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [967] = */ {
    "-fd-lines-as-code",
    "Ignore 'D' in column one in fixed form.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [968] = */ {
    "-fd-lines-as-comments",
    "Treat lines with 'D' in column one as comments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [969] = */ {
    "-fdata-sections",
    "Place data items into their own section.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 969,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_data_sections), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [970] = */ {
    "-fdbg-cnt-list",
    "List all available debugging counters with their limits and counts.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 970,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dbg_cnt_list), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [971] = */ {
    "-fdbg-cnt=",
    "-fdbg-cnt=<counter>[:<lower_limit1>-]<upper_limit1>[:<lower_limit2>-<upper_limit2>:...][,<counter>:...]	Set the debug counter limit.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [972] = */ {
    "-fdce",
    "Use the RTL dead code elimination pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 972,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dce), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [973] = */ {
    "-fdebug",
    "Compile in debug code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 973,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [974] = */ {
    "-fdebug-aux-vars",
    "Issue debug information for compiler-generated auxiliary variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 974,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_debug_aux_vars), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [975] = */ {
    "-fdebug-cpp",
    "Emit debug annotations during preprocessing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 975,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [976] = */ {
    "-fdebug-prefix-map=",
    "-fdebug-prefix-map=<old>=<new>	Map one directory name to another in debug information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [977] = */ {
    "-fdebug-types-section",
    "Output .debug_types section when using DWARF v4 debuginfo.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 977,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_debug_types_section), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [978] = */ {
    "-fdebug=",
    "-fdebug=<level|ident>	Compile in debug code, code <= <level>, or code identified by <ident>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_D | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [979] = */ {
    "-fdec",
    "Enable all DEC language extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 979,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [980] = */ {
    "-fdec-blank-format-item",
    "Enable the use of blank format items in format strings.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 980,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec_blank_format_item), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [981] = */ {
    "-fdec-char-conversions",
    "Enable the use of character literals in assignments and data statements for non-character variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 981,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec_char_conversions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [982] = */ {
    "-fdec-format-defaults",
    "Enable default widths for i, f and g format specifiers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 982,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec_format_defaults), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [983] = */ {
    "-fdec-include",
    "Enable legacy parsing of INCLUDE as statement.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 983,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec_include), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [984] = */ {
    "-fdec-intrinsic-ints",
    "Enable kind-specific variants of integer intrinsic functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 984,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec_intrinsic_ints), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [985] = */ {
    "-fdec-math",
    "Enable legacy math intrinsics for compatibility.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 985,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec_math), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [986] = */ {
    "-fdec-static",
    "Enable DEC-style STATIC and AUTOMATIC attributes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 986,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec_static), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [987] = */ {
    "-fdec-structure",
    "Enable support for DEC STRUCTURE/RECORD.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 987,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dec_structure), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [988] = */ {
    "-fdeclone-ctor-dtor",
    "Factor complex constructors and destructors to favor space over speed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 988,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_declone_ctor_dtor), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [989] = */ {
    "-fdeduce-init-list",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, /* .neg_idx = */ 989,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [990] = */ {
    "-fdefault-double-8",
    "Set the default double precision kind to an 8 byte wide type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 990,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_default_double), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [991] = */ {
    "-fdefault-inline",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, /* .neg_idx = */ 991,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [992] = */ {
    "-fdefault-integer-8",
    "Set the default integer kind to an 8 byte wide type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 992,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_default_integer), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [993] = */ {
    "-fdefault-real-10",
    "Set the default real kind to an 10 byte wide type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 993,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_default_real_10), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [994] = */ {
    "-fdefault-real-16",
    "Set the default real kind to an 16 byte wide type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 994,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_default_real_16), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [995] = */ {
    "-fdefault-real-8",
    "Set the default real kind to an 8 byte wide type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 995,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_default_real_8), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [996] = */ {
    "-fdefer-pop",
    "Defer popping functions args from stack until later.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 996,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_defer_pop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [997] = */ {
    "-fdelayed-branch",
    "Attempt to fill delay slots of branch instructions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 997,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_delayed_branch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [998] = */ {
    "-fdelete-dead-exceptions",
    "Delete dead instructions that may throw exceptions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 998,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_delete_dead_exceptions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [999] = */ {
    "-fdelete-null-pointer-checks",
    "Delete useless null pointer checks.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 999,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_delete_null_pointer_checks), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1000] = */ {
    "-fdevirtualize",
    "Try to convert virtual calls to direct ones.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1000,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_devirtualize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1001] = */ {
    "-fdevirtualize-at-ltrans",
    "Stream extra data to support more aggressive devirtualization in LTO local transformation mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1001,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ltrans_devirtualize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1002] = */ {
    "-fdevirtualize-speculatively",
    "Perform speculative devirtualization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 1002,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_devirtualize_speculatively), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1003] = */ {
    "-fdiagnostics-color",
    NULL,
    NULL,
    NULL,
    "always", "never", OPT_fdiagnostics_color_, N_OPTS, 18, /* .neg_idx = */ 1003,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1004] = */ {
    "-fdiagnostics-color=",
    "-fdiagnostics-color=[never|always|auto]	Colorize diagnostics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_color), 10, CLVC_ENUM, 0, -1, -1 },
 /* [1005] = */ {
    "-fdiagnostics-column-origin=",
    "-fdiagnostics-column-origin=<number>	Set the number of the first column.  The default is 1-based as per GNU style, but some utilities may expect 0-based, for example.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1006] = */ {
    "-fdiagnostics-column-unit=",
    "-fdiagnostics-column-unit=[display|byte]	Select whether column numbers are output as display columns (default) or raw bytes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 14, CLVC_ENUM, 0, -1, -1 },
 /* [1007] = */ {
    "-fdiagnostics-escape-format=",
    "-fdiagnostics-escape-format=[unicode|bytes]	Select how to escape non-printable-ASCII bytes in the source for diagnostics that suggest it.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 15, CLVC_ENUM, 0, -1, -1 },
 /* [1008] = */ {
    "-fdiagnostics-format=",
    "-fdiagnostics-format=[text|json]	Select output format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 16, CLVC_ENUM, 0, -1, -1 },
 /* [1009] = */ {
    "-fdiagnostics-generate-patch",
    "Print fix-it hints to stderr in unified diff format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 1009,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_generate_patch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1010] = */ {
    "-fdiagnostics-minimum-margin-width=",
    "Set minimum width of left margin of source code when showing source.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ 1010,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_diagnostics_minimum_margin_width), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1011] = */ {
    "-fdiagnostics-parseable-fixits",
    "Print fix-it hints in machine-readable form.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 1011,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_parseable_fixits), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1012] = */ {
    "-fdiagnostics-path-format=",
    "Specify how to print any control-flow path associated with a diagnostic.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_path_format), 11, CLVC_ENUM, 0, -1, -1 },
 /* [1013] = */ {
    "-fdiagnostics-plain-output",
    "Turn off any diagnostics features that complicate the output, such as line numbers, color, and warning URLs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1014] = */ {
    "-fdiagnostics-show-caret",
    "Show the source line with a caret indicating the column.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1014,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_caret), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1015] = */ {
    "-fdiagnostics-show-cwe",
    "Print CWE identifiers for diagnostic messages, where available.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1015,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_cwe), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1016] = */ {
    "-fdiagnostics-show-labels",
    "Show labels annotating ranges of source code when showing source.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 1016,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_labels), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1017] = */ {
    "-fdiagnostics-show-line-numbers",
    "Show line numbers in the left margin when showing source.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 1017,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_line_numbers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1018] = */ {
    "-fdiagnostics-show-location=",
    "-fdiagnostics-show-location=[once|every-line]	How often to emit source location at the beginning of line-wrapped diagnostics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 12, CLVC_ENUM, 0, -1, -1 },
 /* [1019] = */ {
    "-fdiagnostics-show-option",
    "Amend appropriate diagnostic messages with the command line option that controls them.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 1019,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_option), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1020] = */ {
    "-fdiagnostics-show-path-depths",
    "Show stack depths of events in paths.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 1020,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_path_depths), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1021] = */ {
    "-fdiagnostics-show-template-tree",
    "Print hierarchical comparisons when template types are mismatched.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ 1021,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_template_tree), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1022] = */ {
    "-fdiagnostics-urls=",
    "-fdiagnostics-urls=[never|always|auto]	Embed URLs in diagnostics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_urls), 13, CLVC_ENUM, 0, -1, -1 },
 /* [1023] = */ {
    "-fdirectives-only",
    "Preprocess directives only.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1023,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1024] = */ {
    "-fdisable-",
    "-fdisable-[tree|rtl|ipa]-<pass>=range1+range2	Disable an optimization pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1025] = */ {
    "-fdoc",
    "Generate documentation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1025,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1026] = */ {
    "-fdoc-dir=",
    "-fdoc-dir=<dir>	Write documentation file to directory <dir>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_D | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1027] = */ {
    "-fdoc-file=",
    "-fdoc-file=<file>	Write documentation to <file>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_D | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1028] = */ {
    "-fdoc-inc=",
    "-fdoc-inc=<file>	Include a Ddoc macro <file>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_D | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1029] = */ {
    "-fdollar-ok",
    "Allow dollar signs in entity names.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1029,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dollar_ok), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1030] = */ {
    "-fdollars-in-identifiers",
    "Permit '$' as an identifier character.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1030,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1031] = */ {
    "-fdruntime",
    "Assume that standard D runtime libraries and \"D main\" exist.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1031,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1032] = */ {
    "-fdse",
    "Use the RTL dead store elimination pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1032,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dse), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1033] = */ {
    "-fdump-",
    "-fdump-<type>	Dump various compiler internals to a file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1034] = */ {
    "-fdump-ada-spec",
    "Write all declarations as Ada code transitively.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 14, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_ada_spec), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1035] = */ {
    "-fdump-ada-spec-slim",
    "Write all declarations as Ada code for the given file only.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 19, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_ada_spec_slim), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1036] = */ {
    "-fdump-analyzer",
    "Dump various analyzer internals to SRCFILE.analyzer.txt.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 14, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1037] = */ {
    "-fdump-analyzer-callgraph",
    "Dump analyzer-specific call graph information to a SRCFILE.callgraph.dot file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 24, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_callgraph), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1038] = */ {
    "-fdump-analyzer-exploded-graph",
    "Dump the analyzer exploded graph to a SRCFILE.eg.dot file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 29, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_exploded_graph), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1039] = */ {
    "-fdump-analyzer-exploded-nodes",
    "Emit diagnostics showing the location of nodes in the exploded graph.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 29, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_exploded_nodes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1040] = */ {
    "-fdump-analyzer-exploded-nodes-2",
    "Dump a textual representation of the exploded graph to SRCFILE.eg.txt.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 31, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_exploded_nodes_2), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1041] = */ {
    "-fdump-analyzer-exploded-nodes-3",
    "Dump a textual representation of the exploded graph to SRCFILE.eg-ID.txt.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 31, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_exploded_nodes_3), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1042] = */ {
    "-fdump-analyzer-feasibility",
    "Dump various analyzer internals to SRCFILE.*.fg.dot and SRCFILE.*.tg.dot.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 26, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_feasibility), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1043] = */ {
    "-fdump-analyzer-json",
    "Dump analyzer-specific data to a SRCFILE.analyzer.json.gz file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 19, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_json), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1044] = */ {
    "-fdump-analyzer-state-purge",
    "Dump state-purging information to a SRCFILE.state-purge.dot file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 26, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_state_purge), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1045] = */ {
    "-fdump-analyzer-stderr",
    "Dump various analyzer internals to stderr.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 21, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_stderr), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1046] = */ {
    "-fdump-analyzer-supergraph",
    "Dump the analyzer supergraph to a SRCFILE.supergraph.dot file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 25, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_analyzer_supergraph), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1047] = */ {
    "-fdump-core",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, OPT_fdump_, 10, /* .neg_idx = */ 1047,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1048] = */ {
    "-fdump-d-original",
    "Display the frontend AST after parsing and semantic passes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 16, /* .neg_idx = */ 1048,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1049] = */ {
    "-fdump-final-insns",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 17, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1050] = */ {
    "-fdump-final-insns=",
    "-fdump-final-insns=filename	Dump to filename the insns at the end of translation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 18, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_final_insns), 0, CLVC_STRING, 0, -1, -1 },
 /* [1051] = */ {
    "-fdump-fortran-global",
    "Display the global symbol table after parsing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 20, /* .neg_idx = */ 1051,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_fortran_global), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1052] = */ {
    "-fdump-fortran-optimized",
    "Display the code tree after front end optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 23, /* .neg_idx = */ 1052,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_fortran_optimized), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1053] = */ {
    "-fdump-fortran-original",
    "Display the code tree after parsing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 22, /* .neg_idx = */ 1053,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_fortran_original), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1054] = */ {
    "-fdump-go-spec=",
    "-fdump-go-spec=filename	Write all declarations to file as Go code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_go_spec), 0, CLVC_STRING, 0, -1, -1 },
 /* [1055] = */ {
    "-fdump-internal-locations",
    "Dump detailed information on GCC's internal representation of source code locations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 24, /* .neg_idx = */ 1055,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_locations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1056] = */ {
    "-fdump-noaddr",
    "Suppress output of addresses in debugging dumps.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 12, /* .neg_idx = */ 1056,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_noaddr), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1057] = */ {
    "-fdump-parse-tree",
    "Display the code tree after parsing; deprecated option.",
    NULL,
    NULL,
    NULL, NULL, OPT_fdump_fortran_original, OPT_fdump_, 16, /* .neg_idx = */ 1057,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1058] = */ {
    "-fdump-passes",
    "Dump optimization passes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 12, /* .neg_idx = */ 1058,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_passes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1059] = */ {
    "-fdump-scos",
    "Dump Source Coverage Obligations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 10, /* .neg_idx = */ -1,
    CL_Ada,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_scos), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1060] = */ {
    "-fdump-unnumbered",
    "Suppress output of instruction numbers, line number notes and addresses in debugging dumps.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 16, /* .neg_idx = */ 1060,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_unnumbered), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1061] = */ {
    "-fdump-unnumbered-links",
    "Suppress output of previous and next insn numbers in debugging dumps.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fdump_, 22, /* .neg_idx = */ 1061,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_unnumbered_links), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1062] = */ {
    "-fdwarf2-cfi-asm",
    "Enable CFI tables via GAS assembler directives.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1062,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dwarf2_cfi_asm), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1063] = */ {
    "-fearly-inlining",
    "Perform early inlining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1063,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_early_inlining), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1064] = */ {
    "-felide-constructors",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1064,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_elide_constructors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1065] = */ {
    "-felide-type",
    "Do not elide common elements in template comparisons.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1065,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_elide_type), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1066] = */ {
    "-feliminate-dwarf2-dups",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 22, /* .neg_idx = */ 1066,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1067] = */ {
    "-feliminate-unused-debug-symbols",
    "Perform unused symbol elimination in debug info.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ 1067,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_debug_only_used_symbols), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1068] = */ {
    "-feliminate-unused-debug-types",
    "Perform unused type elimination in debug info.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 1068,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_eliminate_unused_debug_types), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1069] = */ {
    "-femit-class-debug-always",
    "Do not suppress C++ class debug information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 1069,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_emit_class_debug_always), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1070] = */ {
    "-femit-struct-debug-baseonly",
    "-femit-struct-debug-baseonly	Aggressive reduced debug info for structs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ 1070,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1071] = */ {
    "-femit-struct-debug-detailed=",
    "-femit-struct-debug-detailed=<spec-list>	Detailed reduced debug info for structs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ 1071,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1072] = */ {
    "-femit-struct-debug-reduced",
    "-femit-struct-debug-reduced	Conservative reduced debug info for structs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1072,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1073] = */ {
    "-fenable-",
    "-fenable-[tree|rtl|ipa]-<pass>=range1+range2	Enable an optimization pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1074] = */ {
    "-fenforce-eh-specs",
    "Generate code to check exception specifications.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1074,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_enforce_eh_specs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1075] = */ {
    "-fenum-int-equiv",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 15, /* .neg_idx = */ 1075,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1076] = */ {
    "-fexceptions",
    "Enable exception handling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1076,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_exceptions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1077] = */ {
    "-fexcess-precision=",
    "-fexcess-precision=[fast|standard]	Specify handling of excess floating-point precision.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_excess_precision), 19, CLVC_ENUM, 0, -1, -1 },
 /* [1078] = */ {
    "-fexec-charset=",
    "-fexec-charset=<cset>	Convert all strings and character constants to character set <cset>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1079] = */ {
    "-fexpensive-optimizations",
    "Perform a number of minor, expensive optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 1079,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_expensive_optimizations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1080] = */ {
    "-fext-numeric-literals",
    "Interpret imaginary, fixed-point, or other gnu number suffix as the corresponding number literal rather than a user-defined number literal.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1080,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ext_numeric_literals), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1081] = */ {
    "-fextended-identifiers",
    "Permit universal character names (\\u and \\U) in identifiers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1081,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1082] = */ {
    "-fextern-tls-init",
    "Support dynamic initialization of thread-local variables in a different translation unit.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1082,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_extern_tls_init), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1083] = */ {
    "-fexternal-blas",
    "Specify that an external BLAS library should be used for matmul calls on large-size arrays.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1083,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_external_blas), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1084] = */ {
    "-fexternal-templates",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 19, /* .neg_idx = */ 1084,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1085] = */ {
    "-ff2c",
    "Use f2c calling convention.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1085,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_f2c), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1086] = */ {
    "-ffast-math",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1086,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1087] = */ {
    "-ffat-lto-objects",
    "Output lto objects containing both the intermediate language and binary output.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1087,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fat_lto_objects), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1088] = */ {
    "-ffile-prefix-map=",
    "-ffile-prefix-map=<old>=<new>	Map one directory name to another in compilation result.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1089] = */ {
    "-ffinite-loops",
    "Assume that loops with an exit will terminate and not loop indefinitely.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1089,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_finite_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1090] = */ {
    "-ffinite-math-only",
    "Assume no NaNs or infinities are generated.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1090,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_finite_math_only), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1091] = */ {
    "-ffixed-",
    "-ffixed-<register>	Mark <register> as being unavailable to the compiler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1092] = */ {
    "-ffixed-form",
    "Assume that the source file is fixed form.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_ffixed_, 11, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1093] = */ {
    "-ffixed-line-length-",
    "-ffixed-line-length-<n>	Use n as character line width in fixed mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_ffixed_, 19, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fixed_line_length), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1094] = */ {
    "-ffixed-line-length-none",
    "Allow arbitrary character line width in fixed mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_ffixed_line_length_, 23, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fixed_line_length), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1095] = */ {
    "-ffloat-store",
    "Don't allocate floats and doubles in extended-precision registers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1095,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_float_store), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1096] = */ {
    "-ffor-scope",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 10, /* .neg_idx = */ 1096,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1097] = */ {
    "-fforce-addr",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 11, /* .neg_idx = */ 1097,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1098] = */ {
    "-fforward-propagate",
    "Perform a forward propagation pass on RTL.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1098,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_forward_propagate), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1099] = */ {
    "-ffp-contract=",
    "-ffp-contract=[off|on|fast]	Perform floating-point expression contraction.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fp_contract_mode), 21, CLVC_ENUM, 0, -1, -1 },
 /* [1100] = */ {
    "-ffp-int-builtin-inexact",
    "Allow built-in functions ceil, floor, round, trunc to raise \"inexact\" exceptions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1100,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fp_int_builtin_inexact), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1101] = */ {
    "-ffpe-summary=",
    "-ffpe-summary=[...]	Print summary of floating point exceptions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1102] = */ {
    "-ffpe-trap=",
    "-ffpe-trap=[...]	Stop on following floating point exceptions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1103] = */ {
    "-ffree-form",
    "Assume that the source file is free form.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1104] = */ {
    "-ffree-line-length-",
    "-ffree-line-length-<n>	Use n as character line width in free mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_free_line_length), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1105] = */ {
    "-ffree-line-length-none",
    "Allow arbitrary character line width in free mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_ffree_line_length_, 22, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_free_line_length), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1106] = */ {
    "-ffreestanding",
    "Do not assume that standard C libraries and \"main\" exist.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1106,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1107] = */ {
    "-ffriend-injection",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 17, /* .neg_idx = */ 1107,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1108] = */ {
    "-ffrontend-loop-interchange",
    "Try to interchange loops if profitable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1108,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_frontend_loop_interchange), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1109] = */ {
    "-ffrontend-optimize",
    "Enable front end optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1109,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_frontend_optimize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1110] = */ {
    "-ffunction-cse",
    "Allow function addresses to be held in registers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1110,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_function_cse), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1111] = */ {
    "-ffunction-sections",
    "Place each function into its own section.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1111,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_function_sections), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1112] = */ {
    "-fgcse",
    "Perform global common subexpression elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 1112,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gcse), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1113] = */ {
    "-fgcse-after-reload",
    "Perform global common subexpression elimination after register allocation has finished.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1113,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gcse_after_reload), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1114] = */ {
    "-fgcse-las",
    "Perform redundant load after store elimination in global common subexpression elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1114,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gcse_las), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1115] = */ {
    "-fgcse-lm",
    "Perform enhanced load motion during global common subexpression elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1115,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gcse_lm), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1116] = */ {
    "-fgcse-sm",
    "Perform store motion after global common subexpression elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1116,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gcse_sm), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1117] = */ {
    "-fgimple",
    "Enable parsing GIMPLE.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1117,
    CL_C,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gimple), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1118] = */ {
    "-fgnat-encodings=",
    "-fgnat-encodings=[all|gdb|minimal]	Select the balance between GNAT encodings and standard DWARF emitted in the debug information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_gnat_encodings), 17, CLVC_ENUM, 0, -1, -1 },
 /* [1119] = */ {
    "-fgnu-keywords",
    "Recognize GNU-defined keywords.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1119,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_gnu_keywords), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1120] = */ {
    "-fgnu-runtime",
    "Generate code for GNU runtime environment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_next_runtime), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1121] = */ {
    "-fgnu-tm",
    "Enable support for GNU transactional memory.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1121,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tm), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1122] = */ {
    "-fgnu-unique",
    "Use STB_GNU_UNIQUE if supported by the assembler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1122,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gnu_unique), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1123] = */ {
    "-fgnu89-inline",
    "Use traditional GNU semantics for inline functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1123,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gnu89_inline), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1124] = */ {
    "-fgo-c-header=",
    "-fgo-c-header=<file>	Write Go struct definitions to file as C code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1125] = */ {
    "-fgo-check-divide-overflow",
    "Add explicit checks for division overflow in INT_MIN / -1.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 1125,
    CL_Go,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_check_divide_overflow), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1126] = */ {
    "-fgo-check-divide-zero",
    "Add explicit checks for division by zero.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1126,
    CL_Go,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_check_divide_zero), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1127] = */ {
    "-fgo-compiling-runtime",
    "Apply special rules for compiling runtime package.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1127,
    CL_Go,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_compiling_runtime), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1128] = */ {
    "-fgo-debug-escape",
    "Emit debugging information related to the escape analysis pass when run with -fgo-optimize-allocs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1128,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_go_debug_escape_level), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1129] = */ {
    "-fgo-debug-escape-hash=",
    "-fgo-debug-escape-hash=<string>	Hash value to debug escape analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_fgo_debug_escape, 22, /* .neg_idx = */ -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_debug_escape_hash), 0, CLVC_STRING, 0, -1, -1 },
 /* [1130] = */ {
    "-fgo-debug-optimization",
    "Emit optimization diagnostics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1130,
    CL_Go,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_debug_optimization), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1131] = */ {
    "-fgo-dump-",
    "-fgo-dump-<type>	Dump Go frontend internal information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1132] = */ {
    "-fgo-embedcfg=",
    "-fgo-embedcfg=<file>	List embedded files via go:embed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1133] = */ {
    "-fgo-optimize-",
    "-fgo-optimize-<type>	Turn on optimization passes in the frontend.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1133,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1134] = */ {
    "-fgo-pkgpath=",
    "-fgo-pkgpath=<string>	Set Go package path.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1135] = */ {
    "-fgo-prefix=",
    "-fgo-prefix=<string>	Set package-specific prefix for exported Go names.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1136] = */ {
    "-fgo-relative-import-path=",
    "-fgo-relative-import-path=<path>	Treat a relative import as relative to path.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1137] = */ {
    "-fgraphite",
    "Enable in and out of Graphite representation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1137,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_graphite), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1138] = */ {
    "-fgraphite-identity",
    "Enable Graphite Identity transformation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1138,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_graphite_identity), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1139] = */ {
    "-fguess-branch-probability",
    "Enable guessing of branch probabilities.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 1139,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_guess_branch_prob), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1140] = */ {
    "-fguiding-decls",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 14, /* .neg_idx = */ 1140,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1141] = */ {
    "-fhandle-exceptions",
    NULL,
    NULL,
    "%<-fhandle-exceptions%> has been renamed %<-fexceptions%> (and is now on by default)",
    NULL, NULL, OPT_fexceptions, N_OPTS, 18, /* .neg_idx = */ 1141,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1142] = */ {
    "-fhelp",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT__help, N_OPTS, 5, /* .neg_idx = */ 1142,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1143] = */ {
    "-fhelp=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT__help_, N_OPTS, 6, /* .neg_idx = */ 1143,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1144] = */ {
    "-fhoist-adjacent-loads",
    "Enable hoisting adjacent loads to encourage generating conditional move instructions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1144,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_hoist_adjacent_loads), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1145] = */ {
    "-fhonor-std",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 10, /* .neg_idx = */ 1145,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1146] = */ {
    "-fhosted",
    "Assume normal C execution environment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1146,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1147] = */ {
    "-fhuge-objects",
    "No longer supported.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 13, /* .neg_idx = */ 1147,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1148] = */ {
    "-fident",
    "Process #ident directives.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1148,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_ident), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1149] = */ {
    "-fif-conversion",
    "Perform conversion of conditional jumps to branchless equivalents.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1149,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_if_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1150] = */ {
    "-fif-conversion2",
    "Perform conversion of conditional jumps to conditional execution.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1150,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_if_conversion2), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1151] = */ {
    "-fignore-unknown-pragmas",
    "Ignore unsupported pragmas.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1151,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1152] = */ {
    "-fimplement-inlines",
    "Export functions even if they can be inlined.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1152,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_implement_inlines), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1153] = */ {
    "-fimplicit-inline-templates",
    "Emit implicit instantiations of inline templates.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1153,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_implicit_inline_templates), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1154] = */ {
    "-fimplicit-none",
    "Specify that no implicit typing is allowed, unless overridden by explicit IMPLICIT statements.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1154,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_implicit_none), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1155] = */ {
    "-fimplicit-templates",
    "Emit implicit instantiations of templates.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1155,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_implicit_templates), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1156] = */ {
    "-findirect-inlining",
    "Perform indirect inlining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1156,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_indirect_inlining), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1157] = */ {
    "-finhibit-size-directive",
    "Do not generate .size directives.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1157,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_inhibit_size_directive), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1158] = */ {
    "-finit-character=",
    "-finit-character=<n>	Initialize local character variables to ASCII value n.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1159] = */ {
    "-finit-derived",
    "Initialize components of derived type variables according to other init flags.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1159,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_init_derived), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1160] = */ {
    "-finit-integer=",
    "-finit-integer=<n>	Initialize local integer variables to n.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1161] = */ {
    "-finit-local-zero",
    "Initialize local variables to zero (from g77).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1161,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1162] = */ {
    "-finit-logical=",
    "-finit-logical=<true|false>	Initialize local logical variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1163] = */ {
    "-finit-real=",
    "-finit-real=<zero|snan|nan|inf|-inf>	Initialize local real variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 1 /* ToLower */, 0,
    offsetof (struct gcc_options, x_flag_init_real), 24, CLVC_ENUM, 0, -1, -1 },
 /* [1164] = */ {
    "-finline",
    "Enable inlining of function declared \"inline\", disabling disables all inlining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1164,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_inline), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1165] = */ {
    "-finline-arg-packing",
    "-finline-arg-packing	Perform argument packing inline.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1165,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_inline_arg_packing), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1166] = */ {
    "-finline-atomics",
    "Inline __atomic operations when a lock free instruction sequence is available.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1166,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_inline_atomics), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1167] = */ {
    "-finline-functions",
    "Integrate functions not declared \"inline\" into their callers when profitable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1167,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_inline_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1168] = */ {
    "-finline-functions-called-once",
    "Integrate functions only required by their single caller.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 1168,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_inline_functions_called_once), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1169] = */ {
    "-finline-limit-",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_finline_limit_, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1170] = */ {
    "-finline-limit=",
    "-finline-limit=<number>	Limit the size of inlined functions to <number>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1171] = */ {
    "-finline-matmul-limit=",
    "-finline-matmul-limit=<n>	Specify the size of the largest matrix for which matmul will be inlined.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_inline_matmul_limit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1172] = */ {
    "-finline-small-functions",
    "Integrate functions into their callers when code size is known not to grow.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1172,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_inline_small_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1173] = */ {
    "-finput-charset=",
    "-finput-charset=<cset>	Specify the default character set for source files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1174] = */ {
    "-finstrument-functions",
    "Instrument function entry and exit with profiling calls.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1174,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_instrument_function_entry_exit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1175] = */ {
    "-finstrument-functions-exclude-file-list=",
    "-finstrument-functions-exclude-file-list=filename,...	Do not instrument functions listed in files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 40, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1176] = */ {
    "-finstrument-functions-exclude-function-list=",
    "-finstrument-functions-exclude-function-list=name,...	Do not instrument listed functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 44, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1177] = */ {
    "-finteger-4-integer-8",
    "Interpret any INTEGER(4) as an INTEGER(8).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_integer4_kind), 0, CLVC_EQUAL, 8, -1, -1 },
 /* [1178] = */ {
    "-fintrinsic-modules-path",
    "Specify where to find the compiled intrinsic modules.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_Fortran | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1179] = */ {
    "-fintrinsic-modules-path=",
    "Specify where to find the compiled intrinsic modules.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1180] = */ {
    "-finvariants",
    "Generate code for class invariant contracts.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1180,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_invariants), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1181] = */ {
    "-fipa-bit-cp",
    "Perform interprocedural bitwise constant propagation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1181,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_bit_cp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1182] = */ {
    "-fipa-cp",
    "Perform interprocedural constant propagation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1182,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_cp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1183] = */ {
    "-fipa-cp-alignment",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, /* .neg_idx = */ 1183,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1184] = */ {
    "-fipa-cp-clone",
    "Perform cloning to make Interprocedural constant propagation stronger.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1184,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_cp_clone), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1185] = */ {
    "-fipa-icf",
    "Perform Identical Code Folding for functions and read-only variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1185,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_icf), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1186] = */ {
    "-fipa-icf-functions",
    "Perform Identical Code Folding for functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1186,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_icf_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1187] = */ {
    "-fipa-icf-variables",
    "Perform Identical Code Folding for variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1187,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_icf_variables), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1188] = */ {
    "-fipa-matrix-reorg",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, /* .neg_idx = */ 1188,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1189] = */ {
    "-fipa-modref",
    "Perform interprocedural modref analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1189,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_modref), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1190] = */ {
    "-fipa-profile",
    "Perform interprocedural profile propagation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1190,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_profile), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1191] = */ {
    "-fipa-pta",
    "Perform interprocedural points-to analysis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1191,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_pta), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1192] = */ {
    "-fipa-pure-const",
    "Discover pure and const functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1192,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_pure_const), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1193] = */ {
    "-fipa-ra",
    "Use caller save register across calls if possible.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1193,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_ra), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1194] = */ {
    "-fipa-reference",
    "Discover read-only and non addressable static variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1194,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_reference), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1195] = */ {
    "-fipa-reference-addressable",
    "Discover read-only, write-only and non-addressable static variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1195,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_reference_addressable), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1196] = */ {
    "-fipa-sra",
    "Perform interprocedural reduction of aggregates.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1196,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_sra), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1197] = */ {
    "-fipa-stack-alignment",
    "Reduce stack alignment on call sites if possible.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1197,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_stack_alignment), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1198] = */ {
    "-fipa-struct-reorg",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, /* .neg_idx = */ 1198,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1199] = */ {
    "-fipa-vrp",
    "Perform IPA Value Range Propagation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1199,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ipa_vrp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1200] = */ {
    "-fira-algorithm=",
    "-fira-algorithm=[CB|priority]	Set the used IRA algorithm.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_algorithm), 25, CLVC_ENUM, 0, -1, -1 },
 /* [1201] = */ {
    "-fira-hoist-pressure",
    "Use IRA based register pressure calculation in RTL hoist optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1201,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_hoist_pressure), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1202] = */ {
    "-fira-loop-pressure",
    "Use IRA based register pressure calculation in RTL loop optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1202,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_loop_pressure), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1203] = */ {
    "-fira-region=",
    "-fira-region=[one|all|mixed]	Set regions for IRA.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_region), 26, CLVC_ENUM, 0, -1, -1 },
 /* [1204] = */ {
    "-fira-share-save-slots",
    "Share slots for saving different hard registers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1204,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_share_save_slots), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1205] = */ {
    "-fira-share-spill-slots",
    "Share stack slots for spilled pseudo-registers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1205,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_share_spill_slots), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1206] = */ {
    "-fira-verbose=",
    "-fira-verbose=<number>	Control IRA's level of diagnostic messages.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_verbose), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1207] = */ {
    "-fisolate-erroneous-paths-attribute",
    "Detect paths that trigger erroneous or undefined behavior due to a null value being used in a way forbidden by a returns_nonnull or nonnull attribute.  Isolate those paths from the main control flow and turn the statement with erroneous or undefined behavior into a trap.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ 1207,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_isolate_erroneous_paths_attribute), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1208] = */ {
    "-fisolate-erroneous-paths-dereference",
    "Detect paths that trigger erroneous or undefined behavior due to dereferencing a null pointer.  Isolate those paths from the main control flow and turn the statement with erroneous or undefined behavior into a trap.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 36, /* .neg_idx = */ 1208,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_isolate_erroneous_paths_dereference), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1209] = */ {
    "-fivar-visibility=",
    "-fvisibility=[private|protected|public|package]	Set the default symbol visibility.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_default_ivar_visibility), 27, CLVC_ENUM, 0, -1, -1 },
 /* [1210] = */ {
    "-fivopts",
    "Optimize induction variables on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1210,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ivopts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1211] = */ {
    "-fjump-tables",
    "Use jump tables for sufficiently large switch statements.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1211,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_jump_tables), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1212] = */ {
    "-fkeep-gc-roots-live",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1212,
    CL_COMMON | CL_UNDOCUMENTED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_keep_gc_roots_live), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1213] = */ {
    "-fkeep-inline-dllexport",
    "Don't emit dllexported inline functions unless needed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1213,
#if TARGET_DLLIMPORT_DECL_ATTRIBUTES
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#else
    0,
    1 /* Disabled.  */, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
    offsetof (struct gcc_options, x_flag_keep_inline_dllexport), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1214] = */ {
    "-fkeep-inline-functions",
    "Generate code for functions even if they are fully inlined.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1214,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_keep_inline_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1215] = */ {
    "-fkeep-static-consts",
    "Emit static const variables even if they are not used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1215,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_keep_static_consts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1216] = */ {
    "-fkeep-static-functions",
    "Generate code for static functions even if they are never called.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1216,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_keep_static_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1217] = */ {
    "-flabels-ok",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 10, /* .neg_idx = */ 1217,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1218] = */ {
    "-flang-info-include-translate",
    "Note #include directives translated to import declarations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ 1218,
    CL_CXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_note_include_translate_yes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1219] = */ {
    "-flang-info-include-translate-not",
    "Note #include directives not translated to import declarations, and not known to be textual.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ 1219,
    CL_CXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_note_include_translate_no), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1220] = */ {
    "-flang-info-include-translate=",
    "Note a #include translation of a specific header.",
    "missing header name",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ -1,
    CL_CXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1221] = */ {
    "-flang-info-module-cmi",
    "Note Compiled Module Interface pathnames.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1221,
    CL_CXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_note_module_cmi_yes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1222] = */ {
    "-flang-info-module-cmi=",
    "Note Compiled Module Interface pathname of a specific module or header-unit.",
    "missing module name",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_CXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1223] = */ {
    "-flarge-source-files",
    "Improve GCC's ability to track column numbers in large source files, at the expense of slower compilation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1223,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_large_source_files), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1224] = */ {
    "-flax-vector-conversions",
    "Allow implicit conversions between vectors with differing numbers of subparts and/or differing element types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1224,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lax_vector_conversions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1225] = */ {
    "-fleading-underscore",
    "Give external symbols a leading underscore.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1225,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_leading_underscore), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1226] = */ {
    "-flifetime-dse",
    "Tell DSE that the storage for a C++ object is dead when the constructor starts and when the destructor finishes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1226,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lifetime_dse), 0, CLVC_EQUAL, 2, -1, -1 },
 /* [1227] = */ {
    "-flifetime-dse=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lifetime_dse), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [1228] = */ {
    "-flimit-function-alignment",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 1228,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_limit_function_alignment), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1229] = */ {
    "-flinker-output=",
    "Set linker output type (used internally during LTO optimization).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_LTO | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_linker_output), 29, CLVC_ENUM, 0, -1, -1 },
 /* [1230] = */ {
    "-flive-patching",
    NULL,
    NULL,
    NULL,
    "inline-clone", NULL, OPT_flive_patching_, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1231] = */ {
    "-flive-patching=",
    "-flive-patching=[inline-only-static|inline-clone]	Control IPA optimizations to provide a safe compilation for live-patching.  At the same time, provides multiple-level control on the enabled IPA optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_live_patching), 28, CLVC_ENUM, 0, -1, -1 },
 /* [1232] = */ {
    "-flive-range-shrinkage",
    "Relief of register pressure through live range shrinkage.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1232,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_live_range_shrinkage), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1233] = */ {
    "-flocal-ivars",
    "Allow access to instance variables as if they were local declarations within instance method implementations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1233,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_local_ivars), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1234] = */ {
    "-floop-block",
    "Enable loop nest transforms.  Same as -floop-nest-optimize.",
    NULL,
    NULL,
    NULL, NULL, OPT_floop_nest_optimize, N_OPTS, 11, /* .neg_idx = */ 1234,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1235] = */ {
    "-floop-flatten",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 13, /* .neg_idx = */ 1235,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1236] = */ {
    "-floop-interchange",
    "Enable loop interchange on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1236,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_loop_interchange), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1237] = */ {
    "-floop-nest-optimize",
    "Enable the loop nest optimizer.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1237,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_loop_nest_optimize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1238] = */ {
    "-floop-optimize",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 14, /* .neg_idx = */ 1238,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1239] = */ {
    "-floop-parallelize-all",
    "Mark all loops as parallel.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1239,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_loop_parallelize_all), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1240] = */ {
    "-floop-strip-mine",
    "Enable loop nest transforms.  Same as -floop-nest-optimize.",
    NULL,
    NULL,
    NULL, NULL, OPT_floop_nest_optimize, N_OPTS, 16, /* .neg_idx = */ 1240,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1241] = */ {
    "-floop-unroll-and-jam",
    "Perform unroll-and-jam on loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1241,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_unroll_jam), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1242] = */ {
    "-flra-remat",
    "Do CFG-sensitive rematerialization in LRA.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1242,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lra_remat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1243] = */ {
    "-flto",
    "Enable link-time optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1243,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1244] = */ {
    "-flto-compression-level=",
    "-flto-compression-level=<number>	Use zlib/zstd compression level <number> for IL.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_compression_level), 0, CLVC_BOOLEAN, 0, 0, 19 },
 /* [1245] = */ {
    "-flto-odr-type-merging",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 21, /* .neg_idx = */ 1245,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1246] = */ {
    "-flto-partition=",
    "Specify the algorithm to partition symbols and vars at linktime.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_partition), 30, CLVC_ENUM, 0, -1, -1 },
 /* [1247] = */ {
    "-flto-report",
    "Report various link-time optimization statistics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1247,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_report), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1248] = */ {
    "-flto-report-wpa",
    "Report various link-time optimization statistics for WPA only.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1248,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_report_wpa), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1249] = */ {
    "-flto=",
    "Link-time optimization with number of parallel jobs or jobserver.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto), 0, CLVC_STRING, 0, -1, -1 },
 /* [1250] = */ {
    "-fltrans",
    "Run the link-time optimizer in local transformation (LTRANS) mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1250,
    CL_LTO,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ltrans), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1251] = */ {
    "-fltrans-output-list=",
    "Specify a file to which a list of files output by LTRANS is written.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1251,
    CL_LTO | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ltrans_output_list), 0, CLVC_STRING, 0, -1, -1 },
 /* [1252] = */ {
    "-fmacro-prefix-map=",
    "-fmacro-prefix-map=<old>=<new>	Map one directory name to another in __FILE__, __BASE_FILE__, and __builtin_FILE().",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1253] = */ {
    "-fmain",
    "Generate a default D main() function when compiling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1254] = */ {
    "-fmath-errno",
    "Set errno after built-in math functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1254,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_errno_math), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1255] = */ {
    "-fmax-array-constructor=",
    "-fmax-array-constructor=<n>	Maximum number of objects in an array constructor.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_max_array_constructor), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1256] = */ {
    "-fmax-errors=",
    "-fmax-errors=<number>	Maximum number of errors to report.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_max_errors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1257] = */ {
    "-fmax-identifier-length=",
    "-fmax-identifier-length=<n>	Maximum identifier length.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1258] = */ {
    "-fmax-include-depth=",
    "fmax-include-depth=<number> Set the maximum depth of the nested #include.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1259] = */ {
    "-fmax-stack-var-size=",
    "-fmax-stack-var-size=<n>	Size in bytes of the largest array that will be put on the stack.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_max_stack_var_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1260] = */ {
    "-fmax-subrecord-length=",
    "-fmax-subrecord-length=<n>	Maximum length for subrecords.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_max_subrecord_length), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1261] = */ {
    "-fmem-report",
    "Report on permanent memory allocation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1261,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_mem_report), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1262] = */ {
    "-fmem-report-wpa",
    "Report on permanent memory allocation in WPA only.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1262,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_mem_report_wpa), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1263] = */ {
    "-fmerge-all-constants",
    "Attempt to merge identical constants and constant variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1263,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_merge_constants), 0, CLVC_EQUAL, 2, -1, -1 },
 /* [1264] = */ {
    "-fmerge-constants",
    "Attempt to merge identical constants across compilation units.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1264,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_merge_constants), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1265] = */ {
    "-fmerge-debug-strings",
    "Attempt to merge identical debug strings across compilation units.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1265,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_merge_debug_strings), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1266] = */ {
    "-fmessage-length=",
    "-fmessage-length=<number>	Limit diagnostics to <number> characters per line.  0 suppresses line-wrapping.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1267] = */ {
    "-fmodule-file=",
    "-fmodule-file=<package.module>=<filespec>	use <filespec> as source file for <package.module>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_D | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1268] = */ {
    "-fmodule-header",
    "Enable C++ header module (experimental).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjC,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_header_unit), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1269] = */ {
    "-fmodule-header=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1270] = */ {
    "-fmodule-implicit-inline",
    "Member functions defined within their class are inline in module purview.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1270,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_module_implicit_inline), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1271] = */ {
    "-fmodule-lazy",
    "Enable lazy module importing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1271,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_module_lazy), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1272] = */ {
    "-fmodule-mapper=",
    "Mapper for module to CMI files.",
    "missing mapper",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1273] = */ {
    "-fmodule-only",
    "Only emit Compiled Module Interface.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjC,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_module_only), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1274] = */ {
    "-fmodule-private",
    "Set default accessibility of module entities to PRIVATE.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1274,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_module_private), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1275] = */ {
    "-fmodule-version-ignore",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1275,
    CL_CXX | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_module_version_ignore), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1276] = */ {
    "-fmoduleinfo",
    "Generate ModuleInfo struct for output module.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1276,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_moduleinfo), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1277] = */ {
    "-fmodules-ts",
    "Enable C++ modules-ts (experimental).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1277,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_modules), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1278] = */ {
    "-fmodulo-sched",
    "Perform SMS based modulo scheduling before the first scheduling pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1278,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_modulo_sched), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1279] = */ {
    "-fmodulo-sched-allow-regmoves",
    "Perform SMS based modulo scheduling with register moves allowed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ 1279,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_modulo_sched_allow_regmoves), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1280] = */ {
    "-fmove-loop-invariants",
    "Move loop invariant computations out of loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1280,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_move_loop_invariants), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1281] = */ {
    "-fms-extensions",
    "Don't warn about uses of Microsoft extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1281,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ms_extensions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1282] = */ {
    "-fmudflap",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 8, /* .neg_idx = */ 1282,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1283] = */ {
    "-fmudflapir",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 10, /* .neg_idx = */ 1283,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1284] = */ {
    "-fmudflapth",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 10, /* .neg_idx = */ 1284,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1285] = */ {
    "-fname-mangling-version-",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 23, /* .neg_idx = */ 1285,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1286] = */ {
    "-fnew-abi",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 8, /* .neg_idx = */ 1286,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1287] = */ {
    "-fnew-inheriting-ctors",
    "Implement C++17 inheriting constructor semantics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1287,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_new_inheriting_ctors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1288] = */ {
    "-fnew-ttp-matching",
    "Implement resolution of DR 150 for matching of template template arguments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1288,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_new_ttp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1289] = */ {
    "-fnext-runtime",
    "Generate code for NeXT (Apple Mac OS X) runtime environment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_next_runtime), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1290] = */ {
    "-fnil-receivers",
    "Assume that receivers of Objective-C messages may be nil.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1290,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_nil_receivers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1291] = */ {
    "-fno-modules",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_modules), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1292] = */ {
    "-fnon-call-exceptions",
    "Support synchronous non-call exceptions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1292,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_non_call_exceptions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1293] = */ {
    "-fnonansi-builtins",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1293,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_nonansi_builtin), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1294] = */ {
    "-fnonnull-objects",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 16, /* .neg_idx = */ 1294,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1295] = */ {
    "-fnothrow-opt",
    "Treat a throw() exception specification as noexcept to improve code size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1295,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_nothrow_opt), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1296] = */ {
    "-fobjc-abi-version=",
    "Specify which ABI to use for Objective-C family code and meta-data generation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_abi), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1297] = */ {
    "-fobjc-call-cxx-cdtors",
    "Generate special Objective-C methods to initialize/destroy non-POD C++ ivars, if needed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1297,
    CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_call_cxx_cdtors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1298] = */ {
    "-fobjc-direct-dispatch",
    "Allow fast jumps to the message dispatcher.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1298,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_direct_dispatch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1299] = */ {
    "-fobjc-exceptions",
    "Enable Objective-C exception and synchronization syntax.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1299,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_exceptions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1300] = */ {
    "-fobjc-gc",
    "Enable garbage collection (GC) in Objective-C/Objective-C++ programs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1300,
    CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_gc), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1301] = */ {
    "-fobjc-nilcheck",
    "Enable inline checks for nil receivers with the NeXT runtime and ABI version 2.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1301,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_nilcheck), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1302] = */ {
    "-fobjc-sjlj-exceptions",
    "Enable Objective-C setjmp exception handling runtime.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1302,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_sjlj_exceptions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1303] = */ {
    "-fobjc-std=objc1",
    "Conform to the Objective-C 1.0 language as implemented in GCC 4.0.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1303,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc1_only), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1304] = */ {
    "-foffload-abi=",
    "-foffload-abi=[lp64|ilp32]	Set the ABI to use in an offload compiler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_offload_abi), 31, CLVC_ENUM, 0, -1, -1 },
 /* [1305] = */ {
    "-foffload=",
    "-foffload=<targets>=<options>	Specify offloading targets and options for them.",
    "options or targets missing after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1305,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1306] = */ {
    "-fomit-frame-pointer",
    "When possible do not generate stack frames.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1306,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_omit_frame_pointer), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1307] = */ {
    "-fonly=",
    "Process all modules specified on the command line, but only generate code for the module specified by the argument.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_D | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1308] = */ {
    "-fopenacc",
    "Enable OpenACC.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1308,
    CL_C | CL_CXX | CL_Fortran | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_openacc), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1309] = */ {
    "-fopenacc-dim=",
    "Specify default OpenACC compute dimensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1309,
    CL_C | CL_CXX | CL_Fortran | CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_openacc_dims), 0, CLVC_STRING, 0, -1, -1 },
 /* [1310] = */ {
    "-fopenmp",
    "Enable OpenMP (implies -frecursive in Fortran).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1310,
    CL_C | CL_CXX | CL_Fortran | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_openmp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1311] = */ {
    "-fopenmp-simd",
    "Enable OpenMP's SIMD directives.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1311,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_openmp_simd), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1312] = */ {
    "-foperator-names",
    "Recognize C++ keywords like \"compl\" and \"xor\".",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1312,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1313] = */ {
    "-fopt-info",
    "Enable all optimization info dumps on stderr.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1313,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_opt_info), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1314] = */ {
    "-fopt-info-",
    "-fopt-info[-<type>=filename]	Dump compiler optimization details.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1315] = */ {
    "-foptimize-register-move",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 23, /* .neg_idx = */ 1315,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1316] = */ {
    "-foptimize-sibling-calls",
    "Optimize sibling and tail recursive calls.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1316,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_optimize_sibling_calls), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1317] = */ {
    "-foptimize-strlen",
    "Enable string length optimizations on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1317,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_optimize_strlen), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1318] = */ {
    "-foptional-diags",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, /* .neg_idx = */ 1318,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1319] = */ {
    "-fpack-derived",
    "Try to lay out derived types as compactly as possible.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1319,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pack_derived), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1320] = */ {
    "-fpack-struct",
    "Pack structure members together without holes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1320,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pack_struct), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1321] = */ {
    "-fpack-struct=",
    "-fpack-struct=<number>	Set initial maximum structure member alignment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1322] = */ {
    "-fpad-source",
    "Pad shorter fixed form lines to line width with spaces.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1322,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pad_source), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1323] = */ {
    "-fpartial-inlining",
    "Perform partial inlining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1323,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_partial_inlining), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1324] = */ {
    "-fpatchable-function-entry=",
    "Insert NOP instructions at each function entry.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1324,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_patchable_function_entry), 0, CLVC_STRING, 0, -1, -1 },
 /* [1325] = */ {
    "-fpcc-struct-return",
    "Return small aggregates in memory, not registers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1325,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pcc_struct_return), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1326] = */ {
    "-fpch-deps",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1326,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1327] = */ {
    "-fpch-preprocess",
    "Look for and use PCH files even when preprocessing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1327,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1328] = */ {
    "-fpeel-loops",
    "Perform loop peeling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1328,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_peel_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1329] = */ {
    "-fpeephole",
    "Enable machine specific peephole optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1329,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_peephole), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1330] = */ {
    "-fpeephole2",
    "Enable an RTL peephole pass before sched2.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1330,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_peephole2), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1331] = */ {
    "-fpermissive",
    "Downgrade conformance errors to warnings.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1331,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_permissive), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1332] = */ {
    "-fpermitted-flt-eval-methods=",
    "-fpermitted-flt-eval-methods=[c11|ts-18661]	Specify which values of FLT_EVAL_METHOD are permitted.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_permitted_flt_eval_methods), 34, CLVC_ENUM, 0, -1, -1 },
 /* [1333] = */ {
    "-fpic",
    "Generate position-independent code if possible (small mode).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1334,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pic), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1334] = */ {
    "-fpie",
    "Generate position-independent code for executables if possible (small mode).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 830,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pie), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1335] = */ {
    "-fplan9-extensions",
    "Enable Plan 9 language extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1335,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_plan9_extensions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1336] = */ {
    "-fplt",
    "Use PLT for PIC calls (-fno-plt: load the address from GOT at call site).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1336,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_plt), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1337] = */ {
    "-fplugin-arg-",
    "-fplugin-arg-<name>-<key>[=<value>]	Specify argument <key>=<value> for plugin <name>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1338] = */ {
    "-fplugin=",
    "Specify a plugin to load.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1339] = */ {
    "-fpost-ipa-mem-report",
    "Report on memory allocation before interprocedural optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1339,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_post_ipa_mem_report), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1340] = */ {
    "-fpostconditions",
    "Generate code for postcondition contracts.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1340,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_postconditions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1341] = */ {
    "-fpre-include=",
    "Path to header file that should be pre-included before each compilation unit.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pre_include), 0, CLVC_STRING, 0, -1, -1 },
 /* [1342] = */ {
    "-fpre-ipa-mem-report",
    "Report on memory allocation before interprocedural optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1342,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_pre_ipa_mem_report), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1343] = */ {
    "-fpreconditions",
    "Generate code for precondition contracts.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1343,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_preconditions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1344] = */ {
    "-fpredictive-commoning",
    "Run predictive commoning optimization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1344,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_predictive_commoning), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1345] = */ {
    "-fprefetch-loop-arrays",
    "Generate prefetch instructions, if available, for arrays in loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1345,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_prefetch_loop_arrays), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1346] = */ {
    "-fpreprocessed",
    "Treat the input file as already preprocessed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1346,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1347] = */ {
    "-fpretty-templates",
    "Do not pretty-print template specializations as the template signature followed by the arguments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1347,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pretty_templates), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1348] = */ {
    "-fprintf-return-value",
    "Treat known sprintf return values as constants.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1348,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_printf_return_value), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1349] = */ {
    "-fprofile",
    "Enable basic program profiling code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1349,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_flag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1350] = */ {
    "-fprofile-abs-path",
    "Generate absolute source path names for gcov.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1350,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_abs_path_flag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1351] = */ {
    "-fprofile-arcs",
    "Insert arc-based program profiling code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1351,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_arc_flag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1352] = */ {
    "-fprofile-correction",
    "Enable correction of flow inconsistent profile data input.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1352,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_correction), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1353] = */ {
    "-fprofile-dir=",
    "Set the top-level directory for storing the profile data. The default is 'pwd'.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_data_prefix), 0, CLVC_STRING, 0, -1, -1 },
 /* [1354] = */ {
    "-fprofile-exclude-files=",
    "Instrument only functions from files whose name does not match any of the regular expressions (separated by semi-colons).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_exclude_files), 0, CLVC_STRING, 0, -1, -1 },
 /* [1355] = */ {
    "-fprofile-filter-files=",
    "Instrument only functions from files whose name matches any of the regular expressions (separated by semi-colons).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_filter_files), 0, CLVC_STRING, 0, -1, -1 },
 /* [1356] = */ {
    "-fprofile-generate",
    "Enable common options for generating profile info for profile feedback directed optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1356,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1357] = */ {
    "-fprofile-generate=",
    "Enable common options for generating profile info for profile feedback directed optimizations, and set -fprofile-dir=.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1358] = */ {
    "-fprofile-info-section",
    "Register the profile information in the .gcov_info section instead of using a constructor/destructor.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1359] = */ {
    "-fprofile-info-section=",
    "Register the profile information in the specified section instead of using a constructor/destructor.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_info_section), 0, CLVC_STRING, 0, -1, -1 },
 /* [1360] = */ {
    "-fprofile-note=",
    "Select the name for storing the profile note file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_note_location), 0, CLVC_STRING, 0, -1, -1 },
 /* [1361] = */ {
    "-fprofile-partial-training",
    "Do not assume that functions never executed during the train run are cold.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 1361,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_partial_training), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1362] = */ {
    "-fprofile-prefix-path=",
    "Remove prefix from absolute path before mangling name for -fprofile-generate= and -fprofile-use=.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_prefix_path), 0, CLVC_STRING, 0, -1, -1 },
 /* [1363] = */ {
    "-fprofile-reorder-functions",
    "Enable function reordering that improves code placement.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1363,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_reorder_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1364] = */ {
    "-fprofile-report",
    "Report on consistency of profile.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1364,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_report), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1365] = */ {
    "-fprofile-reproducible=",
    "-fprofile-reproducible=[serial|parallel-runs|multithreaded]	Control level of reproducibility of profile gathered by -fprofile-generate.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_reproducible), 36, CLVC_ENUM, 0, -1, -1 },
 /* [1366] = */ {
    "-fprofile-update=",
    "-fprofile-update=[single|atomic|prefer-atomic]	Set the profile update method.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_update), 37, CLVC_ENUM, 0, -1, -1 },
 /* [1367] = */ {
    "-fprofile-use",
    "Enable common options for performing profile feedback directed optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1367,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_use), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1368] = */ {
    "-fprofile-use=",
    "Enable common options for performing profile feedback directed optimizations, and set -fprofile-dir=.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1369] = */ {
    "-fprofile-values",
    "Insert code to profile values of expressions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1369,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_values), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1370] = */ {
    "-fprotect-parens",
    "Protect parentheses in expressions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1370,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_protect_parens), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1371] = */ {
    "-frandom-seed",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1371,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1372] = */ {
    "-frandom-seed=",
    "-frandom-seed=<string>	Make compile reproducible using <string>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1373] = */ {
    "-frange-check",
    "Enable range checking during compilation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1373,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_range_check), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1374] = */ {
    "-freal-4-real-10",
    "Interpret any REAL(4) as a REAL(10).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_real4_kind), 0, CLVC_EQUAL, 10, -1, -1 },
 /* [1375] = */ {
    "-freal-4-real-16",
    "Interpret any REAL(4) as a REAL(16).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_real4_kind), 0, CLVC_EQUAL, 16, -1, -1 },
 /* [1376] = */ {
    "-freal-4-real-8",
    "Interpret any REAL(4) as a REAL(8).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_real4_kind), 0, CLVC_EQUAL, 8, -1, -1 },
 /* [1377] = */ {
    "-freal-8-real-10",
    "Interpret any REAL(8) as a REAL(10).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_real8_kind), 0, CLVC_EQUAL, 10, -1, -1 },
 /* [1378] = */ {
    "-freal-8-real-16",
    "Interpret any REAL(8) as a REAL(16).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_real8_kind), 0, CLVC_EQUAL, 16, -1, -1 },
 /* [1379] = */ {
    "-freal-8-real-4",
    "Interpret any REAL(8) as a REAL(4).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_real8_kind), 0, CLVC_EQUAL, 4, -1, -1 },
 /* [1380] = */ {
    "-frealloc-lhs",
    "Reallocate the LHS in assignments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1380,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_realloc_lhs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1381] = */ {
    "-freciprocal-math",
    "Same as -fassociative-math for expressions which include division.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1381,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_reciprocal_math), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1382] = */ {
    "-frecord-gcc-switches",
    "Record gcc command line switches in the object file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1382,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_record_gcc_switches), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1383] = */ {
    "-frecord-marker=4",
    "Use a 4-byte record marker for unformatted files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_record_marker), 0, CLVC_EQUAL, 4, -1, -1 },
 /* [1384] = */ {
    "-frecord-marker=8",
    "Use an 8-byte record marker for unformatted files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_record_marker), 0, CLVC_EQUAL, 8, -1, -1 },
 /* [1385] = */ {
    "-frecursive",
    "Allocate local variables on the stack to allow indirect recursion.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1385,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_recursive), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1386] = */ {
    "-free",
    "Turn on Redundant Extensions Elimination pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1386,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ree), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1387] = */ {
    "-freg-struct-return",
    "Return small aggregates in registers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1387,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pcc_struct_return), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1388] = */ {
    "-fregmove",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 8, /* .neg_idx = */ 1388,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1389] = */ {
    "-frelease",
    "Compile release version.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1389,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1390] = */ {
    "-frename-registers",
    "Perform a register renaming optimization pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1390,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_rename_registers), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1391] = */ {
    "-freorder-blocks",
    "Reorder basic blocks to improve code placement.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1391,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_reorder_blocks), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1392] = */ {
    "-freorder-blocks-algorithm=",
    "-freorder-blocks-algorithm=[simple|stc]	Set the used basic block reordering algorithm.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_reorder_blocks_algorithm), 38, CLVC_ENUM, 0, -1, -1 },
 /* [1393] = */ {
    "-freorder-blocks-and-partition",
    "Reorder basic blocks and partition into hot and cold sections.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 29, /* .neg_idx = */ 1393,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_reorder_blocks_and_partition), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1394] = */ {
    "-freorder-functions",
    "Reorder functions to improve code placement.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1394,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_reorder_functions), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1395] = */ {
    "-frepack-arrays",
    "Copy array sections into a contiguous block on procedure entry.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1395,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_repack_arrays), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1396] = */ {
    "-freplace-objc-classes",
    "Used in Fix-and-Continue mode to indicate that object files may be swapped in at runtime.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1396,
    CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_replace_objc_classes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1397] = */ {
    "-frepo",
    "Removed in GCC 10.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 5, /* .neg_idx = */ 1397,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1398] = */ {
    "-freport-bug",
    "Collect and dump debug information into temporary file if ICE in C/C++ compiler occurred.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1398,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_report_bug), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1399] = */ {
    "-frequire-return-statement",
    "Functions which return values must end with return statements.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 1399,
    CL_Go | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_require_return_statement), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1400] = */ {
    "-frerun-cse-after-loop",
    "Add a common subexpression elimination pass after loop optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1400,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_rerun_cse_after_loop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1401] = */ {
    "-frerun-loop-opt",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, /* .neg_idx = */ 1401,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1402] = */ {
    "-freschedule-modulo-scheduled-loops",
    "Enable/Disable the traditional scheduling in loops that already passed modulo scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 34, /* .neg_idx = */ 1402,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_resched_modulo_sched), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1403] = */ {
    "-fresolution=",
    "The resolution file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1403,
    CL_LTO | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1404] = */ {
    "-frounding-math",
    "Disable optimizations that assume default FP rounding behavior.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1404,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_rounding_math), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1405] = */ {
    "-frtti",
    "Generate run time type descriptor information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 1405,
    CL_CXX | CL_D | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_rtti), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1406] = */ {
    "-fsanitize-address-use-after-scope",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ 1406,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sanitize_address_use_after_scope), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1407] = */ {
    "-fsanitize-coverage=",
    "Select type of coverage sanitization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1407,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1408] = */ {
    "-fsanitize-recover",
    "This switch is deprecated; use -fsanitize-recover= instead.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1408,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1409] = */ {
    "-fsanitize-recover=",
    "After diagnosing undefined behavior attempt to continue execution.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1409,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1410] = */ {
    "-fsanitize-sections=",
    "-fsanitize-sections=<sec1,sec2,...>	Sanitize global variables in user-defined sections.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1411] = */ {
    "-fsanitize-undefined-trap-on-error",
    "Use trap instead of a library function for undefined behavior sanitization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ 1411,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sanitize_undefined_trap_on_error), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1412] = */ {
    "-fsanitize=",
    "Select what to sanitize.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1412,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1413] = */ {
    "-fsave-optimization-record",
    "Write a SRCFILE.opt-record.json file detailing what optimizations were performed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 1413,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_save_optimization_record), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1414] = */ {
    "-fsched-critical-path-heuristic",
    "Enable the critical path heuristic in the scheduler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 1414,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_critical_path_heuristic), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1415] = */ {
    "-fsched-dep-count-heuristic",
    "Enable the dependent count heuristic in the scheduler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1415,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_dep_count_heuristic), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1416] = */ {
    "-fsched-group-heuristic",
    "Enable the group heuristic in the scheduler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1416,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_group_heuristic), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1417] = */ {
    "-fsched-interblock",
    "Enable scheduling across basic blocks.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1417,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_schedule_interblock), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1418] = */ {
    "-fsched-last-insn-heuristic",
    "Enable the last instruction heuristic in the scheduler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1418,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_last_insn_heuristic), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1419] = */ {
    "-fsched-pressure",
    "Enable register pressure sensitive insn scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1419,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_pressure), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1420] = */ {
    "-fsched-rank-heuristic",
    "Enable the rank heuristic in the scheduler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1420,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_rank_heuristic), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1421] = */ {
    "-fsched-spec",
    "Allow speculative motion of non-loads.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1421,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_schedule_speculative), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1422] = */ {
    "-fsched-spec-insn-heuristic",
    "Enable the speculative instruction heuristic in the scheduler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1422,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_spec_insn_heuristic), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1423] = */ {
    "-fsched-spec-load",
    "Allow speculative motion of some loads.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1423,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_schedule_speculative_load), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1424] = */ {
    "-fsched-spec-load-dangerous",
    "Allow speculative motion of more loads.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1424,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_schedule_speculative_load_dangerous), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1425] = */ {
    "-fsched-stalled-insns",
    "Allow premature scheduling of queued insns.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1425,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_stalled_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1426] = */ {
    "-fsched-stalled-insns-dep",
    "Set dependence distance checking in premature scheduling of queued insns.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 1426,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched_stalled_insns_dep), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1427] = */ {
    "-fsched-stalled-insns-dep=",
    "-fsched-stalled-insns-dep=<number>	Set dependence distance checking in premature scheduling of queued insns.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1428] = */ {
    "-fsched-stalled-insns=",
    "-fsched-stalled-insns=<number>	Set number of queued insns that can be prematurely scheduled.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1429] = */ {
    "-fsched-verbose=",
    "-fsched-verbose=<number>	Set the verbosity level of the scheduler.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_sched_verbose_param), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1430] = */ {
    "-fsched2-use-superblocks",
    "If scheduling post reload, do superblock scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1430,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sched2_use_superblocks), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1431] = */ {
    "-fsched2-use-traces",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 18, /* .neg_idx = */ 1431,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1432] = */ {
    "-fschedule-fusion",
    "Perform a target dependent instruction fusion optimization pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1432,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_schedule_fusion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1433] = */ {
    "-fschedule-insns",
    "Reschedule instructions before register allocation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1433,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_schedule_insns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1434] = */ {
    "-fschedule-insns2",
    "Reschedule instructions after register allocation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1434,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_schedule_insns_after_reload), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1435] = */ {
    "-fsecond-underscore",
    "Append a second underscore if the name already contains an underscore.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1435,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_second_underscore), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1436] = */ {
    "-fsection-anchors",
    "Access data in the same section from shared anchor points.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1436,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_section_anchors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1437] = */ {
    "-fsee",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 4, /* .neg_idx = */ 1437,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1438] = */ {
    "-fsel-sched-pipelining",
    "Perform software pipelining of inner loops during selective scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1438,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sel_sched_pipelining), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1439] = */ {
    "-fsel-sched-pipelining-outer-loops",
    "Perform software pipelining of outer loops during selective scheduling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 33, /* .neg_idx = */ 1439,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sel_sched_pipelining_outer_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1440] = */ {
    "-fsel-sched-reschedule-pipelined",
    "Reschedule pipelined regions without pipelining.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ 1440,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sel_sched_reschedule_pipelined), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1441] = */ {
    "-fselective-scheduling",
    "Schedule instructions using selective scheduling algorithm.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1441,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_selective_scheduling), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1442] = */ {
    "-fselective-scheduling2",
    "Run selective scheduling after reload.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1442,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_selective_scheduling2), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1443] = */ {
    "-fself-test=",
    "Run self-tests, using the given path to locate test files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1443,
    CL_COMMON | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_self_test), 0, CLVC_STRING, 0, -1, -1 },
 /* [1444] = */ {
    "-fsemantic-interposition",
    "Allow interposing function (or variables) by ones with different semantics (or initializer) respectively by dynamic linker.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1444,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_semantic_interposition), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1445] = */ {
    "-fshort-enums",
    "Use the narrowest integer type possible for enumeration types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1445,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_LTO | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_short_enums), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1446] = */ {
    "-fshort-wchar",
    "Force the underlying type for \"wchar_t\" to be \"unsigned short\".",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1446,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_short_wchar), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1447] = */ {
    "-fshow-column",
    "Show column numbers in diagnostics, when available.  Default on.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1447,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_show_column), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1448] = */ {
    "-fshrink-wrap",
    "Emit function prologues only before parts of the function that need it, rather than at the top of the function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1448,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_shrink_wrap), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1449] = */ {
    "-fshrink-wrap-separate",
    "Shrink-wrap parts of the prologue and epilogue separately.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1449,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_shrink_wrap_separate), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1450] = */ {
    "-fsign-zero",
    "Apply negative sign to zero values.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1450,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sign_zero), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1451] = */ {
    "-fsignaling-nans",
    "Disable optimizations observable by IEEE signaling NaNs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1451,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signaling_nans), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1452] = */ {
    "-fsigned-bitfields",
    "When \"signed\" or \"unsigned\" is not given make the bitfield signed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1452,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_bitfields), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1453] = */ {
    "-fsigned-char",
    "Make \"char\" signed by default.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1453,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_char), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1454] = */ {
    "-fsigned-zeros",
    "Disable floating point optimizations that ignore the IEEE signedness of zero.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1454,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_zeros), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1455] = */ {
    "-fsimd-cost-model=",
    "-fsimd-cost-model=[unlimited|dynamic|cheap|very-cheap]	Specifies the vectorization cost model for code marked with a simd directive.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_simd_cost_model), 46, CLVC_ENUM, 0, -1, -1 },
 /* [1456] = */ {
    "-fsingle-precision-constant",
    "Convert floating point constants to single precision constants.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1456,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_single_precision_constant), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1457] = */ {
    "-fsized-deallocation",
    "Enable C++14 sized deallocation support.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1457,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sized_deallocation), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1458] = */ {
    "-fsplit-ivs-in-unroller",
    "Split lifetimes of induction variables when loops are unrolled.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1458,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_split_ivs_in_unroller), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1459] = */ {
    "-fsplit-loops",
    "Perform loop splitting.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1459,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_split_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1460] = */ {
    "-fsplit-paths",
    "Split paths leading to loop backedges.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1460,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_split_paths), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1461] = */ {
    "-fsplit-stack",
    "Generate discontiguous stack frames.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1461,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_split_stack), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1462] = */ {
    "-fsplit-wide-types",
    "Split wide types into independent registers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1462,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_split_wide_types), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1463] = */ {
    "-fsplit-wide-types-early",
    "Split wide types into independent registers earlier.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1463,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_split_wide_types_early), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1464] = */ {
    "-fsquangle",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 9, /* .neg_idx = */ 1464,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1465] = */ {
    "-fssa-backprop",
    "Enable backward propagation of use properties at the SSA level.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1465,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ssa_backprop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1466] = */ {
    "-fssa-phiopt",
    "Optimize conditional patterns using SSA PHI nodes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1466,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ssa_phiopt), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1467] = */ {
    "-fsso-struct=",
    "-fsso-struct=[big-endian|little-endian|native]	Set the default scalar storage order.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_C | CL_ObjC | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_default_sso), 39, CLVC_ENUM, 0, -1, -1 },
 /* [1468] = */ {
    "-fstack-arrays",
    "Put all local arrays on stack.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1468,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_arrays), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1469] = */ {
    "-fstack-check",
    "Insert stack checking code into the program.  Same as -fstack-check=specific.",
    NULL,
    NULL,
    "specific", "no", OPT_fstack_check_, N_OPTS, 12, /* .neg_idx = */ 1469,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1470] = */ {
    "-fstack-check=",
    "-fstack-check=[no|generic|specific]	Insert stack checking code into the program.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1471] = */ {
    "-fstack-clash-protection",
    "Insert code to probe each page of stack space as it is allocated to protect from stack-clash style attacks.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1471,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_clash_protection), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1472] = */ {
    "-fstack-limit",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1472,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1473] = */ {
    "-fstack-limit-register=",
    "-fstack-limit-register=<register>	Trap if the stack goes past <register>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1474] = */ {
    "-fstack-limit-symbol=",
    "-fstack-limit-symbol=<name>	Trap if the stack goes past symbol <name>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0, -1, -1 },
 /* [1475] = */ {
    "-fstack-protector",
    "Use propolice as a stack protection method.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1475,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_protect), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1476] = */ {
    "-fstack-protector-all",
    "Use a stack protection method for every function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_protect), 0, CLVC_EQUAL, 2, -1, -1 },
 /* [1477] = */ {
    "-fstack-protector-explicit",
    "Use stack protection method only for functions with the stack_protect attribute.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_protect), 0, CLVC_EQUAL, 4, -1, -1 },
 /* [1478] = */ {
    "-fstack-protector-strong",
    "Use a smart stack protection method for certain functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_protect), 0, CLVC_EQUAL, 3, -1, -1 },
 /* [1479] = */ {
    "-fstack-reuse=",
    "-fstack-reuse=[all|named_vars|none]	Set stack reuse level for local variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_reuse), 40, CLVC_ENUM, 0, -1, -1 },
 /* [1480] = */ {
    "-fstack-usage",
    "Output stack usage information on a per-function basis.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_usage), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1481] = */ {
    "-fstats",
    "Display statistics accumulated during compilation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1481,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_detailed_statistics), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1482] = */ {
    "-fstdarg-opt",
    "Optimize amount of stdarg registers saved to stack at start of function.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1482,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stdarg_opt), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1483] = */ {
    "-fstore-merging",
    "Merge adjacent stores.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1483,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_store_merging), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1484] = */ {
    "-fstrength-reduce",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 16, /* .neg_idx = */ 1484,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1485] = */ {
    "-fstrict-aliasing",
    "Assume strict aliasing rules apply.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1485,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_strict_aliasing), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1486] = */ {
    "-fstrict-enums",
    "Assume that values of enumeration type are always within the minimum range of that type.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1486,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_strict_enums), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1487] = */ {
    "-fstrict-overflow",
    "Treat signed overflow as undefined.  Negated as -fwrapv -fwrapv-pointer.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1487,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1488] = */ {
    "-fstrict-prototype",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 17, /* .neg_idx = */ 1488,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1489] = */ {
    "-fstrict-volatile-bitfields",
    "Force bitfield accesses to match their type width.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1489,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_strict_volatile_bitfields), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1490] = */ {
    "-fstrong-eval-order",
    "Follow the C++17 evaluation order requirements for assignment expressions, shift, member function calls, etc.",
    NULL,
    NULL,
    "all", "none", OPT_fstrong_eval_order_, N_OPTS, 18, /* .neg_idx = */ 1490,
    CL_CXX | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1491] = */ {
    "-fstrong-eval-order=",
    "Follow the C++17 evaluation order requirements for assignment expressions, shift, member function calls, etc.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_strong_eval_order), 42, CLVC_ENUM, 0, -1, -1 },
 /* [1492] = */ {
    "-fswitch-errors",
    "Generate code for switches without a default case.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1492,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_switch_errors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1493] = */ {
    "-fsync-libcalls",
    "Implement __atomic operations via libcalls to legacy __sync functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1493,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_sync_libcalls), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1494] = */ {
    "-fsyntax-only",
    "Check for syntax errors, then stop.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1494,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_syntax_only), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1495] = */ {
    "-ftabstop=",
    "-ftabstop=<number>      Distance between tab stops for column reporting.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1496] = */ {
    "-ftail-call-workaround",
    NULL,
    NULL,
    NULL,
    "1", "0", OPT_ftail_call_workaround_, N_OPTS, 21, /* .neg_idx = */ 1496,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1497] = */ {
    "-ftail-call-workaround=",
    "Disallow tail call optimization when a calling routine may have omitted character lengths.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tail_call_workaround), 0, CLVC_BOOLEAN, 0, 0, 2 },
 /* [1498] = */ {
    "-ftarget-help",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT__target_help, N_OPTS, 12, /* .neg_idx = */ 1498,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1499] = */ {
    "-ftemplate-backtrace-limit=",
    "Set the maximum number of template instantiation notes for a single warning or error.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_template_backtrace_limit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1500] = */ {
    "-ftemplate-depth-",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_ftemplate_depth_, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1501] = */ {
    "-ftemplate-depth=",
    "-ftemplate-depth=<number>	Specify maximum template instantiation depth.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1502] = */ {
    "-ftest-coverage",
    "Create data files needed by \"gcov\".",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1502,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_test_coverage), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1503] = */ {
    "-ftest-forall-temp",
    "Force creation of temporary to test infrequently-executed forall code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1503,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_test_forall_temp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1504] = */ {
    "-fthis-is-variable",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 17, /* .neg_idx = */ 1504,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1505] = */ {
    "-fthread-jumps",
    "Perform jump threading optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1505,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_thread_jumps), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1506] = */ {
    "-fthreadsafe-statics",
    "-fno-threadsafe-statics	Do not generate thread-safe code for initializing local statics.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1506,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_threadsafe_statics), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1507] = */ {
    "-ftime-report",
    "Report the time taken by each compiler pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1507,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_time_report), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1508] = */ {
    "-ftime-report-details",
    "Record times taken by sub-phases separately.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1508,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_time_report_details), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1509] = */ {
    "-ftls-model=",
    "-ftls-model=[global-dynamic|local-dynamic|initial-exec|local-exec]	Set the default thread-local storage code generation model.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tls_default), 44, CLVC_ENUM, 0, -1, -1 },
 /* [1510] = */ {
    "-ftoplevel-reorder",
    "Reorder top level functions, variables, and asms.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1510,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_toplevel_reorder), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1511] = */ {
    "-ftracer",
    "Perform superblock formation via tail duplication.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1511,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tracer), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1512] = */ {
    "-ftrack-macro-expansion",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1513] = */ {
    "-ftrack-macro-expansion=",
    "-ftrack-macro-expansion=<0|1|2>	Track locations of tokens coming from macro expansion and display them in error messages.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_ftrack_macro_expansion, 23, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 1 /* UInteger */, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1514] = */ {
    "-ftrampolines",
    "For targets that normally need trampolines for nested functions, always generate them instead of using descriptors.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1514,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_trampolines), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1515] = */ {
    "-ftransition=all",
    "List information on all language changes.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1516] = */ {
    "-ftransition=complex",
    "List all usages of complex or imaginary types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1517] = */ {
    "-ftransition=dip1000",
    "Implement DIP1000: Scoped pointers (experimental).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1518] = */ {
    "-ftransition=dip25",
    "Implement DIP25: Sealed references (experimental).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1519] = */ {
    "-ftransition=field",
    "List all non-mutable fields which occupy an object instance.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1520] = */ {
    "-ftransition=nogc",
    "List all hidden GC allocations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1521] = */ {
    "-ftransition=tls",
    "List all variables going into thread local storage.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_D,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1522] = */ {
    "-ftrapping-math",
    "Assume floating-point operations can trap.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1522,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_trapping_math), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1523] = */ {
    "-ftrapv",
    "Trap for signed overflow in addition, subtraction and multiplication.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1523,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_trapv), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1524] = */ {
    "-ftree-bit-ccp",
    "Enable SSA-BIT-CCP optimization on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1524,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_bit_ccp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1525] = */ {
    "-ftree-builtin-call-dce",
    "Enable conditional dead code elimination for builtin calls.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1525,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_builtin_call_dce), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1526] = */ {
    "-ftree-ccp",
    "Enable SSA-CCP optimization on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1526,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_ccp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1527] = */ {
    "-ftree-ch",
    "Enable loop header copying on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1527,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_ch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1528] = */ {
    "-ftree-coalesce-inlined-vars",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1529] = */ {
    "-ftree-coalesce-vars",
    "Enable SSA coalescing of user variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1529,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_coalesce_vars), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1530] = */ {
    "-ftree-copy-prop",
    "Enable copy propagation on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1530,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_copy_prop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1531] = */ {
    "-ftree-copyrename",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 16, /* .neg_idx = */ 1531,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1532] = */ {
    "-ftree-cselim",
    "Transform condition stores into unconditional ones.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1532,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_cselim), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1533] = */ {
    "-ftree-dce",
    "Enable SSA dead code elimination optimization on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1533,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_dce), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1534] = */ {
    "-ftree-dominator-opts",
    "Enable dominator optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1534,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_dom), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1535] = */ {
    "-ftree-dse",
    "Enable dead store elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1535,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_dse), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1536] = */ {
    "-ftree-forwprop",
    "Enable forward propagation on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1536,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_forwprop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1537] = */ {
    "-ftree-fre",
    "Enable Full Redundancy Elimination (FRE) on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1537,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_fre), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1538] = */ {
    "-ftree-loop-distribute-patterns",
    "Enable loop distribution for patterns transformed into a library call.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 30, /* .neg_idx = */ 1538,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_loop_distribute_patterns), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1539] = */ {
    "-ftree-loop-distribution",
    "Enable loop distribution on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1539,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_loop_distribution), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1540] = */ {
    "-ftree-loop-if-convert",
    "Convert conditional jumps in innermost loops to branchless equivalents.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1540,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_loop_if_convert), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1541] = */ {
    "-ftree-loop-if-convert-stores",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 28, /* .neg_idx = */ 1541,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1542] = */ {
    "-ftree-loop-im",
    "Enable loop invariant motion on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1542,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_loop_im), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1543] = */ {
    "-ftree-loop-ivcanon",
    "Create canonical induction variables in loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1543,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_loop_ivcanon), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1544] = */ {
    "-ftree-loop-linear",
    "Enable loop nest transforms.  Same as -floop-nest-optimize.",
    NULL,
    NULL,
    NULL, NULL, OPT_floop_nest_optimize, N_OPTS, 17, /* .neg_idx = */ 1544,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1545] = */ {
    "-ftree-loop-optimize",
    "Enable loop optimizations on tree level.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1545,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_loop_optimize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1546] = */ {
    "-ftree-loop-vectorize",
    "Enable loop vectorization on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1546,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_loop_vectorize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1547] = */ {
    "-ftree-lrs",
    "Perform live range splitting during the SSA->normal pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1547,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_live_range_split), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1548] = */ {
    "-ftree-parallelize-loops=",
    "-ftree-parallelize-loops=<number>	Enable automatic parallelization of loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_parallelize_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1549] = */ {
    "-ftree-partial-pre",
    "In SSA-PRE optimization on trees, enable partial-partial redundancy elimination.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1549,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_partial_pre), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1550] = */ {
    "-ftree-phiprop",
    "Enable hoisting loads from conditional pointers.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1550,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_phiprop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1551] = */ {
    "-ftree-pre",
    "Enable SSA-PRE optimization on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1551,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_pre), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1552] = */ {
    "-ftree-pta",
    "Perform function-local points-to analysis on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1552,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_pta), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1553] = */ {
    "-ftree-reassoc",
    "Enable reassociation on tree level.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1553,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_reassoc), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1554] = */ {
    "-ftree-salias",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 12, /* .neg_idx = */ 1554,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1555] = */ {
    "-ftree-scev-cprop",
    "Enable copy propagation of scalar-evolution information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1555,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_scev_cprop), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1556] = */ {
    "-ftree-sink",
    "Enable SSA code sinking on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1556,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_sink), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1557] = */ {
    "-ftree-slp-vectorize",
    "Enable basic block vectorization (SLP) on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1557,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_slp_vectorize), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1558] = */ {
    "-ftree-slsr",
    "Perform straight-line strength reduction.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1558,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_slsr), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1559] = */ {
    "-ftree-sra",
    "Perform scalar replacement of aggregates.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1559,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_sra), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1560] = */ {
    "-ftree-store-ccp",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, /* .neg_idx = */ 1560,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1561] = */ {
    "-ftree-store-copy-prop",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 21, /* .neg_idx = */ 1561,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1562] = */ {
    "-ftree-switch-conversion",
    "Perform conversions of switch initializations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ 1562,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_switch_conversion), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1563] = */ {
    "-ftree-tail-merge",
    "Enable tail merging on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1563,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_tail_merge), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1564] = */ {
    "-ftree-ter",
    "Replace temporary expressions in the SSA->normal pass.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1564,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_ter), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1565] = */ {
    "-ftree-vect-loop-version",
    "Does nothing. Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 23, /* .neg_idx = */ 1565,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1566] = */ {
    "-ftree-vectorize",
    "Enable vectorization on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1566,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1567] = */ {
    "-ftree-vectorizer-verbose=",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1568] = */ {
    "-ftree-vrp",
    "Perform Value Range Propagation on trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1568,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tree_vrp), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1569] = */ {
    "-funconstrained-commons",
    "Assume common declarations may be overridden with ones with a larger trailing array.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ 1569,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_unconstrained_commons), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1570] = */ {
    "-funderscoring",
    "Append underscores to externally visible names.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1570,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_underscoring), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1571] = */ {
    "-funit-at-a-time",
    "Compile whole compilation unit at a time.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1571,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_unit_at_a_time), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1572] = */ {
    "-funittest",
    "Compile in unittest code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ 1572,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1573] = */ {
    "-funroll-all-loops",
    "Perform loop unrolling for all loops.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1573,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_unroll_all_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1574] = */ {
    "-funroll-completely-grow-size",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ 1574,
    CL_UNDOCUMENTED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_cunroll_grow_size), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1575] = */ {
    "-funroll-loops",
    "Perform loop unrolling when iteration count is known.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1575,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_unroll_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1576] = */ {
    "-funsafe-loop-optimizations",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 26, /* .neg_idx = */ 1576,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1577] = */ {
    "-funsafe-math-optimizations",
    "Allow math optimizations that may violate IEEE or ISO standards.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1577,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_unsafe_math_optimizations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1578] = */ {
    "-funsigned-bitfields",
    "When \"signed\" or \"unsigned\" is not given make the bitfield unsigned.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1578,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_bitfields), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1579] = */ {
    "-funsigned-char",
    "Make \"char\" unsigned by default.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1579,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_char), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1580] = */ {
    "-funswitch-loops",
    "Perform loop unswitching.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1580,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_unswitch_loops), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1581] = */ {
    "-funwind-tables",
    "Just generate unwind tables for exception handling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1581,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_unwind_tables), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1582] = */ {
    "-fuse-cxa-atexit",
    "Use __cxa_atexit to register destructors.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1582,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_cxa_atexit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1583] = */ {
    "-fuse-cxa-get-exception-ptr",
    "Use __cxa_get_exception_ptr in exception handling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1583,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_cxa_get_exception_ptr), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1584] = */ {
    "-fuse-ld=bfd",
    "Use the bfd linker instead of the default linker.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1585,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1585] = */ {
    "-fuse-ld=gold",
    "Use the gold linker instead of the default linker.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1584,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1586] = */ {
    "-fuse-ld=lld",
    "Use the lld LLVM linker instead of the default linker.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1586,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1587] = */ {
    "-fuse-linker-plugin",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1587,
    CL_COMMON | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_linker_plugin), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1588] = */ {
    "-fvar-tracking",
    "Perform variable tracking.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1588,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_var_tracking), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1589] = */ {
    "-fvar-tracking-assignments",
    "Perform variable tracking by annotating assignments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ 1589,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_var_tracking_assignments), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1590] = */ {
    "-fvar-tracking-assignments-toggle",
    "Toggle -fvar-tracking-assignments.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 32, /* .neg_idx = */ 1590,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_var_tracking_assignments_toggle), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1591] = */ {
    "-fvar-tracking-uninit",
    "Perform variable tracking and also tag variables that are uninitialized.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 20, /* .neg_idx = */ 1591,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_var_tracking_uninit), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1592] = */ {
    "-fvariable-expansion-in-unroller",
    "Apply variable expansion when loops are unrolled.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 31, /* .neg_idx = */ 1592,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_variable_expansion_in_unroller), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1593] = */ {
    "-fvect-cost-model",
    "Enables the dynamic vectorizer cost model.  Preserved for backward compatibility.",
    NULL,
    NULL,
    "dynamic", "unlimited", OPT_fvect_cost_model_, N_OPTS, 16, /* .neg_idx = */ 1593,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1594] = */ {
    "-fvect-cost-model=",
    "-fvect-cost-model=[unlimited|dynamic|cheap|very-cheap]	Specifies the cost model for vectorization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_vect_cost_model), 46, CLVC_ENUM, 0, -1, -1 },
 /* [1595] = */ {
    "-fverbose-asm",
    "Add extra commentary to assembler output.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1595,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_verbose_asm), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1596] = */ {
    "-fversion",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT__version, N_OPTS, 8, /* .neg_idx = */ 1596,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1597] = */ {
    "-fversion-loops-for-strides",
    "Version loops based on whether indices have a stride of one.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1597,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_version_loops_for_strides), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1598] = */ {
    "-fversion=",
    "-fversion=<level|ident>	Compile in version code >= <level> or identified by <ident>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_D | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1599] = */ {
    "-fvisibility-inlines-hidden",
    "Marks all inlined functions and methods as having hidden visibility.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1599,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1600] = */ {
    "-fvisibility-ms-compat",
    "Changes visibility to match Microsoft Visual Studio by default.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ 1600,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_visibility_ms_compat), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1601] = */ {
    "-fvisibility=",
    "-fvisibility=[default|internal|hidden|protected]	Set the default symbol visibility.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_default_visibility), 43, CLVC_ENUM, 0, -1, -1 },
 /* [1602] = */ {
    "-fvpt",
    "Use expression value profiles in optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1602,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_value_profile_transformations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1603] = */ {
    "-fvtable-gc",
    "No longer supported.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 10, /* .neg_idx = */ 1603,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1604] = */ {
    "-fvtable-thunks",
    "No longer supported.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 14, /* .neg_idx = */ 1604,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1605] = */ {
    "-fvtable-verify=",
    "Validate vtable pointers before using them.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_vtable_verify), 47, CLVC_ENUM, 0, -1, -1 },
 /* [1606] = */ {
    "-fvtv-counts",
    "Output vtable verification counters.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1606,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_vtv_counts), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1607] = */ {
    "-fvtv-debug",
    "Output vtable verification pointer sets information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1607,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_vtv_debug), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1608] = */ {
    "-fweak",
    "Emit common-like symbols as weak symbols.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 1608,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_weak), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1609] = */ {
    "-fweak-templates",
    "Emit template instantiations as weak symbols.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1609,
    CL_D,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_weak_templates), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1610] = */ {
    "-fweb",
    "Construct webs and split unrelated uses of single variable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1610,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_web), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1611] = */ {
    "-fwhole-file",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 11, /* .neg_idx = */ 1611,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1612] = */ {
    "-fwhole-program",
    "Perform whole program optimizations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1612,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_whole_program), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1613] = */ {
    "-fwide-exec-charset=",
    "-fwide-exec-charset=<cset>	Convert all wide strings and character constants to character set <cset>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1614] = */ {
    "-fworking-directory",
    "Generate a #line directive pointing at the current working directory.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1614,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_working_directory), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1615] = */ {
    "-fwpa",
    "Run the link-time optimizer in whole program analysis (WPA) mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1615,
    CL_LTO | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1616] = */ {
    "-fwpa=",
    "Whole program analysis (WPA) mode with number of parallel jobs specified.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_LTO | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_wpa), 0, CLVC_STRING, 0, -1, -1 },
 /* [1617] = */ {
    "-fwrapv",
    "Assume signed arithmetic overflow wraps around.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1617,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_wrapv), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1618] = */ {
    "-fwrapv-pointer",
    "Assume pointer overflow wraps around.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1618,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_wrapv_pointer), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1619] = */ {
    "-fxref",
    "No longer supported.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 5, /* .neg_idx = */ 1619,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1620] = */ {
    "-fzee",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 4, /* .neg_idx = */ 1620,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1621] = */ {
    "-fzero-call-used-regs=",
    "Clear call-used registers upon function return.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1622] = */ {
    "-fzero-initialized-in-bss",
    "Put zero initialized data in the bss section.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 1622,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_zero_initialized_in_bss), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1623] = */ {
    "-fzero-link",
    "Generate lazy class lookup (via objc_getClass()) for use in Zero-Link mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1623,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_zero_link), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1624] = */ {
    "-g",
    "Generate debug information in default format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1625] = */ {
    "-gant",
    "Catch typos.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 4, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_DRIVER | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1626] = */ {
    "-gas-loc-support",
    "Assume assembler support for (DWARF2+) .loc directives.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 15, /* .neg_idx = */ 1626,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf2out_as_loc_support), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1627] = */ {
    "-gas-locview-support",
    "Assume assembler support for view in (DWARF2+) .loc directives.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 19, /* .neg_idx = */ 1627,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf2out_as_locview_support), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1628] = */ {
    "-gcoff",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, OPT_g, 5, /* .neg_idx = */ 1628,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1629] = */ {
    "-gcoff1",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, OPT_g, 6, /* .neg_idx = */ 1629,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1630] = */ {
    "-gcoff2",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, OPT_g, 6, /* .neg_idx = */ 1630,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1631] = */ {
    "-gcoff3",
    "Does nothing.  Preserved for backward compatibility.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, OPT_g, 6, /* .neg_idx = */ 1631,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1632] = */ {
    "-gcolumn-info",
    "Record DW_AT_decl_column and DW_AT_call_column in DWARF.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 12, /* .neg_idx = */ 1632,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_column_info), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1633] = */ {
    "-gdescribe-dies",
    "Add description attributes to some DWARF DIEs that have no name attribute.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 14, /* .neg_idx = */ 1633,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_describe_dies), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1634] = */ {
    "-gdwarf",
    "Generate debug information in default version of DWARF format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 6, /* .neg_idx = */ 1635,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1635] = */ {
    "-gdwarf-",
    "Generate debug information in DWARF v2 (or later) format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_gdwarf, 7, /* .neg_idx = */ 1651,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_version), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1636] = */ {
    "-gdwarf32",
    "Use 32-bit DWARF format when emitting DWARF debug information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_gdwarf, 8, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_offset_size), 0, CLVC_EQUAL, 4, -1, -1 },
 /* [1637] = */ {
    "-gdwarf64",
    "Use 64-bit DWARF format when emitting DWARF debug information.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_gdwarf, 8, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_offset_size), 0, CLVC_EQUAL, 8, -1, -1 },
 /* [1638] = */ {
    "-gen-decls",
    "Dump declarations to a .decl file.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 9, /* .neg_idx = */ -1,
    CL_ObjC | CL_ObjCXX | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gen_declaration), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1639] = */ {
    "-ggdb",
    "Generate debug information in default extended format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 4, /* .neg_idx = */ 1639,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1640] = */ {
    "-ggnu-pubnames",
    "Generate DWARF pubnames and pubtypes sections with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 13, /* .neg_idx = */ 1647,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_generate_pub_sections), 0, CLVC_EQUAL, 2, -1, -1 },
 /* [1641] = */ {
    "-gimple-stats",
    "Dump the statistics of gimple statements.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 12, /* .neg_idx = */ 1641,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_gimple_stats), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1642] = */ {
    "-ginline-points",
    "Generate extended entry point information for inlined functions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 14, /* .neg_idx = */ 1642,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_inline_points), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1643] = */ {
    "-ginternal-reset-location-views",
    "Compute locview reset points based on insn length estimates.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 30, /* .neg_idx = */ 1643,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_internal_reset_location_views), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1644] = */ {
    "-gnat",
    "-gnat<options>	Specify options to GNAT.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 4, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1645] = */ {
    "-gnatO",
    "Set name of output ALI file (internal switch).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_gnat, 5, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1646] = */ {
    "-gno-",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 4, /* .neg_idx = */ -1,
    CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1647] = */ {
    "-gno-pubnames",
    "Don't generate DWARF pubnames and pubtypes sections.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_gno_, 12, /* .neg_idx = */ 1648,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_generate_pub_sections), 0, CLVC_EQUAL, 0, -1, -1 },
 /* [1648] = */ {
    "-gpubnames",
    "Generate DWARF pubnames and pubtypes sections.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 9, /* .neg_idx = */ 1640,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_generate_pub_sections), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1649] = */ {
    "-grecord-gcc-switches",
    "Record gcc command line switches in DWARF DW_AT_producer.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 20, /* .neg_idx = */ 1649,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_record_gcc_switches), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1650] = */ {
    "-gsplit-dwarf",
    "Generate debug information in separate .dwo files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 12, /* .neg_idx = */ 1650,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_split_debug_info), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1651] = */ {
    "-gstabs",
    "Generate debug information in STABS format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 6, /* .neg_idx = */ 1652,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1652] = */ {
    "-gstabs+",
    "Generate debug information in extended STABS format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_gstabs, 7, /* .neg_idx = */ 1658,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1653] = */ {
    "-gstatement-frontiers",
    "Emit progressive recommended breakpoint locations.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 20, /* .neg_idx = */ 1653,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_nonbind_markers_p), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1654] = */ {
    "-gstrict-dwarf",
    "Don't emit DWARF additions beyond selected version.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 13, /* .neg_idx = */ 1654,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_strict), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1655] = */ {
    "-gtoggle",
    "Toggle debug information generation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 7, /* .neg_idx = */ 1655,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gtoggle), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1656] = */ {
    "-gvariable-location-views",
    "Augment variable location lists with progressive views.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 24, /* .neg_idx = */ 1656,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_variable_location_views), 0, CLVC_EQUAL, 1, -1, -1 },
 /* [1657] = */ {
    "-gvariable-location-views=incompat5",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 34, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_variable_location_views), 0, CLVC_EQUAL, -1, -1, -1 },
 /* [1658] = */ {
    "-gvms",
    "Generate debug information in VMS format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 4, /* .neg_idx = */ 1659,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1659] = */ {
    "-gxcoff",
    "Generate debug information in XCOFF format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 6, /* .neg_idx = */ 1660,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1660] = */ {
    "-gxcoff+",
    "Generate debug information in extended XCOFF format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_gxcoff, 7, /* .neg_idx = */ 1634,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1661] = */ {
    "-gz",
    "Generate compressed debug sections.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 2, /* .neg_idx = */ 1661,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1662] = */ {
    "-gz=",
    "-gz=<format>	Generate compressed debug sections in format <format>.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_g, 3, /* .neg_idx = */ -1,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 7, CLVC_ENUM, 0, -1, -1 },
 /* [1663] = */ {
    "-h",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1664] = */ {
    "-help",
    "Dump the dump tool command line options.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_h, 4, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_dump_tool_help), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1665] = */ {
    "-idirafter",
    "-idirafter <dir>	Add <dir> to the end of the system include path.",
    "missing path after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1666] = */ {
    "-imacros",
    "-imacros <file>	Accept definition of macros in <file>.",
    "missing filename after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1667] = */ {
    "-imultiarch",
    "-imultiarch <dir>	Set <dir> to be the multiarch include subdirectory.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_imultiarch), 0, CLVC_STRING, 0, -1, -1 },
 /* [1668] = */ {
    "-imultilib",
    "-imultilib <dir>	Set <dir> to be the multilib include subdirectory.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1669] = */ {
    "-include",
    "-include <file>	Include the contents of <file> before other files.",
    "missing filename after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1670] = */ {
    "-iplugindir=",
    "-iplugindir=<dir>	Set <dir> to be the default plugin directory.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_plugindir_string), 0, CLVC_STRING, 0, -1, -1 },
 /* [1671] = */ {
    "-iprefix",
    "-iprefix <path>	Specify <path> as a prefix for next two options.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1672] = */ {
    "-iquote",
    "-iquote <dir>	Add <dir> to the end of the quote include path.",
    "missing path after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1673] = */ {
    "-isysroot",
    "-isysroot <dir>	Set <dir> to be the system root directory.",
    "missing path after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1674] = */ {
    "-isystem",
    "-isystem <dir>	Add <dir> to the start of the system include path.",
    "missing path after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1675] = */ {
    "-iwithprefix",
    "-iwithprefix <dir>	Add <dir> to the end of the system include path.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1676] = */ {
    "-iwithprefixbefore",
    "-iwithprefixbefore <dir>	Add <dir> to the end of the main include path.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_iwithprefix, 17, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1677] = */ {
    "-k8",
    "Synonym of -gnatk8.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1678] = */ {
    "-l",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1679] = */ {
    "-lang-asm",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_l, 8, /* .neg_idx = */ -1,
    CL_C | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1680] = */ {
    "-list",
    "Call the dump function for variables and function in IL.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_l, 4, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_dump_list), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1681] = */ {
    "-mabi=",
    "Specify an ABI.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_abi), 0, CLVC_ENUM, 0, -1, -1 },
 /* [1682] = */ {
    "-mabort-on-noreturn",
    "Generate a call to abort if a noreturn function returns.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1682,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_ABORT_NORETURN, -1, -1 },
 /* [1683] = */ {
    "-mandroid",
    "Generate code for the Android platform.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ 1683,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_android), 0, CLVC_BIT_SET, OPTION_MASK_ANDROID, -1, -1 },
 /* [1684] = */ {
    "-mapcs",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_APCS_FRAME, -1, -1 },
 /* [1685] = */ {
    "-mapcs-frame",
    "Generate APCS conformant stack frames.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1685,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_APCS_FRAME, -1, -1 },
 /* [1686] = */ {
    "-mapcs-reentrant",
    "Generate re-entrant, PIC code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ 1686,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_APCS_REENT, -1, -1 },
 /* [1687] = */ {
    "-mapcs-stack-check",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1687,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_APCS_STACK, -1, -1 },
 /* [1688] = */ {
    "-march=",
    "Specify the name of the target architecture.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1688,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 1 /* ToLower */, 0,
    offsetof (struct gcc_options, x_arm_arch_string), 0, CLVC_STRING, 0, -1, -1 },
 /* [1689] = */ {
    "-marm",
    "Generate code in 32 bit ARM state.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1726,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_THUMB, -1, -1 },
 /* [1690] = */ {
    "-masm-syntax-unified",
    "Assume unified syntax for inline assembly code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1690,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_inline_asm_unified), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1691] = */ {
    "-mbe32",
    "When linking for big-endian targets, generate a legacy BE32 format image.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 1692,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_BE8, -1, -1 },
 /* [1692] = */ {
    "-mbe8",
    "When linking for big-endian targets, generate a BE8 format image.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ 1691,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_BE8, -1, -1 },
 /* [1693] = */ {
    "-mbig-endian",
    "Assume target CPU is configured as big endian.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1711,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_BIG_END, -1, -1 },
 /* [1694] = */ {
    "-mbionic",
    "Use Bionic C library.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1708,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_linux_libc), 0, CLVC_EQUAL, LIBC_BIONIC, -1, -1 },
 /* [1695] = */ {
    "-mbranch-cost=",
    "Cost to assume for a branch insn.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_branch_cost), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1696] = */ {
    "-mcallee-super-interworking",
    "Thumb: Assume non-static functions may be called from ARM code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1696,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_CALLEE_INTERWORKING, -1, -1 },
 /* [1697] = */ {
    "-mcaller-super-interworking",
    "Thumb: Assume function pointers may go to non-Thumb aware code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1697,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_CALLER_INTERWORKING, -1, -1 },
 /* [1698] = */ {
    "-mcmse",
    "Specify that the compiler should target secure code as per ARMv8-M Security Extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_use_cmse), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1699] = */ {
    "-mcpu=",
    "Specify the name of the target CPU.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 1699,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 1 /* ToLower */, 0,
    offsetof (struct gcc_options, x_arm_cpu_string), 0, CLVC_STRING, 0, -1, -1 },
 /* [1700] = */ {
    "-mfdpic",
    "Enable Function Descriptor PIC mode.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1700,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_FDPIC, -1, -1 },
 /* [1701] = */ {
    "-mfix-cmse-cve-2021-35465",
    "Mitigate issues with VLLDM on some M-profile devices (CVE-2021-35465).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ 1701,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_fix_vlldm), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1702] = */ {
    "-mfix-cortex-m3-ldrd",
    "Avoid overlapping destination and address registers on LDRD instructions that may trigger Cortex-M3 errata.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1702,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_fix_cm3_ldrd), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1703] = */ {
    "-mflip-thumb",
    "Switch ARM/Thumb modes on alternating functions for compiler testing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1703,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_TARGET_FLIP_THUMB), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1704] = */ {
    "-mfloat-abi=",
    "Specify if floating point hardware should be used.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_float_abi), 20, CLVC_ENUM, 0, -1, -1 },
 /* [1705] = */ {
    "-mfp16-format=",
    "Specify the __fp16 floating-point format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_fp16_format), 2, CLVC_ENUM, 0, -1, -1 },
 /* [1706] = */ {
    "-mfpu=",
    "Specify the name of the target floating point hardware/format.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_fpu_index), 3, CLVC_ENUM, 0, -1, -1 },
 /* [1707] = */ {
    "-mgeneral-regs-only",
    "Generate code which uses the core registers only (r0-r14).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_GENERAL_REGS_ONLY, -1, -1 },
 /* [1708] = */ {
    "-mglibc",
    "Use GNU C library.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1733,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_linux_libc), 0, CLVC_EQUAL, LIBC_GLIBC, -1, -1 },
 /* [1709] = */ {
    "-mhard-float",
    NULL,
    NULL,
    NULL,
    "hard", NULL, OPT_mfloat_abi_, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1710] = */ {
    "-mlibarch=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED | CL_UNDOCUMENTED | CL_NO_DWARF_RECORD,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_VAR_mlibarch_), 0, CLVC_STRING, 0, -1, -1 },
 /* [1711] = */ {
    "-mlittle-endian",
    "Assume target CPU is configured as little endian.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ 1693,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_BIG_END, -1, -1 },
 /* [1712] = */ {
    "-mlong-calls",
    "Generate call insns as indirect calls, if necessary.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1712,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_LONG_CALLS, -1, -1 },
 /* [1713] = */ {
    "-mmusl",
    "Use musl C library.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 1694,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_linux_libc), 0, CLVC_EQUAL, LIBC_MUSL, -1, -1 },
 /* [1714] = */ {
    "-mneon-for-64bits",
    "This option is deprecated and has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 16, /* .neg_idx = */ 1714,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_VAR_mneon_for_64bits), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1715] = */ {
    "-mpic-data-is-text-relative",
    "Assume data segments are relative to text segment.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 26, /* .neg_idx = */ 1715,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_pic_data_is_text_relative), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1716] = */ {
    "-mpic-register=",
    "Specify the register to be used for PIC addressing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_pic_register_string), 0, CLVC_STRING, 0, -1, -1 },
 /* [1717] = */ {
    "-mpoke-function-name",
    "Store function names in object code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 19, /* .neg_idx = */ 1717,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_POKE_FUNCTION_NAME, -1, -1 },
 /* [1718] = */ {
    "-mprint-tune-info",
    "Print CPU tuning information as comment in assembler file.  This is an option used only for regression testing of the compiler and not intended for ordinary use in compiling code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_tune_info), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1719] = */ {
    "-mpure-code",
    "Do not allow constant data to be placed in code sections.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1719,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_pure_code), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1720] = */ {
    "-mrestrict-it",
    "Generate IT blocks appropriate for ARMv8.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ 1720,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_restrict_it), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1721] = */ {
    "-msched-prolog",
    "Permit scheduling of a function's prologue sequence.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ 1721,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_SCHED_PROLOG, -1, -1 },
 /* [1722] = */ {
    "-msingle-pic-base",
    "Do not load the PIC register in function prologues.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1722,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_SINGLE_PIC_BASE, -1, -1 },
 /* [1723] = */ {
    "-mslow-flash-data",
    "Assume loading data from flash is slower than fetching instructions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1723,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_slow_flash_data), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1724] = */ {
    "-msoft-float",
    NULL,
    NULL,
    NULL,
    "soft", NULL, OPT_mfloat_abi_, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1725] = */ {
    "-mstructure-size-boundary=",
    "Specify the minimum bit alignment of structures. (Deprecated).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_structure_size_boundary), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1726] = */ {
    "-mthumb",
    "Generate code for Thumb state.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1689,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_THUMB, -1, -1 },
 /* [1727] = */ {
    "-mthumb-interwork",
    "Support calls between Thumb and ARM instruction sets.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1727,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_INTERWORK, -1, -1 },
 /* [1728] = */ {
    "-mtls-dialect=",
    "Specify thread local storage scheme.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_tls_dialect), 45, CLVC_ENUM, 0, -1, -1 },
 /* [1729] = */ {
    "-mtp=",
    "Specify how to access the thread pointer.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_thread_pointer), 4, CLVC_ENUM, 0, -1, -1 },
 /* [1730] = */ {
    "-mtpcs-frame",
    "Thumb: Generate (non-leaf) stack frames even if not needed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ 1730,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_TPCS_FRAME, -1, -1 },
 /* [1731] = */ {
    "-mtpcs-leaf-frame",
    "Thumb: Generate (leaf) stack frames even if not needed.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ 1731,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_TPCS_LEAF_FRAME, -1, -1 },
 /* [1732] = */ {
    "-mtune=",
    "Tune code for the given processor.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1732,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 1 /* ToLower */, 0,
    offsetof (struct gcc_options, x_arm_tune_string), 0, CLVC_STRING, 0, -1, -1 },
 /* [1733] = */ {
    "-muclibc",
    "Use uClibc C library.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ 1713,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_linux_libc), 0, CLVC_EQUAL, LIBC_UCLIBC, -1, -1 },
 /* [1734] = */ {
    "-munaligned-access",
    "Enable unaligned word and halfword accesses to packed data.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1734,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_unaligned_access), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1735] = */ {
    "-mvectorize-with-neon-double",
    "Use Neon double-word (rather than quad-word) registers for vectorization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 27, /* .neg_idx = */ -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_NEON_VECTORIZE_DOUBLE, -1, -1 },
 /* [1736] = */ {
    "-mvectorize-with-neon-quad",
    "Use Neon quad-word (rather than double-word) registers for vectorization.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 25, /* .neg_idx = */ -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_NEON_VECTORIZE_DOUBLE, -1, -1 },
 /* [1737] = */ {
    "-mverbose-cost-dump",
    "Enable more verbose RTX cost dumps during debug.  For GCC developers use only.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ 1737,
    CL_COMMON | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_arm_verbose_cost), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1738] = */ {
    "-mword-relocations",
    "Only generate absolute relocations on word sized values.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ 1738,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_word_relocations), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1739] = */ {
    "-n",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1740] = */ {
    "-name-sort",
    "Sort the symbols alphabetically.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_name_sort), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1741] = */ {
    "-no-canonical-prefixes",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1742] = */ {
    "-no-integrated-cpp",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1743] = */ {
    "-no-pie",
    "Don't create a dynamically linked position independent executable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1784,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1744] = */ {
    "-nocpp",
    "Disable preprocessing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ 811,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1745] = */ {
    "-nodefaultlibs",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1746] = */ {
    "-nolibc",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1747] = */ {
    "-nophoboslib",
    "Do not link the standard D library in the compilation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1748] = */ {
    "-nostartfiles",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1749] = */ {
    "-nostdinc",
    "Do not search standard system include directories (those specified with -isystem will still be used).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1750] = */ {
    "-nostdinc++",
    "Do not search standard system include directories for C++.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1751] = */ {
    "-nostdlib",
    "Do not look for object files in standard path.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1752] = */ {
    "-o",
    "-o <file>	Place output into <file>.",
    "missing filename after %qs",
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_Go | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_asm_file_name), 0, CLVC_STRING, 0, -1, -1 },
 /* [1753] = */ {
    "-objects",
    "Dump the details of LTO objects.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_o, 7, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_dump_objects), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1754] = */ {
    "-p",
    "Enable function profiling.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_flag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1755] = */ {
    "-pass-exit-codes",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_pass_exit_codes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1756] = */ {
    "-pedantic",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_Wpedantic, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1757] = */ {
    "-pedantic-errors",
    "Like -pedantic but issue them as errors.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pedantic_errors), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1758] = */ {
    "-pg",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 2, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1759] = */ {
    "-pie",
    "Create a dynamically linked position independent executable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 3, /* .neg_idx = */ 1743,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1760] = */ {
    "-pipe",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_use_pipes), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1761] = */ {
    "-posix",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1762] = */ {
    "-print-file-name=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_file_name), 0, CLVC_STRING, 0, -1, -1 },
 /* [1763] = */ {
    "-print-libgcc-file-name",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 22, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1764] = */ {
    "-print-multi-directory",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_multi_directory), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1765] = */ {
    "-print-multi-lib",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_multi_lib), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1766] = */ {
    "-print-multi-os-directory",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 24, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_multi_os_directory), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1767] = */ {
    "-print-multiarch",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_multiarch), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1768] = */ {
    "-print-objc-runtime-info",
    "Generate C header of platform-specific features.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 23, /* .neg_idx = */ -1,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1769] = */ {
    "-print-prog-name=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_prog_name), 0, CLVC_STRING, 0, -1, -1 },
 /* [1770] = */ {
    "-print-search-dirs",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 17, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_search_dirs), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1771] = */ {
    "-print-sysroot",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_sysroot), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1772] = */ {
    "-print-sysroot-headers-suffix",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 28, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_sysroot_headers_suffix), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1773] = */ {
    "-print-value",
    "Print the initial values of the variables.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_print_value), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1774] = */ {
    "-profile",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1775] = */ {
    "-pthread",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1776] = */ {
    "-quiet",
    "Do not display functions compiled or elapsed time.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_quiet_flag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1777] = */ {
    "-r",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1778] = */ {
    "-rdynamic",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1779] = */ {
    "-remap",
    "Remap file names when including files.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1780] = */ {
    "-reverse-sort",
    "Display the symbols in reverse order.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_reverse_sort), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1781] = */ {
    "-s",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1782] = */ {
    "-save-temps",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1783] = */ {
    "-save-temps=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1784] = */ {
    "-shared",
    "Create a shared library.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ 1803,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1785] = */ {
    "-shared-libgcc",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1786] = */ {
    "-shared-libphobos",
    "Link the standard D library dynamically in the compilation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1787] = */ {
    "-size-sort",
    "Sort the symbols according to size.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_size_sort), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1788] = */ {
    "-specs",
    NULL,
    NULL,
    NULL,
    NULL, NULL, OPT_specs_, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1789] = */ {
    "-specs=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1790] = */ {
    "-static",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 6, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1791] = */ {
    "-static-libasan",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1792] = */ {
    "-static-libgcc",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1793] = */ {
    "-static-libgfortran",
    "Statically link the GNU Fortran helper library (libgfortran).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_Fortran | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1794] = */ {
    "-static-libgo",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 12, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1795] = */ {
    "-static-libhwasan",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1796] = */ {
    "-static-liblsan",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1797] = */ {
    "-static-libmpx",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 13, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1798] = */ {
    "-static-libmpxwrappers",
    "Removed in GCC 9.  This switch has no effect.",
    NULL,
    NULL,
    NULL, NULL, OPT_SPECIAL_warn_removed, N_OPTS, 21, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1799] = */ {
    "-static-libphobos",
    "Link the standard D library statically in the compilation.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1800] = */ {
    "-static-libstdc++",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1801] = */ {
    "-static-libtsan",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1802] = */ {
    "-static-libubsan",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1803] = */ {
    "-static-pie",
    "Create a static position independent executable.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ 1759,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1804] = */ {
    "-std=c++03",
    "Conform to the ISO 1998 C++ standard revised by the 2003 technical corrigendum.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c__98, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1805] = */ {
    "-std=c++0x",
    "Deprecated in favor of -std=c++11.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c__11, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1806] = */ {
    "-std=c++11",
    "Conform to the ISO 2011 C++ standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1807] = */ {
    "-std=c++14",
    "Conform to the ISO 2014 C++ standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1808] = */ {
    "-std=c++17",
    "Conform to the ISO 2017 C++ standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1809] = */ {
    "-std=c++1y",
    "Deprecated in favor of -std=c++14.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c__14, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1810] = */ {
    "-std=c++1z",
    "Deprecated in favor of -std=c++17.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c__17, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1811] = */ {
    "-std=c++20",
    "Conform to the ISO 2020 C++ standard (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1812] = */ {
    "-std=c++23",
    "Conform to the ISO 2023 C++ draft standard (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1813] = */ {
    "-std=c++2a",
    "Conform to the ISO 2020 C++ standard (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c__20, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1814] = */ {
    "-std=c++2b",
    "Conform to the ISO 2023 C++ draft standard (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c__23, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1815] = */ {
    "-std=c++98",
    "Conform to the ISO 1998 C++ standard revised by the 2003 technical corrigendum.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1816] = */ {
    "-std=c11",
    "Conform to the ISO 2011 C standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1817] = */ {
    "-std=c17",
    "Conform to the ISO 2017 C standard (published in 2018).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1818] = */ {
    "-std=c18",
    "Conform to the ISO 2017 C standard (published in 2018).",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c17, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1819] = */ {
    "-std=c1x",
    "Deprecated in favor of -std=c11.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c11, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1820] = */ {
    "-std=c2x",
    "Conform to the ISO 202X C standard draft (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1821] = */ {
    "-std=c89",
    "Conform to the ISO 1990 C standard.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c90, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1822] = */ {
    "-std=c90",
    "Conform to the ISO 1990 C standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1823] = */ {
    "-std=c99",
    "Conform to the ISO 1999 C standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1824] = */ {
    "-std=c9x",
    "Deprecated in favor of -std=c99.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c99, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1825] = */ {
    "-std=f2003",
    "Conform to the ISO Fortran 2003 standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1826] = */ {
    "-std=f2008",
    "Conform to the ISO Fortran 2008 standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1827] = */ {
    "-std=f2008ts",
    "Conform to the ISO Fortran 2008 standard including TS 29113.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1828] = */ {
    "-std=f2018",
    "Conform to the ISO Fortran 2018 standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1829] = */ {
    "-std=f95",
    "Conform to the ISO Fortran 95 standard.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1830] = */ {
    "-std=gnu",
    "Conform to nothing in particular.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1831] = */ {
    "-std=gnu++03",
    "Conform to the ISO 1998 C++ standard revised by the 2003 technical corrigendum with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu__98, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1832] = */ {
    "-std=gnu++0x",
    "Deprecated in favor of -std=gnu++11.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu__11, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1833] = */ {
    "-std=gnu++11",
    "Conform to the ISO 2011 C++ standard with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1834] = */ {
    "-std=gnu++14",
    "Conform to the ISO 2014 C++ standard with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1835] = */ {
    "-std=gnu++17",
    "Conform to the ISO 2017 C++ standard with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1836] = */ {
    "-std=gnu++1y",
    "Deprecated in favor of -std=gnu++14.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu__14, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1837] = */ {
    "-std=gnu++1z",
    "Deprecated in favor of -std=gnu++17.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu__17, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1838] = */ {
    "-std=gnu++20",
    "Conform to the ISO 2020 C++ standard with GNU extensions (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1839] = */ {
    "-std=gnu++23",
    "Conform to the ISO 2023 C++ draft standard with GNU extensions (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1840] = */ {
    "-std=gnu++2a",
    "Conform to the ISO 2020 C++ standard with GNU extensions (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu__20, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1841] = */ {
    "-std=gnu++2b",
    "Conform to the ISO 2023 C++ draft standard with GNU extensions (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu__23, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1842] = */ {
    "-std=gnu++98",
    "Conform to the ISO 1998 C++ standard revised by the 2003 technical corrigendum with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1843] = */ {
    "-std=gnu11",
    "Conform to the ISO 2011 C standard with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1844] = */ {
    "-std=gnu17",
    "Conform to the ISO 2017 C standard (published in 2018) with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1845] = */ {
    "-std=gnu18",
    "Conform to the ISO 2017 C standard (published in 2018) with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu17, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1846] = */ {
    "-std=gnu1x",
    "Deprecated in favor of -std=gnu11.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu11, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1847] = */ {
    "-std=gnu2x",
    "Conform to the ISO 202X C standard draft with GNU extensions (experimental and incomplete support).",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1848] = */ {
    "-std=gnu89",
    "Conform to the ISO 1990 C standard with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu90, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1849] = */ {
    "-std=gnu90",
    "Conform to the ISO 1990 C standard with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1850] = */ {
    "-std=gnu99",
    "Conform to the ISO 1999 C standard with GNU extensions.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1851] = */ {
    "-std=gnu9x",
    "Deprecated in favor of -std=gnu99.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_gnu99, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1852] = */ {
    "-std=iso9899:1990",
    "Conform to the ISO 1990 C standard.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c90, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1853] = */ {
    "-std=iso9899:199409",
    "Conform to the ISO 1990 C standard as amended in 1994.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 18, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1854] = */ {
    "-std=iso9899:1999",
    "Conform to the ISO 1999 C standard.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c99, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1855] = */ {
    "-std=iso9899:199x",
    "Deprecated in favor of -std=iso9899:1999.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c99, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1856] = */ {
    "-std=iso9899:2011",
    "Conform to the ISO 2011 C standard.",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c11, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1857] = */ {
    "-std=iso9899:2017",
    "Conform to the ISO 2017 C standard (published in 2018).",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c17, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1858] = */ {
    "-std=iso9899:2018",
    "Conform to the ISO 2017 C standard (published in 2018).",
    NULL,
    NULL,
    NULL, NULL, OPT_std_c17, N_OPTS, 16, /* .neg_idx = */ -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1859] = */ {
    "-std=legacy",
    "Accept extensions to support legacy code.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1860] = */ {
    "-stdlib=",
    "-stdlib=[libstdc++|libc++]	The standard library to be used for C++ headers and runtime.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
#if ENABLE_STDLIB_OPTION
    CL_CXX | CL_ObjCXX | CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
#else
    0,
    1 /* Disabled.  */, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
    offsetof (struct gcc_options, x_flag_stdlib_kind), 41, CLVC_ENUM, 0, -1, -1 },
 /* [1861] = */ {
    "-symbol=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_LTODump | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_dump_symbol), 0, CLVC_STRING, 0, -1, -1 },
 /* [1862] = */ {
    "-symbolic",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 8, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1863] = */ {
    "-t",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1864] = */ {
    "-time",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 4, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_report_times), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1865] = */ {
    "-time=",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 5, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1866] = */ {
    "-tno-android-cc",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1867] = */ {
    "-tno-android-ld",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 14, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1868] = */ {
    "-traditional",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 11, /* .neg_idx = */ -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1869] = */ {
    "-traditional-cpp",
    "Enable traditional preprocessing.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 15, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1870] = */ {
    "-tree-stats",
    "Dump the statistics of trees.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_tree_stats), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1871] = */ {
    "-trigraphs",
    "-trigraphs	Support ISO C trigraphs.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 9, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1872] = */ {
    "-type-stats",
    "Dump the statistics of tree types.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 10, /* .neg_idx = */ -1,
    CL_LTODump,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_dump_type_stats), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1873] = */ {
    "-u",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1874] = */ {
    "-undef",
    "Do not predefine system-specific and GCC-specific macros.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, OPT_u, 5, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_undef), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1875] = */ {
    "-v",
    "Enable verbose output.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_D | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_verbose_flag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1876] = */ {
    "-version",
    "Display the compiler's version.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_version_flag), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1877] = */ {
    "-w",
    "Suppress warnings.",
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_inhibit_warnings), 0, CLVC_BOOLEAN, 0, -1, -1 },
 /* [1878] = */ {
    "-wrapper",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 7, /* .neg_idx = */ -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_wrapper_string), 0, CLVC_STRING, 0, -1, -1 },
 /* [1879] = */ {
    "-x",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 },
 /* [1880] = */ {
    "-z",
    NULL,
    NULL,
    NULL,
    NULL, NULL, N_OPTS, N_OPTS, 1, /* .neg_idx = */ -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    (unsigned short) -1, 0, CLVC_STRING, 0, -1, -1 }
};



bool                                                                  
common_handle_option_auto (struct gcc_options *opts,                  
                           struct gcc_options *opts_set,              
                           const struct cl_decoded_option *decoded,   
                           unsigned int lang_mask, int kind,          
                           location_t loc,                            
                           const struct cl_option_handlers *handlers, 
                           diagnostic_context *dc)                    
{                                                                     
  size_t scode = decoded->opt_index;                                  
  HOST_WIDE_INT value = decoded->value;                               
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  gcc_assert (decoded->canonical_option_num_elements <= 2);           
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wextra:
      if (!opts_set->x_warn_absolute_value)
        handle_generated_option (opts, opts_set,
                                 OPT_Wabsolute_value, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cast_function_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcast_function_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_clobbered)
        handle_generated_option (opts, opts_set,
                                 OPT_Wclobbered, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_empty_body)
        handle_generated_option (opts, opts_set,
                                 OPT_Wempty_body, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_expansion_to_defined)
        handle_generated_option (opts, opts_set,
                                 OPT_Wexpansion_to_defined, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_ignored_qualifiers)
        handle_generated_option (opts, opts_set,
                                 OPT_Wignored_qualifiers, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_missing_field_initializers)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_field_initializers, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_missing_parameter_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_parameter_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_old_style_declaration)
        handle_generated_option (opts, opts_set,
                                 OPT_Wold_style_declaration, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_override_init)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverride_init, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sign_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sized_deallocation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsized_deallocation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_type_limits)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtype_limits, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_but_set_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_but_set_parameter, NULL, (opts->x_warn_unused && opts->x_extra_warnings),
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_parameter, NULL, (opts->x_warn_unused && opts->x_extra_warnings),
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_cpp_warn_expansion_to_defined)
        handle_generated_option (opts, opts_set,
                                 OPT_Wexpansion_to_defined, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wuninitialized:
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wshadow:
      if (!opts_set->x_warn_shadow_ivar)
        handle_generated_option (opts, opts_set,
                                 OPT_Wshadow_ivar, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_shadow_local)
        handle_generated_option (opts, opts_set,
                                 OPT_Wshadow_local, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wshadow_local:
      if (!opts_set->x_warn_shadow_compatible_local)
        handle_generated_option (opts, opts_set,
                                 OPT_Wshadow_compatible_local, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wunused:
      if (!opts_set->x_warn_unused_but_set_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_but_set_parameter, NULL, (opts->x_warn_unused && opts->x_extra_warnings),
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_but_set_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_but_set_variable, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_function)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_function, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_label)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_label, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_local_typedefs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_local_typedefs, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_parameter, NULL, (opts->x_warn_unused && opts->x_extra_warnings),
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_value)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_value, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_variable, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_ftree_vectorize:
      if (!opts_set->x_flag_tree_loop_vectorize)
        handle_generated_option (opts, opts_set,
                                 OPT_ftree_loop_vectorize, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_flag_tree_slp_vectorize)
        handle_generated_option (opts, opts_set,
                                 OPT_ftree_slp_vectorize, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
Ada_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
AdaSCIL_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
AdaWhy_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
BRIG_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
C_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_array_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_parameter_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_bool_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wbool_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_bool_op)
        handle_generated_option (opts, opts_set,
                                 OPT_Wbool_operation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_char_subscripts)
        handle_generated_option (opts, opts_set,
                                 OPT_Wchar_subscripts, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_comment)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcomment, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_duplicate_decl_specifier)
        handle_generated_option (opts, opts_set,
                                 OPT_Wduplicate_decl_specifier, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_enum_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_frame_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Wframe_address, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_implicit)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_int_in_bool_context)
        handle_generated_option (opts, opts_set,
                                 OPT_Wint_in_bool_context, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_logical_not_paren)
        handle_generated_option (opts, opts_set,
                                 OPT_Wlogical_not_parentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_memset_elt_size)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmemset_elt_size, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_memset_transposed_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmemset_transposed_args, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_misleading_indentation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmisleading_indentation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_mismatched_alloc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmismatched_dealloc, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_mismatched_new_delete)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmismatched_new_delete, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_missing_attributes)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_attributes, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_missing_braces)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_braces, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_multistatement_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmultistatement_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_openmp_simd)
        handle_generated_option (opts, opts_set,
                                 OPT_Wopenmp_simd, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_packed_not_aligned)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpacked_not_aligned, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_parentheses)
        handle_generated_option (opts, opts_set,
                                 OPT_Wparentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pointer_sign)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_sign, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_restrict)
        handle_generated_option (opts, opts_set,
                                 OPT_Wrestrict, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sequence_point)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsequence_point, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_array_div)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_array_div, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_pointer_div)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_div, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_pointer_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_strict_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_aliasing_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_strict_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_overflow_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overflow_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overread)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overread, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_truncation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_truncation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_switch)
        handle_generated_option (opts, opts_set,
                                 OPT_Wswitch, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_tautological_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtautological_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_trigraphs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtrigraphs, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_vla_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvla_parameter, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_volatile_register_var)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvolatile_register_var, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_zero_length_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Wzero_length_bounds, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wparentheses:
      if (!opts_set->x_warn_dangling_else)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdangling_else, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_cpp_warn_endif_labels)
        handle_generated_option (opts, opts_set,
                                 OPT_Wendif_labels, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_overlength_strings)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverlength_strings, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pointer_arith)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_arith, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pointer_sign)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_sign, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_variadic_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvariadic_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wc___compat:
      if (!opts_set->x_warn_enum_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wextra:
      if (!opts_set->x_warn_enum_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_implicit_fallthrough)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_fallthrough_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_string_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstring_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wconversion:
      if (!opts_set->x_warn_float_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfloat_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sign_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_contains_nul)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_contains_nul, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_diag)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_diag, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_extra_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_extra_args, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_nonliteral)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_nonliteral, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_overflow_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_security)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_security, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_trunc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_truncation_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_y2k)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_y2k, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_zero_length)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_zero_length, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wimplicit:
      if (!opts_set->x_warn_implicit_function_declaration)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_function_declaration, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_implicit_int)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_int, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wc90_c99_compat:
      if (!opts_set->x_warn_long_long)
        handle_generated_option (opts, opts_set,
                                 OPT_Wlong_long, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wabi:
      if (!opts_set->x_warn_psabi)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpsabi, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wunused_variable:
      if (!opts_set->x_warn_unused_const_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_const_variable_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wunused:
      if (!opts_set->x_warn_unused_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_variable, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wtraditional:
      if (!opts_set->x_cpp_warn_variadic_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvariadic_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
CXX_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_aligned_new)
        handle_generated_option (opts, opts_set,
                                 OPT_Waligned_new_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_array_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_parameter_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_bool_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wbool_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_bool_op)
        handle_generated_option (opts, opts_set,
                                 OPT_Wbool_operation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cxx11_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__11_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cxx14_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__14_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cxx17_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__17_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cxx20_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__20_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_catch_value)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcatch_value_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_char_subscripts)
        handle_generated_option (opts, opts_set,
                                 OPT_Wchar_subscripts, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_class_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wclass_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_comment)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcomment, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_delnonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdelete_non_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_frame_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Wframe_address, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_init_self)
        handle_generated_option (opts, opts_set,
                                 OPT_Winit_self, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_int_in_bool_context)
        handle_generated_option (opts, opts_set,
                                 OPT_Wint_in_bool_context, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_logical_not_paren)
        handle_generated_option (opts, opts_set,
                                 OPT_Wlogical_not_parentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_memset_elt_size)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmemset_elt_size, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_memset_transposed_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmemset_transposed_args, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_misleading_indentation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmisleading_indentation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_mismatched_alloc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmismatched_dealloc, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_mismatched_new_delete)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmismatched_new_delete, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_missing_attributes)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_attributes, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_multistatement_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmultistatement_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_narrowing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnarrowing, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_openmp_simd)
        handle_generated_option (opts, opts_set,
                                 OPT_Wopenmp_simd, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_packed_not_aligned)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpacked_not_aligned, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_parentheses)
        handle_generated_option (opts, opts_set,
                                 OPT_Wparentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pessimizing_move)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpessimizing_move, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_range_loop_construct)
        handle_generated_option (opts, opts_set,
                                 OPT_Wrange_loop_construct, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_reorder)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreorder, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_restrict)
        handle_generated_option (opts, opts_set,
                                 OPT_Wrestrict, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sequence_point)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsequence_point, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sign_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_array_div)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_array_div, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_pointer_div)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_div, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_pointer_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_strict_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_aliasing_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_strict_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_overflow_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overflow_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overread)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overread, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_truncation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_truncation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_switch)
        handle_generated_option (opts, opts_set,
                                 OPT_Wswitch, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_tautological_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtautological_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_trigraphs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtrigraphs, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_vla_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvla_parameter, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_volatile_register_var)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvolatile_register_var, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_zero_length_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Wzero_length_bounds, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wparentheses:
      if (!opts_set->x_warn_dangling_else)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdangling_else, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Weffc__:
      if (!opts_set->x_warn_delnonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdelete_non_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnon_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wextra:
      if (!opts_set->x_warn_deprecated_copy)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdeprecated_copy, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_implicit_fallthrough)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_fallthrough_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_redundant_move)
        handle_generated_option (opts, opts_set,
                                 OPT_Wredundant_move, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_string_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstring_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_cpp_warn_endif_labels)
        handle_generated_option (opts, opts_set,
                                 OPT_Wendif_labels, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_overlength_strings)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverlength_strings, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pointer_arith)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_arith, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_variadic_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvariadic_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wconversion:
      if (!opts_set->x_warn_float_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfloat_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_contains_nul)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_contains_nul, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_diag)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_diag, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_extra_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_extra_args, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_nonliteral)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_nonliteral, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_overflow_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_security)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_security, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_trunc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_truncation_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_y2k)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_y2k, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_zero_length)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_zero_length, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wc__11_compat:
      if (!opts_set->x_warn_narrowing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnarrowing, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wabi:
      if (!opts_set->x_warn_noexcept_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnoexcept_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_psabi)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpsabi, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wc__17_compat:
      if (!opts_set->x_warn_noexcept_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnoexcept_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wunused:
      if (!opts_set->x_warn_unused_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_variable, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wtraditional:
      if (!opts_set->x_cpp_warn_variadic_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvariadic_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
D_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wextra:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cast_result)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcast_result, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
Fortran_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Waliasing, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_ampersand)
        handle_generated_option (opts, opts_set,
                                 OPT_Wampersand, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_c_binding_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc_binding_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_character_truncation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcharacter_truncation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wconversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_integer_division)
        handle_generated_option (opts, opts_set,
                                 OPT_Winteger_division, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_intrinsic_shadow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wintrinsic_shadow, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_intrinsics_std)
        handle_generated_option (opts, opts_set,
                                 OPT_Wintrinsics_std, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_line_truncation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wline_truncation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_real_q_constant)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreal_q_constant, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_surprising)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsurprising, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_tabs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtabs, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_target_lifetime)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtarget_lifetime, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_undefined_do_loop)
        handle_generated_option (opts, opts_set,
                                 OPT_Wundefined_do_loop, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused_dummy_argument)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_dummy_argument, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_zerotrip)
        handle_generated_option (opts, opts_set,
                                 OPT_Wzerotrip, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_warn_ampersand)
        handle_generated_option (opts, opts_set,
                                 OPT_Wampersand, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_tabs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtabs, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wextra:
      if (!opts_set->x_warn_compare_reals)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcompare_reals, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_do_subscript)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdo_subscript, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_function_elimination)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfunction_elimination, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wrealloc_lhs_all:
      if (!opts_set->x_warn_realloc_lhs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wrealloc_lhs, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_std_legacy:
      if (!opts_set->x_flag_allow_argument_mismatch)
        handle_generated_option (opts, opts_set,
                                 OPT_fallow_argument_mismatch, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
Go_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
LTO_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overflow_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overread)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overread, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_truncation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_truncation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_overflow_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_trunc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_truncation_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
LTODump_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
ObjC_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_array_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_parameter_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_bool_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wbool_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_bool_op)
        handle_generated_option (opts, opts_set,
                                 OPT_Wbool_operation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_char_subscripts)
        handle_generated_option (opts, opts_set,
                                 OPT_Wchar_subscripts, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_comment)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcomment, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_duplicate_decl_specifier)
        handle_generated_option (opts, opts_set,
                                 OPT_Wduplicate_decl_specifier, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_enum_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_frame_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Wframe_address, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_implicit)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_int_in_bool_context)
        handle_generated_option (opts, opts_set,
                                 OPT_Wint_in_bool_context, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_logical_not_paren)
        handle_generated_option (opts, opts_set,
                                 OPT_Wlogical_not_parentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_memset_elt_size)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmemset_elt_size, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_memset_transposed_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmemset_transposed_args, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_mismatched_alloc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmismatched_dealloc, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_mismatched_new_delete)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmismatched_new_delete, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_missing_attributes)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_attributes, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_missing_braces)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_braces, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_multistatement_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmultistatement_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_packed_not_aligned)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpacked_not_aligned, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_parentheses)
        handle_generated_option (opts, opts_set,
                                 OPT_Wparentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pointer_sign)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_sign, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_restrict)
        handle_generated_option (opts, opts_set,
                                 OPT_Wrestrict, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sequence_point)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsequence_point, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_array_div)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_array_div, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_pointer_div)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_div, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_pointer_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_strict_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_aliasing_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_strict_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_overflow_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overflow_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overread)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overread, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_truncation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_truncation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_switch)
        handle_generated_option (opts, opts_set,
                                 OPT_Wswitch, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_tautological_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtautological_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_trigraphs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtrigraphs, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_vla_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvla_parameter, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_volatile_register_var)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvolatile_register_var, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_zero_length_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Wzero_length_bounds, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wparentheses:
      if (!opts_set->x_warn_dangling_else)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdangling_else, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_cpp_warn_endif_labels)
        handle_generated_option (opts, opts_set,
                                 OPT_Wendif_labels, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_overlength_strings)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverlength_strings, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pointer_arith)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_arith, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pointer_sign)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_sign, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_variadic_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvariadic_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wc___compat:
      if (!opts_set->x_warn_enum_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wextra:
      if (!opts_set->x_warn_enum_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_implicit_fallthrough)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_fallthrough_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_string_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstring_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wconversion:
      if (!opts_set->x_warn_float_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfloat_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sign_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_contains_nul)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_contains_nul, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_diag)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_diag, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_extra_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_extra_args, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_nonliteral)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_nonliteral, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_overflow_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_security)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_security, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_trunc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_truncation_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_y2k)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_y2k, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_zero_length)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_zero_length, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wimplicit:
      if (!opts_set->x_warn_implicit_function_declaration)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_function_declaration, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_implicit_int)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_int, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wc90_c99_compat:
      if (!opts_set->x_warn_long_long)
        handle_generated_option (opts, opts_set,
                                 OPT_Wlong_long, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wabi:
      if (!opts_set->x_warn_psabi)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpsabi, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wunused_variable:
      if (!opts_set->x_warn_unused_const_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_const_variable_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wunused:
      if (!opts_set->x_warn_unused_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_variable, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wtraditional:
      if (!opts_set->x_cpp_warn_variadic_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvariadic_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
ObjCXX_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, HOST_WIDE_INT value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_aligned_new)
        handle_generated_option (opts, opts_set,
                                 OPT_Waligned_new_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_array_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_parameter_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_bool_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wbool_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_bool_op)
        handle_generated_option (opts, opts_set,
                                 OPT_Wbool_operation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cxx11_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__11_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cxx14_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__14_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cxx17_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__17_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_cxx20_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__20_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_catch_value)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcatch_value_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_char_subscripts)
        handle_generated_option (opts, opts_set,
                                 OPT_Wchar_subscripts, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_class_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wclass_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_comment)
        handle_generated_option (opts, opts_set,
                                 OPT_Wcomment, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_delnonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdelete_non_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_frame_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Wframe_address, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_init_self)
        handle_generated_option (opts, opts_set,
                                 OPT_Winit_self, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_int_in_bool_context)
        handle_generated_option (opts, opts_set,
                                 OPT_Wint_in_bool_context, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_logical_not_paren)
        handle_generated_option (opts, opts_set,
                                 OPT_Wlogical_not_parentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_memset_elt_size)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmemset_elt_size, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_memset_transposed_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmemset_transposed_args, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_mismatched_alloc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmismatched_dealloc, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_mismatched_new_delete)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmismatched_new_delete, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_missing_attributes)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_attributes, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_multistatement_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmultistatement_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_narrowing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnarrowing, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_packed_not_aligned)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpacked_not_aligned, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_parentheses)
        handle_generated_option (opts, opts_set,
                                 OPT_Wparentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pessimizing_move)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpessimizing_move, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_range_loop_construct)
        handle_generated_option (opts, opts_set,
                                 OPT_Wrange_loop_construct, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_reorder)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreorder, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_restrict)
        handle_generated_option (opts, opts_set,
                                 OPT_Wrestrict, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sequence_point)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsequence_point, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sign_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_array_div)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_array_div, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_pointer_div)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_div, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_sizeof_pointer_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_strict_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_aliasing_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_strict_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_overflow_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overflow_, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_overread)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_overread, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_stringop_truncation)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstringop_truncation, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_switch)
        handle_generated_option (opts, opts_set,
                                 OPT_Wswitch, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_tautological_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtautological_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_trigraphs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtrigraphs, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_vla_parameter)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvla_parameter, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_volatile_register_var)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvolatile_register_var, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_zero_length_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Wzero_length_bounds, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wparentheses:
      if (!opts_set->x_warn_dangling_else)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdangling_else, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Weffc__:
      if (!opts_set->x_warn_delnonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdelete_non_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnon_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wextra:
      if (!opts_set->x_warn_deprecated_copy)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdeprecated_copy, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_implicit_fallthrough)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_fallthrough_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_redundant_move)
        handle_generated_option (opts, opts_set,
                                 OPT_Wredundant_move, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_string_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstring_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_cpp_warn_endif_labels)
        handle_generated_option (opts, opts_set,
                                 OPT_Wendif_labels, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_overlength_strings)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverlength_strings, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_pointer_arith)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_arith, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_cpp_warn_variadic_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvariadic_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wconversion:
      if (!opts_set->x_warn_float_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfloat_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_contains_nul)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_contains_nul, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_diag)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_diag, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_extra_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_extra_args, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_nonliteral)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_nonliteral, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_overflow_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_security)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_security, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_trunc)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_truncation_, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_y2k)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_y2k, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_format_zero_length)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_zero_length, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wc__11_compat:
      if (!opts_set->x_warn_narrowing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnarrowing, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wabi:
      if (!opts_set->x_warn_noexcept_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnoexcept_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      if (!opts_set->x_warn_psabi)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpsabi, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wc__17_compat:
      if (!opts_set->x_warn_noexcept_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnoexcept_type, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wunused:
      if (!opts_set->x_warn_unused_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_variable, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    case OPT_Wtraditional:
      if (!opts_set->x_cpp_warn_variadic_macros)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvariadic_macros, NULL, value,
                                 lang_mask, kind, loc, handlers, true, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               


#include "cpplib.h"
void
cpp_handle_option_auto (const struct gcc_options * opts,                   
                        size_t scode, struct cpp_options * cpp_opts)
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wbidi_chars_:
      cpp_opts->cpp_warn_bidirectional = opts->x_warn_bidirectional;
      break;
    case OPT_Wbuiltin_macro_redefined:
      cpp_opts->warn_builtin_macro_redefined = opts->x_cpp_warn_builtin_macro_redefined;
      break;
    case OPT_Wc___compat:
      cpp_opts->warn_cxx_operator_names = opts->x_warn_cxx_compat;
      break;
    case OPT_Wc__11_compat:
      cpp_opts->cpp_warn_cxx11_compat = opts->x_warn_cxx11_compat;
      break;
    case OPT_Wc11_c2x_compat:
      cpp_opts->cpp_warn_c11_c2x_compat = opts->x_warn_c11_c2x_compat;
      break;
    case OPT_Wc90_c99_compat:
      cpp_opts->cpp_warn_c90_c99_compat = opts->x_warn_c90_c99_compat;
      break;
    case OPT_Wcomment:
      cpp_opts->warn_comments = opts->x_cpp_warn_comment;
      break;
    case OPT_Wdate_time:
      cpp_opts->warn_date_time = opts->x_cpp_warn_date_time;
      break;
    case OPT_Wdeprecated:
      cpp_opts->cpp_warn_deprecated = opts->x_warn_deprecated;
      break;
    case OPT_Wendif_labels:
      cpp_opts->warn_endif_labels = opts->x_cpp_warn_endif_labels;
      break;
    case OPT_Wexpansion_to_defined:
      cpp_opts->warn_expansion_to_defined = opts->x_cpp_warn_expansion_to_defined;
      break;
    case OPT_Winvalid_pch:
      cpp_opts->warn_invalid_pch = opts->x_cpp_warn_invalid_pch;
      break;
    case OPT_Wliteral_suffix:
      cpp_opts->warn_literal_suffix = opts->x_cpp_warn_literal_suffix;
      break;
    case OPT_Wlong_long:
      cpp_opts->cpp_warn_long_long = opts->x_warn_long_long;
      break;
    case OPT_Wmissing_include_dirs:
      cpp_opts->warn_missing_include_dirs = opts->x_cpp_warn_missing_include_dirs;
      break;
    case OPT_Wmultichar:
      cpp_opts->warn_multichar = opts->x_cpp_warn_multichar;
      break;
    case OPT_Wnormalized_:
      cpp_opts->warn_normalize = opts->x_cpp_warn_normalize;
      break;
    case OPT_Wpedantic:
      cpp_opts->cpp_pedantic = opts->x_pedantic;
      break;
    case OPT_Wtraditional:
      cpp_opts->cpp_warn_traditional = opts->x_warn_traditional;
      break;
    case OPT_Wtrigraphs:
      cpp_opts->warn_trigraphs = opts->x_cpp_warn_trigraphs;
      break;
    case OPT_Wundef:
      cpp_opts->warn_undef = opts->x_cpp_warn_undef;
      break;
    case OPT_Wvariadic_macros:
      cpp_opts->warn_variadic_macros = opts->x_cpp_warn_variadic_macros;
      break;
    default:    
      break;    
    }           
}

void
init_global_opts_from_cpp(struct gcc_options * opts,                   
                         const struct cpp_options * cpp_opts)
{                                                                     
  opts->x_warn_bidirectional = cpp_opts->cpp_warn_bidirectional;
  opts->x_cpp_warn_builtin_macro_redefined = cpp_opts->warn_builtin_macro_redefined;
  opts->x_warn_cxx_compat = cpp_opts->warn_cxx_operator_names;
  opts->x_warn_cxx11_compat = cpp_opts->cpp_warn_cxx11_compat;
  opts->x_warn_c11_c2x_compat = cpp_opts->cpp_warn_c11_c2x_compat;
  opts->x_warn_c90_c99_compat = cpp_opts->cpp_warn_c90_c99_compat;
  opts->x_cpp_warn_comment = cpp_opts->warn_comments;
  opts->x_cpp_warn_date_time = cpp_opts->warn_date_time;
  opts->x_warn_deprecated = cpp_opts->cpp_warn_deprecated;
  opts->x_cpp_warn_endif_labels = cpp_opts->warn_endif_labels;
  opts->x_cpp_warn_expansion_to_defined = cpp_opts->warn_expansion_to_defined;
  opts->x_cpp_warn_invalid_pch = cpp_opts->warn_invalid_pch;
  opts->x_cpp_warn_literal_suffix = cpp_opts->warn_literal_suffix;
  opts->x_warn_long_long = cpp_opts->cpp_warn_long_long;
  opts->x_cpp_warn_missing_include_dirs = cpp_opts->warn_missing_include_dirs;
  opts->x_cpp_warn_multichar = cpp_opts->warn_multichar;
  opts->x_cpp_warn_normalize = cpp_opts->warn_normalize;
  opts->x_pedantic = cpp_opts->cpp_pedantic;
  opts->x_warn_traditional = cpp_opts->cpp_warn_traditional;
  opts->x_cpp_warn_trigraphs = cpp_opts->warn_trigraphs;
  opts->x_cpp_warn_undef = cpp_opts->warn_undef;
  opts->x_cpp_warn_variadic_macros = cpp_opts->warn_variadic_macros;
}               

#if !defined(GENERATOR_FILE) && defined(ENABLE_PLUGIN)
DEBUG_VARIABLE const struct cl_var cl_vars[] =
{
  { "dump_base_name_prefixed", offsetof (struct gcc_options, x_dump_base_name_prefixed) },
  { "exit_after_options", offsetof (struct gcc_options, x_exit_after_options) },
  { "flag_dump_all_passed", offsetof (struct gcc_options, x_flag_dump_all_passed) },
  { "flag_opts_finished", offsetof (struct gcc_options, x_flag_opts_finished) },
  { "flag_stack_usage_info", offsetof (struct gcc_options, x_flag_stack_usage_info) },
  { "flag_warn_unused_result", offsetof (struct gcc_options, x_flag_warn_unused_result) },
  { "in_lto_p", offsetof (struct gcc_options, x_in_lto_p) },
  { "use_gnu_debug_info_extensions", offsetof (struct gcc_options, x_use_gnu_debug_info_extensions) },
  { "help_enum_printed", offsetof (struct gcc_options, x_help_enum_printed) },
  { "help_printed", offsetof (struct gcc_options, x_help_printed) },
  { "aux_base_name", offsetof (struct gcc_options, x_aux_base_name) },
  { "main_input_basename", offsetof (struct gcc_options, x_main_input_basename) },
  { "main_input_filename", offsetof (struct gcc_options, x_main_input_filename) },
  { "debug_info_level", offsetof (struct gcc_options, x_debug_info_level) },
  { "write_symbols", offsetof (struct gcc_options, x_write_symbols) },
  { "debug_struct_generic", offsetof (struct gcc_options, x_debug_struct_generic) },
  { "debug_struct_ordinary", offsetof (struct gcc_options, x_debug_struct_ordinary) },
  { "flag_incremental_link", offsetof (struct gcc_options, x_flag_incremental_link) },
  { "flag_stack_check", offsetof (struct gcc_options, x_flag_stack_check) },
  { "flag_complex_method", offsetof (struct gcc_options, x_flag_complex_method) },
  { "flag_debug_asm", offsetof (struct gcc_options, x_flag_debug_asm) },
  { "flag_dump_rtl_in_asm", offsetof (struct gcc_options, x_flag_dump_rtl_in_asm) },
  { "flag_gen_aux_info", offsetof (struct gcc_options, x_flag_gen_aux_info) },
  { "flag_generate_lto", offsetof (struct gcc_options, x_flag_generate_lto) },
  { "flag_generate_offload", offsetof (struct gcc_options, x_flag_generate_offload) },
  { "flag_print_asm_name", offsetof (struct gcc_options, x_flag_print_asm_name) },
  { "flag_shlib", offsetof (struct gcc_options, x_flag_shlib) },
  { "main_input_baselength", offsetof (struct gcc_options, x_main_input_baselength) },
  { "optimize", offsetof (struct gcc_options, x_optimize) },
  { "optimize_debug", offsetof (struct gcc_options, x_optimize_debug) },
  { "optimize_fast", offsetof (struct gcc_options, x_optimize_fast) },
  { "optimize_size", offsetof (struct gcc_options, x_optimize_size) },
  { "rtl_dump_and_exit", offsetof (struct gcc_options, x_rtl_dump_and_exit) },
  { "target_flags", offsetof (struct gcc_options, x_target_flags) },
  { "flag_sanitize", offsetof (struct gcc_options, x_flag_sanitize) },
  { "flag_sanitize_coverage", offsetof (struct gcc_options, x_flag_sanitize_coverage) },
  { "flag_sanitize_recover", offsetof (struct gcc_options, x_flag_sanitize_recover) },
  { "flag_zero_call_used_regs", offsetof (struct gcc_options, x_flag_zero_call_used_regs) },
  { "help_columns", offsetof (struct gcc_options, x_help_columns) },
  { "initial_max_fld_align", offsetof (struct gcc_options, x_initial_max_fld_align) },
  { "flag_instrument_functions_exclude_files", offsetof (struct gcc_options, x_flag_instrument_functions_exclude_files) },
  { "flag_instrument_functions_exclude_functions", offsetof (struct gcc_options, x_flag_instrument_functions_exclude_functions) },
  { NULL, (unsigned short) -1 }
};
#endif
