/* Autogenerated file, DO NOT EDIT manually! generated by gen_perf.py
 *
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdint.h>
#include <stdbool.h>

#include <drm-uapi/i915_drm.h>

#include "util/hash_table.h"
#include "util/ralloc.h"

#include "intel_perf_metrics.h"
#include "perf/intel_perf.h"


#define MIN(a, b) ((a < b) ? (a) : (b))
#define MAX(a, b) ((a > b) ? (a) : (b))

static struct intel_perf_query_info *
intel_query_alloc(struct intel_perf_config *perf, int ncounters)
{
   struct intel_perf_query_info *query = rzalloc(perf, struct intel_perf_query_info);
   query->perf = perf;
   query->kind = INTEL_PERF_QUERY_TYPE_OA;
   query->n_counters = 0;
   query->oa_metrics_set_id = 0; /* determined at runtime, via sysfs */
   query->counters = rzalloc_array(query, struct intel_perf_query_counter, ncounters);
   return query;
}

static struct intel_perf_query_info *
hsw_query_alloc(struct intel_perf_config *perf, int ncounters)
{
   struct intel_perf_query_info *query = intel_query_alloc(perf, ncounters);
   query->oa_format = I915_OA_FORMAT_A45_B8_C8;
   /* Accumulation buffer offsets... */
   query->gpu_time_offset = 0;
   query->a_offset = query->gpu_time_offset + 1;
   query->b_offset = query->a_offset + 45;
   query->c_offset = query->b_offset + 8;
   query->perfcnt_offset = query->c_offset + 8;
   query->rpstat_offset = query->perfcnt_offset + 2;
   return query;
}

static struct intel_perf_query_info *
bdw_query_alloc(struct intel_perf_config *perf, int ncounters)
{
   struct intel_perf_query_info *query = intel_query_alloc(perf, ncounters);
   query->oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;
   /* Accumulation buffer offsets... */
   query->gpu_time_offset = 0;
   query->gpu_clock_offset = query->gpu_time_offset + 1;
   query->a_offset = query->gpu_clock_offset + 1;
   query->b_offset = query->a_offset + 36;
   query->c_offset = query->b_offset + 8;
   query->perfcnt_offset = query->c_offset + 8;
   query->rpstat_offset = query->perfcnt_offset + 2;
   return query;
}

/* Render Metrics Basic set :: GPU Time Elapsed */
static uint64_t
hsw__render_basic__gpu_time__read(UNUSED struct intel_perf_config *perf,
                                  const struct intel_perf_query_info *query,
                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = results->accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = perf->sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: GPU Core Clocks */
static uint64_t
hsw__render_basic__gpu_core_clocks__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 2 READ */
   uint64_t tmp0 = results->accumulator[query->c_offset + 2];

   return tmp0;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
static uint64_t
hsw__render_basic__avg_gpu_core_frequency__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = hsw__render_basic__gpu_core_clocks__read(perf, query, results) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__gpu_time__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
static uint64_t
hsw__render_basic__avg_gpu_core_frequency__max(struct intel_perf_config *perf)
{
   /* RPN equation: $GpuMaxFrequency */

   return perf->sys_vars.gt_max_freq;
}

/* Render Metrics Basic set :: VS Threads Dispatched */
static uint64_t
hsw__render_basic__vs_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 5];

   return tmp0;
}

/* Render Metrics Basic set :: TCS Threads Dispatched */
static uint64_t
hsw__render_basic__hs_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 10 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 10];

   return tmp0;
}

/* Render Metrics Basic set :: TES Threads Dispatched */
static uint64_t
hsw__render_basic__ds_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 15 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 15];

   return tmp0;
}

/* Render Metrics Basic set :: GS Threads Dispatched */
static uint64_t
hsw__render_basic__gs_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 25 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 25];

   return tmp0;
}

/* Render Metrics Basic set :: FS Threads Dispatched */
static uint64_t
hsw__render_basic__ps_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 30 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 30];

   return tmp0;
}

/* Render Metrics Basic set :: CS Threads Dispatched */
static uint64_t
hsw__render_basic__cs_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 20 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 20];

   return tmp0;
}

/* Render Metrics Basic set :: GPU Busy */
static float
hsw__render_basic__gpu_busy__read(UNUSED struct intel_perf_config *perf,
                                  const struct intel_perf_query_info *query,
                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: A 41 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 41];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: EU Active */
static float
hsw__render_basic__eu_active__read(UNUSED struct intel_perf_config *perf,
                                   const struct intel_perf_query_info *query,
                                   const struct intel_perf_query_result *results)
{
   /* RPN equation: A 0 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: EU Stall */
static float
hsw__render_basic__eu_stall__read(UNUSED struct intel_perf_config *perf,
                                  const struct intel_perf_query_info *query,
                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: A 1 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 1];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: VS EU Active */
static float
hsw__render_basic__vs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 2 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 2];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: VS AVG Active per Thread */
static uint64_t
hsw__render_basic__vs_eu_active_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: A 2 READ $VsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 2];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__vs_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: VS AVG Stall per Thread */
static uint64_t
hsw__render_basic__vs_eu_stall_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 3 READ $VsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 3];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__vs_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: VS EU Stall */
static float
hsw__render_basic__vs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 3 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 3];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: TCS EU Active */
static float
hsw__render_basic__hs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: TCS AVG Active per Thread */
static uint64_t
hsw__render_basic__hs_eu_active_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: A 7 READ $HsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__hs_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: TCS AVG Stall per Thread */
static uint64_t
hsw__render_basic__hs_eu_stall_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 8 READ $HsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__hs_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: TCS EU Stall */
static float
hsw__render_basic__hs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: TES EU Active */
static float
hsw__render_basic__ds_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: TES AVG Active per Thread */
static uint64_t
hsw__render_basic__ds_eu_active_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: A 12 READ $DsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__ds_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: TES AVG Stall per Thread */
static uint64_t
hsw__render_basic__ds_eu_stall_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 13 READ $DsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__ds_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: TES EU Stall */
static float
hsw__render_basic__ds_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: GS EU Active */
static float
hsw__render_basic__gs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 22 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: GS AVG Active per Thread */
static uint64_t
hsw__render_basic__gs_eu_active_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: A 22 READ $GsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__gs_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: GS AVG Stall per Thread */
static uint64_t
hsw__render_basic__gs_eu_stall_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 23 READ $GsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__gs_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: GS EU Stall */
static float
hsw__render_basic__gs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 23 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: CS EU Active */
static float
hsw__render_basic__cs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: CS AVG Active per Thread */
static uint64_t
hsw__render_basic__cs_eu_active_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: A 17 READ $CsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__cs_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: CS AVG Stall per Thread */
static uint64_t
hsw__render_basic__cs_eu_stall_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 18 READ $CsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__cs_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: CS EU Stall */
static float
hsw__render_basic__cs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: FS EU Active */
static float
hsw__render_basic__ps_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 27 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: FS AVG Active per Thread */
static uint64_t
hsw__render_basic__ps_eu_active_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: A 27 READ $PsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__ps_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: FS AVG Stall per Thread */
static uint64_t
hsw__render_basic__ps_eu_stall_per_thread__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 28 READ $PsThreads UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__render_basic__ps_threads__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: FS EU Stall */
static float
hsw__render_basic__ps_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 28 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: Sampler 0 Busy */
static float
hsw__render_basic__sampler0_busy__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: Sampler 1 Busy */
static float
hsw__render_basic__sampler1_busy__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: Samplers Busy */
static float
hsw__render_basic__samplers_busy__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ  B 1 READ UADD $GpuCoreClocks FDIV 2 FDIV 100 FMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   double tmp6 = tmp5;
   double tmp7 = 2;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 * 100;

   return tmp9;
}

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
static float
hsw__render_basic__sampler0_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
static float
hsw__render_basic__sampler1_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: Sampler 0 Texels LOD0 */
static uint64_t
hsw__render_basic__sampler0_texels__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Sampler 1 Texels LOD0 */
static uint64_t
hsw__render_basic__sampler1_texels__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: B 5 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Sampler Texels LOD0 */
static uint64_t
hsw__render_basic__sampler_texels__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: $Sampler0Texels $Sampler1Texels UADD $EuSlicesTotalCount UMUL */
   uint64_t tmp0 = hsw__render_basic__sampler0_texels__read(perf, query, results) + hsw__render_basic__sampler1_texels__read(perf, query, results);
   uint64_t tmp1 = tmp0 * perf->sys_vars.n_eu_slices;

   return tmp1;
}

/* Render Metrics Basic set :: L3 Sampler Throughput */
static uint64_t
hsw__render_basic__l3_sampler_throughput__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: B 6 READ B 7 READ UADD 2 UMUL $EuSlicesTotalCount UMUL 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 6];
   uint64_t tmp1 = results->accumulator[query->b_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 2;
   uint64_t tmp4 = tmp3 * perf->sys_vars.n_eu_slices;
   uint64_t tmp5 = tmp4 * 64;

   return tmp5;
}

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
static uint64_t
hsw__render_basic__hi_depth_test_fails__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: A 33 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 33];

   return tmp0;
}

/* Render Metrics Basic set :: Early Depth Test Fails */
static uint64_t
hsw__render_basic__early_depth_test_fails__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 35];

   return tmp0;
}

/* Render Metrics Basic set :: Samples Killed in FS */
static uint64_t
hsw__render_basic__samples_killed_in_ps__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: A 36 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 36];

   return tmp0;
}

/* Render Metrics Basic set :: Alpha Test Fails */
static uint64_t
hsw__render_basic__alpha_test_fails__read(UNUSED struct intel_perf_config *perf,
                                          const struct intel_perf_query_info *query,
                                          const struct intel_perf_query_result *results)
{
   /* RPN equation: A 37 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 37];

   return tmp0;
}

/* Render Metrics Basic set :: Late Stencil Test Fails */
static uint64_t
hsw__render_basic__post_ps_stencil_test_fails__read(UNUSED struct intel_perf_config *perf,
                                                    const struct intel_perf_query_info *query,
                                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 38 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 38];

   return tmp0;
}

/* Render Metrics Basic set :: Late Depth Test Fails */
static uint64_t
hsw__render_basic__post_ps_depth_test_fails__read(UNUSED struct intel_perf_config *perf,
                                                  const struct intel_perf_query_info *query,
                                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: A 39 READ $SamplesKilledInPs USUB */
   uint64_t tmp0 = results->accumulator[query->a_offset + 39];
   uint64_t tmp1 = tmp0 - hsw__render_basic__samples_killed_in_ps__read(perf, query, results);

   return tmp1;
}

/* Render Metrics Basic set :: Samples Written */
static uint64_t
hsw__render_basic__samples_written__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 40 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 40];

   return tmp0;
}

/* Render Metrics Basic set :: Samples Blended */
static uint64_t
hsw__render_basic__samples_blended__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 5 READ $EuSlicesTotalCount 4 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 5];
   uint64_t tmp1 = perf->sys_vars.n_eu_slices * 4;
   uint64_t tmp2 = tmp0 * tmp1;

   return tmp2;
}

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
static uint64_t
hsw__render_basic__gti_vf_throughput__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: C 1 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: GTI Depth Throughput */
static uint64_t
hsw__render_basic__gti_depth_throughput__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: C 0 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: GTI RCC Throughput */
static uint64_t
hsw__render_basic__gti_rcc_throughput__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: C 3 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: GTI L3 Throughput */
static uint64_t
hsw__render_basic__gti_l3_throughput__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: C 4 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: GTI Read Throughput */
static uint64_t
hsw__render_basic__gti_read_throughput__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: C 6 READ 128 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 128;

   return tmp1;
}

/* Render Metrics Basic set :: GTI Write Throughput */
static uint64_t
hsw__render_basic__gti_write_throughput__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: C 7 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: LLC GPU Accesses */
static uint64_t
hsw__render_basic__llc_accesses__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: PERFCNT 0 READ */
   uint64_t tmp0 = results->accumulator[query->perfcnt_offset + 0];

   return tmp0;
}

/* Render Metrics Basic set :: LLC GPU Hits */
static uint64_t
hsw__render_basic__llc_hits__read(UNUSED struct intel_perf_config *perf,
                                  const struct intel_perf_query_info *query,
                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: PERFCNT 1 READ */
   uint64_t tmp0 = results->accumulator[query->perfcnt_offset + 1];

   return tmp0;
}

/* Render Metrics Basic set :: LLC GPU Throughput */
static uint64_t
hsw__render_basic__llc_gpu_throughput__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: PERFCNT 0 READ C 7 READ USUB 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->perfcnt_offset + 0];
   uint64_t tmp1 = results->accumulator[query->c_offset + 7];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic set :: FS Duration */
static uint64_t
hsw__render_basic__ps_duration__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 27 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 28 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 27];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 28];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Render Metrics Basic set :: VS Duration */
static uint64_t
hsw__render_basic__vs_duration__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 2 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 3 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 2];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 3];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Render Metrics Basic set :: GS Duration */
static uint64_t
hsw__render_basic__gs_duration__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 22 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 23 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 22];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 23];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Render Metrics Basic set :: TES Duration */
static uint64_t
hsw__render_basic__ds_duration__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 12 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 13 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 12];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 13];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Render Metrics Basic set :: TCS Duration */
static uint64_t
hsw__render_basic__hs_duration__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 7 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 8 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 7];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 8];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Render Metrics Basic set :: CS Duration */
static uint64_t
hsw__render_basic__cs_duration__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 17 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 18 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 17];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 18];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Render Metrics Basic set :: Sampler Bottleneck */
static float
hsw__render_basic__sampler_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: $Sampler0Bottleneck $Sampler1Bottleneck FMAX */
   double tmp0 = hsw__render_basic__sampler0_bottleneck__read(perf, query, results);
   double tmp1 = hsw__render_basic__sampler1_bottleneck__read(perf, query, results);
   double tmp2 = MAX(tmp0, tmp1);

   return tmp2;
}

/* Render Metrics Basic set :: EU Idle */
static float
hsw__render_basic__eu_idle__read(UNUSED struct intel_perf_config *perf,
                                 const struct intel_perf_query_info *query,
                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: 100 $EuActive $EuStall FADD FSUB */
   double tmp0 = hsw__render_basic__eu_active__read(perf, query, results) + hsw__render_basic__eu_stall__read(perf, query, results);
   double tmp1 = 100 - tmp0;

   return tmp1;
}

/* Compute Metrics Basic set :: GPU Time Elapsed */
#define hsw__compute_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Basic set :: GPU Core Clocks */
#define hsw__compute_basic__gpu_core_clocks__read \
   hsw__render_basic__gpu_core_clocks__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define hsw__compute_basic__avg_gpu_core_frequency__read \
   hsw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define hsw__compute_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Basic set :: GPU Busy */
#define hsw__compute_basic__gpu_busy__read \
   hsw__render_basic__gpu_busy__read

/* Compute Metrics Basic set :: VS Threads Dispatched */
#define hsw__compute_basic__vs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: TCS Threads Dispatched */
#define hsw__compute_basic__hs_threads__read \
   hsw__render_basic__hs_threads__read

/* Compute Metrics Basic set :: TES Threads Dispatched */
#define hsw__compute_basic__ds_threads__read \
   hsw__render_basic__ds_threads__read

/* Compute Metrics Basic set :: GS Threads Dispatched */
#define hsw__compute_basic__gs_threads__read \
   hsw__render_basic__gs_threads__read

/* Compute Metrics Basic set :: FS Threads Dispatched */
#define hsw__compute_basic__ps_threads__read \
   hsw__render_basic__ps_threads__read

/* Compute Metrics Basic set :: CS Threads Dispatched */
#define hsw__compute_basic__cs_threads__read \
   hsw__render_basic__cs_threads__read

/* Compute Metrics Basic set :: EU Active */
#define hsw__compute_basic__eu_active__read \
   hsw__render_basic__eu_active__read

/* Compute Metrics Basic set :: EU Stall */
#define hsw__compute_basic__eu_stall__read \
   hsw__render_basic__eu_stall__read

/* Compute Metrics Basic set :: VS EU Active */
#define hsw__compute_basic__vs_eu_active__read \
   hsw__render_basic__vs_eu_active__read

/* Compute Metrics Basic set :: VS AVG Active per Thread */
#define hsw__compute_basic__vs_eu_active_per_thread__read \
   hsw__render_basic__vs_eu_active_per_thread__read

/* Compute Metrics Basic set :: VS EU Stall */
#define hsw__compute_basic__vs_eu_stall__read \
   hsw__render_basic__vs_eu_stall__read

/* Compute Metrics Basic set :: VS AVG Stall per Thread */
#define hsw__compute_basic__vs_eu_stall_per_thread__read \
   hsw__render_basic__vs_eu_stall_per_thread__read

/* Compute Metrics Basic set :: FS EU Active */
#define hsw__compute_basic__ps_eu_active__read \
   hsw__render_basic__ps_eu_active__read

/* Compute Metrics Basic set :: TCS EU Active */
#define hsw__compute_basic__hs_eu_active__read \
   hsw__render_basic__hs_eu_active__read

/* Compute Metrics Basic set :: TCS AVG Active per Thread */
#define hsw__compute_basic__hs_eu_active_per_thread__read \
   hsw__render_basic__hs_eu_active_per_thread__read

/* Compute Metrics Basic set :: TCS EU Stall */
#define hsw__compute_basic__hs_eu_stall__read \
   hsw__render_basic__hs_eu_stall__read

/* Compute Metrics Basic set :: TCS AVG Stall per Thread */
#define hsw__compute_basic__hs_eu_stall_per_thread__read \
   hsw__render_basic__hs_eu_stall_per_thread__read

/* Compute Metrics Basic set :: TES EU Active */
#define hsw__compute_basic__ds_eu_active__read \
   hsw__render_basic__ds_eu_active__read

/* Compute Metrics Basic set :: TES AVG Active per Thread */
#define hsw__compute_basic__ds_eu_active_per_thread__read \
   hsw__render_basic__ds_eu_active_per_thread__read

/* Compute Metrics Basic set :: TES EU Stall */
#define hsw__compute_basic__ds_eu_stall__read \
   hsw__render_basic__ds_eu_stall__read

/* Compute Metrics Basic set :: TES AVG Stall per Thread */
#define hsw__compute_basic__ds_eu_stall_per_thread__read \
   hsw__render_basic__ds_eu_stall_per_thread__read

/* Compute Metrics Basic set :: GS EU Active */
#define hsw__compute_basic__gs_eu_active__read \
   hsw__render_basic__gs_eu_active__read

/* Compute Metrics Basic set :: GS AVG Active per Thread */
#define hsw__compute_basic__gs_eu_active_per_thread__read \
   hsw__render_basic__gs_eu_active_per_thread__read

/* Compute Metrics Basic set :: GS EU Stall */
#define hsw__compute_basic__gs_eu_stall__read \
   hsw__render_basic__gs_eu_stall__read

/* Compute Metrics Basic set :: GS AVG Stall per Thread */
#define hsw__compute_basic__gs_eu_stall_per_thread__read \
   hsw__render_basic__gs_eu_stall_per_thread__read

/* Compute Metrics Basic set :: CS EU Active */
#define hsw__compute_basic__cs_eu_active__read \
   hsw__render_basic__cs_eu_active__read

/* Compute Metrics Basic set :: CS AVG Active per Thread */
#define hsw__compute_basic__cs_eu_active_per_thread__read \
   hsw__render_basic__cs_eu_active_per_thread__read

/* Compute Metrics Basic set :: CS EU Stall */
#define hsw__compute_basic__cs_eu_stall__read \
   hsw__render_basic__cs_eu_stall__read

/* Compute Metrics Basic set :: CS AVG Stall per Thread */
#define hsw__compute_basic__cs_eu_stall_per_thread__read \
   hsw__render_basic__cs_eu_stall_per_thread__read

/* Compute Metrics Basic set :: FS AVG Active per Thread */
#define hsw__compute_basic__ps_eu_active_per_thread__read \
   hsw__render_basic__ps_eu_active_per_thread__read

/* Compute Metrics Basic set :: FS EU Stall */
#define hsw__compute_basic__ps_eu_stall__read \
   hsw__render_basic__ps_eu_stall__read

/* Compute Metrics Basic set :: FS AVG Stall per Thread */
#define hsw__compute_basic__ps_eu_stall_per_thread__read \
   hsw__render_basic__ps_eu_stall_per_thread__read

/* Compute Metrics Basic set :: Early Hi-Depth Test Fails */
#define hsw__compute_basic__hi_depth_test_fails__read \
   hsw__render_basic__hi_depth_test_fails__read

/* Compute Metrics Basic set :: Early Depth Test Fails */
#define hsw__compute_basic__early_depth_test_fails__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Killed in FS */
#define hsw__compute_basic__samples_killed_in_ps__read \
   hsw__render_basic__samples_killed_in_ps__read

/* Compute Metrics Basic set :: Alpha Test Fails */
#define hsw__compute_basic__alpha_test_fails__read \
   hsw__render_basic__alpha_test_fails__read

/* Compute Metrics Basic set :: Late Stencil Test Fails */
#define hsw__compute_basic__post_ps_stencil_test_fails__read \
   hsw__render_basic__post_ps_stencil_test_fails__read

/* Compute Metrics Basic set :: Late Depth Test Fails */
#define hsw__compute_basic__post_ps_depth_test_fails__read \
   hsw__render_basic__post_ps_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Written */
#define hsw__compute_basic__samples_written__read \
   hsw__render_basic__samples_written__read

/* Compute Metrics Basic set :: Typed Bytes Read */
static uint64_t
hsw__compute_basic__typed_bytes_read__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ B 5 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];
   uint64_t tmp1 = results->accumulator[query->b_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
static uint64_t
hsw__compute_basic__typed_bytes_written__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 6 READ B 7 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 6];
   uint64_t tmp1 = results->accumulator[query->b_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic set :: Typed Atomics */
static uint64_t
hsw__compute_basic__typed_atomics__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: C 0 READ C 1 READ UADD $EuSlicesTotalCount UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 0];
   uint64_t tmp1 = results->accumulator[query->c_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * perf->sys_vars.n_eu_slices;

   return tmp3;
}

/* Compute Metrics Basic set :: Untyped Bytes Read */
static uint64_t
hsw__compute_basic__untyped_bytes_read__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ B 1 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic set :: Untyped Writes */
static uint64_t
hsw__compute_basic__untyped_bytes_written__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: B 2 READ B 3 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 2];
   uint64_t tmp1 = results->accumulator[query->b_offset + 3];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic set :: SLM Bytes Read */
static uint64_t
hsw__compute_basic__slm_bytes_read__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 6 READ C 7 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 6];
   uint64_t tmp1 = results->accumulator[query->c_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic set :: SLM Bytes Written */
static uint64_t
hsw__compute_basic__slm_bytes_written__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: C 4 READ C 5 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 4];
   uint64_t tmp1 = results->accumulator[query->c_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic set :: LLC GPU Accesses */
#define hsw__compute_basic__llc_accesses__read \
   hsw__render_basic__llc_accesses__read

/* Compute Metrics Basic set :: LLC GPU Hits */
#define hsw__compute_basic__llc_hits__read \
   hsw__render_basic__llc_hits__read

/* Compute Metrics Extended set :: GPU Time Elapsed */
#define hsw__compute_extended__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extended set :: GPU Core Clocks */
static uint64_t
hsw__compute_extended__gpu_clocks__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = results->accumulator[query->b_offset + 7];

   return tmp0;
}

/* Compute Metrics Extended set :: CS Threads Dispatched */
#define hsw__compute_extended__cs_threads__read \
   hsw__render_basic__cs_threads__read

/* Compute Metrics Extended set :: EuUntypedReads0 */
static uint64_t
hsw__compute_extended__eu_untyped_reads0__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];

   return tmp0;
}

/* Compute Metrics Extended set :: EuTypedReads0 */
static uint64_t
hsw__compute_extended__eu_typed_reads0__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = results->accumulator[query->b_offset + 2];

   return tmp0;
}

/* Compute Metrics Extended set :: EuUntypedWrites0 */
static uint64_t
hsw__compute_extended__eu_untyped_writes0__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: B 1 READ */
   uint64_t tmp0 = results->accumulator[query->b_offset + 1];

   return tmp0;
}

/* Compute Metrics Extended set :: EuTypedWrites0 */
static uint64_t
hsw__compute_extended__eu_typed_writes0__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = results->accumulator[query->b_offset + 3];

   return tmp0;
}

/* Compute Metrics Extended set :: EuUntypedAtomics0 */
static uint64_t
hsw__compute_extended__eu_untyped_atomics0__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];

   return tmp0;
}

/* Compute Metrics Extended set :: EuTypedAtomics0 */
static uint64_t
hsw__compute_extended__eu_typed_atomics0__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = results->accumulator[query->b_offset + 5];

   return tmp0;
}

/* Compute Metrics Extended set :: EuUrbAtomics0 */
static uint64_t
hsw__compute_extended__eu_urb_atomics0__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = results->accumulator[query->b_offset + 6];

   return tmp0;
}

/* Compute Metrics Extended set :: Typed Reads 0 */
#define hsw__compute_extended__typed_reads0__read \
   hsw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: Typed Writes 0 */
static uint64_t
hsw__compute_extended__typed_writes0__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: C 0 READ */
   uint64_t tmp0 = results->accumulator[query->c_offset + 0];

   return tmp0;
}

/* Compute Metrics Extended set :: Untyped Reads 0 */
static uint64_t
hsw__compute_extended__untyped_reads0__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: C 3 READ */
   uint64_t tmp0 = results->accumulator[query->c_offset + 3];

   return tmp0;
}

/* Compute Metrics Extended set :: Untyped Writes 0 */
static uint64_t
hsw__compute_extended__untyped_writes0__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: C 1 READ */
   uint64_t tmp0 = results->accumulator[query->c_offset + 1];

   return tmp0;
}

/* Compute Metrics Extended set :: Typed Atomics 0 */
static uint64_t
hsw__compute_extended__typed_atomics0__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = results->accumulator[query->c_offset + 4];

   return tmp0;
}

/* Compute Metrics Extended set :: TypedReadsPerCacheLine */
static float
hsw__compute_extended__typed_reads_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                        const struct intel_perf_query_info *query,
                                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuTypedReads0 $TypedReads0 FDIV */
   double tmp0 = hsw__compute_extended__eu_typed_reads0__read(perf, query, results);
   double tmp1 = hsw__compute_extended__typed_reads0__read(perf, query, results);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended set :: TypedWritesPerCacheLine */
static float
hsw__compute_extended__typed_writes_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                         const struct intel_perf_query_info *query,
                                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuTypedWrites0 $TypedWrites0 FDIV */
   double tmp0 = hsw__compute_extended__eu_typed_writes0__read(perf, query, results);
   double tmp1 = hsw__compute_extended__typed_writes0__read(perf, query, results);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended set :: UntypedReadsPerCacheLine */
static float
hsw__compute_extended__untyped_reads_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                          const struct intel_perf_query_info *query,
                                                          const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuUntypedReads0 $UntypedReads0 FDIV */
   double tmp0 = hsw__compute_extended__eu_untyped_reads0__read(perf, query, results);
   double tmp1 = hsw__compute_extended__untyped_reads0__read(perf, query, results);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended set :: UntypedWritesPerCacheLine */
static float
hsw__compute_extended__untyped_writes_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                           const struct intel_perf_query_info *query,
                                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuUntypedWrites0 $UntypedWrites0 FDIV */
   double tmp0 = hsw__compute_extended__eu_untyped_writes0__read(perf, query, results);
   double tmp1 = hsw__compute_extended__untyped_writes0__read(perf, query, results);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended set :: TypedAtomicsPerCacheLine */
static float
hsw__compute_extended__typed_atomics_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                          const struct intel_perf_query_info *query,
                                                          const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuTypedAtomics0 $TypedAtomics0 FDIV */
   double tmp0 = hsw__compute_extended__eu_typed_atomics0__read(perf, query, results);
   double tmp1 = hsw__compute_extended__typed_atomics0__read(perf, query, results);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended set :: LLC GPU Accesses */
#define hsw__compute_extended__llc_accesses__read \
   hsw__render_basic__llc_accesses__read

/* Compute Metrics Extended set :: LLC GPU Hits */
#define hsw__compute_extended__llc_hits__read \
   hsw__render_basic__llc_hits__read

/* Memory Reads Distribution set :: GPU Time Elapsed */
#define hsw__memory_reads__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Reads Distribution set :: GPU Core Clocks */
static uint64_t
hsw__memory_reads__gpu_core_clocks__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 7 READ */
   uint64_t tmp0 = results->accumulator[query->c_offset + 7];

   return tmp0;
}

/* Memory Reads Distribution set :: AVG GPU Core Frequency */
static uint64_t
hsw__memory_reads__avg_gpu_core_frequency__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__memory_reads__gpu_time__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Memory Reads Distribution set :: AVG GPU Core Frequency */
#define hsw__memory_reads__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Reads Distribution set :: GPU Busy */
static float
hsw__memory_reads__gpu_busy__read(UNUSED struct intel_perf_config *perf,
                                  const struct intel_perf_query_info *query,
                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: A 41 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 41];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Reads Distribution set :: VS Threads Dispatched */
#define hsw__memory_reads__vs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Reads Distribution set :: TCS Threads Dispatched */
#define hsw__memory_reads__hs_threads__read \
   hsw__render_basic__hs_threads__read

/* Memory Reads Distribution set :: TES Threads Dispatched */
#define hsw__memory_reads__ds_threads__read \
   hsw__render_basic__ds_threads__read

/* Memory Reads Distribution set :: GS Threads Dispatched */
#define hsw__memory_reads__gs_threads__read \
   hsw__render_basic__gs_threads__read

/* Memory Reads Distribution set :: FS Threads Dispatched */
#define hsw__memory_reads__ps_threads__read \
   hsw__render_basic__ps_threads__read

/* Memory Reads Distribution set :: CS Threads Dispatched */
#define hsw__memory_reads__cs_threads__read \
   hsw__render_basic__cs_threads__read

/* Memory Reads Distribution set :: EU Active */
static float
hsw__memory_reads__eu_active__read(UNUSED struct intel_perf_config *perf,
                                   const struct intel_perf_query_info *query,
                                   const struct intel_perf_query_result *results)
{
   /* RPN equation: A 0 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: EU Stall */
static float
hsw__memory_reads__eu_stall__read(UNUSED struct intel_perf_config *perf,
                                  const struct intel_perf_query_info *query,
                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: A 1 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 1];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: VS EU Active */
static float
hsw__memory_reads__vs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 2 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 2];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: VS AVG Active per Thread */
#define hsw__memory_reads__vs_eu_active_per_thread__read \
   hsw__render_basic__vs_eu_active_per_thread__read

/* Memory Reads Distribution set :: VS EU Stall */
static float
hsw__memory_reads__vs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 3 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 3];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: VS AVG Stall per Thread */
#define hsw__memory_reads__vs_eu_stall_per_thread__read \
   hsw__render_basic__vs_eu_stall_per_thread__read

/* Memory Reads Distribution set :: TCS EU Active */
static float
hsw__memory_reads__hs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: TCS AVG Active per Thread */
#define hsw__memory_reads__hs_eu_active_per_thread__read \
   hsw__render_basic__hs_eu_active_per_thread__read

/* Memory Reads Distribution set :: TCS EU Stall */
static float
hsw__memory_reads__hs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: TCS AVG Stall per Thread */
#define hsw__memory_reads__hs_eu_stall_per_thread__read \
   hsw__render_basic__hs_eu_stall_per_thread__read

/* Memory Reads Distribution set :: TES EU Active */
static float
hsw__memory_reads__ds_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: TES AVG Active per Thread */
#define hsw__memory_reads__ds_eu_active_per_thread__read \
   hsw__render_basic__ds_eu_active_per_thread__read

/* Memory Reads Distribution set :: TES EU Stall */
static float
hsw__memory_reads__ds_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: TES AVG Stall per Thread */
#define hsw__memory_reads__ds_eu_stall_per_thread__read \
   hsw__render_basic__ds_eu_stall_per_thread__read

/* Memory Reads Distribution set :: GS EU Active */
static float
hsw__memory_reads__gs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 22 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: GS AVG Active per Thread */
#define hsw__memory_reads__gs_eu_active_per_thread__read \
   hsw__render_basic__gs_eu_active_per_thread__read

/* Memory Reads Distribution set :: GS EU Stall */
static float
hsw__memory_reads__gs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 23 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: GS AVG Stall per Thread */
#define hsw__memory_reads__gs_eu_stall_per_thread__read \
   hsw__render_basic__gs_eu_stall_per_thread__read

/* Memory Reads Distribution set :: CS EU Active */
static float
hsw__memory_reads__cs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: CS AVG Active per Thread */
#define hsw__memory_reads__cs_eu_active_per_thread__read \
   hsw__render_basic__cs_eu_active_per_thread__read

/* Memory Reads Distribution set :: CS EU Stall */
static float
hsw__memory_reads__cs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: CS AVG Stall per Thread */
#define hsw__memory_reads__cs_eu_stall_per_thread__read \
   hsw__render_basic__cs_eu_stall_per_thread__read

/* Memory Reads Distribution set :: FS EU Active */
static float
hsw__memory_reads__ps_eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 27 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: FS AVG Active per Thread */
#define hsw__memory_reads__ps_eu_active_per_thread__read \
   hsw__render_basic__ps_eu_active_per_thread__read

/* Memory Reads Distribution set :: FS EU Stall */
static float
hsw__memory_reads__ps_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 28 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution set :: FS AVG Stall per Thread */
#define hsw__memory_reads__ps_eu_stall_per_thread__read \
   hsw__render_basic__ps_eu_stall_per_thread__read

/* Memory Reads Distribution set :: Early Hi-Depth Test Fails */
#define hsw__memory_reads__hi_depth_test_fails__read \
   hsw__render_basic__hi_depth_test_fails__read

/* Memory Reads Distribution set :: Early Depth Test Fails */
#define hsw__memory_reads__early_depth_test_fails__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution set :: Samples Killed in FS */
#define hsw__memory_reads__samples_killed_in_ps__read \
   hsw__render_basic__samples_killed_in_ps__read

/* Memory Reads Distribution set :: Alpha Test Fails */
#define hsw__memory_reads__alpha_test_fails__read \
   hsw__render_basic__alpha_test_fails__read

/* Memory Reads Distribution set :: Late Stencil Test Fails */
#define hsw__memory_reads__post_ps_stencil_test_fails__read \
   hsw__render_basic__post_ps_stencil_test_fails__read

/* Memory Reads Distribution set :: Late Depth Test Fails */
#define hsw__memory_reads__post_ps_depth_test_fails__read \
   hsw__render_basic__post_ps_depth_test_fails__read

/* Memory Reads Distribution set :: Samples Written */
#define hsw__memory_reads__samples_written__read \
   hsw__render_basic__samples_written__read

/* Memory Reads Distribution set :: GtiCmdStreamerMemoryReads */
#define hsw__memory_reads__gti_cmd_streamer_memory_reads__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Reads Distribution set :: GtiRsMemoryReads */
#define hsw__memory_reads__gti_rs_memory_reads__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Reads Distribution set :: GtiVfMemoryReads */
#define hsw__memory_reads__gti_vf_memory_reads__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Memory Reads Distribution set :: GtiRccMemoryReads */
#define hsw__memory_reads__gti_rcc_memory_reads__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Reads Distribution set :: GtiMscMemoryReads */
#define hsw__memory_reads__gti_msc_memory_reads__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Reads Distribution set :: GtiHiDepthMemoryReads */
#define hsw__memory_reads__gti_hi_depth_memory_reads__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Reads Distribution set :: GtiStcMemoryReads */
#define hsw__memory_reads__gti_stc_memory_reads__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Reads Distribution set :: GtiRczMemoryReads */
#define hsw__memory_reads__gti_rcz_memory_reads__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Reads Distribution set :: GtiL3Reads */
#define hsw__memory_reads__gti_l3_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Reads Distribution set :: GtiMemoryReads */
static uint64_t
hsw__memory_reads__gti_memory_reads__read(UNUSED struct intel_perf_config *perf,
                                          const struct intel_perf_query_info *query,
                                          const struct intel_perf_query_result *results)
{
   /* RPN equation: C 5 READ */
   uint64_t tmp0 = results->accumulator[query->c_offset + 5];

   return tmp0;
}

/* Memory Reads Distribution set :: LLC GPU Read Accesses */
static uint64_t
hsw__memory_reads__llc_read_accesses__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: C 6 READ */
   uint64_t tmp0 = results->accumulator[query->c_offset + 6];

   return tmp0;
}

/* Memory Reads Distribution set :: LLC GPU Accesses */
#define hsw__memory_reads__llc_accesses__read \
   hsw__render_basic__llc_accesses__read

/* Memory Reads Distribution set :: LLC GPU Hits */
#define hsw__memory_reads__llc_hits__read \
   hsw__render_basic__llc_hits__read

/* Memory Writes Distribution set :: GPU Time Elapsed */
#define hsw__memory_writes__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Writes Distribution set :: GPU Core Clocks */
#define hsw__memory_writes__gpu_core_clocks__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Writes Distribution set :: AVG GPU Core Frequency */
#define hsw__memory_writes__avg_gpu_core_frequency__read \
   hsw__memory_reads__avg_gpu_core_frequency__read

/* Memory Writes Distribution set :: AVG GPU Core Frequency */
#define hsw__memory_writes__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Writes Distribution set :: GPU Busy */
#define hsw__memory_writes__gpu_busy__read \
   hsw__memory_reads__gpu_busy__read

/* Memory Writes Distribution set :: VS Threads Dispatched */
#define hsw__memory_writes__vs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Writes Distribution set :: TCS Threads Dispatched */
#define hsw__memory_writes__hs_threads__read \
   hsw__render_basic__hs_threads__read

/* Memory Writes Distribution set :: TES Threads Dispatched */
#define hsw__memory_writes__ds_threads__read \
   hsw__render_basic__ds_threads__read

/* Memory Writes Distribution set :: GS Threads Dispatched */
#define hsw__memory_writes__gs_threads__read \
   hsw__render_basic__gs_threads__read

/* Memory Writes Distribution set :: FS Threads Dispatched */
#define hsw__memory_writes__ps_threads__read \
   hsw__render_basic__ps_threads__read

/* Memory Writes Distribution set :: CS Threads Dispatched */
#define hsw__memory_writes__cs_threads__read \
   hsw__render_basic__cs_threads__read

/* Memory Writes Distribution set :: EU Active */
#define hsw__memory_writes__eu_active__read \
   hsw__memory_reads__eu_active__read

/* Memory Writes Distribution set :: EU Stall */
#define hsw__memory_writes__eu_stall__read \
   hsw__memory_reads__eu_stall__read

/* Memory Writes Distribution set :: VS EU Active */
#define hsw__memory_writes__vs_eu_active__read \
   hsw__memory_reads__vs_eu_active__read

/* Memory Writes Distribution set :: VS AVG Active per Thread */
#define hsw__memory_writes__vs_eu_active_per_thread__read \
   hsw__render_basic__vs_eu_active_per_thread__read

/* Memory Writes Distribution set :: VS EU Stall */
#define hsw__memory_writes__vs_eu_stall__read \
   hsw__memory_reads__vs_eu_stall__read

/* Memory Writes Distribution set :: VS AVG Stall per Thread */
#define hsw__memory_writes__vs_eu_stall_per_thread__read \
   hsw__render_basic__vs_eu_stall_per_thread__read

/* Memory Writes Distribution set :: TCS EU Active */
#define hsw__memory_writes__hs_eu_active__read \
   hsw__memory_reads__hs_eu_active__read

/* Memory Writes Distribution set :: TCS AVG Active per Thread */
#define hsw__memory_writes__hs_eu_active_per_thread__read \
   hsw__render_basic__hs_eu_active_per_thread__read

/* Memory Writes Distribution set :: TCS EU Stall */
#define hsw__memory_writes__hs_eu_stall__read \
   hsw__memory_reads__hs_eu_stall__read

/* Memory Writes Distribution set :: TCS AVG Stall per Thread */
#define hsw__memory_writes__hs_eu_stall_per_thread__read \
   hsw__render_basic__hs_eu_stall_per_thread__read

/* Memory Writes Distribution set :: TES EU Active */
#define hsw__memory_writes__ds_eu_active__read \
   hsw__memory_reads__ds_eu_active__read

/* Memory Writes Distribution set :: TES AVG Active per Thread */
#define hsw__memory_writes__ds_eu_active_per_thread__read \
   hsw__render_basic__ds_eu_active_per_thread__read

/* Memory Writes Distribution set :: TES EU Stall */
#define hsw__memory_writes__ds_eu_stall__read \
   hsw__memory_reads__ds_eu_stall__read

/* Memory Writes Distribution set :: TES AVG Stall per Thread */
#define hsw__memory_writes__ds_eu_stall_per_thread__read \
   hsw__render_basic__ds_eu_stall_per_thread__read

/* Memory Writes Distribution set :: GS EU Active */
#define hsw__memory_writes__gs_eu_active__read \
   hsw__memory_reads__gs_eu_active__read

/* Memory Writes Distribution set :: GS AVG Active per Thread */
#define hsw__memory_writes__gs_eu_active_per_thread__read \
   hsw__render_basic__gs_eu_active_per_thread__read

/* Memory Writes Distribution set :: GS EU Stall */
#define hsw__memory_writes__gs_eu_stall__read \
   hsw__memory_reads__gs_eu_stall__read

/* Memory Writes Distribution set :: GS AVG Stall per Thread */
#define hsw__memory_writes__gs_eu_stall_per_thread__read \
   hsw__render_basic__gs_eu_stall_per_thread__read

/* Memory Writes Distribution set :: CS EU Active */
#define hsw__memory_writes__cs_eu_active__read \
   hsw__memory_reads__cs_eu_active__read

/* Memory Writes Distribution set :: CS AVG Active per Thread */
#define hsw__memory_writes__cs_eu_active_per_thread__read \
   hsw__render_basic__cs_eu_active_per_thread__read

/* Memory Writes Distribution set :: CS EU Stall */
#define hsw__memory_writes__cs_eu_stall__read \
   hsw__memory_reads__cs_eu_stall__read

/* Memory Writes Distribution set :: CS AVG Stall per Thread */
#define hsw__memory_writes__cs_eu_stall_per_thread__read \
   hsw__render_basic__cs_eu_stall_per_thread__read

/* Memory Writes Distribution set :: FS EU Active */
#define hsw__memory_writes__ps_eu_active__read \
   hsw__memory_reads__ps_eu_active__read

/* Memory Writes Distribution set :: FS AVG Active per Thread */
#define hsw__memory_writes__ps_eu_active_per_thread__read \
   hsw__render_basic__ps_eu_active_per_thread__read

/* Memory Writes Distribution set :: FS EU Stall */
#define hsw__memory_writes__ps_eu_stall__read \
   hsw__memory_reads__ps_eu_stall__read

/* Memory Writes Distribution set :: FS AVG Stall per Thread */
#define hsw__memory_writes__ps_eu_stall_per_thread__read \
   hsw__render_basic__ps_eu_stall_per_thread__read

/* Memory Writes Distribution set :: Early Hi-Depth Test Fails */
#define hsw__memory_writes__hi_depth_test_fails__read \
   hsw__render_basic__hi_depth_test_fails__read

/* Memory Writes Distribution set :: Early Depth Test Fails */
#define hsw__memory_writes__early_depth_test_fails__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution set :: Samples Killed in FS */
#define hsw__memory_writes__samples_killed_in_ps__read \
   hsw__render_basic__samples_killed_in_ps__read

/* Memory Writes Distribution set :: Alpha Test Fails */
#define hsw__memory_writes__alpha_test_fails__read \
   hsw__render_basic__alpha_test_fails__read

/* Memory Writes Distribution set :: Late Stencil Test Fails */
#define hsw__memory_writes__post_ps_stencil_test_fails__read \
   hsw__render_basic__post_ps_stencil_test_fails__read

/* Memory Writes Distribution set :: Late Depth Test Fails */
#define hsw__memory_writes__post_ps_depth_test_fails__read \
   hsw__render_basic__post_ps_depth_test_fails__read

/* Memory Writes Distribution set :: Samples Written */
#define hsw__memory_writes__samples_written__read \
   hsw__render_basic__samples_written__read

/* Memory Writes Distribution set :: GtiCmdStreamerMemoryWrites */
#define hsw__memory_writes__gti_cmd_streamer_memory_writes__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Writes Distribution set :: GtiSoMemoryWrites */
#define hsw__memory_writes__gti_so_memory_writes__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Writes Distribution set :: GtiRccMemoryWrites */
#define hsw__memory_writes__gti_rcc_memory_writes__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Writes Distribution set :: GtiMscMemoryWrites */
#define hsw__memory_writes__gti_msc_memory_writes__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Writes Distribution set :: GtiHizMemoryWrites */
#define hsw__memory_writes__gti_hiz_memory_writes__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Writes Distribution set :: GtiStcMemoryWrites */
#define hsw__memory_writes__gti_stc_memory_writes__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Writes Distribution set :: GtiRczMemoryWrites */
#define hsw__memory_writes__gti_rcz_memory_writes__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Writes Distribution set :: GtiL3Writes */
#define hsw__memory_writes__gti_l3_writes__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Writes Distribution set :: GtiMemoryWrites */
#define hsw__memory_writes__gti_memory_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Writes Distribution set :: LLC GPU Write Accesses */
static uint64_t
hsw__memory_writes__llc_wr_accesses__read(UNUSED struct intel_perf_config *perf,
                                          const struct intel_perf_query_info *query,
                                          const struct intel_perf_query_result *results)
{
   /* RPN equation: C 6 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Memory Writes Distribution set :: LLC GPU Accesses */
#define hsw__memory_writes__llc_accesses__read \
   hsw__render_basic__llc_accesses__read

/* Memory Writes Distribution set :: LLC GPU Hits */
#define hsw__memory_writes__llc_hits__read \
   hsw__render_basic__llc_hits__read

/* Memory Writes Distribution set :: LLC GPU Throughput */
static uint64_t
hsw__memory_writes__llc_gpu_throughput__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: PERFCNT 0 READ $LlcWrAccesses USUB 64 UMUL $LlcWrAccesses 32 UMUL UADD */
   uint64_t tmp0 = results->accumulator[query->perfcnt_offset + 0];
   uint64_t tmp1 = tmp0 - hsw__memory_writes__llc_wr_accesses__read(perf, query, results);
   uint64_t tmp2 = tmp1 * 64;
   uint64_t tmp3 = hsw__memory_writes__llc_wr_accesses__read(perf, query, results) * 32;
   uint64_t tmp4 = tmp2 + tmp3;

   return tmp4;
}

/* Metric set SamplerBalance :: GPU Time Elapsed */
#define hsw__sampler_balance__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set SamplerBalance :: GPU Core Clocks */
#define hsw__sampler_balance__gpu_core_clocks__read \
   hsw__compute_extended__gpu_clocks__read

/* Metric set SamplerBalance :: AVG GPU Core Frequency */
static uint64_t
hsw__sampler_balance__avg_gpu_core_frequency__read(UNUSED struct intel_perf_config *perf,
                                                   const struct intel_perf_query_info *query,
                                                   const struct intel_perf_query_result *results)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = hsw__sampler_balance__gpu_time__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set SamplerBalance :: AVG GPU Core Frequency */
#define hsw__sampler_balance__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set SamplerBalance :: GPU Busy */
static float
hsw__sampler_balance__gpu_busy__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 41 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 41];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set SamplerBalance :: VS Threads Dispatched */
#define hsw__sampler_balance__vs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set SamplerBalance :: TCS Threads Dispatched */
#define hsw__sampler_balance__hs_threads__read \
   hsw__render_basic__hs_threads__read

/* Metric set SamplerBalance :: TES Threads Dispatched */
#define hsw__sampler_balance__ds_threads__read \
   hsw__render_basic__ds_threads__read

/* Metric set SamplerBalance :: GS Threads Dispatched */
#define hsw__sampler_balance__gs_threads__read \
   hsw__render_basic__gs_threads__read

/* Metric set SamplerBalance :: FS Threads Dispatched */
#define hsw__sampler_balance__ps_threads__read \
   hsw__render_basic__ps_threads__read

/* Metric set SamplerBalance :: CS Threads Dispatched */
#define hsw__sampler_balance__cs_threads__read \
   hsw__render_basic__cs_threads__read

/* Metric set SamplerBalance :: EU Active */
static float
hsw__sampler_balance__eu_active__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 0 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: EU Stall */
static float
hsw__sampler_balance__eu_stall__read(UNUSED struct intel_perf_config *perf,
                                     const struct intel_perf_query_info *query,
                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: A 1 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 1];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: VS EU Active */
static float
hsw__sampler_balance__vs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 2 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 2];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: VS AVG Active per Thread */
#define hsw__sampler_balance__vs_eu_active_per_thread__read \
   hsw__render_basic__vs_eu_active_per_thread__read

/* Metric set SamplerBalance :: VS EU Stall */
static float
hsw__sampler_balance__vs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 3 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 3];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: VS AVG Stall per Thread */
#define hsw__sampler_balance__vs_eu_stall_per_thread__read \
   hsw__render_basic__vs_eu_stall_per_thread__read

/* Metric set SamplerBalance :: TCS EU Active */
static float
hsw__sampler_balance__hs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: TCS AVG Active per Thread */
#define hsw__sampler_balance__hs_eu_active_per_thread__read \
   hsw__render_basic__hs_eu_active_per_thread__read

/* Metric set SamplerBalance :: TCS EU Stall */
static float
hsw__sampler_balance__hs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: TCS AVG Stall per Thread */
#define hsw__sampler_balance__hs_eu_stall_per_thread__read \
   hsw__render_basic__hs_eu_stall_per_thread__read

/* Metric set SamplerBalance :: TES EU Active */
static float
hsw__sampler_balance__ds_eu_active__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: TES AVG Active per Thread */
#define hsw__sampler_balance__ds_eu_active_per_thread__read \
   hsw__render_basic__ds_eu_active_per_thread__read

/* Metric set SamplerBalance :: TES EU Stall */
static float
hsw__sampler_balance__ds_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: TES AVG Stall per Thread */
#define hsw__sampler_balance__ds_eu_stall_per_thread__read \
   hsw__render_basic__ds_eu_stall_per_thread__read

/* Metric set SamplerBalance :: GS EU Active */
static float
hsw__sampler_balance__gs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 22 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: GS AVG Active per Thread */
#define hsw__sampler_balance__gs_eu_active_per_thread__read \
   hsw__render_basic__gs_eu_active_per_thread__read

/* Metric set SamplerBalance :: GS EU Stall */
static float
hsw__sampler_balance__gs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 23 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: GS AVG Stall per Thread */
#define hsw__sampler_balance__gs_eu_stall_per_thread__read \
   hsw__render_basic__gs_eu_stall_per_thread__read

/* Metric set SamplerBalance :: CS EU Active */
static float
hsw__sampler_balance__cs_eu_active__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: CS AVG Active per Thread */
#define hsw__sampler_balance__cs_eu_active_per_thread__read \
   hsw__render_basic__cs_eu_active_per_thread__read

/* Metric set SamplerBalance :: CS EU Stall */
static float
hsw__sampler_balance__cs_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: CS AVG Stall per Thread */
#define hsw__sampler_balance__cs_eu_stall_per_thread__read \
   hsw__render_basic__cs_eu_stall_per_thread__read

/* Metric set SamplerBalance :: FS EU Active */
static float
hsw__sampler_balance__ps_eu_active__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 27 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: FS AVG Active per Thread */
#define hsw__sampler_balance__ps_eu_active_per_thread__read \
   hsw__render_basic__ps_eu_active_per_thread__read

/* Metric set SamplerBalance :: FS EU Stall */
static float
hsw__sampler_balance__ps_eu_stall__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 28 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set SamplerBalance :: FS AVG Stall per Thread */
#define hsw__sampler_balance__ps_eu_stall_per_thread__read \
   hsw__render_basic__ps_eu_stall_per_thread__read

/* Metric set SamplerBalance :: Early Hi-Depth Test Fails */
#define hsw__sampler_balance__hi_depth_test_fails__read \
   hsw__render_basic__hi_depth_test_fails__read

/* Metric set SamplerBalance :: Early Depth Test Fails */
#define hsw__sampler_balance__early_depth_test_fails__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set SamplerBalance :: Samples Killed in FS */
#define hsw__sampler_balance__samples_killed_in_ps__read \
   hsw__render_basic__samples_killed_in_ps__read

/* Metric set SamplerBalance :: Alpha Test Fails */
#define hsw__sampler_balance__alpha_test_fails__read \
   hsw__render_basic__alpha_test_fails__read

/* Metric set SamplerBalance :: Late Stencil Test Fails */
#define hsw__sampler_balance__post_ps_stencil_test_fails__read \
   hsw__render_basic__post_ps_stencil_test_fails__read

/* Metric set SamplerBalance :: Late Depth Test Fails */
#define hsw__sampler_balance__post_ps_depth_test_fails__read \
   hsw__render_basic__post_ps_depth_test_fails__read

/* Metric set SamplerBalance :: Samples Written */
#define hsw__sampler_balance__samples_written__read \
   hsw__render_basic__samples_written__read

/* Metric set SamplerBalance :: FS Duration */
static uint64_t
hsw__sampler_balance__ps_duration__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 27 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 28 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 27];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 28];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Metric set SamplerBalance :: VS Duration */
static uint64_t
hsw__sampler_balance__vs_duration__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 2 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 3 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 2];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 3];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Metric set SamplerBalance :: GS Duration */
static uint64_t
hsw__sampler_balance__gs_duration__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 22 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 23 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 22];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 23];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Metric set SamplerBalance :: TES Duration */
static uint64_t
hsw__sampler_balance__ds_duration__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 12 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 13 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 12];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 13];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Metric set SamplerBalance :: TCS Duration */
static uint64_t
hsw__sampler_balance__hs_duration__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 7 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 8 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 7];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 8];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Metric set SamplerBalance :: CS Duration */
static uint64_t
hsw__sampler_balance__cs_duration__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 17 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 18 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 17];
   uint64_t tmp1 = results->accumulator[query->a_offset + 0];
   uint64_t tmp2 = tmp0 * tmp1;
   uint64_t tmp3 = results->accumulator[query->a_offset + 2];
   uint64_t tmp4 = results->accumulator[query->a_offset + 7];
   uint64_t tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->a_offset + 12];
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->a_offset + 17];
   uint64_t tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->a_offset + 22];
   uint64_t tmp11 = tmp9 + tmp10;
   uint64_t tmp12 = results->accumulator[query->a_offset + 27];
   uint64_t tmp13 = tmp11 + tmp12;
   uint64_t tmp14 = tmp2;
   uint64_t tmp15 = tmp13;
   uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
   uint64_t tmp17 = results->accumulator[query->a_offset + 18];
   uint64_t tmp18 = results->accumulator[query->a_offset + 1];
   uint64_t tmp19 = tmp17 * tmp18;
   uint64_t tmp20 = results->accumulator[query->a_offset + 3];
   uint64_t tmp21 = results->accumulator[query->a_offset + 8];
   uint64_t tmp22 = tmp20 + tmp21;
   uint64_t tmp23 = results->accumulator[query->a_offset + 13];
   uint64_t tmp24 = tmp22 + tmp23;
   uint64_t tmp25 = results->accumulator[query->a_offset + 18];
   uint64_t tmp26 = tmp24 + tmp25;
   uint64_t tmp27 = results->accumulator[query->a_offset + 23];
   uint64_t tmp28 = tmp26 + tmp27;
   uint64_t tmp29 = results->accumulator[query->a_offset + 28];
   uint64_t tmp30 = tmp28 + tmp29;
   uint64_t tmp31 = tmp19;
   uint64_t tmp32 = tmp30;
   uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
   uint64_t tmp34 = tmp16 + tmp33;
   uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, query, results);
   uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, query, results) * perf->sys_vars.n_eus;
   uint64_t tmp37 = tmp36 * 1000;
   uint64_t tmp38 = tmp35;
   uint64_t tmp39 = tmp37;
   uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

   return tmp40;
}

/* Metric set SamplerBalance :: EU Idle */
static float
hsw__sampler_balance__eu_idle__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: 100 $EuActive $EuStall FADD FSUB */
   double tmp0 = hsw__sampler_balance__eu_active__read(perf, query, results) + hsw__sampler_balance__eu_stall__read(perf, query, results);
   double tmp1 = 100 - tmp0;

   return tmp1;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses */
static uint64_t
hsw__sampler_balance__sampler_l2_cache_misses__read(UNUSED struct intel_perf_config *perf,
                                                    const struct intel_perf_query_info *query,
                                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: C 7 READ C 6 READ UADD C 5 READ UADD C 4 READ UADD C 3 READ UADD C 2 READ UADD C 1 READ UADD C 0 READ UADD */
   uint64_t tmp0 = results->accumulator[query->c_offset + 7];
   uint64_t tmp1 = results->accumulator[query->c_offset + 6];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = results->accumulator[query->c_offset + 5];
   uint64_t tmp4 = tmp2 + tmp3;
   uint64_t tmp5 = results->accumulator[query->c_offset + 4];
   uint64_t tmp6 = tmp4 + tmp5;
   uint64_t tmp7 = results->accumulator[query->c_offset + 3];
   uint64_t tmp8 = tmp6 + tmp7;
   uint64_t tmp9 = results->accumulator[query->c_offset + 2];
   uint64_t tmp10 = tmp8 + tmp9;
   uint64_t tmp11 = results->accumulator[query->c_offset + 1];
   uint64_t tmp12 = tmp10 + tmp11;
   uint64_t tmp13 = results->accumulator[query->c_offset + 0];
   uint64_t tmp14 = tmp12 + tmp13;

   return tmp14;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses (ss0) */
static uint64_t
hsw__sampler_balance__sampler0_l2_cache_misses__read(UNUSED struct intel_perf_config *perf,
                                                     const struct intel_perf_query_info *query,
                                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: C 7 READ C 6 READ UADD */
   uint64_t tmp0 = results->accumulator[query->c_offset + 7];
   uint64_t tmp1 = results->accumulator[query->c_offset + 6];
   uint64_t tmp2 = tmp0 + tmp1;

   return tmp2;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses (ss1) */
static uint64_t
hsw__sampler_balance__sampler1_l2_cache_misses__read(UNUSED struct intel_perf_config *perf,
                                                     const struct intel_perf_query_info *query,
                                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: C 5 READ C 4 READ UADD */
   uint64_t tmp0 = results->accumulator[query->c_offset + 5];
   uint64_t tmp1 = results->accumulator[query->c_offset + 4];
   uint64_t tmp2 = tmp0 + tmp1;

   return tmp2;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses (ss2) */
static uint64_t
hsw__sampler_balance__sampler2_l2_cache_misses__read(UNUSED struct intel_perf_config *perf,
                                                     const struct intel_perf_query_info *query,
                                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: C 3 READ C 2 READ UADD */
   uint64_t tmp0 = results->accumulator[query->c_offset + 3];
   uint64_t tmp1 = results->accumulator[query->c_offset + 2];
   uint64_t tmp2 = tmp0 + tmp1;

   return tmp2;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses (ss3) */
static uint64_t
hsw__sampler_balance__sampler3_l2_cache_misses__read(UNUSED struct intel_perf_config *perf,
                                                     const struct intel_perf_query_info *query,
                                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: C 1 READ C 0 READ UADD */
   uint64_t tmp0 = results->accumulator[query->c_offset + 1];
   uint64_t tmp1 = results->accumulator[query->c_offset + 0];
   uint64_t tmp2 = tmp0 + tmp1;

   return tmp2;
}

/* Metric set SamplerBalance :: LLC GPU Accesses */
#define hsw__sampler_balance__llc_accesses__read \
   hsw__render_basic__llc_accesses__read

/* Metric set SamplerBalance :: LLC GPU Hits */
#define hsw__sampler_balance__llc_hits__read \
   hsw__render_basic__llc_hits__read

/* Render Metrics Basic set :: GPU Time Elapsed */
#define bdw__render_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics Basic set :: GPU Core Clocks */
static uint64_t
bdw__render_basic__gpu_core_clocks__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = results->accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
static uint64_t
bdw__render_basic__avg_gpu_core_frequency__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = bdw__render_basic__gpu_core_clocks__read(perf, query, results) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = bdw__render_basic__gpu_time__read(perf, query, results);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define bdw__render_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics Basic set :: VS Threads Dispatched */
static uint64_t
bdw__render_basic__vs_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 1];

   return tmp0;
}

/* Render Metrics Basic set :: HS Threads Dispatched */
static uint64_t
bdw__render_basic__hs_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 2];

   return tmp0;
}

/* Render Metrics Basic set :: DS Threads Dispatched */
static uint64_t
bdw__render_basic__ds_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 3];

   return tmp0;
}

/* Render Metrics Basic set :: GS Threads Dispatched */
#define bdw__render_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics Basic set :: FS Threads Dispatched */
static uint64_t
bdw__render_basic__ps_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 6];

   return tmp0;
}

/* Render Metrics Basic set :: CS Threads Dispatched */
static uint64_t
bdw__render_basic__cs_threads__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 4];

   return tmp0;
}

/* Render Metrics Basic set :: GPU Busy */
static float
bdw__render_basic__gpu_busy__read(UNUSED struct intel_perf_config *perf,
                                  const struct intel_perf_query_info *query,
                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: EU Active */
static float
bdw__render_basic__eu_active__read(UNUSED struct intel_perf_config *perf,
                                   const struct intel_perf_query_info *query,
                                   const struct intel_perf_query_result *results)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: EU Stall */
static float
bdw__render_basic__eu_stall__read(UNUSED struct intel_perf_config *perf,
                                  const struct intel_perf_query_info *query,
                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
static float
bdw__render_basic__eu_fpu_both_active__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
static float
bdw__render_basic__vs_fpu0_active__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
static float
bdw__render_basic__vs_fpu1_active__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: VS Send Pipe Active */
static float
bdw__render_basic__vs_send_active__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
static float
bdw__render_basic__ps_fpu0_active__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
static float
bdw__render_basic__ps_fpu1_active__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: PS Send Pipeline Active */
static float
bdw__render_basic__ps_send_active__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: FS Both FPU Active */
static float
bdw__render_basic__ps_eu_both_fpu_active__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic set :: Sampler 0 Busy */
static float
bdw__render_basic__sampler0_busy__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: Sampler 1 Busy */
static float
bdw__render_basic__sampler1_busy__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: Samplers Busy */
static float
bdw__render_basic__samplers_busy__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: $Sampler0Busy $Sampler1Busy FMAX */
   double tmp0 = bdw__render_basic__sampler0_busy__read(perf, query, results);
   double tmp1 = bdw__render_basic__sampler1_busy__read(perf, query, results);
   double tmp2 = MAX(tmp0, tmp1);

   return tmp2;
}

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
static float
bdw__render_basic__sampler0_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
static float
bdw__render_basic__sampler1_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic set :: Samples Written */
static uint64_t
bdw__render_basic__samples_written__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Samples Blended */
static uint64_t
bdw__render_basic__samples_blended__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Sampler Texels */
static uint64_t
bdw__render_basic__sampler_texels__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Sampler Texels Misses */
static uint64_t
bdw__render_basic__sampler_texel_misses__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Sampler Cache Misses */
static uint64_t
bdw__render_basic__sampler_l1_misses__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ B 5 READ UADD 8 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];
   uint64_t tmp1 = results->accumulator[query->b_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 8;

   return tmp3;
}

/* Render Metrics Basic set :: Rasterized Pixels */
static uint64_t
bdw__render_basic__rasterized_pixels__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
static uint64_t
bdw__render_basic__hi_depth_test_fails__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Early Depth Test Fails */
static uint64_t
bdw__render_basic__early_depth_test_fails__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Samples Killed in FS */
static uint64_t
bdw__render_basic__samples_killed_in_ps__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: Pixels Failing Tests */
static uint64_t
bdw__render_basic__pixels_failing_post_ps_tests__read(UNUSED struct intel_perf_config *perf,
                                                      const struct intel_perf_query_info *query,
                                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Read */
static uint64_t
bdw__render_basic__slm_bytes_read__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Written */
static uint64_t
bdw__render_basic__slm_bytes_written__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: Shader Memory Accesses */
static uint64_t
bdw__render_basic__shader_memory_accesses__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 32];

   return tmp0;
}

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
static uint64_t
bdw__render_basic__shader_atomics__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 34];

   return tmp0;
}

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
static uint64_t
bdw__render_basic__l3_lookups__read(UNUSED struct intel_perf_config *perf,
                                    const struct intel_perf_query_info *query,
                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
   uint64_t tmp0 = bdw__render_basic__sampler_l1_misses__read(perf, query, results) + bdw__render_basic__shader_memory_accesses__read(perf, query, results);

   return tmp0;
}

/* Render Metrics Basic set :: L3 Misses */
#define bdw__render_basic__l3_misses__read \
   hsw__compute_extended__typed_atomics0__read

/* Render Metrics Basic set :: L3 Sampler Throughput */
static uint64_t
bdw__render_basic__l3_sampler_throughput__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: $SamplerL1Misses 64 UMUL */
   uint64_t tmp0 = bdw__render_basic__sampler_l1_misses__read(perf, query, results) * 64;

   return tmp0;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
static uint64_t
bdw__render_basic__l3_shader_throughput__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses UADD UADD 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 30];
   uint64_t tmp1 = results->accumulator[query->a_offset + 31];
   uint64_t tmp2 = tmp1 + bdw__render_basic__shader_memory_accesses__read(perf, query, results);
   uint64_t tmp3 = tmp0 + tmp2;
   uint64_t tmp4 = tmp3 * 64;

   return tmp4;
}

/* Render Metrics Basic set :: Shader Barrier Messages */
#define bdw__render_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
static uint64_t
bdw__render_basic__gti_vf_throughput__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: B 6 READ B 7 READ UADD 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 6];
   uint64_t tmp1 = results->accumulator[query->b_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic set :: GTI Depth Throughput */
static uint64_t
bdw__render_basic__gti_depth_throughput__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: C 0 READ C 1 READ UADD 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 0];
   uint64_t tmp1 = results->accumulator[query->c_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic set :: GTI RCC Throughput */
static uint64_t
bdw__render_basic__gti_rcc_throughput__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: C 2 READ C 3 READ UADD 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 2];
   uint64_t tmp1 = results->accumulator[query->c_offset + 3];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic set :: GTI L3 Throughput */
#define bdw__render_basic__gti_l3_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Render Metrics Basic set :: GTI HDC TLB Lookup Throughput */
static uint64_t
bdw__render_basic__gti_hdc_lookups_throughput__read(UNUSED struct intel_perf_config *perf,
                                                    const struct intel_perf_query_info *query,
                                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: C 5 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: GTI Read Throughput */
static uint64_t
bdw__render_basic__gti_read_throughput__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: C 6 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: GTI Write Throughput */
#define bdw__render_basic__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Render Metrics Basic set :: Samplers Bottleneck */
static float
bdw__render_basic__sampler_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: $Sampler0Bottleneck $Sampler1Bottleneck FMAX */
   double tmp0 = bdw__render_basic__sampler0_bottleneck__read(perf, query, results);
   double tmp1 = bdw__render_basic__sampler1_bottleneck__read(perf, query, results);
   double tmp2 = MAX(tmp0, tmp1);

   return tmp2;
}

/* Compute Metrics Basic set :: GPU Time Elapsed */
#define bdw__compute_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Basic set :: GPU Core Clocks */
#define bdw__compute_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define bdw__compute_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define bdw__compute_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Basic set :: GPU Busy */
#define bdw__compute_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics Basic set :: VS Threads Dispatched */
#define bdw__compute_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: HS Threads Dispatched */
#define bdw__compute_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics Basic set :: DS Threads Dispatched */
#define bdw__compute_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics Basic set :: GS Threads Dispatched */
#define bdw__compute_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: FS Threads Dispatched */
#define bdw__compute_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics Basic set :: CS Threads Dispatched */
#define bdw__compute_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Basic set :: EU Active */
#define bdw__compute_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Basic set :: EU Stall */
#define bdw__compute_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Basic set :: EU Both FPU Pipes Active */
#define bdw__compute_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Basic set :: EU FPU0 Pipe Active */
#define bdw__compute_basic__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Basic set :: EU FPU1 Pipe Active */
#define bdw__compute_basic__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Basic set :: EU AVG IPC Rate */
static float
bdw__compute_basic__eu_avg_ipc_rate__read(UNUSED struct intel_perf_config *perf,
                                          const struct intel_perf_query_info *query,
                                          const struct intel_perf_query_result *results)
{
   /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
   uint64_t tmp0 = results->accumulator[query->a_offset + 9];
   uint64_t tmp1 = results->accumulator[query->a_offset + 10];
   uint64_t tmp2 = results->accumulator[query->a_offset + 11];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = results->accumulator[query->a_offset + 9];
   uint64_t tmp5 = tmp3 - tmp4;
   double tmp6 = tmp0;
   double tmp7 = tmp5;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 + 1;

   return tmp9;
}

/* Compute Metrics Basic set :: EU Send Pipe Active */
#define bdw__compute_basic__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Basic set :: EU Thread Occupancy */
static float
bdw__compute_basic__eu_thread_occupancy__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: A 13 READ 8 UMUL $EuCoresTotalCount UDIV $EuThreadsCount UDIV 100 UMUL  $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0 * 8;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = perf->sys_vars.n_eus;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = perf->sys_vars.eu_threads_count;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = bdw__compute_basic__gpu_core_clocks__read(perf, query, results);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* Compute Metrics Basic set :: Rasterized Pixels */
#define bdw__compute_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics Basic set :: Early Hi-Depth Test Fails */
#define bdw__compute_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics Basic set :: Early Depth Test Fails */
#define bdw__compute_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Killed in FS */
#define bdw__compute_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics Basic set :: Pixels Failing Tests */
#define bdw__compute_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics Basic set :: Samples Written */
#define bdw__compute_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics Basic set :: Samples Blended */
#define bdw__compute_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics Basic set :: Sampler Texels */
#define bdw__compute_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Basic set :: Sampler Texels Misses */
#define bdw__compute_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Basic set :: SLM Bytes Read */
#define bdw__compute_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Basic set :: SLM Bytes Written */
#define bdw__compute_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Basic set :: Shader Memory Accesses */
#define bdw__compute_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Basic set :: Shader Atomic Memory Accesses */
#define bdw__compute_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Basic set :: L3 Shader Throughput */
#define bdw__compute_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Basic set :: Shader Barrier Messages */
#define bdw__compute_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Typed Bytes Read */
static uint64_t
bdw__compute_basic__typed_bytes_read__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ B 1 READ B 2 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 1];
   uint64_t tmp2 = results->accumulator[query->b_offset + 2];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;
   uint64_t tmp5 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp6 = tmp4 * tmp5;

   return tmp6;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
static uint64_t
bdw__compute_basic__typed_bytes_written__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 3 READ B 4 READ B 5 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 3];
   uint64_t tmp1 = results->accumulator[query->b_offset + 4];
   uint64_t tmp2 = results->accumulator[query->b_offset + 5];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;
   uint64_t tmp5 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp6 = tmp4 * tmp5;

   return tmp6;
}

/* Compute Metrics Basic set :: Untyped Bytes Read */
static uint64_t
bdw__compute_basic__untyped_bytes_read__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 6 READ B 7 READ C 0 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 6];
   uint64_t tmp1 = results->accumulator[query->b_offset + 7];
   uint64_t tmp2 = results->accumulator[query->c_offset + 0];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;
   uint64_t tmp5 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp6 = tmp4 * tmp5;

   return tmp6;
}

/* Compute Metrics Basic set :: Untyped Writes */
static uint64_t
bdw__compute_basic__untyped_bytes_written__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: C 1 READ C 2 READ C 3 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 1];
   uint64_t tmp1 = results->accumulator[query->c_offset + 2];
   uint64_t tmp2 = results->accumulator[query->c_offset + 3];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;
   uint64_t tmp5 = perf->sys_vars.n_eu_slices * 64;
   uint64_t tmp6 = tmp4 * tmp5;

   return tmp6;
}

/* Compute Metrics Basic set :: GTI Read Throughput */
#define bdw__compute_basic__gti_read_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Compute Metrics Basic set :: GTI Write Throughput */
#define bdw__compute_basic__gti_write_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics for 3D Pipeline Profile :: GPU Time Elapsed */
#define bdw__render_pipe_profile__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics for 3D Pipeline Profile :: GPU Core Clocks */
#define bdw__render_pipe_profile__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define bdw__render_pipe_profile__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define bdw__render_pipe_profile__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics for 3D Pipeline Profile :: GPU Busy */
#define bdw__render_pipe_profile__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics for 3D Pipeline Profile :: VS Threads Dispatched */
#define bdw__render_pipe_profile__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics for 3D Pipeline Profile :: HS Threads Dispatched */
#define bdw__render_pipe_profile__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics for 3D Pipeline Profile :: DS Threads Dispatched */
#define bdw__render_pipe_profile__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics for 3D Pipeline Profile :: GS Threads Dispatched */
#define bdw__render_pipe_profile__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics for 3D Pipeline Profile :: FS Threads Dispatched */
#define bdw__render_pipe_profile__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics for 3D Pipeline Profile :: CS Threads Dispatched */
#define bdw__render_pipe_profile__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics for 3D Pipeline Profile :: EU Active */
#define bdw__render_pipe_profile__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics for 3D Pipeline Profile :: EU Stall */
#define bdw__render_pipe_profile__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics for 3D Pipeline Profile :: Rasterized Pixels */
#define bdw__render_pipe_profile__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics for 3D Pipeline Profile :: Early Hi-Depth Test Fails */
#define bdw__render_pipe_profile__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics for 3D Pipeline Profile :: Early Depth Test Fails */
#define bdw__render_pipe_profile__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics for 3D Pipeline Profile :: Samples Killed in FS */
#define bdw__render_pipe_profile__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics for 3D Pipeline Profile :: Pixels Failing Tests */
#define bdw__render_pipe_profile__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics for 3D Pipeline Profile :: Samples Written */
#define bdw__render_pipe_profile__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics for 3D Pipeline Profile :: Samples Blended */
#define bdw__render_pipe_profile__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics for 3D Pipeline Profile :: Sampler Accesses */
static uint64_t
bdw__render_pipe_profile__sampler_accesses__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: A 28 READ */
   uint64_t tmp0 = results->accumulator[query->a_offset + 28];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: Sampler Texels */
#define bdw__render_pipe_profile__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics for 3D Pipeline Profile :: Sampler Texels Misses */
#define bdw__render_pipe_profile__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics for 3D Pipeline Profile :: SLM Bytes Read */
#define bdw__render_pipe_profile__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics for 3D Pipeline Profile :: SLM Bytes Written */
#define bdw__render_pipe_profile__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics for 3D Pipeline Profile :: Shader Memory Accesses */
#define bdw__render_pipe_profile__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics for 3D Pipeline Profile :: Shader Atomic Memory Accesses */
#define bdw__render_pipe_profile__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics for 3D Pipeline Profile :: L3 Shader Throughput */
#define bdw__render_pipe_profile__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics for 3D Pipeline Profile :: Shader Barrier Messages */
#define bdw__render_pipe_profile__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics for 3D Pipeline Profile :: VF Bottleneck */
static float
bdw__render_pipe_profile__vf_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: C 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: VS Bottleneck */
#define bdw__render_pipe_profile__vs_bottleneck__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics for 3D Pipeline Profile :: HS Bottleneck */
#define bdw__render_pipe_profile__hs_bottleneck__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics for 3D Pipeline Profile :: DS Bottleneck */
#define bdw__render_pipe_profile__ds_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: GS Bottleneck */
#define bdw__render_pipe_profile__gs_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: SO Bottleneck */
static float
bdw__render_pipe_profile__so_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Clipper Bottleneck */
static float
bdw__render_pipe_profile__cl_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Strip-Fans Bottleneck */
static float
bdw__render_pipe_profile__sf_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Hi-Depth Bottleneck */
static float
bdw__render_pipe_profile__hi_depth_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                                    const struct intel_perf_query_info *query,
                                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Early Depth Bottleneck */
static float
bdw__render_pipe_profile__early_depth_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                                       const struct intel_perf_query_info *query,
                                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: B 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: BC Bottleneck */
static float
bdw__render_pipe_profile__bc_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: HS Stall */
static float
bdw__render_pipe_profile__hs_stall__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: DS Stall */
static float
bdw__render_pipe_profile__ds_stall__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: SO Stall */
static float
bdw__render_pipe_profile__so_stall__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: CL Stall */
static float
bdw__render_pipe_profile__cl_stall__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: SF Stall */
static float
bdw__render_pipe_profile__sf_stall__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Reads Distribution metric set :: GPU Time Elapsed */
#define bdw__memory_reads__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Reads Distribution metric set :: GPU Core Clocks */
#define bdw__memory_reads__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Reads Distribution metric set :: AVG GPU Core Frequency */
#define bdw__memory_reads__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Reads Distribution metric set :: AVG GPU Core Frequency */
#define bdw__memory_reads__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Reads Distribution metric set :: GPU Busy */
#define bdw__memory_reads__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Reads Distribution metric set :: VS Threads Dispatched */
#define bdw__memory_reads__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Reads Distribution metric set :: HS Threads Dispatched */
#define bdw__memory_reads__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Reads Distribution metric set :: DS Threads Dispatched */
#define bdw__memory_reads__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Reads Distribution metric set :: GS Threads Dispatched */
#define bdw__memory_reads__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Reads Distribution metric set :: FS Threads Dispatched */
#define bdw__memory_reads__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Reads Distribution metric set :: CS Threads Dispatched */
#define bdw__memory_reads__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Reads Distribution metric set :: EU Active */
#define bdw__memory_reads__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Reads Distribution metric set :: EU Stall */
#define bdw__memory_reads__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Reads Distribution metric set :: Rasterized Pixels */
#define bdw__memory_reads__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Reads Distribution metric set :: Early Hi-Depth Test Fails */
#define bdw__memory_reads__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Reads Distribution metric set :: Early Depth Test Fails */
#define bdw__memory_reads__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metric set :: Samples Killed in FS */
#define bdw__memory_reads__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Reads Distribution metric set :: Pixels Failing Tests */
#define bdw__memory_reads__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Reads Distribution metric set :: Samples Written */
#define bdw__memory_reads__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Reads Distribution metric set :: Samples Blended */
#define bdw__memory_reads__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Reads Distribution metric set :: Sampler Texels */
#define bdw__memory_reads__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Reads Distribution metric set :: Sampler Texels Misses */
#define bdw__memory_reads__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Reads Distribution metric set :: SLM Bytes Read */
#define bdw__memory_reads__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Reads Distribution metric set :: SLM Bytes Written */
#define bdw__memory_reads__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Reads Distribution metric set :: Shader Memory Accesses */
#define bdw__memory_reads__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Reads Distribution metric set :: Shader Atomic Memory Accesses */
#define bdw__memory_reads__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Reads Distribution metric set :: Shader Barrier Messages */
#define bdw__memory_reads__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metric set :: L3 Shader Throughput */
#define bdw__memory_reads__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Memory Reads Distribution metric set :: GtiCmdStreamerMemoryReads */
#define bdw__memory_reads__gti_cmd_streamer_memory_reads__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Reads Distribution metric set :: GtiRsMemoryReads */
#define bdw__memory_reads__gti_rs_memory_reads__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Reads Distribution metric set :: GtiVfMemoryReads */
#define bdw__memory_reads__gti_vf_memory_reads__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Memory Reads Distribution metric set :: GtiRccMemoryReads */
#define bdw__memory_reads__gti_rcc_memory_reads__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Reads Distribution metric set :: GtiMscMemoryReads */
#define bdw__memory_reads__gti_msc_memory_reads__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Reads Distribution metric set :: GtiHizMemoryReads */
#define bdw__memory_reads__gti_hiz_memory_reads__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Reads Distribution metric set :: GtiStcMemoryReads */
#define bdw__memory_reads__gti_stc_memory_reads__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Reads Distribution metric set :: GtiRczMemoryReads */
#define bdw__memory_reads__gti_rcz_memory_reads__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Reads Distribution metric set :: GtiMemoryReads */
#define bdw__memory_reads__gti_memory_reads__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Reads Distribution metric set :: GtiL3Bank0Reads */
#define bdw__memory_reads__gti_l3_bank0_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Reads Distribution metric set :: GtiL3Bank1Reads */
#define bdw__memory_reads__gti_l3_bank1_reads__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Reads Distribution metric set :: GtiL3Bank2Reads */
#define bdw__memory_reads__gti_l3_bank2_reads__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Reads Distribution metric set :: GtiL3Bank3Reads */
#define bdw__memory_reads__gti_l3_bank3_reads__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Reads Distribution metric set :: GtiL3Reads */
static uint64_t
bdw__memory_reads__gti_l3_reads__read(UNUSED struct intel_perf_config *perf,
                                      const struct intel_perf_query_info *query,
                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: $GtiL3Bank0Reads $GtiL3Bank1Reads $GtiL3Bank2Reads $GtiL3Bank3Reads UADD UADD UADD */
   uint64_t tmp0 = bdw__memory_reads__gti_l3_bank2_reads__read(perf, query, results) + bdw__memory_reads__gti_l3_bank3_reads__read(perf, query, results);
   uint64_t tmp1 = bdw__memory_reads__gti_l3_bank1_reads__read(perf, query, results) + tmp0;
   uint64_t tmp2 = bdw__memory_reads__gti_l3_bank0_reads__read(perf, query, results) + tmp1;

   return tmp2;
}

/* Memory Reads Distribution metric set :: GtiRingAccesses */
static uint64_t
bdw__memory_reads__gti_ring_accesses__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: C 3 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Memory Writes Distribution metric set :: GPU Time Elapsed */
#define bdw__memory_writes__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Writes Distribution metric set :: GPU Core Clocks */
#define bdw__memory_writes__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Writes Distribution metric set :: AVG GPU Core Frequency */
#define bdw__memory_writes__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Writes Distribution metric set :: AVG GPU Core Frequency */
#define bdw__memory_writes__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Writes Distribution metric set :: GPU Busy */
#define bdw__memory_writes__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Writes Distribution metric set :: VS Threads Dispatched */
#define bdw__memory_writes__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Writes Distribution metric set :: HS Threads Dispatched */
#define bdw__memory_writes__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Writes Distribution metric set :: DS Threads Dispatched */
#define bdw__memory_writes__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Writes Distribution metric set :: GS Threads Dispatched */
#define bdw__memory_writes__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Writes Distribution metric set :: FS Threads Dispatched */
#define bdw__memory_writes__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Writes Distribution metric set :: CS Threads Dispatched */
#define bdw__memory_writes__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Writes Distribution metric set :: EU Active */
#define bdw__memory_writes__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Writes Distribution metric set :: EU Stall */
#define bdw__memory_writes__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Writes Distribution metric set :: Rasterized Pixels */
#define bdw__memory_writes__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Writes Distribution metric set :: Early Hi-Depth Test Fails */
#define bdw__memory_writes__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Writes Distribution metric set :: Early Depth Test Fails */
#define bdw__memory_writes__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metric set :: Samples Killed in FS */
#define bdw__memory_writes__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Writes Distribution metric set :: Pixels Failing Tests */
#define bdw__memory_writes__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Writes Distribution metric set :: Samples Written */
#define bdw__memory_writes__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Writes Distribution metric set :: Samples Blended */
#define bdw__memory_writes__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Writes Distribution metric set :: Sampler Texels */
#define bdw__memory_writes__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Writes Distribution metric set :: Sampler Texels Misses */
#define bdw__memory_writes__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Writes Distribution metric set :: SLM Bytes Read */
#define bdw__memory_writes__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Writes Distribution metric set :: SLM Bytes Written */
#define bdw__memory_writes__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Writes Distribution metric set :: Shader Memory Accesses */
#define bdw__memory_writes__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Writes Distribution metric set :: Shader Atomic Memory Accesses */
#define bdw__memory_writes__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Writes Distribution metric set :: L3 Shader Throughput */
#define bdw__memory_writes__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Memory Writes Distribution metric set :: Shader Barrier Messages */
#define bdw__memory_writes__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metric set :: GtiCmdStreamerMemoryWrites */
#define bdw__memory_writes__gti_cmd_streamer_memory_writes__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Writes Distribution metric set :: GtiSoMemoryWrites */
#define bdw__memory_writes__gti_so_memory_writes__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Writes Distribution metric set :: GtiRccMemoryWrites */
#define bdw__memory_writes__gti_rcc_memory_writes__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Writes Distribution metric set :: GtiMscMemoryWrites */
#define bdw__memory_writes__gti_msc_memory_writes__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Writes Distribution metric set :: GtiHizMemoryWrites */
#define bdw__memory_writes__gti_hiz_memory_writes__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Writes Distribution metric set :: GtiStcMemoryWrites */
#define bdw__memory_writes__gti_stc_memory_writes__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Writes Distribution metric set :: GtiRczMemoryWrites */
#define bdw__memory_writes__gti_rcz_memory_writes__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Writes Distribution metric set :: GtiMemoryWrites */
#define bdw__memory_writes__gti_memory_writes__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Writes Distribution metric set :: GtiL3Bank0Writes */
#define bdw__memory_writes__gti_l3_bank0_writes__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Writes Distribution metric set :: GtiL3Bank1Writes */
#define bdw__memory_writes__gti_l3_bank1_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Writes Distribution metric set :: GtiL3Bank2Writes */
#define bdw__memory_writes__gti_l3_bank2_writes__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Writes Distribution metric set :: GtiL3Bank3Writes */
#define bdw__memory_writes__gti_l3_bank3_writes__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Writes Distribution metric set :: GtiL3Writes */
#define bdw__memory_writes__gti_l3_writes__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Writes Distribution metric set :: GtiRingAccesses */
#define bdw__memory_writes__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Compute Metrics Extended metric set :: GPU Time Elapsed */
#define bdw__compute_extended__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extended metric set :: GPU Core Clocks */
#define bdw__compute_extended__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended metric set :: AVG GPU Core Frequency */
#define bdw__compute_extended__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extended metric set :: AVG GPU Core Frequency */
#define bdw__compute_extended__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extended metric set :: CS Threads Dispatched */
#define bdw__compute_extended__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Extended metric set :: EU Active */
#define bdw__compute_extended__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Extended metric set :: EU Stall */
#define bdw__compute_extended__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extended metric set :: EU Both FPU Pipes Active */
#define bdw__compute_extended__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Extended metric set :: EU FPU0 Pipe Active */
#define bdw__compute_extended__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Extended metric set :: EU FPU1 Pipe Active */
#define bdw__compute_extended__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Extended metric set :: EU AVG IPC Rate */
#define bdw__compute_extended__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Extended metric set :: EU Send Pipe Active */
#define bdw__compute_extended__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Extended metric set :: EU Thread Occupancy */
#define bdw__compute_extended__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Extended metric set :: Sampler Texels */
#define bdw__compute_extended__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Extended metric set :: Sampler Texels Misses */
#define bdw__compute_extended__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Extended metric set :: SLM Bytes Read */
#define bdw__compute_extended__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Extended metric set :: SLM Bytes Written */
#define bdw__compute_extended__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Extended metric set :: Shader Memory Accesses */
#define bdw__compute_extended__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Extended metric set :: Shader Atomic Memory Accesses */
#define bdw__compute_extended__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Extended metric set :: L3 Shader Throughput */
#define bdw__compute_extended__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Extended metric set :: Shader Barrier Messages */
#define bdw__compute_extended__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Extended metric set :: EuUntypedReads0 */
#define bdw__compute_extended__eu_untyped_reads0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Compute Metrics Extended metric set :: EuTypedReads0 */
#define bdw__compute_extended__eu_typed_reads0__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Compute Metrics Extended metric set :: EuUntypedWrites0 */
#define bdw__compute_extended__eu_untyped_writes0__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Compute Metrics Extended metric set :: EuTypedWrites0 */
#define bdw__compute_extended__eu_typed_writes0__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Compute Metrics Extended metric set :: EuUntypedAtomics0 */
#define bdw__compute_extended__eu_untyped_atomics0__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Compute Metrics Extended metric set :: EuTypedAtomics0 */
#define bdw__compute_extended__eu_typed_atomics0__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Compute Metrics Extended metric set :: EuA64UntypedReads0 */
#define bdw__compute_extended__eu_a64_untyped_reads0__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Compute Metrics Extended metric set :: EuA64UntypedWrites0 */
#define bdw__compute_extended__eu_a64_untyped_writes0__read \
   hsw__compute_extended__gpu_clocks__read

/* Compute Metrics Extended metric set :: Typed Reads 0 */
#define bdw__compute_extended__typed_reads0__read \
   hsw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended metric set :: Typed Writes 0 */
#define bdw__compute_extended__typed_writes0__read \
   hsw__compute_extended__typed_writes0__read

/* Compute Metrics Extended metric set :: Untyped Reads 0 */
#define bdw__compute_extended__untyped_reads0__read \
   hsw__compute_extended__untyped_reads0__read

/* Compute Metrics Extended metric set :: Untyped Writes 0 */
#define bdw__compute_extended__untyped_writes0__read \
   hsw__compute_extended__untyped_writes0__read

/* Compute Metrics Extended metric set :: Typed Atomics 0 */
#define bdw__compute_extended__typed_atomics0__read \
   hsw__compute_extended__typed_atomics0__read

/* Compute Metrics Extended metric set :: TypedReadsPerCacheLine */
#define bdw__compute_extended__typed_reads_per_cache_line__read \
   hsw__compute_extended__typed_reads_per_cache_line__read

/* Compute Metrics Extended metric set :: TypedWritesPerCacheLine */
#define bdw__compute_extended__typed_writes_per_cache_line__read \
   hsw__compute_extended__typed_writes_per_cache_line__read

/* Compute Metrics Extended metric set :: UntypedReadsPerCacheLine */
static float
bdw__compute_extended__untyped_reads_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                          const struct intel_perf_query_info *query,
                                                          const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuUntypedReads0 $EuA64UntypedReads0 UADD $UntypedReads0 FDIV */
   uint64_t tmp0 = bdw__compute_extended__eu_untyped_reads0__read(perf, query, results) + bdw__compute_extended__eu_a64_untyped_reads0__read(perf, query, results);
   double tmp1 = tmp0;
   double tmp2 = bdw__compute_extended__untyped_reads0__read(perf, query, results);
   double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extended metric set :: UntypedWritesPerCacheLine */
static float
bdw__compute_extended__untyped_writes_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                           const struct intel_perf_query_info *query,
                                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuUntypedWrites0 $EuA64UntypedWrites0 UADD $UntypedWrites0 FDIV */
   uint64_t tmp0 = bdw__compute_extended__eu_untyped_writes0__read(perf, query, results) + bdw__compute_extended__eu_a64_untyped_writes0__read(perf, query, results);
   double tmp1 = tmp0;
   double tmp2 = bdw__compute_extended__untyped_writes0__read(perf, query, results);
   double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extended metric set :: TypedAtomicsPerCacheLine */
#define bdw__compute_extended__typed_atomics_per_cache_line__read \
   hsw__compute_extended__typed_atomics_per_cache_line__read

/* Compute Metrics L3 Cache metric set :: GPU Time Elapsed */
#define bdw__compute_l3_cache__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics L3 Cache metric set :: GPU Core Clocks */
#define bdw__compute_l3_cache__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics L3 Cache metric set :: AVG GPU Core Frequency */
#define bdw__compute_l3_cache__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics L3 Cache metric set :: AVG GPU Core Frequency */
#define bdw__compute_l3_cache__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics L3 Cache metric set :: GPU Busy */
#define bdw__compute_l3_cache__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics L3 Cache metric set :: VS Threads Dispatched */
#define bdw__compute_l3_cache__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache metric set :: HS Threads Dispatched */
#define bdw__compute_l3_cache__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics L3 Cache metric set :: DS Threads Dispatched */
#define bdw__compute_l3_cache__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics L3 Cache metric set :: GS Threads Dispatched */
#define bdw__compute_l3_cache__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache metric set :: FS Threads Dispatched */
#define bdw__compute_l3_cache__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics L3 Cache metric set :: CS Threads Dispatched */
#define bdw__compute_l3_cache__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics L3 Cache metric set :: EU Active */
#define bdw__compute_l3_cache__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics L3 Cache metric set :: EU Stall */
#define bdw__compute_l3_cache__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics L3 Cache metric set :: EU Both FPU Pipes Active */
#define bdw__compute_l3_cache__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics L3 Cache metric set :: EU FPU0 Pipe Active */
#define bdw__compute_l3_cache__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics L3 Cache metric set :: EU FPU1 Pipe Active */
#define bdw__compute_l3_cache__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics L3 Cache metric set :: EU AVG IPC Rate */
#define bdw__compute_l3_cache__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics L3 Cache metric set :: EU Send Pipe Active */
#define bdw__compute_l3_cache__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics L3 Cache metric set :: EU FPU0 Hybrid Instruction */
static float
bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read(UNUSED struct intel_perf_config *perf,
                                                        const struct intel_perf_query_info *query,
                                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__compute_l3_cache__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache metric set :: EU FPU1 Hybrid Instruction */
static float
bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read(UNUSED struct intel_perf_config *perf,
                                                        const struct intel_perf_query_info *query,
                                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: A 14 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 14];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__compute_l3_cache__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache metric set :: EU FPU0 Ternary Instruction */
#define bdw__compute_l3_cache__eu_ternary_fpu0_instruction__read \
   bdw__render_basic__ps_fpu0_active__read

/* Compute Metrics L3 Cache metric set :: EU FPU1 Ternary Instruction */
#define bdw__compute_l3_cache__eu_ternary_fpu1_instruction__read \
   bdw__render_basic__ps_fpu1_active__read

/* Compute Metrics L3 Cache metric set :: EU FPU0 Binary Instruction */
#define bdw__compute_l3_cache__eu_binary_fpu0_instruction__read \
   bdw__render_basic__ps_send_active__read

/* Compute Metrics L3 Cache metric set :: EU FPU1 Binary Instruction */
#define bdw__compute_l3_cache__eu_binary_fpu1_instruction__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Compute Metrics L3 Cache metric set :: EU FPU0 Move Instruction */
static float
bdw__compute_l3_cache__eu_move_fpu0_instruction__read(UNUSED struct intel_perf_config *perf,
                                                      const struct intel_perf_query_info *query,
                                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 19 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 19];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__compute_l3_cache__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache metric set :: EU FPU1 Move Instruction */
static float
bdw__compute_l3_cache__eu_move_fpu1_instruction__read(UNUSED struct intel_perf_config *perf,
                                                      const struct intel_perf_query_info *query,
                                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: A 20 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 20];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = perf->sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = bdw__compute_l3_cache__gpu_core_clocks__read(perf, query, results);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache metric set :: Rasterized Pixels */
#define bdw__compute_l3_cache__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics L3 Cache metric set :: Early Hi-Depth Test Fails */
#define bdw__compute_l3_cache__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics L3 Cache metric set :: Early Depth Test Fails */
#define bdw__compute_l3_cache__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache metric set :: Samples Killed in FS */
#define bdw__compute_l3_cache__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics L3 Cache metric set :: Pixels Failing Tests */
#define bdw__compute_l3_cache__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics L3 Cache metric set :: Samples Written */
#define bdw__compute_l3_cache__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics L3 Cache metric set :: Samples Blended */
#define bdw__compute_l3_cache__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics L3 Cache metric set :: Sampler Texels */
#define bdw__compute_l3_cache__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics L3 Cache metric set :: Sampler Texels Misses */
#define bdw__compute_l3_cache__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics L3 Cache metric set :: SLM Bytes Read */
#define bdw__compute_l3_cache__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics L3 Cache metric set :: SLM Bytes Written */
#define bdw__compute_l3_cache__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics L3 Cache metric set :: Shader Memory Accesses */
#define bdw__compute_l3_cache__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics L3 Cache metric set :: Shader Atomic Memory Accesses */
#define bdw__compute_l3_cache__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics L3 Cache metric set :: L3 Accesses */
static uint64_t
bdw__compute_l3_cache__l3_accesses__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: C 0 READ C 1 READ B 2 READ B 3 READ C 2 READ C 3 READ B 6 READ B 7 READ UADD UADD UADD UADD UADD UADD UADD 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 0];
   uint64_t tmp1 = results->accumulator[query->c_offset + 1];
   uint64_t tmp2 = results->accumulator[query->b_offset + 2];
   uint64_t tmp3 = results->accumulator[query->b_offset + 3];
   uint64_t tmp4 = results->accumulator[query->c_offset + 2];
   uint64_t tmp5 = results->accumulator[query->c_offset + 3];
   uint64_t tmp6 = results->accumulator[query->b_offset + 6];
   uint64_t tmp7 = results->accumulator[query->b_offset + 7];
   uint64_t tmp8 = tmp6 + tmp7;
   uint64_t tmp9 = tmp5 + tmp8;
   uint64_t tmp10 = tmp4 + tmp9;
   uint64_t tmp11 = tmp3 + tmp10;
   uint64_t tmp12 = tmp2 + tmp11;
   uint64_t tmp13 = tmp1 + tmp12;
   uint64_t tmp14 = tmp0 + tmp13;
   uint64_t tmp15 = tmp14 * 2;

   return tmp15;
}

/* Compute Metrics L3 Cache metric set :: L3 Misses */
static uint64_t
bdw__compute_l3_cache__l3_misses__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: C 4 READ C 5 READ UADD */
   uint64_t tmp0 = results->accumulator[query->c_offset + 4];
   uint64_t tmp1 = results->accumulator[query->c_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;

   return tmp2;
}

/* Compute Metrics L3 Cache metric set :: L3 Shader Throughput */
#define bdw__compute_l3_cache__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics L3 Cache metric set :: L3 Total Throughput */
static uint64_t
bdw__compute_l3_cache__l3_total_throughput__read(UNUSED struct intel_perf_config *perf,
                                                 const struct intel_perf_query_info *query,
                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: $L3Accesses 64 UMUL */
   uint64_t tmp0 = bdw__compute_l3_cache__l3_accesses__read(perf, query, results) * 64;

   return tmp0;
}

/* Compute Metrics L3 Cache metric set :: Shader Barrier Messages */
#define bdw__compute_l3_cache__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache metric set :: L3 Bank 00 Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank00_accesses__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: C 0 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 01 Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank01_accesses__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: C 1 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 02 Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank02_accesses__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: B 2 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 03 Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank03_accesses__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: B 3 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 10 Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank10_accesses__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: C 2 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 11 Accesses */
#define bdw__compute_l3_cache__l3_bank11_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Compute Metrics L3 Cache metric set :: L3 Bank 12 Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank12_accesses__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: B 6 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 6];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 13 Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank13_accesses__read(UNUSED struct intel_perf_config *perf,
                                                const struct intel_perf_query_info *query,
                                                const struct intel_perf_query_result *results)
{
   /* RPN equation: B 7 READ 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 7];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 00 IC Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank00_ic_accesses__read(UNUSED struct intel_perf_config *perf,
                                                   const struct intel_perf_query_info *query,
                                                   const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ B 1 READ UADD 2 UMUL $L3Bank00Accesses UMIN */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 2;
   uint64_t tmp4 = MIN(tmp3, bdw__compute_l3_cache__l3_bank00_accesses__read(perf, query, results));

   return tmp4;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 00 IC Hits */
static uint64_t
bdw__compute_l3_cache__l3_bank00_ic_hits__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: B 1 READ 2 UMUL $L3Bank00IcAccesses UMIN */
   uint64_t tmp0 = results->accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 2;
   uint64_t tmp2 = MIN(tmp1, bdw__compute_l3_cache__l3_bank00_ic_accesses__read(perf, query, results));

   return tmp2;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 10 IC Accesses */
static uint64_t
bdw__compute_l3_cache__l3_bank10_ic_accesses__read(UNUSED struct intel_perf_config *perf,
                                                   const struct intel_perf_query_info *query,
                                                   const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ B 5 READ UADD 2 UMUL $L3Bank10Accesses UMIN */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];
   uint64_t tmp1 = results->accumulator[query->b_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 2;
   uint64_t tmp4 = MIN(tmp3, bdw__compute_l3_cache__l3_bank10_accesses__read(perf, query, results));

   return tmp4;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 10 IC Hits */
static uint64_t
bdw__compute_l3_cache__l3_bank10_ic_hits__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: B 5 READ 2 UMUL $L3Bank10IcAccesses UMIN */
   uint64_t tmp0 = results->accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 2;
   uint64_t tmp2 = MIN(tmp1, bdw__compute_l3_cache__l3_bank10_ic_accesses__read(perf, query, results));

   return tmp2;
}

/* Compute Metrics L3 Cache metric set :: GTI L3 Throughput */
static uint64_t
bdw__compute_l3_cache__gti_l3_throughput__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: C 4 READ C 5 READ UADD 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 4];
   uint64_t tmp1 = results->accumulator[query->c_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics L3 Cache metric set :: GTI Read Throughput */
#define bdw__compute_l3_cache__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Compute Metrics L3 Cache metric set :: GTI Write Throughput */
#define bdw__compute_l3_cache__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Data Port Reads Coalescing metric set :: GPU Time Elapsed */
#define bdw__data_port_reads_coalescing__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Data Port Reads Coalescing metric set :: GPU Core Clocks */
#define bdw__data_port_reads_coalescing__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Data Port Reads Coalescing metric set :: AVG GPU Core Frequency */
#define bdw__data_port_reads_coalescing__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Data Port Reads Coalescing metric set :: AVG GPU Core Frequency */
#define bdw__data_port_reads_coalescing__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Data Port Reads Coalescing metric set :: VS Threads Dispatched */
#define bdw__data_port_reads_coalescing__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Data Port Reads Coalescing metric set :: HS Threads Dispatched */
#define bdw__data_port_reads_coalescing__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Data Port Reads Coalescing metric set :: DS Threads Dispatched */
#define bdw__data_port_reads_coalescing__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Data Port Reads Coalescing metric set :: GS Threads Dispatched */
#define bdw__data_port_reads_coalescing__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Data Port Reads Coalescing metric set :: FS Threads Dispatched */
#define bdw__data_port_reads_coalescing__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Data Port Reads Coalescing metric set :: CS Threads Dispatched */
#define bdw__data_port_reads_coalescing__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Data Port Reads Coalescing metric set :: EU Active */
#define bdw__data_port_reads_coalescing__eu_active__read \
   bdw__render_basic__eu_active__read

/* Data Port Reads Coalescing metric set :: EU Stall */
#define bdw__data_port_reads_coalescing__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Data Port Reads Coalescing metric set :: EU Both FPU Pipes Active */
#define bdw__data_port_reads_coalescing__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Data Port Reads Coalescing metric set :: EU FPU0 Pipe Active */
#define bdw__data_port_reads_coalescing__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Data Port Reads Coalescing metric set :: EU FPU1 Pipe Active */
#define bdw__data_port_reads_coalescing__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Data Port Reads Coalescing metric set :: EU AVG IPC Rate */
#define bdw__data_port_reads_coalescing__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Data Port Reads Coalescing metric set :: EU Send Pipe Active */
#define bdw__data_port_reads_coalescing__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Data Port Reads Coalescing metric set :: EU Thread Occupancy */
#define bdw__data_port_reads_coalescing__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Data Port Reads Coalescing metric set :: Sampler Texels */
#define bdw__data_port_reads_coalescing__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Data Port Reads Coalescing metric set :: Sampler Texels Misses */
#define bdw__data_port_reads_coalescing__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Data Port Reads Coalescing metric set :: SLM Bytes Read */
#define bdw__data_port_reads_coalescing__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Data Port Reads Coalescing metric set :: SLM Bytes Written */
#define bdw__data_port_reads_coalescing__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Data Port Reads Coalescing metric set :: Shader Memory Accesses */
#define bdw__data_port_reads_coalescing__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Data Port Reads Coalescing metric set :: Shader Atomic Memory Accesses */
#define bdw__data_port_reads_coalescing__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Data Port Reads Coalescing metric set :: L3 Shader Throughput */
#define bdw__data_port_reads_coalescing__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Data Port Reads Coalescing metric set :: Shader Barrier Messages */
#define bdw__data_port_reads_coalescing__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Data Port Reads Coalescing metric set :: EU to Data Port 0 Reads 32 */
#define bdw__data_port_reads_coalescing__eu_hdc0_reads32_b__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Data Port Reads Coalescing metric set :: EU to Data Port 0 Reads 64 */
#define bdw__data_port_reads_coalescing__eu_hdc0_reads64_b__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Data Port Reads Coalescing metric set :: EU to Data Port 0 Reads 128 */
#define bdw__data_port_reads_coalescing__eu_hdc0_reads128_b__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Data Port Reads Coalescing metric set :: EU to Data Port 0 Reads 256 */
#define bdw__data_port_reads_coalescing__eu_hdc0_reads256_b__read \
   hsw__compute_extended__gpu_clocks__read

/* Data Port Reads Coalescing metric set :: Data Port 0 to L3 Data Reads */
#define bdw__data_port_reads_coalescing__hdc0_l3_data_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Data Port Reads Coalescing metric set :: Data Port 0 to L3 Data Writes */
#define bdw__data_port_reads_coalescing__hdc0_l3_data_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Data Port Reads Coalescing metric set :: All Data Port 0 Reads from L3 */
static uint64_t
bdw__data_port_reads_coalescing__hdc0_l3_reads__read(UNUSED struct intel_perf_config *perf,
                                                     const struct intel_perf_query_info *query,
                                                     const struct intel_perf_query_result *results)
{
   /* RPN equation: C 3 READ C 2 READ USUB */
   uint64_t tmp0 = results->accumulator[query->c_offset + 3];
   uint64_t tmp1 = results->accumulator[query->c_offset + 2];
   uint64_t tmp2 = tmp0 - tmp1;

   return tmp2;
}

/* Data Port Reads Coalescing metric set :: All Data Port 0 Writes to L3 */
#define bdw__data_port_reads_coalescing__hdc0_l3_writes__read \
   hsw__render_basic__gpu_core_clocks__read

/* Data Port Reads Coalescing metric set :: EuBytesReadPerCacheLine */
static float
bdw__data_port_reads_coalescing__eu_bytes_read_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                                    const struct intel_perf_query_info *query,
                                                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuHdc0Reads32B 32 UMUL $EuHdc0Reads64B 64 UMUL $EuHdc0Reads128B 128 UMUL $EuHdc0Reads256B 256 UMUL UADD UADD UADD $Hdc0L3DataReads FDIV */
   uint64_t tmp0 = bdw__data_port_reads_coalescing__eu_hdc0_reads32_b__read(perf, query, results) * 32;
   uint64_t tmp1 = bdw__data_port_reads_coalescing__eu_hdc0_reads64_b__read(perf, query, results) * 64;
   uint64_t tmp2 = bdw__data_port_reads_coalescing__eu_hdc0_reads128_b__read(perf, query, results) * 128;
   uint64_t tmp3 = bdw__data_port_reads_coalescing__eu_hdc0_reads256_b__read(perf, query, results) * 256;
   uint64_t tmp4 = tmp2 + tmp3;
   uint64_t tmp5 = tmp1 + tmp4;
   uint64_t tmp6 = tmp0 + tmp5;
   double tmp7 = tmp6;
   double tmp8 = bdw__data_port_reads_coalescing__hdc0_l3_data_reads__read(perf, query, results);
   double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

   return tmp9;
}

/* Data Port Reads Coalescing metric set :: EuDataReadsPerCacheLine */
static float
bdw__data_port_reads_coalescing__eu_data_reads_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                                    const struct intel_perf_query_info *query,
                                                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuBytesReadPerCacheLine 64 FDIV */
   double tmp0 = bdw__data_port_reads_coalescing__eu_bytes_read_per_cache_line__read(perf, query, results);
   double tmp1 = 64;
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Data Port Writes Coalescing metric set :: GPU Time Elapsed */
#define bdw__data_port_writes_coalescing__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Data Port Writes Coalescing metric set :: GPU Core Clocks */
#define bdw__data_port_writes_coalescing__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Data Port Writes Coalescing metric set :: AVG GPU Core Frequency */
#define bdw__data_port_writes_coalescing__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Data Port Writes Coalescing metric set :: AVG GPU Core Frequency */
#define bdw__data_port_writes_coalescing__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Data Port Writes Coalescing metric set :: VS Threads Dispatched */
#define bdw__data_port_writes_coalescing__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Data Port Writes Coalescing metric set :: HS Threads Dispatched */
#define bdw__data_port_writes_coalescing__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Data Port Writes Coalescing metric set :: DS Threads Dispatched */
#define bdw__data_port_writes_coalescing__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Data Port Writes Coalescing metric set :: GS Threads Dispatched */
#define bdw__data_port_writes_coalescing__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Data Port Writes Coalescing metric set :: FS Threads Dispatched */
#define bdw__data_port_writes_coalescing__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Data Port Writes Coalescing metric set :: CS Threads Dispatched */
#define bdw__data_port_writes_coalescing__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Data Port Writes Coalescing metric set :: EU Active */
#define bdw__data_port_writes_coalescing__eu_active__read \
   bdw__render_basic__eu_active__read

/* Data Port Writes Coalescing metric set :: EU Stall */
#define bdw__data_port_writes_coalescing__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Data Port Writes Coalescing metric set :: EU Both FPU Pipes Active */
#define bdw__data_port_writes_coalescing__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Data Port Writes Coalescing metric set :: EU FPU0 Pipe Active */
#define bdw__data_port_writes_coalescing__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Data Port Writes Coalescing metric set :: EU FPU1 Pipe Active */
#define bdw__data_port_writes_coalescing__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Data Port Writes Coalescing metric set :: EU AVG IPC Rate */
#define bdw__data_port_writes_coalescing__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Data Port Writes Coalescing metric set :: EU Send Pipe Active */
#define bdw__data_port_writes_coalescing__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Data Port Writes Coalescing metric set :: EU Thread Occupancy */
#define bdw__data_port_writes_coalescing__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Data Port Writes Coalescing metric set :: Sampler Texels */
#define bdw__data_port_writes_coalescing__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Data Port Writes Coalescing metric set :: Sampler Texels Misses */
#define bdw__data_port_writes_coalescing__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Data Port Writes Coalescing metric set :: SLM Bytes Read */
#define bdw__data_port_writes_coalescing__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Data Port Writes Coalescing metric set :: SLM Bytes Written */
#define bdw__data_port_writes_coalescing__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Data Port Writes Coalescing metric set :: Shader Memory Accesses */
#define bdw__data_port_writes_coalescing__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Data Port Writes Coalescing metric set :: Shader Atomic Memory Accesses */
#define bdw__data_port_writes_coalescing__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Data Port Writes Coalescing metric set :: L3 Shader Throughput */
#define bdw__data_port_writes_coalescing__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Data Port Writes Coalescing metric set :: Shader Barrier Messages */
#define bdw__data_port_writes_coalescing__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 32B */
#define bdw__data_port_writes_coalescing__eu_hdc0_writes32_b__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 64B */
static uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes64_b__read(UNUSED struct intel_perf_config *perf,
                                                           const struct intel_perf_query_info *query,
                                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: B 1 READ B 4 READ UADD */
   uint64_t tmp0 = results->accumulator[query->b_offset + 1];
   uint64_t tmp1 = results->accumulator[query->b_offset + 4];
   uint64_t tmp2 = tmp0 + tmp1;

   return tmp2;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 64B */
static uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes96_b__read(UNUSED struct intel_perf_config *perf,
                                                           const struct intel_perf_query_info *query,
                                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: B 2 READ 2 UDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = 2;
   uint64_t tmp3 = tmp1 / tmp2;

   return tmp3;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 128 */
static uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes128_b__read(UNUSED struct intel_perf_config *perf,
                                                            const struct intel_perf_query_info *query,
                                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: B 3 READ 2 UDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = 2;
   uint64_t tmp3 = tmp1 / tmp2;

   return tmp3;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 128 */
static uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes192_b__read(UNUSED struct intel_perf_config *perf,
                                                            const struct intel_perf_query_info *query,
                                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: B 6 READ 2 UDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 6];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = 2;
   uint64_t tmp3 = tmp1 / tmp2;

   return tmp3;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 64B */
#define bdw__data_port_writes_coalescing__eu_hdc0_writes128_b_simd16__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 256B */
static uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes256_b_simd16__read(UNUSED struct intel_perf_config *perf,
                                                                   const struct intel_perf_query_info *query,
                                                                   const struct intel_perf_query_result *results)
{
   /* RPN equation: B 7 READ 2 UDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = 2;
   uint64_t tmp3 = tmp1 / tmp2;

   return tmp3;
}

/* Data Port Writes Coalescing metric set :: Data Port 0 to L3 Data Reads */
#define bdw__data_port_writes_coalescing__hdc0_l3_data_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Data Port Writes Coalescing metric set :: Data Port 0 to L3 Data Writes */
#define bdw__data_port_writes_coalescing__hdc0_l3_data_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Data Port Writes Coalescing metric set :: All Data Port 0 Reads from L3 */
#define bdw__data_port_writes_coalescing__hdc0_l3_reads__read \
   bdw__data_port_reads_coalescing__hdc0_l3_reads__read

/* Data Port Writes Coalescing metric set :: All Data Port 0 Writes to L3 */
#define bdw__data_port_writes_coalescing__hdc0_l3_writes__read \
   hsw__render_basic__gpu_core_clocks__read

/* Data Port Writes Coalescing metric set :: EuBytesWrittenPerCacheLine */
static float
bdw__data_port_writes_coalescing__eu_bytes_written_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                                        const struct intel_perf_query_info *query,
                                                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuHdc0Writes32B 32 UMUL $EuHdc0Writes64B 64 UMUL $EuHdc0Writes96B 96 UMUL $EuHdc0Writes128B 128 UMUL $EuHdc0Writes128BSimd16 128 UMUL $EuHdc0Writes256BSimd16 256 UMUL $EuHdc0Writes192B 192 UMUL UADD UADD UADD UADD UADD UADD $Hdc0L3DataWrites FDIV */
   uint64_t tmp0 = bdw__data_port_writes_coalescing__eu_hdc0_writes32_b__read(perf, query, results) * 32;
   uint64_t tmp1 = bdw__data_port_writes_coalescing__eu_hdc0_writes64_b__read(perf, query, results) * 64;
   uint64_t tmp2 = bdw__data_port_writes_coalescing__eu_hdc0_writes96_b__read(perf, query, results) * 96;
   uint64_t tmp3 = bdw__data_port_writes_coalescing__eu_hdc0_writes128_b__read(perf, query, results) * 128;
   uint64_t tmp4 = bdw__data_port_writes_coalescing__eu_hdc0_writes128_b_simd16__read(perf, query, results) * 128;
   uint64_t tmp5 = bdw__data_port_writes_coalescing__eu_hdc0_writes256_b_simd16__read(perf, query, results) * 256;
   uint64_t tmp6 = bdw__data_port_writes_coalescing__eu_hdc0_writes192_b__read(perf, query, results) * 192;
   uint64_t tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = tmp4 + tmp7;
   uint64_t tmp9 = tmp3 + tmp8;
   uint64_t tmp10 = tmp2 + tmp9;
   uint64_t tmp11 = tmp1 + tmp10;
   uint64_t tmp12 = tmp0 + tmp11;
   double tmp13 = tmp12;
   double tmp14 = bdw__data_port_writes_coalescing__hdc0_l3_data_writes__read(perf, query, results);
   double tmp15 = tmp14 ? tmp13 / tmp14 : 0;

   return tmp15;
}

/* Data Port Writes Coalescing metric set :: EuDataWritesPerCacheLine */
static float
bdw__data_port_writes_coalescing__eu_data_writes_per_cache_line__read(UNUSED struct intel_perf_config *perf,
                                                                      const struct intel_perf_query_info *query,
                                                                      const struct intel_perf_query_result *results)
{
   /* RPN equation: $EuBytesWrittenPerCacheLine 64 FDIV */
   double tmp0 = bdw__data_port_writes_coalescing__eu_bytes_written_per_cache_line__read(perf, query, results);
   double tmp1 = 64;
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Metric set HDCAndSF :: GPU Time Elapsed */
#define bdw__hdc_and_sf__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set HDCAndSF :: GPU Core Clocks */
#define bdw__hdc_and_sf__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define bdw__hdc_and_sf__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define bdw__hdc_and_sf__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set HDCAndSF :: GPU Busy */
#define bdw__hdc_and_sf__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set HDCAndSF :: VS Threads Dispatched */
#define bdw__hdc_and_sf__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: HS Threads Dispatched */
#define bdw__hdc_and_sf__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set HDCAndSF :: DS Threads Dispatched */
#define bdw__hdc_and_sf__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set HDCAndSF :: GS Threads Dispatched */
#define bdw__hdc_and_sf__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: FS Threads Dispatched */
#define bdw__hdc_and_sf__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set HDCAndSF :: CS Threads Dispatched */
#define bdw__hdc_and_sf__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set HDCAndSF :: EU Active */
#define bdw__hdc_and_sf__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set HDCAndSF :: EU Stall */
#define bdw__hdc_and_sf__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
#define bdw__hdc_and_sf__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
#define bdw__hdc_and_sf__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
#define bdw__hdc_and_sf__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set HDCAndSF :: VS Send Pipe Active */
#define bdw__hdc_and_sf__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
#define bdw__hdc_and_sf__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
#define bdw__hdc_and_sf__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set HDCAndSF :: PS Send Pipeline Active */
#define bdw__hdc_and_sf__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set HDCAndSF :: FS Both FPU Active */
#define bdw__hdc_and_sf__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set HDCAndSF :: Rasterized Pixels */
#define bdw__hdc_and_sf__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
#define bdw__hdc_and_sf__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set HDCAndSF :: Early Depth Test Fails */
#define bdw__hdc_and_sf__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Samples Killed in FS */
#define bdw__hdc_and_sf__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set HDCAndSF :: Pixels Failing Tests */
#define bdw__hdc_and_sf__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set HDCAndSF :: Samples Written */
#define bdw__hdc_and_sf__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set HDCAndSF :: Samples Blended */
#define bdw__hdc_and_sf__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set HDCAndSF :: Sampler Texels */
#define bdw__hdc_and_sf__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set HDCAndSF :: Sampler Texels Misses */
#define bdw__hdc_and_sf__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set HDCAndSF :: SLM Bytes Read */
#define bdw__hdc_and_sf__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set HDCAndSF :: SLM Bytes Written */
#define bdw__hdc_and_sf__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set HDCAndSF :: Shader Memory Accesses */
#define bdw__hdc_and_sf__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
#define bdw__hdc_and_sf__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set HDCAndSF :: L3 Shader Throughput */
#define bdw__hdc_and_sf__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set HDCAndSF :: Shader Barrier Messages */
#define bdw__hdc_and_sf__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Polygon Data Ready */
#define bdw__hdc_and_sf__poly_data_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
static float
bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read(UNUSED struct intel_perf_config *perf,
                                                                 const struct intel_perf_query_info *query,
                                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: C 7 READ C 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 7];
   uint64_t tmp1 = results->accumulator[query->c_offset + 6];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, query, results);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
static float
bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read(UNUSED struct intel_perf_config *perf,
                                                                 const struct intel_perf_query_info *query,
                                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: C 5 READ C 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 5];
   uint64_t tmp1 = results->accumulator[query->c_offset + 4];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, query, results);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
static float
bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read(UNUSED struct intel_perf_config *perf,
                                                                 const struct intel_perf_query_info *query,
                                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: C 3 READ C 2 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 3];
   uint64_t tmp1 = results->accumulator[query->c_offset + 2];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, query, results);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
static float
bdw__hdc_and_sf__non_sampler_shader12_access_stalled_on_l3__read(UNUSED struct intel_perf_config *perf,
                                                                 const struct intel_perf_query_info *query,
                                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: C 1 READ C 0 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->c_offset + 1];
   uint64_t tmp1 = results->accumulator[query->c_offset + 0];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, query, results);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
static float
bdw__hdc_and_sf__non_sampler_shader11_access_stalled_on_l3__read(UNUSED struct intel_perf_config *perf,
                                                                 const struct intel_perf_query_info *query,
                                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: B 7 READ B 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 7];
   uint64_t tmp1 = results->accumulator[query->b_offset + 6];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, query, results);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
static float
bdw__hdc_and_sf__non_sampler_shader10_access_stalled_on_l3__read(UNUSED struct intel_perf_config *perf,
                                                                 const struct intel_perf_query_info *query,
                                                                 const struct intel_perf_query_result *results)
{
   /* RPN equation: B 5 READ B 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 5];
   uint64_t tmp1 = results->accumulator[query->b_offset + 4];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, query, results);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: SQ is full */
static float
bdw__hdc_and_sf__gt_request_queue_full__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: PERFCNT 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->perfcnt_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, query, results);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: GPU Time Elapsed */
#define bdw__l3_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_1 :: GPU Core Clocks */
#define bdw__l3_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define bdw__l3_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define bdw__l3_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_1 :: GPU Busy */
#define bdw__l3_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_1 :: VS Threads Dispatched */
#define bdw__l3_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_1 :: HS Threads Dispatched */
#define bdw__l3_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_1 :: DS Threads Dispatched */
#define bdw__l3_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_1 :: GS Threads Dispatched */
#define bdw__l3_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_1 :: FS Threads Dispatched */
#define bdw__l3_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_1 :: CS Threads Dispatched */
#define bdw__l3_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_1 :: EU Active */
#define bdw__l3_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_1 :: EU Stall */
#define bdw__l3_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_1 :: EU Both FPU Pipes Active */
#define bdw__l3_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_1 :: VS FPU0 Pipe Active */
#define bdw__l3_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_1 :: VS FPU1 Pipe Active */
#define bdw__l3_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_1 :: VS Send Pipe Active */
#define bdw__l3_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_1 :: PS FPU0 Pipe Active */
#define bdw__l3_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_1 :: PS FPU1 Pipe Active */
#define bdw__l3_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_1 :: PS Send Pipeline Active */
#define bdw__l3_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_1 :: FS Both FPU Active */
#define bdw__l3_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_1 :: Rasterized Pixels */
#define bdw__l3_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
#define bdw__l3_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_1 :: Early Depth Test Fails */
#define bdw__l3_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Samples Killed in FS */
#define bdw__l3_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_1 :: Pixels Failing Tests */
#define bdw__l3_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_1 :: Samples Written */
#define bdw__l3_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_1 :: Samples Blended */
#define bdw__l3_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_1 :: Sampler Texels */
#define bdw__l3_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_1 :: Sampler Texels Misses */
#define bdw__l3_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_1 :: SLM Bytes Read */
#define bdw__l3_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_1 :: SLM Bytes Written */
#define bdw__l3_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_1 :: Shader Memory Accesses */
#define bdw__l3_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
#define bdw__l3_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_1 :: L3 Shader Throughput */
#define bdw__l3_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_1 :: Shader Barrier Messages */
#define bdw__l3_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Slice1 L3 Bank0 Stalled */
#define bdw__l3_1__l31_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_1 :: Slice1 L3 Bank1 Stalled */
#define bdw__l3_1__l31_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_1 :: Slice1 L3 Bank1 Active */
#define bdw__l3_1__l31_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_1 :: Slice1 L3 Bank0 Active */
#define bdw__l3_1__l31_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_1 :: SQ is full */
#define bdw__l3_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_2 :: GPU Time Elapsed */
#define bdw__l3_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_2 :: GPU Core Clocks */
#define bdw__l3_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define bdw__l3_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define bdw__l3_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_2 :: GPU Busy */
#define bdw__l3_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_2 :: VS Threads Dispatched */
#define bdw__l3_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_2 :: HS Threads Dispatched */
#define bdw__l3_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_2 :: DS Threads Dispatched */
#define bdw__l3_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_2 :: GS Threads Dispatched */
#define bdw__l3_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_2 :: FS Threads Dispatched */
#define bdw__l3_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_2 :: CS Threads Dispatched */
#define bdw__l3_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_2 :: EU Active */
#define bdw__l3_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_2 :: EU Stall */
#define bdw__l3_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_2 :: EU Both FPU Pipes Active */
#define bdw__l3_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_2 :: VS FPU0 Pipe Active */
#define bdw__l3_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_2 :: VS FPU1 Pipe Active */
#define bdw__l3_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_2 :: VS Send Pipe Active */
#define bdw__l3_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_2 :: PS FPU0 Pipe Active */
#define bdw__l3_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_2 :: PS FPU1 Pipe Active */
#define bdw__l3_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_2 :: PS Send Pipeline Active */
#define bdw__l3_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_2 :: FS Both FPU Active */
#define bdw__l3_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_2 :: Rasterized Pixels */
#define bdw__l3_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
#define bdw__l3_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_2 :: Early Depth Test Fails */
#define bdw__l3_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Samples Killed in FS */
#define bdw__l3_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_2 :: Pixels Failing Tests */
#define bdw__l3_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_2 :: Samples Written */
#define bdw__l3_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_2 :: Samples Blended */
#define bdw__l3_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_2 :: Sampler Texels */
#define bdw__l3_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_2 :: Sampler Texels Misses */
#define bdw__l3_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_2 :: SLM Bytes Read */
#define bdw__l3_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_2 :: SLM Bytes Written */
#define bdw__l3_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_2 :: Shader Memory Accesses */
#define bdw__l3_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
#define bdw__l3_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_2 :: L3 Shader Throughput */
#define bdw__l3_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_2 :: Shader Barrier Messages */
#define bdw__l3_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Slice0 L3 Bank0 Stalled */
#define bdw__l3_2__l30_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_2 :: Slice0 L3 Bank1 Stalled */
#define bdw__l3_2__l30_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_2 :: Slice0 L3 Bank1 Active */
#define bdw__l3_2__l30_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_2 :: Slice0 L3 Bank0 Active */
#define bdw__l3_2__l30_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_2 :: SQ is full */
#define bdw__l3_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_3 :: GPU Time Elapsed */
#define bdw__l3_3__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_3 :: GPU Core Clocks */
#define bdw__l3_3__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define bdw__l3_3__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define bdw__l3_3__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_3 :: GPU Busy */
#define bdw__l3_3__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_3 :: VS Threads Dispatched */
#define bdw__l3_3__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_3 :: HS Threads Dispatched */
#define bdw__l3_3__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_3 :: DS Threads Dispatched */
#define bdw__l3_3__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_3 :: GS Threads Dispatched */
#define bdw__l3_3__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_3 :: FS Threads Dispatched */
#define bdw__l3_3__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_3 :: CS Threads Dispatched */
#define bdw__l3_3__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_3 :: EU Active */
#define bdw__l3_3__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_3 :: EU Stall */
#define bdw__l3_3__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_3 :: EU Both FPU Pipes Active */
#define bdw__l3_3__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_3 :: VS FPU0 Pipe Active */
#define bdw__l3_3__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_3 :: VS FPU1 Pipe Active */
#define bdw__l3_3__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_3 :: VS Send Pipe Active */
#define bdw__l3_3__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_3 :: PS FPU0 Pipe Active */
#define bdw__l3_3__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_3 :: PS FPU1 Pipe Active */
#define bdw__l3_3__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_3 :: PS Send Pipeline Active */
#define bdw__l3_3__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_3 :: FS Both FPU Active */
#define bdw__l3_3__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_3 :: Rasterized Pixels */
#define bdw__l3_3__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
#define bdw__l3_3__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_3 :: Early Depth Test Fails */
#define bdw__l3_3__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Samples Killed in FS */
#define bdw__l3_3__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_3 :: Pixels Failing Tests */
#define bdw__l3_3__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_3 :: Samples Written */
#define bdw__l3_3__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_3 :: Samples Blended */
#define bdw__l3_3__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_3 :: Sampler Texels */
#define bdw__l3_3__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_3 :: Sampler Texels Misses */
#define bdw__l3_3__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_3 :: SLM Bytes Read */
#define bdw__l3_3__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_3 :: SLM Bytes Written */
#define bdw__l3_3__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_3 :: Shader Memory Accesses */
#define bdw__l3_3__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
#define bdw__l3_3__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_3 :: L3 Shader Throughput */
#define bdw__l3_3__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_3 :: Shader Barrier Messages */
#define bdw__l3_3__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
#define bdw__l3_3__l30_bank3_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_3 :: Slice1 L3 Bank3 Stalled */
#define bdw__l3_3__l31_bank3_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_3 :: Slice1 L3 Bank3 Active */
#define bdw__l3_3__l31_bank3_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
#define bdw__l3_3__l30_bank3_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_3 :: SQ is full */
#define bdw__l3_3__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_4 :: GPU Time Elapsed */
#define bdw__l3_4__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_4 :: GPU Core Clocks */
#define bdw__l3_4__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_4 :: AVG GPU Core Frequency */
#define bdw__l3_4__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_4 :: AVG GPU Core Frequency */
#define bdw__l3_4__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_4 :: GPU Busy */
#define bdw__l3_4__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_4 :: VS Threads Dispatched */
#define bdw__l3_4__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_4 :: HS Threads Dispatched */
#define bdw__l3_4__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_4 :: DS Threads Dispatched */
#define bdw__l3_4__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_4 :: GS Threads Dispatched */
#define bdw__l3_4__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_4 :: FS Threads Dispatched */
#define bdw__l3_4__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_4 :: CS Threads Dispatched */
#define bdw__l3_4__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_4 :: EU Active */
#define bdw__l3_4__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_4 :: EU Stall */
#define bdw__l3_4__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_4 :: EU Both FPU Pipes Active */
#define bdw__l3_4__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_4 :: VS FPU0 Pipe Active */
#define bdw__l3_4__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_4 :: VS FPU1 Pipe Active */
#define bdw__l3_4__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_4 :: VS Send Pipe Active */
#define bdw__l3_4__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_4 :: PS FPU0 Pipe Active */
#define bdw__l3_4__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_4 :: PS FPU1 Pipe Active */
#define bdw__l3_4__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_4 :: PS Send Pipeline Active */
#define bdw__l3_4__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_4 :: FS Both FPU Active */
#define bdw__l3_4__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_4 :: Rasterized Pixels */
#define bdw__l3_4__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_4 :: Early Hi-Depth Test Fails */
#define bdw__l3_4__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_4 :: Early Depth Test Fails */
#define bdw__l3_4__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_4 :: Samples Killed in FS */
#define bdw__l3_4__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_4 :: Pixels Failing Tests */
#define bdw__l3_4__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_4 :: Samples Written */
#define bdw__l3_4__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_4 :: Samples Blended */
#define bdw__l3_4__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_4 :: Sampler Texels */
#define bdw__l3_4__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_4 :: Sampler Texels Misses */
#define bdw__l3_4__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_4 :: SLM Bytes Read */
#define bdw__l3_4__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_4 :: SLM Bytes Written */
#define bdw__l3_4__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_4 :: Shader Memory Accesses */
#define bdw__l3_4__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_4 :: Shader Atomic Memory Accesses */
#define bdw__l3_4__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_4 :: L3 Shader Throughput */
#define bdw__l3_4__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_4 :: Shader Barrier Messages */
#define bdw__l3_4__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_4 :: Slice0 L3 Bank2 Stalled */
#define bdw__l3_4__l30_bank2_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_4 :: Slice1 L3 Bank2 Stalled */
#define bdw__l3_4__l31_bank2_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_4 :: Slice1 L3 Bank2 Active */
#define bdw__l3_4__l31_bank2_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_4 :: Slice0 L3 Bank2 Active */
#define bdw__l3_4__l30_bank2_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_4 :: SQ is full */
#define bdw__l3_4__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
#define bdw__rasterizer_and_pixel_backend__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
#define bdw__rasterizer_and_pixel_backend__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define bdw__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define bdw__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
#define bdw__rasterizer_and_pixel_backend__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
#define bdw__rasterizer_and_pixel_backend__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
#define bdw__rasterizer_and_pixel_backend__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
#define bdw__rasterizer_and_pixel_backend__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
#define bdw__rasterizer_and_pixel_backend__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
#define bdw__rasterizer_and_pixel_backend__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
#define bdw__rasterizer_and_pixel_backend__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set RasterizerAndPixelBackend :: EU Active */
#define bdw__rasterizer_and_pixel_backend__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set RasterizerAndPixelBackend :: EU Stall */
#define bdw__rasterizer_and_pixel_backend__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
#define bdw__rasterizer_and_pixel_backend__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
#define bdw__rasterizer_and_pixel_backend__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
#define bdw__rasterizer_and_pixel_backend__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
#define bdw__rasterizer_and_pixel_backend__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
#define bdw__rasterizer_and_pixel_backend__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
#define bdw__rasterizer_and_pixel_backend__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
#define bdw__rasterizer_and_pixel_backend__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
#define bdw__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
#define bdw__rasterizer_and_pixel_backend__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
#define bdw__rasterizer_and_pixel_backend__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
#define bdw__rasterizer_and_pixel_backend__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
#define bdw__rasterizer_and_pixel_backend__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
#define bdw__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set RasterizerAndPixelBackend :: Samples Written */
#define bdw__rasterizer_and_pixel_backend__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
#define bdw__rasterizer_and_pixel_backend__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
#define bdw__rasterizer_and_pixel_backend__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
#define bdw__rasterizer_and_pixel_backend__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
#define bdw__rasterizer_and_pixel_backend__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
#define bdw__rasterizer_and_pixel_backend__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
#define bdw__rasterizer_and_pixel_backend__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
#define bdw__rasterizer_and_pixel_backend__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
#define bdw__rasterizer_and_pixel_backend__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
#define bdw__rasterizer_and_pixel_backend__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
#define bdw__rasterizer_and_pixel_backend__rasterizer0_output_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice1 Post-EarlyZ Pixel Data Ready */
#define bdw__rasterizer_and_pixel_backend__pixel_data1_ready__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
#define bdw__rasterizer_and_pixel_backend__pixel_data0_ready__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice1 Rasterizer Input Available */
#define bdw__rasterizer_and_pixel_backend__rasterizer1_input_available__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice1 Rasterizer Output Ready */
#define bdw__rasterizer_and_pixel_backend__rasterizer1_output_ready__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
#define bdw__rasterizer_and_pixel_backend__rasterizer0_input_available__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
#define bdw__rasterizer_and_pixel_backend__pixel_values0_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
#define bdw__rasterizer_and_pixel_backend__ps_output0_available__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice1 Pixel Values Ready */
#define bdw__rasterizer_and_pixel_backend__pixel_values1_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set RasterizerAndPixelBackend :: Slice1 PS Output Available */
#define bdw__rasterizer_and_pixel_backend__ps_output1_available__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set RasterizerAndPixelBackend :: SQ is full */
#define bdw__rasterizer_and_pixel_backend__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler_1 :: GPU Time Elapsed */
#define bdw__sampler_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler_1 :: GPU Core Clocks */
#define bdw__sampler_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler_1 :: AVG GPU Core Frequency */
#define bdw__sampler_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler_1 :: AVG GPU Core Frequency */
#define bdw__sampler_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler_1 :: GPU Busy */
#define bdw__sampler_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler_1 :: VS Threads Dispatched */
#define bdw__sampler_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler_1 :: HS Threads Dispatched */
#define bdw__sampler_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler_1 :: DS Threads Dispatched */
#define bdw__sampler_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler_1 :: GS Threads Dispatched */
#define bdw__sampler_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler_1 :: FS Threads Dispatched */
#define bdw__sampler_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler_1 :: CS Threads Dispatched */
#define bdw__sampler_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler_1 :: EU Active */
#define bdw__sampler_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler_1 :: EU Stall */
#define bdw__sampler_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler_1 :: EU Both FPU Pipes Active */
#define bdw__sampler_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler_1 :: VS FPU0 Pipe Active */
#define bdw__sampler_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler_1 :: VS FPU1 Pipe Active */
#define bdw__sampler_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler_1 :: VS Send Pipe Active */
#define bdw__sampler_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler_1 :: PS FPU0 Pipe Active */
#define bdw__sampler_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler_1 :: PS FPU1 Pipe Active */
#define bdw__sampler_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler_1 :: PS Send Pipeline Active */
#define bdw__sampler_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler_1 :: FS Both FPU Active */
#define bdw__sampler_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler_1 :: Rasterized Pixels */
#define bdw__sampler_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler_1 :: Early Hi-Depth Test Fails */
#define bdw__sampler_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler_1 :: Early Depth Test Fails */
#define bdw__sampler_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler_1 :: Samples Killed in FS */
#define bdw__sampler_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler_1 :: Pixels Failing Tests */
#define bdw__sampler_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler_1 :: Samples Written */
#define bdw__sampler_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler_1 :: Samples Blended */
#define bdw__sampler_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler_1 :: Sampler Texels */
#define bdw__sampler_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler_1 :: Sampler Texels Misses */
#define bdw__sampler_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler_1 :: SLM Bytes Read */
#define bdw__sampler_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler_1 :: SLM Bytes Written */
#define bdw__sampler_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler_1 :: Shader Memory Accesses */
#define bdw__sampler_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler_1 :: Shader Atomic Memory Accesses */
#define bdw__sampler_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler_1 :: L3 Shader Throughput */
#define bdw__sampler_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler_1 :: Shader Barrier Messages */
#define bdw__sampler_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler_1 :: Slice1 Subslice1 Input Available */
#define bdw__sampler_1__sampler11_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler_1 :: Slice1 Subslice2 Input Available */
#define bdw__sampler_1__sampler12_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler_1 :: Slice1 Subslice0 Input Available */
#define bdw__sampler_1__sampler10_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler_1 :: Slice1 Subslice2 Sampler Output Ready */
#define bdw__sampler_1__sampler12_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler_1 :: Slice1 Subslice0 Sampler Output Ready */
#define bdw__sampler_1__sampler10_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler_1 :: Slice1 Subslice1 Sampler Output Ready */
#define bdw__sampler_1__sampler11_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler_1 :: SQ is full */
#define bdw__sampler_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler_2 :: GPU Time Elapsed */
#define bdw__sampler_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler_2 :: GPU Core Clocks */
#define bdw__sampler_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler_2 :: AVG GPU Core Frequency */
#define bdw__sampler_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler_2 :: AVG GPU Core Frequency */
#define bdw__sampler_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler_2 :: GPU Busy */
#define bdw__sampler_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler_2 :: VS Threads Dispatched */
#define bdw__sampler_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler_2 :: HS Threads Dispatched */
#define bdw__sampler_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler_2 :: DS Threads Dispatched */
#define bdw__sampler_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler_2 :: GS Threads Dispatched */
#define bdw__sampler_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler_2 :: FS Threads Dispatched */
#define bdw__sampler_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler_2 :: CS Threads Dispatched */
#define bdw__sampler_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler_2 :: EU Active */
#define bdw__sampler_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler_2 :: EU Stall */
#define bdw__sampler_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler_2 :: EU Both FPU Pipes Active */
#define bdw__sampler_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler_2 :: VS FPU0 Pipe Active */
#define bdw__sampler_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler_2 :: VS FPU1 Pipe Active */
#define bdw__sampler_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler_2 :: VS Send Pipe Active */
#define bdw__sampler_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler_2 :: PS FPU0 Pipe Active */
#define bdw__sampler_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler_2 :: PS FPU1 Pipe Active */
#define bdw__sampler_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler_2 :: PS Send Pipeline Active */
#define bdw__sampler_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler_2 :: FS Both FPU Active */
#define bdw__sampler_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler_2 :: Rasterized Pixels */
#define bdw__sampler_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler_2 :: Early Hi-Depth Test Fails */
#define bdw__sampler_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler_2 :: Early Depth Test Fails */
#define bdw__sampler_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler_2 :: Samples Killed in FS */
#define bdw__sampler_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler_2 :: Pixels Failing Tests */
#define bdw__sampler_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler_2 :: Samples Written */
#define bdw__sampler_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler_2 :: Samples Blended */
#define bdw__sampler_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler_2 :: Sampler Texels */
#define bdw__sampler_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler_2 :: Sampler Texels Misses */
#define bdw__sampler_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler_2 :: SLM Bytes Read */
#define bdw__sampler_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler_2 :: SLM Bytes Written */
#define bdw__sampler_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler_2 :: Shader Memory Accesses */
#define bdw__sampler_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler_2 :: Shader Atomic Memory Accesses */
#define bdw__sampler_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler_2 :: L3 Shader Throughput */
#define bdw__sampler_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler_2 :: Shader Barrier Messages */
#define bdw__sampler_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler_2 :: Slice0 Subslice1 Input Available */
#define bdw__sampler_2__sampler01_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler_2 :: Slice0 Subslice2 Input Available */
#define bdw__sampler_2__sampler02_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler_2 :: Slice0 Subslice0 Input Available */
#define bdw__sampler_2__sampler00_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler_2 :: Slice0 Subslice2 Sampler Output Ready */
#define bdw__sampler_2__sampler02_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler_2 :: Slice0 Subslice0 Sampler Output Ready */
#define bdw__sampler_2__sampler00_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler_2 :: Slice0 Subslice1 Sampler Output Ready */
#define bdw__sampler_2__sampler01_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler_2 :: SQ is full */
#define bdw__sampler_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_1 :: GPU Time Elapsed */
#define bdw__tdl_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_1 :: GPU Core Clocks */
#define bdw__tdl_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define bdw__tdl_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define bdw__tdl_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_1 :: GPU Busy */
#define bdw__tdl_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_1 :: VS Threads Dispatched */
#define bdw__tdl_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_1 :: HS Threads Dispatched */
#define bdw__tdl_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_1 :: DS Threads Dispatched */
#define bdw__tdl_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_1 :: GS Threads Dispatched */
#define bdw__tdl_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_1 :: FS Threads Dispatched */
#define bdw__tdl_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_1 :: CS Threads Dispatched */
#define bdw__tdl_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_1 :: EU Active */
#define bdw__tdl_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_1 :: EU Stall */
#define bdw__tdl_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
#define bdw__tdl_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
#define bdw__tdl_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
#define bdw__tdl_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_1 :: VS Send Pipe Active */
#define bdw__tdl_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
#define bdw__tdl_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
#define bdw__tdl_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_1 :: PS Send Pipeline Active */
#define bdw__tdl_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_1 :: FS Both FPU Active */
#define bdw__tdl_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_1 :: Rasterized Pixels */
#define bdw__tdl_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
#define bdw__tdl_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_1 :: Early Depth Test Fails */
#define bdw__tdl_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: Samples Killed in FS */
#define bdw__tdl_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_1 :: Pixels Failing Tests */
#define bdw__tdl_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_1 :: Samples Written */
#define bdw__tdl_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_1 :: Samples Blended */
#define bdw__tdl_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_1 :: Sampler Texels */
#define bdw__tdl_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_1 :: Sampler Texels Misses */
#define bdw__tdl_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_1 :: SLM Bytes Read */
#define bdw__tdl_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_1 :: SLM Bytes Written */
#define bdw__tdl_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_1 :: Shader Memory Accesses */
#define bdw__tdl_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
#define bdw__tdl_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_1 :: L3 Shader Throughput */
#define bdw__tdl_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_1 :: Shader Barrier Messages */
#define bdw__tdl_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice1 Subslice1 */
#define bdw__tdl_1__non_ps_thread11_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice0 */
#define bdw__tdl_1__ps_thread10_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice1 Subslice0 */
#define bdw__tdl_1__non_ps_thread10_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice2 */
#define bdw__tdl_1__ps_thread12_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice1 Subslice2 */
#define bdw__tdl_1__non_ps_thread12_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice1 */
#define bdw__tdl_1__ps_thread11_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice1 Port 0 */
#define bdw__tdl_1__thread_header01_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice0 Port 1 */
#define bdw__tdl_1__thread_header00_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice0 Port 0 */
#define bdw__tdl_1__thread_header00_ready_port0__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice2 Port 1 */
#define bdw__tdl_1__thread_header02_ready_port1__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice2 Port 0 */
#define bdw__tdl_1__thread_header02_ready_port0__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice1 Port 1 */
#define bdw__tdl_1__thread_header01_ready_port1__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_1 :: SQ is full */
#define bdw__tdl_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_2 :: GPU Time Elapsed */
#define bdw__tdl_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_2 :: GPU Core Clocks */
#define bdw__tdl_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define bdw__tdl_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define bdw__tdl_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_2 :: GPU Busy */
#define bdw__tdl_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_2 :: VS Threads Dispatched */
#define bdw__tdl_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_2 :: HS Threads Dispatched */
#define bdw__tdl_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_2 :: DS Threads Dispatched */
#define bdw__tdl_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_2 :: GS Threads Dispatched */
#define bdw__tdl_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_2 :: FS Threads Dispatched */
#define bdw__tdl_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_2 :: CS Threads Dispatched */
#define bdw__tdl_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_2 :: EU Active */
#define bdw__tdl_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_2 :: EU Stall */
#define bdw__tdl_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
#define bdw__tdl_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
#define bdw__tdl_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
#define bdw__tdl_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_2 :: VS Send Pipe Active */
#define bdw__tdl_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
#define bdw__tdl_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
#define bdw__tdl_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_2 :: PS Send Pipeline Active */
#define bdw__tdl_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_2 :: FS Both FPU Active */
#define bdw__tdl_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_2 :: Rasterized Pixels */
#define bdw__tdl_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
#define bdw__tdl_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_2 :: Early Depth Test Fails */
#define bdw__tdl_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Samples Killed in FS */
#define bdw__tdl_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_2 :: Pixels Failing Tests */
#define bdw__tdl_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_2 :: Samples Written */
#define bdw__tdl_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_2 :: Samples Blended */
#define bdw__tdl_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_2 :: Sampler Texels */
#define bdw__tdl_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_2 :: Sampler Texels Misses */
#define bdw__tdl_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_2 :: SLM Bytes Read */
#define bdw__tdl_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_2 :: SLM Bytes Written */
#define bdw__tdl_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_2 :: Shader Memory Accesses */
#define bdw__tdl_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
#define bdw__tdl_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_2 :: L3 Shader Throughput */
#define bdw__tdl_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_2 :: Shader Barrier Messages */
#define bdw__tdl_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
#define bdw__tdl_2__non_ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice2 */
#define bdw__tdl_2__ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice1 */
#define bdw__tdl_2__ps_thread01_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice0 */
#define bdw__tdl_2__ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_2 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
#define bdw__tdl_2__non_ps_thread01_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_2 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
#define bdw__tdl_2__non_ps_thread00_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice2 Port 0 */
#define bdw__tdl_2__thread_header12_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice2 Port 1 */
#define bdw__tdl_2__thread_header12_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice1 Port 1 */
#define bdw__tdl_2__thread_header11_ready_port1__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice0 Port 0 */
#define bdw__tdl_2__thread_header10_ready_port0__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice0 Port 1 */
#define bdw__tdl_2__thread_header10_ready_port1__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice1 Port 0 */
#define bdw__tdl_2__thread_header11_ready_port0__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_2 :: SQ is full */
#define bdw__tdl_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Compute Metrics Extra set :: GPU Time Elapsed */
#define bdw__compute_extra__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extra set :: GPU Core Clocks */
#define bdw__compute_extra__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define bdw__compute_extra__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define bdw__compute_extra__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extra set :: EU FPU1 Pipe Active */
#define bdw__compute_extra__fpu1_active__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extra set :: EU FPU1 Pipe Active including Ext Math */
static float
bdw__compute_extra__fpu1_active_adjusted__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: A 8 READ  C 5 READ C 6 READ FADD C 7 READ FADD C 2 READ FADD C 3 READ FADD C 4 READ FADD 8 FMUL FADD 100 FMUL $EuCoresTotalCount FDIV $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 8];
   uint64_t tmp1 = results->accumulator[query->c_offset + 5];
   uint64_t tmp2 = results->accumulator[query->c_offset + 6];
   double tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = results->accumulator[query->c_offset + 7];
   double tmp5 = tmp3 + tmp4;
   uint64_t tmp6 = results->accumulator[query->c_offset + 2];
   double tmp7 = tmp5 + tmp6;
   uint64_t tmp8 = results->accumulator[query->c_offset + 3];
   double tmp9 = tmp7 + tmp8;
   uint64_t tmp10 = results->accumulator[query->c_offset + 4];
   double tmp11 = tmp9 + tmp10;
   double tmp12 = tmp11 * 8;
   double tmp13 = tmp0 + tmp12;
   double tmp14 = tmp13 * 100;
   double tmp15 = tmp14;
   double tmp16 = perf->sys_vars.n_eus;
   double tmp17 = tmp16 ? tmp15 / tmp16 : 0;
   double tmp18 = tmp17;
   double tmp19 = bdw__compute_extra__gpu_core_clocks__read(perf, query, results);
   double tmp20 = tmp19 ? tmp18 / tmp19 : 0;

   return tmp20;
}

/* Media Vme Pipe metric set :: GPU Time Elapsed */
#define bdw__vme_pipe__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Media Vme Pipe metric set :: GPU Core Clocks */
#define bdw__vme_pipe__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Media Vme Pipe metric set :: AVG GPU Core Frequency */
#define bdw__vme_pipe__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Media Vme Pipe metric set :: AVG GPU Core Frequency */
#define bdw__vme_pipe__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Media Vme Pipe metric set :: GPU Busy */
#define bdw__vme_pipe__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Media Vme Pipe metric set :: CS Threads Dispatched */
#define bdw__vme_pipe__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Media Vme Pipe metric set :: EU Active */
#define bdw__vme_pipe__eu_active__read \
   bdw__render_basic__eu_active__read

/* Media Vme Pipe metric set :: EU Stall */
#define bdw__vme_pipe__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Media Vme Pipe metric set :: EU Both FPU Pipes Active */
#define bdw__vme_pipe__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Media Vme Pipe metric set :: EU Thread Occupancy */
static float
bdw__vme_pipe__eu_thread_occupancy__read(UNUSED struct intel_perf_config *perf,
                                         const struct intel_perf_query_info *query,
                                         const struct intel_perf_query_result *results)
{
   /* RPN equation: 8 A 10 READ FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 10];
   double tmp1 = 8 * tmp0;
   double tmp2 = tmp1;
   double tmp3 = perf->sys_vars.eu_threads_count;
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = perf->sys_vars.n_eus;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = bdw__vme_pipe__gpu_core_clocks__read(perf, query, results);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* Media Vme Pipe metric set :: VME Busy */
static float
bdw__vme_pipe__vme_busy__read(UNUSED struct intel_perf_config *perf,
                              const struct intel_perf_query_info *query,
                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ B 3 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 3];
   double tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = 2;
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   uint64_t tmp6 = tmp5 * 100;
   double tmp7 = tmp6;
   double tmp8 = bdw__vme_pipe__gpu_core_clocks__read(perf, query, results);
   double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

   return tmp9;
}

/* Gpu Rings Busyness :: GPU Time Elapsed */
#define bdw__gpu_busyness__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Gpu Rings Busyness :: GPU Core Clocks */
#define bdw__gpu_busyness__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define bdw__gpu_busyness__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define bdw__gpu_busyness__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Gpu Rings Busyness :: Render Ring Busy */
#define bdw__gpu_busyness__render_busy__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Gpu Rings Busyness :: Vdbox0 Ring Busy */
#define bdw__gpu_busyness__vdbox0_busy__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Gpu Rings Busyness :: Vdbox1 Ring Busy */
#define bdw__gpu_busyness__vdbox1_busy__read \
   bdw__render_pipe_profile__so_stall__read

/* Gpu Rings Busyness :: Vebox Ring Busy */
#define bdw__gpu_busyness__vebox_busy__read \
   bdw__render_pipe_profile__sf_stall__read

/* Gpu Rings Busyness :: Blitter Ring Busy */
#define bdw__gpu_busyness__blitter_busy__read \
   bdw__render_pipe_profile__cl_stall__read

/* Gpu Rings Busyness :: AnyRingBusy */
#define bdw__gpu_busyness__any_ring_busy__read \
   bdw__render_basic__sampler0_busy__read

/* MDAPI testing set :: GPU Time Elapsed */
#define bdw__test_oa__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* MDAPI testing set :: GPU Core Clocks */
#define bdw__test_oa__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define bdw__test_oa__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define bdw__test_oa__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* MDAPI testing set :: TestCounter0 */
#define bdw__test_oa__counter0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* MDAPI testing set :: TestCounter1 */
#define bdw__test_oa__counter1__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* MDAPI testing set :: TestCounter2 */
#define bdw__test_oa__counter2__read \
   hsw__compute_extended__eu_typed_reads0__read

/* MDAPI testing set :: TestCounter3 */
#define bdw__test_oa__counter3__read \
   hsw__compute_extended__eu_typed_writes0__read

/* MDAPI testing set :: TestCounter4 */
#define bdw__test_oa__counter4__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* MDAPI testing set :: TestCounter5 */
#define bdw__test_oa__counter5__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* MDAPI testing set :: TestCounter6 */
#define bdw__test_oa__counter6__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* MDAPI testing set :: TestCounter7 */
#define bdw__test_oa__counter7__read \
   hsw__compute_extended__gpu_clocks__read

/* MDAPI testing set :: TestCounter8 */
#define bdw__test_oa__counter8__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Metric set PMA Stall :: GPU Time Elapsed */
#define bdw__stc__pma_stall__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set PMA Stall :: GPU Core Clocks */
#define bdw__stc__pma_stall__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define bdw__stc__pma_stall__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define bdw__stc__pma_stall__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set PMA Stall :: GPU Busy */
#define bdw__stc__pma_stall__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set PMA Stall :: VS Threads Dispatched */
#define bdw__stc__pma_stall__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set PMA Stall :: HS Threads Dispatched */
#define bdw__stc__pma_stall__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set PMA Stall :: DS Threads Dispatched */
#define bdw__stc__pma_stall__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set PMA Stall :: GS Threads Dispatched */
#define bdw__stc__pma_stall__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set PMA Stall :: FS Threads Dispatched */
#define bdw__stc__pma_stall__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set PMA Stall :: CS Threads Dispatched */
#define bdw__stc__pma_stall__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set PMA Stall :: STC PMA stall */
#define bdw__stc__pma_stall__stc_pma_stall__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics Basic set :: GPU Time Elapsed */
#define chv__render_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics Basic set :: GPU Core Clocks */
#define chv__render_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define chv__render_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define chv__render_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics Basic set :: VS Threads Dispatched */
#define chv__render_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics Basic set :: HS Threads Dispatched */
#define chv__render_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics Basic set :: DS Threads Dispatched */
#define chv__render_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics Basic set :: GS Threads Dispatched */
#define chv__render_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics Basic set :: FS Threads Dispatched */
#define chv__render_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics Basic set :: CS Threads Dispatched */
#define chv__render_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics Basic set :: GPU Busy */
#define chv__render_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics Basic set :: EU Active */
#define chv__render_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics Basic set :: EU Stall */
#define chv__render_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
#define chv__render_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
#define chv__render_basic__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
#define chv__render_basic__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Render Metrics Basic set :: VS Send Pipe Active */
#define chv__render_basic__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
#define chv__render_basic__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
#define chv__render_basic__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Render Metrics Basic set :: PS Send Pipeline Active */
#define chv__render_basic__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Render Metrics Basic set :: FS Both FPU Active */
#define chv__render_basic__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Render Metrics Basic set :: Sampler 0 Busy */
#define chv__render_basic__sampler0_busy__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics Basic set :: Sampler 1 Busy */
#define chv__render_basic__sampler1_busy__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics Basic set :: Samplers Busy */
static float
chv__render_basic__samplers_busy__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ  B 1 READ UADD $GpuCoreClocks FDIV 2 FDIV 100 FMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = chv__render_basic__gpu_core_clocks__read(perf, query, results);
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   double tmp6 = tmp5;
   double tmp7 = 2;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 * 100;

   return tmp9;
}

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
#define chv__render_basic__sampler0_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
#define chv__render_basic__sampler1_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics Basic set :: Samples Written */
#define chv__render_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics Basic set :: Samples Blended */
#define chv__render_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics Basic set :: Sampler Texels */
#define chv__render_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics Basic set :: Sampler Texels Misses */
#define chv__render_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics Basic set :: Rasterized Pixels */
#define chv__render_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
#define chv__render_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics Basic set :: Early Depth Test Fails */
#define chv__render_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: Samples Killed in FS */
#define chv__render_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics Basic set :: Pixels Failing Tests */
#define chv__render_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics Basic set :: SLM Bytes Read */
#define chv__render_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics Basic set :: SLM Bytes Written */
#define chv__render_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics Basic set :: Shader Memory Accesses */
#define chv__render_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
#define chv__render_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics Basic set :: L3 Misses */
#define chv__render_basic__l3_misses__read \
   hsw__compute_extended__typed_atomics0__read

/* Render Metrics Basic set :: L3 Sampler Throughput */
static uint64_t
chv__render_basic__l3_sampler_throughput__read(UNUSED struct intel_perf_config *perf,
                                               const struct intel_perf_query_info *query,
                                               const struct intel_perf_query_result *results)
{
   /* RPN equation: A 29 READ 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
#define chv__render_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics Basic set :: Shader Barrier Messages */
#define chv__render_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
#define chv__render_basic__gti_vf_throughput__read \
   bdw__render_basic__gti_vf_throughput__read

/* Render Metrics Basic set :: GTI Depth Throughput */
#define chv__render_basic__gti_depth_throughput__read \
   bdw__render_basic__gti_depth_throughput__read

/* Render Metrics Basic set :: GTI RCC Throughput */
#define chv__render_basic__gti_rcc_throughput__read \
   bdw__render_basic__gti_rcc_throughput__read

/* Render Metrics Basic set :: GTI L3 Throughput */
#define chv__render_basic__gti_l3_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Render Metrics Basic set :: GTI HDC TLB Lookup Throughput */
#define chv__render_basic__gti_hdc_lookups_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics Basic set :: GTI Read Throughput */
#define chv__render_basic__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Render Metrics Basic set :: GTI Write Throughput */
#define chv__render_basic__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Render Metrics Basic set :: Samplers Bottleneck */
#define chv__render_basic__sampler_bottleneck__read \
   bdw__render_basic__sampler_bottleneck__read

/* Compute Metrics Basic set :: GPU Time Elapsed */
#define chv__compute_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Basic set :: GPU Core Clocks */
#define chv__compute_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define chv__compute_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define chv__compute_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Basic set :: GPU Busy */
#define chv__compute_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics Basic set :: VS Threads Dispatched */
#define chv__compute_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: HS Threads Dispatched */
#define chv__compute_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics Basic set :: DS Threads Dispatched */
#define chv__compute_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics Basic set :: GS Threads Dispatched */
#define chv__compute_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: FS Threads Dispatched */
#define chv__compute_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics Basic set :: CS Threads Dispatched */
#define chv__compute_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Basic set :: EU Active */
#define chv__compute_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Basic set :: EU Stall */
#define chv__compute_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Basic set :: EU Both FPU Pipes Active */
#define chv__compute_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Basic set :: EU FPU0 Pipe Active */
#define chv__compute_basic__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Basic set :: EU FPU1 Pipe Active */
#define chv__compute_basic__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Basic set :: EU AVG IPC Rate */
#define chv__compute_basic__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Basic set :: EU Send Pipe Active */
#define chv__compute_basic__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Basic set :: EU Thread Occupancy */
#define chv__compute_basic__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Basic set :: Rasterized Pixels */
#define chv__compute_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics Basic set :: Early Hi-Depth Test Fails */
#define chv__compute_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics Basic set :: Early Depth Test Fails */
#define chv__compute_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Killed in FS */
#define chv__compute_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics Basic set :: Pixels Failing Tests */
#define chv__compute_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics Basic set :: Samples Written */
#define chv__compute_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics Basic set :: Samples Blended */
#define chv__compute_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics Basic set :: Sampler Texels */
#define chv__compute_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Basic set :: Sampler Texels Misses */
#define chv__compute_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Basic set :: SLM Bytes Read */
#define chv__compute_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Basic set :: SLM Bytes Written */
#define chv__compute_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Basic set :: Shader Memory Accesses */
#define chv__compute_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Basic set :: Shader Atomic Memory Accesses */
#define chv__compute_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Basic set :: L3 Shader Throughput */
#define chv__compute_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Basic set :: Shader Barrier Messages */
#define chv__compute_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Typed Bytes Read */
static uint64_t
chv__compute_basic__typed_bytes_read__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ B 1 READ UADD 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
static uint64_t
chv__compute_basic__typed_bytes_written__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 2 READ B 3 READ UADD 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 2];
   uint64_t tmp1 = results->accumulator[query->b_offset + 3];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics Basic set :: Untyped Bytes Read */
static uint64_t
chv__compute_basic__untyped_bytes_read__read(UNUSED struct intel_perf_config *perf,
                                             const struct intel_perf_query_info *query,
                                             const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ B 5 READ UADD 64 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];
   uint64_t tmp1 = results->accumulator[query->b_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics Basic set :: Untyped Writes */
#define chv__compute_basic__untyped_bytes_written__read \
   hsw__compute_basic__typed_bytes_written__read

/* Compute Metrics Basic set :: GTI Read Throughput */
#define chv__compute_basic__gti_read_throughput__read \
   hsw__render_basic__gti_depth_throughput__read

/* Compute Metrics Basic set :: GTI Write Throughput */
#define chv__compute_basic__gti_write_throughput__read \
   hsw__render_basic__gti_vf_throughput__read

/* Compute Metrics Basic set :: GTI Ring Throughput */
static uint64_t
chv__compute_basic__gti_ring_throughput__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: C 2 READ 128 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 128;

   return tmp1;
}

/* Compute Metrics Basic set :: GTI Read-Only Stall */
#define chv__compute_basic__gti_ro_stall__read \
   bdw__render_pipe_profile__so_stall__read

/* Compute Metrics Basic set :: GTI Read-Write Stall */
#define chv__compute_basic__gti_rw_stall__read \
   bdw__render_pipe_profile__cl_stall__read

/* Render Metrics for 3D Pipeline Profile :: GPU Time Elapsed */
#define chv__render_pipe_profile__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics for 3D Pipeline Profile :: GPU Core Clocks */
#define chv__render_pipe_profile__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define chv__render_pipe_profile__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define chv__render_pipe_profile__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics for 3D Pipeline Profile :: GPU Busy */
#define chv__render_pipe_profile__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics for 3D Pipeline Profile :: VS Threads Dispatched */
#define chv__render_pipe_profile__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics for 3D Pipeline Profile :: HS Threads Dispatched */
#define chv__render_pipe_profile__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics for 3D Pipeline Profile :: DS Threads Dispatched */
#define chv__render_pipe_profile__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics for 3D Pipeline Profile :: GS Threads Dispatched */
#define chv__render_pipe_profile__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics for 3D Pipeline Profile :: FS Threads Dispatched */
#define chv__render_pipe_profile__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics for 3D Pipeline Profile :: CS Threads Dispatched */
#define chv__render_pipe_profile__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics for 3D Pipeline Profile :: EU Active */
#define chv__render_pipe_profile__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics for 3D Pipeline Profile :: EU Stall */
#define chv__render_pipe_profile__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics for 3D Pipeline Profile :: Rasterized Pixels */
#define chv__render_pipe_profile__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics for 3D Pipeline Profile :: Early Hi-Depth Test Fails */
#define chv__render_pipe_profile__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics for 3D Pipeline Profile :: Early Depth Test Fails */
#define chv__render_pipe_profile__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics for 3D Pipeline Profile :: Samples Killed in FS */
#define chv__render_pipe_profile__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics for 3D Pipeline Profile :: Pixels Failing Tests */
#define chv__render_pipe_profile__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics for 3D Pipeline Profile :: Samples Written */
#define chv__render_pipe_profile__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics for 3D Pipeline Profile :: Samples Blended */
#define chv__render_pipe_profile__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics for 3D Pipeline Profile :: Sampler Accesses */
#define chv__render_pipe_profile__sampler_accesses__read \
   bdw__render_pipe_profile__sampler_accesses__read

/* Render Metrics for 3D Pipeline Profile :: Sampler Texels */
#define chv__render_pipe_profile__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics for 3D Pipeline Profile :: Sampler Texels Misses */
#define chv__render_pipe_profile__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics for 3D Pipeline Profile :: SLM Bytes Read */
#define chv__render_pipe_profile__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics for 3D Pipeline Profile :: SLM Bytes Written */
#define chv__render_pipe_profile__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics for 3D Pipeline Profile :: Shader Memory Accesses */
#define chv__render_pipe_profile__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics for 3D Pipeline Profile :: Shader Atomic Memory Accesses */
#define chv__render_pipe_profile__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics for 3D Pipeline Profile :: L3 Shader Throughput */
#define chv__render_pipe_profile__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics for 3D Pipeline Profile :: Shader Barrier Messages */
#define chv__render_pipe_profile__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics for 3D Pipeline Profile :: VF Bottleneck */
#define chv__render_pipe_profile__vf_bottleneck__read \
   bdw__render_pipe_profile__vf_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: VS Bottleneck */
#define chv__render_pipe_profile__vs_bottleneck__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics for 3D Pipeline Profile :: HS Bottleneck */
#define chv__render_pipe_profile__hs_bottleneck__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics for 3D Pipeline Profile :: DS Bottleneck */
#define chv__render_pipe_profile__ds_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: GS Bottleneck */
#define chv__render_pipe_profile__gs_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: SO Bottleneck */
#define chv__render_pipe_profile__so_bottleneck__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: Clipper Bottleneck */
#define chv__render_pipe_profile__cl_bottleneck__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: Strip-Fans Bottleneck */
#define chv__render_pipe_profile__sf_bottleneck__read \
   bdw__render_pipe_profile__sf_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: Hi-Depth Bottleneck */
#define chv__render_pipe_profile__hi_depth_bottleneck__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: Early Depth Bottleneck */
#define chv__render_pipe_profile__early_depth_bottleneck__read \
   bdw__render_pipe_profile__early_depth_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: BC Bottleneck */
#define chv__render_pipe_profile__bc_bottleneck__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Render Metrics for 3D Pipeline Profile :: HS Stall */
#define chv__render_pipe_profile__hs_stall__read \
   bdw__render_pipe_profile__hs_stall__read

/* Render Metrics for 3D Pipeline Profile :: DS Stall */
#define chv__render_pipe_profile__ds_stall__read \
   bdw__render_pipe_profile__ds_stall__read

/* Render Metrics for 3D Pipeline Profile :: SO Stall */
#define chv__render_pipe_profile__so_stall__read \
   bdw__render_pipe_profile__so_stall__read

/* Render Metrics for 3D Pipeline Profile :: CL Stall */
#define chv__render_pipe_profile__cl_stall__read \
   bdw__render_pipe_profile__cl_stall__read

/* Render Metrics for 3D Pipeline Profile :: SF Stall */
#define chv__render_pipe_profile__sf_stall__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set HDCAndSF :: GPU Time Elapsed */
#define chv__hdc_and_sf__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set HDCAndSF :: GPU Core Clocks */
#define chv__hdc_and_sf__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define chv__hdc_and_sf__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define chv__hdc_and_sf__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set HDCAndSF :: GPU Busy */
#define chv__hdc_and_sf__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set HDCAndSF :: VS Threads Dispatched */
#define chv__hdc_and_sf__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: HS Threads Dispatched */
#define chv__hdc_and_sf__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set HDCAndSF :: DS Threads Dispatched */
#define chv__hdc_and_sf__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set HDCAndSF :: GS Threads Dispatched */
#define chv__hdc_and_sf__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: FS Threads Dispatched */
#define chv__hdc_and_sf__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set HDCAndSF :: CS Threads Dispatched */
#define chv__hdc_and_sf__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set HDCAndSF :: EU Active */
#define chv__hdc_and_sf__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set HDCAndSF :: EU Stall */
#define chv__hdc_and_sf__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
#define chv__hdc_and_sf__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
#define chv__hdc_and_sf__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
#define chv__hdc_and_sf__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set HDCAndSF :: VS Send Pipe Active */
#define chv__hdc_and_sf__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
#define chv__hdc_and_sf__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
#define chv__hdc_and_sf__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set HDCAndSF :: PS Send Pipeline Active */
#define chv__hdc_and_sf__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set HDCAndSF :: FS Both FPU Active */
#define chv__hdc_and_sf__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set HDCAndSF :: Rasterized Pixels */
#define chv__hdc_and_sf__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
#define chv__hdc_and_sf__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set HDCAndSF :: Early Depth Test Fails */
#define chv__hdc_and_sf__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Samples Killed in FS */
#define chv__hdc_and_sf__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set HDCAndSF :: Pixels Failing Tests */
#define chv__hdc_and_sf__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set HDCAndSF :: Samples Written */
#define chv__hdc_and_sf__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set HDCAndSF :: Samples Blended */
#define chv__hdc_and_sf__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set HDCAndSF :: Sampler Texels */
#define chv__hdc_and_sf__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set HDCAndSF :: Sampler Texels Misses */
#define chv__hdc_and_sf__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set HDCAndSF :: SLM Bytes Read */
#define chv__hdc_and_sf__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set HDCAndSF :: SLM Bytes Written */
#define chv__hdc_and_sf__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set HDCAndSF :: Shader Memory Accesses */
#define chv__hdc_and_sf__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
#define chv__hdc_and_sf__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set HDCAndSF :: L3 Shader Throughput */
#define chv__hdc_and_sf__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set HDCAndSF :: Shader Barrier Messages */
#define chv__hdc_and_sf__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Polygon Data Ready */
#define chv__hdc_and_sf__poly_data_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
#define chv__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
#define chv__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
#define chv__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
#define chv__hdc_and_sf__non_sampler_shader12_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader12_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
#define chv__hdc_and_sf__non_sampler_shader11_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader11_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
#define chv__hdc_and_sf__non_sampler_shader10_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader10_access_stalled_on_l3__read

/* Metric set HDCAndSF :: SQ is full */
#define chv__hdc_and_sf__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_1 :: GPU Time Elapsed */
#define chv__l3_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_1 :: GPU Core Clocks */
#define chv__l3_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define chv__l3_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define chv__l3_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_1 :: GPU Busy */
#define chv__l3_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_1 :: VS Threads Dispatched */
#define chv__l3_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_1 :: HS Threads Dispatched */
#define chv__l3_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_1 :: DS Threads Dispatched */
#define chv__l3_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_1 :: GS Threads Dispatched */
#define chv__l3_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_1 :: FS Threads Dispatched */
#define chv__l3_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_1 :: CS Threads Dispatched */
#define chv__l3_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_1 :: EU Active */
#define chv__l3_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_1 :: EU Stall */
#define chv__l3_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_1 :: EU Both FPU Pipes Active */
#define chv__l3_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_1 :: VS FPU0 Pipe Active */
#define chv__l3_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_1 :: VS FPU1 Pipe Active */
#define chv__l3_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_1 :: VS Send Pipe Active */
#define chv__l3_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_1 :: PS FPU0 Pipe Active */
#define chv__l3_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_1 :: PS FPU1 Pipe Active */
#define chv__l3_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_1 :: PS Send Pipeline Active */
#define chv__l3_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_1 :: FS Both FPU Active */
#define chv__l3_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_1 :: Rasterized Pixels */
#define chv__l3_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
#define chv__l3_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_1 :: Early Depth Test Fails */
#define chv__l3_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Samples Killed in FS */
#define chv__l3_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_1 :: Pixels Failing Tests */
#define chv__l3_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_1 :: Samples Written */
#define chv__l3_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_1 :: Samples Blended */
#define chv__l3_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_1 :: Sampler Texels */
#define chv__l3_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_1 :: Sampler Texels Misses */
#define chv__l3_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_1 :: SLM Bytes Read */
#define chv__l3_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_1 :: SLM Bytes Written */
#define chv__l3_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_1 :: Shader Memory Accesses */
#define chv__l3_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
#define chv__l3_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_1 :: L3 Shader Throughput */
#define chv__l3_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_1 :: Shader Barrier Messages */
#define chv__l3_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Slice1 L3 Bank0 Stalled */
#define chv__l3_1__l31_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_1 :: Slice1 L3 Bank1 Stalled */
#define chv__l3_1__l31_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_1 :: Slice1 L3 Bank1 Active */
#define chv__l3_1__l31_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_1 :: Slice1 L3 Bank0 Active */
#define chv__l3_1__l31_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_1 :: SQ is full */
#define chv__l3_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_2 :: GPU Time Elapsed */
#define chv__l3_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_2 :: GPU Core Clocks */
#define chv__l3_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define chv__l3_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define chv__l3_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_2 :: GPU Busy */
#define chv__l3_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_2 :: VS Threads Dispatched */
#define chv__l3_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_2 :: HS Threads Dispatched */
#define chv__l3_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_2 :: DS Threads Dispatched */
#define chv__l3_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_2 :: GS Threads Dispatched */
#define chv__l3_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_2 :: FS Threads Dispatched */
#define chv__l3_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_2 :: CS Threads Dispatched */
#define chv__l3_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_2 :: EU Active */
#define chv__l3_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_2 :: EU Stall */
#define chv__l3_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_2 :: EU Both FPU Pipes Active */
#define chv__l3_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_2 :: VS FPU0 Pipe Active */
#define chv__l3_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_2 :: VS FPU1 Pipe Active */
#define chv__l3_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_2 :: VS Send Pipe Active */
#define chv__l3_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_2 :: PS FPU0 Pipe Active */
#define chv__l3_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_2 :: PS FPU1 Pipe Active */
#define chv__l3_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_2 :: PS Send Pipeline Active */
#define chv__l3_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_2 :: FS Both FPU Active */
#define chv__l3_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_2 :: Rasterized Pixels */
#define chv__l3_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
#define chv__l3_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_2 :: Early Depth Test Fails */
#define chv__l3_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Samples Killed in FS */
#define chv__l3_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_2 :: Pixels Failing Tests */
#define chv__l3_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_2 :: Samples Written */
#define chv__l3_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_2 :: Samples Blended */
#define chv__l3_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_2 :: Sampler Texels */
#define chv__l3_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_2 :: Sampler Texels Misses */
#define chv__l3_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_2 :: SLM Bytes Read */
#define chv__l3_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_2 :: SLM Bytes Written */
#define chv__l3_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_2 :: Shader Memory Accesses */
#define chv__l3_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
#define chv__l3_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_2 :: L3 Shader Throughput */
#define chv__l3_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_2 :: Shader Barrier Messages */
#define chv__l3_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Slice0 L3 Bank0 Stalled */
#define chv__l3_2__l30_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_2 :: Slice0 L3 Bank1 Stalled */
#define chv__l3_2__l30_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_2 :: Slice0 L3 Bank1 Active */
#define chv__l3_2__l30_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_2 :: Slice0 L3 Bank0 Active */
#define chv__l3_2__l30_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_2 :: SQ is full */
#define chv__l3_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_3 :: GPU Time Elapsed */
#define chv__l3_3__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_3 :: GPU Core Clocks */
#define chv__l3_3__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define chv__l3_3__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define chv__l3_3__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_3 :: GPU Busy */
#define chv__l3_3__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_3 :: VS Threads Dispatched */
#define chv__l3_3__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_3 :: HS Threads Dispatched */
#define chv__l3_3__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_3 :: DS Threads Dispatched */
#define chv__l3_3__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_3 :: GS Threads Dispatched */
#define chv__l3_3__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_3 :: FS Threads Dispatched */
#define chv__l3_3__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_3 :: CS Threads Dispatched */
#define chv__l3_3__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_3 :: EU Active */
#define chv__l3_3__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_3 :: EU Stall */
#define chv__l3_3__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_3 :: EU Both FPU Pipes Active */
#define chv__l3_3__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_3 :: VS FPU0 Pipe Active */
#define chv__l3_3__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_3 :: VS FPU1 Pipe Active */
#define chv__l3_3__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_3 :: VS Send Pipe Active */
#define chv__l3_3__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_3 :: PS FPU0 Pipe Active */
#define chv__l3_3__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_3 :: PS FPU1 Pipe Active */
#define chv__l3_3__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_3 :: PS Send Pipeline Active */
#define chv__l3_3__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_3 :: FS Both FPU Active */
#define chv__l3_3__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_3 :: Rasterized Pixels */
#define chv__l3_3__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
#define chv__l3_3__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_3 :: Early Depth Test Fails */
#define chv__l3_3__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Samples Killed in FS */
#define chv__l3_3__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_3 :: Pixels Failing Tests */
#define chv__l3_3__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_3 :: Samples Written */
#define chv__l3_3__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_3 :: Samples Blended */
#define chv__l3_3__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_3 :: Sampler Texels */
#define chv__l3_3__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_3 :: Sampler Texels Misses */
#define chv__l3_3__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_3 :: SLM Bytes Read */
#define chv__l3_3__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_3 :: SLM Bytes Written */
#define chv__l3_3__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_3 :: Shader Memory Accesses */
#define chv__l3_3__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
#define chv__l3_3__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_3 :: L3 Shader Throughput */
#define chv__l3_3__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_3 :: Shader Barrier Messages */
#define chv__l3_3__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
#define chv__l3_3__l30_bank3_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_3 :: Slice1 L3 Bank3 Stalled */
#define chv__l3_3__l31_bank3_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_3 :: Slice1 L3 Bank3 Active */
#define chv__l3_3__l31_bank3_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
#define chv__l3_3__l30_bank3_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_3 :: SQ is full */
#define chv__l3_3__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_4 :: GPU Time Elapsed */
#define chv__l3_4__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_4 :: GPU Core Clocks */
#define chv__l3_4__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_4 :: AVG GPU Core Frequency */
#define chv__l3_4__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_4 :: AVG GPU Core Frequency */
#define chv__l3_4__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_4 :: GPU Busy */
#define chv__l3_4__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_4 :: VS Threads Dispatched */
#define chv__l3_4__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_4 :: HS Threads Dispatched */
#define chv__l3_4__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_4 :: DS Threads Dispatched */
#define chv__l3_4__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_4 :: GS Threads Dispatched */
#define chv__l3_4__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_4 :: FS Threads Dispatched */
#define chv__l3_4__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_4 :: CS Threads Dispatched */
#define chv__l3_4__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_4 :: EU Active */
#define chv__l3_4__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_4 :: EU Stall */
#define chv__l3_4__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_4 :: EU Both FPU Pipes Active */
#define chv__l3_4__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_4 :: VS FPU0 Pipe Active */
#define chv__l3_4__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_4 :: VS FPU1 Pipe Active */
#define chv__l3_4__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_4 :: VS Send Pipe Active */
#define chv__l3_4__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_4 :: PS FPU0 Pipe Active */
#define chv__l3_4__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_4 :: PS FPU1 Pipe Active */
#define chv__l3_4__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_4 :: PS Send Pipeline Active */
#define chv__l3_4__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_4 :: FS Both FPU Active */
#define chv__l3_4__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_4 :: Rasterized Pixels */
#define chv__l3_4__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_4 :: Early Hi-Depth Test Fails */
#define chv__l3_4__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_4 :: Early Depth Test Fails */
#define chv__l3_4__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_4 :: Samples Killed in FS */
#define chv__l3_4__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_4 :: Pixels Failing Tests */
#define chv__l3_4__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_4 :: Samples Written */
#define chv__l3_4__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_4 :: Samples Blended */
#define chv__l3_4__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_4 :: Sampler Texels */
#define chv__l3_4__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_4 :: Sampler Texels Misses */
#define chv__l3_4__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_4 :: SLM Bytes Read */
#define chv__l3_4__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_4 :: SLM Bytes Written */
#define chv__l3_4__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_4 :: Shader Memory Accesses */
#define chv__l3_4__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_4 :: Shader Atomic Memory Accesses */
#define chv__l3_4__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_4 :: L3 Shader Throughput */
#define chv__l3_4__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_4 :: Shader Barrier Messages */
#define chv__l3_4__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_4 :: Slice0 L3 Bank2 Stalled */
#define chv__l3_4__l30_bank2_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_4 :: Slice1 L3 Bank2 Stalled */
#define chv__l3_4__l31_bank2_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_4 :: Slice1 L3 Bank2 Active */
#define chv__l3_4__l31_bank2_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_4 :: Slice0 L3 Bank2 Active */
#define chv__l3_4__l30_bank2_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_4 :: SQ is full */
#define chv__l3_4__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
#define chv__rasterizer_and_pixel_backend__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
#define chv__rasterizer_and_pixel_backend__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define chv__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define chv__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
#define chv__rasterizer_and_pixel_backend__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
#define chv__rasterizer_and_pixel_backend__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
#define chv__rasterizer_and_pixel_backend__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
#define chv__rasterizer_and_pixel_backend__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
#define chv__rasterizer_and_pixel_backend__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
#define chv__rasterizer_and_pixel_backend__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
#define chv__rasterizer_and_pixel_backend__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set RasterizerAndPixelBackend :: EU Active */
#define chv__rasterizer_and_pixel_backend__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set RasterizerAndPixelBackend :: EU Stall */
#define chv__rasterizer_and_pixel_backend__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
#define chv__rasterizer_and_pixel_backend__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
#define chv__rasterizer_and_pixel_backend__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
#define chv__rasterizer_and_pixel_backend__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
#define chv__rasterizer_and_pixel_backend__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
#define chv__rasterizer_and_pixel_backend__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
#define chv__rasterizer_and_pixel_backend__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
#define chv__rasterizer_and_pixel_backend__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
#define chv__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
#define chv__rasterizer_and_pixel_backend__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
#define chv__rasterizer_and_pixel_backend__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
#define chv__rasterizer_and_pixel_backend__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
#define chv__rasterizer_and_pixel_backend__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
#define chv__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set RasterizerAndPixelBackend :: Samples Written */
#define chv__rasterizer_and_pixel_backend__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
#define chv__rasterizer_and_pixel_backend__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
#define chv__rasterizer_and_pixel_backend__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
#define chv__rasterizer_and_pixel_backend__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
#define chv__rasterizer_and_pixel_backend__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
#define chv__rasterizer_and_pixel_backend__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
#define chv__rasterizer_and_pixel_backend__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
#define chv__rasterizer_and_pixel_backend__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
#define chv__rasterizer_and_pixel_backend__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
#define chv__rasterizer_and_pixel_backend__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
#define chv__rasterizer_and_pixel_backend__rasterizer0_output_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice1 Post-EarlyZ Pixel Data Ready */
#define chv__rasterizer_and_pixel_backend__pixel_data1_ready__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
#define chv__rasterizer_and_pixel_backend__pixel_data0_ready__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice1 Rasterizer Input Available */
#define chv__rasterizer_and_pixel_backend__rasterizer1_input_available__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice1 Rasterizer Output Ready */
#define chv__rasterizer_and_pixel_backend__rasterizer1_output_ready__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
#define chv__rasterizer_and_pixel_backend__rasterizer0_input_available__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
#define chv__rasterizer_and_pixel_backend__pixel_values0_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
#define chv__rasterizer_and_pixel_backend__ps_output0_available__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice1 Pixel Values Ready */
#define chv__rasterizer_and_pixel_backend__pixel_values1_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set RasterizerAndPixelBackend :: Slice1 PS Output Available */
#define chv__rasterizer_and_pixel_backend__ps_output1_available__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set RasterizerAndPixelBackend :: SQ is full */
#define chv__rasterizer_and_pixel_backend__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler_1 :: GPU Time Elapsed */
#define chv__sampler_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler_1 :: GPU Core Clocks */
#define chv__sampler_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler_1 :: AVG GPU Core Frequency */
#define chv__sampler_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler_1 :: AVG GPU Core Frequency */
#define chv__sampler_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler_1 :: GPU Busy */
#define chv__sampler_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler_1 :: VS Threads Dispatched */
#define chv__sampler_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler_1 :: HS Threads Dispatched */
#define chv__sampler_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler_1 :: DS Threads Dispatched */
#define chv__sampler_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler_1 :: GS Threads Dispatched */
#define chv__sampler_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler_1 :: FS Threads Dispatched */
#define chv__sampler_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler_1 :: CS Threads Dispatched */
#define chv__sampler_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler_1 :: EU Active */
#define chv__sampler_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler_1 :: EU Stall */
#define chv__sampler_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler_1 :: EU Both FPU Pipes Active */
#define chv__sampler_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler_1 :: VS FPU0 Pipe Active */
#define chv__sampler_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler_1 :: VS FPU1 Pipe Active */
#define chv__sampler_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler_1 :: VS Send Pipe Active */
#define chv__sampler_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler_1 :: PS FPU0 Pipe Active */
#define chv__sampler_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler_1 :: PS FPU1 Pipe Active */
#define chv__sampler_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler_1 :: PS Send Pipeline Active */
#define chv__sampler_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler_1 :: FS Both FPU Active */
#define chv__sampler_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler_1 :: Rasterized Pixels */
#define chv__sampler_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler_1 :: Early Hi-Depth Test Fails */
#define chv__sampler_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler_1 :: Early Depth Test Fails */
#define chv__sampler_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler_1 :: Samples Killed in FS */
#define chv__sampler_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler_1 :: Pixels Failing Tests */
#define chv__sampler_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler_1 :: Samples Written */
#define chv__sampler_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler_1 :: Samples Blended */
#define chv__sampler_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler_1 :: Sampler Texels */
#define chv__sampler_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler_1 :: Sampler Texels Misses */
#define chv__sampler_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler_1 :: SLM Bytes Read */
#define chv__sampler_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler_1 :: SLM Bytes Written */
#define chv__sampler_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler_1 :: Shader Memory Accesses */
#define chv__sampler_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler_1 :: Shader Atomic Memory Accesses */
#define chv__sampler_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler_1 :: L3 Shader Throughput */
#define chv__sampler_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler_1 :: Shader Barrier Messages */
#define chv__sampler_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler_1 :: Slice1 Subslice1 Input Available */
#define chv__sampler_1__sampler11_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler_1 :: Slice1 Subslice2 Input Available */
#define chv__sampler_1__sampler12_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler_1 :: Slice1 Subslice0 Input Available */
#define chv__sampler_1__sampler10_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler_1 :: Slice1 Subslice2 Sampler Output Ready */
#define chv__sampler_1__sampler12_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler_1 :: Slice1 Subslice0 Sampler Output Ready */
#define chv__sampler_1__sampler10_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler_1 :: Slice1 Subslice1 Sampler Output Ready */
#define chv__sampler_1__sampler11_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler_1 :: SQ is full */
#define chv__sampler_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler_2 :: GPU Time Elapsed */
#define chv__sampler_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler_2 :: GPU Core Clocks */
#define chv__sampler_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler_2 :: AVG GPU Core Frequency */
#define chv__sampler_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler_2 :: AVG GPU Core Frequency */
#define chv__sampler_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler_2 :: GPU Busy */
#define chv__sampler_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler_2 :: VS Threads Dispatched */
#define chv__sampler_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler_2 :: HS Threads Dispatched */
#define chv__sampler_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler_2 :: DS Threads Dispatched */
#define chv__sampler_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler_2 :: GS Threads Dispatched */
#define chv__sampler_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler_2 :: FS Threads Dispatched */
#define chv__sampler_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler_2 :: CS Threads Dispatched */
#define chv__sampler_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler_2 :: EU Active */
#define chv__sampler_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler_2 :: EU Stall */
#define chv__sampler_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler_2 :: EU Both FPU Pipes Active */
#define chv__sampler_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler_2 :: VS FPU0 Pipe Active */
#define chv__sampler_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler_2 :: VS FPU1 Pipe Active */
#define chv__sampler_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler_2 :: VS Send Pipe Active */
#define chv__sampler_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler_2 :: PS FPU0 Pipe Active */
#define chv__sampler_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler_2 :: PS FPU1 Pipe Active */
#define chv__sampler_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler_2 :: PS Send Pipeline Active */
#define chv__sampler_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler_2 :: FS Both FPU Active */
#define chv__sampler_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler_2 :: Rasterized Pixels */
#define chv__sampler_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler_2 :: Early Hi-Depth Test Fails */
#define chv__sampler_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler_2 :: Early Depth Test Fails */
#define chv__sampler_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler_2 :: Samples Killed in FS */
#define chv__sampler_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler_2 :: Pixels Failing Tests */
#define chv__sampler_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler_2 :: Samples Written */
#define chv__sampler_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler_2 :: Samples Blended */
#define chv__sampler_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler_2 :: Sampler Texels */
#define chv__sampler_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler_2 :: Sampler Texels Misses */
#define chv__sampler_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler_2 :: SLM Bytes Read */
#define chv__sampler_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler_2 :: SLM Bytes Written */
#define chv__sampler_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler_2 :: Shader Memory Accesses */
#define chv__sampler_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler_2 :: Shader Atomic Memory Accesses */
#define chv__sampler_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler_2 :: L3 Shader Throughput */
#define chv__sampler_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler_2 :: Shader Barrier Messages */
#define chv__sampler_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler_2 :: Slice0 Subslice1 Input Available */
#define chv__sampler_2__sampler01_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler_2 :: Slice0 Subslice2 Input Available */
#define chv__sampler_2__sampler02_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler_2 :: Slice0 Subslice0 Input Available */
#define chv__sampler_2__sampler00_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler_2 :: Slice0 Subslice2 Sampler Output Ready */
#define chv__sampler_2__sampler02_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler_2 :: Slice0 Subslice0 Sampler Output Ready */
#define chv__sampler_2__sampler00_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler_2 :: Slice0 Subslice1 Sampler Output Ready */
#define chv__sampler_2__sampler01_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler_2 :: SQ is full */
#define chv__sampler_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_1 :: GPU Time Elapsed */
#define chv__tdl_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_1 :: GPU Core Clocks */
#define chv__tdl_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define chv__tdl_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define chv__tdl_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_1 :: GPU Busy */
#define chv__tdl_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_1 :: VS Threads Dispatched */
#define chv__tdl_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_1 :: HS Threads Dispatched */
#define chv__tdl_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_1 :: DS Threads Dispatched */
#define chv__tdl_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_1 :: GS Threads Dispatched */
#define chv__tdl_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_1 :: FS Threads Dispatched */
#define chv__tdl_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_1 :: CS Threads Dispatched */
#define chv__tdl_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_1 :: EU Active */
#define chv__tdl_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_1 :: EU Stall */
#define chv__tdl_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
#define chv__tdl_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
#define chv__tdl_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
#define chv__tdl_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_1 :: VS Send Pipe Active */
#define chv__tdl_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
#define chv__tdl_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
#define chv__tdl_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_1 :: PS Send Pipeline Active */
#define chv__tdl_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_1 :: FS Both FPU Active */
#define chv__tdl_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_1 :: Rasterized Pixels */
#define chv__tdl_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
#define chv__tdl_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_1 :: Early Depth Test Fails */
#define chv__tdl_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: Samples Killed in FS */
#define chv__tdl_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_1 :: Pixels Failing Tests */
#define chv__tdl_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_1 :: Samples Written */
#define chv__tdl_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_1 :: Samples Blended */
#define chv__tdl_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_1 :: Sampler Texels */
#define chv__tdl_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_1 :: Sampler Texels Misses */
#define chv__tdl_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_1 :: SLM Bytes Read */
#define chv__tdl_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_1 :: SLM Bytes Written */
#define chv__tdl_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_1 :: Shader Memory Accesses */
#define chv__tdl_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
#define chv__tdl_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_1 :: L3 Shader Throughput */
#define chv__tdl_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_1 :: Shader Barrier Messages */
#define chv__tdl_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice1 Subslice1 */
#define chv__tdl_1__non_ps_thread11_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice0 */
#define chv__tdl_1__ps_thread10_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice1 Subslice0 */
#define chv__tdl_1__non_ps_thread10_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice2 */
#define chv__tdl_1__ps_thread12_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice1 Subslice2 */
#define chv__tdl_1__non_ps_thread12_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice1 */
#define chv__tdl_1__ps_thread11_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice1 Port 0 */
#define chv__tdl_1__thread_header01_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice0 Port 1 */
#define chv__tdl_1__thread_header00_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice0 Port 0 */
#define chv__tdl_1__thread_header00_ready_port0__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice2 Port 1 */
#define chv__tdl_1__thread_header02_ready_port1__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice2 Port 0 */
#define chv__tdl_1__thread_header02_ready_port0__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice1 Port 1 */
#define chv__tdl_1__thread_header01_ready_port1__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_1 :: SQ is full */
#define chv__tdl_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_2 :: GPU Time Elapsed */
#define chv__tdl_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_2 :: GPU Core Clocks */
#define chv__tdl_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define chv__tdl_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define chv__tdl_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_2 :: GPU Busy */
#define chv__tdl_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_2 :: VS Threads Dispatched */
#define chv__tdl_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_2 :: HS Threads Dispatched */
#define chv__tdl_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_2 :: DS Threads Dispatched */
#define chv__tdl_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_2 :: GS Threads Dispatched */
#define chv__tdl_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_2 :: FS Threads Dispatched */
#define chv__tdl_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_2 :: CS Threads Dispatched */
#define chv__tdl_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_2 :: EU Active */
#define chv__tdl_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_2 :: EU Stall */
#define chv__tdl_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
#define chv__tdl_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
#define chv__tdl_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
#define chv__tdl_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_2 :: VS Send Pipe Active */
#define chv__tdl_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
#define chv__tdl_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
#define chv__tdl_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_2 :: PS Send Pipeline Active */
#define chv__tdl_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_2 :: FS Both FPU Active */
#define chv__tdl_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_2 :: Rasterized Pixels */
#define chv__tdl_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
#define chv__tdl_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_2 :: Early Depth Test Fails */
#define chv__tdl_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Samples Killed in FS */
#define chv__tdl_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_2 :: Pixels Failing Tests */
#define chv__tdl_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_2 :: Samples Written */
#define chv__tdl_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_2 :: Samples Blended */
#define chv__tdl_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_2 :: Sampler Texels */
#define chv__tdl_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_2 :: Sampler Texels Misses */
#define chv__tdl_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_2 :: SLM Bytes Read */
#define chv__tdl_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_2 :: SLM Bytes Written */
#define chv__tdl_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_2 :: Shader Memory Accesses */
#define chv__tdl_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
#define chv__tdl_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_2 :: L3 Shader Throughput */
#define chv__tdl_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_2 :: Shader Barrier Messages */
#define chv__tdl_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
#define chv__tdl_2__non_ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice2 */
#define chv__tdl_2__ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice1 */
#define chv__tdl_2__ps_thread01_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice0 */
#define chv__tdl_2__ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_2 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
#define chv__tdl_2__non_ps_thread01_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_2 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
#define chv__tdl_2__non_ps_thread00_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice2 Port 0 */
#define chv__tdl_2__thread_header12_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice2 Port 1 */
#define chv__tdl_2__thread_header12_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice1 Port 1 */
#define chv__tdl_2__thread_header11_ready_port1__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice0 Port 0 */
#define chv__tdl_2__thread_header10_ready_port0__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice0 Port 1 */
#define chv__tdl_2__thread_header10_ready_port1__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice1 Port 0 */
#define chv__tdl_2__thread_header11_ready_port0__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_2 :: SQ is full */
#define chv__tdl_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* MDAPI testing set :: GPU Time Elapsed */
#define chv__test_oa__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* MDAPI testing set :: GPU Core Clocks */
#define chv__test_oa__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define chv__test_oa__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define chv__test_oa__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* MDAPI testing set :: TestCounter0 */
#define chv__test_oa__counter0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* MDAPI testing set :: TestCounter1 */
#define chv__test_oa__counter1__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* MDAPI testing set :: TestCounter2 */
#define chv__test_oa__counter2__read \
   hsw__compute_extended__eu_typed_reads0__read

/* MDAPI testing set :: TestCounter3 */
#define chv__test_oa__counter3__read \
   hsw__compute_extended__eu_typed_writes0__read

/* MDAPI testing set :: TestCounter4 */
#define chv__test_oa__counter4__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* MDAPI testing set :: TestCounter5 */
#define chv__test_oa__counter5__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* MDAPI testing set :: TestCounter6 */
#define chv__test_oa__counter6__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* MDAPI testing set :: TestCounter7 */
#define chv__test_oa__counter7__read \
   hsw__compute_extended__gpu_clocks__read

/* MDAPI testing set :: TestCounter8 */
#define chv__test_oa__counter8__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Render Metrics Basic set :: GPU Time Elapsed */
#define sklgt2__render_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics Basic set :: GPU Core Clocks */
#define sklgt2__render_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt2__render_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt2__render_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics Basic set :: VS Threads Dispatched */
#define sklgt2__render_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics Basic set :: HS Threads Dispatched */
#define sklgt2__render_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics Basic set :: DS Threads Dispatched */
#define sklgt2__render_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics Basic set :: GS Threads Dispatched */
#define sklgt2__render_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics Basic set :: FS Threads Dispatched */
#define sklgt2__render_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics Basic set :: CS Threads Dispatched */
#define sklgt2__render_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics Basic set :: GPU Busy */
#define sklgt2__render_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics Basic set :: EU Active */
#define sklgt2__render_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics Basic set :: EU Stall */
#define sklgt2__render_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
#define sklgt2__render_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
#define sklgt2__render_basic__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
#define sklgt2__render_basic__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Render Metrics Basic set :: VS Send Pipe Active */
#define sklgt2__render_basic__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
#define sklgt2__render_basic__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
#define sklgt2__render_basic__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Render Metrics Basic set :: PS Send Pipeline Active */
#define sklgt2__render_basic__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Render Metrics Basic set :: FS Both FPU Active */
#define sklgt2__render_basic__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Render Metrics Basic set :: Sampler 0 Busy */
#define sklgt2__render_basic__sampler0_busy__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics Basic set :: Sampler 1 Busy */
#define sklgt2__render_basic__sampler1_busy__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics Basic set :: Samplers Busy */
#define sklgt2__render_basic__samplers_busy__read \
   bdw__render_basic__samplers_busy__read

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
#define sklgt2__render_basic__sampler0_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
#define sklgt2__render_basic__sampler1_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics Basic set :: Rasterized Pixels */
#define sklgt2__render_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
#define sklgt2__render_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics Basic set :: Early Depth Test Fails */
#define sklgt2__render_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: Samples Killed in FS */
#define sklgt2__render_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics Basic set :: Pixels Failing Tests */
#define sklgt2__render_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics Basic set :: Samples Written */
#define sklgt2__render_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics Basic set :: Samples Blended */
#define sklgt2__render_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics Basic set :: Sampler Texels */
#define sklgt2__render_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics Basic set :: Sampler Texels Misses */
#define sklgt2__render_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics Basic set :: Sampler Cache Misses */
static uint64_t
sklgt2__render_basic__sampler_l1_misses__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ 8 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 8;

   return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Read */
#define sklgt2__render_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics Basic set :: SLM Bytes Written */
#define sklgt2__render_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics Basic set :: Shader Memory Accesses */
#define sklgt2__render_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
#define sklgt2__render_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
static uint64_t
sklgt2__render_basic__l3_lookups__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
   uint64_t tmp0 = sklgt2__render_basic__sampler_l1_misses__read(perf, query, results) + sklgt2__render_basic__shader_memory_accesses__read(perf, query, results);

   return tmp0;
}

/* Render Metrics Basic set :: L3 Misses */
#define sklgt2__render_basic__l3_misses__read \
   hsw__compute_extended__typed_atomics0__read

/* Render Metrics Basic set :: L3 Sampler Throughput */
static uint64_t
sklgt2__render_basic__l3_sampler_throughput__read(UNUSED struct intel_perf_config *perf,
                                                  const struct intel_perf_query_info *query,
                                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: $SamplerL1Misses 64 UMUL */
   uint64_t tmp0 = sklgt2__render_basic__sampler_l1_misses__read(perf, query, results) * 64;

   return tmp0;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
#define sklgt2__render_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics Basic set :: Shader Barrier Messages */
#define sklgt2__render_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
#define sklgt2__render_basic__gti_vf_throughput__read \
   bdw__render_basic__gti_vf_throughput__read

/* Render Metrics Basic set :: GTI Depth Throughput */
#define sklgt2__render_basic__gti_depth_throughput__read \
   bdw__render_basic__gti_depth_throughput__read

/* Render Metrics Basic set :: GTI RCC Throughput */
#define sklgt2__render_basic__gti_rcc_throughput__read \
   bdw__render_basic__gti_rcc_throughput__read

/* Render Metrics Basic set :: GTI L3 Throughput */
#define sklgt2__render_basic__gti_l3_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Render Metrics Basic set :: GTI HDC TLB Lookup Throughput */
#define sklgt2__render_basic__gti_hdc_lookups_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics Basic set :: GTI Read Throughput */
#define sklgt2__render_basic__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Render Metrics Basic set :: GTI Write Throughput */
#define sklgt2__render_basic__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Render Metrics Basic set :: Samplers Bottleneck */
#define sklgt2__render_basic__sampler_bottleneck__read \
   bdw__render_basic__sampler_bottleneck__read

/* Compute Metrics Basic set :: GPU Time Elapsed */
#define sklgt2__compute_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Basic set :: GPU Core Clocks */
#define sklgt2__compute_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt2__compute_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt2__compute_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Basic set :: GPU Busy */
#define sklgt2__compute_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics Basic set :: VS Threads Dispatched */
#define sklgt2__compute_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: HS Threads Dispatched */
#define sklgt2__compute_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics Basic set :: DS Threads Dispatched */
#define sklgt2__compute_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics Basic set :: GS Threads Dispatched */
#define sklgt2__compute_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: FS Threads Dispatched */
#define sklgt2__compute_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics Basic set :: CS Threads Dispatched */
#define sklgt2__compute_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Basic set :: EU Active */
#define sklgt2__compute_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Basic set :: EU Stall */
#define sklgt2__compute_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Basic set :: EU Both FPU Pipes Active */
#define sklgt2__compute_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Basic set :: EU FPU0 Pipe Active */
#define sklgt2__compute_basic__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Basic set :: EU FPU1 Pipe Active */
#define sklgt2__compute_basic__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Basic set :: EU AVG IPC Rate */
#define sklgt2__compute_basic__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Basic set :: EU Send Pipe Active */
#define sklgt2__compute_basic__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Basic set :: EU Thread Occupancy */
#define sklgt2__compute_basic__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Basic set :: Rasterized Pixels */
#define sklgt2__compute_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics Basic set :: Early Hi-Depth Test Fails */
#define sklgt2__compute_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics Basic set :: Early Depth Test Fails */
#define sklgt2__compute_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Killed in FS */
#define sklgt2__compute_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics Basic set :: Pixels Failing Tests */
#define sklgt2__compute_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics Basic set :: Samples Written */
#define sklgt2__compute_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics Basic set :: Samples Blended */
#define sklgt2__compute_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics Basic set :: Sampler Texels */
#define sklgt2__compute_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Basic set :: Sampler Texels Misses */
#define sklgt2__compute_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Basic set :: SLM Bytes Read */
#define sklgt2__compute_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Basic set :: SLM Bytes Written */
#define sklgt2__compute_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Basic set :: Shader Memory Accesses */
#define sklgt2__compute_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Basic set :: Shader Atomic Memory Accesses */
#define sklgt2__compute_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Basic set :: L3 Shader Throughput */
#define sklgt2__compute_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Basic set :: Shader Barrier Messages */
#define sklgt2__compute_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Typed Bytes Read */
#define sklgt2__compute_basic__typed_bytes_read__read \
   bdw__compute_basic__typed_bytes_read__read

/* Compute Metrics Basic set :: Typed Bytes Written */
#define sklgt2__compute_basic__typed_bytes_written__read \
   bdw__compute_basic__typed_bytes_written__read

/* Compute Metrics Basic set :: Untyped Bytes Read */
#define sklgt2__compute_basic__untyped_bytes_read__read \
   bdw__compute_basic__untyped_bytes_read__read

/* Compute Metrics Basic set :: Untyped Writes */
#define sklgt2__compute_basic__untyped_bytes_written__read \
   bdw__compute_basic__untyped_bytes_written__read

/* Compute Metrics Basic set :: GTI Read Throughput */
#define sklgt2__compute_basic__gti_read_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Compute Metrics Basic set :: GTI Write Throughput */
#define sklgt2__compute_basic__gti_write_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Time Elapsed */
#define sklgt2__render_pipe_profile__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Core Clocks */
#define sklgt2__render_pipe_profile__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define sklgt2__render_pipe_profile__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define sklgt2__render_pipe_profile__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics set for 3D Pipeline Profile :: GPU Busy */
#define sklgt2__render_pipe_profile__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics set for 3D Pipeline Profile :: VS Threads Dispatched */
#define sklgt2__render_pipe_profile__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: HS Threads Dispatched */
#define sklgt2__render_pipe_profile__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: DS Threads Dispatched */
#define sklgt2__render_pipe_profile__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics set for 3D Pipeline Profile :: GS Threads Dispatched */
#define sklgt2__render_pipe_profile__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: FS Threads Dispatched */
#define sklgt2__render_pipe_profile__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics set for 3D Pipeline Profile :: CS Threads Dispatched */
#define sklgt2__render_pipe_profile__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: EU Active */
#define sklgt2__render_pipe_profile__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics set for 3D Pipeline Profile :: EU Stall */
#define sklgt2__render_pipe_profile__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics set for 3D Pipeline Profile :: Rasterized Pixels */
#define sklgt2__render_pipe_profile__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics set for 3D Pipeline Profile :: Early Hi-Depth Test Fails */
#define sklgt2__render_pipe_profile__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Test Fails */
#define sklgt2__render_pipe_profile__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Killed in FS */
#define sklgt2__render_pipe_profile__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics set for 3D Pipeline Profile :: Pixels Failing Tests */
#define sklgt2__render_pipe_profile__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Written */
#define sklgt2__render_pipe_profile__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Blended */
#define sklgt2__render_pipe_profile__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels */
#define sklgt2__render_pipe_profile__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels Misses */
#define sklgt2__render_pipe_profile__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Read */
#define sklgt2__render_pipe_profile__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Written */
#define sklgt2__render_pipe_profile__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Memory Accesses */
#define sklgt2__render_pipe_profile__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Atomic Memory Accesses */
#define sklgt2__render_pipe_profile__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics set for 3D Pipeline Profile :: L3 Shader Throughput */
#define sklgt2__render_pipe_profile__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Barrier Messages */
#define sklgt2__render_pipe_profile__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: VF Bottleneck */
#define sklgt2__render_pipe_profile__vf_bottleneck__read \
   bdw__render_pipe_profile__vf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: VS Bottleneck */
#define sklgt2__render_pipe_profile__vs_bottleneck__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics set for 3D Pipeline Profile :: HS Bottleneck */
#define sklgt2__render_pipe_profile__hs_bottleneck__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics set for 3D Pipeline Profile :: DS Bottleneck */
#define sklgt2__render_pipe_profile__ds_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: GS Bottleneck */
#define sklgt2__render_pipe_profile__gs_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: SO Bottleneck */
#define sklgt2__render_pipe_profile__so_bottleneck__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Clipper Bottleneck */
#define sklgt2__render_pipe_profile__cl_bottleneck__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Strip-Fans Bottleneck */
#define sklgt2__render_pipe_profile__sf_bottleneck__read \
   bdw__render_pipe_profile__sf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Hi-Depth Bottleneck */
#define sklgt2__render_pipe_profile__hi_depth_bottleneck__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Bottleneck */
#define sklgt2__render_pipe_profile__early_depth_bottleneck__read \
   bdw__render_pipe_profile__early_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: BC Bottleneck */
#define sklgt2__render_pipe_profile__bc_bottleneck__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: HS Stall */
#define sklgt2__render_pipe_profile__hs_stall__read \
   bdw__render_pipe_profile__hs_stall__read

/* Render Metrics set for 3D Pipeline Profile :: DS Stall */
#define sklgt2__render_pipe_profile__ds_stall__read \
   bdw__render_pipe_profile__ds_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SO Stall */
#define sklgt2__render_pipe_profile__so_stall__read \
   bdw__render_pipe_profile__so_stall__read

/* Render Metrics set for 3D Pipeline Profile :: CL Stall */
#define sklgt2__render_pipe_profile__cl_stall__read \
   bdw__render_pipe_profile__cl_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SF Stall */
#define sklgt2__render_pipe_profile__sf_stall__read \
   bdw__render_pipe_profile__sf_stall__read

/* Memory Reads Distribution metrics set :: GPU Time Elapsed */
#define sklgt2__memory_reads__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Reads Distribution metrics set :: GPU Core Clocks */
#define sklgt2__memory_reads__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt2__memory_reads__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt2__memory_reads__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Reads Distribution metrics set :: GPU Busy */
#define sklgt2__memory_reads__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Reads Distribution metrics set :: VS Threads Dispatched */
#define sklgt2__memory_reads__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: HS Threads Dispatched */
#define sklgt2__memory_reads__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Reads Distribution metrics set :: DS Threads Dispatched */
#define sklgt2__memory_reads__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Reads Distribution metrics set :: GS Threads Dispatched */
#define sklgt2__memory_reads__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: FS Threads Dispatched */
#define sklgt2__memory_reads__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Reads Distribution metrics set :: CS Threads Dispatched */
#define sklgt2__memory_reads__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Reads Distribution metrics set :: EU Active */
#define sklgt2__memory_reads__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Reads Distribution metrics set :: EU Stall */
#define sklgt2__memory_reads__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Reads Distribution metrics set :: Rasterized Pixels */
#define sklgt2__memory_reads__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Reads Distribution metrics set :: Early Hi-Depth Test Fails */
#define sklgt2__memory_reads__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Early Depth Test Fails */
#define sklgt2__memory_reads__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Samples Killed in FS */
#define sklgt2__memory_reads__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Reads Distribution metrics set :: Pixels Failing Tests */
#define sklgt2__memory_reads__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Reads Distribution metrics set :: Samples Written */
#define sklgt2__memory_reads__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Reads Distribution metrics set :: Samples Blended */
#define sklgt2__memory_reads__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Reads Distribution metrics set :: Sampler Texels */
#define sklgt2__memory_reads__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Reads Distribution metrics set :: Sampler Texels Misses */
#define sklgt2__memory_reads__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Reads Distribution metrics set :: SLM Bytes Read */
#define sklgt2__memory_reads__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Reads Distribution metrics set :: SLM Bytes Written */
#define sklgt2__memory_reads__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Reads Distribution metrics set :: Shader Memory Accesses */
#define sklgt2__memory_reads__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Reads Distribution metrics set :: Shader Atomic Memory Accesses */
#define sklgt2__memory_reads__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Reads Distribution metrics set :: Shader Barrier Messages */
#define sklgt2__memory_reads__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: GtiCmdStreamerMemoryReads */
#define sklgt2__memory_reads__gti_cmd_streamer_memory_reads__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Reads Distribution metrics set :: GtiRsMemoryReads */
#define sklgt2__memory_reads__gti_rs_memory_reads__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Reads Distribution metrics set :: GtiVfMemoryReads */
#define sklgt2__memory_reads__gti_vf_memory_reads__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Memory Reads Distribution metrics set :: GtiRccMemoryReads */
#define sklgt2__memory_reads__gti_rcc_memory_reads__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiMscMemoryReads */
#define sklgt2__memory_reads__gti_msc_memory_reads__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Reads Distribution metrics set :: GtiHizMemoryReads */
#define sklgt2__memory_reads__gti_hiz_memory_reads__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiStcMemoryReads */
#define sklgt2__memory_reads__gti_stc_memory_reads__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Reads Distribution metrics set :: GtiRczMemoryReads */
#define sklgt2__memory_reads__gti_rcz_memory_reads__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Reads Distribution metrics set :: GtiMemoryReads */
#define sklgt2__memory_reads__gti_memory_reads__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank0Reads */
#define sklgt2__memory_reads__gti_l3_bank0_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank1Reads */
#define sklgt2__memory_reads__gti_l3_bank1_reads__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Reads Distribution metrics set :: GtiL3Bank2Reads */
#define sklgt2__memory_reads__gti_l3_bank2_reads__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Reads Distribution metrics set :: GtiL3Bank3Reads */
#define sklgt2__memory_reads__gti_l3_bank3_reads__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: GtiL3Reads */
#define sklgt2__memory_reads__gti_l3_reads__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Reads Distribution metrics set :: GtiRingAccesses */
#define sklgt2__memory_reads__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Memory Writes Distribution metrics set :: GPU Time Elapsed */
#define sklgt2__memory_writes__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Writes Distribution metrics set :: GPU Core Clocks */
#define sklgt2__memory_writes__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt2__memory_writes__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt2__memory_writes__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Writes Distribution metrics set :: GPU Busy */
#define sklgt2__memory_writes__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Writes Distribution metrics set :: VS Threads Dispatched */
#define sklgt2__memory_writes__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: HS Threads Dispatched */
#define sklgt2__memory_writes__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Writes Distribution metrics set :: DS Threads Dispatched */
#define sklgt2__memory_writes__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Writes Distribution metrics set :: GS Threads Dispatched */
#define sklgt2__memory_writes__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: FS Threads Dispatched */
#define sklgt2__memory_writes__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Writes Distribution metrics set :: CS Threads Dispatched */
#define sklgt2__memory_writes__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Writes Distribution metrics set :: EU Active */
#define sklgt2__memory_writes__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Writes Distribution metrics set :: EU Stall */
#define sklgt2__memory_writes__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Writes Distribution metrics set :: Rasterized Pixels */
#define sklgt2__memory_writes__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Writes Distribution metrics set :: Early Hi-Depth Test Fails */
#define sklgt2__memory_writes__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Early Depth Test Fails */
#define sklgt2__memory_writes__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Samples Killed in FS */
#define sklgt2__memory_writes__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Writes Distribution metrics set :: Pixels Failing Tests */
#define sklgt2__memory_writes__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Writes Distribution metrics set :: Samples Written */
#define sklgt2__memory_writes__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Writes Distribution metrics set :: Samples Blended */
#define sklgt2__memory_writes__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Writes Distribution metrics set :: Sampler Texels */
#define sklgt2__memory_writes__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Writes Distribution metrics set :: Sampler Texels Misses */
#define sklgt2__memory_writes__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Writes Distribution metrics set :: SLM Bytes Read */
#define sklgt2__memory_writes__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Writes Distribution metrics set :: SLM Bytes Written */
#define sklgt2__memory_writes__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Writes Distribution metrics set :: Shader Memory Accesses */
#define sklgt2__memory_writes__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Writes Distribution metrics set :: Shader Atomic Memory Accesses */
#define sklgt2__memory_writes__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Writes Distribution metrics set :: L3 Shader Throughput */
#define sklgt2__memory_writes__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Memory Writes Distribution metrics set :: Shader Barrier Messages */
#define sklgt2__memory_writes__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: GtiCmdStreamerMemoryWrites */
#define sklgt2__memory_writes__gti_cmd_streamer_memory_writes__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Writes Distribution metrics set :: GtiSoMemoryWrites */
#define sklgt2__memory_writes__gti_so_memory_writes__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Writes Distribution metrics set :: GtiRccMemoryWrites */
#define sklgt2__memory_writes__gti_rcc_memory_writes__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiMscMemoryWrites */
#define sklgt2__memory_writes__gti_msc_memory_writes__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Writes Distribution metrics set :: GtiHizMemoryWrites */
#define sklgt2__memory_writes__gti_hiz_memory_writes__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiStcMemoryWrites */
#define sklgt2__memory_writes__gti_stc_memory_writes__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Writes Distribution metrics set :: GtiRczMemoryWrites */
#define sklgt2__memory_writes__gti_rcz_memory_writes__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Writes Distribution metrics set :: GtiMemoryWrites */
#define sklgt2__memory_writes__gti_memory_writes__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank0Writes */
#define sklgt2__memory_writes__gti_l3_bank0_writes__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank1Writes */
#define sklgt2__memory_writes__gti_l3_bank1_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Writes Distribution metrics set :: GtiL3Bank2Writes */
#define sklgt2__memory_writes__gti_l3_bank2_writes__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Writes Distribution metrics set :: GtiL3Bank3Writes */
#define sklgt2__memory_writes__gti_l3_bank3_writes__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: GtiL3Writes */
#define sklgt2__memory_writes__gti_l3_writes__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Writes Distribution metrics set :: GtiRingAccesses */
#define sklgt2__memory_writes__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Compute Metrics Extended metrics set :: GPU Time Elapsed */
#define sklgt2__compute_extended__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extended metrics set :: GPU Core Clocks */
#define sklgt2__compute_extended__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended metrics set :: AVG GPU Core Frequency */
#define sklgt2__compute_extended__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extended metrics set :: AVG GPU Core Frequency */
#define sklgt2__compute_extended__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extended metrics set :: CS Threads Dispatched */
#define sklgt2__compute_extended__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Extended metrics set :: EU Active */
#define sklgt2__compute_extended__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Extended metrics set :: EU Stall */
#define sklgt2__compute_extended__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extended metrics set :: EU Both FPU Pipes Active */
#define sklgt2__compute_extended__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Extended metrics set :: EU FPU0 Pipe Active */
#define sklgt2__compute_extended__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Extended metrics set :: EU FPU1 Pipe Active */
#define sklgt2__compute_extended__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Extended metrics set :: EU AVG IPC Rate */
#define sklgt2__compute_extended__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Extended metrics set :: EU Send Pipe Active */
#define sklgt2__compute_extended__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Extended metrics set :: EU Thread Occupancy */
#define sklgt2__compute_extended__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Extended metrics set :: Sampler Texels */
#define sklgt2__compute_extended__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Extended metrics set :: Sampler Texels Misses */
#define sklgt2__compute_extended__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Extended metrics set :: SLM Bytes Read */
#define sklgt2__compute_extended__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Extended metrics set :: SLM Bytes Written */
#define sklgt2__compute_extended__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Extended metrics set :: Shader Memory Accesses */
#define sklgt2__compute_extended__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Extended metrics set :: Shader Atomic Memory Accesses */
#define sklgt2__compute_extended__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Extended metrics set :: L3 Shader Throughput */
#define sklgt2__compute_extended__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Extended metrics set :: Shader Barrier Messages */
#define sklgt2__compute_extended__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Extended metrics set :: EuUntypedReads0 */
#define sklgt2__compute_extended__eu_untyped_reads0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Compute Metrics Extended metrics set :: EuTypedReads0 */
#define sklgt2__compute_extended__eu_typed_reads0__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Compute Metrics Extended metrics set :: EuUntypedWrites0 */
#define sklgt2__compute_extended__eu_untyped_writes0__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Compute Metrics Extended metrics set :: EuTypedWrites0 */
#define sklgt2__compute_extended__eu_typed_writes0__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Compute Metrics Extended metrics set :: EuUntypedAtomics0 */
#define sklgt2__compute_extended__eu_untyped_atomics0__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Compute Metrics Extended metrics set :: EuTypedAtomics0 */
#define sklgt2__compute_extended__eu_typed_atomics0__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Compute Metrics Extended metrics set :: EuA64UntypedReads0 */
#define sklgt2__compute_extended__eu_a64_untyped_reads0__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Compute Metrics Extended metrics set :: EuA64UntypedWrites0 */
#define sklgt2__compute_extended__eu_a64_untyped_writes0__read \
   hsw__compute_extended__gpu_clocks__read

/* Compute Metrics Extended metrics set :: Typed Reads 0 */
#define sklgt2__compute_extended__typed_reads0__read \
   hsw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended metrics set :: Typed Writes 0 */
#define sklgt2__compute_extended__typed_writes0__read \
   hsw__compute_extended__typed_writes0__read

/* Compute Metrics Extended metrics set :: Untyped Reads 0 */
#define sklgt2__compute_extended__untyped_reads0__read \
   hsw__compute_extended__untyped_reads0__read

/* Compute Metrics Extended metrics set :: Untyped Writes 0 */
#define sklgt2__compute_extended__untyped_writes0__read \
   hsw__compute_extended__untyped_writes0__read

/* Compute Metrics Extended metrics set :: Typed Atomics 0 */
#define sklgt2__compute_extended__typed_atomics0__read \
   hsw__compute_extended__typed_atomics0__read

/* Compute Metrics Extended metrics set :: TypedReadsPerCacheLine */
#define sklgt2__compute_extended__typed_reads_per_cache_line__read \
   hsw__compute_extended__typed_reads_per_cache_line__read

/* Compute Metrics Extended metrics set :: TypedWritesPerCacheLine */
#define sklgt2__compute_extended__typed_writes_per_cache_line__read \
   hsw__compute_extended__typed_writes_per_cache_line__read

/* Compute Metrics Extended metrics set :: UntypedReadsPerCacheLine */
#define sklgt2__compute_extended__untyped_reads_per_cache_line__read \
   bdw__compute_extended__untyped_reads_per_cache_line__read

/* Compute Metrics Extended metrics set :: UntypedWritesPerCacheLine */
#define sklgt2__compute_extended__untyped_writes_per_cache_line__read \
   bdw__compute_extended__untyped_writes_per_cache_line__read

/* Compute Metrics Extended metrics set :: TypedAtomicsPerCacheLine */
#define sklgt2__compute_extended__typed_atomics_per_cache_line__read \
   hsw__compute_extended__typed_atomics_per_cache_line__read

/* Compute Metrics L3 Cache metrics set :: GPU Time Elapsed */
#define sklgt2__compute_l3_cache__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics L3 Cache metrics set :: GPU Core Clocks */
#define sklgt2__compute_l3_cache__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics L3 Cache metrics set :: AVG GPU Core Frequency */
#define sklgt2__compute_l3_cache__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics L3 Cache metrics set :: AVG GPU Core Frequency */
#define sklgt2__compute_l3_cache__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics L3 Cache metrics set :: GPU Busy */
#define sklgt2__compute_l3_cache__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics L3 Cache metrics set :: VS Threads Dispatched */
#define sklgt2__compute_l3_cache__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache metrics set :: HS Threads Dispatched */
#define sklgt2__compute_l3_cache__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics L3 Cache metrics set :: DS Threads Dispatched */
#define sklgt2__compute_l3_cache__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics L3 Cache metrics set :: GS Threads Dispatched */
#define sklgt2__compute_l3_cache__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache metrics set :: FS Threads Dispatched */
#define sklgt2__compute_l3_cache__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics L3 Cache metrics set :: CS Threads Dispatched */
#define sklgt2__compute_l3_cache__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics L3 Cache metrics set :: EU Active */
#define sklgt2__compute_l3_cache__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics L3 Cache metrics set :: EU Stall */
#define sklgt2__compute_l3_cache__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics L3 Cache metrics set :: EU Both FPU Pipes Active */
#define sklgt2__compute_l3_cache__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics L3 Cache metrics set :: EU FPU0 Pipe Active */
#define sklgt2__compute_l3_cache__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics L3 Cache metrics set :: EU FPU1 Pipe Active */
#define sklgt2__compute_l3_cache__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics L3 Cache metrics set :: EU AVG IPC Rate */
#define sklgt2__compute_l3_cache__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics L3 Cache metrics set :: EU Send Pipe Active */
#define sklgt2__compute_l3_cache__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics L3 Cache metrics set :: EU FPU0 Hybrid Instruction */
#define sklgt2__compute_l3_cache__eu_hybrid_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* Compute Metrics L3 Cache metrics set :: EU FPU1 Hybrid Instruction */
#define sklgt2__compute_l3_cache__eu_hybrid_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* Compute Metrics L3 Cache metrics set :: EU FPU0 Ternary Instruction */
#define sklgt2__compute_l3_cache__eu_ternary_fpu0_instruction__read \
   bdw__render_basic__ps_fpu0_active__read

/* Compute Metrics L3 Cache metrics set :: EU FPU1 Ternary Instruction */
#define sklgt2__compute_l3_cache__eu_ternary_fpu1_instruction__read \
   bdw__render_basic__ps_fpu1_active__read

/* Compute Metrics L3 Cache metrics set :: EU FPU0 Binary Instruction */
#define sklgt2__compute_l3_cache__eu_binary_fpu0_instruction__read \
   bdw__render_basic__ps_send_active__read

/* Compute Metrics L3 Cache metrics set :: EU FPU1 Binary Instruction */
#define sklgt2__compute_l3_cache__eu_binary_fpu1_instruction__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Compute Metrics L3 Cache metrics set :: EU FPU0 Move Instruction */
#define sklgt2__compute_l3_cache__eu_move_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu0_instruction__read

/* Compute Metrics L3 Cache metrics set :: EU FPU1 Move Instruction */
#define sklgt2__compute_l3_cache__eu_move_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu1_instruction__read

/* Compute Metrics L3 Cache metrics set :: Rasterized Pixels */
#define sklgt2__compute_l3_cache__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics L3 Cache metrics set :: Early Hi-Depth Test Fails */
#define sklgt2__compute_l3_cache__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics L3 Cache metrics set :: Early Depth Test Fails */
#define sklgt2__compute_l3_cache__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache metrics set :: Samples Killed in FS */
#define sklgt2__compute_l3_cache__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics L3 Cache metrics set :: Pixels Failing Tests */
#define sklgt2__compute_l3_cache__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics L3 Cache metrics set :: Samples Written */
#define sklgt2__compute_l3_cache__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics L3 Cache metrics set :: Samples Blended */
#define sklgt2__compute_l3_cache__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics L3 Cache metrics set :: Sampler Accesses */
#define sklgt2__compute_l3_cache__sampler_accesses__read \
   bdw__render_pipe_profile__sampler_accesses__read

/* Compute Metrics L3 Cache metrics set :: Sampler Texels */
#define sklgt2__compute_l3_cache__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics L3 Cache metrics set :: Sampler Texels Misses */
#define sklgt2__compute_l3_cache__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics L3 Cache metrics set :: SLM Bytes Read */
#define sklgt2__compute_l3_cache__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics L3 Cache metrics set :: SLM Bytes Written */
#define sklgt2__compute_l3_cache__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics L3 Cache metrics set :: Shader Memory Accesses */
#define sklgt2__compute_l3_cache__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics L3 Cache metrics set :: Shader Atomic Memory Accesses */
#define sklgt2__compute_l3_cache__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics L3 Cache metrics set :: L3 Accesses */
static uint64_t
sklgt2__compute_l3_cache__l3_accesses__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: C 0 READ C 1 READ B 2 READ B 3 READ UADD UADD UADD 2 UMUL */
   uint64_t tmp0 = results->accumulator[query->c_offset + 0];
   uint64_t tmp1 = results->accumulator[query->c_offset + 1];
   uint64_t tmp2 = results->accumulator[query->b_offset + 2];
   uint64_t tmp3 = results->accumulator[query->b_offset + 3];
   uint64_t tmp4 = tmp2 + tmp3;
   uint64_t tmp5 = tmp1 + tmp4;
   uint64_t tmp6 = tmp0 + tmp5;
   uint64_t tmp7 = tmp6 * 2;

   return tmp7;
}

/* Compute Metrics L3 Cache metrics set :: L3 Misses */
#define sklgt2__compute_l3_cache__l3_misses__read \
   bdw__compute_l3_cache__l3_misses__read

/* Compute Metrics L3 Cache metrics set :: L3 Sampler Throughput */
#define sklgt2__compute_l3_cache__l3_sampler_throughput__read \
   chv__render_basic__l3_sampler_throughput__read

/* Compute Metrics L3 Cache metrics set :: L3 Shader Throughput */
#define sklgt2__compute_l3_cache__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics L3 Cache metrics set :: L3 Total Throughput */
static uint64_t
sklgt2__compute_l3_cache__l3_total_throughput__read(UNUSED struct intel_perf_config *perf,
                                                    const struct intel_perf_query_info *query,
                                                    const struct intel_perf_query_result *results)
{
   /* RPN equation: $L3Accesses 64 UMUL */
   uint64_t tmp0 = sklgt2__compute_l3_cache__l3_accesses__read(perf, query, results) * 64;

   return tmp0;
}

/* Compute Metrics L3 Cache metrics set :: Shader Barrier Messages */
#define sklgt2__compute_l3_cache__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache metrics set :: L3 Bank 00 Accesses */
#define sklgt2__compute_l3_cache__l3_bank00_accesses__read \
   bdw__compute_l3_cache__l3_bank00_accesses__read

/* Compute Metrics L3 Cache metrics set :: L3 Bank 01 Accesses */
#define sklgt2__compute_l3_cache__l3_bank01_accesses__read \
   bdw__compute_l3_cache__l3_bank01_accesses__read

/* Compute Metrics L3 Cache metrics set :: L3 Bank 02 Accesses */
#define sklgt2__compute_l3_cache__l3_bank02_accesses__read \
   bdw__compute_l3_cache__l3_bank02_accesses__read

/* Compute Metrics L3 Cache metrics set :: L3 Bank 03 Accesses */
#define sklgt2__compute_l3_cache__l3_bank03_accesses__read \
   bdw__compute_l3_cache__l3_bank03_accesses__read

/* Compute Metrics L3 Cache metrics set :: L3 Bank 00 IC Accesses */
#define sklgt2__compute_l3_cache__l3_bank00_ic_accesses__read \
   bdw__compute_l3_cache__l3_bank00_ic_accesses__read

/* Compute Metrics L3 Cache metrics set :: L3 Bank 00 IC Hits */
#define sklgt2__compute_l3_cache__l3_bank00_ic_hits__read \
   bdw__compute_l3_cache__l3_bank00_ic_hits__read

/* Compute Metrics L3 Cache metrics set :: GTI L3 Throughput */
#define sklgt2__compute_l3_cache__gti_l3_throughput__read \
   bdw__compute_l3_cache__gti_l3_throughput__read

/* Compute Metrics L3 Cache metrics set :: GTI Read Throughput */
#define sklgt2__compute_l3_cache__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Compute Metrics L3 Cache metrics set :: GTI Write Throughput */
#define sklgt2__compute_l3_cache__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Metric set HDCAndSF :: GPU Time Elapsed */
#define sklgt2__hdc_and_sf__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set HDCAndSF :: GPU Core Clocks */
#define sklgt2__hdc_and_sf__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define sklgt2__hdc_and_sf__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define sklgt2__hdc_and_sf__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set HDCAndSF :: GPU Busy */
#define sklgt2__hdc_and_sf__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set HDCAndSF :: VS Threads Dispatched */
#define sklgt2__hdc_and_sf__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: HS Threads Dispatched */
#define sklgt2__hdc_and_sf__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set HDCAndSF :: DS Threads Dispatched */
#define sklgt2__hdc_and_sf__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set HDCAndSF :: GS Threads Dispatched */
#define sklgt2__hdc_and_sf__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: FS Threads Dispatched */
#define sklgt2__hdc_and_sf__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set HDCAndSF :: CS Threads Dispatched */
#define sklgt2__hdc_and_sf__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set HDCAndSF :: EU Active */
#define sklgt2__hdc_and_sf__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set HDCAndSF :: EU Stall */
#define sklgt2__hdc_and_sf__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
#define sklgt2__hdc_and_sf__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
#define sklgt2__hdc_and_sf__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
#define sklgt2__hdc_and_sf__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set HDCAndSF :: VS Send Pipe Active */
#define sklgt2__hdc_and_sf__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
#define sklgt2__hdc_and_sf__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
#define sklgt2__hdc_and_sf__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set HDCAndSF :: PS Send Pipeline Active */
#define sklgt2__hdc_and_sf__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set HDCAndSF :: FS Both FPU Active */
#define sklgt2__hdc_and_sf__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set HDCAndSF :: Rasterized Pixels */
#define sklgt2__hdc_and_sf__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
#define sklgt2__hdc_and_sf__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set HDCAndSF :: Early Depth Test Fails */
#define sklgt2__hdc_and_sf__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Samples Killed in FS */
#define sklgt2__hdc_and_sf__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set HDCAndSF :: Pixels Failing Tests */
#define sklgt2__hdc_and_sf__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set HDCAndSF :: Samples Written */
#define sklgt2__hdc_and_sf__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set HDCAndSF :: Samples Blended */
#define sklgt2__hdc_and_sf__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set HDCAndSF :: Sampler Texels */
#define sklgt2__hdc_and_sf__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set HDCAndSF :: Sampler Texels Misses */
#define sklgt2__hdc_and_sf__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set HDCAndSF :: SLM Bytes Read */
#define sklgt2__hdc_and_sf__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set HDCAndSF :: SLM Bytes Written */
#define sklgt2__hdc_and_sf__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set HDCAndSF :: Shader Memory Accesses */
#define sklgt2__hdc_and_sf__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
#define sklgt2__hdc_and_sf__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set HDCAndSF :: L3 Shader Throughput */
#define sklgt2__hdc_and_sf__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set HDCAndSF :: Shader Barrier Messages */
#define sklgt2__hdc_and_sf__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Polygon Data Ready */
#define sklgt2__hdc_and_sf__poly_data_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
#define sklgt2__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
#define sklgt2__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
#define sklgt2__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read

/* Metric set HDCAndSF :: SQ is full */
#define sklgt2__hdc_and_sf__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_1 :: GPU Time Elapsed */
#define sklgt2__l3_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_1 :: GPU Core Clocks */
#define sklgt2__l3_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define sklgt2__l3_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define sklgt2__l3_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_1 :: GPU Busy */
#define sklgt2__l3_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_1 :: VS Threads Dispatched */
#define sklgt2__l3_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_1 :: HS Threads Dispatched */
#define sklgt2__l3_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_1 :: DS Threads Dispatched */
#define sklgt2__l3_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_1 :: GS Threads Dispatched */
#define sklgt2__l3_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_1 :: FS Threads Dispatched */
#define sklgt2__l3_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_1 :: CS Threads Dispatched */
#define sklgt2__l3_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_1 :: EU Active */
#define sklgt2__l3_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_1 :: EU Stall */
#define sklgt2__l3_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_1 :: EU Both FPU Pipes Active */
#define sklgt2__l3_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_1 :: VS FPU0 Pipe Active */
#define sklgt2__l3_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_1 :: VS FPU1 Pipe Active */
#define sklgt2__l3_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_1 :: VS Send Pipe Active */
#define sklgt2__l3_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_1 :: PS FPU0 Pipe Active */
#define sklgt2__l3_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_1 :: PS FPU1 Pipe Active */
#define sklgt2__l3_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_1 :: PS Send Pipeline Active */
#define sklgt2__l3_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_1 :: FS Both FPU Active */
#define sklgt2__l3_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_1 :: Rasterized Pixels */
#define sklgt2__l3_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
#define sklgt2__l3_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_1 :: Early Depth Test Fails */
#define sklgt2__l3_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Samples Killed in FS */
#define sklgt2__l3_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_1 :: Pixels Failing Tests */
#define sklgt2__l3_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_1 :: Samples Written */
#define sklgt2__l3_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_1 :: Samples Blended */
#define sklgt2__l3_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_1 :: Sampler Texels */
#define sklgt2__l3_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_1 :: Sampler Texels Misses */
#define sklgt2__l3_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_1 :: SLM Bytes Read */
#define sklgt2__l3_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_1 :: SLM Bytes Written */
#define sklgt2__l3_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_1 :: Shader Memory Accesses */
#define sklgt2__l3_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
#define sklgt2__l3_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_1 :: L3 Shader Throughput */
#define sklgt2__l3_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_1 :: Shader Barrier Messages */
#define sklgt2__l3_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Stalled */
#define sklgt2__l3_1__l30_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Stalled */
#define sklgt2__l3_1__l30_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Active */
#define sklgt2__l3_1__l30_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Active */
#define sklgt2__l3_1__l30_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_1 :: SQ is full */
#define sklgt2__l3_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_2 :: GPU Time Elapsed */
#define sklgt2__l3_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_2 :: GPU Core Clocks */
#define sklgt2__l3_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define sklgt2__l3_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define sklgt2__l3_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_2 :: GPU Busy */
#define sklgt2__l3_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_2 :: VS Threads Dispatched */
#define sklgt2__l3_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_2 :: HS Threads Dispatched */
#define sklgt2__l3_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_2 :: DS Threads Dispatched */
#define sklgt2__l3_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_2 :: GS Threads Dispatched */
#define sklgt2__l3_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_2 :: FS Threads Dispatched */
#define sklgt2__l3_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_2 :: CS Threads Dispatched */
#define sklgt2__l3_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_2 :: EU Active */
#define sklgt2__l3_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_2 :: EU Stall */
#define sklgt2__l3_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_2 :: EU Both FPU Pipes Active */
#define sklgt2__l3_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_2 :: VS FPU0 Pipe Active */
#define sklgt2__l3_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_2 :: VS FPU1 Pipe Active */
#define sklgt2__l3_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_2 :: VS Send Pipe Active */
#define sklgt2__l3_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_2 :: PS FPU0 Pipe Active */
#define sklgt2__l3_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_2 :: PS FPU1 Pipe Active */
#define sklgt2__l3_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_2 :: PS Send Pipeline Active */
#define sklgt2__l3_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_2 :: FS Both FPU Active */
#define sklgt2__l3_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_2 :: Rasterized Pixels */
#define sklgt2__l3_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
#define sklgt2__l3_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_2 :: Early Depth Test Fails */
#define sklgt2__l3_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Samples Killed in FS */
#define sklgt2__l3_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_2 :: Pixels Failing Tests */
#define sklgt2__l3_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_2 :: Samples Written */
#define sklgt2__l3_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_2 :: Samples Blended */
#define sklgt2__l3_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_2 :: Sampler Texels */
#define sklgt2__l3_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_2 :: Sampler Texels Misses */
#define sklgt2__l3_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_2 :: SLM Bytes Read */
#define sklgt2__l3_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_2 :: SLM Bytes Written */
#define sklgt2__l3_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_2 :: Shader Memory Accesses */
#define sklgt2__l3_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
#define sklgt2__l3_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_2 :: L3 Shader Throughput */
#define sklgt2__l3_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_2 :: Shader Barrier Messages */
#define sklgt2__l3_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Stalled */
#define sklgt2__l3_2__l30_bank2_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Active */
#define sklgt2__l3_2__l30_bank2_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_2 :: SQ is full */
#define sklgt2__l3_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_3 :: GPU Time Elapsed */
#define sklgt2__l3_3__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_3 :: GPU Core Clocks */
#define sklgt2__l3_3__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define sklgt2__l3_3__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define sklgt2__l3_3__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_3 :: GPU Busy */
#define sklgt2__l3_3__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_3 :: VS Threads Dispatched */
#define sklgt2__l3_3__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_3 :: HS Threads Dispatched */
#define sklgt2__l3_3__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_3 :: DS Threads Dispatched */
#define sklgt2__l3_3__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_3 :: GS Threads Dispatched */
#define sklgt2__l3_3__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_3 :: FS Threads Dispatched */
#define sklgt2__l3_3__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_3 :: CS Threads Dispatched */
#define sklgt2__l3_3__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_3 :: EU Active */
#define sklgt2__l3_3__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_3 :: EU Stall */
#define sklgt2__l3_3__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_3 :: EU Both FPU Pipes Active */
#define sklgt2__l3_3__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_3 :: VS FPU0 Pipe Active */
#define sklgt2__l3_3__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_3 :: VS FPU1 Pipe Active */
#define sklgt2__l3_3__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_3 :: VS Send Pipe Active */
#define sklgt2__l3_3__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_3 :: PS FPU0 Pipe Active */
#define sklgt2__l3_3__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_3 :: PS FPU1 Pipe Active */
#define sklgt2__l3_3__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_3 :: PS Send Pipeline Active */
#define sklgt2__l3_3__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_3 :: FS Both FPU Active */
#define sklgt2__l3_3__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_3 :: Rasterized Pixels */
#define sklgt2__l3_3__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
#define sklgt2__l3_3__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_3 :: Early Depth Test Fails */
#define sklgt2__l3_3__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Samples Killed in FS */
#define sklgt2__l3_3__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_3 :: Pixels Failing Tests */
#define sklgt2__l3_3__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_3 :: Samples Written */
#define sklgt2__l3_3__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_3 :: Samples Blended */
#define sklgt2__l3_3__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_3 :: Sampler Texels */
#define sklgt2__l3_3__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_3 :: Sampler Texels Misses */
#define sklgt2__l3_3__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_3 :: SLM Bytes Read */
#define sklgt2__l3_3__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_3 :: SLM Bytes Written */
#define sklgt2__l3_3__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_3 :: Shader Memory Accesses */
#define sklgt2__l3_3__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
#define sklgt2__l3_3__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_3 :: L3 Shader Throughput */
#define sklgt2__l3_3__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_3 :: Shader Barrier Messages */
#define sklgt2__l3_3__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
#define sklgt2__l3_3__l30_bank3_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
#define sklgt2__l3_3__l30_bank3_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_3 :: SQ is full */
#define sklgt2__l3_3__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
#define sklgt2__rasterizer_and_pixel_backend__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
#define sklgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define sklgt2__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define sklgt2__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
#define sklgt2__rasterizer_and_pixel_backend__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
#define sklgt2__rasterizer_and_pixel_backend__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
#define sklgt2__rasterizer_and_pixel_backend__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
#define sklgt2__rasterizer_and_pixel_backend__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
#define sklgt2__rasterizer_and_pixel_backend__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
#define sklgt2__rasterizer_and_pixel_backend__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
#define sklgt2__rasterizer_and_pixel_backend__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set RasterizerAndPixelBackend :: EU Active */
#define sklgt2__rasterizer_and_pixel_backend__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set RasterizerAndPixelBackend :: EU Stall */
#define sklgt2__rasterizer_and_pixel_backend__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
#define sklgt2__rasterizer_and_pixel_backend__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
#define sklgt2__rasterizer_and_pixel_backend__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
#define sklgt2__rasterizer_and_pixel_backend__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
#define sklgt2__rasterizer_and_pixel_backend__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
#define sklgt2__rasterizer_and_pixel_backend__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
#define sklgt2__rasterizer_and_pixel_backend__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
#define sklgt2__rasterizer_and_pixel_backend__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
#define sklgt2__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
#define sklgt2__rasterizer_and_pixel_backend__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
#define sklgt2__rasterizer_and_pixel_backend__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
#define sklgt2__rasterizer_and_pixel_backend__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
#define sklgt2__rasterizer_and_pixel_backend__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
#define sklgt2__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set RasterizerAndPixelBackend :: Samples Written */
#define sklgt2__rasterizer_and_pixel_backend__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
#define sklgt2__rasterizer_and_pixel_backend__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
#define sklgt2__rasterizer_and_pixel_backend__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
#define sklgt2__rasterizer_and_pixel_backend__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
#define sklgt2__rasterizer_and_pixel_backend__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
#define sklgt2__rasterizer_and_pixel_backend__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
#define sklgt2__rasterizer_and_pixel_backend__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
#define sklgt2__rasterizer_and_pixel_backend__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
#define sklgt2__rasterizer_and_pixel_backend__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
#define sklgt2__rasterizer_and_pixel_backend__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
#define sklgt2__rasterizer_and_pixel_backend__pixel_data0_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
#define sklgt2__rasterizer_and_pixel_backend__rasterizer0_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
#define sklgt2__rasterizer_and_pixel_backend__ps_output0_available__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
#define sklgt2__rasterizer_and_pixel_backend__pixel_values0_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
#define sklgt2__rasterizer_and_pixel_backend__rasterizer0_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set RasterizerAndPixelBackend :: SQ is full */
#define sklgt2__rasterizer_and_pixel_backend__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler :: GPU Time Elapsed */
#define sklgt2__sampler__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler :: GPU Core Clocks */
#define sklgt2__sampler__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define sklgt2__sampler__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define sklgt2__sampler__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler :: GPU Busy */
#define sklgt2__sampler__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler :: VS Threads Dispatched */
#define sklgt2__sampler__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler :: HS Threads Dispatched */
#define sklgt2__sampler__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler :: DS Threads Dispatched */
#define sklgt2__sampler__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler :: GS Threads Dispatched */
#define sklgt2__sampler__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler :: FS Threads Dispatched */
#define sklgt2__sampler__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler :: CS Threads Dispatched */
#define sklgt2__sampler__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler :: EU Active */
#define sklgt2__sampler__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler :: EU Stall */
#define sklgt2__sampler__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler :: EU Both FPU Pipes Active */
#define sklgt2__sampler__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler :: VS FPU0 Pipe Active */
#define sklgt2__sampler__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler :: VS FPU1 Pipe Active */
#define sklgt2__sampler__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler :: VS Send Pipe Active */
#define sklgt2__sampler__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler :: PS FPU0 Pipe Active */
#define sklgt2__sampler__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler :: PS FPU1 Pipe Active */
#define sklgt2__sampler__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler :: PS Send Pipeline Active */
#define sklgt2__sampler__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler :: FS Both FPU Active */
#define sklgt2__sampler__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler :: Rasterized Pixels */
#define sklgt2__sampler__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler :: Early Hi-Depth Test Fails */
#define sklgt2__sampler__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler :: Early Depth Test Fails */
#define sklgt2__sampler__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Samples Killed in FS */
#define sklgt2__sampler__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler :: Pixels Failing Tests */
#define sklgt2__sampler__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler :: Samples Written */
#define sklgt2__sampler__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler :: Samples Blended */
#define sklgt2__sampler__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler :: Sampler Texels */
#define sklgt2__sampler__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler :: Sampler Texels Misses */
#define sklgt2__sampler__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler :: SLM Bytes Read */
#define sklgt2__sampler__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler :: SLM Bytes Written */
#define sklgt2__sampler__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler :: Shader Memory Accesses */
#define sklgt2__sampler__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler :: Shader Atomic Memory Accesses */
#define sklgt2__sampler__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler :: L3 Shader Throughput */
#define sklgt2__sampler__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler :: Shader Barrier Messages */
#define sklgt2__sampler__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Slice0 Subslice1 Input Available */
#define sklgt2__sampler__sampler01_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler :: Slice0 Subslice2 Input Available */
#define sklgt2__sampler__sampler02_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler :: Slice0 Subslice0 Input Available */
#define sklgt2__sampler__sampler00_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice2 Sampler Output Ready */
#define sklgt2__sampler__sampler02_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice0 Sampler Output Ready */
#define sklgt2__sampler__sampler00_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice1 Sampler Output Ready */
#define sklgt2__sampler__sampler01_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler :: SQ is full */
#define sklgt2__sampler__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_1 :: GPU Time Elapsed */
#define sklgt2__tdl_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_1 :: GPU Core Clocks */
#define sklgt2__tdl_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define sklgt2__tdl_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define sklgt2__tdl_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_1 :: GPU Busy */
#define sklgt2__tdl_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_1 :: VS Threads Dispatched */
#define sklgt2__tdl_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_1 :: HS Threads Dispatched */
#define sklgt2__tdl_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_1 :: DS Threads Dispatched */
#define sklgt2__tdl_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_1 :: GS Threads Dispatched */
#define sklgt2__tdl_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_1 :: FS Threads Dispatched */
#define sklgt2__tdl_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_1 :: CS Threads Dispatched */
#define sklgt2__tdl_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_1 :: EU Active */
#define sklgt2__tdl_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_1 :: EU Stall */
#define sklgt2__tdl_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
#define sklgt2__tdl_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
#define sklgt2__tdl_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
#define sklgt2__tdl_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_1 :: VS Send Pipe Active */
#define sklgt2__tdl_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
#define sklgt2__tdl_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
#define sklgt2__tdl_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_1 :: PS Send Pipeline Active */
#define sklgt2__tdl_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_1 :: FS Both FPU Active */
#define sklgt2__tdl_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_1 :: Rasterized Pixels */
#define sklgt2__tdl_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
#define sklgt2__tdl_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_1 :: Early Depth Test Fails */
#define sklgt2__tdl_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: Samples Killed in FS */
#define sklgt2__tdl_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_1 :: Pixels Failing Tests */
#define sklgt2__tdl_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_1 :: Samples Written */
#define sklgt2__tdl_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_1 :: Samples Blended */
#define sklgt2__tdl_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_1 :: Sampler Texels */
#define sklgt2__tdl_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_1 :: Sampler Texels Misses */
#define sklgt2__tdl_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_1 :: SLM Bytes Read */
#define sklgt2__tdl_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_1 :: SLM Bytes Written */
#define sklgt2__tdl_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_1 :: Shader Memory Accesses */
#define sklgt2__tdl_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
#define sklgt2__tdl_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_1 :: L3 Shader Throughput */
#define sklgt2__tdl_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_1 :: Shader Barrier Messages */
#define sklgt2__tdl_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
#define sklgt2__tdl_1__non_ps_thread01_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice0 */
#define sklgt2__tdl_1__ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
#define sklgt2__tdl_1__non_ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice2 */
#define sklgt2__tdl_1__ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
#define sklgt2__tdl_1__non_ps_thread02_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice1 */
#define sklgt2__tdl_1__ps_thread01_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_1 :: SQ is full */
#define sklgt2__tdl_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_2 :: GPU Time Elapsed */
#define sklgt2__tdl_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_2 :: GPU Core Clocks */
#define sklgt2__tdl_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define sklgt2__tdl_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define sklgt2__tdl_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_2 :: GPU Busy */
#define sklgt2__tdl_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_2 :: VS Threads Dispatched */
#define sklgt2__tdl_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_2 :: HS Threads Dispatched */
#define sklgt2__tdl_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_2 :: DS Threads Dispatched */
#define sklgt2__tdl_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_2 :: GS Threads Dispatched */
#define sklgt2__tdl_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_2 :: FS Threads Dispatched */
#define sklgt2__tdl_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_2 :: CS Threads Dispatched */
#define sklgt2__tdl_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_2 :: EU Active */
#define sklgt2__tdl_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_2 :: EU Stall */
#define sklgt2__tdl_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
#define sklgt2__tdl_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
#define sklgt2__tdl_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
#define sklgt2__tdl_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_2 :: VS Send Pipe Active */
#define sklgt2__tdl_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
#define sklgt2__tdl_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
#define sklgt2__tdl_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_2 :: PS Send Pipeline Active */
#define sklgt2__tdl_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_2 :: FS Both FPU Active */
#define sklgt2__tdl_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_2 :: Rasterized Pixels */
#define sklgt2__tdl_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
#define sklgt2__tdl_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_2 :: Early Depth Test Fails */
#define sklgt2__tdl_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Samples Killed in FS */
#define sklgt2__tdl_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_2 :: Pixels Failing Tests */
#define sklgt2__tdl_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_2 :: Samples Written */
#define sklgt2__tdl_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_2 :: Samples Blended */
#define sklgt2__tdl_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_2 :: Sampler Texels */
#define sklgt2__tdl_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_2 :: Sampler Texels Misses */
#define sklgt2__tdl_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_2 :: SLM Bytes Read */
#define sklgt2__tdl_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_2 :: SLM Bytes Written */
#define sklgt2__tdl_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_2 :: Shader Memory Accesses */
#define sklgt2__tdl_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
#define sklgt2__tdl_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_2 :: L3 Shader Throughput */
#define sklgt2__tdl_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_2 :: Shader Barrier Messages */
#define sklgt2__tdl_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 0 */
#define sklgt2__tdl_2__thread_header01_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 1 */
#define sklgt2__tdl_2__thread_header00_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 0 */
#define sklgt2__tdl_2__thread_header00_ready_port0__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 1 */
#define sklgt2__tdl_2__thread_header02_ready_port1__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 0 */
#define sklgt2__tdl_2__thread_header02_ready_port0__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 1 */
#define sklgt2__tdl_2__thread_header01_ready_port1__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_2 :: SQ is full */
#define sklgt2__tdl_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Compute Metrics Extra set :: GPU Time Elapsed */
#define sklgt2__compute_extra__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extra set :: GPU Core Clocks */
#define sklgt2__compute_extra__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define sklgt2__compute_extra__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define sklgt2__compute_extra__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extra set :: EU FPU1 Pipe Active */
#define sklgt2__compute_extra__fpu1_active__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extra set :: EU FPU1 Pipe Active including Ext Math */
static float
sklgt2__compute_extra__fpu1_active_adjusted__read(UNUSED struct intel_perf_config *perf,
                                                  const struct intel_perf_query_info *query,
                                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: A 8 READ  C 7 READ C 6 READ FADD C 5 READ FADD 8 FMUL FADD 100 FMUL $EuCoresTotalCount FDIV $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 8];
   uint64_t tmp1 = results->accumulator[query->c_offset + 7];
   uint64_t tmp2 = results->accumulator[query->c_offset + 6];
   double tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = results->accumulator[query->c_offset + 5];
   double tmp5 = tmp3 + tmp4;
   double tmp6 = tmp5 * 8;
   double tmp7 = tmp0 + tmp6;
   double tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = perf->sys_vars.n_eus;
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;
   double tmp12 = tmp11;
   double tmp13 = sklgt2__compute_extra__gpu_core_clocks__read(perf, query, results);
   double tmp14 = tmp13 ? tmp12 / tmp13 : 0;

   return tmp14;
}

/* Media Vme Pipe metrics set :: GPU Time Elapsed */
#define sklgt2__vme_pipe__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Media Vme Pipe metrics set :: GPU Core Clocks */
#define sklgt2__vme_pipe__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define sklgt2__vme_pipe__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define sklgt2__vme_pipe__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Media Vme Pipe metrics set :: GPU Busy */
#define sklgt2__vme_pipe__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Media Vme Pipe metrics set :: CS Threads Dispatched */
#define sklgt2__vme_pipe__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Media Vme Pipe metrics set :: EU Active */
#define sklgt2__vme_pipe__eu_active__read \
   bdw__render_basic__eu_active__read

/* Media Vme Pipe metrics set :: EU Stall */
#define sklgt2__vme_pipe__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Media Vme Pipe metrics set :: EU Both FPU Pipes Active */
#define sklgt2__vme_pipe__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Media Vme Pipe metrics set :: EU Thread Occupancy */
#define sklgt2__vme_pipe__eu_thread_occupancy__read \
   bdw__vme_pipe__eu_thread_occupancy__read

/* Media Vme Pipe metrics set :: VME Busy */
#define sklgt2__vme_pipe__vme_busy__read \
   bdw__vme_pipe__vme_busy__read

/* Gpu Rings Busyness :: GPU Time Elapsed */
#define sklgt2__gpu_busyness__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Gpu Rings Busyness :: GPU Core Clocks */
#define sklgt2__gpu_busyness__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define sklgt2__gpu_busyness__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define sklgt2__gpu_busyness__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Gpu Rings Busyness :: Render Ring Busy */
#define sklgt2__gpu_busyness__render_busy__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Gpu Rings Busyness :: Vdbox0 Ring Busy */
#define sklgt2__gpu_busyness__vdbox0_busy__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Gpu Rings Busyness :: Vebox Ring Busy */
#define sklgt2__gpu_busyness__vebox_busy__read \
   bdw__render_pipe_profile__sf_stall__read

/* Gpu Rings Busyness :: Blitter Ring Busy */
#define sklgt2__gpu_busyness__blitter_busy__read \
   bdw__render_pipe_profile__cl_stall__read

/* Gpu Rings Busyness :: AnyRingBusy */
#define sklgt2__gpu_busyness__any_ring_busy__read \
   bdw__render_basic__sampler0_busy__read

/* FF Bottlenecks :: GPU Time Elapsed */
#define sklgt2__ff_bottlenecks__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* FF Bottlenecks :: GPU Core Clocks */
#define sklgt2__ff_bottlenecks__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* FF Bottlenecks :: AVG GPU Core Frequency */
#define sklgt2__ff_bottlenecks__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* FF Bottlenecks :: AVG GPU Core Frequency */
#define sklgt2__ff_bottlenecks__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* FF Bottlenecks :: GPU Busy */
#define sklgt2__ff_bottlenecks__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* FF Bottlenecks :: VS Threads Dispatched */
#define sklgt2__ff_bottlenecks__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* FF Bottlenecks :: HS Threads Dispatched */
#define sklgt2__ff_bottlenecks__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* FF Bottlenecks :: DS Threads Dispatched */
#define sklgt2__ff_bottlenecks__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* FF Bottlenecks :: GS Threads Dispatched */
#define sklgt2__ff_bottlenecks__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* FF Bottlenecks :: FS Threads Dispatched */
#define sklgt2__ff_bottlenecks__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* FF Bottlenecks :: CS Threads Dispatched */
#define sklgt2__ff_bottlenecks__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* FF Bottlenecks :: Rasterized Pixels */
#define sklgt2__ff_bottlenecks__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* FF Bottlenecks :: Early Hi-Depth Test Fails */
#define sklgt2__ff_bottlenecks__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* FF Bottlenecks :: Early Depth Test Fails */
#define sklgt2__ff_bottlenecks__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* FF Bottlenecks :: Samples Killed in FS */
#define sklgt2__ff_bottlenecks__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* FF Bottlenecks :: Pixels Failing Tests */
#define sklgt2__ff_bottlenecks__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* FF Bottlenecks :: Samples Written */
#define sklgt2__ff_bottlenecks__samples_written__read \
   bdw__render_basic__samples_written__read

/* FF Bottlenecks :: Samples Blended */
#define sklgt2__ff_bottlenecks__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* FF Bottlenecks :: EU Active */
#define sklgt2__ff_bottlenecks__eu_active__read \
   bdw__render_basic__eu_active__read

/* FF Bottlenecks :: EU Stall */
#define sklgt2__ff_bottlenecks__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* FF Bottlenecks :: EU Both FPU Pipes Active */
#define sklgt2__ff_bottlenecks__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* FF Bottlenecks :: EU Thread Occupancy */
static float
sklgt2__ff_bottlenecks__eu_thread_occupancy__read(UNUSED struct intel_perf_config *perf,
                                                  const struct intel_perf_query_info *query,
                                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: 8 A 17 READ FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->a_offset + 17];
   double tmp1 = 8 * tmp0;
   double tmp2 = tmp1;
   double tmp3 = perf->sys_vars.eu_threads_count;
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = perf->sys_vars.n_eus;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = sklgt2__ff_bottlenecks__gpu_core_clocks__read(perf, query, results);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* FF Bottlenecks :: VS FPU0 Pipe Active */
#define sklgt2__ff_bottlenecks__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* FF Bottlenecks :: VS FPU1 Pipe Active */
#define sklgt2__ff_bottlenecks__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* FF Bottlenecks :: PS FPU0 Pipe Active */
#define sklgt2__ff_bottlenecks__ps_fpu0_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* FF Bottlenecks :: PS FPU1 Pipe Active */
#define sklgt2__ff_bottlenecks__ps_fpu1_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* FF Bottlenecks :: VS is sending vertices to CL */
static float
sklgt2__ff_bottlenecks__vs_cl_bypass__read(UNUSED struct intel_perf_config *perf,
                                           const struct intel_perf_query_info *query,
                                           const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ B 4 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 4];
   double tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = 2;
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   uint64_t tmp6 = tmp5 * 100;
   double tmp7 = tmp6;
   double tmp8 = sklgt2__ff_bottlenecks__gpu_core_clocks__read(perf, query, results);
   double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

   return tmp9;
}

/* FF Bottlenecks :: HS Bottleneck */
#define sklgt2__ff_bottlenecks__hs_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* FF Bottlenecks :: DS Bottleneck */
static float
sklgt2__ff_bottlenecks__ds_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: B 1 READ B 5 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 1];
   uint64_t tmp1 = results->accumulator[query->b_offset + 5];
   double tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = 2;
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   uint64_t tmp6 = tmp5 * 100;
   double tmp7 = tmp6;
   double tmp8 = sklgt2__ff_bottlenecks__gpu_core_clocks__read(perf, query, results);
   double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

   return tmp9;
}

/* FF Bottlenecks :: TE Bottleneck */
static float
sklgt2__ff_bottlenecks__te_bottleneck__read(UNUSED struct intel_perf_config *perf,
                                            const struct intel_perf_query_info *query,
                                            const struct intel_perf_query_result *results)
{
   /* RPN equation: B 2 READ B 6 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 2];
   uint64_t tmp1 = results->accumulator[query->b_offset + 6];
   double tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = 2;
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   uint64_t tmp6 = tmp5 * 100;
   double tmp7 = tmp6;
   double tmp8 = sklgt2__ff_bottlenecks__gpu_core_clocks__read(perf, query, results);
   double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

   return tmp9;
}

/* FF Bottlenecks :: GS Bottleneck */
#define sklgt2__ff_bottlenecks__gs_bottleneck__read \
   bdw__render_pipe_profile__early_depth_bottleneck__read

/* MDAPI testing set :: GPU Time Elapsed */
#define sklgt2__test_oa__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* MDAPI testing set :: GPU Core Clocks */
#define sklgt2__test_oa__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define sklgt2__test_oa__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define sklgt2__test_oa__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* MDAPI testing set :: TestCounter0 */
#define sklgt2__test_oa__counter0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* MDAPI testing set :: TestCounter1 */
#define sklgt2__test_oa__counter1__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* MDAPI testing set :: TestCounter2 */
#define sklgt2__test_oa__counter2__read \
   hsw__compute_extended__eu_typed_reads0__read

/* MDAPI testing set :: TestCounter3 */
#define sklgt2__test_oa__counter3__read \
   hsw__compute_extended__eu_typed_writes0__read

/* MDAPI testing set :: TestCounter4 */
#define sklgt2__test_oa__counter4__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* MDAPI testing set :: TestCounter5 */
#define sklgt2__test_oa__counter5__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* MDAPI testing set :: TestCounter6 */
#define sklgt2__test_oa__counter6__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* MDAPI testing set :: TestCounter7 */
#define sklgt2__test_oa__counter7__read \
   hsw__compute_extended__gpu_clocks__read

/* MDAPI testing set :: TestCounter8 */
#define sklgt2__test_oa__counter8__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Metric set PMA Stall :: GPU Time Elapsed */
#define sklgt2__pma__stall__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set PMA Stall :: GPU Core Clocks */
#define sklgt2__pma__stall__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define sklgt2__pma__stall__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define sklgt2__pma__stall__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set PMA Stall :: STC PMA stall */
static float
sklgt2__pma__stall__stc_pma_stall__read(UNUSED struct intel_perf_config *perf,
                                        const struct intel_perf_query_info *query,
                                        const struct intel_perf_query_result *results)
{
   /* RPN equation: B 0 READ B 1 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = results->accumulator[query->b_offset + 0];
   uint64_t tmp1 = results->accumulator[query->b_offset + 1];
   double tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = 2;
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   uint64_t tmp6 = tmp5 * 100;
   double tmp7 = tmp6;
   double tmp8 = sklgt2__pma__stall__gpu_core_clocks__read(perf, query, results);
   double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

   return tmp9;
}

/* AsyncCompute :: GPU Time Elapsed */
#define sklgt2__async_compute__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* AsyncCompute :: GPU Core Clocks */
#define sklgt2__async_compute__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define sklgt2__async_compute__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define sklgt2__async_compute__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* AsyncCompute :: GPU Busy */
#define sklgt2__async_compute__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* AsyncCompute :: VS Threads Dispatched */
#define sklgt2__async_compute__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* AsyncCompute :: HS Threads Dispatched */
#define sklgt2__async_compute__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* AsyncCompute :: DS Threads Dispatched */
#define sklgt2__async_compute__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* AsyncCompute :: GS Threads Dispatched */
#define sklgt2__async_compute__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* AsyncCompute :: FS Threads Dispatched */
#define sklgt2__async_compute__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* AsyncCompute :: CS Threads Dispatched */
#define sklgt2__async_compute__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* AsyncCompute :: EU FPU0 Pipe Active */
#define sklgt2__async_compute__fpu0_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* AsyncCompute :: VS FPU0 Pipe Active */
#define sklgt2__async_compute__vs_fpu0_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* AsyncCompute :: PS FPU0 Pipe Active */
#define sklgt2__async_compute__ps_fpu0_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* AsyncCompute :: CS FPU0 Pipe Active */
#define sklgt2__async_compute__cs_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* AsyncCompute :: EU FPU1 Pipe Active */
#define sklgt2__async_compute__fpu1_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* AsyncCompute :: VS FPU1 Pipe Active */
#define sklgt2__async_compute__vs_fpu1_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* AsyncCompute :: PS FPU1 Pipe Active */
#define sklgt2__async_compute__ps_fpu1_active__read \
   bdw__render_basic__vs_send_active__read

/* AsyncCompute :: CS FPU1 Pipe Active */
#define sklgt2__async_compute__cs_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* AsyncCompute :: EU Thread Occupancy */
#define sklgt2__async_compute__eu_thread_occupancy__read \
   sklgt2__ff_bottlenecks__eu_thread_occupancy__read

/* AsyncCompute :: EU Active */
#define sklgt2__async_compute__eu_active__read \
   bdw__render_basic__eu_active__read

/* AsyncCompute :: EU Stall */
#define sklgt2__async_compute__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: GPU Time Elapsed */
#define sklgt3__render_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics Basic set :: GPU Core Clocks */
#define sklgt3__render_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt3__render_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt3__render_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics Basic set :: VS Threads Dispatched */
#define sklgt3__render_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics Basic set :: HS Threads Dispatched */
#define sklgt3__render_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics Basic set :: DS Threads Dispatched */
#define sklgt3__render_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics Basic set :: GS Threads Dispatched */
#define sklgt3__render_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics Basic set :: FS Threads Dispatched */
#define sklgt3__render_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics Basic set :: CS Threads Dispatched */
#define sklgt3__render_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics Basic set :: GPU Busy */
#define sklgt3__render_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics Basic set :: EU Active */
#define sklgt3__render_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics Basic set :: EU Stall */
#define sklgt3__render_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
#define sklgt3__render_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
#define sklgt3__render_basic__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
#define sklgt3__render_basic__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Render Metrics Basic set :: VS Send Pipe Active */
#define sklgt3__render_basic__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
#define sklgt3__render_basic__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
#define sklgt3__render_basic__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Render Metrics Basic set :: PS Send Pipeline Active */
#define sklgt3__render_basic__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Render Metrics Basic set :: FS Both FPU Active */
#define sklgt3__render_basic__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Render Metrics Basic set :: Sampler 0 Busy */
#define sklgt3__render_basic__sampler0_busy__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics Basic set :: Sampler 1 Busy */
#define sklgt3__render_basic__sampler1_busy__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics Basic set :: Samplers Busy */
#define sklgt3__render_basic__samplers_busy__read \
   bdw__render_basic__samplers_busy__read

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
#define sklgt3__render_basic__sampler0_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
#define sklgt3__render_basic__sampler1_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics Basic set :: Rasterized Pixels */
#define sklgt3__render_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
#define sklgt3__render_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics Basic set :: Early Depth Test Fails */
#define sklgt3__render_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: Samples Killed in FS */
#define sklgt3__render_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics Basic set :: Pixels Failing Tests */
#define sklgt3__render_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics Basic set :: Samples Written */
#define sklgt3__render_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics Basic set :: Samples Blended */
#define sklgt3__render_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics Basic set :: Sampler Texels */
#define sklgt3__render_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics Basic set :: Sampler Texels Misses */
#define sklgt3__render_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics Basic set :: Sampler Cache Misses */
#define sklgt3__render_basic__sampler_l1_misses__read \
   bdw__render_basic__sampler_l1_misses__read

/* Render Metrics Basic set :: SLM Bytes Read */
#define sklgt3__render_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics Basic set :: SLM Bytes Written */
#define sklgt3__render_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics Basic set :: Shader Memory Accesses */
#define sklgt3__render_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
#define sklgt3__render_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
#define sklgt3__render_basic__l3_lookups__read \
   bdw__render_basic__l3_lookups__read

/* Render Metrics Basic set :: L3 Misses */
#define sklgt3__render_basic__l3_misses__read \
   hsw__compute_extended__typed_atomics0__read

/* Render Metrics Basic set :: L3 Sampler Throughput */
#define sklgt3__render_basic__l3_sampler_throughput__read \
   bdw__render_basic__l3_sampler_throughput__read

/* Render Metrics Basic set :: L3 Shader Throughput */
#define sklgt3__render_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics Basic set :: Shader Barrier Messages */
#define sklgt3__render_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
#define sklgt3__render_basic__gti_vf_throughput__read \
   bdw__render_basic__gti_vf_throughput__read

/* Render Metrics Basic set :: GTI Depth Throughput */
#define sklgt3__render_basic__gti_depth_throughput__read \
   bdw__render_basic__gti_depth_throughput__read

/* Render Metrics Basic set :: GTI RCC Throughput */
#define sklgt3__render_basic__gti_rcc_throughput__read \
   bdw__render_basic__gti_rcc_throughput__read

/* Render Metrics Basic set :: GTI L3 Throughput */
#define sklgt3__render_basic__gti_l3_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Render Metrics Basic set :: GTI HDC TLB Lookup Throughput */
#define sklgt3__render_basic__gti_hdc_lookups_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics Basic set :: GTI Read Throughput */
#define sklgt3__render_basic__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Render Metrics Basic set :: GTI Write Throughput */
#define sklgt3__render_basic__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Render Metrics Basic set :: Samplers Bottleneck */
#define sklgt3__render_basic__sampler_bottleneck__read \
   bdw__render_basic__sampler_bottleneck__read

/* Compute Metrics Basic set :: GPU Time Elapsed */
#define sklgt3__compute_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Basic set :: GPU Core Clocks */
#define sklgt3__compute_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt3__compute_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt3__compute_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Basic set :: GPU Busy */
#define sklgt3__compute_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics Basic set :: VS Threads Dispatched */
#define sklgt3__compute_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: HS Threads Dispatched */
#define sklgt3__compute_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics Basic set :: DS Threads Dispatched */
#define sklgt3__compute_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics Basic set :: GS Threads Dispatched */
#define sklgt3__compute_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: FS Threads Dispatched */
#define sklgt3__compute_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics Basic set :: CS Threads Dispatched */
#define sklgt3__compute_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Basic set :: EU Active */
#define sklgt3__compute_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Basic set :: EU Stall */
#define sklgt3__compute_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Basic set :: EU Both FPU Pipes Active */
#define sklgt3__compute_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Basic set :: EU FPU0 Pipe Active */
#define sklgt3__compute_basic__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Basic set :: EU FPU1 Pipe Active */
#define sklgt3__compute_basic__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Basic set :: EU AVG IPC Rate */
#define sklgt3__compute_basic__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Basic set :: EU Send Pipe Active */
#define sklgt3__compute_basic__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Basic set :: EU Thread Occupancy */
#define sklgt3__compute_basic__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Basic set :: Rasterized Pixels */
#define sklgt3__compute_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics Basic set :: Early Hi-Depth Test Fails */
#define sklgt3__compute_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics Basic set :: Early Depth Test Fails */
#define sklgt3__compute_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Killed in FS */
#define sklgt3__compute_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics Basic set :: Pixels Failing Tests */
#define sklgt3__compute_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics Basic set :: Samples Written */
#define sklgt3__compute_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics Basic set :: Samples Blended */
#define sklgt3__compute_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics Basic set :: Sampler Texels */
#define sklgt3__compute_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Basic set :: Sampler Texels Misses */
#define sklgt3__compute_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Basic set :: SLM Bytes Read */
#define sklgt3__compute_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Basic set :: SLM Bytes Written */
#define sklgt3__compute_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Basic set :: Shader Memory Accesses */
#define sklgt3__compute_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Basic set :: Shader Atomic Memory Accesses */
#define sklgt3__compute_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Basic set :: L3 Shader Throughput */
#define sklgt3__compute_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Basic set :: Shader Barrier Messages */
#define sklgt3__compute_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Typed Bytes Read */
#define sklgt3__compute_basic__typed_bytes_read__read \
   bdw__compute_basic__typed_bytes_read__read

/* Compute Metrics Basic set :: Typed Bytes Written */
#define sklgt3__compute_basic__typed_bytes_written__read \
   bdw__compute_basic__typed_bytes_written__read

/* Compute Metrics Basic set :: Untyped Bytes Read */
#define sklgt3__compute_basic__untyped_bytes_read__read \
   bdw__compute_basic__untyped_bytes_read__read

/* Compute Metrics Basic set :: Untyped Writes */
#define sklgt3__compute_basic__untyped_bytes_written__read \
   bdw__compute_basic__untyped_bytes_written__read

/* Compute Metrics Basic set :: GTI Read Throughput */
#define sklgt3__compute_basic__gti_read_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Compute Metrics Basic set :: GTI Write Throughput */
#define sklgt3__compute_basic__gti_write_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Time Elapsed */
#define sklgt3__render_pipe_profile__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Core Clocks */
#define sklgt3__render_pipe_profile__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define sklgt3__render_pipe_profile__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define sklgt3__render_pipe_profile__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics set for 3D Pipeline Profile :: GPU Busy */
#define sklgt3__render_pipe_profile__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics set for 3D Pipeline Profile :: VS Threads Dispatched */
#define sklgt3__render_pipe_profile__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: HS Threads Dispatched */
#define sklgt3__render_pipe_profile__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: DS Threads Dispatched */
#define sklgt3__render_pipe_profile__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics set for 3D Pipeline Profile :: GS Threads Dispatched */
#define sklgt3__render_pipe_profile__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: FS Threads Dispatched */
#define sklgt3__render_pipe_profile__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics set for 3D Pipeline Profile :: CS Threads Dispatched */
#define sklgt3__render_pipe_profile__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: EU Active */
#define sklgt3__render_pipe_profile__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics set for 3D Pipeline Profile :: EU Stall */
#define sklgt3__render_pipe_profile__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics set for 3D Pipeline Profile :: Rasterized Pixels */
#define sklgt3__render_pipe_profile__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics set for 3D Pipeline Profile :: Early Hi-Depth Test Fails */
#define sklgt3__render_pipe_profile__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Test Fails */
#define sklgt3__render_pipe_profile__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Killed in FS */
#define sklgt3__render_pipe_profile__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics set for 3D Pipeline Profile :: Pixels Failing Tests */
#define sklgt3__render_pipe_profile__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Written */
#define sklgt3__render_pipe_profile__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Blended */
#define sklgt3__render_pipe_profile__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels */
#define sklgt3__render_pipe_profile__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels Misses */
#define sklgt3__render_pipe_profile__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Read */
#define sklgt3__render_pipe_profile__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Written */
#define sklgt3__render_pipe_profile__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Memory Accesses */
#define sklgt3__render_pipe_profile__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Atomic Memory Accesses */
#define sklgt3__render_pipe_profile__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics set for 3D Pipeline Profile :: L3 Shader Throughput */
#define sklgt3__render_pipe_profile__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Barrier Messages */
#define sklgt3__render_pipe_profile__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: VF Bottleneck */
#define sklgt3__render_pipe_profile__vf_bottleneck__read \
   bdw__render_pipe_profile__vf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: VS Bottleneck */
#define sklgt3__render_pipe_profile__vs_bottleneck__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics set for 3D Pipeline Profile :: HS Bottleneck */
#define sklgt3__render_pipe_profile__hs_bottleneck__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics set for 3D Pipeline Profile :: DS Bottleneck */
#define sklgt3__render_pipe_profile__ds_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: GS Bottleneck */
#define sklgt3__render_pipe_profile__gs_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: SO Bottleneck */
#define sklgt3__render_pipe_profile__so_bottleneck__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Clipper Bottleneck */
#define sklgt3__render_pipe_profile__cl_bottleneck__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Strip-Fans Bottleneck */
#define sklgt3__render_pipe_profile__sf_bottleneck__read \
   bdw__render_pipe_profile__sf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Hi-Depth Bottleneck */
#define sklgt3__render_pipe_profile__hi_depth_bottleneck__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Bottleneck */
#define sklgt3__render_pipe_profile__early_depth_bottleneck__read \
   bdw__render_pipe_profile__early_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: BC Bottleneck */
#define sklgt3__render_pipe_profile__bc_bottleneck__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: HS Stall */
#define sklgt3__render_pipe_profile__hs_stall__read \
   bdw__render_pipe_profile__hs_stall__read

/* Render Metrics set for 3D Pipeline Profile :: DS Stall */
#define sklgt3__render_pipe_profile__ds_stall__read \
   bdw__render_pipe_profile__ds_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SO Stall */
#define sklgt3__render_pipe_profile__so_stall__read \
   bdw__render_pipe_profile__so_stall__read

/* Render Metrics set for 3D Pipeline Profile :: CL Stall */
#define sklgt3__render_pipe_profile__cl_stall__read \
   bdw__render_pipe_profile__cl_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SF Stall */
#define sklgt3__render_pipe_profile__sf_stall__read \
   bdw__render_pipe_profile__sf_stall__read

/* Memory Reads Distribution metrics set :: GPU Time Elapsed */
#define sklgt3__memory_reads__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Reads Distribution metrics set :: GPU Core Clocks */
#define sklgt3__memory_reads__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt3__memory_reads__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt3__memory_reads__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Reads Distribution metrics set :: GPU Busy */
#define sklgt3__memory_reads__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Reads Distribution metrics set :: VS Threads Dispatched */
#define sklgt3__memory_reads__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: HS Threads Dispatched */
#define sklgt3__memory_reads__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Reads Distribution metrics set :: DS Threads Dispatched */
#define sklgt3__memory_reads__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Reads Distribution metrics set :: GS Threads Dispatched */
#define sklgt3__memory_reads__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: FS Threads Dispatched */
#define sklgt3__memory_reads__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Reads Distribution metrics set :: CS Threads Dispatched */
#define sklgt3__memory_reads__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Reads Distribution metrics set :: EU Active */
#define sklgt3__memory_reads__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Reads Distribution metrics set :: EU Stall */
#define sklgt3__memory_reads__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Reads Distribution metrics set :: Rasterized Pixels */
#define sklgt3__memory_reads__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Reads Distribution metrics set :: Early Hi-Depth Test Fails */
#define sklgt3__memory_reads__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Early Depth Test Fails */
#define sklgt3__memory_reads__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Samples Killed in FS */
#define sklgt3__memory_reads__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Reads Distribution metrics set :: Pixels Failing Tests */
#define sklgt3__memory_reads__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Reads Distribution metrics set :: Samples Written */
#define sklgt3__memory_reads__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Reads Distribution metrics set :: Samples Blended */
#define sklgt3__memory_reads__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Reads Distribution metrics set :: Sampler Texels */
#define sklgt3__memory_reads__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Reads Distribution metrics set :: Sampler Texels Misses */
#define sklgt3__memory_reads__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Reads Distribution metrics set :: SLM Bytes Read */
#define sklgt3__memory_reads__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Reads Distribution metrics set :: SLM Bytes Written */
#define sklgt3__memory_reads__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Reads Distribution metrics set :: Shader Memory Accesses */
#define sklgt3__memory_reads__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Reads Distribution metrics set :: Shader Atomic Memory Accesses */
#define sklgt3__memory_reads__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Reads Distribution metrics set :: Shader Barrier Messages */
#define sklgt3__memory_reads__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: GtiCmdStreamerMemoryReads */
#define sklgt3__memory_reads__gti_cmd_streamer_memory_reads__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Reads Distribution metrics set :: GtiRsMemoryReads */
#define sklgt3__memory_reads__gti_rs_memory_reads__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Reads Distribution metrics set :: GtiVfMemoryReads */
#define sklgt3__memory_reads__gti_vf_memory_reads__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Memory Reads Distribution metrics set :: GtiRccMemoryReads */
#define sklgt3__memory_reads__gti_rcc_memory_reads__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiMscMemoryReads */
#define sklgt3__memory_reads__gti_msc_memory_reads__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Reads Distribution metrics set :: GtiHizMemoryReads */
#define sklgt3__memory_reads__gti_hiz_memory_reads__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiStcMemoryReads */
#define sklgt3__memory_reads__gti_stc_memory_reads__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Reads Distribution metrics set :: GtiRczMemoryReads */
#define sklgt3__memory_reads__gti_rcz_memory_reads__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Reads Distribution metrics set :: GtiMemoryReads */
#define sklgt3__memory_reads__gti_memory_reads__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank0Reads */
#define sklgt3__memory_reads__gti_l3_bank0_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank1Reads */
#define sklgt3__memory_reads__gti_l3_bank1_reads__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Reads Distribution metrics set :: GtiL3Bank2Reads */
#define sklgt3__memory_reads__gti_l3_bank2_reads__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Reads Distribution metrics set :: GtiL3Bank3Reads */
#define sklgt3__memory_reads__gti_l3_bank3_reads__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: GtiL3Reads */
#define sklgt3__memory_reads__gti_l3_reads__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Reads Distribution metrics set :: GtiRingAccesses */
#define sklgt3__memory_reads__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Memory Writes Distribution metrics set :: GPU Time Elapsed */
#define sklgt3__memory_writes__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Writes Distribution metrics set :: GPU Core Clocks */
#define sklgt3__memory_writes__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt3__memory_writes__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt3__memory_writes__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Writes Distribution metrics set :: GPU Busy */
#define sklgt3__memory_writes__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Writes Distribution metrics set :: VS Threads Dispatched */
#define sklgt3__memory_writes__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: HS Threads Dispatched */
#define sklgt3__memory_writes__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Writes Distribution metrics set :: DS Threads Dispatched */
#define sklgt3__memory_writes__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Writes Distribution metrics set :: GS Threads Dispatched */
#define sklgt3__memory_writes__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: FS Threads Dispatched */
#define sklgt3__memory_writes__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Writes Distribution metrics set :: CS Threads Dispatched */
#define sklgt3__memory_writes__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Writes Distribution metrics set :: EU Active */
#define sklgt3__memory_writes__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Writes Distribution metrics set :: EU Stall */
#define sklgt3__memory_writes__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Writes Distribution metrics set :: Rasterized Pixels */
#define sklgt3__memory_writes__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Writes Distribution metrics set :: Early Hi-Depth Test Fails */
#define sklgt3__memory_writes__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Early Depth Test Fails */
#define sklgt3__memory_writes__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Samples Killed in FS */
#define sklgt3__memory_writes__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Writes Distribution metrics set :: Pixels Failing Tests */
#define sklgt3__memory_writes__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Writes Distribution metrics set :: Samples Written */
#define sklgt3__memory_writes__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Writes Distribution metrics set :: Samples Blended */
#define sklgt3__memory_writes__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Writes Distribution metrics set :: Sampler Texels */
#define sklgt3__memory_writes__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Writes Distribution metrics set :: Sampler Texels Misses */
#define sklgt3__memory_writes__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Writes Distribution metrics set :: SLM Bytes Read */
#define sklgt3__memory_writes__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Writes Distribution metrics set :: SLM Bytes Written */
#define sklgt3__memory_writes__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Writes Distribution metrics set :: Shader Memory Accesses */
#define sklgt3__memory_writes__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Writes Distribution metrics set :: Shader Atomic Memory Accesses */
#define sklgt3__memory_writes__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Writes Distribution metrics set :: L3 Shader Throughput */
#define sklgt3__memory_writes__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Memory Writes Distribution metrics set :: Shader Barrier Messages */
#define sklgt3__memory_writes__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: GtiCmdStreamerMemoryWrites */
#define sklgt3__memory_writes__gti_cmd_streamer_memory_writes__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Writes Distribution metrics set :: GtiSoMemoryWrites */
#define sklgt3__memory_writes__gti_so_memory_writes__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Writes Distribution metrics set :: GtiRccMemoryWrites */
#define sklgt3__memory_writes__gti_rcc_memory_writes__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiMscMemoryWrites */
#define sklgt3__memory_writes__gti_msc_memory_writes__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Writes Distribution metrics set :: GtiHizMemoryWrites */
#define sklgt3__memory_writes__gti_hiz_memory_writes__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiStcMemoryWrites */
#define sklgt3__memory_writes__gti_stc_memory_writes__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Writes Distribution metrics set :: GtiRczMemoryWrites */
#define sklgt3__memory_writes__gti_rcz_memory_writes__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Writes Distribution metrics set :: GtiMemoryWrites */
#define sklgt3__memory_writes__gti_memory_writes__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank0Writes */
#define sklgt3__memory_writes__gti_l3_bank0_writes__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank1Writes */
#define sklgt3__memory_writes__gti_l3_bank1_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Writes Distribution metrics set :: GtiL3Bank2Writes */
#define sklgt3__memory_writes__gti_l3_bank2_writes__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Writes Distribution metrics set :: GtiL3Bank3Writes */
#define sklgt3__memory_writes__gti_l3_bank3_writes__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: GtiL3Writes */
#define sklgt3__memory_writes__gti_l3_writes__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Writes Distribution metrics set :: GtiRingAccesses */
#define sklgt3__memory_writes__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Compute Metrics Extended set :: GPU Time Elapsed */
#define sklgt3__compute_extended__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extended set :: GPU Core Clocks */
#define sklgt3__compute_extended__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: AVG GPU Core Frequency */
#define sklgt3__compute_extended__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extended set :: AVG GPU Core Frequency */
#define sklgt3__compute_extended__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extended set :: CS Threads Dispatched */
#define sklgt3__compute_extended__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Extended set :: EU Active */
#define sklgt3__compute_extended__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Extended set :: EU Stall */
#define sklgt3__compute_extended__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extended set :: EU Both FPU Pipes Active */
#define sklgt3__compute_extended__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Extended set :: EU FPU0 Pipe Active */
#define sklgt3__compute_extended__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Extended set :: EU FPU1 Pipe Active */
#define sklgt3__compute_extended__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Extended set :: EU AVG IPC Rate */
#define sklgt3__compute_extended__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Extended set :: EU Send Pipe Active */
#define sklgt3__compute_extended__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Extended set :: EU Thread Occupancy */
#define sklgt3__compute_extended__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Extended set :: Sampler Texels */
#define sklgt3__compute_extended__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Extended set :: Sampler Texels Misses */
#define sklgt3__compute_extended__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Extended set :: SLM Bytes Read */
#define sklgt3__compute_extended__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Extended set :: SLM Bytes Written */
#define sklgt3__compute_extended__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Extended set :: Shader Memory Accesses */
#define sklgt3__compute_extended__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Extended set :: Shader Atomic Memory Accesses */
#define sklgt3__compute_extended__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Extended set :: L3 Shader Throughput */
#define sklgt3__compute_extended__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Extended set :: Shader Barrier Messages */
#define sklgt3__compute_extended__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Extended set :: EuUntypedReads0 */
#define sklgt3__compute_extended__eu_untyped_reads0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Compute Metrics Extended set :: EuTypedReads0 */
#define sklgt3__compute_extended__eu_typed_reads0__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Compute Metrics Extended set :: EuUntypedWrites0 */
#define sklgt3__compute_extended__eu_untyped_writes0__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Compute Metrics Extended set :: EuTypedWrites0 */
#define sklgt3__compute_extended__eu_typed_writes0__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Compute Metrics Extended set :: EuUntypedAtomics0 */
#define sklgt3__compute_extended__eu_untyped_atomics0__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Compute Metrics Extended set :: EuTypedAtomics0 */
#define sklgt3__compute_extended__eu_typed_atomics0__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Compute Metrics Extended set :: EuA64UntypedReads0 */
#define sklgt3__compute_extended__eu_a64_untyped_reads0__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Compute Metrics Extended set :: EuA64UntypedWrites0 */
#define sklgt3__compute_extended__eu_a64_untyped_writes0__read \
   hsw__compute_extended__gpu_clocks__read

/* Compute Metrics Extended set :: Typed Reads 0 */
#define sklgt3__compute_extended__typed_reads0__read \
   hsw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: Typed Writes 0 */
#define sklgt3__compute_extended__typed_writes0__read \
   hsw__compute_extended__typed_writes0__read

/* Compute Metrics Extended set :: Untyped Reads 0 */
#define sklgt3__compute_extended__untyped_reads0__read \
   hsw__compute_extended__untyped_reads0__read

/* Compute Metrics Extended set :: Untyped Writes 0 */
#define sklgt3__compute_extended__untyped_writes0__read \
   hsw__compute_extended__untyped_writes0__read

/* Compute Metrics Extended set :: Typed Atomics 0 */
#define sklgt3__compute_extended__typed_atomics0__read \
   hsw__compute_extended__typed_atomics0__read

/* Compute Metrics Extended set :: TypedReadsPerCacheLine */
#define sklgt3__compute_extended__typed_reads_per_cache_line__read \
   hsw__compute_extended__typed_reads_per_cache_line__read

/* Compute Metrics Extended set :: TypedWritesPerCacheLine */
#define sklgt3__compute_extended__typed_writes_per_cache_line__read \
   hsw__compute_extended__typed_writes_per_cache_line__read

/* Compute Metrics Extended set :: UntypedReadsPerCacheLine */
#define sklgt3__compute_extended__untyped_reads_per_cache_line__read \
   bdw__compute_extended__untyped_reads_per_cache_line__read

/* Compute Metrics Extended set :: UntypedWritesPerCacheLine */
#define sklgt3__compute_extended__untyped_writes_per_cache_line__read \
   bdw__compute_extended__untyped_writes_per_cache_line__read

/* Compute Metrics Extended set :: TypedAtomicsPerCacheLine */
#define sklgt3__compute_extended__typed_atomics_per_cache_line__read \
   hsw__compute_extended__typed_atomics_per_cache_line__read

/* Compute Metrics L3 Cache set :: GPU Time Elapsed */
#define sklgt3__compute_l3_cache__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics L3 Cache set :: GPU Core Clocks */
#define sklgt3__compute_l3_cache__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics L3 Cache set :: AVG GPU Core Frequency */
#define sklgt3__compute_l3_cache__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics L3 Cache set :: AVG GPU Core Frequency */
#define sklgt3__compute_l3_cache__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics L3 Cache set :: GPU Busy */
#define sklgt3__compute_l3_cache__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics L3 Cache set :: VS Threads Dispatched */
#define sklgt3__compute_l3_cache__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache set :: HS Threads Dispatched */
#define sklgt3__compute_l3_cache__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics L3 Cache set :: DS Threads Dispatched */
#define sklgt3__compute_l3_cache__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics L3 Cache set :: GS Threads Dispatched */
#define sklgt3__compute_l3_cache__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache set :: FS Threads Dispatched */
#define sklgt3__compute_l3_cache__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics L3 Cache set :: CS Threads Dispatched */
#define sklgt3__compute_l3_cache__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics L3 Cache set :: EU Active */
#define sklgt3__compute_l3_cache__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics L3 Cache set :: EU Stall */
#define sklgt3__compute_l3_cache__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics L3 Cache set :: EU Both FPU Pipes Active */
#define sklgt3__compute_l3_cache__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Pipe Active */
#define sklgt3__compute_l3_cache__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Pipe Active */
#define sklgt3__compute_l3_cache__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics L3 Cache set :: EU AVG IPC Rate */
#define sklgt3__compute_l3_cache__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics L3 Cache set :: EU Send Pipe Active */
#define sklgt3__compute_l3_cache__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Hybrid Instruction */
#define sklgt3__compute_l3_cache__eu_hybrid_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU1 Hybrid Instruction */
#define sklgt3__compute_l3_cache__eu_hybrid_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU0 Ternary Instruction */
#define sklgt3__compute_l3_cache__eu_ternary_fpu0_instruction__read \
   bdw__render_basic__ps_fpu0_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Ternary Instruction */
#define sklgt3__compute_l3_cache__eu_ternary_fpu1_instruction__read \
   bdw__render_basic__ps_fpu1_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Binary Instruction */
#define sklgt3__compute_l3_cache__eu_binary_fpu0_instruction__read \
   bdw__render_basic__ps_send_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Binary Instruction */
#define sklgt3__compute_l3_cache__eu_binary_fpu1_instruction__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Move Instruction */
#define sklgt3__compute_l3_cache__eu_move_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu0_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU1 Move Instruction */
#define sklgt3__compute_l3_cache__eu_move_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu1_instruction__read

/* Compute Metrics L3 Cache set :: Rasterized Pixels */
#define sklgt3__compute_l3_cache__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics L3 Cache set :: Early Hi-Depth Test Fails */
#define sklgt3__compute_l3_cache__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics L3 Cache set :: Early Depth Test Fails */
#define sklgt3__compute_l3_cache__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache set :: Samples Killed in FS */
#define sklgt3__compute_l3_cache__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics L3 Cache set :: Pixels Failing Tests */
#define sklgt3__compute_l3_cache__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics L3 Cache set :: Samples Written */
#define sklgt3__compute_l3_cache__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics L3 Cache set :: Samples Blended */
#define sklgt3__compute_l3_cache__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics L3 Cache set :: Sampler Accesses */
#define sklgt3__compute_l3_cache__sampler_accesses__read \
   bdw__render_pipe_profile__sampler_accesses__read

/* Compute Metrics L3 Cache set :: Sampler Texels */
#define sklgt3__compute_l3_cache__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics L3 Cache set :: Sampler Texels Misses */
#define sklgt3__compute_l3_cache__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics L3 Cache set :: SLM Bytes Read */
#define sklgt3__compute_l3_cache__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics L3 Cache set :: SLM Bytes Written */
#define sklgt3__compute_l3_cache__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics L3 Cache set :: Shader Memory Accesses */
#define sklgt3__compute_l3_cache__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics L3 Cache set :: Shader Atomic Memory Accesses */
#define sklgt3__compute_l3_cache__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics L3 Cache set :: L3 Accesses */
#define sklgt3__compute_l3_cache__l3_accesses__read \
   sklgt2__compute_l3_cache__l3_accesses__read

/* Compute Metrics L3 Cache set :: L3 Misses */
#define sklgt3__compute_l3_cache__l3_misses__read \
   bdw__compute_l3_cache__l3_misses__read

/* Compute Metrics L3 Cache set :: L3 Sampler Throughput */
#define sklgt3__compute_l3_cache__l3_sampler_throughput__read \
   chv__render_basic__l3_sampler_throughput__read

/* Compute Metrics L3 Cache set :: L3 Shader Throughput */
#define sklgt3__compute_l3_cache__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics L3 Cache set :: L3 Total Throughput */
#define sklgt3__compute_l3_cache__l3_total_throughput__read \
   sklgt2__compute_l3_cache__l3_total_throughput__read

/* Compute Metrics L3 Cache set :: Shader Barrier Messages */
#define sklgt3__compute_l3_cache__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 Accesses */
#define sklgt3__compute_l3_cache__l3_bank00_accesses__read \
   bdw__compute_l3_cache__l3_bank00_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 01 Accesses */
#define sklgt3__compute_l3_cache__l3_bank01_accesses__read \
   bdw__compute_l3_cache__l3_bank01_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 02 Accesses */
#define sklgt3__compute_l3_cache__l3_bank02_accesses__read \
   bdw__compute_l3_cache__l3_bank02_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 03 Accesses */
#define sklgt3__compute_l3_cache__l3_bank03_accesses__read \
   bdw__compute_l3_cache__l3_bank03_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 IC Accesses */
#define sklgt3__compute_l3_cache__l3_bank00_ic_accesses__read \
   bdw__compute_l3_cache__l3_bank00_ic_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 IC Hits */
#define sklgt3__compute_l3_cache__l3_bank00_ic_hits__read \
   bdw__compute_l3_cache__l3_bank00_ic_hits__read

/* Compute Metrics L3 Cache set :: GTI L3 Throughput */
#define sklgt3__compute_l3_cache__gti_l3_throughput__read \
   bdw__compute_l3_cache__gti_l3_throughput__read

/* Compute Metrics L3 Cache set :: GTI Read Throughput */
#define sklgt3__compute_l3_cache__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Compute Metrics L3 Cache set :: GTI Write Throughput */
#define sklgt3__compute_l3_cache__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Metric set HDCAndSF :: GPU Time Elapsed */
#define sklgt3__hdc_and_sf__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set HDCAndSF :: GPU Core Clocks */
#define sklgt3__hdc_and_sf__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define sklgt3__hdc_and_sf__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define sklgt3__hdc_and_sf__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set HDCAndSF :: GPU Busy */
#define sklgt3__hdc_and_sf__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set HDCAndSF :: VS Threads Dispatched */
#define sklgt3__hdc_and_sf__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: HS Threads Dispatched */
#define sklgt3__hdc_and_sf__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set HDCAndSF :: DS Threads Dispatched */
#define sklgt3__hdc_and_sf__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set HDCAndSF :: GS Threads Dispatched */
#define sklgt3__hdc_and_sf__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: FS Threads Dispatched */
#define sklgt3__hdc_and_sf__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set HDCAndSF :: CS Threads Dispatched */
#define sklgt3__hdc_and_sf__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set HDCAndSF :: EU Active */
#define sklgt3__hdc_and_sf__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set HDCAndSF :: EU Stall */
#define sklgt3__hdc_and_sf__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
#define sklgt3__hdc_and_sf__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
#define sklgt3__hdc_and_sf__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
#define sklgt3__hdc_and_sf__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set HDCAndSF :: VS Send Pipe Active */
#define sklgt3__hdc_and_sf__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
#define sklgt3__hdc_and_sf__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
#define sklgt3__hdc_and_sf__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set HDCAndSF :: PS Send Pipeline Active */
#define sklgt3__hdc_and_sf__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set HDCAndSF :: FS Both FPU Active */
#define sklgt3__hdc_and_sf__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set HDCAndSF :: Rasterized Pixels */
#define sklgt3__hdc_and_sf__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
#define sklgt3__hdc_and_sf__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set HDCAndSF :: Early Depth Test Fails */
#define sklgt3__hdc_and_sf__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Samples Killed in FS */
#define sklgt3__hdc_and_sf__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set HDCAndSF :: Pixels Failing Tests */
#define sklgt3__hdc_and_sf__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set HDCAndSF :: Samples Written */
#define sklgt3__hdc_and_sf__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set HDCAndSF :: Samples Blended */
#define sklgt3__hdc_and_sf__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set HDCAndSF :: Sampler Texels */
#define sklgt3__hdc_and_sf__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set HDCAndSF :: Sampler Texels Misses */
#define sklgt3__hdc_and_sf__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set HDCAndSF :: SLM Bytes Read */
#define sklgt3__hdc_and_sf__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set HDCAndSF :: SLM Bytes Written */
#define sklgt3__hdc_and_sf__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set HDCAndSF :: Shader Memory Accesses */
#define sklgt3__hdc_and_sf__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
#define sklgt3__hdc_and_sf__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set HDCAndSF :: L3 Shader Throughput */
#define sklgt3__hdc_and_sf__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set HDCAndSF :: Shader Barrier Messages */
#define sklgt3__hdc_and_sf__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Polygon Data Ready */
#define sklgt3__hdc_and_sf__poly_data_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
#define sklgt3__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
#define sklgt3__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
#define sklgt3__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read

/* Metric set HDCAndSF :: SQ is full */
#define sklgt3__hdc_and_sf__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_1 :: GPU Time Elapsed */
#define sklgt3__l3_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_1 :: GPU Core Clocks */
#define sklgt3__l3_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define sklgt3__l3_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define sklgt3__l3_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_1 :: GPU Busy */
#define sklgt3__l3_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_1 :: VS Threads Dispatched */
#define sklgt3__l3_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_1 :: HS Threads Dispatched */
#define sklgt3__l3_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_1 :: DS Threads Dispatched */
#define sklgt3__l3_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_1 :: GS Threads Dispatched */
#define sklgt3__l3_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_1 :: FS Threads Dispatched */
#define sklgt3__l3_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_1 :: CS Threads Dispatched */
#define sklgt3__l3_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_1 :: EU Active */
#define sklgt3__l3_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_1 :: EU Stall */
#define sklgt3__l3_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_1 :: EU Both FPU Pipes Active */
#define sklgt3__l3_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_1 :: VS FPU0 Pipe Active */
#define sklgt3__l3_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_1 :: VS FPU1 Pipe Active */
#define sklgt3__l3_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_1 :: VS Send Pipe Active */
#define sklgt3__l3_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_1 :: PS FPU0 Pipe Active */
#define sklgt3__l3_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_1 :: PS FPU1 Pipe Active */
#define sklgt3__l3_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_1 :: PS Send Pipeline Active */
#define sklgt3__l3_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_1 :: FS Both FPU Active */
#define sklgt3__l3_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_1 :: Rasterized Pixels */
#define sklgt3__l3_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
#define sklgt3__l3_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_1 :: Early Depth Test Fails */
#define sklgt3__l3_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Samples Killed in FS */
#define sklgt3__l3_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_1 :: Pixels Failing Tests */
#define sklgt3__l3_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_1 :: Samples Written */
#define sklgt3__l3_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_1 :: Samples Blended */
#define sklgt3__l3_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_1 :: Sampler Texels */
#define sklgt3__l3_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_1 :: Sampler Texels Misses */
#define sklgt3__l3_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_1 :: SLM Bytes Read */
#define sklgt3__l3_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_1 :: SLM Bytes Written */
#define sklgt3__l3_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_1 :: Shader Memory Accesses */
#define sklgt3__l3_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
#define sklgt3__l3_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_1 :: L3 Shader Throughput */
#define sklgt3__l3_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_1 :: Shader Barrier Messages */
#define sklgt3__l3_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Stalled */
#define sklgt3__l3_1__l30_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Stalled */
#define sklgt3__l3_1__l30_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Active */
#define sklgt3__l3_1__l30_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Active */
#define sklgt3__l3_1__l30_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_1 :: SQ is full */
#define sklgt3__l3_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_2 :: GPU Time Elapsed */
#define sklgt3__l3_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_2 :: GPU Core Clocks */
#define sklgt3__l3_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define sklgt3__l3_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define sklgt3__l3_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_2 :: GPU Busy */
#define sklgt3__l3_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_2 :: VS Threads Dispatched */
#define sklgt3__l3_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_2 :: HS Threads Dispatched */
#define sklgt3__l3_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_2 :: DS Threads Dispatched */
#define sklgt3__l3_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_2 :: GS Threads Dispatched */
#define sklgt3__l3_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_2 :: FS Threads Dispatched */
#define sklgt3__l3_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_2 :: CS Threads Dispatched */
#define sklgt3__l3_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_2 :: EU Active */
#define sklgt3__l3_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_2 :: EU Stall */
#define sklgt3__l3_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_2 :: EU Both FPU Pipes Active */
#define sklgt3__l3_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_2 :: VS FPU0 Pipe Active */
#define sklgt3__l3_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_2 :: VS FPU1 Pipe Active */
#define sklgt3__l3_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_2 :: VS Send Pipe Active */
#define sklgt3__l3_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_2 :: PS FPU0 Pipe Active */
#define sklgt3__l3_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_2 :: PS FPU1 Pipe Active */
#define sklgt3__l3_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_2 :: PS Send Pipeline Active */
#define sklgt3__l3_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_2 :: FS Both FPU Active */
#define sklgt3__l3_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_2 :: Rasterized Pixels */
#define sklgt3__l3_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
#define sklgt3__l3_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_2 :: Early Depth Test Fails */
#define sklgt3__l3_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Samples Killed in FS */
#define sklgt3__l3_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_2 :: Pixels Failing Tests */
#define sklgt3__l3_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_2 :: Samples Written */
#define sklgt3__l3_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_2 :: Samples Blended */
#define sklgt3__l3_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_2 :: Sampler Texels */
#define sklgt3__l3_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_2 :: Sampler Texels Misses */
#define sklgt3__l3_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_2 :: SLM Bytes Read */
#define sklgt3__l3_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_2 :: SLM Bytes Written */
#define sklgt3__l3_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_2 :: Shader Memory Accesses */
#define sklgt3__l3_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
#define sklgt3__l3_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_2 :: L3 Shader Throughput */
#define sklgt3__l3_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_2 :: Shader Barrier Messages */
#define sklgt3__l3_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Stalled */
#define sklgt3__l3_2__l30_bank2_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Active */
#define sklgt3__l3_2__l30_bank2_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_2 :: SQ is full */
#define sklgt3__l3_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_3 :: GPU Time Elapsed */
#define sklgt3__l3_3__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_3 :: GPU Core Clocks */
#define sklgt3__l3_3__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define sklgt3__l3_3__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define sklgt3__l3_3__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_3 :: GPU Busy */
#define sklgt3__l3_3__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_3 :: VS Threads Dispatched */
#define sklgt3__l3_3__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_3 :: HS Threads Dispatched */
#define sklgt3__l3_3__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_3 :: DS Threads Dispatched */
#define sklgt3__l3_3__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_3 :: GS Threads Dispatched */
#define sklgt3__l3_3__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_3 :: FS Threads Dispatched */
#define sklgt3__l3_3__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_3 :: CS Threads Dispatched */
#define sklgt3__l3_3__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_3 :: EU Active */
#define sklgt3__l3_3__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_3 :: EU Stall */
#define sklgt3__l3_3__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_3 :: EU Both FPU Pipes Active */
#define sklgt3__l3_3__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_3 :: VS FPU0 Pipe Active */
#define sklgt3__l3_3__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_3 :: VS FPU1 Pipe Active */
#define sklgt3__l3_3__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_3 :: VS Send Pipe Active */
#define sklgt3__l3_3__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_3 :: PS FPU0 Pipe Active */
#define sklgt3__l3_3__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_3 :: PS FPU1 Pipe Active */
#define sklgt3__l3_3__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_3 :: PS Send Pipeline Active */
#define sklgt3__l3_3__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_3 :: FS Both FPU Active */
#define sklgt3__l3_3__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_3 :: Rasterized Pixels */
#define sklgt3__l3_3__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
#define sklgt3__l3_3__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_3 :: Early Depth Test Fails */
#define sklgt3__l3_3__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Samples Killed in FS */
#define sklgt3__l3_3__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_3 :: Pixels Failing Tests */
#define sklgt3__l3_3__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_3 :: Samples Written */
#define sklgt3__l3_3__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_3 :: Samples Blended */
#define sklgt3__l3_3__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_3 :: Sampler Texels */
#define sklgt3__l3_3__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_3 :: Sampler Texels Misses */
#define sklgt3__l3_3__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_3 :: SLM Bytes Read */
#define sklgt3__l3_3__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_3 :: SLM Bytes Written */
#define sklgt3__l3_3__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_3 :: Shader Memory Accesses */
#define sklgt3__l3_3__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
#define sklgt3__l3_3__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_3 :: L3 Shader Throughput */
#define sklgt3__l3_3__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_3 :: Shader Barrier Messages */
#define sklgt3__l3_3__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
#define sklgt3__l3_3__l30_bank3_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
#define sklgt3__l3_3__l30_bank3_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_3 :: SQ is full */
#define sklgt3__l3_3__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
#define sklgt3__rasterizer_and_pixel_backend__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
#define sklgt3__rasterizer_and_pixel_backend__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define sklgt3__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define sklgt3__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
#define sklgt3__rasterizer_and_pixel_backend__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
#define sklgt3__rasterizer_and_pixel_backend__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
#define sklgt3__rasterizer_and_pixel_backend__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
#define sklgt3__rasterizer_and_pixel_backend__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
#define sklgt3__rasterizer_and_pixel_backend__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
#define sklgt3__rasterizer_and_pixel_backend__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
#define sklgt3__rasterizer_and_pixel_backend__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set RasterizerAndPixelBackend :: EU Active */
#define sklgt3__rasterizer_and_pixel_backend__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set RasterizerAndPixelBackend :: EU Stall */
#define sklgt3__rasterizer_and_pixel_backend__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
#define sklgt3__rasterizer_and_pixel_backend__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
#define sklgt3__rasterizer_and_pixel_backend__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
#define sklgt3__rasterizer_and_pixel_backend__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
#define sklgt3__rasterizer_and_pixel_backend__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
#define sklgt3__rasterizer_and_pixel_backend__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
#define sklgt3__rasterizer_and_pixel_backend__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
#define sklgt3__rasterizer_and_pixel_backend__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
#define sklgt3__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
#define sklgt3__rasterizer_and_pixel_backend__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
#define sklgt3__rasterizer_and_pixel_backend__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
#define sklgt3__rasterizer_and_pixel_backend__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
#define sklgt3__rasterizer_and_pixel_backend__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
#define sklgt3__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set RasterizerAndPixelBackend :: Samples Written */
#define sklgt3__rasterizer_and_pixel_backend__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
#define sklgt3__rasterizer_and_pixel_backend__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
#define sklgt3__rasterizer_and_pixel_backend__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
#define sklgt3__rasterizer_and_pixel_backend__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
#define sklgt3__rasterizer_and_pixel_backend__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
#define sklgt3__rasterizer_and_pixel_backend__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
#define sklgt3__rasterizer_and_pixel_backend__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
#define sklgt3__rasterizer_and_pixel_backend__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
#define sklgt3__rasterizer_and_pixel_backend__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
#define sklgt3__rasterizer_and_pixel_backend__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
#define sklgt3__rasterizer_and_pixel_backend__pixel_data0_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
#define sklgt3__rasterizer_and_pixel_backend__rasterizer0_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
#define sklgt3__rasterizer_and_pixel_backend__ps_output0_available__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
#define sklgt3__rasterizer_and_pixel_backend__pixel_values0_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
#define sklgt3__rasterizer_and_pixel_backend__rasterizer0_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set RasterizerAndPixelBackend :: SQ is full */
#define sklgt3__rasterizer_and_pixel_backend__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler :: GPU Time Elapsed */
#define sklgt3__sampler__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler :: GPU Core Clocks */
#define sklgt3__sampler__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define sklgt3__sampler__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define sklgt3__sampler__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler :: GPU Busy */
#define sklgt3__sampler__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler :: VS Threads Dispatched */
#define sklgt3__sampler__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler :: HS Threads Dispatched */
#define sklgt3__sampler__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler :: DS Threads Dispatched */
#define sklgt3__sampler__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler :: GS Threads Dispatched */
#define sklgt3__sampler__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler :: FS Threads Dispatched */
#define sklgt3__sampler__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler :: CS Threads Dispatched */
#define sklgt3__sampler__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler :: EU Active */
#define sklgt3__sampler__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler :: EU Stall */
#define sklgt3__sampler__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler :: EU Both FPU Pipes Active */
#define sklgt3__sampler__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler :: VS FPU0 Pipe Active */
#define sklgt3__sampler__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler :: VS FPU1 Pipe Active */
#define sklgt3__sampler__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler :: VS Send Pipe Active */
#define sklgt3__sampler__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler :: PS FPU0 Pipe Active */
#define sklgt3__sampler__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler :: PS FPU1 Pipe Active */
#define sklgt3__sampler__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler :: PS Send Pipeline Active */
#define sklgt3__sampler__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler :: FS Both FPU Active */
#define sklgt3__sampler__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler :: Rasterized Pixels */
#define sklgt3__sampler__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler :: Early Hi-Depth Test Fails */
#define sklgt3__sampler__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler :: Early Depth Test Fails */
#define sklgt3__sampler__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Samples Killed in FS */
#define sklgt3__sampler__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler :: Pixels Failing Tests */
#define sklgt3__sampler__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler :: Samples Written */
#define sklgt3__sampler__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler :: Samples Blended */
#define sklgt3__sampler__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler :: Sampler Texels */
#define sklgt3__sampler__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler :: Sampler Texels Misses */
#define sklgt3__sampler__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler :: SLM Bytes Read */
#define sklgt3__sampler__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler :: SLM Bytes Written */
#define sklgt3__sampler__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler :: Shader Memory Accesses */
#define sklgt3__sampler__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler :: Shader Atomic Memory Accesses */
#define sklgt3__sampler__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler :: L3 Shader Throughput */
#define sklgt3__sampler__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler :: Shader Barrier Messages */
#define sklgt3__sampler__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Slice0 Subslice1 Input Available */
#define sklgt3__sampler__sampler01_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler :: Slice0 Subslice2 Input Available */
#define sklgt3__sampler__sampler02_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler :: Slice0 Subslice0 Input Available */
#define sklgt3__sampler__sampler00_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice2 Sampler Output Ready */
#define sklgt3__sampler__sampler02_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice0 Sampler Output Ready */
#define sklgt3__sampler__sampler00_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice1 Sampler Output Ready */
#define sklgt3__sampler__sampler01_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler :: SQ is full */
#define sklgt3__sampler__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_1 :: GPU Time Elapsed */
#define sklgt3__tdl_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_1 :: GPU Core Clocks */
#define sklgt3__tdl_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define sklgt3__tdl_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define sklgt3__tdl_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_1 :: GPU Busy */
#define sklgt3__tdl_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_1 :: VS Threads Dispatched */
#define sklgt3__tdl_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_1 :: HS Threads Dispatched */
#define sklgt3__tdl_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_1 :: DS Threads Dispatched */
#define sklgt3__tdl_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_1 :: GS Threads Dispatched */
#define sklgt3__tdl_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_1 :: FS Threads Dispatched */
#define sklgt3__tdl_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_1 :: CS Threads Dispatched */
#define sklgt3__tdl_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_1 :: EU Active */
#define sklgt3__tdl_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_1 :: EU Stall */
#define sklgt3__tdl_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
#define sklgt3__tdl_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
#define sklgt3__tdl_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
#define sklgt3__tdl_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_1 :: VS Send Pipe Active */
#define sklgt3__tdl_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
#define sklgt3__tdl_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
#define sklgt3__tdl_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_1 :: PS Send Pipeline Active */
#define sklgt3__tdl_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_1 :: FS Both FPU Active */
#define sklgt3__tdl_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_1 :: Rasterized Pixels */
#define sklgt3__tdl_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
#define sklgt3__tdl_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_1 :: Early Depth Test Fails */
#define sklgt3__tdl_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: Samples Killed in FS */
#define sklgt3__tdl_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_1 :: Pixels Failing Tests */
#define sklgt3__tdl_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_1 :: Samples Written */
#define sklgt3__tdl_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_1 :: Samples Blended */
#define sklgt3__tdl_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_1 :: Sampler Texels */
#define sklgt3__tdl_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_1 :: Sampler Texels Misses */
#define sklgt3__tdl_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_1 :: SLM Bytes Read */
#define sklgt3__tdl_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_1 :: SLM Bytes Written */
#define sklgt3__tdl_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_1 :: Shader Memory Accesses */
#define sklgt3__tdl_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
#define sklgt3__tdl_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_1 :: L3 Shader Throughput */
#define sklgt3__tdl_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_1 :: Shader Barrier Messages */
#define sklgt3__tdl_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
#define sklgt3__tdl_1__non_ps_thread01_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice0 */
#define sklgt3__tdl_1__ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
#define sklgt3__tdl_1__non_ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice2 */
#define sklgt3__tdl_1__ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
#define sklgt3__tdl_1__non_ps_thread02_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice1 */
#define sklgt3__tdl_1__ps_thread01_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_1 :: SQ is full */
#define sklgt3__tdl_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_2 :: GPU Time Elapsed */
#define sklgt3__tdl_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_2 :: GPU Core Clocks */
#define sklgt3__tdl_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define sklgt3__tdl_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define sklgt3__tdl_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_2 :: GPU Busy */
#define sklgt3__tdl_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_2 :: VS Threads Dispatched */
#define sklgt3__tdl_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_2 :: HS Threads Dispatched */
#define sklgt3__tdl_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_2 :: DS Threads Dispatched */
#define sklgt3__tdl_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_2 :: GS Threads Dispatched */
#define sklgt3__tdl_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_2 :: FS Threads Dispatched */
#define sklgt3__tdl_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_2 :: CS Threads Dispatched */
#define sklgt3__tdl_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_2 :: EU Active */
#define sklgt3__tdl_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_2 :: EU Stall */
#define sklgt3__tdl_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
#define sklgt3__tdl_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
#define sklgt3__tdl_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
#define sklgt3__tdl_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_2 :: VS Send Pipe Active */
#define sklgt3__tdl_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
#define sklgt3__tdl_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
#define sklgt3__tdl_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_2 :: PS Send Pipeline Active */
#define sklgt3__tdl_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_2 :: FS Both FPU Active */
#define sklgt3__tdl_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_2 :: Rasterized Pixels */
#define sklgt3__tdl_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
#define sklgt3__tdl_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_2 :: Early Depth Test Fails */
#define sklgt3__tdl_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Samples Killed in FS */
#define sklgt3__tdl_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_2 :: Pixels Failing Tests */
#define sklgt3__tdl_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_2 :: Samples Written */
#define sklgt3__tdl_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_2 :: Samples Blended */
#define sklgt3__tdl_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_2 :: Sampler Texels */
#define sklgt3__tdl_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_2 :: Sampler Texels Misses */
#define sklgt3__tdl_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_2 :: SLM Bytes Read */
#define sklgt3__tdl_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_2 :: SLM Bytes Written */
#define sklgt3__tdl_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_2 :: Shader Memory Accesses */
#define sklgt3__tdl_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
#define sklgt3__tdl_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_2 :: L3 Shader Throughput */
#define sklgt3__tdl_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_2 :: Shader Barrier Messages */
#define sklgt3__tdl_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 0 */
#define sklgt3__tdl_2__thread_header01_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 1 */
#define sklgt3__tdl_2__thread_header00_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 0 */
#define sklgt3__tdl_2__thread_header00_ready_port0__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 1 */
#define sklgt3__tdl_2__thread_header02_ready_port1__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 0 */
#define sklgt3__tdl_2__thread_header02_ready_port0__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 1 */
#define sklgt3__tdl_2__thread_header01_ready_port1__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_2 :: SQ is full */
#define sklgt3__tdl_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Compute Metrics Extra set :: GPU Time Elapsed */
#define sklgt3__compute_extra__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extra set :: GPU Core Clocks */
#define sklgt3__compute_extra__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define sklgt3__compute_extra__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define sklgt3__compute_extra__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extra set :: EU FPU1 Pipe Active */
#define sklgt3__compute_extra__fpu1_active__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extra set :: EU FPU1 Pipe Active including Ext Math */
#define sklgt3__compute_extra__fpu1_active_adjusted__read \
   bdw__compute_extra__fpu1_active_adjusted__read

/* Media Vme Pipe metrics set :: GPU Time Elapsed */
#define sklgt3__vme_pipe__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Media Vme Pipe metrics set :: GPU Core Clocks */
#define sklgt3__vme_pipe__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define sklgt3__vme_pipe__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define sklgt3__vme_pipe__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Media Vme Pipe metrics set :: GPU Busy */
#define sklgt3__vme_pipe__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Media Vme Pipe metrics set :: CS Threads Dispatched */
#define sklgt3__vme_pipe__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Media Vme Pipe metrics set :: EU Active */
#define sklgt3__vme_pipe__eu_active__read \
   bdw__render_basic__eu_active__read

/* Media Vme Pipe metrics set :: EU Stall */
#define sklgt3__vme_pipe__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Media Vme Pipe metrics set :: EU Both FPU Pipes Active */
#define sklgt3__vme_pipe__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Media Vme Pipe metrics set :: EU Thread Occupancy */
#define sklgt3__vme_pipe__eu_thread_occupancy__read \
   bdw__vme_pipe__eu_thread_occupancy__read

/* Media Vme Pipe metrics set :: VME Busy */
#define sklgt3__vme_pipe__vme_busy__read \
   bdw__vme_pipe__vme_busy__read

/* Gpu Rings Busyness :: GPU Time Elapsed */
#define sklgt3__gpu_busyness__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Gpu Rings Busyness :: GPU Core Clocks */
#define sklgt3__gpu_busyness__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define sklgt3__gpu_busyness__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define sklgt3__gpu_busyness__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Gpu Rings Busyness :: Render Ring Busy */
#define sklgt3__gpu_busyness__render_busy__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Gpu Rings Busyness :: Vdbox0 Ring Busy */
#define sklgt3__gpu_busyness__vdbox0_busy__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Gpu Rings Busyness :: Vdbox1 Ring Busy */
#define sklgt3__gpu_busyness__vdbox1_busy__read \
   bdw__render_pipe_profile__sf_stall__read

/* Gpu Rings Busyness :: Vebox Ring Busy */
#define sklgt3__gpu_busyness__vebox_busy__read \
   bdw__render_pipe_profile__cl_stall__read

/* Gpu Rings Busyness :: Blitter Ring Busy */
#define sklgt3__gpu_busyness__blitter_busy__read \
   bdw__render_pipe_profile__so_stall__read

/* Gpu Rings Busyness :: AnyRingBusy */
#define sklgt3__gpu_busyness__any_ring_busy__read \
   bdw__render_basic__sampler0_busy__read

/* MDAPI testing set :: GPU Time Elapsed */
#define sklgt3__test_oa__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* MDAPI testing set :: GPU Core Clocks */
#define sklgt3__test_oa__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define sklgt3__test_oa__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define sklgt3__test_oa__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* MDAPI testing set :: TestCounter0 */
#define sklgt3__test_oa__counter0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* MDAPI testing set :: TestCounter1 */
#define sklgt3__test_oa__counter1__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* MDAPI testing set :: TestCounter2 */
#define sklgt3__test_oa__counter2__read \
   hsw__compute_extended__eu_typed_reads0__read

/* MDAPI testing set :: TestCounter3 */
#define sklgt3__test_oa__counter3__read \
   hsw__compute_extended__eu_typed_writes0__read

/* MDAPI testing set :: TestCounter4 */
#define sklgt3__test_oa__counter4__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* MDAPI testing set :: TestCounter5 */
#define sklgt3__test_oa__counter5__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* MDAPI testing set :: TestCounter6 */
#define sklgt3__test_oa__counter6__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* MDAPI testing set :: TestCounter7 */
#define sklgt3__test_oa__counter7__read \
   hsw__compute_extended__gpu_clocks__read

/* MDAPI testing set :: TestCounter8 */
#define sklgt3__test_oa__counter8__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Metric set PMA Stall :: GPU Time Elapsed */
#define sklgt3__pma__stall__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set PMA Stall :: GPU Core Clocks */
#define sklgt3__pma__stall__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define sklgt3__pma__stall__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define sklgt3__pma__stall__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set PMA Stall :: STC PMA stall */
#define sklgt3__pma__stall__stc_pma_stall__read \
   sklgt2__pma__stall__stc_pma_stall__read

/* AsyncCompute :: GPU Time Elapsed */
#define sklgt3__async_compute__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* AsyncCompute :: GPU Core Clocks */
#define sklgt3__async_compute__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define sklgt3__async_compute__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define sklgt3__async_compute__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* AsyncCompute :: GPU Busy */
#define sklgt3__async_compute__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* AsyncCompute :: VS Threads Dispatched */
#define sklgt3__async_compute__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* AsyncCompute :: HS Threads Dispatched */
#define sklgt3__async_compute__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* AsyncCompute :: DS Threads Dispatched */
#define sklgt3__async_compute__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* AsyncCompute :: GS Threads Dispatched */
#define sklgt3__async_compute__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* AsyncCompute :: FS Threads Dispatched */
#define sklgt3__async_compute__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* AsyncCompute :: CS Threads Dispatched */
#define sklgt3__async_compute__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* AsyncCompute :: EU FPU0 Pipe Active */
#define sklgt3__async_compute__fpu0_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* AsyncCompute :: VS FPU0 Pipe Active */
#define sklgt3__async_compute__vs_fpu0_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* AsyncCompute :: PS FPU0 Pipe Active */
#define sklgt3__async_compute__ps_fpu0_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* AsyncCompute :: CS FPU0 Pipe Active */
#define sklgt3__async_compute__cs_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* AsyncCompute :: EU FPU1 Pipe Active */
#define sklgt3__async_compute__fpu1_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* AsyncCompute :: VS FPU1 Pipe Active */
#define sklgt3__async_compute__vs_fpu1_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* AsyncCompute :: PS FPU1 Pipe Active */
#define sklgt3__async_compute__ps_fpu1_active__read \
   bdw__render_basic__vs_send_active__read

/* AsyncCompute :: CS FPU1 Pipe Active */
#define sklgt3__async_compute__cs_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* AsyncCompute :: EU Thread Occupancy */
#define sklgt3__async_compute__eu_thread_occupancy__read \
   sklgt2__ff_bottlenecks__eu_thread_occupancy__read

/* AsyncCompute :: EU Active */
#define sklgt3__async_compute__eu_active__read \
   bdw__render_basic__eu_active__read

/* AsyncCompute :: EU Stall */
#define sklgt3__async_compute__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: GPU Time Elapsed */
#define sklgt4__render_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics Basic set :: GPU Core Clocks */
#define sklgt4__render_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt4__render_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt4__render_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics Basic set :: VS Threads Dispatched */
#define sklgt4__render_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics Basic set :: HS Threads Dispatched */
#define sklgt4__render_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics Basic set :: DS Threads Dispatched */
#define sklgt4__render_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics Basic set :: GS Threads Dispatched */
#define sklgt4__render_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics Basic set :: FS Threads Dispatched */
#define sklgt4__render_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics Basic set :: CS Threads Dispatched */
#define sklgt4__render_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics Basic set :: GPU Busy */
#define sklgt4__render_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics Basic set :: EU Active */
#define sklgt4__render_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics Basic set :: EU Stall */
#define sklgt4__render_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
#define sklgt4__render_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
#define sklgt4__render_basic__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
#define sklgt4__render_basic__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Render Metrics Basic set :: VS Send Pipe Active */
#define sklgt4__render_basic__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
#define sklgt4__render_basic__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
#define sklgt4__render_basic__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Render Metrics Basic set :: PS Send Pipeline Active */
#define sklgt4__render_basic__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Render Metrics Basic set :: FS Both FPU Active */
#define sklgt4__render_basic__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Render Metrics Basic set :: Sampler 0 Busy */
#define sklgt4__render_basic__sampler0_busy__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics Basic set :: Sampler 1 Busy */
#define sklgt4__render_basic__sampler1_busy__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics Basic set :: Samplers Busy */
#define sklgt4__render_basic__samplers_busy__read \
   bdw__render_basic__samplers_busy__read

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
#define sklgt4__render_basic__sampler0_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics Basic set :: Rasterized Pixels */
#define sklgt4__render_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
#define sklgt4__render_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics Basic set :: Early Depth Test Fails */
#define sklgt4__render_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: Samples Killed in FS */
#define sklgt4__render_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics Basic set :: Pixels Failing Tests */
#define sklgt4__render_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics Basic set :: Samples Written */
#define sklgt4__render_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics Basic set :: Samples Blended */
#define sklgt4__render_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics Basic set :: Sampler Texels */
#define sklgt4__render_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics Basic set :: Sampler Texels Misses */
#define sklgt4__render_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics Basic set :: Sampler Cache Misses */
static uint64_t
sklgt4__render_basic__sampler_l1_misses__read(UNUSED struct intel_perf_config *perf,
                                              const struct intel_perf_query_info *query,
                                              const struct intel_perf_query_result *results)
{
   /* RPN equation: B 4 READ B 5 READ UADD B 3 READ UADD 8 UMUL */
   uint64_t tmp0 = results->accumulator[query->b_offset + 4];
   uint64_t tmp1 = results->accumulator[query->b_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = results->accumulator[query->b_offset + 3];
   uint64_t tmp4 = tmp2 + tmp3;
   uint64_t tmp5 = tmp4 * 8;

   return tmp5;
}

/* Render Metrics Basic set :: SLM Bytes Read */
#define sklgt4__render_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics Basic set :: SLM Bytes Written */
#define sklgt4__render_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics Basic set :: Shader Memory Accesses */
#define sklgt4__render_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
#define sklgt4__render_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
static uint64_t
sklgt4__render_basic__l3_lookups__read(UNUSED struct intel_perf_config *perf,
                                       const struct intel_perf_query_info *query,
                                       const struct intel_perf_query_result *results)
{
   /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
   uint64_t tmp0 = sklgt4__render_basic__sampler_l1_misses__read(perf, query, results) + sklgt4__render_basic__shader_memory_accesses__read(perf, query, results);

   return tmp0;
}

/* Render Metrics Basic set :: L3 Misses */
#define sklgt4__render_basic__l3_misses__read \
   hsw__compute_extended__typed_atomics0__read

/* Render Metrics Basic set :: L3 Sampler Throughput */
static uint64_t
sklgt4__render_basic__l3_sampler_throughput__read(UNUSED struct intel_perf_config *perf,
                                                  const struct intel_perf_query_info *query,
                                                  const struct intel_perf_query_result *results)
{
   /* RPN equation: $SamplerL1Misses 64 UMUL */
   uint64_t tmp0 = sklgt4__render_basic__sampler_l1_misses__read(perf, query, results) * 64;

   return tmp0;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
#define sklgt4__render_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics Basic set :: Shader Barrier Messages */
#define sklgt4__render_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
#define sklgt4__render_basic__gti_vf_throughput__read \
   bdw__render_basic__gti_vf_throughput__read

/* Render Metrics Basic set :: GTI Depth Throughput */
#define sklgt4__render_basic__gti_depth_throughput__read \
   bdw__render_basic__gti_depth_throughput__read

/* Render Metrics Basic set :: GTI RCC Throughput */
#define sklgt4__render_basic__gti_rcc_throughput__read \
   bdw__render_basic__gti_rcc_throughput__read

/* Render Metrics Basic set :: GTI L3 Throughput */
#define sklgt4__render_basic__gti_l3_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Render Metrics Basic set :: GTI HDC TLB Lookup Throughput */
#define sklgt4__render_basic__gti_hdc_lookups_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics Basic set :: GTI Read Throughput */
#define sklgt4__render_basic__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Render Metrics Basic set :: GTI Write Throughput */
#define sklgt4__render_basic__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Render Metrics Basic set :: Samplers Bottleneck */
#define sklgt4__render_basic__sampler_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Compute Metrics Basic set :: GPU Time Elapsed */
#define sklgt4__compute_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Basic set :: GPU Core Clocks */
#define sklgt4__compute_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt4__compute_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define sklgt4__compute_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Basic set :: GPU Busy */
#define sklgt4__compute_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics Basic set :: VS Threads Dispatched */
#define sklgt4__compute_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: HS Threads Dispatched */
#define sklgt4__compute_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics Basic set :: DS Threads Dispatched */
#define sklgt4__compute_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics Basic set :: GS Threads Dispatched */
#define sklgt4__compute_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: FS Threads Dispatched */
#define sklgt4__compute_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics Basic set :: CS Threads Dispatched */
#define sklgt4__compute_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Basic set :: EU Active */
#define sklgt4__compute_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Basic set :: EU Stall */
#define sklgt4__compute_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Basic set :: EU Both FPU Pipes Active */
#define sklgt4__compute_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Basic set :: EU FPU0 Pipe Active */
#define sklgt4__compute_basic__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Basic set :: EU FPU1 Pipe Active */
#define sklgt4__compute_basic__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Basic set :: EU AVG IPC Rate */
#define sklgt4__compute_basic__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Basic set :: EU Send Pipe Active */
#define sklgt4__compute_basic__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Basic set :: EU Thread Occupancy */
#define sklgt4__compute_basic__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Basic set :: Rasterized Pixels */
#define sklgt4__compute_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics Basic set :: Early Hi-Depth Test Fails */
#define sklgt4__compute_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics Basic set :: Early Depth Test Fails */
#define sklgt4__compute_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Killed in FS */
#define sklgt4__compute_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics Basic set :: Pixels Failing Tests */
#define sklgt4__compute_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics Basic set :: Samples Written */
#define sklgt4__compute_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics Basic set :: Samples Blended */
#define sklgt4__compute_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics Basic set :: Sampler Texels */
#define sklgt4__compute_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Basic set :: Sampler Texels Misses */
#define sklgt4__compute_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Basic set :: SLM Bytes Read */
#define sklgt4__compute_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Basic set :: SLM Bytes Written */
#define sklgt4__compute_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Basic set :: Shader Memory Accesses */
#define sklgt4__compute_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Basic set :: Shader Atomic Memory Accesses */
#define sklgt4__compute_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Basic set :: L3 Shader Throughput */
#define sklgt4__compute_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Basic set :: Shader Barrier Messages */
#define sklgt4__compute_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Typed Bytes Read */
#define sklgt4__compute_basic__typed_bytes_read__read \
   bdw__compute_basic__typed_bytes_read__read

/* Compute Metrics Basic set :: Typed Bytes Written */
#define sklgt4__compute_basic__typed_bytes_written__read \
   bdw__compute_basic__typed_bytes_written__read

/* Compute Metrics Basic set :: Untyped Bytes Read */
#define sklgt4__compute_basic__untyped_bytes_read__read \
   bdw__compute_basic__untyped_bytes_read__read

/* Compute Metrics Basic set :: Untyped Writes */
#define sklgt4__compute_basic__untyped_bytes_written__read \
   bdw__compute_basic__untyped_bytes_written__read

/* Compute Metrics Basic set :: GTI Read Throughput */
#define sklgt4__compute_basic__gti_read_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Compute Metrics Basic set :: GTI Write Throughput */
#define sklgt4__compute_basic__gti_write_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Time Elapsed */
#define sklgt4__render_pipe_profile__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Core Clocks */
#define sklgt4__render_pipe_profile__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define sklgt4__render_pipe_profile__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define sklgt4__render_pipe_profile__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics set for 3D Pipeline Profile :: GPU Busy */
#define sklgt4__render_pipe_profile__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics set for 3D Pipeline Profile :: VS Threads Dispatched */
#define sklgt4__render_pipe_profile__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: HS Threads Dispatched */
#define sklgt4__render_pipe_profile__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: DS Threads Dispatched */
#define sklgt4__render_pipe_profile__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics set for 3D Pipeline Profile :: GS Threads Dispatched */
#define sklgt4__render_pipe_profile__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: FS Threads Dispatched */
#define sklgt4__render_pipe_profile__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics set for 3D Pipeline Profile :: CS Threads Dispatched */
#define sklgt4__render_pipe_profile__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: EU Active */
#define sklgt4__render_pipe_profile__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics set for 3D Pipeline Profile :: EU Stall */
#define sklgt4__render_pipe_profile__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics set for 3D Pipeline Profile :: Rasterized Pixels */
#define sklgt4__render_pipe_profile__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics set for 3D Pipeline Profile :: Early Hi-Depth Test Fails */
#define sklgt4__render_pipe_profile__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Test Fails */
#define sklgt4__render_pipe_profile__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Killed in FS */
#define sklgt4__render_pipe_profile__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics set for 3D Pipeline Profile :: Pixels Failing Tests */
#define sklgt4__render_pipe_profile__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Written */
#define sklgt4__render_pipe_profile__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Blended */
#define sklgt4__render_pipe_profile__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels */
#define sklgt4__render_pipe_profile__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels Misses */
#define sklgt4__render_pipe_profile__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Read */
#define sklgt4__render_pipe_profile__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Written */
#define sklgt4__render_pipe_profile__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Memory Accesses */
#define sklgt4__render_pipe_profile__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Atomic Memory Accesses */
#define sklgt4__render_pipe_profile__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics set for 3D Pipeline Profile :: L3 Shader Throughput */
#define sklgt4__render_pipe_profile__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Barrier Messages */
#define sklgt4__render_pipe_profile__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: VF Bottleneck */
#define sklgt4__render_pipe_profile__vf_bottleneck__read \
   bdw__render_pipe_profile__vf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: VS Bottleneck */
#define sklgt4__render_pipe_profile__vs_bottleneck__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics set for 3D Pipeline Profile :: HS Bottleneck */
#define sklgt4__render_pipe_profile__hs_bottleneck__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics set for 3D Pipeline Profile :: DS Bottleneck */
#define sklgt4__render_pipe_profile__ds_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: GS Bottleneck */
#define sklgt4__render_pipe_profile__gs_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: SO Bottleneck */
#define sklgt4__render_pipe_profile__so_bottleneck__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Clipper Bottleneck */
#define sklgt4__render_pipe_profile__cl_bottleneck__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Strip-Fans Bottleneck */
#define sklgt4__render_pipe_profile__sf_bottleneck__read \
   bdw__render_pipe_profile__sf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Hi-Depth Bottleneck */
#define sklgt4__render_pipe_profile__hi_depth_bottleneck__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Bottleneck */
#define sklgt4__render_pipe_profile__early_depth_bottleneck__read \
   bdw__render_pipe_profile__early_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: BC Bottleneck */
#define sklgt4__render_pipe_profile__bc_bottleneck__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: HS Stall */
#define sklgt4__render_pipe_profile__hs_stall__read \
   bdw__render_pipe_profile__hs_stall__read

/* Render Metrics set for 3D Pipeline Profile :: DS Stall */
#define sklgt4__render_pipe_profile__ds_stall__read \
   bdw__render_pipe_profile__ds_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SO Stall */
#define sklgt4__render_pipe_profile__so_stall__read \
   bdw__render_pipe_profile__so_stall__read

/* Render Metrics set for 3D Pipeline Profile :: CL Stall */
#define sklgt4__render_pipe_profile__cl_stall__read \
   bdw__render_pipe_profile__cl_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SF Stall */
#define sklgt4__render_pipe_profile__sf_stall__read \
   bdw__render_pipe_profile__sf_stall__read

/* Memory Reads Distribution metrics set :: GPU Time Elapsed */
#define sklgt4__memory_reads__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Reads Distribution metrics set :: GPU Core Clocks */
#define sklgt4__memory_reads__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt4__memory_reads__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt4__memory_reads__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Reads Distribution metrics set :: GPU Busy */
#define sklgt4__memory_reads__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Reads Distribution metrics set :: VS Threads Dispatched */
#define sklgt4__memory_reads__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: HS Threads Dispatched */
#define sklgt4__memory_reads__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Reads Distribution metrics set :: DS Threads Dispatched */
#define sklgt4__memory_reads__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Reads Distribution metrics set :: GS Threads Dispatched */
#define sklgt4__memory_reads__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: FS Threads Dispatched */
#define sklgt4__memory_reads__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Reads Distribution metrics set :: CS Threads Dispatched */
#define sklgt4__memory_reads__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Reads Distribution metrics set :: EU Active */
#define sklgt4__memory_reads__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Reads Distribution metrics set :: EU Stall */
#define sklgt4__memory_reads__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Reads Distribution metrics set :: Rasterized Pixels */
#define sklgt4__memory_reads__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Reads Distribution metrics set :: Early Hi-Depth Test Fails */
#define sklgt4__memory_reads__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Early Depth Test Fails */
#define sklgt4__memory_reads__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Samples Killed in FS */
#define sklgt4__memory_reads__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Reads Distribution metrics set :: Pixels Failing Tests */
#define sklgt4__memory_reads__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Reads Distribution metrics set :: Samples Written */
#define sklgt4__memory_reads__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Reads Distribution metrics set :: Samples Blended */
#define sklgt4__memory_reads__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Reads Distribution metrics set :: Sampler Texels */
#define sklgt4__memory_reads__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Reads Distribution metrics set :: Sampler Texels Misses */
#define sklgt4__memory_reads__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Reads Distribution metrics set :: SLM Bytes Read */
#define sklgt4__memory_reads__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Reads Distribution metrics set :: SLM Bytes Written */
#define sklgt4__memory_reads__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Reads Distribution metrics set :: Shader Memory Accesses */
#define sklgt4__memory_reads__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Reads Distribution metrics set :: Shader Atomic Memory Accesses */
#define sklgt4__memory_reads__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Reads Distribution metrics set :: Shader Barrier Messages */
#define sklgt4__memory_reads__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: GtiCmdStreamerMemoryReads */
#define sklgt4__memory_reads__gti_cmd_streamer_memory_reads__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Reads Distribution metrics set :: GtiRsMemoryReads */
#define sklgt4__memory_reads__gti_rs_memory_reads__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Reads Distribution metrics set :: GtiVfMemoryReads */
#define sklgt4__memory_reads__gti_vf_memory_reads__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Memory Reads Distribution metrics set :: GtiRccMemoryReads */
#define sklgt4__memory_reads__gti_rcc_memory_reads__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiMscMemoryReads */
#define sklgt4__memory_reads__gti_msc_memory_reads__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Reads Distribution metrics set :: GtiHizMemoryReads */
#define sklgt4__memory_reads__gti_hiz_memory_reads__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiStcMemoryReads */
#define sklgt4__memory_reads__gti_stc_memory_reads__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Reads Distribution metrics set :: GtiRczMemoryReads */
#define sklgt4__memory_reads__gti_rcz_memory_reads__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Reads Distribution metrics set :: GtiMemoryReads */
#define sklgt4__memory_reads__gti_memory_reads__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank0Reads */
#define sklgt4__memory_reads__gti_l3_bank0_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank1Reads */
#define sklgt4__memory_reads__gti_l3_bank1_reads__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Reads Distribution metrics set :: GtiL3Bank2Reads */
#define sklgt4__memory_reads__gti_l3_bank2_reads__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Reads Distribution metrics set :: GtiL3Bank3Reads */
#define sklgt4__memory_reads__gti_l3_bank3_reads__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: GtiL3Reads */
#define sklgt4__memory_reads__gti_l3_reads__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Reads Distribution metrics set :: GtiRingAccesses */
#define sklgt4__memory_reads__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Memory Writes Distribution metrics set :: GPU Time Elapsed */
#define sklgt4__memory_writes__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Writes Distribution metrics set :: GPU Core Clocks */
#define sklgt4__memory_writes__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt4__memory_writes__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define sklgt4__memory_writes__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Writes Distribution metrics set :: GPU Busy */
#define sklgt4__memory_writes__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Writes Distribution metrics set :: VS Threads Dispatched */
#define sklgt4__memory_writes__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: HS Threads Dispatched */
#define sklgt4__memory_writes__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Writes Distribution metrics set :: DS Threads Dispatched */
#define sklgt4__memory_writes__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Writes Distribution metrics set :: GS Threads Dispatched */
#define sklgt4__memory_writes__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: FS Threads Dispatched */
#define sklgt4__memory_writes__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Writes Distribution metrics set :: CS Threads Dispatched */
#define sklgt4__memory_writes__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Writes Distribution metrics set :: EU Active */
#define sklgt4__memory_writes__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Writes Distribution metrics set :: EU Stall */
#define sklgt4__memory_writes__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Writes Distribution metrics set :: Rasterized Pixels */
#define sklgt4__memory_writes__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Writes Distribution metrics set :: Early Hi-Depth Test Fails */
#define sklgt4__memory_writes__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Early Depth Test Fails */
#define sklgt4__memory_writes__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Samples Killed in FS */
#define sklgt4__memory_writes__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Writes Distribution metrics set :: Pixels Failing Tests */
#define sklgt4__memory_writes__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Writes Distribution metrics set :: Samples Written */
#define sklgt4__memory_writes__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Writes Distribution metrics set :: Samples Blended */
#define sklgt4__memory_writes__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Writes Distribution metrics set :: Sampler Texels */
#define sklgt4__memory_writes__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Writes Distribution metrics set :: Sampler Texels Misses */
#define sklgt4__memory_writes__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Writes Distribution metrics set :: SLM Bytes Read */
#define sklgt4__memory_writes__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Writes Distribution metrics set :: SLM Bytes Written */
#define sklgt4__memory_writes__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Writes Distribution metrics set :: Shader Memory Accesses */
#define sklgt4__memory_writes__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Writes Distribution metrics set :: Shader Atomic Memory Accesses */
#define sklgt4__memory_writes__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Writes Distribution metrics set :: L3 Shader Throughput */
#define sklgt4__memory_writes__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Memory Writes Distribution metrics set :: Shader Barrier Messages */
#define sklgt4__memory_writes__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: GtiCmdStreamerMemoryWrites */
#define sklgt4__memory_writes__gti_cmd_streamer_memory_writes__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Writes Distribution metrics set :: GtiSoMemoryWrites */
#define sklgt4__memory_writes__gti_so_memory_writes__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Writes Distribution metrics set :: GtiRccMemoryWrites */
#define sklgt4__memory_writes__gti_rcc_memory_writes__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiMscMemoryWrites */
#define sklgt4__memory_writes__gti_msc_memory_writes__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Writes Distribution metrics set :: GtiHizMemoryWrites */
#define sklgt4__memory_writes__gti_hiz_memory_writes__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiStcMemoryWrites */
#define sklgt4__memory_writes__gti_stc_memory_writes__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Writes Distribution metrics set :: GtiRczMemoryWrites */
#define sklgt4__memory_writes__gti_rcz_memory_writes__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Writes Distribution metrics set :: GtiMemoryWrites */
#define sklgt4__memory_writes__gti_memory_writes__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank0Writes */
#define sklgt4__memory_writes__gti_l3_bank0_writes__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank1Writes */
#define sklgt4__memory_writes__gti_l3_bank1_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Writes Distribution metrics set :: GtiL3Bank2Writes */
#define sklgt4__memory_writes__gti_l3_bank2_writes__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Writes Distribution metrics set :: GtiL3Bank3Writes */
#define sklgt4__memory_writes__gti_l3_bank3_writes__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: GtiL3Writes */
#define sklgt4__memory_writes__gti_l3_writes__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Writes Distribution metrics set :: GtiRingAccesses */
#define sklgt4__memory_writes__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Compute Metrics Extended set :: GPU Time Elapsed */
#define sklgt4__compute_extended__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extended set :: GPU Core Clocks */
#define sklgt4__compute_extended__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: AVG GPU Core Frequency */
#define sklgt4__compute_extended__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extended set :: AVG GPU Core Frequency */
#define sklgt4__compute_extended__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extended set :: CS Threads Dispatched */
#define sklgt4__compute_extended__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Extended set :: EU Active */
#define sklgt4__compute_extended__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Extended set :: EU Stall */
#define sklgt4__compute_extended__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extended set :: EU Both FPU Pipes Active */
#define sklgt4__compute_extended__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Extended set :: EU FPU0 Pipe Active */
#define sklgt4__compute_extended__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Extended set :: EU FPU1 Pipe Active */
#define sklgt4__compute_extended__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Extended set :: EU AVG IPC Rate */
#define sklgt4__compute_extended__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Extended set :: EU Send Pipe Active */
#define sklgt4__compute_extended__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Extended set :: EU Thread Occupancy */
#define sklgt4__compute_extended__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Extended set :: Sampler Texels */
#define sklgt4__compute_extended__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Extended set :: Sampler Texels Misses */
#define sklgt4__compute_extended__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Extended set :: SLM Bytes Read */
#define sklgt4__compute_extended__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Extended set :: SLM Bytes Written */
#define sklgt4__compute_extended__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Extended set :: Shader Memory Accesses */
#define sklgt4__compute_extended__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Extended set :: Shader Atomic Memory Accesses */
#define sklgt4__compute_extended__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Extended set :: L3 Shader Throughput */
#define sklgt4__compute_extended__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Extended set :: Shader Barrier Messages */
#define sklgt4__compute_extended__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Extended set :: EuUntypedReads0 */
#define sklgt4__compute_extended__eu_untyped_reads0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Compute Metrics Extended set :: EuTypedReads0 */
#define sklgt4__compute_extended__eu_typed_reads0__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Compute Metrics Extended set :: EuUntypedWrites0 */
#define sklgt4__compute_extended__eu_untyped_writes0__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Compute Metrics Extended set :: EuTypedWrites0 */
#define sklgt4__compute_extended__eu_typed_writes0__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Compute Metrics Extended set :: EuUntypedAtomics0 */
#define sklgt4__compute_extended__eu_untyped_atomics0__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Compute Metrics Extended set :: EuTypedAtomics0 */
#define sklgt4__compute_extended__eu_typed_atomics0__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Compute Metrics Extended set :: EuA64UntypedReads0 */
#define sklgt4__compute_extended__eu_a64_untyped_reads0__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Compute Metrics Extended set :: EuA64UntypedWrites0 */
#define sklgt4__compute_extended__eu_a64_untyped_writes0__read \
   hsw__compute_extended__gpu_clocks__read

/* Compute Metrics Extended set :: Typed Reads 0 */
#define sklgt4__compute_extended__typed_reads0__read \
   hsw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: Typed Writes 0 */
#define sklgt4__compute_extended__typed_writes0__read \
   hsw__compute_extended__typed_writes0__read

/* Compute Metrics Extended set :: Untyped Reads 0 */
#define sklgt4__compute_extended__untyped_reads0__read \
   hsw__compute_extended__untyped_reads0__read

/* Compute Metrics Extended set :: Untyped Writes 0 */
#define sklgt4__compute_extended__untyped_writes0__read \
   hsw__compute_extended__untyped_writes0__read

/* Compute Metrics Extended set :: Typed Atomics 0 */
#define sklgt4__compute_extended__typed_atomics0__read \
   hsw__compute_extended__typed_atomics0__read

/* Compute Metrics Extended set :: TypedReadsPerCacheLine */
#define sklgt4__compute_extended__typed_reads_per_cache_line__read \
   hsw__compute_extended__typed_reads_per_cache_line__read

/* Compute Metrics Extended set :: TypedWritesPerCacheLine */
#define sklgt4__compute_extended__typed_writes_per_cache_line__read \
   hsw__compute_extended__typed_writes_per_cache_line__read

/* Compute Metrics Extended set :: UntypedReadsPerCacheLine */
#define sklgt4__compute_extended__untyped_reads_per_cache_line__read \
   bdw__compute_extended__untyped_reads_per_cache_line__read

/* Compute Metrics Extended set :: UntypedWritesPerCacheLine */
#define sklgt4__compute_extended__untyped_writes_per_cache_line__read \
   bdw__compute_extended__untyped_writes_per_cache_line__read

/* Compute Metrics Extended set :: TypedAtomicsPerCacheLine */
#define sklgt4__compute_extended__typed_atomics_per_cache_line__read \
   hsw__compute_extended__typed_atomics_per_cache_line__read

/* Compute Metrics L3 Cache set :: GPU Time Elapsed */
#define sklgt4__compute_l3_cache__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics L3 Cache set :: GPU Core Clocks */
#define sklgt4__compute_l3_cache__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics L3 Cache set :: AVG GPU Core Frequency */
#define sklgt4__compute_l3_cache__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics L3 Cache set :: AVG GPU Core Frequency */
#define sklgt4__compute_l3_cache__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics L3 Cache set :: GPU Busy */
#define sklgt4__compute_l3_cache__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics L3 Cache set :: VS Threads Dispatched */
#define sklgt4__compute_l3_cache__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache set :: HS Threads Dispatched */
#define sklgt4__compute_l3_cache__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics L3 Cache set :: DS Threads Dispatched */
#define sklgt4__compute_l3_cache__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics L3 Cache set :: GS Threads Dispatched */
#define sklgt4__compute_l3_cache__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache set :: FS Threads Dispatched */
#define sklgt4__compute_l3_cache__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics L3 Cache set :: CS Threads Dispatched */
#define sklgt4__compute_l3_cache__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics L3 Cache set :: EU Active */
#define sklgt4__compute_l3_cache__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics L3 Cache set :: EU Stall */
#define sklgt4__compute_l3_cache__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics L3 Cache set :: EU Both FPU Pipes Active */
#define sklgt4__compute_l3_cache__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Pipe Active */
#define sklgt4__compute_l3_cache__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Pipe Active */
#define sklgt4__compute_l3_cache__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics L3 Cache set :: EU AVG IPC Rate */
#define sklgt4__compute_l3_cache__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics L3 Cache set :: EU Send Pipe Active */
#define sklgt4__compute_l3_cache__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Hybrid Instruction */
#define sklgt4__compute_l3_cache__eu_hybrid_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU1 Hybrid Instruction */
#define sklgt4__compute_l3_cache__eu_hybrid_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU0 Ternary Instruction */
#define sklgt4__compute_l3_cache__eu_ternary_fpu0_instruction__read \
   bdw__render_basic__ps_fpu0_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Ternary Instruction */
#define sklgt4__compute_l3_cache__eu_ternary_fpu1_instruction__read \
   bdw__render_basic__ps_fpu1_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Binary Instruction */
#define sklgt4__compute_l3_cache__eu_binary_fpu0_instruction__read \
   bdw__render_basic__ps_send_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Binary Instruction */
#define sklgt4__compute_l3_cache__eu_binary_fpu1_instruction__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Move Instruction */
#define sklgt4__compute_l3_cache__eu_move_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu0_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU1 Move Instruction */
#define sklgt4__compute_l3_cache__eu_move_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu1_instruction__read

/* Compute Metrics L3 Cache set :: Rasterized Pixels */
#define sklgt4__compute_l3_cache__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics L3 Cache set :: Early Hi-Depth Test Fails */
#define sklgt4__compute_l3_cache__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics L3 Cache set :: Early Depth Test Fails */
#define sklgt4__compute_l3_cache__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache set :: Samples Killed in FS */
#define sklgt4__compute_l3_cache__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics L3 Cache set :: Pixels Failing Tests */
#define sklgt4__compute_l3_cache__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics L3 Cache set :: Samples Written */
#define sklgt4__compute_l3_cache__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics L3 Cache set :: Samples Blended */
#define sklgt4__compute_l3_cache__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics L3 Cache set :: Sampler Accesses */
#define sklgt4__compute_l3_cache__sampler_accesses__read \
   bdw__render_pipe_profile__sampler_accesses__read

/* Compute Metrics L3 Cache set :: Sampler Texels */
#define sklgt4__compute_l3_cache__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics L3 Cache set :: Sampler Texels Misses */
#define sklgt4__compute_l3_cache__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics L3 Cache set :: SLM Bytes Read */
#define sklgt4__compute_l3_cache__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics L3 Cache set :: SLM Bytes Written */
#define sklgt4__compute_l3_cache__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics L3 Cache set :: Shader Memory Accesses */
#define sklgt4__compute_l3_cache__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics L3 Cache set :: Shader Atomic Memory Accesses */
#define sklgt4__compute_l3_cache__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics L3 Cache set :: L3 Accesses */
#define sklgt4__compute_l3_cache__l3_accesses__read \
   sklgt2__compute_l3_cache__l3_accesses__read

/* Compute Metrics L3 Cache set :: L3 Misses */
#define sklgt4__compute_l3_cache__l3_misses__read \
   bdw__compute_l3_cache__l3_misses__read

/* Compute Metrics L3 Cache set :: L3 Sampler Throughput */
#define sklgt4__compute_l3_cache__l3_sampler_throughput__read \
   chv__render_basic__l3_sampler_throughput__read

/* Compute Metrics L3 Cache set :: L3 Shader Throughput */
#define sklgt4__compute_l3_cache__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics L3 Cache set :: L3 Total Throughput */
#define sklgt4__compute_l3_cache__l3_total_throughput__read \
   sklgt2__compute_l3_cache__l3_total_throughput__read

/* Compute Metrics L3 Cache set :: Shader Barrier Messages */
#define sklgt4__compute_l3_cache__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 Accesses */
#define sklgt4__compute_l3_cache__l3_bank00_accesses__read \
   bdw__compute_l3_cache__l3_bank00_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 01 Accesses */
#define sklgt4__compute_l3_cache__l3_bank01_accesses__read \
   bdw__compute_l3_cache__l3_bank01_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 02 Accesses */
#define sklgt4__compute_l3_cache__l3_bank02_accesses__read \
   bdw__compute_l3_cache__l3_bank02_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 03 Accesses */
#define sklgt4__compute_l3_cache__l3_bank03_accesses__read \
   bdw__compute_l3_cache__l3_bank03_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 IC Accesses */
#define sklgt4__compute_l3_cache__l3_bank00_ic_accesses__read \
   bdw__compute_l3_cache__l3_bank00_ic_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 IC Hits */
#define sklgt4__compute_l3_cache__l3_bank00_ic_hits__read \
   bdw__compute_l3_cache__l3_bank00_ic_hits__read

/* Compute Metrics L3 Cache set :: GTI L3 Throughput */
#define sklgt4__compute_l3_cache__gti_l3_throughput__read \
   bdw__compute_l3_cache__gti_l3_throughput__read

/* Compute Metrics L3 Cache set :: GTI Read Throughput */
#define sklgt4__compute_l3_cache__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Compute Metrics L3 Cache set :: GTI Write Throughput */
#define sklgt4__compute_l3_cache__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Metric set HDCAndSF :: GPU Time Elapsed */
#define sklgt4__hdc_and_sf__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set HDCAndSF :: GPU Core Clocks */
#define sklgt4__hdc_and_sf__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define sklgt4__hdc_and_sf__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define sklgt4__hdc_and_sf__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set HDCAndSF :: GPU Busy */
#define sklgt4__hdc_and_sf__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set HDCAndSF :: VS Threads Dispatched */
#define sklgt4__hdc_and_sf__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: HS Threads Dispatched */
#define sklgt4__hdc_and_sf__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set HDCAndSF :: DS Threads Dispatched */
#define sklgt4__hdc_and_sf__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set HDCAndSF :: GS Threads Dispatched */
#define sklgt4__hdc_and_sf__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: FS Threads Dispatched */
#define sklgt4__hdc_and_sf__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set HDCAndSF :: CS Threads Dispatched */
#define sklgt4__hdc_and_sf__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set HDCAndSF :: EU Active */
#define sklgt4__hdc_and_sf__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set HDCAndSF :: EU Stall */
#define sklgt4__hdc_and_sf__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
#define sklgt4__hdc_and_sf__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
#define sklgt4__hdc_and_sf__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
#define sklgt4__hdc_and_sf__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set HDCAndSF :: VS Send Pipe Active */
#define sklgt4__hdc_and_sf__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
#define sklgt4__hdc_and_sf__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
#define sklgt4__hdc_and_sf__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set HDCAndSF :: PS Send Pipeline Active */
#define sklgt4__hdc_and_sf__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set HDCAndSF :: FS Both FPU Active */
#define sklgt4__hdc_and_sf__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set HDCAndSF :: Rasterized Pixels */
#define sklgt4__hdc_and_sf__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
#define sklgt4__hdc_and_sf__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set HDCAndSF :: Early Depth Test Fails */
#define sklgt4__hdc_and_sf__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Samples Killed in FS */
#define sklgt4__hdc_and_sf__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set HDCAndSF :: Pixels Failing Tests */
#define sklgt4__hdc_and_sf__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set HDCAndSF :: Samples Written */
#define sklgt4__hdc_and_sf__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set HDCAndSF :: Samples Blended */
#define sklgt4__hdc_and_sf__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set HDCAndSF :: Sampler Texels */
#define sklgt4__hdc_and_sf__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set HDCAndSF :: Sampler Texels Misses */
#define sklgt4__hdc_and_sf__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set HDCAndSF :: SLM Bytes Read */
#define sklgt4__hdc_and_sf__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set HDCAndSF :: SLM Bytes Written */
#define sklgt4__hdc_and_sf__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set HDCAndSF :: Shader Memory Accesses */
#define sklgt4__hdc_and_sf__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
#define sklgt4__hdc_and_sf__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set HDCAndSF :: L3 Shader Throughput */
#define sklgt4__hdc_and_sf__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set HDCAndSF :: Shader Barrier Messages */
#define sklgt4__hdc_and_sf__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Polygon Data Ready */
#define sklgt4__hdc_and_sf__poly_data_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
#define sklgt4__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
#define sklgt4__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
#define sklgt4__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read

/* Metric set HDCAndSF :: SQ is full */
#define sklgt4__hdc_and_sf__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_1 :: GPU Time Elapsed */
#define sklgt4__l3_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_1 :: GPU Core Clocks */
#define sklgt4__l3_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define sklgt4__l3_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define sklgt4__l3_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_1 :: GPU Busy */
#define sklgt4__l3_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_1 :: VS Threads Dispatched */
#define sklgt4__l3_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_1 :: HS Threads Dispatched */
#define sklgt4__l3_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_1 :: DS Threads Dispatched */
#define sklgt4__l3_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_1 :: GS Threads Dispatched */
#define sklgt4__l3_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_1 :: FS Threads Dispatched */
#define sklgt4__l3_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_1 :: CS Threads Dispatched */
#define sklgt4__l3_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_1 :: EU Active */
#define sklgt4__l3_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_1 :: EU Stall */
#define sklgt4__l3_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_1 :: EU Both FPU Pipes Active */
#define sklgt4__l3_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_1 :: VS FPU0 Pipe Active */
#define sklgt4__l3_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_1 :: VS FPU1 Pipe Active */
#define sklgt4__l3_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_1 :: VS Send Pipe Active */
#define sklgt4__l3_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_1 :: PS FPU0 Pipe Active */
#define sklgt4__l3_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_1 :: PS FPU1 Pipe Active */
#define sklgt4__l3_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_1 :: PS Send Pipeline Active */
#define sklgt4__l3_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_1 :: FS Both FPU Active */
#define sklgt4__l3_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_1 :: Rasterized Pixels */
#define sklgt4__l3_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
#define sklgt4__l3_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_1 :: Early Depth Test Fails */
#define sklgt4__l3_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Samples Killed in FS */
#define sklgt4__l3_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_1 :: Pixels Failing Tests */
#define sklgt4__l3_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_1 :: Samples Written */
#define sklgt4__l3_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_1 :: Samples Blended */
#define sklgt4__l3_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_1 :: Sampler Texels */
#define sklgt4__l3_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_1 :: Sampler Texels Misses */
#define sklgt4__l3_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_1 :: SLM Bytes Read */
#define sklgt4__l3_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_1 :: SLM Bytes Written */
#define sklgt4__l3_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_1 :: Shader Memory Accesses */
#define sklgt4__l3_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
#define sklgt4__l3_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_1 :: L3 Shader Throughput */
#define sklgt4__l3_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_1 :: Shader Barrier Messages */
#define sklgt4__l3_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Stalled */
#define sklgt4__l3_1__l30_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Stalled */
#define sklgt4__l3_1__l30_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Active */
#define sklgt4__l3_1__l30_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Active */
#define sklgt4__l3_1__l30_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_1 :: SQ is full */
#define sklgt4__l3_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_2 :: GPU Time Elapsed */
#define sklgt4__l3_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_2 :: GPU Core Clocks */
#define sklgt4__l3_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define sklgt4__l3_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define sklgt4__l3_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_2 :: GPU Busy */
#define sklgt4__l3_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_2 :: VS Threads Dispatched */
#define sklgt4__l3_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_2 :: HS Threads Dispatched */
#define sklgt4__l3_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_2 :: DS Threads Dispatched */
#define sklgt4__l3_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_2 :: GS Threads Dispatched */
#define sklgt4__l3_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_2 :: FS Threads Dispatched */
#define sklgt4__l3_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_2 :: CS Threads Dispatched */
#define sklgt4__l3_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_2 :: EU Active */
#define sklgt4__l3_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_2 :: EU Stall */
#define sklgt4__l3_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_2 :: EU Both FPU Pipes Active */
#define sklgt4__l3_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_2 :: VS FPU0 Pipe Active */
#define sklgt4__l3_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_2 :: VS FPU1 Pipe Active */
#define sklgt4__l3_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_2 :: VS Send Pipe Active */
#define sklgt4__l3_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_2 :: PS FPU0 Pipe Active */
#define sklgt4__l3_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_2 :: PS FPU1 Pipe Active */
#define sklgt4__l3_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_2 :: PS Send Pipeline Active */
#define sklgt4__l3_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_2 :: FS Both FPU Active */
#define sklgt4__l3_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_2 :: Rasterized Pixels */
#define sklgt4__l3_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
#define sklgt4__l3_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_2 :: Early Depth Test Fails */
#define sklgt4__l3_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Samples Killed in FS */
#define sklgt4__l3_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_2 :: Pixels Failing Tests */
#define sklgt4__l3_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_2 :: Samples Written */
#define sklgt4__l3_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_2 :: Samples Blended */
#define sklgt4__l3_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_2 :: Sampler Texels */
#define sklgt4__l3_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_2 :: Sampler Texels Misses */
#define sklgt4__l3_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_2 :: SLM Bytes Read */
#define sklgt4__l3_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_2 :: SLM Bytes Written */
#define sklgt4__l3_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_2 :: Shader Memory Accesses */
#define sklgt4__l3_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
#define sklgt4__l3_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_2 :: L3 Shader Throughput */
#define sklgt4__l3_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_2 :: Shader Barrier Messages */
#define sklgt4__l3_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Stalled */
#define sklgt4__l3_2__l30_bank2_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Active */
#define sklgt4__l3_2__l30_bank2_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_2 :: SQ is full */
#define sklgt4__l3_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_3 :: GPU Time Elapsed */
#define sklgt4__l3_3__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_3 :: GPU Core Clocks */
#define sklgt4__l3_3__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define sklgt4__l3_3__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define sklgt4__l3_3__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_3 :: GPU Busy */
#define sklgt4__l3_3__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_3 :: VS Threads Dispatched */
#define sklgt4__l3_3__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_3 :: HS Threads Dispatched */
#define sklgt4__l3_3__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_3 :: DS Threads Dispatched */
#define sklgt4__l3_3__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_3 :: GS Threads Dispatched */
#define sklgt4__l3_3__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_3 :: FS Threads Dispatched */
#define sklgt4__l3_3__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_3 :: CS Threads Dispatched */
#define sklgt4__l3_3__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_3 :: EU Active */
#define sklgt4__l3_3__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_3 :: EU Stall */
#define sklgt4__l3_3__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_3 :: EU Both FPU Pipes Active */
#define sklgt4__l3_3__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_3 :: VS FPU0 Pipe Active */
#define sklgt4__l3_3__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_3 :: VS FPU1 Pipe Active */
#define sklgt4__l3_3__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_3 :: VS Send Pipe Active */
#define sklgt4__l3_3__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_3 :: PS FPU0 Pipe Active */
#define sklgt4__l3_3__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_3 :: PS FPU1 Pipe Active */
#define sklgt4__l3_3__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_3 :: PS Send Pipeline Active */
#define sklgt4__l3_3__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_3 :: FS Both FPU Active */
#define sklgt4__l3_3__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_3 :: Rasterized Pixels */
#define sklgt4__l3_3__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
#define sklgt4__l3_3__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_3 :: Early Depth Test Fails */
#define sklgt4__l3_3__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Samples Killed in FS */
#define sklgt4__l3_3__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_3 :: Pixels Failing Tests */
#define sklgt4__l3_3__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_3 :: Samples Written */
#define sklgt4__l3_3__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_3 :: Samples Blended */
#define sklgt4__l3_3__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_3 :: Sampler Texels */
#define sklgt4__l3_3__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_3 :: Sampler Texels Misses */
#define sklgt4__l3_3__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_3 :: SLM Bytes Read */
#define sklgt4__l3_3__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_3 :: SLM Bytes Written */
#define sklgt4__l3_3__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_3 :: Shader Memory Accesses */
#define sklgt4__l3_3__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
#define sklgt4__l3_3__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_3 :: L3 Shader Throughput */
#define sklgt4__l3_3__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_3 :: Shader Barrier Messages */
#define sklgt4__l3_3__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
#define sklgt4__l3_3__l30_bank3_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
#define sklgt4__l3_3__l30_bank3_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_3 :: SQ is full */
#define sklgt4__l3_3__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
#define sklgt4__rasterizer_and_pixel_backend__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
#define sklgt4__rasterizer_and_pixel_backend__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define sklgt4__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define sklgt4__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
#define sklgt4__rasterizer_and_pixel_backend__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
#define sklgt4__rasterizer_and_pixel_backend__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
#define sklgt4__rasterizer_and_pixel_backend__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
#define sklgt4__rasterizer_and_pixel_backend__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
#define sklgt4__rasterizer_and_pixel_backend__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
#define sklgt4__rasterizer_and_pixel_backend__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
#define sklgt4__rasterizer_and_pixel_backend__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set RasterizerAndPixelBackend :: EU Active */
#define sklgt4__rasterizer_and_pixel_backend__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set RasterizerAndPixelBackend :: EU Stall */
#define sklgt4__rasterizer_and_pixel_backend__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
#define sklgt4__rasterizer_and_pixel_backend__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
#define sklgt4__rasterizer_and_pixel_backend__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
#define sklgt4__rasterizer_and_pixel_backend__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
#define sklgt4__rasterizer_and_pixel_backend__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
#define sklgt4__rasterizer_and_pixel_backend__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
#define sklgt4__rasterizer_and_pixel_backend__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
#define sklgt4__rasterizer_and_pixel_backend__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
#define sklgt4__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
#define sklgt4__rasterizer_and_pixel_backend__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
#define sklgt4__rasterizer_and_pixel_backend__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
#define sklgt4__rasterizer_and_pixel_backend__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
#define sklgt4__rasterizer_and_pixel_backend__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
#define sklgt4__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set RasterizerAndPixelBackend :: Samples Written */
#define sklgt4__rasterizer_and_pixel_backend__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
#define sklgt4__rasterizer_and_pixel_backend__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
#define sklgt4__rasterizer_and_pixel_backend__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
#define sklgt4__rasterizer_and_pixel_backend__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
#define sklgt4__rasterizer_and_pixel_backend__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
#define sklgt4__rasterizer_and_pixel_backend__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
#define sklgt4__rasterizer_and_pixel_backend__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
#define sklgt4__rasterizer_and_pixel_backend__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
#define sklgt4__rasterizer_and_pixel_backend__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
#define sklgt4__rasterizer_and_pixel_backend__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
#define sklgt4__rasterizer_and_pixel_backend__pixel_data0_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
#define sklgt4__rasterizer_and_pixel_backend__rasterizer0_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
#define sklgt4__rasterizer_and_pixel_backend__ps_output0_available__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
#define sklgt4__rasterizer_and_pixel_backend__pixel_values0_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
#define sklgt4__rasterizer_and_pixel_backend__rasterizer0_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set RasterizerAndPixelBackend :: SQ is full */
#define sklgt4__rasterizer_and_pixel_backend__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler :: GPU Time Elapsed */
#define sklgt4__sampler__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler :: GPU Core Clocks */
#define sklgt4__sampler__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define sklgt4__sampler__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define sklgt4__sampler__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler :: GPU Busy */
#define sklgt4__sampler__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler :: VS Threads Dispatched */
#define sklgt4__sampler__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler :: HS Threads Dispatched */
#define sklgt4__sampler__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler :: DS Threads Dispatched */
#define sklgt4__sampler__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler :: GS Threads Dispatched */
#define sklgt4__sampler__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler :: FS Threads Dispatched */
#define sklgt4__sampler__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler :: CS Threads Dispatched */
#define sklgt4__sampler__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler :: EU Active */
#define sklgt4__sampler__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler :: EU Stall */
#define sklgt4__sampler__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler :: EU Both FPU Pipes Active */
#define sklgt4__sampler__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler :: VS FPU0 Pipe Active */
#define sklgt4__sampler__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler :: VS FPU1 Pipe Active */
#define sklgt4__sampler__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler :: VS Send Pipe Active */
#define sklgt4__sampler__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler :: PS FPU0 Pipe Active */
#define sklgt4__sampler__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler :: PS FPU1 Pipe Active */
#define sklgt4__sampler__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler :: PS Send Pipeline Active */
#define sklgt4__sampler__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler :: FS Both FPU Active */
#define sklgt4__sampler__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler :: Rasterized Pixels */
#define sklgt4__sampler__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler :: Early Hi-Depth Test Fails */
#define sklgt4__sampler__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler :: Early Depth Test Fails */
#define sklgt4__sampler__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Samples Killed in FS */
#define sklgt4__sampler__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler :: Pixels Failing Tests */
#define sklgt4__sampler__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler :: Samples Written */
#define sklgt4__sampler__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler :: Samples Blended */
#define sklgt4__sampler__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler :: Sampler Texels */
#define sklgt4__sampler__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler :: Sampler Texels Misses */
#define sklgt4__sampler__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler :: SLM Bytes Read */
#define sklgt4__sampler__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler :: SLM Bytes Written */
#define sklgt4__sampler__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler :: Shader Memory Accesses */
#define sklgt4__sampler__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler :: Shader Atomic Memory Accesses */
#define sklgt4__sampler__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler :: L3 Shader Throughput */
#define sklgt4__sampler__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler :: Shader Barrier Messages */
#define sklgt4__sampler__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Slice0 Subslice1 Input Available */
#define sklgt4__sampler__sampler01_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler :: Slice0 Subslice2 Input Available */
#define sklgt4__sampler__sampler02_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler :: Slice0 Subslice0 Input Available */
#define sklgt4__sampler__sampler00_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice2 Sampler Output Ready */
#define sklgt4__sampler__sampler02_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice0 Sampler Output Ready */
#define sklgt4__sampler__sampler00_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice1 Sampler Output Ready */
#define sklgt4__sampler__sampler01_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler :: SQ is full */
#define sklgt4__sampler__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_1 :: GPU Time Elapsed */
#define sklgt4__tdl_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_1 :: GPU Core Clocks */
#define sklgt4__tdl_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define sklgt4__tdl_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define sklgt4__tdl_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_1 :: GPU Busy */
#define sklgt4__tdl_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_1 :: VS Threads Dispatched */
#define sklgt4__tdl_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_1 :: HS Threads Dispatched */
#define sklgt4__tdl_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_1 :: DS Threads Dispatched */
#define sklgt4__tdl_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_1 :: GS Threads Dispatched */
#define sklgt4__tdl_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_1 :: FS Threads Dispatched */
#define sklgt4__tdl_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_1 :: CS Threads Dispatched */
#define sklgt4__tdl_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_1 :: EU Active */
#define sklgt4__tdl_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_1 :: EU Stall */
#define sklgt4__tdl_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
#define sklgt4__tdl_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
#define sklgt4__tdl_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
#define sklgt4__tdl_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_1 :: VS Send Pipe Active */
#define sklgt4__tdl_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
#define sklgt4__tdl_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
#define sklgt4__tdl_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_1 :: PS Send Pipeline Active */
#define sklgt4__tdl_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_1 :: FS Both FPU Active */
#define sklgt4__tdl_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_1 :: Rasterized Pixels */
#define sklgt4__tdl_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
#define sklgt4__tdl_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_1 :: Early Depth Test Fails */
#define sklgt4__tdl_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: Samples Killed in FS */
#define sklgt4__tdl_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_1 :: Pixels Failing Tests */
#define sklgt4__tdl_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_1 :: Samples Written */
#define sklgt4__tdl_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_1 :: Samples Blended */
#define sklgt4__tdl_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_1 :: Sampler Texels */
#define sklgt4__tdl_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_1 :: Sampler Texels Misses */
#define sklgt4__tdl_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_1 :: SLM Bytes Read */
#define sklgt4__tdl_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_1 :: SLM Bytes Written */
#define sklgt4__tdl_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_1 :: Shader Memory Accesses */
#define sklgt4__tdl_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
#define sklgt4__tdl_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_1 :: L3 Shader Throughput */
#define sklgt4__tdl_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_1 :: Shader Barrier Messages */
#define sklgt4__tdl_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
#define sklgt4__tdl_1__non_ps_thread01_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice0 */
#define sklgt4__tdl_1__ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
#define sklgt4__tdl_1__non_ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice2 */
#define sklgt4__tdl_1__ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
#define sklgt4__tdl_1__non_ps_thread02_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice1 */
#define sklgt4__tdl_1__ps_thread01_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_1 :: SQ is full */
#define sklgt4__tdl_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_2 :: GPU Time Elapsed */
#define sklgt4__tdl_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_2 :: GPU Core Clocks */
#define sklgt4__tdl_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define sklgt4__tdl_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define sklgt4__tdl_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_2 :: GPU Busy */
#define sklgt4__tdl_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_2 :: VS Threads Dispatched */
#define sklgt4__tdl_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_2 :: HS Threads Dispatched */
#define sklgt4__tdl_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_2 :: DS Threads Dispatched */
#define sklgt4__tdl_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_2 :: GS Threads Dispatched */
#define sklgt4__tdl_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_2 :: FS Threads Dispatched */
#define sklgt4__tdl_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_2 :: CS Threads Dispatched */
#define sklgt4__tdl_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_2 :: EU Active */
#define sklgt4__tdl_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_2 :: EU Stall */
#define sklgt4__tdl_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
#define sklgt4__tdl_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
#define sklgt4__tdl_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
#define sklgt4__tdl_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_2 :: VS Send Pipe Active */
#define sklgt4__tdl_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
#define sklgt4__tdl_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
#define sklgt4__tdl_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_2 :: PS Send Pipeline Active */
#define sklgt4__tdl_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_2 :: FS Both FPU Active */
#define sklgt4__tdl_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_2 :: Rasterized Pixels */
#define sklgt4__tdl_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
#define sklgt4__tdl_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_2 :: Early Depth Test Fails */
#define sklgt4__tdl_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Samples Killed in FS */
#define sklgt4__tdl_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_2 :: Pixels Failing Tests */
#define sklgt4__tdl_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_2 :: Samples Written */
#define sklgt4__tdl_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_2 :: Samples Blended */
#define sklgt4__tdl_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_2 :: Sampler Texels */
#define sklgt4__tdl_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_2 :: Sampler Texels Misses */
#define sklgt4__tdl_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_2 :: SLM Bytes Read */
#define sklgt4__tdl_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_2 :: SLM Bytes Written */
#define sklgt4__tdl_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_2 :: Shader Memory Accesses */
#define sklgt4__tdl_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
#define sklgt4__tdl_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_2 :: L3 Shader Throughput */
#define sklgt4__tdl_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_2 :: Shader Barrier Messages */
#define sklgt4__tdl_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 0 */
#define sklgt4__tdl_2__thread_header01_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 1 */
#define sklgt4__tdl_2__thread_header00_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 0 */
#define sklgt4__tdl_2__thread_header00_ready_port0__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 1 */
#define sklgt4__tdl_2__thread_header02_ready_port1__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 0 */
#define sklgt4__tdl_2__thread_header02_ready_port0__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 1 */
#define sklgt4__tdl_2__thread_header01_ready_port1__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_2 :: SQ is full */
#define sklgt4__tdl_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Compute Metrics Extra set :: GPU Time Elapsed */
#define sklgt4__compute_extra__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extra set :: GPU Core Clocks */
#define sklgt4__compute_extra__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define sklgt4__compute_extra__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define sklgt4__compute_extra__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extra set :: EU FPU1 Pipe Active */
#define sklgt4__compute_extra__fpu1_active__read \
   bdw__render_basic__eu_stall__read

/* Media Vme Pipe metrics set :: GPU Time Elapsed */
#define sklgt4__vme_pipe__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Media Vme Pipe metrics set :: GPU Core Clocks */
#define sklgt4__vme_pipe__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define sklgt4__vme_pipe__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define sklgt4__vme_pipe__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Media Vme Pipe metrics set :: GPU Busy */
#define sklgt4__vme_pipe__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Media Vme Pipe metrics set :: CS Threads Dispatched */
#define sklgt4__vme_pipe__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Media Vme Pipe metrics set :: EU Active */
#define sklgt4__vme_pipe__eu_active__read \
   bdw__render_basic__eu_active__read

/* Media Vme Pipe metrics set :: EU Stall */
#define sklgt4__vme_pipe__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Media Vme Pipe metrics set :: EU Both FPU Pipes Active */
#define sklgt4__vme_pipe__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Media Vme Pipe metrics set :: EU Thread Occupancy */
#define sklgt4__vme_pipe__eu_thread_occupancy__read \
   bdw__vme_pipe__eu_thread_occupancy__read

/* Media Vme Pipe metrics set :: VME Busy */
#define sklgt4__vme_pipe__vme_busy__read \
   bdw__vme_pipe__vme_busy__read

/* Gpu Rings Busyness :: GPU Time Elapsed */
#define sklgt4__gpu_busyness__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Gpu Rings Busyness :: GPU Core Clocks */
#define sklgt4__gpu_busyness__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define sklgt4__gpu_busyness__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define sklgt4__gpu_busyness__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Gpu Rings Busyness :: Render Ring Busy */
#define sklgt4__gpu_busyness__render_busy__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Gpu Rings Busyness :: Vdbox0 Ring Busy */
#define sklgt4__gpu_busyness__vdbox0_busy__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Gpu Rings Busyness :: Vdbox1 Ring Busy */
#define sklgt4__gpu_busyness__vdbox1_busy__read \
   bdw__render_pipe_profile__sf_stall__read

/* Gpu Rings Busyness :: Vebox Ring Busy */
#define sklgt4__gpu_busyness__vebox_busy__read \
   bdw__render_pipe_profile__cl_stall__read

/* Gpu Rings Busyness :: Blitter Ring Busy */
#define sklgt4__gpu_busyness__blitter_busy__read \
   bdw__render_pipe_profile__so_stall__read

/* Gpu Rings Busyness :: AnyRingBusy */
#define sklgt4__gpu_busyness__any_ring_busy__read \
   bdw__render_basic__sampler0_busy__read

/* MDAPI testing set :: GPU Time Elapsed */
#define sklgt4__test_oa__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* MDAPI testing set :: GPU Core Clocks */
#define sklgt4__test_oa__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define sklgt4__test_oa__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define sklgt4__test_oa__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* MDAPI testing set :: TestCounter0 */
#define sklgt4__test_oa__counter0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* MDAPI testing set :: TestCounter1 */
#define sklgt4__test_oa__counter1__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* MDAPI testing set :: TestCounter2 */
#define sklgt4__test_oa__counter2__read \
   hsw__compute_extended__eu_typed_reads0__read

/* MDAPI testing set :: TestCounter3 */
#define sklgt4__test_oa__counter3__read \
   hsw__compute_extended__eu_typed_writes0__read

/* MDAPI testing set :: TestCounter4 */
#define sklgt4__test_oa__counter4__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* MDAPI testing set :: TestCounter5 */
#define sklgt4__test_oa__counter5__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* MDAPI testing set :: TestCounter6 */
#define sklgt4__test_oa__counter6__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* MDAPI testing set :: TestCounter7 */
#define sklgt4__test_oa__counter7__read \
   hsw__compute_extended__gpu_clocks__read

/* MDAPI testing set :: TestCounter8 */
#define sklgt4__test_oa__counter8__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Metric set PMA Stall :: GPU Time Elapsed */
#define sklgt4__pma__stall__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set PMA Stall :: GPU Core Clocks */
#define sklgt4__pma__stall__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define sklgt4__pma__stall__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define sklgt4__pma__stall__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set PMA Stall :: STC PMA stall */
#define sklgt4__pma__stall__stc_pma_stall__read \
   sklgt2__pma__stall__stc_pma_stall__read

/* AsyncCompute :: GPU Time Elapsed */
#define sklgt4__async_compute__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* AsyncCompute :: GPU Core Clocks */
#define sklgt4__async_compute__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define sklgt4__async_compute__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define sklgt4__async_compute__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* AsyncCompute :: GPU Busy */
#define sklgt4__async_compute__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* AsyncCompute :: VS Threads Dispatched */
#define sklgt4__async_compute__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* AsyncCompute :: HS Threads Dispatched */
#define sklgt4__async_compute__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* AsyncCompute :: DS Threads Dispatched */
#define sklgt4__async_compute__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* AsyncCompute :: GS Threads Dispatched */
#define sklgt4__async_compute__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* AsyncCompute :: FS Threads Dispatched */
#define sklgt4__async_compute__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* AsyncCompute :: CS Threads Dispatched */
#define sklgt4__async_compute__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* AsyncCompute :: EU FPU0 Pipe Active */
#define sklgt4__async_compute__fpu0_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* AsyncCompute :: VS FPU0 Pipe Active */
#define sklgt4__async_compute__vs_fpu0_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* AsyncCompute :: PS FPU0 Pipe Active */
#define sklgt4__async_compute__ps_fpu0_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* AsyncCompute :: CS FPU0 Pipe Active */
#define sklgt4__async_compute__cs_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* AsyncCompute :: EU FPU1 Pipe Active */
#define sklgt4__async_compute__fpu1_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* AsyncCompute :: VS FPU1 Pipe Active */
#define sklgt4__async_compute__vs_fpu1_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* AsyncCompute :: PS FPU1 Pipe Active */
#define sklgt4__async_compute__ps_fpu1_active__read \
   bdw__render_basic__vs_send_active__read

/* AsyncCompute :: CS FPU1 Pipe Active */
#define sklgt4__async_compute__cs_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* AsyncCompute :: EU Thread Occupancy */
#define sklgt4__async_compute__eu_thread_occupancy__read \
   sklgt2__ff_bottlenecks__eu_thread_occupancy__read

/* AsyncCompute :: EU Active */
#define sklgt4__async_compute__eu_active__read \
   bdw__render_basic__eu_active__read

/* AsyncCompute :: EU Stall */
#define sklgt4__async_compute__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: GPU Time Elapsed */
#define kblgt2__render_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics Basic set :: GPU Core Clocks */
#define kblgt2__render_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define kblgt2__render_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define kblgt2__render_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics Basic set :: VS Threads Dispatched */
#define kblgt2__render_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics Basic set :: HS Threads Dispatched */
#define kblgt2__render_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics Basic set :: DS Threads Dispatched */
#define kblgt2__render_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics Basic set :: GS Threads Dispatched */
#define kblgt2__render_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics Basic set :: FS Threads Dispatched */
#define kblgt2__render_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics Basic set :: CS Threads Dispatched */
#define kblgt2__render_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics Basic set :: GPU Busy */
#define kblgt2__render_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics Basic set :: EU Active */
#define kblgt2__render_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics Basic set :: EU Stall */
#define kblgt2__render_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
#define kblgt2__render_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
#define kblgt2__render_basic__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
#define kblgt2__render_basic__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Render Metrics Basic set :: VS Send Pipe Active */
#define kblgt2__render_basic__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
#define kblgt2__render_basic__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
#define kblgt2__render_basic__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Render Metrics Basic set :: PS Send Pipeline Active */
#define kblgt2__render_basic__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Render Metrics Basic set :: FS Both FPU Active */
#define kblgt2__render_basic__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Render Metrics Basic set :: Sampler 0 Busy */
#define kblgt2__render_basic__sampler0_busy__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics Basic set :: Sampler 1 Busy */
#define kblgt2__render_basic__sampler1_busy__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics Basic set :: Samplers Busy */
#define kblgt2__render_basic__samplers_busy__read \
   bdw__render_basic__samplers_busy__read

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
#define kblgt2__render_basic__sampler0_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
#define kblgt2__render_basic__sampler1_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics Basic set :: Rasterized Pixels */
#define kblgt2__render_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
#define kblgt2__render_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics Basic set :: Early Depth Test Fails */
#define kblgt2__render_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: Samples Killed in FS */
#define kblgt2__render_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics Basic set :: Pixels Failing Tests */
#define kblgt2__render_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics Basic set :: Samples Written */
#define kblgt2__render_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics Basic set :: Samples Blended */
#define kblgt2__render_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics Basic set :: Sampler Texels */
#define kblgt2__render_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics Basic set :: Sampler Texels Misses */
#define kblgt2__render_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics Basic set :: Sampler Cache Misses */
#define kblgt2__render_basic__sampler_l1_misses__read \
   sklgt2__render_basic__sampler_l1_misses__read

/* Render Metrics Basic set :: SLM Bytes Read */
#define kblgt2__render_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics Basic set :: SLM Bytes Written */
#define kblgt2__render_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics Basic set :: Shader Memory Accesses */
#define kblgt2__render_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
#define kblgt2__render_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
#define kblgt2__render_basic__l3_lookups__read \
   sklgt2__render_basic__l3_lookups__read

/* Render Metrics Basic set :: L3 Misses */
#define kblgt2__render_basic__l3_misses__read \
   hsw__compute_extended__typed_atomics0__read

/* Render Metrics Basic set :: L3 Sampler Throughput */
#define kblgt2__render_basic__l3_sampler_throughput__read \
   sklgt2__render_basic__l3_sampler_throughput__read

/* Render Metrics Basic set :: L3 Shader Throughput */
#define kblgt2__render_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics Basic set :: Shader Barrier Messages */
#define kblgt2__render_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
#define kblgt2__render_basic__gti_vf_throughput__read \
   bdw__render_basic__gti_vf_throughput__read

/* Render Metrics Basic set :: GTI Depth Throughput */
#define kblgt2__render_basic__gti_depth_throughput__read \
   bdw__render_basic__gti_depth_throughput__read

/* Render Metrics Basic set :: GTI RCC Throughput */
#define kblgt2__render_basic__gti_rcc_throughput__read \
   bdw__render_basic__gti_rcc_throughput__read

/* Render Metrics Basic set :: GTI L3 Throughput */
#define kblgt2__render_basic__gti_l3_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Render Metrics Basic set :: GTI HDC TLB Lookup Throughput */
#define kblgt2__render_basic__gti_hdc_lookups_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics Basic set :: GTI Read Throughput */
#define kblgt2__render_basic__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Render Metrics Basic set :: GTI Write Throughput */
#define kblgt2__render_basic__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Render Metrics Basic set :: Samplers Bottleneck */
#define kblgt2__render_basic__sampler_bottleneck__read \
   bdw__render_basic__sampler_bottleneck__read

/* Compute Metrics Basic set :: GPU Time Elapsed */
#define kblgt2__compute_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Basic set :: GPU Core Clocks */
#define kblgt2__compute_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define kblgt2__compute_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define kblgt2__compute_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Basic set :: GPU Busy */
#define kblgt2__compute_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics Basic set :: VS Threads Dispatched */
#define kblgt2__compute_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: HS Threads Dispatched */
#define kblgt2__compute_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics Basic set :: DS Threads Dispatched */
#define kblgt2__compute_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics Basic set :: GS Threads Dispatched */
#define kblgt2__compute_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: FS Threads Dispatched */
#define kblgt2__compute_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics Basic set :: CS Threads Dispatched */
#define kblgt2__compute_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Basic set :: EU Active */
#define kblgt2__compute_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Basic set :: EU Stall */
#define kblgt2__compute_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Basic set :: EU Both FPU Pipes Active */
#define kblgt2__compute_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Basic set :: EU FPU0 Pipe Active */
#define kblgt2__compute_basic__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Basic set :: EU FPU1 Pipe Active */
#define kblgt2__compute_basic__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Basic set :: EU AVG IPC Rate */
#define kblgt2__compute_basic__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Basic set :: EU Send Pipe Active */
#define kblgt2__compute_basic__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Basic set :: EU Thread Occupancy */
#define kblgt2__compute_basic__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Basic set :: Rasterized Pixels */
#define kblgt2__compute_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics Basic set :: Early Hi-Depth Test Fails */
#define kblgt2__compute_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics Basic set :: Early Depth Test Fails */
#define kblgt2__compute_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Killed in FS */
#define kblgt2__compute_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics Basic set :: Pixels Failing Tests */
#define kblgt2__compute_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics Basic set :: Samples Written */
#define kblgt2__compute_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics Basic set :: Samples Blended */
#define kblgt2__compute_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics Basic set :: Sampler Texels */
#define kblgt2__compute_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Basic set :: Sampler Texels Misses */
#define kblgt2__compute_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Basic set :: SLM Bytes Read */
#define kblgt2__compute_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Basic set :: SLM Bytes Written */
#define kblgt2__compute_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Basic set :: Shader Memory Accesses */
#define kblgt2__compute_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Basic set :: Shader Atomic Memory Accesses */
#define kblgt2__compute_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Basic set :: L3 Shader Throughput */
#define kblgt2__compute_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Basic set :: Shader Barrier Messages */
#define kblgt2__compute_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Typed Bytes Read */
#define kblgt2__compute_basic__typed_bytes_read__read \
   bdw__compute_basic__typed_bytes_read__read

/* Compute Metrics Basic set :: Typed Bytes Written */
#define kblgt2__compute_basic__typed_bytes_written__read \
   bdw__compute_basic__typed_bytes_written__read

/* Compute Metrics Basic set :: Untyped Bytes Read */
#define kblgt2__compute_basic__untyped_bytes_read__read \
   bdw__compute_basic__untyped_bytes_read__read

/* Compute Metrics Basic set :: Untyped Writes */
#define kblgt2__compute_basic__untyped_bytes_written__read \
   bdw__compute_basic__untyped_bytes_written__read

/* Compute Metrics Basic set :: GTI Read Throughput */
#define kblgt2__compute_basic__gti_read_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Compute Metrics Basic set :: GTI Write Throughput */
#define kblgt2__compute_basic__gti_write_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Time Elapsed */
#define kblgt2__render_pipe_profile__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Core Clocks */
#define kblgt2__render_pipe_profile__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define kblgt2__render_pipe_profile__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define kblgt2__render_pipe_profile__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics set for 3D Pipeline Profile :: GPU Busy */
#define kblgt2__render_pipe_profile__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics set for 3D Pipeline Profile :: VS Threads Dispatched */
#define kblgt2__render_pipe_profile__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: HS Threads Dispatched */
#define kblgt2__render_pipe_profile__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: DS Threads Dispatched */
#define kblgt2__render_pipe_profile__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics set for 3D Pipeline Profile :: GS Threads Dispatched */
#define kblgt2__render_pipe_profile__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: FS Threads Dispatched */
#define kblgt2__render_pipe_profile__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics set for 3D Pipeline Profile :: CS Threads Dispatched */
#define kblgt2__render_pipe_profile__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: EU Active */
#define kblgt2__render_pipe_profile__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics set for 3D Pipeline Profile :: EU Stall */
#define kblgt2__render_pipe_profile__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics set for 3D Pipeline Profile :: Rasterized Pixels */
#define kblgt2__render_pipe_profile__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics set for 3D Pipeline Profile :: Early Hi-Depth Test Fails */
#define kblgt2__render_pipe_profile__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Test Fails */
#define kblgt2__render_pipe_profile__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Killed in FS */
#define kblgt2__render_pipe_profile__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics set for 3D Pipeline Profile :: Pixels Failing Tests */
#define kblgt2__render_pipe_profile__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Written */
#define kblgt2__render_pipe_profile__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Blended */
#define kblgt2__render_pipe_profile__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels */
#define kblgt2__render_pipe_profile__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels Misses */
#define kblgt2__render_pipe_profile__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Read */
#define kblgt2__render_pipe_profile__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Written */
#define kblgt2__render_pipe_profile__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Memory Accesses */
#define kblgt2__render_pipe_profile__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Atomic Memory Accesses */
#define kblgt2__render_pipe_profile__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics set for 3D Pipeline Profile :: L3 Shader Throughput */
#define kblgt2__render_pipe_profile__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Barrier Messages */
#define kblgt2__render_pipe_profile__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: VF Bottleneck */
#define kblgt2__render_pipe_profile__vf_bottleneck__read \
   bdw__render_pipe_profile__vf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: VS Bottleneck */
#define kblgt2__render_pipe_profile__vs_bottleneck__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics set for 3D Pipeline Profile :: HS Bottleneck */
#define kblgt2__render_pipe_profile__hs_bottleneck__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics set for 3D Pipeline Profile :: DS Bottleneck */
#define kblgt2__render_pipe_profile__ds_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: GS Bottleneck */
#define kblgt2__render_pipe_profile__gs_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: SO Bottleneck */
#define kblgt2__render_pipe_profile__so_bottleneck__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Clipper Bottleneck */
#define kblgt2__render_pipe_profile__cl_bottleneck__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Strip-Fans Bottleneck */
#define kblgt2__render_pipe_profile__sf_bottleneck__read \
   bdw__render_pipe_profile__sf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Hi-Depth Bottleneck */
#define kblgt2__render_pipe_profile__hi_depth_bottleneck__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Bottleneck */
#define kblgt2__render_pipe_profile__early_depth_bottleneck__read \
   bdw__render_pipe_profile__early_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: BC Bottleneck */
#define kblgt2__render_pipe_profile__bc_bottleneck__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: HS Stall */
#define kblgt2__render_pipe_profile__hs_stall__read \
   bdw__render_pipe_profile__hs_stall__read

/* Render Metrics set for 3D Pipeline Profile :: DS Stall */
#define kblgt2__render_pipe_profile__ds_stall__read \
   bdw__render_pipe_profile__ds_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SO Stall */
#define kblgt2__render_pipe_profile__so_stall__read \
   bdw__render_pipe_profile__so_stall__read

/* Render Metrics set for 3D Pipeline Profile :: CL Stall */
#define kblgt2__render_pipe_profile__cl_stall__read \
   bdw__render_pipe_profile__cl_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SF Stall */
#define kblgt2__render_pipe_profile__sf_stall__read \
   bdw__render_pipe_profile__sf_stall__read

/* Memory Reads Distribution metrics set :: GPU Time Elapsed */
#define kblgt2__memory_reads__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Reads Distribution metrics set :: GPU Core Clocks */
#define kblgt2__memory_reads__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define kblgt2__memory_reads__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define kblgt2__memory_reads__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Reads Distribution metrics set :: GPU Busy */
#define kblgt2__memory_reads__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Reads Distribution metrics set :: VS Threads Dispatched */
#define kblgt2__memory_reads__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: HS Threads Dispatched */
#define kblgt2__memory_reads__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Reads Distribution metrics set :: DS Threads Dispatched */
#define kblgt2__memory_reads__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Reads Distribution metrics set :: GS Threads Dispatched */
#define kblgt2__memory_reads__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: FS Threads Dispatched */
#define kblgt2__memory_reads__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Reads Distribution metrics set :: CS Threads Dispatched */
#define kblgt2__memory_reads__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Reads Distribution metrics set :: EU Active */
#define kblgt2__memory_reads__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Reads Distribution metrics set :: EU Stall */
#define kblgt2__memory_reads__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Reads Distribution metrics set :: Rasterized Pixels */
#define kblgt2__memory_reads__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Reads Distribution metrics set :: Early Hi-Depth Test Fails */
#define kblgt2__memory_reads__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Early Depth Test Fails */
#define kblgt2__memory_reads__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Samples Killed in FS */
#define kblgt2__memory_reads__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Reads Distribution metrics set :: Pixels Failing Tests */
#define kblgt2__memory_reads__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Reads Distribution metrics set :: Samples Written */
#define kblgt2__memory_reads__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Reads Distribution metrics set :: Samples Blended */
#define kblgt2__memory_reads__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Reads Distribution metrics set :: Sampler Texels */
#define kblgt2__memory_reads__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Reads Distribution metrics set :: Sampler Texels Misses */
#define kblgt2__memory_reads__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Reads Distribution metrics set :: SLM Bytes Read */
#define kblgt2__memory_reads__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Reads Distribution metrics set :: SLM Bytes Written */
#define kblgt2__memory_reads__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Reads Distribution metrics set :: Shader Memory Accesses */
#define kblgt2__memory_reads__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Reads Distribution metrics set :: Shader Atomic Memory Accesses */
#define kblgt2__memory_reads__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Reads Distribution metrics set :: Shader Barrier Messages */
#define kblgt2__memory_reads__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: GtiCmdStreamerMemoryReads */
#define kblgt2__memory_reads__gti_cmd_streamer_memory_reads__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Reads Distribution metrics set :: GtiRsMemoryReads */
#define kblgt2__memory_reads__gti_rs_memory_reads__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Reads Distribution metrics set :: GtiVfMemoryReads */
#define kblgt2__memory_reads__gti_vf_memory_reads__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Memory Reads Distribution metrics set :: GtiRccMemoryReads */
#define kblgt2__memory_reads__gti_rcc_memory_reads__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiMscMemoryReads */
#define kblgt2__memory_reads__gti_msc_memory_reads__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Reads Distribution metrics set :: GtiHizMemoryReads */
#define kblgt2__memory_reads__gti_hiz_memory_reads__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiStcMemoryReads */
#define kblgt2__memory_reads__gti_stc_memory_reads__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Reads Distribution metrics set :: GtiRczMemoryReads */
#define kblgt2__memory_reads__gti_rcz_memory_reads__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Reads Distribution metrics set :: GtiMemoryReads */
#define kblgt2__memory_reads__gti_memory_reads__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank0Reads */
#define kblgt2__memory_reads__gti_l3_bank0_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank1Reads */
#define kblgt2__memory_reads__gti_l3_bank1_reads__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Reads Distribution metrics set :: GtiL3Bank2Reads */
#define kblgt2__memory_reads__gti_l3_bank2_reads__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Reads Distribution metrics set :: GtiL3Bank3Reads */
#define kblgt2__memory_reads__gti_l3_bank3_reads__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: GtiL3Reads */
#define kblgt2__memory_reads__gti_l3_reads__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Reads Distribution metrics set :: GtiRingAccesses */
#define kblgt2__memory_reads__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Memory Writes Distribution metrics set :: GPU Time Elapsed */
#define kblgt2__memory_writes__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Writes Distribution metrics set :: GPU Core Clocks */
#define kblgt2__memory_writes__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define kblgt2__memory_writes__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define kblgt2__memory_writes__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Writes Distribution metrics set :: GPU Busy */
#define kblgt2__memory_writes__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Writes Distribution metrics set :: VS Threads Dispatched */
#define kblgt2__memory_writes__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: HS Threads Dispatched */
#define kblgt2__memory_writes__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Writes Distribution metrics set :: DS Threads Dispatched */
#define kblgt2__memory_writes__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Writes Distribution metrics set :: GS Threads Dispatched */
#define kblgt2__memory_writes__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: FS Threads Dispatched */
#define kblgt2__memory_writes__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Writes Distribution metrics set :: CS Threads Dispatched */
#define kblgt2__memory_writes__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Writes Distribution metrics set :: EU Active */
#define kblgt2__memory_writes__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Writes Distribution metrics set :: EU Stall */
#define kblgt2__memory_writes__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Writes Distribution metrics set :: Rasterized Pixels */
#define kblgt2__memory_writes__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Writes Distribution metrics set :: Early Hi-Depth Test Fails */
#define kblgt2__memory_writes__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Early Depth Test Fails */
#define kblgt2__memory_writes__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Samples Killed in FS */
#define kblgt2__memory_writes__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Writes Distribution metrics set :: Pixels Failing Tests */
#define kblgt2__memory_writes__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Writes Distribution metrics set :: Samples Written */
#define kblgt2__memory_writes__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Writes Distribution metrics set :: Samples Blended */
#define kblgt2__memory_writes__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Writes Distribution metrics set :: Sampler Texels */
#define kblgt2__memory_writes__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Writes Distribution metrics set :: Sampler Texels Misses */
#define kblgt2__memory_writes__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Writes Distribution metrics set :: SLM Bytes Read */
#define kblgt2__memory_writes__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Writes Distribution metrics set :: SLM Bytes Written */
#define kblgt2__memory_writes__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Writes Distribution metrics set :: Shader Memory Accesses */
#define kblgt2__memory_writes__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Writes Distribution metrics set :: Shader Atomic Memory Accesses */
#define kblgt2__memory_writes__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Writes Distribution metrics set :: L3 Shader Throughput */
#define kblgt2__memory_writes__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Memory Writes Distribution metrics set :: Shader Barrier Messages */
#define kblgt2__memory_writes__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: GtiCmdStreamerMemoryWrites */
#define kblgt2__memory_writes__gti_cmd_streamer_memory_writes__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Writes Distribution metrics set :: GtiSoMemoryWrites */
#define kblgt2__memory_writes__gti_so_memory_writes__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Writes Distribution metrics set :: GtiRccMemoryWrites */
#define kblgt2__memory_writes__gti_rcc_memory_writes__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiMscMemoryWrites */
#define kblgt2__memory_writes__gti_msc_memory_writes__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Writes Distribution metrics set :: GtiHizMemoryWrites */
#define kblgt2__memory_writes__gti_hiz_memory_writes__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiStcMemoryWrites */
#define kblgt2__memory_writes__gti_stc_memory_writes__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Writes Distribution metrics set :: GtiRczMemoryWrites */
#define kblgt2__memory_writes__gti_rcz_memory_writes__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Writes Distribution metrics set :: GtiMemoryWrites */
#define kblgt2__memory_writes__gti_memory_writes__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank0Writes */
#define kblgt2__memory_writes__gti_l3_bank0_writes__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank1Writes */
#define kblgt2__memory_writes__gti_l3_bank1_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Writes Distribution metrics set :: GtiL3Bank2Writes */
#define kblgt2__memory_writes__gti_l3_bank2_writes__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Writes Distribution metrics set :: GtiL3Bank3Writes */
#define kblgt2__memory_writes__gti_l3_bank3_writes__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: GtiL3Writes */
#define kblgt2__memory_writes__gti_l3_writes__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Writes Distribution metrics set :: GtiRingAccesses */
#define kblgt2__memory_writes__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Compute Metrics Extended set :: GPU Time Elapsed */
#define kblgt2__compute_extended__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extended set :: GPU Core Clocks */
#define kblgt2__compute_extended__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: AVG GPU Core Frequency */
#define kblgt2__compute_extended__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extended set :: AVG GPU Core Frequency */
#define kblgt2__compute_extended__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extended set :: CS Threads Dispatched */
#define kblgt2__compute_extended__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Extended set :: EU Active */
#define kblgt2__compute_extended__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Extended set :: EU Stall */
#define kblgt2__compute_extended__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extended set :: EU Both FPU Pipes Active */
#define kblgt2__compute_extended__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Extended set :: EU FPU0 Pipe Active */
#define kblgt2__compute_extended__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Extended set :: EU FPU1 Pipe Active */
#define kblgt2__compute_extended__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Extended set :: EU AVG IPC Rate */
#define kblgt2__compute_extended__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Extended set :: EU Send Pipe Active */
#define kblgt2__compute_extended__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Extended set :: EU Thread Occupancy */
#define kblgt2__compute_extended__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Extended set :: Sampler Texels */
#define kblgt2__compute_extended__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Extended set :: Sampler Texels Misses */
#define kblgt2__compute_extended__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Extended set :: SLM Bytes Read */
#define kblgt2__compute_extended__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Extended set :: SLM Bytes Written */
#define kblgt2__compute_extended__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Extended set :: Shader Memory Accesses */
#define kblgt2__compute_extended__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Extended set :: Shader Atomic Memory Accesses */
#define kblgt2__compute_extended__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Extended set :: L3 Shader Throughput */
#define kblgt2__compute_extended__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Extended set :: Shader Barrier Messages */
#define kblgt2__compute_extended__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Extended set :: EuUntypedReads0 */
#define kblgt2__compute_extended__eu_untyped_reads0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Compute Metrics Extended set :: EuTypedReads0 */
#define kblgt2__compute_extended__eu_typed_reads0__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Compute Metrics Extended set :: EuUntypedWrites0 */
#define kblgt2__compute_extended__eu_untyped_writes0__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Compute Metrics Extended set :: EuTypedWrites0 */
#define kblgt2__compute_extended__eu_typed_writes0__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Compute Metrics Extended set :: EuUntypedAtomics0 */
#define kblgt2__compute_extended__eu_untyped_atomics0__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Compute Metrics Extended set :: EuTypedAtomics0 */
#define kblgt2__compute_extended__eu_typed_atomics0__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Compute Metrics Extended set :: EuA64UntypedReads0 */
#define kblgt2__compute_extended__eu_a64_untyped_reads0__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Compute Metrics Extended set :: EuA64UntypedWrites0 */
#define kblgt2__compute_extended__eu_a64_untyped_writes0__read \
   hsw__compute_extended__gpu_clocks__read

/* Compute Metrics Extended set :: Typed Reads 0 */
#define kblgt2__compute_extended__typed_reads0__read \
   hsw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: Typed Writes 0 */
#define kblgt2__compute_extended__typed_writes0__read \
   hsw__compute_extended__typed_writes0__read

/* Compute Metrics Extended set :: Untyped Reads 0 */
#define kblgt2__compute_extended__untyped_reads0__read \
   hsw__compute_extended__untyped_reads0__read

/* Compute Metrics Extended set :: Untyped Writes 0 */
#define kblgt2__compute_extended__untyped_writes0__read \
   hsw__compute_extended__untyped_writes0__read

/* Compute Metrics Extended set :: Typed Atomics 0 */
#define kblgt2__compute_extended__typed_atomics0__read \
   hsw__compute_extended__typed_atomics0__read

/* Compute Metrics Extended set :: TypedReadsPerCacheLine */
#define kblgt2__compute_extended__typed_reads_per_cache_line__read \
   hsw__compute_extended__typed_reads_per_cache_line__read

/* Compute Metrics Extended set :: TypedWritesPerCacheLine */
#define kblgt2__compute_extended__typed_writes_per_cache_line__read \
   hsw__compute_extended__typed_writes_per_cache_line__read

/* Compute Metrics Extended set :: UntypedReadsPerCacheLine */
#define kblgt2__compute_extended__untyped_reads_per_cache_line__read \
   bdw__compute_extended__untyped_reads_per_cache_line__read

/* Compute Metrics Extended set :: UntypedWritesPerCacheLine */
#define kblgt2__compute_extended__untyped_writes_per_cache_line__read \
   bdw__compute_extended__untyped_writes_per_cache_line__read

/* Compute Metrics Extended set :: TypedAtomicsPerCacheLine */
#define kblgt2__compute_extended__typed_atomics_per_cache_line__read \
   hsw__compute_extended__typed_atomics_per_cache_line__read

/* Compute Metrics L3 Cache set :: GPU Time Elapsed */
#define kblgt2__compute_l3_cache__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics L3 Cache set :: GPU Core Clocks */
#define kblgt2__compute_l3_cache__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics L3 Cache set :: AVG GPU Core Frequency */
#define kblgt2__compute_l3_cache__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics L3 Cache set :: AVG GPU Core Frequency */
#define kblgt2__compute_l3_cache__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics L3 Cache set :: GPU Busy */
#define kblgt2__compute_l3_cache__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics L3 Cache set :: VS Threads Dispatched */
#define kblgt2__compute_l3_cache__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache set :: HS Threads Dispatched */
#define kblgt2__compute_l3_cache__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics L3 Cache set :: DS Threads Dispatched */
#define kblgt2__compute_l3_cache__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics L3 Cache set :: GS Threads Dispatched */
#define kblgt2__compute_l3_cache__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache set :: FS Threads Dispatched */
#define kblgt2__compute_l3_cache__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics L3 Cache set :: CS Threads Dispatched */
#define kblgt2__compute_l3_cache__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics L3 Cache set :: EU Active */
#define kblgt2__compute_l3_cache__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics L3 Cache set :: EU Stall */
#define kblgt2__compute_l3_cache__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics L3 Cache set :: EU Both FPU Pipes Active */
#define kblgt2__compute_l3_cache__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Pipe Active */
#define kblgt2__compute_l3_cache__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Pipe Active */
#define kblgt2__compute_l3_cache__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics L3 Cache set :: EU AVG IPC Rate */
#define kblgt2__compute_l3_cache__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics L3 Cache set :: EU Send Pipe Active */
#define kblgt2__compute_l3_cache__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Hybrid Instruction */
#define kblgt2__compute_l3_cache__eu_hybrid_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU1 Hybrid Instruction */
#define kblgt2__compute_l3_cache__eu_hybrid_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU0 Ternary Instruction */
#define kblgt2__compute_l3_cache__eu_ternary_fpu0_instruction__read \
   bdw__render_basic__ps_fpu0_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Ternary Instruction */
#define kblgt2__compute_l3_cache__eu_ternary_fpu1_instruction__read \
   bdw__render_basic__ps_fpu1_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Binary Instruction */
#define kblgt2__compute_l3_cache__eu_binary_fpu0_instruction__read \
   bdw__render_basic__ps_send_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Binary Instruction */
#define kblgt2__compute_l3_cache__eu_binary_fpu1_instruction__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Move Instruction */
#define kblgt2__compute_l3_cache__eu_move_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu0_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU1 Move Instruction */
#define kblgt2__compute_l3_cache__eu_move_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu1_instruction__read

/* Compute Metrics L3 Cache set :: Rasterized Pixels */
#define kblgt2__compute_l3_cache__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics L3 Cache set :: Early Hi-Depth Test Fails */
#define kblgt2__compute_l3_cache__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics L3 Cache set :: Early Depth Test Fails */
#define kblgt2__compute_l3_cache__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache set :: Samples Killed in FS */
#define kblgt2__compute_l3_cache__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics L3 Cache set :: Pixels Failing Tests */
#define kblgt2__compute_l3_cache__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics L3 Cache set :: Samples Written */
#define kblgt2__compute_l3_cache__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics L3 Cache set :: Samples Blended */
#define kblgt2__compute_l3_cache__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics L3 Cache set :: Sampler Accesses */
#define kblgt2__compute_l3_cache__sampler_accesses__read \
   bdw__render_pipe_profile__sampler_accesses__read

/* Compute Metrics L3 Cache set :: Sampler Texels */
#define kblgt2__compute_l3_cache__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics L3 Cache set :: Sampler Texels Misses */
#define kblgt2__compute_l3_cache__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics L3 Cache set :: SLM Bytes Read */
#define kblgt2__compute_l3_cache__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics L3 Cache set :: SLM Bytes Written */
#define kblgt2__compute_l3_cache__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics L3 Cache set :: Shader Memory Accesses */
#define kblgt2__compute_l3_cache__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics L3 Cache set :: Shader Atomic Memory Accesses */
#define kblgt2__compute_l3_cache__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics L3 Cache set :: L3 Accesses */
#define kblgt2__compute_l3_cache__l3_accesses__read \
   sklgt2__compute_l3_cache__l3_accesses__read

/* Compute Metrics L3 Cache set :: L3 Misses */
#define kblgt2__compute_l3_cache__l3_misses__read \
   bdw__compute_l3_cache__l3_misses__read

/* Compute Metrics L3 Cache set :: L3 Sampler Throughput */
#define kblgt2__compute_l3_cache__l3_sampler_throughput__read \
   chv__render_basic__l3_sampler_throughput__read

/* Compute Metrics L3 Cache set :: L3 Shader Throughput */
#define kblgt2__compute_l3_cache__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics L3 Cache set :: L3 Total Throughput */
#define kblgt2__compute_l3_cache__l3_total_throughput__read \
   sklgt2__compute_l3_cache__l3_total_throughput__read

/* Compute Metrics L3 Cache set :: Shader Barrier Messages */
#define kblgt2__compute_l3_cache__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 Accesses */
#define kblgt2__compute_l3_cache__l3_bank00_accesses__read \
   bdw__compute_l3_cache__l3_bank00_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 01 Accesses */
#define kblgt2__compute_l3_cache__l3_bank01_accesses__read \
   bdw__compute_l3_cache__l3_bank01_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 02 Accesses */
#define kblgt2__compute_l3_cache__l3_bank02_accesses__read \
   bdw__compute_l3_cache__l3_bank02_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 03 Accesses */
#define kblgt2__compute_l3_cache__l3_bank03_accesses__read \
   bdw__compute_l3_cache__l3_bank03_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 IC Accesses */
#define kblgt2__compute_l3_cache__l3_bank00_ic_accesses__read \
   bdw__compute_l3_cache__l3_bank00_ic_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 IC Hits */
#define kblgt2__compute_l3_cache__l3_bank00_ic_hits__read \
   bdw__compute_l3_cache__l3_bank00_ic_hits__read

/* Compute Metrics L3 Cache set :: GTI L3 Throughput */
#define kblgt2__compute_l3_cache__gti_l3_throughput__read \
   bdw__compute_l3_cache__gti_l3_throughput__read

/* Compute Metrics L3 Cache set :: GTI Read Throughput */
#define kblgt2__compute_l3_cache__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Compute Metrics L3 Cache set :: GTI Write Throughput */
#define kblgt2__compute_l3_cache__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Metric set HDCAndSF :: GPU Time Elapsed */
#define kblgt2__hdc_and_sf__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set HDCAndSF :: GPU Core Clocks */
#define kblgt2__hdc_and_sf__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define kblgt2__hdc_and_sf__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define kblgt2__hdc_and_sf__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set HDCAndSF :: GPU Busy */
#define kblgt2__hdc_and_sf__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set HDCAndSF :: VS Threads Dispatched */
#define kblgt2__hdc_and_sf__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: HS Threads Dispatched */
#define kblgt2__hdc_and_sf__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set HDCAndSF :: DS Threads Dispatched */
#define kblgt2__hdc_and_sf__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set HDCAndSF :: GS Threads Dispatched */
#define kblgt2__hdc_and_sf__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: FS Threads Dispatched */
#define kblgt2__hdc_and_sf__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set HDCAndSF :: CS Threads Dispatched */
#define kblgt2__hdc_and_sf__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set HDCAndSF :: EU Active */
#define kblgt2__hdc_and_sf__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set HDCAndSF :: EU Stall */
#define kblgt2__hdc_and_sf__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
#define kblgt2__hdc_and_sf__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
#define kblgt2__hdc_and_sf__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
#define kblgt2__hdc_and_sf__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set HDCAndSF :: VS Send Pipe Active */
#define kblgt2__hdc_and_sf__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
#define kblgt2__hdc_and_sf__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
#define kblgt2__hdc_and_sf__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set HDCAndSF :: PS Send Pipeline Active */
#define kblgt2__hdc_and_sf__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set HDCAndSF :: FS Both FPU Active */
#define kblgt2__hdc_and_sf__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set HDCAndSF :: Rasterized Pixels */
#define kblgt2__hdc_and_sf__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
#define kblgt2__hdc_and_sf__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set HDCAndSF :: Early Depth Test Fails */
#define kblgt2__hdc_and_sf__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Samples Killed in FS */
#define kblgt2__hdc_and_sf__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set HDCAndSF :: Pixels Failing Tests */
#define kblgt2__hdc_and_sf__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set HDCAndSF :: Samples Written */
#define kblgt2__hdc_and_sf__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set HDCAndSF :: Samples Blended */
#define kblgt2__hdc_and_sf__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set HDCAndSF :: Sampler Texels */
#define kblgt2__hdc_and_sf__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set HDCAndSF :: Sampler Texels Misses */
#define kblgt2__hdc_and_sf__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set HDCAndSF :: SLM Bytes Read */
#define kblgt2__hdc_and_sf__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set HDCAndSF :: SLM Bytes Written */
#define kblgt2__hdc_and_sf__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set HDCAndSF :: Shader Memory Accesses */
#define kblgt2__hdc_and_sf__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
#define kblgt2__hdc_and_sf__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set HDCAndSF :: L3 Shader Throughput */
#define kblgt2__hdc_and_sf__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set HDCAndSF :: Shader Barrier Messages */
#define kblgt2__hdc_and_sf__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Polygon Data Ready */
#define kblgt2__hdc_and_sf__poly_data_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
#define kblgt2__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
#define kblgt2__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
#define kblgt2__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read

/* Metric set HDCAndSF :: SQ is full */
#define kblgt2__hdc_and_sf__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_1 :: GPU Time Elapsed */
#define kblgt2__l3_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_1 :: GPU Core Clocks */
#define kblgt2__l3_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define kblgt2__l3_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define kblgt2__l3_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_1 :: GPU Busy */
#define kblgt2__l3_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_1 :: VS Threads Dispatched */
#define kblgt2__l3_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_1 :: HS Threads Dispatched */
#define kblgt2__l3_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_1 :: DS Threads Dispatched */
#define kblgt2__l3_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_1 :: GS Threads Dispatched */
#define kblgt2__l3_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_1 :: FS Threads Dispatched */
#define kblgt2__l3_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_1 :: CS Threads Dispatched */
#define kblgt2__l3_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_1 :: EU Active */
#define kblgt2__l3_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_1 :: EU Stall */
#define kblgt2__l3_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_1 :: EU Both FPU Pipes Active */
#define kblgt2__l3_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_1 :: VS FPU0 Pipe Active */
#define kblgt2__l3_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_1 :: VS FPU1 Pipe Active */
#define kblgt2__l3_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_1 :: VS Send Pipe Active */
#define kblgt2__l3_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_1 :: PS FPU0 Pipe Active */
#define kblgt2__l3_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_1 :: PS FPU1 Pipe Active */
#define kblgt2__l3_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_1 :: PS Send Pipeline Active */
#define kblgt2__l3_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_1 :: FS Both FPU Active */
#define kblgt2__l3_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_1 :: Rasterized Pixels */
#define kblgt2__l3_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
#define kblgt2__l3_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_1 :: Early Depth Test Fails */
#define kblgt2__l3_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Samples Killed in FS */
#define kblgt2__l3_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_1 :: Pixels Failing Tests */
#define kblgt2__l3_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_1 :: Samples Written */
#define kblgt2__l3_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_1 :: Samples Blended */
#define kblgt2__l3_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_1 :: Sampler Texels */
#define kblgt2__l3_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_1 :: Sampler Texels Misses */
#define kblgt2__l3_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_1 :: SLM Bytes Read */
#define kblgt2__l3_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_1 :: SLM Bytes Written */
#define kblgt2__l3_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_1 :: Shader Memory Accesses */
#define kblgt2__l3_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
#define kblgt2__l3_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_1 :: L3 Shader Throughput */
#define kblgt2__l3_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_1 :: Shader Barrier Messages */
#define kblgt2__l3_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Stalled */
#define kblgt2__l3_1__l30_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Stalled */
#define kblgt2__l3_1__l30_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Active */
#define kblgt2__l3_1__l30_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Active */
#define kblgt2__l3_1__l30_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_1 :: SQ is full */
#define kblgt2__l3_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_2 :: GPU Time Elapsed */
#define kblgt2__l3_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_2 :: GPU Core Clocks */
#define kblgt2__l3_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define kblgt2__l3_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define kblgt2__l3_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_2 :: GPU Busy */
#define kblgt2__l3_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_2 :: VS Threads Dispatched */
#define kblgt2__l3_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_2 :: HS Threads Dispatched */
#define kblgt2__l3_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_2 :: DS Threads Dispatched */
#define kblgt2__l3_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_2 :: GS Threads Dispatched */
#define kblgt2__l3_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_2 :: FS Threads Dispatched */
#define kblgt2__l3_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_2 :: CS Threads Dispatched */
#define kblgt2__l3_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_2 :: EU Active */
#define kblgt2__l3_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_2 :: EU Stall */
#define kblgt2__l3_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_2 :: EU Both FPU Pipes Active */
#define kblgt2__l3_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_2 :: VS FPU0 Pipe Active */
#define kblgt2__l3_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_2 :: VS FPU1 Pipe Active */
#define kblgt2__l3_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_2 :: VS Send Pipe Active */
#define kblgt2__l3_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_2 :: PS FPU0 Pipe Active */
#define kblgt2__l3_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_2 :: PS FPU1 Pipe Active */
#define kblgt2__l3_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_2 :: PS Send Pipeline Active */
#define kblgt2__l3_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_2 :: FS Both FPU Active */
#define kblgt2__l3_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_2 :: Rasterized Pixels */
#define kblgt2__l3_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
#define kblgt2__l3_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_2 :: Early Depth Test Fails */
#define kblgt2__l3_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Samples Killed in FS */
#define kblgt2__l3_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_2 :: Pixels Failing Tests */
#define kblgt2__l3_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_2 :: Samples Written */
#define kblgt2__l3_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_2 :: Samples Blended */
#define kblgt2__l3_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_2 :: Sampler Texels */
#define kblgt2__l3_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_2 :: Sampler Texels Misses */
#define kblgt2__l3_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_2 :: SLM Bytes Read */
#define kblgt2__l3_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_2 :: SLM Bytes Written */
#define kblgt2__l3_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_2 :: Shader Memory Accesses */
#define kblgt2__l3_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
#define kblgt2__l3_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_2 :: L3 Shader Throughput */
#define kblgt2__l3_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_2 :: Shader Barrier Messages */
#define kblgt2__l3_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Stalled */
#define kblgt2__l3_2__l30_bank2_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Active */
#define kblgt2__l3_2__l30_bank2_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_2 :: SQ is full */
#define kblgt2__l3_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_3 :: GPU Time Elapsed */
#define kblgt2__l3_3__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_3 :: GPU Core Clocks */
#define kblgt2__l3_3__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define kblgt2__l3_3__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define kblgt2__l3_3__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_3 :: GPU Busy */
#define kblgt2__l3_3__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_3 :: VS Threads Dispatched */
#define kblgt2__l3_3__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_3 :: HS Threads Dispatched */
#define kblgt2__l3_3__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_3 :: DS Threads Dispatched */
#define kblgt2__l3_3__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_3 :: GS Threads Dispatched */
#define kblgt2__l3_3__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_3 :: FS Threads Dispatched */
#define kblgt2__l3_3__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_3 :: CS Threads Dispatched */
#define kblgt2__l3_3__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_3 :: EU Active */
#define kblgt2__l3_3__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_3 :: EU Stall */
#define kblgt2__l3_3__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_3 :: EU Both FPU Pipes Active */
#define kblgt2__l3_3__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_3 :: VS FPU0 Pipe Active */
#define kblgt2__l3_3__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_3 :: VS FPU1 Pipe Active */
#define kblgt2__l3_3__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_3 :: VS Send Pipe Active */
#define kblgt2__l3_3__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_3 :: PS FPU0 Pipe Active */
#define kblgt2__l3_3__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_3 :: PS FPU1 Pipe Active */
#define kblgt2__l3_3__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_3 :: PS Send Pipeline Active */
#define kblgt2__l3_3__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_3 :: FS Both FPU Active */
#define kblgt2__l3_3__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_3 :: Rasterized Pixels */
#define kblgt2__l3_3__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
#define kblgt2__l3_3__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_3 :: Early Depth Test Fails */
#define kblgt2__l3_3__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Samples Killed in FS */
#define kblgt2__l3_3__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_3 :: Pixels Failing Tests */
#define kblgt2__l3_3__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_3 :: Samples Written */
#define kblgt2__l3_3__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_3 :: Samples Blended */
#define kblgt2__l3_3__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_3 :: Sampler Texels */
#define kblgt2__l3_3__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_3 :: Sampler Texels Misses */
#define kblgt2__l3_3__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_3 :: SLM Bytes Read */
#define kblgt2__l3_3__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_3 :: SLM Bytes Written */
#define kblgt2__l3_3__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_3 :: Shader Memory Accesses */
#define kblgt2__l3_3__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
#define kblgt2__l3_3__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_3 :: L3 Shader Throughput */
#define kblgt2__l3_3__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_3 :: Shader Barrier Messages */
#define kblgt2__l3_3__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
#define kblgt2__l3_3__l30_bank3_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
#define kblgt2__l3_3__l30_bank3_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_3 :: SQ is full */
#define kblgt2__l3_3__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
#define kblgt2__rasterizer_and_pixel_backend__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
#define kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define kblgt2__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define kblgt2__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
#define kblgt2__rasterizer_and_pixel_backend__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
#define kblgt2__rasterizer_and_pixel_backend__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
#define kblgt2__rasterizer_and_pixel_backend__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
#define kblgt2__rasterizer_and_pixel_backend__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
#define kblgt2__rasterizer_and_pixel_backend__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
#define kblgt2__rasterizer_and_pixel_backend__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
#define kblgt2__rasterizer_and_pixel_backend__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set RasterizerAndPixelBackend :: EU Active */
#define kblgt2__rasterizer_and_pixel_backend__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set RasterizerAndPixelBackend :: EU Stall */
#define kblgt2__rasterizer_and_pixel_backend__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
#define kblgt2__rasterizer_and_pixel_backend__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
#define kblgt2__rasterizer_and_pixel_backend__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
#define kblgt2__rasterizer_and_pixel_backend__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
#define kblgt2__rasterizer_and_pixel_backend__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
#define kblgt2__rasterizer_and_pixel_backend__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
#define kblgt2__rasterizer_and_pixel_backend__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
#define kblgt2__rasterizer_and_pixel_backend__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
#define kblgt2__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
#define kblgt2__rasterizer_and_pixel_backend__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
#define kblgt2__rasterizer_and_pixel_backend__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
#define kblgt2__rasterizer_and_pixel_backend__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
#define kblgt2__rasterizer_and_pixel_backend__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
#define kblgt2__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set RasterizerAndPixelBackend :: Samples Written */
#define kblgt2__rasterizer_and_pixel_backend__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
#define kblgt2__rasterizer_and_pixel_backend__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
#define kblgt2__rasterizer_and_pixel_backend__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
#define kblgt2__rasterizer_and_pixel_backend__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
#define kblgt2__rasterizer_and_pixel_backend__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
#define kblgt2__rasterizer_and_pixel_backend__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
#define kblgt2__rasterizer_and_pixel_backend__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
#define kblgt2__rasterizer_and_pixel_backend__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
#define kblgt2__rasterizer_and_pixel_backend__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
#define kblgt2__rasterizer_and_pixel_backend__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
#define kblgt2__rasterizer_and_pixel_backend__pixel_data0_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
#define kblgt2__rasterizer_and_pixel_backend__rasterizer0_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
#define kblgt2__rasterizer_and_pixel_backend__ps_output0_available__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
#define kblgt2__rasterizer_and_pixel_backend__pixel_values0_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
#define kblgt2__rasterizer_and_pixel_backend__rasterizer0_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set RasterizerAndPixelBackend :: SQ is full */
#define kblgt2__rasterizer_and_pixel_backend__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler :: GPU Time Elapsed */
#define kblgt2__sampler__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler :: GPU Core Clocks */
#define kblgt2__sampler__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define kblgt2__sampler__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define kblgt2__sampler__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler :: GPU Busy */
#define kblgt2__sampler__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler :: VS Threads Dispatched */
#define kblgt2__sampler__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler :: HS Threads Dispatched */
#define kblgt2__sampler__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler :: DS Threads Dispatched */
#define kblgt2__sampler__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler :: GS Threads Dispatched */
#define kblgt2__sampler__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler :: FS Threads Dispatched */
#define kblgt2__sampler__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler :: CS Threads Dispatched */
#define kblgt2__sampler__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler :: EU Active */
#define kblgt2__sampler__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler :: EU Stall */
#define kblgt2__sampler__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler :: EU Both FPU Pipes Active */
#define kblgt2__sampler__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler :: VS FPU0 Pipe Active */
#define kblgt2__sampler__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler :: VS FPU1 Pipe Active */
#define kblgt2__sampler__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler :: VS Send Pipe Active */
#define kblgt2__sampler__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler :: PS FPU0 Pipe Active */
#define kblgt2__sampler__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler :: PS FPU1 Pipe Active */
#define kblgt2__sampler__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler :: PS Send Pipeline Active */
#define kblgt2__sampler__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler :: FS Both FPU Active */
#define kblgt2__sampler__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler :: Rasterized Pixels */
#define kblgt2__sampler__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler :: Early Hi-Depth Test Fails */
#define kblgt2__sampler__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler :: Early Depth Test Fails */
#define kblgt2__sampler__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Samples Killed in FS */
#define kblgt2__sampler__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler :: Pixels Failing Tests */
#define kblgt2__sampler__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler :: Samples Written */
#define kblgt2__sampler__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler :: Samples Blended */
#define kblgt2__sampler__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler :: Sampler Texels */
#define kblgt2__sampler__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler :: Sampler Texels Misses */
#define kblgt2__sampler__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler :: SLM Bytes Read */
#define kblgt2__sampler__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler :: SLM Bytes Written */
#define kblgt2__sampler__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler :: Shader Memory Accesses */
#define kblgt2__sampler__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler :: Shader Atomic Memory Accesses */
#define kblgt2__sampler__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler :: L3 Shader Throughput */
#define kblgt2__sampler__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler :: Shader Barrier Messages */
#define kblgt2__sampler__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Slice0 Subslice1 Input Available */
#define kblgt2__sampler__sampler01_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler :: Slice0 Subslice2 Input Available */
#define kblgt2__sampler__sampler02_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler :: Slice0 Subslice0 Input Available */
#define kblgt2__sampler__sampler00_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice2 Sampler Output Ready */
#define kblgt2__sampler__sampler02_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice0 Sampler Output Ready */
#define kblgt2__sampler__sampler00_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice1 Sampler Output Ready */
#define kblgt2__sampler__sampler01_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler :: SQ is full */
#define kblgt2__sampler__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_1 :: GPU Time Elapsed */
#define kblgt2__tdl_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_1 :: GPU Core Clocks */
#define kblgt2__tdl_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define kblgt2__tdl_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define kblgt2__tdl_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_1 :: GPU Busy */
#define kblgt2__tdl_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_1 :: VS Threads Dispatched */
#define kblgt2__tdl_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_1 :: HS Threads Dispatched */
#define kblgt2__tdl_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_1 :: DS Threads Dispatched */
#define kblgt2__tdl_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_1 :: GS Threads Dispatched */
#define kblgt2__tdl_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_1 :: FS Threads Dispatched */
#define kblgt2__tdl_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_1 :: CS Threads Dispatched */
#define kblgt2__tdl_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_1 :: EU Active */
#define kblgt2__tdl_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_1 :: EU Stall */
#define kblgt2__tdl_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
#define kblgt2__tdl_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
#define kblgt2__tdl_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
#define kblgt2__tdl_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_1 :: VS Send Pipe Active */
#define kblgt2__tdl_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
#define kblgt2__tdl_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
#define kblgt2__tdl_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_1 :: PS Send Pipeline Active */
#define kblgt2__tdl_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_1 :: FS Both FPU Active */
#define kblgt2__tdl_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_1 :: Rasterized Pixels */
#define kblgt2__tdl_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
#define kblgt2__tdl_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_1 :: Early Depth Test Fails */
#define kblgt2__tdl_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: Samples Killed in FS */
#define kblgt2__tdl_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_1 :: Pixels Failing Tests */
#define kblgt2__tdl_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_1 :: Samples Written */
#define kblgt2__tdl_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_1 :: Samples Blended */
#define kblgt2__tdl_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_1 :: Sampler Texels */
#define kblgt2__tdl_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_1 :: Sampler Texels Misses */
#define kblgt2__tdl_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_1 :: SLM Bytes Read */
#define kblgt2__tdl_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_1 :: SLM Bytes Written */
#define kblgt2__tdl_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_1 :: Shader Memory Accesses */
#define kblgt2__tdl_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
#define kblgt2__tdl_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_1 :: L3 Shader Throughput */
#define kblgt2__tdl_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_1 :: Shader Barrier Messages */
#define kblgt2__tdl_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
#define kblgt2__tdl_1__non_ps_thread01_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice0 */
#define kblgt2__tdl_1__ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
#define kblgt2__tdl_1__non_ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice2 */
#define kblgt2__tdl_1__ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
#define kblgt2__tdl_1__non_ps_thread02_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice1 */
#define kblgt2__tdl_1__ps_thread01_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_1 :: SQ is full */
#define kblgt2__tdl_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_2 :: GPU Time Elapsed */
#define kblgt2__tdl_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_2 :: GPU Core Clocks */
#define kblgt2__tdl_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define kblgt2__tdl_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define kblgt2__tdl_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_2 :: GPU Busy */
#define kblgt2__tdl_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_2 :: VS Threads Dispatched */
#define kblgt2__tdl_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_2 :: HS Threads Dispatched */
#define kblgt2__tdl_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_2 :: DS Threads Dispatched */
#define kblgt2__tdl_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_2 :: GS Threads Dispatched */
#define kblgt2__tdl_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_2 :: FS Threads Dispatched */
#define kblgt2__tdl_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_2 :: CS Threads Dispatched */
#define kblgt2__tdl_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_2 :: EU Active */
#define kblgt2__tdl_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_2 :: EU Stall */
#define kblgt2__tdl_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
#define kblgt2__tdl_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
#define kblgt2__tdl_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
#define kblgt2__tdl_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_2 :: VS Send Pipe Active */
#define kblgt2__tdl_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
#define kblgt2__tdl_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
#define kblgt2__tdl_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_2 :: PS Send Pipeline Active */
#define kblgt2__tdl_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_2 :: FS Both FPU Active */
#define kblgt2__tdl_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_2 :: Rasterized Pixels */
#define kblgt2__tdl_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
#define kblgt2__tdl_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_2 :: Early Depth Test Fails */
#define kblgt2__tdl_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Samples Killed in FS */
#define kblgt2__tdl_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_2 :: Pixels Failing Tests */
#define kblgt2__tdl_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_2 :: Samples Written */
#define kblgt2__tdl_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_2 :: Samples Blended */
#define kblgt2__tdl_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_2 :: Sampler Texels */
#define kblgt2__tdl_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_2 :: Sampler Texels Misses */
#define kblgt2__tdl_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_2 :: SLM Bytes Read */
#define kblgt2__tdl_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_2 :: SLM Bytes Written */
#define kblgt2__tdl_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_2 :: Shader Memory Accesses */
#define kblgt2__tdl_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
#define kblgt2__tdl_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_2 :: L3 Shader Throughput */
#define kblgt2__tdl_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_2 :: Shader Barrier Messages */
#define kblgt2__tdl_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 0 */
#define kblgt2__tdl_2__thread_header01_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 1 */
#define kblgt2__tdl_2__thread_header00_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 0 */
#define kblgt2__tdl_2__thread_header00_ready_port0__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 1 */
#define kblgt2__tdl_2__thread_header02_ready_port1__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 0 */
#define kblgt2__tdl_2__thread_header02_ready_port0__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 1 */
#define kblgt2__tdl_2__thread_header01_ready_port1__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_2 :: SQ is full */
#define kblgt2__tdl_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Compute Metrics Extra set :: GPU Time Elapsed */
#define kblgt2__compute_extra__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extra set :: GPU Core Clocks */
#define kblgt2__compute_extra__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define kblgt2__compute_extra__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define kblgt2__compute_extra__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extra set :: EU FPU1 Pipe Active */
#define kblgt2__compute_extra__fpu1_active__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extra set :: EU FPU1 Pipe Active including Ext Math */
#define kblgt2__compute_extra__fpu1_active_adjusted__read \
   sklgt2__compute_extra__fpu1_active_adjusted__read

/* Media Vme Pipe metrics set :: GPU Time Elapsed */
#define kblgt2__vme_pipe__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Media Vme Pipe metrics set :: GPU Core Clocks */
#define kblgt2__vme_pipe__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define kblgt2__vme_pipe__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define kblgt2__vme_pipe__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Media Vme Pipe metrics set :: GPU Busy */
#define kblgt2__vme_pipe__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Media Vme Pipe metrics set :: CS Threads Dispatched */
#define kblgt2__vme_pipe__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Media Vme Pipe metrics set :: EU Active */
#define kblgt2__vme_pipe__eu_active__read \
   bdw__render_basic__eu_active__read

/* Media Vme Pipe metrics set :: EU Stall */
#define kblgt2__vme_pipe__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Media Vme Pipe metrics set :: EU Both FPU Pipes Active */
#define kblgt2__vme_pipe__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Media Vme Pipe metrics set :: EU Thread Occupancy */
#define kblgt2__vme_pipe__eu_thread_occupancy__read \
   bdw__vme_pipe__eu_thread_occupancy__read

/* Media Vme Pipe metrics set :: VME Busy */
#define kblgt2__vme_pipe__vme_busy__read \
   bdw__vme_pipe__vme_busy__read

/* Gpu Rings Busyness :: GPU Time Elapsed */
#define kblgt2__gpu_busyness__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Gpu Rings Busyness :: GPU Core Clocks */
#define kblgt2__gpu_busyness__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define kblgt2__gpu_busyness__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define kblgt2__gpu_busyness__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Gpu Rings Busyness :: Render Ring Busy */
#define kblgt2__gpu_busyness__render_busy__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Gpu Rings Busyness :: Vdbox0 Ring Busy */
#define kblgt2__gpu_busyness__vdbox0_busy__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Gpu Rings Busyness :: Vebox Ring Busy */
#define kblgt2__gpu_busyness__vebox_busy__read \
   bdw__render_pipe_profile__sf_stall__read

/* Gpu Rings Busyness :: Blitter Ring Busy */
#define kblgt2__gpu_busyness__blitter_busy__read \
   bdw__render_pipe_profile__cl_stall__read

/* Gpu Rings Busyness :: AnyRingBusy */
#define kblgt2__gpu_busyness__any_ring_busy__read \
   bdw__render_basic__sampler0_busy__read

/* MDAPI testing set :: GPU Time Elapsed */
#define kblgt2__test_oa__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* MDAPI testing set :: GPU Core Clocks */
#define kblgt2__test_oa__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define kblgt2__test_oa__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define kblgt2__test_oa__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* MDAPI testing set :: TestCounter0 */
#define kblgt2__test_oa__counter0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* MDAPI testing set :: TestCounter1 */
#define kblgt2__test_oa__counter1__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* MDAPI testing set :: TestCounter2 */
#define kblgt2__test_oa__counter2__read \
   hsw__compute_extended__eu_typed_reads0__read

/* MDAPI testing set :: TestCounter3 */
#define kblgt2__test_oa__counter3__read \
   hsw__compute_extended__eu_typed_writes0__read

/* MDAPI testing set :: TestCounter4 */
#define kblgt2__test_oa__counter4__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* MDAPI testing set :: TestCounter5 */
#define kblgt2__test_oa__counter5__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* MDAPI testing set :: TestCounter6 */
#define kblgt2__test_oa__counter6__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* MDAPI testing set :: TestCounter7 */
#define kblgt2__test_oa__counter7__read \
   hsw__compute_extended__gpu_clocks__read

/* MDAPI testing set :: TestCounter8 */
#define kblgt2__test_oa__counter8__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Metric set PMA Stall :: GPU Time Elapsed */
#define kblgt2__pma__stall__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set PMA Stall :: GPU Core Clocks */
#define kblgt2__pma__stall__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define kblgt2__pma__stall__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define kblgt2__pma__stall__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set PMA Stall :: STC PMA stall */
#define kblgt2__pma__stall__stc_pma_stall__read \
   sklgt2__pma__stall__stc_pma_stall__read

/* AsyncCompute :: GPU Time Elapsed */
#define kblgt2__async_compute__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* AsyncCompute :: GPU Core Clocks */
#define kblgt2__async_compute__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define kblgt2__async_compute__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define kblgt2__async_compute__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* AsyncCompute :: GPU Busy */
#define kblgt2__async_compute__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* AsyncCompute :: VS Threads Dispatched */
#define kblgt2__async_compute__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* AsyncCompute :: HS Threads Dispatched */
#define kblgt2__async_compute__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* AsyncCompute :: DS Threads Dispatched */
#define kblgt2__async_compute__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* AsyncCompute :: GS Threads Dispatched */
#define kblgt2__async_compute__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* AsyncCompute :: FS Threads Dispatched */
#define kblgt2__async_compute__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* AsyncCompute :: CS Threads Dispatched */
#define kblgt2__async_compute__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* AsyncCompute :: EU FPU0 Pipe Active */
#define kblgt2__async_compute__fpu0_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* AsyncCompute :: VS FPU0 Pipe Active */
#define kblgt2__async_compute__vs_fpu0_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* AsyncCompute :: PS FPU0 Pipe Active */
#define kblgt2__async_compute__ps_fpu0_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* AsyncCompute :: CS FPU0 Pipe Active */
#define kblgt2__async_compute__cs_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* AsyncCompute :: EU FPU1 Pipe Active */
#define kblgt2__async_compute__fpu1_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* AsyncCompute :: VS FPU1 Pipe Active */
#define kblgt2__async_compute__vs_fpu1_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* AsyncCompute :: PS FPU1 Pipe Active */
#define kblgt2__async_compute__ps_fpu1_active__read \
   bdw__render_basic__vs_send_active__read

/* AsyncCompute :: CS FPU1 Pipe Active */
#define kblgt2__async_compute__cs_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* AsyncCompute :: EU Thread Occupancy */
#define kblgt2__async_compute__eu_thread_occupancy__read \
   sklgt2__ff_bottlenecks__eu_thread_occupancy__read

/* AsyncCompute :: EU Active */
#define kblgt2__async_compute__eu_active__read \
   bdw__render_basic__eu_active__read

/* AsyncCompute :: EU Stall */
#define kblgt2__async_compute__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: GPU Time Elapsed */
#define kblgt3__render_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics Basic set :: GPU Core Clocks */
#define kblgt3__render_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define kblgt3__render_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define kblgt3__render_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics Basic set :: VS Threads Dispatched */
#define kblgt3__render_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics Basic set :: HS Threads Dispatched */
#define kblgt3__render_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics Basic set :: DS Threads Dispatched */
#define kblgt3__render_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics Basic set :: GS Threads Dispatched */
#define kblgt3__render_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics Basic set :: FS Threads Dispatched */
#define kblgt3__render_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics Basic set :: CS Threads Dispatched */
#define kblgt3__render_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics Basic set :: GPU Busy */
#define kblgt3__render_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics Basic set :: EU Active */
#define kblgt3__render_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics Basic set :: EU Stall */
#define kblgt3__render_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
#define kblgt3__render_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
#define kblgt3__render_basic__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
#define kblgt3__render_basic__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Render Metrics Basic set :: VS Send Pipe Active */
#define kblgt3__render_basic__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
#define kblgt3__render_basic__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
#define kblgt3__render_basic__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Render Metrics Basic set :: PS Send Pipeline Active */
#define kblgt3__render_basic__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Render Metrics Basic set :: FS Both FPU Active */
#define kblgt3__render_basic__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Render Metrics Basic set :: Sampler 0 Busy */
#define kblgt3__render_basic__sampler0_busy__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics Basic set :: Sampler 1 Busy */
#define kblgt3__render_basic__sampler1_busy__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics Basic set :: Samplers Busy */
#define kblgt3__render_basic__samplers_busy__read \
   bdw__render_basic__samplers_busy__read

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
#define kblgt3__render_basic__sampler0_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
#define kblgt3__render_basic__sampler1_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics Basic set :: Rasterized Pixels */
#define kblgt3__render_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
#define kblgt3__render_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics Basic set :: Early Depth Test Fails */
#define kblgt3__render_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: Samples Killed in FS */
#define kblgt3__render_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics Basic set :: Pixels Failing Tests */
#define kblgt3__render_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics Basic set :: Samples Written */
#define kblgt3__render_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics Basic set :: Samples Blended */
#define kblgt3__render_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics Basic set :: Sampler Texels */
#define kblgt3__render_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics Basic set :: Sampler Texels Misses */
#define kblgt3__render_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics Basic set :: Sampler Cache Misses */
#define kblgt3__render_basic__sampler_l1_misses__read \
   bdw__render_basic__sampler_l1_misses__read

/* Render Metrics Basic set :: SLM Bytes Read */
#define kblgt3__render_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics Basic set :: SLM Bytes Written */
#define kblgt3__render_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics Basic set :: Shader Memory Accesses */
#define kblgt3__render_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
#define kblgt3__render_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
#define kblgt3__render_basic__l3_lookups__read \
   bdw__render_basic__l3_lookups__read

/* Render Metrics Basic set :: L3 Misses */
#define kblgt3__render_basic__l3_misses__read \
   hsw__compute_extended__typed_atomics0__read

/* Render Metrics Basic set :: L3 Sampler Throughput */
#define kblgt3__render_basic__l3_sampler_throughput__read \
   bdw__render_basic__l3_sampler_throughput__read

/* Render Metrics Basic set :: L3 Shader Throughput */
#define kblgt3__render_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics Basic set :: Shader Barrier Messages */
#define kblgt3__render_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
#define kblgt3__render_basic__gti_vf_throughput__read \
   bdw__render_basic__gti_vf_throughput__read

/* Render Metrics Basic set :: GTI Depth Throughput */
#define kblgt3__render_basic__gti_depth_throughput__read \
   bdw__render_basic__gti_depth_throughput__read

/* Render Metrics Basic set :: GTI RCC Throughput */
#define kblgt3__render_basic__gti_rcc_throughput__read \
   bdw__render_basic__gti_rcc_throughput__read

/* Render Metrics Basic set :: GTI L3 Throughput */
#define kblgt3__render_basic__gti_l3_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Render Metrics Basic set :: GTI HDC TLB Lookup Throughput */
#define kblgt3__render_basic__gti_hdc_lookups_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics Basic set :: GTI Read Throughput */
#define kblgt3__render_basic__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Render Metrics Basic set :: GTI Write Throughput */
#define kblgt3__render_basic__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Render Metrics Basic set :: Samplers Bottleneck */
#define kblgt3__render_basic__sampler_bottleneck__read \
   bdw__render_basic__sampler_bottleneck__read

/* Compute Metrics Basic set :: GPU Time Elapsed */
#define kblgt3__compute_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Basic set :: GPU Core Clocks */
#define kblgt3__compute_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define kblgt3__compute_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Basic set :: AVG GPU Core Frequency */
#define kblgt3__compute_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Basic set :: GPU Busy */
#define kblgt3__compute_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics Basic set :: VS Threads Dispatched */
#define kblgt3__compute_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: HS Threads Dispatched */
#define kblgt3__compute_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics Basic set :: DS Threads Dispatched */
#define kblgt3__compute_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics Basic set :: GS Threads Dispatched */
#define kblgt3__compute_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics Basic set :: FS Threads Dispatched */
#define kblgt3__compute_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics Basic set :: CS Threads Dispatched */
#define kblgt3__compute_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Basic set :: EU Active */
#define kblgt3__compute_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Basic set :: EU Stall */
#define kblgt3__compute_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Basic set :: EU Both FPU Pipes Active */
#define kblgt3__compute_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Basic set :: EU FPU0 Pipe Active */
#define kblgt3__compute_basic__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Basic set :: EU FPU1 Pipe Active */
#define kblgt3__compute_basic__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Basic set :: EU AVG IPC Rate */
#define kblgt3__compute_basic__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Basic set :: EU Send Pipe Active */
#define kblgt3__compute_basic__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Basic set :: EU Thread Occupancy */
#define kblgt3__compute_basic__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Basic set :: Rasterized Pixels */
#define kblgt3__compute_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics Basic set :: Early Hi-Depth Test Fails */
#define kblgt3__compute_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics Basic set :: Early Depth Test Fails */
#define kblgt3__compute_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Samples Killed in FS */
#define kblgt3__compute_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics Basic set :: Pixels Failing Tests */
#define kblgt3__compute_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics Basic set :: Samples Written */
#define kblgt3__compute_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics Basic set :: Samples Blended */
#define kblgt3__compute_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics Basic set :: Sampler Texels */
#define kblgt3__compute_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Basic set :: Sampler Texels Misses */
#define kblgt3__compute_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Basic set :: SLM Bytes Read */
#define kblgt3__compute_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Basic set :: SLM Bytes Written */
#define kblgt3__compute_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Basic set :: Shader Memory Accesses */
#define kblgt3__compute_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Basic set :: Shader Atomic Memory Accesses */
#define kblgt3__compute_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Basic set :: L3 Shader Throughput */
#define kblgt3__compute_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Basic set :: Shader Barrier Messages */
#define kblgt3__compute_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Basic set :: Typed Bytes Read */
#define kblgt3__compute_basic__typed_bytes_read__read \
   bdw__compute_basic__typed_bytes_read__read

/* Compute Metrics Basic set :: Typed Bytes Written */
#define kblgt3__compute_basic__typed_bytes_written__read \
   bdw__compute_basic__typed_bytes_written__read

/* Compute Metrics Basic set :: Untyped Bytes Read */
#define kblgt3__compute_basic__untyped_bytes_read__read \
   bdw__compute_basic__untyped_bytes_read__read

/* Compute Metrics Basic set :: Untyped Writes */
#define kblgt3__compute_basic__untyped_bytes_written__read \
   bdw__compute_basic__untyped_bytes_written__read

/* Compute Metrics Basic set :: GTI Read Throughput */
#define kblgt3__compute_basic__gti_read_throughput__read \
   hsw__render_basic__gti_l3_throughput__read

/* Compute Metrics Basic set :: GTI Write Throughput */
#define kblgt3__compute_basic__gti_write_throughput__read \
   bdw__render_basic__gti_hdc_lookups_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Time Elapsed */
#define kblgt3__render_pipe_profile__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics set for 3D Pipeline Profile :: GPU Core Clocks */
#define kblgt3__render_pipe_profile__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define kblgt3__render_pipe_profile__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics set for 3D Pipeline Profile :: AVG GPU Core Frequency */
#define kblgt3__render_pipe_profile__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics set for 3D Pipeline Profile :: GPU Busy */
#define kblgt3__render_pipe_profile__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics set for 3D Pipeline Profile :: VS Threads Dispatched */
#define kblgt3__render_pipe_profile__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: HS Threads Dispatched */
#define kblgt3__render_pipe_profile__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: DS Threads Dispatched */
#define kblgt3__render_pipe_profile__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics set for 3D Pipeline Profile :: GS Threads Dispatched */
#define kblgt3__render_pipe_profile__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: FS Threads Dispatched */
#define kblgt3__render_pipe_profile__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics set for 3D Pipeline Profile :: CS Threads Dispatched */
#define kblgt3__render_pipe_profile__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics set for 3D Pipeline Profile :: EU Active */
#define kblgt3__render_pipe_profile__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics set for 3D Pipeline Profile :: EU Stall */
#define kblgt3__render_pipe_profile__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics set for 3D Pipeline Profile :: Rasterized Pixels */
#define kblgt3__render_pipe_profile__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics set for 3D Pipeline Profile :: Early Hi-Depth Test Fails */
#define kblgt3__render_pipe_profile__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Test Fails */
#define kblgt3__render_pipe_profile__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Killed in FS */
#define kblgt3__render_pipe_profile__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics set for 3D Pipeline Profile :: Pixels Failing Tests */
#define kblgt3__render_pipe_profile__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Written */
#define kblgt3__render_pipe_profile__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics set for 3D Pipeline Profile :: Samples Blended */
#define kblgt3__render_pipe_profile__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels */
#define kblgt3__render_pipe_profile__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics set for 3D Pipeline Profile :: Sampler Texels Misses */
#define kblgt3__render_pipe_profile__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Read */
#define kblgt3__render_pipe_profile__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics set for 3D Pipeline Profile :: SLM Bytes Written */
#define kblgt3__render_pipe_profile__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Memory Accesses */
#define kblgt3__render_pipe_profile__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Atomic Memory Accesses */
#define kblgt3__render_pipe_profile__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics set for 3D Pipeline Profile :: L3 Shader Throughput */
#define kblgt3__render_pipe_profile__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics set for 3D Pipeline Profile :: Shader Barrier Messages */
#define kblgt3__render_pipe_profile__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics set for 3D Pipeline Profile :: VF Bottleneck */
#define kblgt3__render_pipe_profile__vf_bottleneck__read \
   bdw__render_pipe_profile__vf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: VS Bottleneck */
#define kblgt3__render_pipe_profile__vs_bottleneck__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics set for 3D Pipeline Profile :: HS Bottleneck */
#define kblgt3__render_pipe_profile__hs_bottleneck__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics set for 3D Pipeline Profile :: DS Bottleneck */
#define kblgt3__render_pipe_profile__ds_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: GS Bottleneck */
#define kblgt3__render_pipe_profile__gs_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: SO Bottleneck */
#define kblgt3__render_pipe_profile__so_bottleneck__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Clipper Bottleneck */
#define kblgt3__render_pipe_profile__cl_bottleneck__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Strip-Fans Bottleneck */
#define kblgt3__render_pipe_profile__sf_bottleneck__read \
   bdw__render_pipe_profile__sf_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Hi-Depth Bottleneck */
#define kblgt3__render_pipe_profile__hi_depth_bottleneck__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: Early Depth Bottleneck */
#define kblgt3__render_pipe_profile__early_depth_bottleneck__read \
   bdw__render_pipe_profile__early_depth_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: BC Bottleneck */
#define kblgt3__render_pipe_profile__bc_bottleneck__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Render Metrics set for 3D Pipeline Profile :: HS Stall */
#define kblgt3__render_pipe_profile__hs_stall__read \
   bdw__render_pipe_profile__hs_stall__read

/* Render Metrics set for 3D Pipeline Profile :: DS Stall */
#define kblgt3__render_pipe_profile__ds_stall__read \
   bdw__render_pipe_profile__ds_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SO Stall */
#define kblgt3__render_pipe_profile__so_stall__read \
   bdw__render_pipe_profile__so_stall__read

/* Render Metrics set for 3D Pipeline Profile :: CL Stall */
#define kblgt3__render_pipe_profile__cl_stall__read \
   bdw__render_pipe_profile__cl_stall__read

/* Render Metrics set for 3D Pipeline Profile :: SF Stall */
#define kblgt3__render_pipe_profile__sf_stall__read \
   bdw__render_pipe_profile__sf_stall__read

/* Memory Reads Distribution metrics set :: GPU Time Elapsed */
#define kblgt3__memory_reads__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Reads Distribution metrics set :: GPU Core Clocks */
#define kblgt3__memory_reads__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define kblgt3__memory_reads__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Reads Distribution metrics set :: AVG GPU Core Frequency */
#define kblgt3__memory_reads__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Reads Distribution metrics set :: GPU Busy */
#define kblgt3__memory_reads__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Reads Distribution metrics set :: VS Threads Dispatched */
#define kblgt3__memory_reads__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: HS Threads Dispatched */
#define kblgt3__memory_reads__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Reads Distribution metrics set :: DS Threads Dispatched */
#define kblgt3__memory_reads__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Reads Distribution metrics set :: GS Threads Dispatched */
#define kblgt3__memory_reads__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Reads Distribution metrics set :: FS Threads Dispatched */
#define kblgt3__memory_reads__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Reads Distribution metrics set :: CS Threads Dispatched */
#define kblgt3__memory_reads__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Reads Distribution metrics set :: EU Active */
#define kblgt3__memory_reads__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Reads Distribution metrics set :: EU Stall */
#define kblgt3__memory_reads__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Reads Distribution metrics set :: Rasterized Pixels */
#define kblgt3__memory_reads__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Reads Distribution metrics set :: Early Hi-Depth Test Fails */
#define kblgt3__memory_reads__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Early Depth Test Fails */
#define kblgt3__memory_reads__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: Samples Killed in FS */
#define kblgt3__memory_reads__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Reads Distribution metrics set :: Pixels Failing Tests */
#define kblgt3__memory_reads__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Reads Distribution metrics set :: Samples Written */
#define kblgt3__memory_reads__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Reads Distribution metrics set :: Samples Blended */
#define kblgt3__memory_reads__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Reads Distribution metrics set :: Sampler Texels */
#define kblgt3__memory_reads__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Reads Distribution metrics set :: Sampler Texels Misses */
#define kblgt3__memory_reads__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Reads Distribution metrics set :: SLM Bytes Read */
#define kblgt3__memory_reads__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Reads Distribution metrics set :: SLM Bytes Written */
#define kblgt3__memory_reads__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Reads Distribution metrics set :: Shader Memory Accesses */
#define kblgt3__memory_reads__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Reads Distribution metrics set :: Shader Atomic Memory Accesses */
#define kblgt3__memory_reads__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Reads Distribution metrics set :: Shader Barrier Messages */
#define kblgt3__memory_reads__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Reads Distribution metrics set :: GtiCmdStreamerMemoryReads */
#define kblgt3__memory_reads__gti_cmd_streamer_memory_reads__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Reads Distribution metrics set :: GtiRsMemoryReads */
#define kblgt3__memory_reads__gti_rs_memory_reads__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Reads Distribution metrics set :: GtiVfMemoryReads */
#define kblgt3__memory_reads__gti_vf_memory_reads__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Memory Reads Distribution metrics set :: GtiRccMemoryReads */
#define kblgt3__memory_reads__gti_rcc_memory_reads__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiMscMemoryReads */
#define kblgt3__memory_reads__gti_msc_memory_reads__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Reads Distribution metrics set :: GtiHizMemoryReads */
#define kblgt3__memory_reads__gti_hiz_memory_reads__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiStcMemoryReads */
#define kblgt3__memory_reads__gti_stc_memory_reads__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Reads Distribution metrics set :: GtiRczMemoryReads */
#define kblgt3__memory_reads__gti_rcz_memory_reads__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Reads Distribution metrics set :: GtiMemoryReads */
#define kblgt3__memory_reads__gti_memory_reads__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank0Reads */
#define kblgt3__memory_reads__gti_l3_bank0_reads__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Reads Distribution metrics set :: GtiL3Bank1Reads */
#define kblgt3__memory_reads__gti_l3_bank1_reads__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Reads Distribution metrics set :: GtiL3Bank2Reads */
#define kblgt3__memory_reads__gti_l3_bank2_reads__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Reads Distribution metrics set :: GtiL3Bank3Reads */
#define kblgt3__memory_reads__gti_l3_bank3_reads__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Reads Distribution metrics set :: GtiL3Reads */
#define kblgt3__memory_reads__gti_l3_reads__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Reads Distribution metrics set :: GtiRingAccesses */
#define kblgt3__memory_reads__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Memory Writes Distribution metrics set :: GPU Time Elapsed */
#define kblgt3__memory_writes__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Memory Writes Distribution metrics set :: GPU Core Clocks */
#define kblgt3__memory_writes__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define kblgt3__memory_writes__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Memory Writes Distribution metrics set :: AVG GPU Core Frequency */
#define kblgt3__memory_writes__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Memory Writes Distribution metrics set :: GPU Busy */
#define kblgt3__memory_writes__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Memory Writes Distribution metrics set :: VS Threads Dispatched */
#define kblgt3__memory_writes__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: HS Threads Dispatched */
#define kblgt3__memory_writes__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Memory Writes Distribution metrics set :: DS Threads Dispatched */
#define kblgt3__memory_writes__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Memory Writes Distribution metrics set :: GS Threads Dispatched */
#define kblgt3__memory_writes__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Memory Writes Distribution metrics set :: FS Threads Dispatched */
#define kblgt3__memory_writes__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Memory Writes Distribution metrics set :: CS Threads Dispatched */
#define kblgt3__memory_writes__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Memory Writes Distribution metrics set :: EU Active */
#define kblgt3__memory_writes__eu_active__read \
   bdw__render_basic__eu_active__read

/* Memory Writes Distribution metrics set :: EU Stall */
#define kblgt3__memory_writes__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Memory Writes Distribution metrics set :: Rasterized Pixels */
#define kblgt3__memory_writes__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Memory Writes Distribution metrics set :: Early Hi-Depth Test Fails */
#define kblgt3__memory_writes__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Early Depth Test Fails */
#define kblgt3__memory_writes__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: Samples Killed in FS */
#define kblgt3__memory_writes__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Memory Writes Distribution metrics set :: Pixels Failing Tests */
#define kblgt3__memory_writes__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Memory Writes Distribution metrics set :: Samples Written */
#define kblgt3__memory_writes__samples_written__read \
   bdw__render_basic__samples_written__read

/* Memory Writes Distribution metrics set :: Samples Blended */
#define kblgt3__memory_writes__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Memory Writes Distribution metrics set :: Sampler Texels */
#define kblgt3__memory_writes__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Memory Writes Distribution metrics set :: Sampler Texels Misses */
#define kblgt3__memory_writes__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Memory Writes Distribution metrics set :: SLM Bytes Read */
#define kblgt3__memory_writes__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Memory Writes Distribution metrics set :: SLM Bytes Written */
#define kblgt3__memory_writes__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Memory Writes Distribution metrics set :: Shader Memory Accesses */
#define kblgt3__memory_writes__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Memory Writes Distribution metrics set :: Shader Atomic Memory Accesses */
#define kblgt3__memory_writes__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Memory Writes Distribution metrics set :: L3 Shader Throughput */
#define kblgt3__memory_writes__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Memory Writes Distribution metrics set :: Shader Barrier Messages */
#define kblgt3__memory_writes__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Memory Writes Distribution metrics set :: GtiCmdStreamerMemoryWrites */
#define kblgt3__memory_writes__gti_cmd_streamer_memory_writes__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Memory Writes Distribution metrics set :: GtiSoMemoryWrites */
#define kblgt3__memory_writes__gti_so_memory_writes__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Memory Writes Distribution metrics set :: GtiRccMemoryWrites */
#define kblgt3__memory_writes__gti_rcc_memory_writes__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiMscMemoryWrites */
#define kblgt3__memory_writes__gti_msc_memory_writes__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Memory Writes Distribution metrics set :: GtiHizMemoryWrites */
#define kblgt3__memory_writes__gti_hiz_memory_writes__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiStcMemoryWrites */
#define kblgt3__memory_writes__gti_stc_memory_writes__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Memory Writes Distribution metrics set :: GtiRczMemoryWrites */
#define kblgt3__memory_writes__gti_rcz_memory_writes__read \
   hsw__compute_extended__gpu_clocks__read

/* Memory Writes Distribution metrics set :: GtiMemoryWrites */
#define kblgt3__memory_writes__gti_memory_writes__read \
   hsw__compute_extended__typed_writes0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank0Writes */
#define kblgt3__memory_writes__gti_l3_bank0_writes__read \
   hsw__compute_extended__typed_atomics0__read

/* Memory Writes Distribution metrics set :: GtiL3Bank1Writes */
#define kblgt3__memory_writes__gti_l3_bank1_writes__read \
   hsw__memory_reads__gti_memory_reads__read

/* Memory Writes Distribution metrics set :: GtiL3Bank2Writes */
#define kblgt3__memory_writes__gti_l3_bank2_writes__read \
   hsw__memory_reads__llc_read_accesses__read

/* Memory Writes Distribution metrics set :: GtiL3Bank3Writes */
#define kblgt3__memory_writes__gti_l3_bank3_writes__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Memory Writes Distribution metrics set :: GtiL3Writes */
#define kblgt3__memory_writes__gti_l3_writes__read \
   bdw__memory_reads__gti_l3_reads__read

/* Memory Writes Distribution metrics set :: GtiRingAccesses */
#define kblgt3__memory_writes__gti_ring_accesses__read \
   bdw__memory_reads__gti_ring_accesses__read

/* Compute Metrics Extended set :: GPU Time Elapsed */
#define kblgt3__compute_extended__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extended set :: GPU Core Clocks */
#define kblgt3__compute_extended__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: AVG GPU Core Frequency */
#define kblgt3__compute_extended__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extended set :: AVG GPU Core Frequency */
#define kblgt3__compute_extended__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extended set :: CS Threads Dispatched */
#define kblgt3__compute_extended__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics Extended set :: EU Active */
#define kblgt3__compute_extended__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics Extended set :: EU Stall */
#define kblgt3__compute_extended__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extended set :: EU Both FPU Pipes Active */
#define kblgt3__compute_extended__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics Extended set :: EU FPU0 Pipe Active */
#define kblgt3__compute_extended__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics Extended set :: EU FPU1 Pipe Active */
#define kblgt3__compute_extended__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics Extended set :: EU AVG IPC Rate */
#define kblgt3__compute_extended__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics Extended set :: EU Send Pipe Active */
#define kblgt3__compute_extended__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics Extended set :: EU Thread Occupancy */
#define kblgt3__compute_extended__eu_thread_occupancy__read \
   bdw__compute_basic__eu_thread_occupancy__read

/* Compute Metrics Extended set :: Sampler Texels */
#define kblgt3__compute_extended__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics Extended set :: Sampler Texels Misses */
#define kblgt3__compute_extended__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics Extended set :: SLM Bytes Read */
#define kblgt3__compute_extended__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics Extended set :: SLM Bytes Written */
#define kblgt3__compute_extended__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics Extended set :: Shader Memory Accesses */
#define kblgt3__compute_extended__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics Extended set :: Shader Atomic Memory Accesses */
#define kblgt3__compute_extended__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics Extended set :: L3 Shader Throughput */
#define kblgt3__compute_extended__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics Extended set :: Shader Barrier Messages */
#define kblgt3__compute_extended__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics Extended set :: EuUntypedReads0 */
#define kblgt3__compute_extended__eu_untyped_reads0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* Compute Metrics Extended set :: EuTypedReads0 */
#define kblgt3__compute_extended__eu_typed_reads0__read \
   hsw__compute_extended__eu_typed_reads0__read

/* Compute Metrics Extended set :: EuUntypedWrites0 */
#define kblgt3__compute_extended__eu_untyped_writes0__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* Compute Metrics Extended set :: EuTypedWrites0 */
#define kblgt3__compute_extended__eu_typed_writes0__read \
   hsw__compute_extended__eu_typed_writes0__read

/* Compute Metrics Extended set :: EuUntypedAtomics0 */
#define kblgt3__compute_extended__eu_untyped_atomics0__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* Compute Metrics Extended set :: EuTypedAtomics0 */
#define kblgt3__compute_extended__eu_typed_atomics0__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* Compute Metrics Extended set :: EuA64UntypedReads0 */
#define kblgt3__compute_extended__eu_a64_untyped_reads0__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* Compute Metrics Extended set :: EuA64UntypedWrites0 */
#define kblgt3__compute_extended__eu_a64_untyped_writes0__read \
   hsw__compute_extended__gpu_clocks__read

/* Compute Metrics Extended set :: Typed Reads 0 */
#define kblgt3__compute_extended__typed_reads0__read \
   hsw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extended set :: Typed Writes 0 */
#define kblgt3__compute_extended__typed_writes0__read \
   hsw__compute_extended__typed_writes0__read

/* Compute Metrics Extended set :: Untyped Reads 0 */
#define kblgt3__compute_extended__untyped_reads0__read \
   hsw__compute_extended__untyped_reads0__read

/* Compute Metrics Extended set :: Untyped Writes 0 */
#define kblgt3__compute_extended__untyped_writes0__read \
   hsw__compute_extended__untyped_writes0__read

/* Compute Metrics Extended set :: Typed Atomics 0 */
#define kblgt3__compute_extended__typed_atomics0__read \
   hsw__compute_extended__typed_atomics0__read

/* Compute Metrics Extended set :: TypedReadsPerCacheLine */
#define kblgt3__compute_extended__typed_reads_per_cache_line__read \
   hsw__compute_extended__typed_reads_per_cache_line__read

/* Compute Metrics Extended set :: TypedWritesPerCacheLine */
#define kblgt3__compute_extended__typed_writes_per_cache_line__read \
   hsw__compute_extended__typed_writes_per_cache_line__read

/* Compute Metrics Extended set :: UntypedReadsPerCacheLine */
#define kblgt3__compute_extended__untyped_reads_per_cache_line__read \
   bdw__compute_extended__untyped_reads_per_cache_line__read

/* Compute Metrics Extended set :: UntypedWritesPerCacheLine */
#define kblgt3__compute_extended__untyped_writes_per_cache_line__read \
   bdw__compute_extended__untyped_writes_per_cache_line__read

/* Compute Metrics Extended set :: TypedAtomicsPerCacheLine */
#define kblgt3__compute_extended__typed_atomics_per_cache_line__read \
   hsw__compute_extended__typed_atomics_per_cache_line__read

/* Compute Metrics L3 Cache set :: GPU Time Elapsed */
#define kblgt3__compute_l3_cache__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics L3 Cache set :: GPU Core Clocks */
#define kblgt3__compute_l3_cache__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics L3 Cache set :: AVG GPU Core Frequency */
#define kblgt3__compute_l3_cache__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics L3 Cache set :: AVG GPU Core Frequency */
#define kblgt3__compute_l3_cache__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics L3 Cache set :: GPU Busy */
#define kblgt3__compute_l3_cache__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Compute Metrics L3 Cache set :: VS Threads Dispatched */
#define kblgt3__compute_l3_cache__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache set :: HS Threads Dispatched */
#define kblgt3__compute_l3_cache__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Compute Metrics L3 Cache set :: DS Threads Dispatched */
#define kblgt3__compute_l3_cache__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Compute Metrics L3 Cache set :: GS Threads Dispatched */
#define kblgt3__compute_l3_cache__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Compute Metrics L3 Cache set :: FS Threads Dispatched */
#define kblgt3__compute_l3_cache__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Compute Metrics L3 Cache set :: CS Threads Dispatched */
#define kblgt3__compute_l3_cache__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Compute Metrics L3 Cache set :: EU Active */
#define kblgt3__compute_l3_cache__eu_active__read \
   bdw__render_basic__eu_active__read

/* Compute Metrics L3 Cache set :: EU Stall */
#define kblgt3__compute_l3_cache__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics L3 Cache set :: EU Both FPU Pipes Active */
#define kblgt3__compute_l3_cache__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Pipe Active */
#define kblgt3__compute_l3_cache__fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Pipe Active */
#define kblgt3__compute_l3_cache__fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Compute Metrics L3 Cache set :: EU AVG IPC Rate */
#define kblgt3__compute_l3_cache__eu_avg_ipc_rate__read \
   bdw__compute_basic__eu_avg_ipc_rate__read

/* Compute Metrics L3 Cache set :: EU Send Pipe Active */
#define kblgt3__compute_l3_cache__eu_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Hybrid Instruction */
#define kblgt3__compute_l3_cache__eu_hybrid_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU1 Hybrid Instruction */
#define kblgt3__compute_l3_cache__eu_hybrid_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU0 Ternary Instruction */
#define kblgt3__compute_l3_cache__eu_ternary_fpu0_instruction__read \
   bdw__render_basic__ps_fpu0_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Ternary Instruction */
#define kblgt3__compute_l3_cache__eu_ternary_fpu1_instruction__read \
   bdw__render_basic__ps_fpu1_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Binary Instruction */
#define kblgt3__compute_l3_cache__eu_binary_fpu0_instruction__read \
   bdw__render_basic__ps_send_active__read

/* Compute Metrics L3 Cache set :: EU FPU1 Binary Instruction */
#define kblgt3__compute_l3_cache__eu_binary_fpu1_instruction__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Compute Metrics L3 Cache set :: EU FPU0 Move Instruction */
#define kblgt3__compute_l3_cache__eu_move_fpu0_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu0_instruction__read

/* Compute Metrics L3 Cache set :: EU FPU1 Move Instruction */
#define kblgt3__compute_l3_cache__eu_move_fpu1_instruction__read \
   bdw__compute_l3_cache__eu_move_fpu1_instruction__read

/* Compute Metrics L3 Cache set :: Rasterized Pixels */
#define kblgt3__compute_l3_cache__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Compute Metrics L3 Cache set :: Early Hi-Depth Test Fails */
#define kblgt3__compute_l3_cache__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Compute Metrics L3 Cache set :: Early Depth Test Fails */
#define kblgt3__compute_l3_cache__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache set :: Samples Killed in FS */
#define kblgt3__compute_l3_cache__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Compute Metrics L3 Cache set :: Pixels Failing Tests */
#define kblgt3__compute_l3_cache__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Compute Metrics L3 Cache set :: Samples Written */
#define kblgt3__compute_l3_cache__samples_written__read \
   bdw__render_basic__samples_written__read

/* Compute Metrics L3 Cache set :: Samples Blended */
#define kblgt3__compute_l3_cache__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Compute Metrics L3 Cache set :: Sampler Accesses */
#define kblgt3__compute_l3_cache__sampler_accesses__read \
   bdw__render_pipe_profile__sampler_accesses__read

/* Compute Metrics L3 Cache set :: Sampler Texels */
#define kblgt3__compute_l3_cache__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Compute Metrics L3 Cache set :: Sampler Texels Misses */
#define kblgt3__compute_l3_cache__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Compute Metrics L3 Cache set :: SLM Bytes Read */
#define kblgt3__compute_l3_cache__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Compute Metrics L3 Cache set :: SLM Bytes Written */
#define kblgt3__compute_l3_cache__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Compute Metrics L3 Cache set :: Shader Memory Accesses */
#define kblgt3__compute_l3_cache__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Compute Metrics L3 Cache set :: Shader Atomic Memory Accesses */
#define kblgt3__compute_l3_cache__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Compute Metrics L3 Cache set :: L3 Accesses */
#define kblgt3__compute_l3_cache__l3_accesses__read \
   sklgt2__compute_l3_cache__l3_accesses__read

/* Compute Metrics L3 Cache set :: L3 Misses */
#define kblgt3__compute_l3_cache__l3_misses__read \
   bdw__compute_l3_cache__l3_misses__read

/* Compute Metrics L3 Cache set :: L3 Sampler Throughput */
#define kblgt3__compute_l3_cache__l3_sampler_throughput__read \
   chv__render_basic__l3_sampler_throughput__read

/* Compute Metrics L3 Cache set :: L3 Shader Throughput */
#define kblgt3__compute_l3_cache__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Compute Metrics L3 Cache set :: L3 Total Throughput */
#define kblgt3__compute_l3_cache__l3_total_throughput__read \
   sklgt2__compute_l3_cache__l3_total_throughput__read

/* Compute Metrics L3 Cache set :: Shader Barrier Messages */
#define kblgt3__compute_l3_cache__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 Accesses */
#define kblgt3__compute_l3_cache__l3_bank00_accesses__read \
   bdw__compute_l3_cache__l3_bank00_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 01 Accesses */
#define kblgt3__compute_l3_cache__l3_bank01_accesses__read \
   bdw__compute_l3_cache__l3_bank01_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 02 Accesses */
#define kblgt3__compute_l3_cache__l3_bank02_accesses__read \
   bdw__compute_l3_cache__l3_bank02_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 03 Accesses */
#define kblgt3__compute_l3_cache__l3_bank03_accesses__read \
   bdw__compute_l3_cache__l3_bank03_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 IC Accesses */
#define kblgt3__compute_l3_cache__l3_bank00_ic_accesses__read \
   bdw__compute_l3_cache__l3_bank00_ic_accesses__read

/* Compute Metrics L3 Cache set :: L3 Bank 00 IC Hits */
#define kblgt3__compute_l3_cache__l3_bank00_ic_hits__read \
   bdw__compute_l3_cache__l3_bank00_ic_hits__read

/* Compute Metrics L3 Cache set :: GTI L3 Throughput */
#define kblgt3__compute_l3_cache__gti_l3_throughput__read \
   bdw__compute_l3_cache__gti_l3_throughput__read

/* Compute Metrics L3 Cache set :: GTI Read Throughput */
#define kblgt3__compute_l3_cache__gti_read_throughput__read \
   bdw__render_basic__gti_read_throughput__read

/* Compute Metrics L3 Cache set :: GTI Write Throughput */
#define kblgt3__compute_l3_cache__gti_write_throughput__read \
   hsw__render_basic__gti_write_throughput__read

/* Metric set HDCAndSF :: GPU Time Elapsed */
#define kblgt3__hdc_and_sf__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set HDCAndSF :: GPU Core Clocks */
#define kblgt3__hdc_and_sf__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define kblgt3__hdc_and_sf__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
#define kblgt3__hdc_and_sf__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set HDCAndSF :: GPU Busy */
#define kblgt3__hdc_and_sf__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set HDCAndSF :: VS Threads Dispatched */
#define kblgt3__hdc_and_sf__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: HS Threads Dispatched */
#define kblgt3__hdc_and_sf__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set HDCAndSF :: DS Threads Dispatched */
#define kblgt3__hdc_and_sf__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set HDCAndSF :: GS Threads Dispatched */
#define kblgt3__hdc_and_sf__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set HDCAndSF :: FS Threads Dispatched */
#define kblgt3__hdc_and_sf__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set HDCAndSF :: CS Threads Dispatched */
#define kblgt3__hdc_and_sf__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set HDCAndSF :: EU Active */
#define kblgt3__hdc_and_sf__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set HDCAndSF :: EU Stall */
#define kblgt3__hdc_and_sf__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
#define kblgt3__hdc_and_sf__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
#define kblgt3__hdc_and_sf__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
#define kblgt3__hdc_and_sf__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set HDCAndSF :: VS Send Pipe Active */
#define kblgt3__hdc_and_sf__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
#define kblgt3__hdc_and_sf__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
#define kblgt3__hdc_and_sf__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set HDCAndSF :: PS Send Pipeline Active */
#define kblgt3__hdc_and_sf__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set HDCAndSF :: FS Both FPU Active */
#define kblgt3__hdc_and_sf__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set HDCAndSF :: Rasterized Pixels */
#define kblgt3__hdc_and_sf__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
#define kblgt3__hdc_and_sf__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set HDCAndSF :: Early Depth Test Fails */
#define kblgt3__hdc_and_sf__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Samples Killed in FS */
#define kblgt3__hdc_and_sf__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set HDCAndSF :: Pixels Failing Tests */
#define kblgt3__hdc_and_sf__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set HDCAndSF :: Samples Written */
#define kblgt3__hdc_and_sf__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set HDCAndSF :: Samples Blended */
#define kblgt3__hdc_and_sf__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set HDCAndSF :: Sampler Texels */
#define kblgt3__hdc_and_sf__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set HDCAndSF :: Sampler Texels Misses */
#define kblgt3__hdc_and_sf__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set HDCAndSF :: SLM Bytes Read */
#define kblgt3__hdc_and_sf__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set HDCAndSF :: SLM Bytes Written */
#define kblgt3__hdc_and_sf__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set HDCAndSF :: Shader Memory Accesses */
#define kblgt3__hdc_and_sf__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
#define kblgt3__hdc_and_sf__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set HDCAndSF :: L3 Shader Throughput */
#define kblgt3__hdc_and_sf__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set HDCAndSF :: Shader Barrier Messages */
#define kblgt3__hdc_and_sf__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set HDCAndSF :: Polygon Data Ready */
#define kblgt3__hdc_and_sf__poly_data_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
#define kblgt3__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
#define kblgt3__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
#define kblgt3__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read \
   bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read

/* Metric set HDCAndSF :: SQ is full */
#define kblgt3__hdc_and_sf__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_1 :: GPU Time Elapsed */
#define kblgt3__l3_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_1 :: GPU Core Clocks */
#define kblgt3__l3_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define kblgt3__l3_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_1 :: AVG GPU Core Frequency */
#define kblgt3__l3_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_1 :: GPU Busy */
#define kblgt3__l3_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_1 :: VS Threads Dispatched */
#define kblgt3__l3_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_1 :: HS Threads Dispatched */
#define kblgt3__l3_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_1 :: DS Threads Dispatched */
#define kblgt3__l3_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_1 :: GS Threads Dispatched */
#define kblgt3__l3_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_1 :: FS Threads Dispatched */
#define kblgt3__l3_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_1 :: CS Threads Dispatched */
#define kblgt3__l3_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_1 :: EU Active */
#define kblgt3__l3_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_1 :: EU Stall */
#define kblgt3__l3_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_1 :: EU Both FPU Pipes Active */
#define kblgt3__l3_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_1 :: VS FPU0 Pipe Active */
#define kblgt3__l3_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_1 :: VS FPU1 Pipe Active */
#define kblgt3__l3_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_1 :: VS Send Pipe Active */
#define kblgt3__l3_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_1 :: PS FPU0 Pipe Active */
#define kblgt3__l3_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_1 :: PS FPU1 Pipe Active */
#define kblgt3__l3_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_1 :: PS Send Pipeline Active */
#define kblgt3__l3_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_1 :: FS Both FPU Active */
#define kblgt3__l3_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_1 :: Rasterized Pixels */
#define kblgt3__l3_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
#define kblgt3__l3_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_1 :: Early Depth Test Fails */
#define kblgt3__l3_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Samples Killed in FS */
#define kblgt3__l3_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_1 :: Pixels Failing Tests */
#define kblgt3__l3_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_1 :: Samples Written */
#define kblgt3__l3_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_1 :: Samples Blended */
#define kblgt3__l3_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_1 :: Sampler Texels */
#define kblgt3__l3_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_1 :: Sampler Texels Misses */
#define kblgt3__l3_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_1 :: SLM Bytes Read */
#define kblgt3__l3_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_1 :: SLM Bytes Written */
#define kblgt3__l3_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_1 :: Shader Memory Accesses */
#define kblgt3__l3_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
#define kblgt3__l3_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_1 :: L3 Shader Throughput */
#define kblgt3__l3_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_1 :: Shader Barrier Messages */
#define kblgt3__l3_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Stalled */
#define kblgt3__l3_1__l30_bank0_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Stalled */
#define kblgt3__l3_1__l30_bank1_stalled__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank1 Active */
#define kblgt3__l3_1__l30_bank1_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_1 :: Slice0 L3 Bank0 Active */
#define kblgt3__l3_1__l30_bank0_active__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set L3_1 :: SQ is full */
#define kblgt3__l3_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_2 :: GPU Time Elapsed */
#define kblgt3__l3_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_2 :: GPU Core Clocks */
#define kblgt3__l3_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define kblgt3__l3_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_2 :: AVG GPU Core Frequency */
#define kblgt3__l3_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_2 :: GPU Busy */
#define kblgt3__l3_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_2 :: VS Threads Dispatched */
#define kblgt3__l3_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_2 :: HS Threads Dispatched */
#define kblgt3__l3_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_2 :: DS Threads Dispatched */
#define kblgt3__l3_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_2 :: GS Threads Dispatched */
#define kblgt3__l3_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_2 :: FS Threads Dispatched */
#define kblgt3__l3_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_2 :: CS Threads Dispatched */
#define kblgt3__l3_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_2 :: EU Active */
#define kblgt3__l3_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_2 :: EU Stall */
#define kblgt3__l3_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_2 :: EU Both FPU Pipes Active */
#define kblgt3__l3_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_2 :: VS FPU0 Pipe Active */
#define kblgt3__l3_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_2 :: VS FPU1 Pipe Active */
#define kblgt3__l3_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_2 :: VS Send Pipe Active */
#define kblgt3__l3_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_2 :: PS FPU0 Pipe Active */
#define kblgt3__l3_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_2 :: PS FPU1 Pipe Active */
#define kblgt3__l3_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_2 :: PS Send Pipeline Active */
#define kblgt3__l3_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_2 :: FS Both FPU Active */
#define kblgt3__l3_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_2 :: Rasterized Pixels */
#define kblgt3__l3_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
#define kblgt3__l3_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_2 :: Early Depth Test Fails */
#define kblgt3__l3_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Samples Killed in FS */
#define kblgt3__l3_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_2 :: Pixels Failing Tests */
#define kblgt3__l3_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_2 :: Samples Written */
#define kblgt3__l3_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_2 :: Samples Blended */
#define kblgt3__l3_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_2 :: Sampler Texels */
#define kblgt3__l3_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_2 :: Sampler Texels Misses */
#define kblgt3__l3_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_2 :: SLM Bytes Read */
#define kblgt3__l3_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_2 :: SLM Bytes Written */
#define kblgt3__l3_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_2 :: Shader Memory Accesses */
#define kblgt3__l3_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
#define kblgt3__l3_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_2 :: L3 Shader Throughput */
#define kblgt3__l3_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_2 :: Shader Barrier Messages */
#define kblgt3__l3_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Stalled */
#define kblgt3__l3_2__l30_bank2_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_2 :: Slice0 L3 Bank2 Active */
#define kblgt3__l3_2__l30_bank2_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_2 :: SQ is full */
#define kblgt3__l3_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set L3_3 :: GPU Time Elapsed */
#define kblgt3__l3_3__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set L3_3 :: GPU Core Clocks */
#define kblgt3__l3_3__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define kblgt3__l3_3__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set L3_3 :: AVG GPU Core Frequency */
#define kblgt3__l3_3__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set L3_3 :: GPU Busy */
#define kblgt3__l3_3__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set L3_3 :: VS Threads Dispatched */
#define kblgt3__l3_3__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set L3_3 :: HS Threads Dispatched */
#define kblgt3__l3_3__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set L3_3 :: DS Threads Dispatched */
#define kblgt3__l3_3__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set L3_3 :: GS Threads Dispatched */
#define kblgt3__l3_3__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set L3_3 :: FS Threads Dispatched */
#define kblgt3__l3_3__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set L3_3 :: CS Threads Dispatched */
#define kblgt3__l3_3__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set L3_3 :: EU Active */
#define kblgt3__l3_3__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set L3_3 :: EU Stall */
#define kblgt3__l3_3__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set L3_3 :: EU Both FPU Pipes Active */
#define kblgt3__l3_3__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set L3_3 :: VS FPU0 Pipe Active */
#define kblgt3__l3_3__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set L3_3 :: VS FPU1 Pipe Active */
#define kblgt3__l3_3__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set L3_3 :: VS Send Pipe Active */
#define kblgt3__l3_3__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set L3_3 :: PS FPU0 Pipe Active */
#define kblgt3__l3_3__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set L3_3 :: PS FPU1 Pipe Active */
#define kblgt3__l3_3__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set L3_3 :: PS Send Pipeline Active */
#define kblgt3__l3_3__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set L3_3 :: FS Both FPU Active */
#define kblgt3__l3_3__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set L3_3 :: Rasterized Pixels */
#define kblgt3__l3_3__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
#define kblgt3__l3_3__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set L3_3 :: Early Depth Test Fails */
#define kblgt3__l3_3__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Samples Killed in FS */
#define kblgt3__l3_3__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set L3_3 :: Pixels Failing Tests */
#define kblgt3__l3_3__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set L3_3 :: Samples Written */
#define kblgt3__l3_3__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set L3_3 :: Samples Blended */
#define kblgt3__l3_3__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set L3_3 :: Sampler Texels */
#define kblgt3__l3_3__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set L3_3 :: Sampler Texels Misses */
#define kblgt3__l3_3__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set L3_3 :: SLM Bytes Read */
#define kblgt3__l3_3__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set L3_3 :: SLM Bytes Written */
#define kblgt3__l3_3__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set L3_3 :: Shader Memory Accesses */
#define kblgt3__l3_3__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
#define kblgt3__l3_3__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set L3_3 :: L3 Shader Throughput */
#define kblgt3__l3_3__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set L3_3 :: Shader Barrier Messages */
#define kblgt3__l3_3__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
#define kblgt3__l3_3__l30_bank3_stalled__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
#define kblgt3__l3_3__l30_bank3_active__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set L3_3 :: SQ is full */
#define kblgt3__l3_3__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
#define kblgt3__rasterizer_and_pixel_backend__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
#define kblgt3__rasterizer_and_pixel_backend__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define kblgt3__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
#define kblgt3__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
#define kblgt3__rasterizer_and_pixel_backend__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
#define kblgt3__rasterizer_and_pixel_backend__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
#define kblgt3__rasterizer_and_pixel_backend__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
#define kblgt3__rasterizer_and_pixel_backend__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
#define kblgt3__rasterizer_and_pixel_backend__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
#define kblgt3__rasterizer_and_pixel_backend__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
#define kblgt3__rasterizer_and_pixel_backend__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set RasterizerAndPixelBackend :: EU Active */
#define kblgt3__rasterizer_and_pixel_backend__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set RasterizerAndPixelBackend :: EU Stall */
#define kblgt3__rasterizer_and_pixel_backend__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
#define kblgt3__rasterizer_and_pixel_backend__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
#define kblgt3__rasterizer_and_pixel_backend__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
#define kblgt3__rasterizer_and_pixel_backend__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
#define kblgt3__rasterizer_and_pixel_backend__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
#define kblgt3__rasterizer_and_pixel_backend__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
#define kblgt3__rasterizer_and_pixel_backend__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
#define kblgt3__rasterizer_and_pixel_backend__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
#define kblgt3__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
#define kblgt3__rasterizer_and_pixel_backend__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
#define kblgt3__rasterizer_and_pixel_backend__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
#define kblgt3__rasterizer_and_pixel_backend__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
#define kblgt3__rasterizer_and_pixel_backend__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
#define kblgt3__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set RasterizerAndPixelBackend :: Samples Written */
#define kblgt3__rasterizer_and_pixel_backend__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
#define kblgt3__rasterizer_and_pixel_backend__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
#define kblgt3__rasterizer_and_pixel_backend__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
#define kblgt3__rasterizer_and_pixel_backend__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
#define kblgt3__rasterizer_and_pixel_backend__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
#define kblgt3__rasterizer_and_pixel_backend__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
#define kblgt3__rasterizer_and_pixel_backend__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
#define kblgt3__rasterizer_and_pixel_backend__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
#define kblgt3__rasterizer_and_pixel_backend__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
#define kblgt3__rasterizer_and_pixel_backend__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
#define kblgt3__rasterizer_and_pixel_backend__pixel_data0_ready__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
#define kblgt3__rasterizer_and_pixel_backend__rasterizer0_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
#define kblgt3__rasterizer_and_pixel_backend__ps_output0_available__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
#define kblgt3__rasterizer_and_pixel_backend__pixel_values0_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
#define kblgt3__rasterizer_and_pixel_backend__rasterizer0_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set RasterizerAndPixelBackend :: SQ is full */
#define kblgt3__rasterizer_and_pixel_backend__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set Sampler :: GPU Time Elapsed */
#define kblgt3__sampler__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set Sampler :: GPU Core Clocks */
#define kblgt3__sampler__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define kblgt3__sampler__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set Sampler :: AVG GPU Core Frequency */
#define kblgt3__sampler__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set Sampler :: GPU Busy */
#define kblgt3__sampler__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set Sampler :: VS Threads Dispatched */
#define kblgt3__sampler__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set Sampler :: HS Threads Dispatched */
#define kblgt3__sampler__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set Sampler :: DS Threads Dispatched */
#define kblgt3__sampler__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set Sampler :: GS Threads Dispatched */
#define kblgt3__sampler__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set Sampler :: FS Threads Dispatched */
#define kblgt3__sampler__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set Sampler :: CS Threads Dispatched */
#define kblgt3__sampler__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set Sampler :: EU Active */
#define kblgt3__sampler__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set Sampler :: EU Stall */
#define kblgt3__sampler__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set Sampler :: EU Both FPU Pipes Active */
#define kblgt3__sampler__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set Sampler :: VS FPU0 Pipe Active */
#define kblgt3__sampler__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set Sampler :: VS FPU1 Pipe Active */
#define kblgt3__sampler__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set Sampler :: VS Send Pipe Active */
#define kblgt3__sampler__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set Sampler :: PS FPU0 Pipe Active */
#define kblgt3__sampler__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set Sampler :: PS FPU1 Pipe Active */
#define kblgt3__sampler__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set Sampler :: PS Send Pipeline Active */
#define kblgt3__sampler__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set Sampler :: FS Both FPU Active */
#define kblgt3__sampler__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set Sampler :: Rasterized Pixels */
#define kblgt3__sampler__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set Sampler :: Early Hi-Depth Test Fails */
#define kblgt3__sampler__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set Sampler :: Early Depth Test Fails */
#define kblgt3__sampler__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Samples Killed in FS */
#define kblgt3__sampler__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set Sampler :: Pixels Failing Tests */
#define kblgt3__sampler__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set Sampler :: Samples Written */
#define kblgt3__sampler__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set Sampler :: Samples Blended */
#define kblgt3__sampler__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set Sampler :: Sampler Texels */
#define kblgt3__sampler__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set Sampler :: Sampler Texels Misses */
#define kblgt3__sampler__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set Sampler :: SLM Bytes Read */
#define kblgt3__sampler__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set Sampler :: SLM Bytes Written */
#define kblgt3__sampler__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set Sampler :: Shader Memory Accesses */
#define kblgt3__sampler__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set Sampler :: Shader Atomic Memory Accesses */
#define kblgt3__sampler__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set Sampler :: L3 Shader Throughput */
#define kblgt3__sampler__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set Sampler :: Shader Barrier Messages */
#define kblgt3__sampler__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set Sampler :: Slice0 Subslice1 Input Available */
#define kblgt3__sampler__sampler01_input_available__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set Sampler :: Slice0 Subslice2 Input Available */
#define kblgt3__sampler__sampler02_input_available__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set Sampler :: Slice0 Subslice0 Input Available */
#define kblgt3__sampler__sampler00_input_available__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice2 Sampler Output Ready */
#define kblgt3__sampler__sampler02_output_ready__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice0 Sampler Output Ready */
#define kblgt3__sampler__sampler00_output_ready__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set Sampler :: Slice0 Subslice1 Sampler Output Ready */
#define kblgt3__sampler__sampler01_output_ready__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set Sampler :: SQ is full */
#define kblgt3__sampler__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_1 :: GPU Time Elapsed */
#define kblgt3__tdl_1__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_1 :: GPU Core Clocks */
#define kblgt3__tdl_1__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define kblgt3__tdl_1__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_1 :: AVG GPU Core Frequency */
#define kblgt3__tdl_1__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_1 :: GPU Busy */
#define kblgt3__tdl_1__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_1 :: VS Threads Dispatched */
#define kblgt3__tdl_1__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_1 :: HS Threads Dispatched */
#define kblgt3__tdl_1__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_1 :: DS Threads Dispatched */
#define kblgt3__tdl_1__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_1 :: GS Threads Dispatched */
#define kblgt3__tdl_1__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_1 :: FS Threads Dispatched */
#define kblgt3__tdl_1__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_1 :: CS Threads Dispatched */
#define kblgt3__tdl_1__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_1 :: EU Active */
#define kblgt3__tdl_1__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_1 :: EU Stall */
#define kblgt3__tdl_1__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
#define kblgt3__tdl_1__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
#define kblgt3__tdl_1__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
#define kblgt3__tdl_1__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_1 :: VS Send Pipe Active */
#define kblgt3__tdl_1__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
#define kblgt3__tdl_1__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
#define kblgt3__tdl_1__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_1 :: PS Send Pipeline Active */
#define kblgt3__tdl_1__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_1 :: FS Both FPU Active */
#define kblgt3__tdl_1__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_1 :: Rasterized Pixels */
#define kblgt3__tdl_1__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
#define kblgt3__tdl_1__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_1 :: Early Depth Test Fails */
#define kblgt3__tdl_1__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: Samples Killed in FS */
#define kblgt3__tdl_1__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_1 :: Pixels Failing Tests */
#define kblgt3__tdl_1__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_1 :: Samples Written */
#define kblgt3__tdl_1__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_1 :: Samples Blended */
#define kblgt3__tdl_1__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_1 :: Sampler Texels */
#define kblgt3__tdl_1__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_1 :: Sampler Texels Misses */
#define kblgt3__tdl_1__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_1 :: SLM Bytes Read */
#define kblgt3__tdl_1__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_1 :: SLM Bytes Written */
#define kblgt3__tdl_1__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_1 :: Shader Memory Accesses */
#define kblgt3__tdl_1__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
#define kblgt3__tdl_1__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_1 :: L3 Shader Throughput */
#define kblgt3__tdl_1__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_1 :: Shader Barrier Messages */
#define kblgt3__tdl_1__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
#define kblgt3__tdl_1__non_ps_thread01_ready_for_dispatch__read \
   bdw__render_basic__sampler0_busy__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice0 */
#define kblgt3__tdl_1__ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler1_busy__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
#define kblgt3__tdl_1__non_ps_thread00_ready_for_dispatch__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice2 */
#define kblgt3__tdl_1__ps_thread02_ready_for_dispatch__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
#define kblgt3__tdl_1__non_ps_thread02_ready_for_dispatch__read \
   bdw__render_pipe_profile__so_bottleneck__read

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice1 */
#define kblgt3__tdl_1__ps_thread01_ready_for_dispatch__read \
   bdw__render_pipe_profile__cl_bottleneck__read

/* Metric set TDL_1 :: SQ is full */
#define kblgt3__tdl_1__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Metric set TDL_2 :: GPU Time Elapsed */
#define kblgt3__tdl_2__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set TDL_2 :: GPU Core Clocks */
#define kblgt3__tdl_2__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define kblgt3__tdl_2__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set TDL_2 :: AVG GPU Core Frequency */
#define kblgt3__tdl_2__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set TDL_2 :: GPU Busy */
#define kblgt3__tdl_2__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Metric set TDL_2 :: VS Threads Dispatched */
#define kblgt3__tdl_2__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Metric set TDL_2 :: HS Threads Dispatched */
#define kblgt3__tdl_2__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Metric set TDL_2 :: DS Threads Dispatched */
#define kblgt3__tdl_2__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Metric set TDL_2 :: GS Threads Dispatched */
#define kblgt3__tdl_2__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Metric set TDL_2 :: FS Threads Dispatched */
#define kblgt3__tdl_2__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Metric set TDL_2 :: CS Threads Dispatched */
#define kblgt3__tdl_2__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Metric set TDL_2 :: EU Active */
#define kblgt3__tdl_2__eu_active__read \
   bdw__render_basic__eu_active__read

/* Metric set TDL_2 :: EU Stall */
#define kblgt3__tdl_2__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
#define kblgt3__tdl_2__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
#define kblgt3__tdl_2__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
#define kblgt3__tdl_2__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Metric set TDL_2 :: VS Send Pipe Active */
#define kblgt3__tdl_2__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
#define kblgt3__tdl_2__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
#define kblgt3__tdl_2__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Metric set TDL_2 :: PS Send Pipeline Active */
#define kblgt3__tdl_2__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Metric set TDL_2 :: FS Both FPU Active */
#define kblgt3__tdl_2__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Metric set TDL_2 :: Rasterized Pixels */
#define kblgt3__tdl_2__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
#define kblgt3__tdl_2__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Metric set TDL_2 :: Early Depth Test Fails */
#define kblgt3__tdl_2__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Samples Killed in FS */
#define kblgt3__tdl_2__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Metric set TDL_2 :: Pixels Failing Tests */
#define kblgt3__tdl_2__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Metric set TDL_2 :: Samples Written */
#define kblgt3__tdl_2__samples_written__read \
   bdw__render_basic__samples_written__read

/* Metric set TDL_2 :: Samples Blended */
#define kblgt3__tdl_2__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Metric set TDL_2 :: Sampler Texels */
#define kblgt3__tdl_2__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Metric set TDL_2 :: Sampler Texels Misses */
#define kblgt3__tdl_2__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Metric set TDL_2 :: SLM Bytes Read */
#define kblgt3__tdl_2__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Metric set TDL_2 :: SLM Bytes Written */
#define kblgt3__tdl_2__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Metric set TDL_2 :: Shader Memory Accesses */
#define kblgt3__tdl_2__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
#define kblgt3__tdl_2__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Metric set TDL_2 :: L3 Shader Throughput */
#define kblgt3__tdl_2__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Metric set TDL_2 :: Shader Barrier Messages */
#define kblgt3__tdl_2__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 0 */
#define kblgt3__tdl_2__thread_header01_ready_port0__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 1 */
#define kblgt3__tdl_2__thread_header00_ready_port1__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 0 */
#define kblgt3__tdl_2__thread_header00_ready_port0__read \
   bdw__render_pipe_profile__sf_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 1 */
#define kblgt3__tdl_2__thread_header02_ready_port1__read \
   bdw__render_pipe_profile__cl_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 0 */
#define kblgt3__tdl_2__thread_header02_ready_port0__read \
   bdw__render_pipe_profile__so_stall__read

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 1 */
#define kblgt3__tdl_2__thread_header01_ready_port1__read \
   bdw__render_pipe_profile__ds_stall__read

/* Metric set TDL_2 :: SQ is full */
#define kblgt3__tdl_2__gt_request_queue_full__read \
   bdw__hdc_and_sf__gt_request_queue_full__read

/* Compute Metrics Extra set :: GPU Time Elapsed */
#define kblgt3__compute_extra__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Compute Metrics Extra set :: GPU Core Clocks */
#define kblgt3__compute_extra__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define kblgt3__compute_extra__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Compute Metrics Extra set :: AVG GPU Core Frequency */
#define kblgt3__compute_extra__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Compute Metrics Extra set :: EU FPU1 Pipe Active */
#define kblgt3__compute_extra__fpu1_active__read \
   bdw__render_basic__eu_stall__read

/* Compute Metrics Extra set :: EU FPU1 Pipe Active including Ext Math */
#define kblgt3__compute_extra__fpu1_active_adjusted__read \
   bdw__compute_extra__fpu1_active_adjusted__read

/* Media Vme Pipe metrics set :: GPU Time Elapsed */
#define kblgt3__vme_pipe__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Media Vme Pipe metrics set :: GPU Core Clocks */
#define kblgt3__vme_pipe__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define kblgt3__vme_pipe__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Media Vme Pipe metrics set :: AVG GPU Core Frequency */
#define kblgt3__vme_pipe__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Media Vme Pipe metrics set :: GPU Busy */
#define kblgt3__vme_pipe__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Media Vme Pipe metrics set :: CS Threads Dispatched */
#define kblgt3__vme_pipe__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Media Vme Pipe metrics set :: EU Active */
#define kblgt3__vme_pipe__eu_active__read \
   bdw__render_basic__eu_active__read

/* Media Vme Pipe metrics set :: EU Stall */
#define kblgt3__vme_pipe__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Media Vme Pipe metrics set :: EU Both FPU Pipes Active */
#define kblgt3__vme_pipe__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Media Vme Pipe metrics set :: EU Thread Occupancy */
#define kblgt3__vme_pipe__eu_thread_occupancy__read \
   bdw__vme_pipe__eu_thread_occupancy__read

/* Media Vme Pipe metrics set :: VME Busy */
#define kblgt3__vme_pipe__vme_busy__read \
   bdw__vme_pipe__vme_busy__read

/* Gpu Rings Busyness :: GPU Time Elapsed */
#define kblgt3__gpu_busyness__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Gpu Rings Busyness :: GPU Core Clocks */
#define kblgt3__gpu_busyness__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define kblgt3__gpu_busyness__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Gpu Rings Busyness :: AVG GPU Core Frequency */
#define kblgt3__gpu_busyness__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Gpu Rings Busyness :: Render Ring Busy */
#define kblgt3__gpu_busyness__render_busy__read \
   bdw__render_pipe_profile__bc_bottleneck__read

/* Gpu Rings Busyness :: Vdbox0 Ring Busy */
#define kblgt3__gpu_busyness__vdbox0_busy__read \
   bdw__render_pipe_profile__hi_depth_bottleneck__read

/* Gpu Rings Busyness :: Vdbox1 Ring Busy */
#define kblgt3__gpu_busyness__vdbox1_busy__read \
   bdw__render_pipe_profile__sf_stall__read

/* Gpu Rings Busyness :: Vebox Ring Busy */
#define kblgt3__gpu_busyness__vebox_busy__read \
   bdw__render_pipe_profile__cl_stall__read

/* Gpu Rings Busyness :: Blitter Ring Busy */
#define kblgt3__gpu_busyness__blitter_busy__read \
   bdw__render_pipe_profile__so_stall__read

/* Gpu Rings Busyness :: AnyRingBusy */
#define kblgt3__gpu_busyness__any_ring_busy__read \
   bdw__render_basic__sampler0_busy__read

/* MDAPI testing set :: GPU Time Elapsed */
#define kblgt3__test_oa__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* MDAPI testing set :: GPU Core Clocks */
#define kblgt3__test_oa__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define kblgt3__test_oa__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* MDAPI testing set :: AVG GPU Core Frequency */
#define kblgt3__test_oa__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* MDAPI testing set :: TestCounter0 */
#define kblgt3__test_oa__counter0__read \
   hsw__compute_extended__eu_untyped_reads0__read

/* MDAPI testing set :: TestCounter1 */
#define kblgt3__test_oa__counter1__read \
   hsw__compute_extended__eu_untyped_writes0__read

/* MDAPI testing set :: TestCounter2 */
#define kblgt3__test_oa__counter2__read \
   hsw__compute_extended__eu_typed_reads0__read

/* MDAPI testing set :: TestCounter3 */
#define kblgt3__test_oa__counter3__read \
   hsw__compute_extended__eu_typed_writes0__read

/* MDAPI testing set :: TestCounter4 */
#define kblgt3__test_oa__counter4__read \
   hsw__compute_extended__eu_untyped_atomics0__read

/* MDAPI testing set :: TestCounter5 */
#define kblgt3__test_oa__counter5__read \
   hsw__compute_extended__eu_typed_atomics0__read

/* MDAPI testing set :: TestCounter6 */
#define kblgt3__test_oa__counter6__read \
   hsw__compute_extended__eu_urb_atomics0__read

/* MDAPI testing set :: TestCounter7 */
#define kblgt3__test_oa__counter7__read \
   hsw__compute_extended__gpu_clocks__read

/* MDAPI testing set :: TestCounter8 */
#define kblgt3__test_oa__counter8__read \
   hsw__memory_reads__gpu_core_clocks__read

/* Metric set PMA Stall :: GPU Time Elapsed */
#define kblgt3__pma__stall__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Metric set PMA Stall :: GPU Core Clocks */
#define kblgt3__pma__stall__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define kblgt3__pma__stall__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Metric set PMA Stall :: AVG GPU Core Frequency */
#define kblgt3__pma__stall__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Metric set PMA Stall :: STC PMA stall */
#define kblgt3__pma__stall__stc_pma_stall__read \
   sklgt2__pma__stall__stc_pma_stall__read

/* AsyncCompute :: GPU Time Elapsed */
#define kblgt3__async_compute__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* AsyncCompute :: GPU Core Clocks */
#define kblgt3__async_compute__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define kblgt3__async_compute__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* AsyncCompute :: AVG GPU Core Frequency */
#define kblgt3__async_compute__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* AsyncCompute :: GPU Busy */
#define kblgt3__async_compute__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* AsyncCompute :: VS Threads Dispatched */
#define kblgt3__async_compute__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* AsyncCompute :: HS Threads Dispatched */
#define kblgt3__async_compute__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* AsyncCompute :: DS Threads Dispatched */
#define kblgt3__async_compute__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* AsyncCompute :: GS Threads Dispatched */
#define kblgt3__async_compute__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* AsyncCompute :: FS Threads Dispatched */
#define kblgt3__async_compute__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* AsyncCompute :: CS Threads Dispatched */
#define kblgt3__async_compute__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* AsyncCompute :: EU FPU0 Pipe Active */
#define kblgt3__async_compute__fpu0_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* AsyncCompute :: VS FPU0 Pipe Active */
#define kblgt3__async_compute__vs_fpu0_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read

/* AsyncCompute :: PS FPU0 Pipe Active */
#define kblgt3__async_compute__ps_fpu0_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* AsyncCompute :: CS FPU0 Pipe Active */
#define kblgt3__async_compute__cs_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* AsyncCompute :: EU FPU1 Pipe Active */
#define kblgt3__async_compute__fpu1_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* AsyncCompute :: VS FPU1 Pipe Active */
#define kblgt3__async_compute__vs_fpu1_active__read \
   bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read

/* AsyncCompute :: PS FPU1 Pipe Active */
#define kblgt3__async_compute__ps_fpu1_active__read \
   bdw__render_basic__vs_send_active__read

/* AsyncCompute :: CS FPU1 Pipe Active */
#define kblgt3__async_compute__cs_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* AsyncCompute :: EU Thread Occupancy */
#define kblgt3__async_compute__eu_thread_occupancy__read \
   sklgt2__ff_bottlenecks__eu_thread_occupancy__read

/* AsyncCompute :: EU Active */
#define kblgt3__async_compute__eu_active__read \
   bdw__render_basic__eu_active__read

/* AsyncCompute :: EU Stall */
#define kblgt3__async_compute__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: GPU Time Elapsed */
#define cflgt2__render_basic__gpu_time__read \
   hsw__render_basic__gpu_time__read

/* Render Metrics Basic set :: GPU Core Clocks */
#define cflgt2__render_basic__gpu_core_clocks__read \
   bdw__render_basic__gpu_core_clocks__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define cflgt2__render_basic__avg_gpu_core_frequency__read \
   bdw__render_basic__avg_gpu_core_frequency__read

/* Render Metrics Basic set :: AVG GPU Core Frequency */
#define cflgt2__render_basic__avg_gpu_core_frequency__max \
   hsw__render_basic__avg_gpu_core_frequency__max

/* Render Metrics Basic set :: VS Threads Dispatched */
#define cflgt2__render_basic__vs_threads__read \
   bdw__render_basic__vs_threads__read

/* Render Metrics Basic set :: HS Threads Dispatched */
#define cflgt2__render_basic__hs_threads__read \
   bdw__render_basic__hs_threads__read

/* Render Metrics Basic set :: DS Threads Dispatched */
#define cflgt2__render_basic__ds_threads__read \
   bdw__render_basic__ds_threads__read

/* Render Metrics Basic set :: GS Threads Dispatched */
#define cflgt2__render_basic__gs_threads__read \
   hsw__render_basic__vs_threads__read

/* Render Metrics Basic set :: FS Threads Dispatched */
#define cflgt2__render_basic__ps_threads__read \
   bdw__render_basic__ps_threads__read

/* Render Metrics Basic set :: CS Threads Dispatched */
#define cflgt2__render_basic__cs_threads__read \
   bdw__render_basic__cs_threads__read

/* Render Metrics Basic set :: GPU Busy */
#define cflgt2__render_basic__gpu_busy__read \
   bdw__render_basic__gpu_busy__read

/* Render Metrics Basic set :: EU Active */
#define cflgt2__render_basic__eu_active__read \
   bdw__render_basic__eu_active__read

/* Render Metrics Basic set :: EU Stall */
#define cflgt2__render_basic__eu_stall__read \
   bdw__render_basic__eu_stall__read

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
#define cflgt2__render_basic__eu_fpu_both_active__read \
   bdw__render_basic__eu_fpu_both_active__read

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
#define cflgt2__render_basic__vs_fpu0_active__read \
   bdw__render_basic__vs_fpu0_active__read

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
#define cflgt2__render_basic__vs_fpu1_active__read \
   bdw__render_basic__vs_fpu1_active__read

/* Render Metrics Basic set :: VS Send Pipe Active */
#define cflgt2__render_basic__vs_send_active__read \
   bdw__render_basic__vs_send_active__read

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
#define cflgt2__render_basic__ps_fpu0_active__read \
   bdw__render_basic__ps_fpu0_active__read

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
#define cflgt2__render_basic__ps_fpu1_active__read \
   bdw__render_basic__ps_fpu1_active__read

/* Render Metrics Basic set :: PS Send Pipeline Active */
#define cflgt2__render_basic__ps_send_active__read \
   bdw__render_basic__ps_send_active__read

/* Render Metrics Basic set :: FS Both FPU Active */
#define cflgt2__render_basic__ps_eu_both_fpu_active__read \
   bdw__render_basic__ps_eu_both_fpu_active__read

/* Render Metrics Basic set :: Sampler 0 Busy */
#define cflgt2__render_basic__sampler0_busy__read \
   bdw__render_basic__sampler0_busy__read

/* Render Metrics Basic set :: Sampler 1 Busy */
#define cflgt2__render_basic__sampler1_busy__read \
   bdw__render_basic__sampler1_busy__read

/* Render Metrics Basic set :: Samplers Busy */
#define cflgt2__render_basic__samplers_busy__read \
   bdw__render_basic__samplers_busy__read

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
#define cflgt2__render_basic__sampler0_bottleneck__read \
   bdw__render_basic__sampler0_bottleneck__read

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
#define cflgt2__render_basic__sampler1_bottleneck__read \
   bdw__render_basic__sampler1_bottleneck__read

/* Render Metrics Basic set :: Rasterized Pixels */
#define cflgt2__render_basic__rasterized_pixels__read \
   bdw__render_basic__rasterized_pixels__read

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
#define cflgt2__render_basic__hi_depth_test_fails__read \
   bdw__render_basic__hi_depth_test_fails__read

/* Render Metrics Basic set :: Early Depth Test Fails */
#define cflgt2__render_basic__early_depth_test_fails__read \
   bdw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: Samples Killed in FS */
#define cflgt2__render_basic__samples_killed_in_ps__read \
   bdw__render_basic__samples_killed_in_ps__read

/* Render Metrics Basic set :: Pixels Failing Tests */
#define cflgt2__render_basic__pixels_failing_post_ps_tests__read \
   bdw__render_basic__pixels_failing_post_ps_tests__read

/* Render Metrics Basic set :: Samples Written */
#define cflgt2__render_basic__samples_written__read \
   bdw__render_basic__samples_written__read

/* Render Metrics Basic set :: Samples Blended */
#define cflgt2__render_basic__samples_blended__read \
   bdw__render_basic__samples_blended__read

/* Render Metrics Basic set :: Sampler Texels */
#define cflgt2__render_basic__sampler_texels__read \
   bdw__render_basic__sampler_texels__read

/* Render Metrics Basic set :: Sampler Texels Misses */
#define cflgt2__render_basic__sampler_texel_misses__read \
   bdw__render_basic__sampler_texel_misses__read

/* Render Metrics Basic set :: Sampler Cache Misses */
#define cflgt2__render_basic__sampler_l1_misses__read \
   sklgt2__render_basic__sampler_l1_misses__read

/* Render Metrics Basic set :: SLM Bytes Read */
#define cflgt2__render_basic__slm_bytes_read__read \
   bdw__render_basic__slm_bytes_read__read

/* Render Metrics Basic set :: SLM Bytes Written */
#define cflgt2__render_basic__slm_bytes_written__read \
   bdw__render_basic__slm_bytes_written__read

/* Render Metrics Basic set :: Shader Memory Accesses */
#define cflgt2__render_basic__shader_memory_accesses__read \
   bdw__render_basic__shader_memory_accesses__read

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
#define cflgt2__render_basic__shader_atomics__read \
   bdw__render_basic__shader_atomics__read

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
#define cflgt2__render_basic__l3_lookups__read \
   sklgt2__render_basic__l3_lookups__read

/* Render Metrics Basic set :: L3 Misses */
#define cflgt2__render_basic__l3_misses__read \
   hsw__compute_extended__typed_atomics0__read

/* Render Metrics Basic set :: L3 Sampler Throughput */
#define cflgt2__render_basic__l3_sampler_throughput__read \
   sklgt2__render_basic__l3_sampler_throughput__read

/* Render Metrics Basic set :: L3 Shader Throughput */
#define cflgt2__render_basic__l3_shader_throughput__read \
   bdw__render_basic__l3_shader_throughput__read

/* Render Metrics Basic set :: Shader Barrier Messages */
#define cflgt2__render_basic__shader_barriers__read \
   hsw__render_basic__early_depth_test_fails__read

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
#define cflgt2__render_basic__gti_vf_throughput__read \
   bdw__render_basic__gti_vf_throughput__read

/* Render Metrics Basic set :: GTI Depth Throughput */
#define cflgt2__render_basic__gti_depth_throughput__read \
   bdw__render_basic__gti_depth_throughput__read

/* Render Metrics Basic set :: GTI RCC Throughput */
