/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

static ValaExpression*
vala_method_call_real_get_call (ValaCallableExpression* base)
{
	ValaExpression* result;
	ValaMethodCall* self;
	ValaExpression* _tmp0_;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

static gboolean
vala_method_call_real_get_is_chainup (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_real_set_is_chainup (ValaCallableExpression* base,
                                      gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	_tmp0_ = _vala_code_node_ref0 (call);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp3_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		ValaExpression* _tmp2_;
		_tmp2_ = _vala_code_node_ref0 (new_node);
		_vala_code_node_unref0 (self->priv->_call);
		self->priv->_call = _tmp2_;
	}
	_tmp3_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp3_, old_node);
	if (index >= 0) {
		ValaList* _tmp4_;
		_tmp4_ = self->priv->argument_list;
		vala_list_set (_tmp4_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		gboolean _tmp22_ = FALSE;
		ValaDataType* _tmp23_;
		_tmp23_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp23_)) {
			ValaDataType* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaTypeSymbol* _tmp26_;
			_tmp24_ = mtype;
			_tmp25_ = vala_data_type_get_type_symbol (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp22_ = VALA_IS_CLASS (_tmp26_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp27_;
			ValaTypeSymbol* _tmp28_;
			ValaTypeSymbol* _tmp29_;
			ValaMethod* m = NULL;
			ValaClass* _tmp30_;
			ValaCreationMethod* _tmp31_;
			ValaCreationMethod* _tmp32_;
			ValaMethod* _tmp33_;
			_tmp27_ = mtype;
			_tmp28_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp29_ = _tmp28_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_CLASS, ValaClass);
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_default_construction_method (_tmp30_);
			_tmp32_ = _tmp31_;
			m = (ValaMethod*) _tmp32_;
			_tmp33_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
		} else {
			ValaDataType* _tmp34_;
			_tmp34_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp34_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp35_;
				ValaDelegate* _tmp36_;
				ValaDelegate* _tmp37_;
				ValaDelegate* _tmp38_;
				_tmp35_ = mtype;
				_tmp36_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp37_ = _tmp36_;
				d = _tmp37_;
				_tmp38_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp38_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp39_;
		gint _expr_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _expr_index = 0;
		_tmp39_ = self->priv->argument_list;
		_expr_list = _tmp39_;
		_tmp40_ = _expr_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_expr_size = _tmp42_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			ValaExpression* expr = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			ValaExpression* _tmp47_;
			_expr_index = _expr_index + 1;
			_tmp43_ = _expr_index;
			_tmp44_ = _expr_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _expr_list;
			_tmp46_ = vala_list_get (_tmp45_, _expr_index);
			expr = (ValaExpression*) _tmp46_;
			_tmp47_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp47_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp111_;
	ValaExpression* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean _tmp116_ = FALSE;
	ValaProfile _tmp117_;
	ValaProfile _tmp118_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp144_;
	gboolean _tmp145_;
	gboolean _tmp227_ = FALSE;
	ValaExpression* _tmp228_;
	ValaExpression* _tmp229_;
	gboolean _tmp304_ = FALSE;
	gboolean _tmp305_;
	gboolean _tmp306_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp321_;
	ValaDataType* _tmp322_;
	ValaDataType* _tmp323_;
	ValaList* params = NULL;
	ValaDataType* _tmp324_;
	ValaList* _tmp325_;
	ValaList* _tmp326_;
	ValaDataType* _tmp327_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp383_;
	ValaIterator* _tmp384_;
	gboolean _tmp434_ = FALSE;
	ValaDataType* _tmp435_;
	gboolean _tmp456_ = FALSE;
	ValaDataType* _tmp457_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp537_ = FALSE;
	gboolean _tmp538_;
	gboolean _tmp539_;
	ValaDataType* _tmp559_;
	ValaDataType* _tmp570_;
	ValaDataType* _tmp571_;
	ValaDataType* _tmp572_;
	ValaDataType* _tmp573_;
	ValaDataType* _tmp574_;
	ValaDataType* _tmp575_;
	ValaList* _tmp576_;
	ValaDataType* _tmp577_;
	ValaDataType* _tmp578_;
	gboolean _tmp579_;
	gboolean _tmp580_;
	ValaDataType* _tmp603_;
	ValaSemanticAnalyzer* _tmp846_;
	ValaSemanticAnalyzer* _tmp847_;
	ValaDataType* _tmp848_;
	ValaList* _tmp849_;
	ValaList* _tmp850_;
	gboolean _tmp877_ = FALSE;
	gboolean _tmp878_ = FALSE;
	ValaCreationMethod* _tmp879_;
	ValaDataType* _tmp907_;
	ValaDataType* _tmp908_;
	gboolean _tmp909_;
	gboolean _tmp910_;
	gboolean _tmp971_;
	gboolean _tmp972_;
	gboolean result;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp6_ = _tmp5_;
	if (VALA_IS_MEMBER_ACCESS (_tmp6_)) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_member_access_get_null_safe_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		result = !_tmp12_;
		return result;
	}
	_tmp13_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp14_ = _tmp13_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp14_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp15_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_value_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (VALA_IS_DELEGATE_TYPE (_tmp18_)) {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp19_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_expression_get_value_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp23_;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp25_ = _tmp24_;
		if (VALA_IS_MEMBER_ACCESS (_tmp25_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaMemberAccess* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			ValaMemberAccess* _tmp39_;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			gboolean _tmp95_ = FALSE;
			ValaMemberAccess* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			_tmp26_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp27_ = _tmp26_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp28_ = ma;
			_tmp29_ = vala_member_access_get_prototype_access (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaSymbol* _tmp35_;
				ValaSymbol* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_full_name (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp32_, "Access to instance member `%s' denied", _tmp38_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_type_arguments (_tmp39_);
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp41_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaMemberAccess* _tmp51_;
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				gboolean _tmp69_ = FALSE;
				ValaMethod* _tmp70_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_inner (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_expression_get_value_type (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _vala_code_node_ref0 (_tmp49_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp50_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_inner (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_expression_get_symbol_reference (_tmp53_);
				_tmp55_ = _tmp54_;
				if (VALA_IS_SIGNAL (_tmp55_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp56_;
					ValaExpression* _tmp57_;
					ValaExpression* _tmp58_;
					ValaMemberAccess* _tmp59_;
					_tmp56_ = ma;
					_tmp57_ = vala_member_access_get_inner (_tmp56_);
					_tmp58_ = _tmp57_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp58_) ? ((ValaMemberAccess*) _tmp58_) : NULL;
					_tmp59_ = sig;
					if (_tmp59_ != NULL) {
						ValaMemberAccess* _tmp60_;
						ValaExpression* _tmp61_;
						ValaExpression* _tmp62_;
						ValaDataType* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						_tmp60_ = sig;
						_tmp61_ = vala_member_access_get_inner (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_expression_get_value_type (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _vala_code_node_ref0 (_tmp64_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp65_;
					}
				}
				_tmp66_ = ma;
				_tmp67_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp66_);
				_tmp68_ = _tmp67_;
				m = VALA_IS_METHOD (_tmp68_) ? ((ValaMethod*) _tmp68_) : NULL;
				_tmp70_ = m;
				if (_tmp70_ != NULL) {
					ValaMethod* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					_tmp71_ = m;
					_tmp72_ = vala_method_get_coroutine (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp69_ = _tmp73_;
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					gboolean _tmp74_ = FALSE;
					ValaMemberAccess* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp75_ = ma;
					_tmp76_ = vala_member_access_get_member_name (_tmp75_);
					_tmp77_ = _tmp76_;
					if (g_strcmp0 (_tmp77_, "begin") == 0) {
						_tmp74_ = TRUE;
					} else {
						ValaMemberAccess* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						_tmp78_ = ma;
						_tmp79_ = vala_member_access_get_member_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp74_ = g_strcmp0 (_tmp80_, "end") == 0;
					}
					if (_tmp74_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp81_;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						gboolean _tmp84_ = FALSE;
						ValaMemberAccess* _tmp85_;
						_tmp81_ = ma;
						_tmp82_ = vala_member_access_get_inner (_tmp81_);
						_tmp83_ = _tmp82_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp83_) ? ((ValaMemberAccess*) _tmp83_) : NULL;
						_tmp85_ = method_access;
						if (_tmp85_ != NULL) {
							ValaMemberAccess* _tmp86_;
							ValaExpression* _tmp87_;
							ValaExpression* _tmp88_;
							_tmp86_ = method_access;
							_tmp87_ = vala_member_access_get_inner (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp84_ = _tmp88_ != NULL;
						} else {
							_tmp84_ = FALSE;
						}
						if (_tmp84_) {
							ValaMemberAccess* _tmp89_;
							ValaExpression* _tmp90_;
							ValaExpression* _tmp91_;
							ValaDataType* _tmp92_;
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							_tmp89_ = method_access;
							_tmp90_ = vala_member_access_get_inner (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = vala_expression_get_value_type (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = _vala_code_node_ref0 (_tmp93_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp94_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp96_ = ma;
			_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp98_ != NULL) {
				ValaMemberAccess* _tmp99_;
				ValaSymbol* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaAttribute* _tmp102_;
				_tmp99_ = ma;
				_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp101_, "Assert");
				_tmp95_ = _tmp102_ != NULL;
			} else {
				_tmp95_ = FALSE;
			}
			if (_tmp95_) {
				ValaList* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp103_ = self->priv->argument_list;
				_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
				_tmp105_ = _tmp104_;
				if (_tmp105_ == 1) {
					ValaList* _tmp106_;
					gpointer _tmp107_;
					ValaExpression* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp106_ = self->priv->argument_list;
					_tmp107_ = vala_list_get (_tmp106_, 0);
					_tmp108_ = (ValaExpression*) _tmp107_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp110_);
					_vala_code_node_unref0 (_tmp108_);
				}
			}
		}
	}
	_tmp111_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_expression_get_value_type (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = _vala_code_node_ref0 (_tmp114_);
	mtype = _tmp115_;
	_tmp117_ = vala_code_context_get_profile (context);
	_tmp118_ = _tmp117_;
	if (_tmp118_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaSymbol* _tmp121_;
		ValaSymbol* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSemanticAnalyzer* _tmp124_;
		ValaClass* _tmp125_;
		_tmp119_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_symbol_reference (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_code_context_get_analyzer (context);
		_tmp124_ = _tmp123_;
		_tmp125_ = _tmp124_->object_type;
		_tmp116_ = _tmp122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp116_ = FALSE;
	}
	gobject_chainup = _tmp116_;
	vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp128_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		gboolean _tmp138_ = FALSE;
		ValaMemberAccess* _tmp139_;
		_tmp126_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp127_ = _tmp126_;
		expr = _tmp127_;
		_tmp128_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaSymbol* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = VALA_IS_CREATION_METHOD (_tmp133_);
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			ValaMemberAccess* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			_tmp134_ = ma;
			_tmp135_ = vala_member_access_get_inner (_tmp134_);
			_tmp136_ = _tmp135_;
			expr = _tmp136_;
			_tmp137_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp137_) ? ((ValaMemberAccess*) _tmp137_) : NULL;
		}
		_tmp139_ = ma;
		if (_tmp139_ != NULL) {
			ValaMemberAccess* _tmp140_;
			const gchar* _tmp141_;
			const gchar* _tmp142_;
			_tmp140_ = ma;
			_tmp141_ = vala_member_access_get_member_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp138_ = g_strcmp0 (_tmp142_, "this") == 0;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, TRUE);
		} else {
			ValaExpression* _tmp143_;
			_tmp143_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp143_)) {
				vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp144_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
	_tmp145_ = _tmp144_;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp157_;
		ValaDataType* _tmp158_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		cm = VALA_IS_CREATION_METHOD (_tmp148_) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		_tmp149_ = cm;
		if (_tmp149_ == NULL) {
			ValaSourceReference* _tmp150_;
			ValaSourceReference* _tmp151_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp151_ = _tmp150_;
			vala_report_error (_tmp151_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp152_;
			gboolean _tmp153_;
			gboolean _tmp154_;
			_tmp152_ = cm;
			_tmp153_ = vala_creation_method_get_chain_up (_tmp152_);
			_tmp154_ = _tmp153_;
			if (_tmp154_) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				vala_report_error (_tmp156_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp157_ = cm;
		vala_creation_method_set_chain_up (_tmp157_, TRUE);
		_tmp158_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp158_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp159_;
			ValaTypeSymbol* _tmp160_;
			ValaTypeSymbol* _tmp161_;
			ValaClass* _tmp162_;
			ValaCreationMethod* _tmp163_;
			ValaCreationMethod* _tmp164_;
			ValaCreationMethod* _tmp165_;
			_tmp159_ = mtype;
			_tmp160_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp161_ = _tmp160_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_CLASS, ValaClass);
			_tmp162_ = cl;
			_tmp163_ = vala_class_get_default_construction_method (_tmp162_);
			_tmp164_ = _tmp163_;
			base_cm = _tmp164_;
			_tmp165_ = base_cm;
			if (_tmp165_ == NULL) {
				ValaSourceReference* _tmp166_;
				ValaSourceReference* _tmp167_;
				ValaClass* _tmp168_;
				gchar* _tmp169_;
				gchar* _tmp170_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = cl;
				_tmp169_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp168_);
				_tmp170_ = _tmp169_;
				vala_report_error (_tmp167_, "chain up to `%s' not supported", _tmp170_);
				_g_free0 (_tmp170_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp171_;
				gboolean _tmp172_;
				gboolean _tmp173_;
				_tmp171_ = base_cm;
				_tmp172_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp171_);
				_tmp173_ = _tmp172_;
				if (!_tmp173_) {
					ValaSourceReference* _tmp174_;
					ValaSourceReference* _tmp175_;
					ValaCreationMethod* _tmp176_;
					gchar* _tmp177_;
					gchar* _tmp178_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp175_ = _tmp174_;
					_tmp176_ = base_cm;
					_tmp177_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp176_);
					_tmp178_ = _tmp177_;
					vala_report_error (_tmp175_, "chain up to `%s' not supported", _tmp178_);
					_g_free0 (_tmp178_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp179_ = FALSE;
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			ValaSymbol* _tmp182_;
			ValaSymbol* _tmp183_;
			_tmp180_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
			_tmp183_ = _tmp182_;
			if (VALA_IS_CREATION_METHOD (_tmp183_)) {
				ValaExpression* _tmp184_;
				ValaExpression* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				ValaSymbol* _tmp188_;
				ValaSymbol* _tmp189_;
				_tmp184_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_expression_get_symbol_reference (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_symbol_get_parent_symbol (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp179_ = VALA_IS_CLASS (_tmp189_);
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				ValaExpression* _tmp190_;
				ValaExpression* _tmp191_;
				ValaSymbol* _tmp192_;
				ValaSymbol* _tmp193_;
				ValaCreationMethod* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				_tmp190_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_expression_get_symbol_reference (_tmp191_);
				_tmp193_ = _tmp192_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp193_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp194_ = base_cm;
				_tmp195_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp194_);
				_tmp196_ = _tmp195_;
				if (!_tmp196_) {
					ValaSourceReference* _tmp197_;
					ValaSourceReference* _tmp198_;
					ValaCreationMethod* _tmp199_;
					gchar* _tmp200_;
					gchar* _tmp201_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp198_ = _tmp197_;
					_tmp199_ = base_cm;
					_tmp200_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp199_);
					_tmp201_ = _tmp200_;
					vala_report_error (_tmp198_, "chain up to `%s' not supported", _tmp201_);
					_g_free0 (_tmp201_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					gboolean _tmp205_ = FALSE;
					ValaClass* _tmp206_;
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaSemanticAnalyzer* _tmp215_;
					ValaSemanticAnalyzer* _tmp216_;
					ValaClass* _tmp217_;
					ValaSourceReference* _tmp218_;
					ValaSourceReference* _tmp219_;
					ValaObjectType* _tmp220_;
					ValaObjectType* _tmp221_;
					ValaExpression* _tmp222_;
					ValaExpression* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					ValaDataType* _tmp226_;
					_tmp202_ = cm;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					cl = VALA_IS_CLASS (_tmp204_) ? ((ValaClass*) _tmp204_) : NULL;
					_tmp206_ = cl;
					if (_tmp206_ == NULL) {
						_tmp205_ = TRUE;
					} else {
						ValaClass* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaSemanticAnalyzer* _tmp209_;
						ValaClass* _tmp210_;
						_tmp207_ = cl;
						_tmp208_ = vala_code_context_get_analyzer (context);
						_tmp209_ = _tmp208_;
						_tmp210_ = _tmp209_->object_type;
						_tmp205_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp207_, (ValaTypeSymbol*) _tmp210_);
					}
					if (_tmp205_) {
						ValaSourceReference* _tmp211_;
						ValaSourceReference* _tmp212_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp212_ = _tmp211_;
						vala_report_error (_tmp212_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp213_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_code_context_get_analyzer (context);
					_tmp216_ = _tmp215_;
					_tmp217_ = _tmp216_->object_type;
					_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp217_, _tmp219_);
					_tmp221_ = _tmp220_;
					vala_expression_set_value_type (_tmp214_, (ValaDataType*) _tmp221_);
					_vala_code_node_unref0 (_tmp221_);
					_tmp222_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_expression_get_value_type (_tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = _vala_code_node_ref0 (_tmp225_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp226_;
				}
			}
		}
	}
	_tmp228_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp229_ = _tmp228_;
	if (VALA_IS_MEMBER_ACCESS (_tmp229_)) {
		gboolean _tmp230_ = FALSE;
		gboolean _tmp231_ = FALSE;
		ValaExpression* _tmp232_;
		ValaExpression* _tmp233_;
		ValaSymbol* _tmp234_;
		ValaSymbol* _tmp235_;
		_tmp232_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp233_ = _tmp232_;
		_tmp234_ = vala_expression_get_symbol_reference (_tmp233_);
		_tmp235_ = _tmp234_;
		if (VALA_IS_CREATION_METHOD (_tmp235_)) {
			ValaExpression* _tmp236_;
			ValaExpression* _tmp237_;
			ValaSymbol* _tmp238_;
			ValaSymbol* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			_tmp236_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp237_ = _tmp236_;
			_tmp238_ = vala_expression_get_symbol_reference (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_symbol_get_parent_symbol (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp231_ = VALA_IS_STRUCT (_tmp241_);
		} else {
			_tmp231_ = FALSE;
		}
		if (_tmp231_) {
			_tmp230_ = TRUE;
		} else {
			ValaExpression* _tmp242_;
			ValaExpression* _tmp243_;
			ValaSymbol* _tmp244_;
			ValaSymbol* _tmp245_;
			_tmp242_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp243_ = _tmp242_;
			_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
			_tmp245_ = _tmp244_;
			_tmp230_ = VALA_IS_STRUCT (_tmp245_);
		}
		_tmp227_ = _tmp230_;
	} else {
		_tmp227_ = FALSE;
	}
	if (_tmp227_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp246_;
		ValaExpression* _tmp247_;
		ValaSymbol* _tmp248_;
		ValaSymbol* _tmp249_;
		gboolean _tmp250_ = FALSE;
		gboolean _tmp251_ = FALSE;
		ValaStruct* _tmp252_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp263_;
		ValaExpression* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaSourceReference* _tmp266_;
		ValaObjectCreationExpression* _tmp267_;
		ValaObjectCreationExpression* _tmp268_;
		ValaObjectCreationExpression* _tmp269_;
		gboolean _tmp270_;
		gboolean _tmp271_;
		ValaObjectCreationExpression* _tmp282_;
		ValaDataType* _tmp283_;
		ValaDataType* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaList* _tmp287_;
		ValaCodeNode* _tmp288_;
		ValaCodeNode* _tmp289_;
		ValaObjectCreationExpression* _tmp290_;
		ValaObjectCreationExpression* _tmp291_;
		_tmp246_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp247_ = _tmp246_;
		_tmp248_ = vala_expression_get_symbol_reference (_tmp247_);
		_tmp249_ = _tmp248_;
		st = VALA_IS_STRUCT (_tmp249_) ? ((ValaStruct*) _tmp249_) : NULL;
		_tmp252_ = st;
		if (_tmp252_ != NULL) {
			ValaStruct* _tmp253_;
			ValaCreationMethod* _tmp254_;
			ValaCreationMethod* _tmp255_;
			_tmp253_ = st;
			_tmp254_ = vala_struct_get_default_construction_method (_tmp253_);
			_tmp255_ = _tmp254_;
			_tmp251_ = _tmp255_ == NULL;
		} else {
			_tmp251_ = FALSE;
		}
		if (_tmp251_) {
			gboolean _tmp256_ = FALSE;
			gboolean _tmp257_ = FALSE;
			ValaStruct* _tmp258_;
			_tmp258_ = st;
			if (vala_struct_is_boolean_type (_tmp258_)) {
				_tmp257_ = TRUE;
			} else {
				ValaStruct* _tmp259_;
				_tmp259_ = st;
				_tmp257_ = vala_struct_is_integer_type (_tmp259_);
			}
			if (_tmp257_) {
				_tmp256_ = TRUE;
			} else {
				ValaStruct* _tmp260_;
				_tmp260_ = st;
				_tmp256_ = vala_struct_is_floating_type (_tmp260_);
			}
			_tmp250_ = _tmp256_;
		} else {
			_tmp250_ = FALSE;
		}
		if (_tmp250_) {
			ValaSourceReference* _tmp261_;
			ValaSourceReference* _tmp262_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp262_ = _tmp261_;
			vala_report_error (_tmp262_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp263_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp264_ = _tmp263_;
		_tmp265_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp266_ = _tmp265_;
		_tmp267_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp266_);
		struct_creation_expression = _tmp267_;
		_tmp268_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp268_, TRUE);
		_tmp269_ = struct_creation_expression;
		_tmp270_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
		_tmp271_ = _tmp270_;
		vala_callable_expression_set_is_chainup ((ValaCallableExpression*) _tmp269_, _tmp271_);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp272_;
			gint _arg_size = 0;
			ValaList* _tmp273_;
			gint _tmp274_;
			gint _tmp275_;
			gint _arg_index = 0;
			_tmp272_ = self->priv->argument_list;
			_arg_list = _tmp272_;
			_tmp273_ = _arg_list;
			_tmp274_ = vala_collection_get_size ((ValaCollection*) _tmp273_);
			_tmp275_ = _tmp274_;
			_arg_size = _tmp275_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp276_;
				gint _tmp277_;
				ValaExpression* arg = NULL;
				ValaList* _tmp278_;
				gpointer _tmp279_;
				ValaObjectCreationExpression* _tmp280_;
				ValaExpression* _tmp281_;
				_arg_index = _arg_index + 1;
				_tmp276_ = _arg_index;
				_tmp277_ = _arg_size;
				if (!(_tmp276_ < _tmp277_)) {
					break;
				}
				_tmp278_ = _arg_list;
				_tmp279_ = vala_list_get (_tmp278_, _arg_index);
				arg = (ValaExpression*) _tmp279_;
				_tmp280_ = struct_creation_expression;
				_tmp281_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp280_, _tmp281_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp282_ = struct_creation_expression;
		_tmp283_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp284_ = _tmp283_;
		vala_expression_set_target_type ((ValaExpression*) _tmp282_, _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp287_, (ValaCodeNode*) self);
		_tmp288_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp289_ = _tmp288_;
		_tmp290_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp289_, (ValaExpression*) self, (ValaExpression*) _tmp290_);
		_tmp291_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp291_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp292_ = FALSE;
		gboolean _tmp293_ = FALSE;
		gboolean _tmp294_;
		gboolean _tmp295_;
		_tmp294_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
		_tmp295_ = _tmp294_;
		if (!_tmp295_) {
			ValaExpression* _tmp296_;
			ValaExpression* _tmp297_;
			_tmp296_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp297_ = _tmp296_;
			_tmp293_ = VALA_IS_MEMBER_ACCESS (_tmp297_);
		} else {
			_tmp293_ = FALSE;
		}
		if (_tmp293_) {
			ValaExpression* _tmp298_;
			ValaExpression* _tmp299_;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			_tmp298_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_expression_get_symbol_reference (_tmp299_);
			_tmp301_ = _tmp300_;
			_tmp292_ = VALA_IS_CREATION_METHOD (_tmp301_);
		} else {
			_tmp292_ = FALSE;
		}
		if (_tmp292_) {
			ValaSourceReference* _tmp302_;
			ValaSourceReference* _tmp303_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp302_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp303_ = _tmp302_;
			vala_report_error (_tmp303_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp305_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
	_tmp306_ = _tmp305_;
	if (!_tmp306_) {
		ValaDataType* _tmp307_;
		_tmp307_ = mtype;
		_tmp304_ = VALA_IS_OBJECT_TYPE (_tmp307_);
	} else {
		_tmp304_ = FALSE;
	}
	if (_tmp304_) {
		ValaSourceReference* _tmp308_;
		ValaSourceReference* _tmp309_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp309_ = _tmp308_;
		vala_report_error (_tmp309_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp310_ = FALSE;
		ValaDataType* _tmp311_;
		_tmp311_ = mtype;
		if (_tmp311_ != NULL) {
			ValaDataType* _tmp312_;
			_tmp312_ = mtype;
			_tmp310_ = vala_data_type_is_invokable (_tmp312_);
		} else {
			_tmp310_ = FALSE;
		}
		if (_tmp310_) {
		} else {
			ValaExpression* _tmp313_;
			ValaExpression* _tmp314_;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			_tmp313_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp314_ = _tmp313_;
			_tmp315_ = vala_expression_get_symbol_reference (_tmp314_);
			_tmp316_ = _tmp315_;
			if (VALA_IS_CLASS (_tmp316_)) {
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_report_error (_tmp318_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp319_;
				ValaSourceReference* _tmp320_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp319_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp320_ = _tmp319_;
				vala_report_error (_tmp320_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp321_ = mtype;
	_tmp322_ = vala_data_type_get_return_type (_tmp321_);
	_tmp323_ = _vala_code_node_ref0 (_tmp322_);
	ret_type = _tmp323_;
	_tmp324_ = mtype;
	_tmp325_ = vala_data_type_get_parameters (_tmp324_);
	_tmp326_ = _vala_iterable_ref0 (_tmp325_);
	params = _tmp326_;
	_tmp327_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp327_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp328_;
		ValaExpression* _tmp329_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp330_;
		ValaMethod* _tmp331_;
		ValaMethod* _tmp332_;
		ValaMethod* _tmp333_;
		gboolean _tmp334_;
		gboolean _tmp335_;
		gint n_type_params = 0;
		ValaMethod* _tmp367_;
		ValaList* _tmp368_;
		gint _tmp369_;
		gint _tmp370_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp371_;
		ValaList* _tmp372_;
		gint _tmp373_;
		gint _tmp374_;
		gboolean _tmp375_ = FALSE;
		_tmp328_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp329_ = _tmp328_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp329_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp330_ = mtype;
		_tmp331_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp332_ = _tmp331_;
		m = _tmp332_;
		_tmp333_ = m;
		_tmp334_ = vala_method_get_coroutine (_tmp333_);
		_tmp335_ = _tmp334_;
		if (_tmp335_) {
			gboolean _tmp336_;
			gboolean _tmp337_;
			_tmp336_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp337_ = _tmp336_;
			if (!_tmp337_) {
				ValaMemberAccess* _tmp338_;
				const gchar* _tmp339_;
				const gchar* _tmp340_;
				_tmp338_ = ma;
				_tmp339_ = vala_member_access_get_member_name (_tmp338_);
				_tmp340_ = _tmp339_;
				if (g_strcmp0 (_tmp340_, "end") != 0) {
					ValaMemberAccess* _tmp341_;
					const gchar* _tmp342_;
					const gchar* _tmp343_;
					ValaMethod* _tmp347_;
					ValaList* _tmp348_;
					ValaList* _tmp349_;
					ValaVoidType* _tmp350_;
					_tmp341_ = ma;
					_tmp342_ = vala_member_access_get_member_name (_tmp341_);
					_tmp343_ = _tmp342_;
					if (g_strcmp0 (_tmp343_, "begin") != 0) {
						ValaMemberAccess* _tmp344_;
						ValaSourceReference* _tmp345_;
						ValaSourceReference* _tmp346_;
						_tmp344_ = ma;
						_tmp345_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp344_);
						_tmp346_ = _tmp345_;
						vala_report_deprecated (_tmp346_, "implicit .begin is deprecated");
					}
					_tmp347_ = m;
					_tmp348_ = vala_method_get_async_begin_parameters (_tmp347_);
					_tmp349_ = _vala_iterable_ref0 (_tmp348_);
					_vala_iterable_unref0 (params);
					params = _tmp349_;
					_tmp350_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp350_;
				} else {
					ValaMethod* _tmp351_;
					ValaList* _tmp352_;
					ValaList* _tmp353_;
					_tmp351_ = m;
					_tmp352_ = vala_method_get_async_end_parameters (_tmp351_);
					_tmp353_ = _vala_iterable_ref0 (_tmp352_);
					_vala_iterable_unref0 (params);
					params = _tmp353_;
				}
			} else {
				gboolean _tmp354_ = FALSE;
				ValaMemberAccess* _tmp355_;
				const gchar* _tmp356_;
				const gchar* _tmp357_;
				_tmp355_ = ma;
				_tmp356_ = vala_member_access_get_member_name (_tmp355_);
				_tmp357_ = _tmp356_;
				if (g_strcmp0 (_tmp357_, "begin") == 0) {
					_tmp354_ = TRUE;
				} else {
					ValaMemberAccess* _tmp358_;
					const gchar* _tmp359_;
					const gchar* _tmp360_;
					_tmp358_ = ma;
					_tmp359_ = vala_member_access_get_member_name (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp354_ = g_strcmp0 (_tmp360_, "end") == 0;
				}
				if (_tmp354_) {
					ValaMemberAccess* _tmp361_;
					ValaSourceReference* _tmp362_;
					ValaSourceReference* _tmp363_;
					ValaMemberAccess* _tmp364_;
					const gchar* _tmp365_;
					const gchar* _tmp366_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp361_ = ma;
					_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp361_);
					_tmp363_ = _tmp362_;
					_tmp364_ = ma;
					_tmp365_ = vala_member_access_get_member_name (_tmp364_);
					_tmp366_ = _tmp365_;
					vala_report_error (_tmp363_, "use of `%s' not allowed in yield statement", _tmp366_);
				}
			}
		}
		_tmp367_ = m;
		_tmp368_ = vala_method_get_type_parameters (_tmp367_);
		_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
		_tmp370_ = _tmp369_;
		n_type_params = _tmp370_;
		_tmp371_ = ma;
		_tmp372_ = vala_member_access_get_type_arguments (_tmp371_);
		_tmp373_ = vala_collection_get_size ((ValaCollection*) _tmp372_);
		_tmp374_ = _tmp373_;
		n_type_args = _tmp374_;
		if (n_type_args > 0) {
			_tmp375_ = n_type_args < n_type_params;
		} else {
			_tmp375_ = FALSE;
		}
		if (_tmp375_) {
			ValaMemberAccess* _tmp376_;
			ValaSourceReference* _tmp377_;
			ValaSourceReference* _tmp378_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp376_ = ma;
			_tmp377_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp376_);
			_tmp378_ = _tmp377_;
			vala_report_error (_tmp378_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp379_ = FALSE;
			if (n_type_args > 0) {
				_tmp379_ = n_type_args > n_type_params;
			} else {
				_tmp379_ = FALSE;
			}
			if (_tmp379_) {
				ValaMemberAccess* _tmp380_;
				ValaSourceReference* _tmp381_;
				ValaSourceReference* _tmp382_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp380_ = ma;
				_tmp381_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp380_);
				_tmp382_ = _tmp381_;
				vala_report_error (_tmp382_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp383_ = self->priv->argument_list;
	_tmp384_ = vala_iterable_iterator ((ValaIterable*) _tmp383_);
	arg_it = _tmp384_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp385_;
		gint _param_size = 0;
		ValaList* _tmp386_;
		gint _tmp387_;
		gint _tmp388_;
		gint _param_index = 0;
		_tmp385_ = params;
		_param_list = _tmp385_;
		_tmp386_ = _param_list;
		_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
		_tmp388_ = _tmp387_;
		_param_size = _tmp388_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp389_;
			gint _tmp390_;
			ValaParameter* param = NULL;
			ValaList* _tmp391_;
			gpointer _tmp392_;
			ValaParameter* _tmp393_;
			ValaParameter* _tmp394_;
			gboolean _tmp395_;
			gboolean _tmp396_;
			ValaParameter* _tmp397_;
			gboolean _tmp398_;
			gboolean _tmp399_;
			ValaIterator* _tmp417_;
			_param_index = _param_index + 1;
			_tmp389_ = _param_index;
			_tmp390_ = _param_size;
			if (!(_tmp389_ < _tmp390_)) {
				break;
			}
			_tmp391_ = _param_list;
			_tmp392_ = vala_list_get (_tmp391_, _param_index);
			param = (ValaParameter*) _tmp392_;
			_tmp393_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp393_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp394_ = param;
			_tmp395_ = vala_parameter_get_ellipsis (_tmp394_);
			_tmp396_ = _tmp395_;
			if (_tmp396_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp397_ = param;
			_tmp398_ = vala_parameter_get_params_array (_tmp397_);
			_tmp399_ = _tmp398_;
			if (_tmp399_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp400_;
				ValaDataType* _tmp401_;
				ValaDataType* _tmp402_;
				ValaArrayType* _tmp403_;
				_tmp400_ = param;
				_tmp401_ = vala_variable_get_variable_type ((ValaVariable*) _tmp400_);
				_tmp402_ = _tmp401_;
				_tmp403_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp402_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp403_;
				while (TRUE) {
					ValaIterator* _tmp404_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp405_;
					gpointer _tmp406_;
					ValaExpression* _tmp407_;
					ValaArrayType* _tmp408_;
					ValaDataType* _tmp409_;
					ValaDataType* _tmp410_;
					ValaExpression* _tmp411_;
					ValaDataType* _tmp412_;
					ValaDataType* _tmp413_;
					ValaArrayType* _tmp414_;
					gboolean _tmp415_;
					gboolean _tmp416_;
					_tmp404_ = arg_it;
					if (!vala_iterator_next (_tmp404_)) {
						break;
					}
					_tmp405_ = arg_it;
					_tmp406_ = vala_iterator_get (_tmp405_);
					arg = (ValaExpression*) _tmp406_;
					_tmp407_ = arg;
					_tmp408_ = array_type;
					_tmp409_ = vala_array_type_get_element_type (_tmp408_);
					_tmp410_ = _tmp409_;
					vala_expression_set_target_type (_tmp407_, _tmp410_);
					_tmp411_ = arg;
					_tmp412_ = vala_expression_get_target_type (_tmp411_);
					_tmp413_ = _tmp412_;
					_tmp414_ = array_type;
					_tmp415_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp414_);
					_tmp416_ = _tmp415_;
					vala_data_type_set_value_owned (_tmp413_, _tmp416_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp417_ = arg_it;
			if (vala_iterator_next (_tmp417_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp418_;
				gpointer _tmp419_;
				ValaExpression* _tmp420_;
				ValaParameter* _tmp421_;
				ValaDataType* _tmp422_;
				ValaDataType* _tmp423_;
				ValaExpression* _tmp424_;
				ValaExpression* _tmp425_;
				ValaDataType* _tmp426_;
				ValaDataType* _tmp427_;
				ValaDataType* _tmp428_;
				ValaList* _tmp429_;
				ValaDataType* _tmp430_;
				ValaDataType* _tmp431_;
				ValaExpression* _tmp432_;
				ValaExpression* _tmp433_;
				_tmp418_ = arg_it;
				_tmp419_ = vala_iterator_get (_tmp418_);
				arg = (ValaExpression*) _tmp419_;
				_tmp420_ = arg;
				_tmp421_ = param;
				_tmp422_ = vala_variable_get_variable_type ((ValaVariable*) _tmp421_);
				_tmp423_ = _tmp422_;
				vala_expression_set_formal_target_type (_tmp420_, _tmp423_);
				_tmp424_ = arg;
				_tmp425_ = arg;
				_tmp426_ = vala_expression_get_formal_target_type (_tmp425_);
				_tmp427_ = _tmp426_;
				_tmp428_ = target_object_type;
				_tmp429_ = method_type_args;
				_tmp430_ = vala_data_type_get_actual_type (_tmp427_, _tmp428_, _tmp429_, (ValaCodeNode*) self);
				_tmp431_ = _tmp430_;
				vala_expression_set_target_type (_tmp424_, _tmp431_);
				_vala_code_node_unref0 (_tmp431_);
				_tmp432_ = arg;
				_tmp433_ = _vala_code_node_ref0 (_tmp432_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp433_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp435_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp435_)) {
		ValaDataType* _tmp436_;
		ValaMethod* _tmp437_;
		ValaMethod* _tmp438_;
		ValaAttribute* _tmp439_;
		_tmp436_ = mtype;
		_tmp437_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp436_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp438_, "Print");
		_tmp434_ = _tmp439_ != NULL;
	} else {
		_tmp434_ = FALSE;
	}
	if (_tmp434_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp440_;
		ValaSourceReference* _tmp441_;
		ValaTemplate* _tmp442_;
		ValaList* _tmp454_;
		ValaTemplate* _tmp455_;
		_tmp440_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_template_new (_tmp441_);
		template = _tmp442_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp443_;
			gint _arg_size = 0;
			ValaList* _tmp444_;
			gint _tmp445_;
			gint _tmp446_;
			gint _arg_index = 0;
			_tmp443_ = self->priv->argument_list;
			_arg_list = _tmp443_;
			_tmp444_ = _arg_list;
			_tmp445_ = vala_collection_get_size ((ValaCollection*) _tmp444_);
			_tmp446_ = _tmp445_;
			_arg_size = _tmp446_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp447_;
				gint _tmp448_;
				ValaExpression* arg = NULL;
				ValaList* _tmp449_;
				gpointer _tmp450_;
				ValaExpression* _tmp451_;
				ValaTemplate* _tmp452_;
				ValaExpression* _tmp453_;
				_arg_index = _arg_index + 1;
				_tmp447_ = _arg_index;
				_tmp448_ = _arg_size;
				if (!(_tmp447_ < _tmp448_)) {
					break;
				}
				_tmp449_ = _arg_list;
				_tmp450_ = vala_list_get (_tmp449_, _arg_index);
				arg = (ValaExpression*) _tmp450_;
				_tmp451_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp451_, NULL);
				_tmp452_ = template;
				_tmp453_ = arg;
				vala_template_add_expression (_tmp452_, _tmp453_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp454_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp454_);
		_tmp455_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp455_);
		_vala_code_node_unref0 (template);
	}
	_tmp457_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp457_)) {
		ValaDataType* _tmp458_;
		ValaMethod* _tmp459_;
		ValaMethod* _tmp460_;
		gboolean _tmp461_;
		gboolean _tmp462_;
		_tmp458_ = mtype;
		_tmp459_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp458_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_method_get_printf_format (_tmp460_);
		_tmp462_ = _tmp461_;
		_tmp456_ = _tmp462_;
	} else {
		_tmp456_ = FALSE;
	}
	if (_tmp456_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp463_;
		ValaStringLiteral* _tmp512_;
		format_literal = NULL;
		_tmp463_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp463_)) {
		} else {
			ValaExpression* _tmp464_;
			_tmp464_ = last_arg;
			if (_tmp464_ != NULL) {
				ValaExpression* _tmp465_;
				ValaStringLiteral* _tmp466_;
				gboolean _tmp467_ = FALSE;
				ValaStringLiteral* _tmp468_;
				_tmp465_ = last_arg;
				_tmp466_ = vala_string_literal_get_format_literal (_tmp465_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp466_;
				_tmp468_ = format_literal;
				if (_tmp468_ == NULL) {
					ValaList* _tmp469_;
					gint _tmp470_;
					gint _tmp471_;
					ValaList* _tmp472_;
					gint _tmp473_;
					gint _tmp474_;
					_tmp469_ = self->priv->argument_list;
					_tmp470_ = vala_collection_get_size ((ValaCollection*) _tmp469_);
					_tmp471_ = _tmp470_;
					_tmp472_ = params;
					_tmp473_ = vala_collection_get_size ((ValaCollection*) _tmp472_);
					_tmp474_ = _tmp473_;
					_tmp467_ = _tmp471_ == (_tmp474_ - 1);
				} else {
					_tmp467_ = FALSE;
				}
				if (_tmp467_) {
					ValaStringLiteral* _tmp475_;
					ValaStringLiteral* _tmp476_;
					ValaSemanticAnalyzer* _tmp477_;
					ValaSemanticAnalyzer* _tmp478_;
					ValaDataType* _tmp479_;
					ValaDataType* _tmp480_;
					ValaDataType* _tmp481_;
					ValaList* _tmp482_;
					ValaList* _tmp483_;
					gint _tmp484_;
					gint _tmp485_;
					ValaStringLiteral* _tmp486_;
					ValaList* _tmp487_;
					ValaIterator* _tmp488_;
					_tmp475_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp475_;
					_tmp476_ = format_literal;
					_tmp477_ = vala_code_context_get_analyzer (context);
					_tmp478_ = _tmp477_;
					_tmp479_ = _tmp478_->string_type;
					_tmp480_ = vala_data_type_copy (_tmp479_);
					_tmp481_ = _tmp480_;
					vala_expression_set_target_type ((ValaExpression*) _tmp476_, _tmp481_);
					_vala_code_node_unref0 (_tmp481_);
					_tmp482_ = self->priv->argument_list;
					_tmp483_ = self->priv->argument_list;
					_tmp484_ = vala_collection_get_size ((ValaCollection*) _tmp483_);
					_tmp485_ = _tmp484_;
					_tmp486_ = format_literal;
					vala_list_insert (_tmp482_, _tmp485_ - 1, (ValaExpression*) _tmp486_);
					_tmp487_ = self->priv->argument_list;
					_tmp488_ = vala_iterable_iterator ((ValaIterable*) _tmp487_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp488_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp489_;
						gint _param_size = 0;
						ValaList* _tmp490_;
						gint _tmp491_;
						gint _tmp492_;
						gint _param_index = 0;
						_tmp489_ = params;
						_param_list = _tmp489_;
						_tmp490_ = _param_list;
						_tmp491_ = vala_collection_get_size ((ValaCollection*) _tmp490_);
						_tmp492_ = _tmp491_;
						_param_size = _tmp492_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp493_;
							gint _tmp494_;
							ValaParameter* param = NULL;
							ValaList* _tmp495_;
							gpointer _tmp496_;
							gboolean _tmp497_ = FALSE;
							ValaParameter* _tmp498_;
							gboolean _tmp499_;
							gboolean _tmp500_;
							ValaIterator* _tmp504_;
							_param_index = _param_index + 1;
							_tmp493_ = _param_index;
							_tmp494_ = _param_size;
							if (!(_tmp493_ < _tmp494_)) {
								break;
							}
							_tmp495_ = _param_list;
							_tmp496_ = vala_list_get (_tmp495_, _param_index);
							param = (ValaParameter*) _tmp496_;
							_tmp498_ = param;
							_tmp499_ = vala_parameter_get_ellipsis (_tmp498_);
							_tmp500_ = _tmp499_;
							if (_tmp500_) {
								_tmp497_ = TRUE;
							} else {
								ValaParameter* _tmp501_;
								gboolean _tmp502_;
								gboolean _tmp503_;
								_tmp501_ = param;
								_tmp502_ = vala_parameter_get_params_array (_tmp501_);
								_tmp503_ = _tmp502_;
								_tmp497_ = _tmp503_;
							}
							if (_tmp497_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp504_ = arg_it;
							vala_iterator_next (_tmp504_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp505_;
				ValaExpression* _tmp506_;
				ValaMemberAccess* _tmp507_;
				_tmp505_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp506_ = _tmp505_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp506_) ? ((ValaMemberAccess*) _tmp506_) : NULL;
				_tmp507_ = ma;
				if (_tmp507_ != NULL) {
					ValaMemberAccess* _tmp508_;
					ValaExpression* _tmp509_;
					ValaExpression* _tmp510_;
					ValaStringLiteral* _tmp511_;
					_tmp508_ = ma;
					_tmp509_ = vala_member_access_get_inner (_tmp508_);
					_tmp510_ = _tmp509_;
					_tmp511_ = vala_string_literal_get_format_literal (_tmp510_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp511_;
				}
			}
		}
		_tmp512_ = format_literal;
		if (_tmp512_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp513_;
			gchar* _tmp514_;
			ValaSemanticAnalyzer* _tmp515_;
			ValaSemanticAnalyzer* _tmp516_;
			const gchar* _tmp517_;
			ValaIterator* _tmp518_;
			ValaSourceReference* _tmp519_;
			ValaSourceReference* _tmp520_;
			_tmp513_ = format_literal;
			_tmp514_ = vala_string_literal_eval (_tmp513_);
			format = _tmp514_;
			_tmp515_ = vala_code_context_get_analyzer (context);
			_tmp516_ = _tmp515_;
			_tmp517_ = format;
			_tmp518_ = arg_it;
			_tmp519_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp520_ = _tmp519_;
			if (!vala_semantic_analyzer_check_print_format (_tmp516_, _tmp517_, _tmp518_, _tmp520_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp521_;
		gint _arg_size = 0;
		ValaList* _tmp522_;
		gint _tmp523_;
		gint _tmp524_;
		gint _arg_index = 0;
		_tmp521_ = self->priv->argument_list;
		_arg_list = _tmp521_;
		_tmp522_ = _arg_list;
		_tmp523_ = vala_collection_get_size ((ValaCollection*) _tmp522_);
		_tmp524_ = _tmp523_;
		_arg_size = _tmp524_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp525_;
			gint _tmp526_;
			ValaExpression* arg = NULL;
			ValaList* _tmp527_;
			gpointer _tmp528_;
			ValaExpression* _tmp529_;
			gboolean _tmp530_ = FALSE;
			ValaExpression* _tmp531_;
			_arg_index = _arg_index + 1;
			_tmp525_ = _arg_index;
			_tmp526_ = _arg_size;
			if (!(_tmp525_ < _tmp526_)) {
				break;
			}
			_tmp527_ = _arg_list;
			_tmp528_ = vala_list_get (_tmp527_, _arg_index);
			arg = (ValaExpression*) _tmp528_;
			_tmp529_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp529_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp531_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp531_)) {
				ValaExpression* _tmp532_;
				ValaMethod* _tmp533_;
				ValaMethod* _tmp534_;
				gboolean _tmp535_;
				gboolean _tmp536_;
				_tmp532_ = arg;
				_tmp533_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp532_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp534_ = _tmp533_;
				_tmp535_ = vala_method_get_closure (_tmp534_);
				_tmp536_ = _tmp535_;
				_tmp530_ = _tmp536_;
			} else {
				_tmp530_ = FALSE;
			}
			if (_tmp530_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp538_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp539_ = _tmp538_;
	if (!_tmp539_) {
		_tmp537_ = force_lambda_method_closure;
	} else {
		_tmp537_ = FALSE;
	}
	if (_tmp537_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp540_;
			gint _arg_size = 0;
			ValaList* _tmp541_;
			gint _tmp542_;
			gint _tmp543_;
			gint _arg_index = 0;
			_tmp540_ = self->priv->argument_list;
			_arg_list = _tmp540_;
			_tmp541_ = _arg_list;
			_tmp542_ = vala_collection_get_size ((ValaCollection*) _tmp541_);
			_tmp543_ = _tmp542_;
			_arg_size = _tmp543_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp544_;
				gint _tmp545_;
				ValaExpression* arg = NULL;
				ValaList* _tmp546_;
				gpointer _tmp547_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp548_;
				gboolean _tmp549_ = FALSE;
				ValaLambdaExpression* _tmp550_;
				_arg_index = _arg_index + 1;
				_tmp544_ = _arg_index;
				_tmp545_ = _arg_size;
				if (!(_tmp544_ < _tmp545_)) {
					break;
				}
				_tmp546_ = _arg_list;
				_tmp547_ = vala_list_get (_tmp546_, _arg_index);
				arg = (ValaExpression*) _tmp547_;
				_tmp548_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp548_) ? ((ValaLambdaExpression*) _tmp548_) : NULL;
				_tmp550_ = lambda;
				if (_tmp550_ != NULL) {
					ValaLambdaExpression* _tmp551_;
					ValaMethod* _tmp552_;
					ValaMethod* _tmp553_;
					ValaMemberBinding _tmp554_;
					ValaMemberBinding _tmp555_;
					_tmp551_ = lambda;
					_tmp552_ = vala_lambda_expression_get_method (_tmp551_);
					_tmp553_ = _tmp552_;
					_tmp554_ = vala_method_get_binding (_tmp553_);
					_tmp555_ = _tmp554_;
					_tmp549_ = _tmp555_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp549_ = FALSE;
				}
				if (_tmp549_) {
					ValaLambdaExpression* _tmp556_;
					ValaMethod* _tmp557_;
					ValaMethod* _tmp558_;
					_tmp556_ = lambda;
					_tmp557_ = vala_lambda_expression_get_method (_tmp556_);
					_tmp558_ = _tmp557_;
					vala_method_set_closure (_tmp558_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp559_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp559_)) {
		gboolean _tmp560_ = FALSE;
		gboolean _tmp561_ = FALSE;
		ValaCodeNode* _tmp562_;
		ValaCodeNode* _tmp563_;
		_tmp562_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp563_ = _tmp562_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp563_)) {
			ValaCodeNode* _tmp564_;
			ValaCodeNode* _tmp565_;
			_tmp564_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp565_ = _tmp564_;
			_tmp561_ = !VALA_IS_FOR_STATEMENT (_tmp565_);
		} else {
			_tmp561_ = FALSE;
		}
		if (_tmp561_) {
			ValaCodeNode* _tmp566_;
			ValaCodeNode* _tmp567_;
			_tmp566_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp567_ = _tmp566_;
			_tmp560_ = !VALA_IS_YIELD_STATEMENT (_tmp567_);
		} else {
			_tmp560_ = FALSE;
		}
		if (_tmp560_) {
			ValaSourceReference* _tmp568_;
			ValaSourceReference* _tmp569_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp568_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp569_ = _tmp568_;
			vala_report_error (_tmp569_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp570_ = ret_type;
	_tmp571_ = vala_data_type_copy (_tmp570_);
	_tmp572_ = _tmp571_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp572_);
	_vala_code_node_unref0 (_tmp572_);
	_tmp573_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp574_ = _tmp573_;
	_tmp575_ = target_object_type;
	_tmp576_ = method_type_args;
	_tmp577_ = vala_data_type_get_actual_type (_tmp574_, _tmp575_, _tmp576_, (ValaCodeNode*) self);
	_tmp578_ = _tmp577_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp578_);
	_vala_code_node_unref0 (_tmp578_);
	_tmp579_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp580_ = _tmp579_;
	if (_tmp580_) {
		gboolean _tmp581_ = FALSE;
		ValaDataType* _tmp582_;
		gboolean _tmp590_ = FALSE;
		ValaSemanticAnalyzer* _tmp591_;
		ValaSemanticAnalyzer* _tmp592_;
		ValaMethod* _tmp593_;
		ValaMethod* _tmp594_;
		_tmp582_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp582_)) {
			_tmp581_ = TRUE;
		} else {
			ValaDataType* _tmp583_;
			ValaMethod* _tmp584_;
			ValaMethod* _tmp585_;
			gboolean _tmp586_;
			gboolean _tmp587_;
			_tmp583_ = mtype;
			_tmp584_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp583_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp585_ = _tmp584_;
			_tmp586_ = vala_method_get_coroutine (_tmp585_);
			_tmp587_ = _tmp586_;
			_tmp581_ = !_tmp587_;
		}
		if (_tmp581_) {
			ValaSourceReference* _tmp588_;
			ValaSourceReference* _tmp589_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp589_ = _tmp588_;
			vala_report_error (_tmp589_, "yield expression requires async method");
		}
		_tmp591_ = vala_code_context_get_analyzer (context);
		_tmp592_ = _tmp591_;
		_tmp593_ = vala_semantic_analyzer_get_current_method (_tmp592_);
		_tmp594_ = _tmp593_;
		if (_tmp594_ == NULL) {
			_tmp590_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp595_;
			ValaSemanticAnalyzer* _tmp596_;
			ValaMethod* _tmp597_;
			ValaMethod* _tmp598_;
			gboolean _tmp599_;
			gboolean _tmp600_;
			_tmp595_ = vala_code_context_get_analyzer (context);
			_tmp596_ = _tmp595_;
			_tmp597_ = vala_semantic_analyzer_get_current_method (_tmp596_);
			_tmp598_ = _tmp597_;
			_tmp599_ = vala_method_get_coroutine (_tmp598_);
			_tmp600_ = _tmp599_;
			_tmp590_ = !_tmp600_;
		}
		if (_tmp590_) {
			ValaSourceReference* _tmp601_;
			ValaSourceReference* _tmp602_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp601_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp602_ = _tmp601_;
			vala_report_error (_tmp602_, "yield expression not available outside async method");
		}
	}
	_tmp603_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp603_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp604_;
		ValaMethod* _tmp605_;
		ValaMethod* _tmp606_;
		ValaMethod* _tmp607_;
		gboolean _tmp608_;
		gboolean _tmp609_;
		ValaMethod* _tmp612_;
		gboolean _tmp613_;
		gboolean _tmp614_;
		gboolean _tmp640_ = FALSE;
		gboolean _tmp641_ = FALSE;
		gboolean _tmp642_ = FALSE;
		gboolean _tmp643_;
		gboolean _tmp644_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp656_;
		ValaSymbol* _tmp657_;
		ValaSymbol* _tmp658_;
		gboolean _tmp659_ = FALSE;
		ValaSignal* _tmp660_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp673_;
		ValaSymbol* _tmp674_;
		ValaSymbol* _tmp675_;
		gboolean _tmp676_ = FALSE;
		ValaDynamicSignal* _tmp677_;
		gboolean _tmp722_ = FALSE;
		ValaMethod* _tmp723_;
		gboolean _tmp831_ = FALSE;
		ValaMethod* _tmp832_;
		_tmp604_ = mtype;
		_tmp605_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp604_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp606_ = _tmp605_;
		m = _tmp606_;
		_tmp607_ = m;
		_tmp608_ = vala_method_get_returns_floating_reference (_tmp607_);
		_tmp609_ = _tmp608_;
		if (_tmp609_) {
			ValaDataType* _tmp610_;
			ValaDataType* _tmp611_;
			_tmp610_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp611_ = _tmp610_;
			vala_data_type_set_floating_reference (_tmp611_, TRUE);
		}
		_tmp612_ = m;
		_tmp613_ = vala_method_get_returns_modified_pointer (_tmp612_);
		_tmp614_ = _tmp613_;
		if (_tmp614_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp615_;
			ValaExpression* _tmp616_;
			ValaExpression* _tmp617_;
			ValaExpression* _tmp618_;
			ValaExpression* _tmp619_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp620_;
			ValaSymbol* _tmp621_;
			ValaSymbol* _tmp622_;
			gboolean _tmp623_ = FALSE;
			ValaProperty* _tmp624_;
			_tmp615_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp616_ = _tmp615_;
			_tmp617_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp616_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp618_ = _tmp617_;
			inner = _tmp618_;
			_tmp619_ = inner;
			vala_expression_set_lvalue (_tmp619_, TRUE);
			_tmp620_ = inner;
			_tmp621_ = vala_expression_get_symbol_reference (_tmp620_);
			_tmp622_ = _tmp621_;
			prop = VALA_IS_PROPERTY (_tmp622_) ? ((ValaProperty*) _tmp622_) : NULL;
			_tmp624_ = prop;
			if (_tmp624_ != NULL) {
				gboolean _tmp625_ = FALSE;
				ValaProperty* _tmp626_;
				ValaPropertyAccessor* _tmp627_;
				ValaPropertyAccessor* _tmp628_;
				_tmp626_ = prop;
				_tmp627_ = vala_property_get_set_accessor (_tmp626_);
				_tmp628_ = _tmp627_;
				if (_tmp628_ == NULL) {
					_tmp625_ = TRUE;
				} else {
					ValaProperty* _tmp629_;
					ValaPropertyAccessor* _tmp630_;
					ValaPropertyAccessor* _tmp631_;
					gboolean _tmp632_;
					gboolean _tmp633_;
					_tmp629_ = prop;
					_tmp630_ = vala_property_get_set_accessor (_tmp629_);
					_tmp631_ = _tmp630_;
					_tmp632_ = vala_property_accessor_get_writable (_tmp631_);
					_tmp633_ = _tmp632_;
					_tmp625_ = !_tmp633_;
				}
				_tmp623_ = _tmp625_;
			} else {
				_tmp623_ = FALSE;
			}
			if (_tmp623_) {
				ValaExpression* _tmp634_;
				ValaSourceReference* _tmp635_;
				ValaSourceReference* _tmp636_;
				ValaProperty* _tmp637_;
				gchar* _tmp638_;
				gchar* _tmp639_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp634_ = inner;
				_tmp635_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp634_);
				_tmp636_ = _tmp635_;
				_tmp637_ = prop;
				_tmp638_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp637_);
				_tmp639_ = _tmp638_;
				vala_report_error (_tmp636_, "Property `%s' is read-only", _tmp639_);
				_g_free0 (_tmp639_);
			}
		}
		_tmp643_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp644_ = _tmp643_;
		if (_tmp644_) {
			ValaDataType* _tmp645_;
			ValaDataType* _tmp646_;
			gboolean _tmp647_;
			gboolean _tmp648_;
			_tmp645_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp646_ = _tmp645_;
			_tmp647_ = vala_data_type_get_nullable (_tmp646_);
			_tmp648_ = _tmp647_;
			_tmp642_ = !_tmp648_;
		} else {
			_tmp642_ = FALSE;
		}
		if (_tmp642_) {
			ValaDataType* _tmp649_;
			ValaDataType* _tmp650_;
			gboolean _tmp651_;
			gboolean _tmp652_;
			_tmp649_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp650_ = _tmp649_;
			_tmp651_ = vala_data_type_get_floating_reference (_tmp650_);
			_tmp652_ = _tmp651_;
			_tmp641_ = _tmp652_;
		} else {
			_tmp641_ = FALSE;
		}
		if (_tmp641_) {
			ValaDataType* _tmp653_;
			_tmp653_ = ret_type;
			_tmp640_ = VALA_IS_OBJECT_TYPE (_tmp653_);
		} else {
			_tmp640_ = FALSE;
		}
		if (_tmp640_) {
			ValaDataType* _tmp654_;
			ValaDataType* _tmp655_;
			_tmp654_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp655_ = _tmp654_;
			vala_data_type_set_nullable (_tmp655_, TRUE);
		}
		_tmp656_ = m;
		_tmp657_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp656_);
		_tmp658_ = _tmp657_;
		sig = VALA_IS_SIGNAL (_tmp658_) ? ((ValaSignal*) _tmp658_) : NULL;
		_tmp660_ = sig;
		if (_tmp660_ != NULL) {
			ValaMethod* _tmp661_;
			const gchar* _tmp662_;
			const gchar* _tmp663_;
			_tmp661_ = m;
			_tmp662_ = vala_symbol_get_name ((ValaSymbol*) _tmp661_);
			_tmp663_ = _tmp662_;
			_tmp659_ = g_strcmp0 (_tmp663_, "disconnect") == 0;
		} else {
			_tmp659_ = FALSE;
		}
		if (_tmp659_) {
			gboolean _tmp664_ = FALSE;
			ValaList* _tmp665_;
			gboolean _tmp666_;
			gboolean _tmp667_;
			_tmp665_ = self->priv->argument_list;
			_tmp666_ = vala_collection_get_is_empty ((ValaCollection*) _tmp665_);
			_tmp667_ = _tmp666_;
			if (!_tmp667_) {
				ValaList* _tmp668_;
				gpointer _tmp669_;
				ValaExpression* _tmp670_;
				_tmp668_ = self->priv->argument_list;
				_tmp669_ = vala_list_get (_tmp668_, 0);
				_tmp670_ = (ValaExpression*) _tmp669_;
				_tmp664_ = VALA_IS_LAMBDA_EXPRESSION (_tmp670_);
				_vala_code_node_unref0 (_tmp670_);
			} else {
				_tmp664_ = FALSE;
			}
			if (_tmp664_) {
				ValaSourceReference* _tmp671_;
				ValaSourceReference* _tmp672_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp671_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp672_ = _tmp671_;
				vala_report_error (_tmp672_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp673_ = m;
		_tmp674_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp673_);
		_tmp675_ = _tmp674_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp675_) ? ((ValaDynamicSignal*) _tmp675_) : NULL;
		_tmp677_ = dynamic_sig;
		if (_tmp677_ != NULL) {
			ValaDynamicSignal* _tmp678_;
			ValaExpression* _tmp679_;
			ValaExpression* _tmp680_;
			_tmp678_ = dynamic_sig;
			_tmp679_ = vala_dynamic_signal_get_handler (_tmp678_);
			_tmp680_ = _tmp679_;
			_tmp676_ = _tmp680_ != NULL;
		} else {
			_tmp676_ = FALSE;
		}
		if (_tmp676_) {
			ValaDynamicSignal* _tmp681_;
			ValaDynamicSignal* _tmp682_;
			ValaExpression* _tmp683_;
			ValaExpression* _tmp684_;
			ValaDataType* _tmp685_;
			ValaDataType* _tmp686_;
			ValaDataType* _tmp687_;
			ValaDataType* _tmp688_;
			ValaDataType* _tmp689_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp707_;
			ValaExpression* _tmp708_;
			ValaExpression* _tmp709_;
			ValaDynamicSignal* _tmp710_;
			ValaDynamicSignal* _tmp711_;
			ValaSymbol* _tmp712_;
			ValaSymbol* _tmp713_;
			ValaObjectType* _tmp714_;
			ValaObjectType* _tmp715_;
			ValaDelegate* _tmp716_;
			ValaDelegate* _tmp717_;
			ValaSourceReference* _tmp718_;
			ValaSourceReference* _tmp719_;
			ValaDelegateType* _tmp720_;
			ValaDelegateType* _tmp721_;
			_tmp681_ = dynamic_sig;
			_tmp682_ = dynamic_sig;
			_tmp683_ = vala_dynamic_signal_get_handler (_tmp682_);
			_tmp684_ = _tmp683_;
			_tmp685_ = vala_expression_get_value_type (_tmp684_);
			_tmp686_ = _tmp685_;
			_tmp687_ = vala_data_type_get_return_type (_tmp686_);
			_tmp688_ = vala_data_type_copy (_tmp687_);
			_tmp689_ = _tmp688_;
			vala_callable_set_return_type ((ValaCallable*) _tmp681_, _tmp689_);
			_vala_code_node_unref0 (_tmp689_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp690_;
				ValaExpression* _tmp691_;
				ValaExpression* _tmp692_;
				ValaDataType* _tmp693_;
				ValaDataType* _tmp694_;
				ValaList* _tmp695_;
				gint _param_size = 0;
				ValaList* _tmp696_;
				gint _tmp697_;
				gint _tmp698_;
				gint _param_index = 0;
				_tmp690_ = dynamic_sig;
				_tmp691_ = vala_dynamic_signal_get_handler (_tmp690_);
				_tmp692_ = _tmp691_;
				_tmp693_ = vala_expression_get_value_type (_tmp692_);
				_tmp694_ = _tmp693_;
				_tmp695_ = vala_data_type_get_parameters (_tmp694_);
				_param_list = _tmp695_;
				_tmp696_ = _param_list;
				_tmp697_ = vala_collection_get_size ((ValaCollection*) _tmp696_);
				_tmp698_ = _tmp697_;
				_param_size = _tmp698_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp699_;
					gint _tmp700_;
					ValaParameter* param = NULL;
					ValaList* _tmp701_;
					gpointer _tmp702_;
					_param_index = _param_index + 1;
					_tmp699_ = _param_index;
					_tmp700_ = _param_size;
					if (!(_tmp699_ < _tmp700_)) {
						break;
					}
					_tmp701_ = _param_list;
					_tmp702_ = vala_list_get (_tmp701_, _param_index);
					param = (ValaParameter*) _tmp702_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp703_;
						ValaParameter* _tmp704_;
						ValaParameter* _tmp705_;
						ValaParameter* _tmp706_;
						_tmp703_ = dynamic_sig;
						_tmp704_ = param;
						_tmp705_ = vala_parameter_copy (_tmp704_);
						_tmp706_ = _tmp705_;
						vala_callable_add_parameter ((ValaCallable*) _tmp703_, _tmp706_);
						_vala_code_node_unref0 (_tmp706_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp707_ = dynamic_sig;
			_tmp708_ = vala_dynamic_signal_get_handler (_tmp707_);
			_tmp709_ = _tmp708_;
			_tmp710_ = dynamic_sig;
			_tmp711_ = dynamic_sig;
			_tmp712_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp713_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), NULL);
			_tmp715_ = _tmp714_;
			_tmp716_ = vala_signal_get_delegate ((ValaSignal*) _tmp710_, (ValaDataType*) _tmp715_, (ValaCodeNode*) self);
			_tmp717_ = _tmp716_;
			_tmp718_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp719_ = _tmp718_;
			_tmp720_ = vala_delegate_type_new (_tmp717_, _tmp719_);
			_tmp721_ = _tmp720_;
			vala_expression_set_target_type (_tmp709_, (ValaDataType*) _tmp721_);
			_vala_code_node_unref0 (_tmp721_);
			_vala_code_node_unref0 (_tmp717_);
			_vala_code_node_unref0 (_tmp715_);
		}
		_tmp723_ = m;
		if (_tmp723_ != NULL) {
			ValaMethod* _tmp724_;
			_tmp724_ = m;
			_tmp722_ = vala_method_has_type_parameters (_tmp724_);
		} else {
			_tmp722_ = FALSE;
		}
		if (_tmp722_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp725_;
			ValaExpression* _tmp726_;
			ValaMemberAccess* _tmp727_;
			ValaList* _tmp728_;
			gint _tmp729_;
			gint _tmp730_;
			_tmp725_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp726_ = _tmp725_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp726_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp727_ = ma;
			_tmp728_ = vala_member_access_get_type_arguments (_tmp727_);
			_tmp729_ = vala_collection_get_size ((ValaCollection*) _tmp728_);
			_tmp730_ = _tmp729_;
			if (_tmp730_ == 0) {
				ValaList* _tmp797_;
				ValaIterator* _tmp798_;
				ValaDataType* _tmp825_;
				ValaDataType* _tmp826_;
				ValaDataType* _tmp827_;
				ValaList* _tmp828_;
				ValaDataType* _tmp829_;
				ValaDataType* _tmp830_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp731_;
					ValaList* _tmp732_;
					gint _type_param_size = 0;
					ValaList* _tmp733_;
					gint _tmp734_;
					gint _tmp735_;
					gint _type_param_index = 0;
					_tmp731_ = m;
					_tmp732_ = vala_method_get_type_parameters (_tmp731_);
					_type_param_list = _tmp732_;
					_tmp733_ = _type_param_list;
					_tmp734_ = vala_collection_get_size ((ValaCollection*) _tmp733_);
					_tmp735_ = _tmp734_;
					_type_param_size = _tmp735_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp736_;
						gint _tmp737_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp738_;
						gpointer _tmp739_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp740_;
						ValaIterator* _tmp741_;
						gboolean _tmp777_ = FALSE;
						ValaDataType* _tmp778_;
						ValaDataType* _tmp788_;
						ValaMemberAccess* _tmp795_;
						ValaDataType* _tmp796_;
						_type_param_index = _type_param_index + 1;
						_tmp736_ = _type_param_index;
						_tmp737_ = _type_param_size;
						if (!(_tmp736_ < _tmp737_)) {
							break;
						}
						_tmp738_ = _type_param_list;
						_tmp739_ = vala_list_get (_tmp738_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp739_;
						type_arg = NULL;
						_tmp740_ = self->priv->argument_list;
						_tmp741_ = vala_iterable_iterator ((ValaIterable*) _tmp740_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp741_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp742_;
							gint _param_size = 0;
							ValaList* _tmp743_;
							gint _tmp744_;
							gint _tmp745_;
							gint _param_index = 0;
							_tmp742_ = params;
							_param_list = _tmp742_;
							_tmp743_ = _param_list;
							_tmp744_ = vala_collection_get_size ((ValaCollection*) _tmp743_);
							_tmp745_ = _tmp744_;
							_param_size = _tmp745_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp746_;
								gint _tmp747_;
								ValaParameter* param = NULL;
								ValaList* _tmp748_;
								gpointer _tmp749_;
								gboolean _tmp750_ = FALSE;
								ValaParameter* _tmp751_;
								gboolean _tmp752_;
								gboolean _tmp753_;
								ValaIterator* _tmp757_;
								_param_index = _param_index + 1;
								_tmp746_ = _param_index;
								_tmp747_ = _param_size;
								if (!(_tmp746_ < _tmp747_)) {
									break;
								}
								_tmp748_ = _param_list;
								_tmp749_ = vala_list_get (_tmp748_, _param_index);
								param = (ValaParameter*) _tmp749_;
								_tmp751_ = param;
								_tmp752_ = vala_parameter_get_ellipsis (_tmp751_);
								_tmp753_ = _tmp752_;
								if (_tmp753_) {
									_tmp750_ = TRUE;
								} else {
									ValaParameter* _tmp754_;
									gboolean _tmp755_;
									gboolean _tmp756_;
									_tmp754_ = param;
									_tmp755_ = vala_parameter_get_params_array (_tmp754_);
									_tmp756_ = _tmp755_;
									_tmp750_ = _tmp756_;
								}
								if (_tmp750_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp757_ = arg_it;
								if (vala_iterator_next (_tmp757_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp758_;
									gpointer _tmp759_;
									ValaParameter* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									ValaTypeParameter* _tmp763_;
									ValaExpression* _tmp764_;
									ValaDataType* _tmp765_;
									ValaDataType* _tmp766_;
									ValaDataType* _tmp767_;
									ValaDataType* _tmp768_;
									ValaExpression* _tmp769_;
									ValaExpression* _tmp770_;
									ValaDataType* _tmp771_;
									ValaDataType* _tmp772_;
									ValaDataType* _tmp773_;
									ValaList* _tmp774_;
									ValaDataType* _tmp775_;
									ValaDataType* _tmp776_;
									_tmp758_ = arg_it;
									_tmp759_ = vala_iterator_get (_tmp758_);
									arg = (ValaExpression*) _tmp759_;
									_tmp760_ = param;
									_tmp761_ = vala_variable_get_variable_type ((ValaVariable*) _tmp760_);
									_tmp762_ = _tmp761_;
									_tmp763_ = type_param;
									_tmp764_ = arg;
									_tmp765_ = vala_expression_get_value_type (_tmp764_);
									_tmp766_ = _tmp765_;
									_tmp767_ = vala_data_type_infer_type_argument (_tmp762_, _tmp763_, _tmp766_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp767_;
									_tmp768_ = type_arg;
									if (_tmp768_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp769_ = arg;
									_tmp770_ = arg;
									_tmp771_ = vala_expression_get_formal_target_type (_tmp770_);
									_tmp772_ = _tmp771_;
									_tmp773_ = target_object_type;
									_tmp774_ = method_type_args;
									_tmp775_ = vala_data_type_get_actual_type (_tmp772_, _tmp773_, _tmp774_, (ValaCodeNode*) self);
									_tmp776_ = _tmp775_;
									vala_expression_set_target_type (_tmp769_, _tmp776_);
									_vala_code_node_unref0 (_tmp776_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp778_ = type_arg;
						if (_tmp778_ == NULL) {
							ValaDataType* _tmp779_;
							ValaDataType* _tmp780_;
							_tmp779_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp780_ = _tmp779_;
							_tmp777_ = _tmp780_ != NULL;
						} else {
							_tmp777_ = FALSE;
						}
						if (_tmp777_) {
							ValaMethod* _tmp781_;
							ValaDataType* _tmp782_;
							ValaDataType* _tmp783_;
							ValaTypeParameter* _tmp784_;
							ValaDataType* _tmp785_;
							ValaDataType* _tmp786_;
							ValaDataType* _tmp787_;
							_tmp781_ = m;
							_tmp782_ = vala_callable_get_return_type ((ValaCallable*) _tmp781_);
							_tmp783_ = _tmp782_;
							_tmp784_ = type_param;
							_tmp785_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp786_ = _tmp785_;
							_tmp787_ = vala_data_type_infer_type_argument (_tmp783_, _tmp784_, _tmp786_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp787_;
						}
						_tmp788_ = type_arg;
						if (_tmp788_ == NULL) {
							ValaMemberAccess* _tmp789_;
							ValaSourceReference* _tmp790_;
							ValaSourceReference* _tmp791_;
							ValaTypeParameter* _tmp792_;
							gchar* _tmp793_;
							gchar* _tmp794_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp789_ = ma;
							_tmp790_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp789_);
							_tmp791_ = _tmp790_;
							_tmp792_ = type_param;
							_tmp793_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp792_);
							_tmp794_ = _tmp793_;
							vala_report_error (_tmp791_, "cannot infer generic type argument for type parameter `%s'", _tmp794_);
							_g_free0 (_tmp794_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp795_ = ma;
						_tmp796_ = type_arg;
						vala_member_access_add_type_argument (_tmp795_, _tmp796_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp797_ = self->priv->argument_list;
				_tmp798_ = vala_iterable_iterator ((ValaIterable*) _tmp797_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp798_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp799_;
					gint _param_size = 0;
					ValaList* _tmp800_;
					gint _tmp801_;
					gint _tmp802_;
					gint _param_index = 0;
					_tmp799_ = params;
					_param_list = _tmp799_;
					_tmp800_ = _param_list;
					_tmp801_ = vala_collection_get_size ((ValaCollection*) _tmp800_);
					_tmp802_ = _tmp801_;
					_param_size = _tmp802_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp803_;
						gint _tmp804_;
						ValaParameter* param = NULL;
						ValaList* _tmp805_;
						gpointer _tmp806_;
						gboolean _tmp807_ = FALSE;
						ValaParameter* _tmp808_;
						gboolean _tmp809_;
						gboolean _tmp810_;
						ValaIterator* _tmp814_;
						_param_index = _param_index + 1;
						_tmp803_ = _param_index;
						_tmp804_ = _param_size;
						if (!(_tmp803_ < _tmp804_)) {
							break;
						}
						_tmp805_ = _param_list;
						_tmp806_ = vala_list_get (_tmp805_, _param_index);
						param = (ValaParameter*) _tmp806_;
						_tmp808_ = param;
						_tmp809_ = vala_parameter_get_ellipsis (_tmp808_);
						_tmp810_ = _tmp809_;
						if (_tmp810_) {
							_tmp807_ = TRUE;
						} else {
							ValaParameter* _tmp811_;
							gboolean _tmp812_;
							gboolean _tmp813_;
							_tmp811_ = param;
							_tmp812_ = vala_parameter_get_params_array (_tmp811_);
							_tmp813_ = _tmp812_;
							_tmp807_ = _tmp813_;
						}
						if (_tmp807_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp814_ = arg_it;
						if (vala_iterator_next (_tmp814_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp815_;
							gpointer _tmp816_;
							ValaExpression* _tmp817_;
							ValaExpression* _tmp818_;
							ValaDataType* _tmp819_;
							ValaDataType* _tmp820_;
							ValaDataType* _tmp821_;
							ValaList* _tmp822_;
							ValaDataType* _tmp823_;
							ValaDataType* _tmp824_;
							_tmp815_ = arg_it;
							_tmp816_ = vala_iterator_get (_tmp815_);
							arg = (ValaExpression*) _tmp816_;
							_tmp817_ = arg;
							_tmp818_ = arg;
							_tmp819_ = vala_expression_get_formal_target_type (_tmp818_);
							_tmp820_ = _tmp819_;
							_tmp821_ = target_object_type;
							_tmp822_ = method_type_args;
							_tmp823_ = vala_data_type_get_actual_type (_tmp820_, _tmp821_, _tmp822_, (ValaCodeNode*) self);
							_tmp824_ = _tmp823_;
							vala_expression_set_target_type (_tmp817_, _tmp824_);
							_vala_code_node_unref0 (_tmp824_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp825_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp826_ = _tmp825_;
				_tmp827_ = target_object_type;
				_tmp828_ = method_type_args;
				_tmp829_ = vala_data_type_get_actual_type (_tmp826_, _tmp827_, _tmp828_, (ValaCodeNode*) self);
				_tmp830_ = _tmp829_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp830_);
				_vala_code_node_unref0 (_tmp830_);
			}
		}
		_tmp832_ = m;
		if (_tmp832_ != NULL) {
			ValaMethod* _tmp833_;
			gboolean _tmp834_;
			gboolean _tmp835_;
			_tmp833_ = m;
			_tmp834_ = vala_method_get_coroutine (_tmp833_);
			_tmp835_ = _tmp834_;
			_tmp831_ = _tmp835_;
		} else {
			_tmp831_ = FALSE;
		}
		if (_tmp831_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp836_;
			ValaExpression* _tmp837_;
			ValaMemberAccess* _tmp838_;
			const gchar* _tmp839_;
			const gchar* _tmp840_;
			_tmp836_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp837_ = _tmp836_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp837_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp838_ = ma;
			_tmp839_ = vala_member_access_get_member_name (_tmp838_);
			_tmp840_ = _tmp839_;
			if (g_strcmp0 (_tmp840_, "end") == 0) {
				ValaMethod* _tmp841_;
				ValaMethod* _tmp842_;
				ValaSourceReference* _tmp843_;
				ValaSourceReference* _tmp844_;
				ValaMethodType* _tmp845_;
				_tmp841_ = m;
				_tmp842_ = vala_method_get_end_method (_tmp841_);
				_tmp843_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp844_ = _tmp843_;
				_tmp845_ = vala_method_type_new (_tmp842_, _tmp844_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp845_;
			}
		}
	}
	_tmp846_ = vala_code_context_get_analyzer (context);
	_tmp847_ = _tmp846_;
	_tmp848_ = mtype;
	_tmp849_ = params;
	_tmp850_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp847_, (ValaExpression*) self, _tmp848_, _tmp849_, _tmp850_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp851_;
		gint _arg_size = 0;
		ValaList* _tmp852_;
		gint _tmp853_;
		gint _tmp854_;
		gint _arg_index = 0;
		_tmp851_ = self->priv->argument_list;
		_arg_list = _tmp851_;
		_tmp852_ = _arg_list;
		_tmp853_ = vala_collection_get_size ((ValaCollection*) _tmp852_);
		_tmp854_ = _tmp853_;
		_arg_size = _tmp854_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp855_;
			gint _tmp856_;
			ValaExpression* arg = NULL;
			ValaList* _tmp857_;
			gpointer _tmp858_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp859_;
			gboolean _tmp860_ = FALSE;
			ValaSizeofExpression* _tmp861_;
			_arg_index = _arg_index + 1;
			_tmp855_ = _arg_index;
			_tmp856_ = _arg_size;
			if (!(_tmp855_ < _tmp856_)) {
				break;
			}
			_tmp857_ = _arg_list;
			_tmp858_ = vala_list_get (_tmp857_, _arg_index);
			arg = (ValaExpression*) _tmp858_;
			_tmp859_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp859_) ? ((ValaSizeofExpression*) _tmp859_) : NULL;
			_tmp861_ = sizeof_expr;
			if (_tmp861_ != NULL) {
				ValaSizeofExpression* _tmp862_;
				ValaDataType* _tmp863_;
				ValaDataType* _tmp864_;
				_tmp862_ = sizeof_expr;
				_tmp863_ = vala_sizeof_expression_get_type_reference (_tmp862_);
				_tmp864_ = _tmp863_;
				_tmp860_ = VALA_IS_GENERIC_TYPE (_tmp864_);
			} else {
				_tmp860_ = FALSE;
			}
			if (_tmp860_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp865_;
				ValaDataType* _tmp866_;
				ValaDataType* _tmp867_;
				ValaDataType* _tmp868_;
				ValaList* _tmp869_;
				ValaDataType* _tmp870_;
				ValaExpression* _tmp871_;
				ValaDataType* _tmp872_;
				ValaSourceReference* _tmp873_;
				ValaSourceReference* _tmp874_;
				ValaSizeofExpression* _tmp875_;
				ValaSizeofExpression* _tmp876_;
				_tmp865_ = sizeof_expr;
				_tmp866_ = vala_sizeof_expression_get_type_reference (_tmp865_);
				_tmp867_ = _tmp866_;
				_tmp868_ = target_object_type;
				_tmp869_ = method_type_args;
				_tmp870_ = vala_data_type_get_actual_type (_tmp867_, _tmp868_, _tmp869_, (ValaCodeNode*) self);
				sizeof_type = _tmp870_;
				_tmp871_ = arg;
				_tmp872_ = sizeof_type;
				_tmp873_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp874_ = _tmp873_;
				_tmp875_ = vala_sizeof_expression_new (_tmp872_, _tmp874_);
				_tmp876_ = _tmp875_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp871_, (ValaExpression*) _tmp876_);
				_vala_code_node_unref0 (_tmp876_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp879_ = base_cm;
	if (_tmp879_ != NULL) {
		ValaCreationMethod* _tmp880_;
		_tmp880_ = base_cm;
		_tmp878_ = vala_method_is_variadic ((ValaMethod*) _tmp880_);
	} else {
		_tmp878_ = FALSE;
	}
	if (_tmp878_) {
		ValaList* _tmp881_;
		gint _tmp882_;
		gint _tmp883_;
		ValaCreationMethod* _tmp884_;
		ValaList* _tmp885_;
		gint _tmp886_;
		gint _tmp887_;
		_tmp881_ = self->priv->argument_list;
		_tmp882_ = vala_collection_get_size ((ValaCollection*) _tmp881_);
		_tmp883_ = _tmp882_;
		_tmp884_ = base_cm;
		_tmp885_ = vala_callable_get_parameters ((ValaCallable*) _tmp884_);
		_tmp886_ = vala_collection_get_size ((ValaCollection*) _tmp885_);
		_tmp887_ = _tmp886_;
		_tmp877_ = _tmp883_ == _tmp887_;
	} else {
		_tmp877_ = FALSE;
	}
	if (_tmp877_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp888_;
		ValaList* _tmp889_;
		gint _tmp890_;
		gint _tmp891_;
		gpointer _tmp892_;
		gboolean _tmp893_ = FALSE;
		ValaExpression* _tmp894_;
		ValaDataType* _tmp895_;
		ValaDataType* _tmp896_;
		_tmp888_ = self->priv->argument_list;
		_tmp889_ = self->priv->argument_list;
		_tmp890_ = vala_collection_get_size ((ValaCollection*) _tmp889_);
		_tmp891_ = _tmp890_;
		_tmp892_ = vala_list_get (_tmp888_, _tmp891_ - 1);
		this_last_arg = (ValaExpression*) _tmp892_;
		_tmp894_ = this_last_arg;
		_tmp895_ = vala_expression_get_value_type (_tmp894_);
		_tmp896_ = _tmp895_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp896_)) {
			ValaExpression* _tmp897_;
			ValaDataType* _tmp898_;
			ValaDataType* _tmp899_;
			ValaTypeSymbol* _tmp900_;
			ValaTypeSymbol* _tmp901_;
			ValaSemanticAnalyzer* _tmp902_;
			ValaSemanticAnalyzer* _tmp903_;
			ValaDataType* _tmp904_;
			ValaTypeSymbol* _tmp905_;
			ValaTypeSymbol* _tmp906_;
			_tmp897_ = this_last_arg;
			_tmp898_ = vala_expression_get_value_type (_tmp897_);
			_tmp899_ = _tmp898_;
			_tmp900_ = vala_data_type_get_type_symbol (_tmp899_);
			_tmp901_ = _tmp900_;
			_tmp902_ = vala_code_context_get_analyzer (context);
			_tmp903_ = _tmp902_;
			_tmp904_ = _tmp903_->va_list_type;
			_tmp905_ = vala_data_type_get_type_symbol (_tmp904_);
			_tmp906_ = _tmp905_;
			_tmp893_ = _tmp901_ == _tmp906_;
		} else {
			_tmp893_ = FALSE;
		}
		if (_tmp893_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp907_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp908_ = _tmp907_;
	vala_code_node_check ((ValaCodeNode*) _tmp908_, context);
	_tmp909_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp910_ = _tmp909_;
	if (_tmp910_) {
		gboolean _tmp911_ = FALSE;
		ValaCodeNode* _tmp912_;
		ValaCodeNode* _tmp913_;
		_tmp912_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp913_ = _tmp912_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp913_)) {
			_tmp911_ = TRUE;
		} else {
			ValaCodeNode* _tmp914_;
			ValaCodeNode* _tmp915_;
			_tmp914_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp915_ = _tmp914_;
			_tmp911_ = VALA_IS_EXPRESSION_STATEMENT (_tmp915_);
		}
		if (_tmp911_) {
		} else {
			ValaSemanticAnalyzer* _tmp916_;
			ValaSemanticAnalyzer* _tmp917_;
			ValaSymbol* _tmp918_;
			ValaSymbol* _tmp919_;
			_tmp916_ = vala_code_context_get_analyzer (context);
			_tmp917_ = _tmp916_;
			_tmp918_ = vala_semantic_analyzer_get_current_symbol (_tmp917_);
			_tmp919_ = _tmp918_;
			if (!VALA_IS_BLOCK (_tmp919_)) {
				ValaSourceReference* _tmp920_;
				ValaSourceReference* _tmp921_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp920_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp921_ = _tmp920_;
				vala_report_error (_tmp921_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp922_;
				ValaCodeNode* _tmp923_;
				ValaCodeNode* _tmp924_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp925_;
				ValaDataType* _tmp926_;
				ValaDataType* _tmp927_;
				ValaDataType* _tmp928_;
				gchar* _tmp929_;
				gchar* _tmp930_;
				ValaSourceReference* _tmp931_;
				ValaSourceReference* _tmp932_;
				ValaLocalVariable* _tmp933_;
				ValaLocalVariable* _tmp934_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp935_;
				ValaSourceReference* _tmp936_;
				ValaSourceReference* _tmp937_;
				ValaDeclarationStatement* _tmp938_;
				ValaDataType* _tmp939_;
				ValaDataType* _tmp940_;
				ValaSemanticAnalyzer* _tmp944_;
				ValaSemanticAnalyzer* _tmp945_;
				ValaBlock* _tmp946_;
				ValaDeclarationStatement* _tmp947_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp948_;
				ValaDataType* _tmp949_;
				ValaDataType* _tmp950_;
				ValaExpression* _tmp951_;
				ValaExpression* _tmp952_;
				ValaDataType* _tmp953_;
				ValaDataType* _tmp954_;
				ValaLocalVariable* _tmp955_;
				ValaDeclarationStatement* _tmp956_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp957_;
				ValaSemanticAnalyzer* _tmp958_;
				ValaSymbol* _tmp959_;
				ValaSymbol* _tmp960_;
				ValaBlock* _tmp961_;
				ValaBlock* _tmp962_;
				ValaLocalVariable* _tmp963_;
				ValaSemanticAnalyzer* _tmp964_;
				ValaSemanticAnalyzer* _tmp965_;
				ValaBlock* _tmp966_;
				ValaLocalVariable* _tmp967_;
				ValaCodeNode* _tmp968_;
				ValaExpression* _tmp969_;
				ValaExpression* _tmp970_;
				_tmp922_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp923_ = _tmp922_;
				_tmp924_ = _vala_code_node_ref0 (_tmp923_);
				old_parent_node = _tmp924_;
				_tmp925_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp926_ = _tmp925_;
				_tmp927_ = vala_data_type_copy (_tmp926_);
				_tmp928_ = _tmp927_;
				_tmp929_ = vala_code_node_get_temp_name ();
				_tmp930_ = _tmp929_;
				_tmp931_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp932_ = _tmp931_;
				_tmp933_ = vala_local_variable_new (_tmp928_, _tmp930_, NULL, _tmp932_);
				_tmp934_ = _tmp933_;
				_g_free0 (_tmp930_);
				_vala_code_node_unref0 (_tmp928_);
				local = _tmp934_;
				_tmp935_ = local;
				_tmp936_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp937_ = _tmp936_;
				_tmp938_ = vala_declaration_statement_new ((ValaSymbol*) _tmp935_, _tmp937_);
				decl = _tmp938_;
				_tmp939_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp940_ = _tmp939_;
				if (_tmp940_ == NULL) {
					ValaLocalVariable* _tmp941_;
					ValaDataType* _tmp942_;
					ValaDataType* _tmp943_;
					_tmp941_ = local;
					_tmp942_ = vala_variable_get_variable_type ((ValaVariable*) _tmp941_);
					_tmp943_ = _tmp942_;
					vala_data_type_set_floating_reference (_tmp943_, FALSE);
				}
				_tmp944_ = vala_code_context_get_analyzer (context);
				_tmp945_ = _tmp944_;
				_tmp946_ = _tmp945_->insert_block;
				_tmp947_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp946_, (ValaStatement*) _tmp947_);
				_tmp948_ = local;
				_tmp949_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp950_ = _tmp949_;
				_tmp951_ = vala_semantic_analyzer_create_temp_access (_tmp948_, _tmp950_);
				temp_access = _tmp951_;
				_tmp952_ = temp_access;
				_tmp953_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp954_ = _tmp953_;
				vala_expression_set_formal_target_type (_tmp952_, _tmp954_);
				_tmp955_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp955_, (ValaExpression*) self);
				_tmp956_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp956_, context);
				_tmp957_ = vala_code_context_get_analyzer (context);
				_tmp958_ = _tmp957_;
				_tmp959_ = vala_semantic_analyzer_get_current_symbol (_tmp958_);
				_tmp960_ = _tmp959_;
				_tmp961_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp960_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp961_;
				_tmp962_ = block;
				_tmp963_ = local;
				vala_block_remove_local_variable (_tmp962_, _tmp963_);
				_tmp964_ = vala_code_context_get_analyzer (context);
				_tmp965_ = _tmp964_;
				_tmp966_ = _tmp965_->insert_block;
				_tmp967_ = local;
				vala_block_add_local_variable (_tmp966_, _tmp967_);
				_tmp968_ = old_parent_node;
				_tmp969_ = temp_access;
				vala_code_node_replace_expression (_tmp968_, (ValaExpression*) self, _tmp969_);
				_tmp970_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp970_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp971_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp972_ = _tmp971_;
	result = !_tmp972_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_call = vala_method_call_real_get_call;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
	iface->get_is_chainup = vala_method_call_real_get_is_chainup;
	iface->set_is_chainup = vala_method_call_real_set_is_chainup;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__once = 0;
	if (g_once_init_enter (&vala_method_call_type_id__once)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__once, vala_method_call_type_id);
	}
	return vala_method_call_type_id__once;
}

