#pragma once
/*
    #version:1# (machine generated, don't edit!)

    Generated by sokol-shdc (https://github.com/floooh/sokol-tools)

    Cmdline: sokol-shdc --input ../src/sokol/shader.glsl --output ../src/sokol/generated/shader.h --slang glsl330:hlsl5:metal_macos:metal_ios:metal_sim:glsl300es:glsl100

    Overview:

        Shader program 'rive_tess':
            Get shader desc: rive_tess_shader_desc(sg_query_backend());
            Vertex shader: vs
                Attribute slots:
                    ATTR_vs_position = 0
                    ATTR_vs_texcoord0 = 1
                Uniform block 'vs_params':
                    C struct: vs_params_t
                    Bind slot: SLOT_vs_params = 0
            Fragment shader: fs
                Image 'tex':
                    Type: SG_IMAGETYPE_2D
                    Component Type: SG_SAMPLERTYPE_FLOAT
                    Bind slot: SLOT_tex = 0

        Shader program 'rive_tess_path':
            Get shader desc: rive_tess_path_shader_desc(sg_query_backend());
            Vertex shader: vs_path
                Attribute slots:
                    ATTR_vs_path_position = 0
                Uniform block 'vs_path_params':
                    C struct: vs_path_params_t
                    Bind slot: SLOT_vs_path_params = 0
            Fragment shader: fs_path
                Uniform block 'fs_path_uniforms':
                    C struct: fs_path_uniforms_t
                    Bind slot: SLOT_fs_path_uniforms = 0


    Shader descriptor structs:

        sg_shader rive_tess = sg_make_shader(rive_tess_shader_desc(sg_query_backend()));
        sg_shader rive_tess_path = sg_make_shader(rive_tess_path_shader_desc(sg_query_backend()));

    Vertex attribute locations for vertex shader 'vs':

        sg_pipeline pip = sg_make_pipeline(&(sg_pipeline_desc){
            .layout = {
                .attrs = {
                    [ATTR_vs_position] = { ... },
                    [ATTR_vs_texcoord0] = { ... },
                },
            },
            ...});

    Vertex attribute locations for vertex shader 'vs_path':

        sg_pipeline pip = sg_make_pipeline(&(sg_pipeline_desc){
            .layout = {
                .attrs = {
                    [ATTR_vs_path_position] = { ... },
                },
            },
            ...});

    Image bind slots, use as index in sg_bindings.vs_images[] or .fs_images[]

        SLOT_tex = 0;

    Bind slot and C-struct for uniform block 'vs_params':

        vs_params_t vs_params = {
            .mvp = ...;
        };
        sg_apply_uniforms(SG_SHADERSTAGE_[VS|FS], SLOT_vs_params, &SG_RANGE(vs_params));

    Bind slot and C-struct for uniform block 'vs_path_params':

        vs_path_params_t vs_path_params = {
            .mvp = ...;
            .fillType = ...;
            .gradientStart = ...;
            .gradientEnd = ...;
        };
        sg_apply_uniforms(SG_SHADERSTAGE_[VS|FS], SLOT_vs_path_params, &SG_RANGE(vs_path_params));

    Bind slot and C-struct for uniform block 'fs_path_uniforms':

        fs_path_uniforms_t fs_path_uniforms = {
            .fillType = ...;
            .colors = ...;
            .stops = ...;
            .stopCount = ...;
        };
        sg_apply_uniforms(SG_SHADERSTAGE_[VS|FS], SLOT_fs_path_uniforms, &SG_RANGE(fs_path_uniforms));

*/
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <stddef.h>
#if !defined(SOKOL_SHDC_ALIGN)
  #if defined(_MSC_VER)
    #define SOKOL_SHDC_ALIGN(a) __declspec(align(a))
  #else
    #define SOKOL_SHDC_ALIGN(a) __attribute__((aligned(a)))
  #endif
#endif
#define ATTR_vs_position (0)
#define ATTR_vs_texcoord0 (1)
#define ATTR_vs_path_position (0)
#define SLOT_tex (0)
#define SLOT_vs_params (0)
#pragma pack(push,1)
SOKOL_SHDC_ALIGN(16) typedef struct vs_params_t {
    rive::Mat4 mvp;
} vs_params_t;
#pragma pack(pop)
#define SLOT_vs_path_params (0)
#pragma pack(push,1)
SOKOL_SHDC_ALIGN(16) typedef struct vs_path_params_t {
    rive::Mat4 mvp;
    int fillType;
    uint8_t _pad_68[4];
    rive::Vec2D gradientStart;
    rive::Vec2D gradientEnd;
    uint8_t _pad_88[8];
} vs_path_params_t;
#pragma pack(pop)
#define SLOT_fs_path_uniforms (0)
#pragma pack(push,1)
SOKOL_SHDC_ALIGN(16) typedef struct fs_path_uniforms_t {
    int fillType;
    uint8_t _pad_4[12];
    float colors[16][4];
    float stops[4][4];
    int stopCount;
    uint8_t _pad_340[12];
} fs_path_uniforms_t;
#pragma pack(pop)
/*
    #version 330
    
    uniform vec4 vs_params[4];
    layout(location = 0) in vec2 position;
    out vec2 uv;
    layout(location = 1) in vec2 texcoord0;
    
    void main()
    {
        gl_Position = mat4(vs_params[0], vs_params[1], vs_params[2], vs_params[3]) * vec4(position.x, position.y, 0.0, 1.0);
        uv = texcoord0;
    }
    
*/
static const char vs_source_glsl330[293] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x33,0x30,0x0a,0x0a,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x76,0x73,0x5f,0x70,0x61,
    0x72,0x61,0x6d,0x73,0x5b,0x34,0x5d,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,
    0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x69,0x6e,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,
    0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x75,0x76,0x3b,0x0a,0x6c,0x61,0x79,
    0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x31,
    0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x32,0x20,0x74,0x65,0x78,0x63,0x6f,0x6f,
    0x72,0x64,0x30,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,
    0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x20,0x3d,0x20,0x6d,0x61,0x74,0x34,0x28,0x76,0x73,0x5f,0x70,0x61,
    0x72,0x61,0x6d,0x73,0x5b,0x30,0x5d,0x2c,0x20,0x76,0x73,0x5f,0x70,0x61,0x72,0x61,
    0x6d,0x73,0x5b,0x31,0x5d,0x2c,0x20,0x76,0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,
    0x5b,0x32,0x5d,0x2c,0x20,0x76,0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x5b,0x33,
    0x5d,0x29,0x20,0x2a,0x20,0x76,0x65,0x63,0x34,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,
    0x6f,0x6e,0x2e,0x78,0x2c,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x79,
    0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x75,0x76,0x20,0x3d,0x20,0x74,0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x3b,
    0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 330
    
    uniform sampler2D tex;
    
    layout(location = 0) out vec4 frag_color;
    in vec2 uv;
    
    void main()
    {
        frag_color = texture(tex, uv);
    }
    
*/
static const char fs_source_glsl330[146] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x33,0x30,0x0a,0x0a,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x32,0x44,0x20,
    0x74,0x65,0x78,0x3b,0x0a,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,
    0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x6f,0x75,0x74,0x20,0x76,
    0x65,0x63,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,
    0x69,0x6e,0x20,0x76,0x65,0x63,0x32,0x20,0x75,0x76,0x3b,0x0a,0x0a,0x76,0x6f,0x69,
    0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x74,0x65,0x78,0x74,
    0x75,0x72,0x65,0x28,0x74,0x65,0x78,0x2c,0x20,0x75,0x76,0x29,0x3b,0x0a,0x7d,0x0a,
    0x0a,0x00,
};
/*
    #version 330
    
    struct vs_path_params
    {
        mat4 mvp;
        int fillType;
        vec2 gradientStart;
        vec2 gradientEnd;
    };
    
    uniform vs_path_params _22;
    
    layout(location = 0) in vec2 position;
    out vec2 gradient_uv;
    
    void main()
    {
        gl_Position = _22.mvp * vec4(position, 0.0, 1.0);
        if (_22.fillType == 1)
        {
            vec2 _54 = _22.gradientEnd - _22.gradientStart;
            float _59 = _54.x;
            float _64 = _54.y;
            gradient_uv.x = dot(position - _22.gradientStart, _54) / ((_59 * _59) + (_64 * _64));
        }
        else
        {
            if (_22.fillType == 2)
            {
                gradient_uv = (position - _22.gradientStart) / vec2(distance(_22.gradientStart, _22.gradientEnd));
            }
        }
    }
    
*/
static const char vs_path_source_glsl330[709] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x33,0x30,0x0a,0x0a,0x73,0x74,
    0x72,0x75,0x63,0x74,0x20,0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x70,0x61,0x72,
    0x61,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x74,0x34,0x20,0x6d,
    0x76,0x70,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,0x6c,0x6c,
    0x54,0x79,0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,
    0x6e,0x64,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,
    0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x20,0x5f,
    0x32,0x32,0x3b,0x0a,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,
    0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,
    0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x6f,0x75,0x74,0x20,
    0x76,0x65,0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,
    0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x20,0x3d,0x20,0x5f,0x32,0x32,0x2e,0x6d,0x76,0x70,0x20,0x2a,0x20,0x76,0x65,0x63,
    0x34,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x30,0x2e,0x30,0x2c,
    0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,
    0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x31,
    0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x32,0x20,0x5f,0x35,0x34,0x20,0x3d,0x20,0x5f,0x32,0x32,0x2e,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,0x20,0x2d,0x20,0x5f,0x32,0x32,
    0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x35,
    0x39,0x20,0x3d,0x20,0x5f,0x35,0x34,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x34,0x20,0x3d,0x20,0x5f,
    0x35,0x34,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x67,0x72,
    0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x20,0x3d,0x20,0x64,0x6f,
    0x74,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,0x5f,0x32,0x32,
    0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,
    0x5f,0x35,0x34,0x29,0x20,0x2f,0x20,0x28,0x28,0x5f,0x35,0x39,0x20,0x2a,0x20,0x5f,
    0x35,0x39,0x29,0x20,0x2b,0x20,0x28,0x5f,0x36,0x34,0x20,0x2a,0x20,0x5f,0x36,0x34,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,
    0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x69,0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,
    0x65,0x20,0x3d,0x3d,0x20,0x32,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x67,0x72,
    0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,0x3d,0x20,0x28,0x70,0x6f,0x73,
    0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,
    0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x29,0x20,0x2f,0x20,0x76,0x65,0x63,
    0x32,0x28,0x64,0x69,0x73,0x74,0x61,0x6e,0x63,0x65,0x28,0x5f,0x32,0x32,0x2e,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,0x5f,0x32,
    0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x7d,
    0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 330
    
    struct fs_path_uniforms
    {
        int fillType;
        vec4 colors[16];
        vec4 stops[4];
        int stopCount;
    };
    
    uniform fs_path_uniforms _18;
    
    layout(location = 0) out vec4 frag_color;
    in vec2 gradient_uv;
    
    void main()
    {
        if (_18.fillType == 0)
        {
            frag_color = _18.colors[0];
        }
        else
        {
            float _39;
            if (_18.fillType == 1)
            {
                _39 = gradient_uv.x;
            }
            else
            {
                _39 = length(gradient_uv);
            }
            vec4 color = mix(_18.colors[0], _18.colors[1], vec4(smoothstep(_18.stops[0].x, _18.stops[0].y, _39)));
            for (int i = 1; i < 15; i++)
            {
                if (i >= (_18.stopCount - 1))
                {
                    break;
                }
                int _91 = i + 1;
                color = mix(color, _18.colors[_91], vec4(smoothstep(_18.stops[i / 4][i % 4], _18.stops[_91 / 4][_91 % 4], _39)));
            }
            frag_color = color;
        }
    }
    
*/
static const char fs_path_source_glsl330[949] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x33,0x30,0x0a,0x0a,0x73,0x74,
    0x72,0x75,0x63,0x74,0x20,0x66,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,
    0x66,0x6f,0x72,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,
    0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x36,0x5d,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x34,0x20,0x73,0x74,0x6f,0x70,0x73,0x5b,0x34,0x5d,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x73,0x74,0x6f,0x70,0x43,0x6f,
    0x75,0x6e,0x74,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,
    0x20,0x66,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,
    0x73,0x20,0x5f,0x31,0x38,0x3b,0x0a,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,
    0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x6f,0x75,0x74,
    0x20,0x76,0x65,0x63,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,
    0x3b,0x0a,0x69,0x6e,0x20,0x76,0x65,0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x5f,0x75,0x76,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,
    0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,
    0x38,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x30,0x29,
    0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,
    0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x5f,0x31,0x38,0x2e,
    0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,
    0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,
    0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,
    0x31,0x38,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x31,
    0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x67,0x72,
    0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x65,
    0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,
    0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,
    0x75,0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,0x6c,0x6f,
    0x72,0x20,0x3d,0x20,0x6d,0x69,0x78,0x28,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,
    0x72,0x73,0x5b,0x30,0x5d,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,
    0x73,0x5b,0x31,0x5d,0x2c,0x20,0x76,0x65,0x63,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,
    0x68,0x73,0x74,0x65,0x70,0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,
    0x30,0x5d,0x2e,0x78,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,
    0x30,0x5d,0x2e,0x79,0x2c,0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,
    0x20,0x3d,0x20,0x31,0x3b,0x20,0x69,0x20,0x3c,0x20,0x31,0x35,0x3b,0x20,0x69,0x2b,
    0x2b,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x20,0x3e,
    0x3d,0x20,0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,0x6e,0x74,
    0x20,0x2d,0x20,0x31,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x62,0x72,0x65,0x61,0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x39,0x31,0x20,0x3d,0x20,
    0x69,0x20,0x2b,0x20,0x31,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x6d,0x69,0x78,0x28,0x63,
    0x6f,0x6c,0x6f,0x72,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,
    0x5b,0x5f,0x39,0x31,0x5d,0x2c,0x20,0x76,0x65,0x63,0x34,0x28,0x73,0x6d,0x6f,0x6f,
    0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,
    0x5b,0x69,0x20,0x2f,0x20,0x34,0x5d,0x5b,0x69,0x20,0x25,0x20,0x34,0x5d,0x2c,0x20,
    0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x5f,0x39,0x31,0x20,0x2f,0x20,
    0x34,0x5d,0x5b,0x5f,0x39,0x31,0x20,0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x33,0x39,
    0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,
    0x72,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,
    0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 100
    
    uniform vec4 vs_params[4];
    attribute vec2 position;
    varying vec2 uv;
    attribute vec2 texcoord0;
    
    void main()
    {
        gl_Position = mat4(vs_params[0], vs_params[1], vs_params[2], vs_params[3]) * vec4(position.x, position.y, 0.0, 1.0);
        uv = texcoord0;
    }
    
*/
static const char vs_source_glsl100[269] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x31,0x30,0x30,0x0a,0x0a,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x76,0x73,0x5f,0x70,0x61,
    0x72,0x61,0x6d,0x73,0x5b,0x34,0x5d,0x3b,0x0a,0x61,0x74,0x74,0x72,0x69,0x62,0x75,
    0x74,0x65,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x3b,0x0a,0x76,0x61,0x72,0x79,0x69,0x6e,0x67,0x20,0x76,0x65,0x63,0x32,0x20,0x75,
    0x76,0x3b,0x0a,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x20,0x76,0x65,0x63,
    0x32,0x20,0x74,0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x3b,0x0a,0x0a,0x76,0x6f,
    0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x6d,0x61,
    0x74,0x34,0x28,0x76,0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x5b,0x30,0x5d,0x2c,
    0x20,0x76,0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x5b,0x31,0x5d,0x2c,0x20,0x76,
    0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x5b,0x32,0x5d,0x2c,0x20,0x76,0x73,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x5b,0x33,0x5d,0x29,0x20,0x2a,0x20,0x76,0x65,0x63,
    0x34,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x78,0x2c,0x20,0x70,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x75,0x76,0x20,0x3d,0x20,0x74,0x65,
    0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 100
    precision mediump float;
    precision highp int;
    
    uniform highp sampler2D tex;
    
    varying highp vec2 uv;
    
    void main()
    {
        gl_FragData[0] = texture2D(tex, uv);
    }
    
*/
static const char fs_source_glsl100[173] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x31,0x30,0x30,0x0a,0x70,0x72,0x65,
    0x63,0x69,0x73,0x69,0x6f,0x6e,0x20,0x6d,0x65,0x64,0x69,0x75,0x6d,0x70,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x3b,0x0a,0x70,0x72,0x65,0x63,0x69,0x73,0x69,0x6f,0x6e,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x69,0x6e,0x74,0x3b,0x0a,0x0a,0x75,0x6e,0x69,0x66,
    0x6f,0x72,0x6d,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,
    0x72,0x32,0x44,0x20,0x74,0x65,0x78,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x79,0x69,0x6e,
    0x67,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x75,0x76,0x3b,
    0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x46,0x72,0x61,0x67,0x44,0x61,0x74,0x61,0x5b,
    0x30,0x5d,0x20,0x3d,0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x44,0x28,0x74,
    0x65,0x78,0x2c,0x20,0x75,0x76,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 100
    
    struct vs_path_params
    {
        mat4 mvp;
        int fillType;
        vec2 gradientStart;
        vec2 gradientEnd;
    };
    
    uniform vs_path_params _22;
    
    attribute vec2 position;
    varying vec2 gradient_uv;
    
    void main()
    {
        gl_Position = _22.mvp * vec4(position, 0.0, 1.0);
        if (_22.fillType == 1)
        {
            vec2 _54 = _22.gradientEnd - _22.gradientStart;
            float _59 = _54.x;
            float _64 = _54.y;
            gradient_uv.x = dot(position - _22.gradientStart, _54) / ((_59 * _59) + (_64 * _64));
        }
        else
        {
            if (_22.fillType == 2)
            {
                gradient_uv = (position - _22.gradientStart) / vec2(distance(_22.gradientStart, _22.gradientEnd));
            }
        }
    }
    
*/
static const char vs_path_source_glsl100[699] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x31,0x30,0x30,0x0a,0x0a,0x73,0x74,
    0x72,0x75,0x63,0x74,0x20,0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x70,0x61,0x72,
    0x61,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x74,0x34,0x20,0x6d,
    0x76,0x70,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,0x6c,0x6c,
    0x54,0x79,0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,
    0x6e,0x64,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,
    0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x20,0x5f,
    0x32,0x32,0x3b,0x0a,0x0a,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x20,0x76,
    0x65,0x63,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x76,0x61,
    0x72,0x79,0x69,0x6e,0x67,0x20,0x76,0x65,0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,
    0x65,0x6e,0x74,0x5f,0x75,0x76,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,
    0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x5f,0x32,0x32,0x2e,0x6d,0x76,0x70,
    0x20,0x2a,0x20,0x76,0x65,0x63,0x34,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x69,0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,
    0x65,0x20,0x3d,0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x35,0x34,0x20,0x3d,
    0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,
    0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,
    0x74,0x61,0x72,0x74,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x35,0x39,0x20,0x3d,0x20,0x5f,0x35,0x34,0x2e,0x78,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x36,0x34,0x20,0x3d,0x20,0x5f,0x35,0x34,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x2e,
    0x78,0x20,0x3d,0x20,0x64,0x6f,0x74,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,
    0x74,0x61,0x72,0x74,0x2c,0x20,0x5f,0x35,0x34,0x29,0x20,0x2f,0x20,0x28,0x28,0x5f,
    0x35,0x39,0x20,0x2a,0x20,0x5f,0x35,0x39,0x29,0x20,0x2b,0x20,0x28,0x5f,0x36,0x34,
    0x20,0x2a,0x20,0x5f,0x36,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,
    0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,
    0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x32,0x29,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,
    0x3d,0x20,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,0x5f,0x32,
    0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x29,
    0x20,0x2f,0x20,0x76,0x65,0x63,0x32,0x28,0x64,0x69,0x73,0x74,0x61,0x6e,0x63,0x65,
    0x28,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,
    0x72,0x74,0x2c,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,
    0x45,0x6e,0x64,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,
    0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 100
    precision mediump float;
    precision highp int;
    
    struct fs_path_uniforms
    {
        int fillType;
        highp vec4 colors[16];
        highp vec4 stops[4];
        int stopCount;
    };
    
    uniform fs_path_uniforms _18;
    
    varying highp vec2 gradient_uv;
    
    void main()
    {
        if (_18.fillType == 0)
        {
            gl_FragData[0] = _18.colors[0];
        }
        else
        {
            highp float _39;
            if (_18.fillType == 1)
            {
                _39 = gradient_uv.x;
            }
            else
            {
                _39 = length(gradient_uv);
            }
            highp vec4 color = mix(_18.colors[0], _18.colors[1], vec4(smoothstep(_18.stops[0].x, _18.stops[0].y, _39)));
            for (int i = 1; i < 15; i++)
            {
                if (i >= (_18.stopCount - 1))
                {
                    break;
                }
                int _91 = i + 1;
                color = mix(color, _18.colors[_91], vec4(smoothstep(_18.stops[i / 4][i % 4], _18.stops[_91 / 4][_91 % 4], _39)));
            }
            gl_FragData[0] = color;
        }
    }
    
*/
static const char fs_path_source_glsl100[996] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x31,0x30,0x30,0x0a,0x70,0x72,0x65,
    0x63,0x69,0x73,0x69,0x6f,0x6e,0x20,0x6d,0x65,0x64,0x69,0x75,0x6d,0x70,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x3b,0x0a,0x70,0x72,0x65,0x63,0x69,0x73,0x69,0x6f,0x6e,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x69,0x6e,0x74,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,
    0x63,0x74,0x20,0x66,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,
    0x6c,0x6c,0x54,0x79,0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x36,
    0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x34,0x20,0x73,0x74,0x6f,0x70,0x73,0x5b,0x34,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x69,0x6e,0x74,0x20,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,0x6e,0x74,0x3b,0x0a,0x7d,
    0x3b,0x0a,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x66,0x73,0x5f,0x70,0x61,
    0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x20,0x5f,0x31,0x38,0x3b,
    0x0a,0x0a,0x76,0x61,0x72,0x79,0x69,0x6e,0x67,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x76,0x65,0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,
    0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,0x69,0x6c,
    0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0a,0x20,0x20,0x20,0x20,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x46,0x72,0x61,
    0x67,0x44,0x61,0x74,0x61,0x5b,0x30,0x5d,0x20,0x3d,0x20,0x5f,0x31,0x38,0x2e,0x63,
    0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,
    0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x5f,0x33,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,
    0x20,0x3d,0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,
    0x20,0x3d,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,
    0x33,0x39,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x67,0x72,0x61,0x64,
    0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x6d,
    0x69,0x78,0x28,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,
    0x2c,0x20,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x5d,0x2c,
    0x20,0x76,0x65,0x63,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,
    0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x2c,
    0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x79,0x2c,
    0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,0x20,0x3d,0x20,0x31,0x3b,
    0x20,0x69,0x20,0x3c,0x20,0x31,0x35,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x20,0x3e,0x3d,0x20,0x28,0x5f,0x31,
    0x38,0x2e,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,0x6e,0x74,0x20,0x2d,0x20,0x31,0x29,
    0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x62,0x72,0x65,0x61,0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x69,0x6e,0x74,0x20,0x5f,0x39,0x31,0x20,0x3d,0x20,0x69,0x20,0x2b,0x20,0x31,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x63,0x6f,
    0x6c,0x6f,0x72,0x20,0x3d,0x20,0x6d,0x69,0x78,0x28,0x63,0x6f,0x6c,0x6f,0x72,0x2c,
    0x20,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x5f,0x39,0x31,0x5d,
    0x2c,0x20,0x76,0x65,0x63,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,
    0x70,0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x69,0x20,0x2f,0x20,
    0x34,0x5d,0x5b,0x69,0x20,0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x73,
    0x74,0x6f,0x70,0x73,0x5b,0x5f,0x39,0x31,0x20,0x2f,0x20,0x34,0x5d,0x5b,0x5f,0x39,
    0x31,0x20,0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x67,0x6c,0x5f,0x46,0x72,0x61,0x67,0x44,0x61,0x74,0x61,0x5b,0x30,0x5d,
    0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,
    0x7d,0x0a,0x0a,0x00,
};
/*
    #version 300 es
    
    uniform vec4 vs_params[4];
    layout(location = 0) in vec2 position;
    out vec2 uv;
    layout(location = 1) in vec2 texcoord0;
    
    void main()
    {
        gl_Position = mat4(vs_params[0], vs_params[1], vs_params[2], vs_params[3]) * vec4(position.x, position.y, 0.0, 1.0);
        uv = texcoord0;
    }
    
*/
static const char vs_source_glsl300es[296] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x30,0x30,0x20,0x65,0x73,0x0a,
    0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x76,0x73,
    0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x5b,0x34,0x5d,0x3b,0x0a,0x6c,0x61,0x79,0x6f,
    0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,
    0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x3b,0x0a,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x75,0x76,0x3b,0x0a,
    0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,
    0x3d,0x20,0x31,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x32,0x20,0x74,0x65,0x78,
    0x63,0x6f,0x6f,0x72,0x64,0x30,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,
    0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x6d,0x61,0x74,0x34,0x28,0x76,0x73,
    0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x5b,0x30,0x5d,0x2c,0x20,0x76,0x73,0x5f,0x70,
    0x61,0x72,0x61,0x6d,0x73,0x5b,0x31,0x5d,0x2c,0x20,0x76,0x73,0x5f,0x70,0x61,0x72,
    0x61,0x6d,0x73,0x5b,0x32,0x5d,0x2c,0x20,0x76,0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,
    0x73,0x5b,0x33,0x5d,0x29,0x20,0x2a,0x20,0x76,0x65,0x63,0x34,0x28,0x70,0x6f,0x73,
    0x69,0x74,0x69,0x6f,0x6e,0x2e,0x78,0x2c,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x75,0x76,0x20,0x3d,0x20,0x74,0x65,0x78,0x63,0x6f,0x6f,0x72,
    0x64,0x30,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 300 es
    precision mediump float;
    precision highp int;
    
    uniform highp sampler2D tex;
    
    layout(location = 0) out highp vec4 frag_color;
    in highp vec2 uv;
    
    void main()
    {
        frag_color = texture(tex, uv);
    }
    
*/
static const char fs_source_glsl300es[213] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x30,0x30,0x20,0x65,0x73,0x0a,
    0x70,0x72,0x65,0x63,0x69,0x73,0x69,0x6f,0x6e,0x20,0x6d,0x65,0x64,0x69,0x75,0x6d,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x3b,0x0a,0x70,0x72,0x65,0x63,0x69,0x73,0x69,
    0x6f,0x6e,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x69,0x6e,0x74,0x3b,0x0a,0x0a,0x75,
    0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x73,0x61,0x6d,
    0x70,0x6c,0x65,0x72,0x32,0x44,0x20,0x74,0x65,0x78,0x3b,0x0a,0x0a,0x6c,0x61,0x79,
    0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,
    0x29,0x20,0x6f,0x75,0x74,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x34,
    0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x69,0x6e,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x75,0x76,0x3b,0x0a,0x0a,
    0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x74,0x65,0x78,0x2c,0x20,0x75,0x76,0x29,0x3b,
    0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 300 es
    
    struct vs_path_params
    {
        mat4 mvp;
        int fillType;
        vec2 gradientStart;
        vec2 gradientEnd;
    };
    
    uniform vs_path_params _22;
    
    layout(location = 0) in vec2 position;
    out vec2 gradient_uv;
    
    void main()
    {
        gl_Position = _22.mvp * vec4(position, 0.0, 1.0);
        if (_22.fillType == 1)
        {
            vec2 _54 = _22.gradientEnd - _22.gradientStart;
            float _59 = _54.x;
            float _64 = _54.y;
            gradient_uv.x = dot(position - _22.gradientStart, _54) / ((_59 * _59) + (_64 * _64));
        }
        else
        {
            if (_22.fillType == 2)
            {
                gradient_uv = (position - _22.gradientStart) / vec2(distance(_22.gradientStart, _22.gradientEnd));
            }
        }
    }
    
*/
static const char vs_path_source_glsl300es[712] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x30,0x30,0x20,0x65,0x73,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x74,
    0x34,0x20,0x6d,0x76,0x70,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,
    0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,
    0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x45,0x6e,0x64,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x20,0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x70,0x61,0x72,0x61,0x6d,
    0x73,0x20,0x5f,0x32,0x32,0x3b,0x0a,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,
    0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x69,0x6e,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x6f,
    0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,
    0x5f,0x75,0x76,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,
    0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x20,0x3d,0x20,0x5f,0x32,0x32,0x2e,0x6d,0x76,0x70,0x20,0x2a,0x20,
    0x76,0x65,0x63,0x34,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x30,
    0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,
    0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,
    0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x35,0x34,0x20,0x3d,0x20,0x5f,0x32,
    0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,0x20,0x2d,0x20,
    0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,
    0x74,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x35,0x39,0x20,0x3d,0x20,0x5f,0x35,0x34,0x2e,0x78,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x34,0x20,
    0x3d,0x20,0x5f,0x35,0x34,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x20,0x3d,
    0x20,0x64,0x6f,0x74,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,
    0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,
    0x74,0x2c,0x20,0x5f,0x35,0x34,0x29,0x20,0x2f,0x20,0x28,0x28,0x5f,0x35,0x39,0x20,
    0x2a,0x20,0x5f,0x35,0x39,0x29,0x20,0x2b,0x20,0x28,0x5f,0x36,0x34,0x20,0x2a,0x20,
    0x5f,0x36,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,
    0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,
    0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x32,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,0x3d,0x20,0x28,
    0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x29,0x20,0x2f,0x20,
    0x76,0x65,0x63,0x32,0x28,0x64,0x69,0x73,0x74,0x61,0x6e,0x63,0x65,0x28,0x5f,0x32,
    0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,
    0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 300 es
    precision mediump float;
    precision highp int;
    
    struct fs_path_uniforms
    {
        int fillType;
        highp vec4 colors[16];
        highp vec4 stops[4];
        int stopCount;
    };
    
    uniform fs_path_uniforms _18;
    
    layout(location = 0) out highp vec4 frag_color;
    in highp vec2 gradient_uv;
    
    void main()
    {
        if (_18.fillType == 0)
        {
            frag_color = _18.colors[0];
        }
        else
        {
            highp float _39;
            if (_18.fillType == 1)
            {
                _39 = gradient_uv.x;
            }
            else
            {
                _39 = length(gradient_uv);
            }
            highp vec4 color = mix(_18.colors[0], _18.colors[1], vec4(smoothstep(_18.stops[0].x, _18.stops[0].y, _39)));
            for (int i = 1; i < 15; i++)
            {
                if (i >= (_18.stopCount - 1))
                {
                    break;
                }
                int _91 = i + 1;
                color = mix(color, _18.colors[_91], vec4(smoothstep(_18.stops[i / 4][i % 4], _18.stops[_91 / 4][_91 % 4], _39)));
            }
            frag_color = color;
        }
    }
    
*/
static const char fs_path_source_glsl300es[1034] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x30,0x30,0x20,0x65,0x73,0x0a,
    0x70,0x72,0x65,0x63,0x69,0x73,0x69,0x6f,0x6e,0x20,0x6d,0x65,0x64,0x69,0x75,0x6d,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x3b,0x0a,0x70,0x72,0x65,0x63,0x69,0x73,0x69,
    0x6f,0x6e,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x69,0x6e,0x74,0x3b,0x0a,0x0a,0x73,
    0x74,0x72,0x75,0x63,0x74,0x20,0x66,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,
    0x20,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x73,
    0x5b,0x31,0x36,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x76,0x65,0x63,0x34,0x20,0x73,0x74,0x6f,0x70,0x73,0x5b,0x34,0x5d,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,0x6e,0x74,
    0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x66,0x73,
    0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x20,0x5f,
    0x31,0x38,0x3b,0x0a,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,
    0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x6f,0x75,0x74,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,
    0x6c,0x6f,0x72,0x3b,0x0a,0x69,0x6e,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x3b,0x0a,
    0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,0x69,0x6c,0x6c,0x54,
    0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,
    0x6f,0x72,0x20,0x3d,0x20,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,
    0x30,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,
    0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,0x39,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,
    0x38,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x31,0x29,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x67,0x72,0x61,
    0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x65,0x6c,
    0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x6c,
    0x65,0x6e,0x67,0x74,0x68,0x28,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,
    0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x34,
    0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x6d,0x69,0x78,0x28,0x5f,0x31,0x38,
    0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x2c,0x20,0x5f,0x31,0x38,0x2e,
    0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x5d,0x2c,0x20,0x76,0x65,0x63,0x34,0x28,
    0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x5f,0x31,0x38,0x2e,0x73,
    0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x73,
    0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x79,0x2c,0x20,0x5f,0x33,0x39,0x29,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,
    0x69,0x6e,0x74,0x20,0x69,0x20,0x3d,0x20,0x31,0x3b,0x20,0x69,0x20,0x3c,0x20,0x31,
    0x35,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,
    0x20,0x28,0x69,0x20,0x3e,0x3d,0x20,0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,
    0x43,0x6f,0x75,0x6e,0x74,0x20,0x2d,0x20,0x31,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x62,0x72,0x65,0x61,0x6b,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,
    0x39,0x31,0x20,0x3d,0x20,0x69,0x20,0x2b,0x20,0x31,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,
    0x6d,0x69,0x78,0x28,0x63,0x6f,0x6c,0x6f,0x72,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x63,
    0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x5f,0x39,0x31,0x5d,0x2c,0x20,0x76,0x65,0x63,0x34,
    0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x5f,0x31,0x38,0x2e,
    0x73,0x74,0x6f,0x70,0x73,0x5b,0x69,0x20,0x2f,0x20,0x34,0x5d,0x5b,0x69,0x20,0x25,
    0x20,0x34,0x5d,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x5f,
    0x39,0x31,0x20,0x2f,0x20,0x34,0x5d,0x5b,0x5f,0x39,0x31,0x20,0x25,0x20,0x34,0x5d,
    0x2c,0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,
    0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    cbuffer vs_params : register(b0)
    {
        row_major float4x4 _21_mvp : packoffset(c0);
    };
    
    
    static float4 gl_Position;
    static float2 position;
    static float2 uv;
    static float2 texcoord0;
    
    struct SPIRV_Cross_Input
    {
        float2 position : TEXCOORD0;
        float2 texcoord0 : TEXCOORD1;
    };
    
    struct SPIRV_Cross_Output
    {
        float2 uv : TEXCOORD0;
        float4 gl_Position : SV_Position;
    };
    
    #line 16 "../src/sokol/shader.glsl"
    void vert_main()
    {
    #line 16 "../src/sokol/shader.glsl"
        gl_Position = mul(float4(position.x, position.y, 0.0f, 1.0f), _21_mvp);
    #line 17 "../src/sokol/shader.glsl"
        uv = texcoord0;
    }
    
    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        position = stage_input.position;
        texcoord0 = stage_input.texcoord0;
        vert_main();
        SPIRV_Cross_Output stage_output;
        stage_output.gl_Position = gl_Position;
        stage_output.uv = uv;
        return stage_output;
    }
*/
static const char vs_source_hlsl5[890] = {
    0x63,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x76,0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,
    0x73,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,0x28,0x62,0x30,0x29,
    0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x6f,0x77,0x5f,0x6d,0x61,0x6a,0x6f,0x72,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x5f,0x32,0x31,0x5f,0x6d,0x76,
    0x70,0x20,0x3a,0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,
    0x30,0x29,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,
    0x6f,0x6e,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x73,0x74,0x61,0x74,
    0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x75,0x76,0x3b,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x63,
    0x6f,0x6f,0x72,0x64,0x30,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,
    0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,
    0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,
    0x44,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,
    0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,
    0x4f,0x52,0x44,0x31,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,
    0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,
    0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x75,0x76,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,0x50,
    0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3a,0x20,0x53,0x56,0x5f,0x50,0x6f,0x73,
    0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,
    0x20,0x31,0x36,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,
    0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x76,
    0x6f,0x69,0x64,0x20,0x76,0x65,0x72,0x74,0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,
    0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x36,0x20,0x22,0x2e,0x2e,0x2f,0x73,
    0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,
    0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x6d,0x75,0x6c,0x28,0x66,0x6c,0x6f,0x61,
    0x74,0x34,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x78,0x2c,0x20,0x70,
    0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,0x66,0x2c,
    0x20,0x31,0x2e,0x30,0x66,0x29,0x2c,0x20,0x5f,0x32,0x31,0x5f,0x6d,0x76,0x70,0x29,
    0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,
    0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x75,0x76,0x20,0x3d,0x20,0x74,
    0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x3b,0x0a,0x7d,0x0a,0x0a,0x53,0x50,0x49,
    0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x28,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,
    0x5f,0x49,0x6e,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,
    0x75,0x74,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,
    0x6f,0x6e,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,
    0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x20,0x20,0x20,0x20,0x74,
    0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,
    0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,0x74,0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x72,0x74,0x5f,0x6d,0x61,0x69,0x6e,0x28,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,
    0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,
    0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,
    0x6f,0x6e,0x3b,0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,
    0x74,0x70,0x75,0x74,0x2e,0x75,0x76,0x20,0x3d,0x20,0x75,0x76,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,
    0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x00,
};
/*
    Texture2D<float4> tex : register(t0);
    SamplerState _tex_sampler : register(s0);
    
    static float4 frag_color;
    static float2 uv;
    
    struct SPIRV_Cross_Input
    {
        float2 uv : TEXCOORD0;
    };
    
    struct SPIRV_Cross_Output
    {
        float4 frag_color : SV_Target0;
    };
    
    #line 12 "../src/sokol/shader.glsl"
    void frag_main()
    {
    #line 12 "../src/sokol/shader.glsl"
        frag_color = tex.Sample(_tex_sampler, uv);
    }
    
    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        uv = stage_input.uv;
        frag_main();
        SPIRV_Cross_Output stage_output;
        stage_output.frag_color = frag_color;
        return stage_output;
    }
*/
static const char fs_source_hlsl5[599] = {
    0x54,0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x44,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x34,
    0x3e,0x20,0x74,0x65,0x78,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,
    0x28,0x74,0x30,0x29,0x3b,0x0a,0x53,0x61,0x6d,0x70,0x6c,0x65,0x72,0x53,0x74,0x61,
    0x74,0x65,0x20,0x5f,0x74,0x65,0x78,0x5f,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,
    0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,0x28,0x73,0x30,0x29,0x3b,0x0a,
    0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,
    0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,
    0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x75,0x76,0x3b,0x0a,0x0a,0x73,0x74,
    0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,
    0x5f,0x49,0x6e,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x75,0x76,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,
    0x44,0x30,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,
    0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,
    0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,
    0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3a,0x20,0x53,0x56,0x5f,0x54,
    0x61,0x72,0x67,0x65,0x74,0x30,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,
    0x65,0x20,0x31,0x32,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,
    0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,
    0x76,0x6f,0x69,0x64,0x20,0x66,0x72,0x61,0x67,0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,
    0x0a,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x32,0x20,0x22,0x2e,0x2e,0x2f,
    0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x5f,
    0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x74,0x65,0x78,0x2e,0x53,0x61,0x6d,0x70,
    0x6c,0x65,0x28,0x5f,0x74,0x65,0x78,0x5f,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x2c,
    0x20,0x75,0x76,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,
    0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,
    0x28,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,
    0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x29,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x75,0x76,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,
    0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,0x75,0x76,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x72,0x61,0x67,0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,
    0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,
    0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x66,
    0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,
    0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x00,
};
/*
    cbuffer vs_path_params : register(b0)
    {
        row_major float4x4 _22_mvp : packoffset(c0);
        int _22_fillType : packoffset(c4);
        float2 _22_gradientStart : packoffset(c4.z);
        float2 _22_gradientEnd : packoffset(c5);
    };
    
    
    static float4 gl_Position;
    static float2 position;
    static float2 gradient_uv;
    
    struct SPIRV_Cross_Input
    {
        float2 position : TEXCOORD0;
    };
    
    struct SPIRV_Cross_Output
    {
        float2 gradient_uv : TEXCOORD0;
        float4 gl_Position : SV_Position;
    };
    
    #line 17 "../src/sokol/shader.glsl"
    void vert_main()
    {
    #line 17 "../src/sokol/shader.glsl"
        gl_Position = mul(float4(position, 0.0f, 1.0f), _22_mvp);
    #line 19 "../src/sokol/shader.glsl"
        if (_22_fillType == 1)
        {
    #line 21 "../src/sokol/shader.glsl"
            float2 _54 = _22_gradientEnd - _22_gradientStart;
    #line 22 "../src/sokol/shader.glsl"
            float _59 = _54.x;
            float _64 = _54.y;
    #line 23 "../src/sokol/shader.glsl"
            gradient_uv.x = dot(position - _22_gradientStart, _54) / ((_59 * _59) + (_64 * _64));
        }
        else
        {
    #line 25 "../src/sokol/shader.glsl"
            if (_22_fillType == 2)
            {
    #line 27 "../src/sokol/shader.glsl"
                gradient_uv = (position - _22_gradientStart) / distance(_22_gradientStart, _22_gradientEnd).xx;
            }
        }
    }
    
    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        position = stage_input.position;
        vert_main();
        SPIRV_Cross_Output stage_output;
        stage_output.gl_Position = gl_Position;
        stage_output.gradient_uv = gradient_uv;
        return stage_output;
    }
*/
static const char vs_path_source_hlsl5[1537] = {
    0x63,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,
    0x72,0x28,0x62,0x30,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x6f,0x77,0x5f,
    0x6d,0x61,0x6a,0x6f,0x72,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x5f,
    0x32,0x32,0x5f,0x6d,0x76,0x70,0x20,0x3a,0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,
    0x73,0x65,0x74,0x28,0x63,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,
    0x20,0x5f,0x32,0x32,0x5f,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3a,0x20,
    0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x34,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x32,0x32,0x5f,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x20,0x3a,0x20,0x70,
    0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x34,0x2e,0x7a,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x32,0x32,0x5f,
    0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,0x20,0x3a,0x20,0x70,0x61,
    0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x35,0x29,0x3b,0x0a,0x7d,0x3b,
    0x0a,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,
    0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x3b,
    0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,
    0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,0x3b,0x0a,0x7d,0x3b,
    0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,
    0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,
    0x74,0x5f,0x75,0x76,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,
    0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3a,0x20,0x53,0x56,0x5f,0x50,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,
    0x65,0x20,0x31,0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,
    0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,
    0x76,0x6f,0x69,0x64,0x20,0x76,0x65,0x72,0x74,0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,
    0x0a,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x37,0x20,0x22,0x2e,0x2e,0x2f,
    0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x6d,0x75,0x6c,0x28,0x66,0x6c,0x6f,
    0x61,0x74,0x34,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x30,0x2e,
    0x30,0x66,0x2c,0x20,0x31,0x2e,0x30,0x66,0x29,0x2c,0x20,0x5f,0x32,0x32,0x5f,0x6d,
    0x76,0x70,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x39,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,
    0x28,0x5f,0x32,0x32,0x5f,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,
    0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x32,0x31,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,
    0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x34,
    0x20,0x3d,0x20,0x5f,0x32,0x32,0x5f,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,
    0x6e,0x64,0x20,0x2d,0x20,0x5f,0x32,0x32,0x5f,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,
    0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x32,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x35,0x39,0x20,0x3d,0x20,
    0x5f,0x35,0x34,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x34,0x20,0x3d,0x20,0x5f,0x35,0x34,0x2e,0x79,
    0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x33,0x20,0x22,0x2e,0x2e,0x2f,0x73,
    0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x67,0x72,
    0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x20,0x3d,0x20,0x64,0x6f,
    0x74,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,0x5f,0x32,0x32,
    0x5f,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,
    0x5f,0x35,0x34,0x29,0x20,0x2f,0x20,0x28,0x28,0x5f,0x35,0x39,0x20,0x2a,0x20,0x5f,
    0x35,0x39,0x29,0x20,0x2b,0x20,0x28,0x5f,0x36,0x34,0x20,0x2a,0x20,0x5f,0x36,0x34,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,
    0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,
    0x35,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x32,0x32,0x5f,0x66,0x69,0x6c,
    0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x32,0x29,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x37,0x20,0x22,
    0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,
    0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,
    0x76,0x20,0x3d,0x20,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,
    0x5f,0x32,0x32,0x5f,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,
    0x74,0x29,0x20,0x2f,0x20,0x64,0x69,0x73,0x74,0x61,0x6e,0x63,0x65,0x28,0x5f,0x32,
    0x32,0x5f,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,
    0x20,0x5f,0x32,0x32,0x5f,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,
    0x29,0x2e,0x78,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x7d,0x0a,0x0a,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,
    0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,
    0x28,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,
    0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x29,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,
    0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,0x70,0x6f,0x73,
    0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x72,0x74,0x5f,
    0x6d,0x61,0x69,0x6e,0x28,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x53,0x50,0x49,0x52,
    0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,
    0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x67,0x6c,
    0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x67,0x6c,0x5f,0x50,
    0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,
    0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x5f,0x75,0x76,0x20,0x3d,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,
    0x5f,0x75,0x76,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x7d,0x0a,
    0x00,
};
/*
    cbuffer fs_path_uniforms : register(b0)
    {
        int _18_fillType : packoffset(c0);
        float4 _18_colors[16] : packoffset(c1);
        float4 _18_stops[4] : packoffset(c17);
        int _18_stopCount : packoffset(c21);
    };
    
    
    static float4 frag_color;
    static float2 gradient_uv;
    
    struct SPIRV_Cross_Input
    {
        float2 gradient_uv : TEXCOORD0;
    };
    
    struct SPIRV_Cross_Output
    {
        float4 frag_color : SV_Target0;
    };
    
    #line 18 "../src/sokol/shader.glsl"
    void frag_main()
    {
    #line 18 "../src/sokol/shader.glsl"
        if (_18_fillType == 0)
        {
    #line 20 "../src/sokol/shader.glsl"
            frag_color = _18_colors[0];
        }
        else
        {
    #line 23 "../src/sokol/shader.glsl"
            float _39;
            if (_18_fillType == 1)
            {
                _39 = gradient_uv.x;
            }
            else
            {
                _39 = length(gradient_uv);
            }
    #line 24 "../src/sokol/shader.glsl"
    #line 25 "../src/sokol/shader.glsl"
            float4 color = lerp(_18_colors[0], _18_colors[1], smoothstep(_18_stops[0].x, _18_stops[0].y, _39).xxxx);
    #line 26 "../src/sokol/shader.glsl"
            for (int i = 1; i < 15; i++)
            {
    #line 28 "../src/sokol/shader.glsl"
                if (i >= (_18_stopCount - 1))
                {
    #line 30 "../src/sokol/shader.glsl"
                    break;
                }
    #line 33 "../src/sokol/shader.glsl"
    #line 35 "../src/sokol/shader.glsl"
    #line 34 "../src/sokol/shader.glsl"
                int _91 = i + 1;
    #line 35 "../src/sokol/shader.glsl"
                color = lerp(color, _18_colors[_91], smoothstep(_18_stops[i / 4][i % 4], _18_stops[_91 / 4][_91 % 4], _39).xxxx);
            }
    #line 37 "../src/sokol/shader.glsl"
            frag_color = color;
        }
    }
    
    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        gradient_uv = stage_input.gradient_uv;
        frag_main();
        SPIRV_Cross_Output stage_output;
        stage_output.frag_color = frag_color;
        return stage_output;
    }
*/
static const char fs_path_source_hlsl5[1870] = {
    0x63,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x66,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,
    0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,
    0x74,0x65,0x72,0x28,0x62,0x30,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,
    0x74,0x20,0x5f,0x31,0x38,0x5f,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3a,
    0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x5f,0x31,0x38,0x5f,
    0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x36,0x5d,0x20,0x3a,0x20,0x70,0x61,0x63,
    0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x31,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x5f,0x31,0x38,0x5f,0x73,0x74,0x6f,0x70,
    0x73,0x5b,0x34,0x5d,0x20,0x3a,0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,
    0x74,0x28,0x63,0x31,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,
    0x5f,0x31,0x38,0x5f,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,0x6e,0x74,0x20,0x3a,0x20,
    0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x32,0x31,0x29,0x3b,
    0x0a,0x7d,0x3b,0x0a,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,
    0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,0x72,
    0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,
    0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,
    0x6e,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,0x3a,0x20,
    0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,
    0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,
    0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,
    0x20,0x3a,0x20,0x53,0x56,0x5f,0x54,0x61,0x72,0x67,0x65,0x74,0x30,0x3b,0x0a,0x7d,
    0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x38,0x20,0x22,0x2e,0x2e,0x2f,
    0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x76,0x6f,0x69,0x64,0x20,0x66,0x72,0x61,0x67,
    0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x31,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,
    0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,
    0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x5f,0x66,0x69,0x6c,0x6c,0x54,0x79,
    0x70,0x65,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x32,0x30,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x5f,
    0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x5f,0x31,0x38,0x5f,0x63,0x6f,0x6c,0x6f,
    0x72,0x73,0x5b,0x30,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,
    0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,
    0x65,0x20,0x32,0x33,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,
    0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,
    0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,
    0x31,0x38,0x5f,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x31,
    0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x67,0x72,
    0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x65,
    0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,
    0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,
    0x75,0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x32,0x34,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x2e,0x2e,0x2f,
    0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x6c,0x65,
    0x72,0x70,0x28,0x5f,0x31,0x38,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,
    0x2c,0x20,0x5f,0x31,0x38,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x5d,0x2c,
    0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x5f,0x31,0x38,0x5f,
    0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x2c,0x20,0x5f,0x31,0x38,0x5f,
    0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x79,0x2c,0x20,0x5f,0x33,0x39,0x29,
    0x2e,0x78,0x78,0x78,0x78,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x36,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,0x20,0x3d,
    0x20,0x31,0x3b,0x20,0x69,0x20,0x3c,0x20,0x31,0x35,0x3b,0x20,0x69,0x2b,0x2b,0x29,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,
    0x20,0x32,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,
    0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,
    0x20,0x3e,0x3d,0x20,0x28,0x5f,0x31,0x38,0x5f,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,
    0x6e,0x74,0x20,0x2d,0x20,0x31,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x30,0x20,
    0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,
    0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x62,0x72,0x65,0x61,0x6b,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,
    0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x33,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,
    0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x35,0x20,0x22,0x2e,0x2e,
    0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,
    0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x34,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x39,0x31,0x20,
    0x3d,0x20,0x69,0x20,0x2b,0x20,0x31,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,
    0x35,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,
    0x20,0x6c,0x65,0x72,0x70,0x28,0x63,0x6f,0x6c,0x6f,0x72,0x2c,0x20,0x5f,0x31,0x38,
    0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x5f,0x39,0x31,0x5d,0x2c,0x20,0x73,0x6d,
    0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x5f,0x31,0x38,0x5f,0x73,0x74,0x6f,
    0x70,0x73,0x5b,0x69,0x20,0x2f,0x20,0x34,0x5d,0x5b,0x69,0x20,0x25,0x20,0x34,0x5d,
    0x2c,0x20,0x5f,0x31,0x38,0x5f,0x73,0x74,0x6f,0x70,0x73,0x5b,0x5f,0x39,0x31,0x20,
    0x2f,0x20,0x34,0x5d,0x5b,0x5f,0x39,0x31,0x20,0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,
    0x33,0x39,0x29,0x2e,0x78,0x78,0x78,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x7d,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x37,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x63,0x6f,
    0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x7d,0x0a,0x0a,0x53,0x50,
    0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,
    0x20,0x6d,0x61,0x69,0x6e,0x28,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,
    0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,
    0x70,0x75,0x74,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x72,0x61,0x64,0x69,
    0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,
    0x6e,0x70,0x75,0x74,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x5f,0x6d,0x61,0x69,0x6e,0x28,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,
    0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,
    0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,
    0x6c,0x6f,0x72,0x20,0x3d,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x74,0x61,
    0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct vs_params
    {
        float4x4 mvp;
    };
    
    struct main0_out
    {
        float2 uv [[user(locn0)]];
        float4 gl_Position [[position]];
    };
    
    struct main0_in
    {
        float2 position [[attribute(0)]];
        float2 texcoord0 [[attribute(1)]];
    };
    
    #line 16 "../src/sokol/shader.glsl"
    vertex main0_out main0(main0_in in [[stage_in]], constant vs_params& _21 [[buffer(0)]])
    {
        main0_out out = {};
    #line 16 "../src/sokol/shader.glsl"
        out.gl_Position = _21.mvp * float4(in.position.x, in.position.y, 0.0, 1.0);
    #line 17 "../src/sokol/shader.glsl"
        out.uv = in.texcoord0;
        return out;
    }
    
*/
static const char vs_source_metal_macos[652] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,
    0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x6d,0x76,0x70,0x3b,0x0a,0x7d,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,
    0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x75,
    0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,
    0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,
    0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,
    0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,0x29,
    0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,
    0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,
    0x62,0x75,0x74,0x65,0x28,0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x36,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x76,0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,
    0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x76,0x73,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x26,0x20,0x5f,0x32,0x31,0x20,0x5b,0x5b,0x62,0x75,
    0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,
    0x20,0x7b,0x7d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x36,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x5f,
    0x32,0x31,0x2e,0x6d,0x76,0x70,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,
    0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x78,0x2c,0x20,0x69,
    0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x79,0x2c,0x20,0x30,0x2e,
    0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,
    0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x75,0x76,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x74,0x65,0x78,
    0x63,0x6f,0x6f,0x72,0x64,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,
    0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct main0_out
    {
        float4 frag_color [[color(0)]];
    };
    
    struct main0_in
    {
        float2 uv [[user(locn0)]];
    };
    
    #line 12 "../src/sokol/shader.glsl"
    fragment main0_out main0(main0_in in [[stage_in]], texture2d<float> tex [[texture(0)]], sampler texSmplr [[sampler(0)]])
    {
        main0_out out = {};
    #line 12 "../src/sokol/shader.glsl"
        out.frag_color = tex.sample(texSmplr, in.uv);
        return out;
    }
    
*/
static const char fs_source_metal_macos[473] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,
    0x20,0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,
    0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,
    0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x32,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x66,0x72,0x61,0x67,
    0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,
    0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,
    0x74,0x65,0x78,0x20,0x5b,0x5b,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x30,0x29,
    0x5d,0x5d,0x2c,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x74,0x65,0x78,0x53,
    0x6d,0x70,0x6c,0x72,0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x28,0x30,
    0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x32,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,
    0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x74,0x65,0x78,0x2e,0x73,0x61,0x6d,0x70,
    0x6c,0x65,0x28,0x74,0x65,0x78,0x53,0x6d,0x70,0x6c,0x72,0x2c,0x20,0x69,0x6e,0x2e,
    0x75,0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct vs_path_params
    {
        float4x4 mvp;
        int fillType;
        float2 gradientStart;
        float2 gradientEnd;
    };
    
    struct main0_out
    {
        float2 gradient_uv [[user(locn0)]];
        float4 gl_Position [[position]];
    };
    
    struct main0_in
    {
        float2 position [[attribute(0)]];
    };
    
    #line 17 "../src/sokol/shader.glsl"
    vertex main0_out main0(main0_in in [[stage_in]], constant vs_path_params& _22 [[buffer(0)]])
    {
        main0_out out = {};
    #line 17 "../src/sokol/shader.glsl"
        out.gl_Position = _22.mvp * float4(in.position, 0.0, 1.0);
    #line 19 "../src/sokol/shader.glsl"
        if (_22.fillType == 1)
        {
    #line 21 "../src/sokol/shader.glsl"
            float2 _54 = _22.gradientEnd - _22.gradientStart;
    #line 22 "../src/sokol/shader.glsl"
            float _59 = _54.x;
            float _64 = _54.y;
    #line 23 "../src/sokol/shader.glsl"
            out.gradient_uv.x = dot(in.position - _22.gradientStart, _54) / ((_59 * _59) + (_64 * _64));
        }
        else
        {
    #line 25 "../src/sokol/shader.glsl"
            if (_22.fillType == 2)
            {
    #line 27 "../src/sokol/shader.glsl"
                out.gradient_uv = (in.position - _22.gradientStart) / float2(distance(_22.gradientStart, _22.gradientEnd));
            }
        }
        return out;
    }
    
*/
static const char vs_path_source_metal_macos[1280] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,
    0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x6d,0x76,0x70,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,0x6c,0x6c,0x54,0x79,
    0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,
    0x74,0x45,0x6e,0x64,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,
    0x5f,0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,
    0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,
    0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,
    0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,
    0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x31,0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,
    0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x76,0x65,
    0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,
    0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,
    0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x26,0x20,0x5f,0x32,0x32,0x20,0x5b,0x5b,0x62,0x75,
    0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,
    0x20,0x7b,0x7d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x37,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x5f,
    0x32,0x32,0x2e,0x6d,0x76,0x70,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,
    0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x30,0x2e,0x30,
    0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x39,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x69,0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,
    0x20,0x3d,0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,
    0x6e,0x65,0x20,0x32,0x31,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,
    0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x5f,0x35,0x34,0x20,0x3d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x45,0x6e,0x64,0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,
    0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,
    0x20,0x32,0x32,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,
    0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x35,0x39,
    0x20,0x3d,0x20,0x5f,0x35,0x34,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x34,0x20,0x3d,0x20,0x5f,0x35,
    0x34,0x2e,0x79,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x33,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,
    0x2e,0x78,0x20,0x3d,0x20,0x64,0x6f,0x74,0x28,0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,
    0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,0x5f,0x35,0x34,0x29,0x20,0x2f,
    0x20,0x28,0x28,0x5f,0x35,0x39,0x20,0x2a,0x20,0x5f,0x35,0x39,0x29,0x20,0x2b,0x20,
    0x28,0x5f,0x36,0x34,0x20,0x2a,0x20,0x5f,0x36,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,
    0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x2e,0x2e,0x2f,
    0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,
    0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,
    0x3d,0x3d,0x20,0x32,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,
    0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,
    0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x6f,0x75,0x74,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,
    0x3d,0x20,0x28,0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,
    0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,
    0x72,0x74,0x29,0x20,0x2f,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x64,0x69,0x73,
    0x74,0x61,0x6e,0x63,0x65,0x28,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,
    0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,

};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct fs_path_uniforms
    {
        int fillType;
        float4 colors[16];
        float4 stops[4];
        int stopCount;
    };
    
    struct main0_out
    {
        float4 frag_color [[color(0)]];
    };
    
    struct main0_in
    {
        float2 gradient_uv [[user(locn0)]];
    };
    
    #line 18 "../src/sokol/shader.glsl"
    fragment main0_out main0(main0_in in [[stage_in]], constant fs_path_uniforms& _18 [[buffer(0)]])
    {
        main0_out out = {};
    #line 18 "../src/sokol/shader.glsl"
        if (_18.fillType == 0)
        {
    #line 20 "../src/sokol/shader.glsl"
            out.frag_color = _18.colors[0];
        }
        else
        {
    #line 23 "../src/sokol/shader.glsl"
            float _39;
            if (_18.fillType == 1)
            {
                _39 = in.gradient_uv.x;
            }
            else
            {
                _39 = length(in.gradient_uv);
            }
    #line 24 "../src/sokol/shader.glsl"
    #line 25 "../src/sokol/shader.glsl"
            float4 color = mix(_18.colors[0], _18.colors[1], float4(smoothstep(_18.stops[0].x, _18.stops[0].y, _39)));
    #line 26 "../src/sokol/shader.glsl"
            for (int i = 1; i < 15; i++)
            {
    #line 28 "../src/sokol/shader.glsl"
                if (i >= (_18.stopCount - 1))
                {
    #line 30 "../src/sokol/shader.glsl"
                    break;
                }
    #line 33 "../src/sokol/shader.glsl"
    #line 35 "../src/sokol/shader.glsl"
    #line 34 "../src/sokol/shader.glsl"
                int _91 = i + 1;
    #line 35 "../src/sokol/shader.glsl"
                color = mix(color, _18.colors[_91], float4(smoothstep(_18.stops[i / 4][i % 4], _18.stops[_91 / 4][_91 % 4], _39)));
            }
    #line 37 "../src/sokol/shader.glsl"
            out.frag_color = color;
        }
        return out;
    }
    
*/
static const char fs_path_source_metal_macos[1686] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x66,
    0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,0x6c,0x6c,0x54,0x79,
    0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,
    0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x36,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x73,0x74,0x6f,0x70,0x73,0x5b,0x34,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,0x6e,
    0x74,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,
    0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,
    0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,
    0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,
    0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,
    0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,
    0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,
    0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,
    0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,
    0x66,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,
    0x26,0x20,0x5f,0x31,0x38,0x20,0x5b,0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,
    0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,
    0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0a,0x20,0x20,
    0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x30,0x20,0x22,0x2e,0x2e,
    0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,
    0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,
    0x20,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x33,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,0x69,0x6c,0x6c,
    0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,
    0x74,0x68,0x28,0x69,0x6e,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,
    0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x23,0x6c,
    0x69,0x6e,0x65,0x20,0x32,0x34,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,
    0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,
    0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x2e,0x2e,0x2f,0x73,
    0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x6d,0x69,0x78,
    0x28,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x2c,0x20,
    0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x5d,0x2c,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,
    0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x2c,
    0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x79,0x2c,
    0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,
    0x36,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,0x20,
    0x3d,0x20,0x31,0x3b,0x20,0x69,0x20,0x3c,0x20,0x31,0x35,0x3b,0x20,0x69,0x2b,0x2b,
    0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,
    0x65,0x20,0x32,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,
    0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,
    0x69,0x20,0x3e,0x3d,0x20,0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x43,0x6f,
    0x75,0x6e,0x74,0x20,0x2d,0x20,0x31,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x30,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x62,0x72,0x65,0x61,
    0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,
    0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x33,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,
    0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,
    0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x35,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,
    0x34,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x39,0x31,
    0x20,0x3d,0x20,0x69,0x20,0x2b,0x20,0x31,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x33,0x35,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,
    0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,
    0x3d,0x20,0x6d,0x69,0x78,0x28,0x63,0x6f,0x6c,0x6f,0x72,0x2c,0x20,0x5f,0x31,0x38,
    0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x5f,0x39,0x31,0x5d,0x2c,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,
    0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x69,0x20,0x2f,0x20,0x34,0x5d,
    0x5b,0x69,0x20,0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,
    0x70,0x73,0x5b,0x5f,0x39,0x31,0x20,0x2f,0x20,0x34,0x5d,0x5b,0x5f,0x39,0x31,0x20,
    0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x37,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,
    0x6f,0x72,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,
    0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct vs_params
    {
        float4x4 mvp;
    };
    
    struct main0_out
    {
        float2 uv [[user(locn0)]];
        float4 gl_Position [[position]];
    };
    
    struct main0_in
    {
        float2 position [[attribute(0)]];
        float2 texcoord0 [[attribute(1)]];
    };
    
    #line 16 "../src/sokol/shader.glsl"
    vertex main0_out main0(main0_in in [[stage_in]], constant vs_params& _21 [[buffer(0)]])
    {
        main0_out out = {};
    #line 16 "../src/sokol/shader.glsl"
        out.gl_Position = _21.mvp * float4(in.position.x, in.position.y, 0.0, 1.0);
    #line 17 "../src/sokol/shader.glsl"
        out.uv = in.texcoord0;
        return out;
    }
    
*/
static const char vs_source_metal_ios[652] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,
    0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x6d,0x76,0x70,0x3b,0x0a,0x7d,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,
    0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x75,
    0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,
    0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,
    0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,
    0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,0x29,
    0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,
    0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,
    0x62,0x75,0x74,0x65,0x28,0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x36,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x76,0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,
    0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x76,0x73,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x26,0x20,0x5f,0x32,0x31,0x20,0x5b,0x5b,0x62,0x75,
    0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,
    0x20,0x7b,0x7d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x36,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x5f,
    0x32,0x31,0x2e,0x6d,0x76,0x70,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,
    0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x78,0x2c,0x20,0x69,
    0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x79,0x2c,0x20,0x30,0x2e,
    0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,
    0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x75,0x76,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x74,0x65,0x78,
    0x63,0x6f,0x6f,0x72,0x64,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,
    0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct main0_out
    {
        float4 frag_color [[color(0)]];
    };
    
    struct main0_in
    {
        float2 uv [[user(locn0)]];
    };
    
    #line 12 "../src/sokol/shader.glsl"
    fragment main0_out main0(main0_in in [[stage_in]], texture2d<float> tex [[texture(0)]], sampler texSmplr [[sampler(0)]])
    {
        main0_out out = {};
    #line 12 "../src/sokol/shader.glsl"
        out.frag_color = tex.sample(texSmplr, in.uv);
        return out;
    }
    
*/
static const char fs_source_metal_ios[473] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,
    0x20,0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,
    0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,
    0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x32,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x66,0x72,0x61,0x67,
    0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,
    0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,
    0x74,0x65,0x78,0x20,0x5b,0x5b,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x30,0x29,
    0x5d,0x5d,0x2c,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x74,0x65,0x78,0x53,
    0x6d,0x70,0x6c,0x72,0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x28,0x30,
    0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x32,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,
    0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x74,0x65,0x78,0x2e,0x73,0x61,0x6d,0x70,
    0x6c,0x65,0x28,0x74,0x65,0x78,0x53,0x6d,0x70,0x6c,0x72,0x2c,0x20,0x69,0x6e,0x2e,
    0x75,0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct vs_path_params
    {
        float4x4 mvp;
        int fillType;
        float2 gradientStart;
        float2 gradientEnd;
    };
    
    struct main0_out
    {
        float2 gradient_uv [[user(locn0)]];
        float4 gl_Position [[position]];
    };
    
    struct main0_in
    {
        float2 position [[attribute(0)]];
    };
    
    #line 17 "../src/sokol/shader.glsl"
    vertex main0_out main0(main0_in in [[stage_in]], constant vs_path_params& _22 [[buffer(0)]])
    {
        main0_out out = {};
    #line 17 "../src/sokol/shader.glsl"
        out.gl_Position = _22.mvp * float4(in.position, 0.0, 1.0);
    #line 19 "../src/sokol/shader.glsl"
        if (_22.fillType == 1)
        {
    #line 21 "../src/sokol/shader.glsl"
            float2 _54 = _22.gradientEnd - _22.gradientStart;
    #line 22 "../src/sokol/shader.glsl"
            float _59 = _54.x;
            float _64 = _54.y;
    #line 23 "../src/sokol/shader.glsl"
            out.gradient_uv.x = dot(in.position - _22.gradientStart, _54) / ((_59 * _59) + (_64 * _64));
        }
        else
        {
    #line 25 "../src/sokol/shader.glsl"
            if (_22.fillType == 2)
            {
    #line 27 "../src/sokol/shader.glsl"
                out.gradient_uv = (in.position - _22.gradientStart) / float2(distance(_22.gradientStart, _22.gradientEnd));
            }
        }
        return out;
    }
    
*/
static const char vs_path_source_metal_ios[1280] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,
    0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x6d,0x76,0x70,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,0x6c,0x6c,0x54,0x79,
    0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,
    0x74,0x45,0x6e,0x64,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,
    0x5f,0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,
    0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,
    0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,
    0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,
    0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x31,0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,
    0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x76,0x65,
    0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,
    0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,
    0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x26,0x20,0x5f,0x32,0x32,0x20,0x5b,0x5b,0x62,0x75,
    0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,
    0x20,0x7b,0x7d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x37,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x5f,
    0x32,0x32,0x2e,0x6d,0x76,0x70,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,
    0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x30,0x2e,0x30,
    0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x39,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x69,0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,
    0x20,0x3d,0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,
    0x6e,0x65,0x20,0x32,0x31,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,
    0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x5f,0x35,0x34,0x20,0x3d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x45,0x6e,0x64,0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,
    0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,
    0x20,0x32,0x32,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,
    0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x35,0x39,
    0x20,0x3d,0x20,0x5f,0x35,0x34,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x34,0x20,0x3d,0x20,0x5f,0x35,
    0x34,0x2e,0x79,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x33,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,
    0x2e,0x78,0x20,0x3d,0x20,0x64,0x6f,0x74,0x28,0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,
    0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,0x5f,0x35,0x34,0x29,0x20,0x2f,
    0x20,0x28,0x28,0x5f,0x35,0x39,0x20,0x2a,0x20,0x5f,0x35,0x39,0x29,0x20,0x2b,0x20,
    0x28,0x5f,0x36,0x34,0x20,0x2a,0x20,0x5f,0x36,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,
    0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x2e,0x2e,0x2f,
    0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,
    0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,
    0x3d,0x3d,0x20,0x32,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,
    0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,
    0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x6f,0x75,0x74,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,
    0x3d,0x20,0x28,0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,
    0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,
    0x72,0x74,0x29,0x20,0x2f,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x64,0x69,0x73,
    0x74,0x61,0x6e,0x63,0x65,0x28,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,
    0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,

};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct fs_path_uniforms
    {
        int fillType;
        float4 colors[16];
        float4 stops[4];
        int stopCount;
    };
    
    struct main0_out
    {
        float4 frag_color [[color(0)]];
    };
    
    struct main0_in
    {
        float2 gradient_uv [[user(locn0)]];
    };
    
    #line 18 "../src/sokol/shader.glsl"
    fragment main0_out main0(main0_in in [[stage_in]], constant fs_path_uniforms& _18 [[buffer(0)]])
    {
        main0_out out = {};
    #line 18 "../src/sokol/shader.glsl"
        if (_18.fillType == 0)
        {
    #line 20 "../src/sokol/shader.glsl"
            out.frag_color = _18.colors[0];
        }
        else
        {
    #line 23 "../src/sokol/shader.glsl"
            float _39;
            if (_18.fillType == 1)
            {
                _39 = in.gradient_uv.x;
            }
            else
            {
                _39 = length(in.gradient_uv);
            }
    #line 24 "../src/sokol/shader.glsl"
    #line 25 "../src/sokol/shader.glsl"
            float4 color = mix(_18.colors[0], _18.colors[1], float4(smoothstep(_18.stops[0].x, _18.stops[0].y, _39)));
    #line 26 "../src/sokol/shader.glsl"
            for (int i = 1; i < 15; i++)
            {
    #line 28 "../src/sokol/shader.glsl"
                if (i >= (_18.stopCount - 1))
                {
    #line 30 "../src/sokol/shader.glsl"
                    break;
                }
    #line 33 "../src/sokol/shader.glsl"
    #line 35 "../src/sokol/shader.glsl"
    #line 34 "../src/sokol/shader.glsl"
                int _91 = i + 1;
    #line 35 "../src/sokol/shader.glsl"
                color = mix(color, _18.colors[_91], float4(smoothstep(_18.stops[i / 4][i % 4], _18.stops[_91 / 4][_91 % 4], _39)));
            }
    #line 37 "../src/sokol/shader.glsl"
            out.frag_color = color;
        }
        return out;
    }
    
*/
static const char fs_path_source_metal_ios[1686] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x66,
    0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,0x6c,0x6c,0x54,0x79,
    0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,
    0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x36,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x73,0x74,0x6f,0x70,0x73,0x5b,0x34,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,0x6e,
    0x74,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,
    0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,
    0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,
    0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,
    0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,
    0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,
    0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,
    0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,
    0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,
    0x66,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,
    0x26,0x20,0x5f,0x31,0x38,0x20,0x5b,0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,
    0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,
    0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0a,0x20,0x20,
    0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x30,0x20,0x22,0x2e,0x2e,
    0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,
    0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,
    0x20,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x33,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,0x69,0x6c,0x6c,
    0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,
    0x74,0x68,0x28,0x69,0x6e,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,
    0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x23,0x6c,
    0x69,0x6e,0x65,0x20,0x32,0x34,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,
    0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,
    0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x2e,0x2e,0x2f,0x73,
    0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x6d,0x69,0x78,
    0x28,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x2c,0x20,
    0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x5d,0x2c,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,
    0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x2c,
    0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x79,0x2c,
    0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,
    0x36,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,0x20,
    0x3d,0x20,0x31,0x3b,0x20,0x69,0x20,0x3c,0x20,0x31,0x35,0x3b,0x20,0x69,0x2b,0x2b,
    0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,
    0x65,0x20,0x32,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,
    0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,
    0x69,0x20,0x3e,0x3d,0x20,0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x43,0x6f,
    0x75,0x6e,0x74,0x20,0x2d,0x20,0x31,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x30,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x62,0x72,0x65,0x61,
    0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,
    0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x33,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,
    0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,
    0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x35,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,
    0x34,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x39,0x31,
    0x20,0x3d,0x20,0x69,0x20,0x2b,0x20,0x31,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x33,0x35,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,
    0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,
    0x3d,0x20,0x6d,0x69,0x78,0x28,0x63,0x6f,0x6c,0x6f,0x72,0x2c,0x20,0x5f,0x31,0x38,
    0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x5f,0x39,0x31,0x5d,0x2c,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,
    0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x69,0x20,0x2f,0x20,0x34,0x5d,
    0x5b,0x69,0x20,0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,
    0x70,0x73,0x5b,0x5f,0x39,0x31,0x20,0x2f,0x20,0x34,0x5d,0x5b,0x5f,0x39,0x31,0x20,
    0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x37,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,
    0x6f,0x72,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,
    0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct vs_params
    {
        float4x4 mvp;
    };
    
    struct main0_out
    {
        float2 uv [[user(locn0)]];
        float4 gl_Position [[position]];
    };
    
    struct main0_in
    {
        float2 position [[attribute(0)]];
        float2 texcoord0 [[attribute(1)]];
    };
    
    #line 16 "../src/sokol/shader.glsl"
    vertex main0_out main0(main0_in in [[stage_in]], constant vs_params& _21 [[buffer(0)]])
    {
        main0_out out = {};
    #line 16 "../src/sokol/shader.glsl"
        out.gl_Position = _21.mvp * float4(in.position.x, in.position.y, 0.0, 1.0);
    #line 17 "../src/sokol/shader.glsl"
        out.uv = in.texcoord0;
        return out;
    }
    
*/
static const char vs_source_metal_sim[652] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,
    0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x6d,0x76,0x70,0x3b,0x0a,0x7d,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,
    0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x75,
    0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,
    0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,
    0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,
    0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,0x29,
    0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,
    0x65,0x78,0x63,0x6f,0x6f,0x72,0x64,0x30,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,
    0x62,0x75,0x74,0x65,0x28,0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x36,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x76,0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,
    0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x76,0x73,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x26,0x20,0x5f,0x32,0x31,0x20,0x5b,0x5b,0x62,0x75,
    0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,
    0x20,0x7b,0x7d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x36,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x5f,
    0x32,0x31,0x2e,0x6d,0x76,0x70,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,
    0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x78,0x2c,0x20,0x69,
    0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x79,0x2c,0x20,0x30,0x2e,
    0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,
    0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x75,0x76,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x74,0x65,0x78,
    0x63,0x6f,0x6f,0x72,0x64,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,
    0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct main0_out
    {
        float4 frag_color [[color(0)]];
    };
    
    struct main0_in
    {
        float2 uv [[user(locn0)]];
    };
    
    #line 12 "../src/sokol/shader.glsl"
    fragment main0_out main0(main0_in in [[stage_in]], texture2d<float> tex [[texture(0)]], sampler texSmplr [[sampler(0)]])
    {
        main0_out out = {};
    #line 12 "../src/sokol/shader.glsl"
        out.frag_color = tex.sample(texSmplr, in.uv);
        return out;
    }
    
*/
static const char fs_source_metal_sim[473] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,
    0x20,0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,
    0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,
    0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x32,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x66,0x72,0x61,0x67,
    0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,
    0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,
    0x74,0x65,0x78,0x20,0x5b,0x5b,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x30,0x29,
    0x5d,0x5d,0x2c,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x74,0x65,0x78,0x53,
    0x6d,0x70,0x6c,0x72,0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x28,0x30,
    0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x32,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,
    0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x74,0x65,0x78,0x2e,0x73,0x61,0x6d,0x70,
    0x6c,0x65,0x28,0x74,0x65,0x78,0x53,0x6d,0x70,0x6c,0x72,0x2c,0x20,0x69,0x6e,0x2e,
    0x75,0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct vs_path_params
    {
        float4x4 mvp;
        int fillType;
        float2 gradientStart;
        float2 gradientEnd;
    };
    
    struct main0_out
    {
        float2 gradient_uv [[user(locn0)]];
        float4 gl_Position [[position]];
    };
    
    struct main0_in
    {
        float2 position [[attribute(0)]];
    };
    
    #line 17 "../src/sokol/shader.glsl"
    vertex main0_out main0(main0_in in [[stage_in]], constant vs_path_params& _22 [[buffer(0)]])
    {
        main0_out out = {};
    #line 17 "../src/sokol/shader.glsl"
        out.gl_Position = _22.mvp * float4(in.position, 0.0, 1.0);
    #line 19 "../src/sokol/shader.glsl"
        if (_22.fillType == 1)
        {
    #line 21 "../src/sokol/shader.glsl"
            float2 _54 = _22.gradientEnd - _22.gradientStart;
    #line 22 "../src/sokol/shader.glsl"
            float _59 = _54.x;
            float _64 = _54.y;
    #line 23 "../src/sokol/shader.glsl"
            out.gradient_uv.x = dot(in.position - _22.gradientStart, _54) / ((_59 * _59) + (_64 * _64));
        }
        else
        {
    #line 25 "../src/sokol/shader.glsl"
            if (_22.fillType == 2)
            {
    #line 27 "../src/sokol/shader.glsl"
                out.gradient_uv = (in.position - _22.gradientStart) / float2(distance(_22.gradientStart, _22.gradientEnd));
            }
        }
        return out;
    }
    
*/
static const char vs_path_source_metal_sim[1280] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,
    0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x70,0x61,0x72,0x61,0x6d,0x73,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x6d,0x76,0x70,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,0x6c,0x6c,0x54,0x79,
    0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,
    0x74,0x45,0x6e,0x64,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,
    0x5f,0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,
    0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,
    0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,
    0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,
    0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x31,0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,
    0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x76,0x65,
    0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,
    0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,
    0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x76,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x73,0x26,0x20,0x5f,0x32,0x32,0x20,0x5b,0x5b,0x62,0x75,
    0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,
    0x20,0x7b,0x7d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x37,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x5f,
    0x32,0x32,0x2e,0x6d,0x76,0x70,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,
    0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x30,0x2e,0x30,
    0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x39,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x69,0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,
    0x20,0x3d,0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,
    0x6e,0x65,0x20,0x32,0x31,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,
    0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x5f,0x35,0x34,0x20,0x3d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x45,0x6e,0x64,0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,
    0x69,0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,
    0x20,0x32,0x32,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,
    0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x35,0x39,
    0x20,0x3d,0x20,0x5f,0x35,0x34,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x34,0x20,0x3d,0x20,0x5f,0x35,
    0x34,0x2e,0x79,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x33,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,
    0x2e,0x78,0x20,0x3d,0x20,0x64,0x6f,0x74,0x28,0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x20,0x2d,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,
    0x65,0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,0x5f,0x35,0x34,0x29,0x20,0x2f,
    0x20,0x28,0x28,0x5f,0x35,0x39,0x20,0x2a,0x20,0x5f,0x35,0x39,0x29,0x20,0x2b,0x20,
    0x28,0x5f,0x36,0x34,0x20,0x2a,0x20,0x5f,0x36,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,
    0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x2e,0x2e,0x2f,
    0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,
    0x66,0x20,0x28,0x5f,0x32,0x32,0x2e,0x66,0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,
    0x3d,0x3d,0x20,0x32,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,
    0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x37,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,
    0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x6f,0x75,0x74,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,
    0x3d,0x20,0x28,0x69,0x6e,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x2d,
    0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x53,0x74,0x61,
    0x72,0x74,0x29,0x20,0x2f,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x64,0x69,0x73,
    0x74,0x61,0x6e,0x63,0x65,0x28,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x53,0x74,0x61,0x72,0x74,0x2c,0x20,0x5f,0x32,0x32,0x2e,0x67,0x72,0x61,
    0x64,0x69,0x65,0x6e,0x74,0x45,0x6e,0x64,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,

};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct fs_path_uniforms
    {
        int fillType;
        float4 colors[16];
        float4 stops[4];
        int stopCount;
    };
    
    struct main0_out
    {
        float4 frag_color [[color(0)]];
    };
    
    struct main0_in
    {
        float2 gradient_uv [[user(locn0)]];
    };
    
    #line 18 "../src/sokol/shader.glsl"
    fragment main0_out main0(main0_in in [[stage_in]], constant fs_path_uniforms& _18 [[buffer(0)]])
    {
        main0_out out = {};
    #line 18 "../src/sokol/shader.glsl"
        if (_18.fillType == 0)
        {
    #line 20 "../src/sokol/shader.glsl"
            out.frag_color = _18.colors[0];
        }
        else
        {
    #line 23 "../src/sokol/shader.glsl"
            float _39;
            if (_18.fillType == 1)
            {
                _39 = in.gradient_uv.x;
            }
            else
            {
                _39 = length(in.gradient_uv);
            }
    #line 24 "../src/sokol/shader.glsl"
    #line 25 "../src/sokol/shader.glsl"
            float4 color = mix(_18.colors[0], _18.colors[1], float4(smoothstep(_18.stops[0].x, _18.stops[0].y, _39)));
    #line 26 "../src/sokol/shader.glsl"
            for (int i = 1; i < 15; i++)
            {
    #line 28 "../src/sokol/shader.glsl"
                if (i >= (_18.stopCount - 1))
                {
    #line 30 "../src/sokol/shader.glsl"
                    break;
                }
    #line 33 "../src/sokol/shader.glsl"
    #line 35 "../src/sokol/shader.glsl"
    #line 34 "../src/sokol/shader.glsl"
                int _91 = i + 1;
    #line 35 "../src/sokol/shader.glsl"
                color = mix(color, _18.colors[_91], float4(smoothstep(_18.stops[i / 4][i % 4], _18.stops[_91 / 4][_91 % 4], _39)));
            }
    #line 37 "../src/sokol/shader.glsl"
            out.frag_color = color;
        }
        return out;
    }
    
*/
static const char fs_path_source_metal_sim[1686] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x66,
    0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x66,0x69,0x6c,0x6c,0x54,0x79,
    0x70,0x65,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,
    0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x36,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x73,0x74,0x6f,0x70,0x73,0x5b,0x34,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x73,0x74,0x6f,0x70,0x43,0x6f,0x75,0x6e,
    0x74,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,
    0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,
    0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,
    0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,
    0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x67,
    0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,
    0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,
    0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,
    0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,
    0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,
    0x66,0x73,0x5f,0x70,0x61,0x74,0x68,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,
    0x26,0x20,0x5f,0x31,0x38,0x20,0x5b,0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,
    0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x31,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,
    0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,
    0x69,0x6c,0x6c,0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0a,0x20,0x20,
    0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x30,0x20,0x22,0x2e,0x2e,
    0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,
    0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,
    0x20,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x33,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x5f,0x31,0x38,0x2e,0x66,0x69,0x6c,0x6c,
    0x54,0x79,0x70,0x65,0x20,0x3d,0x3d,0x20,0x31,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,
    0x6e,0x74,0x5f,0x75,0x76,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,
    0x74,0x68,0x28,0x69,0x6e,0x2e,0x67,0x72,0x61,0x64,0x69,0x65,0x6e,0x74,0x5f,0x75,
    0x76,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x23,0x6c,
    0x69,0x6e,0x65,0x20,0x32,0x34,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,
    0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,
    0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x2e,0x2e,0x2f,0x73,
    0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x6d,0x69,0x78,
    0x28,0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x30,0x5d,0x2c,0x20,
    0x5f,0x31,0x38,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x31,0x5d,0x2c,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,
    0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x2c,
    0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x30,0x5d,0x2e,0x79,0x2c,
    0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,
    0x36,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,0x20,
    0x3d,0x20,0x31,0x3b,0x20,0x69,0x20,0x3c,0x20,0x31,0x35,0x3b,0x20,0x69,0x2b,0x2b,
    0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,
    0x65,0x20,0x32,0x38,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,
    0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,
    0x69,0x20,0x3e,0x3d,0x20,0x28,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x43,0x6f,
    0x75,0x6e,0x74,0x20,0x2d,0x20,0x31,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x30,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x62,0x72,0x65,0x61,
    0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x7d,
    0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x33,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,
    0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,
    0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x35,0x20,0x22,0x2e,
    0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,0x68,0x61,0x64,
    0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,
    0x34,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,
    0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x39,0x31,
    0x20,0x3d,0x20,0x69,0x20,0x2b,0x20,0x31,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x33,0x35,0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,
    0x2f,0x73,0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,
    0x3d,0x20,0x6d,0x69,0x78,0x28,0x63,0x6f,0x6c,0x6f,0x72,0x2c,0x20,0x5f,0x31,0x38,
    0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x73,0x5b,0x5f,0x39,0x31,0x5d,0x2c,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,
    0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,0x70,0x73,0x5b,0x69,0x20,0x2f,0x20,0x34,0x5d,
    0x5b,0x69,0x20,0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x31,0x38,0x2e,0x73,0x74,0x6f,
    0x70,0x73,0x5b,0x5f,0x39,0x31,0x20,0x2f,0x20,0x34,0x5d,0x5b,0x5f,0x39,0x31,0x20,
    0x25,0x20,0x34,0x5d,0x2c,0x20,0x5f,0x33,0x39,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x7d,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x33,0x37,
    0x20,0x22,0x2e,0x2e,0x2f,0x73,0x72,0x63,0x2f,0x73,0x6f,0x6b,0x6f,0x6c,0x2f,0x73,
    0x68,0x61,0x64,0x65,0x72,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x5f,0x63,0x6f,0x6c,
    0x6f,0x72,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,
    0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
#if !defined(SOKOL_GFX_INCLUDED)
  #error "Please include sokol_gfx.h before shader.h"
#endif
static inline const sg_shader_desc* rive_tess_shader_desc(sg_backend backend) {
  if (backend == SG_BACKEND_GLCORE33) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].name = "position";
      desc.attrs[1].name = "texcoord0";
      desc.vs.source = vs_source_glsl330;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 64;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[0].uniforms[0].name = "vs_params";
      desc.vs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
      desc.vs.uniform_blocks[0].uniforms[0].array_count = 4;
      desc.fs.source = fs_source_glsl330;
      desc.fs.entry = "main";
      desc.fs.images[0].name = "tex";
      desc.fs.images[0].image_type = SG_IMAGETYPE_2D;
      desc.fs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.label = "rive_tess_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_GLES2) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].name = "position";
      desc.attrs[1].name = "texcoord0";
      desc.vs.source = vs_source_glsl100;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 64;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[0].uniforms[0].name = "vs_params";
      desc.vs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
      desc.vs.uniform_blocks[0].uniforms[0].array_count = 4;
      desc.fs.source = fs_source_glsl100;
      desc.fs.entry = "main";
      desc.fs.images[0].name = "tex";
      desc.fs.images[0].image_type = SG_IMAGETYPE_2D;
      desc.fs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.label = "rive_tess_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_GLES3) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].name = "position";
      desc.attrs[1].name = "texcoord0";
      desc.vs.source = vs_source_glsl300es;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 64;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[0].uniforms[0].name = "vs_params";
      desc.vs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
      desc.vs.uniform_blocks[0].uniforms[0].array_count = 4;
      desc.fs.source = fs_source_glsl300es;
      desc.fs.entry = "main";
      desc.fs.images[0].name = "tex";
      desc.fs.images[0].image_type = SG_IMAGETYPE_2D;
      desc.fs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.label = "rive_tess_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_D3D11) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].sem_name = "TEXCOORD";
      desc.attrs[0].sem_index = 0;
      desc.attrs[1].sem_name = "TEXCOORD";
      desc.attrs[1].sem_index = 1;
      desc.vs.source = vs_source_hlsl5;
      desc.vs.d3d11_target = "vs_5_0";
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 64;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.source = fs_source_hlsl5;
      desc.fs.d3d11_target = "ps_5_0";
      desc.fs.entry = "main";
      desc.fs.images[0].name = "tex";
      desc.fs.images[0].image_type = SG_IMAGETYPE_2D;
      desc.fs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.label = "rive_tess_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_METAL_MACOS) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.vs.source = vs_source_metal_macos;
      desc.vs.entry = "main0";
      desc.vs.uniform_blocks[0].size = 64;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.source = fs_source_metal_macos;
      desc.fs.entry = "main0";
      desc.fs.images[0].name = "tex";
      desc.fs.images[0].image_type = SG_IMAGETYPE_2D;
      desc.fs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.label = "rive_tess_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_METAL_IOS) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.vs.source = vs_source_metal_ios;
      desc.vs.entry = "main0";
      desc.vs.uniform_blocks[0].size = 64;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.source = fs_source_metal_ios;
      desc.fs.entry = "main0";
      desc.fs.images[0].name = "tex";
      desc.fs.images[0].image_type = SG_IMAGETYPE_2D;
      desc.fs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.label = "rive_tess_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_METAL_SIMULATOR) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.vs.source = vs_source_metal_sim;
      desc.vs.entry = "main0";
      desc.vs.uniform_blocks[0].size = 64;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.source = fs_source_metal_sim;
      desc.fs.entry = "main0";
      desc.fs.images[0].name = "tex";
      desc.fs.images[0].image_type = SG_IMAGETYPE_2D;
      desc.fs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.label = "rive_tess_shader";
    }
    return &desc;
  }
  return 0;
}
static inline const sg_shader_desc* rive_tess_path_shader_desc(sg_backend backend) {
  if (backend == SG_BACKEND_GLCORE33) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].name = "position";
      desc.vs.source = vs_path_source_glsl330;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 96;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[0].uniforms[0].name = "_22.mvp";
      desc.vs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_MAT4;
      desc.vs.uniform_blocks[0].uniforms[0].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[1].name = "_22.fillType";
      desc.vs.uniform_blocks[0].uniforms[1].type = SG_UNIFORMTYPE_INT;
      desc.vs.uniform_blocks[0].uniforms[1].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[2].name = "_22.gradientStart";
      desc.vs.uniform_blocks[0].uniforms[2].type = SG_UNIFORMTYPE_FLOAT2;
      desc.vs.uniform_blocks[0].uniforms[2].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[3].name = "_22.gradientEnd";
      desc.vs.uniform_blocks[0].uniforms[3].type = SG_UNIFORMTYPE_FLOAT2;
      desc.vs.uniform_blocks[0].uniforms[3].array_count = 1;
      desc.fs.source = fs_path_source_glsl330;
      desc.fs.entry = "main";
      desc.fs.uniform_blocks[0].size = 352;
      desc.fs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.uniform_blocks[0].uniforms[0].name = "_18.fillType";
      desc.fs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_INT;
      desc.fs.uniform_blocks[0].uniforms[0].array_count = 1;
      desc.fs.uniform_blocks[0].uniforms[1].name = "_18.colors";
      desc.fs.uniform_blocks[0].uniforms[1].type = SG_UNIFORMTYPE_FLOAT4;
      desc.fs.uniform_blocks[0].uniforms[1].array_count = 16;
      desc.fs.uniform_blocks[0].uniforms[2].name = "_18.stops";
      desc.fs.uniform_blocks[0].uniforms[2].type = SG_UNIFORMTYPE_FLOAT4;
      desc.fs.uniform_blocks[0].uniforms[2].array_count = 4;
      desc.fs.uniform_blocks[0].uniforms[3].name = "_18.stopCount";
      desc.fs.uniform_blocks[0].uniforms[3].type = SG_UNIFORMTYPE_INT;
      desc.fs.uniform_blocks[0].uniforms[3].array_count = 1;
      desc.label = "rive_tess_path_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_GLES2) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].name = "position";
      desc.vs.source = vs_path_source_glsl100;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 96;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[0].uniforms[0].name = "_22.mvp";
      desc.vs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_MAT4;
      desc.vs.uniform_blocks[0].uniforms[0].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[1].name = "_22.fillType";
      desc.vs.uniform_blocks[0].uniforms[1].type = SG_UNIFORMTYPE_INT;
      desc.vs.uniform_blocks[0].uniforms[1].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[2].name = "_22.gradientStart";
      desc.vs.uniform_blocks[0].uniforms[2].type = SG_UNIFORMTYPE_FLOAT2;
      desc.vs.uniform_blocks[0].uniforms[2].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[3].name = "_22.gradientEnd";
      desc.vs.uniform_blocks[0].uniforms[3].type = SG_UNIFORMTYPE_FLOAT2;
      desc.vs.uniform_blocks[0].uniforms[3].array_count = 1;
      desc.fs.source = fs_path_source_glsl100;
      desc.fs.entry = "main";
      desc.fs.uniform_blocks[0].size = 352;
      desc.fs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.uniform_blocks[0].uniforms[0].name = "_18.fillType";
      desc.fs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_INT;
      desc.fs.uniform_blocks[0].uniforms[0].array_count = 1;
      desc.fs.uniform_blocks[0].uniforms[1].name = "_18.colors";
      desc.fs.uniform_blocks[0].uniforms[1].type = SG_UNIFORMTYPE_FLOAT4;
      desc.fs.uniform_blocks[0].uniforms[1].array_count = 16;
      desc.fs.uniform_blocks[0].uniforms[2].name = "_18.stops";
      desc.fs.uniform_blocks[0].uniforms[2].type = SG_UNIFORMTYPE_FLOAT4;
      desc.fs.uniform_blocks[0].uniforms[2].array_count = 4;
      desc.fs.uniform_blocks[0].uniforms[3].name = "_18.stopCount";
      desc.fs.uniform_blocks[0].uniforms[3].type = SG_UNIFORMTYPE_INT;
      desc.fs.uniform_blocks[0].uniforms[3].array_count = 1;
      desc.label = "rive_tess_path_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_GLES3) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].name = "position";
      desc.vs.source = vs_path_source_glsl300es;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 96;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[0].uniforms[0].name = "_22.mvp";
      desc.vs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_MAT4;
      desc.vs.uniform_blocks[0].uniforms[0].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[1].name = "_22.fillType";
      desc.vs.uniform_blocks[0].uniforms[1].type = SG_UNIFORMTYPE_INT;
      desc.vs.uniform_blocks[0].uniforms[1].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[2].name = "_22.gradientStart";
      desc.vs.uniform_blocks[0].uniforms[2].type = SG_UNIFORMTYPE_FLOAT2;
      desc.vs.uniform_blocks[0].uniforms[2].array_count = 1;
      desc.vs.uniform_blocks[0].uniforms[3].name = "_22.gradientEnd";
      desc.vs.uniform_blocks[0].uniforms[3].type = SG_UNIFORMTYPE_FLOAT2;
      desc.vs.uniform_blocks[0].uniforms[3].array_count = 1;
      desc.fs.source = fs_path_source_glsl300es;
      desc.fs.entry = "main";
      desc.fs.uniform_blocks[0].size = 352;
      desc.fs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.uniform_blocks[0].uniforms[0].name = "_18.fillType";
      desc.fs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_INT;
      desc.fs.uniform_blocks[0].uniforms[0].array_count = 1;
      desc.fs.uniform_blocks[0].uniforms[1].name = "_18.colors";
      desc.fs.uniform_blocks[0].uniforms[1].type = SG_UNIFORMTYPE_FLOAT4;
      desc.fs.uniform_blocks[0].uniforms[1].array_count = 16;
      desc.fs.uniform_blocks[0].uniforms[2].name = "_18.stops";
      desc.fs.uniform_blocks[0].uniforms[2].type = SG_UNIFORMTYPE_FLOAT4;
      desc.fs.uniform_blocks[0].uniforms[2].array_count = 4;
      desc.fs.uniform_blocks[0].uniforms[3].name = "_18.stopCount";
      desc.fs.uniform_blocks[0].uniforms[3].type = SG_UNIFORMTYPE_INT;
      desc.fs.uniform_blocks[0].uniforms[3].array_count = 1;
      desc.label = "rive_tess_path_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_D3D11) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].sem_name = "TEXCOORD";
      desc.attrs[0].sem_index = 0;
      desc.vs.source = vs_path_source_hlsl5;
      desc.vs.d3d11_target = "vs_5_0";
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 96;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.source = fs_path_source_hlsl5;
      desc.fs.d3d11_target = "ps_5_0";
      desc.fs.entry = "main";
      desc.fs.uniform_blocks[0].size = 352;
      desc.fs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.label = "rive_tess_path_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_METAL_MACOS) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.vs.source = vs_path_source_metal_macos;
      desc.vs.entry = "main0";
      desc.vs.uniform_blocks[0].size = 96;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.source = fs_path_source_metal_macos;
      desc.fs.entry = "main0";
      desc.fs.uniform_blocks[0].size = 352;
      desc.fs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.label = "rive_tess_path_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_METAL_IOS) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.vs.source = vs_path_source_metal_ios;
      desc.vs.entry = "main0";
      desc.vs.uniform_blocks[0].size = 96;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.source = fs_path_source_metal_ios;
      desc.fs.entry = "main0";
      desc.fs.uniform_blocks[0].size = 352;
      desc.fs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.label = "rive_tess_path_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_METAL_SIMULATOR) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.vs.source = vs_path_source_metal_sim;
      desc.vs.entry = "main0";
      desc.vs.uniform_blocks[0].size = 96;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.fs.source = fs_path_source_metal_sim;
      desc.fs.entry = "main0";
      desc.fs.uniform_blocks[0].size = 352;
      desc.fs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.label = "rive_tess_path_shader";
    }
    return &desc;
  }
  return 0;
}
