// Copyright (c) 2023, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// IMPORTANT: This file should only ever be modified by modifying the
// corresponding .proto file and then running
// `dart runtime/vm/protos/tools/compile_perfetto_protos.dart` from the SDK root
// directory.
// Autogenerated by the ProtoZero compiler plugin. DO NOT EDIT.

#ifndef PERFETTO_PROTOS_PROTOS_PERFETTO_TRACE_TRACE_PACKET_PROTO_H_
#define PERFETTO_PROTOS_PROTOS_PERFETTO_TRACE_TRACE_PACKET_PROTO_H_

#include <stddef.h>
#include <stdint.h>

#include "perfetto/protozero/field_writer.h"
#include "perfetto/protozero/message.h"
#include "perfetto/protozero/packed_repeated_fields.h"
#include "perfetto/protozero/proto_decoder.h"
#include "perfetto/protozero/proto_utils.h"

namespace perfetto {
namespace protos {
namespace pbzero {

class ClockSnapshot;
class InternedData;
class PerfSample;
class TrackDescriptor;
class TrackEvent;

namespace perfetto_pbzero_enum_TracePacket {
enum SequenceFlags : int32_t {
  SEQ_UNSPECIFIED = 0,
  SEQ_INCREMENTAL_STATE_CLEARED = 1,
  SEQ_NEEDS_INCREMENTAL_STATE = 2,
};
}  // namespace perfetto_pbzero_enum_TracePacket
using TracePacket_SequenceFlags =
    perfetto_pbzero_enum_TracePacket::SequenceFlags;

constexpr TracePacket_SequenceFlags TracePacket_SequenceFlags_MIN =
    TracePacket_SequenceFlags::SEQ_UNSPECIFIED;
constexpr TracePacket_SequenceFlags TracePacket_SequenceFlags_MAX =
    TracePacket_SequenceFlags::SEQ_NEEDS_INCREMENTAL_STATE;

PERFETTO_PROTOZERO_CONSTEXPR14_OR_INLINE
const char* TracePacket_SequenceFlags_Name(
    ::perfetto::protos::pbzero::TracePacket_SequenceFlags value) {
  switch (value) {
    case ::perfetto::protos::pbzero::TracePacket_SequenceFlags::SEQ_UNSPECIFIED:
      return "SEQ_UNSPECIFIED";

    case ::perfetto::protos::pbzero::TracePacket_SequenceFlags::
        SEQ_INCREMENTAL_STATE_CLEARED:
      return "SEQ_INCREMENTAL_STATE_CLEARED";

    case ::perfetto::protos::pbzero::TracePacket_SequenceFlags::
        SEQ_NEEDS_INCREMENTAL_STATE:
      return "SEQ_NEEDS_INCREMENTAL_STATE";
  }
  return "PBZERO_UNKNOWN_ENUM_VALUE";
}

class TracePacket_Decoder : public ::protozero::TypedProtoDecoder<
                                /*MAX_FIELD_ID=*/66,
                                /*HAS_NONPACKED_REPEATED_FIELDS=*/false> {
 public:
  TracePacket_Decoder(const uint8_t* data, size_t len)
      : TypedProtoDecoder(data, len) {}
  explicit TracePacket_Decoder(const std::string& raw)
      : TypedProtoDecoder(reinterpret_cast<const uint8_t*>(raw.data()),
                          raw.size()) {}
  explicit TracePacket_Decoder(const ::protozero::ConstBytes& raw)
      : TypedProtoDecoder(raw.data, raw.size) {}
  bool has_timestamp() const { return at<8>().valid(); }
  uint64_t timestamp() const { return at<8>().as_uint64(); }
  bool has_timestamp_clock_id() const { return at<58>().valid(); }
  uint32_t timestamp_clock_id() const { return at<58>().as_uint32(); }
  bool has_clock_snapshot() const { return at<6>().valid(); }
  ::protozero::ConstBytes clock_snapshot() const { return at<6>().as_bytes(); }
  bool has_track_event() const { return at<11>().valid(); }
  ::protozero::ConstBytes track_event() const { return at<11>().as_bytes(); }
  bool has_track_descriptor() const { return at<60>().valid(); }
  ::protozero::ConstBytes track_descriptor() const {
    return at<60>().as_bytes();
  }
  bool has_perf_sample() const { return at<66>().valid(); }
  ::protozero::ConstBytes perf_sample() const { return at<66>().as_bytes(); }
  bool has_trusted_packet_sequence_id() const { return at<10>().valid(); }
  uint32_t trusted_packet_sequence_id() const { return at<10>().as_uint32(); }
  bool has_interned_data() const { return at<12>().valid(); }
  ::protozero::ConstBytes interned_data() const { return at<12>().as_bytes(); }
  bool has_sequence_flags() const { return at<13>().valid(); }
  uint32_t sequence_flags() const { return at<13>().as_uint32(); }
};

class TracePacket : public ::protozero::Message {
 public:
  using Decoder = TracePacket_Decoder;
  enum : int32_t {
    kTimestampFieldNumber = 8,
    kTimestampClockIdFieldNumber = 58,
    kClockSnapshotFieldNumber = 6,
    kTrackEventFieldNumber = 11,
    kTrackDescriptorFieldNumber = 60,
    kPerfSampleFieldNumber = 66,
    kTrustedPacketSequenceIdFieldNumber = 10,
    kInternedDataFieldNumber = 12,
    kSequenceFlagsFieldNumber = 13,
  };
  static constexpr const char* GetName() {
    return ".perfetto.protos.TracePacket";
  }

  using SequenceFlags = ::perfetto::protos::pbzero::TracePacket_SequenceFlags;
  static inline const char* SequenceFlags_Name(SequenceFlags value) {
    return ::perfetto::protos::pbzero::TracePacket_SequenceFlags_Name(value);
  }
  static const SequenceFlags SEQ_UNSPECIFIED = SequenceFlags::SEQ_UNSPECIFIED;
  static const SequenceFlags SEQ_INCREMENTAL_STATE_CLEARED =
      SequenceFlags::SEQ_INCREMENTAL_STATE_CLEARED;
  static const SequenceFlags SEQ_NEEDS_INCREMENTAL_STATE =
      SequenceFlags::SEQ_NEEDS_INCREMENTAL_STATE;

  using FieldMetadata_Timestamp = ::protozero::proto_utils::FieldMetadata<
      8,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_Timestamp kTimestamp() { return {}; }
  void set_timestamp(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_Timestamp::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_TimestampClockId =
      ::protozero::proto_utils::FieldMetadata<
          58,
          ::protozero::proto_utils::RepetitionType::kNotRepeated,
          ::protozero::proto_utils::ProtoSchemaType::kUint32,
          uint32_t,
          TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_TimestampClockId kTimestampClockId() {
    return {};
  }
  void set_timestamp_clock_id(uint32_t value) {
    static constexpr uint32_t field_id =
        FieldMetadata_TimestampClockId::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint32>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_ClockSnapshot = ::protozero::proto_utils::FieldMetadata<
      6,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kMessage,
      ClockSnapshot,
      TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_ClockSnapshot kClockSnapshot() { return {}; }
  template <typename T = ClockSnapshot>
  T* set_clock_snapshot() {
    return BeginNestedMessage<T>(6);
  }

  using FieldMetadata_TrackEvent = ::protozero::proto_utils::FieldMetadata<
      11,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kMessage,
      TrackEvent,
      TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_TrackEvent kTrackEvent() { return {}; }
  template <typename T = TrackEvent>
  T* set_track_event() {
    return BeginNestedMessage<T>(11);
  }

  using FieldMetadata_TrackDescriptor = ::protozero::proto_utils::FieldMetadata<
      60,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kMessage,
      TrackDescriptor,
      TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_TrackDescriptor kTrackDescriptor() {
    return {};
  }
  template <typename T = TrackDescriptor>
  T* set_track_descriptor() {
    return BeginNestedMessage<T>(60);
  }

  using FieldMetadata_PerfSample = ::protozero::proto_utils::FieldMetadata<
      66,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kMessage,
      PerfSample,
      TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_PerfSample kPerfSample() { return {}; }
  template <typename T = PerfSample>
  T* set_perf_sample() {
    return BeginNestedMessage<T>(66);
  }

  using FieldMetadata_TrustedPacketSequenceId =
      ::protozero::proto_utils::FieldMetadata<
          10,
          ::protozero::proto_utils::RepetitionType::kNotRepeated,
          ::protozero::proto_utils::ProtoSchemaType::kUint32,
          uint32_t,
          TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_TrustedPacketSequenceId
  kTrustedPacketSequenceId() {
    return {};
  }
  void set_trusted_packet_sequence_id(uint32_t value) {
    static constexpr uint32_t field_id =
        FieldMetadata_TrustedPacketSequenceId::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint32>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_InternedData = ::protozero::proto_utils::FieldMetadata<
      12,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kMessage,
      InternedData,
      TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_InternedData kInternedData() { return {}; }
  template <typename T = InternedData>
  T* set_interned_data() {
    return BeginNestedMessage<T>(12);
  }

  using FieldMetadata_SequenceFlags = ::protozero::proto_utils::FieldMetadata<
      13,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint32,
      uint32_t,
      TracePacket>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_SequenceFlags kSequenceFlags() { return {}; }
  void set_sequence_flags(uint32_t value) {
    static constexpr uint32_t field_id = FieldMetadata_SequenceFlags::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint32>::Append(*this,
                                                                    field_id,
                                                                    value);
  }
};

}  // namespace pbzero
}  // namespace protos
}  // namespace perfetto
#endif  // Include guard.
