// THIS FILE IS GENERATED BY impellerc.
// DO NOT EDIT OR CHECK THIS INTO SOURCE CONTROL

#pragma once

#include "impeller/core/buffer_view.h"                
#include "impeller/core/sampler.h"                    
#include "impeller/core/shader_types.h"               
#include "impeller/core/resource_binder.h"            
#include "impeller/core/texture.h"                    

namespace impeller {

struct AdvancedBlendFragmentShader {
  // ===========================================================================
  // Stage Info ================================================================
  // ===========================================================================
  static constexpr std::string_view kLabel = "AdvancedBlend";
  static constexpr std::string_view kEntrypointName = "advanced_blend_fragment_main";
  static constexpr ShaderStage kShaderStage = ShaderStage::kFragment;
  // The generator used to prepare these bindings. Metal generators may be used
  // by GLES backends but GLES generators are unsuitable for the metal backend.
  static constexpr std::string_view kGeneratorName = "OpenGL Shading Language (Relaxed Vulkan Semantics)";
  // ===========================================================================
  // Struct Definitions ========================================================
  // ===========================================================================

  struct BlendInfo {
    Scalar dst_input_alpha; // (offset 0, size 4)
    Scalar src_input_alpha; // (offset 4, size 4)
    Scalar color_factor; // (offset 8, size 4)
    Padding<4> _PADDING_color_; // (offset 12, size 4)
    Vector4 color; // (offset 16, size 16)
    Scalar supports_decal_sampler_address_mode; // (offset 32, size 4)
    Padding<12> _PADDING_; // (offset 36, size 12)
  }; // struct BlendInfo (size 48)

  // ===========================================================================
  // Stage Uniform & Storage Buffers ===========================================
  // ===========================================================================

  static constexpr auto kResourceBlendInfo = ShaderUniformSlot { // BlendInfo
    "BlendInfo",     // name
    64u, // ext_res_0
    0u,       // set
    64u,   // binding
  };
  static ShaderMetadata kMetadataBlendInfo;

  // ===========================================================================
  // Stage Inputs ==============================================================
  // ===========================================================================
  static constexpr auto kInputVDstTextureCoords = ShaderStageIOSlot { // v_dst_texture_coords
    "v_dst_texture_coords",             // name
    0u,          // attribute location
    0u,    // attribute set
    0u,           // attribute binding
    ShaderType::kFloat,     // type
    32u,    // bit width of type
    2u,     // vec size
    1u,      // number of columns
    0u,            // offset for interleaved layout
    false,  // relaxed precision
  };
  static constexpr auto kInputVSrcTextureCoords = ShaderStageIOSlot { // v_src_texture_coords
    "v_src_texture_coords",             // name
    1u,          // attribute location
    0u,    // attribute set
    0u,           // attribute binding
    ShaderType::kFloat,     // type
    32u,    // bit width of type
    2u,     // vec size
    1u,      // number of columns
    0u,            // offset for interleaved layout
    false,  // relaxed precision
  };

  static constexpr std::array<const ShaderStageIOSlot*, 2> kAllShaderStageInputs = {
    &kInputVDstTextureCoords, // v_dst_texture_coords
    &kInputVSrcTextureCoords, // v_src_texture_coords
  };


  // ===========================================================================
  // Sampled Images ============================================================
  // ===========================================================================

  static constexpr auto kResourceTextureSamplerDst = SampledImageSlot { // texture_sampler_dst
    "texture_sampler_dst",      // name
    65u,  // ext_res_0
    0u,        // set
    65u,    // binding
  };
  static ShaderMetadata kMetadataTextureSamplerDst;

  static constexpr auto kResourceTextureSamplerSrc = SampledImageSlot { // texture_sampler_src
    "texture_sampler_src",      // name
    66u,  // ext_res_0
    0u,        // set
    66u,    // binding
  };
  static ShaderMetadata kMetadataTextureSamplerSrc;
  // ===========================================================================
  // Stage Outputs =============================================================
  // ===========================================================================
  static constexpr auto kOutputFragColor = ShaderStageIOSlot { // frag_color
    "frag_color",             // name
    0u,          // attribute location
    0u,    // attribute set
    0u,           // attribute binding
    ShaderType::kFloat,     // type
    32u,    // bit width of type
    4u,     // vec size
    1u,      // number of columns
    0u,            // offset for interleaved layout
    false,  // relaxed precision
  };
  static constexpr std::array<const ShaderStageIOSlot*, 1> kAllShaderStageOutputs = {
    &kOutputFragColor, // frag_color
  };

  // ===========================================================================
  // Resource Binding Utilities ================================================
  // ===========================================================================

  /// Bind uniform buffer for resource named BlendInfo.
  static bool BindBlendInfo(ResourceBinder& command, BufferView view) {
    return command.BindResource(ShaderStage::kFragment, DescriptorType::kUniformBuffer, kResourceBlendInfo, kMetadataBlendInfo, std::move(view));
  }

  /// Bind combined image sampler for resource named texture_sampler_dst.
  static bool BindTextureSamplerDst(ResourceBinder& command, std::shared_ptr<const Texture> texture, const std::unique_ptr<const Sampler>& sampler) {
    return command.BindResource(ShaderStage::kFragment, DescriptorType::kSampledImage, kResourceTextureSamplerDst, kMetadataTextureSamplerDst, std::move(texture), std::move(sampler));
  }

  /// Bind combined image sampler for resource named texture_sampler_src.
  static bool BindTextureSamplerSrc(ResourceBinder& command, std::shared_ptr<const Texture> texture, const std::unique_ptr<const Sampler>& sampler) {
    return command.BindResource(ShaderStage::kFragment, DescriptorType::kSampledImage, kResourceTextureSamplerSrc, kMetadataTextureSamplerSrc, std::move(texture), std::move(sampler));
  }


  // ===========================================================================
  // Metadata for Vulkan =======================================================
  // ===========================================================================
  static constexpr std::array<DescriptorSetLayout,3> kDescriptorSetLayouts{
    DescriptorSetLayout{
      64, // binding = 64
      DescriptorType::kUniformBuffer, // descriptor_type = DescriptorType::kUniformBuffer
      ShaderStage::kFragment, // shader_stage = ShaderStage::kFragment
    },
    DescriptorSetLayout{
      65, // binding = 65
      DescriptorType::kSampledImage, // descriptor_type = DescriptorType::kSampledImage
      ShaderStage::kFragment, // shader_stage = ShaderStage::kFragment
    },
    DescriptorSetLayout{
      66, // binding = 66
      DescriptorType::kSampledImage, // descriptor_type = DescriptorType::kSampledImage
      ShaderStage::kFragment, // shader_stage = ShaderStage::kFragment
    },
  };

};  // struct AdvancedBlendFragmentShader

}  // namespace impeller
