static const char * const x86_MSRs[] = {
	[0x00000000] = "IA32_P5_MC_ADDR",
	[0x00000001] = "IA32_P5_MC_TYPE",
	[0x00000010] = "IA32_TSC",
	[0x00000017] = "IA32_PLATFORM_ID",
	[0x0000001b] = "IA32_APICBASE",
	[0x00000020] = "KNC_PERFCTR0",
	[0x00000021] = "KNC_PERFCTR1",
	[0x00000028] = "KNC_EVNTSEL0",
	[0x00000029] = "KNC_EVNTSEL1",
	[0x0000002a] = "IA32_EBL_CR_POWERON",
	[0x0000002c] = "EBC_FREQUENCY_ID",
	[0x00000033] = "TEST_CTRL",
	[0x00000034] = "SMI_COUNT",
	[0x0000003a] = "IA32_FEAT_CTL",
	[0x0000003b] = "IA32_TSC_ADJUST",
	[0x00000040] = "LBR_CORE_FROM",
	[0x00000048] = "IA32_SPEC_CTRL",
	[0x00000049] = "IA32_PRED_CMD",
	[0x0000004e] = "PPIN_CTL",
	[0x0000004f] = "PPIN",
	[0x00000060] = "LBR_CORE_TO",
	[0x00000079] = "IA32_UCODE_WRITE",
	[0x00000087] = "IA32_MKTME_KEYID_PARTITIONING",
	[0x0000008C] = "IA32_SGXLEPUBKEYHASH0",
	[0x0000008D] = "IA32_SGXLEPUBKEYHASH1",
	[0x0000008E] = "IA32_SGXLEPUBKEYHASH2",
	[0x0000008F] = "IA32_SGXLEPUBKEYHASH3",
	[0x0000008b] = "AMD64_PATCH_LEVEL",
	[0x0000009b] = "IA32_SMM_MONITOR_CTL",
	[0x0000009e] = "IA32_SMBASE",
	[0x000000c1] = "IA32_PERFCTR0",
	[0x000000c2] = "IA32_PERFCTR1",
	[0x000000cd] = "FSB_FREQ",
	[0x000000ce] = "PLATFORM_INFO",
	[0x000000cf] = "IA32_CORE_CAPS",
	[0x000000e2] = "PKG_CST_CONFIG_CONTROL",
	[0x000000e7] = "IA32_MPERF",
	[0x000000e8] = "IA32_APERF",
	[0x000000fe] = "MTRRcap",
	[0x00000107] = "IDT_FCR1",
	[0x00000108] = "IDT_FCR2",
	[0x00000109] = "IDT_FCR3",
	[0x0000010F] = "TSX_FORCE_ABORT",
	[0x0000010a] = "IA32_ARCH_CAPABILITIES",
	[0x0000010b] = "IA32_FLUSH_CMD",
	[0x00000110] = "IDT_MCR0",
	[0x00000111] = "IDT_MCR1",
	[0x00000112] = "IDT_MCR2",
	[0x00000113] = "IDT_MCR3",
	[0x00000114] = "IDT_MCR4",
	[0x00000115] = "IDT_MCR5",
	[0x00000116] = "IDT_MCR6",
	[0x00000117] = "IDT_MCR7",
	[0x00000119] = "IA32_BBL_CR_CTL",
	[0x0000011e] = "IA32_BBL_CR_CTL3",
	[0x00000120] = "IDT_MCR_CTRL",
	[0x00000122] = "IA32_TSX_CTRL",
	[0x00000123] = "IA32_MCU_OPT_CTRL",
	[0x00000140] = "MISC_FEATURES_ENABLES",
	[0x00000174] = "IA32_SYSENTER_CS",
	[0x00000175] = "IA32_SYSENTER_ESP",
	[0x00000176] = "IA32_SYSENTER_EIP",
	[0x00000179] = "IA32_MCG_CAP",
	[0x0000017a] = "IA32_MCG_STATUS",
	[0x0000017b] = "IA32_MCG_CTL",
	[0x0000017f] = "ERROR_CONTROL",
	[0x00000180] = "IA32_MCG_EAX",
	[0x00000181] = "IA32_MCG_EBX",
	[0x00000182] = "IA32_MCG_ECX",
	[0x00000183] = "IA32_MCG_EDX",
	[0x00000184] = "IA32_MCG_ESI",
	[0x00000185] = "IA32_MCG_EDI",
	[0x00000186] = "IA32_MCG_EBP",
	[0x00000187] = "IA32_MCG_ESP",
	[0x00000188] = "IA32_MCG_EFLAGS",
	[0x00000189] = "IA32_MCG_EIP",
	[0x0000018a] = "IA32_MCG_RESERVED",
	[0x00000198] = "IA32_PERF_STATUS",
	[0x00000199] = "IA32_PERF_CTL",
	[0x0000019a] = "IA32_THERM_CONTROL",
	[0x0000019b] = "IA32_THERM_INTERRUPT",
	[0x0000019c] = "IA32_THERM_STATUS",
	[0x0000019d] = "THERM2_CTL",
	[0x000001a0] = "IA32_MISC_ENABLE",
	[0x000001a2] = "IA32_TEMPERATURE_TARGET",
	[0x000001a4] = "MISC_FEATURE_CONTROL",
	[0x000001a6] = "OFFCORE_RSP_0",
	[0x000001a7] = "OFFCORE_RSP_1",
	[0x000001aa] = "MISC_PWR_MGMT",
	[0x000001ad] = "TURBO_RATIO_LIMIT",
	[0x000001ae] = "TURBO_RATIO_LIMIT1",
	[0x000001af] = "TURBO_RATIO_LIMIT2",
	[0x000001b0] = "IA32_ENERGY_PERF_BIAS",
	[0x000001b1] = "IA32_PACKAGE_THERM_STATUS",
	[0x000001b2] = "IA32_PACKAGE_THERM_INTERRUPT",
	[0x000001c4] = "IA32_XFD",
	[0x000001c5] = "IA32_XFD_ERR",
	[0x000001c8] = "LBR_SELECT",
	[0x000001c9] = "LBR_TOS",
	[0x000001d9] = "IA32_DEBUGCTLMSR",
	[0x000001db] = "IA32_LASTBRANCHFROMIP",
	[0x000001dc] = "IA32_LASTBRANCHTOIP",
	[0x000001dd] = "IA32_LASTINTFROMIP",
	[0x000001de] = "IA32_LASTINTTOIP",
	[0x000001fc] = "IA32_POWER_CTL",
	[0x00000250] = "MTRRfix64K_00000",
	[0x00000258] = "MTRRfix16K_80000",
	[0x00000259] = "MTRRfix16K_A0000",
	[0x00000268] = "MTRRfix4K_C0000",
	[0x00000269] = "MTRRfix4K_C8000",
	[0x0000026a] = "MTRRfix4K_D0000",
	[0x0000026b] = "MTRRfix4K_D8000",
	[0x0000026c] = "MTRRfix4K_E0000",
	[0x0000026d] = "MTRRfix4K_E8000",
	[0x0000026e] = "MTRRfix4K_F0000",
	[0x0000026f] = "MTRRfix4K_F8000",
	[0x00000277] = "IA32_CR_PAT",
	[0x00000280] = "IA32_MC0_CTL2",
	[0x000002d9] = "INTEGRITY_CAPS",
	[0x000002ff] = "MTRRdefType",
	[0x00000309] = "CORE_PERF_FIXED_CTR0",
	[0x0000030a] = "CORE_PERF_FIXED_CTR1",
	[0x0000030b] = "CORE_PERF_FIXED_CTR2",
	[0x0000030c] = "CORE_PERF_FIXED_CTR3",
	[0x00000329] = "PERF_METRICS",
	[0x00000345] = "IA32_PERF_CAPABILITIES",
	[0x0000038d] = "CORE_PERF_FIXED_CTR_CTRL",
	[0x0000038e] = "CORE_PERF_GLOBAL_STATUS",
	[0x0000038f] = "CORE_PERF_GLOBAL_CTRL",
	[0x00000390] = "CORE_PERF_GLOBAL_OVF_CTRL",
	[0x000003f1] = "IA32_PEBS_ENABLE",
	[0x000003f2] = "PEBS_DATA_CFG",
	[0x000003f6] = "PEBS_LD_LAT_THRESHOLD",
	[0x000003f7] = "PEBS_FRONTEND",
	[0x000003f8] = "PKG_C3_RESIDENCY",
	[0x000003f9] = "PKG_C6_RESIDENCY",
	[0x000003fa] = "PKG_C7_RESIDENCY",
	[0x000003fc] = "CORE_C3_RESIDENCY",
	[0x000003fd] = "CORE_C6_RESIDENCY",
	[0x000003fe] = "CORE_C7_RESIDENCY",
	[0x000003ff] = "KNL_CORE_C6_RESIDENCY",
	[0x00000400] = "IA32_MC0_CTL",
	[0x00000401] = "IA32_MC0_STATUS",
	[0x00000402] = "IA32_MC0_ADDR",
	[0x00000403] = "IA32_MC0_MISC",
	[0x00000480] = "IA32_VMX_BASIC",
	[0x00000481] = "IA32_VMX_PINBASED_CTLS",
	[0x00000482] = "IA32_VMX_PROCBASED_CTLS",
	[0x00000483] = "IA32_VMX_EXIT_CTLS",
	[0x00000484] = "IA32_VMX_ENTRY_CTLS",
	[0x00000485] = "IA32_VMX_MISC",
	[0x00000486] = "IA32_VMX_CR0_FIXED0",
	[0x00000487] = "IA32_VMX_CR0_FIXED1",
	[0x00000488] = "IA32_VMX_CR4_FIXED0",
	[0x00000489] = "IA32_VMX_CR4_FIXED1",
	[0x0000048a] = "IA32_VMX_VMCS_ENUM",
	[0x0000048b] = "IA32_VMX_PROCBASED_CTLS2",
	[0x0000048c] = "IA32_VMX_EPT_VPID_CAP",
	[0x0000048d] = "IA32_VMX_TRUE_PINBASED_CTLS",
	[0x0000048e] = "IA32_VMX_TRUE_PROCBASED_CTLS",
	[0x0000048f] = "IA32_VMX_TRUE_EXIT_CTLS",
	[0x00000490] = "IA32_VMX_TRUE_ENTRY_CTLS",
	[0x00000491] = "IA32_VMX_VMFUNC",
	[0x00000492] = "IA32_VMX_PROCBASED_CTLS3",
	[0x000004c1] = "IA32_PMC0",
	[0x000004d0] = "IA32_MCG_EXT_CTL",
	[0x00000560] = "IA32_RTIT_OUTPUT_BASE",
	[0x00000561] = "IA32_RTIT_OUTPUT_MASK",
	[0x00000570] = "IA32_RTIT_CTL",
	[0x00000571] = "IA32_RTIT_STATUS",
	[0x00000572] = "IA32_RTIT_CR3_MATCH",
	[0x00000580] = "IA32_RTIT_ADDR0_A",
	[0x00000581] = "IA32_RTIT_ADDR0_B",
	[0x00000582] = "IA32_RTIT_ADDR1_A",
	[0x00000583] = "IA32_RTIT_ADDR1_B",
	[0x00000584] = "IA32_RTIT_ADDR2_A",
	[0x00000585] = "IA32_RTIT_ADDR2_B",
	[0x00000586] = "IA32_RTIT_ADDR3_A",
	[0x00000587] = "IA32_RTIT_ADDR3_B",
	[0x00000600] = "IA32_DS_AREA",
	[0x00000601] = "VR_CURRENT_CONFIG",
	[0x00000606] = "RAPL_POWER_UNIT",
	[0x0000060a] = "PKGC3_IRTL",
	[0x0000060b] = "PKGC6_IRTL",
	[0x0000060c] = "PKGC7_IRTL",
	[0x0000060d] = "PKG_C2_RESIDENCY",
	[0x00000610] = "PKG_POWER_LIMIT",
	[0x00000611] = "PKG_ENERGY_STATUS",
	[0x00000613] = "PKG_PERF_STATUS",
	[0x00000614] = "PKG_POWER_INFO",
	[0x00000618] = "DRAM_POWER_LIMIT",
	[0x00000619] = "DRAM_ENERGY_STATUS",
	[0x0000061b] = "DRAM_PERF_STATUS",
	[0x0000061c] = "DRAM_POWER_INFO",
	[0x00000630] = "PKG_C8_RESIDENCY",
	[0x00000631] = "PKG_C9_RESIDENCY",
	[0x00000632] = "PKG_C10_RESIDENCY",
	[0x00000633] = "PKGC8_IRTL",
	[0x00000634] = "PKGC9_IRTL",
	[0x00000635] = "PKGC10_IRTL",
	[0x00000638] = "PP0_POWER_LIMIT",
	[0x00000639] = "PP0_ENERGY_STATUS",
	[0x0000063a] = "PP0_POLICY",
	[0x0000063b] = "PP0_PERF_STATUS",
	[0x00000640] = "PP1_POWER_LIMIT",
	[0x00000641] = "PP1_ENERGY_STATUS",
	[0x00000642] = "PP1_POLICY",
	[0x00000648] = "CONFIG_TDP_NOMINAL",
	[0x00000649] = "CONFIG_TDP_LEVEL_1",
	[0x0000064A] = "CONFIG_TDP_LEVEL_2",
	[0x0000064B] = "CONFIG_TDP_CONTROL",
	[0x0000064C] = "TURBO_ACTIVATION_RATIO",
	[0x0000064D] = "PLATFORM_ENERGY_STATUS",
	[0x0000064e] = "PPERF",
	[0x0000064f] = "PERF_LIMIT_REASONS",
	[0x00000650] = "SECONDARY_TURBO_RATIO_LIMIT",
	[0x00000658] = "PKG_WEIGHTED_CORE_C0_RES",
	[0x00000659] = "PKG_ANY_CORE_C0_RES",
	[0x0000065A] = "PKG_ANY_GFXE_C0_RES",
	[0x0000065B] = "PKG_BOTH_CORE_GFXE_C0_RES",
	[0x00000660] = "CORE_C1_RES",
	[0x00000664] = "MODULE_C6_RES_MS",
	[0x00000668] = "CC6_DEMOTION_POLICY_CONFIG",
	[0x00000669] = "MC6_DEMOTION_POLICY_CONFIG",
	[0x00000680] = "LBR_NHM_FROM",
	[0x00000690] = "CORE_PERF_LIMIT_REASONS",
	[0x000006B0] = "GFX_PERF_LIMIT_REASONS",
	[0x000006B1] = "RING_PERF_LIMIT_REASONS",
	[0x000006a0] = "IA32_U_CET",
	[0x000006a2] = "IA32_S_CET",
	[0x000006a4] = "IA32_PL0_SSP",
	[0x000006a5] = "IA32_PL1_SSP",
	[0x000006a6] = "IA32_PL2_SSP",
	[0x000006a7] = "IA32_PL3_SSP",
	[0x000006a8] = "IA32_INT_SSP_TAB",
	[0x000006c0] = "LBR_NHM_TO",
	[0x00000770] = "PM_ENABLE",
	[0x00000771] = "HWP_CAPABILITIES",
	[0x00000772] = "HWP_REQUEST_PKG",
	[0x00000773] = "HWP_INTERRUPT",
	[0x00000774] = "HWP_REQUEST",
	[0x00000777] = "HWP_STATUS",
	[0x00000d90] = "IA32_BNDCFGS",
	[0x00000d93] = "IA32_PASID",
	[0x00000da0] = "IA32_XSS",
	[0x00000dc0] = "LBR_INFO_0",
	[0x00000ffc] = "IA32_BNDCFGS_RSVD",
};

#define x86_64_specific_MSRs_offset 0xc0000080
static const char * const x86_64_specific_MSRs[] = {
	[0xc0000080 - x86_64_specific_MSRs_offset] = "EFER",
	[0xc0000081 - x86_64_specific_MSRs_offset] = "STAR",
	[0xc0000082 - x86_64_specific_MSRs_offset] = "LSTAR",
	[0xc0000083 - x86_64_specific_MSRs_offset] = "CSTAR",
	[0xc0000084 - x86_64_specific_MSRs_offset] = "SYSCALL_MASK",
	[0xc0000085 - x86_64_specific_MSRs_offset] = "K6_UWCCR",
	[0xc0000086 - x86_64_specific_MSRs_offset] = "K6_EPMR",
	[0xc0000087 - x86_64_specific_MSRs_offset] = "K6_PSOR",
	[0xc0000088 - x86_64_specific_MSRs_offset] = "K6_PFIR",
	[0xc00000e9 - x86_64_specific_MSRs_offset] = "F17H_IRPERF",
	[0xc0000100 - x86_64_specific_MSRs_offset] = "FS_BASE",
	[0xc0000101 - x86_64_specific_MSRs_offset] = "GS_BASE",
	[0xc0000102 - x86_64_specific_MSRs_offset] = "KERNEL_GS_BASE",
	[0xc0000103 - x86_64_specific_MSRs_offset] = "TSC_AUX",
	[0xc0000104 - x86_64_specific_MSRs_offset] = "AMD64_TSC_RATIO",
	[0xc000010e - x86_64_specific_MSRs_offset] = "AMD64_LBR_SELECT",
	[0xc000010f - x86_64_specific_MSRs_offset] = "AMD_DBG_EXTN_CFG",
	[0xc0000200 - x86_64_specific_MSRs_offset] = "IA32_MBA_BW_BASE",
	[0xc0000280 - x86_64_specific_MSRs_offset] = "IA32_SMBA_BW_BASE",
	[0xc0000300 - x86_64_specific_MSRs_offset] = "AMD64_PERF_CNTR_GLOBAL_STATUS",
	[0xc0000301 - x86_64_specific_MSRs_offset] = "AMD64_PERF_CNTR_GLOBAL_CTL",
	[0xc0000302 - x86_64_specific_MSRs_offset] = "AMD64_PERF_CNTR_GLOBAL_STATUS_CLR",
	[0xc0000400 - x86_64_specific_MSRs_offset] = "IA32_EVT_CFG_BASE",
};

#define x86_AMD_V_KVM_MSRs_offset 0xc0010000
static const char * const x86_AMD_V_KVM_MSRs[] = {
	[0xc0010000 - x86_AMD_V_KVM_MSRs_offset] = "K7_EVNTSEL0",
	[0xc0010001 - x86_AMD_V_KVM_MSRs_offset] = "K7_EVNTSEL1",
	[0xc0010002 - x86_AMD_V_KVM_MSRs_offset] = "K7_EVNTSEL2",
	[0xc0010003 - x86_AMD_V_KVM_MSRs_offset] = "K7_EVNTSEL3",
	[0xc0010004 - x86_AMD_V_KVM_MSRs_offset] = "K7_PERFCTR0",
	[0xc0010005 - x86_AMD_V_KVM_MSRs_offset] = "K7_PERFCTR1",
	[0xc0010006 - x86_AMD_V_KVM_MSRs_offset] = "K7_PERFCTR2",
	[0xc0010007 - x86_AMD_V_KVM_MSRs_offset] = "K7_PERFCTR3",
	[0xc0010010 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_SYSCFG",
	[0xc0010015 - x86_AMD_V_KVM_MSRs_offset] = "K7_HWCR",
	[0xc001001a - x86_AMD_V_KVM_MSRs_offset] = "K8_TOP_MEM1",
	[0xc001001b - x86_AMD_V_KVM_MSRs_offset] = "K7_CLK_CTL",
	[0xc001001d - x86_AMD_V_KVM_MSRs_offset] = "K8_TOP_MEM2",
	[0xc001001f - x86_AMD_V_KVM_MSRs_offset] = "AMD64_NB_CFG",
	[0xc0010020 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_PATCH_LOADER",
	[0xc0010041 - x86_AMD_V_KVM_MSRs_offset] = "K7_FID_VID_CTL",
	[0xc0010042 - x86_AMD_V_KVM_MSRs_offset] = "K7_FID_VID_STATUS",
	[0xc0010044 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_MC0_MASK",
	[0xc0010055 - x86_AMD_V_KVM_MSRs_offset] = "K8_INT_PENDING_MSG",
	[0xc0010058 - x86_AMD_V_KVM_MSRs_offset] = "FAM10H_MMIO_CONF_BASE",
	[0xc0010062 - x86_AMD_V_KVM_MSRs_offset] = "AMD_PERF_CTL",
	[0xc0010063 - x86_AMD_V_KVM_MSRs_offset] = "AMD_PERF_STATUS",
	[0xc0010064 - x86_AMD_V_KVM_MSRs_offset] = "AMD_PSTATE_DEF_BASE",
	[0xc001007a - x86_AMD_V_KVM_MSRs_offset] = "F15H_CU_PWR_ACCUMULATOR",
	[0xc001007b - x86_AMD_V_KVM_MSRs_offset] = "F15H_CU_MAX_PWR_ACCUMULATOR",
	[0xc0010112 - x86_AMD_V_KVM_MSRs_offset] = "K8_TSEG_ADDR",
	[0xc0010113 - x86_AMD_V_KVM_MSRs_offset] = "K8_TSEG_MASK",
	[0xc0010114 - x86_AMD_V_KVM_MSRs_offset] = "VM_CR",
	[0xc0010115 - x86_AMD_V_KVM_MSRs_offset] = "VM_IGNNE",
	[0xc0010117 - x86_AMD_V_KVM_MSRs_offset] = "VM_HSAVE_PA",
	[0xc001011b - x86_AMD_V_KVM_MSRs_offset] = "AMD64_SVM_AVIC_DOORBELL",
	[0xc001011e - x86_AMD_V_KVM_MSRs_offset] = "AMD64_VM_PAGE_FLUSH",
	[0xc001011f - x86_AMD_V_KVM_MSRs_offset] = "AMD64_VIRT_SPEC_CTRL",
	[0xc0010130 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_SEV_ES_GHCB",
	[0xc0010131 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_SEV",
	[0xc0010132 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_RMP_BASE",
	[0xc0010133 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_RMP_END",
	[0xc0010140 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_OSVW_ID_LENGTH",
	[0xc0010141 - x86_AMD_V_KVM_MSRs_offset] = "AMD64_OSVW_STATUS",
	[0xc0010200 - x86_AMD_V_KVM_MSRs_offset] = "F15H_PERF_CTL",
	[0xc0010201 - x86_AMD_V_KVM_MSRs_offset] = "F15H_PERF_CTR",
	[0xc0010230 - x86_AMD_V_KVM_MSRs_offset] = "F16H_L2I_PERF_CTL",
	[0xc0010231 - x86_AMD_V_KVM_MSRs_offset] = "F16H_L2I_PERF_CTR",
	[0xc0010240 - x86_AMD_V_KVM_MSRs_offset] = "F15H_NB_PERF_CTL",
	[0xc0010241 - x86_AMD_V_KVM_MSRs_offset] = "F15H_NB_PERF_CTR",
	[0xc0010280 - x86_AMD_V_KVM_MSRs_offset] = "F15H_PTSC",
	[0xc0010299 - x86_AMD_V_KVM_MSRs_offset] = "AMD_RAPL_POWER_UNIT",
	[0xc001029a - x86_AMD_V_KVM_MSRs_offset] = "AMD_CORE_ENERGY_STATUS",
	[0xc001029b - x86_AMD_V_KVM_MSRs_offset] = "AMD_PKG_ENERGY_STATUS",
	[0xc00102b0 - x86_AMD_V_KVM_MSRs_offset] = "AMD_CPPC_CAP1",
	[0xc00102b1 - x86_AMD_V_KVM_MSRs_offset] = "AMD_CPPC_ENABLE",
	[0xc00102b2 - x86_AMD_V_KVM_MSRs_offset] = "AMD_CPPC_CAP2",
	[0xc00102b3 - x86_AMD_V_KVM_MSRs_offset] = "AMD_CPPC_REQ",
	[0xc00102b4 - x86_AMD_V_KVM_MSRs_offset] = "AMD_CPPC_STATUS",
	[0xc00102f0 - x86_AMD_V_KVM_MSRs_offset] = "AMD_PPIN_CTL",
	[0xc00102f1 - x86_AMD_V_KVM_MSRs_offset] = "AMD_PPIN",
	[0xc0010300 - x86_AMD_V_KVM_MSRs_offset] = "AMD_SAMP_BR_FROM",
	[0xc0010800 - x86_AMD_V_KVM_MSRs_offset] = "F19H_UMC_PERF_CTL",
	[0xc0010801 - x86_AMD_V_KVM_MSRs_offset] = "F19H_UMC_PERF_CTR",
};
