/* Generated by wayland-scanner 1.22.0 */

#ifndef FULLSCREEN_SHELL_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define FULLSCREEN_SHELL_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_fullscreen_shell_unstable_v1 The fullscreen_shell_unstable_v1 protocol
 * @section page_ifaces_fullscreen_shell_unstable_v1 Interfaces
 * - @subpage page_iface_zwp_fullscreen_shell_v1 - displays a single surface per output
 * - @subpage page_iface_zwp_fullscreen_shell_mode_feedback_v1 - 
 * @section page_copyright_fullscreen_shell_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2016 Yong Bakos
 * Copyright © 2015 Jason Ekstrand
 * Copyright © 2015 Jonas Ådahl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_output;
struct wl_surface;
struct zwp_fullscreen_shell_mode_feedback_v1;
struct zwp_fullscreen_shell_v1;

#ifndef ZWP_FULLSCREEN_SHELL_V1_INTERFACE
#define ZWP_FULLSCREEN_SHELL_V1_INTERFACE
/**
 * @page page_iface_zwp_fullscreen_shell_v1 zwp_fullscreen_shell_v1
 * @section page_iface_zwp_fullscreen_shell_v1_desc Description
 *
 * Displays a single surface per output.
 *
 * This interface provides a mechanism for a single client to display
 * simple full-screen surfaces.  While there technically may be multiple
 * clients bound to this interface, only one of those clients should be
 * shown at a time.
 *
 * To present a surface, the client uses either the present_surface or
 * present_surface_for_mode requests.  Presenting a surface takes effect
 * on the next wl_surface.commit.  See the individual requests for
 * details about scaling and mode switches.
 *
 * The client can have at most one surface per output at any time.
 * Requesting a surface to be presented on an output that already has a
 * surface replaces the previously presented surface.  Presenting a null
 * surface removes its content and effectively disables the output.
 * Exactly what happens when an output is "disabled" is
 * compositor-specific.  The same surface may be presented on multiple
 * outputs simultaneously.
 *
 * Once a surface is presented on an output, it stays on that output
 * until either the client removes it or the compositor destroys the
 * output.  This way, the client can update the output's contents by
 * simply attaching a new buffer.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 * @section page_iface_zwp_fullscreen_shell_v1_api API
 * See @ref iface_zwp_fullscreen_shell_v1.
 */
/**
 * @defgroup iface_zwp_fullscreen_shell_v1 The zwp_fullscreen_shell_v1 interface
 *
 * Displays a single surface per output.
 *
 * This interface provides a mechanism for a single client to display
 * simple full-screen surfaces.  While there technically may be multiple
 * clients bound to this interface, only one of those clients should be
 * shown at a time.
 *
 * To present a surface, the client uses either the present_surface or
 * present_surface_for_mode requests.  Presenting a surface takes effect
 * on the next wl_surface.commit.  See the individual requests for
 * details about scaling and mode switches.
 *
 * The client can have at most one surface per output at any time.
 * Requesting a surface to be presented on an output that already has a
 * surface replaces the previously presented surface.  Presenting a null
 * surface removes its content and effectively disables the output.
 * Exactly what happens when an output is "disabled" is
 * compositor-specific.  The same surface may be presented on multiple
 * outputs simultaneously.
 *
 * Once a surface is presented on an output, it stays on that output
 * until either the client removes it or the compositor destroys the
 * output.  This way, the client can update the output's contents by
 * simply attaching a new buffer.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 */
extern const struct wl_interface zwp_fullscreen_shell_v1_interface;
#endif
#ifndef ZWP_FULLSCREEN_SHELL_MODE_FEEDBACK_V1_INTERFACE
#define ZWP_FULLSCREEN_SHELL_MODE_FEEDBACK_V1_INTERFACE
/**
 * @page page_iface_zwp_fullscreen_shell_mode_feedback_v1 zwp_fullscreen_shell_mode_feedback_v1
 * @section page_iface_zwp_fullscreen_shell_mode_feedback_v1_api API
 * See @ref iface_zwp_fullscreen_shell_mode_feedback_v1.
 */
/**
 * @defgroup iface_zwp_fullscreen_shell_mode_feedback_v1 The zwp_fullscreen_shell_mode_feedback_v1 interface
 */
extern const struct wl_interface zwp_fullscreen_shell_mode_feedback_v1_interface;
#endif

#ifndef ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_ENUM
#define ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_ENUM
/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 * capabilities advertised by the compositor
 *
 * Various capabilities that can be advertised by the compositor.  They
 * are advertised one-at-a-time when the wl_fullscreen_shell interface is
 * bound.  See the wl_fullscreen_shell.capability event for more details.
 *
 * ARBITRARY_MODES:
 * This is a hint to the client that indicates that the compositor is
 * capable of setting practically any mode on its outputs.  If this
 * capability is provided, wl_fullscreen_shell.present_surface_for_mode
 * will almost never fail and clients should feel free to set whatever
 * mode they like.  If the compositor does not advertise this, it may
 * still support some modes that are not advertised through wl_global.mode
 * but it is less likely.
 *
 * CURSOR_PLANE:
 * This is a hint to the client that indicates that the compositor can
 * handle a cursor surface from the client without actually compositing.
 * This may be because of a hardware cursor plane or some other mechanism.
 * If the compositor does not advertise this capability then setting
 * wl_pointer.cursor may degrade performance or be ignored entirely.  If
 * CURSOR_PLANE is not advertised, it is recommended that the client draw
 * its own cursor and set wl_pointer.cursor(NULL).
 */
enum zwp_fullscreen_shell_v1_capability {
	/**
	 * compositor is capable of almost any output mode
	 */
	ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_ARBITRARY_MODES = 1,
	/**
	 * compositor has a separate cursor plane
	 */
	ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_CURSOR_PLANE = 2,
};
#endif /* ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_ENUM */

#ifndef ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ENUM
#define ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ENUM
/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 * different method to set the surface fullscreen
 *
 * Hints to indicate to the compositor how to deal with a conflict
 * between the dimensions of the surface and the dimensions of the
 * output. The compositor is free to ignore this parameter.
 */
enum zwp_fullscreen_shell_v1_present_method {
	/**
	 * no preference, apply default policy
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_DEFAULT = 0,
	/**
	 * center the surface on the output
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_CENTER = 1,
	/**
	 * scale the surface, preserving aspect ratio, to the largest size that will fit on the output
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ZOOM = 2,
	/**
	 * scale the surface, preserving aspect ratio, to fully fill the output cropping if needed
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ZOOM_CROP = 3,
	/**
	 * scale the surface to the size of the output ignoring aspect ratio
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_STRETCH = 4,
};
#endif /* ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ENUM */

#ifndef ZWP_FULLSCREEN_SHELL_V1_ERROR_ENUM
#define ZWP_FULLSCREEN_SHELL_V1_ERROR_ENUM
/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 * wl_fullscreen_shell error values
 *
 * These errors can be emitted in response to wl_fullscreen_shell requests.
 */
enum zwp_fullscreen_shell_v1_error {
	/**
	 * present_method is not known
	 */
	ZWP_FULLSCREEN_SHELL_V1_ERROR_INVALID_METHOD = 0,
	/**
	 * given wl_surface has another role
	 */
	ZWP_FULLSCREEN_SHELL_V1_ERROR_ROLE = 1,
};
#endif /* ZWP_FULLSCREEN_SHELL_V1_ERROR_ENUM */

/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 * @struct zwp_fullscreen_shell_v1_listener
 */
struct zwp_fullscreen_shell_v1_listener {
	/**
	 * advertises a capability of the compositor
	 *
	 * Advertises a single capability of the compositor.
	 *
	 * When the wl_fullscreen_shell interface is bound, this event is
	 * emitted once for each capability advertised. Valid capabilities
	 * are given by the wl_fullscreen_shell.capability enum. If clients
	 * want to take advantage of any of these capabilities, they should
	 * use a wl_display.sync request immediately after binding to
	 * ensure that they receive all the capability events.
	 */
	void (*capability)(void *data,
			   struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1,
			   uint32_t capability);
};

/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 */
static inline int
zwp_fullscreen_shell_v1_add_listener(struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1,
				     const struct zwp_fullscreen_shell_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_fullscreen_shell_v1,
				     (void (**)(void)) listener, data);
}

#define ZWP_FULLSCREEN_SHELL_V1_RELEASE 0
#define ZWP_FULLSCREEN_SHELL_V1_PRESENT_SURFACE 1
#define ZWP_FULLSCREEN_SHELL_V1_PRESENT_SURFACE_FOR_MODE 2

/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 */
#define ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 */
#define ZWP_FULLSCREEN_SHELL_V1_RELEASE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 */
#define ZWP_FULLSCREEN_SHELL_V1_PRESENT_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 */
#define ZWP_FULLSCREEN_SHELL_V1_PRESENT_SURFACE_FOR_MODE_SINCE_VERSION 1

/** @ingroup iface_zwp_fullscreen_shell_v1 */
static inline void
zwp_fullscreen_shell_v1_set_user_data(struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_fullscreen_shell_v1, user_data);
}

/** @ingroup iface_zwp_fullscreen_shell_v1 */
static inline void *
zwp_fullscreen_shell_v1_get_user_data(struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_fullscreen_shell_v1);
}

static inline uint32_t
zwp_fullscreen_shell_v1_get_version(struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_fullscreen_shell_v1);
}

/** @ingroup iface_zwp_fullscreen_shell_v1 */
static inline void
zwp_fullscreen_shell_v1_destroy(struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwp_fullscreen_shell_v1);
}

/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 *
 * Release the binding from the wl_fullscreen_shell interface.
 *
 * This destroys the server-side object and frees this binding.  If
 * the client binds to wl_fullscreen_shell multiple times, it may wish
 * to free some of those bindings.
 */
static inline void
zwp_fullscreen_shell_v1_release(struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_fullscreen_shell_v1,
			 ZWP_FULLSCREEN_SHELL_V1_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_fullscreen_shell_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 *
 * Present a surface on the given output.
 *
 * If the output is null, the compositor will present the surface on
 * whatever display (or displays) it thinks best.  In particular, this
 * may replace any or all surfaces currently presented so it should
 * not be used in combination with placing surfaces on specific
 * outputs.
 *
 * The method parameter is a hint to the compositor for how the surface
 * is to be presented.  In particular, it tells the compositor how to
 * handle a size mismatch between the presented surface and the
 * output.  The compositor is free to ignore this parameter.
 *
 * The "zoom", "zoom_crop", and "stretch" methods imply a scaling
 * operation on the surface.  This will override any kind of output
 * scaling, so the buffer_scale property of the surface is effectively
 * ignored.
 *
 * This request gives the surface the role of a fullscreen shell surface.
 * If the surface already has another role, it raises a role protocol
 * error.
 */
static inline void
zwp_fullscreen_shell_v1_present_surface(struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1, struct wl_surface *surface, uint32_t method, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_fullscreen_shell_v1,
			 ZWP_FULLSCREEN_SHELL_V1_PRESENT_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_fullscreen_shell_v1), 0, surface, method, output);
}

/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 *
 * Presents a surface on the given output for a particular mode.
 *
 * If the current size of the output differs from that of the surface,
 * the compositor will attempt to change the size of the output to
 * match the surface.  The result of the mode-switch operation will be
 * returned via the provided wl_fullscreen_shell_mode_feedback object.
 *
 * If the current output mode matches the one requested or if the
 * compositor successfully switches the mode to match the surface,
 * then the mode_successful event will be sent and the output will
 * contain the contents of the given surface.  If the compositor
 * cannot match the output size to the surface size, the mode_failed
 * will be sent and the output will contain the contents of the
 * previously presented surface (if any).  If another surface is
 * presented on the given output before either of these has a chance
 * to happen, the present_cancelled event will be sent.
 *
 * Due to race conditions and other issues unknown to the client, no
 * mode-switch operation is guaranteed to succeed.  However, if the
 * mode is one advertised by wl_output.mode or if the compositor
 * advertises the ARBITRARY_MODES capability, then the client should
 * expect that the mode-switch operation will usually succeed.
 *
 * If the size of the presented surface changes, the resulting output
 * is undefined.  The compositor may attempt to change the output mode
 * to compensate.  However, there is no guarantee that a suitable mode
 * will be found and the client has no way to be notified of success
 * or failure.
 *
 * The framerate parameter specifies the desired framerate for the
 * output in mHz.  The compositor is free to ignore this parameter.  A
 * value of 0 indicates that the client has no preference.
 *
 * If the value of wl_output.scale differs from wl_surface.buffer_scale,
 * then the compositor may choose a mode that matches either the buffer
 * size or the surface size.  In either case, the surface will fill the
 * output.
 *
 * This request gives the surface the role of a fullscreen shell surface.
 * If the surface already has another role, it raises a role protocol
 * error.
 */
static inline struct zwp_fullscreen_shell_mode_feedback_v1 *
zwp_fullscreen_shell_v1_present_surface_for_mode(struct zwp_fullscreen_shell_v1 *zwp_fullscreen_shell_v1, struct wl_surface *surface, struct wl_output *output, int32_t framerate)
{
	struct wl_proxy *feedback;

	feedback = wl_proxy_marshal_flags((struct wl_proxy *) zwp_fullscreen_shell_v1,
			 ZWP_FULLSCREEN_SHELL_V1_PRESENT_SURFACE_FOR_MODE, &zwp_fullscreen_shell_mode_feedback_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwp_fullscreen_shell_v1), 0, surface, output, framerate, NULL);

	return (struct zwp_fullscreen_shell_mode_feedback_v1 *) feedback;
}

/**
 * @ingroup iface_zwp_fullscreen_shell_mode_feedback_v1
 * @struct zwp_fullscreen_shell_mode_feedback_v1_listener
 */
struct zwp_fullscreen_shell_mode_feedback_v1_listener {
	/**
	 * mode switch succeeded
	 *
	 * This event indicates that the attempted mode switch operation
	 * was successful. A surface of the size requested in the mode
	 * switch will fill the output without scaling.
	 *
	 * Upon receiving this event, the client should destroy the
	 * wl_fullscreen_shell_mode_feedback object.
	 */
	void (*mode_successful)(void *data,
				struct zwp_fullscreen_shell_mode_feedback_v1 *zwp_fullscreen_shell_mode_feedback_v1);
	/**
	 * mode switch failed
	 *
	 * This event indicates that the attempted mode switch operation
	 * failed. This may be because the requested output mode is not
	 * possible or it may mean that the compositor does not want to
	 * allow it.
	 *
	 * Upon receiving this event, the client should destroy the
	 * wl_fullscreen_shell_mode_feedback object.
	 */
	void (*mode_failed)(void *data,
			    struct zwp_fullscreen_shell_mode_feedback_v1 *zwp_fullscreen_shell_mode_feedback_v1);
	/**
	 * mode switch cancelled
	 *
	 * This event indicates that the attempted mode switch operation
	 * was cancelled. Most likely this is because the client requested
	 * a second mode switch before the first one completed.
	 *
	 * Upon receiving this event, the client should destroy the
	 * wl_fullscreen_shell_mode_feedback object.
	 */
	void (*present_cancelled)(void *data,
				  struct zwp_fullscreen_shell_mode_feedback_v1 *zwp_fullscreen_shell_mode_feedback_v1);
};

/**
 * @ingroup iface_zwp_fullscreen_shell_mode_feedback_v1
 */
static inline int
zwp_fullscreen_shell_mode_feedback_v1_add_listener(struct zwp_fullscreen_shell_mode_feedback_v1 *zwp_fullscreen_shell_mode_feedback_v1,
						   const struct zwp_fullscreen_shell_mode_feedback_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_fullscreen_shell_mode_feedback_v1,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_zwp_fullscreen_shell_mode_feedback_v1
 */
#define ZWP_FULLSCREEN_SHELL_MODE_FEEDBACK_V1_MODE_SUCCESSFUL_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_fullscreen_shell_mode_feedback_v1
 */
#define ZWP_FULLSCREEN_SHELL_MODE_FEEDBACK_V1_MODE_FAILED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_fullscreen_shell_mode_feedback_v1
 */
#define ZWP_FULLSCREEN_SHELL_MODE_FEEDBACK_V1_PRESENT_CANCELLED_SINCE_VERSION 1


/** @ingroup iface_zwp_fullscreen_shell_mode_feedback_v1 */
static inline void
zwp_fullscreen_shell_mode_feedback_v1_set_user_data(struct zwp_fullscreen_shell_mode_feedback_v1 *zwp_fullscreen_shell_mode_feedback_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_fullscreen_shell_mode_feedback_v1, user_data);
}

/** @ingroup iface_zwp_fullscreen_shell_mode_feedback_v1 */
static inline void *
zwp_fullscreen_shell_mode_feedback_v1_get_user_data(struct zwp_fullscreen_shell_mode_feedback_v1 *zwp_fullscreen_shell_mode_feedback_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_fullscreen_shell_mode_feedback_v1);
}

static inline uint32_t
zwp_fullscreen_shell_mode_feedback_v1_get_version(struct zwp_fullscreen_shell_mode_feedback_v1 *zwp_fullscreen_shell_mode_feedback_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_fullscreen_shell_mode_feedback_v1);
}

/** @ingroup iface_zwp_fullscreen_shell_mode_feedback_v1 */
static inline void
zwp_fullscreen_shell_mode_feedback_v1_destroy(struct zwp_fullscreen_shell_mode_feedback_v1 *zwp_fullscreen_shell_mode_feedback_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwp_fullscreen_shell_mode_feedback_v1);
}

#ifdef  __cplusplus
}
#endif

#endif
