/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-reqstat.h"
#include "libical-glib-private.h"
#include "i-cal-enums.h"

G_DEFINE_TYPE (ICalReqstat, i_cal_reqstat, I_CAL_TYPE_OBJECT)

static void i_cal_reqstat_class_init (G_GNUC_UNUSED ICalReqstatClass *klass)
{
}

static void i_cal_reqstat_init (G_GNUC_UNUSED ICalReqstat *self)
{
}

/**
 * i_cal_reqstat_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalReqstat *
i_cal_reqstat_new_full (struct icalreqstattype native)
{
    ICalReqstat *object;
    struct icalreqstattype *clone;
    
    
    clone = g_new (struct icalreqstattype, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_REQSTAT,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_reqstat_new_from_string:
 * @str: A string
 *
 * Creates a #ICalReqstat from string.
 *
 * Returns: (transfer full): The newly created #ICalReqstat.
 *
 * Since: 1.0
 *
 **/
ICalReqstat *
i_cal_reqstat_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_reqstat_new_full (icalreqstattype_from_string (str));
}

/**
 * i_cal_reqstat_to_string:
 * @stat: A #ICalReqstat
 *
 * Converts #ICalReqstat to a string representation.
 *
 * Returns: (transfer full): A string.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_reqstat_to_string (ICalReqstat *stat)
{
	g_return_val_if_fail (I_CAL_IS_REQSTAT (stat), NULL);

	return icalreqstattype_as_string_r (* (struct icalreqstattype *)i_cal_object_get_native (I_CAL_OBJECT (stat)));
}

/**
 * i_cal_reqstat_new_default: (skip)
 *
 * Creates a new default #ICalReqstat.
 *
 * Returns: (transfer full): The newly created #ICalReqstat
 *
 * Since: 1.0
 *
 **/
struct icalreqstattype
i_cal_reqstat_new_default (void)
{
        struct icalreqstattype reqstattype;
        reqstattype.code = ICAL_UNKNOWN_STATUS;
        reqstattype.desc = NULL;
        reqstattype.debug = NULL;
        return reqstattype;
}

/**
 * i_cal_reqstat_get_code:
 * @reqstat: The #ICalReqstat
 *
 * Gets the code of #ICalReqstat.
 *
 * Returns: The code of @reqstat.
 *
 * Since: 1.0
 *
 **/
ICalRequestStatus
i_cal_reqstat_get_code (ICalReqstat *reqstat)
{
        g_return_val_if_fail (reqstat != NULL && I_CAL_IS_REQSTAT (reqstat), I_CAL_UNKNOWN_STATUS);
        return (ICalRequestStatus) (((struct icalreqstattype *)i_cal_object_get_native ((ICalObject *)reqstat))->code);
}

/**
 * i_cal_reqstat_set_code:
 * @reqstat: The #ICalReqstat
 * @code: The code of @reqstat
 *
 * Sets the code of #ICalReqstat.
 *
 * Since: 1.0
 *
 **/
void
i_cal_reqstat_set_code (ICalReqstat *reqstat, 
                        ICalRequestStatus code)
{
        g_return_if_fail (reqstat != NULL && I_CAL_IS_REQSTAT (reqstat));
        ((struct icalreqstattype *)i_cal_object_get_native ((ICalObject *)reqstat))->code = (icalrequeststatus) (code);
}

/**
 * i_cal_reqstat_get_desc:
 * @reqstat: The #ICalReqstat
 *
 * Gets the desc of #ICalReqstat.
 *
 * Returns: (transfer none): The desc of @reqstat.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_reqstat_get_desc (const ICalReqstat *reqstat)
{
        g_return_val_if_fail (reqstat != NULL && I_CAL_IS_REQSTAT (reqstat), NULL);
        return ((struct icalreqstattype *)i_cal_object_get_native ((ICalObject *)reqstat))->desc;
}

/**
 * i_cal_reqstat_get_debug:
 * @reqstat: The #ICalReqstat
 *
 * Gets the debug of #ICalReqstat.
 *
 * Returns: (transfer none): The debug of @reqstat.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_reqstat_get_debug (const ICalReqstat *reqstat)
{
        g_return_val_if_fail (reqstat != NULL && I_CAL_IS_REQSTAT (reqstat), NULL);
        return ((struct icalreqstattype *)i_cal_object_get_native ((ICalObject *)reqstat))->debug;
}
