/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-component.h"
#include "libical-glib-private.h"
#include "i-cal-property.h"
#include "i-cal-comp-iter.h"
#include "i-cal-time-span.h"
#include "i-cal-enums.h"
#include "i-cal-time.h"
#include "i-cal-derived-value.h"
#include "i-cal-timezone.h"
#include "i-cal-derived-property.h"
#include "i-cal-duration.h"

G_DEFINE_TYPE (ICalComponent, i_cal_component, I_CAL_TYPE_OBJECT)

static void i_cal_component_class_init (G_GNUC_UNUSED ICalComponentClass *klass)
{
}

static void i_cal_component_init (G_GNUC_UNUSED ICalComponent *self)
{
}

/**
 * i_cal_component_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalComponent *
i_cal_component_new_full (icalcomponent *native, 
                          GObject *owner)
{
    ICalComponent *object;
    if (native == NULL)
        return NULL;
    
    
    object = i_cal_object_construct (I_CAL_TYPE_COMPONENT,
                            (gpointer) native,
                            (GDestroyNotify) icalcomponent_free,
                            FALSE,
                            owner);

    return object;
}


struct ForeachTZIDData {
    void (* callback)(ICalParameter *param, void *user_data);
    void *user_data;
};

static void foreach_tzid_cb(icalparameter *in_param, void *user_data)
{
    ICalParameter *param;
    struct ForeachTZIDData *data = user_data;

    g_return_if_fail (data != NULL);

    param = i_cal_parameter_new_full(in_param, NULL);
    (*(data->callback))(param, data->user_data);
    i_cal_object_steal_native((ICalObject *) param);
    g_object_unref(param);
}

struct ForeachRecurrenceData {
    ICalComponent *comp;
    void (* callback)(ICalComponent *comp, ICalTimeSpan *span, void *user_data);
    void *user_data;
};

static void foreach_recurrence_cb(icalcomponent *in_comp, struct icaltime_span *in_span, void *user_data)
{
    ICalTimeSpan *span;
    struct ForeachRecurrenceData *data = user_data;

    g_return_if_fail (data != NULL);
    g_return_if_fail (in_span != NULL);
    g_warn_if_fail (i_cal_object_get_native ((ICalObject *)data->comp) == (gpointer) in_comp);

    span = i_cal_time_span_new_full(*in_span);
    (*(data->callback))(data->comp, span, data->user_data);
    g_object_unref(span);
}

/**
 * i_cal_component_new:
 * @kind: The #ICalComponentKind
 *
 * Creates a new #ICalComponent with specific type.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new (ICalComponentKind kind)
{
	return i_cal_component_new_full (icalcomponent_new ((icalcomponent_kind) (kind)), NULL);
}

/**
 * i_cal_component_clone:
 * @component: The #ICalComponent to be created
 *
 * Deeply clone a #ICalComponent.
 *
 * Returns: (transfer full): The newly deeply cloned #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_clone (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return i_cal_component_new_full (icalcomponent_new_clone ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))), NULL);
}

/**
 * i_cal_component_new_from_string:
 * @str: The string used to create #ICalComponent
 *
 * Creates a new #ICalComponent based on a string.
 *
 * Returns: (transfer full): The newly created #ICalComponent based on @str.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_new_from_string (str), NULL);
}

/**
 * i_cal_component_new_x:
 * @x_name: The name of x property
 *
 * Creates a new #ICalComponent based on name of x property.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_x (const gchar *x_name)
{
	g_return_val_if_fail (x_name != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_new_x (x_name), NULL);
}

/**
 * i_cal_component_free: (skip)
 * @component: The #ICalComponent to be freed
 *
 * Frees a #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_free (ICalComponent *component)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (component));

	icalcomponent_free ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_as_ical_string:
 * @component: The #ICalComponent to be converted
 *
 * Converts a #ICalComponent to a string.
 *
 * Returns: (transfer full): The string representation of #ICalComponent.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_component_as_ical_string (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return icalcomponent_as_ical_string_r ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_is_valid:
 * @component: The #ICalComponent to be checked
 *
 * Checks whether #ICalComponent is valid.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_component_is_valid (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), FALSE);

	return icalcomponent_is_valid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_isa:
 * @component: The #ICalComponent to be checked
 *
 * Gets the type of #ICalComponent.
 *
 * Returns: A #ICalComponentKind.
 *
 * Since: 1.0
 *
 **/
ICalComponentKind
i_cal_component_isa (const ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), I_CAL_NO_COMPONENT);

	return (ICalComponentKind) (icalcomponent_isa ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))));
}

/**
 * i_cal_component_isa_component:
 * @component: The #ICalComponent to be checked
 *
 * Checks whether the native part of #ICalComponent is icalcomponent.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_isa_component (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), 0);

	return icalcomponent_isa_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_add_property:
 * @component: A #ICalComponent
 * @property: An #ICalProperty
 *
 * Adds an #ICalProperty into #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_add_property (ICalComponent *component, 
                              ICalProperty *property)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (component));
	g_return_if_fail (I_CAL_IS_PROPERTY (property));

	i_cal_object_set_owner ((ICalObject *)property, (GObject *)component);
	icalcomponent_add_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property)));
}

/**
 * i_cal_component_take_property: (skip)
 * @component: An #ICalComponent
 * @property: (transfer full): An #ICalProperty
 *
 * Adds the @property into the @component and unrefs the @property.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_take_property (ICalComponent *component, 
                               ICalProperty *property)
{
    g_return_if_fail(I_CAL_IS_COMPONENT(component));
    g_return_if_fail(I_CAL_IS_PROPERTY(property));

    i_cal_component_add_property(component, property);
    g_object_unref(property);
}

/**
 * i_cal_component_remove_property:
 * @component: A #ICalComponent
 * @property: A #ICalProperty
 *
 * Removes #ICalProperty from #ICalComponent. Caution: The compare is based on address. So you must use
 * the original #ICalProperty as the target.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_remove_property (ICalComponent *component, 
                                 ICalProperty *property)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (component));
	g_return_if_fail (I_CAL_IS_PROPERTY (property));

	i_cal_object_remove_owner (I_CAL_OBJECT (property));
	icalcomponent_remove_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property)));
}

/**
 * i_cal_component_count_properties:
 * @component: The #ICalComponent
 * @kind: A #ICalPropertyKind
 *
 * Counts the number of #ICalProperty in #ICalComponent.
 *
 * Returns: The number of #ICalProperty.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_count_properties (ICalComponent *component, 
                                  ICalPropertyKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), 0);

	return icalcomponent_count_properties ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalproperty_kind) (kind));
}

/**
 * i_cal_property_get_parent:
 * @property: The #ICalProperty
 *
 * Gets the parent component of the property. Use with caution. When icalproperty is deallocated, it won't
 * deallocate its parent. However the #ICalComponent object created using this method will be deallocated
 * (if no reference in other places). So You need to make sure there is another reference except the one
 * in #ICalProperty.
 *
 * Returns: (transfer full) (nullable): The parent #ICalComponent of #ICalProperty.
 *
 * Since: 2.0
 *
 **/
ICalComponent *
i_cal_property_get_parent (ICalProperty *property)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (property), NULL);

	return i_cal_component_new_full (icalproperty_get_parent ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property))), (GObject *)property);
}

/**
 * i_cal_property_set_parent:
 * @property: An #ICalProperty
 * @component: (nullable): An #ICalComponent
 *
 * Sets the parent #ICalComponent of the specified #ICalProperty.
 *
 * Since: 3.0
 *
 **/
void
i_cal_property_set_parent (ICalProperty *property, 
                           ICalComponent *component)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (property));
	if(component)
		g_return_if_fail (I_CAL_IS_COMPONENT (component));

	icalproperty_set_parent ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property)), ((component)?((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))):NULL));
}

/**
 * i_cal_property_get_datetime_with_component:
 * @prop: An #ICalProperty
 * @comp: (nullable): An #ICalComponent
 *
 * If the property is a DATE-TIME with a TZID parameter and a corresponding VTIMEZONE is present in the
 * component, the returned component will already be in the correct timezone; otherwise the caller is responsible
 * for converting it.
 *
 * The @comp can be NULL, in which case the parent of the @prop is used to find
 * the corresponding time zone.
 *
 * Returns: (transfer full): Get a DATE or DATE-TIME property as an #ICalTime.
 *
 * Since: 3.0.5
 *
 **/
ICalTime *
i_cal_property_get_datetime_with_component (ICalProperty *prop, 
                                            ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	if(comp)
		g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_time_new_full (icalproperty_get_datetime_with_component ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), ((comp)?((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))):NULL)));
}

/**
 * i_cal_component_get_current_property:
 * @component: A #ICalComponent
 *
 * Gets the current #ICalProperty in #ICalComponent.
 *
 * Returns: (transfer full): The current #ICalProperty.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_component_get_current_property (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return i_cal_property_new_full (icalcomponent_get_current_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))), (GObject *)component);
}

/**
 * i_cal_component_get_first_property:
 * @component: A #ICalComponent
 * @kind: A #ICalPropertyKind
 *
 * Gets the first #ICalProperty with specific kind in #ICalComponent.
 *
 * Returns: (transfer full) (nullable): The first #ICalProperty.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_component_get_first_property (ICalComponent *component, 
                                    ICalPropertyKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return i_cal_property_new_full (icalcomponent_get_first_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalproperty_kind) (kind)), (GObject *)component);
}

/**
 * i_cal_component_get_next_property:
 * @component: A #ICalComponent
 * @kind: A #ICalPropertyKind
 *
 * Gets the next #ICalProperty with specific kind in #ICalComponent.
 *
 * Returns: (transfer full) (nullable): The next #ICalProperty.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_component_get_next_property (ICalComponent *component, 
                                   ICalPropertyKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return i_cal_property_new_full (icalcomponent_get_next_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalproperty_kind) (kind)), (GObject *)component);
}

/**
 * i_cal_component_get_inner:
 * @comp: A #ICalComponent
 *
 * Returns the first VEVENT, VTODO or VJOURNAL sub-component of cop, or comp if it is one of those types.
 *
 * Returns: (transfer full) (nullable): The first VEVENT, VTODO or VJOURNAL sub-component.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_inner (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_component_new_full (icalcomponent_get_inner ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))), (GObject *)comp);
}

/**
 * i_cal_component_add_component:
 * @parent: A #ICalComponent
 * @child: A child #ICalComponent
 *
 * Adds a #ICalComponent into another #ICalComponent as a child component.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_add_component (ICalComponent *parent, 
                               ICalComponent *child)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (parent));
	g_return_if_fail (I_CAL_IS_COMPONENT (child));

	i_cal_object_set_owner ((ICalObject *)child, (GObject *)(GObject*) parent);
	icalcomponent_add_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (parent)), (icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (child)));
}

/**
 * i_cal_component_take_component: (skip)
 * @parent: A #ICalComponent
 * @child: (transfer full): A child #ICalComponent
 *
 * Adds the @child into the @parent as a child component and unrefs the @child.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_take_component (ICalComponent *parent, 
                                ICalComponent *child)
{
    g_return_if_fail(I_CAL_IS_COMPONENT(parent));
    g_return_if_fail(I_CAL_IS_COMPONENT(child));

    i_cal_component_add_component(parent, child);
    g_object_unref(child);
}

/**
 * i_cal_component_remove_component:
 * @parent: A #ICalComponent
 * @child: A child #ICalComponent
 *
 * Removes a child #ICalComponent from another #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_remove_component (ICalComponent *parent, 
                                  ICalComponent *child)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (parent));
	g_return_if_fail (I_CAL_IS_COMPONENT (child));

	i_cal_object_remove_owner (I_CAL_OBJECT (child));
	icalcomponent_remove_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (parent)), (icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (child)));
}

/**
 * i_cal_component_count_components:
 * @component: The #ICalComponent to be checked
 * @kind: The target #ICalComponentKind
 *
 * Counts the child #ICalComponent with the target kind in the parent one.
 *
 * Returns: The count of child #ICalComponent in the parent one.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_count_components (ICalComponent *component, 
                                  ICalComponentKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), 0);

	return icalcomponent_count_components ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalcomponent_kind) (kind));
}

/**
 * i_cal_component_get_parent:
 * @component: The #ICalComponent
 *
 * Gets the parent component of the @component.
 *
 * Returns: (transfer full) (nullable): The parent #ICalComponent of the @component.
 *
 * Since: 3.0
 *
 **/
ICalComponent *
i_cal_component_get_parent (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return i_cal_component_new_full (icalcomponent_get_parent ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))), (GObject *)component);
}

/**
 * i_cal_component_set_parent:
 * @component: An #ICalComponent, a child
 * @parent: (nullable): An #ICalComponent, a new parent
 *
 * Sets the @parent #ICalComponent of the specified @component.
 *
 * Since: 3.0
 *
 **/
void
i_cal_component_set_parent (ICalComponent *component, 
                            ICalComponent *parent)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (component));
	if(parent)
		g_return_if_fail (I_CAL_IS_COMPONENT (parent));

	icalcomponent_set_parent ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), ((parent)?((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (parent))):NULL));
}

/**
 * i_cal_component_merge_component:
 * @comp: The #ICalComponent
 * @comp_to_merge: (in): A #ICalComponent. After merged it will not exist any more.
 *
 * Takes 2 VCALENDAR components and merges the second one into the first, resolving any problems with conflicting
 * TZIDs. comp_to_merge will no longer exist after calling this function.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_merge_component (ICalComponent *comp, 
                                 ICalComponent *comp_to_merge)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (I_CAL_IS_COMPONENT (comp_to_merge));

	icalcomponent_merge_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), (icalcomponent *)i_cal_object_steal_native (I_CAL_OBJECT (comp_to_merge)));
}

/**
 * i_cal_component_get_current_component:
 * @component: A #ICalComponent
 *
 * Gets the current #ICalComponent in #ICalComponent.
 *
 * Returns: (transfer full): The current #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_current_component (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return i_cal_component_new_full (icalcomponent_get_current_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))), (GObject *)component);
}

/**
 * i_cal_component_get_first_component:
 * @component: A #ICalComponent
 * @kind: A #ICalComponentKind
 *
 * Gets the first #ICalComponent with specific kind in #ICalComponent.
 *
 * Returns: (transfer full) (nullable): The first #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_first_component (ICalComponent *component, 
                                     ICalComponentKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return i_cal_component_new_full (icalcomponent_get_first_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalcomponent_kind) (kind)), (GObject *)component);
}

/**
 * i_cal_component_get_next_component:
 * @component: A #ICalComponent
 * @kind: A #ICalComponentKind
 *
 * Gets the next #ICalComponent with specific kind in #ICalComponent.
 *
 * Returns: (transfer full) (nullable): The next #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_next_component (ICalComponent *component, 
                                    ICalComponentKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return i_cal_component_new_full (icalcomponent_get_next_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalcomponent_kind) (kind)), (GObject *)component);
}

/**
 * i_cal_component_begin_component:
 * @component: A #ICalComponent
 * @kind: A #ICalComponentKind
 *
 * Gets the #ICalCompIter pointing to the first child #ICalComponent.
 *
 * Returns: (transfer full): A #ICalCompIter
 *
 * Since: 1.0
 *
 **/
ICalCompIter *
i_cal_component_begin_component (ICalComponent *component, 
                                 ICalComponentKind kind)
{
    ICalCompIter *iter;

    g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

    iter = i_cal_comp_iter_new_full(icalcomponent_begin_component((icalcomponent *)i_cal_object_get_native(I_CAL_OBJECT (component)), (icalcomponent_kind) (kind)));
    if (iter) {
        i_cal_object_set_owner(I_CAL_OBJECT(iter), G_OBJECT(component));
        i_cal_object_set_always_destroy(I_CAL_OBJECT(iter), TRUE);
    }

    return iter;
}

/**
 * i_cal_component_end_component:
 * @component: A #ICalComponent
 * @kind: A #ICalComponentKind
 *
 * Gets the #ICalCompIter pointing to the end child #ICalComponent.
 *
 * Returns: (transfer full): A #ICalCompIter
 *
 * Since: 1.0
 *
 **/
ICalCompIter *
i_cal_component_end_component (ICalComponent *component, 
                               ICalComponentKind kind)
{
    ICalCompIter *iter;
    g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

    iter = i_cal_comp_iter_new_full(icalcomponent_end_component((icalcomponent *)i_cal_object_get_native(I_CAL_OBJECT (component)), (icalcomponent_kind) (kind)));
    if (iter) {
        i_cal_object_set_owner(I_CAL_OBJECT(iter), G_OBJECT(component));
        i_cal_object_set_always_destroy(I_CAL_OBJECT(iter), TRUE);
    }

    return iter;
}

/**
 * i_cal_comp_iter_next:
 * @i: A #ICalCompIter
 *
 * Gets the next #ICalComponent pointed by #ICalCompIter.
 *
 * Returns: (transfer full): A #ICalCompIter
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_comp_iter_next (ICalCompIter *i)
{
    ICalComponent *comp;

    g_return_val_if_fail (I_CAL_IS_COMP_ITER (i), NULL);

    comp = i_cal_component_new_full(icalcompiter_next((struct icalcompiter *)i_cal_object_get_native(I_CAL_OBJECT (i))), NULL);
    if (comp) {
        GObject *owner = i_cal_object_ref_owner(I_CAL_OBJECT(i));
        i_cal_object_set_owner(I_CAL_OBJECT(comp), owner);
        g_clear_object(&owner);
    }

    return comp;
}

/**
 * i_cal_comp_iter_prior:
 * @i: A #ICalCompIter
 *
 * Gets the prior #ICalComponent pointed by #ICalCompIter.
 *
 * Returns: (transfer full): A #ICalCompIter
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_comp_iter_prior (ICalCompIter *i)
{
    ICalComponent *comp;

    g_return_val_if_fail (I_CAL_IS_COMP_ITER (i), NULL);

    comp = i_cal_component_new_full(icalcompiter_prior((struct icalcompiter *)i_cal_object_get_native(I_CAL_OBJECT (i))), NULL);
    if (comp) {
        GObject *owner = i_cal_object_ref_owner(I_CAL_OBJECT(i));
        i_cal_object_set_owner(I_CAL_OBJECT(comp), owner);
        g_clear_object(&owner);
    }

    return comp;
}

/**
 * i_cal_comp_iter_deref:
 * @i: A #ICalCompIter
 *
 * Gets the current #ICalComponent pointed by #ICalCompIter.
 *
 * Returns: (transfer full): A #ICalComponent
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_comp_iter_deref (ICalCompIter *i)
{
    ICalComponent *comp;

    g_return_val_if_fail (I_CAL_IS_COMP_ITER (i), NULL);

    comp = i_cal_component_new_full(icalcompiter_deref((struct icalcompiter *)i_cal_object_get_native(I_CAL_OBJECT (i))), NULL);
    if (comp) {
        GObject *owner = i_cal_object_ref_owner(I_CAL_OBJECT(i));
        i_cal_object_set_owner(I_CAL_OBJECT(comp), owner);
        g_clear_object(&owner);
    }

    return comp;
}

/**
 * i_cal_component_check_restrictions:
 * @comp: The #ICalComponent to be checked
 *
 * Checks the number of restrictions in #ICalComponent.
 *
 * Returns: The number of restrictions in @comp
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_check_restrictions (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), 0);

	return icalcomponent_check_restrictions ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_count_errors:
 * @comp: A #ICalComponent
 *
 * Counts the number of errors in #ICalComponent.
 *
 * Returns: The count of errors.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_count_errors (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), 0);

	return icalcomponent_count_errors ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_strip_errors:
 * @comp: A #ICalComponent
 *
 * Removes all X-LIC-ERROR properties.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_strip_errors (ICalComponent *comp)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));

	icalcomponent_strip_errors ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_convert_errors:
 * @comp: A #ICalComponent
 *
 * Converts some X-LIC-ERROR properties into RETURN-STATUS properties.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_convert_errors (ICalComponent *comp)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));

	icalcomponent_convert_errors ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_kind_is_valid:
 * @kind: A #ICalComponentKind
 *
 * Checks if a #ICalComponentKind is valid.
 *
 * Returns: 1 if @kind id a #ICalComponent but not the I_CAL_NO_COMPONENT, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_component_kind_is_valid (const ICalComponentKind kind)
{
	return icalcomponent_kind_is_valid ((icalcomponent_kind) (kind));
}

/**
 * i_cal_component_kind_from_string:
 * @string: A string
 *
 * Converts a string to a #ICalComponentKind.
 *
 * Returns: A #ICalComponentKind
 *
 * Since: 1.0
 *
 **/
ICalComponentKind
i_cal_component_kind_from_string (const gchar *string)
{
	g_return_val_if_fail (string != NULL, I_CAL_NO_COMPONENT);

	return (ICalComponentKind) (icalcomponent_string_to_kind (string));
}

/**
 * i_cal_component_kind_to_string:
 * @kind: A #ICalComponentKind
 *
 * Converts a #ICalComponentKind to a string.
 *
 * Returns: (transfer none): The string representation of @kind.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_kind_to_string (ICalComponentKind kind)
{
	return icalcomponent_kind_to_string ((icalcomponent_kind) (kind));
}

/**
 * i_cal_component_get_first_real_component:
 * @c: A VCOMPONENT type of #ICalComponent
 *
 * For VCOMPONENT: Returns a reference to the first VEVENT, VTODO or VJOURNAL.
 *
 * Returns: (transfer full): A reference to the first VEVENT, VTODO or VJOURNAL
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_first_real_component (ICalComponent *c)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (c), NULL);

	return i_cal_component_new_full (icalcomponent_get_first_real_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (c))), (GObject *)c);
}

/**
 * i_cal_component_get_span:
 * @comp: A #ICalComponent
 *
 * For VEVENT, VTODO, VJOURNAL and VTIMEZONE: reports the start and end times of an event in UTC.
 *
 * Returns: (transfer full): A #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
ICalTimeSpan *
i_cal_component_get_span (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_time_span_new_full (icalcomponent_get_span ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_dtstart:
 * @comp: A #ICalComponent
 * @v: A #ICalTime
 *
 * Sets the dtstart of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_dtstart (ICalComponent *comp, 
                             ICalTime *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (I_CAL_IS_TIME (v));

	icalcomponent_set_dtstart ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_dtstart:
 * @comp: A #ICalComponent
 *
 * Gets the dtstart of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTime.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_component_get_dtstart (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_time_new_full (icalcomponent_get_dtstart ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_dtend:
 * @comp: A #ICalComponent
 * @v: A #ICalTime
 *
 * Sets the dtend of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_dtend (ICalComponent *comp, 
                           ICalTime *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (I_CAL_IS_TIME (v));

	icalcomponent_set_dtend ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_dtend:
 * @comp: A #ICalComponent
 *
 * Gets the dtend of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTime.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_component_get_dtend (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_time_new_full (icalcomponent_get_dtend ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_due:
 * @comp: A #ICalComponent
 * @v: A #ICalTime
 *
 * Sets the due of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_due (ICalComponent *comp, 
                         ICalTime *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (I_CAL_IS_TIME (v));

	icalcomponent_set_due ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_due:
 * @comp: A #ICalComponent
 *
 * Gets the due of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTime.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_component_get_due (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_time_new_full (icalcomponent_get_due ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_duration:
 * @comp: A #ICalComponent
 * @v: A #ICalDuration
 *
 * Sets the duration of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_duration (ICalComponent *comp, 
                              ICalDuration *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (I_CAL_IS_DURATION (v));

	icalcomponent_set_duration ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaldurationtype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_duration:
 * @comp: A #ICalComponent
 *
 * Gets the duration of the #ICalComponent.
 *
 * Returns: (transfer full): An #ICalDuration.
 *
 * Since: 1.0
 *
 **/
ICalDuration *
i_cal_component_get_duration (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_duration_new_full (icalcomponent_get_duration ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_method:
 * @comp: A #ICalComponent
 * @method: A #ICalPropertyMethod
 *
 * Sets the method of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_method (ICalComponent *comp, 
                            ICalPropertyMethod method)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));

	icalcomponent_set_method ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), (icalproperty_method) (method));
}

/**
 * i_cal_component_get_method:
 * @comp: A #ICalComponent
 *
 * Gets the method of the #ICalComponent.
 *
 * Returns: A #ICalPropertyMethod.
 *
 * Since: 1.0
 *
 **/
ICalPropertyMethod
i_cal_component_get_method (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), I_CAL_METHOD_NONE);

	return (ICalPropertyMethod) (icalcomponent_get_method ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_dtstamp:
 * @comp: A #ICalComponent
 * @v: A #ICalTime
 *
 * Sets the dtstamp of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_dtstamp (ICalComponent *comp, 
                             ICalTime *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (I_CAL_IS_TIME (v));

	icalcomponent_set_dtstamp ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_dtstamp:
 * @comp: A #ICalComponent
 *
 * Gets the dtstamp of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTime.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_component_get_dtstamp (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_time_new_full (icalcomponent_get_dtstamp ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_summary:
 * @comp: A #ICalComponent
 * @v: A string representing summary
 *
 * Sets the summary of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_summary (ICalComponent *comp, 
                             const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (v != NULL);

	icalcomponent_set_summary ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_summary:
 * @comp: A #ICalComponent
 *
 * Gets the summary of the #ICalComponent.
 *
 * Returns: (transfer none): The summary of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_summary (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return icalcomponent_get_summary ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_comment:
 * @comp: A #ICalComponent
 * @v: A string representing comment
 *
 * Sets the comment of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_comment (ICalComponent *comp, 
                             const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (v != NULL);

	icalcomponent_set_comment ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_comment:
 * @comp: A #ICalComponent
 *
 * Gets the comment of the #ICalComponent.
 *
 * Returns: (transfer none): The comment of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_comment (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return icalcomponent_get_comment ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_uid:
 * @comp: A #ICalComponent
 * @v: A string representing uid
 *
 * Sets the uid of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_uid (ICalComponent *comp, 
                         const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (v != NULL);

	icalcomponent_set_uid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_uid:
 * @comp: A #ICalComponent
 *
 * Gets the uid of the #ICalComponent.
 *
 * Returns: (transfer none): The uid of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_uid (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return icalcomponent_get_uid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_relcalid:
 * @comp: A #ICalComponent
 * @v: A string representing relcalid
 *
 * Sets the relcalid of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_relcalid (ICalComponent *comp, 
                              const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (v != NULL);

	icalcomponent_set_relcalid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_relcalid:
 * @comp: A #ICalComponent
 *
 * Gets the relcalid of the #ICalComponent.
 *
 * Returns: (transfer none): The relcalid of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_relcalid (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return icalcomponent_get_relcalid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_recurrenceid:
 * @comp: A #ICalComponent
 * @v: A #ICalTime
 *
 * Sets the recurrenceid of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_recurrenceid (ICalComponent *comp, 
                                  ICalTime *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (I_CAL_IS_TIME (v));

	icalcomponent_set_recurrenceid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_recurrenceid:
 * @comp: A #ICalComponent
 *
 * Gets the recurrenceid of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTime.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_component_get_recurrenceid (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return i_cal_time_new_full (icalcomponent_get_recurrenceid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_description:
 * @comp: A #ICalComponent
 * @v: A string representing description
 *
 * Sets the description of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_description (ICalComponent *comp, 
                                 const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (v != NULL);

	icalcomponent_set_description ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_description:
 * @comp: A #ICalComponent
 *
 * Gets the description of the #ICalComponent.
 *
 * Returns: (transfer none): The description of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_description (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return icalcomponent_get_description ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_location:
 * @comp: A #ICalComponent
 * @v: A string representing location
 *
 * Sets the location of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_location (ICalComponent *comp, 
                              const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (v != NULL);

	icalcomponent_set_location ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_location:
 * @comp: A #ICalComponent
 *
 * Gets the location of the #ICalComponent.
 *
 * Returns: (transfer none): The location of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_location (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);

	return icalcomponent_get_location ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_sequence:
 * @comp: A #ICalComponent
 * @v: The sequence number
 *
 * Sets the sequence of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_sequence (ICalComponent *comp, 
                              gint v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));

	icalcomponent_set_sequence ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_sequence:
 * @comp: A #ICalComponent
 *
 * Gets the sequence of the #ICalComponent.
 *
 * Returns: The sequence of @comp.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_get_sequence (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), 0);

	return icalcomponent_get_sequence ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_status:
 * @comp: A #ICalComponent
 * @status: A #ICalPropertyStatus
 *
 * Sets the status of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_status (ICalComponent *comp, 
                            ICalPropertyStatus status)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));

	icalcomponent_set_status ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), (icalproperty_status) (status));
}

/**
 * i_cal_component_get_status:
 * @comp: A #ICalComponent
 *
 * Gets the status of the #ICalComponent.
 *
 * Returns: A #ICalPropertyStatus.
 *
 * Since: 1.0
 *
 **/
ICalPropertyStatus
i_cal_component_get_status (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), I_CAL_STATUS_NONE);

	return (ICalPropertyStatus) (icalcomponent_get_status ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_foreach_tzid:
 * @comp: The #ICalComponent to be queried
 * @callback: (scope call): The callback function
 * @user_data: (nullable) (closure callback): The data for callback function
 *
 * Applies the same manipulation on every tzid in #ICalComponent.
 *
 * Since: 3.0.5
 *
 **/
void
i_cal_component_foreach_tzid (ICalComponent *comp, 
                              ICalComponentForeachTZIDFunc callback, 
                              gpointer user_data)
{
    struct ForeachTZIDData data;
    icalcomponent *native_comp;

    g_return_if_fail (I_CAL_IS_COMPONENT (comp));
    g_return_if_fail (callback != NULL);

    native_comp = i_cal_object_get_native((ICalObject *) comp);
    g_return_if_fail (native_comp != NULL);

    data.callback = callback;
    data.user_data = user_data;

    icalcomponent_foreach_tzid(native_comp, foreach_tzid_cb, &data);
}

/**
 * i_cal_component_foreach_recurrence:
 * @comp: The #ICalComponent to be queried
 * @start: Ignore timespans before this
 * @end: Ignore timespans after this
 * @callback: (scope call): Function called for each timespan within the range
 * @user_data: (nullable) (closure callback): The user data for callback function
 *
 * Cycles through all recurrences of an event. This function will call the specified callback function for
 * once for the base value of DTSTART, and foreach recurring date/time value. It will filter out events
 * that are specified as an EXDATE or an EXRULE.
 *
 * Since: 3.0.5
 *
 **/
void
i_cal_component_foreach_recurrence (ICalComponent *comp, 
                                    ICalTime *start, 
                                    ICalTime *end, 
                                    ICalComponentForeachRecurrenceFunc callback, 
                                    gpointer user_data)
{
    struct ForeachRecurrenceData data;
    icalcomponent *native_comp;
    struct icaltimetype *native_start, *native_end;

    g_return_if_fail (I_CAL_IS_COMPONENT (comp));
    g_return_if_fail (I_CAL_IS_TIME(start));
    g_return_if_fail (I_CAL_IS_TIME(end));
    g_return_if_fail (callback != NULL);

    native_comp = i_cal_object_get_native((ICalObject *) comp);
    native_start = i_cal_object_get_native((ICalObject *) start);
    native_end = i_cal_object_get_native((ICalObject *) end);
    g_return_if_fail (native_comp != NULL);
    g_return_if_fail (native_start != NULL);
    g_return_if_fail (native_end != NULL);

    data.comp = comp;
    data.callback = callback;
    data.user_data = user_data;

    icalcomponent_foreach_recurrence(native_comp, *native_start, *native_end, foreach_recurrence_cb, &data);
}

/**
 * i_cal_component_get_timezone:
 * @comp: A #ICalComponent
 * @tzid: A string representing timezone
 *
 * Returns the icaltimezone in the component corresponding to the TZID, or NULL if it can't be found.
 *
 * Returns: (transfer full) (nullable): A #ICalTimezone.
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_component_get_timezone (ICalComponent *comp, 
                              const gchar *tzid)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (tzid != NULL, NULL);

	return i_cal_timezone_new_full (icalcomponent_get_timezone ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), tzid), (GObject *)comp, FALSE);
}

/**
 * i_cal_property_recurrence_is_excluded:
 * @comp: A #ICalComponent
 * @dtstart: The base dtstart value for this component
 * @recurtime: The time to test against
 *
 * Decides if this recurrence is acceptable. This function decides if a specific recurrence value is excluded
 * by EXRULE or EXDATE properties.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_property_recurrence_is_excluded (ICalComponent *comp, 
                                       ICalTime *dtstart, 
                                       ICalTime *recurtime)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), FALSE);
	g_return_val_if_fail (I_CAL_IS_TIME (dtstart), FALSE);
	g_return_val_if_fail (I_CAL_IS_TIME (recurtime), FALSE);

	return icalproperty_recurrence_is_excluded ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (dtstart)), (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (recurtime)));
}

/**
 * i_cal_component_new_vcalendar:
 *
 * Creates a #ICalComponent with the type to be vcalendar.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vcalendar (void)
{
	return i_cal_component_new_full (icalcomponent_new_vcalendar (), NULL);
}

/**
 * i_cal_component_new_vevent:
 *
 * Creates a #ICalComponent with the type to be vevent.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vevent (void)
{
	return i_cal_component_new_full (icalcomponent_new_vevent (), NULL);
}

/**
 * i_cal_component_new_vtodo:
 *
 * Creates a #ICalComponent with the type to be vtodo.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vtodo (void)
{
	return i_cal_component_new_full (icalcomponent_new_vtodo (), NULL);
}

/**
 * i_cal_component_new_vjournal:
 *
 * Creates a #ICalComponent with the type to be vjournal.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vjournal (void)
{
	return i_cal_component_new_full (icalcomponent_new_vjournal (), NULL);
}

/**
 * i_cal_component_new_valarm:
 *
 * Creates a #ICalComponent with the type to be valarm.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_valarm (void)
{
	return i_cal_component_new_full (icalcomponent_new_valarm (), NULL);
}

/**
 * i_cal_component_new_vfreebusy:
 *
 * Creates a #ICalComponent with the type to be vfreebusy.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vfreebusy (void)
{
	return i_cal_component_new_full (icalcomponent_new_vfreebusy (), NULL);
}

/**
 * i_cal_component_new_vtimezone:
 *
 * Creates a #ICalComponent with the type to be vtimezone.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vtimezone (void)
{
	return i_cal_component_new_full (icalcomponent_new_vtimezone (), NULL);
}

/**
 * i_cal_component_new_xstandard:
 *
 * Creates a #ICalComponent with the type to be xstandard.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_xstandard (void)
{
	return i_cal_component_new_full (icalcomponent_new_xstandard (), NULL);
}

/**
 * i_cal_component_new_xdaylight:
 *
 * Creates a #ICalComponent with the type to be xdaylight.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_xdaylight (void)
{
	return i_cal_component_new_full (icalcomponent_new_xdaylight (), NULL);
}

/**
 * i_cal_component_new_vagenda:
 *
 * Creates a #ICalComponent with the type to be vagenda.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vagenda (void)
{
	return i_cal_component_new_full (icalcomponent_new_vagenda (), NULL);
}

/**
 * i_cal_component_new_vquery:
 *
 * Creates a #ICalComponent with the type to be vquery.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vquery (void)
{
	return i_cal_component_new_full (icalcomponent_new_vquery (), NULL);
}

/**
 * i_cal_component_new_vavailability:
 *
 * Creates a #ICalComponent with the type to be vavailability.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vavailability (void)
{
	return i_cal_component_new_full (icalcomponent_new_vavailability (), NULL);
}

/**
 * i_cal_component_new_xavailable:
 *
 * Creates a #ICalComponent with the type to be xavailable.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_xavailable (void)
{
	return i_cal_component_new_full (icalcomponent_new_xavailable (), NULL);
}

/**
 * i_cal_component_new_vpoll:
 *
 * Creates a #ICalComponent with the type to be vpoll.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vpoll (void)
{
	return i_cal_component_new_full (icalcomponent_new_vpoll (), NULL);
}

/**
 * i_cal_component_new_vvoter:
 *
 * Creates a #ICalComponent with the type to be vvoter.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vvoter (void)
{
	return i_cal_component_new_full (icalcomponent_new_vvoter (), NULL);
}

/**
 * i_cal_component_new_xvote:
 *
 * Creates a #ICalComponent with the type to be xvote.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_xvote (void)
{
	return i_cal_component_new_full (icalcomponent_new_xvote (), NULL);
}
