/*
 * Copyright (C) 2011 David Goulet <dgoulet@efficios.com>
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 *
 */

#define _LGPL_SOURCE
#include <common/compat/fcntl.h>
#include <common/macros.h>
#include <common/bug.h>
#include <stdint.h>
#include <unistd.h>

#ifdef __linux__

LTTNG_HIDDEN
int compat_sync_file_range(int fd, off_t offset, off_t nbytes,
		unsigned int flags)
{
	LTTNG_BUILD_BUG_ON(sizeof(off_t) != sizeof(int64_t));
#ifdef HAVE_SYNC_FILE_RANGE
	return sync_file_range(fd, offset, nbytes, flags);
#else
	return fdatasync(fd);
#endif
}

#endif /* __linux__ */
