/* Generated by wayland-scanner 1.22.0 */

#ifndef WESTON_TOUCH_CALIBRATION_CLIENT_PROTOCOL_H
#define WESTON_TOUCH_CALIBRATION_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_weston_touch_calibration The weston_touch_calibration protocol
 * @section page_ifaces_weston_touch_calibration Interfaces
 * - @subpage page_iface_weston_touch_calibration - weston touchscreen calibration interface
 * - @subpage page_iface_weston_touch_calibrator - calibrator surface for a specific touch device
 * - @subpage page_iface_weston_touch_coordinate - coordinate conversion reply
 * @section page_copyright_weston_touch_calibration Copyright
 * <pre>
 *
 * Copyright 2017-2018 Collabora, Ltd.
 * Copyright 2017-2018 General Electric Company
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct weston_touch_calibration;
struct weston_touch_calibrator;
struct weston_touch_coordinate;
struct wl_surface;

#ifndef WESTON_TOUCH_CALIBRATION_INTERFACE
#define WESTON_TOUCH_CALIBRATION_INTERFACE
/**
 * @page page_iface_weston_touch_calibration weston_touch_calibration
 * @section page_iface_weston_touch_calibration_desc Description
 *
 * This is the global interface for calibrating a touchscreen input
 * coordinate transformation. It is recommended to make this interface
 * privileged.
 *
 * This interface can be used by a client to show a calibration pattern and
 * receive uncalibrated touch coordinates, facilitating the computation of
 * a calibration transformation that will align actual touch positions
 * on screen with their expected coordinates.
 *
 * Immediately after being bound by a client, the compositor sends the
 * touch_device events.
 *
 * The client chooses a touch device from the touch_device events, creates a
 * wl_surface and then a weston_touch_calibrator for the wl_surface and the
 * chosen touch device. The client waits for the compositor to send a
 * configure event before it starts drawing the first calibration pattern.
 * After receiving the configure event, the client will iterate drawing a
 * pattern, getting touch input via weston_touch_calibrator, and converting
 * pixel coordinates to expected touch coordinates with
 * weston_touch_calibrator.convert until it has enough correspondences to
 * compute the calibration transformation or the compositor cancels the
 * calibration.
 *
 * Once the client has successfully computed a new calibration, it can use
 * weston_touch_calibration.save request to load the new calibration into
 * the compositor. The compositor may take this new calibration into use and
 * may write it into persistent storage.
 * @section page_iface_weston_touch_calibration_api API
 * See @ref iface_weston_touch_calibration.
 */
/**
 * @defgroup iface_weston_touch_calibration The weston_touch_calibration interface
 *
 * This is the global interface for calibrating a touchscreen input
 * coordinate transformation. It is recommended to make this interface
 * privileged.
 *
 * This interface can be used by a client to show a calibration pattern and
 * receive uncalibrated touch coordinates, facilitating the computation of
 * a calibration transformation that will align actual touch positions
 * on screen with their expected coordinates.
 *
 * Immediately after being bound by a client, the compositor sends the
 * touch_device events.
 *
 * The client chooses a touch device from the touch_device events, creates a
 * wl_surface and then a weston_touch_calibrator for the wl_surface and the
 * chosen touch device. The client waits for the compositor to send a
 * configure event before it starts drawing the first calibration pattern.
 * After receiving the configure event, the client will iterate drawing a
 * pattern, getting touch input via weston_touch_calibrator, and converting
 * pixel coordinates to expected touch coordinates with
 * weston_touch_calibrator.convert until it has enough correspondences to
 * compute the calibration transformation or the compositor cancels the
 * calibration.
 *
 * Once the client has successfully computed a new calibration, it can use
 * weston_touch_calibration.save request to load the new calibration into
 * the compositor. The compositor may take this new calibration into use and
 * may write it into persistent storage.
 */
extern const struct wl_interface weston_touch_calibration_interface;
#endif
#ifndef WESTON_TOUCH_CALIBRATOR_INTERFACE
#define WESTON_TOUCH_CALIBRATOR_INTERFACE
/**
 * @page page_iface_weston_touch_calibrator weston_touch_calibrator
 * @section page_iface_weston_touch_calibrator_desc Description
 *
 * On creation, this object is tied to a specific touch device. The
 * compositor sends a configure event which the client must obey with the
 * associated wl_surface.
 *
 * Once the client has committed content to the surface, the compositor can
 * grab the touch input device, prevent it from emitting normal touch
 * events, show the surface on the correct output, and relay input events
 * from the touch device via this protocol object.
 *
 * Touch events from other touch devices than the one tied to this object
 * must generate wrong_touch events on at least touch-down and must not
 * generate normal or calibration touch events.
 *
 * At any time, the compositor can choose to cancel the calibration
 * procedure by sending the cancel_calibration event. This should also be
 * used if the touch device disappears or anything else prevents the
 * calibration from continuing on the compositor side.
 *
 * If the wl_surface is destroyed, the compositor must cancel the
 * calibration.
 *
 * The touch event coordinates and conversion results are delivered in
 * calibration units. The calibration units cover the device coordinate
 * range exactly. Calibration units are in the closed interval [0.0, 1.0]
 * mapped into 32-bit unsigned integers. An integer can be converted into a
 * real value by dividing by 2^32-1. A calibration matrix must be computed
 * from the [0.0, 1.0] real values, but the matrix elements do not need to
 * fall into that range.
 * @section page_iface_weston_touch_calibrator_api API
 * See @ref iface_weston_touch_calibrator.
 */
/**
 * @defgroup iface_weston_touch_calibrator The weston_touch_calibrator interface
 *
 * On creation, this object is tied to a specific touch device. The
 * compositor sends a configure event which the client must obey with the
 * associated wl_surface.
 *
 * Once the client has committed content to the surface, the compositor can
 * grab the touch input device, prevent it from emitting normal touch
 * events, show the surface on the correct output, and relay input events
 * from the touch device via this protocol object.
 *
 * Touch events from other touch devices than the one tied to this object
 * must generate wrong_touch events on at least touch-down and must not
 * generate normal or calibration touch events.
 *
 * At any time, the compositor can choose to cancel the calibration
 * procedure by sending the cancel_calibration event. This should also be
 * used if the touch device disappears or anything else prevents the
 * calibration from continuing on the compositor side.
 *
 * If the wl_surface is destroyed, the compositor must cancel the
 * calibration.
 *
 * The touch event coordinates and conversion results are delivered in
 * calibration units. The calibration units cover the device coordinate
 * range exactly. Calibration units are in the closed interval [0.0, 1.0]
 * mapped into 32-bit unsigned integers. An integer can be converted into a
 * real value by dividing by 2^32-1. A calibration matrix must be computed
 * from the [0.0, 1.0] real values, but the matrix elements do not need to
 * fall into that range.
 */
extern const struct wl_interface weston_touch_calibrator_interface;
#endif
#ifndef WESTON_TOUCH_COORDINATE_INTERFACE
#define WESTON_TOUCH_COORDINATE_INTERFACE
/**
 * @page page_iface_weston_touch_coordinate weston_touch_coordinate
 * @section page_iface_weston_touch_coordinate_desc Description
 * @section page_iface_weston_touch_coordinate_api API
 * See @ref iface_weston_touch_coordinate.
 */
/**
 * @defgroup iface_weston_touch_coordinate The weston_touch_coordinate interface
 */
extern const struct wl_interface weston_touch_coordinate_interface;
#endif

#ifndef WESTON_TOUCH_CALIBRATION_ERROR_ENUM
#define WESTON_TOUCH_CALIBRATION_ERROR_ENUM
/**
 * @ingroup iface_weston_touch_calibration
 * global interface errors
 */
enum weston_touch_calibration_error {
	/**
	 * the given wl_surface already has a role
	 */
	WESTON_TOUCH_CALIBRATION_ERROR_INVALID_SURFACE = 0,
	/**
	 * the given device is not valid
	 */
	WESTON_TOUCH_CALIBRATION_ERROR_INVALID_DEVICE = 1,
	/**
	 * a calibrator has already been created
	 */
	WESTON_TOUCH_CALIBRATION_ERROR_ALREADY_EXISTS = 2,
};
#endif /* WESTON_TOUCH_CALIBRATION_ERROR_ENUM */

/**
 * @ingroup iface_weston_touch_calibration
 * @struct weston_touch_calibration_listener
 */
struct weston_touch_calibration_listener {
	/**
	 * advertise a touchscreen input device
	 *
	 * When a client binds to weston_touch_calibration, one
	 * touch_device event is sent for each touchscreen that is
	 * available to be calibrated. This is the only time the event is
	 * sent. Touch devices added in the compositor will not generate
	 * events for existing weston_touch_calibration objects.
	 *
	 * An event carries the touch device identification and the
	 * associated output or head (display connector) name.
	 *
	 * On platforms using udev, the device identification is the udev
	 * sys path. It is an absolute path and starts with the sys mount
	 * point.
	 * @param device the touch device identification
	 * @param head name of the head or display connector
	 */
	void (*touch_device)(void *data,
			     struct weston_touch_calibration *weston_touch_calibration,
			     const char *device,
			     const char *head);
};

/**
 * @ingroup iface_weston_touch_calibration
 */
static inline int
weston_touch_calibration_add_listener(struct weston_touch_calibration *weston_touch_calibration,
				      const struct weston_touch_calibration_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) weston_touch_calibration,
				     (void (**)(void)) listener, data);
}

#define WESTON_TOUCH_CALIBRATION_DESTROY 0
#define WESTON_TOUCH_CALIBRATION_CREATE_CALIBRATOR 1
#define WESTON_TOUCH_CALIBRATION_SAVE 2

/**
 * @ingroup iface_weston_touch_calibration
 */
#define WESTON_TOUCH_CALIBRATION_TOUCH_DEVICE_SINCE_VERSION 1

/**
 * @ingroup iface_weston_touch_calibration
 */
#define WESTON_TOUCH_CALIBRATION_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibration
 */
#define WESTON_TOUCH_CALIBRATION_CREATE_CALIBRATOR_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibration
 */
#define WESTON_TOUCH_CALIBRATION_SAVE_SINCE_VERSION 1

/** @ingroup iface_weston_touch_calibration */
static inline void
weston_touch_calibration_set_user_data(struct weston_touch_calibration *weston_touch_calibration, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) weston_touch_calibration, user_data);
}

/** @ingroup iface_weston_touch_calibration */
static inline void *
weston_touch_calibration_get_user_data(struct weston_touch_calibration *weston_touch_calibration)
{
	return wl_proxy_get_user_data((struct wl_proxy *) weston_touch_calibration);
}

static inline uint32_t
weston_touch_calibration_get_version(struct weston_touch_calibration *weston_touch_calibration)
{
	return wl_proxy_get_version((struct wl_proxy *) weston_touch_calibration);
}

/**
 * @ingroup iface_weston_touch_calibration
 *
 * Destroy the binding to the global interface, does not affect any
 * objects already created through this interface.
 */
static inline void
weston_touch_calibration_destroy(struct weston_touch_calibration *weston_touch_calibration)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_touch_calibration,
			 WESTON_TOUCH_CALIBRATION_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) weston_touch_calibration), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_weston_touch_calibration
 *
 * This gives the calibrator role to the surface and ties it with the
 * given touch input device.
 *
 * If the surface already has a role, then invalid_surface error is raised.
 *
 * If the device string is not one advertised with touch_device event's
 * device argument, then invalid_device error is raised.
 *
 * If a weston_touch_calibrator protocol object exists in the compositor
 * already, then already_exists error is raised. This limitation is
 * compositor-wide and not specific to any particular client.
 */
static inline struct weston_touch_calibrator *
weston_touch_calibration_create_calibrator(struct weston_touch_calibration *weston_touch_calibration, struct wl_surface *surface, const char *device)
{
	struct wl_proxy *cal;

	cal = wl_proxy_marshal_flags((struct wl_proxy *) weston_touch_calibration,
			 WESTON_TOUCH_CALIBRATION_CREATE_CALIBRATOR, &weston_touch_calibrator_interface, wl_proxy_get_version((struct wl_proxy *) weston_touch_calibration), 0, surface, device, NULL);

	return (struct weston_touch_calibrator *) cal;
}

/**
 * @ingroup iface_weston_touch_calibration
 *
 * This request asks the compositor to save the calibration data for the
 * given touch input device. The compositor may ignore this request.
 *
 * If the device string is not one advertised with touch_device event's
 * device argument, then invalid_device error is raised.
 *
 * The array must contain exactly six 'float' (the 32-bit floating
 * point format used by the C language on the system) numbers. For a 3x3
 * calibration matrix in the form
 * @code
 * ( a b c )
 * ( d e f )
 * ( 0 0 1 )
 * @endcode
 * the array must contain the values { a, b, c, d, e, f }. For the
 * definition of the coordinate spaces, see
 * libinput_device_config_calibration_set_matrix().
 */
static inline void
weston_touch_calibration_save(struct weston_touch_calibration *weston_touch_calibration, const char *device, struct wl_array *matrix)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_touch_calibration,
			 WESTON_TOUCH_CALIBRATION_SAVE, NULL, wl_proxy_get_version((struct wl_proxy *) weston_touch_calibration), 0, device, matrix);
}

#ifndef WESTON_TOUCH_CALIBRATOR_ERROR_ENUM
#define WESTON_TOUCH_CALIBRATOR_ERROR_ENUM
/**
 * @ingroup iface_weston_touch_calibrator
 * calibrator object errors
 */
enum weston_touch_calibrator_error {
	/**
	 * surface size does not match
	 */
	WESTON_TOUCH_CALIBRATOR_ERROR_BAD_SIZE = 0,
	/**
	 * requested operation is not possible without mapping the surface
	 */
	WESTON_TOUCH_CALIBRATOR_ERROR_NOT_MAPPED = 1,
	/**
	 * surface-local coordinates are out of bounds
	 */
	WESTON_TOUCH_CALIBRATOR_ERROR_BAD_COORDINATES = 2,
};
#endif /* WESTON_TOUCH_CALIBRATOR_ERROR_ENUM */

/**
 * @ingroup iface_weston_touch_calibrator
 * @struct weston_touch_calibrator_listener
 */
struct weston_touch_calibrator_listener {
	/**
	 * surface size
	 *
	 * This event tells the client what size to make the surface. The
	 * client must obey the size exactly on the next commit with a
	 * wl_buffer.
	 *
	 * This event shall be sent once as a response to creating a
	 * weston_touch_calibrator object.
	 * @param width surface width
	 * @param height surface height
	 */
	void (*configure)(void *data,
			  struct weston_touch_calibrator *weston_touch_calibrator,
			  int32_t width,
			  int32_t height);
	/**
	 * cancel the calibration procedure
	 *
	 * This is sent when the compositor wants to cancel the
	 * calibration and drop the touch device grab. The compositor
	 * unmaps the surface, if it was mapped.
	 *
	 * The weston_touch_calibrator object will not send any more
	 * events. The client should destroy it.
	 */
	void (*cancel_calibration)(void *data,
				   struct weston_touch_calibrator *weston_touch_calibrator);
	/**
	 * a user touch that cannot be used for calibration
	 *
	 * For whatever reason, a touch event resulting from a user
	 * action cannot be used for calibration. The client should show
	 * feedback to the user that the touch was rejected.
	 *
	 * Possible causes for this event include the user touching a wrong
	 * touchscreen when there are multiple ones present. This is
	 * particularly useful when the touchscreens are cloned and there
	 * is no other way to identify which screen the user should be
	 * touching.
	 *
	 * Another cause could be a touch device that sends coordinates
	 * beyond its declared range. If motion takes a touch point outside
	 * the range, the compositor should also send 'cancel' event to
	 * undo the touch-down.
	 */
	void (*invalid_touch)(void *data,
			      struct weston_touch_calibrator *weston_touch_calibrator);
	/**
	 * touch down event and beginning of a touch sequence
	 *
	 * A new touch point has appeared on the surface. This touch
	 * point is assigned a unique ID. Future events from this touch
	 * point reference this ID. The ID ceases to be valid after a touch
	 * up event and may be reused in the future.
	 *
	 * For the coordinate units, see weston_touch_calibrator.
	 * @param time timestamp with millisecond granularity
	 * @param id the unique ID of this touch point
	 * @param x x coordinate in calibration units
	 * @param y y coordinate in calibration units
	 */
	void (*down)(void *data,
		     struct weston_touch_calibrator *weston_touch_calibrator,
		     uint32_t time,
		     int32_t id,
		     uint32_t x,
		     uint32_t y);
	/**
	 * end of a touch event sequence
	 *
	 * The touch point has disappeared. No further events will be
	 * sent for this touch point and the touch point's ID is released
	 * and may be reused in a future touch down event.
	 * @param time timestamp with millisecond granularity
	 * @param id the unique ID of this touch point
	 */
	void (*up)(void *data,
		   struct weston_touch_calibrator *weston_touch_calibrator,
		   uint32_t time,
		   int32_t id);
	/**
	 * update of touch point coordinates
	 *
	 * A touch point has changed coordinates.
	 *
	 * For the coordinate units, see weston_touch_calibrator.
	 * @param time timestamp with millisecond granularity
	 * @param id the unique ID of this touch point
	 * @param x x coordinate in calibration units
	 * @param y y coordinate in calibration units
	 */
	void (*motion)(void *data,
		       struct weston_touch_calibrator *weston_touch_calibrator,
		       uint32_t time,
		       int32_t id,
		       uint32_t x,
		       uint32_t y);
	/**
	 * end of touch frame event
	 *
	 * Indicates the end of a set of events that logically belong
	 * together. A client is expected to accumulate the data in all
	 * events within the frame before proceeding.
	 *
	 * A wl_touch.frame terminates at least one event but otherwise no
	 * guarantee is provided about the set of events within a frame. A
	 * client must assume that any state not updated in a frame is
	 * unchanged from the previously known state.
	 */
	void (*frame)(void *data,
		      struct weston_touch_calibrator *weston_touch_calibrator);
	/**
	 * touch session cancelled
	 *
	 * Sent if the compositor decides the touch stream is a global
	 * gesture. No further events are sent to the clients from that
	 * particular gesture. Touch cancellation applies to all touch
	 * points currently active on this client's surface. The client is
	 * responsible for finalizing the touch points, future touch points
	 * on this surface may reuse the touch point ID.
	 */
	void (*cancel)(void *data,
		       struct weston_touch_calibrator *weston_touch_calibrator);
};

/**
 * @ingroup iface_weston_touch_calibrator
 */
static inline int
weston_touch_calibrator_add_listener(struct weston_touch_calibrator *weston_touch_calibrator,
				     const struct weston_touch_calibrator_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) weston_touch_calibrator,
				     (void (**)(void)) listener, data);
}

#define WESTON_TOUCH_CALIBRATOR_DESTROY 0
#define WESTON_TOUCH_CALIBRATOR_CONVERT 1

/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_CONFIGURE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_CANCEL_CALIBRATION_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_INVALID_TOUCH_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_DOWN_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_UP_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_CANCEL_SINCE_VERSION 1

/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_CONVERT_SINCE_VERSION 1

/** @ingroup iface_weston_touch_calibrator */
static inline void
weston_touch_calibrator_set_user_data(struct weston_touch_calibrator *weston_touch_calibrator, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) weston_touch_calibrator, user_data);
}

/** @ingroup iface_weston_touch_calibrator */
static inline void *
weston_touch_calibrator_get_user_data(struct weston_touch_calibrator *weston_touch_calibrator)
{
	return wl_proxy_get_user_data((struct wl_proxy *) weston_touch_calibrator);
}

static inline uint32_t
weston_touch_calibrator_get_version(struct weston_touch_calibrator *weston_touch_calibrator)
{
	return wl_proxy_get_version((struct wl_proxy *) weston_touch_calibrator);
}

/**
 * @ingroup iface_weston_touch_calibrator
 *
 * This unmaps the surface if it was mapped. The input device grab
 * is dropped, if it was present. The surface loses its role as a
 * calibrator.
 */
static inline void
weston_touch_calibrator_destroy(struct weston_touch_calibrator *weston_touch_calibrator)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_touch_calibrator,
			 WESTON_TOUCH_CALIBRATOR_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) weston_touch_calibrator), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_weston_touch_calibrator
 *
 * This request asks the compositor to convert the surface-local
 * coordinates into the expected touch input coordinates appropriate for
 * the associated touch device. The intention is that a client uses this
 * request to convert marker positions that the user is supposed to touch
 * during calibration.
 *
 * If the compositor has cancelled the calibration, the conversion result
 * shall be zeroes and no errors will be raised.
 *
 * The coordinates given as arguments to this request are relative to
 * the associated wl_surface.
 *
 * If a client asks for conversion before it has committed valid
 * content to the wl_surface, the not_mapped error is raised.
 *
 * If the coordinates x, y are outside of the wl_surface content, the
 * bad_coordinates error is raised.
 */
static inline struct weston_touch_coordinate *
weston_touch_calibrator_convert(struct weston_touch_calibrator *weston_touch_calibrator, int32_t x, int32_t y)
{
	struct wl_proxy *reply;

	reply = wl_proxy_marshal_flags((struct wl_proxy *) weston_touch_calibrator,
			 WESTON_TOUCH_CALIBRATOR_CONVERT, &weston_touch_coordinate_interface, wl_proxy_get_version((struct wl_proxy *) weston_touch_calibrator), 0, x, y, NULL);

	return (struct weston_touch_coordinate *) reply;
}

/**
 * @ingroup iface_weston_touch_coordinate
 * @struct weston_touch_coordinate_listener
 */
struct weston_touch_coordinate_listener {
	/**
	 * coordinates in raw touch space
	 *
	 * This event returns the conversion result from surface
	 * coordinates to the expected touch device coordinates.
	 *
	 * For details, see weston_touch_calibrator.convert. For the
	 * coordinate units, see weston_touch_calibrator.
	 *
	 * This event destroys the weston_touch_coordinate object.
	 * @param x x coordinate in calibration units
	 * @param y y coordinate in calibration units
	 */
	void (*result)(void *data,
		       struct weston_touch_coordinate *weston_touch_coordinate,
		       uint32_t x,
		       uint32_t y);
};

/**
 * @ingroup iface_weston_touch_coordinate
 */
static inline int
weston_touch_coordinate_add_listener(struct weston_touch_coordinate *weston_touch_coordinate,
				     const struct weston_touch_coordinate_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) weston_touch_coordinate,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_weston_touch_coordinate
 */
#define WESTON_TOUCH_COORDINATE_RESULT_SINCE_VERSION 1


/** @ingroup iface_weston_touch_coordinate */
static inline void
weston_touch_coordinate_set_user_data(struct weston_touch_coordinate *weston_touch_coordinate, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) weston_touch_coordinate, user_data);
}

/** @ingroup iface_weston_touch_coordinate */
static inline void *
weston_touch_coordinate_get_user_data(struct weston_touch_coordinate *weston_touch_coordinate)
{
	return wl_proxy_get_user_data((struct wl_proxy *) weston_touch_coordinate);
}

static inline uint32_t
weston_touch_coordinate_get_version(struct weston_touch_coordinate *weston_touch_coordinate)
{
	return wl_proxy_get_version((struct wl_proxy *) weston_touch_coordinate);
}

/** @ingroup iface_weston_touch_coordinate */
static inline void
weston_touch_coordinate_destroy(struct weston_touch_coordinate *weston_touch_coordinate)
{
	wl_proxy_destroy((struct wl_proxy *) weston_touch_coordinate);
}

#ifdef  __cplusplus
}
#endif

#endif
