#include <tests/llvm.h>
const char test_llvm__bpf_base_prog[] =
"// SPDX-License-Identifier: GPL-2.0\n"
"/*\n"
" * bpf-script-example.c\n"
" * Test basic LLVM building\n"
" */\n"
"#ifndef LINUX_VERSION_CODE\n"
"# error Need LINUX_VERSION_CODE\n"
"# error Example: for 4.2 kernel, put 'clang-opt=\"-DLINUX_VERSION_CODE=0x40200\" into llvm section of ~/.perfconfig'\n"
"#endif\n"
"#define BPF_ANY 0\n"
"#define BPF_MAP_TYPE_ARRAY 2\n"
"#define BPF_FUNC_map_lookup_elem 1\n"
"#define BPF_FUNC_map_update_elem 2\n"
"\n"
"static void *(*bpf_map_lookup_elem)(void *map, void *key) =\n"
"	(void *) BPF_FUNC_map_lookup_elem;\n"
"static void *(*bpf_map_update_elem)(void *map, void *key, void *value, int flags) =\n"
"	(void *) BPF_FUNC_map_update_elem;\n"
"\n"
"struct bpf_map_def {\n"
"	unsigned int type;\n"
"	unsigned int key_size;\n"
"	unsigned int value_size;\n"
"	unsigned int max_entries;\n"
"};\n"
"\n"
"#define SEC(NAME) __attribute__((section(NAME), used))\n"
"struct bpf_map_def SEC(\"maps\") flip_table = {\n"
"	.type = BPF_MAP_TYPE_ARRAY,\n"
"	.key_size = sizeof(int),\n"
"	.value_size = sizeof(int),\n"
"	.max_entries = 1,\n"
"};\n"
"\n"
"SEC(\"func=do_epoll_wait\")\n"
"int bpf_func__SyS_epoll_pwait(void *ctx)\n"
"{\n"
"	int ind =0;\n"
"	int *flag = bpf_map_lookup_elem(&flip_table, &ind);\n"
"	int new_flag;\n"
"	if (!flag)\n"
"		return 0;\n"
"	/* flip flag and store back */\n"
"	new_flag = !*flag;\n"
"	bpf_map_update_elem(&flip_table, &ind, &new_flag, BPF_ANY);\n"
"	return new_flag;\n"
"}\n"
"char _license[] SEC(\"license\") = \"GPL\";\n"
"int _version SEC(\"version\") = LINUX_VERSION_CODE;\n"
;
