#include <tests/llvm.h>
const char test_llvm__bpf_test_prologue_prog[] =
"// SPDX-License-Identifier: GPL-2.0\n"
"/*\n"
" * bpf-script-test-prologue.c\n"
" * Test BPF prologue\n"
" */\n"
"#ifndef LINUX_VERSION_CODE\n"
"# error Need LINUX_VERSION_CODE\n"
"# error Example: for 4.2 kernel, put 'clang-opt=\"-DLINUX_VERSION_CODE=0x40200\" into llvm section of ~/.perfconfig'\n"
"#endif\n"
"#define SEC(NAME) __attribute__((section(NAME), used))\n"
"\n"
"#include <uapi/linux/fs.h>\n"
"\n"
"/*\n"
" * If CONFIG_PROFILE_ALL_BRANCHES is selected,\n"
" * 'if' is redefined after include kernel header.\n"
" * Recover 'if' for BPF object code.\n"
" */\n"
"#ifdef if\n"
"# undef if\n"
"#endif\n"
"\n"
"#define FMODE_READ		0x1\n"
"#define FMODE_WRITE		0x2\n"
"\n"
"static void (*bpf_trace_printk)(const char *fmt, int fmt_size, ...) =\n"
"	(void *) 6;\n"
"\n"
"SEC(\"func=null_lseek file->f_mode offset orig\")\n"
"int bpf_func__null_lseek(void *ctx, int err, unsigned long _f_mode,\n"
"			 unsigned long offset, unsigned long orig)\n"
"{\n"
"	fmode_t f_mode = (fmode_t)_f_mode;\n"
"\n"
"	if (err)\n"
"		return 0;\n"
"	if (f_mode & FMODE_WRITE)\n"
"		return 0;\n"
"	if (offset & 1)\n"
"		return 0;\n"
"	if (orig == SEEK_CUR)\n"
"		return 0;\n"
"	return 1;\n"
"}\n"
"\n"
"char _license[] SEC(\"license\") = \"GPL\";\n"
"int _version SEC(\"version\") = LINUX_VERSION_CODE;\n"
;
