/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-geo.h"
#include "libical-glib-private.h"

G_DEFINE_TYPE (ICalGeo, i_cal_geo, I_CAL_TYPE_OBJECT)

static void i_cal_geo_class_init (G_GNUC_UNUSED ICalGeoClass *klass)
{
}

static void i_cal_geo_init (G_GNUC_UNUSED ICalGeo *self)
{
}

/**
 * i_cal_geo_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalGeo *
i_cal_geo_new_full (struct icalgeotype native)
{
    ICalGeo *object;
    struct icalgeotype *clone;
    
    
    clone = g_new (struct icalgeotype, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_GEO,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_geo_new_default: (skip)
 *
 * Creates a new default #ICalGeo.
 *
 * Returns: (transfer full): The newly created #ICalGeo
 *
 * Since: 1.0
 *
 **/
struct icalgeotype
i_cal_geo_new_default (void)
{
	struct icalgeotype geotype;
	geotype.lat = 0;
	geotype.lon = 0;
	return geotype;
}

/**
 * i_cal_geo_new:
 * @lat: Latitude
 * @lon: Longitude
 *
 * Creates a new #ICalGeo.
 *
 * Returns: (transfer full): The newly created #ICalGeo.
 *
 * Since: 1.0
 *
 **/
ICalGeo *
i_cal_geo_new (gdouble lat, 
               gdouble lon)
{
    struct icalgeotype geo;

    geo = i_cal_geo_new_default();
    geo.lat = lat;
    geo.lon = lon;

    return i_cal_geo_new_full(geo);
}

/**
 * i_cal_geo_clone:
 * @geo: The #ICalGeo to clone
 *
 * Creates a new #ICalGeo, copy of @geo.
 *
 * Returns: (transfer full): The newly created #ICalGeo, copy of @geo.
 *
 * Since: 1.0
 *
 **/
ICalGeo *
i_cal_geo_clone (const ICalGeo *geo)
{
    struct icalgeotype *src;

    g_return_val_if_fail(I_CAL_IS_GEO(geo), NULL);

    src = (struct icalgeotype *)i_cal_object_get_native((ICalObject *)geo);
    g_return_val_if_fail(src != NULL, NULL);

    return i_cal_geo_new_full(*src);
}

/**
 * i_cal_geo_get_lat:
 * @geo: The #ICalGeo to be queried
 *
 * Gets the latitude of #ICalGeo.
 *
 * Returns: The latitude.
 *
 * Since: 1.0
 *
 **/
gdouble
i_cal_geo_get_lat (ICalGeo *geo)
{
	g_return_val_if_fail (geo != NULL, 0);
	return ((struct icalgeotype *)i_cal_object_get_native ((ICalObject *)geo))->lat;
}

/**
 * i_cal_geo_set_lat:
 * @geo: The #ICalGeo to be set
 * @lat: The latitude
 *
 * Sets the latitude of #ICalGeo.
 *
 * Since: 1.0
 *
 **/
void
i_cal_geo_set_lat (ICalGeo *geo, 
                   gdouble lat)
{
	g_return_if_fail (geo != NULL && I_CAL_IS_GEO (geo));
	((struct icalgeotype *)i_cal_object_get_native ((ICalObject *)geo))->lat = lat;
}

/**
 * i_cal_geo_get_lon:
 * @geo: The #ICalGeo to be queried
 *
 * Gets the longitude of #ICalGeo.
 *
 * Returns: The longitude.
 *
 * Since: 1.0
 *
 **/
gdouble
i_cal_geo_get_lon (ICalGeo *geo)
{
	g_return_val_if_fail (geo != NULL, 0);
	return ((struct icalgeotype *)i_cal_object_get_native ((ICalObject *)geo))->lon;
}

/**
 * i_cal_geo_set_lon:
 * @geo: The #ICalGeo to be set
 * @lon: The longitude
 *
 * Sets the longitude of #ICalGeo.
 *
 * Since: 1.0
 *
 **/
void
i_cal_geo_set_lon (ICalGeo *geo, 
                   gdouble lon)
{
	g_return_if_fail (geo != NULL && I_CAL_IS_GEO (geo));
	((struct icalgeotype *)i_cal_object_get_native ((ICalObject *)geo))->lon = lon;
}
