/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_FRAMEBUFFER_H
#define VN_PROTOCOL_DRIVER_FRAMEBUFFER_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/* struct VkFramebufferAttachmentImageInfo chain */

static inline size_t
vn_sizeof_VkFramebufferAttachmentImageInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFramebufferAttachmentImageInfo_self(const VkFramebufferAttachmentImageInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_uint32_t(&val->width);
    size += vn_sizeof_uint32_t(&val->height);
    size += vn_sizeof_uint32_t(&val->layerCount);
    size += vn_sizeof_uint32_t(&val->viewFormatCount);
    if (val->pViewFormats) {
        size += vn_sizeof_array_size(val->viewFormatCount);
        size += vn_sizeof_VkFormat_array(val->pViewFormats, val->viewFormatCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkFramebufferAttachmentImageInfo(const VkFramebufferAttachmentImageInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFramebufferAttachmentImageInfo_pnext(val->pNext);
    size += vn_sizeof_VkFramebufferAttachmentImageInfo_self(val);

    return size;
}

static inline void
vn_encode_VkFramebufferAttachmentImageInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFramebufferAttachmentImageInfo_self(struct vn_cs_encoder *enc, const VkFramebufferAttachmentImageInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_uint32_t(enc, &val->width);
    vn_encode_uint32_t(enc, &val->height);
    vn_encode_uint32_t(enc, &val->layerCount);
    vn_encode_uint32_t(enc, &val->viewFormatCount);
    if (val->pViewFormats) {
        vn_encode_array_size(enc, val->viewFormatCount);
        vn_encode_VkFormat_array(enc, val->pViewFormats, val->viewFormatCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkFramebufferAttachmentImageInfo(struct vn_cs_encoder *enc, const VkFramebufferAttachmentImageInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO });
    vn_encode_VkFramebufferAttachmentImageInfo_pnext(enc, val->pNext);
    vn_encode_VkFramebufferAttachmentImageInfo_self(enc, val);
}

/* struct VkFramebufferAttachmentsCreateInfo chain */

static inline size_t
vn_sizeof_VkFramebufferAttachmentsCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFramebufferAttachmentsCreateInfo_self(const VkFramebufferAttachmentsCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->attachmentImageInfoCount);
    if (val->pAttachmentImageInfos) {
        size += vn_sizeof_array_size(val->attachmentImageInfoCount);
        for (uint32_t i = 0; i < val->attachmentImageInfoCount; i++)
            size += vn_sizeof_VkFramebufferAttachmentImageInfo(&val->pAttachmentImageInfos[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkFramebufferAttachmentsCreateInfo(const VkFramebufferAttachmentsCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFramebufferAttachmentsCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkFramebufferAttachmentsCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkFramebufferAttachmentsCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFramebufferAttachmentsCreateInfo_self(struct vn_cs_encoder *enc, const VkFramebufferAttachmentsCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->attachmentImageInfoCount);
    if (val->pAttachmentImageInfos) {
        vn_encode_array_size(enc, val->attachmentImageInfoCount);
        for (uint32_t i = 0; i < val->attachmentImageInfoCount; i++)
            vn_encode_VkFramebufferAttachmentImageInfo(enc, &val->pAttachmentImageInfos[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkFramebufferAttachmentsCreateInfo(struct vn_cs_encoder *enc, const VkFramebufferAttachmentsCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO });
    vn_encode_VkFramebufferAttachmentsCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkFramebufferAttachmentsCreateInfo_self(enc, val);
}

/* struct VkFramebufferCreateInfo chain */

static inline size_t
vn_sizeof_VkFramebufferCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFramebufferCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkFramebufferAttachmentsCreateInfo_self((const VkFramebufferAttachmentsCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFramebufferCreateInfo_self(const VkFramebufferCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkRenderPass(&val->renderPass);
    size += vn_sizeof_uint32_t(&val->attachmentCount);
    if (val->pAttachments) {
        size += vn_sizeof_array_size(val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            size += vn_sizeof_VkImageView(&val->pAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->width);
    size += vn_sizeof_uint32_t(&val->height);
    size += vn_sizeof_uint32_t(&val->layers);
    return size;
}

static inline size_t
vn_sizeof_VkFramebufferCreateInfo(const VkFramebufferCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFramebufferCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkFramebufferCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkFramebufferCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFramebufferCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkFramebufferAttachmentsCreateInfo_self(enc, (const VkFramebufferAttachmentsCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFramebufferCreateInfo_self(struct vn_cs_encoder *enc, const VkFramebufferCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkRenderPass(enc, &val->renderPass);
    vn_encode_uint32_t(enc, &val->attachmentCount);
    if (val->pAttachments) {
        vn_encode_array_size(enc, val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_encode_VkImageView(enc, &val->pAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->width);
    vn_encode_uint32_t(enc, &val->height);
    vn_encode_uint32_t(enc, &val->layers);
}

static inline void
vn_encode_VkFramebufferCreateInfo(struct vn_cs_encoder *enc, const VkFramebufferCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO });
    vn_encode_VkFramebufferCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkFramebufferCreateInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkCreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateFramebuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkFramebufferCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pFramebuffer);
    if (pFramebuffer)
        cmd_size += vn_sizeof_VkFramebuffer(pFramebuffer);

    return cmd_size;
}

static inline void vn_encode_vkCreateFramebuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateFramebuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkFramebufferCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pFramebuffer))
        vn_encode_VkFramebuffer(enc, pFramebuffer);
}

static inline size_t vn_sizeof_vkCreateFramebuffer_reply(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateFramebuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pFramebuffer);
    if (pFramebuffer)
        cmd_size += vn_sizeof_VkFramebuffer(pFramebuffer);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateFramebuffer_reply(struct vn_cs_decoder *dec, VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateFramebuffer_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkFramebuffer(dec, pFramebuffer);
    } else {
        pFramebuffer = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyFramebuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkFramebuffer(&framebuffer);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyFramebuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyFramebuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkFramebuffer(enc, &framebuffer);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyFramebuffer_reply(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyFramebuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip framebuffer */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyFramebuffer_reply(struct vn_cs_decoder *dec, VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyFramebuffer_EXT);

    /* skip device */
    /* skip framebuffer */
    /* skip pAllocator */
}

static inline void vn_submit_vkCreateFramebuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateFramebuffer_reply(device, pCreateInfo, pAllocator, pFramebuffer) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateFramebuffer(enc, cmd_flags, device, pCreateInfo, pAllocator, pFramebuffer);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroyFramebuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyFramebuffer(device, framebuffer, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyFramebuffer_reply(device, framebuffer, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyFramebuffer(enc, cmd_flags, device, framebuffer, pAllocator);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkCreateFramebuffer(struct vn_ring *vn_ring, VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCreateFramebuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pFramebuffer, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateFramebuffer_reply(dec, device, pCreateInfo, pAllocator, pFramebuffer);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateFramebuffer(struct vn_ring *vn_ring, VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCreateFramebuffer(vn_ring, 0, device, pCreateInfo, pAllocator, pFramebuffer, &submit);
}

static inline void vn_call_vkDestroyFramebuffer(struct vn_ring *vn_ring, VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkDestroyFramebuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, framebuffer, pAllocator, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkDestroyFramebuffer_reply(dec, device, framebuffer, pAllocator);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkDestroyFramebuffer(struct vn_ring *vn_ring, VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkDestroyFramebuffer(vn_ring, 0, device, framebuffer, pAllocator, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_FRAMEBUFFER_H */
